/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef CDO_CMOR_H
#define CDO_CMOR_H

#include <vector>
#include <cdi.h>

struct CmorVar
{
  bool convert = false;
  bool remove = false;
  // missing value
  bool changemissval = false;
  double missval_old = 0;
  //
  bool lfactor = false;
  double factor = 0;
  //
  bool checkvalid = false;
  double valid_min = 0;
  double valid_max = 0;
  //
  bool check_min_mean_abs = false;
  double ok_min_mean_abs = 0;
  //
  bool check_max_mean_abs = false;
  double ok_max_mean_abs = 0;
  // units
  bool changeunits = false;
  char units_old[CDI_MAX_NAME] = { 0 };
  char units[CDI_MAX_NAME] = { 0 };
  // varname
  char name[CDI_MAX_NAME] = { 0 };
  // converter
  void *ut_converter = nullptr;

  double amean = 0;
  long nvals = 0, n_lower_min = 0, n_greater_max = 0;
};

void cmor_check_init(int nvars, std::vector<CmorVar> &vars);
void cmor_check_eval(int vlistID, int nvars, const std::vector<CmorVar> &vars);
void cmor_check_prep(CmorVar &var, const long gridsize, const double missval, const double *const array);

void cdo_define_var_units(CmorVar &var, int vlistID2, int varID, const char *const units);

#endif
