/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef UTIL_STRING_H
#define UTIL_STRING_H

#include <string>

#define ADD_PLURAL(n) ((n) != 1 ? "s" : "")

std::string stringToUpper(std::string p_str);
std::string stringToLower(std::string p_str);

void cstrToLowerCase(char *str);
void cstrToUpperCase(char *str);
char *doubleToAttstr(int digits, char *str, size_t len, double value);

const char *tunitToCstr(int tunits);
const char *calendarToCstr(int calendar);

#endif
