/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2021 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef CDO_VARLIST_H
#define CDO_VARLIST_H

#include <vector>

#include <cdi.h>

#include "cdo_varlist.h"
#include "cdo_options.h"

struct CdoVar
{
  char name[CDI_MAX_NAME] = { 0 };
  MemType memType = MemType::Native;
  int gridID = -1;
  int zaxisID = -1;
  int timetype = -1;
  int tsteptype = -1;
  size_t gridsize = 0;
  int nlevels = 0;
  int datatype = -1;
  double missval = 0;
  int code = 0;
  int param = 0;
  int nwpv = 1;  // number of words per value; real:1  complex:2
};

using VarList = std::vector<CdoVar>;
void varListInit(VarList &vl, int vlistID);
void varListSetUniqueMemtype(VarList &vl);
void varListSetMemtype(VarList &vl, MemType memType);

#endif
