// Automatically created with makedoc, don't edit!

#include "operator_help.h"

// clang-format off

const CdoHelp InfoHelp = {
    "NAME",
    "    info, infon, map - Information and simple statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure and contents for each field of all input files",
    "    to standard output. A field is a horizontal layer of a data variable. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    info   Dataset information listed by parameter identifier",
    "           Prints information and simple statistics for each field of all input datasets.",
    "           For each field the operator prints one line with the following elements:",
    "           - Date and Time",
    "           - Level, Gridsize and number of Missing values",
    "           - Minimum, Mean and Maximum \\",
    "           The mean value is computed without the use of area weights!",
    "           - Parameter identifier",
    "    infon  Dataset information listed by parameter name",
    "           The same as operator info but using the name instead of the",
    "           identifier to label the parameter.",
    "    map    Dataset information and simple map",
    "           Prints information, simple statistics and a map for each field of all input",
    "           datasets. The map will be printed only for fields on a regular lon/lat grid.",
};

const CdoHelp SinfoHelp = {
    "NAME",
    "    sinfo, sinfon - Short information",
    "",
    "SYNOPSIS",
    "    <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure of infiles to standard output.",
    "    infiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    sinfo   Short information listed by parameter identifier",
    "            Prints short information of a dataset. The information is divided into 4 sections.",
    "            Section 1 prints one line per parameter with the following information:",
    "            - institute and source",
    "            - time c=constant v=varying",
    "            - type of statistical processing",
    "            - number of levels and z-axis number",
    "            - horizontal grid size and number",
    "            - data type",
    "            - parameter identifier",
    "            Section 2 and 3 gives a short overview of all grid and vertical coordinates.",
    "            And the last section contains short information of the time coordinate.",
    "    sinfon  Short information listed by parameter name",
    "            The same as operator sinfo but using the name instead of the identifier to label the parameter.",
};

const CdoHelp XSinfoHelp = {
    "NAME",
    "    xsinfo, xsinfop - Extra short information",
    "",
    "SYNOPSIS",
    "    <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure of infiles to standard output.",
    "    infiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    xsinfo   Extra short information listed by parameter name",
    "             Prints short information of a dataset. The information is divided into 4 sections.",
    "             Section 1 prints one line per parameter with the following information:",
    "             - institute and source",
    "             - time c=constant v=varying",
    "             - type of statistical processing",
    "             - number of levels and z-axis number",
    "             - horizontal grid size and number",
    "             - data type",
    "             - memory type (float or double)",
    "             - parameter name",
    "             Section 2 to 4 gives a short overview of all grid, vertical and time coordinates.",
    "    xsinfop  Extra short information listed by parameter identifier",
    "             The same as operator xsinfo but using the identifier instead of the name to label the parameter.",
};

const CdoHelp DiffHelp = {
    "NAME",
    "    diff, diffn - Compare two datasets field by field",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile1 infile2",
    "",
    "DESCRIPTION",
    "    Compares the contents of two datasets field by field. The input datasets need",
    "    to have the same structure and its fields need to have the dimensions.",
    "    Try the option names if the number of variables differ.",
    "    Exit status is 0 if inputs are the same and 1 if they differ.",
    "",
    "OPERATORS",
    "    diff   Compare two datasets listed by parameter id",
    "           Provides statistics on differences between two datasets.",
    "           For each pair of fields the operator prints one line with the following information:",
    "           - Date and Time",
    "           - Level, Gridsize and number of Missing values",
    "           - Number of different values",
    "           - Occurrence of coefficient pairs with different signs (S)",
    "           - Occurrence of zero values (Z)",
    "           - Maxima of absolute difference of coefficient pairs",
    "           - Maxima of relative difference of non-zero coefficient pairs with equal signs",
    "           - Parameter identifier",
    "    diffn  Compare two datasets listed by parameter name",
    "           The same as operator diff. Using the name instead of the",
    "           identifier to label the parameter.",
    "",
    "PARAMETER",
    "    maxcount  INTEGER Stop after maxcount different fields",
    "    abslim    FLOAT   Limit of the maximum absolute difference (default: 0)",
    "    rellim    FLOAT   Limit of the maximum relative difference (default: 1)",
    "    names     STRING  Consideration of the variable names of only one input file (left/right) or the intersection of both (intersect).",
};

const CdoHelp NinfoHelp = {
    "NAME",
    "    npar, nlevel, nyear, nmon, ndate, ntime, ngridpoints, ngrids - ",
    "    Print the number of parameters, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints the number of variables, levels or times of the ",
    "    input dataset.",
    "",
    "OPERATORS",
    "    npar         Number of parameters",
    "                 Prints the number of parameters (variables).",
    "    nlevel       Number of levels",
    "                 Prints the number of levels for each variable.",
    "    nyear        Number of years",
    "                 Prints the number of different years.",
    "    nmon         Number of months",
    "                 Prints the number of different combinations of years and months.",
    "    ndate        Number of dates",
    "                 Prints the number of different dates.",
    "    ntime        Number of timesteps",
    "                 Prints the number of timesteps.",
    "    ngridpoints  Number of gridpoints",
    "                 Prints the number of gridpoints for each variable.",
    "    ngrids       Number of horizontal grids",
    "                 Prints the number of horizontal grids.",
};

const CdoHelp ShowinfoHelp = {
    "NAME",
    "    showformat, showcode, showname, showstdname, showlevel, showltype, showyear, ",
    "    showmon, showdate, showtime, showtimestamp - Show variables, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints the format, variables, levels or times of the input dataset.",
    "",
    "OPERATORS",
    "    showformat     Show file format",
    "                   Prints the file format of the input dataset.",
    "    showcode       Show code numbers",
    "                   Prints the code number of all variables.",
    "    showname       Show variable names",
    "                   Prints the name of all variables.",
    "    showstdname    Show standard names",
    "                   Prints the standard name of all variables.",
    "    showlevel      Show levels",
    "                   Prints all levels for each variable.",
    "    showltype      Show GRIB level types",
    "                   Prints the GRIB level type for all z-axes.",
    "    showyear       Show years",
    "                   Prints all years.",
    "    showmon        Show months",
    "                   Prints all months.",
    "    showdate       Show date information",
    "                   Prints date information of all timesteps (format YYYY-MM-DD).",
    "    showtime       Show time information",
    "                   Prints time information of all timesteps (format hh:mm:ss).",
    "    showtimestamp  Show timestamp",
    "                   Prints timestamp of all timesteps (format YYYY-MM-DDThh:mm:ss).",
};

const CdoHelp ShowattributeHelp = {
    "NAME",
    "    showattribute - Show attributes",
    "",
    "SYNOPSIS",
    "    showattribute[,attributes]  infile",
    "",
    "DESCRIPTION",
    "    This operator prints the attributes of the data variables of a dataset.",
    "    ",
    "    Each attribute has the following structure:",
    "    ",
    "      [var_nm@][att_nm]",
    "    ",
    "       var_nm  Variable name (optional). Example: pressure",
    "       att_nm  Attribute name (optional). Example: units",
    "    ",
    "    The value of var_nm is the name of the variable containing the attribute (named att_nm) that",
    "    you want to print. Use wildcards to print the attribute att_nm of more than one variable.",
    "    A value of var_nm of '*' will print the attribute att_nm of all data variables.",
    "    If var_nm is missing then att_nm refers to a global attribute.",
    "    ",
    "    The value of att_nm is the name of the attribute you want to print. Use wildcards to print more than",
    "    one attribute. A value of att_nm of '*' will print all attributes.",
    "",
    "PARAMETER",
    "    attributes  STRING  Comma-separated list of attributes. ",
};

const CdoHelp FiledesHelp = {
    "NAME",
    "    partab, codetab, griddes, zaxisdes, vct - Dataset description",
    "",
    "SYNOPSIS",
    "    <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module provides operators to print meta information about a dataset.",
    "    The printed meta-data depends on the chosen operator.",
    "",
    "OPERATORS",
    "    partab    Parameter table",
    "              Prints all available meta information of the variables.",
    "    codetab   Parameter code table",
    "              Prints a code table with a description of all variables.",
    "              For each variable the operator prints one line listing the",
    "              code, name, description and units.",
    "    griddes   Grid description",
    "              Prints the description of all grids.",
    "    zaxisdes  Z-axis description",
    "              Prints the description of all z-axes.",
    "    vct       Vertical coordinate table",
    "              Prints the vertical coordinate table.",
};

const CdoHelp ApplyHelp = {
    "NAME",
    "    apply - Apply operators",
    "",
    "SYNOPSIS",
    "    apply,operators  infiles",
    "",
    "DESCRIPTION",
    "    The apply utility runs the named operators on each input file. The input files must be enclosed in square brackets.",
    "    This utility can only be used on a series of input files. These are all operators with more than one input file (infiles).",
    "    Here is an incomplete list of these operators: copy, cat, merge, mergetime, select, ENSSTAT.",
    "    The parameter operators is a blank-separated list of CDO operators. Use quotation marks if more than one operator is needed.",
    "    Each operator may have only one input and output stream.",
    "",
    "PARAMETER",
    "    operators  STRING    Blank-separated list of CDO operators.",
};

const CdoHelp CopyHelp = {
    "NAME",
    "    copy, clone, cat - Copy datasets",
    "",
    "SYNOPSIS",
    "    <operator>  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to copy, clone or concatenate datasets.",
    "    infiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "",
    "OPERATORS",
    "    copy   Copy datasets",
    "           Copies all input datasets to outfile. ",
    "    clone  Clone datasets",
    "           Copies all input datasets to outfile. In contrast to the copy operator, clone tries",
    "           not to change the input data. GRIB records are neither decoded nor decompressed.",
    "    cat    Concatenate datasets",
    "           Concatenates all input datasets and appends the result to the end ",
    "           of outfile. If outfile does not exist it will be created.",
};

const CdoHelp TeeHelp = {
    "NAME",
    "    tee - Duplicate a data stream and write it to file",
    "",
    "SYNOPSIS",
    "    tee,outfile2  infile outfile1",
    "",
    "DESCRIPTION",
    "    This operator copies the input dataset to outfile1 and outfile2. The first output stream",
    "    in outfile1 can be further processesd with other cdo operators. The second output outfile2",
    "    is written to disk. It can be used to store intermediate results to a file.",
    "",
    "PARAMETER",
    "    outfile2  STRING Destination filename for the copy of the input file",
};

const CdoHelp PackHelp = {
    "NAME",
    "    pack - Pack data",
    "",
    "SYNOPSIS",
    "    pack[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Packing reduces the data volume by reducing the precision of the stored numbers.",
    "    It is implemented using the NetCDF attributes add_offset and scale_factor.",
    "    The operator pack calculates the attributes add_offset and scale_factor for all variables.",
    "    The default data type for all variables is automatically changed to 16-bit integer.",
    "    Use the CDO option -b to change the data type to a different integer precision, if needed.",
    "    Missing values are automatically transformed to the current data type.",
    "    ",
    "    Alternatively, the pack parameters add_offset and scale_factor can be read from a file for each variable.",
    "",
    "PARAMETER",
    "    printparam  BOOL    Print pack parameters to stdout for each variable",
    "    filename    STRING  Read pack parameters from file for each variable[format: name=<> add_offset=<> scale_factor=<>]",
};

const CdoHelp UnpackHelp = {
    "NAME",
    "    unpack - Unpack data",
    "",
    "SYNOPSIS",
    "    unpack  infile outfile",
    "",
    "DESCRIPTION",
    "    Packing reduces the data volume by reducing the precision of the stored numbers.",
    "    It is implemented using the NetCDF attributes add_offset and scale_factor.",
    "    The operator unpack unpack all packed variables.",
    "    The default data type for all variables is automatically changed to 32-bit floats.",
    "    Use the CDO option -b F64 to change the data type to 64-bit floats, if needed.",
};

const CdoHelp BitroundingHelp = {
    "NAME",
    "    bitrounding - Bit rounding",
    "",
    "SYNOPSIS",
    "    bitrounding[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates for each field the number of necessary mantissa bits to get a certain",
    "    information level in the data. With this number of significant bits (numbits) a rounding of the data is performed.",
    "    This allows the data to be compressed to a higher level.",
    "    ",
    "    The default value of the information level is 0.9999 and can be adjusted with the parameter inflevel.",
    "    That means 99.99% of the information in the mantissa bits is preserved.",
    "    ",
    "    Alternatively, the number of significant bits can be set for all variables with the numbits parameter.",
    "    Furthermore, numbits can be assigned for each variable via the filename parameter. In this case, numbits is still",
    "    calculated for all variables if they are not present in the file.",
    "    ",
    "    The analysis of the bit information is based on the Julia library BitInformation.jl (https://github.com/milankl/BitInformation.jl).",
    "    The procedure to derive the number of significant mantissa bits was adapted from the Python library xbitinfo (https://github.com/observingClouds/xbitinfo).",
    "    Quantize to the number of mantissa bits is done with IEEE rounding using code from NetCDF 4.9.0.",
    "    ",
    "    Currently only 32-bit float data is rounded. Data with missing values are not yet supported for the calculation of significant bits.",
    "",
    "PARAMETER",
    "    inflevel   FLOAT   Information level (0 - 1) [default: 0.9999]",
    "    addbits    INTEGER Add bits to the number of significant bits [default: 0]",
    "    minbits    INTEGER Minimum value of the number of bits [default: 1]",
    "    maxbits    INTEGER Maximum value of the number of bits [default: 23]",
    "    numsteps   INTEGER Set to 1 to run the calculation only in the first time step",
    "    numbits    INTEGER Set number of significant bits",
    "    printbits  BOOL    Print max. numbits per variable of 1st timestep to stdout [format: name=numbits]",
    "    filename   STRING  Read number of significant bits per variable from file [format: name=numbits]",
};

const CdoHelp ReplaceHelp = {
    "NAME",
    "    replace - Replace variables",
    "",
    "SYNOPSIS",
    "    replace  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator replaces variables in infile1 by variables from infile2 and write",
    "    the result to outfile. Both input datasets need to have the same number of timesteps.",
    "    All variable names may only occur once!",
};

const CdoHelp DuplicateHelp = {
    "NAME",
    "    duplicate - Duplicates a dataset",
    "",
    "SYNOPSIS",
    "    duplicate[,ndup]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator duplicates the contents of infile and writes the result to outfile.",
    "    The optional parameter sets the number of duplicates, the default is 2.",
    "",
    "PARAMETER",
    "    ndup  INTEGER  Number of duplicates, default is 2.",
};

const CdoHelp MergegridHelp = {
    "NAME",
    "    mergegrid - Merge grid",
    "",
    "SYNOPSIS",
    "    mergegrid  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Merges grid points of all variables from infile2 to infile1 and write the result to outfile.",
    "    Only the non missing values of infile2 will be used. The horizontal grid of infile2 should ",
    "    be smaller or equal to the grid of infile1 and the resolution must be the same.",
    "    Only rectilinear grids are supported. Both input files need to have the same variables ",
    "    and the same number of timesteps.",
};

const CdoHelp MergeHelp = {
    "NAME",
    "    merge, mergetime - Merge datasets",
    "",
    "SYNOPSIS",
    "    merge  infiles outfile",
    "    mergetime[,options]  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module reads datasets from several input files, merges them and writes the resulting dataset to outfile.",
    "",
    "OPERATORS",
    "    merge      Merge datasets with different fields",
    "               Merges time series of different fields from several input datasets. The number ",
    "               of fields per timestep written to outfile is the sum of the field numbers ",
    "               per timestep in all input datasets. The time series on all input datasets are ",
    "               required to have different fields and the same number of timesteps.",
    "               The fields in each different input file either have to be different variables",
    "               or different levels of the same variable. A mixture of different variables on",
    "               different levels in different input files is not allowed.",
    "    mergetime  Merge datasets sorted by date and time",
    "               Merges all timesteps of all input files sorted by date and time.",
    "               All input files need to have the same structure with the same variables on ",
    "               different timesteps. After this operation every input timestep is in outfile ",
    "               and all timesteps are sorted by date and time.",
    "",
    "PARAMETER",
    "    skip_same_time  BOOL    Skips all consecutive timesteps with a double entry of the same timestamp.",
    "    names           STRING  Fill missing variable names with missing values (union) or use the intersection (intersect).",
    "",
    "NOTE",
    "    Operators of this module need to open all input files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp SplitHelp = {
    "NAME",
    "    splitcode, splitparam, splitname, splitlevel, splitgrid, splitzaxis, ",
    "    splittabnum - Split a dataset",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile obase",
    "",
    "DESCRIPTION",
    "    This module splits infile into pieces. The output files will be named <obase><xxx><suffix>",
    "    where suffix is the filename extension derived from the file format. xxx and the contents ",
    "    of the output files depends on the chosen operator. ",
    "    params is a comma-separated list of processing parameters.",
    "",
    "OPERATORS",
    "    splitcode    Split code numbers",
    "                 Splits a dataset into pieces, one for each different code number.",
    "                 xxx will have three digits with the code number.",
    "    splitparam   Split parameter identifiers",
    "                 Splits a dataset into pieces, one for each different parameter identifier.",
    "                 xxx will be a string with the parameter identifier.",
    "    splitname    Split variable names",
    "                 Splits a dataset into pieces, one for each variable name.",
    "                 xxx will be a string with the variable name.",
    "    splitlevel   Split levels",
    "                 Splits a dataset into pieces, one for each different level.",
    "                 xxx will have six digits with the level.",
    "    splitgrid    Split grids",
    "                 Splits a dataset into pieces, one for each different grid.",
    "                 xxx will have two digits with the grid number.",
    "    splitzaxis   Split z-axes",
    "                 Splits a dataset into pieces, one for each different z-axis.",
    "                 xxx will have two digits with the z-axis number.",
    "    splittabnum  Split parameter table numbers",
    "                 Splits a dataset into pieces, one for each GRIB1 parameter table number.",
    "                 xxx will have three digits with the GRIB1 parameter table number.",
    "",
    "PARAMETER",
    "    swap            STRING  Swap the position of obase and xxx in the output filename",
    "    uuid=<attname>  STRING  Add a UUID as global attribute <attname> to each output file",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    "",
    "NOTE",
    "    Operators of this module need to open all output files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp SplittimeHelp = {
    "NAME",
    "    splithour, splitday, splitseas, splityear, splityearmon, splitmon - ",
    "    Split timesteps of a dataset",
    "",
    "SYNOPSIS",
    "    <operator>  infile obase",
    "    splitmon[,format]  infile obase",
    "",
    "DESCRIPTION",
    "    This module splits infile into  timesteps pieces. The output files will be named",
    "    <obase><xxx><suffix> where suffix is the filename extension derived from the file format. ",
    "    xxx and the contents of the output files depends on the chosen operator. ",
    "",
    "OPERATORS",
    "    splithour     Split hours",
    "                  Splits a file into pieces, one for each different hour.",
    "                  xxx will have two digits with the hour.",
    "    splitday      Split days",
    "                  Splits a file into pieces, one for each different day.",
    "                  xxx will have two digits with the day.",
    "    splitseas     Split seasons",
    "                  Splits a file into pieces, one for each different season.",
    "                  xxx will have three characters with the season.",
    "    splityear     Split years",
    "                  Splits a file into pieces, one for each different year.",
    "                  xxx will have four digits with the year (YYYY).",
    "    splityearmon  Split in years and months",
    "                  Splits a file into pieces, one for each different year and month.",
    "                  xxx will have six digits with the year and month (YYYYMM).",
    "    splitmon      Split months",
    "                  Splits a file into pieces, one for each different month.",
    "                  xxx will have two digits with the month.",
    "",
    "PARAMETER",
    "    format  STRING  C-style format for strftime() (e.g. %B for the full month name)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    "",
    "NOTE",
    "    Operators of this module need to open all output files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp SplitselHelp = {
    "NAME",
    "    splitsel - Split selected timesteps",
    "",
    "SYNOPSIS",
    "    splitsel,nsets[,noffset[,nskip]]  infile obase",
    "",
    "DESCRIPTION",
    "    This operator splits infile into pieces, one for each adjacent",
    "    sequence t_1, ...., t_n of timesteps of the same selected time range.",
    "    The output files will be named <obase><nnnnnn><suffix> where nnnnnn is the ",
    "    sequence number and suffix is the filename extension derived from the file format.",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input timesteps for each output file",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
};

const CdoHelp SplitdateHelp = {
    "NAME",
    "    splitdate - Splits a file into dates",
    "",
    "SYNOPSIS",
    "    splitdate  infile obase",
    "",
    "DESCRIPTION",
    "    This operator splits infile into pieces, one for each different date.",
    "    The output files will be named <obase><YYYY-MM-DD><suffix> where YYYY-MM-DD is the ",
    "    date and suffix is the filename extension derived from the file format.",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
};

const CdoHelp DistgridHelp = {
    "NAME",
    "    distgrid - Distribute horizontal grid",
    "",
    "SYNOPSIS",
    "    distgrid,nx[,ny]  infile obase",
    "",
    "DESCRIPTION",
    "    This operator distributes a dataset into smaller pieces. Each output file contains a different region of the",
    "    horizontal source grid. 2D Lon/Lat grids can be split into nx*ny pieces, where a target grid region contains",
    "    a structured longitude/latitude box of the source grid. Data on an unstructured grid is split into nx pieces.",
    "    The output files will be named <obase><xxx><suffix> where suffix is the filename extension derived from the",
    "    file format. xxx will have five digits with the number of the target region.",
    "",
    "PARAMETER",
    "    nx  INTEGER  Number of regions in x direction, or number of pieces for unstructured grids",
    "    ny  INTEGER  Number of regions in y direction [default: 1]",
    "",
    "NOTE",
    "    This operator needs to open all output files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp CollgridHelp = {
    "NAME",
    "    collgrid - Collect horizontal grid",
    "",
    "SYNOPSIS",
    "    collgrid[,nx[,names]]  infiles outfile",
    "",
    "DESCRIPTION",
    "    This operator collects the data of the input files to one output file. All input files need",
    "    to have the same variables and the same number of timesteps on a different horizonal grid region.",
    "    If the source regions are on a structured lon/lat grid, all regions together must result in a",
    "    new structured lat/long grid box. Data on an unstructured grid is concatenated in the order of",
    "    the input files. The parameter nx needs to be specified only for curvilinear grids.",
    "",
    "PARAMETER",
    "    nx     INTEGER  Number of regions in x direction [default: number of input files]",
    "    names  STRING   Comma-separated list of variable names [default: all variables]",
    "",
    "NOTE",
    "    This operator needs to open all input files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp SelectHelp = {
    "NAME",
    "    select, delete - Select fields",
    "",
    "SYNOPSIS",
    "    <operator>,parameter  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from infiles and writes them to outfile.",
    "    infiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The fields selected depends on the chosen parameters. Parameter is a comma-separated list",
    "    of \"key=value\" pairs. A range of integer values can be specified by first/last[/inc].",
    "    Wildcards are supported for string values.",
    "",
    "OPERATORS",
    "    select  Select fields",
    "            Selects all fields with parameters in a user given list.",
    "    delete  Delete fields",
    "            Deletes all fields with parameters in a user given list.",
    "",
    "PARAMETER",
    "    name              STRING  Comma-separated list of variable names.",
    "    param             STRING  Comma-separated list of parameter identifiers.",
    "    code              INTEGER Comma-separated list or first/last[/inc] range of code numbers.",
    "    level             FLOAT   Comma-separated list of vertical levels.",
    "    levrange          FLOAT   First and last value of the level range.",
    "    levidx            INTEGER Comma-separated list or first/last[/inc] range of index of levels.",
    "    zaxisname         STRING  Comma-separated list of zaxis names.",
    "    zaxisnum          INTEGER Comma-separated list or first/last[/inc] range of zaxis numbers.",
    "    ltype             INTEGER Comma-separated list or first/last[/inc] range of GRIB level types.",
    "    gridname          STRING  Comma-separated list of grid names.",
    "    gridnum           INTEGER Comma-separated list or first/last[/inc] range of grid numbers.",
    "    steptype          STRING  Comma-separated list of timestep types (constant, avg, accum, min, max, range, diff, sum)",
    "    date              STRING  Comma-separated list of dates (format YYYY-MM-DDThh:mm:ss).",
    "    startdate         STRING  Start date (format YYYY-MM-DDThh:mm:ss).",
    "    enddate           STRING  End date (format YYYY-MM-DDThh:mm:ss).",
    "    minute            INTEGER Comma-separated list or first/last[/inc] range of minutes.",
    "    hour              INTEGER Comma-separated list or first/last[/inc] range of hours.",
    "    day               INTEGER Comma-separated list or first/last[/inc] range of days.",
    "    month             INTEGER Comma-separated list or first/last[/inc] range of months.",
    "    season            STRING  Comma-separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "    year              INTEGER Comma-separated list or first/last[/inc] range of years.",
    "    dom               STRING  Comma-separated list of the day of month (e.g. 29feb).",
    "    timestep          INTEGER Comma-separated list or first/last[/inc] range of timesteps. Negative values select timesteps from the end (NetCDF only).",
    "    timestep_of_year  INTEGER Comma-separated list or first/last[/inc] range of timesteps of year.",
    "    timestepmask      STRING  Read timesteps from a mask file.",
};

const CdoHelp SelmultiHelp = {
    "NAME",
    "    selmulti, delmulti, changemulti - Select multiple fields via GRIB1 parameters",
    "",
    "SYNOPSIS",
    "    <operator>,selection-specification  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects multiple fields from infile and writes them to outfile.",
    "    selection-specification is a filename or in-place string with the selection specification.",
    "    Each selection-specification has the following compact notation format: ",
    "    ",
    "       <type>(parameters; leveltype(s); levels)",
    "    ",
    "    type      "    "    sel for select or del for delete (optional)",
    "    parameters"    "    GRIB1 parameter code number",
    "    leveltype "    "    GRIB1 level type",
    "    levels    "    "    value of each level",
    "    ",
    "    Examples:",
    "    ",
    "       (1; 103; 0) ",
    "       (33,34; 105; 10) ",
    "       (11,17; 105; 2) ",
    "       (71,73,74,75,61,62,65,117,67,122,121,11,131,66,84,111,112; 105; 0) ",
    "    ",
    "    The following descriptive notation can also be used for selection specification from a file:",
    "    ",
    "       SELECT/DELETE, PARAMETER=parameters, LEVTYPE=leveltye(s), LEVEL=levels",
    "    ",
    "    Examples:",
    "    ",
    "       SELECT, PARAMETER=1, LEVTYPE=103, LEVEL=0 ",
    "       SELECT, PARAMETER=33/34, LEVTYPE=105, LEVEL=10 ",
    "       SELECT, PARAMETER=11/17, LEVTYPE=105, LEVEL=2 ",
    "       SELECT, PARAMETER=71/73/74/75/61/62/65/117/67/122, LEVTYPE=105, LEVEL=0 ",
    "       DELETE, PARAMETER=128, LEVTYPE=109, LEVEL=* ",
    "    ",
    "    The following will convert Pressure from Pa into hPa; Temp from Kelvin to Celsius: ",
    "       SELECT, PARAMETER=1, LEVTYPE= 103, LEVEL=0, SCALE=0.01 ",
    "       SELECT, PARAMETER=11, LEVTYPE=105, LEVEL=2, OFFSET=273.15 ",
    "    If SCALE and/or OFFSET are defined, then the data values are scaled as SCALE*(VALUE-OFFSET).",
    "",
    "OPERATORS",
    "    selmulti     Select multiple fields",
    "    delmulti     Delete multiple fields",
    "    changemulti  Change identication of multiple fields",
};

const CdoHelp SelvarHelp = {
    "NAME",
    "    selparam, delparam, selcode, delcode, selname, delname, selstdname, sellevel, ",
    "    sellevidx, selgrid, selzaxis, selzaxisname, selltype, seltabnum - Select fields",
    "",
    "SYNOPSIS",
    "    <operator>,parameter  infile outfile",
    "    selcode,codes  infile outfile",
    "    delcode,codes  infile outfile",
    "    selname,names  infile outfile",
    "    delname,names  infile outfile",
    "    selstdname,stdnames  infile outfile",
    "    sellevel,levels  infile outfile",
    "    sellevidx,levidx  infile outfile",
    "    selgrid,grids  infile outfile",
    "    selzaxis,zaxes  infile outfile",
    "    selzaxisname,zaxisnames  infile outfile",
    "    selltype,ltypes  infile outfile",
    "    seltabnum,tabnums  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from infile and writes them to outfile.",
    "    The fields selected depends on the chosen operator and the parameters. A range of integer",
    "    values can be specified by first/last[/inc].",
    "",
    "OPERATORS",
    "    selparam      Select parameters by identifier",
    "                  Selects all fields with parameter identifiers in a user given list.",
    "    delparam      Delete parameters by identifier",
    "                  Deletes all fields with parameter identifiers in a user given list.",
    "    selcode       Select parameters by code number",
    "                  Selects all fields with code numbers in a user given list or range.",
    "    delcode       Delete parameters by code number",
    "                  Deletes all fields with code numbers in a user given list or range.",
    "    selname       Select parameters by name",
    "                  Selects all fields with parameter names in a user given list.",
    "    delname       Delete parameters by name",
    "                  Deletes all fields with parameter names in a user given list.",
    "    selstdname    Select parameters by standard name",
    "                  Selects all fields with standard names in a user given list.",
    "    sellevel      Select levels",
    "                  Selects all fields with levels in a user given list.",
    "    sellevidx     Select levels by index",
    "                  Selects all fields with index of levels in a user given list or range.",
    "    selgrid       Select grids",
    "                  Selects all fields with grids in a user given list.",
    "    selzaxis      Select z-axes",
    "                  Selects all fields with z-axes in a user given list.",
    "    selzaxisname  Select z-axes by name",
    "                  Selects all fields with z-axis names in a user given list.",
    "    selltype      Select GRIB level types",
    "                  Selects all fields with GRIB level type in a user given list or range.",
    "    seltabnum     Select parameter table numbers",
    "                  Selects all fields with parameter table numbers in a user given list or range.",
    "",
    "PARAMETER",
    "    parameter   STRING   Comma-separated list of parameter identifiers.",
    "    codes       INTEGER  Comma-separated list or first/last[/inc] range of code numbers.",
    "    names       STRING   Comma-separated list of variable names.",
    "    stdnames    STRING   Comma-separated list of standard names.",
    "    levels      FLOAT    Comma-separated list of vertical levels.",
    "    levidx      INTEGER  Comma-separated list or first/last[/inc] range of index of levels.",
    "    ltypes      INTEGER  Comma-separated list or first/last[/inc] range of GRIB level types.",
    "    grids       STRING   Comma-separated list of grid names or numbers.",
    "    zaxes       STRING   Comma-separated list of z-axis types or numbers.",
    "    zaxisnames  STRING   Comma-separated list of z-axis names.",
    "    tabnums     INTEGER  Comma-separated list or range of parameter table numbers.",
};

const CdoHelp SeltimeHelp = {
    "NAME",
    "    seltimestep, seltime, selhour, selday, selmonth, selyear, selseason, seldate, ",
    "    selsmon - Select timesteps",
    "",
    "SYNOPSIS",
    "    seltimestep,timesteps  infile outfile",
    "    seltime,times  infile outfile",
    "    selhour,hours  infile outfile",
    "    selday,days  infile outfile",
    "    selmonth,months  infile outfile",
    "    selyear,years  infile outfile",
    "    selseason,seasons  infile outfile",
    "    seldate,startdate[,enddate]  infile outfile",
    "    selsmon,month[,nts1[,nts2]]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects user specified timesteps from infile and writes them to outfile.",
    "    The timesteps selected depends on the chosen operator and the parameters. A range of integer values",
    "    can be specified by first/last[/inc].",
    "",
    "OPERATORS",
    "    seltimestep  Select timesteps",
    "                 Selects all timesteps with a timestep in a user given list or range.",
    "    seltime      Select times",
    "                 Selects all timesteps with a time in a user given list or range.",
    "    selhour      Select hours",
    "                 Selects all timesteps with a hour in a user given list or range.",
    "    selday       Select days",
    "                 Selects all timesteps with a day in a user given list or range.",
    "    selmonth     Select months",
    "                 Selects all timesteps with a month in a user given list or range.",
    "    selyear      Select years",
    "                 Selects all timesteps with a year in a user given list or range.",
    "    selseason    Select seasons",
    "                 Selects all timesteps with a month of a season in a user given list.",
    "    seldate      Select dates",
    "                 Selects all timesteps with a date in a user given range.",
    "    selsmon      Select single month",
    "                 Selects a month and optional an arbitrary number of timesteps before and after this month.",
    "",
    "PARAMETER",
    "    timesteps  INTEGER  Comma-separated list or first/last[/inc] range of timesteps. Negative values select timesteps from the end (NetCDF only).",
    "    times      STRING   Comma-separated list of times (format hh:mm:ss).",
    "    hours      INTEGER  Comma-separated list or first/last[/inc] range of hours.",
    "    days       INTEGER  Comma-separated list or first/last[/inc] range of days.",
    "    months     INTEGER  Comma-separated list or first/last[/inc] range of months.",
    "    years      INTEGER  Comma-separated list or first/last[/inc] range of years.",
    "    seasons    STRING   Comma-separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "    startdate  STRING   Start date (format YYYY-MM-DDThh:mm:ss).",
    "    enddate    STRING   End date (format YYYY-MM-DDThh:mm:ss) [default: startdate].",
    "    nts1       INTEGER  Number of timesteps before the selected month [default: 0].",
    "    nts2       INTEGER  Number of timesteps after the selected month [default: nts1].",
};

const CdoHelp SelboxHelp = {
    "NAME",
    "    sellonlatbox, selindexbox - Select a box",
    "",
    "SYNOPSIS",
    "    sellonlatbox,lon1,lon2,lat1,lat2  infile outfile",
    "    selindexbox,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Selects grid cells inside a lon/lat or index box.",
    "",
    "OPERATORS",
    "    sellonlatbox  Select a longitude/latitude box",
    "                  Selects grid cells inside a lon/lat box. The user must specify the longitude and latitude of the edges of the box.",
    "                  Only those grid cells are considered whose grid center lies within the lon/lat box.",
    "                  For rotated lon/lat grids the parameters must be specified in rotated coordinates.",
    "    selindexbox   Select an index box",
    "                  Selects grid cells within an index box. The user must specify the indices of the edges of the box.",
    "                  The index of the left edge can be greater then the one of the right edge. Use negative indexing to",
    "                  start from the end. The input grid must be a regular lon/lat or a 2D curvilinear grid.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude in degrees",
    "    lon2  FLOAT    Eastern longitude in degrees",
    "    lat1  FLOAT    Southern or northern latitude in degrees",
    "    lat2  FLOAT    Northern or southern latitude in degrees",
    "    idx1  INTEGER  Index of first longitude (1 - nlon)",
    "    idx2  INTEGER  Index of last longitude (1 - nlon)",
    "    idy1  INTEGER  Index of first latitude (1 - nlat)",
    "    idy2  INTEGER  Index of last latitude (1 - nlat)",
};

const CdoHelp SelregionHelp = {
    "NAME",
    "    selregion, selcircle - Select horizontal regions",
    "",
    "SYNOPSIS",
    "    selregion,regions  infile outfile",
    "    selcircle[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Selects all grid cells with the center point inside user defined regions or a circle.",
    "    The resulting grid is unstructured.",
    "",
    "OPERATORS",
    "    selregion  Select cells inside regions",
    "               Selects all grid cells with the center point inside the regions.",
    "               Regions can be defined by the user via an ASCII file.",
    "               Each region consists of the geographic coordinates of a convex polygon.",
    "               Each line of a polygon description file contains the longitude and latitude of one point.",
    "               Each polygon description file can contain one or more polygons separated by a line with the character \\&.",
    "               ",
    "               Predefined regions of countries can be specified via the country codes.",
    "               A country is specified with dcw:<CountryCode>. Country codes can be combined with the plus sign.",
    "    selcircle  Select cells inside a circle",
    "               Selects all grid cells with the center point inside a circle. The circle is described by geographic coordinates",
    "               of the center and the radius of the circle.",
    "",
    "PARAMETER",
    "    regions  STRING   Comma-separated list of ASCII formatted files with different regions",
    "    lon      FLOAT    Longitude of the center of the circle in degrees, default lon=0.0",
    "    lat      FLOAT    Latitude of the center of the circle in degrees, default lat=0.0",
    "    radius   STRING   Radius of the circle, default radius=1deg (units: deg, rad, km, m)",
};

const CdoHelp SelgridcellHelp = {
    "NAME",
    "    selgridcell, delgridcell - Select grid cells",
    "",
    "SYNOPSIS",
    "    <operator>,indices  infile outfile",
    "",
    "DESCRIPTION",
    "    The operator selects grid cells of all fields from infile. The user must specify the index of each grid cell.",
    "    The resulting grid in outfile is unstructured.",
    "",
    "OPERATORS",
    "    selgridcell  Select grid cells",
    "    delgridcell  Delete grid cells",
    "",
    "PARAMETER",
    "    indices  INTEGER  Comma-separated list or first/last[/inc] range of indices",
};

const CdoHelp SamplegridHelp = {
    "NAME",
    "    samplegrid - Resample grid",
    "",
    "SYNOPSIS",
    "    samplegrid,factor  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for resampling the horizontal grid.",
    "    No interpolation takes place. Resample factor=2 means every second grid point is removed.",
    "    Only rectilinear and curvilinear source grids are supported by this operator.",
    "",
    "PARAMETER",
    "    factor  INTEGER  Resample factor, typically 2, which will half the resolution",
};

const CdoHelp SelyearidxHelp = {
    "NAME",
    "    selyearidx - Select year by index",
    "",
    "SYNOPSIS",
    "    selyearidx  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Selects field elements from infile2 according to a year index from infile1.",
    "    The index of the year in infile1 should be the result of corresponding yearminidx or yearmaxidx operations, respectively.",
};

const CdoHelp SeltimeidxHelp = {
    "NAME",
    "    seltimeidx - Select timestep by index",
    "",
    "SYNOPSIS",
    "    seltimeidx  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Selects field elements from infile2 according to a timestep index from infile1.",
    "    The index of the timestep in infile1 should be the result of corresponding timminidx or timmaxidx operations, respectively.",
};

const CdoHelp SelsurfaceHelp = {
    "NAME",
    "    bottomvalue, topvalue, isosurface - Extract surface",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "    isosurface,isovalue  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes a surface from all 3D variables. The result is a horizonal 2D field.",
    "",
    "OPERATORS",
    "    bottomvalue  Extract bottom level",
    "                 This operator selects the valid values at the bottom level.",
    "                 The NetCDF CF compliant attribute positive is used to determine where top and bottom are.",
    "                 If this attribute is missing, low values are bottom and high values are top.",
    "    topvalue     Extract top level",
    "                 This operator selects the valid values at the top level.",
    "                 The NetCDF CF compliant attribute positive is used to determine where top and bottom are.",
    "                 If this attribute is missing, low values are bottom and high values are top.",
    "    isosurface   Extract isosurface",
    "                 This operator computes an isosurface. The value of the isosurfce is specified by the parameter isovalue.",
    "                 The isosurface is calculated by linear interpolation between two layers.",
    "",
    "PARAMETER",
    "    isovalue  FLOAT  Isosurface value",
};

const CdoHelp CondHelp = {
    "NAME",
    "    ifthen, ifnotthen - Conditional select one field",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module selects field elements from infile2 with respect to infile1 and writes them ",
    "    to outfile. The fields in infile1 are handled as a mask. A value ",
    "    not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in infile1 has either to be the same as in infile2 or the",
    "    same as in one timestep of infile2 or only one.",
    "    The fields in outfile inherit the meta data from infile2.",
    "",
    "OPERATORS",
    "    ifthen     If then",
    "                        / i_2(t,x) if i_1(t,x) NE 0  AND  i_1(t,x) NE miss",
    "               o(t,x) =",
    "                        \\ miss     if i_1(t,x) EQ 0  OR   i_1(t,x) EQ miss",
    "    ifnotthen  If not then",
    "                        / i_2(t,x) if i_1(t,x) EQ 0  AND  i_1(t,x) NE miss",
    "               o(t,x) = ",
    "                        \\ miss     if i_1(t,x) NE 0  OR   i_1(t,x) EQ miss",
};

const CdoHelp Cond2Help = {
    "NAME",
    "    ifthenelse - Conditional select  two fields",
    "",
    "SYNOPSIS",
    "    ifthenelse  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator selects field elements from infile2 or infile3 with respect to",
    "    infile1 and writes them to outfile. The fields in infile1 are handled as a mask.",
    "    A value not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in infile1 has either to be the same as in infile2 or the ",
    "    same as in one timestep of infile2 or only one.",
    "    infile2 and infile3 need to have the same number of fields.",
    "    The fields in outfile inherit the meta data from infile2.",
    "    ",
    "              / i_2(t,x) if i_1(t,x) NE 0  AND  i_1(t,x) NE miss",
    "    o(t,x) = <  i_3(t,x) if i_1(t,x) EQ 0  AND  i_1[t,x) NE miss",
    "              \\ miss     if i_1(t,x) EQ miss",
};

const CdoHelp CondcHelp = {
    "NAME",
    "    ifthenc, ifnotthenc - Conditional select a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  infile outfile",
    "",
    "DESCRIPTION",
    "    This module creates fields with a constant value or missing value.",
    "    The fields in infile are handled as a mask. A value not equal ",
    "    to zero is treated as \"true\", zero is treated as \"false\".",
    "",
    "OPERATORS",
    "    ifthenc     If then constant",
    "                         / c      if i(t,x) NE 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) EQ 0  OR   i(t,x) EQ miss",
    "    ifnotthenc  If not then constant",
    "                         / c      if i(t,x) EQ 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) NE 0  OR   i(t,x) EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
};

const CdoHelp MapReduceHelp = {
    "NAME",
    "    reducegrid - Reduce fields to user-defined mask",
    "",
    "SYNOPSIS",
    "    reducegrid,mask[,limitCoordsOutput]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module holds an operator for data reduction based on a user defined mask.",
    "    The output grid is unstructured and includes coordinate bounds. Bounds can be",
    "    avoided by using the additional 'nobounds' keyword. With 'nocoords' given,",
    "    coordinates a completely suppressed.",
    "",
    "PARAMETER",
    "    mask               STRING file which holds the mask field",
    "    limitCoordsOutput  STRING optional parameter to limit coordinates output: 'nobounds' disables coordinate bounds, 'nocoords' avoids all coordinate information",
};

const CdoHelp CompHelp = {
    "NAME",
    "    eq, ne, le, lt, ge, gt - Comparison of two fields",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module compares two datasets field by field.",
    "    The resulting field is a mask containing 1 if the comparison is true and 0 if not.",
    "    The number of fields in infile1 should be the same as in infile2.",
    "    One of the input files can contain only one timestep or one field.",
    "    The fields in outfile inherit the meta data from infile1 or infile2.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eq  Equal",
    "                  /   1   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ne  Not equal",
    "                  /   1   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    le  Less equal",
    "                  /   1   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    lt  Less than",
    "                  /   1   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ge  Greater equal",
    "                  /   1   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    gt  Greater than",
    "                  /   1   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
};

const CdoHelp CompcHelp = {
    "NAME",
    "    eqc, nec, lec, ltc, gec, gtc - Comparison of a field with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  infile outfile",
    "",
    "DESCRIPTION",
    "    This module compares all fields of a dataset with a constant. The resulting",
    "    field is a mask containing 1 if the comparison is true and 0 if not.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eqc  Equal constant",
    "                   /   1   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    nec  Not equal constant",
    "                   /   1   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    lec  Less equal constant",
    "                   /   1   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    ltc  Less than constant",
    "                   /   1   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gec  Greater equal constant",
    "                   /   1   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gtc  Greater than constant",
    "                   /   1   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
};

const CdoHelp YmoncompHelp = {
    "NAME",
    "    ymoneq, ymonne, ymonle, ymonlt, ymonge, ymongt - Multi-year monthly comparison",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs compaisons of a time series and one timestep with the same month of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same month of year is used.",
    "    The resulting field is a mask containing 1 if the comparison is true and 0 if not. ",
    "    The type of comparison depends on the chosen operator.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module YMONSTAT.",
    "",
    "OPERATORS",
    "    ymoneq  Compare time series with Equal",
    "            Compares whether a time series is equal to a multi-year monthly time series.",
    "    ymonne  Compare time series with NotEqual",
    "            Compares whether a time series is not equal to a multi-year monthly time series.",
    "    ymonle  Compare time series with LessEqual",
    "            Compares whether a time series is less than or equal to a multi-year monthly time series.",
    "    ymonlt  Compares if time series with LessThan",
    "            Compares whether a time series is less than a multi-year monthly time series.",
    "    ymonge  Compares if time series with GreaterEqual",
    "            Compares whether a time series is greater than or equal to a multi-year monthly time series.",
    "    ymongt  Compares if time series with GreaterThan",
    "            Compares whether a time series is greater than a multi-year monthly time series.",
};

const CdoHelp SetattributeHelp = {
    "NAME",
    "    setattribute, delattribute - Set attributes",
    "",
    "SYNOPSIS",
    "    <operator>,attributes  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets or deletes attributes of a dataset and writes the result to outfile.",
    "    The new attributes are only available in outfile if the file format supports attributes.",
    "    ",
    "    Each attribute has the following structure:",
    "    ",
    "      [var_nm@]att_nm[:{s|d|i}]=[att_val|{[var_nm@]att_nm}]",
    "    ",
    "       var_nm  Variable name (optional). Example: pressure",
    "       att_nm  Attribute name. Example: units",
    "       att_val Comma-separated list of attribute values. Example: pascal",
    "    ",
    "    The value of var_nm is the name of the variable containing the attribute (named att_nm) that",
    "    you want to set. Use wildcards to set the attribute att_nm to more than one variable.",
    "    A value of var_nm of '*' will set the attribute att_nm to all data variables.",
    "    If var_nm is missing then att_nm refers to a global attribute.",
    "    ",
    "    The value of att_nm is the name of the attribute you want to set. For each attribute a string (att_nm:s),",
    "    a double (att_nm:d) or an integer (att_nm:i) type can be defined. By default the native type is set.",
    "    ",
    "    The value of att_val is the contents of the attribute att_nm. att_val may be a single value",
    "    or one-dimensional array of elements. The type and the number of elements of an attribute will be detected",
    "    automatically from the contents of the values. An already existing attribute att_nm will be overwritten",
    "    or it will be removed if att_val is omitted. Alternatively, the values of an existing attribute can be copied.",
    "    This attribute must then be enclosed in curly brackets.",
    "    ",
    "    A special meaning has the attribute name FILE. If this is the 1st attribute then all attributes",
    "    are read from a file specified in the value of att_val.",
    "",
    "OPERATORS",
    "    setattribute  Set attributes",
    "    delattribute  Delete attributes",
    "",
    "PARAMETER",
    "    attributes  STRING  Comma-separated list of attributes. ",
    "",
    "NOTE",
    "    Attributes are evaluated by CDO when opening infile. Therefor the result of this operator is not available",
    "    for other operators when this operator is used in chaining operators.",
};

const CdoHelp SetpartabHelp = {
    "NAME",
    "    setpartabp, setpartabn - Set parameter table",
    "",
    "SYNOPSIS",
    "    <operator>,table[,convert]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module transforms data and metadata of infile via a parameter table and writes the result to outfile.",
    "    A parameter table is an ASCII formatted file with a set of parameter entries for each variable. Each new set have to",
    "    start with \"\\&parameter\" and to end with \"/\".",
    "    ",
    "    The following parameter table entries are supported:",
    "    ",
    "     Entry           & Type        & Description      ",
    "     name            & WORD        & Name of the variable",
    "     out_name        & WORD        & New name of the variable",
    "     param           & WORD        & Parameter identifier (GRIB1: code[.tabnum];  GRIB2: num[.cat[.dis]])",
    "     out_param       & WORD        & New parameter identifier",
    "     type            & WORD        & Data type (real or double)",
    "     standard_name   & WORD        & As defined in the CF standard name table",
    "     long_name       & STRING      & Describing the variable",
    "     units           & STRING      & Specifying the units for the variable",
    "     comment         & STRING      & Information concerning the variable",
    "     cell_methods    & STRING      & Information concerning calculation of means or climatologies",
    "     cell_measures   & STRING      & Indicates the names of the variables containing cell areas and volumes",
    "     missing_value   & FLOAT       & Specifying how missing data will be identified",
    "     valid_min       & FLOAT       & Minimum valid value",
    "     valid_max       & FLOAT       & Maximum valid value",
    "     ok_min_mean_abs & FLOAT       & Minimum absolute mean",
    "     ok_max_mean_abs & FLOAT       & Maximum absolute mean",
    "     factor          & FLOAT       & Scale factor",
    "     delete          & INTEGER     & Set to 1 to delete variable",
    "     convert         & INTEGER     & Set to 1 to convert the unit if necessary",
    "    ",
    "    Unsupported parameter table entries are stored as variable attributes.",
    "    The search key for the variable depends on the operator. Use setpartabn to search variables by the name.",
    "    This is typically used for NetCDF datasets. The operator setpartabp searches variables by the parameter ID.",
    "",
    "OPERATORS",
    "    setpartabp  Set parameter table",
    "                Search variables by the parameter identifier.",
    "    setpartabn  Set parameter table",
    "                Search variables by name.",
    "",
    "PARAMETER",
    "    table    STRING   Parameter table file or name",
    "    convert  STRING   Converts the units if necessary",
};

const CdoHelp SetHelp = {
    "NAME",
    "    setcodetab, setcode, setparam, setname, setunit, setlevel, setltype, ",
    "    setmaxsteps - Set field info",
    "",
    "SYNOPSIS",
    "    setcodetab,table  infile outfile",
    "    setcode,code  infile outfile",
    "    setparam,param  infile outfile",
    "    setname,name  infile outfile",
    "    setunit,unit  infile outfile",
    "    setlevel,level  infile outfile",
    "    setltype,ltype  infile outfile",
    "    setmaxsteps,maxsteps  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets some field information. Depending on the chosen operator the ",
    "    parameter table, code number, parameter identifier, variable name or level is set.",
    "",
    "OPERATORS",
    "    setcodetab   Set parameter code table",
    "                 Sets the parameter code table for all variables.",
    "    setcode      Set code number",
    "                 Sets the code number for all variables to the same given value.",
    "    setparam     Set parameter identifier",
    "                 Sets the parameter identifier of the first variable.",
    "    setname      Set variable name",
    "                 Sets the name of the first variable.",
    "    setunit      Set variable unit",
    "                 Sets the unit of the first variable.",
    "    setlevel     Set level",
    "                 Sets the first level of all variables.",
    "    setltype     Set GRIB level type",
    "                 Sets the GRIB level type of all variables.",
    "    setmaxsteps  Set max timesteps",
    "                 Sets maximum number of timesteps",
    "",
    "PARAMETER",
    "    table     STRING   Parameter table file or name",
    "    code      INTEGER  Code number",
    "    param     STRING   Parameter identifier (GRIB1: code[.tabnum]; GRIB2: num[.cat[.dis]])",
    "    name      STRING   Variable name",
    "    level     FLOAT    New level",
    "    ltype     INTEGER  GRIB level type",
    "    maxsteps  INTEGER  Maximum number of timesteps",
};

const CdoHelp SettimeHelp = {
    "NAME",
    "    setdate, settime, setday, setmon, setyear, settunits, settaxis, settbounds, ",
    "    setreftime, setcalendar, shifttime - Set time",
    "",
    "SYNOPSIS",
    "    setdate,date  infile outfile",
    "    settime,time  infile outfile",
    "    setday,day  infile outfile",
    "    setmon,month  infile outfile",
    "    setyear,year  infile outfile",
    "    settunits,units  infile outfile",
    "    settaxis,date,time[,inc]  infile outfile",
    "    settbounds,frequency  infile outfile",
    "    setreftime,date,time[,units]  infile outfile",
    "    setcalendar,calendar  infile outfile",
    "    shifttime,shiftValue  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets the time axis or part of the time axis. Which part of the time axis is",
    "    overwritten/created depends on the chosen operator. The number of time steps does not change.",
    "",
    "OPERATORS",
    "    setdate      Set date",
    "                 Sets the date in every timestep to the same given value.",
    "    settime      Set time of the day",
    "                 Sets the time in every timestep to the same given value.",
    "    setday       Set day",
    "                 Sets the day in every timestep to the same given value.",
    "    setmon       Set month",
    "                 Sets the month in every timestep to the same given value.",
    "    setyear      Set year",
    "                 Sets the year in every timestep to the same given value.",
    "    settunits    Set time units",
    "                 Sets the base units of a relative time axis.",
    "    settaxis     Set time axis",
    "                 Sets the time axis.",
    "    settbounds   Set time bounds",
    "                 Sets the time bounds.",
    "    setreftime   Set reference time",
    "                 Sets the reference time of a relative time axis.",
    "    setcalendar  Set calendar",
    "                 Sets the calendar attribute of a relative time axis.",
    "    shifttime    Shift timesteps",
    "                 Shifts all timesteps by the parameter shiftValue.",
    "",
    "PARAMETER",
    "    day         INTEGER  Value of the new day",
    "    month       INTEGER  Value of the new month",
    "    year        INTEGER  Value of the new year",
    "    units       STRING   Base units of the time axis (seconds, minutes, hours, days, months, years)",
    "    date        STRING   Date (format: YYYY-MM-DD)",
    "    time        STRING   Time (format: hh:mm:ss)",
    "    inc         STRING   Optional increment (seconds, minutes, hours, days, months, years) [default: 1hour]",
    "    frequency   STRING   Frequency of the time series (hour, day, month, year)",
    "    calendar    STRING   Calendar (standard, proleptic_gregorian, 360_day, 365_day, 366_day)",
    "    shiftValue  STRING   Shift value (e.g. -3hour)",
};

const CdoHelp ChangeHelp = {
    "NAME",
    "    chcode, chparam, chname, chunit, chlevel, chlevelc, chlevelv - ",
    "    Change field header",
    "",
    "SYNOPSIS",
    "    chcode,oldcode,newcode[,...]  infile outfile",
    "    chparam,oldparam,newparam,...  infile outfile",
    "    chname,oldname,newname,...  infile outfile",
    "    chunit,oldunit,newunit,...  infile outfile",
    "    chlevel,oldlev,newlev,...  infile outfile",
    "    chlevelc,code,oldlev,newlev  infile outfile",
    "    chlevelv,name,oldlev,newlev  infile outfile",
    "",
    "DESCRIPTION",
    "    This module reads fields from infile, changes some header values",
    "    and writes the results to outfile. The kind of changes depends on ",
    "    the chosen operator.",
    "",
    "OPERATORS",
    "    chcode    Change code number",
    "              Changes some user given code numbers to new user given values.",
    "    chparam   Change parameter identifier",
    "              Changes some user given parameter identifiers to new user given values.",
    "    chname    Change variable or coordinate name",
    "              Changes some user given variable or coordinate names to new user given names.",
    "    chunit    Change variable unit",
    "              Changes some user given variable units to new user given units.",
    "    chlevel   Change level",
    "              Changes some user given levels to new user given values.",
    "    chlevelc  Change level of one code",
    "              Changes one level of a user given code number.",
    "    chlevelv  Change level of one variable",
    "              Changes one level of a user given variable name.",
    "",
    "PARAMETER",
    "    code                   INTEGER  Code number",
    "    oldcode,newcode,...    INTEGER  Pairs of old and new code numbers",
    "    oldparam,newparam,...  STRING   Pairs of old and new parameter identifiers",
    "    name                   STRING   Variable name",
    "    oldname,newname,...    STRING   Pairs of old and new variable names",
    "    oldlev                 FLOAT    Old level",
    "    newlev                 FLOAT    New level",
    "    oldlev,newlev,...      FLOAT    Pairs of old and new levels",
};

const CdoHelp SetgridHelp = {
    "NAME",
    "    setgrid, setgridtype, setgridarea, setgridmask, setprojparams - ",
    "    Set grid information",
    "",
    "SYNOPSIS",
    "    setgrid,grid  infile outfile",
    "    setgridtype,gridtype  infile outfile",
    "    setgridarea,gridarea  infile outfile",
    "    setgridmask,gridmask  infile outfile",
    "    setprojparams,projparams  infile outfile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the horizontal grid. Depending on the chosen operator",
    "    a new grid description is set, the coordinates are converted or the grid cell area is added.",
    "",
    "OPERATORS",
    "    setgrid        Set grid",
    "                   Sets a new grid description. The input fields need to have the same grid size as the size",
    "                   of the target grid description.",
    "    setgridtype    Set grid type",
    "                   Sets the grid type of all input fields. The following grid types are available:",
    "                   curvilinear "    "    Converts a regular grid to a curvilinear grid",
    "                   unstructured"    "    Converts a regular or curvilinear grid to an unstructured grid",
    "                   dereference "    "    Dereference a reference to a grid",
    "                   regular     "    "    Linear interpolation of a reduced Gaussian grid to a regular Gaussian grid",
    "                   regularnn   "    "    Nearest neighbor interpolation of a reduced Gaussian grid to a regular Gaussian grid",
    "                   lonlat      "    "    Converts a regular lonlat grid stored as a curvilinear grid back to a lonlat grid",
    "                   projection  "    "    Removes the geographical coordinates if projection parameter available",
    "    setgridarea    Set grid cell area",
    "                   Sets the grid cell area. The parameter gridarea is the path to a data file,",
    "                   the first field is used as grid cell area. The input fields need to have the same",
    "                   grid size as the grid cell area. The grid cell area is used to compute",
    "                   the weights of each grid cell if needed by an operator, e.g. for fldmean.",
    "    setgridmask    Set grid mask",
    "                   Sets the grid mask. The parameter gridmask is the path to a data file,",
    "                   the first field is used as the grid mask. The input fields need to have the same",
    "                   grid size as the grid mask. The grid mask is used as the target grid mask for",
    "                   remapping, e.g. for remapbil.",
    "    setprojparams  Set proj params",
    "                   Sets the proj_params attribute of a projection. This attribute is used to compute",
    "                   geographic coordinates of a projecton with the proj library.",
    "",
    "PARAMETER",
    "    grid        STRING  Grid description file or name",
    "    gridtype    STRING  Grid type (curvilinear, unstructured, regular, lonlat, projection or dereference)",
    "    gridarea    STRING  Data file, the first field is used as grid cell area",
    "    gridmask    STRING  Data file, the first field is used as grid mask",
    "    projparams  STRING  Proj library parameter (e.g.:+init=EPSG:3413)",
};

const CdoHelp SetzaxisHelp = {
    "NAME",
    "    setzaxis, genlevelbounds - Set z-axis information",
    "",
    "SYNOPSIS",
    "    setzaxis,zaxis  infile outfile",
    "    genlevelbounds[,zbot[,ztop]]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the vertical grid.",
    "",
    "OPERATORS",
    "    setzaxis        Set z-axis",
    "                    This operator sets the z-axis description of all variables with the same number of level as the new z-axis.",
    "    genlevelbounds  Generate level bounds",
    "                    Generates the layer bounds of the z-axis.",
    "",
    "PARAMETER",
    "    zaxis  STRING  Z-axis description file or name of the target z-axis",
    "    zbot   FLOAT   Specifying the bottom of the vertical column. Must have the same units as z-axis. ",
    "    ztop   FLOAT   Specifying the top of the vertical column. Must have the same units as z-axis. ",
};

const CdoHelp InvertHelp = {
    "NAME",
    "    invertlat - Invert latitudes",
    "",
    "SYNOPSIS",
    "    invertlat  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator inverts the latitudes of all fields on a rectilinear grid. ",
};

const CdoHelp InvertlevHelp = {
    "NAME",
    "    invertlev - Invert levels",
    "",
    "SYNOPSIS",
    "    invertlev  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator inverts the levels of all 3D variables.",
};

const CdoHelp ShiftxyHelp = {
    "NAME",
    "    shiftx, shifty - Shift field",
    "",
    "SYNOPSIS",
    "    <operator>,<nshift>,<cyclic>,<coord>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to shift all fields in x or y direction.",
    "    All fields need to have the same horizontal rectilinear or curvilinear grid.",
    "",
    "OPERATORS",
    "    shiftx  Shift x",
    "            Shifts all fields in x direction.",
    "    shifty  Shift y",
    "            Shifts all fields in y direction.",
    "",
    "PARAMETER",
    "    nshift  INTEGER  Number of grid cells to shift (default: 1)",
    "    cyclic  STRING   If set, cells are filled up cyclic (default: missing value)",
    "    coord   STRING   If set, coordinates are also shifted",
};

const CdoHelp MaskregionHelp = {
    "NAME",
    "    maskregion - Mask regions",
    "",
    "SYNOPSIS",
    "    maskregion,regions  infile outfile",
    "",
    "DESCRIPTION",
    "    Masks different regions of the input fields.",
    "    The grid cells inside a region are untouched, the cells outside are set to missing value.",
    "    Considered are only those grid cells with the grid center inside the regions.",
    "    All input fields must have the same horizontal grid.",
    "    ",
    "    Regions can be defined by the user via an ASCII file.",
    "    Each region consists of the geographic coordinates of a convex polygon.",
    "    Each line of a polygon description file contains the longitude and latitude of one point.",
    "    Each polygon description file can contain one or more polygons separated by a line with the character \\&.",
    "    ",
    "    Predefined regions of countries can be specified via the country codes.",
    "    A country is specified with dcw:<CountryCode>. Country codes can be combined with the plus sign.",
    "",
    "PARAMETER",
    "    regions  STRING   Comma-separated list of ASCII formatted files with different regions",
};

const CdoHelp MaskboxHelp = {
    "NAME",
    "    masklonlatbox, maskindexbox - Mask a box",
    "",
    "SYNOPSIS",
    "    masklonlatbox,lon1,lon2,lat1,lat2  infile outfile",
    "    maskindexbox,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Masks grid cells inside a lon/lat or index box. The elements inside the box are untouched, the ",
    "    elements outside are set to missing value. All input fields need to have the same horizontal grid.",
    "    Use sellonlatbox or selindexbox if only the data inside the box are needed.",
    "",
    "OPERATORS",
    "    masklonlatbox  Mask a longitude/latitude box",
    "                   Masks grid cells inside a lon/lat box. The user must specify the longitude and latitude of the edges of the box.",
    "                   Only those grid cells are considered whose grid center lies within the lon/lat box.",
    "                   For rotated lon/lat grids the parameters must be specified in rotated coordinates.",
    "    maskindexbox   Mask an index box",
    "                   Masks grid cells within an index box. The user must specify the indices of the edges of the box.",
    "                   The index of the left edge can be greater then the one of the right edge. Use negative indexing to",
    "                   start from the end. The input grid must be a regular lon/lat or a 2D curvilinear grid.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
};

const CdoHelp SetboxHelp = {
    "NAME",
    "    setclonlatbox, setcindexbox - Set a box to constant",
    "",
    "SYNOPSIS",
    "    setclonlatbox,c,lon1,lon2,lat1,lat2  infile outfile",
    "    setcindexbox,c,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Sets a box of the rectangularly understood field to a constant value. The elements outside ",
    "    the box are untouched, the elements inside are set to the given constant. All input fields ",
    "    need to have the same horizontal grid.",
    "",
    "OPERATORS",
    "    setclonlatbox  Set a longitude/latitude box to constant",
    "                   Sets the values of a longitude/latitude box to a constant value. The ",
    "                   user has to give the longitudes and latitudes of the edges of the box.",
    "    setcindexbox   Set an index box to constant",
    "                   Sets the values of an index box to a constant value. The user has to ",
    "                   give the indices of the edges of the box. The index of the left edge ",
    "                   can be greater than the one of the right edge.",
    "",
    "PARAMETER",
    "    c     FLOAT    Constant",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
};

const CdoHelp EnlargeHelp = {
    "NAME",
    "    enlarge - Enlarge fields",
    "",
    "SYNOPSIS",
    "    enlarge,grid  infile outfile",
    "",
    "DESCRIPTION",
    "    Enlarge all fields of infile to a user given horizontal grid. Normally only the last ",
    "    field element is used for the enlargement. If however the input and output",
    "    grid are regular lon/lat grids, a zonal or meridional enlargement is possible.",
    "    Zonal enlargement takes place, if the xsize of the input field is 1 and ",
    "    the ysize of both grids are the same. For meridional enlargement the ysize",
    "    have to be 1 and the xsize of both grids should have the same size.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
};

const CdoHelp SetmissHelp = {
    "NAME",
    "    setmissval, setctomiss, setmisstoc, setrtomiss, setvrange, setmisstonn, ",
    "    setmisstodis - Set missing value",
    "",
    "SYNOPSIS",
    "    setmissval,newmiss  infile outfile",
    "    setctomiss,c  infile outfile",
    "    setmisstoc,c  infile outfile",
    "    setrtomiss,rmin,rmax  infile outfile",
    "    setvrange,rmin,rmax  infile outfile",
    "    setmisstonn  infile outfile",
    "    setmisstodis[,neighbors]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets part of a field to missing value or missing values",
    "    to a constant value. Which part of the field is set depends on the ",
    "    chosen operator.",
    "",
    "OPERATORS",
    "    setmissval    Set a new missing value",
    "                           / newmiss   if i(t,x) EQ miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x)    if i(t,x) NE miss",
    "    setctomiss    Set constant to missing value",
    "                           / miss   if i(t,x) EQ c",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE c",
    "    setmisstoc    Set missing value to constant",
    "                           / c      if i(t,x) EQ miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE miss",
    "    setrtomiss    Set range to missing value",
    "                           / miss   if i(t,x) GE rmin AND i(t,x) LE rmax",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "    setvrange     Set valid range",
    "                           / miss   if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) GE rmin AND i(t,x) LE rmax",
    "    setmisstonn   Set missing value to nearest neighbor",
    "                  Set all missing values to the nearest non missing value.",
    "                           / i(t,y) if i(t,x) EQ miss AND i(t,y) NE miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE miss",
    "    setmisstodis  Set missing value to distance-weighted average",
    "                  Set all missing values to the distance-weighted average of the nearest non missing values.",
    "                  The default number of nearest neighbors is 4.",
    "",
    "PARAMETER",
    "    neighbors  INTEGER  Number of nearest neighbors",
    "    newmiss    FLOAT    New missing value",
    "    c          FLOAT    Constant",
    "    rmin       FLOAT    Lower bound",
    "    rmax       FLOAT    Upper bound",
};

const CdoHelp VertfillmissHelp = {
    "NAME",
    "    vertfillmiss - Vertical filling of missing values",
    "",
    "SYNOPSIS",
    "    vertfillmiss[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator fills in vertical missing values.",
    "    The method parameter can be used to select the filling method.",
    "    The default method=nearest fills missing values with the nearest neighbor value.",
    "    Other options are forward and backward to fill missing values by forward or backward propagation of values.",
    "    Use the limit parameter to set the maximum number of consecutive missing values to fill and max_gaps to set the maximum number of gaps to fill.",
    "",
    "PARAMETER",
    "    method    STRING   Fill method [nearest|linear|forward|backward] (default: nearest)",
    "    limit     INTEGER  The maximum number of consecutive missing values to fill (default: all)",
    "    max_gaps  INTEGER  The maximum number of gaps to fill (default: all)",
};

const CdoHelp TimfillmissHelp = {
    "NAME",
    "    timfillmiss - Temporal filling of missing values",
    "",
    "SYNOPSIS",
    "    timfillmiss[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator fills in temporally missing values.",
    "    The method parameter can be used to select the filling method.",
    "    The default method=nearest fills missing values with the nearest neighbor value.",
    "    Other options are forward and backward to fill missing values by forward or backward propagation of values.",
    "    Use the limit parameter to set the maximum number of consecutive missing values to fill and max_gaps to set the maximum number of gaps to fill.",
    "",
    "PARAMETER",
    "    method    STRING   Fill method [nearest|linear|forward|backward] (default: nearest)",
    "    limit     INTEGER  The maximum number of consecutive missing values to fill (default: all)",
    "    max_gaps  INTEGER  The maximum number of gaps to fill (default: all)",
};

const CdoHelp SetgridcellHelp = {
    "NAME",
    "    setgridcell - Set the value of a grid cell",
    "",
    "SYNOPSIS",
    "    setgridcell,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets the value of the selected grid cells. The grid cells can be selected by a comma-separated list of grid cell indices",
    "    or a mask. The mask is read from a data file, which may contain only one field. If no grid cells are selected, all values are set.",
    "",
    "PARAMETER",
    "    value  FLOAT    Value of the grid cell",
    "    cell   INTEGER  Comma-separated list of grid cell indices",
    "    mask   STRING   Name of the data file which contains the mask",
};

const CdoHelp ExprHelp = {
    "NAME",
    "    expr, exprf, aexpr, aexprf - Evaluate expressions",
    "",
    "SYNOPSIS",
    "    expr,instr  infile outfile",
    "    exprf,filename  infile outfile",
    "    aexpr,instr  infile outfile",
    "    aexprf,filename  infile outfile",
    "",
    "DESCRIPTION",
    "    This module arithmetically processes every timestep of the input dataset.",
    "    Each individual assignment statement have to end with a semi-colon.",
    "    The special key _ALL_ is used as a template. A statement with a template is replaced for all variable names.",
    "    Unlike regular variables, temporary variables are never written to the output stream.",
    "    To define a temporary variable simply prefix the variable name with an underscore (e.g. _varname)",
    "    when the variable is declared.",
    "    ",
    "    The following operators are supported:",
    "    ",
    "     Operator   & Meaning             & Example   & Result",
    "         =      & assignment          & x = y     & Assigns y to x",
    "         +      & addition            & x + y     & Sum of x and y",
    "         -      & subtraction         & x - y     & Difference of x and y",
    "         *      & multiplication      & x * y     & Product of x and y",
    "         /      & division            & x / y     & Quotient of x and y",
    "         ^      & exponentiation      & x ^y      & Exponentiates x with y",
    "         ==     & equal to            & x == y    &  1, if x equal to y; else 0",
    "         !=     & not equal to        & x != y    &  1, if x not equal to y; else 0",
    "         >      & greater than        & x > y     &  1, if x greater than y; else 0",
    "         <      & less than           & x < y     &  1, if x less than y; else 0",
    "         >=     & greater equal       & x >= y    &  1, if x greater equal y; else 0",
    "         <=     & less equal          & x <= y    &  1, if x less equal y; else 0",
    "         <=>    & less equal greater  & x <=> y   & -1, if x less y; 1, if x greater y; else 0",
    "         &&     & logical AND         & x && y    &  1, if x and y not equal 0; else 0",
    "         ||     & logical OR          & x || y    &  1, if x or y not equal 0; else 0",
    "         !      & logical NOT         & !x        &  1, if x equal 0; else 0",
    "         ?:     & ternary conditional & x ? y : z & y, if x not equal 0, else z",
    "    ",
    "    The following functions are supported:",
    "    ",
    "    Math intrinsics:",
    "    ",
    "    abs(x)      "    "    Absolute value of x",
    "    floor(x)    "    "    Round to largest integral value not greater than x",
    "    ceil(x)     "    "    Round to smallest integral value not less than x",
    "    float(x)    "    "    32-bit float value of x",
    "    int(x)      "    "    Integer value of x",
    "    nint(x)     "    "    Nearest integer value of x",
    "    sqr(x)      "    "    Square of x",
    "    sqrt(x)     "    "    Square Root of x",
    "    exp(x)      "    "    Exponential of x",
    "    ln(x)       "    "    Natural logarithm of x",
    "    log10(x)    "    "    Base 10 logarithm of x",
    "    sin(x)      "    "    Sine of x, where x is specified in radians",
    "    cos(x)      "    "    Cosine of x, where x is specified in radians",
    "    tan(x)      "    "    Tangent of x, where x is specified in radians",
    "    asin(x)     "    "    Arc-sine of x, where x is specified in radians",
    "    acos(x)     "    "    Arc-cosine of x, where x is specified in radians",
    "    atan(x)     "    "    Arc-tangent of x, where x is specified in radians",
    "    sinh(x)     "    "    Hyperbolic sine of x, where x is specified in radians",
    "    cosh(x)     "    "    Hyperbolic cosine of x, where x is specified in radians",
    "    tanh(x)     "    "    Hyperbolic tangent of x, where x is specified in radians",
    "    asinh(x)    "    "    Inverse hyperbolic sine of x, where x is specified in radians",
    "    acosh(x)    "    "    Inverse hyperbolic cosine of x, where x is specified in radians",
    "    atanh(x)    "    "    Inverse hyperbolic tangent of x, where x is specified in radians",
    "    rad(x)      "    "    Convert x from degrees to radians",
    "    deg(x)      "    "    Convert x from radians to degrees",
    "    rand(x)     "    "    Replace x by pseudo-random numbers in the range of 0 to 1",
    "    isMissval(x)"    "    Returns 1 where x is missing",
    "    ",
    "    mod(x,y)    "    "    Floating-point remainder of x/ y",
    "    min(x,y)    "    "    Minimum value of x and y",
    "    max(x,y)    "    "    Maximum value of x and y",
    "    pow(x,y)    "    "    Power function",
    "    hypot(x,y)  "    "    Euclidean distance function, sqrt(x*x + y*y)",
    "    atan2(x,y)  "    "    Arc tangent function of y/x, using signs to determine quadrants",
    "    ",
    "    Coordinates:",
    "    ",
    "    clon(x)      "    "    Longitude coordinate of x (available only if x has geographical coordinates)",
    "    clat(x)      "    "    Latitude coordinate of x (available only if x has geographical coordinates)",
    "    gridarea(x)  "    "    Grid cell area of x (available only if x has geographical coordinates)",
    "    gridindex(x) "    "    Grid cell indices of x",
    "    clev(x)      "    "    Level coordinate of x (0, if x is a 2D surface variable)",
    "    clevidx(x)   "    "    Level index of x (0, if x is a 2D surface variable)",
    "    cthickness(x)"    "    Layer thickness, upper minus lower level bound of x (1, if level bounds are missing)",
    "    ctimestep()  "    "    Timestep number (1 to N)",
    "    cdate()      "    "    Verification date as YYYYMMDD",
    "    ctime()      "    "    Verification time as HHMMSS.millisecond",
    "    cdeltat()    "    "    Difference between current and last timestep in seconds",
    "    cday()       "    "    Day as DD",
    "    cmonth()     "    "    Month as MM",
    "    cyear()      "    "    Year as YYYY",
    "    csecond()    "    "    Second as SS.millisecond",
    "    cminute()    "    "    Minute as MM",
    "    chour()      "    "    Hour as HH",
    "    ",
    "    Constants:",
    "    ",
    "    ngp(x)    "    "    Number of horizontal grid points",
    "    nlev(x)   "    "    Number of vertical levels",
    "    size(x)   "    "    Total number of elements (ngp(x)*nlev(x))",
    "    missval(x)"    "    Returns the missing value of variable x",
    "    ",
    "    Statistics over a field:",
    "    ",
    "    fldmin(x), fldmax(x), fldrange(x), fldsum(x), fldmean(x), fldavg(x), fldstd(x), fldstd1(x),",
    "    fldvar(x), fldvar1(x), fldskew(x), fldkurt(x), fldmedian(x)",
    "    ",
    "    Zonal statistics for regular 2D grids:",
    "    ",
    "    zonmin(x), zonmax(x), zonrange(x), zonsum(x), zonmean(x), zonavg(x), zonstd(x), zonstd1(x),",
    "    zonvar(x), zonvar1(x), zonskew(x), zonkurt(x), zonmedian(x)",
    "    ",
    "    Vertical statistics:",
    "    ",
    "    vertmin(x), vertmax(x), vertrange(x), vertsum(x), vertmean(x), vertavg(x), vertstd(x), vertstd1(x),",
    "    vertvar(x), vertvar1(x)",
    "    ",
    "    Miscellaneous:",
    "    ",
    "    sellevel(x,k)          "    "    Select level k of variable x",
    "    sellevidx(x,k)         "    "    Select level index k of variable x",
    "    sellevelrange(x,k1,k2) "    "    Select all levels of variable x in the range k1 to k2",
    "    sellevidxrange(x,k1,k2)"    "    Select all level indices of variable x in the range k1 to k2",
    "    remove(x)              "    "    Remove variable x from output stream",
    "    ",
    "",
    "OPERATORS",
    "    expr    Evaluate expressions",
    "            The processing instructions are read from the parameter.",
    "    exprf   Evaluate expressions script",
    "            Contrary to expr the processing instructions are read from a file.",
    "    aexpr   Evaluate expressions and append results",
    "            Same as expr, but keep input variables and append results",
    "    aexprf  Evaluate expression script and append results",
    "            Same as exprf, but keep input variables and append results",
    "",
    "PARAMETER",
    "    instr     STRING  Processing instructions (need to be 'quoted' in most cases)",
    "    filename  STRING  File with processing instructions",
    "",
    "NOTE",
    "    If the input stream contains duplicate entries of the same variable name then the last one is used.",
};

const CdoHelp MathHelp = {
    "NAME",
    "    abs, int, nint, pow, sqr, sqrt, exp, ln, log10, sin, cos, tan, asin, acos, ",
    "    atan, reci, not - Mathematical functions",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains some standard mathematical functions.",
    "    All trigonometric functions calculate with radians.",
    "",
    "OPERATORS",
    "    abs    Absolute value",
    "           o(t,x) = abs(i(t,x))",
    "    int    Integer value",
    "           o(t,x) = int(i(t,x))",
    "    nint   Nearest integer value",
    "           o(t,x) = nint(i(t,x))",
    "    pow    Power",
    "           o(t,x) = i(t,x)^y",
    "    sqr    Square",
    "           o(t,x) = i(t,x)^2",
    "    sqrt   Square root",
    "           o(t,x) = sqrt(i(t,x))",
    "    exp    Exponential",
    "           o(t,x) = e^i(t,x)",
    "    ln     Natural logarithm",
    "           o(t,x) = ln(i(t,x))",
    "    log10  Base 10 logarithm",
    "           o(t,x) = log10(i(t,x))",
    "    sin    Sine",
    "           o(t,x) = sin(i(t,x))",
    "    cos    Cosine",
    "           o(t,x) = cos(i(t,x))",
    "    tan    Tangent",
    "           o(t,x) = tan(i(t,x))",
    "    asin   Arc sine",
    "           o(t,x) = asin(i(t,x))",
    "    acos   Arc cosine",
    "           o(t,x) = acos(i(t,x))",
    "    atan   Arc tangent",
    "           o(t,x) = atan(i(t,x))",
    "    reci   Reciprocal value",
    "           o(t,x) = 1 / i(t,x)",
    "    not    Logical NOT",
    "           o(t,x) = 1, if x equal 0; else 0",
};

const CdoHelp ArithcHelp = {
    "NAME",
    "    addc, subc, mulc, divc, minc, maxc - Arithmetic with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  infile outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic with all field elements of a dataset and ",
    "    a constant. The fields in outfile inherit the meta data from infile.",
    "",
    "OPERATORS",
    "    addc  Add a constant",
    "          o(t,x) = i(t,x) + c",
    "    subc  Subtract a constant",
    "          o(t,x) = i(t,x) - c",
    "    mulc  Multiply with a constant",
    "          o(t,x) = i(t,x) * c",
    "    divc  Divide by a constant",
    "          o(t,x) = i(t,x) / c",
    "    minc  Minimum of a field and a constant",
    "          o(t,x) = min(i(t,x), c)",
    "    maxc  Maximum of a field and a constant",
    "          o(t,x) = max(i(t,x), c)",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
};

const CdoHelp ArithHelp = {
    "NAME",
    "    add, sub, mul, div, min, max, atan2 - Arithmetic on two datasets",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of two datasets.",
    "    The number of fields in infile1 should be the same as in infile2.",
    "    The fields in outfile inherit the meta data from infile1.",
    "    All operators in this module simply process one field after the other from the two input files.",
    "    Neither the order of the variables nor the date is checked.",
    "    One of the input files can contain only one timestep or one variable.",
    "",
    "OPERATORS",
    "    add    Add two fields",
    "           o(t,x) = i_1(t,x) + i_2(t,x)",
    "    sub    Subtract two fields",
    "           o(t,x) = i_1(t,x) - i_2(t,x)",
    "    mul    Multiply two fields",
    "           o(t,x) = i_1(t,x) * i_2(t,x)",
    "    div    Divide two fields",
    "           o(t,x) = i_1(t,x) / i_2(t,x)",
    "    min    Minimum of two fields",
    "           o(t,x) = min(i_1(t,x), i_2(t,x))",
    "    max    Maximum of two fields",
    "           o(t,x) = max(i_1(t,x), i_2(t,x))",
    "    atan2  Arc tangent of two fields",
    "           The atan2 operator calculates the arc tangent of two fields. The result is",
    "           in radians, which is between -PI and PI (inclusive).",
    "           ",
    "           o(t,x) = atan2(i_1(t,x), i_2(t,x))",
};

const CdoHelp DayarithHelp = {
    "NAME",
    "    dayadd, daysub, daymul, daydiv - Daily arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same day, month and year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same day, month and year is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module DAYSTAT.",
    "",
    "OPERATORS",
    "    dayadd  Add daily time series",
    "            Adds a time series and a daily time series.",
    "    daysub  Subtract daily time series",
    "            Subtracts a time series and a daily time series.",
    "    daymul  Multiply daily time series",
    "            Multiplies a time series and a daily time series.",
    "    daydiv  Divide daily time series",
    "            Divides a time series and a daily time series.",
};

const CdoHelp MonarithHelp = {
    "NAME",
    "    monadd, monsub, monmul, mondiv - Monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same month and year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same month and year is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module MONSTAT.",
    "",
    "OPERATORS",
    "    monadd  Add monthly time series",
    "            Adds a time series and a monthly time series.",
    "    monsub  Subtract monthly time series",
    "            Subtracts a time series and a monthly time series.",
    "    monmul  Multiply monthly time series",
    "            Multiplies a time series and a monthly time series.",
    "    mondiv  Divide monthly time series",
    "            Divides a time series and a monthly time series.",
};

const CdoHelp YeararithHelp = {
    "NAME",
    "    yearadd, yearsub, yearmul, yeardiv - Yearly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep",
    "    with the same year. For each field in infile1 the corresponding",
    "    field of the timestep in infile2 with the same year is used.",
    "    The header information in infile1 have to be the same as in infile2.",
    "    Usually infile2 is generated by an operator of the module YEARSTAT.",
    "",
    "OPERATORS",
    "    yearadd  Add yearly time series",
    "             Adds a time series and a yearly time series.",
    "    yearsub  Subtract yearly time series",
    "             Subtracts a time series and a yearly time series.",
    "    yearmul  Multiply yearly time series",
    "             Multiplies a time series and a yearly time series.",
    "    yeardiv  Divide yearly time series",
    "             Divides a time series and a yearly time series.",
};

const CdoHelp YhourarithHelp = {
    "NAME",
    "    yhouradd, yhoursub, yhourmul, yhourdiv - Multi-year hourly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same hour and day of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same hour and day of year is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module YHOURSTAT.",
    "",
    "OPERATORS",
    "    yhouradd  Add multi-year hourly time series",
    "              Adds a time series and a multi-year hourly time series.",
    "    yhoursub  Subtract multi-year hourly time series",
    "              Subtracts a time series and a multi-year hourly time series.",
    "    yhourmul  Multiply multi-year hourly time series",
    "              Multiplies a time series and a multi-year hourly time series.",
    "    yhourdiv  Divide multi-year hourly time series",
    "              Divides a time series and a multi-year hourly time series.",
};

const CdoHelp YdayarithHelp = {
    "NAME",
    "    ydayadd, ydaysub, ydaymul, ydaydiv - Multi-year daily arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same day of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same day of year is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module YDAYSTAT.",
    "",
    "OPERATORS",
    "    ydayadd  Add multi-year daily time series",
    "             Adds a time series and a multi-year daily time series.",
    "    ydaysub  Subtract multi-year daily time series",
    "             Subtracts a time series and a multi-year daily time series.",
    "    ydaymul  Multiply multi-year daily time series",
    "             Multiplies a time series and a multi-year daily time series.",
    "    ydaydiv  Divide multi-year daily time series",
    "             Divides a time series and a multi-year daily time series.",
};

const CdoHelp YmonarithHelp = {
    "NAME",
    "    ymonadd, ymonsub, ymonmul, ymondiv - Multi-year monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same month of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same month of year is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module YMONSTAT.",
    "",
    "OPERATORS",
    "    ymonadd  Add multi-year monthly time series",
    "             Adds a time series and a multi-year monthly time series.",
    "    ymonsub  Subtract multi-year monthly time series",
    "             Subtracts a time series and a multi-year monthly time series.",
    "    ymonmul  Multiply multi-year monthly time series",
    "             Multiplies a time series with a multi-year monthly time series.",
    "    ymondiv  Divide multi-year monthly time series",
    "             Divides a time series by a multi-year monthly time series.",
};

const CdoHelp YseasarithHelp = {
    "NAME",
    "    yseasadd, yseassub, yseasmul, yseasdiv - Multi-year seasonal arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same season.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same season is used.",
    "    The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module YSEASSTAT.",
    "",
    "OPERATORS",
    "    yseasadd  Add multi-year seasonal time series",
    "              Adds a time series and a multi-year seasonal time series.",
    "    yseassub  Subtract multi-year seasonal time series",
    "              Subtracts a time series and a multi-year seasonal time series.",
    "    yseasmul  Multiply multi-year seasonal time series",
    "              Multiplies a time series and a multi-year seasonal time series.",
    "    yseasdiv  Divide multi-year seasonal time series",
    "              Divides a time series and a multi-year seasonal time series.",
};

const CdoHelp ArithdaysHelp = {
    "NAME",
    "    muldpm, divdpm, muldpy, divdpy - Arithmetic with days",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each timestep of a dataset with the corresponding",
    "    days per month or days per year. The result of these functions depends on the used",
    "    calendar of the input data.",
    "",
    "OPERATORS",
    "    muldpm  Multiply with days per month",
    "            o(t,x) = i(t,x) * days_per_month",
    "    divdpm  Divide by days per month",
    "            o(t,x) = i(t,x) / days_per_month",
    "    muldpy  Multiply with days per year",
    "            o(t,x) = i(t,x) * days_per_year",
    "    divdpy  Divide by days per year",
    "            o(t,x) = i(t,x) / days_per_year",
};

const CdoHelp ArithlatHelp = {
    "NAME",
    "    mulcoslat, divcoslat - Arithmetic with latitude",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each field element with the cosine of the latitude.",
    "",
    "OPERATORS",
    "    mulcoslat  Multiply with the cosine of the latitude",
    "               o(t,x) = i(t,x) * cos(latitude(x))",
    "    divcoslat  Divide by cosine of the latitude",
    "               o(t,x) = i(t,x) / cos(latitude(x))",
};

const CdoHelp TimcumsumHelp = {
    "NAME",
    "    timcumsum - Cumulative sum over all timesteps",
    "",
    "SYNOPSIS",
    "    timcumsum  infile outfile",
    "",
    "DESCRIPTION",
    "    The timcumsum operator calculates the cumulative sum over all timesteps.",
    "    Missing values are treated as numeric zero when summing.",
    "    ",
    "    o(t,x) = sum{i(t',x), 0<t'<=t}",
};

const CdoHelp ConsecstatHelp = {
    "NAME",
    "    consecsum, consects - Consecute timestep periods",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes periods over all timesteps in infile where a",
    "    certain property is valid. The property can be chosen by creating a mask from",
    "    the original data, which is the expected input format for operators of this",
    "    module. Depending on the operator full information about each period or",
    "    just its length and ending date are computed.",
    "",
    "OPERATORS",
    "    consecsum  Consecutive Sum",
    "               This operator computes periods of consecutive timesteps similar to a",
    "               runsum, but periods are finished, when the mask value is 0. That way",
    "               multiple periods can be found. Timesteps from the input are preserved. Missing",
    "               values are handled like 0, i.e. finish periods of consecutive timesteps.",
    "    consects   Consecutive Timesteps",
    "               In contrast to the operator above consects only computes the length of each",
    "               period together with its last timestep. To be able to perform statistical",
    "               analysis like min, max or mean, everything else is set to missing value.",
};

const CdoHelp VarsstatHelp = {
    "NAME",
    "    varsmin, varsmax, varsrange, varssum, varsmean, varsavg, varsstd, varsstd1, ",
    "    varsvar, varsvar1 - Statistical values over all variables",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all variables for each timestep.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance or",
    "    standard deviation is written to outfile.",
    "    All input variables need to have the same gridsize and the same number of levels.",
    "",
    "OPERATORS",
    "    varsmin    Variables minimum",
    "               For every timestep the minimum over all variables is computed.",
    "    varsmax    Variables maximum",
    "               For every timestep the maximum over all variables is computed.",
    "    varsrange  Variables range",
    "               For every timestep the range over all variables is computed.",
    "    varssum    Variables sum",
    "               For every timestep the sum over all variables is computed.",
    "    varsmean   Variables mean",
    "               For every timestep the mean over all variables is computed.",
    "    varsavg    Variables average",
    "               For every timestep the average over all variables is computed.",
    "    varsstd    Variables standard deviation",
    "               For every timestep the standard deviation over all variables is computed. Normalize by n.",
    "    varsstd1   Variables standard deviation (n-1)",
    "               For every timestep the standard deviation over all variables is computed. Normalize by (n-1).",
    "    varsvar    Variables variance",
    "               For every timestep the variance over all variables is computed. Normalize by n.",
    "    varsvar1   Variables variance (n-1)",
    "               For every timestep the variance over all variables is computed. Normalize by (n-1).",
};

const CdoHelp EnsstatHelp = {
    "NAME",
    "    ensmin, ensmax, ensrange, enssum, ensmean, ensavg, ensstd, ensstd1, ensvar, ",
    "    ensvar1, ensskew, enskurt, ensmedian, enspctl - ",
    "    Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    <operator>  infiles outfile",
    "    enspctl,p  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over an ensemble of input files.",
    "    Depending on the chosen operator, the minimum, maximum, range, sum, average, standard deviation, variance,",
    "    skewness, kurtosis, median or a certain percentile over all input files is written to outfile.",
    "    All input files need to have the same structure with the same variables.",
    "    The date information of a timestep in outfile is the date of the first input file.",
    "",
    "OPERATORS",
    "    ensmin     Ensemble minimum",
    "               o(t,x) = min{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmax     Ensemble maximum",
    "               o(t,x) = max{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensrange   Ensemble range",
    "               o(t,x) = range{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enssum     Ensemble sum",
    "               o(t,x) = sum{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmean    Ensemble mean",
    "               o(t,x) = mean{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensavg     Ensemble average",
    "               o(t,x) = avg{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensstd     Ensemble standard deviation",
    "               Normalize by n.",
    "               ",
    "               o(t,x) = std{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensstd1    Ensemble standard deviation (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(t,x) = std1{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensvar     Ensemble variance",
    "               Normalize by n.",
    "               ",
    "               o(t,x) = var{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensvar1    Ensemble variance (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(t,x) = var1{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensskew    Ensemble skewness",
    "               o(t,x) = skew{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enskurt    Ensemble kurtosis",
    "               o(t,x) = kurt{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmedian  Ensemble median",
    "               o(t,x) = median{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enspctl    Ensemble percentiles",
    "               o(t,x) = pth percentile {i1(t,x), i2(t,x), ..., in(t,x)}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "NOTE",
    "    Operators of this module need to open all input files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp Ensstat2Help = {
    "NAME",
    "    ensrkhistspace, ensrkhisttime, ensroc - Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    <operator>  obsfile ensfiles outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over the ensemble of ensfiles using",
    "    obsfile as a reference. Depending on the operator a ranked Histogram or ",
    "    a roc-curve over all Ensembles ensfiles",
    "    with reference to obsfile is written to outfile. ",
    "    The date and grid information of a timestep in outfile is the date of the ",
    "    first input file. Thus all input files are required to have the same structure in ",
    "    terms of the gridsize, variable definitions and number of timesteps. ",
    "    ",
    "    All Operators in this module use obsfile as the reference (for instance ",
    "    an observation) whereas ensfiles are understood as an ensemble consisting ",
    "    of n (where n is the number of ensfiles) members. ",
    "    ",
    "    The operators ensrkhistspace and ensrkhisttime compute Ranked Histograms. ",
    "    Therefor the vertical axis is utilized as the Histogram axis, which prohibits",
    "    the use of files containing more than one level. The histogram axis has ",
    "    nensfiles+1 bins with level 0 containing for each grid point the number of ",
    "    observations being smaller as all ensembles and level nensfiles+1 indicating",
    "    the number of observations being larger than all ensembles. ",
    "    ",
    "    ensrkhisttime computes a ranked histogram at each timestep reducing each ",
    "    horizontal grid to a 1x1 grid and keeping the time axis as in obsfile. ",
    "    Contrary ensrkhistspace  computes a histogram at each grid point keeping the ",
    "    horizontal grid for each variable and reducing the time-axis. The time information",
    "    is that from the last timestep in obsfile. ",
    "",
    "OPERATORS",
    "    ensrkhistspace  Ranked Histogram averaged over space",
    "    ensrkhisttime   Ranked Histogram averaged over time",
    "    ensroc          Ensemble Receiver Operating characteristics",
};

const CdoHelp EnsvalHelp = {
    "NAME",
    "    enscrps, ensbrs - Ensemble validation tools",
    "",
    "SYNOPSIS",
    "    enscrps  rfile infiles outfilebase",
    "    ensbrs,x  rfile infiles outfilebase",
    "",
    "DESCRIPTION",
    "    This module computes ensemble validation scores and their decomposition such as ",
    "    the Brier and cumulative ranked probability score (CRPS). ",
    "    The first file is used as a reference it can be a climatology, observation or ",
    "    reanalysis against which the skill of the ensembles given in infiles is measured. ",
    "    Depending on the operator a number of output files is generated each containing ",
    "    the skill score and its decomposition corresponding to the operator. ",
    "    The output is averaged  over horizontal fields using appropriate weights ",
    "    for each level and timestep in rfile. ",
    "    ",
    "    All input files need to have the same structure with the same variables.",
    "    The date information of a timestep in outfile is the date of the first input file.",
    "    The output files are named as ",
    "    <outfilebase>.<type>.<filesuffix> where <type> depends on the ",
    "    operator and <filesuffix> is determined from the output file type. ",
    "    There are three output files for operator enscrps and four output files ",
    "    for operator ensbrs.",
    "    ",
    "    The CRPS and its decomposition into Reliability and the potential ",
    "    CRPS are calculated by an appropriate averaging over the field ",
    "    members (note, that the CRPS does *not* average linearly). ",
    "    In the three output files ",
    "    <type> has the following meaning:",
    "    crps for the CRPS, reli for the reliability ",
    "    and crpspot for the potential crps. The relation ",
    "    CRPS = CRPS_{pot} + RELI",
    "    holds. 	  ",
    "    ",
    "    The Brier score of the Ensemble given by infiles with respect to the ",
    "    reference given in rfile and the threshold x is calculated. ",
    "    In the four output files <type> has the following meaning: ",
    "    brs for the Brier score wrt threshold  x; ",
    "    brsreli for the Brier score reliability wrt threshold x;",
    "    brsreso for the Brier score resolution wrt threshold x;",
    "    brsunct for the Brier score uncertainty wrt threshold x.",
    "    In analogy to the CRPS the following relation holds:",
    "    BRS(x) = RELI(x)-RESO(x)+ UNCT(x).",
    "    ",
    "    The implementation of the decomposition of the CRPS and Brier Score follows ",
    "      Hans Hersbach (2000): Decomposition of the Continuous Ranked Probability ",
    "      Score for Ensemble Prediction Systems, in: Weather and Forecasting (15) ",
    "      pp. 559-570. ",
    "    ",
    "    The CRPS code decomposition has been verified against the CRAN - ensemble ",
    "    validation package from R. Differences occur when grid-cell area is not ",
    "    uniform as the implementation in R does not account for that. ",
    "    ",
    "",
    "OPERATORS",
    "    enscrps  Ensemble CRPS and decomposition",
    "    ensbrs   Ensemble Brier score",
    "             Ensemble Brier Score and Decomposition",
};

const CdoHelp FldstatHelp = {
    "NAME",
    "    fldmin, fldmax, fldrange, fldsum, fldint, fldmean, fldavg, fldstd, fldstd1, ",
    "    fldvar, fldvar1, fldskew, fldkurt, fldmedian, fldcount, fldpctl - ",
    "    Statistical values over a field",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "    fldint,weights  infile outfile",
    "    fldmean,weights  infile outfile",
    "    fldavg,weights  infile outfile",
    "    fldstd,weights  infile outfile",
    "    fldstd1,weights  infile outfile",
    "    fldvar,weights  infile outfile",
    "    fldvar1,weights  infile outfile",
    "    fldpctl,p  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of all input fields. A field is a horizontal layer of a data variable.",
    "    Depending on the chosen operator, the minimum, maximum, range, sum, integral, average, standard deviation, variance,",
    "    skewness, kurtosis, median or a certain percentile of the field is written to outfile.",
    "",
    "OPERATORS",
    "    fldmin     Field minimum",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = min{i(t,x'), x_1<x'<=x_n}",
    "    fldmax     Field maximum",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = max{i(t,x'), x_1<x'<=x_n}",
    "    fldrange   Field range",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = range{i(t,x'), x_1<x'<=x_n}",
    "    fldsum     Field sum",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = sum{i(t,x'), x_1<x'<=x_n}",
    "    fldint     Field integral",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = sum{i(t,x')*cellarea(x'), x_1<x'<=x_n}",
    "    fldmean    Field mean",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = mean{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldavg     Field average",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = avg{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldstd     Field standard deviation",
    "               Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = std{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldstd1    Field standard deviation (n-1)",
    "               Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = std1{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldvar     Field variance",
    "               Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = var{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldvar1    Field variance (n-1)",
    "               Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = var1{i(t,x'), x_1<x'<=x_n}",
    "               weighted by area weights obtained by the input field.",
    "    fldskew    Field skewness",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = skew{i(t,x'), x_1<x'<=x_n}",
    "    fldkurt    Field kurtosis",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = kurt{i(t,x'), x_1<x'<=x_n}",
    "    fldmedian  Field median",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = median{i(t,x'), x_1<x'<=x_n}",
    "    fldcount   Field count",
    "               Number of non-missing values of the field.",
    "    fldpctl    Field percentiles",
    "               For every gridpoint x_1, ..., x_n of the same field it is:",
    "               ",
    "               o(t,1) = pth percentile {i(t,x'), x_1<x'<=x_n}",
    "",
    "PARAMETER",
    "    weights  BOOL   weights=FALSE disables weighting by grid cell area [default: weights=TRUE]",
    "    p        FLOAT  Percentile number in {0, ..., 100}",
};

const CdoHelp ZonstatHelp = {
    "NAME",
    "    zonmin, zonmax, zonrange, zonsum, zonmean, zonavg, zonstd, zonstd1, zonvar, ",
    "    zonvar1, zonskew, zonkurt, zonmedian, zonpctl - Zonal statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "    zonmean[,zonaldes]  infile outfile",
    "    zonpctl,p  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes zonal statistical values of the input fields.",
    "    Depending on the chosen operator, the zonal minimum, maximum, range, sum, average, standard deviation, variance,",
    "    skewness, kurtosis, median or a certain percentile of the field is written to outfile.",
    "    Operators of this module require all variables on the same regular lon/lat grid.",
    "    Only the zonal mean (zonmean) can be calculated for data on an unstructured grid if the latitude bins are",
    "    defined with the optional parameter zonaldes.",
    "",
    "OPERATORS",
    "    zonmin     Zonal minimum",
    "               For every latitude the minimum over all longitudes is computed.",
    "    zonmax     Zonal maximum",
    "               For every latitude the maximum over all longitudes is computed.",
    "    zonrange   Zonal range",
    "               For every latitude the range over all longitudes is computed.",
    "    zonsum     Zonal sum",
    "               For every latitude the sum over all longitudes is computed.",
    "    zonmean    Zonal mean",
    "               For every latitude the mean over all longitudes is computed.",
    "               Use the optional parameter zonaldes for data on an unstructured grid.",
    "    zonavg     Zonal average",
    "               For every latitude the average over all longitudes is computed.",
    "    zonstd     Zonal standard deviation",
    "               For every latitude the standard deviation over all longitudes is computed. Normalize by n.",
    "    zonstd1    Zonal standard deviation (n-1)",
    "               For every latitude the standard deviation over all longitudes is computed. Normalize by (n-1).",
    "    zonvar     Zonal variance",
    "               For every latitude the variance over all longitudes is computed. Normalize by n.",
    "    zonvar1    Zonal variance (n-1)",
    "               For every latitude the variance over all longitudes is computed. Normalize by (n-1).",
    "    zonskew    Zonal skewness",
    "               For every latitude the skewness over all longitudes is computed.",
    "    zonkurt    Zonal kurtosis",
    "               For every latitude the kurtosis over all longitudes is computed.",
    "    zonmedian  Zonal median",
    "               For every latitude the median over all longitudes is computed.",
    "    zonpctl    Zonal percentiles",
    "               For every latitude the pth percentile over all longitudes is computed.",
    "",
    "PARAMETER",
    "    p         FLOAT   Percentile number in {0, ..., 100}",
    "    zonaldes  STRING  Description of the zonal latitude bins needed for data on an unstructured grid. A predefined zonal description is zonal_<DY>. DY is the increment of the latitudes in degrees.",
};

const CdoHelp MerstatHelp = {
    "NAME",
    "    mermin, mermax, merrange, mersum, mermean, meravg, merstd, merstd1, mervar, ",
    "    mervar1, merskew, merkurt, mermedian, merpctl - Meridional statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "    merpctl,p  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes meridional statistical values of the input fields.",
    "    Depending on the chosen operator, the meridional minimum, maximum, range, sum, average, standard deviation, variance,",
    "    skewness, kurtosis, median or a certain percentile of the field is written to outfile.",
    "    Operators of this module require all variables on the same regular lon/lat grid.",
    "",
    "OPERATORS",
    "    mermin     Meridional minimum",
    "               For every longitude the minimum over all latitudes is computed.",
    "    mermax     Meridional maximum",
    "               For every longitude the maximum over all latitudes is computed.",
    "    merrange   Meridional range",
    "               For every longitude the range over all latitudes is computed.",
    "    mersum     Meridional sum",
    "               For every longitude the sum over all latitudes is computed.",
    "    mermean    Meridional mean",
    "               For every longitude the area weighted mean over all latitudes is computed.",
    "    meravg     Meridional average",
    "               For every longitude the area weighted average over all latitudes is computed.",
    "    merstd     Meridional standard deviation",
    "               For every longitude the standard deviation over all latitudes is computed. Normalize by n.",
    "    merstd1    Meridional standard deviation (n-1)",
    "               For every longitude the standard deviation over all latitudes is computed. Normalize by (n-1).",
    "    mervar     Meridional variance",
    "               For every longitude the variance over all latitudes is computed. Normalize by n.",
    "    mervar1    Meridional variance (n-1)",
    "               For every longitude the variance over all latitudes is computed. Normalize by (n-1).",
    "    merskew    Meridional skewness",
    "               For every longitude the skewness over all latitudes is computed.",
    "    merkurt    Meridional kurtosis",
    "               For every longitude the kurtosis over all latitudes is computed.",
    "    mermedian  Meridional median",
    "               For every longitude the median over all latitudes is computed.",
    "    merpctl    Meridional percentiles",
    "               For every longitude the pth percentile over all latitudes is computed.",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
};

const CdoHelp GridboxstatHelp = {
    "NAME",
    "    gridboxmin, gridboxmax, gridboxrange, gridboxsum, gridboxmean, gridboxavg, ",
    "    gridboxstd, gridboxstd1, gridboxvar, gridboxvar1, gridboxskew, gridboxkurt, ",
    "    gridboxmedian - Statistical values over grid boxes",
    "",
    "SYNOPSIS",
    "    <operator>,nx,ny  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over surrounding grid boxes.",
    "    Depending on the chosen operator, the minimum, maximum, range, sum, average, standard deviation, variance,",
    "    skewness, kurtosis or median of the neighboring grid boxes is written to outfile.",
    "    All gridbox operators only work on quadrilateral curvilinear grids.",
    "",
    "OPERATORS",
    "    gridboxmin     Gridbox minimum",
    "                   Minimum value of the selected grid boxes.",
    "    gridboxmax     Gridbox maximum",
    "                   Maximum value of the selected grid boxes.",
    "    gridboxrange   Gridbox range",
    "                   Range (max-min value) of the selected grid boxes.",
    "    gridboxsum     Gridbox sum",
    "                   Sum of the selected grid boxes.",
    "    gridboxmean    Gridbox mean",
    "                   Mean of the selected grid boxes.",
    "    gridboxavg     Gridbox average",
    "                   Average of the selected grid boxes.",
    "    gridboxstd     Gridbox standard deviation",
    "                   Standard deviation of the selected grid boxes. Normalize by n.",
    "    gridboxstd1    Gridbox standard deviation (n-1)",
    "                   Standard deviation of the selected grid boxes. Normalize by (n-1).",
    "    gridboxvar     Gridbox variance",
    "                   Variance of the selected grid boxes. Normalize by n.",
    "    gridboxvar1    Gridbox variance (n-1)",
    "                   Variance of the selected grid boxes. Normalize by (n-1).",
    "    gridboxskew    Gridbox skewness",
    "                   Skewness of the selected grid boxes.",
    "    gridboxkurt    Gridbox kurtosis",
    "                   Kurtosis of the selected grid boxes.",
    "    gridboxmedian  Gridbox median",
    "                   Median of the selected grid boxes.",
    "",
    "PARAMETER",
    "    nx  INTEGER  Number of grid boxes in x direction",
    "    ny  INTEGER  Number of grid boxes in y direction",
};

const CdoHelp RemapstatHelp = {
    "NAME",
    "    remapmin, remapmax, remaprange, remapsum, remapmean, remapavg, remapstd, ",
    "    remapstd1, remapvar, remapvar1, remapskew, remapkurt, remapmedian - ",
    "    Remaps source points to target cells",
    "",
    "SYNOPSIS",
    "    <operator>,grid  infile outfile",
    "",
    "DESCRIPTION",
    "    This module maps source points to target cells by calculating a statistical value from the source points.",
    "    Each target cell contains the statistical value from all source points within that target cell.",
    "    If there are no source points within a target cell, it gets a missing value.",
    "    The target grid must be regular lon/lat or Gaussian.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance,",
    "    standard deviation, skewness, kurtosis or median of source points is computed.",
    "",
    "OPERATORS",
    "    remapmin     Remap minimum",
    "                 Minimum value of the source points.",
    "    remapmax     Remap maximum",
    "                 Maximum value of the source points.",
    "    remaprange   Remap range",
    "                 Range (max-min value) of the source points.",
    "    remapsum     Remap sum",
    "                 Sum of the source points.",
    "    remapmean    Remap mean",
    "                 Mean of the source points.",
    "    remapavg     Remap average",
    "                 Average of the source points.",
    "    remapstd     Remap standard deviation",
    "                 Standard deviation of the source points. Normalize by n.",
    "    remapstd1    Remap standard deviation (n-1)",
    "                 Standard deviation of the source points. Normalize by (n-1).",
    "    remapvar     Remap variance",
    "                 Variance of the source points. Normalize by n.",
    "    remapvar1    Remap variance (n-1)",
    "                 Variance of the source points. Normalize by (n-1).",
    "    remapskew    Remap skewness",
    "                 Skewness of the source points.",
    "    remapkurt    Remap kurtosis",
    "                 Kurtosis of the source points.",
    "    remapmedian  Remap median",
    "                 Median of the source points.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
};

const CdoHelp VertstatHelp = {
    "NAME",
    "    vertmin, vertmax, vertrange, vertsum, vertmean, vertavg, vertstd, vertstd1, ",
    "    vertvar, vertvar1 - Vertical statistics",
    "",
    "SYNOPSIS",
    "    <operator>,weights  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all levels of the input variables.",
    "    According to chosen operator the vertical minimum, maximum, range, sum, average, variance",
    "    or standard deviation is written to outfile.",
    "",
    "OPERATORS",
    "    vertmin    Vertical minimum",
    "               For every gridpoint the minimum over all levels is computed.",
    "    vertmax    Vertical maximum",
    "               For every gridpoint the maximum over all levels is computed.",
    "    vertrange  Vertical range",
    "               For every gridpoint the range over all levels is computed.",
    "    vertsum    Vertical sum",
    "               For every gridpoint the sum over all levels is computed.",
    "    vertmean   Vertical mean",
    "               For every gridpoint the layer weighted mean over all levels is computed.",
    "    vertavg    Vertical average",
    "               For every gridpoint the layer weighted average over all levels is computed.",
    "    vertstd    Vertical standard deviation",
    "               For every gridpoint the standard deviation over all levels is computed. Normalize by n.",
    "    vertstd1   Vertical standard deviation (n-1)",
    "               For every gridpoint the standard deviation over all levels is computed. Normalize by (n-1).",
    "    vertvar    Vertical variance",
    "               For every gridpoint the variance over all levels is computed. Normalize by n.",
    "    vertvar1   Vertical variance (n-1)",
    "               For every gridpoint the variance over all levels is computed. Normalize by (n-1).",
    "",
    "PARAMETER",
    "    weights  BOOL   weights=FALSE disables weighting by layer thickness [default: weights=TRUE]",
};

const CdoHelp TimselstatHelp = {
    "NAME",
    "    timselmin, timselmax, timselrange, timselsum, timselmean, timselavg, ",
    "    timselstd, timselstd1, timselvar, timselvar1 - Time range statistics",
    "",
    "SYNOPSIS",
    "    <operator>,nsets[,noffset[,nskip]]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values for a selected number of timesteps. According to",
    "    the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of",
    "    the selected timesteps is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    timselmin    Time selection minimum",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    timselmax    Time selection maximum",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    timselrange  Time selection range",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = range{i(t',x), t1 < t' <= tn}",
    "    timselsum    Time selection sum",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    timselmean   Time selection mean",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    timselavg    Time selection average",
    "                 For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    timselstd    Time selection standard deviation",
    "                 Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = std{i(t',x), t1 < t' <= tn}",
    "    timselstd1   Time selection standard deviation (n-1)",
    "                 Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = std1{i(t',x), t1 < t' <= tn}",
    "    timselvar    Time selection variance",
    "                 Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    timselvar1   Time selection variance (n-1)",
    "                 Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "                 ",
    "                 o(t,x) = var1{i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input timesteps for each output timestep",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
};

const CdoHelp TimselpctlHelp = {
    "NAME",
    "    timselpctl - Time range percentile values",
    "",
    "SYNOPSIS",
    "    timselpctl,p,nsets[,noffset[,nskip]]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentile values over a selected number of timesteps in infile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files infile2 and infile3 ",
    "    should be the result of corresponding timselmin and timselmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p        FLOAT    Percentile number in {0, ..., 100}",
    "    nsets    INTEGER  Number of input timesteps for each output timestep ",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp RunstatHelp = {
    "NAME",
    "    runmin, runmax, runrange, runsum, runmean, runavg, runstd, runstd1, runvar, ",
    "    runvar1 - Running statistics",
    "",
    "SYNOPSIS",
    "    <operator>,nts  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes running statistical values over a selected number of timesteps. Depending on",
    "    the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of a selected",
    "    number of consecutive timesteps read from infile is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    runmin    Running minimum",
    "              o(t+(nts-1)/2,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmax    Running maximum",
    "              o(t+(nts-1)/2,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runrange  Running range",
    "              o(t+(nts-1)/2,x) = range{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runsum    Running sum",
    "              o(t+(nts-1)/2,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmean   Running mean",
    "              o(t+(nts-1)/2,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runavg    Running average",
    "              o(t+(nts-1)/2,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runstd    Running standard deviation",
    "              Normalize by n.",
    "              ",
    "              o(t+(nts-1)/2,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runstd1   Running standard deviation (n-1)",
    "              Normalize by (n-1).",
    "              ",
    "              o(t+(nts-1)/2,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runvar    Running variance",
    "              Normalize by n.",
    "              ",
    "              o(t+(nts-1)/2,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runvar1   Running variance (n-1)",
    "              Normalize by (n-1).",
    "              ",
    "              o(t+(nts-1)/2,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of timesteps",
    "",
    "ENVIRONMENT",
    "    CDO_TIMESTAT_DATE",
    "        Sets the time stamp in outfile to the \"first\", \"middle\" or \"last\" contributing timestep of infile.",
};

const CdoHelp RunpctlHelp = {
    "NAME",
    "    runpctl - Running percentile values",
    "",
    "SYNOPSIS",
    "    runpctl,p,nts  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes running percentiles over a selected number of timesteps in infile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    ",
    "    o(t+(nts-1)/2,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    p    FLOAT    Percentile number in {0, ..., 100}",
    "    nts  INTEGER  Number of timesteps",
};

const CdoHelp TimstatHelp = {
    "NAME",
    "    timmin, timmax, timminidx, timmaxidx, timrange, timsum, timmean, timavg, ",
    "    timstd, timstd1, timvar, timvar1 - Statistical values over all timesteps",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all timesteps in infile. Depending on ",
    "    the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of ",
    "    all timesteps read from infile is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    timmin     Time minimum",
    "               o(1,x) = min{i(t',x), t_1<t'<=t_n}",
    "    timmax     Time maximum",
    "               o(1,x) = max{i(t',x), t_1<t'<=t_n}",
    "    timminidx  Index of time minimum",
    "               o(1,x) = minidx{i(t',x), t_1<t'<=t_n}",
    "    timmaxidx  Index of time maximum",
    "               o(1,x) = maxidx{i(t',x), t_1<t'<=t_n}",
    "    timrange   Time range",
    "               o(1,x) = range{i(t',x), t_1<t'<=t_n}",
    "    timsum     Time sum",
    "               o(1,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    timmean    Time mean",
    "               o(1,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    timavg     Time average",
    "               o(1,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    timstd     Time standard deviation",
    "               Normalize by n. ",
    "               ",
    "               o(1,x) = std{i(t',x), t_1<t'<=t_n}",
    "    timstd1    Time standard deviation (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(1,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    timvar     Time variance",
    "               Normalize by n. ",
    "               ",
    "               o(1,x) = var{i(t',x), t_1<t'<=t_n}",
    "    timvar1    Time variance (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(1,x) = var1{i(t',x), t_1<t'<=t_n}",
};

const CdoHelp TimpctlHelp = {
    "NAME",
    "    timpctl - Percentile values over all timesteps",
    "",
    "SYNOPSIS",
    "    timpctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in infile1. The algorithm uses ",
    "    histograms with minimum and maximum bounds given in infile2 and infile3, respectively. ",
    "    The default number of histogram bins is 101. The default can be overridden by defining the",
    "    environment variable CDO_PCTL_NBINS. The files infile2 and infile3 should be",
    "    the result of corresponding timmin and timmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    ",
    "    o(1,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp HourstatHelp = {
    "NAME",
    "    hourmin, hourmax, hourrange, hoursum, hourmean, houravg, hourstd, hourstd1, ",
    "    hourvar, hourvar1 - Hourly statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same hour.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of timesteps of the same hour is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    hourmin    Hourly minimum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    hourmax    Hourly maximum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    hourrange  Hourly range",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = range{i(t',x), t_1<t'<=t_n}",
    "    hoursum    Hourly sum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    hourmean   Hourly mean",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    houravg    Hourly average",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    hourstd    Hourly standard deviation",
    "               Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    "    hourstd1   Hourly standard deviation (n-1)",
    "               Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    hourvar    Hourly variance",
    "               Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    hourvar1   Hourly variance (n-1)",
    "               Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "               ",
    "               o(t,x) = var1{i(t',x), t_1<t'<=t_n}",
};

const CdoHelp HourpctlHelp = {
    "NAME",
    "    hourpctl - Hourly percentile values",
    "",
    "SYNOPSIS",
    "    hourpctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same hour in infile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and",
    "    infile3, respectively. The default number of histogram bins is 101.",
    "    The default can be overridden by defining the environment variable CDO_PCTL_NBINS.",
    "    The files infile2 and infile3 should be the result of corresponding hourmin",
    "    and hourmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp DaystatHelp = {
    "NAME",
    "    daymin, daymax, dayrange, daysum, daymean, dayavg, daystd, daystd1, dayvar, ",
    "    dayvar1 - Daily statistics",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same day.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of timesteps of the same day is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    daymin    Daily minimum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    daymax    Daily maximum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    dayrange  Daily range",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = range{i(t',x), t_1<t'<=t_n}",
    "    daysum    Daily sum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    daymean   Daily mean",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    dayavg    Daily average",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    daystd    Daily standard deviation",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    "    daystd1   Daily standard deviation (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    dayvar    Daily variance",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    dayvar1   Daily variance (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "              ",
    "              o(t,x) = var1{i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    complete_only  BOOL Process the last day only if it is complete",
};

const CdoHelp DaypctlHelp = {
    "NAME",
    "    daypctl - Daily percentile values",
    "",
    "SYNOPSIS",
    "    daypctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same day in infile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and",
    "    infile3, respectively. The default number of histogram bins is 101.",
    "    The default can be overridden by defining the environment variable CDO_PCTL_NBINS.",
    "    The files infile2 and infile3 should be the result of corresponding daymin",
    "    and daymax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp MonstatHelp = {
    "NAME",
    "    monmin, monmax, monrange, monsum, monmean, monavg, monstd, monstd1, monvar, ",
    "    monvar1 - Monthly statistics",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same month.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of timesteps of the same month is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    monmin    Monthly minimum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    monmax    Monthly maximum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    monrange  Monthly range",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = range{i(t',x), t_1<t'<=t_n}",
    "    monsum    Monthly sum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    monmean   Monthly mean",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    monavg    Monthly average",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    monstd    Monthly standard deviation",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    "    monstd1   Monthly standard deviation (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = std1{i(t',x), t_1 < t' <= t_n}",
    "    monvar    Monthly variance",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    monvar1   Monthly variance (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "              ",
    "              o(t,x) = var1{i(t',x), t_1 < t' <= t_n}",
    "",
    "PARAMETER",
    "    complete_only  BOOL Process the last month only if it is complete",
};

const CdoHelp MonpctlHelp = {
    "NAME",
    "    monpctl - Monthly percentile values",
    "",
    "SYNOPSIS",
    "    monpctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same month in infile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and",
    "    infile3, respectively. The default number of histogram bins is 101.",
    "    The default can be overridden by defining the environment variable CDO_PCTL_NBINS.",
    "    The files infile2 and infile3 should be the result of corresponding monmin",
    "    and monmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp YearmonstatHelp = {
    "NAME",
    "    yearmonmean - Yearly mean from monthly data",
    "",
    "SYNOPSIS",
    "    yearmonmean  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator computes the yearly mean of a monthly time series.",
    "    Each month is weighted with the number of days per month. ",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    ",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "    ",
    "    o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "",
    "ENVIRONMENT",
    "    CDO_TIMESTAT_DATE",
    "        Sets the date information in outfile to the \"first\", \"middle\" or \"last\" contributing timestep of infile.",
};

const CdoHelp YearstatHelp = {
    "NAME",
    "    yearmin, yearmax, yearminidx, yearmaxidx, yearrange, yearsum, yearmean, ",
    "    yearavg, yearstd, yearstd1, yearvar, yearvar1 - Yearly statistics",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same year.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of timesteps of the same year is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    yearmin     Yearly minimum",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    yearmax     Yearly maximum",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    yearminidx  Index of yearly minimum",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = minidx{i(t',x), t_1<t'<=t_n}",
    "    yearmaxidx  Index of yearly maximum",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = maxidx{i(t',x), t_1<t'<=t_n}",
    "    yearrange   Yearly range",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = range{i(t',x), t_1<t'<=t_n}",
    "    yearsum     Yearly sum",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    yearmean    Yearly mean",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    yearavg     Yearly average",
    "                For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    yearstd     Yearly standard deviation",
    "                Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    "    yearstd1    Yearly standard deviation (n-1)",
    "                Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = std1{i(t',x), t_1 < t' <= t_n}",
    "    yearvar     Yearly variance",
    "                Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    yearvar1    Yearly variance (n-1)",
    "                Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "                ",
    "                o(t,x) = var1{i(t',x), t_1 < t' <= t_n}",
    "",
    "PARAMETER",
    "    complete_only  BOOL Process the last year only if it is complete",
    "",
    "NOTE",
    "    The operators yearmean and yearavg compute only arithmetical means!",
};

const CdoHelp YearpctlHelp = {
    "NAME",
    "    yearpctl - Yearly percentile values",
    "",
    "SYNOPSIS",
    "    yearpctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same year in infile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and",
    "    infile3, respectively. The default number of histogram bins is 101. The default can be",
    "    overridden by defining the environment variable CDO_PCTL_NBINS. The files infile2 and",
    "    infile3 should be the result of corresponding yearmin and yearmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp SeasstatHelp = {
    "NAME",
    "    seasmin, seasmax, seasrange, seassum, seasmean, seasavg, seasstd, seasstd1, ",
    "    seasvar, seasvar1 - Seasonal statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same season.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of timesteps of the same season is written to outfile.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    Be careful about the first and the last output timestep, they may be incorrect values",
    "    if the seasons have incomplete timesteps.",
    "",
    "OPERATORS",
    "    seasmin    Seasonal minimum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    seasmax    Seasonal maximum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    seasrange  Seasonal range",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = range{i(t',x), t1 < t' <= tn}",
    "    seassum    Seasonal sum",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    seasmean   Seasonal mean",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    seasavg    Seasonal average",
    "               For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    seasstd    Seasonal standard deviation",
    "               Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = std{i(t',x), t1 < t' <= tn}",
    "    seasstd1   Seasonal standard deviation (n-1)",
    "               Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = std1{i(t',x), t1 < t' <= tn}",
    "    seasvar    Seasonal variance",
    "               Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    seasvar1   Seasonal variance (n-1)",
    "               Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "               ",
    "               o(t,x) = var1{i(t',x), t1 < t' <= tn}",
};

const CdoHelp SeaspctlHelp = {
    "NAME",
    "    seaspctl - Seasonal percentile values",
    "",
    "SYNOPSIS",
    "    seaspctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in infile1 of the same season.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden",
    "    by defining the environment variable CDO_PCTL_NBINS. The files infile2 and infile3",
    "    should be the result of corresponding seasmin and seasmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of infile1.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "    Be careful about the first and the last output timestep, they may be incorrect values ",
    "    if the seasons have incomplete timesteps.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp YhourstatHelp = {
    "NAME",
    "    yhourmin, yhourmax, yhourrange, yhoursum, yhourmean, yhouravg, yhourstd, ",
    "    yhourstd1, yhourvar, yhourvar1 - Multi-year hourly statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour and day of year.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each hour and day of year in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yhourmin    Multi-year hourly minimum",
    "                o(0001,x) = min{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = min{i(t,x), day(i(t)) = 8784}",
    "    yhourmax    Multi-year hourly maximum",
    "                o(0001,x) = max{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = max{i(t,x), day(i(t)) = 8784}",
    "    yhourrange  Multi-year hourly range",
    "                o(0001,x) = range{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = range{i(t,x), day(i(t)) = 8784}",
    "    yhoursum    Multi-year hourly sum",
    "                o(0001,x) = sum{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = sum{i(t,x), day(i(t)) = 8784}",
    "    yhourmean   Multi-year hourly mean",
    "                o(0001,x) = mean{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = mean{i(t,x), day(i(t)) = 8784}",
    "    yhouravg    Multi-year hourly average",
    "                o(0001,x) = avg{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = avg{i(t,x), day(i(t)) = 8784}",
    "    yhourstd    Multi-year hourly standard deviation",
    "                Normalize by n.",
    "                ",
    "                o(0001,x) = std{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = std{i(t,x), day(i(t)) = 8784}",
    "    yhourstd1   Multi-year hourly standard deviation (n-1)",
    "                Normalize by (n-1).",
    "                ",
    "                o(0001,x) = std1{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = std1{i(t,x), day(i(t)) = 8784}",
    "    yhourvar    Multi-year hourly variance",
    "                Normalize by n.",
    "                ",
    "                o(0001,x) = var{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = var{i(t,x), day(i(t)) = 8784}",
    "    yhourvar1   Multi-year hourly variance (n-1)",
    "                Normalize by (n-1).",
    "                ",
    "                o(0001,x) = var1{i(t,x), day(i(t)) = 0001}",
    "                                 ...",
    "                o(8784,x) = var1{i(t,x), day(i(t)) = 8784}",
};

const CdoHelp DhourstatHelp = {
    "NAME",
    "    dhourmin, dhourmax, dhourrange, dhoursum, dhourmean, dhouravg, dhourstd, ",
    "    dhourstd1, dhourvar, dhourvar1 - Multi-day hourly statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour of day.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each hour of day in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    dhourmin    Multi-day hourly minimum",
    "                o(01,x) = min{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = min{i(t,x), day(i(t)) = 24}",
    "    dhourmax    Multi-day hourly maximum",
    "                o(01,x) = max{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = max{i(t,x), day(i(t)) = 24}",
    "    dhourrange  Multi-day hourly range",
    "                o(01,x) = range{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = range{i(t,x), day(i(t)) = 24}",
    "    dhoursum    Multi-day hourly sum",
    "                o(01,x) = sum{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = sum{i(t,x), day(i(t)) = 24}",
    "    dhourmean   Multi-day hourly mean",
    "                o(01,x) = mean{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = mean{i(t,x), day(i(t)) = 24}",
    "    dhouravg    Multi-day hourly average",
    "                o(01,x) = avg{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = avg{i(t,x), day(i(t)) = 24}",
    "    dhourstd    Multi-day hourly standard deviation",
    "                Normalize by n.",
    "                ",
    "                o(01,x) = std{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = std{i(t,x), day(i(t)) = 24}",
    "    dhourstd1   Multi-day hourly standard deviation (n-1)",
    "                Normalize by (n-1).",
    "                ",
    "                o(01,x) = std1{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = std1{i(t,x), day(i(t)) = 24}",
    "    dhourvar    Multi-day hourly variance",
    "                Normalize by n.",
    "                ",
    "                o(01,x) = var{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = var{i(t,x), day(i(t)) = 24}",
    "    dhourvar1   Multi-day hourly variance (n-1)",
    "                Normalize by (n-1).",
    "                ",
    "                o(01,x) = var1{i(t,x), day(i(t)) = 01}",
    "                                 ...",
    "                o(24,x) = var1{i(t,x), day(i(t)) = 24}",
};

const CdoHelp DminutestatHelp = {
    "NAME",
    "    dminutemin, dminutemax, dminuterange, dminutesum, dminutemean, dminuteavg, ",
    "    dminutestd, dminutestd1, dminutevar, dminutevar1 - ",
    "    Multi-day by the minute statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each minute of day.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each minute of day in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    dminutemin    Multi-day by the minute minimum",
    "                  o(01,x) = min{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = min{i(t,x), day(i(t)) = 1440}",
    "    dminutemax    Multi-day by the minute maximum",
    "                  o(01,x) = max{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = max{i(t,x), day(i(t)) = 1440}",
    "    dminuterange  Multi-day by the minute range",
    "                  o(01,x) = range{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = range{i(t,x), day(i(t)) = 1440}",
    "    dminutesum    Multi-day by the minute sum",
    "                  o(01,x) = sum{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = sum{i(t,x), day(i(t)) = 1440}",
    "    dminutemean   Multi-day by the minute mean",
    "                  o(01,x) = mean{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = mean{i(t,x), day(i(t)) = 1440}",
    "    dminuteavg    Multi-day by the minute average",
    "                  o(01,x) = avg{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = avg{i(t,x), day(i(t)) = 1440}",
    "    dminutestd    Multi-day by the minute standard deviation",
    "                  Normalize by n.",
    "                  ",
    "                  o(01,x) = std{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = std{i(t,x), day(i(t)) = 1440}",
    "    dminutestd1   Multi-day by the minute standard deviation (n-1)",
    "                  Normalize by (n-1).",
    "                  ",
    "                  o(01,x) = std1{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = std1{i(t,x), day(i(t)) = 1440}",
    "    dminutevar    Multi-day by the minute variance",
    "                  Normalize by n.",
    "                  ",
    "                  o(01,x) = var{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = var{i(t,x), day(i(t)) = 1440}",
    "    dminutevar1   Multi-day by the minute variance (n-1)",
    "                  Normalize by (n-1).",
    "                  ",
    "                  o(01,x) = var1{i(t,x), day(i(t)) = 01}",
    "                                   ...",
    "                  o(1440,x) = var1{i(t,x), day(i(t)) = 1440}",
};

const CdoHelp YdaystatHelp = {
    "NAME",
    "    ydaymin, ydaymax, ydayrange, ydaysum, ydaymean, ydayavg, ydaystd, ydaystd1, ",
    "    ydayvar, ydayvar1 - Multi-year daily statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each day of year.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each day of year in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    ydaymin    Multi-year daily minimum",
    "               o(001,x) = min{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = min{i(t,x), day(i(t)) = 366}",
    "    ydaymax    Multi-year daily maximum",
    "               o(001,x) = max{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = max{i(t,x), day(i(t)) = 366}",
    "    ydayrange  Multi-year daily range",
    "               o(001,x) = range{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = range{i(t,x), day(i(t)) = 366}",
    "    ydaysum    Multi-year daily sum",
    "               o(001,x) = sum{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = sum{i(t,x), day(i(t)) = 366}",
    "    ydaymean   Multi-year daily mean",
    "               o(001,x) = mean{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = mean{i(t,x), day(i(t)) = 366}",
    "    ydayavg    Multi-year daily average",
    "               o(001,x) = avg{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = avg{i(t,x), day(i(t)) = 366}",
    "    ydaystd    Multi-year daily standard deviation",
    "               Normalize by n.",
    "               ",
    "               o(001,x) = std{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = std{i(t,x), day(i(t)) = 366}",
    "    ydaystd1   Multi-year daily standard deviation (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(001,x) = std1{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = std1{i(t,x), day(i(t)) = 366}",
    "    ydayvar    Multi-year daily variance",
    "               Normalize by n.",
    "               ",
    "               o(001,x) = var{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = var{i(t,x), day(i(t)) = 366}",
    "    ydayvar1   Multi-year daily variance (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(001,x) = var1{i(t,x), day(i(t)) = 001}",
    "                                ...",
    "               o(366,x) = var1{i(t,x), day(i(t)) = 366}",
};

const CdoHelp YdaypctlHelp = {
    "NAME",
    "    ydaypctl - Multi-year daily percentile values",
    "",
    "SYNOPSIS",
    "    ydaypctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each day of year in infile1 to outfile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and",
    "    infile3, respectively. The default number of histogram bins is 101. The default can be",
    "    overridden by setting the environment variable CDO_PCTL_NBINS to a different value.",
    "    The files infile2 and infile3 should be the result of corresponding ydaymin and",
    "    ydaymax operations, respectively.",
    "    The date information in an output field is the date of the last contributing input field.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), day(i(t)) = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), day(i(t)) = 366}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp YmonstatHelp = {
    "NAME",
    "    ymonmin, ymonmax, ymonrange, ymonsum, ymonmean, ymonavg, ymonstd, ymonstd1, ",
    "    ymonvar, ymonvar1 - Multi-year monthly statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each month of year.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each month of year in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "    This can be change with the CDO option --timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "    ymonmin    Multi-year monthly minimum",
    "               o(01,x) = min{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = min{i(t,x), month(i(t)) = 12}",
    "    ymonmax    Multi-year monthly maximum",
    "               o(01,x) = max{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = max{i(t,x), month(i(t)) = 12}",
    "    ymonrange  Multi-year monthly range",
    "               o(01,x) = range{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = range{i(t,x), month(i(t)) = 12}",
    "    ymonsum    Multi-year monthly sum",
    "               o(01,x) = sum{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = sum{i(t,x), month(i(t)) = 12}",
    "    ymonmean   Multi-year monthly mean",
    "               o(01,x) = mean{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = mean{i(t,x), month(i(t)) = 12}",
    "    ymonavg    Multi-year monthly average",
    "               o(01,x) = avg{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = avg{i(t,x), month(i(t)) = 12}",
    "    ymonstd    Multi-year monthly standard deviation",
    "               Normalize by n.",
    "               ",
    "               o(01,x) = std{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = std{i(t,x), month(i(t)) = 12}",
    "    ymonstd1   Multi-year monthly standard deviation (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(01,x) = std1{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = std1{i(t,x), month(i(t)) = 12}",
    "    ymonvar    Multi-year monthly variance",
    "               Normalize by n.",
    "               ",
    "               o(01,x) = var{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = var{i(t,x), month(i(t)) = 12}",
    "    ymonvar1   Multi-year monthly variance (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(01,x) = var1{i(t,x), month(i(t)) = 01}",
    "                                ...",
    "               o(12,x) = var1{i(t,x), month(i(t)) = 12}",
};

const CdoHelp YmonpctlHelp = {
    "NAME",
    "    ymonpctl - Multi-year monthly percentile values",
    "",
    "SYNOPSIS",
    "    ymonpctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each month of year in infile1 to outfile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    infile2 and infile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    infile2 and infile3 should be the result of corresponding",
    "    ymonmin and ymonmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(01,x) = pth percentile {i(t,x), month(i(t)) = 01}",
    "                     ...",
    "    o(12,x) = pth percentile {i(t,x), month(i(t)) = 12}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp YseasstatHelp = {
    "NAME",
    "    yseasmin, yseasmax, yseasrange, yseassum, yseasmean, yseasavg, yseasstd, ",
    "    yseasstd1, yseasvar, yseasvar1 - Multi-year seasonal statistics",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each season.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance",
    "    or standard deviation of each season in infile is written to outfile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yseasmin    Multi-year seasonal minimum",
    "                o(1,x) = min{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = min{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = min{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = min{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmax    Multi-year seasonal maximum",
    "                o(1,x) = max{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = max{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = max{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = max{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasrange  Multi-year seasonal range",
    "                o(1,x) = range{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = range{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = range{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = range{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseassum    Multi-year seasonal sum",
    "                o(1,x) = sum{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = sum{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = sum{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = sum{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmean   Multi-year seasonal mean",
    "                o(1,x) = mean{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = mean{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = mean{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = mean{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasavg    Multi-year seasonal average",
    "                o(1,x) = avg{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = avg{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = avg{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = avg{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasstd    Multi-year seasonal standard deviation",
    "                o(1,x) = std{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = std{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = std{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = std{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasstd1   Multi-year seasonal standard deviation (n-1)",
    "                o(1,x) = std1{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = std1{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = std1{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = std1{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasvar    Multi-year seasonal variance",
    "                o(1,x) = var{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = var{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = var{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = var{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasvar1   Multi-year seasonal variance (n-1)",
    "                o(1,x) = var1{i(t,x), month(i(t)) = 12, 01, 02}",
    "                o(2,x) = var1{i(t,x), month(i(t)) = 03, 04, 05}",
    "                o(3,x) = var1{i(t,x), month(i(t)) = 06, 07, 08}",
    "                o(4,x) = var1{i(t,x), month(i(t)) = 09, 10, 11}",
};

const CdoHelp YseaspctlHelp = {
    "NAME",
    "    yseaspctl - Multi-year seasonal percentile values",
    "",
    "SYNOPSIS",
    "    yseaspctl,p  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each season in infile1 to outfile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    infile2 and infile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    infile2 and infile3 should be the result of corresponding",
    "    yseasmin and yseasmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(1,x) = pth percentile {i(t,x), month(i(t)) = 12, 01, 02}",
    "    o(2,x) = pth percentile {i(t,x), month(i(t)) = 03, 04, 05}",
    "    o(3,x) = pth percentile {i(t,x), month(i(t)) = 06, 07, 08}",
    "    o(4,x) = pth percentile {i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp YdrunstatHelp = {
    "NAME",
    "    ydrunmin, ydrunmax, ydrunsum, ydrunmean, ydrunavg, ydrunstd, ydrunstd1, ",
    "    ydrunvar, ydrunvar1 - Multi-year daily running statistics",
    "",
    "SYNOPSIS",
    "    <operator>,nts  infile outfile",
    "",
    "DESCRIPTION",
    "    This module writes running statistical values for each day of year in infile to outfile.",
    "    Depending on the chosen operator, the minimum, maximum, sum, average, variance or standard deviation",
    "    of all timesteps in running windows of which the medium timestep corresponds to a certain day of",
    "    year is computed. The date information in an output field is the date of the timestep in the middle",
    "    of the last contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily measurements in order",
    "    to yield physically meaningful results. Also note that the output time series begins (nts-1)/2 timesteps",
    "    after the first timestep of the input time series and ends (nts-1)/2 timesteps before the last one.",
    "    For input data which are complete but not continuous, such as time series of daily measurements for",
    "    the same month or season within different years, the operator yields physically meaningful results",
    "    only if the input time series does include the (nts-1)/2 days before and after each period of interest.",
    "",
    "OPERATORS",
    "    ydrunmin   Multi-year daily running minimum",
    "               o(001,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmax   Multi-year daily running maximum",
    "               o(001,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunsum   Multi-year daily running sum",
    "               o(001,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmean  Multi-year daily running mean",
    "               o(001,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunavg   Multi-year daily running average",
    "               o(001,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunstd   Multi-year daily running standard deviation",
    "               Normalize by n.",
    "               ",
    "               o(001,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "    ydrunstd1  Multi-year daily running standard deviation (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(001,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "    ydrunvar   Multi-year daily running variance",
    "               Normalize by n.",
    "               ",
    "               o(001,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunvar1  Multi-year daily running variance (n-1)",
    "               Normalize by (n-1).",
    "               ",
    "               o(001,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of timesteps",
};

const CdoHelp YdrunpctlHelp = {
    "NAME",
    "    ydrunpctl - Multi-year daily running percentile values",
    "",
    "SYNOPSIS",
    "    ydrunpctl,p,nts  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes running percentile values for each day of year in infile1 to outfile. ",
    "    A certain percentile is computed for all timesteps in running windows of which the medium ",
    "    timestep corresponds to a certain day of year. ",
    "    The algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden",
    "    by setting the environment variable CDO_PCTL_NBINS to a different value. The files infile2 ",
    "    and infile3 should be the result of corresponding ydrunmin and ydrunmax operations, respectively.",
    "    The date information in an output field is the date of the timestep in the middle of the last contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily measurements ",
    "    in order to yield physically meaningful results. Also note that the output time series begins",
    "    (nts-1)/2 timesteps after the first timestep of the input time series and ends (nts-1)/2 ",
    "    timesteps before the last.",
    "    For input data which are complete but not continuous, such as time series of daily measurements ",
    "    for the same month or season within different years, the operator only yields physically meaningful ",
    "    results if the input time series does include the (nts-1)/2 days before and after each period ",
    "    of interest.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    p    FLOAT    Percentile number in {0, ..., 100}",
    "    nts  INTEGER  Number of timesteps",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

const CdoHelp FldcorHelp = {
    "NAME",
    "    fldcor - Correlation in grid space",
    "",
    "SYNOPSIS",
    "    fldcor  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates all gridpoints",
    "    of two fields for each timestep. With",
    "    ",
    "    S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    ",
    "    it is",
    "    ",
    "    o(t,1) = Cor{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "    ",
    "    where w(x) are the area weights obtained by the input streams.",
    "    For every timestep t only those field elements x belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
};

const CdoHelp TimcorHelp = {
    "NAME",
    "    timcor - Correlation over time",
    "",
    "SYNOPSIS",
    "    timcor  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates each gridpoint",
    "    of two fields over all timesteps. With",
    "    ",
    "    S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    ",
    "    it is",
    "    ",
    "    o(1,x) = Cor{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "    ",
    "    For every gridpoint x only those timesteps t belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
};

const CdoHelp FldcovarHelp = {
    "NAME",
    "    fldcovar - Covariance in grid space",
    "",
    "SYNOPSIS",
    "    fldcovar  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields over all gridpoints",
    "    for each timestep. With",
    "    ",
    "    S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    ",
    "    it is",
    "    ",
    "    o(t,1) = Covar{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "    ",
    "    where w(x) are the area weights obtained by the input streams.",
    "    For every timestep t only those field elements x belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
};

const CdoHelp TimcovarHelp = {
    "NAME",
    "    timcovar - Covariance over time",
    "",
    "SYNOPSIS",
    "    timcovar  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields at each gridpoint",
    "    over all timesteps. With",
    "    ",
    "    S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    ",
    "    it is",
    "    ",
    "    o(1,x) = Covar{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "    ",
    "    For every gridpoint x only those timesteps t belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
};

const CdoHelp RegresHelp = {
    "NAME",
    "    regres - Regression",
    "",
    "SYNOPSIS",
    "    regres[,equal]  infile outfile",
    "",
    "DESCRIPTION",
    "    The values of the input file infile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter b. For every field element x only those timesteps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    "    It is assumed that all timesteps are equidistant, if this is not the case set the parameter equal=false.",
    "",
    "PARAMETER",
    "    equal  BOOL  Set to false for unequal distributed timesteps (default: true)",
};

const CdoHelp DetrendHelp = {
    "NAME",
    "    detrend - Detrend time series",
    "",
    "SYNOPSIS",
    "    detrend[,equal]  infile outfile",
    "",
    "DESCRIPTION",
    "    Every time series in infile is linearly detrended. For every field element x ",
    "    only those timesteps t belong to the sample S(x), which have i(t,x) NE miss.",
    "    It is assumed that all timesteps are equidistant, if this is not the case set the parameter equal=false.",
    "",
    "PARAMETER",
    "    equal  BOOL  Set to false for unequal distributed timesteps (default: true)",
    "",
    "NOTE",
    "    This operator has to keep the fields of all timesteps concurrently in the memory.",
    "    If not enough memory is available use the operators trend and subtrend.",
};

const CdoHelp TrendHelp = {
    "NAME",
    "    trend - Trend of time series",
    "",
    "SYNOPSIS",
    "    trend[,equal]  infile outfile1 outfile2",
    "",
    "DESCRIPTION",
    "    The values of the input file infile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter a and b. For every field element x only those timesteps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    "    Thus the estimation for a is stored in outfile1 and that for b is stored ",
    "    in outfile2. To subtract the trend from the data see operator subtrend.",
    "    It is assumed that all timesteps are equidistant, if this is not the case set the parameter equal=false.",
    "",
    "PARAMETER",
    "    equal  BOOL  Set to false for unequal distributed timesteps (default: true)",
};

const CdoHelp TrendarithHelp = {
    "NAME",
    "    addtrend, subtrend - Add or subtract a trend",
    "",
    "SYNOPSIS",
    "    <operator>[,equal]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This module is for adding or subtracting a trend computed by the operator trend.",
    "",
    "OPERATORS",
    "    addtrend  Add trend",
    "              It is",
    "              ",
    "              o(t,x) = i_1(t,x) + (i_2(1,x) + i_3(1,x)*t)",
    "              where t is the timesteps.",
    "    subtrend  Subtract trend",
    "              It is",
    "              ",
    "              o(t,x) = i_1(t,x) - (i_2(1,x) + i_3(1,x)*t)",
    "              where t is the timesteps.",
    "",
    "PARAMETER",
    "    equal  BOOL  Set to false for unequal distributed timesteps (default: true)",
};

const CdoHelp EOFsHelp = {
    "NAME",
    "    eof, eoftime, eofspatial, eof3d - Empirical Orthogonal Functions",
    "",
    "SYNOPSIS",
    "    <operator>,neof  infile outfile1 outfile2",
    "",
    "DESCRIPTION",
    "    This module calculates empirical orthogonal functions of the data in infile ",
    "    as the eigen values of the scatter matrix (covariance matrix) S of the data",
    "    sample z(t). A more detailed description can be found above.",
    "    ",
    "    Please note, that the input data are assumed to be anomalies.",
    "    ",
    "    If operator eof is chosen, the EOFs are computed in either time or spatial",
    "    space, whichever is the fastest. If the user already knows, which computation",
    "    is faster, the module can be forced to perform a computation in time- or gridspace",
    "    by using the operators eoftime or eofspatial, respectively. This can enhance ",
    "    performance, especially for very long time series, where the number of timesteps",
    "    is larger than the number of grid-points. Data in infile are assumed to be anomalies.",
    "    If they are not, the behavior of this module is not well defined. ",
    "    After execution outfile1 will contain all eigen-values and outfile2 the",
    "    eigenvectors e_j. All EOFs and eigen-values are computed. However, only the first ",
    "    neof EOFs are written to outfile2. Nonetheless, outfile1 contains all eigen-values. ",
    "    ",
    "    Missing values are not fully supported. Support is only checked for non-changing",
    "    masks of missing values in time. Although there still will be results, they are",
    "    not trustworthy, and a warning will occur. In the latter case we suggest to ",
    "    replace missing values by 0 in infile. ",
    "",
    "OPERATORS",
    "    eof         Calculate EOFs in spatial or time space",
    "    eoftime     Calculate EOFs in time space",
    "    eofspatial  Calculate EOFs in spatial space",
    "    eof3d       Calculate 3-Dimensional EOFs in time space",
    "",
    "PARAMETER",
    "    neof  INTEGER  Number of eigen functions",
    "",
    "ENVIRONMENT",
    "    CDO_SVD_MODE   ",
    "        Is used to choose the algorithm for eigenvalue calculation. Options are 'jacobi' for ",
    "        a one-sided parallel jacobi-algorithm (only executed in parallel if -P flag is set)",
    "        and  'danielson_lanczos' for a non-parallel d/l algorithm. The default setting is 'jacobi'.",
    "    CDO_WEIGHT_MODE",
    "        It is used to set the weight mode. The default is 'off'. Set it to 'on' for a weighted version.",
    "    MAX_JACOBI_ITER",
    "        Is the maximum integer number of annihilation sweeps that is executed if the ",
    "        jacobi-algorithm is used to compute the eigen values. The default value is 12.",
    "    FNORM_PRECISION",
    "        Is the Frobenius norm of the matrix consisting of an annihilation pair",
    "        of eigenvectors that is used to determine if the eigenvectors have reached ",
    "        a sufficient level of convergence. If all annihilation-pairs of vectors have ",
    "        a norm below this value, the computation is considered to have converged ",
    "        properly. Otherwise, a warning will occur. The default value 1e-12.",
};

const CdoHelp EofcoeffHelp = {
    "NAME",
    "    eofcoeff - Principal coefficients of EOFs",
    "",
    "SYNOPSIS",
    "    eofcoeff  infile1 infile2 obase",
    "",
    "DESCRIPTION",
    "    This module calculates the time series of the principal coefficients for given EOF",
    "    (empirical orthogonal functions) and data. Time steps in infile1 are assumed to be the EOFs,",
    "    time steps in infile2 are assumed to be the time series.",
    "    Note, that this operator calculates a non weighted dot product of the fields in infile1 and infile2.",
    "    For consistency set the environment variable CDO_WEIGHT_MODE=off when using eof or eof3d.",
    "    ",
    "    There will be a separate file containing a time series of principal coefficients",
    "    with time information from infile2 for each EOF in infile1. Output files will be",
    "    numbered as <obase><neof><suffix> where neof+1 is the number of the EOF (timestep)",
    "    in infile1 and suffix is the filename extension derived from the file format. ",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
};

const CdoHelp RemapbilHelp = {
    "NAME",
    "    remapbil, genbil - Bilinear interpolation",
    "",
    "SYNOPSIS",
    "    remapbil,grid  infile outfile",
    "    genbil,grid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bilinear remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    This interpolation method only works on quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "    remapbil  Bilinear interpolation",
    "              Performs a bilinear interpolation on all input fields.",
    "    genbil    Generate bilinear interpolation weights",
    "              Generates bilinear interpolation weights for the first input field and writes the",
    "              result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "              Set the parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.",
    "              In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETER",
    "    grid   STRING  Target grid description file or name",
    "    map3d  BOOL    Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for circular grids.",
};

const CdoHelp RemapbicHelp = {
    "NAME",
    "    remapbic, genbic - Bicubic interpolation",
    "",
    "SYNOPSIS",
    "    remapbic,grid  infile outfile",
    "    genbic,grid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bicubic remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    This interpolation method only works on quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "    remapbic  Bicubic interpolation",
    "              Performs a bicubic interpolation on all input fields.",
    "    genbic    Generate bicubic interpolation weights",
    "              Generates bicubic interpolation weights for the first input field and writes the",
    "              result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "              Set the parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.",
    "              In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETER",
    "    grid   STRING  Target grid description file or name",
    "    map3d  BOOL    Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for circular grids.",
};

const CdoHelp RemapnnHelp = {
    "NAME",
    "    remapnn, gennn - Nearest neighbor remapping",
    "",
    "SYNOPSIS",
    "    remapnn,grid  infile outfile",
    "    gennn,grid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a nearest neighbor remapping of fields between grids",
    "    in spherical coordinates.",
    "",
    "OPERATORS",
    "    remapnn  Nearest neighbor remapping",
    "             Performs a nearest neighbor remapping on all input fields.",
    "    gennn    Generate nearest neighbor remap weights",
    "             Generates nearest neighbor remapping weights for the first input field and writes the result to a file.",
    "             The format of this file is NetCDF following the SCRIP convention.",
    "             Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "             Set the parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.",
    "             In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETER",
    "    grid   STRING  Target grid description file or name",
    "    map3d  BOOL    Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for this remapping method.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
};

const CdoHelp RemapdisHelp = {
    "NAME",
    "    remapdis, gendis - Distance weighted average remapping",
    "",
    "SYNOPSIS",
    "    remapdis,grid[,neighbors]  infile outfile",
    "    gendis,grid[,neighbors[,map3d]]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for an inverse distance weighted average remapping of the four",
    "    nearest neighbor values of fields between grids in spherical coordinates.",
    "    The default number of 4 neighbors can be changed with the neighbors parameter.",
    "",
    "OPERATORS",
    "    remapdis  Distance weighted average remapping",
    "              Performs an inverse distance weighted averaged remapping of the nearest neighbor values on all input fields.",
    "    gendis    Generate distance weighted average remap weights",
    "              Generates distance weighted averaged remapping weights of the nearest neighbor values for the first input",
    "              field and writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "              Set the parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.",
    "              In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETER",
    "    grid       STRING   Target grid description file or name",
    "    neighbors  INTEGER  Number of nearest neighbors [default: 4]",
    "    map3d      BOOL    Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for this remapping method.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
};

const CdoHelp RemapconHelp = {
    "NAME",
    "    remapcon, gencon - First order conservative remapping",
    "",
    "SYNOPSIS",
    "    remapcon,grid  infile outfile",
    "    gencon,grid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a first order conservative remapping of fields between grids in spherical coordinates.",
    "    The operators in this module uses code from the YAC software package to compute the conservative remapping weights.",
    "    For a detailed description of the interpolation method see YAC.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for the conservative remapping requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remapcon  First order conservative remapping",
    "              Performs a first order conservative remapping on all input fields.",
    "    gencon    Generate 1st order conservative remap weights",
    "              Generates first order conservative remapping weights for the first input field and",
    "              writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "              Set the parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.",
    "              In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETER",
    "    grid   STRING  Target grid description file or name",
    "    map3d  BOOL    Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
};

const CdoHelp RemaplafHelp = {
    "NAME",
    "    remaplaf, genlaf - Largest area fraction remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a largest area fraction remapping of fields between grids in spherical coordinates.",
    "    The operators in this module uses code from the YAC software package to compute the largest area fraction.",
    "    For a detailed description of the interpolation method see YAC.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for this remapping method requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remaplaf  Largest area fraction remapping",
    "              Performs a largest area fraction remapping on all input fields.",
    "    genlaf    Generate largest area fraction remap weights",
    "              Generates largest area fraction remapping weights for the first input field and",
    "              writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
};

const CdoHelp RemapHelp = {
    "NAME",
    "    remap - Grid remapping",
    "",
    "SYNOPSIS",
    "    remap,grid,weights  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolation between different horizontal grids can be a very time-consuming ",
    "    process. Especially if the data are on an unstructured and/or a large grid. ",
    "    In this case the interpolation process can be split into two parts.",
    "    Firstly the generation of the interpolation weights, which is the most time-consuming part.",
    "    These interpolation weights can be reused for every remapping process with the operator remap.",
    "    This operator remaps all input fields to a new horizontal grid. The remap type and ",
    "    the interpolation weights of one input grid are read from a NetCDF file. More weights ",
    "    are computed if the input fields are on different grids. The NetCDF file with the ",
    "    weights should follow the SCRIP convention. Normally these weights come from a previous",
    "    call to one of the genXXX operators (e.g. genbil) or were created by the original SCRIP package.",
    "",
    "PARAMETER",
    "    grid     STRING  Target grid description file or name",
    "    weights  STRING  Interpolation weights (SCRIP NetCDF file)",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM       ",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for remapdis, remapnn and for circular grids.",
    "    REMAP_AREA_MIN       ",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
};

const CdoHelp RemapetaHelp = {
    "NAME",
    "    remapeta - Remap vertical hybrid level",
    "",
    "SYNOPSIS",
    "    remapeta,vct[,oro]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator interpolates between different vertical hybrid levels. This include the preparation ",
    "    of consistent data for the free atmosphere. The procedure for the vertical interpolation is based ",
    "    on the HIRLAM scheme and was adapted from INTERA.",
    "    The vertical interpolation is based on the vertical integration of the hydrostatic equation with ",
    "    few adjustments. The basic tasks are the following one:",
    "    - at first integration of hydrostatic equation",
    "    - extrapolation of surface pressure",
    "    - Planetary Boundary-Layer (PBL) proutfile interpolation",
    "    - interpolation in free atmosphere",
    "    - merging of both proutfiles",
    "    - final surface pressure correction",
    "    ",
    "    The vertical interpolation corrects the surface pressure. This is simply a cut-off or an addition ",
    "    of air mass. This mass correction should not influence the geostrophic velocity field in the middle ",
    "    troposhere. Therefore the total mass above a given reference level is conserved. As reference level",
    "    the geopotential height of the 400 hPa level is used. Near the surface the correction can affect ",
    "    the vertical structure of the PBL. Therefore the interpolation is done using the potential temperature. ",
    "    But in the free atmosphere above a certain n (n=0.8 defining the top of the PBL) the interpolation ",
    "    is done linearly. After the interpolation both proutfiles are merged. With the resulting ",
    "    temperature/pressure correction the hydrostatic equation is integrated again and adjusted to the ",
    "    reference level finding the final surface pressure correction. A more detailed description of",
    "    the interpolation can be found in INTERA. This operator requires all variables on the same horizontal grid.",
    "",
    "PARAMETER",
    "    vct  STRING  File name of an ASCII dataset with the vertical coordinate table",
    "    oro  STRING  File name with the orography (surf. geopotential) of the target dataset (optional)",
    "",
    "ENVIRONMENT",
    "    REMAPETA_PTOP",
    "        Sets the minimum pressure level for condensation.",
    "        Above this level the humidity is set to the constant 1.E-6.",
    "        The default value is 0 Pa.",
    "",
    "NOTE",
    "    The code numbers or the variable names of the required parameter have to follow the ECHAM convention.",
    "    ",
    "    Use the sinfo command to test if your vertical coordinate system is recognized as hybrid system.",
    "    ",
    "    In case remapeta complains about not finding any data on hybrid model levels you may wish",
    "    to use the setzaxis command to generate a zaxis description which conforms to the ECHAM convention.",
    "    See section \"1.4 Z-axis description\" for an example how to define a hybrid Z-axis.",
};

const CdoHelp VertintmlHelp = {
    "NAME",
    "    ml2pl, ml2hl - Vertical interpolation",
    "",
    "SYNOPSIS",
    "    ml2pl,plevels  infile outfile",
    "    ml2hl,hlevels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolates 3D variables on hybrid sigma pressure level to pressure or height levels.",
    "    To calculate the pressure on model levels, the a and b coefficients defining the model levels and",
    "    the surface pressure are required. The a and b coefficients are normally part of the model level data.",
    "    If not available, the surface pressure can be derived from the logarithm of the surface pressure.",
    "    To extrapolate the temperature, the surface geopotential is also needed.",
    "    The geopotential height must be present at the hybrid layer interfaces (model half-layers)!",
    "    All needed variables are identified by their GRIB1 code number or NetCDF CF standard name.",
    "    Supported parameter tables are: WMO standard table number 2 and ECMWF local table number 128.",
    "    ",
    "     Name                       & Units      & GRIB1 code & CF standard name",
    "       log surface pressure     &  Pa        &  152       &",
    "       surface pressure         &  Pa        &  134       &  surface_air_pressure",
    "       air temperature          &  K         &  130       &  air_temperature",
    "       surface geopotential     &  m2 s-2    &  129       &  surface_geopotential",
    "       geopotential height      &  m         &  156       &  geopotential_height",
    "    ",
    "    Use the alias  ml2plx/ml2hlx or the environment variable EXTRAPOLATE to extrapolate",
    "    missing values. This operator requires all variables on the same horizontal grid.",
    "    Missing values in the input data are not supported.",
    "    ",
    "",
    "OPERATORS",
    "    ml2pl  Model to pressure level interpolation",
    "           Interpolates 3D variables on hybrid sigma pressure level to pressure level.",
    "    ml2hl  Model to height level interpolation",
    "           Interpolates 3D variables on hybrid sigma pressure level to height level.",
    "           The procedure is the same as for the operator ml2pl except for",
    "           the pressure levels being calculated from the heights by:",
    "           plevel = 101325*exp(hlevel/-7000)",
    "",
    "PARAMETER",
    "    plevels  FLOAT  Pressure levels in pascal",
    "    hlevels  FLOAT  Height levels in meter",
    "",
    "ENVIRONMENT",
    "    EXTRAPOLATE",
    "        If set to 1 extrapolate missing values.",
    "",
    "NOTE",
    "    The components of the hybrid coordinate must always be avaiable at the hybrid layer interfaces even if the data is defined at the hybrid layer midpoints.",
};

const CdoHelp VertintapHelp = {
    "NAME",
    "    ap2pl - Vertical pressure interpolation",
    "",
    "SYNOPSIS",
    "    ap2pl,plevels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma height coordinates to pressure levels.",
    "    The input file must contain the 3D air pressure in pascal. The air pressure is",
    "    identified by the NetCDF CF standard name air_pressure.",
    "    Use the alias  ap2plx or the environment variable EXTRAPOLATE to extrapolate",
    "    missing values. This operator requires all variables on the same horizontal grid.",
    "",
    "PARAMETER",
    "    plevels  FLOAT  Comma-separated list of pressure levels in pascal",
    "",
    "ENVIRONMENT",
    "    EXTRAPOLATE",
    "        If set to 1 extrapolate missing values.",
    "",
    "NOTE",
    "    This is a specific implementation for NetCDF files from the ICON model, it may not work with data from other sources.",
};

const CdoHelp VertintghHelp = {
    "NAME",
    "    gh2hl - Vertical height interpolation",
    "",
    "SYNOPSIS",
    "    gh2hl,hlevels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma height coordinates to height levels.",
    "    The input file must contain the 3D geometric height in meter. The geometric height is",
    "    identified by the NetCDF CF standard name geometric_height_at_full_level_center.",
    "    Use the alias  gh2hlx or the environment variable EXTRAPOLATE to extrapolate",
    "    missing values. This operator requires all variables on the same horizontal grid.",
    "",
    "PARAMETER",
    "    hlevels  FLOAT  Comma-separated list of height levels in meter",
    "",
    "ENVIRONMENT",
    "    EXTRAPOLATE",
    "        If set to 1 extrapolate missing values.",
    "",
    "NOTE",
    "    This is a specific implementation for NetCDF files from the ICON model, it may not work with data from other sources.",
};

const CdoHelp IntlevelHelp = {
    "NAME",
    "    intlevel - Linear level interpolation",
    "",
    "SYNOPSIS",
    "    intlevel,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of 3D variables. The 1D target levels can be",
    "    specified with the level parameter or read in via a Z-axis description file.",
    "",
    "PARAMETER",
    "    level         FLOAT   Comma-separated list of target levels",
    "    zdescription  STRING  Path to a file containing a description of the Z-axis",
    "    zvarname      STRING  Use zvarname as the vertical 3D source coordinate instead of the 1D coordinate variable",
};

const CdoHelp Intlevel3dHelp = {
    "NAME",
    "    intlevel3d, intlevelx3d - ",
    "    Linear level interpolation from/to 3D vertical coordinates",
    "",
    "SYNOPSIS",
    "    <operator>,tgtcoordinate  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of 3D variables fields with given 3D vertical coordinates.",
    "    infile1 contains the 3D data variables and infile2 the 3D vertical source coordinate. The parameter tgtcoordinate",
    "    is a datafile with the 3D vertical target coordinate.",
    "",
    "OPERATORS",
    "    intlevel3d   Linear level interpolation onto a 3D vertical coordinate",
    "    intlevelx3d  like intlevel3d but with extrapolation",
    "",
    "PARAMETER",
    "    tgtcoordinate  STRING  filename for 3D vertical target coordinates",
};

const CdoHelp InttimeHelp = {
    "NAME",
    "    inttime, intntime - Time interpolation",
    "",
    "SYNOPSIS",
    "    inttime,date,time[,inc]  infile outfile",
    "    intntime,n  infile outfile",
    "",
    "DESCRIPTION",
    "    This module performs linear interpolation between timesteps.",
    "    Interpolation is only performed if both values exist.",
    "    If both values are missing values, the result is also a missing value.",
    "    If only one value exists, it is taken if the time weighting is greater than or equal to 0.5.",
    "    So no new value will be created at existing time steps, if the value is missing there.",
    "",
    "OPERATORS",
    "    inttime   Interpolation between timesteps",
    "              This operator creates a new dataset by linear interpolation between timesteps.",
    "              The user has to define the start date/time with an optional increment.",
    "    intntime  Interpolation between timesteps",
    "              This operator performs linear interpolation between timesteps.",
    "              The user has to define the number of timesteps from one timestep to the next.",
    "",
    "PARAMETER",
    "    date  STRING  Start date (format YYYY-MM-DD)",
    "    time  STRING  Start time (format hh:mm:ss)",
    "    inc   STRING  Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]",
    "    n     INTEGER Number of timesteps from one timestep to the next",
};

const CdoHelp IntyearHelp = {
    "NAME",
    "    intyear - Year interpolation",
    "",
    "SYNOPSIS",
    "    intyear,years  infile1 infile2 obase",
    "",
    "DESCRIPTION",
    "    This operator performs linear interpolation between two years, timestep by timestep.",
    "    The input files need to have the same structure with the same variables.",
    "    The output files will be named <obase><yyyy><suffix> where yyyy will be the year and ",
    "    suffix is the filename extension derived from the file format.",
    "",
    "PARAMETER",
    "    years  INTEGER  Comma-separated list or first/last[/inc] range of years",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    "",
    "NOTE",
    "    This operator needs to open all output files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
};

const CdoHelp SpectralHelp = {
    "NAME",
    "    sp2gp, gp2sp - Spectral transformation",
    "",
    "SYNOPSIS",
    "    <operator>[,type|trunc]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module transforms fields on a global regular Gaussian grid to spectral coefficients and vice versa.",
    "    The transformation is achieved by applying Fast Fourier Transformation (FFT) first and direct Legendre",
    "    Transformation afterwards in gp2sp. In sp2gp the inverse Legendre Transformation and inverse FFT are used.",
    "    Missing values are not supported.",
    "    ",
    "    The relationship between the spectral resolution, governed by the truncation number T, and the grid",
    "    resolution depends on the number of grid points at which the shortest wavelength field is represented.",
    "    For a grid with 2N points between the poles (so 4N grid points in total around the globe) the relationship is:",
    "    ",
    "             linear grid: the shortest wavelength is represented by 2 grid points → 4N ≃ 2(TL + 1)",
    "    ",
    "          quadratic grid: the shortest wavelength is represented by 3 grid points → 4N ≃ 3(TQ + 1)",
    "    ",
    "              cubic grid: the shortest wavelength is represented by 4 grid points → 4N ≃ 4(TC + 1)",
    "    ",
    "    The quadratic grid is used by ECHAM and ERA15. ERA40 is using a linear Gaussian grid reflected by the TL notation.",
    "    ",
    "    The following table shows the calculation of the number of latitudes and the triangular truncation for the different grid types:",
    "    ",
    "         Gridtype           & Number of latitudes: nlat   & Triangular truncation: ntr  ",
    "           linear           &     NINT((ntr*2 + 1)/2)     &     (nlat*2 - 1) / 2",
    "           quadratic        &     NINT((ntr*3 + 1)/2)     &     (nlat*2 - 1) / 3",
    "           cubic            &     NINT((ntr*4 + 1)/2)     &     (nlat*2 - 1) / 4",
    "",
    "OPERATORS",
    "    sp2gp  Spectral to gridpoint",
    "           Convert all spectral fields to a global regular Gaussian grid.",
    "           The optional parameter trunc must be greater than the input truncation.",
    "    gp2sp  Gridpoint to spectral",
    "           Convert all Gaussian gridpoint fields to spectral fields.",
    "           The optional parameter trunc must be lower than the input truncation.",
    "",
    "PARAMETER",
    "    type   STRING  Type of the grid: quadratic, linear, cubic (default: type=quadratic)",
    "    trunc  STRING  Triangular truncation",
    "",
    "NOTE",
    "    To speed up the calculations, the Legendre polynoms are kept in memory. This requires a relatively large",
    "    amount of memory. This is for example 12GB for T1279 data.",
};

const CdoHelp SpecconvHelp = {
    "NAME",
    "    sp2sp - Spectral conversion",
    "",
    "SYNOPSIS",
    "    sp2sp,trunc  infile outfile",
    "",
    "DESCRIPTION",
    "    Changed the triangular truncation of all spectral fields. This operator performs downward ",
    "    conversion by cutting the resolution. Upward conversions are achieved by filling in zeros.",
    "",
    "PARAMETER",
    "    trunc  INTEGER  New spectral resolution",
};

const CdoHelp Wind2Help = {
    "NAME",
    "    dv2ps - D and V to velocity potential and stream function",
    "",
    "SYNOPSIS",
    "    dv2ps  infile outfile",
    "",
    "DESCRIPTION",
    "    Calculate spherical harmonic coefficients of velocity potential and stream function from ",
    "    spherical harmonic coefficients of relative divergence and vorticity. The divergence and ",
    "    vorticity need to have the names sd and svo or code numbers 155 and 138.",
};

const CdoHelp WindHelp = {
    "NAME",
    "    dv2uv, uv2dv - Wind transformation",
    "",
    "SYNOPSIS",
    "    <operator>[,gridtype]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module converts relative divergence and vorticity to U and V wind and vice versa.",
    "    Divergence and vorticity are spherical harmonic coefficients in spectral space and",
    "    U and V are on a global regular Gaussian grid. The Gaussian latitudes need to be ordered from",
    "    north to south. Missing values are not supported.",
    "    ",
    "    The relationship between the spectral resolution, governed by the truncation number T, and the grid",
    "    resolution depends on the number of grid points at which the shortest wavelength field is represented.",
    "    For a grid with 2N points between the poles (so 4N grid points in total around the globe) the relationship is:",
    "    ",
    "             linear grid: the shortest wavelength is represented by 2 grid points → 4N ≃ 2(TL + 1)",
    "    ",
    "          quadratic grid: the shortest wavelength is represented by 3 grid points → 4N ≃ 3(TQ + 1)",
    "    ",
    "              cubic grid: the shortest wavelength is represented by 4 grid points → 4N ≃ 4(TC + 1)",
    "    ",
    "    The quadratic grid is used by ECHAM and ERA15. ERA40 is using a linear Gaussian grid reflected by the TL notation.",
    "    ",
    "    The following table shows the calculation of the number of latitudes and the triangular truncation for the different grid types:",
    "    ",
    "         Gridtype           & Number of latitudes: nlat   & Triangular truncation: ntr  ",
    "           linear           &     NINT((ntr*2 + 1)/2)     &     (nlat*2 - 1) / 2",
    "           quadratic        &     NINT((ntr*3 + 1)/2)     &     (nlat*2 - 1) / 3",
    "           cubic            &     NINT((ntr*4 + 1)/2)     &     (nlat*2 - 1) / 4",
    "",
    "OPERATORS",
    "    dv2uv  Divergence and vorticity to U and V wind",
    "           Calculate U and V wind on a Gaussian grid from spherical harmonic ",
    "           coefficients of relative divergence and vorticity. The divergence and vorticity ",
    "           need to have the names sd and svo or code numbers 155 and 138.",
    "    uv2dv  U and V wind to divergence and vorticity",
    "           Calculate spherical harmonic coefficients of relative divergence and vorticity",
    "           from U and V wind. The U and V wind need to be on a Gaussian grid and need to have the ",
    "           names u and v or the code numbers 131 and 132.",
    "",
    "PARAMETER",
    "    gridtype  STRING  Type of the grid: quadratic, linear, cubic (default: quadratic)",
    "",
    "NOTE",
    "    To speed up the calculations, the Legendre polynoms are kept in memory. This requires a relatively large",
    "    amount of memory. This is for example 12GB for T1279 data.",
};

const CdoHelp FourierHelp = {
    "NAME",
    "    fourier - Fourier transformation",
    "",
    "SYNOPSIS",
    "    fourier,epsilon  infile outfile",
    "",
    "DESCRIPTION",
    "    The fourier operator performs the fourier transformation or the inverse fourier transformation of all input fields.",
    "    If the number of timesteps is a power of 2 then the algorithm of the Fast Fourier Transformation (FFT) is used.",
    "    ",
    "    ",
    "    If the input stream infile consists only of complex fields, then the fields of outfile, computed by",
    "       cdo -f ext fourier,1 -fourier,-1 infile outfile",
    "    are the same than that of infile. For real input files see function retocomplex.",
    "",
    "PARAMETER",
    "    epsilon  INTEGER  -1: forward transformation;  1: backward transformation",
    "",
    "NOTE",
    "    Complex numbers can only be stored in NetCDF4 and EXTRA format.",
};

const CdoHelp ImportbinaryHelp = {
    "NAME",
    "    import_binary - Import binary data sets",
    "",
    "SYNOPSIS",
    "    import_binary  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary data sets via a GrADS data descriptor file.",
    "    The GrADS data descriptor file contains a complete description of the binary data as well ",
    "    as instructions on where to find the data and how to read it. The descriptor file is an ASCII ",
    "    file that can be created easily with a text editor. The general contents of a gridded data ",
    "    descriptor file are as follows:",
    "    - Filename for the binary data",
    "    - Missing or undefined data value",
    "    - Mapping between grid coordinates and world coordinates",
    "    - Description of variables in the binary data set ",
    "    ",
    "    A detailed description of the components of a GrADS data descriptor file can be found in GrADS.",
    "    Here is a list of the supported components:",
    "    BYTESWAPPED, CHSUB, DSET, ENDVARS, FILEHEADER, HEADERBYTES, OPTIONS, TDEF, TITLE, ",
    "    TRAILERBYTES, UNDEF, VARS, XDEF, XYHEADER, YDEF, ZDEF",
    "",
    "NOTE",
    "    Only 32-bit IEEE floats are supported for standard binary files!",
};

const CdoHelp ImportcmsafHelp = {
    "NAME",
    "    import_cmsaf - Import CM-SAF HDF5 files",
    "",
    "SYNOPSIS",
    "    import_cmsaf  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded CM-SAF (Satellite Application Facility on Climate Monitoring)",
    "    HDF5 files. CM-SAF exploits data from polar-orbiting and geostationary satellites in order ",
    "    to provide climate monitoring products of the following parameters: ",
    "    ",
    "    Cloud parameters: cloud fraction (CFC), cloud type (CTY), cloud phase (CPH), ",
    "                      cloud top height, pressure and temperature (CTH,CTP,CTT), ",
    "                      cloud optical thickness (COT), cloud water path (CWP).",
    "    ",
    "    Surface radiation components: Surface albedo (SAL); surface incoming (SIS) ",
    "                      and net (SNS) shortwave radiation; surface downward (SDL) ",
    "                      and outgoing (SOL) longwave radiation, surface net longwave ",
    "                      radiation (SNL) and surface radiation budget (SRB).",
    "    ",
    "    Top-of-atmosphere radiation components: Incoming (TIS) and reflected (TRS) ",
    "                      solar radiative flux at top-of-atmosphere. Emitted thermal ",
    "                      radiative flux at top-of-atmosphere (TET).",
    "    ",
    "    Water vapour:     Vertically integrated water vapour (HTW), layered vertically ",
    "                      integrated water vapour and layer mean temperature and relative ",
    "                      humidity for 5 layers (HLW), temperature and mixing ratio at ",
    "                      6 pressure levels. ",
    "    ",
    "    Daily and monthly mean products can be ordered via the CM-SAF web page (www.cmsaf.eu). ",
    "    Products with higher spatial and temporal resolution, i.e. instantaneous swath-based products,",
    "    are available on request (contact.cmsaf@dwd.de). All products are distributed free-of-charge.",
    "    More information on the data is available on the CM-SAF homepage (www.cmsaf.eu).",
    "    ",
    "    Daily and monthly mean products are provided in equal-area projections. CDO reads the ",
    "    projection parameters from the metadata in the HDF5-headers in order to allow spatial ",
    "    operations like remapping. For spatial operations with instantaneous products on original ",
    "    satellite projection, additional files with arrays of latitudes and longitudes are needed.",
    "    These can be obtained from CM-SAF together with the data.",
    "    ",
    "",
    "NOTE",
    "    To use this operator, it is necessary to build CDO with HDF5 support (version 1.6 or higher).",
    "    The PROJ library (version 5.0 or higher) is needed for full support of the remapping",
    "    functionality. ",
};

const CdoHelp ImportamsrHelp = {
    "NAME",
    "    import_amsr - Import AMSR binary files",
    "",
    "SYNOPSIS",
    "    import_amsr  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary AMSR (Advanced Microwave Scanning Radiometer) data.",
    "    The binary data files are available from the AMSR ftp site (ftp://ftp.ssmi.com/amsre).",
    "    Each file consists of twelve (daily) or five (averaged) 0.25 x 0.25 degree ",
    "    grid (1440,720) byte maps. For daily files, six daytime maps in the following",
    "    order, Time (UTC), Sea Surface Temperature (SST), 10 meter Surface Wind Speed (WSPD),",
    "    Atmospheric Water Vapor (VAPOR), Cloud Liquid Water (CLOUD), and Rain Rate (RAIN), ",
    "    are followed by six nighttime maps in the same order. Time-Averaged files contain ",
    "    just the geophysical layers in the same order [SST, WSPD, VAPOR, CLOUD, RAIN].",
    "    More information to the data is available on the AMSR homepage http://www.remss.com/amsr.",
};

const CdoHelp InputHelp = {
    "NAME",
    "    input, inputsrv, inputext - Formatted input",
    "",
    "SYNOPSIS",
    "    input,grid[,zaxis]  outfile",
    "    inputsrv  outfile",
    "    inputext  outfile",
    "",
    "DESCRIPTION",
    "    This module reads time series of one 2D variable from standard input.",
    "    All input fields need to have the same horizontal grid. The format of the ",
    "    input depends on the chosen operator.",
    "",
    "OPERATORS",
    "    input     ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them",
    "              in outfile. The numbers read are exactly that ones which are written ",
    "              out by the output operator.",
    "    inputsrv  SERVICE ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them ",
    "              in outfile. Each field should have a header of 8 integers (SERVICE likely).",
    "              The numbers that are read are exactly that ones which are written out by ",
    "              the outputsrv operator.",
    "    inputext  EXTRA ASCII input",
    "              Read fields with ASCII numbers from standard input and stores them ",
    "              in outfile. Each field should have header of 4 integers (EXTRA likely).",
    "              The numbers read are exactly that ones which are written out by ",
    "              the outputext operator.",
    "",
    "PARAMETER",
    "    grid   STRING  Grid description file or name",
    "    zaxis  STRING  Z-axis description file",
};

const CdoHelp OutputHelp = {
    "NAME",
    "    output, outputf, outputint, outputsrv, outputext - Formatted output",
    "",
    "SYNOPSIS",
    "    output  infiles",
    "    outputf,format[,nelem]  infiles",
    "    outputint  infiles",
    "    outputsrv  infiles",
    "    outputext  infiles",
    "",
    "DESCRIPTION",
    "    This module prints all values of all input datasets to standard output.",
    "    All input fields need to have the same horizontal grid. All input files ",
    "    need to have the same structure with the same variables.",
    "    The format of the output depends on the chosen operator.",
    "",
    "OPERATORS",
    "    output     ASCII output",
    "               Prints all values to standard output.",
    "               Each row has 6 elements with the C-style format \"%13.6g\".",
    "    outputf    Formatted output",
    "               Prints all values to standard output.",
    "               The format and number of elements for each row have to be specified by the parameters",
    "               format and nelem. The default for nelem is 1.",
    "    outputint  Integer output",
    "               Prints all values rounded to the nearest integer to standard output.",
    "    outputsrv  SERVICE ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 8 integers (SERVICE likely).",
    "    outputext  EXTRA ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 4 integers (EXTRA likely).",
    "",
    "PARAMETER",
    "    format  STRING  C-style format for one element (e.g. %13.6g)",
    "    nelem   INTEGER Number of elements for each row (default: nelem = 1)",
};

const CdoHelp OutputtabHelp = {
    "NAME",
    "    outputtab - Table output",
    "",
    "SYNOPSIS",
    "    outputtab,parameter  infiles outfile",
    "",
    "DESCRIPTION",
    "    This operator prints a table of all input datasets to standard output.",
    "    infiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    All input fields need to have the same horizontal grid.",
    "    ",
    "    The contents of the table depends on the chosen parameters. The format of each table parameter is keyname[:len].",
    "    len is the optional length of a table entry. The number of significant digits of floating point parameters",
    "    can be set with the CDO option --precision, the default is 7.",
    "    Here is a list of all valid keynames:",
    "    ",
    "     Keyname    & Type    & Description      ",
    "     value      & FLOAT   & Value of the variable [len:8]",
    "     name       & STRING  & Name of the variable [len:8]",
    "     param      & STRING  & Parameter ID (GRIB1: code[.tabnum]; GRIB2: num[.cat[.dis]]) [len:11]",
    "     code       & INTEGER & Code number [len:4]",
    "     x          & FLOAT   & X coordinate of the original grid [len:6]",
    "     y          & FLOAT   & Y coordinate of the original grid [len:6]",
    "     lon        & FLOAT   & Longitude coordinate in degrees [len:6]",
    "     lat        & FLOAT   & Latitude coordinate in degrees [len:6]",
    "     lev        & FLOAT   & Vertical level [len:6]",
    "     xind       & INTEGER & Grid x index [len:4]",
    "     yind       & INTEGER & Grid y index [len:4]",
    "     timestep   & INTEGER & Timestep number [len:6]",
    "     date       & STRING  & Date (format YYYY-MM-DD) [len:10]",
    "     time       & STRING  & Time (format hh:mm:ss) [len:8]",
    "     year       & INTEGER & Year [len:5]",
    "     month      & INTEGER & Month [len:2]",
    "     day        & INTEGER & Day [len:2]",
    "     nohead     & INTEGER & Disable output of header line",
    "",
    "PARAMETER",
    "    parameter  STRING   Comma-separated list of keynames, one for each column of the table",
};

const CdoHelp OutputgmtHelp = {
    "NAME",
    "    gmtxyz, gmtcells - GMT output",
    "",
    "SYNOPSIS",
    "    <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints the first field of the input dataset to standard output.",
    "    The output can be used to generate 2D Lon/Lat plots with GMT.",
    "    The format of the output depends on the chosen operator.",
    "",
    "OPERATORS",
    "    gmtxyz    GMT xyz format",
    "              The operator exports the first field to the GMT xyz ASCII format.",
    "              The output can be used to create contour plots with the GMT module pscontour.",
    "    gmtcells  GMT multiple segment format",
    "              The operator exports the first field to the GMT multiple segment ASCII format.",
    "              The output can be used to create shaded gridfill plots with the GMT module psxy.",
};

const CdoHelp GradsdesHelp = {
    "NAME",
    "    gradsdes - GrADS data descriptor file",
    "",
    "SYNOPSIS",
    "    gradsdes[,mapversion]  infile",
    "",
    "DESCRIPTION",
    "    Creates a GrADS data descriptor file. Supported file formats are GRIB1, NetCDF, SERVICE, ",
    "    EXTRA and IEG. For GRIB1 files the GrADS map file is also generated. For SERVICE and EXTRA",
    "    files the grid have to be specified with the CDO option '-g <grid>'. This module takes infile",
    "    in order to create filenames for the descriptor (infile.ctl) and the map (infile.gmp) file.",
    "",
    "PARAMETER",
    "    mapversion  INTEGER  Format version of the GrADS map file for GRIB1 datasets. Use 1 for a machine",
    "                specific version 1 GrADS map file, 2 for a machine independent version 2 GrADS map file",
    "                and 4 to support GRIB files >2GB. ",
    "                A version 2 map file can be used only with GrADS version 1.8 or newer.",
    "                A version 4 map file can be used only with GrADS version 2.0 or newer.",
    "                The default is 4 for files >2GB, otherwise 2.",
};

const CdoHelp AfterburnerHelp = {
    "NAME",
    "    after - ECHAM standard post processor",
    "",
    "SYNOPSIS",
    "    after[,vct]  infiles outfile",
    "",
    "DESCRIPTION",
    "    The \"afterburner\" is the standard post processor for ECHAM GRIB and NetCDF data which provides the following operations:",
    "    ",
    "    - Extract specified variables and levels",
    "    - Compute derived variables",
    "    - Transform spectral data to Gaussian grid representation",
    "    - Vertical interpolation to pressure levels",
    "    - Compute temporal means",
    "    ",
    "    This operator reads selection parameters as namelist from stdin.",
    "    Use the UNIX redirection \"<namelistfile\" to read the namelist from file.",
    "    ",
    "    The input files can't be combined with other CDO operators because of an optimized reader for this operator.",
    "",
    "NAMELIST",
    "    Namelist parameter and there defaults:",
    "      TYPE=0, CODE=-1, LEVEL=-1, INTERVAL=0, MEAN=0, EXTRAPOLATE=1",
    "    ",
    "    TYPE controls the transformation and vertical interpolation. Transforming spectral data to Gaussian grid",
    "    representation and vertical interpolation to pressure levels are performed in a chain of steps.",
    "    The TYPE parameter may be used to stop the chain at a certain step. Valid values are:",
    "    ",
    "      TYPE  =  0 : Hybrid   level spectral coefficients",
    "      TYPE  = 10 : Hybrid   level fourier  coefficients",
    "      TYPE  = 11 : Hybrid   level zonal mean sections",
    "      TYPE  = 20 : Hybrid   level gauss grids",
    "      TYPE  = 30 : Pressure level gauss grids",
    "      TYPE  = 40 : Pressure level fourier  coefficients",
    "      TYPE  = 41 : Pressure level zonal mean sections",
    "      TYPE  = 50 : Pressure level spectral coefficients",
    "      TYPE  = 60 : Pressure level fourier  coefficients",
    "      TYPE  = 61 : Pressure level zonal mean sections",
    "      TYPE  = 70 : Pressure level gauss grids",
    "    ",
    "    Vorticity, divergence, streamfunction and velocity potential need special treatment in the vertical transformation.",
    "    They are not available as types 30, 40 and 41. If you select one of these combinations, type is automatically",
    "    switched to the equivalent types 70, 60 and 61. The type of all other variables will be switched too, because ",
    "    the type is a global parameter.",
    "    ",
    "    CODE selects the variables by the ECHAM GRIB1 code number (1-255). The default value -1 processes all detected codes.",
    "    Derived variables computed by the afterburner:",
    "    ",
    "    Code  & Name      & Longname                       & Units & Level       & Needed Codes",
    "     34   & low_cld   & low cloud                      &       & single      & 223 on modellevel  ",
    "     35   & mid_cld   & mid cloud                      &       & single      & 223 on modellevel  ",
    "     36   & hih_cld   & high cloud                     &       & single      & 223 on modellevel  ",
    "     131  & u         & u-velocity                     & m/s   & atm (ml+pl) & 138, 155           ",
    "     132  & v         & v-velocity                     & m/s   & atm (ml+pl) & 138, 155           ",
    "     135  & omega     & vertical velocity              & Pa/s  & atm (ml+pl) & 138, 152, 155      ",
    "     148  & stream    & streamfunction                 & m^2/s & atm (ml+pl) & 131, 132           ",
    "     149  & velopot   & velocity potential             & m^2/s & atm (ml+pl) & 131, 132           ",
    "     151  & slp       & mean sea level pressure        & Pa    & surface     & 129, 130, 152       ",
    "     156  & geopoth   & geopotential height            & m     & atm (ml+pl) & 129, 130, 133, 152 ",
    "     157  & rhumidity & relative humidity              &       & atm (ml+pl) & 130, 133, 152      ",
    "     189  & sclfs     & surface solar cloud forcing    &       & surface     & 176-185            ",
    "     190  & tclfs     & surface thermal cloud forcing  &       & surface     & 177-186            ",
    "     191  & sclf0     & top solar cloud forcing        &       & surface     & 178-187             ",
    "     192  & tclf0     & top thermal cloud forcing      &       & surface     & 179-188            ",
    "     259  & windspeed & windspeed                      & m/s   & atm (ml+pl) & sqrt(u*u+v*v)      ",
    "     260  & precip    & total precipitation            &       & surface     & 142+143            ",
    "    ",
    "    LEVEL selects the hybrid or pressure levels. The allowed values depends on the parameter TYPE.",
    "    The default value -1 processes all detected levels.",
    "    ",
    "    INTERVAL selects the processing interval. The default value 0 process data on monthly intervals.",
    "    INTERVAL=1 sets the interval to daily.",
    "    ",
    "    MEAN=1 compute and write monthly or daily mean fields. The default value 0 writes out all timesteps.",
    "    ",
    "    EXTRAPOLATE=0 switch of the extrapolation of missing values during the interpolation from model to pressure",
    "    level (only available with MEAN=0 and TYPE=30). The default value 1 extrapolate missing values.",
    "    ",
    "    Possible combinations of TYPE, CODE and MEAN:",
    "    ",
    "          TYPE   & CODE                    & MEAN",
    "        0/10/11  & 130  temperature        &  0",
    "        0/10/11  & 131  u-velocity         &  0",
    "        0/10/11  & 132  v-velocity         &  0",
    "        0/10/11  & 133  specific humidity  &  0",
    "        0/10/11  & 138  vorticity          &  0",
    "        0/10/11  & 148  streamfunction     &  0",
    "        0/10/11  & 149  velocity potential &  0",
    "        0/10/11  & 152  LnPs               &  0",
    "        0/10/11  & 155  divergence         &  0",
    "         >11     & all codes               &  0/1",
    "",
    "PARAMETER",
    "    vct  STRING  File with VCT in ASCII format",
};

const CdoHelp FilterHelp = {
    "NAME",
    "    bandpass, lowpass, highpass - Time series filtering",
    "",
    "SYNOPSIS",
    "    bandpass,fmin,fmax  infile outfile",
    "    lowpass,fmax  infile outfile",
    "    highpass,fmin  infile outfile",
    "",
    "DESCRIPTION",
    "    This module takes the time series for each gridpoint in infile and (fast fourier) transforms it ",
    "    into the frequency domain. According to the particular operator and its parameters certain frequencies ",
    "    are filtered (set to zero) in the frequency domain and the spectrum is (inverse fast fourier) transformed ",
    "    back into the time domain.",
    "    To determine the frequency the time-axis of infile is used. (Data should have a constant time increment ",
    "    since this assumption applies for transformation. However, the time increment has to be different from zero.)",
    "    All frequencies given as parameter are interpreted per year. This is done by the assumption of a 365-day calendar. ",
    "    Consequently if you want to perform multiyear-filtering accurately you have to delete the 29th of February. ",
    "    If your infile has a 360 year calendar the frequency parameters fmin respectively fmax should be ",
    "    multiplied with a factor of 360/365 in order to obtain accurate results.  ",
    "    For the set up of a frequency filter the frequency parameters have to be adjusted to a frequency in the data. ",
    "    Here fmin is rounded down and fmax is always rounded up. Consequently it is possible to use bandpass with ",
    "    fmin=fmax without getting a zero-field for outfile. ",
    "    Hints for efficient usage: ",
    "    - to get reliable results the time-series has to be detrended (cdo detrend)",
    "    - the lowest frequency greater zero that can be contained in infile is 1/(N*dT), ",
    "    - the greatest frequency is 1/(2dT) (Nyquist frequency),",
    "    with N the number of timesteps and dT the time increment of infile in years.",
    "    ",
    "    Missing value support for operators in this module is not implemented, yet!",
    "",
    "OPERATORS",
    "    bandpass  Bandpass filtering",
    "              Bandpass filtering (pass for frequencies between fmin and fmax).",
    "              Suppresses all variability outside the frequency range specified by [fmin,fmax].",
    "    lowpass   Lowpass filtering",
    "              Lowpass filtering (pass for frequencies lower than fmax).",
    "              Suppresses all variability with frequencies greater than fmax. ",
    "    highpass  Highpass filtering",
    "              Highpass filtering (pass for frequencies greater than fmin). ",
    "              Suppresses all variabilty with frequencies lower than fmin. ",
    "",
    "PARAMETER",
    "    fmin  FLOAT	Minimum frequency per year that passes the filter.",
    "    fmax  FLOAT	Maximum frequency per year that passes the filter.  ",
    "",
    "NOTE",
    "    For better performace of these operators use the CDO configure option --with-fftw3.",
};

const CdoHelp GridcellHelp = {
    "NAME",
    "    gridarea, gridweights - Grid cell quantities",
    "",
    "SYNOPSIS",
    "    gridarea[,radius]  infile outfile",
    "    gridweights  infile outfile",
    "",
    "DESCRIPTION",
    "    This module reads the grid cell area of the first grid from the input stream. If the grid cell area is missing it",
    "    will be computed from the grid coordinates. The area of a grid cell is calculated using spherical triangles from",
    "    the coordinates of the center and the vertices. The base is a unit sphere which is scaled with the radius of the planet.",
    "    The default planet radius is 6371000 meter. The parameter radius or the environment variable PLANET_RADIUS can be used to change the default.",
    "    Depending on the chosen operator the grid cell area or weights are written to the output stream.",
    "",
    "OPERATORS",
    "    gridarea     Grid cell area",
    "                 Writes the grid cell area to the output stream. If the grid cell area have to",
    "                 be computed it is scaled with the planet radius to square meters.",
    "    gridweights  Grid cell weights",
    "                 Writes the grid cell area weights to the output stream.",
    "",
    "PARAMETER",
    "    radius  FLOAT   Planet radius in meter",
    "",
    "ENVIRONMENT",
    "    PLANET_RADIUS",
    "        This variable is used to scale the computed grid cell areas to square meters. ",
    "        By default PLANET_RADIUS is set to an earth radius of 6371000 meter.",
};

const CdoHelp SmoothHelp = {
    "NAME",
    "    smooth, smooth9 - Smooth grid points",
    "",
    "SYNOPSIS",
    "    smooth[,options]  infile outfile",
    "    smooth9  infile outfile",
    "",
    "DESCRIPTION",
    "    Smooth all grid points of a horizontal grid.",
    "    Options is a comma-separated list of \"key=value\" pairs with optional parameters.",
    "",
    "OPERATORS",
    "    smooth   Smooth grid points",
    "             Performs a N point smoothing on all input fields. The number of points used depend",
    "             on the search radius (radius) and the maximum number of points (maxpoints).",
    "             Per default all points within the search radius of 1degree are used.",
    "             The weights for the points depend on the form of the curve and the distance.",
    "             The implemented form of the curve is linear with constant default weights of 0.25",
    "             at distance 0 (weight0) and at the search radius (weightR).",
    "    smooth9  9 point smoothing",
    "             Performs a 9 point smoothing on all fields with a quadrilateral curvilinear grid.",
    "             The result at each grid point is a weighted average of the grid point plus",
    "             the 8 surrounding points. The center point receives a weight of 1.0, the ",
    "             points at each side and above and below receive a weight of 0.5, and corner ",
    "             points receive a weight of 0.3.",
    "             All 9 points are multiplied by their weights and summed, then divided by ",
    "             the total weight to obtain the smoothed value. Any missing data points are ",
    "             not included in the sum; points beyond the grid boundary are considered to ",
    "             be missing. Thus the final result may be the result of an averaging with less ",
    "             than 9 points.",
    "",
    "PARAMETER",
    "    nsmooth    INTEGER  Number of times to smooth, default nsmooth=1",
    "    radius     STRING   Search radius, default radius=1deg (units: deg, rad, km, m)",
    "    maxpoints  INTEGER  Maximum number of points, default maxpoints=<gridsize>",
    "    form       STRING   Form of the curve, default form=linear",
    "    weight0    FLOAT    Weight at distance 0, default weight0=0.25",
    "    weightR    FLOAT    Weight at the search radius, default weightR=0.25",
};

const CdoHelp DeltatHelp = {
    "NAME",
    "    deltat - Difference between timesteps",
    "",
    "SYNOPSIS",
    "    deltat  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator computes the difference between each timestep.",
};

const CdoHelp ReplacevaluesHelp = {
    "NAME",
    "    setvals, setrtoc, setrtoc2 - Replace variable values",
    "",
    "SYNOPSIS",
    "    setvals,oldval,newval[,...]  infile outfile",
    "    setrtoc,rmin,rmax,c  infile outfile",
    "    setrtoc2,rmin,rmax,c,c2  infile outfile",
    "",
    "DESCRIPTION",
    "    This module replaces old variable values with new values, depending on the operator.",
    "",
    "OPERATORS",
    "    setvals   Set list of old values to new values",
    "              Supply a list of n pairs of old and new values.",
    "    setrtoc   Set range to constant",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ i(t,x) if i(t,x) LT rmin AND i(t,x) GT rmax",
    "    setrtoc2  Set range to constant others to constant2",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ c2     if i(t,x) LT rmin AND i(t,x) GT rmax",
    "",
    "PARAMETER",
    "    oldval,newval,...  FLOAT   Pairs of old and new values",
    "    rmin               FLOAT   Lower bound",
    "    rmax               FLOAT   Upper bound",
    "    c                  FLOAT   New value - inside range",
    "    c2                 FLOAT   New value - outside range",
};

const CdoHelp GetgridcellHelp = {
    "NAME",
    "    gridcellindex - Get grid cell index",
    "",
    "SYNOPSIS",
    "    gridcellindex[,parameter]  infile",
    "",
    "DESCRIPTION",
    "    Get the grid cell index of one grid point selected by the parameter lon and lat.",
    "",
    "PARAMETER",
    "    lon  INTEGER   Longitude of the grid cell in degree",
    "    lat  INTEGER   Latitude of the grid cell in degree",
};

const CdoHelp VargenHelp = {
    "NAME",
    "    const, random, topo, seq, stdatm - Generate a field",
    "",
    "SYNOPSIS",
    "    const,const,grid  outfile",
    "    random,grid[,seed]  outfile",
    "    topo[,grid]  outfile",
    "    seq,start,end[,inc]  outfile",
    "    stdatm,levels  outfile",
    "",
    "DESCRIPTION",
    "    Generates a dataset with one or more fields",
    "",
    "OPERATORS",
    "    const   Create a constant field",
    "            Creates a constant field. All field elements of the grid have the same value.",
    "    random  Create a field with random numbers",
    "            Creates a field with rectangularly distrubuted random numbers in the interval [0,1].",
    "    topo    Create a field with topography",
    "            Creates a field with topography data, per default on a global half degree grid.",
    "    seq     Create a time series",
    "            Creates a time series with field size 1 and field elements beginning with a start value in time step 1",
    "            which is increased from one time step to the next.",
    "    stdatm  Create values for pressure and temperature for hydrostatic atmosphere",
    "            Creates pressure and temperature values for the given list of vertical levels.",
    "            The formulas are:",
    "            ",
    "            P(z) = P_0 * exp(-1 * g/R * H/T_0 * log( (exp(z/H)*T_0 + T_Delta)/(T_0 + T_Delta))",
    "            T(z) = T_0 + T_Delta * exp(-z/H)",
    "            ",
    "            with the following constants",
    "            ",
    "            T_0     = 213 K           Offset to get a surface temperature of 288K",
    "            T_Delta = 75 K            Temperature lapse rate for 10Km",
    "            P_0     = 1013.25 hPa     Surface pressure",
    "            H       = 10000.0 m       Scale height",
    "            g       = 9.80665 m/s**2  Earth gravity",
    "            R       = 287.05 J/kg*K   Gas constant for air",
    "            ",
    "            This is the solution for the hydrostatic equations and is only valid for the",
    "            troposphere (constant positive lapse rate). The temperature increase in the",
    "            stratosphere and other effects of the upper atmosphere are not taken into",
    "            account.",
    "",
    "PARAMETER",
    "    const   FLOAT   Constant",
    "    seed    INTEGER The seed for a new sequence of pseudo-random numbers [default: 1]",
    "    grid    STRING  Target grid description file or name",
    "    start   FLOAT   Start value of the loop",
    "    end     FLOAT   End value of the loop",
    "    inc     FLOAT   Increment of the loop [default: 1]",
    "    levels  FLOAT   Target levels in metre above surface",
};

const CdoHelp TimsortHelp = {
    "NAME",
    "    timsort - Timsort",
    "",
    "SYNOPSIS",
    "    timsort  infile outfile",
    "",
    "DESCRIPTION",
    "    Sorts the elements in ascending order over all timesteps for every field position.",
    "    After sorting it is:",
    "    ",
    "    o(t_1,x) <= o(t_2,x)      forall (t_1<t_2),x",
};

const CdoHelp WindTransHelp = {
    "NAME",
    "    uvDestag, rotuvNorth, projuvLatLon - Wind Transformation",
    "",
    "SYNOPSIS",
    "    uvDestag,u,v[,-/+0.5[,-/+0.5]]  infile outfile",
    "    rotuvNorth,u,v  infile outfile",
    "    projuvLatLon,u,v  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains special operators for datsets with wind components on a rotated lon/lat grid, ",
    "    e.g. data from the regional model HIRLAM or REMO. ",
    "",
    "OPERATORS",
    "    uvDestag      Destaggering of u/v wind components",
    "                  This is a special operator for destaggering of wind components.",
    "                  If the file contains a grid with temperature (name='t' or code=11)",
    "                  then grid_temp will be used for destaggered wind.",
    "    rotuvNorth    Rotate u/v wind to North pole.",
    "                  This is an operator for transformation of wind-vectors from grid-relative to north-pole",
    "                  relative for the whole file. (FAST implementation with JACOBIANS)",
    "    projuvLatLon  Cylindrical Equidistant projection",
    "                  Thus is an operator for transformation of wind-vectors from the globe-spherical coordinate system",
    "                  into a flat Cylindrical Equidistant (lat-lon) projection. (FAST JACOBIAN implementation)",
    "",
    "PARAMETER",
    "    u,v            STRING  Pair of u,v wind components (use variable names or code numbers)",
    "    -/+0.5,-/+0.5  STRING  Destaggered grid offsets are optional (default -0.5,-0.5)",
};

const CdoHelp RotuvbHelp = {
    "NAME",
    "    rotuvb - Rotation",
    "",
    "SYNOPSIS",
    "    rotuvb,u,v,...  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for datsets with wind components on a rotated grid, ",
    "    e.g. data from the regional model REMO. It performs a backward transformation of ",
    "    velocity components U and V from a rotated spherical system to a geographical system.",
    "",
    "PARAMETER",
    "    u,v,...  STRING  Pairs of zonal and meridional velocity components (use variable names or code numbers)",
    "",
    "NOTE",
    "    This is a specific implementation for data from the REMO model, it may not work with data from other sources.",
};

const CdoHelp MrotuvbHelp = {
    "NAME",
    "    mrotuvb - Backward rotation of MPIOM data",
    "",
    "SYNOPSIS",
    "    mrotuvb  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    MPIOM data are on a rotated Arakawa C grid. The velocity components U and V are located on",
    "    the edges of the cells and point in the direction of the grid lines and rows.",
    "    With mrotuvb the velocity vector is rotated in latitudinal and longitudinal direction.",
    "    Before the rotation, U and V are interpolated to the scalar points (cell center).",
    "    U is located with the coordinates for U in infile1 and V in infile2.",
    "    mrotuvb assumes a positive meridional flow for a flow from grid point(i,j) to grid point(i,j+1)",
    "    and positive zonal flow for a flow from grid point(i+1,j) to point(i,j).",
    "",
    "NOTE",
    "    This is a specific implementation for data from the MPIOM model, it may not work with data from other sources.",
};

const CdoHelp MastrfuHelp = {
    "NAME",
    "    mastrfu - Mass stream function",
    "",
    "SYNOPSIS",
    "    mastrfu  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the atmospheric general circulation",
    "    model ECHAM. It computes the mass stream function (code=272). The input dataset have ",
    "    to be a zonal mean of v-velocity [m/s] (code=132) on pressure levels.",
};

const CdoHelp PressureHelp = {
    "NAME",
    "    pressure_half, pressure, delta_pressure - Pressure on model levels",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to calculate the pressure on model levels.",
    "    To calculate the pressure on model levels, the a and b coefficients defining the model levels and",
    "    the surface pressure are required. The a and b coefficients are normally part of the model level data.",
    "    If not available, the surface pressure can be derived from the logarithm of the surface pressure.",
    "    The surface pressure is identified by the GRIB1 code number or NetCDF CF standard name.",
    "    ",
    "     Name                       & Units      & GRIB1 code & CF standard name",
    "       log surface pressure     &  Pa        &  152       &",
    "       surface pressure         &  Pa        &  134       &  surface_air_pressure",
    "    ",
    "",
    "OPERATORS",
    "    pressure_half   Pressure on half-levels",
    "                    This operator computes the pressure on model half-levels in pascal.",
    "                    The model half-level pressure (p_half) is given by:",
    "                    ",
    "                    ",
    "                            p_half = a + b ∗ sp",
    "                    ",
    "                    with",
    "                       a, b: coefficients defining the model levels",
    "                       sp: surface pressure",
    "    pressure        Pressure on full-levels",
    "                    This operator computes the pressure on model full-levels in pascal.",
    "                    The pressure on model full-levels (p_full) is in the middle of the layers defined by the model half-levels:",
    "                    ",
    "                            p_full = (p_half_above + p_half_below) / 2",
    "                    ",
    "    delta_pressure  Pressure difference of half-levels",
    "                    This operator computes the pressure difference between to model half-levels.",
    "                    ",
    "                            delta_p = p_half_below - p_half_above",
    "                    ",
};

const CdoHelp DeriveparHelp = {
    "NAME",
    "    sealevelpressure, gheight, gheight_half - Derived model parameters",
    "",
    "SYNOPSIS",
    "    <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators that calculate derived model parameters. These are currently the parameters",
    "    sea level pressure and geopotential height. All necessary input variables are identified by their GRIB1",
    "    code number or the NetCDF CF standard name.",
    "    Supported GRIB1 parameter tables are: WMO standard table number 2 and ECMWF local table number 128.",
    "    ",
    "     CF standard name            & Units      & GRIB 1 code      ",
    "       surface_air_pressure      &  Pa        &  134",
    "       air_temperature           &  K         &  130",
    "       specific_humidity         &  kg/kg     &  133",
    "       surface_geopotential      &  m2 s-2    &  129",
    "       geopotential_height       &  m         &  156",
    "    ",
    "",
    "OPERATORS",
    "    sealevelpressure  Sea level pressure",
    "                      This operator computes the sea level pressure (air_pressure_at_sea_level). Required input fields",
    "                      are surface_air_pressure, surface_geopotential and air_temperature on full hybrid sigma pressure levels.",
    "    gheight           Geopotential height on full-levels",
    "                      This operator computes the geopotential height (geopotential_height) on model full-levels in metres.",
    "                      Required input fields are surface_air_pressure, surface_geopotential, specific_humidity and air_temperature",
    "                      on full hybrid sigma pressure levels. Note, this procedure is an approximation, which doesn't take into",
    "                      account the effects of e.g. cloud ice and water, rain and snow.",
    "    gheight_half      Geopotential height on half-levels",
    "                      This operator computes the geopotential height (geopotential_height) on model half-levels in metres.",
    "                      Required input fields are surface_air_pressure, surface_geopotential, specific_humidity and air_temperature",
    "                      on full hybrid sigma pressure levels. Note, this procedure is an approximation, which doesn't take into",
    "                      account the effects of e.g. cloud ice and water, rain and snow.",
};

const CdoHelp AdisitHelp = {
    "NAME",
    "    adisit, adipot - Potential temperature to in-situ temperature and vice versa",
    "",
    "SYNOPSIS",
    "    <operator>[,pressure]  infile outfile",
    "",
    "DESCRIPTION",
    "",
    "OPERATORS",
    "    adisit  Potential temperature to in-situ temperature",
    "            This is a special operator for the post processing of the ocean and sea ice model MPIOM.",
    "            It converts potential temperature adiabatically to in-situ temperature to(t, s, p).",
    "            Required input fields are sea water potential temperature (name=tho; code=2) and sea water salinity (name=sao; code=5).",
    "            Pressure is calculated from the level information or can be specified by the optional parameter.",
    "            Output fields are sea water temperature (name=to; code=20) and sea water salinity (name=s; code=5).",
    "    adipot  In-situ temperature to potential temperature",
    "            This is a special operator for the post processing of the ocean and sea ice model MPIOM.",
    "            It converts in-situ temperature to potential temperature tho(to, s, p). Required input fields",
    "            are sea water in-situ temperature (name=t; code=2) and sea water salinity (name=sao,s; code=5).",
    "            Pressure is calculated from the level information or can be specified by the optional parameter.",
    "            Output fields are sea water temperature (name=tho; code=2) and sea water salinity (name=s; code=5).",
    "",
    "PARAMETER",
    "    pressure  FLOAT   Pressure in bar (constant value assigned to all levels)",
};

const CdoHelp RhopotHelp = {
    "NAME",
    "    rhopot - Calculates potential density",
    "",
    "SYNOPSIS",
    "    rhopot[,pressure]  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the ocean and sea ice model MPIOM.",
    "    It calculates the sea water potential density (name=rhopoto; code=18). Required input fields ",
    "    are sea water in-situ temperature (name=to; code=20) and sea water salinity (name=sao; code=5).",
    "    Pressure is calculated from the level information or can be specified by the optional parameter.",
    "",
    "PARAMETER",
    "    pressure  FLOAT   Pressure in bar (constant value assigned to all levels)",
};

const CdoHelp HistogramHelp = {
    "NAME",
    "    histcount, histsum, histmean, histfreq - Histogram",
    "",
    "SYNOPSIS",
    "    <operator>,bounds  infile outfile",
    "",
    "DESCRIPTION",
    "    This module creates bins for a histogram of the input data.",
    "    The bins have to be adjacent and have non-overlapping intervals.",
    "    The user has to define the bounds of the bins. The first value",
    "    is the lower bound and the second value the upper bound of the",
    "    first bin. The bounds of the second bin are defined by the",
    "    second and third value, aso.",
    "    Only 2-dimensional input fields are allowed. The output file ",
    "    contains one vertical level for each of the bins requested.",
    "",
    "OPERATORS",
    "    histcount  Histogram count",
    "               Number of elements in the bin range.",
    "    histsum    Histogram sum",
    "               Sum of elements in the bin range.",
    "    histmean   Histogram mean",
    "               Mean of elements in the bin range.",
    "    histfreq   Histogram frequency",
    "               Relative frequency of elements in the bin range.",
    "",
    "PARAMETER",
    "    bounds  FLOAT  Comma-separated list of the bin bounds (-inf and inf valid)",
};

const CdoHelp SethaloHelp = {
    "NAME",
    "    sethalo - Set the bounds of a field",
    "",
    "SYNOPSIS",
    "    sethalo[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets the boundary in the east, west, south and north of the rectangular understood fields.",
    "    Positive values of the parameters increase the boundary in the selected direction. Negative values",
    "    decrease the field at the selected boundary. The new rows and columns are filled with the missing value.",
    "    With the optional parameter value a different fill value can be used. Global cyclic fields are filled",
    "    cyclically at the east and west borders, if the fill value is not set by the user.",
    "",
    "PARAMETER",
    "    east   INTEGER  East halo",
    "    west   INTEGER  West halo",
    "    south  INTEGER  South halo",
    "    north  INTEGER  North halo",
    "    value  FLOAT    Fill value (default is the missing value)",
};

const CdoHelp WctHelp = {
    "NAME",
    "    wct - Windchill temperature",
    "",
    "SYNOPSIS",
    "    wct  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 and infile2 be time series of temperature and wind",
    "    speed records, then a corresponding time series of resulting windchill",
    "    temperatures is written to outfile. The wind chill temperature",
    "    calculation is only valid for a temperature of T <= 33 °C and a wind speed",
    "    of v >= 1.39 m/s. Whenever these conditions are not satisfied, a missing",
    "    value is written to outfile. Note that temperature and wind speed records",
    "    have to be given in units of °C and m/s, respectively.",
};

const CdoHelp FdnsHelp = {
    "NAME",
    "    fdns - Frost days where no snow index per time period",
    "",
    "SYNOPSIS",
    "    fdns  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN",
    "    and infile2 be a corresponding series of daily surface snow",
    "    amounts. Then the number of days where TN < 0 °C and the surface ",
    "    snow amount is less than 1 cm is counted. The temperature TN",
    "    have to be given in units of Kelvin.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
};

const CdoHelp StrwinHelp = {
    "NAME",
    "    strwin - Strong wind days index per time period",
    "",
    "SYNOPSIS",
    "    strwin[,v]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX > v is counted. The horizontal wind",
    "    speed v is an optional parameter with default v = 10.5 m/s. A further",
    "    output variable is the maximum number of consecutive days with maximum wind",
    "    speed greater than or equal to v. Note that both VX and v have to be given in",
    "    units of m/s. Also note that the horizontal wind speed is defined as the",
    "    square root of the sum of squares of the zonal and meridional wind speeds.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    v  FLOAT   Horizontal wind speed threshold (m/s, default v = 10.5 m/s)",
};

const CdoHelp StrbreHelp = {
    "NAME",
    "    strbre - Strong breeze days index per time period",
    "",
    "SYNOPSIS",
    "    strbre  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 10.5 m/s ",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 10.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
};

const CdoHelp StrgalHelp = {
    "NAME",
    "    strgal - Strong gale days index per time period",
    "",
    "SYNOPSIS",
    "    strgal  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 20.5 m/s ",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 20.5 m/s. Note that",
    "    VX is defined as the square root of the sum of square of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
};

const CdoHelp HurrHelp = {
    "NAME",
    "    hurr - Hurricane days index per time period",
    "",
    "SYNOPSIS",
    "    hurr  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 32.5 m/s",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 32.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
};

const CdoHelp CMORliteHelp = {
    "NAME",
    "    cmorlite - CMOR lite",
    "",
    "SYNOPSIS",
    "    cmorlite,table[,convert]  infile outfile",
    "",
    "DESCRIPTION",
    "    The CMOR (Climate Model Output Rewriter) library comprises a set of",
    "    functions, that can be used to produce CF-compliant NetCDF files that ",
    "    fulfill the requirements of many of the climate community's standard",
    "    model experiments. These experiments are collectively referred to as",
    "    MIP's. Much of the metadata written to the output files is defined in",
    "    MIP-specific tables, typically made available from each MIP's web site.",
    "    ",
    "    The CDO operator cmorlite process the header and variable section",
    "    of such MIP tables and writes the result with the internal IO library CDI.",
    "    In addition to the CMOR 2 and 3 table format, the CDO parameter table format",
    "    is also supported. The following parameter table entries are available:",
    "    ",
    "     Entry           & Type        & Description      ",
    "     name            & WORD        & Name of the variable",
    "     out_name        & WORD        & New name of the variable",
    "     type            & WORD        & Data type (real or double)",
    "     standard_name   & WORD        & As defined in the CF standard name table",
    "     long_name       & STRING      & Describing the variable",
    "     units           & STRING      & Specifying the units for the variable",
    "     comment         & STRING      & Information concerning the variable",
    "     cell_methods    & STRING      & Information concerning calculation of means or climatologies",
    "     cell_measures   & STRING      & Indicates the names of the variables containing cell areas and volumes",
    "     missing_value   & FLOAT       & Specifying how missing data will be identified",
    "     valid_min       & FLOAT       & Minimum valid value",
    "     valid_max       & FLOAT       & Maximum valid value",
    "     ok_min_mean_abs & FLOAT       & Minimum absolute mean",
    "     ok_max_mean_abs & FLOAT       & Maximum absolute mean",
    "     factor          & FLOAT       & Scale factor",
    "     delete          & INTEGER     & Set to 1 to delete variable",
    "     convert         & INTEGER     & Set to 1 to convert the unit if necessary",
    "    ",
    "    Most of the above entries are stored as variables attributes, some of them are handled differently.",
    "    The variable name is used as a search key for the parameter table. valid_min, valid_max,",
    "    ok_min_mean_abs and ok_max_mean_abs are used to check the range of the data.",
    "",
    "PARAMETER",
    "    table    STRING   Name of the CMOR table as specified from PCMDI",
    "    convert  STRING   Converts the units if necessary",
};

const CdoHelp VerifygridHelp = {
    "NAME",
    "    verifygrid - Verify grid coordinates",
    "",
    "SYNOPSIS",
    "    verifygrid  infile",
    "",
    "DESCRIPTION",
    "    This operator verifies the coordinates of all horizontal grids found in infile.",
    "    Among other things, it searches for duplicate cells, non-convex cells,",
    "    and whether the center is located outside the cell bounds.",
    "    Use the CDO option -v to output the position of these cells.",
    "    This information can be useful to avoid problems when interpolating the data.",
};

const CdoHelp HealpixHelp = {
    "NAME",
    "    hpdegrade, hpupgrade - Change healpix resolution",
    "",
    "SYNOPSIS",
    "    <operator>,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    Degrade or upgrade the resolution of a healpix grid.",
    "",
    "OPERATORS",
    "    hpdegrade  Degrade healpix",
    "               Degrade the resolution of a healpix grid. The value of the target pixel is the mean of the source pixels.",
    "    hpupgrade  Upgrade healpix",
    "               Upgrade the resolution of a healpix grid. The values of the target pixels is the value of the source pixel.",
    "",
    "PARAMETER",
    "    nside  INTEGER The nside of the target healpix, must be a power of two [default: same as input].",
    "    order  STRING  Pixel ordering of the target healpix ('nested' or 'ring').",
    "    power  FLOAT   If non-zero, divide the result by (nside[in]/nside[out])**power. power=-2 keeps the sum of the map invariant.",
};

const CdoHelp NCL_windHelp = {
    "NAME",
    "    uv2vr_cfd, uv2dv_cfd - Wind transformation",
    "",
    "SYNOPSIS",
    "    <operator>[,u,v,boundOpt,outMode]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains CDO operators with an interface to NCL functions.",
    "    The corresponding NCL functions have the same name. A more detailed description",
    "    of those NCL function can be found on the NCL homepage https://www.ncl.ucar.edu.",
    "",
    "OPERATORS",
    "    uv2vr_cfd  U and V wind to relative vorticity",
    "               Computes relative vorticity for a latitude-longitude grid using centered finite differences.",
    "               The grid need not be global and missing values are allowed.",
    "    uv2dv_cfd  U and V wind to divergence",
    "               Computes divergence for a latitude-longitude grid using centered finite differences.",
    "               The grid need not be global and missing values are allowed.",
    "",
    "PARAMETER",
    "    u         STRING   Name of variable u (default: u)",
    "    v         STRING   Name of variable v (default: v)",
    "    boundOpt  INTEGER  Boundary condition option (0-3) (default: 0/1 for cyclic grids)",
    "    outMode   STRING   Output mode new/append (default: new)",
};

const CdoHelp CMORHelp = {
    "NAME",
    "    cmor - Climate Model Output Rewriting to produce CMIP-compliant data",
    "",
    "SYNOPSIS",
    "    cmor,MIPtable[,cmor_name=VarList[,key=value[,...]]]  infile",
    "",
    "DESCRIPTION",
    "    ",
    "    ",
    "    The CDO operator cmor converts an infile into a CMIP-compliant format",
    "    by using the CMOR library. Each output file contains a single output variable.",
    "    The name of the output files are generated by CMOR according to a template based on the",
    "    DRS (Data reference Syntax) of the project. CMOR checks and applies the information delivered",
    "    through the project dependend MIPtable on the infile. Additional information",
    "    which is required for the conversion can be configured via keyvalues as optional parameters.",
    "    ",
    "    By specifying a variable selector keyvalue, e.g. cmor_name=tas, the user can",
    "    pre-select a subset of infile variables. If name or code is specified, a",
    "    corresponding cmor_name which can also be found in the MIPtable is also",
    "    required to map the infile variable to the CMOR-variable. For mapping more",
    "    variables at the operator call, one can specify a mapping table via keyword mapping_table.",
    "    ",
    "    Global attributes must be collected in info files and can be specified via keyword",
    "    info. All required and optional global attributes as well as information",
    "    about table file formats are given in the 'cdo cmor manual'.",
    "    ",
    "    If questions remain, do not hesitate to ask and send an email to wachsmannATdkrz.de.",
    "    ",
    "",
    "PARAMETER",
    "    MIPtable                   STRING    Name of the MIP table as used by CMOR.",
    "                               --------------------------------------------------------------------------------------------",
    "    cmor_name           | cn   STRING    Variable selector and specified in the MIP table.",
    "                                         Comma-separated list of CMOR variable names.",
    "                                         Default is to process all variables.",
    "    name                | n    STRING    Variable selector.",
    "                                         Name of a selected @file{infile} variable.",
    "    code                | c    INTEGER   Variable selector. ",
    "                                         Three digits (GRIB) Code of a selected @file{infile} variable.",
    "                               --------------------------------------------------------------------------------------------",
    "    info                | i    STRING    Preprozessing.",
    "                                         Comma-separated list of filenames.",
    "                                         Containins global attributes and control keywords.",
    "                                         Default: CWD/.cdocmorinfo",
    "    grid_info           | gi   STRING    Preprozessing.",
    "                                         NetCDF or table formatted file with model grid description.",
    "                                         Horizontal and vertical axes are substituted with the ones from grid info file.",
    "    mapping_table       | mt   STRING    Preprozessing.",
    "                                         Fortran Namelist containing variable information for e.g. renaming.",
    "    keep_all_attributes | kaa  STRING    Preprozessing.",
    "                                         'y' for passing all infile attributes. 'n' for discarding all infile attributes.",
    "                               --------------------------------------------------------------------------------------------",
    "    drs                 | d    CHARACTER Output control.",
    "                                         Do(=y, default) or do not(=n) move output into the project DRS structure.",
    "    drs_root            | dr   STRING    Output control. CMOR output root directory.",
    "                                         Default: CWD.",
    "    output_mode         | om   CHARACTER Output control.",
    "                                         Either 'r' for replace (default) or 'a' for append mode.",
    "    last_chunk          | lc   STRING    Output control. Filename of chunk to which shall be appended.  ",
    "    max_size            | ms   INTEGER   Output control. Limit of output file sie in GigaByte.",
    "    deflate_level       | dl   INTEGER   Output control. Compression level. -1: No compression. 0: Only shuffle.",
    "    version_date        | vd   INTEGER   Output control. Subdirectory name in CMIP6 DRS.",
    "                               --------------------------------------------------------------------------------------------",
    "    required_time_units | rtu  STRING    Temporal description.",
    "                                         Time axis reference date specified by the experiment.",
    "                                         Format: 'days since YYYY-day-month hh:mm:ss'.",
    "    cell_methods        | cm   CHARACTER Temporal description.",
    "                                         Cell_methods of time axis.",
    "                                         Value is one of 'm' (default)  , 'p', 'c', 'n', 'd'",
    "                               --------------------------------------------------------------------------------------------",
    "    units               | u    STRING    Variable attrbiute. Units of the variable.",
    "                                         Must be known by library UDunits.",
    "    variable_comment    | vc   STRING    Variable attribute. Variable comment.",
    "    positive            | p    CHARACTER Variable attrbiute.",
    "                                         Positive flux direction, either 'u' for upward or 'd' for downward.",
    "    z_axis              | za   STRING    Name of the coordinate variable associated with",
    "                                         the z-axis of the target variable.",
    "    character_axis      | ca   STRING    Name of the coordinate variable associated with",
    "                                         a character axis of the target variable.",
    "                                         Valid axes names are: basin, vegtype or oline. ",
    "    t_axis              | ta   STRING    Sets time values and time bounds to the nearest value",
    "                                         required by the project given by the value of t_axis.",
    "                                         Valid value is: cmip",
};

const CdoHelp MagplotHelp = {
    "NAME",
    "    contour, shaded, grfill - Lat/Lon plot",
    "",
    "SYNOPSIS",
    "    <operator>,parameter  infile obase",
    "",
    "DESCRIPTION",
    "    The operators in this module generates 2D Lon/Lat plots.",
    "    The data for the plot is read from infile.",
    "    Only data on rectilinear Lon/Lat grids are supported.",
    "    The output file will be named <obase>_<param>.<device> where param is the parameter name and",
    "    device is the device name. The default output file format is postscript,",
    "    this can be changed with the device parameter.",
    "    The type of the plot depends on the choosen operator.",
    "    ",
    "    Here is a list of all common plot parameters:",
    "    ",
    "     Keyname     & Type    & Description      ",
    "     device      & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     projection  & STRING  & Projection (cylindrical, polar_stereographic, robinson, mercator)",
    "     style       & STRING  & Contour line style (solid, dash, dot, chain_dash, chain_dot)",
    "     min         & FLOAT   & Minimum value",
    "     max         & FLOAT   & Maximum value",
    "     lon_max     & FLOAT   & Maximum longitude of the image",
    "     lon_min     & FLOAT   & Minimum longitude of the image",
    "     lat_max     & FLOAT   & Maximum latitude of the image",
    "     lat_min     & FLOAT   & Minimum latitude of the image",
    "     count       & INTEGER & Number of Contour levels / Colour bands  ",
    "     interval    & FLOAT   & Interval in data units between two bands lines",
    "     list        & INTEGER & List of levels to be plotted",
    "     RGB         & STRING  & TRUE or FALSE, to  indicate, if the input colour is in RGB format",
    "     step_freq   & INTEGER & Frequency of time steps to be considered for making the animation",
    "                 &         & (device=gif_animation). Default value is \"1\" (all time steps).",
    "                 &         & Will be ignored if input file has multiple variables.",
    "     file_split  & STRING  & TRUE or FALSE, to split the output file for each variable, if input has",
    "                 &         & multiple variables. Default value is \"FALSE\". Valid only for \"PS\" format.",
    "",
    "OPERATORS",
    "    contour  Contour plot",
    "             The operator contour generates the discrete contour lines of the input field values.",
    "             The following additional parameters are valid for contour operator,",
    "             module in addition to the common plot parameters:",
    "             ",
    "              Keyname      & Type    & Description      ",
    "              colour       & STRING  & Colour for drawing the contours",
    "              thickness    & FLOAT   & Thickness of the contour line",
    "              style        & STRING  & Line Style can be \"SOLID\", \"DASH\", \"DOT\", \"CHAIN_DASH\",",
    "                           &         & \"CHAIN_DOT\"",
    "    shaded   Shaded contour plot",
    "             The operator shaded generates the filled contours of the given input field values.",
    "             The following additional parameters are valid for shaded contour and gridfill operator,",
    "             in addition to the common plot parameters.",
    "             ",
    "              Keyname      & Type    & Description      ",
    "              colour_min   & STRING  & Colour for the Minimum colour band",
    "              colour_max   & STRING  & Colour for the Minimum colour band",
    "              colour_triad & STRING  & Direction of colour sequencing for shading \"CW\" or \"ACW\",",
    "                           &         & to denote \"clockwise\" and \"anticlockwise\" respectively.",
    "                           &         & To be used in conjunction with \"colour_min\", \"colour_max\"",
    "                           &         & options. Default is \"ACW\"",
    "              colour_table & STRING  & File with user specified colours with the format as",
    "             ",
    "             Example file for 6 colours in RGB format:",
    "             	6",
    "             	RGB(0.0;0.0;1.0)",
    "             	RGB(0.0;0.0;0.5)",
    "             	RGB(0.0;0.5;0.5)",
    "             	RGB(0.0;1.0;0.0)",
    "             	RGB(0.5;0.5;0.0)",
    "             	RGB(1.0;0.0;0.0)",
    "             ",
    "    grfill   Shaded gridfill plot",
    "             The operator grfill is similar to satellite imaging and shades each cell (pixel) according",
    "             to the value of the field at that cell.",
    "",
    "PARAMETER",
    "    parameter  STRING   Comma-separated list of plot parameters",
    "",
    "NOTE",
    "    All colour parameter can be either standard name or in RGB format.",
    "    The valid standard name strings for \"colour\" are:",
    "    ",
    "    \"red\", \"green\", \"blue\", \"yellow\", \"cyan\", \"magenta\", \"black\", \"avocado\", \"beige\",",
    "    \"brick\", \"brown\", \"burgundy\", \"charcoal\", \"chestnut\", \"coral\", \"cream\", \"evergreen\",",
    "    \"gold\", \"grey\", \"khaki\", \"kellygreen\", \"lavender\", \"mustard\", \"navy\", \"ochre\",",
    "    \"olive\", \"peach\", \"pink\", \"rose\", \"rust\", \"sky\", \"tan\", \"tangerine\", \"turquoise\",",
    "    \"violet\", \"reddishpurple\", \"purplered\", \"purplishred\", \"orangishred\", \"redorange\",",
    "    \"reddishorange\", \"orange\", \"yellowishorange\", \"orangeyellow\", \"orangishyellow\",",
    "    \"greenishyellow\", \"yellowgreen\", \"yellowishgreen\", \"bluishgreen\", \"bluegreen\",",
    "    \"greenishblue\", \"purplishblue\", \"bluepurple\", \"bluishpurple\", \"purple\", \"white\"",
};

const CdoHelp MagvectorHelp = {
    "NAME",
    "    vector - Lat/Lon vector plot",
    "",
    "SYNOPSIS",
    "    vector,parameter  infile obase",
    "",
    "DESCRIPTION",
    "    This operator generates 2D Lon/Lat vector plots.",
    "    The data for the plot is read from infile. The input is expected to contain two velocity",
    "    components. Only data on rectilinear Lon/Lat grids are supported.",
    "    The output file will be named <obase>.<device> where device is the device name. ",
    "    The default output file format is postscript, this can be changed with the device parameter.",
    "    ",
    "    Here is a list of all vector plot parameters:",
    "    ",
    "     Keyname     & Type    & Description      ",
    "     device      & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     projection  & STRING  & Projection (cylindrical, polar_stereographic, robinson, mercator)",
    "     thin_fac    & FLOAT   & Controls the actual number of wind arrows or flags plotted (default 2).",
    "     unit_vec    & FLOAT   & Wind speed in m/s represented by a unit vector (1.0cm)",
    "     step_freq   & INTEGER & Frequency of time steps to be considered for making the animation",
    "                 &         & (device=gif_animation). Default value is \"1\" (all time steps).",
    "                 &         & Will be ignored if input file has multiple variables.",
    "",
    "PARAMETER",
    "    parameter  STRING   Comma-separated list of plot parameters",
};

const CdoHelp MaggraphHelp = {
    "NAME",
    "    graph - Line graph plot",
    "",
    "SYNOPSIS",
    "    graph,parameter  infiles outfile",
    "",
    "DESCRIPTION",
    "    This operator generates line graph plots.",
    "    The data for the plot is read from infiles. The result is written to outfile.",
    "    The default output file format is postscript, this can be changed with the device parameter.",
    "    ",
    "    Here is a list of all graph plot parameters:",
    "    ",
    "     Keyname    & Type    & Description      ",
    "     device     & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     ymin       & FLOAT   & Minimum value of the y-axis data ",
    "     ymax       & FLOAT   & Maximum value of the y-axis data ",
    "     linewidth  & INT     & Linewidth (default 8)",
    "     stat       & STRING  & \"TRUE\" or \"FALSE\", to switch on the mean computation. Default is \"FALSE\".",
    "                &         & Will be overridden to \"FALSE\", if input files have unequal number of time",
    "                &         & steps or different start/end times. ",
    "     sigma      & FLOAT   & Standard deviation value for generating shaded back ground around the mean value.",
    "                &         & To be used in conjunction with 'stat=\"TRUE\"' ",
    "     obsv       & STRING  & To indicate if the input files have an observation data, by setting to \"TRUE\".",
    "                &         & Default value is \"FALSE\". The observation data should be the first file in the",
    "                &         & input file list. The observation data is always plotted in black colour. ",
    "",
    "PARAMETER",
    "    parameter  STRING   Comma-separated list of plot parameters",
};

const CdoHelp EcaCddHelp = {
    "NAME",
    "    eca_cdd, etccdi_cdd - Consecutive dry days index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,R[,N[,params]]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the largest number ",
    "    of consecutive days where RR is less than R is counted. R is an optional parameter with ",
    "    default R = 1 mm. A further output variable is the number of dry periods of more than N days.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_cdd     Consecutive dry days index per time period",
    "                The operator counts over the entire time series.",
    "                The date information of a timestep in outfile is the date of",
    "                the last contributing timestep in infile.",
    "    etccdi_cdd  Consecutive dry days index per time period",
    "                The default output frequency is yearly.",
    "                Periods within overlapping years are accounted for the first year.",
    "                The date information of a timestep in outfile is the mid of",
    "                the frequency interval.",
    "",
    "PARAMETER",
    "    R     FLOAT    Precipitation threshold (unit: mm; default: R = 1 mm)",
    "    N     INTEGER  Minimum number of days exceeded (default: N = 5)",
    "    freq  STRING   Output frequency (year, month)",
};

const CdoHelp EcaCfdHelp = {
    "NAME",
    "    eca_cfd - Consecutive frost days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cfd[,N]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN, then the largest number of",
    "    consecutive days where TN < 0 °C is counted. Note that TN have to be given in units of Kelvin.",
    "    A further output variable is the number of frost periods of more than N days.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    N  INTEGER  Minimum number of days exceeded (default: N = 5)",
};

const CdoHelp EcaCsuHelp = {
    "NAME",
    "    eca_csu - Consecutive summer days index per time period",
    "",
    "SYNOPSIS",
    "    eca_csu[,T[,N]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX, then the largest number of consecutive",
    "    days where TX > T is counted. The number T is an optional parameter with default T = 25°C.",
    "    Note that TN have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    A further output variable is the number of summer periods of more than N days.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    T  FLOAT    Temperature threshold (unit: °C; default: T = 25°C)",
    "    N  INTEGER  Minimum number of days exceeded (default: N = 5)",
};

const CdoHelp EcaCwdHelp = {
    "NAME",
    "    eca_cwd, etccdi_cwd - Consecutive wet days index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,params]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the largest number ",
    "    of consecutive days where RR is at least R is counted. R is an optional parameter with ",
    "    default R = 1 mm. A further output variable is the number of wet periods of more than N days.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_cwd     Consecutive wet days index per time period",
    "                The operator counts over the entire time series.",
    "                The date information of a timestep in outfile is the date of",
    "                the last contributing timestep in infile.",
    "    etccdi_cwd  Consecutive wet days index per time period",
    "                The default output frequency is yearly.",
    "                Periods within overlapping years are accounted for the first year.",
    "                The date information of a timestep in outfile is the mid of",
    "                the frequency interval.",
    "",
    "PARAMETER",
    "    R     FLOAT    Precipitation threshold (unit: mm; default: R = 1 mm)",
    "    N     INTEGER  Minimum number of days exceeded (default: N = 5)",
    "    freq  STRING   Output frequency (year, month)",
};

const CdoHelp EcaCwdiHelp = {
    "NAME",
    "    eca_cwdi - Cold wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_cwdi[,nday[,T]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN, and let infile2 be the mean ",
    "    TNnorm of daily minimum temperatures for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TN < TNnorm - T.",
    "    The numbers nday and T are optional parameters with default nday = 6 and T = 5°C. ",
    "    A further output variable is the number of cold waves longer than or equal to nday days.",
    "    TNnorm is calculated as the mean of minimum temperatures of a five day window centred on each calendar day ",
    "    of a given climate reference period. Note that both TN and TNnorm have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset (unit: °C; default: T = 5°C)",
};

const CdoHelp EcaCwfiHelp = {
    "NAME",
    "    eca_cwfi, etccdi_csdi - ",
    "    Cold-spell days index wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    <operator>[,nday[,params]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be the 10th",
    "    percentile TGn10 of daily mean temperatures for any period used as reference. ",
    "    Then counted is the number of days where, in intervals of at least nday consecutive days,",
    "    TG < TGn10. The number nday is an optional parameter with default nday = 6.",
    "    A further output variable is the number of cold-spell periods longer than or equal to nday days.",
    "    TGn10 is calculated as the 10th percentile of daily mean temperatures of a five day window ",
    "    centred on each calendar day of a given climate reference period. Note that both TG and TGn10 ",
    "    have to be given in the same units.",
    "",
    "OPERATORS",
    "    eca_cwfi     Cold-spell days index wrt 10th percentile of reference period",
    "                 The operator counts over the entire time series.",
    "                 The date information of a timestep in outfile is the date of",
    "                 the last contributing timestep in infile.",
    "    etccdi_csdi  Cold-spell duration index",
    "                 The default output frequency is yearly.",
    "                 Periods within overlapping years are accounted for the first year.",
    "                 The date information of a timestep in outfile is the mid of",
    "                 the frequency interval.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    freq  STRING   Output frequency (year, month)",
};

const CdoHelp EcaEtrHelp = {
    "NAME",
    "    eca_etr - Intra-period extreme temperature range",
    "",
    "SYNOPSIS",
    "    eca_etr  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 and infile2 be time series of thr maximum and minimum",
    "    temperature TX and TN, respectively. Then the extreme temperature",
    "    range is the difference of the maximum of TX and the minimum of TN.",
    "    Note that TX and TN have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timesteps in infile1 and infile2.",
};

const CdoHelp EcaFdHelp = {
    "NAME",
    "    eca_fd, etccdi_fd - Frost days index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN,",
    "    then the number of days where TN < 0 °C is counted. Note",
    "    that TN have to be given in units of Kelvin. Parameter is a",
    "    comma-separated list of \"key=value\" pairs.",
    "",
    "OPERATORS",
    "    eca_fd     Frost days index per time period",
    "               The operator counts over the entire time series.",
    "               The date information of a timestep in outfile is the date of",
    "               the last contributing timestep in infile.",
    "    etccdi_fd  Frost days index per time period",
    "               The default output frequency is yearly.",
    "               The date information of a timestep in outfile is the mid of",
    "               the frequency interval.",
    "",
    "PARAMETER",
    "    freq  STRING    Output frequency (year, month)",
};

const CdoHelp EcaGslHelp = {
    "NAME",
    "    eca_gsl - Thermal Growing season length index",
    "",
    "SYNOPSIS",
    "    eca_gsl[,nday[,T[,fland]]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be a land-water mask.",
    "    Within a period of 12 months, the thermal growing season length is officially defined as the number of days between:",
    "    - first occurrence of at least nday consecutive days with TG > T",
    "    - first occurrence of at least nday consecutive days with TG < T within the last 6 months",
    "    On northern hemisphere, this period corresponds with the regular year, whereas on southern hemisphere, it starts ",
    "    at July 1st. Please note, that this definition may lead to weird results concerning values TG = T: ",
    "    In the first half of the period, these days do not contribute to the gsl, but they do within the second half.",
    "    Moreover this definition could lead to discontinuous values in equatorial regions.",
    "    ",
    "    The numbers nday and T are optional parameter with default nday = 6 and T = 5°C. ",
    "    The number fland is an optional parameter with default value fland = 0.5 and denotes the fraction of ",
    "    a grid point that have to be covered by land in order to be included in the calculation. A further output variable ",
    "    is the start day of year of the growing season. Note that TG have to be given in units of Kelvin, whereas T ",
    "    have to be given in degrees Celsius.",
    "    ",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    nday   INTEGER  Number of consecutive days (default: nday = 6)",
    "    T      FLOAT    Temperature threshold (unit: °C; default: T = 5°C)",
    "    fland  FLOAT    Land fraction threshold (default: fland = 0.5)",
};

const CdoHelp EcaHdHelp = {
    "NAME",
    "    eca_hd - Heating degree days per time period",
    "",
    "SYNOPSIS",
    "    eca_hd[,T1[,T2]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily mean temperature TG, then the heating degree days ",
    "    are defined as the sum of T1 - TG, where only values TG < T2 are considered. ",
    "    If T1 and T2 are omitted, a temperature of 17°C is used for both parameters. ",
    "    If only T1 is given, T2 is set to T1. Note that TG have to be given in units ",
    "    of kelvin, whereas T1 and T2 have to be given in degrees Celsius.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    T1  FLOAT   Temperature limit (unit: °C; default: T1 = 17°C)",
    "    T2  FLOAT   Temperature limit (unit: °C; default: T2 = T1)",
};

const CdoHelp EcaHwdiHelp = {
    "NAME",
    "    eca_hwdi - Heat wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_hwdi[,nday[,T]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and let infile2 be the mean ",
    "    TXnorm of daily maximum temperatures for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TX > TXnorm + T.",
    "    The numbers nday and T are optional parameters with default nday = 6 and T = 5°C. ",
    "    A further output variable is the number of heat waves longer than or equal to nday days. ",
    "    TXnorm is calculated as the mean of maximum temperatures of a five day window centred on each calendar day",
    "    of a given climate reference period. Note that both TX and TXnorm have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset (unit: °C; default: T = 5°C)",
};

const CdoHelp EcaHwfiHelp = {
    "NAME",
    "    eca_hwfi, etccdi_wsdi - ",
    "    Warm spell days index wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    <operator>[,params]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and ",
    "    infile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TG > TGn90. The",
    "    number nday is an optional parameter with default nday = 6. A further",
    "    output variable is the number of warm-spell periods longer than or",
    "    equal to nday days. ",
    "    TGn90 is calculated as the 90th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn90 have to be given in the same units.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_hwfi     Warm spell days index wrt 90th percentile of reference period",
    "                 The operator counts over the entire time series.",
    "                 The date information of a timestep in outfile is the date of",
    "                 the last contributing timestep in infile.",
    "    etccdi_wsdi  Warm Spell Duration Index",
    "                 The default output frequency is yearly.",
    "                 Periods within overlapping years are accounted for the first year.",
    "                 The date information of a timestep in outfile is the mid of",
    "                 the frequency interval.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    freq  STRING   Output frequency (year, month)",
};

const CdoHelp EcaIdHelp = {
    "NAME",
    "    eca_id, etccdi_id - Ice days index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX,",
    "    then the number of days where TX < 0 °C is counted. Note",
    "    that TX have to be given in units of Kelvin. Parameter is a",
    "    comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_id     Ice days index per time period",
    "               The operator counts over the entire time series.",
    "               The date information of a timestep in outfile is the date of",
    "               the last contributing timestep in infile.",
    "    etccdi_id  Ice days index per time period",
    "               The default output frequency is yearly.",
    "               The date information of a timestep in outfile is the mid of",
    "               the frequency interval.",
    "",
    "PARAMETER",
    "    freq  STRING    Output frequency (year, month)",
};

const CdoHelp EcaR75pHelp = {
    "NAME",
    "    eca_r75p - Moderate wet days wrt 75th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r75p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn75 is calculated. ",
    "    RRn75 is calculated as the 75th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,75.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR75ptotHelp = {
    "NAME",
    "    eca_r75ptot - Precipitation percent due to R75p days",
    "",
    "SYNOPSIS",
    "    eca_r75ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn75 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn75 is calculated as the 75th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,75.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR90pHelp = {
    "NAME",
    "    eca_r90p - Wet days wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn90 is calculated. ",
    "    RRn90 is calculated as the 90th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,90.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR90ptotHelp = {
    "NAME",
    "    eca_r90ptot - Precipitation percent due to R90p days",
    "",
    "SYNOPSIS",
    "    eca_r90ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn90 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn90 is calculated as the 90th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,90.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR95pHelp = {
    "NAME",
    "    eca_r95p - Very wet days wrt 95th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r95p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn95 is calculated. ",
    "    RRn95 is calculated as the 95th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,95.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR95ptotHelp = {
    "NAME",
    "    eca_r95ptot - Precipitation percent due to R95p days",
    "",
    "SYNOPSIS",
    "    eca_r95ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn95 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn95 is calculated as the 95th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,95.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR99pHelp = {
    "NAME",
    "    eca_r99p - Extremely wet days wrt 99th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r99p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn99 is calculated. ",
    "    RRn99 is calculated as the 99th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,99.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaR99ptotHelp = {
    "NAME",
    "    eca_r99ptot - Precipitation percent due to R99p days",
    "",
    "SYNOPSIS",
    "    eca_r99ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and infile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn99 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn99 is calculated as the 99th percentile of all wet days of a given climate reference period.",
    "    Usually infile2 is generated by the operator ydaypctl,99.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaPdHelp = {
    "NAME",
    "    eca_pd, eca_r10mm, eca_r20mm, etccdi_r1mm - ",
    "    Precipitation days index per time period",
    "",
    "SYNOPSIS",
    "    eca_pd,x  infile outfile",
    "    eca_r10mm  infile outfile",
    "    eca_r20mm  infile outfile",
    "    etccdi_r1mm[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg m-2]),",
    "    then the number of days where RR is at least x mm is counted. ",
    "    eca_r10mm and eca_r20mm are specific ECA operators with a daily precipitation amount of 10 and 20 mm respectively.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile",
    "    except for the etccdi operator. Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_pd       Precipitation days index per time period",
    "                 Generic ECA operator with daily precipitation sum exceeding x mm.",
    "    eca_r10mm    Heavy precipitation days index per time period",
    "                 Specific ECA operator with daily precipitation sum exceeding 10 mm.",
    "    eca_r20mm    Very heavy precipitation days index per time period",
    "                 Specific ECA operator with daily precipitation sum exceeding 20 mm.",
    "    etccdi_r1mm  Precipitation days index per time period",
    "                 The default output frequency is yearly.",
    "                 The date information of a timestep in outfile is the mid of",
    "                 the frequency interval.",
    "",
    "PARAMETER",
    "    x     FLOAT   Daily precipitation amount threshold in [mm]",
    "    freq  STRING  Output frequency (year, month)",
    "",
    "NOTE",
    "    Precipitation rates in [mm/s] have to be converted to precipitation amounts (multiply with 86400 s).",
    "    Apart from metadata information the result of eca_pd,1 and eca_rr1 is the same.",
};

const CdoHelp EcaRr1Help = {
    "NAME",
    "    eca_rr1 - Wet days index per time period",
    "",
    "SYNOPSIS",
    "    eca_rr1[,R]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg m-2]), then",
    "    the number of days where RR is at least R is counted. R is an optional parameter with default R = 1 mm. ",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
};

const CdoHelp EcaRx1dayHelp = {
    "NAME",
    "    eca_rx1day, etccdi_rx1day - ",
    "    Highest one day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR,",
    "    then the maximum of RR is written to outfile. If the optional",
    "    parameter mode is set to 'm' the maximum daily precipitation",
    "    amounts are determined for each month. ",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_rx1day     Highest one day precipitation amount per time period",
    "                   The operator counts over the entire time series.",
    "                   The date information of a timestep in outfile is the date of",
    "                   the last contributing timestep in infile.",
    "    etccdi_rx1day  Maximum 1-day Precipitation",
    "                   The default output frequency is yearly.",
    "                   The date information of a timestep in outfile is the mid of",
    "                   the frequency interval.",
    "",
    "PARAMETER",
    "    freq  STRING  Output frequency (year, month)",
};

const CdoHelp EcaRx5dayHelp = {
    "NAME",
    "    eca_rx5day, etccdi_rx5day - ",
    "    Highest five-day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,x[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of 5-day precipitation totals RR, then the maximum of RR is written to outfile. ",
    "    A further output variable is the number of 5 day period with precipitation totals greater than x mm, where x ",
    "    is an optional parameter with default x = 50 mm.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_rx5day     Highest five-day precipitation amount per time period",
    "                   The operator counts over the entire time series.",
    "                   The date information of a timestep in outfile is the date of",
    "                   the last contributing timestep in infile.",
    "    etccdi_rx5day  Highest five-day precipitation amount per time period",
    "                   The default output frequency is yearly.",
    "                   Periods within overlapping years are accounted for the first year.",
    "                   The date information of a timestep in outfile is the mid of",
    "                   the frequency interval.",
    "",
    "PARAMETER",
    "    x     FLOAT   Precipitation threshold (unit: mm; default: x = 50 mm)",
    "    freq  STRING  Output frequency (year, month)",
};

const CdoHelp EcaSdiiHelp = {
    "NAME",
    "    eca_sdii - Simple daily intensity index per time period",
    "",
    "SYNOPSIS",
    "    eca_sdii[,R]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the mean precipitation amount at ",
    "    wet days (RR >= R) is written to outfile. R is an optional parameter with default R = 1 mm.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
};

const CdoHelp EcaSuHelp = {
    "NAME",
    "    eca_su, etccdi_su - Summer days index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,T[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX, then the number of days where ",
    "    TX > T is counted. The number T is an optional parameter with default T = 25°C. ",
    "    Note that TX have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_su     Summer days index per time period",
    "               The operator counts over the entire time series.",
    "               The date information of a timestep in outfile is the date of",
    "               the last contributing timestep in infile.",
    "    etccdi_su  Summer days index per time period",
    "               The default output frequency is yearly.",
    "               The date information of a timestep in outfile is the mid of",
    "               the frequency interval.",
    "",
    "PARAMETER",
    "    T     FLOAT     Temperature threshold (unit: °C; default: T = 25°C)",
    "    freq  STRING    Output frequency (year, month)",
};

const CdoHelp EcaTg10pHelp = {
    "NAME",
    "    eca_tg10p - Cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and",
    "    infile2 be the 10th percentile TGn10 of daily mean temperatures",
    "    for any period used as reference. Then the percentage of time where ",
    "    TG < TGn10 is calculated.",
    "    TGn10 is calculated as the 10th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn10 have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile1.",
};

const CdoHelp EcaTg90pHelp = {
    "NAME",
    "    eca_tg90p - Warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and",
    "    infile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then the percentage of time where TG > TGn90 ",
    "    is calculated. ",
    "    TGn90 is calculated as the 90th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn90 have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile1.",
};

const CdoHelp EcaTn10pHelp = {
    "NAME",
    "    eca_tn10p - Cold nights percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time serie of the daily minimum temperature TN, and",
    "    infile2 be the 10th percentile TNn10 of daily minimum temperatures",
    "    for any period used as reference. Then the percentage of time where TN < TNn10 ",
    "    is calculated.",
    "    TNn10 is calculated as the 10th percentile of daily minimum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TN and TNn10 have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile1.",
};

const CdoHelp EcaTn90pHelp = {
    "NAME",
    "    eca_tn90p - Warm nights percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN, and infile2 be the ",
    "    90th percentile TNn90 of daily minimum temperatures for any period used as reference. ",
    "    Then the percentage of time where TN > TNn90 is calculated. TNn90 is calculated as the 90th percentile",
    "    of daily minimum temperatures of a five day window centred on each calendar day of a given climate",
    "    reference period. Note that both TN and TNn90 have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in infile1.",
};

const CdoHelp EcaTrHelp = {
    "NAME",
    "    eca_tr, etccdi_tr - Tropical nights index per time period",
    "",
    "SYNOPSIS",
    "    <operator>[,T[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN, then the number of days where ",
    "    TN > T is counted. The number T is an optional parameter with default T = 20°C. ",
    "    Note that TN have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    Parameter is a comma-separated list of \"key=values\" pairs.",
    "",
    "OPERATORS",
    "    eca_tr     Tropical nights index per time period",
    "               The operator counts over the entire time series.",
    "               The date information of a timestep in outfile is the date of",
    "               the last contributing timestep in infile.",
    "    etccdi_tr  Tropical nights index per time period",
    "               The default output frequency is yearly.",
    "               The date information of a timestep in outfile is the mid of",
    "               the frequency interval.",
    "",
    "PARAMETER",
    "    T     FLOAT   Temperature threshold (unit: °C; default: T = 20°C)",
    "    freq  STRING  Output frequency (year, month)",
};

const CdoHelp EcaTx10pHelp = {
    "NAME",
    "    eca_tx10p - Very cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and",
    "    infile2 be the 10th percentile TXn10 of daily maximum temperatures",
    "    for any period used as reference. Then the percentage of time where TX < TXn10.",
    "    is calculated.",
    "    TXn10 is calculated as the 10th percentile of daily maximum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TX and TXn10 have to be givenin the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile1.",
};

const CdoHelp EcaTx90pHelp = {
    "NAME",
    "    eca_tx90p - Very warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and",
    "    infile2 be the 90th percentile TXn90 of daily maximum temperatures",
    "    for any period used as reference. Then the percentage of time where TX > TXn90.",
    "    is calculated.",
    "    TXn90 is calculated as the 90th percentile of daily maximum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TX and TXn90 have to be given in the same units.",
    "    The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile1.",
};

const CdoHelp EcaEtccdiHelp = {
    "NAME",
    "    etccdi_tx90p, etccdi_tx10p, etccdi_tn90p, etccdi_tn10p, etccdi_r95p, ",
    "    etccdi_r99p - ",
    "    ETCCDI conform index for a reference periode calculated with bootstrapping",
    "",
    "SYNOPSIS",
    "    <operator>,n,startboot,endboot[,m]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This module enables to compute Climate Extremes Indices according to the method recommended",
    "    by the Expert Team on Climate Change Detection and Indices. It differs from the",
    "    corresponding eca_* indices by applying bootstrapping for a reference period",
    "    (see Zhang et al. 2005) given by startboot and endboot and using the R-type 8 method ",
    "    for percentile calculation.",
    "    A requirement for correct percentile calculation is that",
    "    CDO_PCTL_NBINS>=window*(endboot-startboot+1)*(sizeof(double)/sizeof(int))+2",
    "    This demands for high working storage since the entire data of the bootstrapping interval",
    "    need to be hold in storage. Otherwise, a histogram is used to calculate the percentile.",
    "    infile2 (infile3) contains the daily minimum (maximum) of the bootstrapping interval.",
    "    If m=m, the output variable will be saved monthly, otherwise with yearly frequency.",
    "",
    "OPERATORS",
    "    etccdi_tx90p  Percentage of Days when Daily Maximum Temperature is Above the 90th Percentile",
    "    etccdi_tx10p  Percentage of Days when Daily Maximum Temperature is Below the 10th Percentile",
    "    etccdi_tn90p  Percentage of Days when Daily Minimum Temperature is Above the 90th Percentile",
    "    etccdi_tn10p  Percentage of Days when Daily Minimum Temperature is Below the 10th Percentile",
    "    etccdi_r95p   Annual Total Precipitation when Daily Precipitation Exceeds the 95th Percentile of Wet Day Precipitation",
    "    etccdi_r99p   Annual Total Precipitation when Daily Precipitation Exceeds the 99th Percentile of Wet Day Precipitation",
    "",
    "PARAMETER",
    "    n          INTEGER  Window days, number of timesteps",
    "    startboot  INTEGER  First year of bootstrapping interval",
    "    endboot    INTEGER  Last year of bootstrapping interval",
    "    m          CHARACTER Output frequency",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
};

// clang-format on

