/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * A few small modifications (C) 2007 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <signal.h>
#include <string.h>
#include <ctype.h> //isgraph()

#include <stdio.h>
#include <stdlib.h>

#include <ncursesw/ncurses.h>
#include <ncursesw/menu.h>
#include <ncursesw/form.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <libintl.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/wait.h>


#include "options.h"
#include "log.h"
#include "main.h"
#include "config.h"
#include "color.h"
#include "gettext.h"
#include "utils.h"

// #include "cdw_ui.h"
// #include "commands.h"
// #include "cdw_tmp_files.h"



extern struct conf config;


void after_event(char *message, int adddic)
{
	if (strcmp(config.showlog, "1") == 0)
		log_window(message, config.logfile, 0);
#ifdef HAVE_LIBMYSQLCLIENT
	if ((strcmp(config.autodic, "1") == 0) && (adddic == 1))
		add_to_dic();
#endif
#ifdef HAVE_LIBSQLITE
	if ((strcmp(config.autodic, "1") == 0) && (adddic == 1))
		add_to_dic();
#endif
	if (strcmp(config.eject, "1") == 0) {
		eject_tray(config.cdrwdevice);
	}
}




/*
 * Filter function for scandir()
 *
 * Filter function for scandir() - returns zero value for 
 * current directory ('.') and parent directory ('..') entries.
 * Entries, for which filter returns zero value, are ommited by scandir()
 *
 * \param const struct dirent *unused
 *
 * \returns 0 if entry is '.' or '..'. 1 otherwise
 */
int one(const struct dirent *unused)
{
	if (strcmp(unused->d_name, ".") && strcmp(unused->d_name, "..")) {
		return 1;
	} else
		return 0;
}




/*
 * Get size of all files and dirs that are in table with paths
 *
 * Get size of all files and dirs (recursively) that are in table with paths.
 *
 * \param char **pathtable - pointer to table of *char strings with full (non-relative) paths
 * \param int paths - size of table
 *
 * \returns size of all dirs/files from table or -1 if failure
 */
long long int dirsize(char **pathtable, int paths)
{
	long long int d_size = 0;

	int i = 0;
	for (i = 0; i < paths; i++) {
		long long int rv = _dirsize(*(pathtable + i));
		if (rv == -1 ) {
			return -1; /* error */
		} else {
			d_size += rv;
		}
	}
	// fprintf(stderr, "\t>>>>>>>>>total: %lld\n", d_size);
	return d_size;
}




/*
 * Get size of given dir (recursively) or file
 *
 * Get size of given dir (recursively) or file. Do not follow 
 * symlinks (that's easy to change).
 *
 * \param char *path - non-relative path to dir or file.
 *
 * \returns -1 on failure, value >=0 on success
 */
long long int _dirsize(char *path)
{
	struct stat *finfo;
	int ok;
	long long int _d_size = 0;

	finfo = (struct stat *) malloc(sizeof(struct stat));
	if ((ok = stat(path, finfo)) != 0) { /* lstat() - don't follow links */
		return -1;
	}

	if ( S_ISREG(finfo->st_mode) ) { /* regular file */
		_d_size += finfo->st_size;
	} else if ( S_ISLNK(finfo->st_mode) ) { /* symbolic link */
		_d_size += finfo->st_size; /* st_size is lenght of path without terminating null */
	} else if ( S_ISDIR(finfo->st_mode) ) { /* directory */
		_d_size += finfo->st_blocks * 512;
		/* get directory listing */
		struct dirent **eps;
		int n = scandir(path, &eps, one, &alphasort);
		if (n > 0) {
			int i;
			for (i = 0; i < n; i++) {
				/* for every dir entry create new full path to this entry and scan it */
				char *newpath = (char *) malloc(strlen(eps[i]->d_name) + strlen(path) + 4);
				sprintf(newpath, "%s/%s", path, eps[i]->d_name);
				long long int dd = _dirsize(newpath);
				if (dd > 0) {
					_d_size += dd;
				} 

				free(eps[i]);
				eps[i] = NULL;

				free(newpath);
				newpath = NULL;
			}
		}

		free(eps); // FIXME - this should be in 'if' or outside of 'if'?
		eps = NULL;
	}

	free(finfo);
	finfo = NULL;

	return _d_size;
}




sig_atomic_t child_exit_status;
/* 
 * Remove zombie process created by run_command()
 */
void clean_up_child_process(int signal_number)
{
	// clean child process
	int status;
	wait(&status);
	child_exit_status = status;

	return;
}




/*
 * Process main(argc, argv[]) arguments
 */
void process_commandline_args(int argc, char *argv[])
{

/*      printf(_("Usage: %s\n"),argv[0]); */
#ifdef HAVE_LIBMYSQLCLIENT
	if ((strcmp((char *) argv[1], "--catalog") == 0) || (strcmp((char *) argv[1], "-c") == 0)) {
		initscr();
		start_color();
		cbreak();
		noecho();
		keypad(stdscr, TRUE);
		// colors
		init_curses_colors();
		lines = LINES - 2;
		if ((LINES < 24) || (COLS < 79)) {
			clean_before_cdw_exit();
			printf(_("Needed min 80x25 terminal!"));
			exit(-1);
		}
		cddb_window();
		clean_before_cdw_exit();
		exit(0);
	}
#endif
#ifdef GTK_GUI
	if ((strcmp((char *) argv[1], "--gui") == 0) || (strcmp((char *) argv[1], "-g") == 0)) {
			gtk_gui(0, "");
		exit(0);
	}
#endif
	if ((strcmp((char *) argv[1], "--version") == 0) || (strcmp((char *) argv[1], "-v") == 0)) {
		clean_before_cdw_exit();
		printf("%s-%s (C) 2002-2003 Balazs Varkonyi\n\n", PACKAGE, VERSION);
		exit(0);
	}
	if ((strcmp((char *) argv[1], "--help") == 0) || (strcmp((char *) argv[1], "-h") == 0)) {
		endwin();
		printf(_("Usage: %s [options]\n\n"), argv[0]);
		printf(_("Options:\n\n"));
#ifdef HAVE_LIBMYSQLCLIENT
		printf(_("  --catalog | -c            : start in Disk Catalog mode\n"));
#endif
#ifdef GTK_GUI
		printf(_("  --gui     | -g            : start cdw in GUI mode\n"));
#endif
		printf(_("  --help    | -h            : show this screen\n"));
		printf(_("  --version | -v            : show version\n\n"));
		clean_before_cdw_exit();
		exit(0);
	}
	printf(_("%s: invalid option -- %s\n"), argv[0], argv[1]);
	printf(_("Try `%s --help`\n"), argv[0]);
	clean_before_cdw_exit();
	exit(0);
}




/*
 * Simple wrapper for locale setting functions
 */
int set_cdw_locale(void)
{
	setlocale(LC_ALL, "");
	textdomain(PACKAGE);
	bindtextdomain(PACKAGE, LOCALEDIR);

	return 0;
}




/*
 * Check existence of given file, store lstat() info in one of arguments
 *
 * FIXME - come up with better name
 *
 * \param char *dir
 * \param char *filename
 * \param struct stat *stbuf
 *
 * \returns 0 on success, -1 on failure
 */
int check_fullpath_dir(char *dir, char *filename, struct stat *stbuf)
{
	char path[1000];
	memset(path, '\0', sizeof(path));
	strcpy(path, "/");
	strcat(path, dir);
	strcat(path, "/");
	strcat(path, filename);
	if (lstat(path, stbuf) == -1) {
		fprintf(stderr, _("File: %s not found!"), path);
		return -1;
	}
	
	return 0;

}




/*
 * Setup code dealing with zombie processes created during run_command() call
 *
 * \returns 0
 */
int set_zombie_handler(void)
{
	/* handling terminated child process - data structure*/
	struct sigaction sigchild_action;

	/* handling terminated child process - setup */
	memset(&sigchild_action, 0, sizeof(sigchild_action));
	sigchild_action.sa_handler = &clean_up_child_process;
	sigaction(SIGCHLD, &sigchild_action, NULL);

	return 0;
}




/*
 * Remove non-printable characters from path
 *
 * Replace non-printable characters (like '»') from file's path.
 * Such characters may be visible in files selector window, but
 * path containig such characters is not displayed by 'Selected files'
 * list, because it is implemented using ncurses MENU (and I don't know 
 * how to fix it yet). Non-printable characters are replaced by '?'.
 *
 * It may be possible to replace thiese characters only in strings 
 * displayed in 'Selected files' window and print them unaltered to
 * cdrecord-source-files-paths tmp file.
 *
 * \param char **string - pointer to path - this parameter may be modified by function
 *
 */
void make_ncurses_printable_string(char **string)
{

	return;

	int len = strlen(*string);

	int i = 0;
	for (i = 0; i < len; i++) {
		if (! isprint(*((*string) + i))) {
			(*((*string) + i)) = '?';
			if (! isprint(*((*string) + i + 1))) {
				i++;
			}
		}
	}

	return;
}


