#ifndef __UTILS_H
#define __UTILS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

enum {
	CDW_FILE,
	CDW_DIR
} file_type;

void process_commandline_args(int argc, char *argv[]);
int cdw_locale_init(void);
int zombie_handler_init(void);
int one(const struct dirent *unused);
void load_dir(char *dir, int width, int height);
long long dirsize(char **pathtable, int paths);
long long _dirsize(char *dirpath);
int is_valid_path(char *fullpath, mode_t permissions, int filetype, struct stat *finfo);
int add_to_dic();
int check_for_boot_image(void);
void after_event(char *message, int adddic);
int get_home_dir(char **path);
int get_tmp_dir(char **path);
/* void make_ncurses_printable_string(char **string); */
char *rtrim(char *str);
char *ltrim(char *str);

char *concat(const char *str, ...);
void my_itoa(int i, char *string);

#endif /* __UTILS_H */
