/* @(#)isosize.c	1.4 98/11/22 Copyright 1996 J. Schilling */
/*
 *	Copyright (c) 1996 J. Schilling
 *
 *	A few small modifications (c) 2000 Jonas Munsin
 *      Further small modifications (c) 2009 Kamil Ignacak
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#define _BSD_SOURCE
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "iso9660.h"
#include "isosize.h"
#include "cdw_debug.h"

struct iso9660_pr_voldesc *get_voldesc(int file)
{
	struct iso9660_voldesc *vd = (struct iso9660_voldesc *) malloc(sizeof(struct iso9660_voldesc));
	if (vd == (struct iso9660_voldesc *) NULL) {
		return (struct iso9660_pr_voldesc *) NULL;
	}

	/*
	 * First check if a bad guy tries to call isosize()
	 * with an inappropriate file descriptor.
	 * return -1 in this case.
	 */
	if (isatty(file)) {
	        free(vd);
		return (struct iso9660_pr_voldesc *) NULL;
	}
	struct stat sb;
	if (fstat(file, &sb) < 0) {
	        free(vd);
		return (struct iso9660_pr_voldesc *) NULL;
	}

	long mode = (long)(sb.st_mode & S_IFMT);
	if (!S_ISREG(mode) && !S_ISBLK(mode) && !S_ISCHR(mode)) {
	        free(vd);
		return (struct iso9660_pr_voldesc *) NULL;
	}

	if (lseek(file, (off_t)(16L * 2048L), SEEK_SET) == -1) {
	        free(vd);
		return (struct iso9660_pr_voldesc *)NULL;
	}

	struct iso9660_pr_voldesc *vp = (struct iso9660_pr_voldesc *) vd;

	do {
		read(file, vd, sizeof(*vd));
		if (GET_UBYTE(vd->vd_type) == VD_PRIMARY)
			break;

	} while (GET_UBYTE(vd->vd_type) != VD_TERM);

	lseek(file, (off_t)0L, SEEK_SET);

	if (GET_UBYTE(vd->vd_type) != VD_PRIMARY) {
		free(vd);
		return (struct iso9660_pr_voldesc *) NULL;
	}

	return vp;
}





long long isosize(int file)
{
	struct iso9660_pr_voldesc *vp = get_voldesc(file);
	if (vp == (struct iso9660_pr_voldesc *) NULL) {
		return -1;
	}

	long sectors = GET_BINT(vp->vd_volume_space_size);
	long long bytes = sectors * GET_BSHORT(vp->vd_lbsize);
	cdw_vdm ("INFO: iso size = %ld sectors * %d = %lld bytes\n",
		 sectors, GET_BSHORT(vp->vd_lbsize), bytes);

	free(vp);
	vp = (struct iso9660_pr_voldesc *) NULL;

	return bytes;
}
