//
// MetadataTableReader.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Thu Oct 20 22:51:11 CEST 2005
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil.Metadata {

	using System;
	using System.Collections;
	using System.IO;

	class MetadataTableReader : BaseMetadataTableVisitor {

		MetadataRoot m_metadataRoot;
		TablesHeap m_heap;
		MetadataRowReader m_mrrv;
		BinaryReader m_binaryReader;

		public readonly IDictionary Rows = new Hashtable (38);

		public MetadataTableReader (MetadataReader mrv)
		{
			m_metadataRoot = mrv.GetMetadataRoot ();
			m_heap = m_metadataRoot.Streams.TablesHeap;
			m_binaryReader = new BinaryReader (new MemoryStream (m_heap.Data));
			m_binaryReader.BaseStream.Position = 24;
			m_mrrv = new MetadataRowReader (this);
		}

		public MetadataRoot GetMetadataRoot ()
		{
			return m_metadataRoot;
		}

		public BinaryReader GetReader ()
		{
			return m_binaryReader;
		}

		public override IMetadataRowVisitor GetRowVisitor ()
		{
			return m_mrrv;
		}

		void ReadNumberOfRows (Type table)
		{
			this.Rows [table] = m_binaryReader.ReadInt32 ();
		}

		public int GetNumberOfRows (Type table)
		{
			object n = this.Rows [table];
			if (n != null)
				return (int) n;
			return 0;
		}

		public AssemblyTable GetAssemblyTable ()
		{
			return (AssemblyTable) m_heap [typeof (AssemblyTable)];
		}

		public AssemblyOSTable GetAssemblyOSTable ()
		{
			return (AssemblyOSTable) m_heap [typeof (AssemblyOSTable)];
		}

		public AssemblyProcessorTable GetAssemblyProcessorTable ()
		{
			return (AssemblyProcessorTable) m_heap [typeof (AssemblyProcessorTable)];
		}

		public AssemblyRefTable GetAssemblyRefTable ()
		{
			return (AssemblyRefTable) m_heap [typeof (AssemblyRefTable)];
		}

		public AssemblyRefOSTable GetAssemblyRefOSTable ()
		{
			return (AssemblyRefOSTable) m_heap [typeof (AssemblyRefOSTable)];
		}

		public AssemblyRefProcessorTable GetAssemblyRefProcessorTable ()
		{
			return (AssemblyRefProcessorTable) m_heap [typeof (AssemblyRefProcessorTable)];
		}

		public ClassLayoutTable GetClassLayoutTable ()
		{
			return (ClassLayoutTable) m_heap [typeof (ClassLayoutTable)];
		}

		public ConstantTable GetConstantTable ()
		{
			return (ConstantTable) m_heap [typeof (ConstantTable)];
		}

		public CustomAttributeTable GetCustomAttributeTable ()
		{
			return (CustomAttributeTable) m_heap [typeof (CustomAttributeTable)];
		}

		public DeclSecurityTable GetDeclSecurityTable ()
		{
			return (DeclSecurityTable) m_heap [typeof (DeclSecurityTable)];
		}

		public EventTable GetEventTable ()
		{
			return (EventTable) m_heap [typeof (EventTable)];
		}

		public EventMapTable GetEventMapTable ()
		{
			return (EventMapTable) m_heap [typeof (EventMapTable)];
		}

		public ExportedTypeTable GetExportedTypeTable ()
		{
			return (ExportedTypeTable) m_heap [typeof (ExportedTypeTable)];
		}

		public FieldTable GetFieldTable ()
		{
			return (FieldTable) m_heap [typeof (FieldTable)];
		}

		public FieldLayoutTable GetFieldLayoutTable ()
		{
			return (FieldLayoutTable) m_heap [typeof (FieldLayoutTable)];
		}

		public FieldMarshalTable GetFieldMarshalTable ()
		{
			return (FieldMarshalTable) m_heap [typeof (FieldMarshalTable)];
		}

		public FieldRVATable GetFieldRVATable ()
		{
			return (FieldRVATable) m_heap [typeof (FieldRVATable)];
		}

		public FileTable GetFileTable ()
		{
			return (FileTable) m_heap [typeof (FileTable)];
		}

		public GenericParamTable GetGenericParamTable ()
		{
			return (GenericParamTable) m_heap [typeof (GenericParamTable)];
		}

		public GenericParamConstraintTable GetGenericParamConstraintTable ()
		{
			return (GenericParamConstraintTable) m_heap [typeof (GenericParamConstraintTable)];
		}

		public ImplMapTable GetImplMapTable ()
		{
			return (ImplMapTable) m_heap [typeof (ImplMapTable)];
		}

		public InterfaceImplTable GetInterfaceImplTable ()
		{
			return (InterfaceImplTable) m_heap [typeof (InterfaceImplTable)];
		}

		public ManifestResourceTable GetManifestResourceTable ()
		{
			return (ManifestResourceTable) m_heap [typeof (ManifestResourceTable)];
		}

		public MemberRefTable GetMemberRefTable ()
		{
			return (MemberRefTable) m_heap [typeof (MemberRefTable)];
		}

		public MethodTable GetMethodTable ()
		{
			return (MethodTable) m_heap [typeof (MethodTable)];
		}

		public MethodImplTable GetMethodImplTable ()
		{
			return (MethodImplTable) m_heap [typeof (MethodImplTable)];
		}

		public MethodSemanticsTable GetMethodSemanticsTable ()
		{
			return (MethodSemanticsTable) m_heap [typeof (MethodSemanticsTable)];
		}

		public MethodSpecTable GetMethodSpecTable ()
		{
			return (MethodSpecTable) m_heap [typeof (MethodSpecTable)];
		}

		public ModuleTable GetModuleTable ()
		{
			return (ModuleTable) m_heap [typeof (ModuleTable)];
		}

		public ModuleRefTable GetModuleRefTable ()
		{
			return (ModuleRefTable) m_heap [typeof (ModuleRefTable)];
		}

		public NestedClassTable GetNestedClassTable ()
		{
			return (NestedClassTable) m_heap [typeof (NestedClassTable)];
		}

		public ParamTable GetParamTable ()
		{
			return (ParamTable) m_heap [typeof (ParamTable)];
		}

		public PropertyTable GetPropertyTable ()
		{
			return (PropertyTable) m_heap [typeof (PropertyTable)];
		}

		public PropertyMapTable GetPropertyMapTable ()
		{
			return (PropertyMapTable) m_heap [typeof (PropertyMapTable)];
		}

		public StandAloneSigTable GetStandAloneSigTable ()
		{
			return (StandAloneSigTable) m_heap [typeof (StandAloneSigTable)];
		}

		public TypeDefTable GetTypeDefTable ()
		{
			return (TypeDefTable) m_heap [typeof (TypeDefTable)];
		}

		public TypeRefTable GetTypeRefTable ()
		{
			return (TypeRefTable) m_heap [typeof (TypeRefTable)];
		}

		public TypeSpecTable GetTypeSpecTable ()
		{
			return (TypeSpecTable) m_heap [typeof (TypeSpecTable)];
		}

		public override void VisitTableCollection (TableCollection coll)
		{
			if (m_heap.HasTable (typeof (ModuleTable))) {
				coll.Add (new ModuleTable ());
				ReadNumberOfRows (typeof (ModuleTable));
			}
			if (m_heap.HasTable (typeof (TypeRefTable))) {
				coll.Add (new TypeRefTable ());
				ReadNumberOfRows (typeof (TypeRefTable));
			}
			if (m_heap.HasTable (typeof (TypeDefTable))) {
				coll.Add (new TypeDefTable ());
				ReadNumberOfRows (typeof (TypeDefTable));
			}
			if (m_heap.HasTable (typeof (FieldTable))) {
				coll.Add (new FieldTable ());
				ReadNumberOfRows (typeof (FieldTable));
			}
			if (m_heap.HasTable (typeof (MethodTable))) {
				coll.Add (new MethodTable ());
				ReadNumberOfRows (typeof (MethodTable));
			}
			if (m_heap.HasTable (typeof (ParamTable))) {
				coll.Add (new ParamTable ());
				ReadNumberOfRows (typeof (ParamTable));
			}
			if (m_heap.HasTable (typeof (InterfaceImplTable))) {
				coll.Add (new InterfaceImplTable ());
				ReadNumberOfRows (typeof (InterfaceImplTable));
			}
			if (m_heap.HasTable (typeof (MemberRefTable))) {
				coll.Add (new MemberRefTable ());
				ReadNumberOfRows (typeof (MemberRefTable));
			}
			if (m_heap.HasTable (typeof (ConstantTable))) {
				coll.Add (new ConstantTable ());
				ReadNumberOfRows (typeof (ConstantTable));
			}
			if (m_heap.HasTable (typeof (CustomAttributeTable))) {
				coll.Add (new CustomAttributeTable ());
				ReadNumberOfRows (typeof (CustomAttributeTable));
			}
			if (m_heap.HasTable (typeof (FieldMarshalTable))) {
				coll.Add (new FieldMarshalTable ());
				ReadNumberOfRows (typeof (FieldMarshalTable));
			}
			if (m_heap.HasTable (typeof (DeclSecurityTable))) {
				coll.Add (new DeclSecurityTable ());
				ReadNumberOfRows (typeof (DeclSecurityTable));
			}
			if (m_heap.HasTable (typeof (ClassLayoutTable))) {
				coll.Add (new ClassLayoutTable ());
				ReadNumberOfRows (typeof (ClassLayoutTable));
			}
			if (m_heap.HasTable (typeof (FieldLayoutTable))) {
				coll.Add (new FieldLayoutTable ());
				ReadNumberOfRows (typeof (FieldLayoutTable));
			}
			if (m_heap.HasTable (typeof (StandAloneSigTable))) {
				coll.Add (new StandAloneSigTable ());
				ReadNumberOfRows (typeof (StandAloneSigTable));
			}
			if (m_heap.HasTable (typeof (EventMapTable))) {
				coll.Add (new EventMapTable ());
				ReadNumberOfRows (typeof (EventMapTable));
			}
			if (m_heap.HasTable (typeof (EventTable))) {
				coll.Add (new EventTable ());
				ReadNumberOfRows (typeof (EventTable));
			}
			if (m_heap.HasTable (typeof (PropertyMapTable))) {
				coll.Add (new PropertyMapTable ());
				ReadNumberOfRows (typeof (PropertyMapTable));
			}
			if (m_heap.HasTable (typeof (PropertyTable))) {
				coll.Add (new PropertyTable ());
				ReadNumberOfRows (typeof (PropertyTable));
			}
			if (m_heap.HasTable (typeof (MethodSemanticsTable))) {
				coll.Add (new MethodSemanticsTable ());
				ReadNumberOfRows (typeof (MethodSemanticsTable));
			}
			if (m_heap.HasTable (typeof (MethodImplTable))) {
				coll.Add (new MethodImplTable ());
				ReadNumberOfRows (typeof (MethodImplTable));
			}
			if (m_heap.HasTable (typeof (ModuleRefTable))) {
				coll.Add (new ModuleRefTable ());
				ReadNumberOfRows (typeof (ModuleRefTable));
			}
			if (m_heap.HasTable (typeof (TypeSpecTable))) {
				coll.Add (new TypeSpecTable ());
				ReadNumberOfRows (typeof (TypeSpecTable));
			}
			if (m_heap.HasTable (typeof (ImplMapTable))) {
				coll.Add (new ImplMapTable ());
				ReadNumberOfRows (typeof (ImplMapTable));
			}
			if (m_heap.HasTable (typeof (FieldRVATable))) {
				coll.Add (new FieldRVATable ());
				ReadNumberOfRows (typeof (FieldRVATable));
			}
			if (m_heap.HasTable (typeof (AssemblyTable))) {
				coll.Add (new AssemblyTable ());
				ReadNumberOfRows (typeof (AssemblyTable));
			}
			if (m_heap.HasTable (typeof (AssemblyProcessorTable))) {
				coll.Add (new AssemblyProcessorTable ());
				ReadNumberOfRows (typeof (AssemblyProcessorTable));
			}
			if (m_heap.HasTable (typeof (AssemblyOSTable))) {
				coll.Add (new AssemblyOSTable ());
				ReadNumberOfRows (typeof (AssemblyOSTable));
			}
			if (m_heap.HasTable (typeof (AssemblyRefTable))) {
				coll.Add (new AssemblyRefTable ());
				ReadNumberOfRows (typeof (AssemblyRefTable));
			}
			if (m_heap.HasTable (typeof (AssemblyRefProcessorTable))) {
				coll.Add (new AssemblyRefProcessorTable ());
				ReadNumberOfRows (typeof (AssemblyRefProcessorTable));
			}
			if (m_heap.HasTable (typeof (AssemblyRefOSTable))) {
				coll.Add (new AssemblyRefOSTable ());
				ReadNumberOfRows (typeof (AssemblyRefOSTable));
			}
			if (m_heap.HasTable (typeof (FileTable))) {
				coll.Add (new FileTable ());
				ReadNumberOfRows (typeof (FileTable));
			}
			if (m_heap.HasTable (typeof (ExportedTypeTable))) {
				coll.Add (new ExportedTypeTable ());
				ReadNumberOfRows (typeof (ExportedTypeTable));
			}
			if (m_heap.HasTable (typeof (ManifestResourceTable))) {
				coll.Add (new ManifestResourceTable ());
				ReadNumberOfRows (typeof (ManifestResourceTable));
			}
			if (m_heap.HasTable (typeof (NestedClassTable))) {
				coll.Add (new NestedClassTable ());
				ReadNumberOfRows (typeof (NestedClassTable));
			}
			if (m_heap.HasTable (typeof (GenericParamTable))) {
				coll.Add (new GenericParamTable ());
				ReadNumberOfRows (typeof (GenericParamTable));
			}
			if (m_heap.HasTable (typeof (MethodSpecTable))) {
				coll.Add (new MethodSpecTable ());
				ReadNumberOfRows (typeof (MethodSpecTable));
			}
			if (m_heap.HasTable (typeof (GenericParamConstraintTable))) {
				coll.Add (new GenericParamConstraintTable ());
				ReadNumberOfRows (typeof (GenericParamConstraintTable));
			}
		}

		public override void VisitAssemblyTable (AssemblyTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyRow ());
		}

		public override void VisitAssemblyOSTable (AssemblyOSTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyOSTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyOSRow ());
		}

		public override void VisitAssemblyProcessorTable (AssemblyProcessorTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyProcessorTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyProcessorRow ());
		}

		public override void VisitAssemblyRefTable (AssemblyRefTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyRefTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyRefRow ());
		}

		public override void VisitAssemblyRefOSTable (AssemblyRefOSTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyRefOSTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyRefOSRow ());
		}

		public override void VisitAssemblyRefProcessorTable (AssemblyRefProcessorTable table)
		{
			int number = GetNumberOfRows (typeof (AssemblyRefProcessorTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new AssemblyRefProcessorRow ());
		}

		public override void VisitClassLayoutTable (ClassLayoutTable table)
		{
			int number = GetNumberOfRows (typeof (ClassLayoutTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ClassLayoutRow ());
		}

		public override void VisitConstantTable (ConstantTable table)
		{
			int number = GetNumberOfRows (typeof (ConstantTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ConstantRow ());
		}

		public override void VisitCustomAttributeTable (CustomAttributeTable table)
		{
			int number = GetNumberOfRows (typeof (CustomAttributeTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new CustomAttributeRow ());
		}

		public override void VisitDeclSecurityTable (DeclSecurityTable table)
		{
			int number = GetNumberOfRows (typeof (DeclSecurityTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new DeclSecurityRow ());
		}

		public override void VisitEventTable (EventTable table)
		{
			int number = GetNumberOfRows (typeof (EventTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new EventRow ());
		}

		public override void VisitEventMapTable (EventMapTable table)
		{
			int number = GetNumberOfRows (typeof (EventMapTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new EventMapRow ());
		}

		public override void VisitExportedTypeTable (ExportedTypeTable table)
		{
			int number = GetNumberOfRows (typeof (ExportedTypeTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ExportedTypeRow ());
		}

		public override void VisitFieldTable (FieldTable table)
		{
			int number = GetNumberOfRows (typeof (FieldTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new FieldRow ());
		}

		public override void VisitFieldLayoutTable (FieldLayoutTable table)
		{
			int number = GetNumberOfRows (typeof (FieldLayoutTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new FieldLayoutRow ());
		}

		public override void VisitFieldMarshalTable (FieldMarshalTable table)
		{
			int number = GetNumberOfRows (typeof (FieldMarshalTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new FieldMarshalRow ());
		}

		public override void VisitFieldRVATable (FieldRVATable table)
		{
			int number = GetNumberOfRows (typeof (FieldRVATable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new FieldRVARow ());
		}

		public override void VisitFileTable (FileTable table)
		{
			int number = GetNumberOfRows (typeof (FileTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new FileRow ());
		}

		public override void VisitGenericParamTable (GenericParamTable table)
		{
			int number = GetNumberOfRows (typeof (GenericParamTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new GenericParamRow ());
		}

		public override void VisitGenericParamConstraintTable (GenericParamConstraintTable table)
		{
			int number = GetNumberOfRows (typeof (GenericParamConstraintTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new GenericParamConstraintRow ());
		}

		public override void VisitImplMapTable (ImplMapTable table)
		{
			int number = GetNumberOfRows (typeof (ImplMapTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ImplMapRow ());
		}

		public override void VisitInterfaceImplTable (InterfaceImplTable table)
		{
			int number = GetNumberOfRows (typeof (InterfaceImplTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new InterfaceImplRow ());
		}

		public override void VisitManifestResourceTable (ManifestResourceTable table)
		{
			int number = GetNumberOfRows (typeof (ManifestResourceTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ManifestResourceRow ());
		}

		public override void VisitMemberRefTable (MemberRefTable table)
		{
			int number = GetNumberOfRows (typeof (MemberRefTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new MemberRefRow ());
		}

		public override void VisitMethodTable (MethodTable table)
		{
			int number = GetNumberOfRows (typeof (MethodTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new MethodRow ());
		}

		public override void VisitMethodImplTable (MethodImplTable table)
		{
			int number = GetNumberOfRows (typeof (MethodImplTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new MethodImplRow ());
		}

		public override void VisitMethodSemanticsTable (MethodSemanticsTable table)
		{
			int number = GetNumberOfRows (typeof (MethodSemanticsTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new MethodSemanticsRow ());
		}

		public override void VisitMethodSpecTable (MethodSpecTable table)
		{
			int number = GetNumberOfRows (typeof (MethodSpecTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new MethodSpecRow ());
		}

		public override void VisitModuleTable (ModuleTable table)
		{
			int number = GetNumberOfRows (typeof (ModuleTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ModuleRow ());
		}

		public override void VisitModuleRefTable (ModuleRefTable table)
		{
			int number = GetNumberOfRows (typeof (ModuleRefTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ModuleRefRow ());
		}

		public override void VisitNestedClassTable (NestedClassTable table)
		{
			int number = GetNumberOfRows (typeof (NestedClassTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new NestedClassRow ());
		}

		public override void VisitParamTable (ParamTable table)
		{
			int number = GetNumberOfRows (typeof (ParamTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new ParamRow ());
		}

		public override void VisitPropertyTable (PropertyTable table)
		{
			int number = GetNumberOfRows (typeof (PropertyTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new PropertyRow ());
		}

		public override void VisitPropertyMapTable (PropertyMapTable table)
		{
			int number = GetNumberOfRows (typeof (PropertyMapTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new PropertyMapRow ());
		}

		public override void VisitStandAloneSigTable (StandAloneSigTable table)
		{
			int number = GetNumberOfRows (typeof (StandAloneSigTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new StandAloneSigRow ());
		}

		public override void VisitTypeDefTable (TypeDefTable table)
		{
			int number = GetNumberOfRows (typeof (TypeDefTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new TypeDefRow ());
		}

		public override void VisitTypeRefTable (TypeRefTable table)
		{
			int number = GetNumberOfRows (typeof (TypeRefTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new TypeRefRow ());
		}

		public override void VisitTypeSpecTable (TypeSpecTable table)
		{
			int number = GetNumberOfRows (typeof (TypeSpecTable));
			table.Rows = new RowCollection (number);
			for (int i = 0; i < number; i++)
				table.Rows.Add (new TypeSpecRow ());
		}

	}
}
