//
// MetadataTableWriter.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Thu Sep 29 22:11:54 CEST 2005
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil.Metadata {

	using System;
	using System.Collections;

	using Mono.Cecil.Binary;

	internal sealed class MetadataTableWriter : BaseMetadataTableVisitor {

		MetadataRoot m_root;
		TablesHeap m_heap;
		MetadataRowWriter m_mrrw;
		MemoryBinaryWriter m_binaryWriter;

		public MetadataTableWriter (MetadataWriter mrv, MemoryBinaryWriter writer)
		{
			m_root = mrv.GetMetadataRoot ();
			m_heap = m_root.Streams.TablesHeap;
			m_binaryWriter = writer;
			m_mrrw = new MetadataRowWriter (this);
		}

		public MetadataRoot GetMetadataRoot ()
		{
			return m_root;
		}

		public override IMetadataRowVisitor GetRowVisitor ()
		{
			return m_mrrw;
		}

		public MemoryBinaryWriter GetWriter ()
		{
			return m_binaryWriter;
		}

		public AssemblyTable GetAssemblyTable ()
		{
			Type tt = typeof (AssemblyTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyTable;

			AssemblyTable table = new AssemblyTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public AssemblyOSTable GetAssemblyOSTable ()
		{
			Type tt = typeof (AssemblyOSTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyOSTable;

			AssemblyOSTable table = new AssemblyOSTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public AssemblyProcessorTable GetAssemblyProcessorTable ()
		{
			Type tt = typeof (AssemblyProcessorTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyProcessorTable;

			AssemblyProcessorTable table = new AssemblyProcessorTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public AssemblyRefTable GetAssemblyRefTable ()
		{
			Type tt = typeof (AssemblyRefTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyRefTable;

			AssemblyRefTable table = new AssemblyRefTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public AssemblyRefOSTable GetAssemblyRefOSTable ()
		{
			Type tt = typeof (AssemblyRefOSTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyRefOSTable;

			AssemblyRefOSTable table = new AssemblyRefOSTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public AssemblyRefProcessorTable GetAssemblyRefProcessorTable ()
		{
			Type tt = typeof (AssemblyRefProcessorTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as AssemblyRefProcessorTable;

			AssemblyRefProcessorTable table = new AssemblyRefProcessorTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ClassLayoutTable GetClassLayoutTable ()
		{
			Type tt = typeof (ClassLayoutTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ClassLayoutTable;

			ClassLayoutTable table = new ClassLayoutTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ConstantTable GetConstantTable ()
		{
			Type tt = typeof (ConstantTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ConstantTable;

			ConstantTable table = new ConstantTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public CustomAttributeTable GetCustomAttributeTable ()
		{
			Type tt = typeof (CustomAttributeTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as CustomAttributeTable;

			CustomAttributeTable table = new CustomAttributeTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public DeclSecurityTable GetDeclSecurityTable ()
		{
			Type tt = typeof (DeclSecurityTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as DeclSecurityTable;

			DeclSecurityTable table = new DeclSecurityTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public EventTable GetEventTable ()
		{
			Type tt = typeof (EventTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as EventTable;

			EventTable table = new EventTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public EventMapTable GetEventMapTable ()
		{
			Type tt = typeof (EventMapTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as EventMapTable;

			EventMapTable table = new EventMapTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ExportedTypeTable GetExportedTypeTable ()
		{
			Type tt = typeof (ExportedTypeTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ExportedTypeTable;

			ExportedTypeTable table = new ExportedTypeTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public FieldTable GetFieldTable ()
		{
			Type tt = typeof (FieldTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as FieldTable;

			FieldTable table = new FieldTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public FieldLayoutTable GetFieldLayoutTable ()
		{
			Type tt = typeof (FieldLayoutTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as FieldLayoutTable;

			FieldLayoutTable table = new FieldLayoutTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public FieldMarshalTable GetFieldMarshalTable ()
		{
			Type tt = typeof (FieldMarshalTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as FieldMarshalTable;

			FieldMarshalTable table = new FieldMarshalTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public FieldRVATable GetFieldRVATable ()
		{
			Type tt = typeof (FieldRVATable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as FieldRVATable;

			FieldRVATable table = new FieldRVATable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public FileTable GetFileTable ()
		{
			Type tt = typeof (FileTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as FileTable;

			FileTable table = new FileTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public GenericParamTable GetGenericParamTable ()
		{
			Type tt = typeof (GenericParamTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as GenericParamTable;

			GenericParamTable table = new GenericParamTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public GenericParamConstraintTable GetGenericParamConstraintTable ()
		{
			Type tt = typeof (GenericParamConstraintTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as GenericParamConstraintTable;

			GenericParamConstraintTable table = new GenericParamConstraintTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ImplMapTable GetImplMapTable ()
		{
			Type tt = typeof (ImplMapTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ImplMapTable;

			ImplMapTable table = new ImplMapTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public InterfaceImplTable GetInterfaceImplTable ()
		{
			Type tt = typeof (InterfaceImplTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as InterfaceImplTable;

			InterfaceImplTable table = new InterfaceImplTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ManifestResourceTable GetManifestResourceTable ()
		{
			Type tt = typeof (ManifestResourceTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ManifestResourceTable;

			ManifestResourceTable table = new ManifestResourceTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public MemberRefTable GetMemberRefTable ()
		{
			Type tt = typeof (MemberRefTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as MemberRefTable;

			MemberRefTable table = new MemberRefTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public MethodTable GetMethodTable ()
		{
			Type tt = typeof (MethodTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as MethodTable;

			MethodTable table = new MethodTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public MethodImplTable GetMethodImplTable ()
		{
			Type tt = typeof (MethodImplTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as MethodImplTable;

			MethodImplTable table = new MethodImplTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public MethodSemanticsTable GetMethodSemanticsTable ()
		{
			Type tt = typeof (MethodSemanticsTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as MethodSemanticsTable;

			MethodSemanticsTable table = new MethodSemanticsTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public MethodSpecTable GetMethodSpecTable ()
		{
			Type tt = typeof (MethodSpecTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as MethodSpecTable;

			MethodSpecTable table = new MethodSpecTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ModuleTable GetModuleTable ()
		{
			Type tt = typeof (ModuleTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ModuleTable;

			ModuleTable table = new ModuleTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ModuleRefTable GetModuleRefTable ()
		{
			Type tt = typeof (ModuleRefTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ModuleRefTable;

			ModuleRefTable table = new ModuleRefTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public NestedClassTable GetNestedClassTable ()
		{
			Type tt = typeof (NestedClassTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as NestedClassTable;

			NestedClassTable table = new NestedClassTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public ParamTable GetParamTable ()
		{
			Type tt = typeof (ParamTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as ParamTable;

			ParamTable table = new ParamTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public PropertyTable GetPropertyTable ()
		{
			Type tt = typeof (PropertyTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as PropertyTable;

			PropertyTable table = new PropertyTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public PropertyMapTable GetPropertyMapTable ()
		{
			Type tt = typeof (PropertyMapTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as PropertyMapTable;

			PropertyMapTable table = new PropertyMapTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public StandAloneSigTable GetStandAloneSigTable ()
		{
			Type tt = typeof (StandAloneSigTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as StandAloneSigTable;

			StandAloneSigTable table = new StandAloneSigTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public TypeDefTable GetTypeDefTable ()
		{
			Type tt = typeof (TypeDefTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as TypeDefTable;

			TypeDefTable table = new TypeDefTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public TypeRefTable GetTypeRefTable ()
		{
			Type tt = typeof (TypeRefTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as TypeRefTable;

			TypeRefTable table = new TypeRefTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public TypeSpecTable GetTypeSpecTable ()
		{
			Type tt = typeof (TypeSpecTable);
			if (m_heap.HasTable (tt))
				return m_heap [tt] as TypeSpecTable;

			TypeSpecTable table = new TypeSpecTable ();
			table.Rows = new RowCollection ();
			m_heap.Valid |= 1L << TablesHeap.GetTableId (tt);
			m_heap.Tables.Add (table);
			return table;
		}

		public override void VisitTableCollection (TableCollection coll)
		{
			coll.Sort ();

			if (m_heap.HasTable (typeof (ModuleTable)))
				m_binaryWriter.Write (m_heap [typeof (ModuleTable)].Rows.Count);
			if (m_heap.HasTable (typeof (TypeRefTable)))
				m_binaryWriter.Write (m_heap [typeof (TypeRefTable)].Rows.Count);
			if (m_heap.HasTable (typeof (TypeDefTable)))
				m_binaryWriter.Write (m_heap [typeof (TypeDefTable)].Rows.Count);
			if (m_heap.HasTable (typeof (FieldTable)))
				m_binaryWriter.Write (m_heap [typeof (FieldTable)].Rows.Count);
			if (m_heap.HasTable (typeof (MethodTable)))
				m_binaryWriter.Write (m_heap [typeof (MethodTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ParamTable)))
				m_binaryWriter.Write (m_heap [typeof (ParamTable)].Rows.Count);
			if (m_heap.HasTable (typeof (InterfaceImplTable)))
				m_binaryWriter.Write (m_heap [typeof (InterfaceImplTable)].Rows.Count);
			if (m_heap.HasTable (typeof (MemberRefTable)))
				m_binaryWriter.Write (m_heap [typeof (MemberRefTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ConstantTable)))
				m_binaryWriter.Write (m_heap [typeof (ConstantTable)].Rows.Count);
			if (m_heap.HasTable (typeof (CustomAttributeTable)))
				m_binaryWriter.Write (m_heap [typeof (CustomAttributeTable)].Rows.Count);
			if (m_heap.HasTable (typeof (FieldMarshalTable)))
				m_binaryWriter.Write (m_heap [typeof (FieldMarshalTable)].Rows.Count);
			if (m_heap.HasTable (typeof (DeclSecurityTable)))
				m_binaryWriter.Write (m_heap [typeof (DeclSecurityTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ClassLayoutTable)))
				m_binaryWriter.Write (m_heap [typeof (ClassLayoutTable)].Rows.Count);
			if (m_heap.HasTable (typeof (FieldLayoutTable)))
				m_binaryWriter.Write (m_heap [typeof (FieldLayoutTable)].Rows.Count);
			if (m_heap.HasTable (typeof (StandAloneSigTable)))
				m_binaryWriter.Write (m_heap [typeof (StandAloneSigTable)].Rows.Count);
			if (m_heap.HasTable (typeof (EventMapTable)))
				m_binaryWriter.Write (m_heap [typeof (EventMapTable)].Rows.Count);
			if (m_heap.HasTable (typeof (EventTable)))
				m_binaryWriter.Write (m_heap [typeof (EventTable)].Rows.Count);
			if (m_heap.HasTable (typeof (PropertyMapTable)))
				m_binaryWriter.Write (m_heap [typeof (PropertyMapTable)].Rows.Count);
			if (m_heap.HasTable (typeof (PropertyTable)))
				m_binaryWriter.Write (m_heap [typeof (PropertyTable)].Rows.Count);
			if (m_heap.HasTable (typeof (MethodSemanticsTable)))
				m_binaryWriter.Write (m_heap [typeof (MethodSemanticsTable)].Rows.Count);
			if (m_heap.HasTable (typeof (MethodImplTable)))
				m_binaryWriter.Write (m_heap [typeof (MethodImplTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ModuleRefTable)))
				m_binaryWriter.Write (m_heap [typeof (ModuleRefTable)].Rows.Count);
			if (m_heap.HasTable (typeof (TypeSpecTable)))
				m_binaryWriter.Write (m_heap [typeof (TypeSpecTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ImplMapTable)))
				m_binaryWriter.Write (m_heap [typeof (ImplMapTable)].Rows.Count);
			if (m_heap.HasTable (typeof (FieldRVATable)))
				m_binaryWriter.Write (m_heap [typeof (FieldRVATable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyTable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyProcessorTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyProcessorTable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyOSTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyOSTable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyRefTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyRefTable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyRefProcessorTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyRefProcessorTable)].Rows.Count);
			if (m_heap.HasTable (typeof (AssemblyRefOSTable)))
				m_binaryWriter.Write (m_heap [typeof (AssemblyRefOSTable)].Rows.Count);
			if (m_heap.HasTable (typeof (FileTable)))
				m_binaryWriter.Write (m_heap [typeof (FileTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ExportedTypeTable)))
				m_binaryWriter.Write (m_heap [typeof (ExportedTypeTable)].Rows.Count);
			if (m_heap.HasTable (typeof (ManifestResourceTable)))
				m_binaryWriter.Write (m_heap [typeof (ManifestResourceTable)].Rows.Count);
			if (m_heap.HasTable (typeof (NestedClassTable)))
				m_binaryWriter.Write (m_heap [typeof (NestedClassTable)].Rows.Count);
			if (m_heap.HasTable (typeof (GenericParamTable)))
				m_binaryWriter.Write (m_heap [typeof (GenericParamTable)].Rows.Count);
			if (m_heap.HasTable (typeof (MethodSpecTable)))
				m_binaryWriter.Write (m_heap [typeof (MethodSpecTable)].Rows.Count);
			if (m_heap.HasTable (typeof (GenericParamConstraintTable)))
				m_binaryWriter.Write (m_heap [typeof (GenericParamConstraintTable)].Rows.Count);
		}
	}
}
