# Revised NGC and IC Catalog, Wolfgang Steinicke, April 5, 2005
# http://www.ngcic.org/steinicke/default.htm
#
# Augmented by
# Revised 3rd Reference Catalog of Bright Galaxies (RC3,VII/155)
# http://cdsweb.u-strasbg.fr/viz-bin/Cat?VII/155
#
# Augmented by
# Mark III Catalog of Galaxy Peculiar Velocities (Willick+ 1997,VII/198)
# http://cdsweb.u-strasbg.fr/viz-bin/Cat?VII/198#sRM2.18
#
# Augmented by distances from
# The SBF Survey of Galaxy Distances. IV.
# SBF Magnitudes, Colors, and Distances, 
# J.L. Tonry et al., Astrophys J 546, 681 (2001)
#
# Augmented by distances from
# Compilation of "200 Brightest Galaxies"
# http://www.anzwers.org/free/universe/galax200.html
#
# Using today's Hubble constant = 72 [km/sec/Mpc]  (WMAP 2005)
#
# Abreviations for various distance methods used:
# S= SBF (Surface Brightness Fluctuations), T-F= Tully-Fischer
# V = rad. velocity in CMB frame & Hubble law 
# C=Cepheids, P=photometric, N(G)=planetary nebula (globular cluster) luminosity function
#
# Adapted for Celestia with Perl script: deepsky.pl Revision: 1.20 
# Processed 2006-1-3 2 2 0 21:19:26 UTC
#
# by Dr. Fridger Schrempp, fridger.schrempp@desy.de
# ------------------------------------------------------ 


Galaxy "NGC 1:UGC 57:MCG 4-1-25:ZWG 477.54"
{
        Type  "Sb"
        RA            0.1208
        Dec          27.7089
        Distance   2.073e+08  # method: T-F
        Radius     5.127e+04
        AbsMag        -20.42
        Axis    [  0.0781   0.9082  -0.4112]
        Angle    197.1490
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1"
}

Galaxy "NGC 2:UGC 59:MCG 4-1-26:ZWG 477.55"
{
        Type  "Sb"
        RA            0.1214
        Dec          27.6786
        Distance   3.376e+08  # method: T-F
        Radius     4.911e+04
        AbsMag        -20.07
        Axis    [  0.0198   0.9315  -0.3633]
        Angle    189.8103
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2"
}

Galaxy "NGC 3:UGC 58:MCG 1-1-37:ZWG 408.35"
{
        Type  "S0"
        RA            0.1211
        Dec           8.3014
        Distance   1.608e+08  # method: V
        Radius     2.572e+04
        AbsMag        -19.06
        Axis    [  0.1555   0.9159  -0.3700]
        Angle    188.5756
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3"
}

Galaxy "NGC 4"
{
        Type  "S0"
        RA            0.1233
        Dec           8.3739
        Distance   5.098e+08  # distance uncertain!
        Radius     4.449e+04
        AbsMag        -19.07
        Axis    [  0.1625   0.9532   0.2550]
        Angle    166.6854
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4"
}

Galaxy "NGC 5:UGC 62:MCG 6-1-13:ZWG 517.17"
{
        Type  "E0"
        RA            0.1300
        Dec          35.3628
        Distance   3.163e+08  # distance uncertain!
        Radius      5.52e+04
        AbsMag        -20.13
        Axis    [  0.4157   0.8614  -0.2919]
        Angle    210.6705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5"
}

Galaxy "NGC 7:ESO 409-22:MCG 5-1-37:AM 0005-301"
{
        Type  "SBc"
        RA            0.1389
        Dec         -29.9164
        Distance   7.765e+07  # method: T-F
        Radius     2.484e+04
        AbsMag        -17.78
        Axis    [  0.2321   0.9204   0.3147]
        Angle    197.4218
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7"
}

Galaxy "NGC 9:UGC 78:MCG 4-1-30:ZWG 477.59"
{
        Type  "Sb"
        RA            0.1483
        Dec          23.8178
        Distance   1.538e+08  # method: T-F
        Radius     2.461e+04
        AbsMag        -18.87
        Axis    [  0.0225   0.7569  -0.6532]
        Angle    209.8479
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 9"
}

Galaxy "NGC 10:ESO 349-32:MCG 6-1-24:AM 0006-340"
{
        Type  "SBc"
        RA            0.1428
        Dec         -33.8578
        Distance   2.909e+08  # method: T-F
        Radius     1.015e+05
        AbsMag        -21.65
        Axis    [  0.4139   0.8354   0.3617]
        Angle    193.0380
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 10"
}

Galaxy "NGC 11:UGC 73:MCG 6-1-15:ZWG 517.20"
{
        Type  "Sa"
        RA            0.1450
        Dec          37.4481
        Distance   1.768e+08  # distance uncertain!
        Radius     3.857e+04
        AbsMag        -19.07
        Axis    [ -0.3206   0.8792  -0.3525]
        Angle    177.1576
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 11"
}

Galaxy "NGC 12:UGC 74:MCG 1-1-40:ZWG 408.38"
{
        Type  "SBc"
        RA            0.1456
        Dec           4.6122
        Distance   1.626e+08  # method: V
        Radius     2.601e+04
        AbsMag        -19.49
        Axis    [  0.4243   0.7925  -0.4380]
        Angle    207.4736
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 12"
}

Galaxy "NGC 13:UGC 77:MCG 5-1-34:ZWG 498.81"
{
        Type  "Sb"
        RA            0.1464
        Dec          33.4331
        Distance   2.153e+08  # method: T-F
        Radius     7.203e+04
        AbsMag           -20
        Axis    [ -0.1847   0.9766   0.1103]
        Angle    160.7278
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 13"
}

Galaxy "NGC 14:UGC 75:MCG 3-1-26:ZWG 456.34"
{
        Type  "Irr"
        RA            0.1461
        Dec          15.8158
        Distance   2.351e+07  # method: V
        Radius          9575
        AbsMag        -16.49
        Axis    [  0.2794   0.9140   0.2942]
        Angle    152.7668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 14"
}

Galaxy "NGC 15:UGC 82:MCG 3-1-27:ZWG 456.35"
{
        Type  "Sa"
        RA            0.1506
        Dec          21.6250
        Distance   2.715e+08  # method: V
        Radius     3.949e+04
        AbsMag         -19.8
        Axis    [  0.1401   0.9534   0.2672]
        Angle    154.5411
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 15"
}

Galaxy "NGC 16:UGC 80:MCG 4-1-32:ZWG 477.61"
{
        Type  "S0"
        RA            0.1511
        Dec          27.7300
        Distance   1.237e+08  # method: V
        Radius     3.238e+04
        AbsMag        -19.89
        Axis    [  0.0833   0.9239   0.3736]
        Angle    146.1349
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 16"
}

Galaxy "NGC 17:NGC 34:MCG 2-1-32:MK 938"
{
        Type  "S0"
        RA            0.1850
        Dec         -12.1078
        Distance   2.525e+08  # method: V
        Radius     7.711e+04
        AbsMag        -19.14
        Axis    [  0.2279   0.9218   0.3137]
        Angle    180.8864
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 17"
}

Galaxy "NGC 19:UGC 98:MCG 5-1-46:ZWG 499.65"
{
        Type  "SBc"
        RA            0.1778
        Dec          32.9828
        Distance   2.181e+08  # method: T-F
        Radius      3.49e+04
        AbsMag        -20.03
        Axis    [  0.0174   0.9864   0.1636]
        Angle    153.4652
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 19"
}

Galaxy "NGC 20:NGC 6:UGC 84:MCG 5-1-36"
{
        Type  "S0"
        RA            0.1589
        Dec          33.3089
        Distance    2.15e+08  # method: V
        Radius     5.316e+04
        AbsMag        -19.99
        Axis    [  0.2010   0.8545  -0.4791]
        Angle    221.1568
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 20"
}

Galaxy "NGC 22:UGC 86:MCG 5-1-39:ZWG 499.55"
{
        Type  "Sb"
        RA            0.1633
        Dec          27.8328
        Distance   3.618e+08  # method: V
        Radius      6.84e+04
        AbsMag        -20.62
        Axis    [  0.0558   0.7517  -0.6571]
        Angle    220.5093
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 22"
}

Galaxy "NGC 23:UGC 89:MCG 4-1-33:MK 545"
{
        Type  "SBa"
        RA            0.1647
        Dec          25.9239
        Distance   2.128e+08  # method: T-F
        Radius     6.499e+04
        AbsMag        -21.27
        Axis    [  0.1392   0.8933   0.4274]
        Angle    142.3865
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 23"
}

Galaxy "NGC 24:ESO 472-16:MCG 4-1-18:UGCA 2"
{
        Type  "Sc"
        RA            0.1656
        Dec         -24.9644
        Distance   3.633e+07  # method: T-F
        Radius     3.065e+04
        AbsMag        -18.03
        Axis    [  0.2170   0.9607   0.1730]
        Angle    191.2471
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 24"
}

Galaxy "NGC 25:ESO 149-19:FAIR 1:AM 0007-571"
{
        Type  "S0"
        RA            0.1664
        Dec         -57.0203
        Distance   4.199e+08  # method: V
        Radius     8.551e+04
        AbsMag        -21.95
        Axis    [  0.6830   0.7156  -0.1464]
        Angle    194.7706
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 25"
}

Galaxy "NGC 26:UGC 94:MCG 4-1-34:ZWG 477.64"
{
        Type  "Sb"
        RA            0.1736
        Dec          25.8322
        Distance   2.155e+08  # method: T-F
        Radius     6.582e+04
        AbsMag         -20.4
        Axis    [  0.0926   0.9565  -0.2766]
        Angle    184.9164
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 26"
}

Galaxy "NGC 27:UGC 96:MCG 5-1-44:ZWG 499.63"
{
        Type  "Sb"
        RA            0.1756
        Dec          28.9969
        Distance   3.154e+08  # method: T-F
        Radius     5.505e+04
        AbsMag        -20.43
        Axis    [ -0.1034   0.9086  -0.4046]
        Angle    186.0316
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 27"
}

Galaxy "NGC 28:AM 0007-571"
{
        Type  "E1"
        RA            0.1736
        Dec         -56.9889
        Distance   3.163e+08  # distance uncertain!
        Radius      3.68e+04
        AbsMag        -20.13
        Axis    [  0.9196   0.2250  -0.3221]
        Angle    209.0624
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 28"
}

Galaxy "NGC 29:NGC 21:UGC 100:MCG 5-1-48"
{
        Type  "SBc"
        RA            0.1797
        Dec          33.3519
        Distance   2.387e+08  # method: T-F
        Radius     5.208e+04
        AbsMag        -20.72
        Axis    [ -0.1387   0.7534  -0.6428]
        Angle    203.6481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 29"
}

Galaxy "NGC 31:ESO 149-20:AM 0007-571"
{
        Type  "Sc"
        RA            0.1772
        Dec         -56.9861
        Distance   2.125e+08  # distance uncertain!
        Radius     4.019e+04
        AbsMag        -19.07
        Axis    [  0.4853   0.6913   0.5353]
        Angle    209.9998
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 31"
}

Galaxy "NGC 35:MCG 2-1-33:NPM 1:IRAS 00086-1217"
{
        Type  "Sb"
        RA            0.1861
        Dec         -12.0206
        Distance   2.125e+08  # distance uncertain!
        Radius     2.164e+04
        AbsMag        -19.07
        Axis    [  0.3870   0.7422  -0.5472]
        Angle    198.1668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 35"
}

Galaxy "NGC 36:UGC 106:MCG 1-1-43:ZWG 408.40"
{
        Type  "SBb"
        RA            0.1894
        Dec           6.3889
        Distance   2.608e+08  # method: V
        Radius     8.343e+04
        AbsMag        -20.41
        Axis    [  0.1797   0.9115   0.3699]
        Angle    163.9564
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 36"
}

Galaxy "NGC 37:ESO 149-22:AM 0007-571"
{
        Type  "S0"
        RA            0.1897
        Dec         -56.9569
        Distance   1.851e+08  # distance uncertain!
        Radius     2.962e+04
        AbsMag        -19.07
        Axis    [  0.6342   0.7087   0.3091]
        Angle    203.3918
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 37"
}

Galaxy "NGC 38:MCG 1-1-47"
{
        Type  "Sa"
        RA            0.1964
        Dec          -5.5864
        Distance    1.47e+08  # distance uncertain!
        Radius     2.994e+04
        AbsMag        -19.07
        Axis    [  0.5773   0.8097  -0.1055]
        Angle    186.2238
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 38"
}

Galaxy "NGC 39:UGC 114:MCG 5-1-52:ZWG 499.76"
{
        Type  "Sc"
        RA            0.2050
        Dec          31.0608
        Distance   2.057e+08  # method: V
        Radius      3.29e+04
        AbsMag         -19.7
        Axis    [  0.2181   0.8990  -0.3799]
        Angle    204.2696
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 39"
}

Galaxy "NGC 41:MCG 4-1-39:ZWG 478.42:KUG 0010+217"
{
        Type  "Sc"
        RA            0.2133
        Dec          22.0239
        Distance   2.813e+08  # method: T-F
        Radius     3.273e+04
        AbsMag        -20.08
        Axis    [  0.0713   0.8923  -0.4458]
        Angle    194.2548
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 41"
}

Galaxy "NGC 42:UGC 118:MCG 4-1-41:ZWG 478.43"
{
        Type  "S0"
        RA            0.2156
        Dec          22.1008
        Distance    2.44e+08  # distance uncertain!
        Radius     3.904e+04
        AbsMag        -19.07
        Axis    [  0.0324   0.9191  -0.3927]
        Angle    188.3154
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 42"
}

Galaxy "NGC 43:UGC 120:MCG 5-1-54:ZWG 499.79"
{
        Type  "S0"
        RA            0.2167
        Dec          30.9156
        Distance   2.024e+08  # method: V
        Radius      4.71e+04
        AbsMag        -20.26
        Axis    [  0.3778   0.8885   0.2605]
        Angle    130.7731
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 43"
}

Galaxy "NGC 45:ESO 473-1:MCG 4-1-21:UGCA 4"
{
        Type  "SBc"
        RA            0.2344
        Dec         -23.1814
        Distance   4.725e+07  # method: T-F
        Radius     5.841e+04
        AbsMag         -19.5
        Axis    [  0.4417   0.6671  -0.5999]
        Angle    195.0738
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 45"
}

Galaxy "NGC 47:NGC 58:MCG 1-1-55:IRAS 00119-0726"
{
        Type  "SBc"
        RA            0.2417
        Dec          -7.1678
        Distance   2.429e+08  # method: V
        Radius     8.126e+04
        AbsMag        -20.46
        Axis    [  0.5723   0.8119  -0.1157]
        Angle    186.3011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 47"
}

Galaxy "NGC 48:UGC 133:MCG 8-1-31:ZWG 549.27"
{
        Type  "SBc"
        RA            0.2339
        Dec          48.2350
        Distance   6.872e+07  # method: V
        Radius     1.599e+04
        AbsMag        -16.92
        Axis    [  0.0056   0.9454   0.3259]
        Angle    128.6883
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 48"
}

Galaxy "NGC 49:UGC 136:MCG 8-1-33:ZWG 549.29"
{
        Type  "S0"
        RA            0.2394
        Dec          48.2472
        Distance   2.226e+08  # distance uncertain!
        Radius     3.561e+04
        AbsMag        -19.07
        Axis    [ -0.0172   0.8154  -0.5787]
        Angle    237.4948
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 49"
}

Galaxy "NGC 50:MCG 1-1-58"
{
        Type  "S0"
        RA            0.2456
        Dec          -7.3450
        Distance   9.715e+07  # distance uncertain!
        Radius     3.391e+04
        AbsMag        -19.07
        Axis    [  0.2801   0.5719  -0.7711]
        Angle    208.1274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 50"
}

Galaxy "NGC 51:UGC 138:MCG 8-1-35:ZWG 549.31"
{
        Type  "S0"
        RA            0.2428
        Dec          48.2561
        Distance    1.47e+08  # distance uncertain!
        Radius      2.78e+04
        AbsMag        -19.07
        Axis    [  0.0993   0.9651   0.2422]
        Angle    128.0231
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 51"
}

Galaxy "NGC 52:UGC 140:MCG 3-1-30:ZWG 456.42"
{
        Type  "Sc"
        RA            0.2444
        Dec          18.5817
        Distance   2.288e+08  # method: V
        Radius     7.322e+04
        AbsMag        -19.83
        Axis    [ -0.1640   0.8550  -0.4920]
        Angle    178.5904
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 52"
}

Galaxy "NGC 53:ESO 111-20:FAIR 3:AM 0012-603"
{
        Type  "SBb"
        RA            0.2453
        Dec         -60.3286
        Distance   2.006e+08  # method: V
        Radius     5.836e+04
        AbsMag        -20.44
        Axis    [  0.5742   0.3336  -0.7477]
        Angle    178.4305
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 53"
}

Galaxy "NGC 54:MCG 1-1-60"
{
        Type  "Sa"
        RA            0.2519
        Dec          -7.1067
        Distance   1.768e+08  # distance uncertain!
        Radius     3.343e+04
        AbsMag        -19.07
        Axis    [  0.2062   0.9509  -0.2308]
        Angle    181.3781
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 54"
}

Galaxy "NGC 55:ESO 293-50:MCG 7-1-13"
{
        Type  "Irr"
        RA            0.2522
        Dec         -39.2194
        Distance     4.9e+06  # method: P
        Radius     2.224e+04
        AbsMag        -17.47
        Axis    [  0.3366   0.8768  -0.3435]
        Angle    178.2645
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 55"
}

Galaxy "NGC 57:UGC 145:MCG 3-1-31:ZWG 456.46"
{
        Type  "E0"
        RA            0.2583
        Dec          17.3292
        Distance   2.309e+08  # method: V
        Radius      7.39e+04
        AbsMag        -21.45
        Axis    [  0.6273   0.7742   0.0840]
        Angle    151.4480
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 57"
}

Galaxy "NGC 59:ESO 539-4:MCG 4-1-26:KDWG 2"
{
        Type  "S0"
        RA            0.2569
        Dec         -21.4447
        Distance    8.86e+07  # distance uncertain!
        Radius      3.35e+04
        AbsMag        -19.07
        Axis    [  0.3592   0.7877  -0.5005]
        Angle    186.2118
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 59"
}

Galaxy "NGC 60:UGC 150:MCG 0-1-48:ZWG 382.37"
{
        Type  "Sc"
        RA            0.2661
        Dec          -0.3036
        Distance    2.03e+08  # distance uncertain!
        Radius     3.838e+04
        AbsMag        -19.07
        Axis    [  0.3941   0.6519  -0.6479]
        Angle    219.7989
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 60"
}

Galaxy "NGC 61-1:NGC 61A:MCG 1-1-62:VV 742"
{
        Type  "S0"
        RA            0.2733
        Dec          -6.3172
        Distance   1.612e+08  # distance uncertain!
        Radius     2.579e+04
        AbsMag        -19.07
        Axis    [  0.3432   0.8719   0.3492]
        Angle    169.0051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 61-1"
}

Galaxy "NGC 61-2:NGC 61B:MCG 1-1-63:VV 742"
{
        Type  "S0"
        RA            0.2733
        Dec          -6.3222
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.2449   0.9692   0.0269]
        Angle    178.4015
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 61-2"
}

Galaxy "NGC 62:MCG 2-1-43:IRAS 00145-1345"
{
        Type  "Sa"
        RA            0.2847
        Dec         -13.4864
        Distance   1.612e+08  # distance uncertain!
        Radius     2.579e+04
        AbsMag        -19.07
        Axis    [  0.4127   0.7518  -0.5142]
        Angle    196.1794
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 62"
}

Galaxy "NGC 63:UGC 167:MCG 2-1-30:ZWG 433.42"
{
        Type  "S0"
        RA            0.2958
        Dec          11.4500
        Distance   6.102e+07  # method: S
        Radius     1.509e+04
        AbsMag        -18.66
        Axis    [  0.2330   0.9101  -0.3426]
        Angle    189.2425
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 63"
}

Galaxy "NGC 64:MCG 1-1-68:IRAS 00149-0706"
{
        Type  "SBc"
        RA            0.2917
        Dec          -6.8250
        Distance   1.341e+08  # distance uncertain!
        Radius     3.121e+04
        AbsMag        -19.07
        Axis    [  0.3923   0.8921   0.2243]
        Angle    171.5589
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 64"
}

Galaxy "NGC 65:ESO 473-10A:MCG 4-2-1"
{
        Type  "S0"
        RA            0.3161
        Dec         -22.8800
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.4891   0.7091   0.5080]
        Angle    170.6811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 65"
}

Galaxy "NGC 66:ESO 473-10:MCG 4-2-2:AM 0016-231"
{
        Type  "SBb"
        RA            0.3178
        Dec         -22.9364
        Distance   3.291e+08  # method: V
        Radius     5.743e+04
        AbsMag        -20.82
        Axis    [  0.4213   0.8562   0.2991]
        Angle    182.2322
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 66"
}

Galaxy "NGC 67:MCG 5-1-64:ZWG 499.104:ARAK 4"
{
        Type  "E0"
        RA            0.3039
        Dec          30.0633
        Distance   2.956e+08  # method: V
        Radius      1.29e+04
        AbsMag        -18.99
        Axis    [  0.5456   0.8378  -0.0191]
        Angle    154.8394
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 67"
}

Galaxy "NGC 67A:ARP 113:VV 166"
{
        Type  "E5"
        RA            0.3033
        Dec          30.0553
        Distance   4.787e+08  # distance uncertain!
        Radius     2.785e+04
        AbsMag        -20.13
        Axis    [  0.4817   0.8428  -0.2401]
        Angle    196.2098
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 67A"
}

Galaxy "NGC 68:UGC 170:MCG 5-1-65:ZWG 499.106"
{
        Type  "S0"
        RA            0.3050
        Dec          30.0725
        Distance   2.485e+08  # method: V
        Radius     4.338e+04
        AbsMag        -20.21
        Axis    [  0.3705   0.8463   0.3827]
        Angle    122.1325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 68"
}

Galaxy "NGC 69:MCG 5-1-66:ZWG 499.105:ARAK 5"
{
        Type  "S0"
        RA            0.3056
        Dec          30.0406
        Distance   2.916e+08  # method: V
        Radius      2.12e+04
        AbsMag        -18.96
        Axis    [  0.0934   0.9685   0.2310]
        Angle    148.7753
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 69"
}

Galaxy "NGC 70:IC 1539:UGC 174:MCG 5-1-67"
{
        Type  "Sc"
        RA            0.3061
        Dec          30.0789
        Distance   3.104e+08  # method: V
        Radius     7.223e+04
        AbsMag        -20.69
        Axis    [  0.3259   0.8544   0.4047]
        Angle    124.2985
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 70"
}

Galaxy "NGC 71:UGC 173:MCG 5-1-68:ZWG 499.107"
{
        Type  "S0"
        RA            0.3064
        Dec          30.0631
        Distance   2.899e+08  # method: V
        Radius     5.059e+04
        AbsMag        -20.44
        Axis    [  0.0736   0.8829  -0.4637]
        Angle    201.1059
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 71"
}

Galaxy "NGC 72:UGC 176:MCG 5-1-69:ZWG 499.109"
{
        Type  "SBb"
        RA            0.3078
        Dec          30.0406
        Distance    3.14e+08  # method: V
        Radius     5.024e+04
        AbsMag        -20.32
        Axis    [  0.2672   0.9103   0.3161]
        Angle    134.7335
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 72"
}

Galaxy "NGC 72A:MCG 5-1-70:ZWG 499.110:ARAK 6"
{
        Type  "E3"
        RA            0.3094
        Dec          30.0361
        Distance    2.94e+08  # method: V
        Radius     1.283e+04
        AbsMag        -19.07
        Axis    [  0.5851   0.7701   0.2541]
        Angle    113.4188
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 72A"
}

Galaxy "NGC 73:MCG 3-1-26:NPM 1"
{
        Type  "Sc"
        RA            0.3106
        Dec         -15.3217
        Distance   3.348e+08  # method: V
        Radius     8.279e+04
        AbsMag        -20.56
        Axis    [  0.3798   0.6829  -0.6240]
        Angle    197.1277
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 73"
}

Galaxy "NGC 74:MCG 5-1-71"
{
        Type  "Sb"
        RA            0.3136
        Dec          30.0614
        Distance   3.527e+08  # distance uncertain!
        Radius     4.104e+04
        AbsMag        -19.07
        Axis    [ -0.1463   0.8525  -0.5018]
        Angle    188.0566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 74"
}

Galaxy "NGC 75:UGC 182:MCG 1-1-51:ZWG 408.48"
{
        Type  "S0"
        RA            0.3239
        Dec           6.4497
        Distance   1.688e+08  # distance uncertain!
        Radius     2.701e+04
        AbsMag        -19.07
        Axis    [  0.6382   0.6652   0.3877]
        Angle    129.1808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 75"
}

Galaxy "NGC 76:UGC 185:MCG 5-1-72:ZWG 499.111"
{
        Type  "E0"
        RA            0.3269
        Dec          29.9342
        Distance   3.204e+08  # method: V
        Radius      4.66e+04
        AbsMag        -20.96
        Axis    [  0.5317   0.8427  -0.0850]
        Angle    166.3762
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 76"
}

Galaxy "NGC 77:ESO 473-15:NPM 1"
{
        Type  "S0"
        RA            0.3336
        Dec         -22.5322
        Distance   2.934e+08  # distance uncertain!
        Radius     1.707e+04
        AbsMag        -19.07
        Axis    [  0.6954   0.5175   0.4986]
        Angle    149.4006
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 77"
}

Galaxy "NGC 78-1:NGC 78A:UGC 193:MCG 0-2-4"
{
        Type  "SBa"
        RA            0.3403
        Dec           0.8264
        Distance   2.132e+08  # method: V
        Radius     3.411e+04
        AbsMag        -19.88
        Axis    [  0.3045   0.9443  -0.1246]
        Angle    179.1382
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 78-1"
}

Galaxy "NGC 78-2:NGC 78B:UGC 194:MCG 0-2-5"
{
        Type  "S0"
        RA            0.3408
        Dec           0.8333
        Distance   2.309e+08  # method: V
        Radius     3.359e+04
        AbsMag        -19.85
        Axis    [  0.2746   0.7947  -0.5413]
        Angle    197.3158
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 78-2"
}

Galaxy "NGC 79:MCG 4-2-3:ZWG 479.3:NPM 1"
{
        Type  "S0"
        RA            0.3506
        Dec          22.5672
        Distance   2.125e+08  # distance uncertain!
        Radius     1.855e+04
        AbsMag        -19.07
        Axis    [  0.5934   0.7431   0.3095]
        Angle    118.4546
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 79"
}

Galaxy "NGC 80:UGC 203:MCG 4-2-4:ZWG 479.6"
{
        Type  "S0"
        RA            0.3528
        Dec          22.3578
        Distance   3.437e+08  # method: T-F
        Radius     7.997e+04
        AbsMag        -21.91
        Axis    [  0.5943   0.7419   0.3105]
        Angle    118.5684
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 80"
}

Galaxy "NGC 81:NPM 1"
{
        Type  "S0"
        RA            0.3536
        Dec          22.3833
        Distance   4.241e+08  # distance uncertain!
        Radius     1.234e+04
        AbsMag        -19.07
        Axis    [  0.0372   0.9869  -0.1568]
        Angle    173.0193
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 81"
}

Galaxy "NGC 83:UGC 206:MCG 4-2-5:ZWG 479.8"
{
        Type  "E0"
        RA            0.3561
        Dec          22.4342
        Distance   3.437e+08  # method: T-F
        Radius     7.498e+04
        AbsMag        -21.51
        Axis    [  0.6165   0.7297   0.2957]
        Angle    117.5835
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 83"
}

Galaxy "NGC 85:NGC 85A:MCG 4-2-7:ZWG 479.9"
{
        Type  "S0"
        RA            0.3569
        Dec          22.5122
        Distance   3.072e+08  # distance uncertain!
        Radius     3.128e+04
        AbsMag        -19.07
        Axis    [  0.0837   0.8024  -0.5910]
        Angle    206.4637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 85"
}

Galaxy "NGC 86:MCG 4-2-9:ZWG 479.11"
{
        Type  "S0"
        RA            0.3578
        Dec          22.5564
        Distance   3.126e+08  # method: T-F
        Radius     3.182e+04
        AbsMag        -19.21
        Axis    [  0.0667   0.8868   0.4572]
        Angle    149.6077
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 86"
}

Galaxy "NGC 87:ESO 194-8:AM 0018-485"
{
        Type  "Irr"
        RA            0.3539
        Dec         -48.6289
        Distance   1.491e+08  # method: V
        Radius     1.952e+04
        AbsMag         -18.6
        Axis    [  0.5302   0.3626  -0.7664]
        Angle    188.7950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 87"
}

Galaxy "NGC 88:ESO 194-10:AM 0018-485"
{
        Type  "SBa"
        RA            0.3561
        Dec         -48.6397
        Distance   1.465e+08  # method: V
        Radius     1.704e+04
        AbsMag        -18.26
        Axis    [  0.5713   0.5497  -0.6095]
        Angle    183.1547
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 88"
}

Galaxy "NGC 89:ESO 194-11:AM 0018-485"
{
        Type  "SBa"
        RA            0.3567
        Dec         -48.6653
        Distance   1.397e+08  # method: V
        Radius     2.438e+04
        AbsMag        -18.96
        Axis    [  0.5176   0.5796  -0.6294]
        Angle    176.7950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 89"
}

Galaxy "NGC 90:UGC 208:MCG 4-2-11:ZWG 479.13"
{
        Type  "SBc"
        RA            0.3642
        Dec          22.4006
        Distance   2.271e+08  # method: V
        Radius     6.277e+04
        AbsMag        -19.71
        Axis    [ -0.0579   0.8532  -0.5184]
        Angle    188.3130
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 90"
}

Galaxy "NGC 92:ESO 194-12:AM 0018-485"
{
        Type  "Sa"
        RA            0.3586
        Dec         -48.6247
        Distance   1.438e+08  # method: V
        Radius     3.975e+04
        AbsMag        -19.42
        Axis    [  0.5077   0.5884  -0.6292]
        Angle    175.5924
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 92"
}

Galaxy "NGC 93:UGC 209:MCG 4-2-12:ZWG 479.15"
{
        Type  "Sb"
        RA            0.3675
        Dec          22.4089
        Distance    3.08e+08  # method: T-F
        Radius     6.272e+04
        AbsMag        -20.48
        Axis    [  0.0304   0.9894   0.1420]
        Angle    160.2914
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 93"
}

Galaxy "NGC 94-1:ZWG 479.17"
{
        Type  "S0"
        RA            0.3703
        Dec          22.4833
        Distance   2.802e+08  # distance uncertain!
        Radius      1.63e+04
        AbsMag        -19.07
        Axis    [  0.0912   0.9554   0.2807]
        Angle    153.4862
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 94-1"
}

Galaxy "NGC 94-2:NPM 1"
{
        Type  "S0"
        RA            0.3703
        Dec          22.4739
        Distance   4.241e+08  # distance uncertain!
        Radius     2.467e+04
        AbsMag        -19.07
        Axis    [ -0.0366   0.7725  -0.6339]
        Angle    197.7768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 94-2"
}

Galaxy "NGC 95:UGC 214:MCG 2-2-3:ZWG 434.3"
{
        Type  "SBc"
        RA            0.3703
        Dec          10.4919
        Distance   2.284e+08  # method: V
        Radius     4.983e+04
        AbsMag        -21.03
        Axis    [  0.2837   0.9361  -0.2081]
        Angle    181.3011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 95"
}

Galaxy "NGC 96:MCG 4-2-14"
{
        Type  "S0"
        RA            0.3714
        Dec          22.5467
        Distance   2.802e+08  # distance uncertain!
        Radius     2.445e+04
        AbsMag        -19.07
        Axis    [  0.5956   0.7415   0.3090]
        Angle    118.2932
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 96"
}

Galaxy "NGC 97:UGC 216:MCG 5-2-7:ZWG 500.9"
{
        Type  "E0"
        RA            0.3750
        Dec          29.7456
        Distance   2.022e+08  # method: V
        Radius     3.823e+04
        AbsMag        -20.56
        Axis    [  0.5928   0.7641   0.2543]
        Angle    112.9972
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 97"
}

Galaxy "NGC 98:ESO 242-5"
{
        Type  "SBc"
        RA            0.3803
        Dec         -45.2683
        Distance   2.687e+08  # method: V
        Radius     6.254e+04
        AbsMag        -21.18
        Axis    [  0.5596   0.6013   0.5703]
        Angle    186.7583
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 98"
}

Galaxy "NGC 99:UGC 230:MCG 2-2-6:ZWG 434.6"
{
        Type  "Sc"
        RA            0.3997
        Dec          15.7700
        Distance   2.256e+08  # method: V
        Radius     3.281e+04
        AbsMag         -20.2
        Axis    [  0.4268   0.8951   0.1292]
        Angle    155.1642
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 99"
}

Galaxy "NGC 100:UGC 231:MCG 3-2-9:ZWG 457.12"
{
        Type  "Sc"
        RA            0.4006
        Dec          16.4864
        Distance   7.162e+07  # method: T-F
        Radius     4.375e+04
        AbsMag        -17.81
        Axis    [ -0.1013   0.9899   0.0991]
        Angle    166.8750
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 100"
}

Galaxy "NGC 101:ESO 350-14:MCG 5-2-3:IRAS 00214-3248"
{
        Type  "SBc"
        RA            0.3983
        Dec         -32.5364
        Distance   1.418e+08  # method: V
        Radius     4.331e+04
        AbsMag        -19.79
        Axis    [  0.7701   0.6172  -0.1610]
        Angle    194.0242
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 101"
}

Galaxy "NGC 102:MCG 2-2-11"
{
        Type  "SBa"
        RA            0.4100
        Dec         -13.9561
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.3743   0.7121  -0.5939]
        Angle    195.0155
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 102"
}

Galaxy "NGC 105:UGC 241:MCG 2-2-8:ZWG 434.9"
{
        Type  "Sb"
        RA            0.4211
        Dec          12.8836
        Distance   2.241e+08  # method: V
        Radius     3.586e+04
        AbsMag        -20.29
        Axis    [  0.0758   0.6653  -0.7427]
        Angle    206.5989
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 105"
}

Galaxy "NGC 106"
{
        Type  "Sc"
        RA            0.4119
        Dec          -5.1489
        Distance   1.612e+08  # distance uncertain!
        Radius      2.11e+04
        AbsMag        -19.07
        Axis    [  0.4291   0.8570  -0.2852]
        Angle    188.1856
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 106"
}

Galaxy "NGC 107:MCG 2-2-14"
{
        Type  "Sc"
        RA            0.4283
        Dec          -8.2833
        Distance   3.369e+08  # distance uncertain!
        Radius     4.409e+04
        AbsMag        -19.07
        Axis    [  0.3079   0.7317  -0.6081]
        Angle    194.7751
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 107"
}

Galaxy "NGC 108:UGC 246:MCG 5-2-12:ZWG 500.20"
{
        Type  "SBa"
        RA            0.4331
        Dec          29.2119
        Distance   2.008e+08  # method: V
        Radius     6.716e+04
        AbsMag        -20.85
        Axis    [  0.0565   0.7910  -0.6092]
        Angle    214.1117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 108"
}

Galaxy "NGC 109:UGC 251:MCG 4-2-20:ZWG 479.31"
{
        Type  "SBa"
        RA            0.4372
        Dec          21.8078
        Distance   2.347e+08  # method: V
        Radius     3.755e+04
        AbsMag        -19.29
        Axis    [  0.3639   0.9230  -0.1252]
        Angle    173.5637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 109"
}

Galaxy "NGC 112:UGC 255:MCG 5-2-13:ZWG 500.21"
{
        Type  "Sc"
        RA            0.4467
        Dec          31.7028
        Distance    2.78e+08  # method: T-F
        Radius     4.043e+04
        AbsMag        -20.15
        Axis    [ -0.0686   0.9407  -0.3321]
        Angle    180.2893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 112"
}

Galaxy "NGC 113:MCG 1-2-16"
{
        Type  "S0"
        RA            0.4483
        Dec          -2.5006
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.3044   0.7754  -0.5533]
        Angle    196.2281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 113"
}

Galaxy "NGC 114:UGC 259:MCG 0-2-27:MK 946"
{
        Type  "S0"
        RA            0.4494
        Dec          -1.7858
        Distance    1.54e+08  # distance uncertain!
        Radius     1.792e+04
        AbsMag        -19.07
        Axis    [  0.3183   0.6069  -0.7283]
        Angle    216.2165
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 114"
}

Galaxy "NGC 115:ESO 350-17:MCG 6-2-6"
{
        Type  "SBc"
        RA            0.4461
        Dec         -33.6761
        Distance   1.098e+08  # method: T-F
        Radius     3.033e+04
        AbsMag        -18.93
        Axis    [  0.4378   0.7449  -0.5035]
        Angle    181.2542
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 115"
}

Galaxy "NGC 117:MCG 0-2-29:ZWG 383.15"
{
        Type  "Sa"
        RA            0.4528
        Dec           1.3342
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.2440   0.9247  -0.2923]
        Angle    181.8696
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 117"
}

Galaxy "NGC 118:UGC 264:MCG 0-2-32:MK 947"
{
        Type  "E0"
        RA            0.4544
        Dec          -1.7797
        Distance   4.942e+08  # method: V
        Radius     5.032e+04
        AbsMag         -21.3
        Axis    [  0.7341   0.6651   0.1368]
        Angle    158.2543
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 118"
}

Galaxy "NGC 119:ESO 150-8"
{
        Type  "S0"
        RA            0.4492
        Dec         -56.9778
        Distance   3.255e+08  # method: V
        Radius     4.734e+04
        AbsMag         -20.9
        Axis    [  0.7372   0.3340   0.5874]
        Angle    174.6019
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 119"
}

Galaxy "NGC 120:UGC 267:MCG 0-2-33:ZWG 383.17"
{
        Type  "S0"
        RA            0.4583
        Dec          -1.5136
        Distance   1.688e+08  # distance uncertain!
        Radius     3.683e+04
        AbsMag        -19.07
        Axis    [  0.1862   0.9804  -0.0642]
        Angle    175.1469
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 120"
}

Galaxy "NGC 124:UGC 271:MCG 0-2-38:ZWG 383.18"
{
        Type  "Sc"
        RA            0.4644
        Dec          -1.8103
        Distance   1.678e+08  # method: V
        Radius     3.417e+04
        AbsMag        -19.76
        Axis    [  0.1521   0.6193  -0.7703]
        Angle    196.2965
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 124"
}

Galaxy "NGC 125:UGC 286:MCG 0-2-48:ZWG 383.27"
{
        Type  "Sa"
        RA            0.4806
        Dec           2.8386
        Distance   2.248e+08  # method: V
        Radius     5.886e+04
        AbsMag        -20.89
        Axis    [  0.4787   0.8612  -0.1708]
        Angle    182.2733
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 125"
}

Galaxy "NGC 126:MCG 0-2-49:ZWG 383.28"
{
        Type  "S0"
        RA            0.4856
        Dec           2.8111
        Distance   1.771e+08  # method: V
        Radius     2.061e+04
        AbsMag        -18.27
        Axis    [  0.1778   0.9106  -0.3730]
        Angle    181.8959
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 126"
}

Galaxy "NGC 127:MCG 0-2-50:ZWG 383.29:NPM 1"
{
        Type  "S0"
        RA            0.4867
        Dec           2.8733
        Distance    1.68e+08  # method: V
        Radius     1.954e+04
        AbsMag        -17.76
        Axis    [  0.2939   0.9547  -0.0473]
        Angle    173.4609
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 127"
}

Galaxy "NGC 128:UGC 292:MCG 0-2-51:ZWG 383.29"
{
        Type  "S0"
        RA            0.4872
        Dec           2.8650
        Distance   1.766e+08  # method: V
        Radius     6.422e+04
        AbsMag        -20.87
        Axis    [  0.1018   0.8366   0.5383]
        Angle    168.9466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 128"
}

Galaxy "NGC 130:MCG 0-2-52:ZWG 383.29"
{
        Type  "S0"
        RA            0.4883
        Dec           2.8711
        Distance   1.853e+08  # method: V
        Radius     1.887e+04
        AbsMag        -18.37
        Axis    [  0.2691   0.9572   0.1066]
        Angle    168.6825
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 130"
}

Galaxy "NGC 131:ESO 350-21:MCG 6-2-10:IRAS 00271-3332"
{
        Type  "SBb"
        RA            0.4939
        Dec         -33.2603
        Distance   5.196e+07  # method: V
        Radius      1.36e+04
        AbsMag        -17.21
        Axis    [  0.3903   0.9205   0.0185]
        Angle    187.3420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 131"
}

Galaxy "NGC 132:UGC 301:MCG 0-2-63:ZWG 383.32"
{
        Type  "SBc"
        RA            0.5028
        Dec           2.0931
        Distance   2.273e+08  # method: V
        Radius     6.282e+04
        AbsMag        -20.72
        Axis    [  0.4237   0.8986   0.1143]
        Angle    165.9466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 132"
}

Galaxy "NGC 134:ESO 350-23:MCG 6-2-12:AM 0027-333"
{
        Type  "SBc"
        RA            0.5058
        Dec         -33.2450
        Distance   6.541e+07  # method: T-F
        Radius     7.992e+04
        AbsMag        -20.31
        Axis    [  0.2899   0.9494   0.1208]
        Angle    190.8536
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 134"
}

Galaxy "NGC 135:IC 26"
{
        Type  "S0"
        RA            0.5292
        Dec         -13.3378
        Distance   3.217e+08  # distance uncertain!
        Radius     2.339e+04
        AbsMag        -19.07
        Axis    [  0.6994   0.5510   0.4552]
        Angle    141.8564
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 135"
}

Galaxy "NGC 137:UGC 309:MCG 2-2-17:ZWG 434.19"
{
        Type  "S0"
        RA            0.5161
        Dec          10.2086
        Distance   2.236e+08  # method: V
        Radius     3.902e+04
        AbsMag        -20.38
        Axis    [  0.6474   0.6700   0.3633]
        Angle    125.3009
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 137"
}

Galaxy "NGC 138:UGC 308:MCG 1-2-16:ZWG 409.23"
{
        Type  "Sa"
        RA            0.5164
        Dec           5.1597
        Distance   5.288e+08  # method: V
        Radius     9.998e+04
        AbsMag        -21.45
        Axis    [  0.0408   0.5927  -0.8044]
        Angle    193.8356
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 138"
}

Galaxy "NGC 139:ZWG 409.22"
{
        Type  "SBb"
        RA            0.5183
        Dec           5.0783
        Distance   6.063e+08  # method: V
        Radius     7.054e+04
        AbsMag        -20.95
        Axis    [  0.1141   0.6187  -0.7773]
        Angle    202.4397
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 139"
}

Galaxy "NGC 140:UGC 311:MCG 5-2-21:ZWG 500.38"
{
        Type  "Sc"
        RA            0.5222
        Dec          30.7919
        Distance   2.774e+08  # method: V
        Radius     6.051e+04
        AbsMag        -20.65
        Axis    [  0.2236   0.9741   0.0344]
        Angle    154.2635
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 140"
}

Galaxy "NGC 141:ZWG 409.27"
{
        Type  "S0"
        RA            0.5214
        Dec           5.1794
        Distance    2.44e+08  # distance uncertain!
        Radius     2.839e+04
        AbsMag        -19.07
        Axis    [  0.3420   0.9152  -0.2133]
        Angle    180.6156
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 141"
}

Galaxy "NGC 142:ESO 473-21:MCG 4-2-14:AM 0028-225"
{
        Type  "SBb"
        RA            0.5186
        Dec         -22.6194
        Distance   1.768e+08  # distance uncertain!
        Radius     2.828e+04
        AbsMag        -19.07
        Axis    [  0.4225   0.8538  -0.3043]
        Angle    183.4451
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 142"
}

Galaxy "NGC 143:ESO 473-22:MCG 4-2-15:AM 0028-225"
{
        Type  "SBb"
        RA            0.5208
        Dec         -22.5600
        Distance    2.44e+08  # distance uncertain!
        Radius     3.549e+04
        AbsMag        -19.07
        Axis    [  0.1833   0.9082   0.3762]
        Angle    191.0487
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 143"
}

Galaxy "NGC 144:ESO 473-23:MCG 4-2-16:AM 0028-225"
{
        Type  "Sc"
        RA            0.5222
        Dec         -22.6461
        Distance   1.612e+08  # distance uncertain!
        Radius     1.876e+04
        AbsMag        -19.07
        Axis    [  0.7130   0.5047   0.4867]
        Angle    148.7114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 144"
}

Galaxy "NGC 145:MCG 1-2-27:ARP 19:IRAS 00292-0525"
{
        Type  "Irr"
        RA            0.5292
        Dec          -5.1539
        Distance   1.724e+08  # method: V
        Radius     4.514e+04
        AbsMag        -20.32
        Axis    [  0.5066   0.8605   0.0542]
        Angle    171.8509
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 145"
}

Galaxy "NGC 147:UGC 326:MCG 8-2-5:DDO 3"
{
        Type  "E5"
        RA            0.5531
        Dec          48.5072
        Distance    2.52e+06  # method: S
        Radius          4838
        AbsMag        -14.04
        Axis    [  0.4782   0.8782   0.0141]
        Angle    122.2064
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 147"
}

Galaxy "NGC 148:ESO 410-20:MCG 5-2-17:AM 0031-320"
{
        Type  "S0"
        RA            0.5708
        Dec         -31.7861
        Distance   5.712e+07  # method: V
        Radius     1.662e+04
        AbsMag        -18.12
        Axis    [  0.4226   0.8806  -0.2146]
        Angle    182.1090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 148"
}

Galaxy "NGC 149:UGC 332:MCG 5-2-24:ZWG 500.44"
{
        Type  "S0"
        RA            0.5639
        Dec          30.7236
        Distance   1.938e+08  # distance uncertain!
        Radius     3.383e+04
        AbsMag        -19.07
        Axis    [ -0.0760   0.7658  -0.6386]
        Angle    203.2812
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 149"
}

Galaxy "NGC 150:ESO 410-19:MCG 5-2-18:UGCA 7"
{
        Type  "SBb"
        RA            0.5708
        Dec         -27.8050
        Distance   7.135e+07  # method: T-F
        Radius     4.047e+04
        AbsMag         -19.7
        Axis    [  0.4108   0.7964  -0.4438]
        Angle    181.1918
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 150"
}

Galaxy "NGC 151:NGC 153:MCG 2-2-54:IRAS 00315-0958"
{
        Type  "SBc"
        RA            0.5672
        Dec          -9.7050
        Distance   1.655e+08  # method: T-F
        Radius     9.146e+04
        AbsMag        -21.13
        Axis    [  0.2680   0.9596  -0.0853]
        Angle    176.7698
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 151"
}

Galaxy "NGC 154:MCG 2-2-53:NPM 1"
{
        Type  "E0"
        RA            0.5719
        Dec         -12.6558
        Distance   3.468e+08  # distance uncertain!
        Radius     5.548e+04
        AbsMag        -20.13
        Axis    [  0.7863   0.6069  -0.1160]
        Angle    186.8576
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 154"
}

Galaxy "NGC 155:MCG 2-2-55:NPM 1"
{
        Type  "S0"
        RA            0.5778
        Dec         -10.7661
        Distance    1.54e+08  # distance uncertain!
        Radius     3.807e+04
        AbsMag        -19.07
        Axis    [  0.2686   0.5248  -0.8077]
        Angle    204.4682
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 155"
}

Galaxy "NGC 157:MCG 2-2-56"
{
        Type  "SBc"
        RA            0.5794
        Dec          -8.3961
        Distance    7.04e+07  # method: T-F
        Radius     3.584e+04
        AbsMag        -20.47
        Axis    [  0.4212   0.8750   0.2387]
        Angle    168.7190
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 157"
}

Galaxy "NGC 159:ESO 150-11"
{
        Type  "SBa"
        RA            0.5764
        Dec         -55.7897
        Distance    2.03e+08  # distance uncertain!
        Radius     4.133e+04
        AbsMag        -19.07
        Axis    [  0.5364   0.8063  -0.2493]
        Angle    183.2857
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 159"
}

Galaxy "NGC 160:UGC 356:MCG 4-2-33:ZWG 479.43"
{
        Type  "Sa"
        RA            0.6011
        Dec          23.9581
        Distance   2.796e+08  # method: T-F
        Radius     9.355e+04
        AbsMag        -21.17
        Axis    [  0.0965   0.9831   0.1558]
        Angle    154.5139
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 160"
}

Galaxy "NGC 161:MCG 1-2-36:NPM 1"
{
        Type  "S0"
        RA            0.5925
        Dec          -2.8483
        Distance   1.612e+08  # distance uncertain!
        Radius     3.048e+04
        AbsMag        -19.07
        Axis    [  0.3412   0.8864   0.3128]
        Angle    164.5610
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 161"
}

Galaxy "NGC 163:MCG 2-2-66:NPM 1"
{
        Type  "E0"
        RA            0.5997
        Dec         -10.1214
        Distance   1.906e+08  # distance uncertain!
        Radius     4.435e+04
        AbsMag        -20.13
        Axis    [  0.7686   0.6204  -0.1561]
        Angle    189.0692
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 163"
}

Galaxy "NGC 164:MCG 0-2-89"
{
        Type  "S0"
        RA            0.6089
        Dec           2.7500
        Distance   4.441e+08  # distance uncertain!
        Radius     2.583e+04
        AbsMag        -19.07
        Axis    [  0.6751   0.6257   0.3908]
        Angle    129.8626
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 164"
}

Galaxy "NGC 165:MCG 2-2-69:IRAS 00339-1022"
{
        Type  "SBc"
        RA            0.6078
        Dec         -10.1064
        Distance   2.515e+08  # method: V
        Radius     5.852e+04
        AbsMag        -20.53
        Axis    [  0.5193   0.8477  -0.1084]
        Angle    179.8068
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 165"
}

Galaxy "NGC 166:MCG 2-2-63"
{
        Type  "Sa"
        RA            0.5967
        Dec         -13.6106
        Distance   2.555e+08  # distance uncertain!
        Radius     3.345e+04
        AbsMag        -19.07
        Axis    [  0.1769   0.7465  -0.6414]
        Angle    175.9329
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 166"
}

Galaxy "NGC 167:ESO 473-29:MCG 4-2-22:IRAS 00328-2339"
{
        Type  "SBc"
        RA            0.5894
        Dec         -23.3747
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.3357   0.5051  -0.7951]
        Angle    193.2180
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 167"
}

Galaxy "NGC 168:ESO 474-4:MCG 4-2-26:AM 0034-225"
{
        Type  "Sa"
        RA            0.6106
        Dec         -22.5936
        Distance    2.03e+08  # distance uncertain!
        Radius     3.543e+04
        AbsMag        -19.07
        Axis    [  0.2422   0.9130   0.3283]
        Angle    187.0925
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 168"
}

Galaxy "NGC 169:UGC 365:MCG 4-2-35:ZWG 479.44"
{
        Type  "Sb"
        RA            0.6142
        Dec          23.9914
        Distance   2.799e+08  # method: T-F
        Radius     1.058e+05
        AbsMag        -21.47
        Axis    [ -0.1543   0.9733  -0.1700]
        Angle    166.5873
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 169"
}

Galaxy "NGC 170:MCG 0-2-91:ZWG 383.42"
{
        Type  "S0"
        RA            0.6125
        Dec           1.8864
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [  0.3832   0.9145  -0.1296]
        Angle    176.0050
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 170"
}

Galaxy "NGC 171:NGC 175:ESO 540-6:MCG 3-2-24"
{
        Type  "SBb"
        RA            0.6225
        Dec         -19.9344
        Distance   1.595e+08  # method: V
        Radius     4.872e+04
        AbsMag        -20.45
        Axis    [  0.5706   0.6413   0.5131]
        Angle    159.0177
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 171"
}

Galaxy "NGC 172:ESO 474-5:MCG 4-2-27:AM 0034-225"
{
        Type  "SBc"
        RA            0.6203
        Dec         -22.5867
        Distance   1.471e+08  # method: T-F
        Radius      4.28e+04
        AbsMag        -18.87
        Axis    [  0.1861   0.8805   0.4361]
        Angle    191.5626
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 172"
}

Galaxy "NGC 173:UGC 369:MCG 0-2-92:ZWG 383.43"
{
        Type  "Sc"
        RA            0.6200
        Dec           1.9422
        Distance   1.825e+08  # method: V
        Radius     8.493e+04
        AbsMag        -20.74
        Axis    [  0.4162   0.8829  -0.2172]
        Angle    181.2451
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 173"
}

Galaxy "NGC 174:ESO 411-1:MCG 5-2-28:AM 0034-294"
{
        Type  "SBa"
        RA            0.6161
        Dec         -29.4778
        Distance   1.447e+08  # method: V
        Radius     2.947e+04
        AbsMag        -19.44
        Axis    [  0.3299   0.6479  -0.6866]
        Angle    175.3976
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 174"
}

Galaxy "NGC 177:ESO 474-6:MCG 4-2-28:AM 0035-224"
{
        Type  "Sb"
        RA            0.6261
        Dec         -22.5492
        Distance   1.629e+08  # method: V
        Radius     5.211e+04
        AbsMag        -19.39
        Axis    [  0.2107   0.8699   0.4459]
        Angle    190.1850
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 177"
}

Galaxy "NGC 178:IC 39:MCG 2-2-78:ZW 34"
{
        Type  "Sb"
        RA            0.6522
        Dec         -14.1722
        Distance   5.151e+07  # method: V
        Radius     1.573e+04
        AbsMag        -17.59
        Axis    [  0.1519   0.5300  -0.8343]
        Angle    180.6927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 178"
}

Galaxy "NGC 179:ESO 540-7:MCG 3-2-26"
{
        Type  "S0"
        RA            0.6294
        Dec         -17.8500
        Distance   3.208e+08  # method: T-F
        Radius     4.199e+04
        AbsMag        -20.76
        Axis    [  0.5034   0.7658  -0.4003]
        Angle    189.8413
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 179"
}

Galaxy "NGC 180:UGC 380:MCG 1-2-39:ZWG 409.50"
{
        Type  "SBc"
        RA            0.6325
        Dec           8.6347
        Distance   2.231e+08  # method: V
        Radius     6.165e+04
        AbsMag        -20.37
        Axis    [  0.1353   0.6939  -0.7072]
        Angle    202.6067
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 180"
}

Galaxy "NGC 181:MCG 5-2-32:ZWG 500.55"
{
        Type  "S0"
        RA            0.6397
        Dec          29.4733
        Distance   2.367e+08  # method: V
        Radius     2.409e+04
        AbsMag         -18.5
        Axis    [ -0.2065   0.7689  -0.6051]
        Angle    184.9752
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 181"
}

Galaxy "NGC 182:UGC 382:MCG 0-2-95:ZWG 383.45"
{
        Type  "SBa"
        RA            0.6367
        Dec           2.7286
        Distance   2.229e+08  # method: V
        Radius      6.16e+04
        AbsMag        -20.77
        Axis    [  0.4530   0.8856  -0.1027]
        Angle    174.8475
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 182"
}

Galaxy "NGC 183:UGC 387:MCG 5-2-35:ZWG 500.57"
{
        Type  "E0"
        RA            0.6414
        Dec          29.5117
        Distance   2.258e+08  # method: V
        Radius     5.584e+04
        AbsMag         -20.6
        Axis    [  0.4232   0.8147  -0.3964]
        Angle    216.6611
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 183"
}

Galaxy "NGC 184:ZWG 500.59"
{
        Type  "S0"
        RA            0.6431
        Dec          29.4475
        Distance   2.255e+08  # method: V
        Radius     2.296e+04
        AbsMag         -18.6
        Axis    [ -0.0184   0.8585   0.5125]
        Angle    145.9914
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 184"
}

Galaxy "NGC 185:UGC 396:MCG 8-2-10:ZWG 550.9"
{
        Type  "E3"
        RA            0.6492
        Dec          48.3372
        Distance   2.077e+06  # method: S
        Radius          2417
        AbsMag        -13.72
        Axis    [  0.4669   0.8838  -0.0291]
        Angle    129.9180
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 185"
}

Galaxy "NGC 186:UGC 390:MCG 0-2-98:ZWG 383.47"
{
        Type  "SBa"
        RA            0.6403
        Dec           3.1661
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.2830   0.8954   0.3437]
        Angle    160.1489
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 186"
}

Galaxy "NGC 187:MCG 3-2-34:IRAS 00369-1455"
{
        Type  "Sc"
        RA            0.6583
        Dec         -14.6564
        Distance   1.645e+08  # method: V
        Radius     3.111e+04
        AbsMag        -19.61
        Axis    [  0.2021   0.7204  -0.6635]
        Angle    177.2715
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 187"
}

Galaxy "NGC 190:UGC 397:MCG 1-2-41:ZWG 409.51"
{
        Type  "Sb"
        RA            0.6483
        Dec           7.0622
        Distance   4.918e+08  # method: V
        Radius     6.438e+04
        AbsMag        -21.09
        Axis    [  0.3489   0.7729  -0.5301]
        Angle    204.4192
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 190"
}

Galaxy "NGC 190A:MCG 1-2-42:ZWG 409.51:ZW 10"
{
        Type  "E0"
        RA            0.6483
        Dec           7.0564
        Distance   5.335e+08  # method: V
        Radius     4.656e+04
        AbsMag        -20.27
        Axis    [  0.6886   0.6296   0.3599]
        Angle    125.4780
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 190A"
}

Galaxy "NGC 191:MCG 2-2-77:ARP 127"
{
        Type  "SBc"
        RA            0.6497
        Dec          -9.0028
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.4594   0.7313  -0.5042]
        Angle    197.8203
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 191"
}

Galaxy "NGC 192:UGC 401:MCG 0-2-104:ZWG 383.51"
{
        Type  "SBa"
        RA            0.6536
        Dec           0.8642
        Distance   1.755e+08  # method: V
        Radius      4.85e+04
        AbsMag        -20.15
        Axis    [  0.0831   0.6363  -0.7670]
        Angle    189.3011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 192"
}

Galaxy "NGC 193:UGC 408:MCG 0-2-103:ZWG 383.55"
{
        Type  "S0"
        RA            0.6550
        Dec           3.3311
        Distance   1.807e+08  # method: V
        Radius      3.68e+04
        AbsMag        -20.32
        Axis    [  0.4780   0.8769   0.0502]
        Angle    165.4783
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 193"
}

Galaxy "NGC 194:UGC 407:MCG 0-2-105:ZWG 383.54"
{
        Type  "E0"
        RA            0.6550
        Dec           3.0375
        Distance   1.842e+08  # method: T-F
        Radius     4.285e+04
        AbsMag        -20.56
        Axis    [  0.7235   0.6686   0.1717]
        Angle    147.4754
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 194"
}

Galaxy "NGC 195:MCG 2-2-79:NPM 1:IRAS 00370-0928"
{
        Type  "SBa"
        RA            0.6597
        Dec          -9.1942
        Distance   2.081e+08  # method: V
        Radius     3.631e+04
        AbsMag        -19.42
        Axis    [  0.4781   0.8643   0.1563]
        Angle    169.4367
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 195"
}

Galaxy "NGC 196:UGC 405:MCG 0-2-110:ZWG 383.53"
{
        Type  "S0"
        RA            0.6547
        Dec           0.9131
        Distance   1.768e+08  # method: V
        Radius     3.342e+04
        AbsMag        -19.07
        Axis    [  0.3131   0.8089   0.4976]
        Angle    156.4428
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 196"
}

Galaxy "NGC 197:UGC 406:MCG 0-2-107:ZWG 383.53"
{
        Type  "S0"
        RA            0.6550
        Dec           0.8925
        Distance   1.747e+08  # method: V
        Radius     1.778e+04
        AbsMag        -18.94
        Axis    [  0.6837   0.6130   0.3960]
        Angle    130.8983
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 197"
}

Galaxy "NGC 198:UGC 414:MCG 0-2-109:ZWG 383.57"
{
        Type  "Sc"
        RA            0.6561
        Dec           2.7983
        Distance   2.231e+08  # method: V
        Radius     3.894e+04
        AbsMag        -20.67
        Axis    [  0.6795   0.6224   0.3884]
        Angle    129.5326
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 198"
}

Galaxy "NGC 199:UGC 415:MCG 0-2-111:ZWG 383.58"
{
        Type  "S0"
        RA            0.6592
        Dec           3.1381
        Distance   1.851e+08  # distance uncertain!
        Radius     3.231e+04
        AbsMag        -19.07
        Axis    [  0.1270   0.6809  -0.7212]
        Angle    194.6497
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 199"
}

Galaxy "NGC 200:UGC 420:MCG 0-2-112:ZWG 383.60"
{
        Type  "SBc"
        RA            0.6594
        Dec           2.8869
        Distance   2.468e+08  # method: T-F
        Radius     6.101e+04
        AbsMag        -20.89
        Axis    [  0.1289   0.6742  -0.7272]
        Angle    195.0622
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 200"
}

Galaxy "NGC 201:UGC 419:MCG 0-2-115:ZWG 383.59"
{
        Type  "SBc"
        RA            0.6594
        Dec           0.8603
        Distance   1.826e+08  # method: V
        Radius     4.779e+04
        AbsMag        -20.14
        Axis    [  0.2916   0.6764  -0.6763]
        Angle    207.5459
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 201"
}

Galaxy "NGC 202:UGC 421:MCG 0-2-113:ZWG 383.62"
{
        Type  "Sa"
        RA            0.6608
        Dec           3.5356
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.0233   0.7294  -0.6836]
        Angle    180.6117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 202"
}

Galaxy "NGC 203:NGC 211:MCG 0-2-114:ZWG 383.61"
{
        Type  "S0"
        RA            0.6608
        Dec           3.4425
        Distance   2.226e+08  # distance uncertain!
        Radius     2.913e+04
        AbsMag        -19.07
        Axis    [  0.1021   0.9807  -0.1666]
        Angle    171.6269
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 203"
}

Galaxy "NGC 204:UGC 423:MCG 0-2-116:ZWG 383.63"
{
        Type  "S0"
        RA            0.6622
        Dec           3.3000
        Distance   1.341e+08  # distance uncertain!
        Radius     2.341e+04
        AbsMag        -19.07
        Axis    [  0.5392   0.8098   0.2313]
        Angle    152.7396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 204"
}

Galaxy "M 110:NGC 205:UGC 426:MCG 7-2-14"
{
        Type  "E5"
        RA            0.6728
        Dec          41.6853
        Distance     2.7e+06  # method: PN
        Radius          7658
        AbsMag        -15.68
        Axis    [  0.2155   0.8200  -0.5303]
        Angle    249.5817
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 110"
}

Galaxy "NGC 207:MCG 3-2-35:IRAS 00371-1430"
{
        Type  "Sa"
        RA            0.6611
        Dec         -14.2364
        Distance   1.768e+08  # distance uncertain!
        Radius     2.314e+04
        AbsMag        -19.07
        Axis    [  0.3151   0.9326  -0.1758]
        Angle    177.5595
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 207"
}

Galaxy "NGC 208:MCG 0-2-118:ZWG 383.64"
{
        Type  "Sa"
        RA            0.6714
        Dec           2.7558
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.6811   0.6210   0.3878]
        Angle    129.4675
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 208"
}

Galaxy "NGC 209:ESO 540-8:MCG 3-2-31:NPM 1"
{
        Type  "S0"
        RA            0.6508
        Dec         -18.6083
        Distance   1.642e+08  # method: V
        Radius     2.627e+04
        AbsMag        -19.51
        Axis    [  0.7190   0.5162   0.4653]
        Angle    145.1779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 209"
}

Galaxy "NGC 210:MCG 2-2-81:IRAS 00380-1408"
{
        Type  "SBb"
        RA            0.6761
        Dec         -13.8725
        Distance   5.975e+07  # method: V
        Radius     4.345e+04
        AbsMag        -19.61
        Axis    [  0.2859   0.6152  -0.7347]
        Angle    192.4935
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 210"
}

Galaxy "NGC 212:ESO 150-18:AM 0038-562"
{
        Type  "S0"
        RA            0.6703
        Dec         -56.1525
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.7599   0.3985  -0.5135]
        Angle    194.5004
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 212"
}

Galaxy "NGC 213:UGC 436:MCG 3-2-23:ZWG 457.26"
{
        Type  "SBa"
        RA            0.6858
        Dec          16.4697
        Distance   2.318e+08  # method: V
        Radius     5.057e+04
        AbsMag        -19.86
        Axis    [  0.2719   0.9129  -0.3044]
        Angle    183.0596
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 213"
}

Galaxy "NGC 214:UGC 438:MCG 4-2-44:ZWG 479.59"
{
        Type  "SBc"
        RA            0.6911
        Dec          25.4994
        Distance   1.909e+08  # method: V
        Radius     5.277e+04
        AbsMag        -20.84
        Axis    [  0.2887   0.9398   0.1827]
        Angle    144.4968
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 214"
}

Galaxy "NGC 215:ESO 150-19:AM 0038-562"
{
        Type  "S0"
        RA            0.6800
        Dec         -56.2142
        Distance   3.657e+08  # method: V
        Radius     5.851e+04
        AbsMag        -21.15
        Axis    [  0.7520   0.4932  -0.4374]
        Angle    190.5042
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 215"
}

Galaxy "NGC 216:ESO 540-15:MCG 4-2-35:HARO 13"
{
        Type  "S0"
        RA            0.6908
        Dec         -21.0453
        Distance   5.703e+07  # method: V
        Radius     1.659e+04
        AbsMag        -17.51
        Axis    [  0.3053   0.8966   0.3209]
        Angle    182.3811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 216"
}

Galaxy "NGC 217:MCG 2-2-85:IRAS 00390-1017"
{
        Type  "Sa"
        RA            0.6925
        Dec         -10.0217
        Distance   1.666e+08  # method: V
        Radius     6.543e+04
        AbsMag        -20.04
        Axis    [  0.1071   0.9023  -0.4176]
        Angle    170.6313
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 217"
}

Galaxy "NGC 218:UGC 440:MCG 6-2-13:ZWG 519.17"
{
        Type  "S0"
        RA            0.6956
        Dec          36.3592
        Distance   2.085e+08  # method: V
        Radius      2.73e+04
        AbsMag        -18.83
        Axis    [  0.0425   0.9010  -0.4318]
        Angle    194.9391
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 218"
}

Galaxy "NGC 219:MCG 0-2-128:ZWG 383.73"
{
        Type  "E0"
        RA            0.7031
        Dec           0.9044
        Distance   2.336e+08  # method: V
        Radius     1.699e+04
        AbsMag        -18.78
        Axis    [  0.4623   0.5445  -0.6999]
        Angle    239.7085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 219"
}

Galaxy "M 32:NGC 221:UGC 452:MCG 7-2-15"
{
        Type  "E2"
        RA            0.7114
        Dec          40.8658
        Distance   2.651e+06  # method: S
        Radius          3278
        AbsMag        -15.45
        Axis    [  0.1854   0.7953  -0.5772]
        Angle    256.1765
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 32"
}

Galaxy "NGC 223:IC 44:UGC 450:MCG 0-2-129"
{
        Type  "Sa"
        RA            0.7042
        Dec           0.8461
        Distance   2.275e+08  # method: V
        Radius     4.301e+04
        AbsMag        -19.92
        Axis    [  0.3698   0.9291   0.0088]
        Angle    169.1352
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 223"
}

Galaxy "M 31:NGC 224:UGC 454:MCG 7-2-16"
{
        Type  "Sb"
        RA            0.7122
        Dec          41.2689
        Distance   2.474e+06  # method: S
        Radius     6.805e+04
        AbsMag        -20.04
        Axis    [ -0.1274   0.9554   0.2663]
        Angle    142.9019
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 31"
}

Galaxy "NGC 226:UGC 459:ZWG 500.76:IRAS 00402+3218"
{
        Type  "Irr"
        RA            0.7147
        Dec          32.5803
        Distance   2.051e+08  # method: V
        Radius     2.685e+04
        AbsMag        -19.59
        Axis    [  0.0351   0.9501  -0.3098]
        Angle    178.7341
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 226"
}

Galaxy "NGC 227:UGC 456:MCG 0-2-135:ZWG 383.76"
{
        Type  "S0"
        RA            0.7100
        Dec          -1.5281
        Distance   2.228e+08  # method: T-F
        Radius      4.86e+04
        AbsMag        -21.07
        Axis    [  0.2844   0.6709  -0.6849]
        Angle    203.8309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 227"
}

Galaxy "NGC 228:UGC 458:MCG 4-2-48:ZWG 479.62"
{
        Type  "SBb"
        RA            0.7150
        Dec          23.5033
        Distance   3.168e+08  # method: V
        Radius     5.529e+04
        AbsMag        -20.24
        Axis    [  0.2710   0.8553  -0.4416]
        Angle    201.3162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 228"
}

Galaxy "NGC 229:MCG 4-2-49:ZWG 479.64"
{
        Type  "S0"
        RA            0.7178
        Dec          23.5094
        Distance   2.125e+08  # distance uncertain!
        Radius     3.091e+04
        AbsMag        -19.07
        Axis    [ -0.0386   0.9685  -0.2460]
        Angle    170.2684
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 229"
}

Galaxy "NGC 230:ESO 474-14:MCG 4-2-37:AM 0040-234"
{
        Type  "Sa"
        RA            0.7075
        Dec         -23.6289
        Distance   2.802e+08  # distance uncertain!
        Radius     4.483e+04
        AbsMag        -19.07
        Axis    [  0.2193   0.9603   0.1722]
        Angle    184.7811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 230"
}

Galaxy "NGC 232:ESO 474-15:MCG 4-2-40:VV 830"
{
        Type  "SBa"
        RA            0.7125
        Dec         -23.5617
        Distance   2.891e+08  # method: V
        Radius     3.784e+04
        AbsMag        -20.34
        Axis    [  0.6627   0.7253   0.1865]
        Angle    173.7786
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 232"
}

Galaxy "NGC 233:UGC 464:MCG 5-2-41:ZWG 500.78"
{
        Type  "E0"
        RA            0.7267
        Dec          30.5869
        Distance   2.331e+08  # method: V
        Radius     4.068e+04
        AbsMag        -20.47
        Axis    [  0.6253   0.7423   0.2410]
        Angle    109.3583
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 233"
}

Galaxy "NGC 234:UGC 463:MCG 2-2-28:ZWG 434.32"
{
        Type  "SBc"
        RA            0.7256
        Dec          14.3425
        Distance   1.866e+08  # method: V
        Radius     4.072e+04
        AbsMag        -20.49
        Axis    [  0.3586   0.9321   0.0500]
        Angle    159.2362
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 234"
}

Galaxy "NGC 235A:ESO 474-16:MCG 4-2-41:AM 0040-234"
{
        Type  "S0"
        RA            0.7144
        Dec         -23.5411
        Distance   1.341e+08  # distance uncertain!
        Radius     2.536e+04
        AbsMag        -19.07
        Axis    [  0.4034   0.8005  -0.4434]
        Angle    180.9878
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 235A"
}

Galaxy "NGC 235B:ESO 474-17:MCG 4-2-42:AM 0040-234"
{
        Type  "S0"
        RA            0.7147
        Dec         -23.5453
        Distance   2.948e+08  # method: V
        Radius     1.715e+04
        AbsMag        -20.28
        Axis    [  0.7317   0.4874   0.4765]
        Angle    148.6223
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 235B"
}

Galaxy "NGC 236:UGC 462:MCG 0-3-1:ZWG 383.80"
{
        Type  "Sc"
        RA            0.7242
        Dec           2.9581
        Distance   2.405e+08  # method: V
        Radius     4.198e+04
        AbsMag        -20.04
        Axis    [  0.2570   0.6614  -0.7046]
        Angle    209.1654
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 236"
}

Galaxy "NGC 237:UGC 461:MCG 0-2-136:ZWG 383.79"
{
        Type  "SBc"
        RA            0.7242
        Dec          -0.1253
        Distance   1.934e+08  # method: T-F
        Radius     4.501e+04
        AbsMag        -20.26
        Axis    [  0.1028   0.5796  -0.8084]
        Angle    194.4909
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 237"
}

Galaxy "NGC 238:ESO 194-31:FAIR 663:AM 0041-502"
{
        Type  "SBb"
        RA            0.7236
        Dec         -50.1828
        Distance   3.822e+08  # method: V
        Radius     1.112e+05
        AbsMag        -22.14
        Axis    [  0.7534   0.6068  -0.2532]
        Angle    190.6502
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 238"
}

Galaxy "NGC 239:MCG 1-3-7:IRAS 00420-0401"
{
        Type  "Sb"
        RA            0.7436
        Dec          -3.7600
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.2924   0.9049   0.3094]
        Angle    166.4263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 239"
}

Galaxy "NGC 240:UGC 473:MCG 1-3-1:ZWG 410.3"
{
        Type  "Sa"
        RA            0.7503
        Dec           6.1128
        Distance   1.768e+08  # distance uncertain!
        Radius     3.085e+04
        AbsMag        -19.07
        Axis    [  0.6808   0.6317   0.3708]
        Angle    126.5730
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 240"
}

Galaxy "NGC 243:MCG 5-2-43:ZWG 500.82:ZWG 501.1"
{
        Type  "S0"
        RA            0.7667
        Dec          29.9597
        Distance    2.03e+08  # method: V
        Radius     2.657e+04
        AbsMag        -19.37
        Axis    [ -0.1364   0.7813  -0.6091]
        Angle    191.2393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 243"
}

Galaxy "NGC 244:MCG 3-3-3:UGCA 10:VV 728"
{
        Type  "S0"
        RA            0.7628
        Dec         -15.5972
        Distance   2.877e+07  # method: V
        Radius          5021
        AbsMag        -15.83
        Axis    [  0.5844   0.8040   0.1097]
        Angle    172.1213
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 244"
}

Galaxy "NGC 245:UGC 476:MCG 0-3-5:MK 555"
{
        Type  "Sb"
        RA            0.7681
        Dec          -1.7233
        Distance   1.697e+08  # method: V
        Radius     3.209e+04
        AbsMag        -20.48
        Axis    [  0.3450   0.7054  -0.6192]
        Angle    202.6866
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 245"
}

Galaxy "NGC 247:ESO 540-22:MCG 4-3-5:UGCA 11"
{
        Type  "SBc"
        RA            0.7856
        Dec         -20.7600
        Distance   1.318e+07  # method: T-F
        Radius     3.681e+04
        AbsMag        -18.43
        Axis    [  0.1533   0.5713  -0.8063]
        Angle    167.0641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 247"
}

Galaxy "NGC 250:UGC 487:MCG 1-3-2:ZWG 410.5"
{
        Type  "Sa"
        RA            0.7878
        Dec           7.9100
        Distance   2.232e+08  # method: V
        Radius      3.57e+04
        AbsMag        -19.48
        Axis    [  0.0813   0.7334  -0.6749]
        Angle    190.6774
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 250"
}

Galaxy "NGC 251:UGC 490:MCG 3-3-3:ZWG 458.5"
{
        Type  "Sc"
        RA            0.7981
        Dec          19.5969
        Distance   1.936e+08  # method: V
        Radius     6.757e+04
        AbsMag        -19.77
        Axis    [  0.2523   0.9310  -0.2637]
        Angle    177.5994
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 251"
}

Galaxy "NGC 252:UGC 491:MCG 4-3-4:ZWG 480.7"
{
        Type  "Sa"
        RA            0.8003
        Dec          27.6233
        Distance   2.135e+08  # method: V
        Radius     4.347e+04
        AbsMag        -20.68
        Axis    [  0.1560   0.9775  -0.1421]
        Angle    165.7927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 252"
}

Galaxy "NGC 253:ESO 474-29:MCG 4-3-9:UGCA 13"
{
        Type  "SBc"
        RA            0.7925
        Dec         -25.2875
        Distance    1.21e+07  # method: T-F
        Radius     5.102e+04
        AbsMag        -19.84
        Axis    [  0.2739   0.9564   0.1013]
        Angle    182.3693
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 253"
}

Galaxy "NGC 254:ESO 411-15:MCG 5-3-5:AM 0045-314"
{
        Type  "S0"
        RA            0.7908
        Dec         -31.4219
        Distance   6.156e+07  # method: V
        Radius     2.328e+04
        AbsMag        -18.78
        Axis    [  0.4710   0.6520  -0.5942]
        Angle    184.0231
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 254"
}

Galaxy "NGC 255:MCG 2-3-17:IRAS 00452-1144"
{
        Type  "SBc"
        RA            0.7964
        Dec         -11.4683
        Distance    5.83e+07  # method: V
        Radius     2.629e+04
        AbsMag        -18.56
        Axis    [  0.5634   0.7331   0.3810]
        Angle    157.6405
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 255"
}

Galaxy "NGC 257:UGC 493:MCG 1-3-3:ZWG 410.6"
{
        Type  "Sc"
        RA            0.8003
        Dec           8.2967
        Distance   2.703e+08  # method: T-F
        Radius     7.469e+04
        AbsMag        -21.19
        Axis    [  0.2523   0.9069  -0.3376]
        Angle    180.3763
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 257"
}

Galaxy "NGC 258:MCG 4-3-5:NPM 1"
{
        Type  "Sb"
        RA            0.8033
        Dec          27.6578
        Distance   2.125e+08  # distance uncertain!
        Radius     1.546e+04
        AbsMag        -19.07
        Axis    [  0.1686   0.9265  -0.3365]
        Angle    183.4090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 258"
}

Galaxy "NGC 259:MCG 1-3-15:IRAS 00455-0302"
{
        Type  "Sc"
        RA            0.8008
        Dec          -2.7758
        Distance   1.777e+08  # method: T-F
        Radius     7.496e+04
        AbsMag        -20.08
        Axis    [  0.0011   0.8052  -0.5930]
        Angle    167.7345
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 259"
}

Galaxy "NGC 260:UGC 497:MCG 4-3-6:ZWG 480.9"
{
        Type  "Sc"
        RA            0.8094
        Dec          27.6919
        Distance   2.219e+08  # method: V
        Radius     2.582e+04
        AbsMag        -19.86
        Axis    [  0.6222   0.7344   0.2713]
        Angle    111.2736
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 260"
}

Galaxy "NGC 262:UGC 499:MCG 5-3-8:MK 348"
{
        Type  "Sa"
        RA            0.8131
        Dec          31.9575
        Distance   1.907e+08  # method: V
        Radius     3.051e+04
        AbsMag        -19.83
        Axis    [  0.6064   0.7551   0.2491]
        Angle    108.4587
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 262"
}

Galaxy "NGC 263:MCG 2-3-21"
{
        Type  "Sc"
        RA            0.8133
        Dec         -13.1072
        Distance   2.226e+08  # distance uncertain!
        Radius     2.266e+04
        AbsMag        -19.07
        Axis    [  0.3183   0.9333   0.1665]
        Angle    173.9487
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 263"
}

Galaxy "NGC 264:ESO 295-6:MCG 7-2-16"
{
        Type  "S0"
        RA            0.8056
        Dec         -38.2344
        Distance   1.612e+08  # distance uncertain!
        Radius     2.579e+04
        AbsMag        -19.07
        Axis    [  0.3848   0.8274  -0.4089]
        Angle    171.9452
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 264"
}

Galaxy "NGC 266:UGC 508:MCG 5-3-9:ZWG 501.22"
{
        Type  "SBb"
        RA            0.8297
        Dec          32.2775
        Distance   1.977e+08  # method: V
        Radius     8.626e+04
        AbsMag        -21.31
        Axis    [  0.3317   0.9028  -0.2737]
        Angle    183.1810
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 266"
}

Galaxy "NGC 268:MCG 1-3-17:IRAS 00476-0527"
{
        Type  "SBc"
        RA            0.8358
        Dec          -5.1939
        Distance   2.338e+08  # method: V
        Radius      5.44e+04
        AbsMag        -20.38
        Axis    [  0.4064   0.9079  -0.1032]
        Angle    173.4731
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 268"
}

Galaxy "NGC 270:MCG 2-3-27"
{
        Type  "Sa"
        RA            0.8422
        Dec          -8.6517
        Distance   1.223e+08  # distance uncertain!
        Radius     3.024e+04
        AbsMag        -19.07
        Axis    [  0.4501   0.8350   0.3166]
        Angle    163.4082
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 270"
}

Galaxy "NGC 271:UGC 519:MCG 0-3-12:ZWG 384.13"
{
        Type  "SBb"
        RA            0.8447
        Dec          -1.9106
        Distance   1.708e+08  # method: V
        Radius     5.465e+04
        AbsMag        -20.59
        Axis    [  0.3365   0.7795  -0.5283]
        Angle    192.0444
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 271"
}

Galaxy "NGC 273:MCG 1-3-19"
{
        Type  "S0"
        RA            0.8467
        Dec          -6.8856
        Distance   1.281e+08  # distance uncertain!
        Radius     3.912e+04
        AbsMag        -19.07
        Axis    [  0.1448   0.9375  -0.3165]
        Angle    170.8984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 273"
}

Galaxy "NGC 274:MCG 1-3-21:VV 81:ARP 140"
{
        Type  "S0"
        RA            0.8503
        Dec          -7.0567
        Distance    6.36e+07  # method: S
        Radius     1.295e+04
        AbsMag        -18.65
        Axis    [  0.5490   0.7822   0.2946]
        Angle    157.7551
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 274"
}

Galaxy "NGC 275:MCG 1-3-22:VV 81:ARP 140"
{
        Type  "SBc"
        RA            0.8511
        Dec          -7.0653
        Distance   6.446e+07  # method: V
        Radius     1.406e+04
        AbsMag        -18.28
        Axis    [  0.4038   0.7636  -0.5038]
        Angle    191.5900
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 275"
}

Galaxy "NGC 276:IC 1591:ESO 474-34:MCG 4-3-21"
{
        Type  "SBb"
        RA            0.8683
        Dec         -22.6803
        Distance   6.142e+08  # method: V
        Radius     8.933e+04
        AbsMag        -20.57
        Axis    [  0.3576   0.9056  -0.2279]
        Angle    176.0379
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 276"
}

Galaxy "NGC 277:MCG 2-3-28:NPM 1"
{
        Type  "S0"
        RA            0.8547
        Dec          -8.5964
        Distance   1.854e+08  # method: V
        Radius     3.775e+04
        AbsMag        -19.07
        Axis    [  0.5670   0.8183   0.0939]
        Angle    167.1875
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 277"
}

Galaxy "NGC 278:UGC 528:MCG 8-2-16:ZWG 550.16"
{
        Type  "SBb"
        RA            0.8678
        Dec          47.5508
        Distance   1.771e+07  # method: V
        Radius          5410
        AbsMag        -17.17
        Axis    [  0.3673   0.9083   0.2003]
        Angle    110.7079
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 278"
}

Galaxy "NGC 279:UGC 532:MCG 0-3-19A:MK 558"
{
        Type  "Sa"
        RA            0.8689
        Dec          -2.2183
        Distance   1.614e+08  # method: V
        Radius     3.755e+04
        AbsMag        -19.67
        Axis    [  0.2423   0.6591  -0.7120]
        Angle    199.1316
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 279"
}

Galaxy "NGC 280:UGC 534:MCG 4-3-13:ZWG 480.17"
{
        Type  "SBa"
        RA            0.8750
        Dec          24.3508
        Distance   4.057e+08  # method: T-F
        Radius     1.003e+05
        AbsMag        -21.17
        Axis    [  0.1126   0.9618  -0.2497]
        Angle    171.9133
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 280"
}

Galaxy "NGC 282:MCG 5-3-15:ZWG 501.30"
{
        Type  "E0"
        RA            0.8783
        Dec          30.6389
        Distance    3.02e+08  # distance uncertain!
        Radius     4.393e+04
        AbsMag        -20.13
        Axis    [  0.5741   0.8175  -0.0473]
        Angle    147.1331
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 282"
}

Galaxy "NGC 283:MCG 2-3-31:NPM 1:IRAS 00507-1326"
{
        Type  "Sc"
        RA            0.8869
        Dec         -13.1633
        Distance   1.938e+08  # distance uncertain!
        Radius     4.511e+04
        AbsMag        -19.07
        Axis    [  0.2714   0.6545  -0.7057]
        Angle    187.1487
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 283"
}

Galaxy "NGC 284:MCG 2-3-33:NPM 1"
{
        Type  "E0"
        RA            0.8900
        Dec         -13.1583
        Distance   4.169e+08  # distance uncertain!
        Radius     3.638e+04
        AbsMag        -20.13
        Axis    [  0.7583   0.5181   0.3957]
        Angle    140.7722
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 284"
}

Galaxy "NGC 285:KAZ 377:NPM 1"
{
        Type  "S0"
        RA            0.8914
        Dec         -13.1603
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [  0.3851   0.8074   0.4470]
        Angle    168.3716
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 285"
}

Galaxy "NGC 286:MCG 2-3-34:NPM 1:AM 0051-132"
{
        Type  "S0"
        RA            0.8917
        Dec         -13.1122
        Distance   2.226e+08  # distance uncertain!
        Radius     4.208e+04
        AbsMag        -19.07
        Axis    [  0.4521   0.7765   0.4389]
        Angle    164.1420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 286"
}

Galaxy "NGC 287:ZWG 501.33"
{
        Type  "Sa"
        RA            0.8911
        Dec          32.4825
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.0833   0.9318   0.3533]
        Angle    138.1234
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 287"
}

Galaxy "NGC 289:ESO 411-25:MCG 5-3-10:VV 484"
{
        Type  "SBc"
        RA            0.8783
        Dec         -31.2056
        Distance   6.211e+07  # method: V
        Radius     4.607e+04
        AbsMag         -19.7
        Axis    [  0.5109   0.6621  -0.5482]
        Angle    185.2136
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 289"
}

Galaxy "NGC 291:MCG 2-3-35:IRAS 00510-0901"
{
        Type  "Sa"
        RA            0.8914
        Dec          -8.7675
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [  0.3632   0.9181   0.1589]
        Angle    169.1353
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 291"
}

Galaxy "NGC 293:MCG 1-3-30:IRAS 00517-0730"
{
        Type  "SBb"
        RA            0.9044
        Dec          -7.2356
        Distance   2.125e+08  # distance uncertain!
        Radius       3.4e+04
        AbsMag        -19.07
        Axis    [  0.5192   0.7812   0.3467]
        Angle    156.9192
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 293"
}

Galaxy "NGC 296:UGC 562:MCG 5-3-24:ZWG 501.42"
{
        Type  "SBb"
        RA            0.9186
        Dec          31.5422
        Distance    1.95e+08  # method: T-F
        Radius     6.239e+04
        AbsMag        -20.68
        Axis    [ -0.1669   0.7053  -0.6890]
        Angle    196.2437
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 296"
}

Galaxy "NGC 297"
{
        Type  "E0"
        RA            0.9161
        Dec          -7.3503
        Distance   6.919e+08  # distance uncertain!
        Radius     3.019e+04
        AbsMag        -20.13
        Axis    [  0.7395   0.6230  -0.2548]
        Angle    191.6200
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 297"
}

Galaxy "NGC 298:MCG 1-3-33"
{
        Type  "Sc"
        RA            0.9172
        Dec          -7.3336
        Distance   6.514e+07  # method: V
        Radius     1.611e+04
        AbsMag           -17
        Axis    [  0.1230   0.9692  -0.2135]
        Angle    168.9480
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 298"
}

Galaxy "NGC 300:ESO 295-20:MCG 6-3-5:AM 0052-375"
{
        Type  "Sc"
        RA            0.9147
        Dec         -37.6842
        Distance     7.1e+06  # method: CN
        Radius     1.962e+04
        AbsMag        -17.88
        Axis    [  0.5869   0.7014  -0.4044]
        Angle    183.2719
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 300"
}

Galaxy "NGC 301"
{
        Type  "S0"
        RA            0.9383
        Dec         -10.6733
        Distance   3.072e+08  # distance uncertain!
        Radius     3.128e+04
        AbsMag        -19.07
        Axis    [  0.4724   0.8789  -0.0665]
        Angle    173.1732
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 301"
}

Galaxy "NGC 303"
{
        Type  "Sa"
        RA            0.9150
        Dec         -16.6550
        Distance    2.33e+08  # distance uncertain!
        Radius     2.373e+04
        AbsMag        -19.07
        Axis    [  0.2026   0.6488  -0.7335]
        Angle    175.5594
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 303"
}

Galaxy "NGC 304:UGC 573:MCG 4-3-18:ZWG 480.23"
{
        Type  "S0"
        RA            0.9350
        Dec          24.1272
        Distance   2.114e+08  # method: V
        Radius     3.382e+04
        AbsMag        -20.06
        Axis    [ -0.0525   0.6514  -0.7569]
        Angle    207.3173
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 304"
}

Galaxy "NGC 307:UGC 584:MCG 0-3-35:ZWG 384.39"
{
        Type  "S0"
        RA            0.9422
        Dec          -1.7722
        Distance   1.666e+08  # method: V
        Radius     3.877e+04
        AbsMag        -19.74
        Axis    [  0.2186   0.9592  -0.1794]
        Angle    170.2294
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 307"
}

Galaxy "NGC 309:MCG 2-3-50:IRAS 00542-1010"
{
        Type  "SBc"
        RA            0.9450
        Dec          -9.9142
        Distance   2.423e+08  # method: V
        Radius     1.057e+05
        AbsMag        -21.75
        Axis    [  0.2521   0.5238  -0.8137]
        Angle    203.1701
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 309"
}

Galaxy "NGC 311:UGC 592:MCG 5-3-28:ZWG 501.49"
{
        Type  "S0"
        RA            0.9589
        Dec          30.2803
        Distance   2.158e+08  # method: V
        Radius     4.708e+04
        AbsMag         -20.1
        Axis    [ -0.0527   0.9083  -0.4150]
        Angle    179.0737
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 311"
}

Galaxy "NGC 312:ESO 151-6:AM 0054-530"
{
        Type  "E2"
        RA            0.9375
        Dec         -52.7831
        Distance    3.63e+08  # method: T-F
        Radius     7.392e+04
        AbsMag        -21.83
        Axis    [  0.9473   0.3160   0.0523]
        Angle    189.0566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 312"
}

Galaxy "NGC 314:ESO 411-32:MCG 5-3-15:IRAS 00544-3214"
{
        Type  "S0"
        RA            0.9478
        Dec         -31.9631
        Distance    1.47e+08  # distance uncertain!
        Radius     1.925e+04
        AbsMag        -19.07
        Axis    [  0.4557   0.4159  -0.7870]
        Angle    200.0477
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 314"
}

Galaxy "NGC 315:UGC 597:MCG 5-3-31:ZWG 501.52"
{
        Type  "E0"
        RA            0.9636
        Dec          30.3519
        Distance   2.184e+08  # method: T-F
        Radius      9.53e+04
        AbsMag        -21.93
        Axis    [  0.5922   0.8057  -0.0160]
        Angle    140.6039
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 315"
}

Galaxy "NGC 317-2:NGC 317B:UGC 594:MCG 7-3-10"
{
        Type  "SBc"
        RA            0.9611
        Dec          43.7919
        Distance   2.296e+08  # method: V
        Radius     3.674e+04
        AbsMag        -20.34
        Axis    [ -0.1889   0.9405  -0.2823]
        Angle    169.4147
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 317-2"
}

Galaxy "NGC 317A:NGC 317-1:UGC 593:MCG 7-3-9"
{
        Type  "S0"
        RA            0.9608
        Dec          43.8014
        Distance    2.28e+08  # method: V
        Radius     4.643e+04
        AbsMag        -19.72
        Axis    [  0.1556   0.9330  -0.3245]
        Angle    186.6778
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 317A"
}

Galaxy "NGC 318:ZWG 501.54:NPM 1"
{
        Type  "S0"
        RA            0.9681
        Dec          30.4261
        Distance   2.555e+08  # distance uncertain!
        Radius     1.858e+04
        AbsMag        -19.07
        Axis    [  0.1824   0.8882   0.4217]
        Angle    132.4693
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 318"
}

Galaxy "NGC 319:ESO 243-13:MCG 7-3-1"
{
        Type  "SBa"
        RA            0.9492
        Dec         -43.8386
        Distance    1.54e+08  # distance uncertain!
        Radius     2.239e+04
        AbsMag        -19.07
        Axis    [  0.5616   0.4661  -0.6836]
        Angle    187.4222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 319"
}

Galaxy "NGC 320:ESO 541-3:MCG 4-3-37:IRAS 00563-2106"
{
        Type  "SBa"
        RA            0.9794
        Dec         -20.8403
        Distance   1.688e+08  # distance uncertain!
        Radius     1.964e+04
        AbsMag        -19.07
        Axis    [  0.3052   0.5952  -0.7434]
        Angle    183.9505
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 320"
}

Galaxy "NGC 321:MCG 1-3-43:NPM 1"
{
        Type  "SBc"
        RA            0.9608
        Dec          -5.0858
        Distance   2.934e+08  # distance uncertain!
        Radius     1.707e+04
        AbsMag        -19.07
        Axis    [  0.4224   0.8638  -0.2745]
        Angle    178.4372
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 321"
}

Galaxy "NGC 322-1:ESO 243-15:MCG 7-3-3:AM 0054-435"
{
        Type  "S0"
        RA            0.9528
        Dec         -43.7269
        Distance   3.119e+08  # method: V
        Radius     4.082e+04
        AbsMag         -20.6
        Axis    [  0.4220   0.5762  -0.6999]
        Angle    167.4470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 322-1"
}

Galaxy "NGC 322-2"
{
        Type  "S0"
        RA            0.9525
        Dec         -43.7300
        Distance    6.13e+08  # distance uncertain!
        Radius     1.337e+04
        AbsMag        -19.07
        Axis    [  0.6599   0.7513   0.0090]
        Angle    186.4770
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 322-2"
}

Galaxy "NGC 323:ESO 151-9:AM 0054-531"
{
        Type  "E0"
        RA            0.9447
        Dec         -52.9758
        Distance    3.63e+08  # method: T-F
        Radius     6.864e+04
        AbsMag        -21.63
        Axis    [  0.5928   0.1121  -0.7975]
        Angle    215.5197
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 323"
}

Galaxy "NGC 324:ESO 295-25:MCG 7-3-2:AM 0054-411"
{
        Type  "Sa"
        RA            0.9539
        Dec         -40.9594
        Distance   1.461e+08  # method: V
        Radius     2.974e+04
        AbsMag        -19.25
        Axis    [  0.4715   0.8375  -0.2760]
        Angle    177.1654
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 324"
}

Galaxy "NGC 325:MCG 1-3-45:FGC 111"
{
        Type  "Sc"
        RA            0.9631
        Dec          -5.1125
        Distance   2.676e+08  # distance uncertain!
        Radius     5.059e+04
        AbsMag        -19.07
        Axis    [  0.0683   0.9739  -0.2167]
        Angle    166.8394
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 325"
}

Galaxy "NGC 326:UGC 601:MCG 4-3-25:ZWG 480.26"
{
        Type  "E0"
        RA            0.9728
        Dec          26.8658
        Distance   6.266e+08  # method: V
        Radius     1.276e+05
        AbsMag        -22.12
        Axis    [  0.6636   0.7037   0.2540]
        Angle    109.6712
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 326"
}

Galaxy "NGC 327:MCG 1-3-47"
{
        Type  "Sc"
        RA            0.9653
        Dec          -5.1308
        Distance   2.845e+08  # method: T-F
        Radius     6.207e+04
        AbsMag         -20.4
        Axis    [  0.0625   0.5721  -0.8178]
        Angle    179.4168
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 327"
}

Galaxy "NGC 328:ESO 151-13:AM 0054-531"
{
        Type  "SBa"
        RA            0.9492
        Dec         -52.9236
        Distance   2.103e+08  # method: V
        Radius     7.954e+04
        AbsMag        -19.75
        Axis    [  0.4529   0.8363  -0.3090]
        Angle    173.2992
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 328"
}

Galaxy "NGC 329:MCG 1-3-48"
{
        Type  "Sb"
        RA            0.9669
        Dec          -5.0706
        Distance    1.54e+08  # distance uncertain!
        Radius     3.359e+04
        AbsMag        -19.07
        Axis    [  0.2626   0.8886   0.3760]
        Angle    166.9830
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 329"
}

Galaxy "NGC 331:MCG 1-3-12"
{
        Type  "Sa"
        RA            0.7850
        Dec          -2.7311
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [  0.2457   0.7851  -0.5686]
        Angle    187.3874
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 331"
}

Galaxy "NGC 332:UGC 609:ZWG 410.21"
{
        Type  "E0"
        RA            0.9803
        Dec           7.1111
        Distance   2.754e+08  # distance uncertain!
        Radius     4.006e+04
        AbsMag        -20.13
        Axis    [  0.4323   0.6094  -0.6646]
        Angle    235.2830
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 332"
}

Galaxy "NGC 333:NGC 333A:MCG 3-3-13"
{
        Type  "E0"
        RA            0.9808
        Dec         -16.4689
        Distance   3.312e+08  # distance uncertain!
        Radius     7.706e+04
        AbsMag        -20.13
        Axis    [  0.7315   0.5345  -0.4234]
        Angle    205.8772
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 333"
}

Galaxy "NGC 333B"
{
        Type  "S0"
        RA            0.9806
        Dec         -16.4719
        Distance   2.802e+08  # distance uncertain!
        Radius     1.223e+04
        AbsMag        -19.07
        Axis    [  0.4862   0.8725  -0.0490]
        Angle    174.4003
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 333B"
}

Galaxy "NGC 334:ESO 351-26:MCG 6-3-12:IRAS 00564-3523"
{
        Type  "SBb"
        RA            0.9803
        Dec         -35.1156
        Distance   4.059e+08  # method: V
        Radius     7.085e+04
        AbsMag        -20.87
        Axis    [  0.4384   0.7410   0.5086]
        Angle    188.4047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 334"
}

Galaxy "NGC 335:ESO 541-6:MCG 3-3-15:IRAS 00568-1830"
{
        Type  "Sc"
        RA            0.9886
        Dec         -18.2342
        Distance   2.366e+08  # method: V
        Radius     3.785e+04
        AbsMag         -19.2
        Axis    [  0.1831   0.7827  -0.5948]
        Angle    166.6372
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 335"
}

Galaxy "NGC 336:ESO 541-2:IRAS 00555-1839"
{
        Type  "S0"
        RA            0.9675
        Dec         -18.3858
        Distance   2.676e+08  # distance uncertain!
        Radius     2.335e+04
        AbsMag        -19.07
        Axis    [  0.3073   0.9314   0.1950]
        Angle    176.6940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 336"
}

Galaxy "NGC 337:MCG 1-3-53:IRAS 00573-0750"
{
        Type  "SBc"
        RA            0.9969
        Dec          -7.5781
        Distance   6.048e+07  # method: V
        Radius     2.639e+04
        AbsMag        -19.04
        Axis    [  0.2490   0.7431  -0.6211]
        Angle    183.6723
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 337"
}

Galaxy "NGC 337A:MCG 1-3-65:IRAS 00589-0751"
{
        Type  "Irr"
        RA            1.0258
        Dec          -7.5883
        Distance   3.438e+07  # method: V
        Radius     3.301e+04
        AbsMag        -17.31
        Axis    [  0.4811   0.7683   0.4223]
        Angle    156.2228
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 337A"
}

Galaxy "NGC 338:UGC 624:MCG 5-3-34:ZWG 501.61"
{
        Type  "Sb"
        RA            1.0100
        Dec          30.6692
        Distance   2.546e+08  # method: T-F
        Radius     6.666e+04
        AbsMag        -20.76
        Axis    [ -0.1555   0.9316  -0.3285]
        Angle    168.3597
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 338"
}

Galaxy "NGC 340:MCG 1-3-55:IRAS 00580-0708"
{
        Type  "Sb"
        RA            1.0094
        Dec          -6.8661
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.2870   0.9578  -0.0119]
        Angle    169.0955
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 340"
}

Galaxy "NGC 341:NGC 341A:MCG 2-3-63:MK 968"
{
        Type  "SBc"
        RA            1.0125
        Dec          -9.1861
        Distance   1.894e+08  # method: V
        Radius     3.307e+04
        AbsMag        -20.02
        Axis    [  0.6315   0.7745   0.0363]
        Angle    167.2017
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 341"
}

Galaxy "NGC 341B:MCG 2-3-64:MK 968:ARP 59"
{
        Type  "E0"
        RA            1.0131
        Dec          -9.1872
        Distance   7.245e+08  # distance uncertain!
        Radius     3.161e+04
        AbsMag        -20.13
        Axis    [  0.7538   0.5187   0.4034]
        Angle    135.1685
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 341B"
}

Galaxy "NGC 342:MCG 1-3-58:NPM 1"
{
        Type  "E0"
        RA            1.0136
        Dec          -6.7722
        Distance   4.169e+08  # distance uncertain!
        Radius     4.851e+04
        AbsMag        -20.13
        Axis    [  0.7099   0.6156  -0.3421]
        Angle    197.9606
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 342"
}

Galaxy "NGC 343:AM 0055-232"
{
        Type  "S0"
        RA            0.9731
        Dec         -23.2244
        Distance   3.868e+08  # distance uncertain!
        Radius     3.938e+04
        AbsMag        -19.07
        Axis    [  0.3670   0.8169   0.4450]
        Angle    180.3831
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 343"
}

Galaxy "NGC 344:AM 0055-232"
{
        Type  "S0"
        RA            0.9736
        Dec         -23.2289
        Distance   5.098e+08  # distance uncertain!
        Radius     2.966e+04
        AbsMag        -19.07
        Axis    [  0.4364   0.8863   0.1550]
        Angle    177.1801
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 344"
}

Galaxy "NGC 345:MCG 1-3-64"
{
        Type  "Sa"
        RA            1.0228
        Dec          -6.8842
        Distance   1.938e+08  # distance uncertain!
        Radius     3.383e+04
        AbsMag        -19.07
        Axis    [  0.2851   0.7476  -0.5998]
        Angle    185.9987
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 345"
}

Galaxy "NGC 347:MCG 1-3-63"
{
        Type  "S0"
        RA            1.0264
        Dec          -6.7336
        Distance   2.802e+08  # distance uncertain!
        Radius     2.445e+04
        AbsMag        -19.07
        Axis    [  0.3352   0.8239  -0.4570]
        Angle    181.3120
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 347"
}

Galaxy "NGC 348:ESO 151-17"
{
        Type  "Sb"
        RA            1.0142
        Dec         -53.2450
        Distance   1.768e+08  # distance uncertain!
        Radius     2.057e+04
        AbsMag        -19.07
        Axis    [  0.8116   0.5252  -0.2560]
        Angle    190.5622
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 348"
}

Galaxy "NGC 349:MCG 1-3-68"
{
        Type  "S0"
        RA            1.0306
        Dec          -6.7997
        Distance   1.404e+08  # distance uncertain!
        Radius     2.655e+04
        AbsMag        -19.07
        Axis    [  0.6275   0.7746   0.0788]
        Angle    163.2662
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 349"
}

Galaxy "NGC 350:MCG 1-3-69:NPM 1"
{
        Type  "S0"
        RA            1.0322
        Dec          -6.7953
        Distance   3.217e+08  # distance uncertain!
        Radius     3.275e+04
        AbsMag        -19.07
        Axis    [  0.4339   0.8844  -0.1721]
        Angle    173.5317
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 350"
}

Galaxy "NGC 351:UGC 639:MCG 0-3-57:ZWG 384.57"
{
        Type  "SBa"
        RA            1.0325
        Dec          -1.9364
        Distance   1.755e+08  # method: V
        Radius     3.829e+04
        AbsMag        -19.55
        Axis    [  0.1681   0.7643  -0.6226]
        Angle    181.4449
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 351"
}

Galaxy "NGC 352:MCG 1-3-71:IRAS 00596-0430"
{
        Type  "SBb"
        RA            1.0358
        Dec          -4.2453
        Distance   2.249e+08  # method: V
        Radius      7.85e+04
        AbsMag        -20.69
        Axis    [  0.0461   0.6427  -0.7647]
        Angle    173.9413
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 352"
}

Galaxy "NGC 353:UGC 641:MCG 0-3-58:ZWG 384.58"
{
        Type  "SBa"
        RA            1.0400
        Dec          -1.9569
        Distance   1.748e+08  # method: V
        Radius     3.305e+04
        AbsMag        -19.04
        Axis    [  0.1945   0.9223   0.3339]
        Angle    166.4325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 353"
}

Galaxy "NGC 354:UGC 645:MCG 4-3-37:MK 353"
{
        Type  "SBa"
        RA            1.0544
        Dec          22.3428
        Distance   1.547e+08  # method: T-F
        Radius       1.8e+04
        AbsMag        -19.08
        Axis    [  0.1530   0.9435   0.2940]
        Angle    145.5190
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 354"
}

Galaxy "NGC 355:MCG 1-3-77:NPM 1"
{
        Type  "S0"
        RA            1.0517
        Dec          -6.3236
        Distance   3.868e+08  # distance uncertain!
        Radius     5.625e+04
        AbsMag        -19.07
        Axis    [  0.2609   0.9652   0.0161]
        Angle    168.1255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 355"
}

Galaxy "NGC 356:MCG 1-3-78:VV 486:IRAS 01005-0715"
{
        Type  "Sc"
        RA            1.0519
        Dec          -6.9881
        Distance   2.527e+08  # method: V
        Radius     6.615e+04
        AbsMag        -20.55
        Axis    [  0.4334   0.8981   0.0749]
        Angle    166.4272
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 356"
}

Galaxy "NGC 357:MCG 1-3-81"
{
        Type  "SBa"
        RA            1.0558
        Dec          -6.3392
        Distance   1.008e+08  # method: V
        Radius     3.667e+04
        AbsMag        -19.35
        Axis    [  0.4422   0.8635   0.2427]
        Angle    161.8628
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 357"
}

Galaxy "NGC 359:UGC 662:MCG 0-3-66:ZWG 384.66"
{
        Type  "S0"
        RA            1.0711
        Dec          -0.7644
        Distance   1.612e+08  # distance uncertain!
        Radius     3.517e+04
        AbsMag        -19.07
        Axis    [  0.2828   0.7706  -0.5712]
        Angle    188.6934
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 359"
}

Galaxy "NGC 360:ESO 79-14:FGCE 119"
{
        Type  "Sc"
        RA            1.0475
        Dec         -65.6089
        Distance   1.071e+08  # method: T-F
        Radius      5.61e+04
        AbsMag        -19.18
        Axis    [  0.5037   0.6235  -0.5979]
        Angle    150.7764
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 360"
}

Galaxy "NGC 363:MCG 3-3-23:NPM 1"
{
        Type  "S0"
        RA            1.1042
        Dec         -16.5422
        Distance   2.934e+08  # distance uncertain!
        Radius      2.56e+04
        AbsMag        -19.07
        Axis    [  0.6096   0.7869   0.0963]
        Angle    168.8366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 363"
}

Galaxy "NGC 364:UGC 666:MCG 0-3-69:ZWG 384.67"
{
        Type  "S0"
        RA            1.0778
        Dec          -0.8028
        Distance    1.54e+08  # distance uncertain!
        Radius     3.135e+04
        AbsMag        -19.07
        Axis    [  0.5385   0.8094   0.2341]
        Angle    153.1082
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 364"
}

Galaxy "NGC 365:ESO 352-1:MCG 6-3-17:IRAS 01019-3523"
{
        Type  "SBc"
        RA            1.0717
        Dec         -35.1222
        Distance    1.54e+08  # distance uncertain!
        Radius     2.239e+04
        AbsMag        -19.07
        Axis    [  0.5033   0.7217   0.4752]
        Angle    183.8733
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 365"
}

Galaxy "NGC 367"
{
        Type  "S0"
        RA            1.0967
        Dec         -12.1283
        Distance   2.934e+08  # distance uncertain!
        Radius      3.84e+04
        AbsMag        -19.07
        Axis    [  0.3962   0.8262   0.4006]
        Angle    166.5784
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 367"
}

Galaxy "NGC 368:ESO 243-23"
{
        Type  "SBa"
        RA            1.0725
        Dec         -43.2761
        Distance   1.851e+08  # distance uncertain!
        Radius     1.885e+04
        AbsMag        -19.07
        Axis    [  0.4834   0.3549  -0.8002]
        Angle    190.9235
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 368"
}

Galaxy "NGC 369:ESO 541-17:MCG 3-3-22"
{
        Type  "SBb"
        RA            1.0856
        Dec         -17.7592
        Distance    2.67e+08  # method: V
        Radius     3.883e+04
        AbsMag        -19.97
        Axis    [  0.5917   0.8026   0.0756]
        Angle    170.7087
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 369"
}

Galaxy "NGC 373"
{
        Type  "E0"
        RA            1.1161
        Dec          32.3089
        Distance   5.249e+08  # distance uncertain!
        Radius     3.053e+04
        AbsMag        -20.13
        Axis    [  0.6584   0.7193   0.2216]
        Angle    104.8726
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 373"
}

Galaxy "NGC 374:UGC 680:MCG 5-3-48:ZWG 501.80"
{
        Type  "Sa"
        RA            1.1181
        Dec          32.7947
        Distance   2.165e+08  # method: V
        Radius     3.464e+04
        AbsMag        -19.71
        Axis    [ -0.1983   0.6448  -0.7382]
        Angle    198.6711
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 374"
}

Galaxy "NGC 375:ARP 331:NPM 1"
{
        Type  "E2"
        RA            1.1181
        Dec          32.3486
        Distance   2.593e+08  # method: V
        Radius     1.885e+04
        AbsMag           -19
        Axis    [  0.6584   0.7193   0.2214]
        Angle    104.8298
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 375"
}

Galaxy "NGC 377:ESO 541-19:MCG 4-3-53:IRAS 01041-2036"
{
        Type  "Sc"
        RA            1.1097
        Dec         -20.3314
        Distance   2.934e+08  # distance uncertain!
        Radius     3.414e+04
        AbsMag        -19.07
        Axis    [  0.2721   0.9202   0.2814]
        Angle    179.4974
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 377"
}

Galaxy "NGC 378:ESO 412-5:MCG 5-3-24:AM 0103-302"
{
        Type  "SBc"
        RA            1.1033
        Dec         -30.1781
        Distance   4.242e+08  # method: V
        Radius     9.254e+04
        AbsMag        -21.77
        Axis    [  0.5752   0.7299  -0.3695]
        Angle    181.9634
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 378"
}

Galaxy "NGC 379:UGC 683:MCG 5-3-50:ZWG 501.82"
{
        Type  "S0"
        RA            1.1208
        Dec          32.5203
        Distance   2.228e+08  # method: T-F
        Radius     4.537e+04
        AbsMag        -20.27
        Axis    [  0.1459   0.8388   0.5246]
        Angle    130.2065
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 379"
}

Galaxy "NGC 380:UGC 682:MCG 5-3-51:ZWG 501.81"
{
        Type  "E2"
        RA            1.1214
        Dec          32.4828
        Distance   2.228e+08  # method: T-F
        Radius     4.213e+04
        AbsMag        -20.57
        Axis    [  0.6583   0.7197   0.2206]
        Angle    104.7129
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 380"
}

Galaxy "NGC 382:UGC 688:MCG 5-3-52:ZWG 501.86"
{
        Type  "E0"
        RA            1.1231
        Dec          32.4033
        Distance   2.228e+08  # method: T-F
        Radius     2.268e+04
        AbsMag        -19.97
        Axis    [  0.6587   0.7192   0.2210]
        Angle    104.7509
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 382"
}

Galaxy "NGC 383:UGC 689:MCG 5-3-53:ZWG 501.87"
{
        Type  "S0"
        RA            1.1233
        Dec          32.4122
        Distance   2.228e+08  # method: T-F
        Radius     6.481e+04
        AbsMag        -20.97
        Axis    [  0.3367   0.9236   0.1835]
        Angle    131.4815
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 383"
}

Galaxy "NGC 384:UGC 686:MCG 5-3-55:ZWG 501.84"
{
        Type  "E3"
        RA            1.1236
        Dec          32.2928
        Distance   1.862e+08  # method: V
        Radius     2.979e+04
        AbsMag        -19.78
        Axis    [  0.3786   0.8173  -0.4344]
        Angle    214.0292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 384"
}

Galaxy "NGC 385:UGC 687:MCG 5-3-56:ZWG 501.85"
{
        Type  "S0"
        RA            1.1242
        Dec          32.3194
        Distance   2.228e+08  # method: T-F
        Radius     3.564e+04
        AbsMag        -20.17
        Axis    [  0.1295   0.8280  -0.5456]
        Angle    209.1605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 385"
}

Galaxy "NGC 386:MCG 5-3-57:ZWG 501.88:ARAK 27"
{
        Type  "E3"
        RA            1.1253
        Dec          32.3625
        Distance   2.386e+08  # method: V
        Radius     1.388e+04
        AbsMag        -18.82
        Axis    [  0.6468   0.7453   0.1618]
        Angle    111.3510
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 386"
}

Galaxy "NGC 387"
{
        Type  "E0"
        RA            1.1258
        Dec          32.3908
        Distance   6.919e+08  # distance uncertain!
        Radius     4.025e+04
        AbsMag        -20.13
        Axis    [  0.6591   0.7189   0.2210]
        Angle    104.7353
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 387"
}

Galaxy "NGC 388:MCG 5-3-59:ZWG 501.90:ARAK 28"
{
        Type  "E1"
        RA            1.1297
        Dec          32.3106
        Distance   2.186e+08  # method: V
        Radius     1.908e+04
        AbsMag        -18.53
        Axis    [  0.2766   0.7766  -0.5660]
        Angle    237.9289
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 388"
}

Galaxy "NGC 389:UGC 703:MCG 6-3-14:ZWG 520.17"
{
        Type  "Sa"
        RA            1.1414
        Dec          39.6950
        Distance    2.03e+08  # distance uncertain!
        Radius     3.838e+04
        AbsMag        -19.07
        Axis    [ -0.1412   0.9814   0.1302]
        Angle    144.9564
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 389"
}

Galaxy "NGC 391:UGC 693:MCG 0-3-75:ZWG 384.77"
{
        Type  "S0"
        RA            1.1228
        Dec           0.9258
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.4660   0.8762   0.1227]
        Angle    158.1518
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 391"
}

Galaxy "NGC 392:UGC 700:MCG 5-3-62:ZWG 501.94"
{
        Type  "S0"
        RA            1.1397
        Dec          33.1333
        Distance   2.228e+08  # method: T-F
        Radius     3.889e+04
        AbsMag        -20.47
        Axis    [  0.2114   0.9751   0.0665]
        Angle    143.0416
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 392"
}

Galaxy "NGC 393:UGC 707:MCG 6-3-15:ZWG 520.18"
{
        Type  "S0"
        RA            1.1433
        Dec          39.6439
        Distance   1.017e+08  # distance uncertain!
        Radius     2.515e+04
        AbsMag        -19.07
        Axis    [  0.2658   0.9452   0.1894]
        Angle    126.8213
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 393"
}

Galaxy "NGC 394:MCG 5-3-63:ZWG 501.95:ARAK 30"
{
        Type  "S0"
        RA            1.1406
        Dec          33.1478
        Distance   2.125e+08  # distance uncertain!
        Radius     1.855e+04
        AbsMag        -19.07
        Axis    [ -0.1124   0.8774  -0.4665]
        Angle    179.7005
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 394"
}

Galaxy "NGC 396"
{
        Type  "S0"
        RA            1.1356
        Dec           4.5308
        Distance   4.241e+08  # distance uncertain!
        Radius     2.467e+04
        AbsMag        -19.07
        Axis    [  0.3949   0.9152  -0.0803]
        Angle    164.8773
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 396"
}

Galaxy "NGC 397:MCG 5-3-64:ZWG 501.96:NPM 1"
{
        Type  "E0"
        RA            1.1419
        Dec          33.1097
        Distance   5.012e+08  # distance uncertain!
        Radius     5.103e+04
        AbsMag        -20.13
        Axis    [  0.5641   0.8211  -0.0870]
        Angle    146.3347
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 397"
}

Galaxy "NGC 398:MCG 5-3-65:ZWG 501.100:ARAK 31"
{
        Type  "S0"
        RA            1.1481
        Dec          32.5150
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [ -0.0664   0.8269  -0.5585]
        Angle    191.7182
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 398"
}

Galaxy "NGC 399:UGC 712:MCG 5-3-67:ZWG 501.101"
{
        Type  "SBa"
        RA            1.1497
        Dec          32.6336
        Distance   2.233e+08  # method: V
        Radius     2.923e+04
        AbsMag        -19.68
        Axis    [  0.2572   0.9570   0.1340]
        Angle    137.6218
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 399"
}

Galaxy "NGC 403:UGC 715:MCG 5-3-68:ZWG 501.104"
{
        Type  "Sa"
        RA            1.1539
        Dec          32.7517
        Distance   2.164e+08  # method: V
        Radius     5.665e+04
        AbsMag        -20.71
        Axis    [ -0.1326   0.9808  -0.1432]
        Angle    157.8742
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 403"
}

Galaxy "NGC 404:UGC 718:MCG 6-3-18:ZWG 520.20"
{
        Type  "S0"
        RA            1.1572
        Dec          35.7183
        Distance   1.065e+07  # method: S
        Radius          5423
        AbsMag        -16.57
        Axis    [  0.6270   0.7467   0.2223]
        Angle    102.9214
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 404"
}

Galaxy "NGC 406:ESO 51-18:IRAS 01057-7008"
{
        Type  "Sc"
        RA            1.1233
        Dec         -69.8761
        Distance   7.651e+07  # method: T-F
        Radius     2.893e+04
        AbsMag        -18.85
        Axis    [  0.5552   0.4338  -0.7096]
        Angle    152.5502
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 406"
}

Galaxy "NGC 407:UGC 730:MCG 5-3-77:ZWG 501.115"
{
        Type  "Sa"
        RA            1.1767
        Dec          33.1253
        Distance   2.413e+08  # method: V
        Radius     6.317e+04
        AbsMag        -19.94
        Axis    [ -0.0145   0.8137   0.5811]
        Angle    141.5747
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 407"
}

Galaxy "NGC 409:ESO 352-12:MCG 6-3-23"
{
        Type  "E0"
        RA            1.1592
        Dec         -35.8056
        Distance   2.861e+08  # method: V
        Radius     5.409e+04
        AbsMag        -20.71
        Axis    [  0.5373   0.2495  -0.8057]
        Angle    222.1336
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 409"
}

Galaxy "NGC 410:UGC 735:MCG 5-3-80:ZWG 501.118"
{
        Type  "E0"
        RA            1.1828
        Dec          33.1525
        Distance   2.228e+08  # method: T-F
        Radius     7.777e+04
        AbsMag        -21.67
        Axis    [  0.6124   0.7899   0.0324]
        Angle    126.4838
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 410"
}

Galaxy "NGC 413:MCG 1-4-13"
{
        Type  "Sc"
        RA            1.2086
        Dec          -2.7933
        Distance    2.49e+08  # method: V
        Radius     4.345e+04
        AbsMag        -19.51
        Axis    [  0.1679   0.7097  -0.6842]
        Angle    183.0848
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 413"
}

Galaxy "NGC 414:UGC 744:ZWG 501.123:ZW 39"
{
        Type  "S0"
        RA            1.1881
        Dec          33.1136
        Distance   1.688e+08  # distance uncertain!
        Radius     1.719e+04
        AbsMag        -19.07
        Axis    [  0.1219   0.9658   0.2290]
        Angle    137.6882
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 414"
}

Galaxy "NGC 415:ESO 352-14:MCG 6-3-24:IRAS 01077-3545"
{
        Type  "SBb"
        RA            1.1681
        Dec         -35.4903
        Distance   2.761e+08  # method: T-F
        Radius     6.024e+04
        AbsMag        -20.34
        Axis    [  0.5465   0.8359   0.0521]
        Angle    180.9619
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 415"
}

Galaxy "NGC 417:ESO 541-24:MCG 3-4-19:NPM 1"
{
        Type  "S0"
        RA            1.1847
        Dec         -18.1486
        Distance    2.44e+08  # distance uncertain!
        Radius      2.13e+04
        AbsMag        -19.07
        Axis    [  0.6224   0.7816   0.0412]
        Angle    170.3671
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 417"
}

Galaxy "NGC 418:ESO 412-9:MCG 5-4-2:AM 0108-302"
{
        Type  "SBc"
        RA            1.1764
        Dec         -30.2211
        Distance   2.471e+08  # method: V
        Radius     7.187e+04
        AbsMag         -21.3
        Axis    [  0.6460   0.6457   0.4072]
        Angle    169.6802
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 418"
}

Galaxy "NGC 420:UGC 752:MCG 5-3-83:ZWG 501.127"
{
        Type  "S0"
        RA            1.2025
        Dec          32.1231
        Distance   2.124e+08  # method: V
        Radius     6.179e+04
        AbsMag        -20.87
        Axis    [  0.0341   0.7269  -0.6859]
        Angle    224.6198
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 420"
}

Galaxy "NGC 423:ESO 412-11:MCG 5-4-4:IRAS 01090-2929"
{
        Type  "Sa"
        RA            1.1894
        Dec         -29.2344
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.3792   0.8139  -0.4402]
        Angle    170.2735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 423"
}

Galaxy "NGC 424:ESO 296-4:MCG 6-3-26:AM 0109-382"
{
        Type  "SBa"
        RA            1.1908
        Dec         -38.0836
        Distance   1.461e+08  # method: V
        Radius     4.887e+04
        AbsMag        -19.46
        Axis    [  0.4644   0.8856   0.0045]
        Angle    181.5337
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 424"
}

Galaxy "NGC 425:UGC 758:MCG 6-3-23:ZWG 520.26"
{
        Type  "S0"
        RA            1.2172
        Dec          38.7692
        Distance   2.759e+08  # method: V
        Radius     4.013e+04
        AbsMag        -21.04
        Axis    [  0.2034   0.9789   0.0195]
        Angle    141.4495
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 425"
}

Galaxy "NGC 426:UGC 760:MCG 0-4-35:ZWG 385.26"
{
        Type  "E0"
        RA            1.2133
        Dec          -0.2897
        Distance   2.242e+08  # method: V
        Radius     4.566e+04
        AbsMag        -20.39
        Axis    [  0.5630   0.6134  -0.5539]
        Angle    215.9298
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 426"
}

Galaxy "NGC 427:ESO 412-14:MCG 5-4-7"
{
        Type  "SBa"
        RA            1.2053
        Dec         -32.0611
        Distance   4.424e+08  # method: V
        Radius     6.434e+04
        AbsMag        -20.56
        Axis    [  0.4921   0.7085   0.5058]
        Angle    180.5470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 427"
}

Galaxy "NGC 428:UGC 763:MCG 0-4-36:ZWG 385.28"
{
        Type  "Irr"
        RA            1.2153
        Dec           0.9814
        Distance   3.837e+07  # method: V
        Radius     2.232e+04
        AbsMag        -18.45
        Axis    [  0.3024   0.8294  -0.4698]
        Angle    181.4719
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 428"
}

Galaxy "NGC 429:UGC 762:MCG 0-4-37:ZWG 385.27"
{
        Type  "S0"
        RA            1.2158
        Dec          -0.3450
        Distance   2.415e+08  # method: V
        Radius     4.917e+04
        AbsMag        -19.95
        Axis    [  0.1310   0.9077   0.3987]
        Angle    167.2927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 429"
}

Galaxy "NGC 430:UGC 765:MCG 0-4-39:ZWG 385.29"
{
        Type  "E0"
        RA            1.2164
        Dec          -0.2525
        Distance   2.251e+08  # method: V
        Radius     4.257e+04
        AbsMag        -20.69
        Axis    [  0.4997   0.5826  -0.6410]
        Angle    224.8800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 430"
}

Galaxy "NGC 431:UGC 776:MCG 5-4-2:ZWG 502.8"
{
        Type  "S0"
        RA            1.2344
        Dec          33.7053
        Distance   4.195e+08  # method: T-F
        Radius     8.543e+04
        AbsMag        -21.65
        Axis    [  0.1983   0.9222   0.3320]
        Angle    129.5715
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 431"
}

Galaxy "NGC 432:ESO 113-22"
{
        Type  "S0"
        RA            1.1961
        Dec         -61.5275
        Distance   3.607e+08  # method: V
        Radius      6.82e+04
        AbsMag        -21.22
        Axis    [  0.8176   0.3597  -0.4497]
        Angle    191.7728
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 432"
}

Galaxy "NGC 434:ESO 113-23:AM 0110-583"
{
        Type  "SBb"
        RA            1.2039
        Dec         -58.2472
        Distance    2.17e+08  # method: V
        Radius     6.943e+04
        AbsMag        -21.31
        Axis    [  0.5866   0.6785   0.4422]
        Angle    203.9212
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 434"
}

Galaxy "NGC 434A:ESO 113-24"
{
        Type  "SBa"
        RA            1.2083
        Dec         -58.2078
        Distance   2.126e+08  # method: V
        Radius     3.711e+04
        AbsMag        -18.27
        Axis    [  0.5297   0.8468   0.0479]
        Angle    194.8267
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 434A"
}

Galaxy "NGC 435:UGC 779:MCG 0-4-46:ZWG 385.35"
{
        Type  "Sc"
        RA            1.2331
        Dec           2.0711
        Distance    2.03e+08  # distance uncertain!
        Radius     3.247e+04
        AbsMag        -19.07
        Axis    [  0.2304   0.8666   0.4426]
        Angle    159.9428
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 435"
}

Galaxy "NGC 437:UGC 788:MCG 1-4-5:ZWG 411.9"
{
        Type  "Sa"
        RA            1.2394
        Dec           5.9264
        Distance   2.254e+08  # method: V
        Radius     4.262e+04
        AbsMag         -20.3
        Axis    [  0.2640   0.8054  -0.5308]
        Angle    186.9803
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 437"
}

Galaxy "NGC 438:ESO 296-7:MCG 6-3-29:IRAS 01112-3810"
{
        Type  "SBb"
        RA            1.2261
        Dec         -37.9014
        Distance   1.464e+08  # method: V
        Radius     2.981e+04
        AbsMag        -19.66
        Axis    [  0.6859   0.6960   0.2126]
        Angle    179.5438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 438"
}

Galaxy "NGC 439:ESO 412-18:MCG 5-4-15:AM 0111-320"
{
        Type  "S0"
        RA            1.2297
        Dec         -31.7472
        Distance   2.499e+08  # method: V
        Radius     9.086e+04
        AbsMag        -21.92
        Axis    [  0.3671   0.5645  -0.7393]
        Angle    175.6623
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 439"
}

Galaxy "NGC 440:ESO 113-25:AM 0110-583"
{
        Type  "Sc"
        RA            1.2133
        Dec         -58.2828
        Distance   2.211e+08  # method: V
        Radius     3.859e+04
        AbsMag        -20.46
        Axis    [  0.6940   0.7090   0.1253]
        Angle    194.6625
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 440"
}

Galaxy "NGC 441:ESO 412-19:MCG 5-4-16"
{
        Type  "SBa"
        RA            1.2308
        Dec         -31.7889
        Distance   2.452e+08  # method: V
        Radius     4.992e+04
        AbsMag        -20.58
        Axis    [  0.5252   0.5996  -0.6038]
        Angle    185.3281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 441"
}

Galaxy "NGC 442:UGC 789:MCG 0-4-54:ZWG 385.41"
{
        Type  "Sa"
        RA            1.2439
        Dec          -1.0206
        Distance   2.405e+08  # method: V
        Radius     3.497e+04
        AbsMag        -19.84
        Axis    [  0.0988   0.6889  -0.7181]
        Angle    180.1092
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 442"
}

Galaxy "NGC 443:IC 1653:UGC 796:MCG 5-4-5"
{
        Type  "S0"
        RA            1.2519
        Dec          33.3778
        Distance   2.091e+08  # method: V
        Radius     2.433e+04
        AbsMag        -19.53
        Axis    [  0.3103   0.9504  -0.0214]
        Angle    145.2602
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 443"
}

Galaxy "NGC 444:IC 1658:UGC 810:MCG 5-4-7"
{
        Type  "Sc"
        RA            1.2636
        Dec          31.0806
        Distance   1.865e+08  # method: T-F
        Radius     5.153e+04
        AbsMag        -18.89
        Axis    [ -0.2994   0.7036  -0.6444]
        Angle    174.8991
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 444"
}

Galaxy "NGC 445:ZWG 385.47"
{
        Type  "S0"
        RA            1.2478
        Dec           1.9175
        Distance    2.44e+08  # distance uncertain!
        Radius     1.775e+04
        AbsMag        -19.07
        Axis    [  0.2387   0.6921  -0.6811]
        Angle    196.8611
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 445"
}

Galaxy "NGC 446:IC 89:UGC 818:MCG 1-4-12"
{
        Type  "S0"
        RA            1.2675
        Dec           4.2944
        Distance   2.323e+08  # method: V
        Radius     6.759e+04
        AbsMag        -20.46
        Axis    [  0.4619   0.8862   0.0370]
        Angle    157.5769
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 446"
}

Galaxy "NGC 447:IC 1656:UGC 804:MCG 5-4-6"
{
        Type  "SBa"
        RA            1.2603
        Dec          33.0664
        Distance   2.408e+08  # method: V
        Radius     7.706e+04
        AbsMag        -19.84
        Axis    [  0.6484   0.7246   0.2335]
        Angle    103.8092
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 447"
}

Galaxy "NGC 448:UGC 801:MCG 0-4-60:ZWG 385.51"
{
        Type  "S0"
        RA            1.2544
        Dec          -1.6253
        Distance   9.896e+07  # method: S
        Radius     2.303e+04
        AbsMag        -19.21
        Axis    [  0.2035   0.8740  -0.4413]
        Angle    171.9096
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 448"
}

Galaxy "NGC 449:MCG 5-4-9:MK 1:ZWG 502.18"
{
        Type  "Sb"
        RA            1.2686
        Dec          33.0889
        Distance   2.057e+08  # method: V
        Radius     2.394e+04
        AbsMag           -19
        Axis    [  0.0853   0.9942  -0.0653]
        Angle    152.0603
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 449"
}

Galaxy "NGC 450:UGC 806:MCG 0-4-62:ZWG 385.52"
{
        Type  "SBc"
        RA            1.2583
        Dec          -0.8614
        Distance   7.203e+07  # method: T-F
        Radius     3.143e+04
        AbsMag        -19.42
        Axis    [  0.4727   0.8747  -0.1072]
        Angle    166.5592
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 450"
}

Galaxy "NGC 451:IC 1661:MCG 5-4-11:MK 976"
{
        Type  "Sc"
        RA            1.2700
        Dec          33.0636
        Distance   2.085e+08  # method: V
        Radius     2.123e+04
        AbsMag        -19.13
        Axis    [  0.2253   0.9552   0.1917]
        Angle    134.3555
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 451"
}

Galaxy "NGC 452:UGC 820:MCG 5-4-10:ZWG 502.20"
{
        Type  "SBb"
        RA            1.2708
        Dec          31.0333
        Distance   2.149e+08  # method: T-F
        Radius     7.813e+04
        AbsMag        -19.79
        Axis    [ -0.0298   0.9756   0.2175]
        Angle    144.4420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 452"
}

Galaxy "NGC 454-1:ESO 151-36:AM 0112-554"
{
        Type  "S0"
        RA            1.2392
        Dec         -55.4006
        Distance    8.86e+07  # distance uncertain!
        Radius     2.191e+04
        AbsMag        -19.07
        Axis    [  0.7572   0.5183   0.3975]
        Angle    187.9872
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 454-1"
}

Galaxy "NGC 454-2:ESO 151-36:AM 0112-554"
{
        Type  "S0"
        RA            1.2400
        Dec         -55.3972
        Distance   1.584e+08  # method: V
        Radius     2.304e+04
        AbsMag        -18.93
        Axis    [  0.6481   0.7175  -0.2553]
        Angle    180.9470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 454-2"
}

Galaxy "NGC 455:UGC 815:MCG 1-4-11:ZWG 411.15"
{
        Type  "Irr"
        RA            1.2658
        Dec           5.1783
        Distance   2.245e+08  # method: V
        Radius     6.531e+04
        AbsMag        -20.59
        Axis    [  0.1072   0.7227  -0.6827]
        Angle    185.9050
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 455"
}

Galaxy "NGC 459:UGC 832:MCG 3-4-17:ZWG 459.24"
{
        Type  "Sc"
        RA            1.3022
        Dec          17.5625
        Distance   5.617e+08  # method: V
        Radius     5.719e+04
        AbsMag        -20.68
        Axis    [  0.4503   0.8751   0.1772]
        Angle    140.0733
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 459"
}

Galaxy "NGC 461:ESO 352-33:MCG 6-4-2:AM 0115-340"
{
        Type  "SBc"
        RA            1.2889
        Dec         -33.8411
        Distance    2.29e+08  # method: T-F
        Radius     3.997e+04
        AbsMag        -20.13
        Axis    [  0.6316   0.7078   0.3163]
        Angle    176.3698
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 461"
}

Galaxy "NGC 462:NPM 1"
{
        Type  "E0"
        RA            1.3028
        Dec           4.2264
        Distance   4.787e+08  # distance uncertain!
        Radius     2.785e+04
        AbsMag        -20.13
        Axis    [  0.7558   0.5603   0.3389]
        Angle    123.5271
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 462"
}

Galaxy "NGC 463:UGC 840:MCG 3-4-19:ZWG 459.25"
{
        Type  "Sa"
        RA            1.3161
        Dec          16.3253
        Distance   2.226e+08  # distance uncertain!
        Radius     3.237e+04
        AbsMag        -19.07
        Axis    [  0.1916   0.8384   0.5103]
        Angle    146.1887
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 463"
}

Galaxy "NGC 466:ESO 113-34:AM 0115-591"
{
        Type  "Sa"
        RA            1.2869
        Dec         -58.9097
        Distance   2.347e+08  # method: V
        Radius     5.804e+04
        AbsMag        -20.69
        Axis    [  0.8205   0.4495  -0.3533]
        Angle    189.2241
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 466"
}

Galaxy "NGC 467:UGC 848:MCG 0-4-79:ZWG 385.65"
{
        Type  "S0"
        RA            1.3194
        Dec           3.3014
        Distance   2.349e+08  # method: V
        Radius     5.808e+04
        AbsMag        -21.19
        Axis    [  0.7409   0.5712   0.3534]
        Angle    125.1760
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 467"
}

Galaxy "NGC 468:IC 92:MCG 5-4-20:ZWG 502.29"
{
        Type  "Sa"
        RA            1.3300
        Dec          32.7672
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [ -0.1543   0.6910  -0.7062]
        Angle    200.1269
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 468"
}

Galaxy "NGC 469:MCG 2-4-23:ZWG 436.24"
{
        Type  "S0"
        RA            1.3258
        Dec          14.8719
        Distance   2.226e+08  # distance uncertain!
        Radius     2.266e+04
        AbsMag        -19.07
        Axis    [ -0.0127   0.6845  -0.7289]
        Angle    190.6709
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 469"
}

Galaxy "NGC 470:UGC 858:MCG 0-4-84:ZWG 385.70"
{
        Type  "Sb"
        RA            1.3289
        Dec           3.4092
        Distance   9.355e+07  # method: V
        Radius     3.946e+04
        AbsMag        -19.79
        Axis    [  0.1054   0.7074  -0.6989]
        Angle    184.3556
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 470"
}

Galaxy "NGC 471:UGC 861:MCG 2-4-24:ZWG 436.29"
{
        Type  "S0"
        RA            1.3331
        Dec          14.7858
        Distance   1.735e+08  # method: V
        Radius     2.524e+04
        AbsMag        -19.43
        Axis    [  0.2595   0.9456  -0.1962]
        Angle    163.9332
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 471"
}

Galaxy "NGC 472:UGC 870:MCG 5-4-22:ZWG 502.34"
{
        Type  "Sa"
        RA            1.3411
        Dec          32.7083
        Distance   1.341e+08  # distance uncertain!
        Radius     2.536e+04
        AbsMag        -19.07
        Axis    [  0.1385   0.9022  -0.4084]
        Angle    184.3726
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 472"
}

Galaxy "NGC 473:UGC 859:MCG 3-4-22:ZWG 459.30"
{
        Type  "SBa"
        RA            1.3317
        Dec          16.5450
        Distance   8.281e+07  # method: V
        Radius     2.288e+04
        AbsMag        -18.72
        Axis    [  0.0343   0.7540  -0.6559]
        Angle    189.7727
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 473"
}

Galaxy "NGC 474:UGC 864:MCG 0-4-85:ZWG 385.71"
{
        Type  "S0"
        RA            1.3350
        Dec           3.4161
        Distance   9.305e+07  # method: V
        Radius     9.609e+04
        AbsMag        -19.97
        Axis    [  0.5123   0.8465  -0.1450]
        Angle    166.4222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 474"
}

Galaxy "NGC 475:IC 97:NPM 1"
{
        Type  "E0"
        RA            1.3336
        Dec          14.8617
        Distance   5.496e+08  # distance uncertain!
        Radius     3.197e+04
        AbsMag        -20.13
        Axis    [  0.7346   0.6106   0.2958]
        Angle    115.4067
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 475"
}

Galaxy "NGC 476:MCG 3-4-23:ZWG 459.33:NPM 1"
{
        Type  "S0"
        RA            1.3386
        Dec          16.0206
        Distance   2.555e+08  # distance uncertain!
        Radius     1.858e+04
        AbsMag        -19.07
        Axis    [  0.2820   0.9022  -0.3265]
        Angle    173.7410
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 476"
}

Galaxy "NGC 477:UGC 886:MCG 7-3-32:ZWG 536.32"
{
        Type  "SBc"
        RA            1.3556
        Dec          40.4886
        Distance   2.538e+08  # method: V
        Radius     5.537e+04
        AbsMag        -20.65
        Axis    [ -0.1587   0.8104  -0.5640]
        Angle    192.5916
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 477"
}

Galaxy "NGC 478:ESO 476-3:MCG 4-4-5:VV 398"
{
        Type  "S0"
        RA            1.3356
        Dec         -22.3781
        Distance   1.768e+08  # distance uncertain!
        Radius     2.314e+04
        AbsMag        -19.07
        Axis    [  0.5905   0.7810  -0.2031]
        Angle    175.8255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 478"
}

Galaxy "NGC 479:UGC 893:MCG 1-4-31:ZWG 411.31"
{
        Type  "Sc"
        RA            1.3542
        Dec           3.8628
        Distance   2.233e+08  # method: V
        Radius     3.572e+04
        AbsMag        -19.38
        Axis    [  0.2203   0.6842  -0.6953]
        Angle    198.3266
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 479"
}

Galaxy "NGC 480"
{
        Type  "Sa"
        RA            1.3428
        Dec          -9.8803
        Distance   3.527e+08  # distance uncertain!
        Radius     2.565e+04
        AbsMag        -19.07
        Axis    [  0.3003   0.9536  -0.0209]
        Angle    165.9435
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 480"
}

Galaxy "NGC 481:MCG 2-4-30"
{
        Type  "S0"
        RA            1.3533
        Dec          -9.2111
        Distance   1.688e+08  # distance uncertain!
        Radius     3.192e+04
        AbsMag        -19.07
        Axis    [  0.4413   0.8717  -0.2129]
        Angle    170.3607
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 481"
}

Galaxy "NGC 482:ESO 296-13:MCG 7-3-17:AM 0118-411"
{
        Type  "Sb"
        RA            1.3389
        Dec         -40.9661
        Distance   2.885e+08  # method: V
        Radius     9.231e+04
        AbsMag        -20.23
        Axis    [  0.4016   0.8931  -0.2025]
        Angle    172.5933
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 482"
}

Galaxy "NGC 483:UGC 906:MCG 5-4-29:ZWG 502.50"
{
        Type  "S0"
        RA            1.3656
        Dec          33.5206
        Distance   2.024e+08  # method: V
        Radius     2.061e+04
        AbsMag        -19.96
        Axis    [  0.6575   0.7178   0.2288]
        Angle    102.5961
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 483"
}

Galaxy "NGC 484:ESO 113-36"
{
        Type  "S0"
        RA            1.3261
        Dec         -58.5244
        Distance   2.297e+08  # method: V
        Radius     6.347e+04
        AbsMag        -22.04
        Axis    [  0.7664   0.5729  -0.2907]
        Angle    184.9445
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 484"
}

Galaxy "NGC 485:UGC 895:MCG 1-4-32:ZWG 411.32"
{
        Type  "S0"
        RA            1.3575
        Dec           7.0181
        Distance   8.797e+07  # method: V
        Radius     2.303e+04
        AbsMag        -18.05
        Axis    [  0.2068   0.8301   0.5179]
        Angle    156.0067
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 485"
}

Galaxy "NGC 487:MCG 3-4-56"
{
        Type  "Sa"
        RA            1.3653
        Dec         -16.3700
        Distance    1.54e+08  # distance uncertain!
        Radius     2.463e+04
        AbsMag        -19.07
        Axis    [  0.4038   0.8054  -0.4339]
        Angle    174.7588
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 487"
}

Galaxy "NGC 488:UGC 907:MCG 1-4-33:ZWG 411.33"
{
        Type  "Sb"
        RA            1.3628
        Dec           5.2558
        Distance   8.874e+07  # method: V
        Radius      6.97e+04
        AbsMag        -20.97
        Axis    [  0.4339   0.8221   0.3686]
        Angle    145.5491
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 488"
}

Galaxy "NGC 489:UGC 908:MCG 1-4-34:ZWG 411.34"
{
        Type  "S0"
        RA            1.3647
        Dec           9.2064
        Distance   1.005e+08  # method: V
        Radius     2.484e+04
        AbsMag        -18.94
        Axis    [ -0.0568   0.8963  -0.4398]
        Angle    162.0221
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 489"
}

Galaxy "NGC 490:MCG 1-4-35:ZWG 411.35:NPM 1"
{
        Type  "S0"
        RA            1.3672
        Dec           5.3678
        Distance    8.68e+07  # method: V
        Radius          8837
        AbsMag        -16.93
        Axis    [  0.5313   0.7558   0.3827]
        Angle    138.8152
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 490"
}

Galaxy "NGC 491:ESO 352-53:MCG 6-4-11:IRAS 01190-3419"
{
        Type  "SBb"
        RA            1.3556
        Dec         -34.0636
        Distance   2.367e+08  # method: T-F
        Radius      4.82e+04
        AbsMag         -21.1
        Axis    [  0.6132   0.7351  -0.2891]
        Angle    178.4396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 491"
}

Galaxy "NGC 491A:ESO 352-46:MCG 6-4-8:AM 0117-340"
{
        Type  "SBc"
        RA            1.3347
        Dec         -33.9006
        Distance   1.734e+08  # method: T-F
        Radius     4.792e+04
        AbsMag        -19.33
        Axis    [  0.4466   0.8216  -0.3542]
        Angle    170.9385
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 491A"
}

Galaxy "NGC 492:MCG 1-4-38:ZWG 411.36"
{
        Type  "SBa"
        RA            1.3703
        Dec           5.4169
        Distance    4.05e+08  # distance uncertain!
        Radius     4.123e+04
        AbsMag        -19.07
        Axis    [  0.3593   0.8082  -0.4666]
        Angle    185.3053
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 492"
}

Galaxy "NGC 493:UGC 914:MCG 0-4-99:ZWG 385.84"
{
        Type  "SBc"
        RA            1.3692
        Dec           0.9464
        Distance   9.722e+07  # method: T-F
        Radius     4.807e+04
        AbsMag        -19.47
        Axis    [  0.1808   0.9818   0.0584]
        Angle    160.5932
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 493"
}

Galaxy "NGC 494:UGC 919:MCG 5-4-34:ZWG 502.57"
{
        Type  "Sb"
        RA            1.3819
        Dec          33.1728
        Distance   2.263e+08  # method: T-F
        Radius     6.583e+04
        AbsMag        -20.41
        Axis    [ -0.1160   0.9601  -0.2544]
        Angle    160.7152
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 494"
}

Galaxy "NGC 495:UGC 920:MCG 5-4-35:ZWG 502.58"
{
        Type  "SBa"
        RA            1.3822
        Dec          33.4708
        Distance   1.739e+08  # method: V
        Radius     3.035e+04
        AbsMag        -19.73
        Axis    [ -0.1156   0.7135  -0.6910]
        Angle    204.3134
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 495"
}

Galaxy "NGC 496:UGC 927:MCG 5-4-36:ZWG 502.60"
{
        Type  "Sc"
        RA            1.3864
        Dec          33.5281
        Distance   2.033e+08  # method: T-F
        Radius      4.73e+04
        AbsMag        -19.77
        Axis    [  0.1456   0.9454   0.2915]
        Angle    132.7852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 496"
}

Galaxy "NGC 497:UGC 915:MCG 0-4-100:ZWG 385.85"
{
        Type  "SBc"
        RA            1.3731
        Dec          -0.8747
        Distance   3.538e+08  # method: V
        Radius      1.08e+05
        AbsMag        -21.38
        Axis    [  0.1212   0.8213  -0.5575]
        Angle    170.4141
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 497"
}

Galaxy "NGC 498:MCG 5-4-37:NPM 1"
{
        Type  "S0"
        RA            1.3864
        Dec          33.4900
        Distance    2.44e+08  # distance uncertain!
        Radius     1.775e+04
        AbsMag        -19.07
        Axis    [  0.6598   0.7158   0.2284]
        Angle    102.4402
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 498"
}

Galaxy "NGC 499:IC 1686:UGC 926:MCG 5-4-38"
{
        Type  "S0"
        RA            1.3864
        Dec          33.4597
        Distance     2.5e+08  # method: T-F
        Radius     6.181e+04
        AbsMag        -21.22
        Axis    [  0.1569   0.9710  -0.1805]
        Angle    158.7287
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 499"
}

Galaxy "NGC 500:MCG 1-4-40:ZWG 411.39:NPM 1"
{
        Type  "S0"
        RA            1.3775
        Dec           5.3878
        Distance    2.33e+08  # distance uncertain!
        Radius     2.712e+04
        AbsMag        -19.07
        Axis    [  0.3302   0.8808  -0.3392]
        Angle    173.2452
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 500"
}

Galaxy "NGC 501:ZWG 502.62:NPM 1"
{
        Type  "E0"
        RA            1.3894
        Dec          33.4336
        Distance   2.089e+08  # method: V
        Radius     1.519e+04
        AbsMag        -18.53
        Axis    [  0.6820   0.7010   0.2085]
        Angle    101.7978
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 501"
}

Galaxy "NGC 502:UGC 922:MCG 1-4-43:ZWG 411.40"
{
        Type  "S0"
        RA            1.3819
        Dec           9.0494
        Distance   9.935e+07  # method: V
        Radius     1.589e+04
        AbsMag        -18.72
        Axis    [  0.5129   0.8542  -0.0855]
        Angle    159.5627
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 502"
}

Galaxy "NGC 503:MCG 5-4-40:ZWG 502.65:NPM 1"
{
        Type  "S0"
        RA            1.3911
        Dec          33.3322
        Distance   2.584e+08  # method: V
        Radius     3.382e+04
        AbsMag        -19.39
        Axis    [  0.2980   0.9256   0.2332]
        Angle    127.8092
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 503"
}

Galaxy "NGC 504:UGC 935:MCG 5-4-41:ZWG 502.64"
{
        Type  "S0"
        RA            1.3911
        Dec          33.2039
        Distance   1.728e+08  # method: V
        Radius     4.272e+04
        AbsMag        -19.62
        Axis    [ -0.1110   0.9714   0.2099]
        Angle    144.2697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 504"
}

Galaxy "NGC 505:UGC 924:MCG 1-4-41:ZWG 411.41"
{
        Type  "S0"
        RA            1.3825
        Dec           9.4689
        Distance   2.125e+08  # distance uncertain!
        Radius     2.782e+04
        AbsMag        -19.07
        Axis    [  0.3339   0.9422   0.0290]
        Angle    154.9311
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 505"
}

Galaxy "NGC 507:UGC 938:MCG 5-4-44:ZWG 502.67"
{
        Type  "S0"
        RA            1.3944
        Dec          33.2567
        Distance     2.5e+08  # method: T-F
        Radius      9.09e+04
        AbsMag        -22.12
        Axis    [  0.6616   0.7139   0.2294]
        Angle    102.5346
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 507"
}

Galaxy "NGC 508:UGC 939:MCG 5-4-45:ZWG 502.68"
{
        Type  "E0"
        RA            1.3944
        Dec          33.2803
        Distance    2.38e+08  # method: V
        Radius     3.808e+04
        AbsMag        -20.22
        Axis    [  0.6831   0.6997   0.2091]
        Angle    101.8605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 508"
}

Galaxy "NGC 509:UGC 932:MCG 1-4-45:ZWG 411.43"
{
        Type  "SBa"
        RA            1.3900
        Dec           9.4333
        Distance   8.911e+07  # method: V
        Radius     2.074e+04
        AbsMag        -17.58
        Axis    [  0.1018   0.9801  -0.1705]
        Angle    160.0603
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 509"
}

Galaxy "NGC 511:UGC 936:MCG 2-4-33:ZWG 436.37"
{
        Type  "E0"
        RA            1.3917
        Dec          11.2908
        Distance   3.312e+08  # distance uncertain!
        Radius     5.298e+04
        AbsMag        -20.13
        Axis    [  0.7487   0.5873   0.3075]
        Angle    117.6812
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 511"
}

Galaxy "NGC 512:UGC 944:MCG 6-4-13:ZWG 521.18"
{
        Type  "Sb"
        RA            1.3997
        Dec          33.9072
        Distance   2.727e+08  # method: T-F
        Radius     6.346e+04
        AbsMag        -20.51
        Axis    [ -0.2486   0.9004  -0.3572]
        Angle    162.7299
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 512"
}

Galaxy "NGC 513:UGC 953:MCG 6-4-16:ZWG 521.20"
{
        Type  "Sc"
        RA            1.4072
        Dec          33.7989
        Distance   2.571e+08  # method: V
        Radius     3.366e+04
        AbsMag        -20.88
        Axis    [  0.1047   0.9893  -0.1016]
        Angle    152.1523
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 513"
}

Galaxy "NGC 514:UGC 947:MCG 2-4-35:ZWG 436.38"
{
        Type  "SBc"
        RA            1.4008
        Dec          12.9172
        Distance   9.808e+07  # method: V
        Radius     5.278e+04
        AbsMag        -20.09
        Axis    [  0.2940   0.8733  -0.3885]
        Angle    177.5565
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 514"
}

Galaxy "NGC 515:UGC 956:MCG 5-4-52:ZWG 502.77"
{
        Type  "S0"
        RA            1.4106
        Dec          33.4722
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.0675   0.8938  -0.4433]
        Angle    184.4934
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 515"
}

Galaxy "NGC 516:UGC 946:MCG 1-4-48:ZWG 411.46"
{
        Type  "SBa"
        RA            1.4022
        Dec           9.5519
        Distance   9.626e+07  # method: V
        Radius      1.96e+04
        AbsMag        -18.15
        Axis    [  0.1615   0.9695   0.1846]
        Angle    154.4940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 516"
}

Galaxy "NGC 517:UGC 960:MCG 5-4-54:ZWG 502.79"
{
        Type  "S0"
        RA            1.4119
        Dec          33.4289
        Distance   1.806e+08  # method: V
        Radius     3.677e+04
        AbsMag        -20.22
        Axis    [  0.0453   0.9128   0.4058]
        Angle    135.6789
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 517"
}

Galaxy "NGC 518:UGC 952:MCG 1-4-49:ZWG 411.47"
{
        Type  "Sa"
        RA            1.4047
        Dec           9.3308
        Distance   1.086e+08  # method: V
        Radius     2.527e+04
        AbsMag        -18.31
        Axis    [  0.0776   0.9573  -0.2786]
        Angle    162.1927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 518"
}

Galaxy "NGC 519:ZWG 385.103:DRCG 7-19"
{
        Type  "E0"
        RA            1.4078
        Dec          -1.6414
        Distance   2.278e+08  # method: V
        Radius     1.657e+04
        AbsMag        -18.82
        Axis    [  0.5598   0.6017  -0.5697]
        Angle    213.5590
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 519"
}

Galaxy "NGC 520:UGC 966:MCG 1-4-52:ZWG 411.50"
{
        Type  "Sa"
        RA            1.4094
        Dec           3.7942
        Distance   8.652e+07  # method: V
        Radius     4.279e+04
        AbsMag        -19.92
        Axis    [  0.1238   0.8335  -0.5385]
        Angle    172.8432
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 520"
}

Galaxy "NGC 521:UGC 962:MCG 0-4-118:ZWG 385.106"
{
        Type  "SBc"
        RA            1.4092
        Dec           1.7314
        Distance   2.145e+08  # method: V
        Radius     8.422e+04
        AbsMag        -21.59
        Axis    [  0.5760   0.8050   0.1419]
        Angle    150.4493
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 521"
}

Galaxy "NGC 522:UGC 970:MCG 2-4-38:ZWG 436.43"
{
        Type  "Sc"
        RA            1.4125
        Dec           9.9950
        Distance   1.133e+08  # method: V
        Radius     4.612e+04
        AbsMag         -18.7
        Axis    [  0.0539   0.9512   0.3039]
        Angle    157.4946
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 522"
}

Galaxy "NGC 524:UGC 968:MCG 1-4-53:ZWG 411.51"
{
        Type  "Sa"
        RA            1.4131
        Dec           9.5386
        Distance   7.824e+07  # method: S
        Radius     3.186e+04
        AbsMag         -20.6
        Axis    [  0.7356   0.5932   0.3270]
        Angle    119.8269
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 524"
}

Galaxy "NGC 525:UGC 972:MCG 1-4-54:ZWG 411.53"
{
        Type  "S0"
        RA            1.4144
        Dec           9.7039
        Distance   8.335e+07  # method: V
        Radius     1.818e+04
        AbsMag        -17.74
        Axis    [  0.2688   0.8430   0.4659]
        Angle    148.6826
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 525"
}

Galaxy "NGC 526A:ESO 352-66:MCG 6-4-19:AM 0121-351"
{
        Type  "S0"
        RA            1.3983
        Dec         -35.0656
        Distance   2.507e+08  # method: V
        Radius     4.375e+04
        AbsMag        -20.03
        Axis    [  0.5321   0.8396  -0.1094]
        Angle    176.0114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 526A"
}

Galaxy "NGC 526B:ESO 352-66:MCG 6-4-20:AM 0121-351"
{
        Type  "S0"
        RA            1.3989
        Dec         -35.0692
        Distance   1.341e+08  # distance uncertain!
        Radius      1.56e+04
        AbsMag        -19.07
        Axis    [  0.3233   0.5372  -0.7791]
        Angle    166.6667
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 526B"
}

Galaxy "NGC 527-1:ESO 352-68:MCG 6-4-21:PGC 5141"
{
        Type  "SBa"
        RA            1.3994
        Dec         -35.1153
        Distance   2.506e+08  # method: V
        Radius     5.831e+04
        AbsMag        -20.33
        Axis    [  0.3264   0.8706   0.3682]
        Angle    193.0918
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 527-1"
}

Galaxy "NGC 527-2:MCG 6-4-22"
{
        Type  "S0"
        RA            1.3997
        Dec         -35.1281
        Distance   2.226e+08  # distance uncertain!
        Radius     1.942e+04
        AbsMag        -19.07
        Axis    [  0.3431   0.9314   0.1214]
        Angle    182.6623
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 527-2"
}

Galaxy "NGC 528:UGC 988:MCG 5-4-57:ZWG 502.83"
{
        Type  "S0"
        RA            1.4258
        Dec          33.6706
        Distance   2.047e+08  # method: V
        Radius     3.573e+04
        AbsMag        -20.39
        Axis    [  0.1541   0.9869   0.0486]
        Angle    141.9528
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 528"
}

Galaxy "NGC 529:UGC 995:MCG 6-4-19:ZWG 521.23"
{
        Type  "S0"
        RA            1.4278
        Dec          34.7131
        Distance   2.052e+08  # method: V
        Radius     7.162e+04
        AbsMag        -20.79
        Axis    [  0.0316   0.7913  -0.6106]
        Angle    211.1256
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 529"
}

Galaxy "NGC 530:IC 106:UGC 965:MCG 0-4-119"
{
        Type  "Sa"
        RA            1.4114
        Dec          -1.5869
        Distance   2.131e+08  # method: V
        Radius      4.65e+04
        AbsMag        -20.08
        Axis    [  0.0335   0.8247  -0.5646]
        Angle    163.0270
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 530"
}

Galaxy "NGC 531:UGC 1012:MCG 6-4-20:ZWG 521.24"
{
        Type  "SBa"
        RA            1.4383
        Dec          34.7542
        Distance   2.227e+08  # method: V
        Radius     5.829e+04
        AbsMag        -19.27
        Axis    [ -0.0500   0.9490   0.3113]
        Angle    139.3867
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 531"
}

Galaxy "NGC 532:UGC 982:MCG 1-4-56:ZWG 411.55"
{
        Type  "Sb"
        RA            1.4214
        Dec           9.2642
        Distance   9.368e+07  # method: V
        Radius     4.224e+04
        AbsMag        -18.39
        Axis    [  0.1665   0.9312   0.3242]
        Angle    154.1745
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 532"
}

Galaxy "NGC 533:UGC 992:MCG 0-4-131:ZWG 385.121"
{
        Type  "E3"
        RA            1.4253
        Dec           1.7592
        Distance   2.113e+08  # method: T-F
        Radius     1.168e+05
        AbsMag        -21.66
        Axis    [  0.7657   0.6430  -0.0155]
        Angle    154.6745
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 533"
}

Galaxy "NGC 534:ESO 296-21:MCG 6-4-26"
{
        Type  "S0"
        RA            1.4122
        Dec         -38.1289
        Distance   2.541e+08  # method: V
        Radius     3.696e+04
        AbsMag        -20.06
        Axis    [  0.5866   0.4697  -0.6598]
        Angle    191.1216
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 534"
}

Galaxy "NGC 535:UGC 997:MCG 0-4-133:ZWG 385.124"
{
        Type  "Sa"
        RA            1.4253
        Dec          -1.4089
        Distance     2.1e+08  # method: V
        Radius     3.055e+04
        AbsMag        -19.14
        Axis    [  0.1862   0.9808   0.0575]
        Angle    161.0922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 535"
}

Galaxy "NGC 536:UGC 1013:MCG 6-4-21:ZWG 521.25"
{
        Type  "SBb"
        RA            1.4392
        Dec          34.7033
        Distance   2.071e+08  # method: T-F
        Radius     9.939e+04
        AbsMag        -20.81
        Axis    [ -0.0798   0.9968   0.0076]
        Angle    147.3117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 536"
}

Galaxy "NGC 537:NGC 523:UGC 979:MCG 6-4-18"
{
        Type  "Sc"
        RA            1.4222
        Dec          34.0253
        Distance   2.035e+08  # method: V
        Radius     7.401e+04
        AbsMag        -20.48
        Axis    [ -0.2143   0.9297  -0.2995]
        Angle    160.5482
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 537"
}

Galaxy "NGC 538:UGC 991:MCG 0-4-130:ZWG 385.120"
{
        Type  "Sb"
        RA            1.4239
        Dec          -1.5508
        Distance   2.113e+08  # method: T-F
        Radius     3.995e+04
        AbsMag        -19.46
        Axis    [  0.3078   0.9312   0.1954]
        Angle    159.1676
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 538"
}

Galaxy "NGC 539:NGC 563:ESO 542-10:MCG 3-4-63"
{
        Type  "SBc"
        RA            1.4225
        Dec         -18.1644
        Distance   4.249e+08  # method: V
        Radius     9.888e+04
        AbsMag        -21.37
        Axis    [  0.4039   0.6225  -0.6703]
        Angle    188.4940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 539"
}

Galaxy "NGC 540:ESO 542-12:NPM 1"
{
        Type  "S0"
        RA            1.4522
        Dec         -20.0367
        Distance   3.072e+08  # distance uncertain!
        Radius     4.021e+04
        AbsMag        -19.07
        Axis    [  0.1388   0.5031  -0.8530]
        Angle    168.9632
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 540"
}

Galaxy "NGC 541:UGC 1004:MCG 0-4-137:ZWG 385.128"
{
        Type  "S0"
        RA            1.4289
        Dec          -1.3794
        Distance   2.113e+08  # method: T-F
        Radius     5.531e+04
        AbsMag        -20.86
        Axis    [  0.6386   0.7695   0.0012]
        Angle    158.3435
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 541"
}

Galaxy "NGC 542:MCG 6-4-22:ZWG 521.26:HCG 10"
{
        Type  "Sb"
        RA            1.4417
        Dec          34.6761
        Distance   1.989e+08  # method: V
        Radius     2.892e+04
        AbsMag        -18.33
        Axis    [ -0.3325   0.7600  -0.5584]
        Angle    169.6922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 542"
}

Galaxy "NGC 543:MCG 0-4-138:ZWG 385.130:DRCG 7-53"
{
        Type  "S0"
        RA            1.4306
        Dec          -1.2925
        Distance   2.236e+08  # method: V
        Radius     1.951e+04
        AbsMag        -19.88
        Axis    [  0.2570   0.9367  -0.2378]
        Angle    164.7887
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 543"
}

Galaxy "NGC 544:ESO 296-24:MCG 6-4-28:AM 0122-381"
{
        Type  "S0"
        RA            1.4197
        Dec         -38.0944
        Distance   2.616e+08  # method: V
        Radius     5.708e+04
        AbsMag        -20.12
        Axis    [  0.6024   0.6413   0.4753]
        Angle    179.0424
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 544"
}

Galaxy "NGC 545:UGC 1007:MCG 0-4-142:ZWG 385.132"
{
        Type  "S0"
        RA            1.4331
        Dec          -1.3406
        Distance   2.113e+08  # method: T-F
        Radius      7.99e+04
        AbsMag        -20.76
        Axis    [  0.3842   0.9220   0.0482]
        Angle    159.4545
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 545"
}

Galaxy "NGC 546:ESO 296-25:MCG 6-4-29:AM 0122-381"
{
        Type  "SBb"
        RA            1.4200
        Dec         -38.0692
        Distance   3.016e+08  # method: T-F
        Radius     6.141e+04
        AbsMag        -20.33
        Axis    [  0.4718   0.8583   0.2018]
        Angle    184.8231
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 546"
}

Galaxy "NGC 547:UGC 1009:MCG 0-4-143:ZWG 385.133"
{
        Type  "E1"
        RA            1.4333
        Dec          -1.3450
        Distance   2.113e+08  # method: T-F
        Radius     5.839e+04
        AbsMag        -20.76
        Axis    [  0.7258   0.6452  -0.2387]
        Angle    178.5085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 547"
}

Galaxy "NGC 548:UGC 1010:MCG 0-4-141:ZWG 385.134"
{
        Type  "E0"
        RA            1.4339
        Dec          -1.2253
        Distance   2.113e+08  # method: T-F
        Radius     2.458e+04
        AbsMag        -19.36
        Axis    [  0.5762   0.6122  -0.5416]
        Angle    210.2371
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 548"
}

Galaxy "NGC 549:ESO 296-22"
{
        Type  "Sa"
        RA            1.4186
        Dec         -38.0072
        Distance   2.676e+08  # distance uncertain!
        Radius     1.946e+04
        AbsMag        -19.07
        Axis    [  0.6301   0.6026   0.4897]
        Angle    175.9489
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 549"
}

Galaxy "NGC 550:UGC 1021:MCG 0-4-146:ZWG 385.139"
{
        Type  "Sa"
        RA            1.4450
        Dec           2.0222
        Distance   2.522e+08  # method: V
        Radius     5.136e+04
        AbsMag        -20.84
        Axis    [  0.1238   0.8756  -0.4669]
        Angle    167.5219
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 550"
}

Galaxy "NGC 551:UGC 1034:MCG 6-4-27:ZWG 521.30"
{
        Type  "SBc"
        RA            1.4611
        Dec          37.1831
        Distance   2.121e+08  # method: T-F
        Radius     5.554e+04
        AbsMag        -20.57
        Axis    [ -0.1985   0.8319  -0.5182]
        Angle    178.8938
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 551"
}

Galaxy "NGC 553:ZWG 502.84:MK 1155"
{
        Type  "S0"
        RA            1.4367
        Dec          33.4047
        Distance   2.128e+08  # method: V
        Radius     1.857e+04
        AbsMag        -18.97
        Axis    [  0.1432   0.8988   0.4142]
        Angle    130.1317
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 553"
}

Galaxy "NGC 554A:ESO 476-11:MCG 4-4-13:AM 0124-225"
{
        Type  "S0"
        RA            1.4525
        Dec         -22.7256
        Distance   1.938e+08  # distance uncertain!
        Radius     2.537e+04
        AbsMag        -19.07
        Axis    [  0.1946   0.4860  -0.8520]
        Angle    174.4633
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 554A"
}

Galaxy "NGC 554B:ESO 476-11A"
{
        Type  "S0"
        RA            1.4525
        Dec         -22.7236
        Distance   1.938e+08  # distance uncertain!
        Radius          8458
        AbsMag        -19.07
        Axis    [  0.7937   0.4390   0.4212]
        Angle    145.2454
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 554B"
}

Galaxy "NGC 555:ESO 476-12:MCG 4-4-14:NPM 1"
{
        Type  "SBa"
        RA            1.4531
        Dec         -22.7617
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.6508   0.6610   0.3736]
        Angle    161.7113
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 555"
}

Galaxy "NGC 556:ESO 476-13:NPM 1"
{
        Type  "S0"
        RA            1.4533
        Dec         -22.6972
        Distance   3.217e+08  # distance uncertain!
        Radius     1.872e+04
        AbsMag        -19.07
        Axis    [  0.4337   0.6547  -0.6191]
        Angle    181.8526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 556"
}

Galaxy "NGC 557:IC 1703:UGC 1016:MCG 0-4-144"
{
        Type  "SBa"
        RA            1.4403
        Dec          -1.6383
        Distance    2.44e+08  # method: V
        Radius     6.388e+04
        AbsMag        -19.77
        Axis    [  0.0955   0.8669  -0.4893]
        Angle    164.5126
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 557"
}

Galaxy "NGC 558:ZWG 385.143:NPM 1:DRCG 7-5"
{
        Type  "E0"
        RA            1.4544
        Dec          -1.9706
        Distance   2.137e+08  # method: V
        Radius     1.243e+04
        AbsMag        -19.08
        Axis    [  0.6653   0.6332  -0.3956]
        Angle    194.4393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 558"
}

Galaxy "NGC 560:UGC 1036:MCG 0-4-151:ZWG 385.145"
{
        Type  "S0"
        RA            1.4569
        Dec          -1.9125
        Distance   2.347e+08  # method: V
        Radius     6.487e+04
        AbsMag        -20.39
        Axis    [ -0.0322   0.5584  -0.8289]
        Angle    170.0066
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 560"
}

Galaxy "NGC 561:UGC 1048:MCG 6-4-29:ZWG 521.32"
{
        Type  "SBa"
        RA            1.4717
        Dec          34.3083
        Distance   1.993e+08  # method: V
        Radius     4.638e+04
        AbsMag        -20.03
        Axis    [  0.4158   0.9092   0.0238]
        Angle    134.1923
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 561"
}

Galaxy "NGC 562:UGC 1049:MCG 8-3-25:ZWG 551.20"
{
        Type  "Sc"
        RA            1.4747
        Dec          48.3869
        Distance   4.542e+08  # method: V
        Radius     8.589e+04
        AbsMag        -21.42
        Axis    [  0.2747   0.9331   0.2320]
        Angle    111.7100
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 562"
}

Galaxy "NGC 564:UGC 1044:MCG 0-4-154:ZWG 385.148"
{
        Type  "E0"
        RA            1.4633
        Dec          -1.8786
        Distance   2.113e+08  # method: T-F
        Radius     3.995e+04
        AbsMag        -20.56
        Axis    [  0.5368   0.5907  -0.6025]
        Angle    215.8715
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 564"
}

Galaxy "NGC 565:UGC 1052:MCG 0-4-158:ZWG 385.153"
{
        Type  "Sa"
        RA            1.4694
        Dec          -1.3058
        Distance   1.901e+08  # method: V
        Radius     3.595e+04
        AbsMag        -19.33
        Axis    [  0.2200   0.9441   0.2454]
        Angle    160.9274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 565"
}

Galaxy "NGC 566:UGC 1058:MCG 5-4-62:ZWG 502.92"
{
        Type  "S0"
        RA            1.4839
        Dec          32.3322
        Distance   1.688e+08  # distance uncertain!
        Radius     3.929e+04
        AbsMag        -19.07
        Axis    [ -0.3005   0.5914  -0.7483]
        Angle    183.1038
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 566"
}

Galaxy "NGC 567:MCG 2-4-53:NPM 1"
{
        Type  "S0"
        RA            1.4506
        Dec         -10.2647
        Distance    2.33e+08  # distance uncertain!
        Radius      3.39e+04
        AbsMag        -19.07
        Axis    [  0.2744   0.7584  -0.5913]
        Angle    175.6475
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 567"
}

Galaxy "NGC 568:IC 1709:ESO 353-3:MCG 6-4-37"
{
        Type  "S0"
        RA            1.4656
        Dec         -35.7175
        Distance   2.446e+08  # method: V
        Radius     7.827e+04
        AbsMag        -20.77
        Axis    [  0.4372   0.6203  -0.6512]
        Angle    171.7699
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 568"
}

Galaxy "NGC 569:UGC 1063:MCG 2-4-53:MK 997"
{
        Type  "Sc"
        RA            1.4853
        Dec          11.1317
        Distance   2.478e+08  # method: V
        Radius     3.604e+04
        AbsMag         -19.7
        Axis    [ -0.0199   0.6852  -0.7281]
        Angle    182.5991
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 569"
}

Galaxy "NGC 570:UGC 1061:MCG 0-4-162:ZWG 385.159"
{
        Type  "SBa"
        RA            1.4828
        Dec          -0.9486
        Distance   2.352e+08  # method: V
        Radius     5.474e+04
        AbsMag        -20.59
        Axis    [  0.1640   0.5668  -0.8074]
        Angle    201.4668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 570"
}

Galaxy "NGC 571:UGC 1069:MCG 5-4-63:ZWG 502.98"
{
        Type  "S0"
        RA            1.4989
        Dec          32.5008
        Distance   1.986e+08  # method: V
        Radius     3.756e+04
        AbsMag        -19.22
        Axis    [  0.6753   0.7007   0.2303]
        Angle    102.1937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 571"
}

Galaxy "NGC 572:ESO 296-31:MCG 7-4-9"
{
        Type  "S0"
        RA            1.4767
        Dec         -39.3072
        Distance    2.33e+08  # distance uncertain!
        Radius     2.712e+04
        AbsMag        -19.07
        Axis    [  0.6490   0.5348  -0.5412]
        Angle    186.3950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 572"
}

Galaxy "NGC 573:UGC 1078:ZWG 537.10:IRAS 01278+4100"
{
        Type  "S0"
        RA            1.5136
        Dec          41.2572
        Distance   1.168e+08  # distance uncertain!
        Radius          6795
        AbsMag        -19.07
        Axis    [  0.6407   0.7447   0.1870]
        Angle     95.9759
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 573"
}

Galaxy "NGC 574:ESO 353-6:MCG 6-4-39:IRAS 01268-3551"
{
        Type  "SBb"
        RA            1.4842
        Dec         -35.5986
        Distance   2.485e+08  # method: V
        Radius     3.976e+04
        AbsMag        -20.21
        Axis    [  0.5534   0.6865   0.4717]
        Angle    180.2656
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 574"
}

Galaxy "NGC 575:IC 1710:UGC 1081:MCG 3-4-51"
{
        Type  "SBc"
        RA            1.5128
        Dec          21.4403
        Distance   1.294e+08  # method: V
        Radius       3.2e+04
        AbsMag        -19.39
        Axis    [  0.4687   0.8770  -0.1063]
        Angle    153.2051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 575"
}

Galaxy "NGC 576:ESO 196-7:FAIR 295:AM 0126-515"
{
        Type  "SBa"
        RA            1.4825
        Dec         -51.5981
        Distance   1.355e+08  # method: V
        Radius     1.971e+04
        AbsMag        -18.69
        Axis    [  0.7292   0.5914   0.3443]
        Angle    187.0615
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 576"
}

Galaxy "NGC 577:NGC 580:UGC 1080:MCG 0-4-165"
{
        Type  "SBa"
        RA            1.5111
        Dec          -1.9942
        Distance   2.561e+08  # method: V
        Radius     7.078e+04
        AbsMag        -20.57
        Axis    [  0.2946   0.7285  -0.6184]
        Angle    187.1536
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 577"
}

Galaxy "NGC 578:ESO 476-15:MCG 4-4-20:UGCA 18"
{
        Type  "SBc"
        RA            1.5078
        Dec         -22.6667
        Distance   9.223e+07  # method: T-F
        Radius     6.439e+04
        AbsMag        -20.76
        Axis    [  0.4488   0.7834  -0.4299]
        Angle    172.7672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 578"
}

Galaxy "NGC 579:UGC 1089:MCG 5-4-64:ZWG 502.103"
{
        Type  "Sc"
        RA            1.5294
        Dec          33.6144
        Distance    2.14e+08  # method: V
        Radius      4.67e+04
        AbsMag        -20.18
        Axis    [  0.0603   0.8218  -0.5666]
        Angle    202.3410
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 579"
}

Galaxy "NGC 582:UGC 1094:MCG 5-4-65:ZWG 502.105"
{
        Type  "SBb"
        RA            1.5328
        Dec          33.4756
        Distance     2.3e+08  # method: T-F
        Radius     7.359e+04
        AbsMag        -20.14
        Axis    [ -0.1014   0.9886   0.1117]
        Angle    144.0884
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 582"
}

Galaxy "NGC 583:ESO 542-20:MCG 3-4-77:NPM 1"
{
        Type  "S0"
        RA            1.4956
        Dec         -18.3394
        Distance    2.33e+08  # distance uncertain!
        Radius     2.373e+04
        AbsMag        -19.07
        Axis    [  0.6600   0.7374   0.1438]
        Angle    163.5832
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 583"
}

Galaxy "NGC 584:IC 1712:MCG 1-4-60"
{
        Type  "E4"
        RA            1.5222
        Dec          -6.8672
        Distance   6.568e+07  # method: S
        Radius     3.917e+04
        AbsMag        -20.02
        Axis    [  0.7811   0.6041  -0.1576]
        Angle    171.4217
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 584"
}

Galaxy "NGC 585:UGC 1092:MCG 0-5-1:ZWG 386.1"
{
        Type  "Sa"
        RA            1.5283
        Dec          -0.9328
        Distance   2.294e+08  # method: V
        Radius     7.339e+04
        AbsMag        -20.13
        Axis    [  0.0844   0.9808  -0.1756]
        Angle    158.5342
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 585"
}

Galaxy "NGC 586:MCG 1-5-1"
{
        Type  "Sa"
        RA            1.5267
        Dec          -6.8931
        Distance   7.692e+07  # method: V
        Radius     1.902e+04
        AbsMag        -17.76
        Axis    [  0.3916   0.7680   0.5068]
        Angle    159.1544
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 586"
}

Galaxy "NGC 587:UGC 1100:MCG 6-4-37:ZWG 521.45"
{
        Type  "SBb"
        RA            1.5425
        Dec          35.3583
        Distance   2.132e+08  # method: T-F
        Radius     6.821e+04
        AbsMag        -20.48
        Axis    [ -0.0776   0.9968   0.0193]
        Angle    145.3394
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 587"
}

Galaxy "NGC 589:MCG 2-5-4:MK 999:NPM 1"
{
        Type  "Sa"
        RA            1.5442
        Dec         -12.0422
        Distance   2.217e+08  # method: V
        Radius     3.547e+04
        AbsMag        -19.16
        Axis    [  0.5378   0.7976  -0.2730]
        Angle    172.7333
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 589"
}

Galaxy "NGC 590:UGC 1109:MCG 7-4-3:ZWG 537.13"
{
        Type  "SBa"
        RA            1.5611
        Dec          44.9292
        Distance   2.184e+08  # method: V
        Radius      8.26e+04
        AbsMag        -20.23
        Axis    [ -0.2481   0.8005  -0.5455]
        Angle    186.6502
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 590"
}

Galaxy "NGC 591:UGC 1111:MCG 6-4-38:MK 1157"
{
        Type  "SBa"
        RA            1.5586
        Dec          35.6683
        Distance   1.943e+08  # method: V
        Radius     3.673e+04
        AbsMag        -19.97
        Axis    [  0.3376   0.8464   0.4118]
        Angle    115.1900
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 591"
}

Galaxy "NGC 593:MCG 2-5-3"
{
        Type  "S0"
        RA            1.5389
        Dec         -12.3544
        Distance   2.802e+08  # distance uncertain!
        Radius      4.89e+04
        AbsMag        -19.07
        Axis    [  0.2209   0.8765   0.4278]
        Angle    174.9184
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 593"
}

Galaxy "NGC 594:MCG 3-5-5:IRAS 01305-1647"
{
        Type  "Sc"
        RA            1.5492
        Dec         -16.5353
        Distance   2.331e+08  # method: V
        Radius     4.746e+04
        AbsMag        -19.97
        Axis    [  0.3956   0.8844   0.2476]
        Angle    168.1816
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 594"
}

Galaxy "NGC 596:MCG 1-5-5"
{
        Type  "E0"
        RA            1.5478
        Dec          -7.0319
        Distance   7.103e+07  # method: S
        Radius     3.306e+04
        AbsMag        -19.79
        Axis    [  0.8175   0.5725   0.0637]
        Angle    152.3735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 596"
}

Galaxy "NGC 597:ESO 353-11:MCG 6-4-44:IRAS 01299-3345"
{
        Type  "SBc"
        RA            1.5372
        Dec         -33.4969
        Distance   2.194e+08  # method: V
        Radius     4.468e+04
        AbsMag        -20.14
        Axis    [  0.7647   0.5778   0.2855]
        Angle    168.2519
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 597"
}

Galaxy "M 33:NGC 598:UGC 1117:MCG 5-4-69"
{
        Type  "Sc"
        RA            1.5642
        Dec          30.6581
        Distance   3.262e+06  # method: T-F
        Radius     3.259e+04
        AbsMag        -18.78
        Axis    [  0.2202   0.9202   0.3237]
        Angle    130.1439
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 33"
}

Galaxy "NGC 599:MCG 2-5-5:MK 1000"
{
        Type  "S0"
        RA            1.5481
        Dec         -12.1908
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.4829   0.6401  -0.5976]
        Angle    193.8126
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 599"
}

Galaxy "NGC 600:MCG 1-5-7:IRAS 01305-0733"
{
        Type  "SBc"
        RA            1.5514
        Dec          -7.3122
        Distance   7.031e+07  # method: V
        Radius     2.863e+04
        AbsMag        -18.57
        Axis    [  0.5306   0.7780   0.3364]
        Angle    153.3561
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 600"
}

Galaxy "NGC 601:MK 1000:NPM 1"
{
        Type  "E0"
        RA            1.5517
        Dec         -12.2083
        Distance   5.755e+08  # distance uncertain!
        Radius     3.348e+04
        AbsMag        -20.13
        Axis    [  0.8038   0.4598   0.3775]
        Angle    135.1513
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 601"
}

Galaxy "NGC 605:UGC 1128:MCG 7-4-4:ZWG 537.14"
{
        Type  "S0"
        RA            1.5839
        Dec          41.2478
        Distance   1.341e+08  # distance uncertain!
        Radius     4.291e+04
        AbsMag        -19.07
        Axis    [ -0.2124   0.8206  -0.5305]
        Angle    182.6551
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 605"
}

Galaxy "NGC 606:UGC 1126:MCG 3-5-10:ZWG 460.11"
{
        Type  "SBc"
        RA            1.5806
        Dec          21.4181
        Distance   4.386e+08  # method: V
        Radius     8.931e+04
        AbsMag        -21.44
        Axis    [  0.2536   0.8784  -0.4050]
        Angle    178.3085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 606"
}

Galaxy "NGC 608:NGC 618:UGC 1135:MCG 5-4-73"
{
        Type  "Sb"
        RA            1.5911
        Dec          33.6564
        Distance   2.191e+08  # method: V
        Radius     6.054e+04
        AbsMag        -19.94
        Axis    [  0.3121   0.9311   0.1889]
        Angle    127.4667
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 608"
}

Galaxy "NGC 612:ESO 353-15:MCG 6-4-46:AM 0131-364"
{
        Type  "Sa"
        RA            1.5658
        Dec         -36.4931
        Distance   3.945e+08  # method: V
        Radius     8.607e+04
        AbsMag        -21.51
        Axis    [  0.3097   0.4461  -0.8397]
        Angle    169.7081
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 612"
}

Galaxy "NGC 613:ESO 413-11:MCG 5-4-44:VV 824"
{
        Type  "SBc"
        RA            1.5717
        Dec         -29.4186
        Distance   1.079e+08  # method: T-F
        Radius     8.628e+04
        AbsMag         -21.9
        Axis    [  0.5381   0.6656  -0.5172]
        Angle    178.7136
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 613"
}

Galaxy "NGC 614:NGC 627:UGC 1140:MCG 5-4-75"
{
        Type  "S0"
        RA            1.5978
        Dec          33.6819
        Distance   2.217e+08  # method: V
        Radius     4.515e+04
        AbsMag        -20.46
        Axis    [  0.6811   0.6976   0.2224]
        Angle    100.5326
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 614"
}

Galaxy "NGC 615:MCG 1-5-8:IRAS 01325-0735"
{
        Type  "Sb"
        RA            1.5847
        Dec          -7.3403
        Distance   1.012e+08  # method: T-F
        Radius     3.976e+04
        AbsMag        -19.96
        Axis    [  0.0633   0.6944  -0.7168]
        Angle    164.3530
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 615"
}

Galaxy "NGC 617:MCG 2-5-7:NPM 1"
{
        Type  "Sb"
        RA            1.5672
        Dec          -9.7736
        Distance    2.44e+08  # distance uncertain!
        Radius     1.775e+04
        AbsMag        -19.07
        Axis    [  0.7860   0.4886   0.3789]
        Angle    134.2540
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 617"
}

Galaxy "NGC 619:ESO 353-21:MCG 6-4-51:AM 0132-364"
{
        Type  "SBb"
        RA            1.5808
        Dec         -36.4894
        Distance   3.758e+08  # method: V
        Radius     8.199e+04
        AbsMag        -21.01
        Axis    [  0.5043   0.6291  -0.5915]
        Angle    174.2556
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 619"
}

Galaxy "NGC 620:UGC 1150:MCG 7-4-6:ZWG 537.16"
{
        Type  "E0"
        RA            1.6164
        Dec          42.3228
        Distance   2.089e+08  # distance uncertain!
        Radius     3.039e+04
        AbsMag        -20.13
        Axis    [  0.6610   0.7380   0.1361]
        Angle     96.0046
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 620"
}

Galaxy "NGC 621:UGC 1147:MCG 6-4-45:ZWG 521.55"
{
        Type  "S0"
        RA            1.6133
        Dec          35.5125
        Distance   1.379e+08  # method: V
        Radius     2.407e+04
        AbsMag        -19.33
        Axis    [  0.3566   0.9055   0.2300]
        Angle    121.1216
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 621"
}

Galaxy "NGC 622:UGC 1143:MCG 0-5-14:MK 571"
{
        Type  "SBc"
        RA            1.6000
        Dec           0.6636
        Distance   2.202e+08  # method: V
        Radius     5.124e+04
        AbsMag        -20.35
        Axis    [  0.3995   0.9078   0.1277]
        Angle    154.4074
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 622"
}

Galaxy "NGC 623:ESO 353-23:MCG 6-4-52"
{
        Type  "E0"
        RA            1.5850
        Dec         -36.4900
        Distance   3.959e+08  # method: V
        Radius     1.152e+05
        AbsMag        -21.82
        Axis    [  0.8689   0.3927  -0.3015]
        Angle    191.5226
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 623"
}

Galaxy "NGC 624:MCG 2-5-10:IRAS 01333-1015"
{
        Type  "Sb"
        RA            1.5975
        Dec         -10.0031
        Distance   2.531e+08  # method: V
        Radius     5.521e+04
        AbsMag        -20.35
        Axis    [  0.4028   0.8473  -0.3461]
        Angle    169.7385
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 624"
}

Galaxy "NGC 625:ESO 297-5:MCG 7-4-17:AM 0132-414"
{
        Type  "Irr"
        RA            1.5844
        Dec         -41.4375
        Distance   8.562e+06  # method: V
        Radius          7223
        AbsMag        -15.39
        Axis    [  0.4703   0.8350  -0.2857]
        Angle    169.1216
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 625"
}

Galaxy "NGC 626:ESO 297-6:MCG 7-4-18"
{
        Type  "SBc"
        RA            1.5864
        Dec         -39.1461
        Distance   2.454e+08  # method: V
        Radius     7.852e+04
        AbsMag        -20.98
        Axis    [  0.6457   0.6191   0.4470]
        Angle    177.3232
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 626"
}

Galaxy "M 74:NGC 628:UGC 1149:MCG 3-5-11"
{
        Type  "Sc"
        RA            1.6114
        Dec          15.7833
        Distance   1.644e+07  # method: V
        Radius     2.511e+04
        AbsMag        -18.71
        Axis    [  0.5423   0.8127   0.2130]
        Angle    133.1949
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 74"
}

Galaxy "NGC 630:ESO 297-9:MCG 7-4-20:AM 0133-393"
{
        Type  "S0"
        RA            1.5933
        Dec         -39.3578
        Distance   2.591e+08  # method: V
        Radius      6.03e+04
        AbsMag         -21.6
        Axis    [  0.7786   0.6269  -0.0273]
        Angle    178.3146
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 630"
}

Galaxy "NGC 631:UGC 1153:MCG 1-5-7:ZWG 412.6"
{
        Type  "E0"
        RA            1.6131
        Dec           5.8358
        Distance   2.418e+08  # method: V
        Radius     3.517e+04
        AbsMag        -19.35
        Axis    [  0.5735   0.6698  -0.4717]
        Angle    200.1926
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 631"
}

Galaxy "NGC 632:UGC 1157:MCG 1-5-10:MK 1002"
{
        Type  "S0"
        RA            1.6214
        Dec           5.8772
        Distance   1.301e+08  # method: V
        Radius     1.892e+04
        AbsMag         -19.6
        Axis    [  0.1266   0.6265  -0.7691]
        Angle    199.5334
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 632"
}

Galaxy "NGC 633:ESO 297-11:MCG 6-4-56:AM 0134-373"
{
        Type  "SBb"
        RA            1.6064
        Dec         -37.3208
        Distance   2.241e+08  # method: V
        Radius     4.564e+04
        AbsMag        -20.69
        Axis    [  0.5190   0.4728  -0.7121]
        Angle    186.2255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 633"
}

Galaxy "NGC 634:UGC 1164:MCG 6-4-48:ZWG 521.60"
{
        Type  "Sa"
        RA            1.6383
        Dec          35.3647
        Distance   2.548e+08  # method: T-F
        Radius     7.782e+04
        AbsMag        -20.56
        Axis    [ -0.3045   0.6714  -0.6757]
        Angle    180.6710
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 634"
}

Galaxy "NGC 635:MCG 4-5-2:IRAS 01359-2310"
{
        Type  "Sb"
        RA            1.6381
        Dec         -22.9289
        Distance    2.44e+08  # distance uncertain!
        Radius     1.775e+04
        AbsMag        -19.07
        Axis    [  0.8087   0.4241   0.4076]
        Angle    144.7712
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 635"
}

Galaxy "NGC 636:MCG 1-5-13"
{
        Type  "E3"
        RA            1.6517
        Dec          -7.5122
        Distance   9.715e+07  # method: S
        Radius     3.956e+04
        AbsMag        -19.87
        Axis    [  0.8245   0.5631   0.0560]
        Angle    151.8824
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 636"
}

Galaxy "NGC 638:UGC 1170:MCG 1-5-14:MK 1003"
{
        Type  "Sb"
        RA            1.6603
        Dec           7.2372
        Distance   1.508e+08  # method: V
        Radius     1.754e+04
        AbsMag        -18.82
        Axis    [  0.3889   0.8565   0.3393]
        Angle    144.9923
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 638"
}

Galaxy "NGC 639:ESO 413-13:MCG 5-5-2:IRAS 01367-3010"
{
        Type  "Sa"
        RA            1.6497
        Dec         -29.9250
        Distance   2.533e+08  # method: V
        Radius     3.684e+04
        AbsMag        -19.75
        Axis    [  0.3261   0.9155   0.2355]
        Angle    181.1998
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 639"
}

Galaxy "NGC 640:MCG 2-5-31"
{
        Type  "Sa"
        RA            1.6567
        Dec          -9.4011
        Distance   3.217e+08  # distance uncertain!
        Radius     3.275e+04
        AbsMag        -19.07
        Axis    [  0.2802   0.6883  -0.6691]
        Angle    181.0378
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 640"
}

Galaxy "NGC 641:ESO 244-42:MCG 7-4-26:AM 0136-424"
{
        Type  "S0"
        RA            1.6442
        Dec         -42.5275
        Distance   2.309e+08  # method: T-F
        Radius     4.702e+04
        AbsMag        -21.15
        Axis    [  0.7500   0.4958   0.4377]
        Angle    171.9198
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 641"
}

Galaxy "NGC 642:ESO 413-14:MCG 5-5-3:VV 419"
{
        Type  "SBc"
        RA            1.6517
        Dec         -29.9153
        Distance   2.838e+08  # method: T-F
        Radius     8.256e+04
        AbsMag         -21.7
        Axis    [  0.5423   0.8078   0.2310]
        Angle    174.4862
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 642"
}

Galaxy "NGC 643B:ESO 29-53:IRAS 01384-7515"
{
        Type  "S0"
        RA            1.6536
        Dec         -75.0114
        Distance   1.779e+08  # method: V
        Radius      3.88e+04
        AbsMag        -19.18
        Axis    [  0.6039   0.6700  -0.4318]
        Angle    160.6458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 643B"
}

Galaxy "NGC 643C:ESO 30-1:FGCE 186"
{
        Type  "Sc"
        RA            1.6967
        Dec         -75.2675
        Distance   2.934e+08  # distance uncertain!
        Radius     5.547e+04
        AbsMag        -19.07
        Axis    [  0.5459   0.5205  -0.6566]
        Angle    138.7242
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 643C"
}

Galaxy "NGC 644:ESO 244-43:MCG 7-4-27:FAIR 706"
{
        Type  "SBc"
        RA            1.6478
        Dec         -42.5856
        Distance   2.527e+08  # method: T-F
        Radius     4.779e+04
        AbsMag        -19.65
        Axis    [  0.3765   0.5452  -0.7490]
        Angle    159.9553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 644"
}

Galaxy "NGC 645:UGC 1177:MCG 1-5-16:ZWG 412.13"
{
        Type  "SBb"
        RA            1.6689
        Dec           5.7261
        Distance   1.366e+08  # method: V
        Radius     5.165e+04
        AbsMag        -19.61
        Axis    [  0.0959   0.8597  -0.5017]
        Angle    166.5581
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 645"
}

Galaxy "NGC 646-1:ESO 80-2:VV 443:AM 0135-650"
{
        Type  "SBc"
        RA            1.6225
        Dec         -64.8953
        Distance   3.687e+08  # method: V
        Radius     1.073e+05
        AbsMag        -21.07
        Axis    [  0.8209   0.5404  -0.1843]
        Angle    187.4215
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 646-1"
}

Galaxy "NGC 646-2:ESO 80-2:VV 443:AM 0135-650"
{
        Type  "S0"
        RA            1.6250
        Dec         -64.8958
        Distance   3.369e+08  # distance uncertain!
        Radius      1.96e+04
        AbsMag        -19.07
        Axis    [  0.8342   0.2447   0.4941]
        Angle    180.0831
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 646-2"
}

Galaxy "NGC 647:MCG 2-5-33:NPM 1"
{
        Type  "S0"
        RA            1.6656
        Dec          -9.2419
        Distance   1.688e+08  # distance uncertain!
        Radius     3.683e+04
        AbsMag        -19.07
        Axis    [  0.5285   0.7170   0.4545]
        Angle    152.5852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 647"
}

Galaxy "NGC 648:IC 146:ESO 543-6:MCG 3-5-11"
{
        Type  "S0"
        RA            1.6442
        Dec         -17.8311
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.3730   0.8050  -0.4613]
        Angle    169.0144
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 648"
}

Galaxy "NGC 649:MCG 2-5-34"
{
        Type  "Sa"
        RA            1.6686
        Dec          -9.2717
        Distance    2.33e+08  # distance uncertain!
        Radius     3.051e+04
        AbsMag        -19.07
        Axis    [  0.3131   0.8792   0.3592]
        Angle    164.9318
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 649"
}

Galaxy "NGC 652:UGC 1184:MCG 1-5-17:ZWG 412.14"
{
        Type  "S0"
        RA            1.6786
        Dec           7.9833
        Distance   2.281e+08  # method: V
        Radius     3.317e+04
        AbsMag        -19.52
        Axis    [  0.3236   0.9450   0.0482]
        Angle    151.5660
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 652"
}

Galaxy "NGC 653:UGC 1193:MCG 6-4-58:ZWG 521.70"
{
        Type  "Sb"
        RA            1.7069
        Dec          35.6386
        Distance    1.54e+08  # distance uncertain!
        Radius     3.359e+04
        AbsMag        -19.07
        Axis    [ -0.1174   0.9447   0.3062]
        Angle    139.2105
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 653"
}

Galaxy "NGC 655:MCG 2-5-37"
{
        Type  "S0"
        RA            1.6986
        Dec         -13.0825
        Distance   2.125e+08  # distance uncertain!
        Radius     4.328e+04
        AbsMag        -19.07
        Axis    [  0.4620   0.8703  -0.1706]
        Angle    165.1333
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 655"
}

Galaxy "NGC 656:UGC 1194:MCG 4-5-2:ZWG 482.4"
{
        Type  "S0"
        RA            1.7075
        Dec          26.1433
        Distance   1.661e+08  # method: V
        Radius     3.623e+04
        AbsMag        -20.13
        Axis    [  0.4344   0.8901   0.1377]
        Angle    130.9402
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 656"
}

Galaxy "NGC 658:UGC 1192:MCG 2-5-9:ZWG 437.9"
{
        Type  "Sb"
        RA            1.7025
        Dec          12.6014
        Distance   1.258e+08  # method: T-F
        Radius     5.489e+04
        AbsMag        -19.83
        Axis    [  0.3040   0.8922   0.3339]
        Angle    143.3495
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 658"
}

Galaxy "NGC 660:UGC 1201:MCG 2-5-13:ZWG 437.12"
{
        Type  "SBa"
        RA            1.7169
        Dec          13.6436
        Distance   2.555e+07  # method: V
        Radius     3.084e+04
        AbsMag        -17.77
        Axis    [ -0.1148   0.6442  -0.7562]
        Angle    176.4655
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 660"
}

Galaxy "NGC 661:UGC 1215:MCG 5-5-5:ZWG 503.14"
{
        Type  "E0"
        RA            1.7372
        Dec          28.7067
        Distance   9.948e+07  # method: T-F
        Radius     2.315e+04
        AbsMag        -19.22
        Axis    [  0.6075   0.7813  -0.1434]
        Angle    145.9992
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 661"
}

Galaxy "NGC 662:UGC 1220:MCG 6-4-60:ZWG 521.73"
{
        Type  "Sc"
        RA            1.7431
        Dec          37.6964
        Distance   2.499e+08  # method: T-F
        Radius     2.907e+04
        AbsMag        -20.02
        Axis    [  0.2095   0.9147   0.3455]
        Angle    121.8366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 662"
}

Galaxy "NGC 664:UGC 1210:MCG 1-5-29:ZWG 412.23"
{
        Type  "Sb"
        RA            1.7292
        Dec           4.2225
        Distance   2.326e+08  # method: V
        Radius     3.722e+04
        AbsMag        -20.57
        Axis    [  0.4836   0.8719  -0.0767]
        Angle    156.0927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 664"
}

Galaxy "NGC 665:UGC 1223:MCG 2-5-19:ZWG 437.19"
{
        Type  "S0"
        RA            1.7489
        Dec          10.4231
        Distance   2.324e+08  # method: V
        Radius     8.112e+04
        AbsMag        -21.06
        Axis    [  0.1705   0.8482  -0.5015]
        Angle    173.3274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 665"
}

Galaxy "NGC 666:UGC 1236:MCG 6-5-2:ZWG 521.79"
{
        Type  "S0"
        RA            1.7683
        Dec          34.3747
        Distance   2.063e+08  # method: V
        Radius     2.101e+04
        AbsMag        -19.81
        Axis    [  0.1353   0.9798  -0.1473]
        Angle    149.9698
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 666"
}

Galaxy "NGC 667:ESO 477-2"
{
        Type  "S0"
        RA            1.7489
        Dec         -22.9192
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [  0.6308   0.7310  -0.2602]
        Angle    172.9660
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 667"
}

Galaxy "NGC 668:UGC 1238:MCG 6-5-3:ZWG 521.80"
{
        Type  "Sb"
        RA            1.7728
        Dec          36.4600
        Distance   1.224e+08  # method: T-F
        Radius     3.203e+04
        AbsMag        -19.17
        Axis    [  0.2222   0.9424   0.2500]
        Angle    125.0522
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 668"
}

Galaxy "NGC 669:UGC 1248:MCG 6-5-4:ZWG 522.4"
{
        Type  "Sb"
        RA            1.7878
        Dec          35.5631
        Distance   2.655e+08  # method: T-F
        Radius     1.197e+05
        AbsMag        -21.25
        Axis    [ -0.1003   0.9370   0.3346]
        Angle    138.0332
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 669"
}

Galaxy "NGC 670:UGC 1250:MCG 5-5-12:ZWG 503.24"
{
        Type  "S0"
        RA            1.7900
        Dec          27.8861
        Distance   1.559e+08  # method: V
        Radius     4.761e+04
        AbsMag         -19.8
        Axis    [ -0.2044   0.6618  -0.7213]
        Angle    184.8561
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 670"
}

Galaxy "NGC 671:UGC 1247:MCG 2-5-29:ZWG 437.27"
{
        Type  "S0"
        RA            1.7831
        Dec          13.1253
        Distance   2.344e+08  # method: V
        Radius     5.114e+04
        AbsMag        -20.08
        Axis    [  0.1265   0.9871   0.0980]
        Angle    149.0281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 671"
}

Galaxy "NGC 672:UGC 1256:MCG 4-5-11:ZWG 482.16"
{
        Type  "SBc"
        RA            1.7983
        Dec          27.4328
        Distance   6.886e+06  # method: V
        Radius          6009
        AbsMag        -15.22
        Axis    [  0.0308   0.9993   0.0221]
        Angle    144.1068
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 672"
}

Galaxy "NGC 673:UGC 1259:MCG 2-5-33:ZWG 437.30"
{
        Type  "Sc"
        RA            1.8061
        Dec          11.5214
        Distance    2.63e+08  # method: T-F
        Radius     8.032e+04
        AbsMag        -21.33
        Axis    [  0.5137   0.7292   0.4521]
        Angle    129.9358
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 673"
}

Galaxy "NGC 675:UGC 1273:MCG 2-5-41:MK 1166"
{
        Type  "S0"
        RA            1.8189
        Dec          13.0597
        Distance    2.44e+08  # distance uncertain!
        Radius     3.549e+04
        AbsMag        -19.07
        Axis    [  0.0660   0.9562  -0.2850]
        Angle    156.2383
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 675"
}

Galaxy "NGC 676:UGC 1270:MCG 1-5-34:ZWG 412.28"
{
        Type  "Sa"
        RA            1.8158
        Dec           5.9061
        Distance   5.549e+07  # method: V
        Radius     3.228e+04
        AbsMag        -18.35
        Axis    [ -0.1295   0.6110  -0.7810]
        Angle    163.7142
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 676"
}

Galaxy "NGC 677:UGC 1275:MCG 2-5-42:ZWG 437.39"
{
        Type  "E0"
        RA            1.8206
        Dec          13.0558
        Distance   2.182e+08  # method: V
        Radius     6.346e+04
        AbsMag        -20.93
        Axis    [  0.7836   0.5548   0.2797]
        Angle    113.7078
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 677"
}

Galaxy "NGC 678:UGC 1280:MCG 4-5-14:ZWG 482.18"
{
        Type  "SBb"
        RA            1.8233
        Dec          21.9969
        Distance   8.988e+07  # method: T-F
        Radius     5.882e+04
        AbsMag         -18.9
        Axis    [ -0.1103   0.9925  -0.0522]
        Angle    147.7800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 678"
}

Galaxy "NGC 679:UGC 1283:MCG 6-5-12:ZWG 522.15"
{
        Type  "S0"
        RA            1.8286
        Dec          35.7861
        Distance   1.903e+08  # method: T-F
        Radius     5.257e+04
        AbsMag        -20.53
        Axis    [  0.6971   0.6865   0.2070]
        Angle     97.1053
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 679"
}

Galaxy "NGC 680:UGC 1286:MCG 4-5-15:ZWG 482.19"
{
        Type  "E0"
        RA            1.8297
        Dec          21.9711
        Distance   1.161e+08  # method: T-F
        Radius      3.04e+04
        AbsMag        -19.86
        Axis    [  0.3409   0.7283  -0.5944]
        Angle    220.4661
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 680"
}

Galaxy "NGC 681:MCG 2-5-52:IRAS 01467-1040"
{
        Type  "SBb"
        RA            1.8194
        Dec         -10.4272
        Distance   6.727e+07  # method: V
        Radius     2.642e+04
        AbsMag        -18.77
        Axis    [  0.4928   0.8698  -0.0228]
        Angle    160.1862
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 681"
}

Galaxy "NGC 682:MCG 3-5-22"
{
        Type  "S0"
        RA            1.8178
        Dec         -14.9744
        Distance   1.612e+08  # distance uncertain!
        Radius     3.283e+04
        AbsMag        -19.07
        Axis    [  0.5261   0.7838  -0.3301]
        Angle    170.3340
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 682"
}

Galaxy "NGC 683:UGC 1288:MCG 2-5-47:ZWG 437.43"
{
        Type  "S0"
        RA            1.8294
        Dec          11.7019
        Distance   2.256e+08  # method: V
        Radius     3.281e+04
        AbsMag         -19.6
        Axis    [  0.7690   0.5649   0.2992]
        Angle    115.5937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 683"
}

Galaxy "NGC 684:IC 165:UGC 1292:MCG 4-5-17"
{
        Type  "Sb"
        RA            1.8372
        Dec          27.6461
        Distance   1.538e+08  # method: T-F
        Radius     2.685e+04
        AbsMag        -20.07
        Axis    [  0.0343   0.9841  -0.1741]
        Angle    151.3173
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 684"
}

Galaxy "NGC 685:ESO 152-24:AM 0145-530:IRAS 01458-5300"
{
        Type  "SBc"
        RA            1.7950
        Dec         -52.7619
        Distance     5.5e+07  # method: V
        Radius      2.88e+04
        AbsMag        -19.23
        Axis    [  0.8255   0.5398  -0.1649]
        Angle    183.4400
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 685"
}

Galaxy "NGC 686:ESO 477-6:MCG 4-5-8"
{
        Type  "S0"
        RA            1.8156
        Dec         -23.7981
        Distance   1.999e+08  # method: V
        Radius     4.943e+04
        AbsMag        -20.54
        Axis    [  0.6641   0.6627   0.3461]
        Angle    161.4888
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 686"
}

Galaxy "NGC 687:UGC 1298:MCG 6-5-14:ZWG 522.17"
{
        Type  "S0"
        RA            1.8425
        Dec          36.3708
        Distance   1.903e+08  # method: T-F
        Radius     3.874e+04
        AbsMag        -20.53
        Axis    [  0.6963   0.6882   0.2040]
        Angle     96.5631
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 687"
}

Galaxy "NGC 688:UGC 1302:MCG 6-5-15:MK 1009"
{
        Type  "SBb"
        RA            1.8456
        Dec          35.2847
        Distance   2.288e+08  # method: T-F
        Radius     7.986e+04
        AbsMag        -20.93
        Axis    [ -0.1058   0.8307  -0.5466]
        Angle    182.5465
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 688"
}

Galaxy "NGC 689:ESO 414-5:MCG 5-5-19:AM 0147-274"
{
        Type  "Sb"
        RA            1.8308
        Dec         -27.4664
        Distance   1.768e+08  # distance uncertain!
        Radius     2.571e+04
        AbsMag        -19.07
        Axis    [  0.5546   0.8260  -0.1004]
        Angle    168.5442
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 689"
}

Galaxy "NGC 690:MCG 3-5-21:A 0145-16"
{
        Type  "SBc"
        RA            1.7967
        Dec         -16.7214
        Distance    2.22e+08  # method: V
        Radius     3.875e+04
        AbsMag        -18.96
        Axis    [  0.3023   0.6626  -0.6852]
        Angle    175.1081
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 690"
}

Galaxy "NGC 691:UGC 1305:MCG 4-5-19:ZWG 482.23"
{
        Type  "Sc"
        RA            1.8447
        Dec          21.7603
        Distance   1.083e+08  # method: V
        Radius     5.354e+04
        AbsMag         -20.3
        Axis    [  0.2146   0.9365  -0.2775]
        Angle    160.1185
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 691"
}

Galaxy "NGC 692:ESO 197-3:FAIR 712:IRAS 01467-4853"
{
        Type  "SBc"
        RA            1.8117
        Dec         -48.6481
        Distance   2.762e+08  # method: V
        Radius     8.436e+04
        AbsMag        -21.54
        Axis    [  0.8011   0.5709   0.1800]
        Angle    180.9938
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 692"
}

Galaxy "NGC 693:UGC 1304:MCG 1-5-35:ZWG 412.33"
{
        Type  "Sa"
        RA            1.8417
        Dec           6.1447
        Distance   5.799e+07  # method: V
        Radius     1.855e+04
        AbsMag        -18.05
        Axis    [  0.1643   0.9164  -0.3649]
        Angle    160.6910
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 693"
}

Galaxy "NGC 694:UGC 1310:MCG 4-5-20:MK 363"
{
        Type  "S0"
        RA            1.8494
        Dec          21.9969
        Distance   1.212e+08  # method: V
        Radius     1.057e+04
        AbsMag        -18.55
        Axis    [ -0.0287   0.7370  -0.6753]
        Angle    188.8771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 694"
}

Galaxy "NGC 695:UGC 1315:ZWG 482.26:ZW 123"
{
        Type  "S0"
        RA            1.8539
        Dec          22.5828
        Distance   4.286e+08  # method: V
        Radius     4.987e+04
        AbsMag        -21.69
        Axis    [  0.4670   0.8792   0.0943]
        Angle    133.7982
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 695"
}

Galaxy "NGC 696:ESO 353-50:MCG 6-5-4"
{
        Type  "SBa"
        RA            1.8253
        Dec         -34.9050
        Distance   3.541e+08  # method: V
        Radius     8.756e+04
        AbsMag        -20.78
        Axis    [  0.4742   0.8394   0.2656]
        Angle    180.9751
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 696"
}

Galaxy "NGC 697:NGC 674:UGC 1317:MCG 4-5-22"
{
        Type  "SBc"
        RA            1.8547
        Dec          22.3575
        Distance   1.277e+08  # method: T-F
        Radius     7.429e+04
        AbsMag        -20.16
        Axis    [ -0.0743   0.9505  -0.3017]
        Angle    154.6855
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 697"
}

Galaxy "NGC 698:ESO 353-51:MCG 6-5-5:AM 0147-350"
{
        Type  "SBb"
        RA            1.8286
        Dec         -34.8314
        Distance   3.696e+08  # method: V
        Radius     4.838e+04
        AbsMag        -20.47
        Axis    [  0.4215   0.4048  -0.8115]
        Angle    189.2734
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 698"
}

Galaxy "NGC 699:MCG 2-5-59:IRAS 01482-1217"
{
        Type  "Sc"
        RA            1.8453
        Dec         -12.0356
        Distance   2.408e+08  # method: T-F
        Radius     5.604e+04
        AbsMag        -19.44
        Axis    [  0.0574   0.8107  -0.5827]
        Angle    150.7220
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 699"
}

Galaxy "NGC 700:ZWG 522.30"
{
        Type  "S0"
        RA            1.8711
        Dec          36.0367
        Distance   2.012e+08  # method: V
        Radius     2.341e+04
        AbsMag        -18.35
        Axis    [  0.4709   0.7868   0.3989]
        Angle    105.6518
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 700"
}

Galaxy "NGC 701:MCG 2-5-60:IRAS 01485-0957"
{
        Type  "SBc"
        RA            1.8508
        Dec          -9.7033
        Distance   7.792e+07  # method: T-F
        Radius     2.946e+04
        AbsMag        -18.99
        Axis    [  0.4367   0.8843   0.1654]
        Angle    158.4657
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 701"
}

Galaxy "NGC 702:MCG 1-5-43:ARP 75"
{
        Type  "SBc"
        RA            1.8553
        Dec          -4.0556
        Distance    4.68e+08  # method: V
        Radius     8.167e+04
        AbsMag        -21.88
        Axis    [  0.2277   0.7391  -0.6339]
        Angle    175.3592
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 702"
}

Galaxy "NGC 703:UGC 1346:MCG 6-5-29:ZWG 522.37"
{
        Type  "S0"
        RA            1.8775
        Dec          36.1722
        Distance   2.041e+08  # method: V
        Radius     2.671e+04
        AbsMag        -19.68
        Axis    [  0.2595   0.9643   0.0530]
        Angle    131.7921
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 703"
}

Galaxy "NGC 704-1:UGC 1343:MCG 6-5-28:ZWG 522.34"
{
        Type  "S0"
        RA            1.8769
        Dec          36.1269
        Distance   1.281e+08  # distance uncertain!
        Radius     1.118e+04
        AbsMag        -19.07
        Axis    [  0.0623   0.9767  -0.2056]
        Angle    152.7191
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 704-1"
}

Galaxy "NGC 704-2:ZWG 522.33"
{
        Type  "E0"
        RA            1.8772
        Dec          36.1244
        Distance   4.571e+08  # distance uncertain!
        Radius     2.659e+04
        AbsMag        -20.13
        Axis    [  0.7218   0.6678   0.1817]
        Angle     95.8794
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 704-2"
}

Galaxy "NGC 705:UGC 1345:MCG 6-5-30:ZWG 522.36"
{
        Type  "Sa"
        RA            1.8781
        Dec          36.1444
        Distance   1.945e+08  # method: V
        Radius     3.395e+04
        AbsMag        -19.28
        Axis    [ -0.2635   0.9099  -0.3205]
        Angle    155.2503
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 705"
}

Galaxy "NGC 706:UGC 1334:MCG 1-5-40:ZWG 412.37"
{
        Type  "Sc"
        RA            1.8639
        Dec           6.2961
        Distance    2.13e+08  # method: V
        Radius     5.885e+04
        AbsMag        -20.87
        Axis    [  0.1958   0.7335  -0.6508]
        Angle    186.2648
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 706"
}

Galaxy "NGC 707-1:MCG 2-5-63"
{
        Type  "S0"
        RA            1.8575
        Dec          -8.5061
        Distance   1.768e+08  # distance uncertain!
        Radius     3.343e+04
        AbsMag        -19.07
        Axis    [  0.4225   0.8484  -0.3189]
        Angle    165.5437
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 707-1"
}

Galaxy "NGC 707-2:MCG 2-5-63"
{
        Type  "E0"
        RA            1.8575
        Dec          -8.5069
        Distance   3.468e+08  # distance uncertain!
        Radius     1.513e+04
        AbsMag        -20.13
        Axis    [  0.8234   0.4499   0.3457]
        Angle    130.8840
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 707-2"
}

Galaxy "NGC 708:UGC 1348:MCG 6-5-31:ZWG 522.39"
{
        Type  "E0"
        RA            1.8794
        Dec          36.1522
        Distance   1.903e+08  # method: T-F
        Radius     8.301e+04
        AbsMag        -20.93
        Axis    [  0.6327   0.7735  -0.0375]
        Angle    121.3051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 708"
}

Galaxy "NGC 709:ZWG 522.40"
{
        Type  "S0"
        RA            1.8806
        Dec          36.2231
        Distance    1.41e+08  # method: V
        Radius      2.05e+04
        AbsMag        -17.98
        Axis    [ -0.1585   0.8611  -0.4831]
        Angle    172.0969
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 709"
}

Galaxy "NGC 710:UGC 1349:MCG 6-5-33:ZWG 522.41"
{
        Type  "Sc"
        RA            1.8817
        Dec          36.0533
        Distance   2.654e+08  # method: V
        Radius     5.018e+04
        AbsMag        -20.35
        Axis    [  0.4133   0.9103   0.0206]
        Angle    128.2526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 710"
}

Galaxy "NGC 711:UGC 1342:MCG 3-5-24:ZWG 460.38"
{
        Type  "S0"
        RA            1.8742
        Dec          17.5131
        Distance   2.107e+08  # method: V
        Radius     4.903e+04
        AbsMag        -19.75
        Axis    [  0.2492   0.8720   0.4213]
        Angle    139.7463
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 711"
}

Galaxy "NGC 712:UGC 1352:MCG 6-5-35:ZWG 522.43"
{
        Type  "S0"
        RA            1.8856
        Dec          36.8197
        Distance   2.271e+08  # method: V
        Radius     3.303e+04
        AbsMag        -20.41
        Axis    [  0.0263   0.9872  -0.1576]
        Angle    148.8700
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 712"
}

Galaxy "NGC 713:MCG 2-5-75"
{
        Type  "Sb"
        RA            1.9225
        Dec          -9.0833
        Distance    2.33e+08  # distance uncertain!
        Radius      3.39e+04
        AbsMag        -19.07
        Axis    [  0.2022   0.9378  -0.2822]
        Angle    155.8669
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 713"
}

Galaxy "NGC 714:UGC 1358:MCG 6-5-37:ZWG 522.47"
{
        Type  "Sa"
        RA            1.8914
        Dec          36.2214
        Distance   1.908e+08  # method: V
        Radius     4.162e+04
        AbsMag        -19.73
        Axis    [ -0.2472   0.9188  -0.3076]
        Angle    154.8359
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 714"
}

Galaxy "NGC 715:MCG 2-5-69"
{
        Type  "Sb"
        RA            1.8867
        Dec         -12.8733
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.0867   0.5371  -0.8391]
        Angle    170.1051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 715"
}

Galaxy "NGC 716:IC 1743:UGC 1351:MCG 2-5-54"
{
        Type  "SBa"
        RA            1.8831
        Dec          12.7083
        Distance   2.107e+08  # method: T-F
        Radius     5.516e+04
        AbsMag        -20.15
        Axis    [  0.2016   0.9776   0.0599]
        Angle    147.5401
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 716"
}

Galaxy "NGC 717:UGC 1363:MCG 6-5-41:ZWG 522.52"
{
        Type  "Sa"
        RA            1.8986
        Dec          36.2297
        Distance   2.139e+08  # method: V
        Radius     4.045e+04
        AbsMag        -19.18
        Axis    [ -0.3166   0.8887  -0.3318]
        Angle    154.0755
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 717"
}

Galaxy "NGC 718:UGC 1356:MCG 1-5-41:ZWG 412.39"
{
        Type  "SBa"
        RA            1.8869
        Dec           4.1956
        Distance   6.587e+07  # method: V
        Radius     2.203e+04
        AbsMag        -18.93
        Axis    [  0.6601   0.7506   0.0305]
        Angle    146.1918
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 718"
}

Galaxy "NGC 719:IC 1744:UGC 1360:MCG 3-5-26"
{
        Type  "S0"
        RA            1.8939
        Dec          19.8408
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.0865   0.7750  -0.6260]
        Angle    189.5244
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 719"
}

Galaxy "NGC 720:MCG 2-5-68"
{
        Type  "E5"
        RA            1.8833
        Dec         -13.7386
        Distance   9.025e+07  # method: S
        Radius     6.169e+04
        AbsMag        -21.01
        Axis    [  0.5908   0.5075  -0.6272]
        Angle    207.5389
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 720"
}

Galaxy "NGC 721:UGC 1376:MCG 6-5-43:ZWG 522.56"
{
        Type  "SBc"
        RA            1.9125
        Dec          39.3831
        Distance   2.426e+08  # method: V
        Radius     5.998e+04
        AbsMag        -20.26
        Axis    [ -0.1342   0.8706  -0.4733]
        Angle    175.2114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 721"
}

Galaxy "NGC 722:UGC 1379:MCG 3-5-32:ZWG 460.46"
{
        Type  "Sc"
        RA            1.9128
        Dec          20.6983
        Distance   2.097e+08  # method: V
        Radius     5.185e+04
        AbsMag        -19.64
        Axis    [ -0.1553   0.8258  -0.5421]
        Angle    162.0074
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 722"
}

Galaxy "NGC 723:NGC 724:ESO 477-13:MCG 4-5-16"
{
        Type  "Sc"
        RA            1.8958
        Dec         -23.7572
        Distance   5.667e+07  # method: V
        Radius     1.236e+04
        AbsMag         -17.9
        Axis    [  0.3368   0.4742  -0.8135]
        Angle    190.2768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 723"
}

Galaxy "NGC 725:MCG 3-5-25"
{
        Type  "Sc"
        RA            1.8764
        Dec         -16.5175
        Distance   2.125e+08  # distance uncertain!
        Radius     2.473e+04
        AbsMag        -19.07
        Axis    [  0.4813   0.8576  -0.1814]
        Angle    163.8774
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 725"
}

Galaxy "NGC 726:MCG 2-6-3:KUG 0153-110"
{
        Type  "Irr"
        RA            1.9253
        Dec         -10.7994
        Distance   2.308e+08  # method: V
        Radius     4.028e+04
        AbsMag        -19.35
        Axis    [  0.3186   0.8815  -0.3484]
        Angle    160.9197
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 726"
}

Galaxy "NGC 727:NGC 729:ESO 354-10:MCG 6-5-12"
{
        Type  "SBb"
        RA            1.8969
        Dec         -35.8558
        Distance   4.463e+08  # method: V
        Radius      7.14e+04
        AbsMag        -20.78
        Axis    [  0.5713   0.8012  -0.1780]
        Angle    170.2398
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 727"
}

Galaxy "NGC 731:NGC 757:MCG 2-5-73"
{
        Type  "E0"
        RA            1.9153
        Dec          -9.0114
        Distance   1.446e+08  # distance uncertain!
        Radius     3.574e+04
        AbsMag        -20.13
        Axis    [  0.8286   0.4425   0.3430]
        Angle    131.0646
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 731"
}

Galaxy "NGC 732:UGC 1406:MCG 6-5-57:MK 1011"
{
        Type  "S0"
        RA            1.9408
        Dec          36.8022
        Distance   2.558e+08  # method: V
        Radius     5.209e+04
        AbsMag        -19.87
        Axis    [  0.2740   0.9284   0.2509]
        Angle    121.1235
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 732"
}

Galaxy "NGC 734"
{
        Type  "SBa"
        RA            1.9158
        Dec         -17.0797
        Distance   4.869e+08  # distance uncertain!
        Radius     4.957e+04
        AbsMag        -19.07
        Axis    [  0.5067   0.8130   0.2869]
        Angle    162.5086
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 734"
}

Galaxy "NGC 735:UGC 1411:MCG 6-5-58:ZWG 522.78"
{
        Type  "Sb"
        RA            1.9439
        Dec          34.1775
        Distance   2.366e+08  # method: T-F
        Radius     6.194e+04
        AbsMag         -20.2
        Axis    [ -0.1802   0.8438  -0.5055]
        Angle    170.2866
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 735"
}

Galaxy "NGC 736:UGC 1414:MCG 5-5-28:ZWG 503.55"
{
        Type  "E0"
        RA            1.9447
        Dec          33.0444
        Distance   1.903e+08  # method: T-F
        Radius     4.151e+04
        AbsMag        -20.63
        Axis    [  0.7398   0.6443   0.1940]
        Angle     97.5967
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 736"
}

Galaxy "NGC 738:ZWG 503.57:ZW 113:NPM 1"
{
        Type  "S0"
        RA            1.9458
        Dec          33.0589
        Distance   3.369e+08  # distance uncertain!
        Radius      1.96e+04
        AbsMag        -19.07
        Axis    [ -0.1810   0.7720  -0.6093]
        Angle    180.3662
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 738"
}

Galaxy "NGC 739:MCG 5-5-30:ZWG 503.59:ARAK 67"
{
        Type  "Sa"
        RA            1.9483
        Dec          33.2672
        Distance   1.885e+08  # method: V
        Radius     2.467e+04
        AbsMag        -18.81
        Axis    [ -0.0185   0.8926  -0.4504]
        Angle    172.3746
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 739"
}

Galaxy "NGC 740:UGC 1421:MCG 5-5-31:ZWG 503.58"
{
        Type  "SBb"
        RA            1.9486
        Dec          33.0156
        Distance   2.242e+08  # method: T-F
        Radius     4.566e+04
        AbsMag        -19.29
        Axis    [ -0.3128   0.8159  -0.4863]
        Angle    159.9102
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 740"
}

Galaxy "NGC 741:IC 1751:UGC 1413:MCG 1-6-3"
{
        Type  "E0"
        RA            1.9389
        Dec           5.6286
        Distance   2.296e+08  # method: T-F
        Radius     1.002e+05
        AbsMag        -21.94
        Axis    [  0.6751   0.6689  -0.3112]
        Angle    174.2528
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 741"
}

Galaxy "NGC 742:MCG 1-6-4:ZWG 413.9:VV 175"
{
        Type  "S0"
        RA            1.9400
        Dec           5.6258
        Distance   2.324e+08  # method: V
        Radius     1.014e+04
        AbsMag        -18.96
        Axis    [  0.7914   0.5256   0.3122]
        Angle    119.8746
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 742"
}

Galaxy "NGC 745-1:ESO 152-32:AM 0152-565"
{
        Type  "Sa"
        RA            1.9019
        Dec         -56.6936
        Distance   2.641e+08  # method: V
        Radius     4.994e+04
        AbsMag        -21.24
        Axis    [  0.7328   0.6801   0.0233]
        Angle    186.0778
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 745-1"
}

Galaxy "NGC 745-2:ESO 152-32:AM 0152-565"
{
        Type  "S0"
        RA            1.9031
        Dec         -56.6853
        Distance   2.125e+08  # distance uncertain!
        Radius     2.164e+04
        AbsMag        -19.07
        Axis    [  0.6237   0.7095  -0.3280]
        Angle    171.1746
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 745-2"
}

Galaxy "NGC 745-3:ESO 152-32:AM 0152-565"
{
        Type  "E0"
        RA            1.9019
        Dec         -56.6875
        Distance   5.496e+08  # distance uncertain!
        Radius     1.599e+04
        AbsMag        -20.13
        Axis    [  0.8587   0.2436   0.4509]
        Angle    171.5164
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 745-3"
}

Galaxy "NGC 746:UGC 1438:MCG 7-5-3:ZWG 538.4"
{
        Type  "Irr"
        RA            1.9642
        Dec          44.9183
        Distance   2.211e+07  # method: V
        Radius          5466
        AbsMag        -15.55
        Axis    [ -0.0627   0.9831  -0.1721]
        Angle    148.6224
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 746"
}

Galaxy "NGC 747:MCG 2-6-7"
{
        Type  "Sb"
        RA            1.9583
        Dec          -9.4628
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.0586   0.5487  -0.8339]
        Angle    170.7404
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 747"
}

Galaxy "NGC 748:MCG 1-6-4:IRAS 01538-0442"
{
        Type  "Sb"
        RA            1.9392
        Dec          -4.4672
        Distance   2.288e+08  # method: V
        Radius     7.653e+04
        AbsMag        -20.83
        Axis    [  0.1426   0.7736  -0.6174]
        Angle    164.8005
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 748"
}

Galaxy "NGC 749:ESO 414-11:MCG 5-5-23:IRAS 01534-3009"
{
        Type  "SBa"
        RA            1.9278
        Dec         -29.9222
        Distance    1.89e+08  # method: V
        Radius     5.224e+04
        AbsMag        -20.41
        Axis    [  0.5492   0.6894  -0.4724]
        Angle    172.3877
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 749"
}

Galaxy "NGC 750:UGC 1430:MCG 5-5-34:ZWG 503.62"
{
        Type  "E0"
        RA            1.9589
        Dec          33.2097
        Distance   1.903e+08  # method: T-F
        Radius     4.427e+04
        AbsMag        -20.83
        Axis    [  0.2481   0.7847  -0.5680]
        Angle    223.9492
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 750"
}

Galaxy "NGC 751:UGC 1431:MCG 5-5-35:ZWG 503.62"
{
        Type  "E0"
        RA            1.9592
        Dec          33.2025
        Distance   2.226e+08  # method: V
        Radius     3.884e+04
        AbsMag        -20.97
        Axis    [  0.7407   0.6436   0.1928]
        Angle     97.3684
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 751"
}

Galaxy "NGC 753:UGC 1437:MCG 6-5-66:ZWG 522.86"
{
        Type  "SBc"
        RA            1.9617
        Dec          35.9158
        Distance    2.02e+08  # method: T-F
        Radius     8.812e+04
        AbsMag        -20.96
        Axis    [ -0.0547   0.9022  -0.4279]
        Angle    170.0501
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 753"
}

Galaxy "NGC 754:ESO 152-33"
{
        Type  "E0"
        RA            1.9056
        Dec         -56.7611
        Distance   3.802e+08  # distance uncertain!
        Radius     3.318e+04
        AbsMag        -20.13
        Axis    [  0.9230   0.2219  -0.3145]
        Angle    194.3946
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 754"
}

Galaxy "NGC 755:NGC 763:MCG 2-6-5:KUG 0153-093"
{
        Type  "SBb"
        RA            1.9394
        Dec          -9.0625
        Distance   7.461e+07  # method: T-F
        Radius     3.581e+04
        AbsMag         -18.4
        Axis    [  0.3140   0.9384   0.1441]
        Angle    159.1512
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 755"
}

Galaxy "NGC 756:MCG 3-5-29"
{
        Type  "S0"
        RA            1.9081
        Dec         -16.7075
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [  0.5338   0.8179   0.2148]
        Angle    161.2381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 756"
}

Galaxy "NGC 758:NPM 1"
{
        Type  "S0"
        RA            1.9283
        Dec          -3.0661
        Distance   2.555e+08  # distance uncertain!
        Radius     3.345e+04
        AbsMag        -19.07
        Axis    [  0.4659   0.8502  -0.2452]
        Angle    162.5809
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 758"
}

Galaxy "NGC 759:UGC 1440:MCG 6-5-67:ZWG 522.87"
{
        Type  "E0"
        RA            1.9639
        Dec          36.3431
        Distance     2.1e+08  # method: V
        Radius     4.276e+04
        AbsMag        -20.24
        Axis    [  0.7299   0.6600   0.1782]
        Angle     95.0219
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 759"
}

Galaxy "NGC 761:UGC 1439:MCG 5-5-36:ZWG 503.64"
{
        Type  "SBa"
        RA            1.9636
        Dec          33.3764
        Distance   2.165e+08  # method: V
        Radius     4.409e+04
        AbsMag        -19.61
        Axis    [ -0.2310   0.8126  -0.5351]
        Angle    168.7716
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 761"
}

Galaxy "NGC 762:MCG 1-6-6:MK 1012:IRAS 01544-0538"
{
        Type  "SBa"
        RA            1.9492
        Dec          -5.4022
        Distance   2.061e+08  # method: V
        Radius     4.197e+04
        AbsMag         -20.1
        Axis    [  0.6323   0.7383   0.2346]
        Angle    146.7842
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 762"
}

Galaxy "NGC 765:UGC 1455:MCG 4-5-25:ZWG 482.33"
{
        Type  "SBc"
        RA            1.9800
        Dec          24.8922
        Distance   2.199e+08  # method: V
        Radius     8.955e+04
        AbsMag        -20.34
        Axis    [  0.7491   0.6147   0.2468]
        Angle    104.2037
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 765"
}

Galaxy "NGC 766:UGC 1458:MCG 1-6-19:ZWG 413.19"
{
        Type  "E0"
        RA            1.9783
        Dec           8.3472
        Distance   3.546e+08  # method: V
        Radius     1.032e+05
        AbsMag        -21.28
        Axis    [  0.8069   0.5161   0.2873]
        Angle    116.5576
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 766"
}

Galaxy "NGC 767:MCG 2-6-10:KUG 0156-098:IRAS 01563-0949"
{
        Type  "Sb"
        RA            1.9806
        Dec          -9.5872
        Distance   2.323e+08  # method: V
        Radius     3.716e+04
        AbsMag        -18.96
        Axis    [  0.0429   0.6212  -0.7825]
        Angle    160.9486
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 767"
}

Galaxy "NGC 768:UGC 1457:MCG 0-6-16:ZWG 387.18"
{
        Type  "Sc"
        RA            1.9778
        Dec           0.5289
        Distance   3.221e+08  # method: T-F
        Radius     7.965e+04
        AbsMag        -20.87
        Axis    [  0.3562   0.8950   0.2686]
        Angle    151.0082
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 768"
}

Galaxy "NGC 769:UGC 1467:MCG 5-5-37:ZWG 503.66"
{
        Type  "Sc"
        RA            1.9931
        Dec          30.9097
        Distance   1.912e+08  # method: V
        Radius     2.224e+04
        AbsMag        -20.24
        Axis    [  0.1322   0.9877  -0.0833]
        Angle    143.5387
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 769"
}

Galaxy "NGC 770:UGC 1463:MCG 3-6-10:ZWG 461.16"
{
        Type  "E1"
        RA            1.9869
        Dec          18.9550
        Distance   9.839e+07  # method: V
        Radius     1.574e+04
        AbsMag         -18.4
        Axis    [  0.7696   0.6234   0.1381]
        Angle    117.0063
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 770"
}

Galaxy "NGC 772:UGC 1466:MCG 3-6-11:ZWG 461.18"
{
        Type  "Sb"
        RA            1.9886
        Dec          19.0075
        Distance    1.25e+08  # method: T-F
        Radius     1.309e+05
        AbsMag        -21.81
        Axis    [  0.0433   0.8579  -0.5120]
        Angle    169.5588
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 772"
}

Galaxy "NGC 773:MCG 2-6-11"
{
        Type  "Sa"
        RA            1.9808
        Dec         -11.5153
        Distance   2.422e+08  # method: V
        Radius     4.931e+04
        AbsMag        -20.35
        Axis    [  0.0788   0.5110  -0.8560]
        Angle    174.6770
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 773"
}

Galaxy "NGC 774:UGC 1469:MCG 2-6-8:ZWG 438.10"
{
        Type  "S0"
        RA            1.9928
        Dec          14.0083
        Distance   1.958e+08  # method: V
        Radius     4.271e+04
        AbsMag        -19.79
        Axis    [  0.0738   0.6876  -0.7224]
        Angle    195.0523
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 774"
}

Galaxy "NGC 775:ESO 477-18:MCG 5-5-24:IRAS 01562-2632"
{
        Type  "SBc"
        RA            1.9756
        Dec         -26.2939
        Distance   1.863e+08  # method: T-F
        Radius     4.607e+04
        AbsMag        -20.38
        Axis    [  0.2730   0.4939  -0.8255]
        Angle    175.7848
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 775"
}

Galaxy "NGC 776:UGC 1471:MCG 4-5-28:ZWG 482.37"
{
        Type  "SBb"
        RA            1.9983
        Dec          23.6442
        Distance    2.11e+08  # method: V
        Radius     5.216e+04
        AbsMag        -20.75
        Axis    [  0.7545   0.6065   0.2507]
        Angle    105.0538
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 776"
}

Galaxy "NGC 777:UGC 1476:MCG 5-5-38:ZWG 503.67"
{
        Type  "E1"
        RA            2.0039
        Dec          31.4297
        Distance   1.903e+08  # method: T-F
        Radius     6.918e+04
        AbsMag        -21.33
        Axis    [  0.2856   0.7835  -0.5520]
        Angle    217.7471
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 777"
}

Galaxy "NGC 778:UGC 1480:MCG 5-5-39:ZWG 503.69"
{
        Type  "S0"
        RA            2.0053
        Dec          31.3131
        Distance    1.47e+08  # distance uncertain!
        Radius     2.352e+04
        AbsMag        -19.07
        Axis    [ -0.1813   0.7895  -0.5863]
        Angle    174.6722
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 778"
}

Galaxy "NGC 779:MCG 1-6-16:IRAS 01571-0612"
{
        Type  "SBb"
        RA            1.9950
        Dec          -5.9642
        Distance   6.831e+07  # method: T-F
        Radius     4.074e+04
        AbsMag         -19.6
        Axis    [ -0.0010   0.6670  -0.7451]
        Angle    157.3607
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 779"
}

Galaxy "NGC 780:UGC 1488:MCG 5-5-41:ZWG 503.72"
{
        Type  "Sb"
        RA            2.0097
        Dec          28.2258
        Distance   1.938e+08  # distance uncertain!
        Radius     3.665e+04
        AbsMag        -19.07
        Axis    [ -0.1134   0.6787  -0.7256]
        Angle    198.2475
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 780"
}

Galaxy "NGC 781:UGC 1482:MCG 2-6-10:ZWG 438.11"
{
        Type  "Sb"
        RA            2.0022
        Dec          12.6556
        Distance   1.454e+08  # method: V
        Radius     3.172e+04
        AbsMag        -19.15
        Axis    [  0.1912   0.8676   0.4590]
        Angle    148.0146
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 781"
}

Galaxy "NGC 782:ESO 114-15:AM 0155-580:IRAS 01559-5801"
{
        Type  "SBb"
        RA            1.9611
        Dec         -57.7908
        Distance   2.666e+08  # method: V
        Radius     9.306e+04
        AbsMag        -22.06
        Axis    [  0.8280   0.4967   0.2602]
        Angle    186.5922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 782"
}

Galaxy "NGC 783:IC 1765:UGC 1497:MCG 5-5-42"
{
        Type  "Sc"
        RA            2.0183
        Dec          31.8819
        Distance   2.238e+08  # method: V
        Radius     5.208e+04
        AbsMag        -21.28
        Axis    [  0.4294   0.8947   0.1226]
        Angle    123.6690
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 783"
}

Galaxy "NGC 784:UGC 1501:MCG 5-5-45:ZWG 503.74"
{
        Type  "SBc"
        RA            2.0214
        Dec          28.8381
        Distance   1.522e+07  # method: T-F
        Radius     1.461e+04
        AbsMag        -16.24
        Axis    [  0.1209   0.7963   0.5927]
        Angle    137.2436
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 784"
}

Galaxy "NGC 785:IC 1766:UGC 1509:MCG 5-5-46"
{
        Type  "S0"
        RA            2.0278
        Dec          31.8267
        Distance   2.162e+08  # method: V
        Radius     4.717e+04
        AbsMag        -20.31
        Axis    [  0.1713   0.9689  -0.1786]
        Angle    148.8514
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 785"
}

Galaxy "NGC 786:UGC 1506:MCG 2-6-12:ZWG 438.13"
{
        Type  "S0"
        RA            2.0233
        Dec          15.6461
        Distance   1.925e+08  # method: V
        Radius      1.96e+04
        AbsMag        -19.46
        Axis    [  0.2075   0.7921  -0.5741]
        Angle    185.2549
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 786"
}

Galaxy "NGC 787:MCG 2-6-15"
{
        Type  "Sb"
        RA            2.0133
        Dec          -9.0025
        Distance   1.168e+08  # distance uncertain!
        Radius     4.247e+04
        AbsMag        -19.07
        Axis    [  0.4841   0.8242  -0.2938]
        Angle    164.2396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 787"
}

Galaxy "NGC 788:MCG 1-6-25"
{
        Type  "Sa"
        RA            2.0183
        Dec          -6.8156
        Distance   1.742e+08  # method: V
        Radius     4.053e+04
        AbsMag        -20.64
        Axis    [  0.4812   0.7479  -0.4573]
        Angle    174.7637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 788"
}

Galaxy "NGC 789:UGC 1520:MCG 5-5-47:ZWG 503.77"
{
        Type  "Irr"
        RA            2.0406
        Dec          32.0722
        Distance    2.27e+08  # method: V
        Radius     3.962e+04
        AbsMag        -20.01
        Axis    [  0.3446   0.8105   0.4736]
        Angle    117.1997
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 789"
}

Galaxy "NGC 790:MCG 1-6-26"
{
        Type  "S0"
        RA            2.0225
        Dec          -5.3706
        Distance   1.341e+08  # distance uncertain!
        Radius     2.536e+04
        AbsMag        -19.07
        Axis    [  0.8168   0.4684   0.3370]
        Angle    128.5913
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 790"
}

Galaxy "NGC 791:UGC 1511:MCG 1-6-31:ZWG 413.28"
{
        Type  "E0"
        RA            2.0289
        Dec           8.4997
        Distance   2.512e+08  # distance uncertain!
        Radius     5.846e+04
        AbsMag        -20.13
        Axis    [  0.8109   0.5117   0.2840]
        Angle    116.1629
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 791"
}

Galaxy "NGC 792:UGC 1517:MCG 2-6-15:ZWG 438.14"
{
        Type  "S0"
        RA            2.0375
        Dec          15.7122
        Distance   1.968e+08  # method: V
        Radius     4.867e+04
        AbsMag         -19.7
        Axis    [  0.0968   0.8460  -0.5244]
        Angle    170.5591
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 792"
}

Galaxy "NGC 794:IC 191:UGC 1528:MCG 3-6-24"
{
        Type  "S0"
        RA            2.0414
        Dec          18.3728
        Distance   3.605e+08  # method: V
        Radius     6.815e+04
        AbsMag        -21.42
        Axis    [  0.4718   0.8795   0.0627]
        Angle    136.7071
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 794"
}

Galaxy "NGC 795:ESO 153-8:AM 0158-560"
{
        Type  "S0"
        RA            1.9969
        Dec         -55.8244
        Distance    1.47e+08  # distance uncertain!
        Radius     2.566e+04
        AbsMag        -19.07
        Axis    [  0.5394   0.4875  -0.6866]
        Angle    162.3100
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 795"
}

Galaxy "NGC 797:UGC 1541:MCG 6-5-78:ZWG 522.105"
{
        Type  "SBa"
        RA            2.0575
        Dec          38.1175
        Distance   2.455e+08  # method: V
        Radius     5.714e+04
        AbsMag        -20.78
        Axis    [  0.2383   0.9688  -0.0678]
        Angle    136.9885
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 797"
}

Galaxy "NGC 798:UGC 1539:MCG 5-5-48:ZWG 503.78"
{
        Type  "E0"
        RA            2.0553
        Dec          32.0775
        Distance   2.884e+08  # distance uncertain!
        Radius     5.034e+04
        AbsMag        -20.13
        Axis    [  0.3508   0.8021  -0.4833]
        Angle    202.7260
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 798"
}

Galaxy "NGC 799:UGC 1527:MCG 0-6-23:ZWG 387.29"
{
        Type  "SBa"
        RA            2.0367
        Dec          -0.1003
        Distance    2.52e+08  # method: V
        Radius     7.329e+04
        AbsMag        -20.14
        Axis    [  0.4535   0.8114  -0.3687]
        Angle    167.8974
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 799"
}

Galaxy "NGC 800:UGC 1526:MCG 0-6-24:ZWG 387.28"
{
        Type  "Sc"
        RA            2.0364
        Dec          -0.1308
        Distance   2.573e+08  # method: V
        Radius     3.742e+04
        AbsMag        -20.68
        Axis    [  0.6543   0.6772   0.3365]
        Angle    136.4984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 800"
}

Galaxy "NGC 801:UGC 1550:MCG 6-5-79:ZWG 522.106"
{
        Type  "Sc"
        RA            2.0622
        Dec          38.2594
        Distance   1.902e+08  # method: T-F
        Radius     8.577e+04
        AbsMag        -19.93
        Axis    [ -0.3614   0.7539  -0.5487]
        Angle    165.6048
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 801"
}

Galaxy "NGC 802:ESO 52-13:AM 0157-680"
{
        Type  "SBa"
        RA            1.9850
        Dec         -67.8703
        Distance   6.505e+07  # method: V
        Radius          8515
        AbsMag         -17.8
        Axis    [  0.5802   0.3285  -0.7453]
        Angle    162.6679
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 802"
}

Galaxy "NGC 803:UGC 1554:MCG 3-6-28:ZWG 461.38"
{
        Type  "Sc"
        RA            2.0622
        Dec          16.0311
        Distance   7.031e+07  # method: T-F
        Radius     3.068e+04
        AbsMag        -18.47
        Axis    [  0.2870   0.8319   0.4750]
        Angle    139.0367
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 803"
}

Galaxy "NGC 804:IC 1773:UGC 1557:MCG 5-5-49"
{
        Type  "S0"
        RA            2.0672
        Dec          30.8325
        Distance   1.851e+08  # distance uncertain!
        Radius     3.769e+04
        AbsMag        -19.07
        Axis    [  0.0678   0.8277   0.5570]
        Angle    137.0263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 804"
}

Galaxy "NGC 805:UGC 1566:MCG 5-5-50:ZWG 503.82"
{
        Type  "S0"
        RA            2.0747
        Dec          28.8128
        Distance    2.44e+08  # distance uncertain!
        Radius     3.904e+04
        AbsMag        -19.07
        Axis    [  0.0331   0.9209  -0.3885]
        Angle    163.0201
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 805"
}

Galaxy "NGC 806-1:MCG 2-6-21:KUG 0201-101:IRAS 02010-1010"
{
        Type  "Sc"
        RA            2.0586
        Dec          -9.9328
        Distance   1.668e+08  # method: V
        Radius      2.91e+04
        AbsMag        -18.74
        Axis    [  0.3058   0.9520   0.0097]
        Angle    156.7274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 806-1"
}

Galaxy "NGC 806-2:MCG 2-6-21"
{
        Type  "S0"
        RA            2.0589
        Dec          -9.9294
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [  0.4044   0.9145  -0.0120]
        Angle    156.7360
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 806-2"
}

Galaxy "NGC 807:UGC 1571:MCG 5-6-1:ZWG 503.84"
{
        Type  "E0"
        RA            2.0819
        Dec          28.9878
        Distance   2.029e+08  # method: V
        Radius     5.312e+04
        AbsMag        -20.47
        Axis    [  0.3374   0.7796  -0.5276]
        Angle    208.8387
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 807"
}

Galaxy "NGC 808:ESO 478-1:MCG 4-6-3:AM 0201-233"
{
        Type  "SBc"
        RA            2.0656
        Dec         -23.3122
        Distance   1.404e+08  # distance uncertain!
        Radius     2.451e+04
        AbsMag        -19.07
        Axis    [  0.5028   0.7590   0.4136]
        Angle    169.4909
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 808"
}

Galaxy "NGC 809:MCG 2-6-23"
{
        Type  "S0"
        RA            2.0717
        Dec          -8.7350
        Distance   2.337e+08  # method: V
        Radius     4.079e+04
        AbsMag        -19.48
        Axis    [  0.1195   0.5110  -0.8512]
        Angle    187.1469
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 809"
}

Galaxy "NGC 810-1:UGC 1583:MCG 2-6-26:ZWG 438.24"
{
        Type  "E0"
        RA            2.0911
        Dec          13.2511
        Distance   3.312e+08  # distance uncertain!
        Radius     8.188e+04
        AbsMag        -20.13
        Axis    [  0.7851   0.6145   0.0781]
        Angle    126.3338
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 810-1"
}

Galaxy "NGC 810-2:UGC 1583:MCG 2-6-26:ZWG 438.24"
{
        Type  "E0"
        RA            2.0914
        Dec          13.2511
        Distance   6.919e+08  # distance uncertain!
        Radius     2.013e+04
        AbsMag        -20.13
        Axis    [  0.6148   0.7091  -0.3453]
        Angle    173.6601
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 810-2"
}

Galaxy "NGC 811:MCG 2-6-24:KUG 0202-103"
{
        Type  "Sc"
        RA            2.0761
        Dec         -10.1083
        Distance    2.44e+08  # distance uncertain!
        Radius     3.904e+04
        AbsMag        -19.07
        Axis    [  0.5165   0.8360   0.1854]
        Angle    154.8028
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 811"
}

Galaxy "NGC 812:UGC 1598:MCG 7-5-14:ZWG 538.19"
{
        Type  "Sc"
        RA            2.1142
        Dec          44.5725
        Distance   2.245e+08  # method: V
        Radius     7.184e+04
        AbsMag        -21.79
        Axis    [ -0.3415   0.7368  -0.5836]
        Angle    178.6594
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 812"
}

Galaxy "NGC 813:ESO 52-16"
{
        Type  "SBa"
        RA            2.0267
        Dec         -68.4392
        Distance   3.667e+08  # method: V
        Radius     6.934e+04
        AbsMag        -21.45
        Axis    [  0.7777   0.4908  -0.3927]
        Angle    178.2982
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 813"
}

Galaxy "NGC 814:MCG 3-6-10:IRAS 02082-1600"
{
        Type  "S0"
        RA            2.1769
        Dec         -15.7733
        Distance   6.098e+07  # method: V
        Radius     1.242e+04
        AbsMag        -16.56
        Axis    [  0.4456   0.7748   0.4485]
        Angle    164.8786
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 814"
}

Galaxy "NGC 815"
{
        Type  "E0"
        RA            2.1775
        Dec         -15.8128
        Distance   6.919e+08  # distance uncertain!
        Radius     4.025e+04
        AbsMag        -20.13
        Axis    [  0.6063   0.4945  -0.6228]
        Angle    201.8673
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 815"
}

Galaxy "NGC 816:ZWG 504.16:NPM 1:KUG 0205+290"
{
        Type  "E0"
        RA            2.1356
        Dec          29.2564
        Distance   3.802e+08  # distance uncertain!
        Radius     2.212e+04
        AbsMag        -20.13
        Axis    [  0.7709   0.6036   0.2037]
        Angle     99.0466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 816"
}

Galaxy "NGC 817:UGC 1611:MCG 3-6-33:ZWG 461.47"
{
        Type  "S0"
        RA            2.1258
        Dec          17.2019
        Distance   1.928e+08  # method: V
        Radius     1.963e+04
        AbsMag        -19.76
        Axis    [  0.2471   0.9128   0.3252]
        Angle    138.5552
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 817"
}

Galaxy "NGC 818:UGC 1633:MCG 6-5-86:ZWG 522.116"
{
        Type  "SBc"
        RA            2.1456
        Dec          38.7772
        Distance       2e+08  # method: T-F
        Radius     8.436e+04
        AbsMag        -20.74
        Axis    [ -0.1767   0.9311  -0.3193]
        Angle    155.1834
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 818"
}

Galaxy "NGC 819:UGC 1632:ZWG 504.17:KUG 0205+289"
{
        Type  "S0"
        RA            2.1428
        Dec          29.2347
        Distance   2.867e+08  # method: V
        Radius     2.502e+04
        AbsMag        -20.42
        Axis    [  0.3568   0.8362   0.4165]
        Angle    120.1735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 819"
}

Galaxy "NGC 820:UGC 1629:MCG 2-6-36:ZWG 438.31"
{
        Type  "Sb"
        RA            2.1400
        Dec          14.3497
        Distance   1.884e+08  # method: V
        Radius     3.835e+04
        AbsMag        -20.11
        Axis    [  0.2433   0.9656  -0.0919]
        Angle    146.7657
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 820"
}

Galaxy "NGC 821:UGC 1631:MCG 2-6-34:ZWG 438.33"
{
        Type  "E6"
        RA            2.1392
        Dec          10.9942
        Distance    7.86e+07  # method: S
        Radius     2.744e+04
        AbsMag        -20.11
        Axis    [  0.7970   0.5985   0.0810]
        Angle    127.4978
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 821"
}

Galaxy "NGC 822:ESO 298-9:MCG 7-5-8"
{
        Type  "E0"
        RA            2.1108
        Dec         -41.1569
        Distance   1.864e+08  # method: T-F
        Radius     2.982e+04
        AbsMag        -19.68
        Axis    [  0.9120   0.3446  -0.2223]
        Angle    183.2873
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 822"
}

Galaxy "NGC 823:IC 1782:ESO 478-2:MCG 4-6-5"
{
        Type  "S0"
        RA            2.1222
        Dec         -25.4417
        Distance   1.906e+08  # method: V
        Radius     4.713e+04
        AbsMag        -20.03
        Axis    [  0.5621   0.7165  -0.4132]
        Angle    169.4431
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 823"
}

Galaxy "NGC 824:ESO 354-37:MCG 6-5-28"
{
        Type  "SBc"
        RA            2.1147
        Dec         -36.4533
        Distance   2.557e+08  # method: V
        Radius     5.207e+04
        AbsMag        -20.37
        Axis    [  0.7662   0.6039   0.2199]
        Angle    169.4752
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 824"
}

Galaxy "NGC 825:UGC 1636:MCG 1-6-45:ZWG 413.46"
{
        Type  "Sa"
        RA            2.1422
        Dec           6.3233
        Distance   1.415e+08  # method: V
        Radius     4.115e+04
        AbsMag        -18.99
        Axis    [  0.1469   0.9819   0.1193]
        Angle    148.4785
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 825"
}

Galaxy "NGC 826-1:ZWG 504.19"
{
        Type  "S0"
        RA            2.1569
        Dec          30.7394
        Distance   2.555e+08  # distance uncertain!
        Radius     2.973e+04
        AbsMag        -19.07
        Axis    [  0.3753   0.9247  -0.0636]
        Angle    136.3559
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 826-1"
}

Galaxy "NGC 826-2:ZWG 504.19"
{
        Type  "S0"
        RA            2.1567
        Dec          30.7436
        Distance   3.369e+08  # distance uncertain!
        Radius      1.47e+04
        AbsMag        -19.07
        Axis    [ -0.2223   0.8249  -0.5196]
        Angle    163.1419
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 826-2"
}

Galaxy "NGC 827:UGC 1640:MCG 1-6-46:ZWG 413.47"
{
        Type  "Sc"
        RA            2.1489
        Dec           7.9717
        Distance   1.446e+08  # method: V
        Radius     4.206e+04
        AbsMag        -19.43
        Axis    [  0.0910   0.9820  -0.1655]
        Angle    148.4610
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 827"
}

Galaxy "NGC 828:UGC 1655:MCG 6-5-92:ZWG 522.125"
{
        Type  "Sa"
        RA            2.1692
        Dec          39.1911
        Distance   2.329e+08  # method: V
        Radius     8.468e+04
        AbsMag        -21.17
        Axis    [ -0.1219   0.8547  -0.5046]
        Angle    176.8165
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 828"
}

Galaxy "NGC 829:MCG 1-6-49:KUG 0206-080A:IRAS 02062-0801"
{
        Type  "Sc"
        RA            2.1450
        Dec          -7.7903
        Distance   1.722e+08  # method: V
        Radius     2.755e+04
        AbsMag        -19.21
        Axis    [  0.4208   0.9070  -0.0185]
        Angle    154.6023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 829"
}

Galaxy "NGC 830:MCG 1-6-50:MK 1020"
{
        Type  "S0"
        RA            2.1494
        Dec          -7.7675
        Distance   1.646e+08  # method: V
        Radius     3.351e+04
        AbsMag        -19.21
        Axis    [  0.4531   0.8810  -0.1362]
        Angle    156.3212
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 830"
}

Galaxy "NGC 831:ZWG 413.49:KUG 0206+058"
{
        Type  "S0"
        RA            2.1594
        Dec           6.0967
        Distance    2.44e+08  # distance uncertain!
        Radius      1.42e+04
        AbsMag        -19.07
        Axis    [  0.3306   0.8689  -0.3685]
        Angle    162.0593
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 831"
}

Galaxy "NGC 833:MCG 2-6-30:ARP 318:MCG 2-6-30"
{
        Type  "Sa"
        RA            2.1556
        Dec         -10.1328
        Distance   1.668e+08  # method: V
        Radius     3.639e+04
        AbsMag        -19.84
        Axis    [  0.3383   0.9131  -0.2275]
        Angle    155.9158
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 833"
}

Galaxy "NGC 834:UGC 1672:MCG 6-5-99:ZWG 522.128"
{
        Type  "Sc"
        RA            2.1836
        Dec          37.6661
        Distance   1.842e+08  # method: T-F
        Radius     2.948e+04
        AbsMag        -19.96
        Axis    [  0.1508   0.8999   0.4092]
        Angle    122.0835
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 834"
}

Galaxy "NGC 835:MCG 2-6-31:MK 1021:ARP 318"
{
        Type  "SBb"
        RA            2.1567
        Dec         -10.1353
        Distance   1.752e+08  # method: V
        Radius     3.312e+04
        AbsMag        -20.65
        Axis    [  0.6598   0.6843   0.3105]
        Angle    147.0962
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 835"
}

Galaxy "NGC 836:ESO 544-17:MCG 4-6-12:NPM 1"
{
        Type  "Sa"
        RA            2.1733
        Dec         -22.0550
        Distance   1.612e+08  # distance uncertain!
        Radius     2.814e+04
        AbsMag        -19.07
        Axis    [  0.5041   0.7224  -0.4734]
        Angle    168.6714
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 836"
}

Galaxy "NGC 837:ESO 478-10:MCG 4-6-11:AM 0207-224"
{
        Type  "Sb"
        RA            2.1711
        Dec         -22.4314
        Distance   1.938e+08  # distance uncertain!
        Radius     2.537e+04
        AbsMag        -19.07
        Axis    [  0.4843   0.7913   0.3732]
        Angle    168.6839
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 837"
}

Galaxy "NGC 838:MCG 2-6-33:MK 1022:ARP 318"
{
        Type  "S0"
        RA            2.1606
        Dec         -10.1458
        Distance   1.626e+08  # method: V
        Radius     2.838e+04
        AbsMag        -19.49
        Axis    [  0.5024   0.8240  -0.2621]
        Angle    161.2678
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 838"
}

Galaxy "NGC 839:MCG 2-6-34:ARP 318:HCG 16"
{
        Type  "S0"
        RA            2.1617
        Dec         -10.1833
        Distance   1.623e+08  # method: V
        Radius     3.305e+04
        AbsMag        -19.38
        Axis    [  0.3600   0.9058  -0.2235]
        Angle    156.3421
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 839"
}

Galaxy "NGC 840:UGC 1664:MCG 1-6-49:ZWG 413.53"
{
        Type  "SBb"
        RA            2.1711
        Dec           7.8458
        Distance   3.803e+08  # method: T-F
        Radius     9.957e+04
        AbsMag        -21.03
        Axis    [  0.2834   0.9528  -0.1088]
        Angle    148.9700
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 840"
}

Galaxy "NGC 841:UGC 1676:MCG 6-5-101:ZWG 522.131"
{
        Type  "SBb"
        RA            2.1881
        Dec          37.4975
        Distance   1.946e+08  # method: T-F
        Radius     5.095e+04
        AbsMag        -20.48
        Axis    [ -0.1419   0.8684  -0.4751]
        Angle    169.7010
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 841"
}

Galaxy "NGC 842:MCG 1-6-55"
{
        Type  "S0"
        RA            2.1639
        Dec          -7.7625
        Distance   1.562e+08  # method: V
        Radius     3.636e+04
        AbsMag         -19.7
        Axis    [  0.1274   0.6982  -0.7045]
        Angle    164.1296
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 842"
}

Galaxy "NGC 844:ZWG 413.52"
{
        Type  "E0"
        RA            2.1706
        Dec           6.0500
        Distance   3.468e+08  # distance uncertain!
        Radius     2.017e+04
        AbsMag        -20.13
        Axis    [  0.8269   0.4857   0.2833]
        Angle    117.4368
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 844"
}

Galaxy "NGC 845:UGC 1695:MCG 6-5-104:ZWG 522.135"
{
        Type  "Sb"
        RA            2.2053
        Dec          37.4775
        Distance   1.612e+08  # distance uncertain!
        Radius     3.986e+04
        AbsMag        -19.07
        Axis    [ -0.3512   0.7644  -0.5406]
        Angle    163.5751
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 845"
}

Galaxy "NGC 846:NGC 847:UGC 1688:MCG 7-5-24"
{
        Type  "SBb"
        RA            2.2033
        Dec          44.5681
        Distance   2.219e+08  # method: V
        Radius     6.132e+04
        AbsMag        -21.06
        Axis    [  0.0282   0.8811  -0.4721]
        Angle    188.2552
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 846"
}

Galaxy "NGC 848:MCG 2-6-36:MK 1026:ARP 318"
{
        Type  "SBb"
        RA            2.1714
        Dec         -10.3206
        Distance   1.649e+08  # method: V
        Radius     3.597e+04
        AbsMag        -19.72
        Axis    [  0.2815   0.7281  -0.6251]
        Angle    169.0137
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 848"
}

Galaxy "NGC 849:ESO 478-9:NPM 1"
{
        Type  "S0"
        RA            2.1697
        Dec         -22.3231
        Distance   3.072e+08  # distance uncertain!
        Radius     2.234e+04
        AbsMag        -19.07
        Axis    [  0.4048   0.7549  -0.5160]
        Angle    163.3981
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 849"
}

Galaxy "NGC 850:UGC 1679:MCG 0-6-49:ZWG 387.53"
{
        Type  "Sa"
        RA            2.1869
        Dec          -1.4850
        Distance    3.58e+08  # method: V
        Radius     6.248e+04
        AbsMag         -21.3
        Axis    [  0.5697   0.7732  -0.2785]
        Angle    162.8908
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 850"
}

Galaxy "NGC 851:UGC 1680:MCG 1-6-54:MK 588"
{
        Type  "Sa"
        RA            2.1867
        Dec           3.7797
        Distance   1.291e+08  # method: V
        Radius     1.877e+04
        AbsMag        -18.39
        Axis    [  0.1421   0.7950  -0.5897]
        Angle    167.0315
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 851"
}

Galaxy "NGC 852:ESO 153-26"
{
        Type  "SBc"
        RA            2.1486
        Dec         -56.7367
        Distance   2.773e+08  # method: T-F
        Radius     5.243e+04
        AbsMag        -20.45
        Axis    [  0.8357   0.5112  -0.2006]
        Angle    181.9613
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 852"
}

Galaxy "NGC 853:MCG 2-6-38:KUG 0209-095:IRAS 02092-0932"
{
        Type  "Irr"
        RA            2.1947
        Dec          -9.3053
        Distance   5.567e+07  # method: V
        Radius     1.296e+04
        AbsMag        -17.66
        Axis    [  0.6260   0.7649  -0.1520]
        Angle    158.9420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 853"
}

Galaxy "NGC 854:ESO 354-47:MCG 6-5-38:AM 0209-360"
{
        Type  "SBc"
        RA            2.1917
        Dec         -35.8356
        Distance   2.338e+08  # method: T-F
        Radius     6.121e+04
        AbsMag        -20.48
        Axis    [  0.4755   0.7635   0.4369]
        Angle    185.8053
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 854"
}

Galaxy "NGC 855:UGC 1718:MCG 5-6-16:ZWG 504.35"
{
        Type  "E0"
        RA            2.2342
        Dec          27.8778
        Distance   3.173e+07  # method: S
        Radius       1.2e+04
        AbsMag        -16.64
        Axis    [  0.6245   0.7579  -0.1888]
        Angle    142.9170
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 855"
}

Galaxy "NGC 856:NGC 859:UGC 1713:MCG 0-6-54"
{
        Type  "Sa"
        RA            2.2272
        Dec          -0.7167
        Distance   2.599e+08  # method: V
        Radius     4.915e+04
        AbsMag        -20.31
        Axis    [  0.5244   0.7952   0.3043]
        Angle    144.0162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 856"
}

Galaxy "NGC 857:ESO 415-6:MCG 5-6-8"
{
        Type  "S0"
        RA            2.2103
        Dec         -31.9444
        Distance   1.492e+08  # method: V
        Radius     3.255e+04
        AbsMag         -19.9
        Axis    [  0.6912   0.6316  -0.3511]
        Angle    172.8622
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 857"
}

Galaxy "NGC 858-1:ESO 478-13:MCG 4-6-16:AM 0210-224"
{
        Type  "SBc"
        RA            2.2083
        Dec         -22.4714
        Distance   5.495e+08  # method: V
        Radius     1.039e+05
        AbsMag        -21.93
        Axis    [  0.6859   0.5877   0.4291]
        Angle    155.6505
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 858-1"
}

Galaxy "NGC 858-2:ESO 478-13:MCG 4-6-16:AM 0210-224"
{
        Type  "S0"
        RA            2.2092
        Dec         -22.4694
        Distance   4.241e+08  # distance uncertain!
        Radius      1.85e+04
        AbsMag        -19.07
        Axis    [  0.1320   0.6127  -0.7792]
        Angle    151.2602
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 858-2"
}

Galaxy "NGC 860:ZWG 504.37:NPM 1"
{
        Type  "E0"
        RA            2.2500
        Dec          30.7794
        Distance   3.802e+08  # distance uncertain!
        Radius     2.765e+04
        AbsMag        -20.13
        Axis    [  0.3497   0.7922  -0.5001]
        Angle    200.9115
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 860"
}

Galaxy "NGC 861:UGC 1737:MCG 6-6-3:ZWG 523.5"
{
        Type  "Sb"
        RA            2.2642
        Dec          35.9139
        Distance    3.52e+08  # method: T-F
        Radius     7.679e+04
        AbsMag        -20.46
        Axis    [  0.0365   0.9551   0.2941]
        Angle    128.7604
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 861"
}

Galaxy "NGC 862:ESO 298-20:MCG 7-5-12:AM 0211-421"
{
        Type  "E0"
        RA            2.2172
        Dec         -42.0336
        Distance   2.329e+08  # method: V
        Radius      2.71e+04
        AbsMag        -21.37
        Axis    [  0.8752   0.2823   0.3928]
        Angle    158.4566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 862"
}

Galaxy "NGC 863:NGC 866:NGC 885:UGC 1727"
{
        Type  "Sa"
        RA            2.2425
        Dec          -0.7661
        Distance    3.47e+08  # method: V
        Radius     5.552e+04
        AbsMag        -21.23
        Axis    [  0.6050   0.7802  -0.1593]
        Angle    155.0221
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 863"
}

Galaxy "NGC 864:UGC 1736:MCG 1-6-61:ZWG 413.66"
{
        Type  "SBc"
        RA            2.2575
        Dec           6.0019
        Distance   5.898e+07  # method: V
        Radius     4.032e+04
        AbsMag        -19.58
        Axis    [  0.5279   0.7965   0.2949]
        Angle    137.1218
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 864"
}

Galaxy "NGC 865:UGC 1747:MCG 5-6-20:ZWG 504.42"
{
        Type  "S0"
        RA            2.2708
        Dec          28.6008
        Distance   1.436e+08  # method: T-F
        Radius     3.134e+04
        AbsMag        -19.12
        Axis    [ -0.2948   0.6844  -0.6669]
        Angle    167.3145
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 865"
}

Galaxy "NGC 867:NGC 875:UGC 1760:MCG 0-6-60"
{
        Type  "Sa"
        RA            2.2844
        Dec           1.2447
        Distance   2.797e+08  # method: V
        Radius     4.882e+04
        AbsMag        -20.67
        Axis    [  0.4831   0.7676  -0.4211]
        Angle    169.8309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 867"
}

Galaxy "NGC 868:UGC 1748:ZWG 387.63"
{
        Type  "S0"
        RA            2.2661
        Dec          -0.7128
        Distance   2.226e+08  # distance uncertain!
        Radius     4.208e+04
        AbsMag        -19.07
        Axis    [  0.4189   0.8437  -0.3356]
        Angle    160.2640
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 868"
}

Galaxy "NGC 870:MCG 2-6-52"
{
        Type  "E0"
        RA            2.2858
        Dec          14.5228
        Distance   6.919e+08  # distance uncertain!
        Radius     3.019e+04
        AbsMag        -20.13
        Axis    [  0.8210   0.5131   0.2505]
        Angle    109.8454
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 870"
}

Galaxy "NGC 871:UGC 1759:MCG 2-6-53:ZWG 438.46"
{
        Type  "SBc"
        RA            2.2861
        Dec          14.5475
        Distance   1.577e+08  # method: V
        Radius     2.524e+04
        AbsMag        -19.32
        Axis    [  0.3369   0.7989   0.4982]
        Angle    137.6517
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 871"
}

Galaxy "NGC 872:ESO 544-32:MCG 3-6-19"
{
        Type  "Sc"
        RA            2.2569
        Dec         -17.7819
        Distance   1.704e+08  # method: T-F
        Radius     3.718e+04
        AbsMag        -19.09
        Axis    [  0.0422   0.5365  -0.8429]
        Angle    153.0406
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 872"
}

Galaxy "NGC 873:MCG 2-6-48:IRAS 02140-1134"
{
        Type  "Sc"
        RA            2.2756
        Dec         -11.3486
        Distance   1.709e+08  # method: V
        Radius     3.976e+04
        AbsMag         -20.3
        Axis    [  0.3169   0.6451  -0.6952]
        Angle    178.7006
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 873"
}

Galaxy "NGC 874:ESO 478-18:MCG 4-6-19"
{
        Type  "Sb"
        RA            2.2672
        Dec         -23.3058
        Distance   2.226e+08  # distance uncertain!
        Radius     2.913e+04
        AbsMag        -19.07
        Axis    [  0.1543   0.4955  -0.8548]
        Angle    164.2125
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 874"
}

Galaxy "NGC 876:UGC 1766:MCG 2-6-57"
{
        Type  "Sc"
        RA            2.2981
        Dec          14.5211
        Distance   1.634e+08  # method: V
        Radius     4.752e+04
        AbsMag           -19
        Axis    [  0.1371   0.8937   0.4271]
        Angle    146.3584
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 876"
}

Galaxy "NGC 877:UGC 1768:MCG 2-6-58:ZWG 438.52"
{
        Type  "SBc"
        RA            2.2997
        Dec          14.5439
        Distance   1.658e+08  # method: V
        Radius     5.786e+04
        AbsMag        -20.93
        Axis    [  0.1517   0.7891  -0.5952]
        Angle    178.1906
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 877"
}

Galaxy "NGC 878:ESO 478-22:MCG 4-6-21:IRAS 02156-2336"
{
        Type  "Sa"
        RA            2.2983
        Dec         -23.3844
        Distance   1.768e+08  # distance uncertain!
        Radius     2.057e+04
        AbsMag        -19.07
        Axis    [  0.4404   0.7533  -0.4885]
        Angle    162.4464
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 878"
}

Galaxy "NGC 879:KUG 0214-091"
{
        Type  "Irr"
        RA            2.2808
        Dec          -8.9636
        Distance   3.981e+08  # distance uncertain!
        Radius     4.054e+04
        AbsMag        -20.13
        Axis    [  0.6688   0.6375   0.3825]
        Angle    143.2449
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 879"
}

Galaxy "NGC 880"
{
        Type  "S0"
        RA            2.3075
        Dec          -4.2053
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [  0.5856   0.7378   0.3356]
        Angle    143.9401
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 880"
}

Galaxy "NGC 881:MCG 1-6-89:IRAS 02160-0650"
{
        Type  "Sc"
        RA            2.3125
        Dec          -6.6394
        Distance   9.278e+07  # distance uncertain!
        Radius     3.104e+04
        AbsMag        -19.07
        Axis    [  0.2429   0.7450  -0.6213]
        Angle    166.6566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 881"
}

Galaxy "NGC 882:UGC 1789:MCG 3-6-52:ZWG 462.1"
{
        Type  "S0"
        RA            2.3275
        Dec          15.8147
        Distance    2.03e+08  # distance uncertain!
        Radius     3.543e+04
        AbsMag        -19.07
        Axis    [  0.1656   0.9731  -0.1605]
        Angle    145.6274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 882"
}

Galaxy "NGC 883:MCG 1-6-90"
{
        Type  "S0"
        RA            2.3181
        Dec          -6.7906
        Distance   1.115e+08  # distance uncertain!
        Radius     1.947e+04
        AbsMag        -19.07
        Axis    [  0.6203   0.7420  -0.2541]
        Angle    161.3031
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 883"
}

Galaxy "NGC 887:MCG 3-7-1:IRAS 02171-1617"
{
        Type  "SBc"
        RA            2.3256
        Dec         -16.0692
        Distance   1.848e+08  # method: V
        Radius     5.375e+04
        AbsMag        -20.37
        Axis    [  0.6570   0.6443   0.3915]
        Angle    151.5411
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 887"
}

Galaxy "NGC 888:ESO 115-2:AM 0215-600"
{
        Type  "E1"
        RA            2.2908
        Dec         -59.8606
        Distance   2.754e+08  # distance uncertain!
        Radius     3.205e+04
        AbsMag        -20.13
        Axis    [  0.8841   0.2106   0.4171]
        Angle    174.0749
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 888"
}

Galaxy "NGC 889:ESO 298-27:MCG 7-5-16"
{
        Type  "E0"
        RA            2.3183
        Dec         -41.7492
        Distance   2.308e+08  # method: V
        Radius     3.357e+04
        AbsMag        -19.85
        Axis    [  0.8365   0.3194  -0.4454]
        Angle    190.7770
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 889"
}

Galaxy "NGC 890:UGC 1823:MCG 5-6-30:ZWG 504.64"
{
        Type  "S0"
        RA            2.3669
        Dec          33.2664
        Distance   1.711e+08  # method: V
        Radius     6.223e+04
        AbsMag         -21.3
        Axis    [  0.2319   0.9713   0.0528]
        Angle    129.2353
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 890"
}

Galaxy "NGC 891:UGC 1831:MCG 7-5-46:ZWG 538.52"
{
        Type  "Sb"
        RA            2.3758
        Dec          42.3472
        Distance   2.725e+07  # method: S
        Radius     4.638e+04
        AbsMag        -18.71
        Axis    [ -0.0400   0.8707   0.4902]
        Angle    127.1011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 891"
}

Galaxy "NGC 892:ESO 478-26"
{
        Type  "Sb"
        RA            2.3478
        Dec         -23.1136
        Distance   2.934e+08  # distance uncertain!
        Radius      2.56e+04
        AbsMag        -19.07
        Axis    [  0.6094   0.6879   0.3942]
        Angle    162.1965
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 892"
}

Galaxy "NGC 893:ESO 298-29:MCG 7-5-17:AM 0217-413"
{
        Type  "Sc"
        RA            2.3328
        Dec         -41.4028
        Distance   2.497e+08  # method: T-F
        Radius     4.721e+04
        AbsMag        -20.82
        Axis    [  0.6307   0.5248  -0.5716]
        Angle    175.1425
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 893"
}

Galaxy "NGC 895:MCG 1-7-2:IRAS 02191-0544"
{
        Type  "Sc"
        RA            2.3600
        Dec          -5.5211
        Distance   9.386e+07  # method: T-F
        Radius     4.915e+04
        AbsMag        -19.89
        Axis    [  0.3077   0.7649  -0.5659]
        Angle    167.0914
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 895"
}

Galaxy "NGC 897:ESO 355-7:MCG 6-6-3:AM 0218-335"
{
        Type  "Sa"
        RA            2.3517
        Dec         -33.7208
        Distance   2.091e+08  # method: V
        Radius     6.385e+04
        AbsMag        -21.13
        Axis    [  0.6359   0.7136   0.2941]
        Angle    171.3549
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 897"
}

Galaxy "NGC 898:UGC 1842:MCG 7-6-4:ZWG 538.58"
{
        Type  "Sb"
        RA            2.3889
        Dec          41.9517
        Distance   2.352e+08  # method: V
        Radius     6.158e+04
        AbsMag        -20.39
        Axis    [ -0.4223   0.6488  -0.6330]
        Angle    171.1816
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 898"
}

Galaxy "NGC 899:ESO 545-7:MCG 4-6-30:UGCA 26"
{
        Type  "Irr"
        RA            2.3647
        Dec         -20.8231
        Distance   6.138e+07  # method: V
        Radius     1.607e+04
        AbsMag        -18.27
        Axis    [  0.4552   0.7189  -0.5253]
        Angle    165.6983
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 899"
}

Galaxy "NGC 900:UGC 1843:MCG 4-6-20:ZWG 483.23"
{
        Type  "S0"
        RA            2.3922
        Dec          26.5119
        Distance   2.226e+08  # distance uncertain!
        Radius     3.561e+04
        AbsMag        -19.07
        Axis    [  0.3301   0.9078   0.2587]
        Angle    125.2840
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 900"
}

Galaxy "NGC 901"
{
        Type  "E0"
        RA            2.3928
        Dec          26.5567
        Distance   5.012e+08  # distance uncertain!
        Radius     2.916e+04
        AbsMag        -20.13
        Axis    [  0.8028   0.5603   0.2040]
        Angle     99.4241
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 901"
}

Galaxy "NGC 902:MCG 3-7-5"
{
        Type  "SBc"
        RA            2.3725
        Dec         -16.6789
        Distance   1.938e+08  # distance uncertain!
        Radius     1.692e+04
        AbsMag        -19.07
        Axis    [  0.6923   0.6565   0.2996]
        Angle    151.3644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 902"
}

Galaxy "NGC 903:NPM 1"
{
        Type  "S0"
        RA            2.4000
        Dec          27.3569
        Distance    4.65e+08  # distance uncertain!
        Radius     3.381e+04
        AbsMag        -19.07
        Axis    [ -0.1669   0.6735  -0.7201]
        Angle    186.7865
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 903"
}

Galaxy "NGC 904:UGC 1852:MCG 4-6-24:ZWG 483.28"
{
        Type  "E0"
        RA            2.4014
        Dec          27.3431
        Distance   3.631e+08  # distance uncertain!
        Radius     6.337e+04
        AbsMag        -20.13
        Axis    [  0.3976   0.7758  -0.4900]
        Angle    192.8900
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 904"
}

Galaxy "NGC 905:NPM 1"
{
        Type  "Sa"
        RA            2.3786
        Dec          -8.7186
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [  0.3084   0.8168  -0.4876]
        Angle    159.2295
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 905"
}

Galaxy "NGC 906:UGC 1868:MCG 7-6-12:ZWG 539.14"
{
        Type  "SBb"
        RA            2.4211
        Dec          42.0903
        Distance   2.024e+08  # method: V
        Radius     5.298e+04
        AbsMag        -20.16
        Axis    [  0.0264   0.8671  -0.4974]
        Angle    186.6962
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 906"
}

Galaxy "NGC 907:ESO 545-10:MCG 4-6-34:UGCA 28"
{
        Type  "SBc"
        RA            2.3836
        Dec         -20.7114
        Distance   7.298e+07  # method: T-F
        Radius     1.911e+04
        AbsMag        -18.55
        Axis    [  0.3448   0.9036  -0.2542]
        Angle    153.5580
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 907"
}

Galaxy "NGC 908:ESO 545-11:MCG 4-6-35:UGCA 29"
{
        Type  "SBc"
        RA            2.3844
        Dec         -21.2333
        Distance   6.587e+07  # method: T-F
        Radius     5.844e+04
        AbsMag        -20.62
        Axis    [  0.4369   0.8838  -0.1676]
        Angle    156.8107
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 908"
}

Galaxy "NGC 909:UGC 1872:MCG 7-6-13:ZWG 539.16"
{
        Type  "E0"
        RA            2.4228
        Dec          42.0361
        Distance   2.126e+08  # method: V
        Radius     2.783e+04
        AbsMag        -19.37
        Axis    [  0.7557   0.6400   0.1391]
        Angle     87.1200
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 909"
}

Galaxy "NGC 910:UGC 1875:MCG 7-6-14:ZWG 539.17"
{
        Type  "E0"
        RA            2.4239
        Dec          41.8242
        Distance   2.228e+08  # method: V
        Radius     5.186e+04
        AbsMag        -20.97
        Axis    [  0.7566   0.6387   0.1401]
        Angle     87.2714
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 910"
}

Galaxy "NGC 911:UGC 1878:MCG 7-6-16:ZWG 539.21"
{
        Type  "E0"
        RA            2.4283
        Dec          41.9567
        Distance   2.445e+08  # method: V
        Radius     4.624e+04
        AbsMag        -20.57
        Axis    [  0.3612   0.8478  -0.3882]
        Angle    177.9452
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 911"
}

Galaxy "NGC 912:MCG 7-6-15:ZWG 539.20:NPM 1"
{
        Type  "S0"
        RA            2.4283
        Dec          41.7781
        Distance   2.226e+08  # distance uncertain!
        Radius     2.913e+04
        AbsMag        -19.07
        Axis    [ -0.0065   0.8410  -0.5409]
        Angle    193.8378
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 912"
}

Galaxy "NGC 913"
{
        Type  "S0"
        RA            2.4289
        Dec          41.7992
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [  0.0999   0.9073   0.4085]
        Angle    119.1800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 913"
}

Galaxy "NGC 914:UGC 1887:MCG 7-6-17:ZWG 539.23"
{
        Type  "Sc"
        RA            2.4347
        Dec          42.1447
        Distance   2.417e+08  # method: V
        Radius     5.274e+04
        AbsMag        -20.65
        Axis    [ -0.0143   0.9311  -0.3645]
        Angle    161.4913
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 914"
}

Galaxy "NGC 915:MCG 4-6-33:ZWG 483.41:NPM 1"
{
        Type  "S0"
        RA            2.4292
        Dec          27.2217
        Distance    2.33e+08  # distance uncertain!
        Radius     2.373e+04
        AbsMag        -19.07
        Axis    [  0.7858   0.5776   0.2214]
        Angle     99.2853
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 915"
}

Galaxy "NGC 916:MCG 4-6-34:ZWG 483.43:NPM 1"
{
        Type  "S0"
        RA            2.4297
        Dec          27.2431
        Distance   3.527e+08  # distance uncertain!
        Radius     4.617e+04
        AbsMag        -19.07
        Axis    [  0.2330   0.7827   0.5772]
        Angle    130.9775
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 916"
}

Galaxy "NGC 917:UGC 1890:MCG 5-6-39:ZWG 504.79"
{
        Type  "Sb"
        RA            2.4353
        Dec          31.9122
        Distance   2.625e+08  # method: T-F
        Radius     9.544e+04
        AbsMag        -20.03
        Axis    [  0.1392   0.9859   0.0927]
        Angle    130.2512
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 917"
}

Galaxy "NGC 918:UGC 1888:MCG 3-7-11:ZWG 462.11"
{
        Type  "SBc"
        RA            2.4306
        Dec          18.4958
        Distance   7.121e+07  # method: T-F
        Radius     3.625e+04
        AbsMag        -18.59
        Axis    [ -0.0702   0.7350  -0.6744]
        Angle    173.7214
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 918"
}

Galaxy "NGC 919:UGC 1894:MCG 4-6-39:ZWG 483.49"
{
        Type  "Sb"
        RA            2.4378
        Dec          27.2114
        Distance   5.064e+08  # method: T-F
        Radius     8.839e+04
        AbsMag        -20.55
        Axis    [ -0.2490   0.8270  -0.5040]
        Angle    153.8940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 919"
}

Galaxy "NGC 920:UGC 1920:MCG 8-5-11:ZWG 553.12"
{
        Type  "SBb"
        RA            2.4642
        Dec          45.9469
        Distance   2.719e+08  # method: V
        Radius     5.932e+04
        AbsMag         -19.4
        Axis    [ -0.1543   0.8323  -0.5323]
        Angle    186.1180
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 920"
}

Galaxy "NGC 921:MCG 3-7-15"
{
        Type  "Sc"
        RA            2.4425
        Dec         -15.8475
        Distance   2.125e+08  # distance uncertain!
        Radius     4.328e+04
        AbsMag        -19.07
        Axis    [  0.3711   0.8984  -0.2350]
        Angle    153.1637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 921"
}

Galaxy "NGC 922:ESO 478-28:MCG 4-6-37:UGCA 30"
{
        Type  "SBc"
        RA            2.4175
        Dec         -24.7892
        Distance   1.307e+08  # method: V
        Radius     3.802e+04
        AbsMag        -20.51
        Axis    [  0.2387   0.4506  -0.8602]
        Angle    179.1771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 922"
}

Galaxy "NGC 923:UGC 1915:MCG 7-6-22:ZWG 539.30"
{
        Type  "Sb"
        RA            2.4594
        Dec          41.9781
        Distance   2.456e+08  # method: V
        Radius     2.857e+04
        AbsMag        -19.88
        Axis    [  0.0722   0.9680  -0.2404]
        Angle    147.5497
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 923"
}

Galaxy "NGC 924:UGC 1912:MCG 3-7-12:ZWG 462.12"
{
        Type  "S0"
        RA            2.4461
        Dec          20.4972
        Distance   2.003e+08  # method: V
        Radius       6.7e+04
        AbsMag        -20.44
        Axis    [  0.2656   0.9611   0.0759]
        Angle    134.9180
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 924"
}

Galaxy "NGC 925:UGC 1913:MCG 5-6-45:ZWG 504.85"
{
        Type  "SBc"
        RA            2.4544
        Dec          33.5789
        Distance   2.727e+07  # method: T-F
        Radius     4.165e+04
        AbsMag        -19.01
        Axis    [ -0.0083   0.9609  -0.2769]
        Angle    148.7585
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 925"
}

Galaxy "NGC 926:UGC 1901:MCG 0-7-11:ZWG 388.14"
{
        Type  "SBc"
        RA            2.4350
        Dec          -0.3325
        Distance   2.828e+08  # method: V
        Radius     7.403e+04
        AbsMag        -20.69
        Axis    [  0.4408   0.8774   0.1894]
        Angle    145.3990
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 926"
}

Galaxy "NGC 927:UGC 1908:MCG 2-7-9:MK 593"
{
        Type  "SBc"
        RA            2.4436
        Dec          12.1553
        Distance   3.631e+08  # method: V
        Radius     6.337e+04
        AbsMag        -21.03
        Axis    [  0.8218   0.5040   0.2658]
        Angle    111.7345
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 927"
}

Galaxy "NGC 928:MCG 4-6-50:ZWG 483.60"
{
        Type  "S0"
        RA            2.4611
        Dec          27.2208
        Distance   2.216e+08  # method: V
        Radius     2.256e+04
        AbsMag        -19.36
        Axis    [  0.1883   0.9415   0.2796]
        Angle    129.1627
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 928"
}

Galaxy "NGC 929:MCG 2-7-9"
{
        Type  "Sa"
        RA            2.4550
        Dec         -12.0872
        Distance   2.226e+08  # distance uncertain!
        Radius     3.237e+04
        AbsMag        -19.07
        Axis    [  0.0972   0.5561  -0.8254]
        Angle    168.5606
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 929"
}

Galaxy "NGC 931:UGC 1935:MCG 5-6-49:MK 1040"
{
        Type  "Sc"
        RA            2.4706
        Dec          31.3111
        Distance   1.743e+08  # method: T-F
        Radius     9.888e+04
        AbsMag        -19.34
        Axis    [ -0.1443   0.9884   0.0469]
        Angle    135.7528
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 931"
}

Galaxy "NGC 932:UGC 1931:MCG 3-7-14:ZWG 462.14"
{
        Type  "Sa"
        RA            2.4650
        Dec          20.3331
        Distance   1.739e+08  # method: V
        Radius     4.806e+04
        AbsMag        -20.23
        Axis    [  0.4948   0.8658   0.0749]
        Angle    129.3691
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 932"
}

Galaxy "NGC 933:UGC 1956:MCG 8-5-13:ZWG 553.16"
{
        Type  "S0"
        RA            2.4881
        Dec          45.9119
        Distance   2.225e+08  # method: V
        Radius     4.207e+04
        AbsMag        -19.07
        Axis    [  0.2148   0.9524   0.2164]
        Angle    112.4984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 933"
}

Galaxy "NGC 934:UGC 1926:MCG 0-7-16:ZWG 388.17"
{
        Type  "S0"
        RA            2.4589
        Dec          -0.2442
        Distance   2.768e+08  # method: V
        Radius     5.234e+04
        AbsMag        -20.54
        Axis    [  0.2339   0.7799  -0.5805]
        Angle    165.5429
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 934"
}

Galaxy "NGC 935:UGC 1937:MCG 3-7-15:ZWG 462.16"
{
        Type  "Sc"
        RA            2.4697
        Dec          19.5992
        Distance   1.771e+08  # method: V
        Radius     4.378e+04
        AbsMag        -19.97
        Axis    [ -0.0312   0.7541  -0.6560]
        Angle    175.9836
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 935"
}

Galaxy "NGC 936:UGC 1929:MCG 0-7-17:ZWG 388.18"
{
        Type  "SBa"
        RA            2.4603
        Dec          -1.1564
        Distance   7.507e+07  # method: S
        Radius     5.131e+04
        AbsMag        -20.71
        Axis    [  0.3301   0.7114  -0.6204]
        Angle    177.8626
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 936"
}

Galaxy "NGC 937:UGC 1961:MCG 7-6-24:ZWG 539.32"
{
        Type  "SBc"
        RA            2.4911
        Dec          42.2497
        Distance    2.03e+08  # distance uncertain!
        Radius     3.247e+04
        AbsMag        -19.07
        Axis    [ -0.1903   0.9245  -0.3303]
        Angle    153.1797
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 937"
}

Galaxy "NGC 938:UGC 1947:MCG 3-7-17:ZWG 462.17"
{
        Type  "E0"
        RA            2.4758
        Dec          20.2839
        Distance   1.744e+08  # method: V
        Radius     4.059e+04
        AbsMag        -20.14
        Axis    [  0.5539   0.7371  -0.3871]
        Angle    170.5823
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 938"
}

Galaxy "NGC 939:ESO 246-11:MCG 7-6-4"
{
        Type  "E0"
        RA            2.4392
        Dec         -44.4464
        Distance   2.298e+08  # method: V
        Radius      4.01e+04
        AbsMag        -20.14
        Axis    [  0.8112   0.2881  -0.5088]
        Angle    192.6569
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 939"
}

Galaxy "NGC 940:UGC 1964:MCG 5-6-50:ZWG 504.95"
{
        Type  "S0"
        RA            2.4908
        Dec          31.6414
        Distance   2.203e+08  # method: V
        Radius     3.846e+04
        AbsMag        -20.65
        Axis    [  0.4411   0.8056   0.3956]
        Angle    112.0388
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 940"
}

Galaxy "NGC 941:UGC 1954:MCG 0-7-22:ZWG 388.23"
{
        Type  "SBc"
        RA            2.4742
        Dec          -1.1511
        Distance   6.197e+07  # method: V
        Radius     2.434e+04
        AbsMag        -18.49
        Axis    [  0.0530   0.5998  -0.7984]
        Angle    176.5617
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 941"
}

Galaxy "NGC 942:MCG 2-7-18:VV 217:ARP 309"
{
        Type  "Sa"
        RA            2.4861
        Dec         -10.8356
        Distance   1.281e+08  # distance uncertain!
        Radius     5.215e+04
        AbsMag        -19.07
        Axis    [  0.4550   0.8697   0.1916]
        Angle    153.3526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 942"
}

Galaxy "NGC 943:MCG 2-7-19:VV 217:ARP 309"
{
        Type  "E0"
        RA            2.4858
        Dec         -10.8281
        Distance   2.089e+08  # distance uncertain!
        Radius     8.509e+04
        AbsMag        -20.13
        Axis    [  0.8844   0.4286   0.1849]
        Angle    136.5672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 943"
}

Galaxy "NGC 944:IC 228:MCG 3-7-16:IRAS 02242-1444"
{
        Type  "Sa"
        RA            2.4447
        Dec         -14.5158
        Distance    2.03e+08  # distance uncertain!
        Radius     3.247e+04
        AbsMag        -19.07
        Axis    [  0.4309   0.8273   0.3604]
        Angle    161.4689
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 944"
}

Galaxy "NGC 945:MCG 2-7-13:IRAS 02261-1045"
{
        Type  "SBc"
        RA            2.4769
        Dec         -10.5389
        Distance   1.927e+08  # method: V
        Radius     6.447e+04
        AbsMag        -21.06
        Axis    [  0.7796   0.5548   0.2906]
        Angle    139.5168
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 945"
}

Galaxy "NGC 946:UGC 1979:MCG 7-6-26:ZWG 539.34"
{
        Type  "S0"
        RA            2.5106
        Dec          42.2331
        Distance   2.471e+08  # method: V
        Radius      5.39e+04
        AbsMag         -19.7
        Axis    [  0.1171   0.9930  -0.0129]
        Angle    128.5943
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 946"
}

Galaxy "NGC 947:ESO 545-21:MCG 3-7-22:IRAS 02262-1915"
{
        Type  "SBc"
        RA            2.4758
        Dec         -19.0422
        Distance   2.017e+08  # method: T-F
        Radius      6.16e+04
        AbsMag        -20.66
        Axis    [  0.5154   0.8561   0.0386]
        Angle    157.0737
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 947"
}

Galaxy "NGC 948:MCG 2-7-15"
{
        Type  "SBc"
        RA            2.4792
        Dec         -10.5139
        Distance   1.939e+08  # method: V
        Radius     3.949e+04
        AbsMag        -19.47
        Axis    [  0.6478   0.6859   0.3314]
        Angle    146.6176
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 948"
}

Galaxy "NGC 949:UGC 1983:MCG 6-6-48:ZWG 523.53"
{
        Type  "Sb"
        RA            2.5133
        Dec          37.1358
        Distance   3.677e+07  # method: S
        Radius     1.604e+04
        AbsMag        -17.86
        Axis    [ -0.1923   0.8178  -0.5425]
        Angle    171.1139
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 949"
}

Galaxy "NGC 950:MCG 2-7-21"
{
        Type  "Sb"
        RA            2.4864
        Dec         -11.0250
        Distance   2.024e+08  # method: V
        Radius     3.826e+04
        AbsMag        -19.36
        Axis    [  0.5346   0.8358   0.1250]
        Angle    151.5251
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 950"
}

Galaxy "NGC 951:ESO 479-8:MCG 4-7-1:AM 0226-223"
{
        Type  "SBb"
        RA            2.4822
        Dec         -22.3492
        Distance   2.692e+08  # method: V
        Radius     3.915e+04
        AbsMag        -19.08
        Axis    [  0.5785   0.8147   0.0404]
        Angle    158.9758
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 951"
}

Galaxy "NGC 953:UGC 1991:MCG 5-7-1:ZWG 504.104"
{
        Type  "E0"
        RA            2.5192
        Dec          29.5889
        Distance   2.754e+08  # distance uncertain!
        Radius     5.208e+04
        AbsMag        -20.13
        Axis    [  0.8064   0.5609   0.1875]
        Angle     96.1569
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 953"
}

Galaxy "NGC 954:ESO 299-4:MCG 7-6-6:IRAS 02268-4137"
{
        Type  "SBc"
        RA            2.4808
        Dec         -41.4025
        Distance   2.179e+08  # method: T-F
        Radius     5.071e+04
        AbsMag        -20.42
        Axis    [  0.6208   0.7405   0.2576]
        Angle    178.5536
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 954"
}

Galaxy "NGC 955:UGC 1986:MCG 0-7-27A:ZWG 388.29"
{
        Type  "Sb"
        RA            2.5092
        Dec          -1.1083
        Distance   5.735e+07  # method: V
        Radius     2.419e+04
        AbsMag        -18.32
        Axis    [  0.3356   0.8671   0.3681]
        Angle    151.3123
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 955"
}

Galaxy "NGC 958:MCG 1-7-19:IRAS 02281-0309"
{
        Type  "SBc"
        RA            2.5117
        Dec          -2.9408
        Distance   2.492e+08  # method: V
        Radius     1.051e+05
        AbsMag        -21.52
        Axis    [  0.3565   0.8282   0.4324]
        Angle    154.3008
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 958"
}

Galaxy "NGC 959:UGC 2002:MCG 6-6-51:ZWG 523.55"
{
        Type  "Irr"
        RA            2.5400
        Dec          35.4950
        Distance    5.83e+07  # method: T-F
        Radius      1.95e+04
        AbsMag        -18.36
        Axis    [  0.1376   0.9905  -0.0074]
        Angle    130.7222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 959"
}

Galaxy "NGC 960:MCG 2-7-28"
{
        Type  "Sb"
        RA            2.5281
        Dec          -9.3003
        Distance   2.125e+08  # distance uncertain!
        Radius      3.71e+04
        AbsMag        -19.07
        Axis    [  0.0889   0.8469  -0.5242]
        Angle    144.4804
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 960"
}

Galaxy "NGC 961:NGC 1051:IC 249:MCG 1-7-33"
{
        Type  "Irr"
        RA            2.6839
        Dec          -6.9356
        Distance   4.893e+07  # method: V
        Radius     1.352e+04
        AbsMag        -17.48
        Axis    [  0.5828   0.8124   0.0184]
        Angle    146.6231
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 961"
}

Galaxy "NGC 962:UGC 2013:MCG 5-7-4:ZWG 505.3"
{
        Type  "E0"
        RA            2.5442
        Dec          28.0708
        Distance   2.188e+08  # distance uncertain!
        Radius     4.455e+04
        AbsMag        -20.13
        Axis    [  0.1846   0.7347  -0.6528]
        Angle    225.0936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 962"
}

Galaxy "NGC 963:IC 1808:MCG 1-7-17:KUG 0228-044"
{
        Type  "Irr"
        RA            2.5086
        Dec          -4.2156
        Distance   2.754e+08  # distance uncertain!
        Radius     2.804e+04
        AbsMag        -20.13
        Axis    [  0.8527   0.4271   0.3010]
        Angle    125.5294
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 963"
}

Galaxy "NGC 964:IC 1814:ESO 355-24:MCG 6-6-10"
{
        Type  "Sb"
        RA            2.5181
        Dec         -36.0347
        Distance   2.088e+08  # method: V
        Radius     6.377e+04
        AbsMag        -20.53
        Axis    [  0.4585   0.8707   0.1779]
        Angle    174.7480
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 964"
}

Galaxy "NGC 965:ESO 545-32:MCG 3-7-31"
{
        Type  "Sc"
        RA            2.5403
        Dec         -18.6403
        Distance    2.03e+08  # distance uncertain!
        Radius     2.952e+04
        AbsMag        -19.07
        Axis    [  0.6883   0.6430   0.3359]
        Angle    152.5953
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 965"
}

Galaxy "NGC 966:ESO 545-30:MCG 3-7-29"
{
        Type  "S0"
        RA            2.5297
        Dec         -19.8817
        Distance    1.54e+08  # distance uncertain!
        Radius     2.239e+04
        AbsMag        -19.07
        Axis    [  0.5682   0.6402  -0.5170]
        Angle    172.3000
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 966"
}

Galaxy "NGC 967:ESO 545-31:MCG 3-7-30:NPM 1"
{
        Type  "S0"
        RA            2.5367
        Dec         -17.2164
        Distance   1.115e+08  # distance uncertain!
        Radius     2.596e+04
        AbsMag        -19.07
        Axis    [  0.5828   0.7943   0.1718]
        Angle    155.3469
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 967"
}

Galaxy "NGC 968:UGC 2040:MCG 6-6-56:ZWG 523.61"
{
        Type  "E0"
        RA            2.5683
        Dec          34.4806
        Distance   1.551e+08  # method: V
        Radius     6.089e+04
        AbsMag        -19.78
        Axis    [  0.6048   0.7713  -0.1985]
        Angle    133.6602
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 968"
}

Galaxy "NGC 969:UGC 2039:MCG 5-7-8:ZWG 505.10"
{
        Type  "S0"
        RA            2.5689
        Dec          32.9464
        Distance   1.949e+08  # method: V
        Radius      4.82e+04
        AbsMag        -20.58
        Axis    [  0.3529   0.7870   0.5061]
        Angle    115.1953
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 969"
}

Galaxy "NGC 970:MCG 5-7-9:ZWG 505.11"
{
        Type  "S0"
        RA            2.5697
        Dec          32.9764
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [ -0.0099   0.9859   0.1673]
        Angle    130.3002
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 970"
}

Galaxy "NGC 972:UGC 2045:MCG 5-7-10:ZWG 505.12"
{
        Type  "Sb"
        RA            2.5703
        Dec          29.3103
        Distance   6.238e+07  # method: T-F
        Radius     2.994e+04
        AbsMag        -19.31
        Axis    [ -0.1747   0.7843  -0.5952]
        Angle    168.2019
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 972"
}

Galaxy "NGC 973:UGC 2048:MCG 5-7-13:ZWG 505.14"
{
        Type  "Sb"
        RA            2.5722
        Dec          32.5056
        Distance   2.151e+08  # method: T-F
        Radius     1.157e+05
        AbsMag        -20.49
        Axis    [ -0.0557   0.9639   0.2602]
        Angle    131.6365
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 973"
}

Galaxy "NGC 974:UGC 2049:MCG 5-7-12:ZWG 505.15"
{
        Type  "Sb"
        RA            2.5736
        Dec          32.9550
        Distance   1.948e+08  # method: V
        Radius     4.818e+04
        AbsMag        -20.28
        Axis    [  0.2347   0.9717  -0.0277]
        Angle    130.5617
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 974"
}

Galaxy "NGC 975:UGC 2030:MCG 1-7-9:ZWG 414.17"
{
        Type  "Sa"
        RA            2.5561
        Dec           9.6019
        Distance   2.661e+08  # method: V
        Radius     4.257e+04
        AbsMag        -20.46
        Axis    [  0.5461   0.7022   0.4569]
        Angle    129.7504
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 975"
}

Galaxy "NGC 976:UGC 2042:MCG 3-7-27:ZWG 462.27"
{
        Type  "Sc"
        RA            2.5664
        Dec          20.9772
        Distance   1.842e+08  # method: V
        Radius     4.286e+04
        AbsMag        -20.46
        Axis    [  0.0231   0.7306  -0.6824]
        Angle    188.2999
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 976"
}

Galaxy "NGC 977:MCG 2-7-31"
{
        Type  "Sa"
        RA            2.5508
        Dec         -10.7594
        Distance   1.958e+08  # method: V
        Radius     5.695e+04
        AbsMag        -19.49
        Axis    [  0.6622   0.7205   0.2058]
        Angle    147.1761
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 977"
}

Galaxy "NGC 978A:NGC 978:UGC 2057:MCG 5-7-16"
{
        Type  "S0"
        RA            2.5797
        Dec          32.8450
        Distance   2.034e+08  # method: V
        Radius     3.847e+04
        AbsMag        -20.77
        Axis    [  0.2864   0.9571  -0.0429]
        Angle    130.2496
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 978A"
}

Galaxy "NGC 978B:MCG 5-7-17:KCPG 71B"
{
        Type  "S0"
        RA            2.5800
        Dec          32.8425
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [ -0.2296   0.7233  -0.6513]
        Angle    176.8783
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 978B"
}

Galaxy "NGC 979:ESO 246-23:MCG 7-6-14:AM 0229-444"
{
        Type  "S0"
        RA            2.5272
        Dec         -44.5242
        Distance   1.223e+08  # distance uncertain!
        Radius     1.601e+04
        AbsMag        -19.07
        Axis    [  0.7302   0.5540   0.3999]
        Angle    176.8589
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 979"
}

Galaxy "NGC 980:UGC 2063:MCG 7-6-38:ZWG 539.54"
{
        Type  "S0"
        RA            2.5883
        Dec          40.9269
        Distance   1.404e+08  # distance uncertain!
        Radius     3.472e+04
        AbsMag        -19.07
        Axis    [ -0.1135   0.9477  -0.2984]
        Angle    149.7305
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 980"
}

Galaxy "NGC 981:MCG 2-7-30:KUG 0230-111:IRAS 02305-1111"
{
        Type  "Sc"
        RA            2.5497
        Dec         -10.9736
        Distance   1.851e+08  # distance uncertain!
        Radius     2.692e+04
        AbsMag        -19.07
        Axis    [  0.5498   0.7244   0.4159]
        Angle    152.3447
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 981"
}

Galaxy "NGC 982:UGC 2066:MCG 7-6-39:ZWG 539.56"
{
        Type  "Sa"
        RA            2.5900
        Dec          40.8694
        Distance   2.511e+08  # method: V
        Radius     5.478e+04
        AbsMag        -21.03
        Axis    [ -0.2514   0.8708  -0.4226]
        Angle    157.7491
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 982"
}

Galaxy "NGC 983:NGC 1002:UGC 2133:MCG 6-6-70"
{
        Type  "SBb"
        RA            2.6486
        Dec          34.6219
        Distance   2.072e+08  # method: V
        Radius     3.616e+04
        AbsMag        -20.01
        Axis    [ -0.0466   0.8355  -0.5475]
        Angle    176.8374
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 983"
}

Galaxy "NGC 984:UGC 2059:MCG 4-7-12:ZWG 484.10"
{
        Type  "Sa"
        RA            2.5786
        Dec          23.4136
        Distance   1.869e+08  # method: V
        Radius     5.436e+04
        AbsMag        -19.29
        Axis    [  0.0370   0.8985  -0.4373]
        Angle    156.7246
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 984"
}

Galaxy "NGC 985:MCG 2-7-35:MK 1048:VV 285"
{
        Type  "S0"
        RA            2.5769
        Dec          -8.7850
        Distance   5.755e+08  # method: V
        Radius      8.37e+04
        AbsMag        -21.73
        Axis    [  0.6554   0.7326  -0.1839]
        Angle    154.9001
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 985"
}

Galaxy "NGC 986:ESO 299-7:MCG 7-6-15:AM 0231-391"
{
        Type  "SBb"
        RA            2.5594
        Dec         -39.0458
        Distance   8.358e+07  # method: V
        Radius     4.863e+04
        AbsMag        -20.44
        Axis    [  0.4316   0.4545  -0.7792]
        Angle    171.2174
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 986"
}

Galaxy "NGC 986A:MCG 7-6-14A:ESO 299-6A:AM 0230-393"
{
        Type  "Irr"
        RA            2.5450
        Dec         -39.2953
        Distance   5.649e+07  # method: V
        Radius     1.479e+04
        AbsMag        -16.59
        Axis    [  0.5330   0.8213  -0.2032]
        Angle    161.7664
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 986A"
}

Galaxy "NGC 987:UGC 2093:MCG 5-7-21:MK 1180"
{
        Type  "SBa"
        RA            2.6136
        Dec          33.3272
        Distance   1.957e+08  # method: V
        Radius     4.555e+04
        AbsMag        -20.49
        Axis    [  0.3075   0.9357   0.1730]
        Angle    120.2050
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 987"
}

Galaxy "NGC 988:MCG 2-7-37:UGCA 35:IRAS 02330-0934"
{
        Type  "SBc"
        RA            2.5908
        Dec          -9.3550
        Distance   5.799e+07  # method: V
        Radius     3.458e+04
        AbsMag        -19.55
        Axis    [  0.2077   0.8608  -0.4647]
        Angle    148.8213
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 988"
}

Galaxy "NGC 989:MCG 3-7-34:NPM 1"
{
        Type  "S0"
        RA            2.5628
        Dec         -16.5114
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [  0.6479   0.7116  -0.2719]
        Angle    161.0697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 989"
}

Galaxy "NGC 990:UGC 2089:MCG 2-7-18:ZWG 439.19"
{
        Type  "E0"
        RA            2.6050
        Dec          11.6422
        Distance   1.483e+08  # method: V
        Radius     3.883e+04
        AbsMag        -19.79
        Axis    [  0.7893   0.6098  -0.0719]
        Angle    133.4804
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 990"
}

Galaxy "NGC 991:MCG 1-7-23:IRAS 02330-0722:KUG 0233-073"
{
        Type  "SBc"
        RA            2.5922
        Dec          -7.1550
        Distance   5.925e+07  # method: V
        Radius     2.585e+04
        AbsMag         -18.9
        Axis    [  0.6702   0.7338  -0.1113]
        Angle    151.0363
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 991"
}

Galaxy "NGC 992:UGC 2103:MCG 3-7-35:ZWG 462.35"
{
        Type  "Sc"
        RA            2.6236
        Dec          21.1003
        Distance   1.772e+08  # method: V
        Radius      2.32e+04
        AbsMag        -18.78
        Axis    [  0.5327   0.7502   0.3917]
        Angle    118.2261
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 992"
}

Galaxy "NGC 993:NGC 994:UGC 2095:MCG 0-7-52"
{
        Type  "S0"
        RA            2.6128
        Dec           2.0503
        Distance   3.063e+08  # method: V
        Radius     4.009e+04
        AbsMag        -20.16
        Axis    [  0.4302   0.7723  -0.4675]
        Angle    165.8968
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 993"
}

Galaxy "NGC 995:UGC 2118:MCG 7-6-44:ZWG 539.63"
{
        Type  "S0"
        RA            2.6419
        Dec          41.5289
        Distance   1.688e+08  # distance uncertain!
        Radius     3.192e+04
        AbsMag        -19.07
        Axis    [  0.1158   0.9455   0.3044]
        Angle    117.8641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 995"
}

Galaxy "NGC 996:UGC 2123:MCG 7-6-45:ZWG 539.64"
{
        Type  "E0"
        RA            2.6442
        Dec          41.6472
        Distance   2.291e+08  # distance uncertain!
        Radius     3.999e+04
        AbsMag        -20.13
        Axis    [  0.7803   0.6107   0.1349]
        Angle     85.6940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 996"
}

Galaxy "NGC 997:UGC 2102:MCG 1-7-16:ZWG 414.27"
{
        Type  "E0"
        RA            2.6206
        Dec           7.3061
        Distance   2.631e+08  # distance uncertain!
        Radius     4.209e+04
        AbsMag        -20.13
        Axis    [  0.8603   0.4431   0.2520]
        Angle    114.2176
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 997"
}

Galaxy "NGC 998:MCG 1-7-15:ZWG 414.28"
{
        Type  "S0"
        RA            2.6211
        Dec           7.3358
        Distance   2.802e+08  # distance uncertain!
        Radius      3.26e+04
        AbsMag        -19.07
        Axis    [ -0.0552   0.5964  -0.8008]
        Angle    177.7979
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 998"
}

Galaxy "NGC 999:UGC 2127:MCG 7-6-47:NPM 1"
{
        Type  "SBa"
        RA            2.6464
        Dec          41.6711
        Distance   1.688e+08  # distance uncertain!
        Radius     2.947e+04
        AbsMag        -19.07
        Axis    [  0.1954   0.9734   0.1199]
        Angle    118.9522
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 999"
}

Galaxy "NGC 1000:MCG 7-6-48:ZWG 539.67:NPM 1"
{
        Type  "E0"
        RA            2.6469
        Dec          41.4603
        Distance   4.571e+08  # distance uncertain!
        Radius     4.654e+04
        AbsMag        -20.13
        Axis    [  0.7813   0.6092   0.1356]
        Angle     85.8189
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1000"
}

Galaxy "NGC 1001:MCG 7-6-50:ZWG 539.69"
{
        Type  "Sc"
        RA            2.6533
        Dec          41.6717
        Distance   2.802e+08  # distance uncertain!
        Radius     2.853e+04
        AbsMag        -19.07
        Axis    [ -0.2421   0.8746  -0.4201]
        Angle    157.8447
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1001"
}

Galaxy "NGC 1003:UGC 2137:MCG 7-6-51:ZWG 539.70"
{
        Type  "Sc"
        RA            2.6544
        Dec          40.8728
        Distance    4.43e+07  # method: T-F
        Radius     2.771e+04
        AbsMag        -18.66
        Axis    [ -0.2119   0.9643  -0.1590]
        Angle    138.9382
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1003"
}

Galaxy "NGC 1004:UGC 2112:MCG 0-7-57:ZWG 388.68"
{
        Type  "E0"
        RA            2.6281
        Dec           1.9756
        Distance    2.83e+08  # method: V
        Radius     5.763e+04
        AbsMag        -20.89
        Axis    [  0.5942   0.6237  -0.5078]
        Angle    183.5558
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1004"
}

Galaxy "NGC 1005:MCG 7-6-52:ZWG 539.71"
{
        Type  "S0"
        RA            2.6575
        Dec          41.4933
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.2325   0.9705  -0.0640]
        Angle    127.3087
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1005"
}

Galaxy "NGC 1006:NGC 1010:MCG 2-7-44:IRAS 02351-1114"
{
        Type  "Sc"
        RA            2.6261
        Dec         -11.0253
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.8689   0.3889   0.3062]
        Angle    131.0832
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1006"
}

Galaxy "NGC 1007:MCG 0-7-59:ZWG 388.69"
{
        Type  "Irr"
        RA            2.6311
        Dec           2.1556
        Distance   7.944e+08  # distance uncertain!
        Radius     6.932e+04
        AbsMag        -20.13
        Axis    [  0.2838   0.9499   0.1308]
        Angle    143.9579
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1007"
}

Galaxy "NGC 1008:UGC 2114:MCG 0-7-60:ZWG 388.70"
{
        Type  "E0"
        RA            2.6319
        Dec           2.0803
        Distance   2.882e+08  # method: V
        Radius     3.353e+04
        AbsMag        -19.83
        Axis    [  0.7107   0.6160  -0.3398]
        Angle    164.8185
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1008"
}

Galaxy "NGC 1009:UGC 2129:MCG 0-7-65:ZWG 388.77"
{
        Type  "Sb"
        RA            2.6383
        Dec           2.3100
        Distance   2.536e+08  # method: V
        Radius     5.165e+04
        AbsMag        -19.15
        Axis    [ -0.0531   0.8792  -0.4735]
        Angle    140.8206
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1009"
}

Galaxy "NGC 1011:MCG 2-7-45:NPM 1"
{
        Type  "Sa"
        RA            2.6272
        Dec         -11.0050
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [  0.8690   0.3888   0.3061]
        Angle    131.0612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1011"
}

Galaxy "NGC 1012:UGC 2141:MCG 5-7-27:ZWG 505.30"
{
        Type  "Sa"
        RA            2.6539
        Dec          30.1514
        Distance    6.27e+07  # method: T-F
        Radius      2.28e+04
        AbsMag        -18.32
        Axis    [  0.2292   0.8971   0.3778]
        Angle    123.5765
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1012"
}

Galaxy "NGC 1013:MCG 2-7-46:NPM 1"
{
        Type  "Sa"
        RA            2.6306
        Dec         -11.5067
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.5521   0.8072  -0.2088]
        Angle    153.8948
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1013"
}

Galaxy "NGC 1015:UGC 2124:MCG 0-7-66:ZWG 388.75"
{
        Type  "SBa"
        RA            2.6364
        Dec          -1.3183
        Distance   1.089e+08  # method: V
        Radius     3.167e+04
        AbsMag        -19.52
        Axis    [  0.6711   0.6882   0.2757]
        Angle    136.1366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1015"
}

Galaxy "NGC 1016:UGC 2128:MCG 0-7-67:ZWG 388.76"
{
        Type  "E0"
        RA            2.6386
        Dec           2.1192
        Distance   2.298e+08  # method: T-F
        Radius     6.686e+04
        AbsMag        -21.64
        Axis    [  0.8687   0.4190   0.2641]
        Angle    118.6229
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1016"
}

Galaxy "NGC 1017:MCG 2-7-47:KUG 0235-112B"
{
        Type  "Irr"
        RA            2.6303
        Dec         -11.0106
        Distance   3.468e+08  # distance uncertain!
        Radius      3.53e+04
        AbsMag        -20.13
        Axis    [  0.6801   0.7329  -0.0201]
        Angle    149.9958
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1017"
}

Galaxy "NGC 1018:MCG 2-7-48"
{
        Type  "SBa"
        RA            2.6361
        Dec          -9.5442
        Distance   2.934e+08  # distance uncertain!
        Radius     4.267e+04
        AbsMag        -19.07
        Axis    [  0.0685   0.5656  -0.8218]
        Angle    167.2073
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1018"
}

Galaxy "NGC 1019:UGC 2132:MCG 0-7-68:ZWG 388.79"
{
        Type  "SBc"
        RA            2.6408
        Dec           1.9081
        Distance   3.181e+08  # method: V
        Radius     4.626e+04
        AbsMag        -20.55
        Axis    [  0.6686   0.7417   0.0531]
        Angle    138.4931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1019"
}

Galaxy "NGC 1020:ZWG 388.81"
{
        Type  "S0"
        RA            2.6456
        Dec           2.2311
        Distance    2.33e+08  # distance uncertain!
        Radius     2.712e+04
        AbsMag        -19.07
        Axis    [  0.2881   0.8797   0.3783]
        Angle    149.2896
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1020"
}

Galaxy "NGC 1021:ZWG 388.84"
{
        Type  "Sc"
        RA            2.6464
        Dec           2.2172
        Distance   2.226e+08  # distance uncertain!
        Radius     2.266e+04
        AbsMag        -19.07
        Axis    [  0.0886   0.6616  -0.7446]
        Angle    174.9040
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1021"
}

Galaxy "NGC 1022:MCG 1-7-25:IRAS 02360-0653"
{
        Type  "SBa"
        RA            2.6422
        Dec          -6.6775
        Distance   5.776e+07  # method: V
        Radius     2.016e+04
        AbsMag        -19.04
        Axis    [  0.7439   0.6060   0.2816]
        Angle    137.5393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1022"
}

Galaxy "NGC 1023:UGC 2154:MCG 6-6-73:ZWG 523.83"
{
        Type  "S0"
        RA            2.6733
        Dec          39.0633
        Distance   3.728e+07  # method: S
        Radius     4.012e+04
        AbsMag        -19.79
        Axis    [ -0.1387   0.9857  -0.0953]
        Angle    135.4846
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1023"
}

Galaxy "NGC 1023A"
{
        Type  "Irr"
        RA            2.6767
        Dec          39.0603
        Distance   2.464e+07  # method: V
        Radius          4660
        AbsMag        -15.19
        Axis    [  0.2645   0.8539   0.4482]
        Angle    112.7112
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1023A"
}

Galaxy "NGC 1024:UGC 2142:MCG 2-7-20:ZWG 439.22"
{
        Type  "Sb"
        RA            2.6531
        Dec          10.8478
        Distance   1.494e+08  # method: V
        Radius     8.475e+04
        AbsMag         -20.2
        Axis    [ -0.1031   0.7289  -0.6769]
        Angle    157.9311
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1024"
}

Galaxy "NGC 1025:ESO 154-4:IRAS 02347-5504"
{
        Type  "SBb"
        RA            2.6053
        Dec         -54.8636
        Distance   2.828e+08  # method: V
        Radius     3.702e+04
        AbsMag        -20.79
        Axis    [  0.6836   0.6537   0.3246]
        Angle    191.0950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1025"
}

Galaxy "NGC 1026:UGC 2145:MCG 1-7-18:ZWG 414.33"
{
        Type  "S0"
        RA            2.6553
        Dec           6.5444
        Distance   1.788e+08  # method: V
        Radius     4.422e+04
        AbsMag        -19.99
        Axis    [  0.2914   0.8327  -0.4708]
        Angle    160.1106
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1026"
}

Galaxy "NGC 1028:MCG 2-7-23:ZWG 439.25"
{
        Type  "SBc"
        RA            2.6603
        Dec          10.8433
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.3082   0.8507   0.4258]
        Angle    140.7440
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1028"
}

Galaxy "NGC 1029:UGC 2149:MCG 2-7-24:ZWG 439.24"
{
        Type  "Sa"
        RA            2.6600
        Dec          10.7933
        Distance   1.532e+08  # method: V
        Radius     3.119e+04
        AbsMag        -19.26
        Axis    [  0.1249   0.9919  -0.0250]
        Angle    139.3282
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1029"
}

Galaxy "NGC 1030:UGC 2153:MCG 3-7-39:ZWG 462.39"
{
        Type  "Sc"
        RA            2.6639
        Dec          18.0239
        Distance   3.771e+08  # method: V
        Radius     8.776e+04
        AbsMag        -21.01
        Axis    [  0.3448   0.8086   0.4767]
        Angle    132.2035
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1030"
}

Galaxy "NGC 1031:ESO 154-5:AM 0235-550"
{
        Type  "SBa"
        RA            2.6106
        Dec         -54.8589
        Distance   2.496e+08  # method: V
        Radius     6.898e+04
        AbsMag        -21.02
        Axis    [  0.7199   0.6683   0.1873]
        Angle    185.8343
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1031"
}

Galaxy "NGC 1032:UGC 2147:MCG 0-7-73:ZWG 388.86"
{
        Type  "Sa"
        RA            2.6564
        Dec           1.0939
        Distance   1.098e+08  # method: V
        Radius     5.428e+04
        AbsMag        -19.93
        Axis    [  0.2331   0.9714  -0.0441]
        Angle    143.2644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1032"
}

Galaxy "NGC 1033:MCG 2-7-53:NPM 1"
{
        Type  "Sc"
        RA            2.6711
        Dec          -8.7764
        Distance   3.307e+08  # method: V
        Radius     5.771e+04
        AbsMag        -20.53
        Axis    [  0.6839   0.6050   0.4078]
        Angle    141.1736
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1033"
}

Galaxy "NGC 1034:MCG 3-7-43:IRAS 02358-1601"
{
        Type  "Irr"
        RA            2.6369
        Dec         -15.8092
        Distance   2.884e+08  # distance uncertain!
        Radius     3.356e+04
        AbsMag        -20.13
        Axis    [  0.3779   0.6014  -0.7039]
        Angle    177.5435
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1034"
}

Galaxy "NGC 1035:MCG 1-7-27:IRAS 02370-0820"
{
        Type  "Sc"
        RA            2.6581
        Dec          -8.1325
        Distance   7.783e+07  # method: T-F
        Radius      2.49e+04
        AbsMag        -18.99
        Axis    [  0.0041   0.7180  -0.6961]
        Angle    145.2348
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1035"
}

Galaxy "NGC 1036:IC 1828:UGC 2160:MCG 3-7-41"
{
        Type  "Irr"
        RA            2.6747
        Dec          19.2969
        Distance   2.519e+07  # method: V
        Radius          5495
        AbsMag        -15.74
        Axis    [  0.5228   0.7260   0.4469]
        Angle    120.3269
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1036"
}

Galaxy "NGC 1038:UGC 2158:MCG 0-7-76:ZWG 388.90"
{
        Type  "Sa"
        RA            2.6683
        Dec           1.5094
        Distance   1.612e+08  # distance uncertain!
        Radius     2.814e+04
        AbsMag        -19.07
        Axis    [  0.2569   0.9663   0.0158]
        Angle    143.1470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1038"
}

Galaxy "NGC 1040-1:NGC 1053-1:UGC 2187:MCG 7-6-60"
{
        Type  "S0"
        RA            2.7200
        Dec          41.5003
        Distance   2.093e+08  # method: V
        Radius     5.176e+04
        AbsMag        -20.14
        Axis    [  0.1083   0.9591   0.2617]
        Angle    118.1052
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1040-1"
}

Galaxy "NGC 1040-2:NGC 1053-2:NPM 1"
{
        Type  "S0"
        RA            2.7200
        Dec          41.5150
        Distance   3.868e+08  # distance uncertain!
        Radius      2.25e+04
        AbsMag        -19.07
        Axis    [  0.0857   0.9822   0.1672]
        Angle    120.6825
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1040-2"
}

Galaxy "NGC 1041:MCG 1-7-30:NPM 1"
{
        Type  "S0"
        RA            2.6736
        Dec          -5.4400
        Distance    1.54e+08  # distance uncertain!
        Radius     3.807e+04
        AbsMag        -19.07
        Axis    [  0.5737   0.8173  -0.0545]
        Angle    147.1618
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1041"
}

Galaxy "NGC 1042:MCG 2-7-54:IRAS 02379-0838"
{
        Type  "SBc"
        RA            2.6731
        Dec          -8.4342
        Distance   5.232e+07  # method: V
        Radius     3.272e+04
        AbsMag        -19.32
        Axis    [  0.6908   0.6755   0.2579]
        Angle    142.4456
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1042"
}

Galaxy "NGC 1043:ZWG 388.94"
{
        Type  "Sb"
        RA            2.6794
        Dec           1.3431
        Distance   3.072e+08  # distance uncertain!
        Radius     4.021e+04
        AbsMag        -19.07
        Axis    [  0.0209   0.9275  -0.3734]
        Angle    140.7783
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1043"
}

Galaxy "NGC 1044:MCG 1-7-23:ZWG 414.38:NPM 1"
{
        Type  "S0"
        RA            2.6850
        Dec           8.7386
        Distance   2.805e+08  # method: V
        Radius      2.04e+04
        AbsMag        -20.27
        Axis    [  0.8475   0.4626   0.2604]
        Angle    113.4431
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1044"
}

Galaxy "NGC 1045:MCG 2-7-59"
{
        Type  "S0"
        RA            2.6747
        Dec         -11.2778
        Distance   1.017e+08  # distance uncertain!
        Radius     2.367e+04
        AbsMag        -19.07
        Axis    [  0.6286   0.7726   0.0889]
        Angle    148.5421
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1045"
}

Galaxy "NGC 1046:MCG 1-7-24:ZWG 414.39:NPM 1"
{
        Type  "S0"
        RA            2.6867
        Dec           8.7200
        Distance   1.938e+08  # distance uncertain!
        Radius     1.128e+04
        AbsMag        -19.07
        Axis    [  0.8476   0.4623   0.2603]
        Angle    113.4513
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1046"
}

Galaxy "NGC 1047:MCG 1-7-32"
{
        Type  "Sa"
        RA            2.6756
        Dec          -8.1472
        Distance   5.078e+07  # method: V
        Radius          9602
        AbsMag        -16.56
        Axis    [  0.3262   0.9071  -0.2660]
        Angle    148.0521
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1047"
}

Galaxy "NGC 1048:NGC 1048B:MCG 2-7-62"
{
        Type  "SBa"
        RA            2.6769
        Dec          -8.5336
        Distance   2.676e+08  # distance uncertain!
        Radius     3.892e+04
        AbsMag        -19.07
        Axis    [  0.1942   0.9177  -0.3465]
        Angle    144.5276
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1048"
}

Galaxy "NGC 1048A:MCG 2-7-58"
{
        Type  "SBc"
        RA            2.6764
        Dec          -8.5478
        Distance   2.676e+08  # distance uncertain!
        Radius     2.724e+04
        AbsMag        -19.07
        Axis    [  0.5379   0.7084   0.4569]
        Angle    150.7107
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1048A"
}

Galaxy "NGC 1050:UGC 2178:MCG 6-6-78:ZWG 523.92"
{
        Type  "SBa"
        RA            2.7097
        Dec          34.7642
        Distance   1.667e+08  # method: V
        Radius     4.121e+04
        AbsMag        -20.04
        Axis    [  0.0009   0.9339  -0.3576]
        Angle    152.5853
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1050"
}

Galaxy "NGC 1052:MCG 1-7-34:IRAS 02386-0828"
{
        Type  "E4"
        RA            2.6844
        Dec          -8.2547
        Distance   6.331e+07  # method: S
        Radius     2.578e+04
        AbsMag        -19.94
        Axis    [  0.5901   0.5480  -0.5928]
        Angle    191.1286
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1052"
}

Galaxy "NGC 1054:MCG 3-7-46:ZWG 462.45:IRAS 02394+1800"
{
        Type  "Sc"
        RA            2.7042
        Dec          18.2175
        Distance   4.319e+08  # method: V
        Radius     5.654e+04
        AbsMag        -20.91
        Axis    [  0.3557   0.9023   0.2437]
        Angle    129.5936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1054"
}

Galaxy "NGC 1055:UGC 2173:MCG 0-7-81:ZWG 388.95"
{
        Type  "SBb"
        RA            2.6958
        Dec           0.4428
        Distance   5.536e+07  # method: T-F
        Radius     6.119e+04
        AbsMag        -19.75
        Axis    [  0.1396   0.9202  -0.3658]
        Angle    144.6594
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1055"
}

Galaxy "NGC 1056:UGC 2183:MCG 5-7-32:MK 1183"
{
        Type  "Sa"
        RA            2.7133
        Dec          28.5744
        Distance   6.034e+07  # method: V
        Radius     2.106e+04
        AbsMag        -17.94
        Axis    [ -0.2104   0.7423  -0.6362]
        Angle    168.5540
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1056"
}

Galaxy "NGC 1057:UGC 2184:MCG 5-7-33:ZWG 505.37"
{
        Type  "S0"
        RA            2.7172
        Dec          32.4917
        Distance   3.217e+08  # distance uncertain!
        Radius     5.615e+04
        AbsMag        -19.07
        Axis    [  0.0244   0.9241  -0.3813]
        Angle    154.2122
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1057"
}

Galaxy "NGC 1058:UGC 2193:MCG 6-7-1:ZWG 524.5"
{
        Type  "Sc"
        RA            2.7247
        Dec          37.3414
        Distance   1.441e+07  # method: V
        Radius          5238
        AbsMag        -16.32
        Axis    [  0.7844   0.5946   0.1763]
        Angle     89.0047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1058"
}

Galaxy "NGC 1060:UGC 2191:MCG 5-7-35:ZWG 505.38"
{
        Type  "S0"
        RA            2.7208
        Dec          32.4247
        Distance    2.43e+08  # method: T-F
        Radius      8.13e+04
        AbsMag        -21.36
        Axis    [  0.2261   0.9653  -0.1307]
        Angle    134.7110
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1060"
}

Galaxy "NGC 1061:MCG 5-7-36:ZWG 505.39:KUG 0240+322"
{
        Type  "Irr"
        RA            2.7208
        Dec          32.4672
        Distance    1.73e+08  # method: V
        Radius     2.264e+04
        AbsMag        -18.52
        Axis    [  0.2984   0.9417   0.1553]
        Angle    120.7494
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1061"
}

Galaxy "NGC 1063:MCG 1-7-36:IRAS 02396-0546"
{
        Type  "SBc"
        RA            2.7025
        Dec          -5.5683
        Distance   1.768e+08  # distance uncertain!
        Radius       3.6e+04
        AbsMag        -19.07
        Axis    [  0.1905   0.9041  -0.3824]
        Angle    145.3471
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1063"
}

Galaxy "NGC 1064:MCG 2-7-71"
{
        Type  "Sc"
        RA            2.7064
        Dec          -9.3628
        Distance   2.125e+08  # distance uncertain!
        Radius       3.4e+04
        AbsMag        -19.07
        Axis    [  0.7448   0.6547   0.1286]
        Angle    143.3344
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1064"
}

Galaxy "NGC 1065:MCG 3-7-59:NPM 1"
{
        Type  "S0"
        RA            2.7017
        Dec         -15.0917
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [  0.2122   0.5006  -0.8392]
        Angle    185.4605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1065"
}

Galaxy "NGC 1066:UGC 2203:MCG 5-7-42:ZWG 505.44"
{
        Type  "E0"
        RA            2.7303
        Dec          32.4756
        Distance   3.163e+08  # distance uncertain!
        Radius      7.82e+04
        AbsMag        -20.13
        Axis    [  0.6355   0.7477  -0.1926]
        Angle    130.4835
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1066"
}

Galaxy "NGC 1067:UGC 2204:MCG 5-7-43:ZWG 505.45"
{
        Type  "Sc"
        RA            2.7306
        Dec          32.5117
        Distance   1.959e+08  # method: V
        Radius     3.135e+04
        AbsMag        -19.39
        Axis    [  0.0122   0.7734  -0.6339]
        Angle    197.8824
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1067"
}

Galaxy "M 77:NGC 1068:UGC 2188:MCG 0-7-83"
{
        Type  "Sb"
        RA            2.7111
        Dec          -0.0128
        Distance   4.127e+07  # method: V
        Radius     4.262e+04
        AbsMag        -20.81
        Axis    [  0.5613   0.8082  -0.1783]
        Angle    148.0870
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 77"
}

Galaxy "NGC 1069:MCG 1-7-38:IRAS 02405-0829"
{
        Type  "Sc"
        RA            2.7164
        Dec          -8.2889
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.1907   0.6912  -0.6970]
        Angle    162.8457
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1069"
}

Galaxy "NGC 1070:UGC 2200:MCG 1-7-26:ZWG 414.45"
{
        Type  "Sb"
        RA            2.7228
        Dec           4.9686
        Distance    1.75e+08  # method: V
        Radius     5.854e+04
        AbsMag        -20.85
        Axis    [  0.0532   0.5984  -0.7994]
        Angle    188.9283
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1070"
}

Galaxy "NGC 1071:MCG 2-7-77"
{
        Type  "Sa"
        RA            2.7186
        Dec          -8.7742
        Distance    2.44e+08  # distance uncertain!
        Radius     4.259e+04
        AbsMag        -19.07
        Axis    [  0.0324   0.6415  -0.7664]
        Angle    153.6439
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1071"
}

Galaxy "NGC 1072:IC 1837:UGC 2208:MCG 0-7-88"
{
        Type  "SBb"
        RA            2.7253
        Dec           0.3069
        Distance   3.533e+08  # method: V
        Radius     7.707e+04
        AbsMag        -20.97
        Axis    [  0.3750   0.8234   0.4258]
        Angle    148.9023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1072"
}

Galaxy "NGC 1073:UGC 2210:MCG 0-8-1:ZWG 389.2"
{
        Type  "SBc"
        RA            2.7278
        Dec           1.3761
        Distance   4.476e+07  # method: V
        Radius      3.19e+04
        AbsMag        -19.19
        Axis    [  0.6910   0.6709   0.2691]
        Angle    132.1121
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1073"
}

Galaxy "NGC 1074:MCG 3-8-1"
{
        Type  "Sb"
        RA            2.7267
        Dec         -16.2969
        Distance   2.226e+08  # distance uncertain!
        Radius     6.474e+04
        AbsMag        -19.07
        Axis    [  0.1378   0.5435  -0.8280]
        Angle    166.2736
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1074"
}

Galaxy "NGC 1075:MCG 3-8-2:NPM 1:IRAS 02412-1624"
{
        Type  "SBa"
        RA            2.7258
        Dec         -16.2011
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [  0.3577   0.6751  -0.6452]
        Angle    165.0834
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1075"
}

Galaxy "NGC 1076:MCG 3-8-3:IRAS 02411-1457"
{
        Type  "Sa"
        RA            2.7247
        Dec         -14.7550
        Distance   8.589e+07  # method: V
        Radius     2.498e+04
        AbsMag         -18.5
        Axis    [  0.3863   0.8378  -0.3858]
        Angle    151.7891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1076"
}

Galaxy "NGC 1077A:NGC 1077-1:UGC 2230:MCG 7-6-69"
{
        Type  "Sb"
        RA            2.7667
        Dec          40.0900
        Distance   1.688e+08  # distance uncertain!
        Radius     2.701e+04
        AbsMag        -19.07
        Axis    [ -0.1627   0.7792  -0.6053]
        Angle    187.2381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1077A"
}

Galaxy "NGC 1077B:NGC 1077-2:MCG 7-6-68:ZWG 539.95"
{
        Type  "SBb"
        RA            2.7672
        Dec          40.0933
        Distance    5.59e+08  # distance uncertain!
        Radius     4.065e+04
        AbsMag        -19.07
        Axis    [  0.3882   0.8995   0.2005]
        Angle    108.7262
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1077B"
}

Galaxy "NGC 1078:MCG 2-8-1:NPM 1"
{
        Type  "S0"
        RA            2.7356
        Dec          -9.4519
        Distance    2.44e+08  # distance uncertain!
        Radius     3.194e+04
        AbsMag        -19.07
        Axis    [  0.7371   0.6330   0.2365]
        Angle    141.3278
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1078"
}

Galaxy "NGC 1079:ESO 416-13:MCG 5-7-17:IRAS 02415-2913"
{
        Type  "SBa"
        RA            2.7289
        Dec         -29.0028
        Distance   5.812e+07  # method: V
        Radius     4.649e+04
        AbsMag        -18.85
        Axis    [  0.5304   0.7867  -0.3159]
        Angle    156.4810
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1079"
}

Galaxy "NGC 1080:MCG 1-8-3:IRAS 02426-0455:KUG 0242-049"
{
        Type  "SBc"
        RA            2.7528
        Dec          -4.7108
        Distance   3.457e+08  # method: V
        Radius     5.531e+04
        AbsMag        -20.93
        Axis    [  0.0619   0.5573  -0.8280]
        Angle    177.1240
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1080"
}

Galaxy "NGC 1081:MCG 3-8-10:IRAS 02427-1547"
{
        Type  "Sb"
        RA            2.7514
        Dec         -15.5875
        Distance    1.72e+08  # method: V
        Radius     4.003e+04
        AbsMag        -19.51
        Axis    [  0.4608   0.8521   0.2482]
        Angle    156.5646
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1081"
}

Galaxy "NGC 1082-1:MCG 1-8-4:NPM 1"
{
        Type  "S0"
        RA            2.7614
        Dec          -8.1800
        Distance   2.125e+08  # distance uncertain!
        Radius     2.782e+04
        AbsMag        -19.07
        Axis    [  0.3752   0.7434  -0.5537]
        Angle    162.7763
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1082-1"
}

Galaxy "NGC 1082-2:MCG 1-8-4"
{
        Type  "E0"
        RA            2.7617
        Dec          -8.1831
        Distance   6.919e+08  # distance uncertain!
        Radius     2.013e+04
        AbsMag        -20.13
        Axis    [  0.8883   0.3649   0.2787]
        Angle    127.2140
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1082-2"
}

Galaxy "NGC 1083:MCG 3-8-15:IRAS 02433-1534"
{
        Type  "Sb"
        RA            2.7611
        Dec         -15.3572
        Distance    2.33e+08  # distance uncertain!
        Radius     5.423e+04
        AbsMag        -19.07
        Axis    [  0.3480   0.8701   0.3491]
        Angle    163.8708
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1083"
}

Galaxy "NGC 1084:MCG 1-8-7:IRAS 02435-0747:KUG 0243-077"
{
        Type  "Sc"
        RA            2.7664
        Dec          -7.5778
        Distance   8.961e+07  # method: T-F
        Radius     3.649e+04
        AbsMag        -20.79
        Axis    [  0.4861   0.8445   0.2248]
        Angle    147.9852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1084"
}

Galaxy "NGC 1085:UGC 2241:MCG 0-8-10:ZWG 389.8"
{
        Type  "Sc"
        RA            2.7736
        Dec           3.6078
        Distance   2.976e+08  # method: V
        Radius     7.791e+04
        AbsMag         -21.6
        Axis    [  0.5783   0.7494   0.3225]
        Angle    134.4966
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1085"
}

Galaxy "NGC 1086:UGC 2258:MCG 7-6-71:ZWG 539.101"
{
        Type  "Sc"
        RA            2.7989
        Dec          41.2467
        Distance   1.747e+08  # method: V
        Radius     3.811e+04
        AbsMag        -20.04
        Axis    [  0.2634   0.9372   0.2288]
        Angle    112.1341
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1086"
}

Galaxy "NGC 1087:UGC 2245:MCG 0-8-9:ZWG 389.10"
{
        Type  "SBc"
        RA            2.7736
        Dec          -0.4992
        Distance   5.889e+07  # method: V
        Radius     3.341e+04
        AbsMag        -19.78
        Axis    [  0.5265   0.7351   0.4271]
        Angle    141.9335
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1087"
}

Galaxy "NGC 1088:UGC 2253:MCG 3-8-9:ZWG 463.11"
{
        Type  "Sa"
        RA            2.7842
        Dec          16.2003
        Distance   1.688e+08  # distance uncertain!
        Radius     2.455e+04
        AbsMag        -19.07
        Axis    [  0.1756   0.9318  -0.3178]
        Angle    145.8292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1088"
}

Galaxy "NGC 1089:MCG 3-8-20:NPM 1"
{
        Type  "E0"
        RA            2.7694
        Dec         -15.0736
        Distance   2.884e+08  # distance uncertain!
        Radius     3.776e+04
        AbsMag        -20.13
        Axis    [  0.9075   0.3842   0.1696]
        Angle    138.7616
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1089"
}

Galaxy "NGC 1090:UGC 2247:MCG 0-8-11:ZWG 389.11"
{
        Type  "SBc"
        RA            2.7761
        Dec          -0.2478
        Distance   9.835e+07  # method: T-F
        Radius     5.579e+04
        AbsMag         -19.8
        Axis    [  0.2170   0.9059  -0.3636]
        Angle    146.0215
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1090"
}

Galaxy "NGC 1091:ESO 546-16:MCG 3-8-13:HCG 21"
{
        Type  "SBa"
        RA            2.7561
        Dec         -17.5333
        Distance    2.33e+08  # distance uncertain!
        Radius     3.051e+04
        AbsMag        -19.07
        Axis    [  0.5399   0.8101  -0.2285]
        Angle    153.7154
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1091"
}

Galaxy "NGC 1092:ESO 546-17:MCG 3-8-14:HCG 21"
{
        Type  "E0"
        RA            2.7581
        Dec         -17.5425
        Distance   3.912e+08  # method: V
        Radius     5.121e+04
        AbsMag        -20.39
        Axis    [  0.3606   0.4190  -0.8333]
        Angle    211.5222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1092"
}

Galaxy "NGC 1093:UGC 2274:MCG 6-7-11:ZWG 524.22"
{
        Type  "Sb"
        RA            2.8044
        Dec          34.4200
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.0980   0.9522  -0.2894]
        Angle    145.8071
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1093"
}

Galaxy "NGC 1094:UGC 2262:MCG 0-8-15:ZWG 389.16"
{
        Type  "SBb"
        RA            2.7908
        Dec          -0.2853
        Distance   2.825e+08  # method: V
        Radius     5.341e+04
        AbsMag        -21.19
        Axis    [  0.4608   0.8408  -0.2840]
        Angle    150.0114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1094"
}

Galaxy "NGC 1095:UGC 2264:MCG 1-8-1:ZWG 415.8"
{
        Type  "SBc"
        RA            2.7936
        Dec           4.6381
        Distance   2.783e+08  # method: V
        Radius     5.263e+04
        AbsMag        -20.56
        Axis    [  0.4556   0.8850   0.0960]
        Angle    138.0936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1095"
}

Galaxy "NGC 1096:ESO 115-28:AM 0242-600:IRAS 02425-6007"
{
        Type  "SBc"
        RA            2.7303
        Dec         -59.9139
        Distance   2.991e+08  # method: V
        Radius     8.265e+04
        AbsMag        -21.21
        Axis    [  0.9252   0.3758  -0.0531]
        Angle    182.4554
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1096"
}

Galaxy "NGC 1097:ESO 416-20:MCG 5-7-24:UGCA 41"
{
        Type  "SBb"
        RA            2.7719
        Dec         -30.2756
        Distance   6.487e+07  # method: T-F
        Radius     8.869e+04
        AbsMag        -21.19
        Axis    [  0.4342   0.6163  -0.6570]
        Angle    161.5621
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1097"
}

Galaxy "NGC 1097A:ESO 416-19:MCG 5-7-22"
{
        Type  "E0"
        RA            2.7692
        Dec         -30.2286
        Distance   5.278e+07  # method: V
        Radius          6141
        AbsMag        -16.94
        Axis    [  0.7716   0.3918  -0.5010]
        Angle    184.9438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1097A"
}

Galaxy "NGC 1098:ESO 546-14:MCG 3-8-8:HCG 21"
{
        Type  "S0"
        RA            2.7481
        Dec         -17.6594
        Distance   3.256e+08  # method: V
        Radius      8.05e+04
        AbsMag         -21.3
        Axis    [  0.5085   0.7385  -0.4429]
        Angle    159.7524
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1098"
}

Galaxy "NGC 1099:ESO 546-15:MCG 3-8-11:HCG 21A"
{
        Type  "SBb"
        RA            2.7547
        Dec         -17.7086
        Distance   3.099e+08  # method: T-F
        Radius     8.564e+04
        AbsMag        -20.79
        Axis    [  0.4493   0.8077   0.3818]
        Angle    163.7529
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1099"
}

Galaxy "NGC 1100:ESO 546-18:MCG 3-8-16:HCG 21B"
{
        Type  "SBa"
        RA            2.7597
        Dec         -17.6886
        Distance   3.332e+08  # method: V
        Radius     8.239e+04
        AbsMag        -21.05
        Axis    [  0.4809   0.8761  -0.0343]
        Angle    152.1783
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1100"
}

Galaxy "NGC 1101:UGC 2278:MCG 1-8-3:ZWG 415.11"
{
        Type  "S0"
        RA            2.8039
        Dec           4.5786
        Distance   2.713e+08  # method: V
        Radius     5.129e+04
        AbsMag         -20.6
        Axis    [  0.2809   0.8060  -0.5210]
        Angle    160.7298
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1101"
}

Galaxy "NGC 1102:ESO 546-19:MCG 4-7-40:AM 0245-222"
{
        Type  "SBb"
        RA            2.7867
        Dec         -22.2089
        Distance    2.44e+08  # distance uncertain!
        Radius     2.839e+04
        AbsMag        -19.07
        Axis    [  0.5739   0.7371  -0.3569]
        Angle    158.4081
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1102"
}

Galaxy "NGC 1103:MCG 2-8-5"
{
        Type  "SBb"
        RA            2.8017
        Dec         -13.9594
        Distance    1.79e+08  # method: V
        Radius     5.729e+04
        AbsMag           -20
        Axis    [  0.3672   0.9227   0.1177]
        Angle    152.3498
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1103"
}

Galaxy "NGC 1104:UGC 2287:MCG 0-8-19:ZWG 389.20"
{
        Type  "SBa"
        RA            2.8106
        Dec          -0.2714
        Distance   1.688e+08  # distance uncertain!
        Radius     2.947e+04
        AbsMag        -19.07
        Axis    [  0.5012   0.8504  -0.1603]
        Angle    145.3839
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1104"
}

Galaxy "NGC 1105:IC 1840:MCG 3-8-4:NPM 1"
{
        Type  "Sb"
        RA            2.7281
        Dec         -15.7058
        Distance   2.226e+08  # distance uncertain!
        Radius     2.266e+04
        AbsMag        -19.07
        Axis    [  0.8803   0.3618   0.3068]
        Angle    134.9236
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1105"
}

Galaxy "NGC 1106:UGC 2322:MCG 7-6-76:ZWG 539.112"
{
        Type  "S0"
        RA            2.8444
        Dec          41.6722
        Distance   1.821e+08  # method: V
        Radius     3.443e+04
        AbsMag        -20.23
        Axis    [  0.3712   0.8956   0.2454]
        Angle    106.2419
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1106"
}

Galaxy "NGC 1107:UGC 2307:MCG 1-8-6:ZWG 415.13"
{
        Type  "S0"
        RA            2.8219
        Dec           8.0933
        Distance   1.452e+08  # method: V
        Radius     3.801e+04
        AbsMag        -19.74
        Axis    [  0.2063   0.7485  -0.6302]
        Angle    172.7761
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1107"
}

Galaxy "NGC 1108"
{
        Type  "S0"
        RA            2.8106
        Dec          -7.9506
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.3595   0.8985  -0.2518]
        Angle    146.6818
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1108"
}

Galaxy "NGC 1109:IC 1846:UGC 2265:MCG 2-8-6"
{
        Type  "E0"
        RA            2.7953
        Dec          13.2556
        Distance   3.802e+08  # distance uncertain!
        Radius     3.318e+04
        AbsMag        -20.13
        Axis    [  0.3652   0.6738  -0.6424]
        Angle    203.0703
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1109"
}

Galaxy "NGC 1110:MCG 1-8-10:UGCA 43:FGC 346"
{
        Type  "Irr"
        RA            2.8192
        Dec          -7.8381
        Distance   5.087e+07  # method: V
        Radius     2.146e+04
        AbsMag        -16.46
        Axis    [  0.3152   0.8751   0.3672]
        Angle    157.5176
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1110"
}

Galaxy "NGC 1111:IC 1850"
{
        Type  "S0"
        RA            2.8108
        Dec          13.2592
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [  0.3699   0.7871   0.4936]
        Angle    136.4156
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1111"
}

Galaxy "NGC 1112:IC 1852:UGC 2293:MCG 2-8-11"
{
        Type  "SBc"
        RA            2.8167
        Dec          13.2236
        Distance   3.721e+08  # method: V
        Radius     6.495e+04
        AbsMag        -20.69
        Axis    [  0.5725   0.7025   0.4228]
        Angle    124.0705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1112"
}

Galaxy "NGC 1114:MCG 3-8-29:IRAS 02467-1712"
{
        Type  "Sc"
        RA            2.8186
        Dec         -16.9939
        Distance   1.842e+08  # method: T-F
        Radius     4.822e+04
        AbsMag        -20.16
        Axis    [  0.5200   0.7664   0.3771]
        Angle    159.2782
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1114"
}

Galaxy "NGC 1115:MCG 2-8-16:ZWG 440.20"
{
        Type  "S0"
        RA            2.8403
        Dec          13.2669
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [  0.2918   0.8362   0.4644]
        Angle    139.3811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1115"
}

Galaxy "NGC 1116:UGC 2326:MCG 2-8-17:ZWG 440.21"
{
        Type  "Sb"
        RA            2.8431
        Dec          13.3350
        Distance    3.39e+08  # method: V
        Radius     6.903e+04
        AbsMag        -19.78
        Axis    [  0.1912   0.9088   0.3707]
        Angle    140.0195
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1116"
}

Galaxy "NGC 1117-1:UGC 2337:MCG 2-8-20:ZWG 440.22"
{
        Type  "E0"
        RA            2.8536
        Dec          13.1858
        Distance   3.981e+08  # distance uncertain!
        Radius     4.054e+04
        AbsMag        -20.13
        Axis    [  0.8178   0.5747  -0.0308]
        Angle    125.0056
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1117-1"
}

Galaxy "NGC 1117-2:UGC 2337:ZWG 440.22"
{
        Type  "E0"
        RA            2.8536
        Dec          13.1878
        Distance   6.919e+08  # distance uncertain!
        Radius     1.006e+04
        AbsMag        -20.13
        Axis    [  0.8691   0.4420   0.2222]
        Angle    108.0413
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1117-2"
}

Galaxy "NGC 1117A:UGC 2337:MCG 2-8-19:ZWG 440.22"
{
        Type  "S0"
        RA            2.8533
        Dec          13.1925
        Distance    2.03e+08  # distance uncertain!
        Radius     1.476e+04
        AbsMag        -19.07
        Axis    [  0.4357   0.8662   0.2446]
        Angle    130.3396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1117A"
}

Galaxy "NGC 1118:MCG 2-8-11:IRAS 02475-1222"
{
        Type  "S0"
        RA            2.8328
        Dec         -12.1639
        Distance    1.47e+08  # distance uncertain!
        Radius     4.705e+04
        AbsMag        -19.07
        Axis    [  0.2735   0.9227  -0.2716]
        Angle    144.1024
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1118"
}

Galaxy "NGC 1119:ESO 546-24:IRAS 02459-1811"
{
        Type  "S0"
        RA            2.8047
        Dec         -17.9881
        Distance   1.938e+08  # distance uncertain!
        Radius      1.41e+04
        AbsMag        -19.07
        Axis    [  0.6997   0.5917   0.4005]
        Angle    150.1965
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1119"
}

Galaxy "NGC 1120:IC 261:MCG 3-8-28:NPM 1"
{
        Type  "S0"
        RA            2.8178
        Dec         -14.4703
        Distance   1.768e+08  # distance uncertain!
        Radius     3.343e+04
        AbsMag        -19.07
        Axis    [  0.5762   0.8108   0.1024]
        Angle    150.3642
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1120"
}

Galaxy "NGC 1121:UGC 2332:MCG 0-8-30:ZWG 389.32"
{
        Type  "S0"
        RA            2.8442
        Dec          -1.7342
        Distance    1.08e+08  # method: V
        Radius     1.414e+04
        AbsMag         -18.7
        Axis    [  0.4583   0.7897   0.4078]
        Angle    146.3015
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1121"
}

Galaxy "NGC 1123:NGC 1122:UGC 2353:MCG 7-6-83"
{
        Type  "SBb"
        RA            2.8808
        Dec          42.2053
        Distance   1.549e+08  # method: V
        Radius     4.055e+04
        AbsMag        -20.38
        Axis    [  0.2823   0.9452   0.1639]
        Angle    111.6554
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1123"
}

Galaxy "NGC 1124:ESO 480-7:MCG 4-7-47"
{
        Type  "S0"
        RA            2.8600
        Dec         -25.7014
        Distance    2.03e+08  # distance uncertain!
        Radius     2.952e+04
        AbsMag        -19.07
        Axis    [  0.2563   0.4752  -0.8417]
        Angle    172.3155
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1124"
}

Galaxy "NGC 1125:MCG 3-8-35"
{
        Type  "SBa"
        RA            2.8611
        Dec         -16.6508
        Distance   1.065e+08  # distance uncertain!
        Radius     2.789e+04
        AbsMag        -19.07
        Axis    [  0.5100   0.8599   0.0195]
        Angle    151.0893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1125"
}

Galaxy "NGC 1126:MCG 0-8-38:ZWG 389.38"
{
        Type  "Sb"
        RA            2.8717
        Dec          -1.2964
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [ -0.0206   0.8160  -0.5777]
        Angle    140.8008
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1126"
}

Galaxy "NGC 1127:UGC 2356:MCG 2-8-24:ZWG 440.24"
{
        Type  "SBb"
        RA            2.8808
        Dec          13.2569
        Distance   4.331e+08  # method: V
        Radius      4.41e+04
        AbsMag        -20.12
        Axis    [  0.4869   0.8636   0.1309]
        Angle    129.6285
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1127"
}

Galaxy "NGC 1128-1:MCG 1-8-27:ZWG 415.41:DRCG 9-43"
{
        Type  "E0"
        RA            2.9614
        Dec           6.0267
        Distance   4.366e+08  # distance uncertain!
        Radius     3.175e+04
        AbsMag        -20.13
        Axis    [  0.8868   0.3992   0.2330]
        Angle    113.8529
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1128-1"
}

Galaxy "NGC 1128-2:MCG 1-8-27:ZWG 415.41:DRCG 9-42"
{
        Type  "E0"
        RA            2.9614
        Dec           6.0225
        Distance    3.05e+08  # method: V
        Radius     2.218e+04
        AbsMag        -19.35
        Axis    [  0.8868   0.3992   0.2330]
        Angle    113.8566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1128-2"
}

Galaxy "NGC 1129:UGC 2373:MCG 7-7-4:ZWG 539.124"
{
        Type  "E0"
        RA            2.9075
        Dec          41.5797
        Distance   2.275e+08  # method: V
        Radius     9.594e+04
        AbsMag        -21.32
        Axis    [  0.4566   0.8253  -0.3321]
        Angle    150.5242
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1129"
}

Galaxy "NGC 1130:MCG 7-7-2:ZWG 539.122:ZWG 540.4"
{
        Type  "E0"
        RA            2.9067
        Dec          41.6061
        Distance   5.755e+08  # distance uncertain!
        Radius     4.185e+04
        AbsMag        -20.13
        Axis    [  0.6671   0.7374  -0.1060]
        Angle    107.8151
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1130"
}

Galaxy "NGC 1131:MCG 7-7-5:ZWG 539.125:ZWG 540.7"
{
        Type  "E0"
        RA            2.9094
        Dec          41.5592
        Distance   4.571e+08  # distance uncertain!
        Radius     2.659e+04
        AbsMag        -20.13
        Axis    [  0.8079   0.5754   0.1276]
        Angle     83.8060
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1131"
}

Galaxy "NGC 1132:UGC 2359:MCG 0-8-40:ZWG 389.40"
{
        Type  "E0"
        RA            2.8808
        Dec          -1.2744
        Distance   3.053e+08  # method: V
        Radius      1.11e+05
        AbsMag        -21.56
        Axis    [  0.4772   0.5837  -0.6569]
        Angle    196.1297
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1132"
}

Galaxy "NGC 1133:MCG 2-8-15:IRAS 02502-0900"
{
        Type  "Sa"
        RA            2.8783
        Dec          -8.8044
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [  0.1384   0.6272  -0.7665]
        Angle    165.0713
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1133"
}

Galaxy "NGC 1134:UGC 2365:MCG 2-8-27:ZWG 440.27"
{
        Type  "Sb"
        RA            2.8947
        Dec          13.0147
        Distance   1.554e+08  # method: V
        Radius     5.652e+04
        AbsMag        -20.29
        Axis    [ -0.1180   0.7711  -0.6256]
        Angle    151.8019
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1134"
}

Galaxy "NGC 1135:ESO 154-18"
{
        Type  "Sc"
        RA            2.8464
        Dec         -54.9294
        Distance   3.694e+08  # distance uncertain!
        Radius      3.76e+04
        AbsMag        -19.07
        Axis    [  0.6528   0.7214  -0.2311]
        Angle    167.0918
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1135"
}

Galaxy "NGC 1136:ESO 154-19:FAIR 732:AM 0249-551"
{
        Type  "SBa"
        RA            2.8481
        Dec         -54.9761
        Distance   2.483e+08  # method: V
        Radius     5.057e+04
        AbsMag        -20.61
        Axis    [  0.8193   0.4757  -0.3200]
        Angle    175.1547
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1136"
}

Galaxy "NGC 1137:UGC 2374:MCG 0-8-43:ZWG 389.42"
{
        Type  "Sb"
        RA            2.9006
        Dec           2.9619
        Distance   1.282e+08  # method: V
        Radius     4.101e+04
        AbsMag        -19.67
        Axis    [  0.5096   0.8031   0.3088]
        Angle    137.3726
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1137"
}

Galaxy "NGC 1138:UGC 2408:MCG 7-7-12:ZWG 540.15"
{
        Type  "S0"
        RA            2.9433
        Dec          43.0472
        Distance   1.341e+08  # distance uncertain!
        Radius     2.146e+04
        AbsMag        -19.07
        Axis    [  0.7876   0.5977   0.1498]
        Angle     82.7665
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1138"
}

Galaxy "NGC 1139:MCG 3-8-38:NPM 1"
{
        Type  "SBa"
        RA            2.8794
        Dec         -14.5289
        Distance   3.217e+08  # distance uncertain!
        Radius     5.615e+04
        AbsMag        -19.07
        Axis    [  0.6146   0.7790   0.1242]
        Angle    149.4117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1139"
}

Galaxy "NGC 1140:MCG 2-8-19:MK 1063:VV 482"
{
        Type  "Irr"
        RA            2.9092
        Dec         -10.0281
        Distance    5.93e+07  # method: V
        Radius     1.552e+04
        AbsMag         -18.2
        Axis    [  0.0414   0.5697  -0.8208]
        Angle    160.5881
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1140"
}

Galaxy "NGC 1141:NGC 1143:UGC 2388:MCG 0-8-47"
{
        Type  "S0"
        RA            2.9192
        Dec          -0.1781
        Distance   3.738e+08  # method: V
        Radius     4.893e+04
        AbsMag         -21.2
        Axis    [  0.3635   0.8019  -0.4742]
        Angle    156.4299
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1141"
}

Galaxy "NGC 1142:NGC 1144:UGC 2389:MCG 0-8-48"
{
        Type  "S0"
        RA            2.9200
        Dec          -0.1839
        Distance   3.822e+08  # method: V
        Radius     5.004e+04
        AbsMag        -21.54
        Axis    [  0.1508   0.7995  -0.5815]
        Angle    152.7472
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1142"
}

Galaxy "NGC 1145:ESO 546-29:MCG 3-8-42:UGCA 45"
{
        Type  "Sc"
        RA            2.9092
        Dec         -18.6358
        Distance   9.907e+07  # method: T-F
        Radius     4.611e+04
        AbsMag        -18.81
        Axis    [  0.3098   0.9508  -0.0079]
        Angle    149.8577
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1145"
}

Galaxy "NGC 1148:MCG 1-8-18"
{
        Type  "Irr"
        RA            2.9511
        Dec          -7.6856
        Distance   4.366e+08  # distance uncertain!
        Radius     8.889e+04
        AbsMag        -20.13
        Axis    [  0.4043   0.8765  -0.2612]
        Angle    145.9272
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1148"
}

Galaxy "NGC 1149:MCG 0-8-58:ZWG 389.54:NPM 1"
{
        Type  "S0"
        RA            2.9564
        Dec          -0.3089
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [  0.3048   0.7337  -0.6072]
        Angle    166.3620
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1149"
}

Galaxy "NGC 1150:MCG 3-8-48:NPM 1"
{
        Type  "S0"
        RA            2.9503
        Dec         -15.0486
        Distance   2.226e+08  # distance uncertain!
        Radius     2.913e+04
        AbsMag        -19.07
        Axis    [  0.5423   0.8157  -0.2015]
        Angle    149.8895
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1150"
}

Galaxy "NGC 1151:NPM 1"
{
        Type  "E0"
        RA            2.9511
        Dec         -15.0133
        Distance   5.496e+08  # distance uncertain!
        Radius     3.197e+04
        AbsMag        -20.13
        Axis    [  0.9149   0.3536   0.1946]
        Angle    136.1394
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1151"
}

Galaxy "NGC 1152:MCG 1-8-19"
{
        Type  "S0"
        RA            2.9592
        Dec          -7.7597
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.5972   0.7787   0.1922]
        Angle    143.6163
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1152"
}

Galaxy "NGC 1153:UGC 2439:MCG 0-8-59:ZWG 389.55"
{
        Type  "Sa"
        RA            2.9694
        Dec           3.3619
        Distance   1.323e+08  # method: V
        Radius     2.309e+04
        AbsMag        -19.64
        Axis    [  0.4577   0.8839   0.0961]
        Angle    137.0960
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1153"
}

Galaxy "NGC 1154:MCG 2-8-34"
{
        Type  "Sc"
        RA            2.9686
        Dec         -10.3636
        Distance    1.54e+08  # distance uncertain!
        Radius     2.239e+04
        AbsMag        -19.07
        Axis    [  0.3783   0.7078  -0.5965]
        Angle    162.5641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1154"
}

Galaxy "NGC 1155:MCG 2-8-35:MK 1064:IRAS 02557-1033"
{
        Type  "S0"
        RA            2.9703
        Dec         -10.3503
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.1592   0.5613  -0.8122]
        Angle    175.1808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1155"
}

Galaxy "NGC 1156:UGC 2455:MCG 4-8-6:ZWG 485.6"
{
        Type  "Irr"
        RA            2.9950
        Dec          25.2372
        Distance    8.29e+06  # method: V
        Radius          3135
        AbsMag        -14.72
        Axis    [  0.3949   0.8932   0.2149]
        Angle    120.1245
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1156"
}

Galaxy "NGC 1157"
{
        Type  "Sb"
        RA            2.9683
        Dec         -15.1181
        Distance   2.802e+08  # distance uncertain!
        Radius     2.445e+04
        AbsMag        -19.07
        Axis    [  0.0509   0.5511  -0.8329]
        Angle    154.6928
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1157"
}

Galaxy "NGC 1158:MCG 3-8-49:NPM 1"
{
        Type  "S0"
        RA            2.9531
        Dec         -14.3950
        Distance   3.072e+08  # distance uncertain!
        Radius     4.021e+04
        AbsMag        -19.07
        Axis    [  0.2217   0.6438  -0.7324]
        Angle    160.5782
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1158"
}

Galaxy "NGC 1159:UGC 2467:ZWG 540.23:IRAS 02575+4257"
{
        Type  "S0"
        RA            3.0128
        Dec          43.1628
        Distance   1.612e+08  # distance uncertain!
        Radius     1.172e+04
        AbsMag        -19.07
        Axis    [  0.0084   0.9169  -0.3989]
        Angle    159.1768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1159"
}

Galaxy "NGC 1160:UGC 2475:MCG 7-7-14:ZWG 540.27"
{
        Type  "Sc"
        RA            3.0203
        Dec          44.9556
        Distance   1.024e+08  # method: V
        Radius     2.235e+04
        AbsMag        -18.98
        Axis    [  0.0585   0.9784   0.1985]
        Angle    115.8251
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1160"
}

Galaxy "NGC 1161:UGC 2474:MCG 7-7-15:ZWG 540.26"
{
        Type  "S0"
        RA            3.0206
        Dec          44.8975
        Distance   8.027e+07  # method: V
        Radius     3.269e+04
        AbsMag        -19.85
        Axis    [  0.3407   0.8850   0.3172]
        Angle    102.0878
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1161"
}

Galaxy "NGC 1162:MCG 2-8-36"
{
        Type  "E0"
        RA            2.9819
        Dec         -12.3983
        Distance   1.347e+08  # method: S
        Radius     2.743e+04
        AbsMag        -19.58
        Axis    [  0.9056   0.3274   0.2697]
        Angle    130.3074
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1162"
}

Galaxy "NGC 1163:MCG 3-8-56:FGC 373:IRAS 02580-1720"
{
        Type  "SBc"
        RA            3.0061
        Dec         -17.1528
        Distance   9.939e+07  # method: T-F
        Radius      3.18e+04
        AbsMag        -17.72
        Axis    [  0.0474   0.7561  -0.6527]
        Angle    132.7149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1163"
}

Galaxy "NGC 1164:UGC 2490:MCG 7-7-16:MK 1067"
{
        Type  "SBb"
        RA            3.0331
        Dec          42.5856
        Distance   1.812e+08  # method: V
        Radius     3.427e+04
        AbsMag        -19.32
        Axis    [ -0.0316   0.8634  -0.5035]
        Angle    176.5290
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1164"
}

Galaxy "NGC 1165:ESO 417-8:MCG 5-8-9:AM 0256-321"
{
        Type  "SBa"
        RA            2.9797
        Dec         -32.0994
        Distance   2.147e+08  # method: V
        Radius     7.808e+04
        AbsMag        -20.39
        Axis    [  0.3650   0.7657  -0.5296]
        Angle    144.3001
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1165"
}

Galaxy "NGC 1166:UGC 2471:MCG 2-8-46:ZWG 440.41"
{
        Type  "Sb"
        RA            3.0094
        Dec          11.8428
        Distance   3.392e+08  # method: V
        Radius     4.934e+04
        AbsMag        -20.08
        Axis    [  0.8677   0.4386   0.2338]
        Angle    109.1764
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1166"
}

Galaxy "NGC 1167:UGC 2487:MCG 6-7-33:ZWG 524.45"
{
        Type  "S0"
        RA            3.0283
        Dec          35.2058
        Distance    2.16e+08  # method: V
        Radius     1.037e+05
        AbsMag         -20.7
        Axis    [  0.2081   0.9752  -0.0752]
        Angle    126.6138
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1167"
}

Galaxy "NGC 1168:UGC 2476:MCG 2-8-47:ZWG 440.42"
{
        Type  "Sb"
        RA            3.0131
        Dec          11.7722
        Distance   3.362e+08  # method: V
        Radius     5.379e+04
        AbsMag        -19.97
        Axis    [  0.4540   0.8177   0.3538]
        Angle    130.5741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1168"
}

Galaxy "NGC 1169:UGC 2503:MCG 8-6-25:ZWG 554.20"
{
        Type  "SBb"
        RA            3.0594
        Dec          46.3864
        Distance   1.687e+08  # method: T-F
        Radius     9.817e+04
        AbsMag        -21.17
        Axis    [  0.2664   0.9121   0.3116]
        Angle    103.9739
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1169"
}

Galaxy "NGC 1171:UGC 2510:MCG 7-7-18:ZWG 540.31"
{
        Type  "Sc"
        RA            3.0661
        Dec          43.3978
        Distance   8.154e+07  # method: T-F
        Radius     2.253e+04
        AbsMag        -18.59
        Axis    [ -0.2485   0.8340  -0.4926]
        Angle    163.8955
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1171"
}

Galaxy "NGC 1172:MCG 3-8-59"
{
        Type  "E0"
        RA            3.0267
        Dec         -14.8367
        Distance   7.006e+07  # method: S
        Radius     2.343e+04
        AbsMag        -18.76
        Axis    [  0.9172   0.3955   0.0489]
        Angle    142.0359
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1172"
}

Galaxy "NGC 1175:UGC 2515:MCG 7-7-19:ZWG 540.32"
{
        Type  "Sa"
        RA            3.0756
        Dec          42.3403
        Distance   2.433e+08  # method: V
        Radius     6.723e+04
        AbsMag        -20.56
        Axis    [ -0.3402   0.7848  -0.5181]
        Angle    161.0834
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1175"
}

Galaxy "NGC 1177:IC 281:MCG 7-7-20:ZWG 540.33"
{
        Type  "S0"
        RA            3.0769
        Dec          42.3628
        Distance   2.453e+08  # method: V
        Radius     1.427e+04
        AbsMag        -18.98
        Axis    [  0.8041   0.5756   0.1488]
        Angle     82.3717
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1177"
}

Galaxy "NGC 1179:ESO 547-1:MCG 3-8-60:UGCA 48"
{
        Type  "SBc"
        RA            3.0439
        Dec         -18.8978
        Distance   5.409e+07  # method: T-F
        Radius     3.697e+04
        AbsMag         -18.5
        Axis    [  0.7283   0.6798   0.0864]
        Angle    149.7808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1179"
}

Galaxy "NGC 1180:NPM 1"
{
        Type  "S0"
        RA            3.0308
        Dec         -15.0303
        Distance   3.217e+08  # distance uncertain!
        Radius     2.807e+04
        AbsMag        -19.07
        Axis    [  0.7358   0.5854   0.3404]
        Angle    144.9263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1180"
}

Galaxy "NGC 1181"
{
        Type  "Sb"
        RA            3.0283
        Dec         -15.0528
        Distance   3.694e+08  # distance uncertain!
        Radius     4.298e+04
        AbsMag        -19.07
        Axis    [  0.2222   0.9093  -0.3519]
        Angle    139.0540
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1181"
}

Galaxy "NGC 1182:NGC 1205"
{
        Type  "Sa"
        RA            3.0578
        Dec          -9.6706
        Distance   2.802e+08  # distance uncertain!
        Radius     3.668e+04
        AbsMag        -19.07
        Axis    [  0.2318   0.8377  -0.4945]
        Angle    143.9856
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1182"
}

Galaxy "NGC 1184:UGC 2583:MCG 13-3-2:ZWG 346.2"
{
        Type  "Sa"
        RA            3.2792
        Dec          80.7931
        Distance   1.017e+08  # distance uncertain!
        Radius     4.143e+04
        AbsMag        -19.07
        Axis    [ -0.6600   0.6655  -0.3487]
        Angle    177.1870
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1184"
}

Galaxy "NGC 1185:MCG 2-8-41:IRAS 03005-0919"
{
        Type  "Sb"
        RA            3.0497
        Dec          -9.1331
        Distance   2.094e+08  # method: V
        Radius     3.654e+04
        AbsMag        -18.44
        Axis    [  0.4244   0.8734   0.2390]
        Angle    148.9442
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1185"
}

Galaxy "NGC 1186:NGC 1174:UGC 2521:MCG 7-7-21"
{
        Type  "SBc"
        RA            3.0917
        Dec          42.8356
        Distance   1.128e+08  # method: V
        Radius      5.25e+04
        AbsMag        -20.19
        Axis    [ -0.2565   0.9083  -0.3304]
        Angle    145.1112
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1186"
}

Galaxy "NGC 1187:ESO 480-23:MCG 4-8-16:UGCA 49"
{
        Type  "SBc"
        RA            3.0436
        Dec         -22.8672
        Distance   5.563e+07  # method: V
        Radius     3.398e+04
        AbsMag        -19.86
        Axis    [  0.4037   0.6305  -0.6629]
        Angle    161.3983
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1187"
}

Galaxy "NGC 1188:MCG 3-8-68"
{
        Type  "S0"
        RA            3.0619
        Dec         -15.4847
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.0418   0.5419  -0.8394]
        Angle    153.5797
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1188"
}

Galaxy "NGC 1189:MCG 3-8-61:HCG 22"
{
        Type  "SBc"
        RA            3.0567
        Dec         -15.6231
        Distance   1.154e+08  # method: V
        Radius     2.853e+04
        AbsMag        -18.24
        Axis    [  0.5920   0.6812  -0.4307]
        Angle    159.4111
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1189"
}

Galaxy "NGC 1190:MCG 3-8-62:HCG 22B"
{
        Type  "S0"
        RA            3.0572
        Dec         -15.6622
        Distance   1.107e+08  # method: V
        Radius     1.449e+04
        AbsMag        -17.45
        Axis    [  0.2981   0.8948  -0.3324]
        Angle    141.7149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1190"
}

Galaxy "NGC 1191:MCG 3-8-64:HCG 22:NPM 1"
{
        Type  "S0"
        RA            3.0583
        Dec         -15.6856
        Distance    4.15e+08  # method: V
        Radius     3.622e+04
        AbsMag        -20.22
        Axis    [  0.6847   0.7166  -0.1332]
        Angle    150.0915
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1191"
}

Galaxy "NGC 1192:MCG 3-8-65:HCG 22:NPM 1"
{
        Type  "E0"
        RA            3.0594
        Dec         -15.6789
        Distance   4.225e+08  # method: V
        Radius     4.301e+04
        AbsMag        -19.76
        Axis    [  0.7190   0.4877  -0.4953]
        Angle    176.4775
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1192"
}

Galaxy "NGC 1194:UGC 2514:MCG 0-8-78:ZWG 389.68"
{
        Type  "Sa"
        RA            3.0636
        Dec          -1.1033
        Distance   1.281e+08  # distance uncertain!
        Radius     3.353e+04
        AbsMag        -19.07
        Axis    [  0.1083   0.7531  -0.6490]
        Angle    153.2236
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1194"
}

Galaxy "NGC 1195:MCG 2-8-42A:NPM 1"
{
        Type  "S0"
        RA            3.0589
        Dec         -12.0392
        Distance   2.676e+08  # distance uncertain!
        Radius     2.335e+04
        AbsMag        -19.07
        Axis    [  0.7272   0.5702   0.3821]
        Angle    141.9458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1195"
}

Galaxy "NGC 1196:MCG 2-8-42B"
{
        Type  "S0"
        RA            3.0597
        Dec         -12.0758
        Distance    1.47e+08  # distance uncertain!
        Radius     2.994e+04
        AbsMag        -19.07
        Axis    [  0.8984   0.3434   0.2740]
        Angle    130.5964
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1196"
}

Galaxy "NGC 1198:IC 282:UGC 2533:MCG 7-7-24"
{
        Type  "S0"
        RA            3.1036
        Dec          41.8489
        Distance   6.474e+07  # method: V
        Radius     1.318e+04
        AbsMag        -17.69
        Axis    [ -0.1258   0.9264  -0.3549]
        Angle    148.6409
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1198"
}

Galaxy "NGC 1199:MCG 3-8-67:HCG 22A"
{
        Type  "E3"
        RA            3.0606
        Dec         -15.6133
        Distance    1.08e+08  # method: S
        Radius     3.613e+04
        AbsMag         -20.2
        Axis    [  0.8583   0.4580  -0.2312]
        Angle    157.8507
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1199"
}

Galaxy "NGC 1200:MCG 2-8-43"
{
        Type  "S0"
        RA            3.0650
        Dec         -11.9914
        Distance   1.065e+08  # distance uncertain!
        Radius     4.493e+04
        AbsMag        -19.07
        Axis    [  0.5259   0.7571  -0.3876]
        Angle    153.3544
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1200"
}

Galaxy "NGC 1201:ESO 480-28:MCG 4-8-23"
{
        Type  "S0"
        RA            3.0686
        Dec         -26.0689
        Distance   6.598e+07  # method: S
        Radius     3.455e+04
        AbsMag        -19.83
        Axis    [  0.6415   0.6860   0.3432]
        Angle    161.8030
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1201"
}

Galaxy "NGC 1202:KUG 0302-066"
{
        Type  "Sb"
        RA            3.0839
        Dec          -6.4919
        Distance   2.676e+08  # distance uncertain!
        Radius     2.335e+04
        AbsMag        -19.07
        Axis    [  0.5126   0.7635  -0.3928]
        Angle    153.1218
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1202"
}

Galaxy "NGC 1203-1:MCG 3-8-70"
{
        Type  "E0"
        RA            3.0872
        Dec         -14.3808
        Distance   3.163e+08  # distance uncertain!
        Radius      3.22e+04
        AbsMag        -20.13
        Axis    [  0.9132   0.3101   0.2646]
        Angle    131.8164
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1203-1"
}

Galaxy "NGC 1203-2:MCG 3-8-71"
{
        Type  "E0"
        RA            3.0872
        Dec         -14.3772
        Distance   5.496e+08  # distance uncertain!
        Radius     2.398e+04
        AbsMag        -20.13
        Axis    [  0.9132   0.3101   0.2646]
        Angle    131.8131
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1203-2"
}

Galaxy "NGC 1204:MCG 2-8-45:IRAS 03022-1232"
{
        Type  "Sa"
        RA            3.0775
        Dec         -12.3417
        Distance    1.47e+08  # distance uncertain!
        Radius     2.566e+04
        AbsMag        -19.07
        Axis    [  0.3007   0.9502  -0.0822]
        Angle    142.6874
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1204"
}

Galaxy "NGC 1206:NPM 1"
{
        Type  "E0"
        RA            3.1025
        Dec          -8.8328
        Distance   4.366e+08  # distance uncertain!
        Radius     3.175e+04
        AbsMag        -20.13
        Axis    [  0.9102   0.3278   0.2533]
        Angle    126.7147
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1206"
}

Galaxy "NGC 1207:UGC 2548:MCG 6-7-43:ZWG 524.55"
{
        Type  "Sb"
        RA            3.1375
        Dec          38.3822
        Distance    2.09e+08  # method: V
        Radius     6.992e+04
        AbsMag        -20.53
        Axis    [ -0.0316   0.9131  -0.4065]
        Angle    153.4602
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1207"
}

Galaxy "NGC 1208:MCG 2-8-47:IRAS 03037-0943"
{
        Type  "Sa"
        RA            3.1031
        Dec          -9.5408
        Distance   2.003e+08  # method: V
        Radius     5.536e+04
        AbsMag        -20.54
        Axis    [  0.3833   0.8972  -0.2193]
        Angle    142.6570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1208"
}

Galaxy "NGC 1209:MCG 3-8-73"
{
        Type  "E6"
        RA            3.1006
        Dec         -15.6111
        Distance   1.168e+08  # method: S
        Radius     3.737e+04
        AbsMag        -20.37
        Axis    [  0.7871   0.4785  -0.3892]
        Angle    167.8432
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1209"
}

Galaxy "NGC 1210:ESO 480-31:AM 0304-255"
{
        Type  "S0"
        RA            3.1125
        Dec         -25.7164
        Distance   1.708e+08  # method: V
        Radius     2.484e+04
        AbsMag        -19.99
        Axis    [  0.3330   0.4705  -0.8172]
        Angle    177.0721
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1210"
}

Galaxy "NGC 1211:UGC 2545:MCG 0-8-93:ZWG 389.81"
{
        Type  "SBa"
        RA            3.1144
        Dec          -0.7942
        Distance   1.362e+08  # method: V
        Radius     4.159e+04
        AbsMag         -19.8
        Axis    [  0.7358   0.6689   0.1057]
        Angle    133.2990
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1211"
}

Galaxy "NGC 1212:IC 1883:UGC 2560"
{
        Type  "Sa"
        RA            3.1617
        Dec          40.8931
        Distance   2.676e+08  # distance uncertain!
        Radius     3.892e+04
        AbsMag        -19.07
        Axis    [  0.2513   0.8744   0.4151]
        Angle    109.2962
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1212"
}

Galaxy "NGC 1213:IC 1881:UGC 2557:MCG 6-7-45"
{
        Type  "Irr"
        RA            3.1547
        Dec          38.6492
        Distance   1.475e+08  # method: V
        Radius     3.862e+04
        AbsMag        -17.98
        Axis    [  0.3163   0.9485   0.0192]
        Angle    116.0204
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1213"
}

Galaxy "NGC 1214:MCG 2-8-51:HCG 23A"
{
        Type  "Sa"
        RA            3.1156
        Dec          -9.5442
        Distance    2.11e+08  # method: V
        Radius     3.989e+04
        AbsMag        -19.05
        Axis    [  0.3400   0.9238   0.1759]
        Angle    147.8581
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1214"
}

Galaxy "NGC 1215:MCG 2-8-55:HCG 23B"
{
        Type  "Sa"
        RA            3.1192
        Dec          -9.5928
        Distance   2.151e+08  # method: V
        Radius     5.632e+04
        AbsMag         -19.1
        Axis    [  0.5396   0.8315  -0.1317]
        Angle    144.4554
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1215"
}

Galaxy "NGC 1216:MCG 2-8-56:HCG 23"
{
        Type  "Sa"
        RA            3.1217
        Dec          -9.6125
        Distance   2.189e+08  # method: V
        Radius     2.547e+04
        AbsMag        -18.13
        Axis    [  0.2949   0.9547  -0.0397]
        Angle    141.6956
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1216"
}

Galaxy "NGC 1217-1:ESO 300-10:MCG 7-7-3:AM 0304-391"
{
        Type  "Sa"
        RA            3.1017
        Dec         -39.0358
        Distance   2.767e+08  # method: V
        Radius     7.244e+04
        AbsMag        -21.34
        Axis    [  0.7486   0.6602  -0.0619]
        Angle    163.5801
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1217-1"
}

Galaxy "NGC 1217-2:ESO 300-10:MCG 7-7-2:AM 0304-391"
{
        Type  "Sb"
        RA            3.1014
        Dec         -39.0206
        Distance   2.125e+08  # distance uncertain!
        Radius     1.546e+04
        AbsMag        -19.07
        Axis    [  0.7719   0.5270   0.3555]
        Angle    168.0004
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1217-2"
}

Galaxy "NGC 1218:UGC 2555:MCG 1-9-1:ZWG 416.2"
{
        Type  "Sa"
        RA            3.1406
        Dec           4.1114
        Distance   3.828e+08  # method: V
        Radius     7.239e+04
        AbsMag        -21.05
        Axis    [  0.1039   0.6832  -0.7228]
        Angle    170.1933
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1218"
}

Galaxy "NGC 1219:UGC 2556:MCG 0-9-6:ZWG 390.6"
{
        Type  "Sc"
        RA            3.1411
        Dec           2.1081
        Distance   2.677e+08  # method: V
        Radius     3.893e+04
        AbsMag        -20.77
        Axis    [  0.6471   0.7472   0.1517]
        Angle    132.3392
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1219"
}

Galaxy "NGC 1221:MCG 1-9-2"
{
        Type  "Sa"
        RA            3.1375
        Dec          -4.2597
        Distance   2.125e+08  # distance uncertain!
        Radius      3.71e+04
        AbsMag        -19.07
        Axis    [ -0.0760   0.6334  -0.7701]
        Angle    145.6634
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1221"
}

Galaxy "NGC 1222:MCG 1-9-5:MK 603:KUG 0306-031"
{
        Type  "S0"
        RA            3.1489
        Dec          -2.9556
        Distance   1.031e+08  # method: V
        Radius      1.65e+04
        AbsMag           -19
        Axis    [  0.0943   0.5819  -0.8077]
        Angle    177.8132
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1222"
}

Galaxy "NGC 1223:MCG 1-9-3"
{
        Type  "E0"
        RA            3.1386
        Dec          -4.1386
        Distance   3.468e+08  # distance uncertain!
        Radius     6.052e+04
        AbsMag        -20.13
        Axis    [  0.9105   0.3573   0.2084]
        Angle    123.7291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1223"
}

Galaxy "NGC 1224:UGC 2578:MCG 7-7-34:ZWG 540.55"
{
        Type  "S0"
        RA            3.1869
        Dec          41.3633
        Distance   2.213e+08  # method: V
        Radius     3.219e+04
        AbsMag        -19.16
        Axis    [  0.5348   0.7097   0.4586]
        Angle     94.3359
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1224"
}

Galaxy "NGC 1225:MCG 1-9-4"
{
        Type  "Sb"
        RA            3.1464
        Dec          -4.1017
        Distance   2.555e+08  # distance uncertain!
        Radius     3.717e+04
        AbsMag        -19.07
        Axis    [  0.1380   0.7240  -0.6758]
        Angle    154.4201
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1225"
}

Galaxy "NGC 1226:UGC 2575:MCG 6-8-1:ZWG 525.2"
{
        Type  "E0"
        RA            3.1847
        Dec          35.3864
        Distance   2.188e+08  # distance uncertain!
        Radius     5.092e+04
        AbsMag        -20.13
        Axis    [  0.4816   0.7906  -0.3782]
        Angle    152.9612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1226"
}

Galaxy "NGC 1227:UGC 2577:ZWG 525.3:ZWG 524.62"
{
        Type  "SBa"
        RA            3.1853
        Dec          35.3253
        Distance    2.44e+08  # distance uncertain!
        Radius     3.549e+04
        AbsMag        -19.07
        Axis    [  0.4131   0.9026  -0.1211]
        Angle    122.7460
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1227"
}

Galaxy "NGC 1228:ESO 480-32:MCG 4-8-26:UGCA 54"
{
        Type  "SBa"
        RA            3.1364
        Dec         -22.9225
        Distance   4.631e+08  # method: V
        Radius     1.078e+05
        AbsMag        -21.56
        Axis    [  0.5300   0.8121  -0.2440]
        Angle    149.4570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1228"
}

Galaxy "NGC 1229:ESO 480-33:MCG 4-8-25:UGCA 53"
{
        Type  "SBb"
        RA            3.1361
        Dec         -22.9606
        Distance   4.725e+08  # method: V
        Radius     9.621e+04
        AbsMag         -20.9
        Axis    [  0.5800   0.7809  -0.2320]
        Angle    151.0562
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1229"
}

Galaxy "NGC 1230:ESO 480-34:MCG 4-8-27:ARP 332"
{
        Type  "S0"
        RA            3.1378
        Dec         -22.9839
        Distance   2.555e+08  # distance uncertain!
        Radius      2.23e+04
        AbsMag        -19.07
        Axis    [  0.3120   0.8361  -0.4512]
        Angle    140.8401
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1230"
}

Galaxy "NGC 1231:MCG 3-8-74"
{
        Type  "Sc"
        RA            3.1081
        Dec         -15.5692
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.9041   0.3269   0.2754]
        Angle    133.6580
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1231"
}

Galaxy "NGC 1232:ESO 547-14:MCG 4-8-32:ARP 41"
{
        Type  "SBc"
        RA            3.1625
        Dec         -20.5792
        Distance    6.36e+07  # method: T-F
        Radius     6.845e+04
        AbsMag        -20.95
        Axis    [  0.5610   0.6348  -0.5314]
        Angle    162.4223
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1232"
}

Galaxy "NGC 1232A:ESO 547-16:MCG 4-8-32:ARP 41"
{
        Type  "Irr"
        RA            3.1669
        Dec         -20.5994
        Distance   2.868e+08  # method: V
        Radius     3.755e+04
        AbsMag        -19.42
        Axis    [  0.7294   0.5953   0.3369]
        Angle    151.0333
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1232A"
}

Galaxy "NGC 1233:NGC 1235:UGC 2586:MCG 6-8-3"
{
        Type  "Sb"
        RA            3.2092
        Dec          39.3192
        Distance   1.947e+08  # method: V
        Radius     5.097e+04
        AbsMag        -19.98
        Axis    [  0.1465   0.8913   0.4292]
        Angle    115.4500
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1233"
}

Galaxy "NGC 1234:MCG 1-9-11"
{
        Type  "SBc"
        RA            3.1608
        Dec          -7.8458
        Distance    2.03e+08  # distance uncertain!
        Radius     5.314e+04
        AbsMag        -19.07
        Axis    [  0.1239   0.7289  -0.6733]
        Angle    148.5275
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1234"
}

Galaxy "NGC 1236:ZWG 441.3:NPM 1"
{
        Type  "S0"
        RA            3.1908
        Dec          10.8089
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.5286   0.8151   0.2370]
        Angle    127.1550
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1236"
}

Galaxy "NGC 1238:MCG 2-9-10:NPM 1"
{
        Type  "E0"
        RA            3.1811
        Dec         -10.7475
        Distance   2.512e+08  # distance uncertain!
        Radius     5.846e+04
        AbsMag        -20.13
        Axis    [  0.6574   0.5192  -0.5461]
        Angle    177.7472
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1238"
}

Galaxy "NGC 1239:MCG 1-9-12:NPM 1"
{
        Type  "S0"
        RA            3.1814
        Dec          -2.5525
        Distance   1.768e+08  # distance uncertain!
        Radius     3.085e+04
        AbsMag        -19.07
        Axis    [  0.4642   0.8797   0.1034]
        Angle    139.0378
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1239"
}

Galaxy "NGC 1241:MCG 2-9-11:VV 334:ARP 304"
{
        Type  "SBb"
        RA            3.1872
        Dec          -8.9222
        Distance   1.786e+08  # method: T-F
        Radius     8.831e+04
        AbsMag        -20.69
        Axis    [  0.0988   0.7096  -0.6977]
        Angle    147.3028
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1241"
}

Galaxy "NGC 1242:MCG 2-9-12:VV 334:ARP 304"
{
        Type  "SBc"
        RA            3.1886
        Dec          -8.9031
        Distance   1.702e+08  # method: V
        Radius     2.971e+04
        AbsMag        -19.19
        Axis    [  0.1832   0.7718  -0.6089]
        Angle    146.1032
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1242"
}

Galaxy "NGC 1244:ESO 82-8:AM 0305-665:IRAS 03058-6657"
{
        Type  "Sb"
        RA            3.1086
        Dec         -66.7758
        Distance   2.559e+08  # method: T-F
        Radius     7.071e+04
        AbsMag        -20.57
        Axis    [  0.5788   0.7814   0.2333]
        Angle    206.5683
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1244"
}

Galaxy "NGC 1246:ESO 82-9:FAIR 229"
{
        Type  "E5"
        RA            3.1172
        Dec         -66.9383
        Distance   2.386e+08  # method: V
        Radius     4.512e+04
        AbsMag        -20.42
        Axis    [  0.9872   0.1395   0.0779]
        Angle    184.7939
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1246"
}

Galaxy "NGC 1247:MCG 2-9-14:UGCA 58:FGC 396"
{
        Type  "Sc"
        RA            3.2039
        Dec         -10.4811
        Distance   2.353e+08  # method: T-F
        Radius     1.164e+05
        AbsMag        -20.79
        Axis    [  0.2455   0.9675  -0.0602]
        Angle    139.7779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1247"
}

Galaxy "NGC 1248:MCG 1-9-16"
{
        Type  "S0"
        RA            3.2133
        Dec          -5.2247
        Distance   9.341e+07  # method: V
        Radius      1.63e+04
        AbsMag        -18.78
        Axis    [  0.5231   0.7685  -0.3684]
        Angle    149.8398
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1248"
}

Galaxy "NGC 1249:ESO 155-6:IRAS 03085-5331"
{
        Type  "SBc"
        RA            3.1669
        Dec         -53.3361
        Distance   5.889e+07  # method: T-F
        Radius     4.026e+04
        AbsMag        -19.08
        Axis    [  0.6630   0.6495  -0.3722]
        Angle    160.3330
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1249"
}

Galaxy "NGC 1250:UGC 2613:MCG 7-7-40:ZWG 540.66"
{
        Type  "S0"
        RA            3.2558
        Dec          41.3556
        Distance   2.716e+08  # method: V
        Radius     8.295e+04
        AbsMag         -20.6
        Axis    [ -0.3975   0.7414  -0.5407]
        Angle    157.9815
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1250"
}

Galaxy "NGC 1253:MCG 1-9-18:UGCA 62:ARP 279"
{
        Type  "SBc"
        RA            3.2358
        Dec          -2.8231
        Distance   9.568e+07  # method: T-F
        Radius     7.375e+04
        AbsMag        -19.94
        Axis    [  0.3132   0.9275  -0.2043]
        Angle    137.7391
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1253"
}

Galaxy "NGC 1253A:MCG 1-9-19:DDO 31:VV 587"
{
        Type  "Irr"
        RA            3.2397
        Dec          -2.8011
        Distance   7.475e+07  # method: V
        Radius     1.413e+04
        AbsMag         -17.3
        Axis    [  0.4183   0.8768  -0.2371]
        Angle    140.5351
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1253A"
}

Galaxy "NGC 1254:MCG 0-9-33:ZWG 390.32"
{
        Type  "S0"
        RA            3.2397
        Dec           2.6778
        Distance    2.44e+08  # distance uncertain!
        Radius     2.839e+04
        AbsMag        -19.07
        Axis    [  0.6791   0.7339   0.0130]
        Angle    132.6640
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1254"
}

Galaxy "NGC 1255:ESO 481-13:MCG 4-8-50:UGCA 60"
{
        Type  "SBc"
        RA            3.2256
        Dec         -25.7244
        Distance   7.814e+07  # method: T-F
        Radius     4.774e+04
        AbsMag         -20.4
        Axis    [  0.3991   0.6735  -0.6223]
        Angle    151.9695
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1255"
}

Galaxy "NGC 1256:ESO 547-23:MCG 4-8-52"
{
        Type  "S0"
        RA            3.2328
        Dec         -21.9864
        Distance   1.882e+08  # method: V
        Radius     3.011e+04
        AbsMag        -19.21
        Axis    [  0.3160   0.8264  -0.4660]
        Angle    140.2550
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1256"
}

Galaxy "NGC 1258:ESO 547-24:MCG 4-8-53"
{
        Type  "SBc"
        RA            3.2347
        Dec         -21.7744
        Distance   9.871e+07  # method: T-F
        Radius     1.866e+04
        AbsMag         -18.4
        Axis    [  0.6968   0.6737   0.2462]
        Angle    152.7813
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1258"
}

Galaxy "NGC 1259:MCG 7-7-46:ARP 310"
{
        Type  "S0"
        RA            3.2881
        Dec          41.3856
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [  0.8288   0.5402   0.1460]
        Angle     81.7616
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1259"
}

Galaxy "NGC 1260:UGC 2634:MCG 7-7-47:ZWG 540.81"
{
        Type  "Sa"
        RA            3.2908
        Dec          41.4053
        Distance   2.617e+08  # method: T-F
        Radius     4.187e+04
        AbsMag        -20.32
        Axis    [ -0.0601   0.9938  -0.0934]
        Angle    126.7773
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1260"
}

Galaxy "NGC 1262:MCG 3-9-14:IRAS 03132-1604"
{
        Type  "Sc"
        RA            3.2592
        Dec         -15.8800
        Distance   2.125e+08  # distance uncertain!
        Radius     2.782e+04
        AbsMag        -19.07
        Axis    [  0.3328   0.6446  -0.6883]
        Angle    160.5202
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1262"
}

Galaxy "NGC 1263:MCG 3-9-15"
{
        Type  "SBa"
        RA            3.2608
        Dec         -15.0983
        Distance   2.125e+08  # distance uncertain!
        Radius     2.164e+04
        AbsMag        -19.07
        Axis    [  0.7661   0.5331   0.3591]
        Angle    142.7253
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1263"
}

Galaxy "NGC 1264:UGC 2643:MCG 7-7-50"
{
        Type  "SBb"
        RA            3.2997
        Dec          41.5203
        Distance   2.226e+08  # distance uncertain!
        Radius     3.237e+04
        AbsMag        -19.07
        Axis    [  0.2257   0.9072   0.3550]
        Angle    108.7811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1264"
}

Galaxy "NGC 1265:UGC 2651:MCG 7-7-52:ZWG 540.88"
{
        Type  "E0"
        RA            3.3042
        Dec          41.8578
        Distance   3.343e+08  # method: V
        Radius     8.751e+04
        AbsMag        -21.85
        Axis    [  0.1491   0.8218  -0.5499]
        Angle    207.2262
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1265"
}

Galaxy "NGC 1266:MCG 1-9-23:IRAS 03134-0236"
{
        Type  "S0"
        RA            3.2667
        Dec          -2.4267
        Distance   1.341e+08  # distance uncertain!
        Radius     3.121e+04
        AbsMag        -19.07
        Axis    [  0.2668   0.8195  -0.5073]
        Angle    146.9459
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1266"
}

Galaxy "NGC 1267:UGC 2657:MCG 7-7-55:ZWG 540.92"
{
        Type  "E0"
        RA            3.3122
        Dec          41.4675
        Distance   2.221e+08  # method: V
        Radius     3.553e+04
        AbsMag        -20.06
        Axis    [  0.7239   0.6837  -0.0924]
        Angle     99.4210
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1267"
}

Galaxy "NGC 1268:UGC 2658:MCG 7-7-56:ZWG 540.93"
{
        Type  "Sb"
        RA            3.3125
        Dec          41.4892
        Distance   1.344e+08  # method: V
        Radius     1.759e+04
        AbsMag        -18.47
        Axis    [ -0.0626   0.9270  -0.3697]
        Angle    148.1719
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1268"
}

Galaxy "NGC 1269:NGC 1291:ESO 301-2:MCG 7-7-8"
{
        Type  "SBa"
        RA            3.2883
        Dec         -41.1072
        Distance   3.289e+07  # method: V
        Radius     5.262e+04
        AbsMag        -20.61
        Axis    [  0.7887   0.5441  -0.2861]
        Angle    164.4533
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1269"
}

Galaxy "NGC 1270:UGC 2660:MCG 7-7-57:ZWG 540.95"
{
        Type  "E0"
        RA            3.3161
        Dec          41.4703
        Distance   2.617e+08  # method: T-F
        Radius     3.426e+04
        AbsMag        -20.22
        Axis    [  0.7899   0.6132   0.0030]
        Angle     89.6270
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1270"
}

Galaxy "NGC 1271:ZWG 540.96"
{
        Type  "S0"
        RA            3.3197
        Dec          41.3536
        Distance   2.528e+08  # method: V
        Radius     1.838e+04
        AbsMag        -19.25
        Axis    [ -0.2475   0.8968  -0.3667]
        Angle    144.7069
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1271"
}

Galaxy "NGC 1272:UGC 2662:MCG 7-7-58:ZWG 540.98"
{
        Type  "E0"
        RA            3.3225
        Dec          41.4906
        Distance   2.617e+08  # method: T-F
        Radius     8.375e+04
        AbsMag        -21.52
        Axis    [  0.8490   0.5158   0.1147]
        Angle     81.0573
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1272"
}

Galaxy "NGC 1273:MCG 7-7-59:ZWG 540.99"
{
        Type  "S0"
        RA            3.3239
        Dec          41.5400
        Distance   2.617e+08  # method: T-F
        Radius     3.045e+04
        AbsMag        -20.22
        Axis    [ -0.0007   0.8627  -0.5057]
        Angle    173.0647
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1273"
}

Galaxy "NGC 1274:MCG 7-7-62:ZWG 540.102"
{
        Type  "E3"
        RA            3.3278
        Dec          41.5494
        Distance   2.617e+08  # method: T-F
        Radius     3.045e+04
        AbsMag        -19.42
        Axis    [  0.6886   0.7118  -0.1381]
        Angle    104.7929
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1274"
}

Galaxy "NGC 1275:UGC 2669:MCG 7-7-63:ZWG 540.103"
{
        Type  "S0"
        RA            3.3300
        Dec          41.5114
        Distance   2.312e+08  # method: V
        Radius     7.735e+04
        AbsMag        -21.55
        Axis    [ -0.0037   0.9478  -0.3188]
        Angle    142.6059
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1275"
}

Galaxy "NGC 1277:MCG 7-7-64:ZWG 540.104"
{
        Type  "Sa"
        RA            3.3308
        Dec          41.5742
        Distance   2.186e+08  # method: V
        Radius     2.544e+04
        AbsMag        -19.43
        Axis    [ -0.1351   0.9843  -0.1133]
        Angle    128.0605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1277"
}

Galaxy "NGC 1278:IC 1907:UGC 2670:MCG 7-7-65"
{
        Type  "E0"
        RA            3.3317
        Dec          41.5636
        Distance   2.617e+08  # method: T-F
        Radius     5.329e+04
        AbsMag        -20.92
        Axis    [  0.4147   0.8215  -0.3915]
        Angle    154.6866
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1278"
}

Galaxy "NGC 1279:PGC 12449"
{
        Type  "S0"
        RA            3.3331
        Dec          41.4797
        Distance   3.072e+08  # distance uncertain!
        Radius     2.681e+04
        AbsMag        -19.07
        Axis    [  0.4565   0.7147   0.5299]
        Angle     99.0608
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1279"
}

Galaxy "NGC 1280:UGC 2652:MCG 0-9-50:ZWG 390.51"
{
        Type  "SBc"
        RA            3.2992
        Dec          -0.1689
        Distance   3.032e+08  # method: V
        Radius     3.968e+04
        AbsMag        -20.74
        Axis    [  0.6700   0.7344  -0.1082]
        Angle    137.5535
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1280"
}

Galaxy "NGC 1281:MCG 7-7-67:ZWG 540.108"
{
        Type  "E5"
        RA            3.3350
        Dec          41.6297
        Distance   1.832e+08  # method: V
        Radius     2.399e+04
        AbsMag        -18.95
        Axis    [  0.5647   0.7806  -0.2678]
        Angle    125.6612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1281"
}

Galaxy "NGC 1282:UGC 2675:MCG 7-7-68:ZWG 540.109"
{
        Type  "E0"
        RA            3.3367
        Dec          41.3669
        Distance   2.617e+08  # method: T-F
        Radius     4.568e+04
        AbsMag        -20.82
        Axis    [  0.7487   0.6599  -0.0632]
        Angle     95.8927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1282"
}

Galaxy "NGC 1283:UGC 2676:MCG 7-7-69:ZWG 540.110"
{
        Type  "E1"
        RA            3.3375
        Dec          41.3986
        Distance   2.617e+08  # method: T-F
        Radius     2.665e+04
        AbsMag        -19.72
        Axis    [  0.5364   0.7906  -0.2953]
        Angle    131.2360
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1283"
}

Galaxy "NGC 1284:MCG 2-9-22:NPM 1"
{
        Type  "S0"
        RA            3.2958
        Dec         -10.2886
        Distance   1.938e+08  # distance uncertain!
        Radius     3.665e+04
        AbsMag        -19.07
        Axis    [  0.6480   0.7456   0.1551]
        Angle    142.0067
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1284"
}

Galaxy "NGC 1285:MCG 1-9-26:IRAS 03154-0728"
{
        Type  "SBb"
        RA            3.2981
        Dec          -7.2975
        Distance   2.297e+08  # method: V
        Radius     5.012e+04
        AbsMag        -20.64
        Axis    [  0.6525   0.7489   0.1155]
        Angle    139.2336
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1285"
}

Galaxy "NGC 1286:MCG 1-9-25:NPM 1"
{
        Type  "S0"
        RA            3.2967
        Dec          -7.6164
        Distance   1.938e+08  # distance uncertain!
        Radius     2.537e+04
        AbsMag        -19.07
        Axis    [  0.1971   0.6381  -0.7443]
        Angle    164.9020
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1286"
}

Galaxy "NGC 1287:KUG 0316-029"
{
        Type  "Sa"
        RA            3.3092
        Dec          -2.7306
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.3369   0.6975  -0.6325]
        Angle    164.6162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1287"
}

Galaxy "NGC 1288:ESO 357-13:MCG 5-8-25:AM 0315-324"
{
        Type  "SBc"
        RA            3.2869
        Dec         -32.5764
        Distance   1.996e+08  # method: V
        Radius     6.675e+04
        AbsMag        -21.13
        Axis    [  0.2551   0.4065  -0.8773]
        Angle    168.5177
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1288"
}

Galaxy "NGC 1289:IC 314:UGC 2666:MCG 0-9-54"
{
        Type  "S0"
        RA            3.3136
        Dec          -1.9731
        Distance   1.205e+08  # method: V
        Radius     3.154e+04
        AbsMag        -19.34
        Axis    [  0.3264   0.8581  -0.3963]
        Angle    142.4413
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1289"
}

Galaxy "NGC 1290:NPM 1"
{
        Type  "E0"
        RA            3.3236
        Dec         -13.9892
        Distance   5.012e+08  # distance uncertain!
        Radius     3.645e+04
        AbsMag        -20.13
        Axis    [  0.7774   0.4781  -0.4088]
        Angle    165.0884
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1290"
}

Galaxy "NGC 1292:ESO 418-1:MCG 5-8-26:IRAS 03161-2747"
{
        Type  "Sc"
        RA            3.3039
        Dec         -27.6106
        Distance   7.543e+07  # method: T-F
        Radius     3.291e+04
        AbsMag        -19.12
        Axis    [  0.6117   0.7172   0.3339]
        Angle    164.2176
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1292"
}

Galaxy "NGC 1293:MCG 7-7-75:ZWG 540.116:NPM 1"
{
        Type  "E0"
        RA            3.3600
        Dec          41.3933
        Distance   2.617e+08  # method: T-F
        Radius     3.426e+04
        AbsMag        -20.02
        Axis    [  0.8529   0.5096   0.1137]
        Angle     80.9010
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1293"
}

Galaxy "NGC 1294:UGC 2694:MCG 7-7-76:ZWG 540.117"
{
        Type  "S0"
        RA            3.3611
        Dec          41.3606
        Distance   2.902e+08  # method: V
        Radius     4.643e+04
        AbsMag        -20.35
        Axis    [  0.5015   0.7049   0.5016]
        Angle     96.3633
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1294"
}

Galaxy "NGC 1295:MCG 2-9-30:NPM 1:IRAS 03177-1410"
{
        Type  "S0"
        RA            3.3342
        Dec         -13.9978
        Distance    2.44e+08  # distance uncertain!
        Radius     3.194e+04
        AbsMag        -19.07
        Axis    [  0.0050   0.5105  -0.8598]
        Angle    155.2980
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1295"
}

Galaxy "NGC 1296:MCG 2-9-25:IRAS 03164-1314"
{
        Type  "Sb"
        RA            3.3136
        Dec         -13.0622
        Distance   2.125e+08  # distance uncertain!
        Radius       3.4e+04
        AbsMag        -19.07
        Axis    [  0.7425   0.5592   0.3687]
        Angle    142.0809
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1296"
}

Galaxy "NGC 1297:ESO 547-30:MCG 3-9-17"
{
        Type  "S0"
        RA            3.3206
        Dec         -19.1000
        Distance   9.321e+07  # method: S
        Radius     3.118e+04
        AbsMag        -19.48
        Axis    [  0.7636   0.5524   0.3342]
        Angle    147.2434
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1297"
}

Galaxy "NGC 1298:UGC 2683:MCG 0-9-62:ZWG 390.63"
{
        Type  "E0"
        RA            3.3369
        Dec          -2.1136
        Distance   2.878e+08  # method: V
        Radius     4.605e+04
        AbsMag        -19.93
        Axis    [  0.7865   0.5353  -0.3079]
        Angle    151.1937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1298"
}

Galaxy "NGC 1299:MCG 1-9-28:KUG 0317-064:IRAS 03176-0626"
{
        Type  "Sb"
        RA            3.3358
        Dec          -6.2619
        Distance   1.223e+08  # distance uncertain!
        Radius     2.135e+04
        AbsMag        -19.07
        Axis    [  0.4948   0.8655   0.0787]
        Angle    139.5905
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1299"
}

Galaxy "NGC 1300:ESO 547-31:MCG 3-9-18:UGCA 66"
{
        Type  "SBc"
        RA            3.3278
        Dec         -19.4114
        Distance   6.804e+07  # method: T-F
        Radius     6.136e+04
        AbsMag        -20.49
        Axis    [  0.4460   0.7450  -0.4961]
        Angle    149.0163
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1300"
}

Galaxy "NGC 1301:ESO 547-32:MCG 3-9-22:IRAS 03183-1853"
{
        Type  "SBc"
        RA            3.3431
        Dec         -18.7158
        Distance   1.895e+08  # method: T-F
        Radius     6.065e+04
        AbsMag        -19.72
        Axis    [  0.0738   0.7435  -0.6647]
        Angle    129.8898
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1301"
}

Galaxy "NGC 1302:ESO 481-20:MCG 4-8-58:IRAS 03177-2614"
{
        Type  "SBa"
        RA            3.3308
        Dec         -26.0606
        Distance   7.076e+07  # method: V
        Radius     4.014e+04
        AbsMag        -20.08
        Axis    [  0.8531   0.4147   0.3166]
        Angle    148.3773
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1302"
}

Galaxy "NGC 1303:MCG 1-9-29:NPM 1"
{
        Type  "S0"
        RA            3.3444
        Dec          -7.3942
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.6759   0.7195   0.1599]
        Angle    138.5014
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1303"
}

Galaxy "NGC 1304:NGC 1307:MCG 1-9-30:NPM 1"
{
        Type  "S0"
        RA            3.3533
        Dec          -4.5836
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.5184   0.8542   0.0396]
        Angle    137.8434
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1304"
}

Galaxy "NGC 1305:UGC 2697:MCG 0-9-69:ZWG 390.72"
{
        Type  "S0"
        RA            3.3561
        Dec          -2.3164
        Distance   1.017e+08  # distance uncertain!
        Radius     2.219e+04
        AbsMag        -19.07
        Axis    [  0.2114   0.7619  -0.6123]
        Angle    151.5376
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1305"
}

Galaxy "NGC 1306:ESO 481-23:IRAS 03188-2541"
{
        Type  "Sb"
        RA            3.3508
        Dec         -25.5122
        Distance   1.115e+08  # distance uncertain!
        Radius     1.298e+04
        AbsMag        -19.07
        Axis    [  0.9239   0.2736   0.2675]
        Angle    142.2848
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1306"
}

Galaxy "NGC 1308:MCG 1-9-32"
{
        Type  "Sa"
        RA            3.3744
        Dec          -2.7572
        Distance   1.768e+08  # distance uncertain!
        Radius     3.085e+04
        AbsMag        -19.07
        Axis    [  0.5865   0.8055  -0.0844]
        Angle    137.3544
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1308"
}

Galaxy "NGC 1309:MCG 3-9-28:IRAS 03197-1534"
{
        Type  "Sc"
        RA            3.3683
        Dec         -15.4000
        Distance   8.965e+07  # method: V
        Radius     2.999e+04
        AbsMag        -19.89
        Axis    [  0.8231   0.5633  -0.0726]
        Angle    145.7129
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1309"
}

Galaxy "NGC 1310:ESO 357-19:MCG 6-8-4:IRAS 03191-3716"
{
        Type  "SBc"
        RA            3.3508
        Dec         -37.1022
        Distance    6.84e+07  # method: T-F
        Radius      1.89e+04
        AbsMag        -18.81
        Axis    [  0.6555   0.5965  -0.4631]
        Angle    159.1395
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1310"
}

Galaxy "NGC 1311:ESO 200-7:IRAS 03186-5222"
{
        Type  "Irr"
        RA            3.3350
        Dec         -52.1872
        Distance   1.853e+07  # method: T-F
        Radius          8084
        AbsMag        -15.37
        Axis    [  0.6004   0.7997   0.0017]
        Angle    172.3966
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1311"
}

Galaxy "NGC 1313:ESO 82-11:VV 436:AM 0317-664"
{
        Type  "SBc"
        RA            3.3044
        Dec         -66.4953
        Distance   1.898e+07  # method: V
        Radius      2.54e+04
        AbsMag        -19.02
        Axis    [  0.8768   0.4804  -0.0215]
        Angle    184.4931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1313"
}

Galaxy "NGC 1313A:ESO 83-1:IRAS 03195-6652"
{
        Type  "SBb"
        RA            3.3347
        Dec         -66.7019
        Distance   1.851e+08  # distance uncertain!
        Radius     3.231e+04
        AbsMag        -19.07
        Axis    [  0.6477   0.7617   0.0202]
        Angle    187.6856
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1313A"
}

Galaxy "NGC 1314:MCG 1-9-33"
{
        Type  "Sc"
        RA            3.3781
        Dec          -4.1864
        Distance   1.645e+08  # method: V
        Radius      3.59e+04
        AbsMag        -18.61
        Axis    [  0.5942   0.6968  -0.4017]
        Angle    152.3484
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1314"
}

Galaxy "NGC 1315:ESO 548-3:MCG 4-9-2:NPM 1"
{
        Type  "SBa"
        RA            3.3850
        Dec         -21.3747
        Distance   7.067e+07  # method: V
        Radius     1.645e+04
        AbsMag        -18.18
        Axis    [  0.7619   0.6339  -0.1326]
        Angle    150.3648
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1315"
}

Galaxy "NGC 1316:ESO 357-22:MCG 6-8-8:ARP 154"
{
        Type  "S0"
        RA            3.3781
        Dec         -37.2078
        Distance   7.006e+07  # method: S
        Radius     1.121e+05
        AbsMag        -22.26
        Axis    [  0.7188   0.6914  -0.0729]
        Angle    159.2628
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1316"
}

Galaxy "NGC 1316A:MCG 6-8-8:FCC 192:IRAS 03217-3704"
{
        Type  "Sa"
        RA            3.3936
        Dec         -36.9039
        Distance    2.03e+08  # distance uncertain!
        Radius     2.066e+04
        AbsMag        -19.07
        Axis    [  0.5943   0.7938  -0.1290]
        Angle    154.9052
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1316A"
}

Galaxy "NGC 1316B:MCG 6-8-9"
{
        Type  "Sb"
        RA            3.3942
        Dec         -36.9086
        Distance   2.226e+08  # distance uncertain!
        Radius     1.295e+04
        AbsMag        -19.07
        Axis    [  0.7723   0.5613   0.2974]
        Angle    165.3114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1316B"
}

Galaxy "NGC 1316C:ESO 357-27:MCG 6-8-12:FCC 33"
{
        Type  "S0"
        RA            3.4161
        Dec         -37.0092
        Distance   8.435e+07  # method: V
        Radius     1.963e+04
        AbsMag        -17.66
        Axis    [  0.5383   0.7716  -0.3391]
        Angle    148.2214
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1316C"
}

Galaxy "NGC 1317:NGC 1318:ESO 357-23:MCG 6-8-6"
{
        Type  "SBa"
        RA            3.3789
        Dec         -37.1033
        Distance   8.272e+07  # method: V
        Radius     3.369e+04
        AbsMag        -20.02
        Axis    [  0.7513   0.5664  -0.3389]
        Angle    161.3079
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1317"
}

Galaxy "NGC 1319:ESO 548-6:MCG 4-9-3"
{
        Type  "S0"
        RA            3.3989
        Dec         -21.5272
        Distance   1.773e+08  # method: V
        Radius     3.352e+04
        AbsMag        -19.78
        Axis    [  0.6249   0.7603   0.1771]
        Angle    152.1355
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1319"
}

Galaxy "NGC 1320:MCG 1-9-36:MK 607:KUG 0322-032"
{
        Type  "Sa"
        RA            3.4133
        Dec          -3.0425
        Distance   1.017e+08  # distance uncertain!
        Radius     2.811e+04
        AbsMag        -19.07
        Axis    [  0.0453   0.7918  -0.6091]
        Angle    138.3297
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1320"
}

Galaxy "NGC 1321:MCG 1-9-35:MK 608:KUG 0322-031"
{
        Type  "Sa"
        RA            3.4133
        Dec          -3.0153
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.3720   0.8874  -0.2722]
        Angle    137.6907
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1321"
}

Galaxy "NGC 1322:MCG 1-9-37:NPM 1"
{
        Type  "S0"
        RA            3.4150
        Dec          -2.9186
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.3664   0.7573  -0.5406]
        Angle    152.8324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1322"
}

Galaxy "NGC 1323:NPM 1"
{
        Type  "S0"
        RA            3.4156
        Dec          -2.8217
        Distance   3.527e+08  # distance uncertain!
        Radius     4.617e+04
        AbsMag        -19.07
        Axis    [  0.2416   0.9437  -0.2261]
        Angle    133.6034
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1323"
}

Galaxy "NGC 1324:MCG 1-9-38:IRAS 03225-0555"
{
        Type  "Sb"
        RA            3.4169
        Dec          -5.7453
        Distance     2.5e+08  # method: V
        Radius     7.636e+04
        AbsMag        -20.92
        Axis    [  0.0726   0.7807  -0.6207]
        Angle    138.5393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1324"
}

Galaxy "NGC 1325:ESO 548-7:MCG 4-9-4:UGCA 70"
{
        Type  "SBc"
        RA            3.4069
        Dec         -21.5431
        Distance   8.064e+07  # method: T-F
        Radius     5.629e+04
        AbsMag        -19.76
        Axis    [  0.4684   0.8829  -0.0325]
        Angle    146.4138
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1325"
}

Galaxy "NGC 1325A:ESO 548-10:MCG 4-9-6:"
{
        Type  "SBb"
        RA            3.4133
        Dec         -21.3364
        Distance   1.017e+08  # distance uncertain!
        Radius     3.107e+04
        AbsMag        -19.07
        Axis    [  0.3700   0.5285  -0.7640]
        Angle    171.2535
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1325A"
}

Galaxy "NGC 1326:ESO 357-26:MCG 6-8-11:IRAS 03220-3638"
{
        Type  "S0"
        RA            3.3989
        Dec         -36.4642
        Distance   5.817e+07  # method: T-F
        Radius     3.299e+04
        AbsMag        -19.75
        Axis    [  0.6962   0.6450  -0.3153]
        Angle    157.0689
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1326"
}

Galaxy "NGC 1326A:ESO 357-28:MCG 6-8-13:AM 0323-363"
{
        Type  "Irr"
        RA            3.4189
        Dec         -36.3644
        Distance   7.792e+07  # method: V
        Radius     2.153e+04
        AbsMag        -18.09
        Axis    [  0.8396   0.5317  -0.1113]
        Angle    160.4526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1326A"
}

Galaxy "NGC 1326B:ESO 357-29:MCG 6-8-14:AM 0323-363"
{
        Type  "SBc"
        RA            3.4219
        Dec         -36.3844
        Distance   4.023e+07  # method: V
        Radius     2.106e+04
        AbsMag        -17.15
        Axis    [  0.3037   0.6898  -0.6573]
        Angle    133.6711
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1326B"
}

Galaxy "NGC 1327:ESO 481-26:MCG 4-9-8:IRAS 03232-2551"
{
        Type  "SBb"
        RA            3.4231
        Dec         -25.6794
        Distance   2.802e+08  # distance uncertain!
        Radius     4.075e+04
        AbsMag        -19.07
        Axis    [ -0.0107   0.4696  -0.8828]
        Angle    133.5309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1327"
}

Galaxy "NGC 1328:NPM 1"
{
        Type  "S0"
        RA            3.4275
        Dec          -4.1244
        Distance   2.125e+08  # distance uncertain!
        Radius     3.091e+04
        AbsMag        -19.07
        Axis    [  0.1684   0.7523  -0.6369]
        Angle    148.3400
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1328"
}

Galaxy "NGC 1329:ESO 548-15:MCG 3-9-42"
{
        Type  "Sa"
        RA            3.4339
        Dec         -17.5917
        Distance    1.87e+08  # method: V
        Radius     3.808e+04
        AbsMag        -20.29
        Axis    [  0.7766   0.6283   0.0460]
        Angle    145.0616
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1329"
}

Galaxy "NGC 1331:IC 324:ESO 548-19:MCG 4-9-12"
{
        Type  "E2"
        RA            3.4411
        Dec         -21.3556
        Distance   7.472e+07  # method: S
        Radius          9781
        AbsMag         -17.4
        Axis    [  0.9393   0.2634   0.2197]
        Angle    138.2098
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1331"
}

Galaxy "NGC 1332:ESO 548-18:MCG 4-9-11:UGCA 72"
{
        Type  "S0"
        RA            3.4381
        Dec         -21.3344
        Distance   7.472e+07  # method: S
        Radius      4.89e+04
        AbsMag         -20.5
        Axis    [  0.2545   0.8181  -0.5158]
        Angle    134.6396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1332"
}

Galaxy "NGC 1334:UGC 2759:MCG 7-8-18:ZWG 541.17"
{
        Type  "Sc"
        RA            3.5003
        Dec          41.8325
        Distance   1.852e+08  # method: V
        Radius      4.04e+04
        AbsMag        -19.17
        Axis    [ -0.1694   0.9402  -0.2956]
        Angle    137.5545
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1334"
}

Galaxy "NGC 1335:UGC 2762:MCG 7-8-19:ZWG 541.18"
{
        Type  "S0"
        RA            3.5053
        Dec          41.5733
        Distance     2.4e+08  # method: V
        Radius     3.839e+04
        AbsMag        -18.93
        Axis    [ -0.3177   0.7226  -0.6139]
        Angle    174.3495
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1335"
}

Galaxy "NGC 1336:ESO 358-2:MCG 6-8-16:FCC 47"
{
        Type  "S0"
        RA            3.4422
        Dec         -35.7133
        Distance   6.158e+07  # method: S
        Radius     1.881e+04
        AbsMag        -18.28
        Axis    [  0.7656   0.6236   0.1578]
        Angle    161.9313
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1336"
}

Galaxy "NGC 1337:MCG 2-9-42"
{
        Type  "SBc"
        RA            3.4681
        Dec          -8.3883
        Distance   6.265e+07  # method: T-F
        Radius     5.194e+04
        AbsMag        -18.82
        Axis    [ -0.0109   0.7440  -0.6680]
        Angle    132.5479
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1337"
}

Galaxy "NGC 1338:MCG 2-9-44:IRAS 03265-1219"
{
        Type  "Sb"
        RA            3.4817
        Dec         -12.1531
        Distance   1.064e+08  # method: V
        Radius     2.166e+04
        AbsMag        -18.87
        Axis    [  0.7655   0.6256  -0.1501]
        Angle    144.2725
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1338"
}

Galaxy "NGC 1339:ESO 418-4:MCG 5-9-4:FCC 63"
{
        Type  "E0"
        RA            3.4683
        Dec         -32.2856
        Distance   6.846e+07  # method: S
        Radius     1.494e+04
        AbsMag        -19.11
        Axis    [  0.3154   0.2982  -0.9009]
        Angle    202.1023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1339"
}

Galaxy "NGC 1341:ESO 358-8:MCG 6-8-20:IRAS 03260-3719"
{
        Type  "SBb"
        RA            3.4661
        Dec         -37.1494
        Distance   7.928e+07  # method: V
        Radius     1.384e+04
        AbsMag        -19.63
        Axis    [  0.7427   0.5024  -0.4427]
        Angle    164.2911
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1341"
}

Galaxy "NGC 1343:UGC 2792:MCG 12-4-1:ZWG 327.5"
{
        Type  "SBb"
        RA            3.6303
        Dec          72.5714
        Distance   9.663e+07  # method: V
        Radius     3.654e+04
        AbsMag        -18.76
        Axis    [ -0.1981   0.9794   0.0380]
        Angle    115.1090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1343"
}

Galaxy "NGC 1344:NGC 1340:ESO 418-5:MCG 5-9-5"
{
        Type  "E5"
        RA            3.4719
        Dec         -31.0681
        Distance   6.448e+07  # method: S
        Radius     4.502e+04
        AbsMag        -20.08
        Axis    [  0.3656   0.3186  -0.8745]
        Angle    200.0991
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1344"
}

Galaxy "NGC 1345:ESO 548-26:MCG 3-9-46:UGCA 74"
{
        Type  "SBc"
        RA            3.4919
        Dec         -17.7792
        Distance   6.279e+07  # method: V
        Radius      1.37e+04
        AbsMag        -17.22
        Axis    [  0.4594   0.7152  -0.5267]
        Angle    149.7989
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1345"
}

Galaxy "NGC 1346:MCG 1-9-42:KUG 0327-057:IRAS 03277-0542"
{
        Type  "Sb"
        RA            3.5036
        Dec          -5.5431
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.4716   0.8230  -0.3167]
        Angle    140.7404
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1346"
}

Galaxy "NGC 1347-1:ESO 548-27:MCG 4-9-17:VV 23"
{
        Type  "SBc"
        RA            3.4947
        Dec         -22.2792
        Distance   7.425e+07  # method: V
        Radius      1.62e+04
        AbsMag        -18.09
        Axis    [  0.8126   0.5348   0.2317]
        Angle    147.6762
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1347-1"
}

Galaxy "NGC 1347-2:ESO 548-27:MCG 4-9-17:VV 23"
{
        Type  "S0"
        RA            3.4947
        Dec         -22.2908
        Distance   3.369e+08  # distance uncertain!
        Radius      1.47e+04
        AbsMag        -19.07
        Axis    [  0.7040   0.6795   0.2068]
        Angle    151.2419
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1347-2"
}

Galaxy "NGC 1349:UGC 2774:MCG 1-9-6:ZWG 416.13"
{
        Type  "S0"
        RA            3.5242
        Dec           4.3814
        Distance   2.914e+08  # method: V
        Radius      3.39e+04
        AbsMag        -20.55
        Axis    [  0.9124   0.3494   0.2133]
        Angle    113.8700
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1349"
}

Galaxy "NGC 1350:ESO 358-13:MCG 6-8-23:AM 0329-334"
{
        Type  "SBb"
        RA            3.5186
        Dec         -33.6272
        Distance   7.846e+07  # method: T-F
        Radius     6.733e+04
        AbsMag         -20.7
        Axis    [  0.1318   0.4339  -0.8913]
        Angle    143.8833
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1350"
}

Galaxy "NGC 1351:ESO 358-12:MCG 6-8-22:FCC 83"
{
        Type  "S0"
        RA            3.5094
        Dec         -34.8533
        Distance   6.846e+07  # method: S
        Radius     2.788e+04
        AbsMag        -19.11
        Axis    [  0.3422   0.5573  -0.7565]
        Angle    147.5197
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1351"
}

Galaxy "NGC 1351A:ESO 358-9:MCG 6-8-21:FCC 67"
{
        Type  "SBc"
        RA            3.4800
        Dec         -35.1778
        Distance   7.864e+07  # method: T-F
        Radius     2.974e+04
        AbsMag        -17.71
        Axis    [  0.2251   0.7292  -0.6462]
        Angle    125.5295
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1351A"
}

Galaxy "NGC 1352:ESO 548-30:MCG 3-10-2:NPM 1"
{
        Type  "S0"
        RA            3.5256
        Dec         -19.2778
        Distance   1.916e+08  # method: V
        Radius     2.786e+04
        AbsMag        -19.54
        Axis    [  0.4112   0.7006  -0.5831]
        Angle    149.2507
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1352"
}

Galaxy "NGC 1353:ESO 548-31:MCG 4-9-22:UGCA 76"
{
        Type  "SBb"
        RA            3.5342
        Dec         -20.8189
        Distance   9.115e+07  # method: T-F
        Radius     4.507e+04
        AbsMag        -19.93
        Axis    [  0.1840   0.6961  -0.6940]
        Angle    137.3257
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1353"
}

Galaxy "NGC 1354:MCG 3-10-4:IRAS 03301-1523"
{
        Type  "Sa"
        RA            3.5414
        Dec         -15.2208
        Distance   7.524e+07  # method: V
        Radius     2.517e+04
        AbsMag        -18.61
        Axis    [  0.0528   0.6708  -0.7398]
        Angle    135.5830
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1354"
}

Galaxy "NGC 1355:MCG 1-10-2"
{
        Type  "S0"
        RA            3.5564
        Dec          -4.9983
        Distance    1.54e+08  # distance uncertain!
        Radius     3.359e+04
        AbsMag        -19.07
        Axis    [  0.2521   0.9564  -0.1477]
        Angle    131.9037
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1355"
}

Galaxy "NGC 1356:ESO 200-31:AM 0329-502:IRAS 03291-5028"
{
        Type  "SBc"
        RA            3.5111
        Dec         -50.3092
        Distance   5.162e+08  # method: V
        Radius     1.276e+05
        AbsMag         -22.2
        Axis    [  0.2192   0.3140  -0.9238]
        Angle    139.6766
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1356"
}

Galaxy "NGC 1357:MCG 2-10-1:IRAS 03309-1349"
{
        Type  "Sb"
        RA            3.5547
        Dec         -13.6644
        Distance   8.421e+07  # method: V
        Radius      3.92e+04
        AbsMag        -19.66
        Axis    [  0.5510   0.7574  -0.3504]
        Angle    144.8878
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1357"
}

Galaxy "NGC 1358:MCG 1-10-3"
{
        Type  "SBa"
        RA            3.5608
        Dec          -5.0889
        Distance   1.752e+08  # method: V
        Radius     5.352e+04
        AbsMag        -20.65
        Axis    [  0.6613   0.6452   0.3825]
        Angle    138.1415
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1358"
}

Galaxy "NGC 1359:ESO 548-39:MCG 3-10-7:IRAS 03315-1939"
{
        Type  "Irr"
        RA            3.5631
        Dec         -19.4908
        Distance   1.538e+08  # method: T-F
        Radius     5.591e+04
        AbsMag        -20.77
        Axis    [  0.2424   0.6525  -0.7180]
        Angle    146.7954
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1359"
}

Galaxy "NGC 1361:MCG 1-10-5:NPM 1"
{
        Type  "E0"
        RA            3.5714
        Dec          -6.2644
        Distance   3.312e+08  # distance uncertain!
        Radius     7.706e+04
        AbsMag        -20.13
        Axis    [  0.8985   0.4259  -0.1067]
        Angle    137.0940
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1361"
}

Galaxy "NGC 1362:ESO 548-41:MCG 3-10-8:NPM 1"
{
        Type  "S0"
        RA            3.5647
        Dec         -20.2822
        Distance   4.979e+07  # method: V
        Radius          8689
        AbsMag        -17.22
        Axis    [  0.8434   0.4736   0.2537]
        Angle    143.7893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1362"
}

Galaxy "NGC 1363:IRAS 03324-1000"
{
        Type  "Sc"
        RA            3.5803
        Dec          -9.8422
        Distance   1.281e+08  # distance uncertain!
        Radius     1.676e+04
        AbsMag        -19.07
        Axis    [  0.6104   0.7609  -0.2203]
        Angle    141.1777
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1363"
}

Galaxy "NGC 1364"
{
        Type  "Sc"
        RA            3.5831
        Dec          -9.8389
        Distance   2.555e+08  # distance uncertain!
        Radius     1.858e+04
        AbsMag        -19.07
        Axis    [  0.9270   0.2976   0.2281]
        Angle    126.9925
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1364"
}

Galaxy "NGC 1365:ESO 358-17:MCG 6-8-26:VV 825"
{
        Type  "SBb"
        RA            3.5600
        Dec         -36.1408
        Distance   4.657e+07  # method: T-F
        Radius     7.451e+04
        AbsMag        -20.47
        Axis    [  0.6998   0.7098   0.0800]
        Angle    160.5832
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1365"
}

Galaxy "NGC 1366:ESO 418-10:MCG 5-9-13"
{
        Type  "S0"
        RA            3.5647
        Dec         -31.1933
        Distance   6.878e+07  # method: S
        Radius     2.101e+04
        AbsMag        -19.62
        Axis    [  0.6254   0.6994   0.3460]
        Angle    167.8018
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1366"
}

Galaxy "NGC 1368:MCG 3-10-12:NPM 1"
{
        Type  "Sa"
        RA            3.5828
        Dec         -15.6556
        Distance    2.33e+08  # distance uncertain!
        Radius     4.406e+04
        AbsMag        -19.07
        Axis    [  0.3158   0.8180  -0.4807]
        Angle    137.5204
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1368"
}

Galaxy "NGC 1369:ESO 358-34:MCG 6-9-4:FCC 176"
{
        Type  "SBa"
        RA            3.6125
        Dec         -36.2556
        Distance   5.948e+07  # method: V
        Radius     1.298e+04
        AbsMag         -17.5
        Axis    [  0.8877   0.4187   0.1915]
        Angle    157.8828
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1369"
}

Galaxy "NGC 1370:ESO 548-48:MCG 3-10-13:IRAS 03330-2032"
{
        Type  "E0"
        RA            3.5872
        Dec         -20.3733
        Distance   4.263e+07  # method: V
        Radius          9300
        AbsMag        -17.18
        Axis    [  0.9099   0.3730  -0.1813]
        Angle    151.9160
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1370"
}

Galaxy "NGC 1371:NGC 1367:ESO 482-10:MCG 4-9-29"
{
        Type  "SBa"
        RA            3.5836
        Dec         -24.9333
        Distance   6.093e+07  # method: V
        Radius     4.963e+04
        AbsMag        -19.76
        Axis    [  0.3377   0.6078  -0.7187]
        Angle    151.4295
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1371"
}

Galaxy "NGC 1372:NPM 1"
{
        Type  "E0"
        RA            3.6164
        Dec         -15.8817
        Distance   3.981e+08  # distance uncertain!
        Radius     3.474e+04
        AbsMag        -20.13
        Axis    [  0.9418   0.2528   0.2215]
        Angle    131.9272
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1372"
}

Galaxy "NGC 1373:ESO 358-21:MCG 6-8-28:FCC 143"
{
        Type  "E0"
        RA            3.5831
        Dec         -35.1711
        Distance   7.404e+07  # method: S
        Radius     1.292e+04
        AbsMag        -18.38
        Axis    [  0.6006   0.3162  -0.7344]
        Angle    188.2658
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1373"
}

Galaxy "NGC 1374:ESO 358-23:MCG 6-8-29:AM 0333-352"
{
        Type  "E0"
        RA            3.5878
        Dec         -35.2258
        Distance   6.448e+07  # method: S
        Radius     2.532e+04
        AbsMag        -19.48
        Axis    [  0.6433   0.3191  -0.6959]
        Angle    186.0114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1374"
}

Galaxy "NGC 1375:ESO 358-24:MCG 6-8-30:AM 0333-352"
{
        Type  "S0"
        RA            3.5878
        Dec         -35.2658
        Distance   6.752e+07  # method: S
        Radius     2.259e+04
        AbsMag        -18.38
        Axis    [  0.4897   0.7819  -0.3856]
        Angle    142.6986
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1375"
}

Galaxy "NGC 1376:MCG 1-10-11:IRAS 03346-0512"
{
        Type  "Sc"
        RA            3.6183
        Dec          -5.0428
        Distance   1.819e+08  # method: V
        Radius     5.555e+04
        AbsMag        -20.93
        Axis    [  0.5515   0.7049  -0.4460]
        Angle    149.7927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1376"
}

Galaxy "NGC 1377:ESO 548-51:MCG 4-9-33:IRAS 03344-2103"
{
        Type  "S0"
        RA            3.6108
        Dec         -20.9014
        Distance   7.534e+07  # method: V
        Radius     1.972e+04
        AbsMag        -18.42
        Axis    [  0.4430   0.8130  -0.3779]
        Angle    140.0845
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1377"
}

Galaxy "NGC 1379:ESO 358-27:MCG 6-9-1:FCC 161"
{
        Type  "E0"
        RA            3.6008
        Dec         -35.4408
        Distance   6.538e+07  # method: S
        Radius     2.282e+04
        AbsMag        -19.81
        Axis    [  0.9661   0.2360   0.1047]
        Angle    154.1601
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1379"
}

Galaxy "NGC 1380:ESO 358-28:MCG 6-9-2:AM 0334-350"
{
        Type  "S0"
        RA            3.6075
        Dec         -34.9753
        Distance   5.747e+07  # method: S
        Radius     3.343e+04
        AbsMag        -20.33
        Axis    [  0.7173   0.6376   0.2810]
        Angle    165.3047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1380"
}

Galaxy "NGC 1380A:ESO 358-33:MCG 6-9-6:FCC 177"
{
        Type  "S0"
        RA            3.6131
        Dec         -34.7397
        Distance   5.169e+07  # method: S
        Radius     1.804e+04
        AbsMag         -17.7
        Axis    [  0.0200   0.4005  -0.9161]
        Angle    127.4330
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1380A"
}

Galaxy "NGC 1381:ESO 358-29:MCG 6-9-3:FCC 170"
{
        Type  "S0"
        RA            3.6086
        Dec         -35.2953
        Distance   5.881e+07  # method: S
        Radius     2.224e+04
        AbsMag        -18.78
        Axis    [  0.2465   0.6451  -0.7232]
        Angle    129.9871
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1381"
}

Galaxy "NGC 1382:NGC 1380B:ESO 358-37:MCG 6-9-9"
{
        Type  "S0"
        RA            3.6192
        Dec         -35.1956
        Distance    7.37e+07  # method: S
        Radius     1.608e+04
        AbsMag        -17.87
        Axis    [  0.8504   0.5190   0.0860]
        Angle    157.9883
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1382"
}

Galaxy "NGC 1383:ESO 548-53:MCG 3-10-15"
{
        Type  "S0"
        RA            3.6275
        Dec         -18.3394
        Distance   8.363e+07  # method: V
        Radius     2.311e+04
        AbsMag        -18.54
        Axis    [  0.3916   0.8523  -0.3469]
        Angle    137.0108
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1383"
}

Galaxy "NGC 1384:MCG 3-10-3:ZWG 465.4"
{
        Type  "Sc"
        RA            3.6536
        Dec          15.8194
        Distance   4.376e+08  # method: V
        Radius     5.728e+04
        AbsMag        -20.14
        Axis    [ -0.0086   0.8283  -0.5603]
        Angle    144.9638
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1384"
}

Galaxy "NGC 1385:ESO 482-16:MCG 4-9-36:AM 0335-244"
{
        Type  "SBc"
        RA            3.6244
        Dec         -24.5028
        Distance   4.779e+07  # method: T-F
        Radius     2.502e+04
        AbsMag        -19.23
        Axis    [  0.0852   0.4659  -0.8807]
        Angle    151.1068
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1385"
}

Galaxy "NGC 1386:ESO 358-35:MCG 6-9-5:IRAS 03348-3609"
{
        Type  "Sa"
        RA            3.6128
        Dec         -35.9989
        Distance   5.388e+07  # method: S
        Radius     2.664e+04
        AbsMag        -18.99
        Axis    [  0.6206   0.7693   0.1517]
        Angle    163.7308
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1386"
}

Galaxy "NGC 1387:ESO 358-36:MCG 6-9-7:IRAS 03350-3540"
{
        Type  "S0"
        RA            3.6158
        Dec         -35.5058
        Distance   6.629e+07  # method: S
        Radius       2.7e+04
        AbsMag        -19.74
        Axis    [  0.5890   0.4594  -0.6649]
        Angle    167.3591
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1387"
}

Galaxy "NGC 1388:NPM 1"
{
        Type  "E0"
        RA            3.6367
        Dec         -15.8994
        Distance   3.163e+08  # distance uncertain!
        Radius      3.22e+04
        AbsMag        -20.13
        Axis    [  0.9428   0.2507   0.2197]
        Angle    131.9003
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1388"
}

Galaxy "NGC 1389:ESO 358-38:MCG 6-9-10:FCC 193"
{
        Type  "S0"
        RA            3.6197
        Dec         -35.7456
        Distance    7.07e+07  # method: S
        Radius     2.365e+04
        AbsMag        -19.28
        Axis    [  0.6837   0.7232   0.0980]
        Angle    160.5422
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1389"
}

Galaxy "NGC 1390:ESO 548-54:MCG 3-10-17"
{
        Type  "SBa"
        RA            3.6311
        Dec         -19.0075
        Distance   4.911e+07  # method: V
        Radius          9999
        AbsMag        -15.99
        Axis    [  0.5853   0.7701   0.2539]
        Angle    151.6777
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1390"
}

Galaxy "NGC 1391:ESO 548-59:MCG 3-10-20:NPM 1"
{
        Type  "S0"
        RA            3.6478
        Dec         -18.3544
        Distance   1.612e+08  # distance uncertain!
        Radius     2.814e+04
        AbsMag        -19.07
        Axis    [  0.4841   0.8658  -0.1265]
        Angle    140.1578
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1391"
}

Galaxy "NGC 1393:ESO 548-58:MCG 3-10-19"
{
        Type  "S0"
        RA            3.6439
        Dec         -18.4286
        Distance   9.309e+07  # method: V
        Radius     2.302e+04
        AbsMag        -19.28
        Axis    [  0.1080   0.4871  -0.8667]
        Angle    163.4931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1393"
}

Galaxy "NGC 1394:ESO 548-60:MCG 3-10-21"
{
        Type  "S0"
        RA            3.6517
        Dec         -18.2922
        Distance   1.223e+08  # distance uncertain!
        Radius     2.312e+04
        AbsMag        -19.07
        Axis    [  0.5328   0.7579   0.3765]
        Angle    158.4800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1394"
}

Galaxy "NGC 1395:ESO 482-19:MCG 4-9-39:AM 0336-231"
{
        Type  "E2"
        RA            3.6414
        Dec         -23.0272
        Distance    7.86e+07  # method: S
        Radius     5.716e+04
        AbsMag        -21.11
        Axis    [  0.6278   0.4138  -0.6592]
        Angle    181.1569
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1395"
}

Galaxy "NGC 1396:FCC 202"
{
        Type  "S0"
        RA            3.6350
        Dec         -35.4397
        Distance   3.592e+07  # method: V
        Radius          3657
        AbsMag        -15.41
        Axis    [  0.5722   0.7097  -0.4110]
        Angle    147.5566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1396"
}

Galaxy "NGC 1397:MCG 1-10-17"
{
        Type  "SBa"
        RA            3.6631
        Dec          -4.6697
        Distance   1.768e+08  # distance uncertain!
        Radius     4.371e+04
        AbsMag        -19.07
        Axis    [  0.3744   0.7968  -0.4743]
        Angle    142.5718
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1397"
}

Galaxy "NGC 1398:ESO 482-22:MCG 4-9-40:AM 0336-263"
{
        Type  "SBb"
        RA            3.6478
        Dec         -26.3372
        Distance   5.844e+07  # method: V
        Radius      6.12e+04
        AbsMag        -20.66
        Axis    [  0.5428   0.6786  -0.4949]
        Angle    148.9944
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1398"
}

Galaxy "NGC 1399:ESO 358-45:MCG 6-9-12:AM 0336-353"
{
        Type  "E1"
        RA            3.6411
        Dec         -35.4497
        Distance   6.508e+07  # method: S
        Radius     6.531e+04
        AbsMag         -21.1
        Axis    [  0.8717   0.3091  -0.3803]
        Angle    170.4092
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1399"
}

Galaxy "NGC 1400:ESO 548-62:MCG 3-10-22:IRAS 03372-1850"
{
        Type  "S0"
        RA            3.6583
        Dec         -18.6881
        Distance   8.619e+07  # method: S
        Radius     3.134e+04
        AbsMag        -20.21
        Axis    [  0.7738   0.6334  -0.0108]
        Angle    144.3280
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1400"
}

Galaxy "NGC 1401:ESO 482-26:MCG 4-9-42"
{
        Type  "S0"
        RA            3.6558
        Dec         -22.7244
        Distance   6.455e+07  # method: V
        Radius     2.253e+04
        AbsMag        -18.38
        Axis    [  0.1596   0.7660  -0.6228]
        Angle    127.2484
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1401"
}

Galaxy "NGC 1402:ESO 548-61:MCG 3-10-23:IRAS 03372-1841"
{
        Type  "S0"
        RA            3.6583
        Dec         -18.5269
        Distance    1.54e+08  # distance uncertain!
        Radius     1.792e+04
        AbsMag        -19.07
        Axis    [  0.5673   0.7245  -0.3915]
        Angle    146.0389
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1402"
}

Galaxy "NGC 1403:ESO 482-25:MCG 4-9-41:NPM 1"
{
        Type  "S0"
        RA            3.6528
        Dec         -22.3889
        Distance   1.648e+08  # method: T-F
        Radius     2.157e+04
        AbsMag        -19.82
        Axis    [  0.1775   0.4902  -0.8534]
        Angle    161.7414
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1403"
}

Galaxy "NGC 1404:ESO 358-46:MCG 6-9-13:FCC 219"
{
        Type  "E1"
        RA            3.6475
        Dec         -35.5928
        Distance   6.846e+07  # method: S
        Radius     3.286e+04
        AbsMag        -20.61
        Axis    [  0.3732   0.2830  -0.8835]
        Angle    197.3389
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1404"
}

Galaxy "NGC 1405:MCG 3-10-28"
{
        Type  "S0"
        RA            3.6719
        Dec         -15.5308
        Distance   2.226e+08  # distance uncertain!
        Radius     4.855e+04
        AbsMag        -19.07
        Axis    [  0.0267   0.6519  -0.7578]
        Angle    133.2685
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1405"
}

Galaxy "NGC 1406:ESO 418-15:MCG 5-9-20:UGCA 83"
{
        Type  "SBc"
        RA            3.6564
        Dec         -31.3222
        Distance   6.985e+07  # method: T-F
        Radius     3.962e+04
        AbsMag        -19.15
        Axis    [  0.4952   0.8285   0.2613]
        Angle    167.5758
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1406"
}

Galaxy "NGC 1407:ESO 548-67:MCG 3-10-30"
{
        Type  "E0"
        RA            3.6697
        Dec         -18.5803
        Distance   9.407e+07  # method: S
        Radius     6.294e+04
        AbsMag         -21.6
        Axis    [  0.9363   0.3438  -0.0717]
        Angle    144.6816
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1407"
}

Galaxy "NGC 1409:UGC 2821:MCG 0-10-11:ZWG 391.28"
{
        Type  "S0"
        RA            3.6861
        Dec          -1.3019
        Distance   3.336e+08  # method: V
        Radius     4.853e+04
        AbsMag        -20.35
        Axis    [  0.2678   0.7244  -0.6353]
        Angle    154.2481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1409"
}

Galaxy "NGC 1410:UGC 2821:MCG 0-10-12:ZWG 391.28"
{
        Type  "E0"
        RA            3.6861
        Dec          -1.2986
        Distance   3.344e+08  # method: V
        Radius     3.404e+04
        AbsMag        -20.05
        Axis    [  0.5466   0.5700  -0.6135]
        Angle    175.0699
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1410"
}

Galaxy "NGC 1411:IC 1943:MCG 7-8-4:ESO 249-11"
{
        Type  "S0"
        RA            3.6456
        Dec         -44.1006
        Distance   6.448e+07  # method: S
        Radius     1.688e+04
        AbsMag        -19.18
        Axis    [  0.8177   0.5177   0.2519]
        Angle    169.5750
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1411"
}

Galaxy "NGC 1412:IC 1981:ESO 482-29:MCG 5-9-21"
{
        Type  "S0"
        RA            3.6747
        Dec         -26.8619
        Distance   7.588e+07  # method: V
        Radius     1.987e+04
        AbsMag        -18.33
        Axis    [  0.2521   0.7006  -0.6675]
        Angle    134.0790
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1412"
}

Galaxy "NGC 1413:NPM 1"
{
        Type  "E0"
        RA            3.6697
        Dec         -15.6103
        Distance   3.981e+08  # distance uncertain!
        Radius     5.791e+04
        AbsMag        -20.13
        Axis    [  0.8794   0.4079  -0.2454]
        Angle    150.7447
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1413"
}

Galaxy "NGC 1414:ESO 548-71:MCG 4-9-45"
{
        Type  "SBc"
        RA            3.6825
        Dec         -21.7133
        Distance   7.629e+07  # method: T-F
        Radius     1.664e+04
        AbsMag        -17.24
        Axis    [ -0.0878   0.5212  -0.8489]
        Angle    122.7934
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1414"
}

Galaxy "NGC 1415:IC 1983:ESO 482-33:MCG 4-9-47"
{
        Type  "Sa"
        RA            3.6822
        Dec         -22.5642
        Distance   6.628e+07  # method: V
        Radius      3.47e+04
        AbsMag        -18.74
        Axis    [  0.1588   0.6207  -0.7678]
        Angle    139.0482
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1415"
}

Galaxy "NGC 1416:ESO 482-34:MCG 4-9-48:NPM 1"
{
        Type  "E1"
        RA            3.6839
        Dec         -22.7192
        Distance   9.269e+07  # method: V
        Radius     1.618e+04
        AbsMag        -18.17
        Axis    [  0.9476   0.2274   0.2245]
        Angle    138.2540
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1416"
}

Galaxy "NGC 1417:MCG 1-10-21:IRAS 03394-0451"
{
        Type  "SBb"
        RA            3.6992
        Dec          -4.7053
        Distance   1.878e+08  # method: T-F
        Radius     6.281e+04
        AbsMag         -20.9
        Axis    [  0.6025   0.6731   0.4288]
        Angle    141.9126
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1417"
}

Galaxy "NGC 1418:MCG 1-10-22"
{
        Type  "SBb"
        RA            3.7044
        Dec          -4.7317
        Distance   1.832e+08  # method: V
        Radius     2.664e+04
        AbsMag        -19.35
        Axis    [  0.6293   0.7184   0.2966]
        Angle    136.8569
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1418"
}

Galaxy "NGC 1419:ESO 301-23:MCG 6-9-17:AM 0338-374"
{
        Type  "E0"
        RA            3.6783
        Dec         -37.5111
        Distance   6.272e+07  # method: S
        Radius          8211
        AbsMag        -17.92
        Axis    [  0.9513   0.1896   0.2430]
        Angle    152.3088
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1419"
}

Galaxy "NGC 1421:MCG 2-10-8:IRAS 03401-1338"
{
        Type  "SBc"
        RA            3.7081
        Dec         -13.4878
        Distance   9.273e+07  # method: T-F
        Radius     4.586e+04
        AbsMag        -20.07
        Axis    [  0.4806   0.7602   0.4371]
        Angle    158.8489
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1421"
}

Galaxy "NGC 1422:ESO 548-77:MCG 4-9-51:IRAS 03393-2150"
{
        Type  "SBb"
        RA            3.6919
        Dec         -21.6808
        Distance   5.731e+07  # method: T-F
        Radius     1.917e+04
        AbsMag        -17.22
        Axis    [  0.4156   0.9037  -0.1024]
        Angle    139.9085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1422"
}

Galaxy "NGC 1423:MCG 1-10-25"
{
        Type  "SBa"
        RA            3.7111
        Dec          -6.3817
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [  0.6625   0.7170   0.2168]
        Angle    135.9943
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1423"
}

Galaxy "NGC 1424:MCG 1-10-26:IRAS 03407-0453"
{
        Type  "SBb"
        RA            3.7206
        Dec          -4.7303
        Distance   2.492e+08  # method: V
        Radius     5.798e+04
        AbsMag        -19.81
        Axis    [  0.5196   0.7686   0.3733]
        Angle    143.1060
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1424"
}

Galaxy "NGC 1425:ESO 419-4:MCG 5-9-23:UGCA 84"
{
        Type  "Sb"
        RA            3.7031
        Dec         -29.8942
        Distance    7.37e+07  # method: T-F
        Radius     6.218e+04
        AbsMag        -20.37
        Axis    [  0.3004   0.6798  -0.6691]
        Angle    135.9187
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1425"
}

Galaxy "NGC 1426:ESO 549-1:MCG 4-9-54:AM 0340-221"
{
        Type  "E4"
        RA            3.7136
        Dec         -22.1078
        Distance    7.86e+07  # method: S
        Radius     2.972e+04
        AbsMag        -19.61
        Axis    [  0.6711   0.4175  -0.6126]
        Angle    176.4553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1426"
}

Galaxy "NGC 1427:ESO 358-52:MCG 6-9-21:FCC 276"
{
        Type  "E0"
        RA            3.7053
        Dec         -35.3928
        Distance   7.681e+07  # method: S
        Radius     4.245e+04
        AbsMag        -20.06
        Axis    [  0.8699   0.3060  -0.3868]
        Angle    169.9576
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1427"
}

Galaxy "NGC 1427A:ESO 358-49:MCG 6-9-16:AM 0338-354"
{
        Type  "Irr"
        RA            3.6692
        Dec         -35.6233
        Distance   8.739e+07  # method: V
        Radius     2.923e+04
        AbsMag        -18.74
        Axis    [  0.6573   0.6858  -0.3123]
        Angle    151.3279
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1427A"
}

Galaxy "NGC 1428:ESO 358-53:MCG 6-9-22:FCC 277"
{
        Type  "S0"
        RA            3.7061
        Dec         -35.1539
        Distance   6.945e+07  # method: V
        Radius     1.111e+04
        AbsMag        -17.84
        Axis    [  0.4349   0.6514  -0.6217]
        Angle    142.5417
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1428"
}

Galaxy "NGC 1431:UGC 2845:MCG 0-10-17:ZWG 391.33"
{
        Type  "S0"
        RA            3.7444
        Dec           2.8356
        Distance    2.33e+08  # distance uncertain!
        Radius      3.39e+04
        AbsMag        -19.07
        Axis    [  0.0686   0.6480  -0.7585]
        Angle    166.1015
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1431"
}

Galaxy "NGC 1433:ESO 249-14:AM 0340-472:IRAS 03404-4722"
{
        Type  "SBa"
        RA            3.7003
        Dec         -47.2219
        Distance   4.517e+07  # method: V
        Radius      4.27e+04
        AbsMag           -20
        Axis    [  0.7253   0.4192  -0.5461]
        Angle    166.5096
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1433"
}

Galaxy "NGC 1434"
{
        Type  "Sa"
        RA            3.7700
        Dec          -9.6831
        Distance    2.33e+08  # distance uncertain!
        Radius     2.712e+04
        AbsMag        -19.07
        Axis    [  0.0281   0.5756  -0.8173]
        Angle    152.9107
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1434"
}

Galaxy "NGC 1436:NGC 1437:ESO 358-58:MCG 6-9-25"
{
        Type  "SBb"
        RA            3.7269
        Dec         -35.8542
        Distance   6.999e+07  # method: T-F
        Radius     3.156e+04
        AbsMag        -19.16
        Axis    [  0.2871   0.4888  -0.8238]
        Angle    147.5497
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1436"
}

Galaxy "NGC 1437A:ESO 358-54:MCG 6-9-24:FCC 285"
{
        Type  "SBc"
        RA            3.7172
        Dec         -36.2731
        Distance   3.629e+07  # method: V
        Radius          9500
        AbsMag        -16.23
        Axis    [  0.7169   0.5688  -0.4032]
        Angle    156.6434
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1437A"
}

Galaxy "NGC 1437B:ESO 358-61:MCG 6-9-29:IRAS 03440-3630"
{
        Type  "Sc"
        RA            3.7650
        Dec         -36.3586
        Distance   6.356e+07  # method: V
        Radius     2.403e+04
        AbsMag        -17.65
        Axis    [  0.5993   0.7434   0.2971]
        Angle    172.1960
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1437B"
}

Galaxy "NGC 1438:ESO 482-41:MCG 4-9-58"
{
        Type  "SBa"
        RA            3.7547
        Dec         -23.0022
        Distance   1.147e+08  # method: T-F
        Radius     3.337e+04
        AbsMag        -19.53
        Axis    [  0.5211   0.8325  -0.1882]
        Angle    140.8984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1438"
}

Galaxy "NGC 1439:ESO 549-9:MCG 4-9-56"
{
        Type  "E1"
        RA            3.7469
        Dec         -21.9203
        Distance   8.698e+07  # method: S
        Radius     3.036e+04
        AbsMag        -19.83
        Axis    [  0.9534   0.3017  -0.0099]
        Angle    144.5159
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1439"
}

Galaxy "NGC 1440:NGC 1442:ESO 549-10:MCG 3-10-43"
{
        Type  "S0"
        RA            3.7506
        Dec         -18.2664
        Distance   6.261e+07  # method: V
        Radius     2.003e+04
        AbsMag        -18.82
        Axis    [  0.7330   0.6698   0.1183]
        Angle    144.0198
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1440"
}

Galaxy "NGC 1441:MCG 1-10-29"
{
        Type  "SBb"
        RA            3.7619
        Dec          -4.0917
        Distance   1.853e+08  # method: V
        Radius     4.581e+04
        AbsMag        -19.87
        Axis    [  0.2902   0.9109  -0.2933]
        Angle    130.4860
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1441"
}

Galaxy "NGC 1445"
{
        Type  "E0"
        RA            3.7489
        Dec          -9.8558
        Distance   3.468e+08  # distance uncertain!
        Radius     4.539e+04
        AbsMag        -20.13
        Axis    [  0.9467   0.3111   0.0835]
        Angle    129.9231
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1445"
}

Galaxy "NGC 1447:NPM 1"
{
        Type  "S0"
        RA            3.7631
        Dec          -9.0183
        Distance   2.934e+08  # distance uncertain!
        Radius     4.267e+04
        AbsMag        -19.07
        Axis    [  0.3005   0.8401  -0.4515]
        Angle    134.8027
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1447"
}

Galaxy "NGC 1448:NGC 1457:ESO 249-16:MCG 7-8-5"
{
        Type  "Sc"
        RA            3.7419
        Dec         -44.6458
        Distance   6.242e+07  # method: T-F
        Radius       6.9e+04
        AbsMag        -20.01
        Axis    [  0.5548   0.8319   0.0025]
        Angle    162.3781
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1448"
}

Galaxy "NGC 1449:MCG 1-10-32"
{
        Type  "S0"
        RA            3.7675
        Dec          -4.1381
        Distance     1.8e+08  # method: V
        Radius     2.095e+04
        AbsMag        -19.21
        Axis    [  0.6359   0.7362   0.2316]
        Angle    134.4149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1449"
}

Galaxy "NGC 1450-1"
{
        Type  "S0"
        RA            3.7600
        Dec          -9.2347
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [  0.6903   0.7230   0.0274]
        Angle    136.2504
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1450-1"
}

Galaxy "NGC 1450-2"
{
        Type  "E0"
        RA            3.7600
        Dec          -9.2328
        Distance   5.496e+08  # distance uncertain!
        Radius     1.599e+04
        AbsMag        -20.13
        Axis    [  0.9456   0.2568   0.1999]
        Angle    125.3291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1450-2"
}

Galaxy "NGC 1451:MCG 1-10-33"
{
        Type  "S0"
        RA            3.7686
        Dec          -4.0692
        Distance   1.717e+08  # method: V
        Radius     1.998e+04
        AbsMag        -19.21
        Axis    [  0.6142   0.7769   0.1386]
        Angle    133.3366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1451"
}

Galaxy "NGC 1452:NGC 1455:ESO 549-12:MCG 3-10-44"
{
        Type  "SBa"
        RA            3.7561
        Dec         -18.6331
        Distance   7.334e+07  # method: V
        Radius     2.987e+04
        AbsMag        -18.96
        Axis    [  0.3454   0.7623  -0.5473]
        Angle    138.5519
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1452"
}

Galaxy "NGC 1453:MCG 1-10-34"
{
        Type  "E2"
        RA            3.7742
        Dec          -3.9689
        Distance   1.892e+08  # method: T-F
        Radius     6.606e+04
        AbsMag        -21.22
        Axis    [  0.8822   0.4382  -0.1722]
        Angle    136.5768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1453"
}

Galaxy "NGC 1459:ESO 482-43:MCG 4-10-1:IRAS 03448-2540"
{
        Type  "SBc"
        RA            3.7825
        Dec         -25.5214
        Distance   1.752e+08  # method: T-F
        Radius     4.331e+04
        AbsMag        -20.05
        Axis    [  0.1145   0.4718  -0.8742]
        Angle    150.7049
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1459"
}

Galaxy "NGC 1460:ESO 358-62:MCG 6-9-31:AM 0344-365"
{
        Type  "S0"
        RA            3.7703
        Dec         -36.6967
        Distance   5.676e+07  # method: V
        Radius     1.156e+04
        AbsMag         -17.7
        Axis    [  0.7298   0.6462  -0.2230]
        Angle    153.8184
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1460"
}

Galaxy "NGC 1461:MCG 3-10-47"
{
        Type  "S0"
        RA            3.8075
        Dec         -16.3928
        Distance   5.857e+07  # method: V
        Radius     2.556e+04
        AbsMag        -18.47
        Axis    [  0.0006   0.6388  -0.7693]
        Angle    129.4874
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1461"
}

Galaxy "NGC 1462:MCG 1-10-10:ZWG 417.7"
{
        Type  "S0"
        RA            3.8397
        Dec           6.9731
        Distance   3.663e+08  # method: V
        Radius     4.795e+04
        AbsMag        -20.05
        Axis    [  0.4767   0.8768   0.0635]
        Angle    124.9592
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1462"
}

Galaxy "NGC 1463:ESO 117-9:IRAS 03453-5957"
{
        Type  "Sa"
        RA            3.7708
        Dec         -59.8103
        Distance    1.47e+08  # distance uncertain!
        Radius      2.78e+04
        AbsMag        -19.07
        Axis    [  0.9247   0.3597  -0.1249]
        Angle    176.3968
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1463"
}

Galaxy "NGC 1464:NGC 1471:IRAS 03491-1533"
{
        Type  "S0"
        RA            3.8567
        Dec         -15.4022
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [  0.7122   0.7014  -0.0275]
        Angle    139.8847
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1464"
}

Galaxy "NGC 1465:UGC 2891:MCG 5-10-3:ZWG 508.4"
{
        Type  "Sa"
        RA            3.8919
        Dec          32.4928
        Distance   9.762e+07  # method: V
        Radius     2.414e+04
        AbsMag        -17.68
        Axis    [ -0.3809   0.7103  -0.5920]
        Angle    148.9012
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1465"
}

Galaxy "NGC 1467:MCG 2-10-15:NPM 1"
{
        Type  "Sa"
        RA            3.8644
        Dec          -8.8378
        Distance   2.125e+08  # distance uncertain!
        Radius       3.4e+04
        AbsMag        -19.07
        Axis    [  0.5892   0.8046  -0.0745]
        Angle    134.5943
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1467"
}

Galaxy "NGC 1468:MCG 1-10-45:NPM 1"
{
        Type  "S0"
        RA            3.8700
        Dec          -6.3486
        Distance    2.33e+08  # distance uncertain!
        Radius     4.067e+04
        AbsMag        -19.07
        Axis    [  0.1949   0.7149  -0.6715]
        Angle    145.7554
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1468"
}

Galaxy "NGC 1469:UGC 2909:MCG 11-5-4:ZWG 305.3"
{
        Type  "S0"
        RA            4.0075
        Dec          68.5775
        Distance    1.47e+08  # distance uncertain!
        Radius     4.063e+04
        AbsMag        -19.07
        Axis    [ -0.4785   0.8167  -0.3225]
        Angle    159.9821
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1469"
}

Galaxy "NGC 1470:MCG 2-10-16:IRAS 03497-0908"
{
        Type  "Sb"
        RA            3.8692
        Dec          -9.0000
        Distance   2.873e+08  # method: V
        Radius     5.431e+04
        AbsMag        -19.72
        Axis    [ -0.1642   0.5796  -0.7982]
        Angle    128.2270
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1470"
}

Galaxy "NGC 1472:NPM 1"
{
        Type  "S0"
        RA            3.8964
        Dec          -8.5681
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.6580   0.7024  -0.2713]
        Angle    138.9939
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1472"
}

Galaxy "NGC 1473:ESO 54-19:AM 0347-682:IRAS 03472-6822"
{
        Type  "Irr"
        RA            3.7906
        Dec         -68.2206
        Distance   6.637e+07  # method: T-F
        Radius     1.448e+04
        AbsMag        -17.94
        Axis    [  0.7960   0.6020  -0.0636]
        Angle    181.8804
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1473"
}

Galaxy "NGC 1474:IC 2002:UGC 2898:MCG 2-10-3"
{
        Type  "SBa"
        RA            3.9083
        Dec          10.7069
        Distance   2.309e+08  # method: V
        Radius     3.693e+04
        AbsMag        -19.45
        Axis    [  0.8052   0.4974   0.3227]
        Angle    112.9621
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1474"
}

Galaxy "NGC 1476:ESO 249-24:MCG 7-9-1:AM 0350-444"
{
        Type  "Sa"
        RA            3.8689
        Dec         -44.5322
        Distance   1.341e+08  # distance uncertain!
        Radius     2.731e+04
        AbsMag        -19.07
        Axis    [  0.5798   0.7141  -0.3922]
        Angle    145.3641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1476"
}

Galaxy "NGC 1477:NPM 1"
{
        Type  "E0"
        RA            3.9006
        Dec          -8.5744
        Distance   3.802e+08  # distance uncertain!
        Radius     3.318e+04
        AbsMag        -20.13
        Axis    [  0.2419   0.4909  -0.8369]
        Angle    199.9967
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1477"
}

Galaxy "NGC 1478:NPM 1"
{
        Type  "S0"
        RA            3.9019
        Dec          -8.5550
        Distance   3.072e+08  # distance uncertain!
        Radius     2.681e+04
        AbsMag        -19.07
        Axis    [  0.5271   0.8497  -0.0117]
        Angle    133.7503
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1478"
}

Galaxy "NGC 1481:ESO 549-32:MCG 3-10-53:NPM 1"
{
        Type  "S0"
        RA            3.9078
        Dec         -20.4267
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.3094   0.6313  -0.7112]
        Angle    147.0108
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1481"
}

Galaxy "NGC 1482:ESO 549-33:MCG 3-10-54:IRAS 03524-2038"
{
        Type  "Sa"
        RA            3.9106
        Dec         -20.5019
        Distance   7.515e+07  # method: V
        Radius     2.623e+04
        AbsMag        -18.71
        Axis    [  0.4297   0.7552  -0.4951]
        Angle    138.3987
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1482"
}

Galaxy "NGC 1483:ESO 201-7:IRAS 03512-4737"
{
        Type  "SBc"
        RA            3.8797
        Dec         -47.4783
        Distance   4.883e+07  # method: V
        Radius     1.136e+04
        AbsMag        -17.78
        Axis    [  0.5633   0.3864  -0.7303]
        Angle    162.7384
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1483"
}

Galaxy "NGC 1484:ESO 359-6:MCG 6-9-36:AM 0352-370"
{
        Type  "Sb"
        RA            3.9047
        Dec         -36.9708
        Distance   6.868e+07  # method: T-F
        Radius     2.497e+04
        AbsMag        -18.02
        Axis    [  0.4614   0.8405  -0.2842]
        Angle    138.5393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1484"
}

Galaxy "NGC 1485:UGC 2933:MCG 12-4-10:ZWG 327.14"
{
        Type  "Sb"
        RA            4.0842
        Dec          70.9967
        Distance   4.584e+07  # method: V
        Radius       1.4e+04
        AbsMag        -17.14
        Axis    [  0.0115   0.7576   0.6526]
        Angle     90.6013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1485"
}

Galaxy "NGC 1486:ESO 549-37:MCG 4-10-8"
{
        Type  "SBc"
        RA            3.9383
        Dec         -21.8208
        Distance    2.33e+08  # distance uncertain!
        Radius     3.051e+04
        AbsMag        -19.07
        Axis    [  0.6879   0.6412   0.3401]
        Angle    153.8131
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1486"
}

Galaxy "NGC 1487:ESO 249-31:MCG 7-9-2:VV 78"
{
        Type  "Irr"
        RA            3.9292
        Dec         -42.3678
        Distance   3.452e+07  # method: V
        Radius     1.205e+04
        AbsMag        -17.92
        Axis    [  0.7708   0.6114  -0.1789]
        Angle    157.1644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1487"
}

Galaxy "NGC 1489:ESO 549-42:MCG 3-11-3"
{
        Type  "SBb"
        RA            3.9606
        Dec         -19.2172
        Distance   5.142e+08  # method: V
        Radius     1.047e+05
        AbsMag        -21.39
        Axis    [  0.6196   0.7295   0.2896]
        Angle    151.1740
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1489"
}

Galaxy "NGC 1490:ESO 83-11:AM 0353-661"
{
        Type  "E1"
        RA            3.8928
        Dec         -66.0181
        Distance   2.437e+08  # method: V
        Radius     4.607e+04
        AbsMag        -20.97
        Axis    [  0.5519   0.0402  -0.8329]
        Angle    191.7164
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1490"
}

Galaxy "NGC 1492:ESO 359-12:IRAS 03563-3535"
{
        Type  "Sa"
        RA            3.9703
        Dec         -35.4458
        Distance   2.036e+08  # method: V
        Radius     2.665e+04
        AbsMag        -19.68
        Axis    [  0.8237   0.5282   0.2063]
        Angle    159.0476
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1492"
}

Galaxy "NGC 1493:ESO 249-33:AM 0355-462:IRAS 03558-4621"
{
        Type  "SBc"
        RA            3.9575
        Dec         -46.2117
        Distance   4.507e+07  # method: V
        Radius     1.836e+04
        AbsMag         -18.9
        Axis    [  0.9582   0.1734   0.2275]
        Angle    161.0574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1493"
}

Galaxy "NGC 1494:ESO 201-12:IRAS 03562-4902"
{
        Type  "SBc"
        RA            3.9617
        Dec         -48.9094
        Distance   6.596e+07  # method: T-F
        Radius     3.166e+04
        AbsMag        -19.23
        Axis    [  0.1394   0.2565  -0.9564]
        Angle    141.0395
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1494"
}

Galaxy "NGC 1495:ESO 249-34:MCG 7-9-4:AM 0356-443"
{
        Type  "Sc"
        RA            3.9725
        Dec         -44.4658
        Distance    6.22e+07  # method: T-F
        Radius     2.714e+04
        AbsMag         -18.1
        Axis    [  0.4012   0.7735  -0.4907]
        Angle    128.4892
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1495"
}

Galaxy "NGC 1497:UGC 2929:MCG 4-10-8:ZWG 487.9"
{
        Type  "S0"
        RA            4.0350
        Dec          23.1333
        Distance    2.74e+08  # method: V
        Radius     5.978e+04
        AbsMag        -20.32
        Axis    [  0.2724   0.9607   0.0537]
        Angle    114.9011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1497"
}

Galaxy "NGC 1500:ESO 201-13:AM 0356-522"
{
        Type  "S0"
        RA            3.9706
        Dec         -52.3283
        Distance   4.499e+08  # method: V
        Radius     7.198e+04
        AbsMag           -21
        Axis    [  0.6901   0.4346  -0.5787]
        Angle    160.0903
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1500"
}

Galaxy "NGC 1503:ESO 83-13:IRAS 03561-6611"
{
        Type  "SBa"
        RA            3.9425
        Dec         -66.0406
        Distance   1.612e+08  # distance uncertain!
        Radius      2.11e+04
        AbsMag        -19.07
        Axis    [  0.5164   0.2476  -0.8197]
        Angle    155.9132
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1503"
}

Galaxy "NGC 1504:MCG 2-11-8:NPM 1"
{
        Type  "S0"
        RA            4.0414
        Dec          -9.3350
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.7279   0.6578   0.1936]
        Angle    135.1291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1504"
}

Galaxy "NGC 1505:MCG 2-11-9:NPM 1"
{
        Type  "S0"
        RA            4.0433
        Dec          -9.3219
        Distance   1.851e+08  # distance uncertain!
        Radius     2.423e+04
        AbsMag        -19.07
        Axis    [  0.5737   0.7462  -0.3377]
        Angle    136.9597
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1505"
}

Galaxy "NGC 1506:ESO 156-27"
{
        Type  "S0"
        RA            4.0058
        Dec         -52.5733
        Distance    5.13e+08  # method: V
        Radius     8.953e+04
        AbsMag        -21.58
        Axis    [  0.7536   0.5093  -0.4156]
        Angle    159.5034
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1506"
}

Galaxy "NGC 1507:UGC 2947:MCG 0-11-9:MK 1080"
{
        Type  "Irr"
        RA            4.0742
        Dec          -2.1886
        Distance   4.444e+07  # method: T-F
        Radius     2.327e+04
        AbsMag        -17.77
        Axis    [  0.4892   0.7792   0.3918]
        Angle    141.0605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1507"
}

Galaxy "NGC 1508:MCG 4-10-21:ZWG 487.21:NPM 1"
{
        Type  "Sc"
        RA            4.0964
        Dec          25.4092
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.6831   0.7093   0.1740]
        Angle    103.1732
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1508"
}

Galaxy "NGC 1509:IC 2026:MCG 2-11-13:MK 1079"
{
        Type  "Sa"
        RA            4.0653
        Dec         -11.1786
        Distance   1.768e+08  # distance uncertain!
        Radius     2.314e+04
        AbsMag        -19.07
        Axis    [  0.7045   0.7036  -0.0927]
        Angle    134.9448
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1509"
}

Galaxy "NGC 1510:ESO 250-3:MCG 7-9-6:IRAS 04019-4332"
{
        Type  "S0"
        RA            4.0589
        Dec         -43.3997
        Distance   4.222e+07  # method: V
        Radius     1.965e+04
        AbsMag        -17.16
        Axis    [  0.6113   0.6470  -0.4558]
        Angle    145.6619
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1510"
}

Galaxy "NGC 1511:ESO 55-4:AM 0359-674:IRAS 03594-6746"
{
        Type  "Sa"
        RA            3.9933
        Dec         -67.6347
        Distance   5.771e+07  # method: T-F
        Radius     2.938e+04
        AbsMag        -19.34
        Axis    [  0.5406   0.4625  -0.7027]
        Angle    135.8025
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1511"
}

Galaxy "NGC 1511A:ESO 55-5:IRAS 04001-6756"
{
        Type  "SBa"
        RA            4.0053
        Dec         -67.8072
        Distance   5.857e+07  # method: T-F
        Radius     1.533e+04
        AbsMag        -16.97
        Axis    [  0.5515   0.5995  -0.5801]
        Angle    134.2847
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1511A"
}

Galaxy "NGC 1511B:ESO 55-6:FGCE 368"
{
        Type  "SBc"
        RA            4.0150
        Dec         -67.6119
        Distance    2.33e+08  # distance uncertain!
        Radius     6.101e+04
        AbsMag        -19.07
        Axis    [  0.5810   0.6752  -0.4545]
        Angle    142.6647
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1511B"
}

Galaxy "NGC 1512:ESO 250-4:MCG 7-9-7:AM 0402-433"
{
        Type  "SBa"
        RA            4.0650
        Dec         -43.3489
        Distance   4.874e+07  # method: T-F
        Radius      6.31e+04
        AbsMag        -19.77
        Axis    [  0.6351   0.6156  -0.4665]
        Angle    147.9011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1512"
}

Galaxy "NGC 1515:ESO 156-36:AM 0402-541:IRAS 04028-5414"
{
        Type  "SBc"
        RA            4.0672
        Dec         -54.1000
        Distance   6.695e+07  # method: T-F
        Radius     5.259e+04
        AbsMag        -19.46
        Axis    [  0.6313   0.7674   0.1116]
        Angle    178.4227
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1515"
}

Galaxy "NGC 1515A:ESO 156-34:FAIR 397"
{
        Type  "SBb"
        RA            4.0639
        Dec         -54.1131
        Distance   5.993e+08  # method: V
        Radius     8.716e+04
        AbsMag        -20.92
        Axis    [  0.4214   0.3058  -0.8537]
        Angle    155.0701
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1515A"
}

Galaxy "NGC 1516-1:NGC 1524:NGC 1516A:MCG 2-11-17"
{
        Type  "SBc"
        RA            4.1353
        Dec          -8.8294
        Distance   7.038e+07  # distance uncertain!
        Radius     1.433e+04
        AbsMag        -19.07
        Axis    [  0.6082   0.7886  -0.0908]
        Angle    131.5281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1516-1"
}

Galaxy "NGC 1517:UGC 2970:ZWG 418.13:IRAS 04064+0831"
{
        Type  "Sc"
        RA            4.1531
        Dec           8.6489
        Distance   1.529e+08  # method: V
        Radius     2.447e+04
        AbsMag        -19.16
        Axis    [  0.8300   0.4661   0.3064]
        Angle    113.7508
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1517"
}

Galaxy "NGC 1518:ESO 550-7:MCG 4-10-13:IRAS 04046-2118"
{
        Type  "SBc"
        RA            4.1136
        Dec         -21.1794
        Distance   3.244e+07  # method: T-F
        Radius     1.368e+04
        AbsMag        -17.69
        Axis    [  0.6352   0.7682   0.0803]
        Angle    143.5146
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1518"
}

Galaxy "NGC 1519:ESO 550-9:MCG 3-11-13:IRAS 04058-1719"
{
        Type  "SBb"
        RA            4.1353
        Dec         -17.1928
        Distance   8.598e+07  # method: T-F
        Radius     2.626e+04
        AbsMag         -18.5
        Axis    [  0.2403   0.8519  -0.4653]
        Angle    123.6690
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1519"
}

Galaxy "NGC 1521:ESO 550-11:MCG 4-10-15"
{
        Type  "E0"
        RA            4.1383
        Dec         -21.0517
        Distance   2.195e+08  # method: S
        Radius      8.62e+04
        AbsMag        -21.54
        Axis    [  0.9707   0.2209   0.0947]
        Angle    137.9530
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1521"
}

Galaxy "NGC 1522:ESO 156-38:FAIR 301:AM 0404-524"
{
        Type  "S0"
        RA            4.1019
        Dec         -52.6694
        Distance   4.417e+07  # method: V
        Radius          7709
        AbsMag        -16.76
        Axis    [  0.8099   0.5773  -0.1037]
        Angle    165.8570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1522"
}

Galaxy "NGC 1525:NGC 1516B:NGC 1516-2:MCG 2-11-18"
{
        Type  "Sc"
        RA            4.1356
        Dec          -8.8347
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.3108   0.6884  -0.6554]
        Angle    146.0738
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1525"
}

Galaxy "NGC 1526:ESO 84-3:IRAS 04048-6558"
{
        Type  "SBc"
        RA            4.0867
        Dec         -65.8400
        Distance   1.768e+08  # distance uncertain!
        Radius     2.057e+04
        AbsMag        -19.07
        Axis    [  0.8770   0.4726  -0.0869]
        Angle    178.9481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1526"
}

Galaxy "NGC 1527:ESO 201-20"
{
        Type  "S0"
        RA            4.1400
        Dec         -47.8967
        Distance   5.881e+07  # method: S
        Radius     3.336e+04
        AbsMag        -19.58
        Axis    [  0.6068   0.7143  -0.3487]
        Angle    145.2922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1527"
}

Galaxy "NGC 1529:ESO 84-4:DRCG 46-18"
{
        Type  "S0"
        RA            4.1219
        Dec         -62.8994
        Distance   1.612e+08  # distance uncertain!
        Radius     2.814e+04
        AbsMag        -19.07
        Axis    [  0.2772   0.3233  -0.9048]
        Angle    113.2793
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1529"
}

Galaxy "NGC 1530:UGC 3013:MCG 13-4-4:ZWG 327.17"
{
        Type  "SBb"
        RA            4.3906
        Dec          75.2944
        Distance   1.089e+08  # method: V
        Radius     6.969e+04
        AbsMag        -20.32
        Axis    [  0.1119   0.8050   0.5826]
        Angle     76.3804
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1530"
}

Galaxy "NGC 1531:ESO 359-26:MCG 5-11-1:AM 0410-325"
{
        Type  "S0"
        RA            4.1997
        Dec         -32.8508
        Distance   5.096e+07  # method: V
        Radius          8895
        AbsMag        -18.27
        Axis    [  0.4551   0.5524  -0.6983]
        Angle    146.8355
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1531"
}

Galaxy "NGC 1532:ESO 359-27:MCG 5-11-2:AM 0410-330"
{
        Type  "SBb"
        RA            4.2008
        Dec         -32.8731
        Distance   6.206e+07  # method: T-F
        Radius     1.047e+05
        AbsMag        -20.79
        Axis    [  0.5918   0.8024   0.0773]
        Angle    152.9240
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1532"
}

Galaxy "NGC 1533:ESO 157-3:AM 0408-561:IRAS 04088-5614"
{
        Type  "S0"
        RA            4.1642
        Dec         -56.1178
        Distance   6.973e+07  # method: S
        Radius      2.84e+04
        AbsMag        -19.95
        Axis    [  0.3903   0.2603  -0.8831]
        Angle    155.8989
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1533"
}

Galaxy "NGC 1534:ESO 84-6:AM 0408-625:DRCG 46-23"
{
        Type  "Sa"
        RA            4.1461
        Dec         -62.7972
        Distance   2.409e+08  # method: V
        Radius     5.956e+04
        AbsMag        -20.54
        Axis    [  0.7072   0.5936  -0.3841]
        Angle    156.4420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1534"
}

Galaxy "NGC 1536:ESO 157-5:AM 0409-563:IRAS 04099-5636"
{
        Type  "SBc"
        RA            4.1833
        Dec         -56.4825
        Distance   6.972e+07  # method: V
        Radius     2.129e+04
        AbsMag        -18.35
        Axis    [  0.3455   0.2793  -0.8959]
        Angle    146.6096
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1536"
}

Galaxy "NGC 1537:ESO 420-12:MCG 5-11-5:AM 0411-314"
{
        Type  "S0"
        RA            4.2278
        Dec         -31.6456
        Distance   7.576e+07  # method: S
        Radius     4.297e+04
        AbsMag        -20.33
        Axis    [  0.5535   0.6500  -0.5207]
        Angle    141.5236
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1537"
}

Galaxy "NGC 1538:IC 2047:NPM 1"
{
        Type  "S0"
        RA            4.2489
        Dec         -13.1914
        Distance   3.369e+08  # distance uncertain!
        Radius      2.94e+04
        AbsMag        -19.07
        Axis    [  0.8264   0.4772   0.2990]
        Angle    136.8553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1538"
}

Galaxy "NGC 1539-1:ZWG 488.1:ZW 373"
{
        Type  "E0"
        RA            4.3169
        Dec          26.8275
        Distance   4.571e+08  # distance uncertain!
        Radius     3.324e+04
        AbsMag        -20.13
        Axis    [  0.9506   0.2919   0.1055]
        Angle     89.5117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1539-1"
}

Galaxy "NGC 1539-2:ZWG 488.1:ZW 373"
{
        Type  "E0"
        RA            4.3172
        Dec          26.8294
        Distance   1.148e+09  # distance uncertain!
        Radius      5.01e+04
        AbsMag        -20.13
        Axis    [  0.9506   0.2919   0.1055]
        Angle     89.5090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1539-2"
}

Galaxy "NGC 1540:ESO 420-14:AM 0413-283:IRAS 04131-2836"
{
        Type  "Sa"
        RA            4.2528
        Dec         -28.4828
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [  0.2469   0.5468  -0.8000]
        Angle    140.4966
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1540"
}

Galaxy "NGC 1540A:ESO 420-14A"
{
        Type  "Sb"
        RA            4.2528
        Dec         -28.4794
        Distance   1.688e+08  # distance uncertain!
        Radius     1.964e+04
        AbsMag        -19.07
        Axis    [  0.6371   0.7109  -0.2980]
        Angle    140.5371
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1540A"
}

Galaxy "NGC 1541:UGC 3001:MCG 0-11-40:ZWG 392.13"
{
        Type  "Sa"
        RA            4.2833
        Dec           0.8353
        Distance   1.768e+08  # distance uncertain!
        Radius     3.343e+04
        AbsMag        -19.07
        Axis    [  0.2910   0.9314  -0.2186]
        Angle    120.9999
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1541"
}

Galaxy "NGC 1542:UGC 3003:MCG 1-11-16:ZWG 418.17"
{
        Type  "Sb"
        RA            4.2872
        Dec           4.7819
        Distance   1.639e+08  # method: V
        Radius     3.098e+04
        AbsMag         -18.6
        Axis    [  0.0059   0.8387  -0.5446]
        Angle    125.4951
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1542"
}

Galaxy "NGC 1543:ESO 118-10:AM 0411-575:IRAS 04117-5751"
{
        Type  "S0"
        RA            4.2119
        Dec         -57.7372
        Distance   6.538e+07  # method: S
        Radius     3.613e+04
        AbsMag        -20.21
        Axis    [  0.7128   0.4503  -0.5378]
        Angle    157.1952
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1543"
}

Galaxy "NGC 1544:UGC 3160:MCG 14-3-6:ZWG 361.11"
{
        Type  "S0"
        RA            5.0433
        Dec          86.2228
        Distance   2.029e+08  # method: V
        Radius     3.836e+04
        AbsMag        -19.47
        Axis    [ -0.3462   0.9349  -0.0788]
        Angle    137.5821
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1544"
}

Galaxy "NGC 1546:ESO 157-12:AM 0413-561:IRAS 04134-5611"
{
        Type  "Sa"
        RA            4.2433
        Dec         -56.0603
        Distance   5.146e+07  # method: V
        Radius     2.395e+04
        AbsMag        -19.09
        Axis    [  0.3759   0.3519  -0.8572]
        Angle    138.4110
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1546"
}

Galaxy "NGC 1547:ESO 550-18:MCG 3-11-20:PGC 14794"
{
        Type  "SBc"
        RA            4.2867
        Dec         -17.8575
        Distance   1.612e+08  # distance uncertain!
        Radius     3.048e+04
        AbsMag        -19.07
        Axis    [  0.1827   0.7026  -0.6877]
        Angle    129.1701
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1547"
}

Galaxy "NGC 1549:ESO 157-16:AM 0414-554"
{
        Type  "E0"
        RA            4.2625
        Dec         -55.5914
        Distance   6.419e+07  # method: S
        Radius     4.574e+04
        AbsMag        -20.87
        Axis    [  0.5546   0.1280  -0.8222]
        Angle    187.4673
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1549"
}

Galaxy "NGC 1551:NGC 1550:UGC 3012:MCG 0-11-55"
{
        Type  "S0"
        RA            4.3272
        Dec           2.4094
        Distance    1.63e+08  # method: V
        Radius     5.215e+04
        AbsMag        -20.39
        Axis    [  0.7796   0.6237   0.0568]
        Angle    120.8872
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1551"
}

Galaxy "NGC 1552:UGC 3015:MCG 0-12-7:ZWG 393.5"
{
        Type  "Sa"
        RA            4.3381
        Dec          -0.6925
        Distance   2.191e+08  # method: V
        Radius     5.735e+04
        AbsMag        -20.14
        Axis    [  0.2971   0.8036  -0.5158]
        Angle    131.8719
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1552"
}

Galaxy "NGC 1553:ESO 157-17:AM 0415-555:IRAS 04150-5554"
{
        Type  "S0"
        RA            4.2694
        Dec         -55.7794
        Distance   6.046e+07  # method: S
        Radius     3.957e+04
        AbsMag        -21.34
        Axis    [  0.3566   0.3303  -0.8739]
        Angle    139.6587
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1553"
}

Galaxy "NGC 1556:ESO 202-4:AM 0416-501:IRAS 04163-5017"
{
        Type  "Sb"
        RA            4.2956
        Dec         -50.1642
        Distance   6.677e+07  # method: T-F
        Radius     1.651e+04
        AbsMag        -18.06
        Axis    [  0.1520   0.3613  -0.9200]
        Angle    116.2024
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1556"
}

Galaxy "NGC 1558:ESO 250-17:AM 0418-450:IRAS 04187-4508"
{
        Type  "SBc"
        RA            4.3375
        Dec         -45.0311
        Distance   2.298e+08  # method: T-F
        Radius     8.356e+04
        AbsMag        -20.94
        Axis    [  0.6206   0.7208  -0.3088]
        Angle    144.0140
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1558"
}

Galaxy "NGC 1559:ESO 84-10:AM 0417-625"
{
        Type  "SBc"
        RA            4.2933
        Dec         -62.7839
        Distance   6.002e+07  # method: T-F
        Radius     3.056e+04
        AbsMag        -20.22
        Axis    [  0.7686   0.5565  -0.3156]
        Angle    162.3851
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1559"
}

Galaxy "NGC 1560:UGC 3060:MCG 12-5-5:ZWG 328.6"
{
        Type  "Sc"
        RA            4.5464
        Dec          71.8794
        Distance   1.468e+07  # method: T-F
        Radius     2.092e+04
        AbsMag        -16.16
        Axis    [ -0.0270   0.6699   0.7420]
        Angle     96.6808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1560"
}

Galaxy "NGC 1561:MCG 3-12-6:NPM 1"
{
        Type  "S0"
        RA            4.3836
        Dec         -15.8453
        Distance    2.03e+08  # distance uncertain!
        Radius     3.247e+04
        AbsMag        -19.07
        Axis    [ -0.0096   0.4725  -0.8813]
        Angle    153.9894
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1561"
}

Galaxy "NGC 1562:NPM 1"
{
        Type  "S0"
        RA            4.3631
        Dec         -15.7553
        Distance    2.44e+08  # distance uncertain!
        Radius      2.13e+04
        AbsMag        -19.07
        Axis    [  0.9654   0.2013   0.1659]
        Angle    130.9160
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1562"
}

Galaxy "NGC 1563:MCG 3-12-5:NPM 1:IRAS 04204-1546"
{
        Type  "E0"
        RA            4.3814
        Dec         -15.7328
        Distance   5.496e+08  # distance uncertain!
        Radius     5.595e+04
        AbsMag        -20.13
        Axis    [  0.7845   0.4008  -0.4732]
        Angle    154.6277
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1563"
}

Galaxy "NGC 1564:NPM 1"
{
        Type  "S0"
        RA            4.3833
        Dec         -15.7389
        Distance   2.802e+08  # distance uncertain!
        Radius     2.853e+04
        AbsMag        -19.07
        Axis    [  0.7719   0.6171   0.1532]
        Angle    137.9672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1564"
}

Galaxy "NGC 1565:MCG 3-12-7"
{
        Type  "Sc"
        RA            4.3897
        Dec         -15.7447
        Distance   1.851e+08  # distance uncertain!
        Radius     2.423e+04
        AbsMag        -19.07
        Axis    [  0.0921   0.4763  -0.8745]
        Angle    166.7913
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1565"
}

Galaxy "NGC 1566:ESO 157-20:IRAS 04189-5503"
{
        Type  "SBc"
        RA            4.3333
        Dec         -54.9372
        Distance   3.013e+07  # method: T-F
        Radius     3.593e+04
        AbsMag        -19.62
        Axis    [  0.8338   0.4681  -0.2927]
        Angle    163.3636
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1566"
}

Galaxy "NGC 1567:ESO 202-10:AM 0419-482"
{
        Type  "E0"
        RA            4.3522
        Dec         -48.2547
        Distance   2.045e+08  # method: V
        Radius     3.867e+04
        AbsMag        -21.49
        Axis    [  0.9762   0.1167   0.1825]
        Angle    162.1217
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1567"
}

Galaxy "NGC 1568-1:UGC 3031:MCG 0-12-26:ZWG 393.16"
{
        Type  "Sa"
        RA            4.4056
        Dec          -0.7381
        Distance   2.676e+08  # distance uncertain!
        Radius     1.946e+04
        AbsMag        -19.07
        Axis    [  0.2090   0.6987  -0.6842]
        Angle    146.2541
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1568-1"
}

Galaxy "NGC 1568-2:UGC 3032:MCG 0-12-27:ZWG 393.16"
{
        Type  "Sa"
        RA            4.4069
        Dec          -0.7461
        Distance   2.107e+08  # method: V
        Radius     3.372e+04
        AbsMag        -18.05
        Axis    [  0.1700   0.7189  -0.6740]
        Angle    141.6802
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1568-2"
}

Galaxy "NGC 1569:UGC 3056:MCG 11-6-1:ZWG 306.1"
{
        Type  "Irr"
        RA            4.5136
        Dec          64.8481
        Distance   7.944e+07  # distance uncertain!
        Radius     4.275e+04
        AbsMag        -20.13
        Axis    [ -0.3354   0.9294  -0.1539]
        Angle    129.7873
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1569"
}

Galaxy "NGC 1570:NGC 1571:ESO 250-19:MCG 7-10-1"
{
        Type  "E0"
        RA            4.3689
        Dec         -43.6300
        Distance   1.975e+08  # method: V
        Radius     4.309e+04
        AbsMag        -20.61
        Axis    [  0.2416   0.2034  -0.9488]
        Angle    192.3311
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1570"
}

Galaxy "NGC 1572:ESO 303-14:MCG 7-10-3:AM 0421-404"
{
        Type  "SBa"
        RA            4.3783
        Dec         -40.6011
        Distance   2.287e+08  # method: T-F
        Radius     7.984e+04
        AbsMag        -20.83
        Axis    [  0.7388   0.6208   0.2622]
        Angle    169.2324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1572"
}

Galaxy "NGC 1573:UGC 3077:MCG 12-5-8:ZWG 328.9"
{
        Type  "E0"
        RA            4.5844
        Dec          73.2631
        Distance    2.02e+08  # method: T-F
        Radius     5.581e+04
        AbsMag        -21.06
        Axis    [  0.5641   0.8017  -0.1978]
        Angle     68.8111
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1573"
}

Galaxy "NGC 1573A:UGC 3150:MCG 12-5-20:ZWG 328.21"
{
        Type  "SBc"
        RA            4.8072
        Dec          73.4694
        Distance   2.017e+08  # method: V
        Radius     4.694e+04
        AbsMag        -19.16
        Axis    [ -0.2862   0.9001  -0.3284]
        Angle    170.5051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1573A"
}

Galaxy "NGC 1574:ESO 157-22:AM 0421-570"
{
        Type  "S0"
        RA            4.3661
        Dec         -56.9744
        Distance   6.478e+07  # method: S
        Radius     3.769e+04
        AbsMag        -20.19
        Axis    [  0.5113   0.2538  -0.8211]
        Angle    162.6885
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1574"
}

Galaxy "NGC 1575:NGC 1577:MCG 2-12-14:IRAS 04239-1012"
{
        Type  "SBa"
        RA            4.4389
        Dec         -10.0989
        Distance   1.065e+08  # distance uncertain!
        Radius     2.324e+04
        AbsMag        -19.07
        Axis    [  0.3287   0.6262  -0.7070]
        Angle    149.8659
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1575"
}

Galaxy "NGC 1576:MCG 1-12-7"
{
        Type  "S0"
        RA            4.4383
        Dec          -3.6208
        Distance    1.54e+08  # distance uncertain!
        Radius     2.463e+04
        AbsMag        -19.07
        Axis    [  0.1935   0.7516  -0.6306]
        Angle    133.9422
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1576"
}

Galaxy "NGC 1578:ESO 202-14:FAIR 771:AM 0422-514"
{
        Type  "Sa"
        RA            4.3961
        Dec         -51.5994
        Distance   2.757e+08  # method: V
        Radius     4.811e+04
        AbsMag        -20.73
        Axis    [  0.1693   0.1756  -0.9698]
        Angle    165.6429
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1578"
}

Galaxy "NGC 1580:MCG 1-12-11:IRAS 04258-0517"
{
        Type  "Sc"
        RA            4.4717
        Dec          -5.1792
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.5398   0.6792  -0.4973]
        Angle    138.3183
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1580"
}

Galaxy "NGC 1581:ESO 157-26:IRAS 04236-5503"
{
        Type  "S0"
        RA            4.4122
        Dec         -54.9422
        Distance    6.84e+07  # method: V
        Radius     1.791e+04
        AbsMag        -18.11
        Axis    [  0.6374   0.6563  -0.4038]
        Angle    145.1589
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1581"
}

Galaxy "NGC 1583:ESO 551-8:MCG 3-12-10:NPM 1"
{
        Type  "S0"
        RA            4.4722
        Dec         -17.5961
        Distance   1.851e+08  # distance uncertain!
        Radius     1.885e+04
        AbsMag        -19.07
        Axis    [  0.9698   0.1865   0.1570]
        Angle    132.5273
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1583"
}

Galaxy "NGC 1584:ESO 551-6:NPM 1"
{
        Type  "S0"
        RA            4.4694
        Dec         -17.5239
        Distance   2.125e+08  # distance uncertain!
        Radius     1.855e+04
        AbsMag        -19.07
        Axis    [  0.9697   0.1869   0.1572]
        Angle    132.4612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1584"
}

Galaxy "NGC 1585:ESO 303-18:MCG 7-10-6:IRAS 04259-4216"
{
        Type  "Sc"
        RA            4.4592
        Dec         -42.1650
        Distance   2.088e+08  # method: V
        Radius     3.644e+04
        AbsMag        -19.83
        Axis    [  0.0794   0.3074  -0.9483]
        Angle    136.0842
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1585"
}

Galaxy "NGC 1586:UGC 3062:MCG 0-12-36:ZWG 393.27"
{
        Type  "Sc"
        RA            4.5106
        Dec          -0.3053
        Distance   1.761e+08  # method: T-F
        Radius     4.355e+04
        AbsMag        -19.56
        Axis    [ -0.0551   0.6715  -0.7389]
        Angle    136.4113
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1586"
}

Galaxy "NGC 1587:UGC 3063:MCG 0-12-35:ZWG 393.28"
{
        Type  "E0"
        RA            4.5111
        Dec           0.6625
        Distance   1.226e+08  # method: T-F
        Radius     3.032e+04
        AbsMag        -20.17
        Axis    [  0.7795   0.4750  -0.4084]
        Angle    138.8233
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1587"
}

Galaxy "NGC 1588:UGC 3064:MCG 0-12-37:ZWG 393.29"
{
        Type  "E0"
        RA            4.5119
        Dec           0.6653
        Distance   1.226e+08  # method: T-F
        Radius     1.962e+04
        AbsMag        -18.68
        Axis    [  0.1422   0.5550  -0.8196]
        Angle    195.9316
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1588"
}

Galaxy "NGC 1589:UGC 3065:MCG 0-12-38:ZWG 393.30"
{
        Type  "Sb"
        RA            4.5125
        Dec           0.8633
        Distance   1.686e+08  # method: V
        Radius     7.847e+04
        AbsMag        -20.77
        Axis    [ -0.1890   0.6619  -0.7254]
        Angle    126.7657
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1589"
}

Galaxy "NGC 1590:UGC 3071:MCG 1-12-8:ZWG 419.14"
{
        Type  "S0"
        RA            4.5194
        Dec           7.6308
        Distance    1.73e+08  # method: V
        Radius     2.265e+04
        AbsMag        -19.12
        Axis    [  0.3976   0.8156  -0.4204]
        Angle    127.1884
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1590"
}

Galaxy "NGC 1591:ESO 484-25:MCG 4-11-15:IRAS 04274-2649"
{
        Type  "SBb"
        RA            4.4917
        Dec         -26.7128
        Distance   1.801e+08  # method: T-F
        Radius     3.143e+04
        AbsMag        -19.91
        Axis    [  0.7720   0.6344   0.0388]
        Angle    144.7470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1591"
}

Galaxy "NGC 1592:ESO 421-2:MCG 5-11-11:VV 647"
{
        Type  "S0"
        RA            4.4944
        Dec         -27.4081
        Distance   3.977e+07  # method: V
        Radius          9834
        AbsMag        -15.93
        Axis    [  0.5099   0.7026  -0.4964]
        Angle    133.5411
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1592"
}

Galaxy "NGC 1593:NGC 1608:IC 2077:UGC 3082"
{
        Type  "S0"
        RA            4.5350
        Dec           0.5678
        Distance   1.938e+08  # distance uncertain!
        Radius     4.511e+04
        AbsMag        -19.07
        Axis    [  0.0159   0.8150  -0.5793]
        Angle    121.6179
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1593"
}

Galaxy "NGC 1594:IC 2075:MCG 1-12-14:NPM 1"
{
        Type  "SBc"
        RA            4.5142
        Dec          -5.7978
        Distance   1.929e+08  # method: V
        Radius     5.051e+04
        AbsMag        -20.06
        Axis    [  0.6354   0.7527  -0.1724]
        Angle    126.1088
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1594"
}

Galaxy "NGC 1595:ESO 202-25:AM 0426-475"
{
        Type  "E3"
        RA            4.4725
        Dec         -47.8153
        Distance    1.12e+08  # method: T-F
        Radius     2.117e+04
        AbsMag        -18.98
        Axis    [  0.9911   0.1314   0.0224]
        Angle    163.6786
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1595"
}

Galaxy "NGC 1596:ESO 157-31:AM 0426-550"
{
        Type  "S0"
        RA            4.4606
        Dec         -55.0264
        Distance   4.982e+07  # method: S
        Radius     2.681e+04
        AbsMag        -18.82
        Axis    [  0.6555   0.7531   0.0561]
        Angle    173.4460
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1596"
}

Galaxy "NGC 1597:MCG 2-12-32:NPM 1:IRAS 04287-1124"
{
        Type  "S0"
        RA            4.5203
        Dec         -11.2900
        Distance   2.125e+08  # distance uncertain!
        Radius     2.782e+04
        AbsMag        -19.07
        Axis    [  0.5098   0.7095  -0.4865]
        Angle    134.3429
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1597"
}

Galaxy "NGC 1598:ESO 202-26:AM 0427-475:IRAS 04271-4753"
{
        Type  "SBc"
        RA            4.4758
        Dec         -47.7825
        Distance    1.87e+08  # method: T-F
        Radius     3.809e+04
        AbsMag        -19.99
        Axis    [  0.4636   0.5052  -0.7279]
        Angle    136.7152
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1598"
}

Galaxy "NGC 1599:MCG 1-12-16:IRAS 04292-0441"
{
        Type  "Sc"
        RA            4.5272
        Dec          -4.5886
        Distance   1.612e+08  # distance uncertain!
        Radius      2.11e+04
        AbsMag        -19.07
        Axis    [  0.0133   0.5382  -0.8427]
        Angle    168.7970
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1599"
}

Galaxy "NGC 1600:MCG 1-12-17"
{
        Type  "E3"
        RA            4.5275
        Dec          -5.0872
        Distance   1.739e+08  # method: T-F
        Radius     6.322e+04
        AbsMag        -21.63
        Axis    [  0.9683   0.2497   0.0012]
        Angle    123.0123
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1600"
}

Galaxy "NGC 1601:MCG 1-12-18:NPM 1"
{
        Type  "S0"
        RA            4.5281
        Dec          -5.0597
        Distance   1.739e+08  # method: T-F
        Radius     1.517e+04
        AbsMag        -18.83
        Axis    [  0.3652   0.8635  -0.3477]
        Angle    121.9911
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1601"
}

Galaxy "NGC 1602:ESO 157-32:AM 0426-550:IRAS 04267-5510"
{
        Type  "Irr"
        RA            4.4650
        Dec         -55.0567
        Distance   7.085e+07  # method: V
        Radius     1.958e+04
        AbsMag        -18.18
        Axis    [  0.6909   0.5580  -0.4597]
        Angle    149.5052
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1602"
}

Galaxy "NGC 1603:MCG 1-12-19:NPM 1"
{
        Type  "S0"
        RA            4.5303
        Dec          -5.0939
        Distance   1.739e+08  # method: T-F
        Radius     2.023e+04
        AbsMag        -18.83
        Axis    [  0.6673   0.7420   0.0638]
        Angle    126.1883
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1603"
}

Galaxy "NGC 1604:MCG 1-12-20:NPM 1"
{
        Type  "S0"
        RA            4.5328
        Dec          -5.3694
        Distance   1.851e+08  # distance uncertain!
        Radius     2.692e+04
        AbsMag        -19.07
        Axis    [  0.5706   0.7799  -0.2571]
        Angle    125.7791
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1604"
}

Galaxy "NGC 1606:MCG 1-12-22:NPM 1"
{
        Type  "SBa"
        RA            4.5342
        Dec          -5.0319
        Distance   3.072e+08  # distance uncertain!
        Radius     2.234e+04
        AbsMag        -19.07
        Axis    [  0.9684   0.2039   0.1438]
        Angle    120.1284
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1606"
}

Galaxy "NGC 1607:MCG 1-12-23:IRAS 04295-0433"
{
        Type  "Sa"
        RA            4.5342
        Dec          -4.4606
        Distance    1.47e+08  # distance uncertain!
        Radius     2.139e+04
        AbsMag        -19.07
        Axis    [  0.5025   0.8641   0.0295]
        Angle    124.1902
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1607"
}

Galaxy "NGC 1609:MCG 1-12-25:NPM 1"
{
        Type  "Sa"
        RA            4.5458
        Dec          -4.3719
        Distance   1.612e+08  # distance uncertain!
        Radius     2.579e+04
        AbsMag        -19.07
        Axis    [  0.3991   0.8124  -0.4252]
        Angle    125.8816
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1609"
}

Galaxy "NGC 1611:MCG 1-12-29:IRAS 04306-0424"
{
        Type  "Sa"
        RA            4.5514
        Dec          -4.2969
        Distance    1.54e+08  # distance uncertain!
        Radius     4.479e+04
        AbsMag        -19.07
        Axis    [  0.1478   0.8931  -0.4249]
        Angle    116.1643
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1611"
}

Galaxy "NGC 1612:MCG 1-12-30:NPM 1:IRAS 04307-0416"
{
        Type  "Sa"
        RA            4.5536
        Dec          -4.1719
        Distance    1.54e+08  # distance uncertain!
        Radius     2.911e+04
        AbsMag        -19.07
        Axis    [  0.1593   0.6638  -0.7307]
        Angle    144.9054
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1612"
}

Galaxy "NGC 1613:MCG 1-12-31:NPM 1"
{
        Type  "Sa"
        RA            4.5569
        Dec          -4.2650
        Distance   1.768e+08  # distance uncertain!
        Radius     2.571e+04
        AbsMag        -19.07
        Axis    [  0.7331   0.6763  -0.0725]
        Angle    124.9527
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1613"
}

Galaxy "NGC 1614:MCG 1-12-32:MK 617:ZW 15"
{
        Type  "SBc"
        RA            4.5664
        Dec          -8.5792
        Distance   2.134e+08  # method: V
        Radius     4.034e+04
        AbsMag        -20.48
        Axis    [  0.1471   0.6560  -0.7403]
        Angle    139.7405
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1614"
}

Galaxy "NGC 1615:UGC 3096:MCG 3-12-5:ZWG 467.3"
{
        Type  "S0"
        RA            4.6003
        Dec          19.9508
        Distance   1.341e+08  # distance uncertain!
        Radius     2.341e+04
        AbsMag        -19.07
        Axis    [  0.1212   0.8808  -0.4577]
        Angle    126.7419
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1615"
}

Galaxy "NGC 1616:ESO 251-10:MCG 7-10-13:AM 0431-434"
{
        Type  "Sc"
        RA            4.5447
        Dec         -43.7150
        Distance   2.118e+08  # method: T-F
        Radius     5.544e+04
        AbsMag        -20.76
        Axis    [  0.7405   0.6705  -0.0456]
        Angle    155.9625
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1616"
}

Galaxy "NGC 1617:ESO 157-41:AM 0430-544:IRAS 04305-5442"
{
        Type  "SBa"
        RA            4.5275
        Dec         -54.6019
        Distance   4.766e+07  # method: V
        Radius      2.98e+04
        AbsMag        -19.42
        Axis    [  0.5623   0.5414  -0.6251]
        Angle    137.7211
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1617"
}

Galaxy "NGC 1618:MCG 1-12-34:IRAS 04336-0314"
{
        Type  "SBb"
        RA            4.6017
        Dec          -3.1486
        Distance   1.065e+08  # distance uncertain!
        Radius     3.718e+04
        AbsMag        -19.07
        Axis    [  0.5425   0.8025   0.2485]
        Angle    130.1516
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1618"
}

Galaxy "NGC 1620:UGC 3103:MCG 0-12-52:ZWG 393.46"
{
        Type  "Sc"
        RA            4.6103
        Dec          -0.1442
        Distance   1.494e+08  # method: T-F
        Radius     6.304e+04
        AbsMag         -20.2
        Axis    [  0.5398   0.7980   0.2682]
        Angle    128.0756
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1620"
}

Galaxy "NGC 1621:NGC 1626:MCG 1-12-35:NPM 1"
{
        Type  "E0"
        RA            4.6069
        Dec          -4.9867
        Distance   2.884e+08  # distance uncertain!
        Radius     5.873e+04
        AbsMag        -20.13
        Axis    [  0.6095   0.4980  -0.6169]
        Angle    158.1291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1621"
}

Galaxy "NGC 1622:MCG 1-12-36:NPM 1"
{
        Type  "SBb"
        RA            4.6100
        Dec          -3.1883
        Distance   1.281e+08  # distance uncertain!
        Radius     6.892e+04
        AbsMag        -19.07
        Axis    [  0.4225   0.8726   0.2450]
        Angle    130.5381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1622"
}

Galaxy "NGC 1623:DRCG 10-7"
{
        Type  "SBa"
        RA            4.5922
        Dec         -13.5564
        Distance   4.241e+08  # distance uncertain!
        Radius     4.934e+04
        AbsMag        -19.07
        Axis    [  0.7445   0.6332   0.2116]
        Angle    136.9157
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1623"
}

Galaxy "NGC 1625:MCG 1-12-38:IRAS 04346-0324"
{
        Type  "SBb"
        RA            4.6183
        Dec          -3.3039
        Distance   2.102e+08  # method: V
        Radius     6.419e+04
        AbsMag        -20.94
        Axis    [ -0.0428   0.8228  -0.5667]
        Angle    113.7323
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1625"
}

Galaxy "NGC 1627:MCG 1-12-40:IRAS 04351-0459"
{
        Type  "Sc"
        RA            4.6269
        Dec          -4.8881
        Distance   1.725e+08  # method: V
        Radius     4.013e+04
        AbsMag        -19.92
        Axis    [  0.2896   0.6063  -0.7406]
        Angle    157.0181
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1627"
}

Galaxy "NGC 1628:MCG 1-12-39:IRAS 04351-0448"
{
        Type  "Sb"
        RA            4.6267
        Dec          -4.7158
        Distance   1.647e+08  # method: V
        Radius     4.552e+04
        AbsMag        -19.32
        Axis    [  0.5093   0.7554   0.4123]
        Angle    143.6145
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1628"
}

Galaxy "NGC 1630-1:ESO 551-19:NPM 1"
{
        Type  "Sa"
        RA            4.6208
        Dec         -18.9019
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.2263   0.5908  -0.7744]
        Angle    140.0422
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1630-1"
}

Galaxy "NGC 1630-2"
{
        Type  "S0"
        RA            4.6206
        Dec         -18.9061
        Distance   6.721e+08  # distance uncertain!
        Radius     1.955e+04
        AbsMag        -19.07
        Axis    [  0.5323   0.7980  -0.2827]
        Angle    127.6856
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1630-2"
}

Galaxy "NGC 1631:ESO 551-21:MCG 3-12-17:IRAS 04362-2045"
{
        Type  "SBa"
        RA            4.6400
        Dec         -20.6503
        Distance    4.24e+08  # method: V
        Radius     9.251e+04
        AbsMag        -21.27
        Axis    [  0.7014   0.7108  -0.0535]
        Angle    135.4766
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1631"
}

Galaxy "NGC 1632:IC 386:NPM 1"
{
        Type  "Sa"
        RA            4.6661
        Dec          -9.4558
        Distance    2.44e+08  # distance uncertain!
        Radius     3.549e+04
        AbsMag        -19.07
        Axis    [  0.6729   0.7394   0.0221]
        Angle    127.7087
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1632"
}

Galaxy "NGC 1633:UGC 3125:MCG 1-12-14:ZWG 419.23"
{
        Type  "SBb"
        RA            4.6692
        Dec           7.3497
        Distance    2.23e+08  # method: V
        Radius     3.243e+04
        AbsMag        -19.77
        Axis    [  0.7302   0.6650  -0.1566]
        Angle    117.2616
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1633"
}

Galaxy "NGC 1634:MCG 1-12-15:ZWG 419.22:ARAK 109"
{
        Type  "S0"
        RA            4.6692
        Dec           7.3389
        Distance   3.369e+08  # method: V
        Radius      1.96e+04
        AbsMag        -19.97
        Axis    [  0.2948   0.8082  -0.5098]
        Angle    128.7723
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1634"
}

Galaxy "NGC 1635:UGC 3126:MCG 0-12-63:ZWG 393.60"
{
        Type  "SBa"
        RA            4.6686
        Dec          -0.5472
        Distance   1.017e+08  # distance uncertain!
        Radius     2.071e+04
        AbsMag        -19.07
        Axis    [  0.8943   0.3994   0.2015]
        Angle    119.4970
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1635"
}

Galaxy "NGC 1636:MCG 1-12-42:IRAS 04382-0842"
{
        Type  "Sb"
        RA            4.6778
        Dec          -8.6078
        Distance   1.223e+08  # distance uncertain!
        Radius     2.135e+04
        AbsMag        -19.07
        Axis    [  0.8095   0.5005   0.3068]
        Angle    132.8982
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1636"
}

Galaxy "NGC 1637:MCG 0-12-68:UGCA 93:ZWG 393.66"
{
        Type  "SBc"
        RA            4.6911
        Dec          -2.8578
        Distance   3.003e+07  # method: V
        Radius     1.442e+04
        AbsMag        -18.32
        Axis    [  0.8076   0.5816   0.0971]
        Angle    122.8345
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1637"
}

Galaxy "NGC 1638:UGC 3133:MCG 0-12-69:ZWG 393.68"
{
        Type  "S0"
        RA            4.6933
        Dec          -1.8083
        Distance   1.478e+08  # method: V
        Radius      3.87e+04
        AbsMag        -20.28
        Axis    [  0.5462   0.8048  -0.2323]
        Angle    121.0882
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1638"
}

Galaxy "NGC 1640:ESO 551-27:MCG 3-12-18:IRAS 04400-2031"
{
        Type  "SBb"
        RA            4.7039
        Dec         -20.4347
        Distance    7.09e+07  # method: V
        Radius     2.784e+04
        AbsMag        -19.29
        Axis    [  0.8191   0.5552  -0.1445]
        Angle    136.8210
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1640"
}

Galaxy "NGC 1642:UGC 3140:MCG 0-12-72:ZWG 393.73"
{
        Type  "Sc"
        RA            4.7150
        Dec           0.6189
        Distance   2.074e+08  # method: V
        Radius     5.128e+04
        AbsMag        -20.72
        Axis    [ -0.1178   0.5696  -0.8134]
        Angle    152.8618
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1642"
}

Galaxy "NGC 1643:MCG 1-13-1:IRAS 04412-0524"
{
        Type  "Sc"
        RA            4.7286
        Dec          -5.3189
        Distance   1.404e+08  # distance uncertain!
        Radius     2.451e+04
        AbsMag        -19.07
        Axis    [  0.2074   0.5953  -0.7763]
        Angle    157.1982
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1643"
}

Galaxy "NGC 1645:MCG 1-13-2:NPM 1"
{
        Type  "Sa"
        RA            4.7350
        Dec          -5.4650
        Distance   2.154e+08  # method: V
        Radius     6.578e+04
        AbsMag         -20.2
        Axis    [  0.3675   0.8829  -0.2924]
        Angle    117.6478
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1645"
}

Galaxy "NGC 1646-1:MCG 1-13-3:ZW 22"
{
        Type  "S0"
        RA            4.7397
        Dec          -8.5314
        Distance   1.341e+08  # distance uncertain!
        Radius     4.291e+04
        AbsMag        -19.07
        Axis    [ -0.0587   0.5688  -0.8204]
        Angle    138.6762
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1646-1"
}

Galaxy "NGC 1646-2:ZW 22"
{
        Type  "E0"
        RA            4.7397
        Dec          -8.5350
        Distance   5.496e+08  # distance uncertain!
        Radius     2.398e+04
        AbsMag        -20.13
        Axis    [  0.9824   0.1483   0.1140]
        Angle    122.8353
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1646-2"
}

Galaxy "NGC 1646-3:ZW 22"
{
        Type  "E0"
        RA            4.7406
        Dec          -8.5353
        Distance   7.944e+08  # distance uncertain!
        Radius     4.622e+04
        AbsMag        -20.13
        Axis    [  0.2341   0.4936  -0.8376]
        Angle    186.1534
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1646-3"
}

Galaxy "NGC 1648:MCG 1-13-4:Z 0441.2:NPM 1"
{
        Type  "S0"
        RA            4.7428
        Dec          -8.4783
        Distance   2.802e+08  # distance uncertain!
        Radius     2.445e+04
        AbsMag        -19.07
        Axis    [  0.8547   0.4599   0.2408]
        Angle    129.4690
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1648"
}

Galaxy "NGC 1650:MCG 3-13-1"
{
        Type  "E0"
        RA            4.7531
        Dec         -15.8700
        Distance   1.906e+08  # distance uncertain!
        Radius     6.375e+04
        AbsMag        -20.13
        Axis    [  0.1851   0.4330  -0.8822]
        Angle    189.7476
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1650"
}

Galaxy "NGC 1653:UGC 3153:MCG 0-13-3:ZWG 394.2"
{
        Type  "E0"
        RA            4.7631
        Dec          -2.3928
        Distance   1.358e+08  # method: T-F
        Radius     2.963e+04
        AbsMag         -20.2
        Axis    [  0.9819   0.1561   0.1072]
        Angle    116.7693
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1653"
}

Galaxy "NGC 1654:UGC 3154:ZWG 394.3:IRAS 04433-0210"
{
        Type  "Sa"
        RA            4.7633
        Dec          -2.0833
        Distance   2.052e+08  # method: V
        Radius     2.387e+04
        AbsMag        -19.59
        Axis    [  0.9756   0.1819   0.1228]
        Angle    116.8097
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1654"
}

Galaxy "NGC 1656:MCG 1-13-5"
{
        Type  "Sa"
        RA            4.7647
        Dec          -5.1364
        Distance   1.223e+08  # distance uncertain!
        Radius     2.668e+04
        AbsMag        -19.07
        Axis    [  0.2360   0.7382  -0.6320]
        Angle    129.9622
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1656"
}

Galaxy "NGC 1657:UGC 3156:MCG 0-13-4:ZWG 394.5"
{
        Type  "SBc"
        RA            4.7686
        Dec          -2.0769
        Distance   1.851e+08  # distance uncertain!
        Radius     3.231e+04
        AbsMag        -19.07
        Axis    [  0.0341   0.6642  -0.7468]
        Angle    138.5510
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1657"
}

Galaxy "NGC 1658:ESO 304-16:MCG 7-10-20:AM 0442-413"
{
        Type  "Sc"
        RA            4.7336
        Dec         -41.4636
        Distance   2.458e+08  # method: T-F
        Radius     5.363e+04
        AbsMag        -19.99
        Axis    [  0.3458   0.6236  -0.7011]
        Angle    119.6070
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1658"
}

Galaxy "NGC 1659:IC 4099:MCG 1-13-6:IRAS 04440-0452"
{
        Type  "Sc"
        RA            4.7750
        Dec          -4.7886
        Distance   2.054e+08  # method: V
        Radius     4.481e+04
        AbsMag         -20.7
        Axis    [  0.6934   0.7133  -0.1025]
        Angle    122.6324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1659"
}

Galaxy "NGC 1660:ESO 304-18:MCG 7-10-21:AM 0442-413"
{
        Type  "Sa"
        RA            4.7364
        Dec         -41.4978
        Distance    2.03e+08  # distance uncertain!
        Radius     2.952e+04
        AbsMag        -19.07
        Axis    [  0.7485   0.6629  -0.0199]
        Angle    154.0159
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1660"
}

Galaxy "NGC 1661:UGC 3166:MCG 0-13-8:ZWG 394.9"
{
        Type  "Sc"
        RA            4.7853
        Dec          -2.0550
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.6903   0.7197   0.0735]
        Angle    121.6023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1661"
}

Galaxy "NGC 1665:MCG 1-13-9:NPM 1"
{
        Type  "S0"
        RA            4.8047
        Dec          -5.4272
        Distance    1.22e+08  # method: V
        Radius     3.195e+04
        AbsMag        -19.06
        Axis    [  0.6361   0.7693  -0.0590]
        Angle    121.9580
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1665"
}

Galaxy "NGC 1666:MCG 1-13-10:NPM 1"
{
        Type  "SBa"
        RA            4.8089
        Dec          -6.5694
        Distance   1.115e+08  # distance uncertain!
        Radius     2.271e+04
        AbsMag        -19.07
        Axis    [  0.1608   0.6359  -0.7548]
        Angle    143.0305
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1666"
}

Galaxy "NGC 1667:NGC 1689:MCG 1-13-13:IRAS 04461-0624"
{
        Type  "SBc"
        RA            4.8103
        Dec          -6.3203
        Distance   2.044e+08  # method: V
        Radius     4.161e+04
        AbsMag        -21.18
        Axis    [  0.7785   0.6080   0.1560]
        Angle    126.6469
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1667"
}

Galaxy "NGC 1668:ESO 251-30:MCG 7-10-23:AM 0444-444"
{
        Type  "S0"
        RA            4.7681
        Dec         -44.7328
        Distance   4.559e+08  # method: V
        Radius     1.061e+05
        AbsMag        -21.93
        Axis    [  0.5279   0.5644  -0.6346]
        Angle    134.5744
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1668"
}

Galaxy "NGC 1669:ESO 84-38:IRAS 04428-6553"
{
        Type  "Sa"
        RA            4.7167
        Dec         -65.8142
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.6513   0.4775  -0.5897]
        Angle    144.6292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1669"
}

Galaxy "NGC 1670:MCG 0-13-16:ZWG 394.17"
{
        Type  "S0"
        RA            4.8283
        Dec          -2.7600
        Distance   1.223e+08  # distance uncertain!
        Radius     2.312e+04
        AbsMag        -19.07
        Axis    [  0.4827   0.8498  -0.2120]
        Angle    117.7184
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1670"
}

Galaxy "NGC 1671:IC 395:UGC 3178:MCG 0-13-15"
{
        Type  "S0"
        RA            4.8258
        Dec           0.2533
        Distance   1.281e+08  # distance uncertain!
        Radius     1.676e+04
        AbsMag        -19.07
        Axis    [  0.1524   0.7467  -0.6474]
        Angle    130.6817
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1671"
}

Galaxy "NGC 1672:ESO 118-43:VV 826:AM 0444-592"
{
        Type  "SBb"
        RA            4.7617
        Dec         -59.2478
        Distance   6.098e+07  # method: V
        Radius     5.942e+04
        AbsMag        -20.86
        Axis    [  0.2012   0.1426  -0.9691]
        Angle    151.7849
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1672"
}

Galaxy "NGC 1678:MCG 0-13-19:ZWG 394.20"
{
        Type  "S0"
        RA            4.8597
        Dec          -2.6228
        Distance    1.54e+08  # distance uncertain!
        Radius     2.463e+04
        AbsMag        -19.07
        Axis    [  0.5781   0.7649  -0.2843]
        Angle    120.9428
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1678"
}

Galaxy "NGC 1679:ESO 422-1:MCG 5-12-4:UGCA 96"
{
        Type  "Irr"
        RA            4.8319
        Dec         -31.9672
        Distance   4.449e+07  # method: T-F
        Radius     1.747e+04
        AbsMag        -18.67
        Axis    [  0.2175   0.4493  -0.8665]
        Angle    141.6859
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1679"
}

Galaxy "NGC 1680:ESO 203-4:IRAS 04471-4754"
{
        Type  "SBb"
        RA            4.8092
        Dec         -47.8167
        Distance   1.612e+08  # distance uncertain!
        Radius     2.814e+04
        AbsMag        -19.07
        Axis    [  0.5273   0.6180  -0.5831]
        Angle    130.1011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1680"
}

Galaxy "NGC 1681:MCG 1-13-26:IRAS 04493-0553"
{
        Type  "Sb"
        RA            4.8639
        Dec          -5.8031
        Distance   1.168e+08  # distance uncertain!
        Radius     2.208e+04
        AbsMag        -19.07
        Axis    [  0.2417   0.5952  -0.7664]
        Angle    154.0799
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1681"
}

Galaxy "NGC 1682:MCG 1-13-28:NPM 1"
{
        Type  "S0"
        RA            4.8719
        Dec          -3.1053
        Distance   1.688e+08  # distance uncertain!
        Radius      2.21e+04
        AbsMag        -19.07
        Axis    [  0.9794   0.1669   0.1141]
        Angle    117.6328
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1682"
}

Galaxy "NGC 1683:NPM 1"
{
        Type  "Sa"
        RA            4.8714
        Dec          -3.0242
        Distance   2.802e+08  # distance uncertain!
        Radius     4.075e+04
        AbsMag        -19.07
        Axis    [ -0.1584   0.6244  -0.7649]
        Angle    126.3141
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1683"
}

Galaxy "NGC 1684:MCG 1-13-31:IRAS 04500-0311"
{
        Type  "E0"
        RA            4.8753
        Dec          -3.1056
        Distance   1.381e+08  # distance uncertain!
        Radius     4.417e+04
        AbsMag        -20.13
        Axis    [  0.6648   0.4781  -0.5741]
        Angle    148.5840
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1684"
}

Galaxy "NGC 1685:MCG 1-13-32:IRAS 04500-0301"
{
        Type  "SBa"
        RA            4.8761
        Dec          -2.9497
        Distance   2.034e+08  # method: V
        Radius     3.846e+04
        AbsMag        -18.97
        Axis    [  0.1482   0.7054  -0.6931]
        Angle    133.2060
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1685"
}

Galaxy "NGC 1686:MCG 3-13-19"
{
        Type  "Sc"
        RA            4.8817
        Dec         -15.3464
        Distance   1.688e+08  # distance uncertain!
        Radius     4.174e+04
        AbsMag        -19.07
        Axis    [  0.5170   0.8303   0.2080]
        Angle    138.1273
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1686"
}

Galaxy "NGC 1687:ESO 361-13:MCG 6-11-5"
{
        Type  "SBb"
        RA            4.8558
        Dec         -33.9392
        Distance   1.851e+08  # distance uncertain!
        Radius       3.5e+04
        AbsMag        -19.07
        Axis    [  0.6696   0.7417  -0.0393]
        Angle    143.5658
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1687"
}

Galaxy "NGC 1688:ESO 119-6:AM 0447-595:IRAS 04476-5953"
{
        Type  "SBc"
        RA            4.8064
        Dec         -59.8000
        Distance   4.825e+07  # method: T-F
        Radius     1.684e+04
        AbsMag        -18.55
        Axis    [  0.1383   0.1195  -0.9832]
        Angle    146.9567
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1688"
}

Galaxy "NGC 1690:UGC 3198:MCG 0-13-27:ZWG 394.30"
{
        Type  "E0"
        RA            4.9053
        Dec           1.6406
        Distance   3.953e+08  # method: V
        Radius     5.749e+04
        AbsMag        -20.12
        Axis    [  0.9852   0.1448   0.0921]
        Angle    112.5921
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1690"
}

Galaxy "NGC 1691:UGC 3201:MCG 1-13-9:MK 1088"
{
        Type  "SBa"
        RA            4.9106
        Dec           3.2678
        Distance   2.058e+08  # method: V
        Radius     6.885e+04
        AbsMag         -20.9
        Axis    [  0.7479   0.6637   0.0076]
        Angle    115.6277
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1691"
}

Galaxy "NGC 1692:ESO 552-21:MCG 3-13-29:NPM 1"
{
        Type  "S0"
        RA            4.9231
        Dec         -20.5711
        Distance   4.694e+08  # method: V
        Radius     8.875e+04
        AbsMag        -21.79
        Axis    [  0.9261   0.3452   0.1519]
        Angle    137.8961
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1692"
}

Galaxy "NGC 1694:MCG 1-13-35A:NPM 1"
{
        Type  "Sc"
        RA            4.9211
        Dec          -4.6522
        Distance   2.125e+08  # distance uncertain!
        Radius      3.71e+04
        AbsMag        -19.07
        Axis    [  0.6837   0.7247   0.0859]
        Angle    122.8413
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1694"
}

Galaxy "NGC 1699:MCG 1-13-39:IRAS 04545-0449"
{
        Type  "Sb"
        RA            4.9497
        Dec          -4.7572
        Distance   1.754e+08  # method: V
        Radius     2.296e+04
        AbsMag        -18.95
        Axis    [ -0.0427   0.6390  -0.7681]
        Angle    131.0917
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1699"
}

Galaxy "NGC 1700:MCG 1-13-38"
{
        Type  "E4"
        RA            4.9489
        Dec          -4.8653
        Distance   1.444e+08  # method: S
        Radius     6.929e+04
        AbsMag        -21.03
        Axis    [  0.5008   0.5018  -0.7053]
        Angle    161.8750
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1700"
}

Galaxy "NGC 1701:ESO 422-11:MCG 5-12-10:IRAS 04539-2957"
{
        Type  "Sb"
        RA            4.9308
        Dec         -29.8836
        Distance   2.626e+08  # method: V
        Radius     4.583e+04
        AbsMag        -20.93
        Axis    [  0.3007   0.5007  -0.8117]
        Angle    139.1796
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1701"
}

Galaxy "NGC 1703:ESO 119-19:AM 0452-594:IRAS 04521-5949"
{
        Type  "SBb"
        RA            4.8808
        Dec         -59.7428
        Distance   6.967e+07  # method: V
        Radius     2.939e+04
        AbsMag        -19.65
        Axis    [  0.9422   0.3227   0.0900]
        Angle    176.1924
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1703"
}

Galaxy "NGC 1705:ESO 158-13:AM 0453-532:IRAS 04531-5326"
{
        Type  "S0"
        RA            4.9036
        Dec         -53.3606
        Distance   3.085e+07  # method: V
        Radius          8525
        AbsMag        -17.08
        Axis    [  0.8364   0.4857  -0.2542]
        Angle    158.4526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1705"
}

Galaxy "NGC 1706:ESO 85-7:FAIR 240:AM 0452-630"
{
        Type  "Sb"
        RA            4.8753
        Dec         -62.9861
        Distance   2.222e+08  # method: V
        Radius     4.524e+04
        AbsMag        -20.57
        Axis    [  0.5304   0.3044  -0.7912]
        Angle    145.5182
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1706"
}

Galaxy "NGC 1709:NGC 1717:MCG 0-13-54:ZWG 394.58"
{
        Type  "S0"
        RA            4.9789
        Dec          -0.4778
        Distance    2.13e+08  # method: V
        Radius     2.788e+04
        AbsMag        -18.87
        Axis    [  0.7159   0.6893  -0.1113]
        Angle    117.8325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1709"
}

Galaxy "NGC 1710:IC 2108:MCG 3-13-37"
{
        Type  "S0"
        RA            4.9544
        Dec         -15.2889
        Distance   2.367e+08  # method: V
        Radius     4.475e+04
        AbsMag         -20.3
        Axis    [  0.8413   0.5226   0.1383]
        Angle    133.8013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1710"
}

Galaxy "NGC 1713:UGC 3222:MCG 0-13-56:ZWG 394.59"
{
        Type  "E0"
        RA            4.9817
        Dec          -0.4886
        Distance   2.916e+08  # method: T-F
        Radius     5.938e+04
        AbsMag        -20.86
        Axis    [  0.8945   0.3475  -0.2812]
        Angle    125.6383
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1713"
}

Galaxy "NGC 1716:ESO 552-34:MCG 3-13-38:IRAS 04560-2026"
{
        Type  "SBc"
        RA            4.9703
        Dec         -20.3633
        Distance   3.082e+08  # method: V
        Radius     6.275e+04
        AbsMag        -20.98
        Axis    [  0.8859   0.4613   0.0484]
        Angle    136.6536
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1716"
}

Galaxy "NGC 1719:UGC 3226:MCG 0-13-60:ZWG 394.63"
{
        Type  "Sa"
        RA            4.9928
        Dec          -0.2606
        Distance   1.874e+08  # method: V
        Radius     2.998e+04
        AbsMag         -19.3
        Axis    [  0.1412   0.9257  -0.3508]
        Angle    108.1666
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1719"
}

Galaxy "NGC 1720:MCG 1-13-41:IRAS 04569-0756"
{
        Type  "SBb"
        RA            4.9889
        Dec          -7.8592
        Distance   1.883e+08  # method: V
        Radius     5.478e+04
        AbsMag        -19.91
        Axis    [  0.5156   0.7970  -0.3146]
        Angle    119.2955
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1720"
}

Galaxy "NGC 1721:MCG 2-13-27:VV 699:IRAS 04569-1111"
{
        Type  "S0"
        RA            4.9881
        Dec         -11.1183
        Distance    2.06e+08  # method: V
        Radius     5.693e+04
        AbsMag         -20.2
        Axis    [  0.1435   0.7089  -0.6905]
        Angle    122.3544
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1721"
}

Galaxy "NGC 1723:MCG 2-13-29:IRAS 04571-1103"
{
        Type  "SBa"
        RA            4.9903
        Dec         -10.9806
        Distance    7.37e+07  # distance uncertain!
        Radius     2.787e+04
        AbsMag        -19.07
        Axis    [  0.1250   0.6234  -0.7718]
        Angle    134.6802
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1723"
}

Galaxy "NGC 1725:MCG 2-13-28:VV 699"
{
        Type  "S0"
        RA            4.9894
        Dec         -11.1319
        Distance   1.223e+08  # distance uncertain!
        Radius     2.135e+04
        AbsMag        -19.07
        Axis    [  0.8604   0.5033   0.0805]
        Angle    128.3142
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1725"
}

Galaxy "NGC 1726:MCG 1-13-42"
{
        Type  "S0"
        RA            4.9947
        Dec          -7.7550
        Distance   1.352e+08  # method: T-F
        Radius     3.344e+04
        AbsMag        -20.39
        Axis    [  0.8671   0.4246   0.2606]
        Angle    128.6061
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1726"
}

Galaxy "NGC 1728:MCG 2-13-30:VV 699"
{
        Type  "Sa"
        RA            4.9908
        Dec         -11.1233
        Distance   2.032e+08  # method: V
        Radius     5.911e+04
        AbsMag        -19.17
        Axis    [ -0.2285   0.4868  -0.8431]
        Angle    124.3028
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1728"
}

Galaxy "NGC 1729:MCG 1-13-43:IRAS 04577-0325"
{
        Type  "Sc"
        RA            5.0042
        Dec          -3.3531
        Distance   1.639e+08  # method: V
        Radius     4.054e+04
        AbsMag        -19.91
        Axis    [  0.8184   0.5743   0.0201]
        Angle    120.5076
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1729"
}

Galaxy "NGC 1730:IC 2113:MCG 3-13-43:IRAS 04573-1553"
{
        Type  "SBa"
        RA            4.9919
        Dec         -15.8233
        Distance   1.788e+08  # method: V
        Radius     5.981e+04
        AbsMag        -20.49
        Axis    [  0.3566   0.8050  -0.4741]
        Angle    117.0135
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1730"
}

Galaxy "NGC 1738:ESO 552-49:MCG 3-13-54:IRAS 04595-1813"
{
        Type  "SBc"
        RA            5.0294
        Dec         -18.1575
        Distance   1.797e+08  # method: V
        Radius     3.397e+04
        AbsMag           -20
        Axis    [  0.7046   0.7096   0.0002]
        Angle    131.1399
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1738"
}

Galaxy "NGC 1739:ESO 552-50:MCG 3-13-55"
{
        Type  "Sc"
        RA            5.0297
        Dec         -18.1672
        Distance   1.758e+08  # method: V
        Radius     3.579e+04
        AbsMag        -19.46
        Axis    [  0.3956   0.7279  -0.5600]
        Angle    122.3050
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1739"
}

Galaxy "NGC 1740:MCG 1-13-46:NPM 1"
{
        Type  "S0"
        RA            5.0317
        Dec          -3.2958
        Distance   1.281e+08  # distance uncertain!
        Radius     2.794e+04
        AbsMag        -19.07
        Axis    [  0.7141   0.6748  -0.1865]
        Angle    119.8431
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1740"
}

Galaxy "NGC 1741A:MCG 1-13-45:MK 1089:ARP 259"
{
        Type  "Irr"
        RA            5.0272
        Dec          -4.2589
        Distance   1.825e+08  # method: V
        Radius     2.389e+04
        AbsMag        -18.74
        Axis    [  0.4426   0.8940  -0.0692]
        Angle    115.0105
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1741A"
}

Galaxy "NGC 1741B:MCG 1-13-45:ARP 259:VV 524"
{
        Type  "Irr"
        RA            5.0264
        Dec          -4.2633
        Distance   3.802e+08  # distance uncertain!
        Radius     4.977e+04
        AbsMag        -20.13
        Axis    [  0.7017   0.6928   0.1662]
        Angle    124.0672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1741B"
}

Galaxy "NGC 1744:ESO 486-5:MCG 4-12-29:IRAS 04579-2605"
{
        Type  "SBc"
        RA            4.9992
        Dec         -26.0228
        Distance   4.693e+07  # method: T-F
        Radius     5.051e+04
        AbsMag        -18.99
        Axis    [ -0.0389   0.4486  -0.8929]
        Angle    125.1550
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1744"
}

Galaxy "NGC 1752:MCG 1-13-47:IRAS 04597-0818"
{
        Type  "SBc"
        RA            5.0358
        Dec          -8.2408
        Distance   1.672e+08  # method: T-F
        Radius     6.321e+04
        AbsMag        -20.25
        Axis    [  0.4171   0.8979  -0.1409]
        Angle    114.9449
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1752"
}

Galaxy "NGC 1753:MCG 1-13-48:IRAS 05000-0324"
{
        Type  "Sa"
        RA            5.0422
        Dec          -3.3447
        Distance   2.676e+08  # distance uncertain!
        Radius     5.448e+04
        AbsMag        -19.07
        Axis    [ -0.1746   0.6009  -0.7800]
        Angle    126.6445
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1753"
}

Galaxy "NGC 1759:ESO 305-1:MCG 6-12-2:AM 0459-384"
{
        Type  "E0"
        RA            5.0136
        Dec         -38.6736
        Distance   2.291e+08  # distance uncertain!
        Radius     3.999e+04
        AbsMag        -20.13
        Axis    [  0.9912   0.0805   0.1054]
        Angle    152.3497
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1759"
}

Galaxy "NGC 1762:UGC 3238:MCG 0-13-67:ZWG 394.73"
{
        Type  "Sc"
        RA            5.0603
        Dec           1.5733
        Distance   2.088e+08  # method: V
        Radius     5.164e+04
        AbsMag        -20.63
        Axis    [ -0.1720   0.5716  -0.8023]
        Angle    144.8833
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1762"
}

Galaxy "NGC 1765:ESO 119-24:AM 0457-620"
{
        Type  "S0"
        RA            4.9733
        Dec         -62.0278
        Distance   1.281e+08  # distance uncertain!
        Radius     2.235e+04
        AbsMag        -19.07
        Axis    [  0.3476   0.1752  -0.9211]
        Angle    150.7321
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1765"
}

Galaxy "NGC 1771:ESO 85-27:IRAS 04585-6322"
{
        Type  "Sc"
        RA            4.9819
        Dec         -63.2983
        Distance   2.159e+08  # method: T-F
        Radius     5.654e+04
        AbsMag         -19.9
        Axis    [  0.3972   0.4173  -0.8174]
        Angle    114.6910
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1771"
}

Galaxy "NGC 1779:MCG 2-13-41:IRAS 05029-0912"
{
        Type  "SBa"
        RA            5.0883
        Dec          -9.1478
        Distance   1.607e+08  # method: V
        Radius     5.844e+04
        AbsMag        -20.46
        Axis    [  0.3137   0.7784  -0.5438]
        Angle    118.5786
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1779"
}

Galaxy "NGC 1780:ESO 553-1:ESO 552-71:MCG 3-13-70"
{
        Type  "S0"
        RA            5.1056
        Dec         -19.4669
        Distance   1.851e+08  # distance uncertain!
        Radius     2.423e+04
        AbsMag        -19.07
        Axis    [  0.5276   0.7476  -0.4034]
        Angle    122.0870
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1780"
}

Galaxy "NGC 1781:NGC 1794:ESO 553-7:MCG 3-14-2"
{
        Type  "S0"
        RA            5.1319
        Dec         -18.1900
        Distance   2.259e+08  # method: V
        Radius     4.272e+04
        AbsMag         -20.5
        Axis    [  0.8259   0.5370  -0.1719]
        Angle    131.2800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1781"
}

Galaxy "NGC 1784:MCG 2-13-42:IRAS 05030-1156"
{
        Type  "SBc"
        RA            5.0908
        Dec         -11.8711
        Distance   1.145e+08  # method: T-F
        Radius     6.829e+04
        AbsMag        -20.33
        Axis    [  0.3834   0.7386  -0.5544]
        Angle    122.1068
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1784"
}

Galaxy "NGC 1792:ESO 305-6:MCG 6-12-4:AM 0503-380"
{
        Type  "SBc"
        RA            5.0869
        Dec         -37.9797
        Distance   4.412e+07  # method: T-F
        Radius     3.337e+04
        AbsMag        -19.85
        Axis    [  0.2671   0.5154  -0.8142]
        Angle    122.4162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1792"
}

Galaxy "NGC 1796:ESO 119-30:AM 0507-611:IRAS 05021-6112"
{
        Type  "SBb"
        RA            5.0450
        Dec         -61.1397
        Distance   4.476e+07  # method: V
        Radius     1.172e+04
        AbsMag        -17.79
        Axis    [  0.6135   0.4497  -0.6491]
        Angle    139.7406
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1796"
}

Galaxy "NGC 1796A:ESO 119-35"
{
        Type  "Sb"
        RA            5.0842
        Dec         -61.4839
        Distance   3.952e+08  # method: V
        Radius     9.771e+04
        AbsMag        -20.52
        Axis    [  0.2914   0.3350  -0.8960]
        Angle    110.5374
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1796A"
}

Galaxy "NGC 1796B1:ESO 119-37:IRAS 05073-6115"
{
        Type  "Sc"
        RA            5.1314
        Dec         -61.1906
        Distance    2.62e+08  # method: V
        Radius     4.191e+04
        AbsMag        -18.72
        Axis    [  0.7145   0.6987  -0.0369]
        Angle    170.7491
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1796B1"
}

Galaxy "NGC 1796B2:ESO 119-37A"
{
        Type  "S0"
        RA            5.1319
        Dec         -61.1936
        Distance   4.241e+08  # distance uncertain!
        Radius     3.701e+04
        AbsMag        -19.07
        Axis    [  0.7401   0.6673  -0.0832]
        Angle    167.4808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1796B2"
}

Galaxy "NGC 1797:MCG 1-14-2:MK 1093:IRAS 05053-0805"
{
        Type  "Sa"
        RA            5.1289
        Dec          -8.0189
        Distance   2.007e+08  # method: V
        Radius     4.671e+04
        AbsMag        -19.55
        Axis    [  0.4582   0.7792  -0.4277]
        Angle    118.5393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1797"
}

Galaxy "NGC 1799:MCG 1-14-1"
{
        Type  "S0"
        RA            5.1289
        Dec          -7.9689
        Distance   1.851e+08  # distance uncertain!
        Radius     2.962e+04
        AbsMag        -19.07
        Axis    [  0.1767   0.7432  -0.6453]
        Angle    119.7263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1799"
}

Galaxy "NGC 1800:ESO 422-30:MCG 5-13-4:AM 0504-320"
{
        Type  "Irr"
        RA            5.1069
        Dec         -31.9544
        Distance   3.642e+07  # method: V
        Radius     1.059e+04
        AbsMag        -17.14
        Axis    [  0.4132   0.6245  -0.6628]
        Angle    124.6091
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1800"
}

Galaxy "NGC 1803:ESO 203-18:IRAS 05041-4938"
{
        Type  "SBc"
        RA            5.0906
        Dec         -49.5675
        Distance   1.877e+08  # method: V
        Radius     3.549e+04
        AbsMag         -20.4
        Axis    [  0.7561   0.5599  -0.3387]
        Angle    147.3667
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1803"
}

Galaxy "NGC 1808:ESO 305-8:MCG 6-12-5:AM 0505-373"
{
        Type  "SBa"
        RA            5.1283
        Dec         -37.5133
        Distance   4.607e+07  # method: V
        Radius     4.355e+04
        AbsMag        -19.95
        Axis    [  0.3163   0.5003  -0.8060]
        Angle    127.8831
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1808"
}

Galaxy "NGC 1809:ESO 56-48:IRAS 05023-6937"
{
        Type  "Sc"
        RA            5.0347
        Dec         -69.5683
        Distance   6.011e+07  # method: V
        Radius     2.798e+04
        AbsMag        -18.13
        Axis    [  0.3910   0.3373  -0.8563]
        Angle    111.0096
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1809"
}

Galaxy "NGC 1811:ESO 422-37:MCG 5-13-8:AM 0506-292"
{
        Type  "Sa"
        RA            5.1450
        Dec         -29.2764
        Distance   1.792e+08  # method: V
        Radius      4.43e+04
        AbsMag         -19.2
        Axis    [  0.5316   0.8343  -0.1461]
        Angle    127.0705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1811"
}

Galaxy "NGC 1812:ESO 422-39:MCG 5-13-9:AM 0506-291"
{
        Type  "Sa"
        RA            5.1478
        Dec         -29.2517
        Distance   1.776e+08  # method: V
        Radius       3.1e+04
        AbsMag        -20.08
        Axis    [  0.8694   0.4734   0.1417]
        Angle    147.3355
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1812"
}

Galaxy "NGC 1819:UGC 3265:MCG 1-14-2:MK 1194"
{
        Type  "S0"
        RA            5.1961
        Dec           5.2008
        Distance    2.02e+08  # method: V
        Radius     3.819e+04
        AbsMag        -20.46
        Axis    [  0.2374   0.7578  -0.6077]
        Angle    126.8159
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1819"
}

Galaxy "NGC 1821:MCG 3-14-7:IRAS 05095-1511"
{
        Type  "Irr"
        RA            5.1961
        Dec         -15.1344
        Distance   2.754e+08  # distance uncertain!
        Radius     4.807e+04
        AbsMag        -20.13
        Axis    [  0.2693   0.6575  -0.7037]
        Angle    126.1131
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1821"
}

Galaxy "NGC 1824:ESO 119-36:AM 0506-594:IRAS 05061-5947"
{
        Type  "Irr"
        RA            5.1156
        Dec         -59.7253
        Distance    4.92e+07  # method: T-F
        Radius      2.29e+04
        AbsMag        -17.79
        Axis    [  0.1997   0.2952  -0.9343]
        Angle    104.5149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1824"
}

Galaxy "NGC 1827:ESO 362-6:MCG 6-12-8:AM 0508-370"
{
        Type  "SBc"
        RA            5.1678
        Dec         -36.9603
        Distance   4.815e+07  # method: V
        Radius     2.101e+04
        AbsMag        -17.55
        Axis    [  0.2880   0.6970  -0.6567]
        Angle    107.8913
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1827"
}

Galaxy "NGC 1832:MCG 3-14-10:IRAS 05098-1544"
{
        Type  "SBc"
        RA            5.2008
        Dec         -15.6889
        Distance   1.133e+08  # method: T-F
        Radius     4.283e+04
        AbsMag         -20.6
        Axis    [  0.8104   0.5580   0.1785]
        Angle    134.9059
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1832"
}

Galaxy "NGC 1843:MCG 2-14-8:UGCA 107:IRAS 05117-1041"
{
        Type  "Sc"
        RA            5.2350
        Dec         -10.6267
        Distance   1.184e+08  # method: V
        Radius     3.615e+04
        AbsMag         -19.4
        Axis    [  0.3273   0.6360  -0.6988]
        Angle    132.8626
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1843"
}

Galaxy "NGC 1853:ESO 158-22:AM 0511-572:IRAS 05114-5727"
{
        Type  "SBc"
        RA            5.2044
        Dec         -57.3994
        Distance   1.183e+08  # method: T-F
        Radius     3.442e+04
        AbsMag         -19.2
        Axis    [  0.7247   0.6626  -0.1891]
        Angle    155.1462
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1853"
}

Galaxy "NGC 1875:MCG 1-14-31:ZWG 421.39:ARP 327"
{
        Type  "S0"
        RA            5.3625
        Dec           6.6889
        Distance   4.077e+08  # method: V
        Radius     4.743e+04
        AbsMag        -20.78
        Axis    [  0.8744   0.4783   0.0819]
        Angle    109.4687
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1875"
}

Galaxy "NGC 1879:ESO 423-6:MCG 5-13-16:UGCA 110"
{
        Type  "Irr"
        RA            5.3300
        Dec         -32.1425
        Distance   8.811e+07  # method: T-F
        Radius     3.204e+04
        AbsMag        -18.96
        Axis    [  0.7446   0.5955  -0.3017]
        Angle    134.6179
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1879"
}

Galaxy "NGC 1886:ESO 487-2:MCG 4-13-13:FGCE 485"
{
        Type  "Sc"
        RA            5.3633
        Dec         -23.8100
        Distance   1.026e+08  # method: T-F
        Radius     4.624e+04
        AbsMag        -18.89
        Axis    [  0.4885   0.8664  -0.1038]
        Angle    120.8442
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1886"
}

Galaxy "NGC 1888:MCG 2-14-13:ARP 123:IRAS 05202-1132"
{
        Type  "SBc"
        RA            5.3761
        Dec         -11.5003
        Distance   1.109e+08  # method: V
        Radius     4.841e+04
        AbsMag        -19.86
        Axis    [ -0.0832   0.6934  -0.7158]
        Angle    105.5515
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1888"
}

Galaxy "NGC 1889:MCG 2-14-14:ARP 123"
{
        Type  "E0"
        RA            5.3764
        Dec         -11.4969
        Distance   1.131e+08  # method: V
        Radius          9871
        AbsMag         -18.6
        Axis    [  0.1663   0.4650  -0.8695]
        Angle    180.3056
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1889"
}

Galaxy "NGC 1892:ESO 85-61:IRAS 05169-6500"
{
        Type  "Sc"
        RA            5.2858
        Dec         -64.9603
        Distance   5.912e+07  # method: T-F
        Radius     2.494e+04
        AbsMag        -18.49
        Axis    [  0.6527   0.6204  -0.4350]
        Angle    140.3933
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1892"
}

Galaxy "NGC 1906:MCG 3-14-15:IRAS 05224-1559"
{
        Type  "Sc"
        RA            5.4131
        Dec         -15.9428
        Distance   1.938e+08  # distance uncertain!
        Radius     2.537e+04
        AbsMag        -19.07
        Axis    [  0.0686   0.6057  -0.7928]
        Angle    121.0604
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1906"
}

Galaxy "NGC 1924:MCG 1-14-11:NPM 1:IRAS 05255-0521"
{
        Type  "SBc"
        RA            5.4669
        Dec          -5.3103
        Distance   1.159e+08  # method: V
        Radius     2.697e+04
        AbsMag        -19.45
        Axis    [  0.1258   0.6456  -0.7533]
        Angle    130.6263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1924"
}

Galaxy "NGC 1930:ESO 253-4"
{
        Type  "S0"
        RA            5.4322
        Dec         -46.7283
        Distance   1.732e+08  # method: T-F
        Radius     4.787e+04
        AbsMag        -20.23
        Axis    [  0.8346   0.5379  -0.1189]
        Angle    152.9046
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1930"
}

Galaxy "NGC 1947:ESO 85-87:AM 0526-634:IRAS 05264-6347"
{
        Type  "S0"
        RA            5.4464
        Dec         -63.7608
        Distance   5.423e+07  # method: V
        Radius     2.366e+04
        AbsMag         -19.3
        Axis    [  0.5421   0.2028  -0.8155]
        Angle    153.9372
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1947"
}

Galaxy "NGC 1954:MCG 2-15-3:NPM 1:IRAS 05305-1405"
{
        Type  "Sc"
        RA            5.5467
        Dec         -14.0622
        Distance   1.432e+08  # method: V
        Radius      8.75e+04
        AbsMag        -20.61
        Axis    [ -0.0200   0.6057  -0.7954]
        Angle    116.0324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1954"
}

Galaxy "NGC 1956:ESO 16-2:AM 0522-774"
{
        Type  "Sa"
        RA            5.3264
        Dec         -77.7297
        Distance   2.211e+08  # method: V
        Radius      6.11e+04
        AbsMag        -20.16
        Axis    [  0.7421   0.4873  -0.4602]
        Angle    156.5757
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1956"
}

Galaxy "NGC 1957:NPM 1"
{
        Type  "E0"
        RA            5.5486
        Dec         -14.1325
        Distance   3.312e+08  # distance uncertain!
        Radius     5.298e+04
        AbsMag        -20.13
        Axis    [  0.1239   0.4432  -0.8878]
        Angle    180.2905
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1957"
}

Galaxy "NGC 1961:IC 2133:UGC 3334:MCG 12-6-7"
{
        Type  "SBc"
        RA            5.7008
        Dec          69.3786
        Distance   1.772e+08  # method: V
        Radius      1.16e+05
        AbsMag        -21.97
        Axis    [ -0.0439   0.9964   0.0726]
        Angle     90.8282
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1961"
}

Galaxy "NGC 1964:ESO 554-10:MCG 4-14-3:IRAS 05312-2158"
{
        Type  "SBb"
        RA            5.5558
        Dec         -21.9453
        Distance   7.108e+07  # method: T-F
        Radius     5.789e+04
        AbsMag        -20.09
        Axis    [  0.6655   0.7440   0.0602]
        Angle    131.6166
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1964"
}

Galaxy "NGC 1979:ESO 487-24:MCG 4-14-4:AM 0531-232"
{
        Type  "S0"
        RA            5.5669
        Dec         -23.3103
        Distance   7.717e+07  # distance uncertain!
        Radius      2.02e+04
        AbsMag        -19.07
        Axis    [  0.9962   0.0692   0.0534]
        Angle    136.9671
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1979"
}

Galaxy "NGC 1989:ESO 423-21:MCG 5-14-4:AM 0532-304"
{
        Type  "S0"
        RA            5.5731
        Dec         -30.8006
        Distance   4.903e+08  # method: V
        Radius     9.983e+04
        AbsMag        -21.78
        Axis    [  0.5137   0.5114  -0.6889]
        Angle    131.7834
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1989"
}

Galaxy "NGC 1992:ESO 423-23:MCG 5-14-7:AM 0532-305"
{
        Type  "Sa"
        RA            5.5753
        Dec         -30.8969
        Distance    4.81e+08  # method: V
        Radius     7.696e+04
        AbsMag        -21.14
        Axis    [  0.7853   0.5927  -0.1787]
        Angle    134.3197
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1992"
}

Galaxy "NGC 1993:ESO 554-14:MCG 3-15-3"
{
        Type  "S0"
        RA            5.5903
        Dec         -17.8150
        Distance   1.017e+08  # distance uncertain!
        Radius     2.219e+04
        AbsMag        -19.07
        Axis    [  0.6998   0.4819  -0.5273]
        Angle    132.6296
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1993"
}

Galaxy "NGC 1998:ESO 204-15"
{
        Type  "S0"
        RA            5.5542
        Dec         -48.6953
        Distance    2.33e+08  # distance uncertain!
        Radius     3.051e+04
        AbsMag        -19.07
        Axis    [  0.8296   0.5575  -0.0315]
        Angle    158.1913
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1998"
}

Galaxy "NGC 2007:ESO 204-19:AM 0533-505"
{
        Type  "Sc"
        RA            5.5828
        Dec         -50.9217
        Distance   1.932e+08  # method: T-F
        Radius     4.777e+04
        AbsMag        -19.76
        Axis    [  0.6046   0.6276  -0.4905]
        Angle    126.9731
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2007"
}

Galaxy "NGC 2008:ESO 204-20:AM 0533-505:IRAS 05338-5059"
{
        Type  "Sc"
        RA            5.5842
        Dec         -50.9661
        Distance   4.705e+08  # method: V
        Radius     9.581e+04
        AbsMag         -21.9
        Axis    [  0.5305   0.5050  -0.6808]
        Angle    125.5140
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2008"
}

Galaxy "NGC 2012:ESO 16-5"
{
        Type  "S0"
        RA            5.3764
        Dec         -79.8519
        Distance    2.22e+08  # method: V
        Radius     3.551e+04
        AbsMag        -20.06
        Axis    [  0.5805   0.2407  -0.7779]
        Angle    139.8045
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2012"
}

Galaxy "NGC 2049:ESO 424-11:MCG 5-14-11:AM 0541-300"
{
        Type  "Sa"
        RA            5.7208
        Dec         -30.0781
        Distance   1.168e+08  # distance uncertain!
        Radius     3.398e+04
        AbsMag        -19.07
        Axis    [ -0.0726   0.3873  -0.9191]
        Angle    118.1897
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2049"
}

Galaxy "NGC 2073:ESO 554-31:MCG 4-14-24"
{
        Type  "S0"
        RA            5.7647
        Dec         -21.9992
        Distance   1.017e+08  # distance uncertain!
        Radius     2.219e+04
        AbsMag        -19.07
        Axis    [  0.9661   0.2340   0.1090]
        Angle    137.0888
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2073"
}

Galaxy "NGC 2076:MCG 3-15-12:IRAS 05445-1648"
{
        Type  "Sa"
        RA            5.7797
        Dec         -16.7828
        Distance   1.001e+08  # method: V
        Radius     3.203e+04
        AbsMag        -18.53
        Axis    [  0.7462   0.6554  -0.1169]
        Angle    120.9575
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2076"
}

Galaxy "NGC 2082:ESO 86-21:IRAS 05415-6419"
{
        Type  "SBb"
        RA            5.6972
        Dec         -64.3014
        Distance   5.848e+07  # method: V
        Radius     1.106e+04
        AbsMag        -18.67
        Axis    [  0.9319   0.2386  -0.2733]
        Angle    171.1679
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2082"
}

Galaxy "NGC 2087:ESO 159-26:IRAS 05433-5533"
{
        Type  "SBa"
        RA            5.7378
        Dec         -55.5331
        Distance   1.851e+08  # distance uncertain!
        Radius     2.154e+04
        AbsMag        -19.07
        Axis    [  0.3581   0.2613  -0.8964]
        Angle    136.4438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2087"
}

Galaxy "NGC 2089:ESO 554-36:MCG 3-15-16:IRAS 05456-1738"
{
        Type  "S0"
        RA            5.7975
        Dec         -17.6028
        Distance   8.081e+07  # distance uncertain!
        Radius     2.233e+04
        AbsMag        -19.07
        Axis    [  0.7857   0.6126  -0.0863]
        Angle    123.5132
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2089"
}

Galaxy "NGC 2090:ESO 363-23:MCG 6-13-9:AM 0545-341"
{
        Type  "Sc"
        RA            5.7836
        Dec         -34.2508
        Distance   4.811e+07  # method: T-F
        Radius     3.429e+04
        AbsMag        -18.84
        Axis    [  0.8077   0.5843   0.0792]
        Angle    147.7745
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2090"
}

Galaxy "NGC 2101:ESO 205-1:AM 0545-520:IRAS 05451-5206"
{
        Type  "Irr"
        RA            5.7728
        Dec         -52.0900
        Distance   5.658e+07  # method: V
        Radius     1.646e+04
        AbsMag         -17.5
        Axis    [  0.6708   0.4569  -0.5842]
        Angle    136.7567
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2101"
}

Galaxy "NGC 2104:ESO 205-2:AM 0545-513:IRAS 05459-5133"
{
        Type  "Irr"
        RA            5.7844
        Dec         -51.5531
        Distance   4.236e+07  # method: T-F
        Radius     1.232e+04
        AbsMag        -17.37
        Axis    [  0.1056   0.2631  -0.9590]
        Angle    112.5393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2104"
}

Galaxy "NGC 2106:ESO 555-3:MCG 4-14-40"
{
        Type  "S0"
        RA            5.8461
        Dec         -21.5669
        Distance    8.86e+07  # distance uncertain!
        Radius     3.479e+04
        AbsMag        -19.07
        Axis    [  0.4072   0.6954  -0.5921]
        Angle    110.5199
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2106"
}

Galaxy "NGC 2110:MCG 1-15-4:IRAS 05497-0728"
{
        Type  "S0"
        RA            5.8697
        Dec          -7.4564
        Distance   1.061e+08  # method: V
        Radius     2.623e+04
        AbsMag        -19.06
        Axis    [ -0.1598   0.5123  -0.8438]
        Angle    135.7268
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2110"
}

Galaxy "NGC 2115:ESO 205-6:AM 0550-503:IRAS 05501-5036"
{
        Type  "Sa"
        RA            5.8553
        Dec         -50.5833
        Distance   1.404e+08  # distance uncertain!
        Radius     1.634e+04
        AbsMag        -19.07
        Axis    [  0.8722   0.3276  -0.3631]
        Angle    153.3788
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2115"
}

Galaxy "NGC 2115A:ESO 205-6A"
{
        Type  "Sa"
        RA            5.8558
        Dec         -50.5922
        Distance   3.369e+08  # distance uncertain!
        Radius      2.94e+04
        AbsMag        -19.07
        Axis    [  0.8397   0.3645  -0.4025]
        Angle    150.3273
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2115A"
}

Galaxy "NGC 2119:UGC 3380"
{
        Type  "E0"
        RA            5.9572
        Dec          11.9489
        Distance   2.884e+08  # distance uncertain!
        Radius     5.034e+04
        AbsMag        -20.13
        Axis    [  0.2395   0.6157  -0.7508]
        Angle    158.6160
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2119"
}

Galaxy "NGC 2124:ESO 555-16:MCG 3-16-3:IRAS 05557-2005"
{
        Type  "Sb"
        RA            5.9644
        Dec         -20.0850
        Distance   1.525e+08  # method: T-F
        Radius      5.99e+04
        AbsMag        -19.95
        Axis    [  0.7467   0.6241   0.2300]
        Angle    141.3486
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2124"
}

Galaxy "NGC 2128:UGC 3392:MCG 10-9-10:ZWG 284.6"
{
        Type  "S0"
        RA            6.0761
        Dec          57.6275
        Distance   1.427e+08  # method: V
        Radius     3.113e+04
        AbsMag         -19.6
        Axis    [  0.3314   0.9311   0.1525]
        Angle     73.7418
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2128"
}

Galaxy "NGC 2131:ESO 488-50"
{
        Type  "Irr"
        RA            5.9797
        Dec         -26.6531
        Distance    7.91e+07  # method: V
        Radius     1.265e+04
        AbsMag        -17.32
        Axis    [  0.2951   0.6424  -0.7072]
        Angle    106.7901
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2131"
}

Galaxy "NGC 2139:IC 2154:ESO 488-54:MCG 4-15-5"
{
        Type  "SBc"
        RA            6.0189
        Dec         -23.6728
        Distance   9.069e+07  # method: T-F
        Radius     3.166e+04
        AbsMag        -19.92
        Axis    [  0.1930   0.4794  -0.8561]
        Angle    129.1837
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2139"
}

Galaxy "NGC 2144:ESO 16-10:AM 0546-820:IRAS 05464-8208"
{
        Type  "Sa"
        RA            5.6822
        Dec         -82.1189
        Distance   1.281e+08  # distance uncertain!
        Radius     2.608e+04
        AbsMag        -19.07
        Axis    [  0.7038   0.1732  -0.6889]
        Angle    162.3013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2144"
}

Galaxy "NGC 2146:UGC 3429:MCG 13-5-22:ZWG 348.17"
{
        Type  "SBb"
        RA            6.3106
        Dec          78.3558
        Distance   3.959e+07  # method: V
        Radius      3.11e+04
        AbsMag        -19.12
        Axis    [  0.0268   0.8311   0.5554]
        Angle     72.3881
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2146"
}

Galaxy "NGC 2146A:UGC 3439:MCG 13-5-25:ZWG 348.19"
{
        Type  "SBc"
        RA            6.3983
        Dec          78.5300
        Distance   8.707e+07  # method: T-F
        Radius     3.799e+04
        AbsMag        -18.63
        Axis    [  0.1966   0.5461   0.8143]
        Angle     74.4005
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2146A"
}

Galaxy "NGC 2148:ESO 120-24:IRAS 05581-5907"
{
        Type  "Sb"
        RA            5.9792
        Dec         -59.1264
        Distance   1.768e+08  # distance uncertain!
        Radius     2.828e+04
        AbsMag        -19.07
        Axis    [  0.2329   0.1775  -0.9562]
        Angle    132.5987
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2148"
}

Galaxy "NGC 2150:ESO 57-55:IRAS 05562-6933"
{
        Type  "SBb"
        RA            5.9294
        Dec         -69.5608
        Distance   2.036e+08  # method: V
        Radius     3.554e+04
        AbsMag        -19.98
        Axis    [  0.3307   0.1110  -0.9372]
        Angle    138.4680
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2150"
}

Galaxy "NGC 2152:ESO 205-15"
{
        Type  "SBa"
        RA            6.0153
        Dec         -50.7408
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [  0.7580   0.4225  -0.4969]
        Angle    141.3741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2152"
}

Galaxy "NGC 2178:ESO 86-53"
{
        Type  "E1"
        RA            6.0464
        Dec         -63.7639
        Distance    1.82e+08  # distance uncertain!
        Radius     2.382e+04
        AbsMag        -20.13
        Axis    [  1.0000  -0.0026  -0.0055]
        Angle    177.2032
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2178"
}

Galaxy "NGC 2179:ESO 555-38:MCG 4-15-11:IRAS 06059-2144"
{
        Type  "SBa"
        RA            6.1339
        Dec         -21.7461
        Distance   1.306e+08  # method: V
        Radius     2.089e+04
        AbsMag        -19.81
        Axis    [ -0.0658   0.4054  -0.9117]
        Angle    138.9831
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2179"
}

Galaxy "NGC 2187:ESO 57-68:AM 0604-693:IRAS 06041-6934"
{
        Type  "Sa"
        RA            6.0644
        Dec         -69.5778
        Distance   9.278e+07  # distance uncertain!
        Radius     1.754e+04
        AbsMag        -19.07
        Axis    [  0.6226   0.2675  -0.7354]
        Angle    143.5557
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2187"
}

Galaxy "NGC 2187A:ESO 57-68A"
{
        Type  "Sa"
        RA            6.0622
        Dec         -69.5881
        Distance   8.081e+07  # distance uncertain!
        Radius     1.998e+04
        AbsMag        -19.07
        Axis    [  0.6075   0.3441  -0.7159]
        Angle    134.4693
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2187A"
}

Galaxy "NGC 2188:ESO 364-37:MCG 6-14-8:AM 0608-340"
{
        Type  "Irr"
        RA            6.1692
        Dec         -34.1050
        Distance   3.783e+07  # method: V
        Radius     2.311e+04
        AbsMag        -18.22
        Axis    [ -0.2200   0.2981  -0.9288]
        Angle     98.0040
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2188"
}

Galaxy "NGC 2191:ESO 160-14"
{
        Type  "S0"
        RA            6.1397
        Dec         -52.5122
        Distance    2.08e+08  # method: V
        Radius     5.142e+04
        AbsMag        -21.62
        Axis    [  0.4322   0.4011  -0.8077]
        Angle    118.8016
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2191"
}

Galaxy "NGC 2196:ESO 556-4:MCG 4-15-14:UGCA 121"
{
        Type  "Sa"
        RA            6.2025
        Dec         -21.8061
        Distance   1.093e+08  # method: V
        Radius      4.45e+04
        AbsMag        -20.82
        Axis    [  0.8767   0.4535  -0.1604]
        Angle    126.4743
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2196"
}

Galaxy "NGC 2199:ESO 34-3:FAIR 247:IRAS 06060-7323"
{
        Type  "Sa"
        RA            6.0789
        Dec         -73.4000
        Distance    2.65e+08  # method: T-F
        Radius     7.709e+04
        AbsMag        -20.75
        Axis    [  0.7836   0.5445  -0.2992]
        Angle    163.0378
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2199"
}

Galaxy "NGC 2200:ESO 254-39:MCG 7-13-6:AM 0611-433"
{
        Type  "SBc"
        RA            6.2214
        Dec         -43.6631
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [  0.0438   0.2659  -0.9630]
        Angle    123.4976
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2200"
}

Galaxy "NGC 2201:ESO 254-40:MCG 7-13-7:AM 0611-433"
{
        Type  "SBb"
        RA            6.2253
        Dec         -43.7050
        Distance    1.54e+08  # distance uncertain!
        Radius     2.463e+04
        AbsMag        -19.07
        Axis    [  0.4170   0.5124  -0.7507]
        Angle    110.6874
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2201"
}

Galaxy "NGC 2205:ESO 86-63:AM 0610-623"
{
        Type  "S0"
        RA            6.1756
        Dec         -62.5386
        Distance   3.831e+08  # method: V
        Radius       7.8e+04
        AbsMag        -21.65
        Axis    [  0.7014   0.3785  -0.6040]
        Angle    141.4028
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2205"
}

Galaxy "NGC 2206:ESO 489-26:MCG 4-15-19:UGCA 123"
{
        Type  "SBc"
        RA            6.2664
        Dec         -26.7653
        Distance   2.682e+08  # method: T-F
        Radius     9.363e+04
        AbsMag        -21.67
        Axis    [  0.1338   0.5235  -0.8415]
        Angle    109.0052
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2206"
}

Galaxy "NGC 2207:ESO 556-8:MCG 4-15-20:UGCA 124"
{
        Type  "SBc"
        RA            6.2725
        Dec         -21.3728
        Distance   1.288e+08  # method: V
        Radius     7.305e+04
        AbsMag        -21.18
        Axis    [  0.0832   0.5476  -0.8326]
        Angle    110.0088
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2207"
}

Galaxy "NGC 2208:UGC 3452:MCG 9-11-10:ZWG 260.7"
{
        Type  "S0"
        RA            6.3761
        Dec          51.9100
        Distance   2.563e+08  # method: V
        Radius     5.965e+04
        AbsMag        -20.18
        Axis    [ -0.0396   0.9782  -0.2039]
        Angle     97.1116
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2208"
}

Galaxy "NGC 2211:ESO 556-13:MCG 3-16-21"
{
        Type  "S0"
        RA            6.3083
        Dec         -18.5378
        Distance   1.168e+08  # distance uncertain!
        Radius     2.378e+04
        AbsMag        -19.07
        Axis    [  0.8112   0.5822   0.0543]
        Angle    126.6008
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2211"
}

Galaxy "NGC 2212:ESO 556-14:MCG 3-16-22"
{
        Type  "SBa"
        RA            6.3097
        Dec         -18.5200
        Distance   1.688e+08  # distance uncertain!
        Radius     3.683e+04
        AbsMag        -19.07
        Axis    [  0.0998   0.5961  -0.7967]
        Angle    106.3574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2212"
}

Galaxy "NGC 2216:ESO 556-17:MCG 4-15-27:IRAS 06194-2203"
{
        Type  "SBb"
        RA            6.3583
        Dec         -22.0872
        Distance   1.168e+08  # distance uncertain!
        Radius     2.378e+04
        AbsMag        -19.07
        Axis    [  0.9185   0.3925  -0.0485]
        Angle    130.0598
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2216"
}

Galaxy "NGC 2217:ESO 489-42:MCG 5-15-10:AM 0619-271"
{
        Type  "SBa"
        RA            6.3608
        Dec         -27.2342
        Distance   7.805e+07  # method: V
        Radius     5.336e+04
        AbsMag        -20.29
        Axis    [  0.9555   0.2651  -0.1295]
        Angle    135.9078
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2217"
}

Galaxy "NGC 2221:ESO 121-24:AM 0619-573:IRAS 06194-5733"
{
        Type  "Sa"
        RA            6.3375
        Dec         -57.5786
        Distance   1.145e+08  # method: V
        Radius      3.33e+04
        AbsMag        -18.83
        Axis    [  0.7556   0.6547   0.0236]
        Angle    170.3395
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2221"
}

Galaxy "NGC 2222:ESO 121-25:AM 0619-573"
{
        Type  "SBa"
        RA            6.3378
        Dec         -57.5333
        Distance   1.216e+08  # method: V
        Radius     2.123e+04
        AbsMag        -18.66
        Axis    [  0.1585   0.2732  -0.9488]
        Angle     94.0581
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2222"
}

Galaxy "NGC 2223:ESO 489-49:MCG 4-16-2:UGCA 129"
{
        Type  "SBb"
        RA            6.4097
        Dec         -22.8386
        Distance   1.282e+08  # method: V
        Radius     5.592e+04
        AbsMag        -20.67
        Axis    [ -0.1101   0.3745  -0.9207]
        Angle    142.6597
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2223"
}

Galaxy "NGC 2227:ESO 556-23:MCG 4-16-4:IRAS 06238-2158"
{
        Type  "SBc"
        RA            6.4325
        Dec         -22.0047
        Distance   1.072e+08  # method: T-F
        Radius     3.274e+04
        AbsMag        -19.28
        Axis    [  0.8535   0.5204   0.0263]
        Angle    129.7205
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2227"
}

Galaxy "NGC 2228:ESO 87-7:FAIR 249:DRCG 50-89"
{
        Type  "S0"
        RA            6.3542
        Dec         -64.4592
        Distance   3.323e+08  # method: V
        Radius     3.867e+04
        AbsMag        -20.44
        Axis    [  0.9644   0.2621  -0.0354]
        Angle    176.6279
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2228"
}

Galaxy "NGC 2229:ESO 87-8:AM 0621-645:DRCG 50-55"
{
        Type  "SBa"
        RA            6.3564
        Dec         -64.9567
        Distance   1.612e+08  # distance uncertain!
        Radius     3.517e+04
        AbsMag        -19.07
        Axis    [  0.3443   0.3115  -0.8857]
        Angle    101.4137
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2229"
}

Galaxy "NGC 2230:ESO 87-9:AM 0621-645:DRCG 50-42"
{
        Type  "S0"
        RA            6.3575
        Dec         -64.9928
        Distance   1.404e+08  # distance uncertain!
        Radius     2.451e+04
        AbsMag        -19.07
        Axis    [  0.7268   0.2971  -0.6192]
        Angle    148.1911
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2230"
}

Galaxy "NGC 2233:ESO 87-11:AM 0621-645:DRCG 50-41"
{
        Type  "S0"
        RA            6.3611
        Dec         -65.0333
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [  0.7069   0.6548  -0.2675]
        Angle    148.4341
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2233"
}

Galaxy "NGC 2235:ESO 87-13:AM 0621-645:DRCG 50-52"
{
        Type  "E2"
        RA            6.3728
        Dec         -64.9347
        Distance   2.188e+08  # distance uncertain!
        Radius     4.455e+04
        AbsMag        -20.13
        Axis    [  0.8033  -0.0087  -0.5955]
        Angle    177.3696
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2235"
}

Galaxy "NGC 2255:ESO 365-31:MCG 6-15-10:IRAS 06321-3446"
{
        Type  "SBc"
        RA            6.5661
        Dec         -34.8117
        Distance   3.004e+08  # method: T-F
        Radius     6.554e+04
        AbsMag        -20.62
        Axis    [  0.0076   0.3925  -0.9197]
        Angle    103.7222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2255"
}

Galaxy "NGC 2256:UGC 3519:MCG 12-7-15:ZWG 330.14"
{
        Type  "S0"
        RA            6.7872
        Dec          74.2369
        Distance   1.115e+08  # distance uncertain!
        Radius     3.731e+04
        AbsMag        -19.07
        Axis    [  0.2363   0.9670   0.0949]
        Angle     65.9889
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2256"
}

Galaxy "NGC 2258:UGC 3523:MCG 12-7-16:ZWG 330.15"
{
        Type  "S0"
        RA            6.7961
        Dec          74.4814
        Distance   8.461e+07  # distance uncertain!
        Radius     2.831e+04
        AbsMag        -19.07
        Axis    [ -0.3516   0.9249  -0.1448]
        Angle    126.5403
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2258"
}

Galaxy "NGC 2263:ESO 490-19:MCG 4-16-14:IRAS 06364-2448"
{
        Type  "SBb"
        RA            6.6411
        Dec         -24.8486
        Distance   8.081e+07  # distance uncertain!
        Radius     3.056e+04
        AbsMag        -19.07
        Axis    [  0.1184   0.4408  -0.8898]
        Angle    121.0851
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2263"
}

Galaxy "NGC 2267:ESO 426-29:MCG 5-16-15:AM 0638-322"
{
        Type  "S0"
        RA            6.6808
        Dec         -32.4822
        Distance   9.278e+07  # distance uncertain!
        Radius     2.294e+04
        AbsMag        -19.07
        Axis    [  0.3507   0.4218  -0.8361]
        Angle    119.4572
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2267"
}

Galaxy "NGC 2268:UGC 3653:MCG 14-4-22:ZWG 362.36"
{
        Type  "SBc"
        RA            7.2381
        Dec          84.3822
        Distance    1.43e+08  # method: T-F
        Radius     5.616e+04
        AbsMag        -21.01
        Axis    [  0.0152   0.7616   0.6479]
        Angle     68.1605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2268"
}

Galaxy "NGC 2271:ESO 490-34:MCG 4-16-17"
{
        Type  "S0"
        RA            6.7144
        Dec         -23.4758
        Distance   1.036e+08  # method: S
        Radius     3.165e+04
        AbsMag        -19.51
        Axis    [  0.6916   0.5552  -0.4620]
        Angle    111.4665
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2271"
}

Galaxy "NGC 2272:ESO 490-33:MCG 5-16-17"
{
        Type  "S0"
        RA            6.7114
        Dec         -27.4597
        Distance   7.717e+07  # distance uncertain!
        Radius     2.694e+04
        AbsMag        -19.07
        Axis    [  0.2824   0.4962  -0.8210]
        Angle    110.2515
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2272"
}

Galaxy "NGC 2273:UGC 3546:MCG 10-10-15:MK 620"
{
        Type  "SBa"
        RA            6.8356
        Dec          60.8458
        Distance   8.503e+07  # method: V
        Radius     4.452e+04
        AbsMag        -19.58
        Axis    [  0.3621   0.7956   0.4857]
        Angle     67.3044
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2273"
}

Galaxy "NGC 2273A:UGC 3504:MCG 10-10-9:ZWG 285.3"
{
        Type  "Sc"
        RA            6.6686
        Dec          60.0806
        Distance   9.672e+07  # method: V
        Radius     3.798e+04
        AbsMag        -19.06
        Axis    [ -0.1282   0.9467  -0.2955]
        Angle    115.1401
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2273A"
}

Galaxy "NGC 2273B:UGC 3530:MCG 10-10-13:ZWG 285.5"
{
        Type  "SBc"
        RA            6.7753
        Dec          60.3403
        Distance   1.158e+08  # method: T-F
        Radius     4.547e+04
        AbsMag        -19.55
        Axis    [  0.3520   0.7204   0.5976]
        Angle     72.2298
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2273B"
}

Galaxy "NGC 2274:UGC 3541:MCG 6-15-8:ZWG 175.15"
{
        Type  "E0"
        RA            6.7881
        Dec          33.5675
        Distance   2.338e+08  # method: V
        Radius      4.08e+04
        AbsMag        -20.88
        Axis    [  0.0326   0.7610  -0.6480]
        Angle    160.2638
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2274"
}

Galaxy "NGC 2275:UGC 3542:MCG 6-15-7:ZWG 175.16"
{
        Type  "Sb"
        RA            6.7881
        Dec          33.5992
        Distance   2.243e+08  # method: V
        Radius     4.242e+04
        AbsMag        -20.09
        Axis    [ -0.2540   0.8057  -0.5350]
        Angle    120.7790
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2275"
}

Galaxy "NGC 2276:UGC 3740:MCG 14-4-28:ZWG 362.42"
{
        Type  "SBc"
        RA            7.4536
        Dec          85.7550
        Distance   1.085e+08  # method: V
        Radius     3.628e+04
        AbsMag        -20.61
        Axis    [  0.5908   0.1549   0.7918]
        Angle     45.7702
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2276"
}

Galaxy "NGC 2280:ESO 427-2:MCG 5-16-20:UGCA 131"
{
        Type  "Sc"
        RA            6.7467
        Dec         -27.6389
        Distance   8.168e+07  # method: T-F
        Radius     7.484e+04
        AbsMag        -20.79
        Axis    [ -0.1498   0.3833  -0.9114]
        Angle    104.4393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2280"
}

Galaxy "NGC 2283:ESO 557-13:MCG 3-18-2:IRAS 06436-1809"
{
        Type  "SBc"
        RA            6.7644
        Dec         -18.2103
        Distance   4.353e+07  # method: V
        Radius     2.279e+04
        AbsMag        -17.73
        Axis    [  0.9444   0.3164   0.0890]
        Angle    131.7032
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2283"
}

Galaxy "NGC 2288:MCG 6-15-11:ZWG 175.17"
{
        Type  "E0"
        RA            6.8478
        Dec          33.4622
        Distance   4.169e+08  # distance uncertain!
        Radius     2.425e+04
        AbsMag        -20.13
        Axis    [  0.5215   0.5997  -0.6069]
        Angle    106.0941
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2288"
}

Galaxy "NGC 2289:UGC 3560:MCG 6-15-10:ZWG 175.18"
{
        Type  "S0"
        RA            6.8481
        Dec          33.4792
        Distance   1.688e+08  # distance uncertain!
        Radius     2.701e+04
        AbsMag        -19.07
        Axis    [  0.1833   0.9701  -0.1589]
        Angle     79.8953
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2289"
}

Galaxy "NGC 2290:UGC 3562:MCG 6-15-12:ZWG 175.19"
{
        Type  "Sa"
        RA            6.8489
        Dec          33.4381
        Distance   2.329e+08  # method: V
        Radius     4.065e+04
        AbsMag        -20.07
        Axis    [  0.6177   0.7689   0.1651]
        Angle     76.2464
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2290"
}

Galaxy "NGC 2291:ZWG 175.20:MCG 6-15-13:NPM 1"
{
        Type  "S0"
        RA            6.8494
        Dec          33.5256
        Distance    1.47e+08  # distance uncertain!
        Radius     2.139e+04
        AbsMag        -19.07
        Axis    [  0.0326   0.8660  -0.4990]
        Angle    103.9383
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2291"
}

Galaxy "NGC 2292:ESO 490-48:MCG 4-16-22:VV 178"
{
        Type  "S0"
        RA            6.7942
        Dec         -26.7464
        Distance   1.075e+08  # method: T-F
        Radius     6.253e+04
        AbsMag        -20.79
        Axis    [  0.3176   0.4036  -0.8580]
        Angle    125.9054
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2292"
}

Galaxy "NGC 2293:ESO 490-49:MCG 4-16-23:VV 178"
{
        Type  "SBa"
        RA            6.7950
        Dec         -26.7547
        Distance   5.565e+07  # method: S
        Radius     3.237e+04
        AbsMag        -19.06
        Axis    [  0.2887   0.4382  -0.8513]
        Angle    119.0889
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2293"
}

Galaxy "NGC 2294:MCG 6-15-14:ZWG 175.21:IRAS 06478+3335"
{
        Type  "E6"
        RA            6.8531
        Dec          33.5269
        Distance   3.312e+08  # distance uncertain!
        Radius     3.853e+04
        AbsMag        -20.13
        Axis    [  0.9894  -0.1040  -0.1012]
        Angle     79.9528
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2294"
}

Galaxy "NGC 2295:ESO 490-47:MCG 4-16-21:VV 178"
{
        Type  "Sb"
        RA            6.7897
        Dec         -26.7361
        Distance   1.115e+08  # distance uncertain!
        Radius     3.407e+04
        AbsMag        -19.07
        Axis    [  0.6997   0.7024  -0.1307]
        Angle    114.5891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2295"
}

Galaxy "NGC 2297:ESO 87-40:FAIR 256:IRAS 06440-6339"
{
        Type  "SBc"
        RA            6.7400
        Dec         -63.7175
        Distance    1.58e+08  # method: V
        Radius     4.365e+04
        AbsMag        -20.02
        Axis    [  0.5636   0.2074  -0.7996]
        Angle    140.5252
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2297"
}

Galaxy "NGC 2300:UGC 3798:MCG 14-4-31:ZWG 362.43"
{
        Type  "S0"
        RA            7.5389
        Dec          85.7092
        Distance     1.4e+08  # method: T-F
        Radius     5.702e+04
        AbsMag        -21.06
        Axis    [  0.0040   0.8949   0.4462]
        Angle     66.3284
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2300"
}

Galaxy "NGC 2303:UGC 3603:MCG 8-13-31:ZWG 234.30"
{
        Type  "E0"
        RA            6.9381
        Dec          45.4933
        Distance    2.87e+08  # method: V
        Radius     6.261e+04
        AbsMag        -20.82
        Axis    [  0.9765  -0.2120  -0.0394]
        Angle     69.2160
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2303"
}

Galaxy "NGC 2305:ESO 87-44:AM 0648-641"
{
        Type  "E2"
        RA            6.8103
        Dec         -64.2728
        Distance   1.289e+08  # method: T-F
        Radius     3.939e+04
        AbsMag        -20.18
        Axis    [  0.2329   0.0044  -0.9725]
        Angle    174.4853
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2305"
}

Galaxy "NGC 2307:ESO 87-45:AM 0648-641:IRAS 06485-6416"
{
        Type  "SBb"
        RA            6.8142
        Dec         -64.3350
        Distance   2.107e+08  # method: V
        Radius      5.21e+04
        AbsMag        -20.95
        Axis    [  0.2077   0.0480  -0.9770]
        Angle    151.8407
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2307"
}

Galaxy "NGC 2308:UGC 3618:MCG 8-13-37:ZWG 234.37"
{
        Type  "Sb"
        RA            6.9769
        Dec          45.2111
        Distance   2.689e+08  # method: V
        Radius     7.039e+04
        AbsMag        -20.38
        Axis    [ -0.3693   0.8106  -0.4544]
        Angle    130.0444
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2308"
}

Galaxy "NGC 2310:ESO 309-7:MCG 7-15-1:AM 0652-405"
{
        Type  "S0"
        RA            6.8981
        Dec         -40.8636
        Distance   5.989e+07  # method: V
        Radius     3.745e+04
        AbsMag        -18.62
        Axis    [  0.6730   0.7128  -0.1977]
        Angle    120.3857
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2310"
}

Galaxy "NGC 2314:UGC 3677:MCG 13-6-3:ZWG 348.32"
{
        Type  "E3"
        RA            7.1753
        Dec          75.3278
        Distance   2.186e+08  # method: T-F
        Radius     3.498e+04
        AbsMag        -20.93
        Axis    [  0.9705   0.1620  -0.1785]
        Angle     38.1936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2314"
}

Galaxy "NGC 2315:UGC 3633:MCG 8-13-45:ZWG 234.41"
{
        Type  "Sa"
        RA            7.0425
        Dec          50.5908
        Distance   2.823e+08  # method: V
        Radius     5.337e+04
        AbsMag        -20.19
        Axis    [ -0.3631   0.9281   0.0822]
        Angle     88.4439
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2315"
}

Galaxy "NGC 2320:UGC 3659:MCG 8-13-51:ZWG 234.47"
{
        Type  "E0"
        RA            7.0947
        Dec          50.5808
        Distance   3.008e+08  # method: T-F
        Radius     6.125e+04
        AbsMag        -21.72
        Axis    [  0.1741   0.8219  -0.5424]
        Angle    130.1106
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2320"
}

Galaxy "NGC 2321:UGC 3663:MCG 8-13-53:ZWG 234.51"
{
        Type  "SBa"
        RA            7.0994
        Dec          50.7567
        Distance   1.938e+08  # distance uncertain!
        Radius     3.947e+04
        AbsMag        -19.07
        Axis    [ -0.1178   0.9261  -0.3585]
        Angle    106.5438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2321"
}

Galaxy "NGC 2322:UGC 3662:MCG 8-13-54:ZWG 234.50"
{
        Type  "SBa"
        RA            7.1000
        Dec          50.5106
        Distance   1.768e+08  # distance uncertain!
        Radius     2.828e+04
        AbsMag        -19.07
        Axis    [ -0.4019   0.9034  -0.1497]
        Angle     98.6948
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2322"
}

Galaxy "NGC 2325:ESO 427-28:MCG 5-17-5"
{
        Type  "E4"
        RA            7.0444
        Dec         -28.6978
        Distance   8.345e+07  # method: S
        Radius     3.641e+04
        AbsMag        -20.04
        Axis    [  0.9842  -0.0792  -0.1582]
        Angle    141.9748
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2325"
}

Galaxy "NGC 2326:UGC 3681:MCG 8-13-62:ZWG 234.60"
{
        Type  "SBb"
        RA            7.1361
        Dec          50.6822
        Distance   2.746e+08  # method: V
        Radius     7.589e+04
        AbsMag        -20.63
        Axis    [  0.1403   0.8872  -0.4395]
        Angle    102.4276
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2326"
}

Galaxy "NGC 2326A:UGC 3687:MCG 8-13-67:ZWG 234.66"
{
        Type  "Irr"
        RA            7.1428
        Dec          50.6317
        Distance   3.981e+08  # distance uncertain!
        Radius     5.791e+04
        AbsMag        -20.13
        Axis    [  0.7575   0.3500   0.5511]
        Angle     75.2527
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2326A"
}

Galaxy "NGC 2328:ESO 309-16:MCG 7-15-2:IRAS 07010-4159"
{
        Type  "S0"
        RA            7.0433
        Dec         -42.0681
        Distance   5.894e+07  # method: V
        Radius     1.114e+04
        AbsMag        -18.48
        Axis    [  0.3811   0.3915  -0.8375]
        Angle    110.0213
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2328"
}

Galaxy "NGC 2329:UGC 3695:MCG 8-13-73:ZWG 234.70"
{
        Type  "S0"
        RA            7.1519
        Dec          48.6158
        Distance   3.008e+08  # method: T-F
        Radius     5.687e+04
        AbsMag        -21.32
        Axis    [ -0.2717   0.8365  -0.4758]
        Angle    140.3276
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2329"
}

Galaxy "NGC 2330:IC 457:MCG 8-13-78:ZWG 234.74"
{
        Type  "E0"
        RA            7.1578
        Dec          50.1531
        Distance   5.012e+08  # distance uncertain!
        Radius     2.916e+04
        AbsMag        -20.13
        Axis    [  0.9449   0.1402  -0.2957]
        Angle     63.2336
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2330"
}

Galaxy "NGC 2332:UGC 3699:MCG 8-13-79:ZWG 234.75"
{
        Type  "S0"
        RA            7.1592
        Dec          50.1819
        Distance   2.666e+08  # method: V
        Radius     5.816e+04
        AbsMag        -20.76
        Axis    [  0.4919   0.8478   0.1984]
        Angle     64.9348
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2332"
}

Galaxy "NGC 2333:UGC 3689:MCG 6-16-20:ZWG 176.18"
{
        Type  "Sa"
        RA            7.1392
        Dec          35.1700
        Distance   2.194e+08  # method: V
        Radius     3.192e+04
        AbsMag        -19.94
        Axis    [  0.8114   0.5489   0.2008]
        Angle     74.1719
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2333"
}

Galaxy "NGC 2334:IC 465:MCG 8-13-98:ZWG 234.95"
{
        Type  "E0"
        RA            7.1925
        Dec          50.2489
        Distance   2.877e+08  # method: V
        Radius     3.766e+04
        AbsMag        -20.03
        Axis    [  0.5716   0.6325  -0.5227]
        Angle     83.9424
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2334"
}

Galaxy "NGC 2336:UGC 3809:MCG 13-6-6:ZWG 348.34"
{
        Type  "SBc"
        RA            7.4508
        Dec          80.1778
        Distance   1.292e+08  # method: T-F
        Radius     1.334e+05
        AbsMag        -21.89
        Axis    [ -0.4812   0.8647  -0.1444]
        Angle    142.8329
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2336"
}

Galaxy "NGC 2336A:UGC 4066:MCG 13-6-12:ZWG 349.11"
{
        Type  "Sc"
        RA            7.9375
        Dec          78.0131
        Distance   1.046e+08  # method: V
        Radius     2.587e+04
        AbsMag        -18.13
        Axis    [  0.7732  -0.6214   0.1263]
        Angle     45.8110
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2336A"
}

Galaxy "NGC 2337:UGC 3711:MCG 7-15-10:ZWG 205.23"
{
        Type  "Irr"
        RA            7.1703
        Dec          44.4569
        Distance   2.396e+07  # method: V
        Radius          7319
        AbsMag        -16.33
        Axis    [ -0.0714   0.9527  -0.2953]
        Angle     90.7466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2337"
}

Galaxy "NGC 2339:UGC 3693:MCG 3-19-2:ZWG 85.40"
{
        Type  "SBc"
        RA            7.1389
        Dec          18.7794
        Distance   1.066e+08  # method: V
        Radius     4.186e+04
        AbsMag        -20.07
        Axis    [ -0.3192   0.6665  -0.6737]
        Angle    128.0250
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2339"
}

Galaxy "NGC 2340:UGC 3720:MCG 8-13-96:ZWG 234.91"
{
        Type  "E0"
        RA            7.1861
        Dec          50.1747
        Distance   3.008e+08  # method: T-F
        Radius     7.875e+04
        AbsMag        -21.92
        Axis    [  0.5398   0.6546  -0.5292]
        Angle     86.6384
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2340"
}

Galaxy "NGC 2341:UGC 3708:MCG 3-19-3:ZWG 86.6"
{
        Type  "Sc"
        RA            7.1533
        Dec          20.6033
        Distance   2.433e+08  # method: V
        Radius     2.831e+04
        AbsMag        -20.46
        Axis    [  0.9849  -0.1638  -0.0559]
        Angle     93.8658
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2341"
}

Galaxy "NGC 2342:UGC 3709:MCG 3-19-4:ZWG 86.7"
{
        Type  "Sc"
        RA            7.1550
        Dec          20.6369
        Distance   2.454e+08  # method: V
        Radius     4.996e+04
        AbsMag        -21.18
        Axis    [  0.1786   0.7179  -0.6728]
        Angle    110.7924
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2342"
}

Galaxy "NGC 2344:UGC 3734:MCG 8-13-103:ZWG 234.100"
{
        Type  "SBc"
        RA            7.2078
        Dec          47.1672
        Distance   4.815e+07  # method: V
        Radius     1.051e+04
        AbsMag        -18.05
        Axis    [ -0.2630   0.8486  -0.4590]
        Angle    128.6838
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2344"
}

Galaxy "NGC 2347:UGC 3759:MCG 11-9-39:ZWG 309.26"
{
        Type  "Sb"
        RA            7.2678
        Dec          64.7114
        Distance   2.023e+08  # method: V
        Radius     5.295e+04
        AbsMag        -20.76
        Axis    [  0.7689   0.0774   0.6346]
        Angle     67.2511
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2347"
}

Galaxy "NGC 2350:UGC 3747:MCG 2-19-1:ZWG 57.5"
{
        Type  "Sa"
        RA            7.2200
        Dec          12.2664
        Distance   9.232e+07  # method: V
        Radius      1.88e+04
        AbsMag        -18.26
        Axis    [  0.1322   0.8727  -0.4700]
        Angle     81.1833
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2350"
}

Galaxy "NGC 2357:UGC 3782:MCG 4-17-14:ZWG 116.46"
{
        Type  "Sc"
        RA            7.2944
        Dec          23.3564
        Distance   1.297e+08  # method: T-F
        Radius     6.793e+04
        AbsMag         -18.6
        Axis    [ -0.2865   0.9390  -0.1900]
        Angle     75.9335
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2357"
}

Galaxy "NGC 2363:UGC 3847:MCG 12-7-39:KCPG 133A"
{
        Type  "Irr"
        RA            7.4747
        Dec          69.1928
        Distance   4.366e+08  # distance uncertain!
        Radius     1.016e+05
        AbsMag        -20.13
        Axis    [  0.6368   0.2710   0.7218]
        Angle     63.8675
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2363"
}

Galaxy "NGC 2365:UGC 3821:MCG 4-18-8:ZWG 117.20"
{
        Type  "SBa"
        RA            7.3728
        Dec          22.0833
        Distance   1.104e+08  # method: V
        Radius     4.494e+04
        AbsMag        -19.05
        Axis    [ -0.4453   0.6837  -0.5782]
        Angle    110.5082
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2365"
}

Galaxy "NGC 2366:UGC 3851:MCG 12-7-40:DDO 42"
{
        Type  "Irr"
        RA            7.4817
        Dec          69.2161
        Distance   1.672e+07  # method: T-F
        Radius     1.969e+04
        AbsMag        -17.05
        Axis    [  0.4569   0.3647   0.8113]
        Angle     76.4383
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2366"
}

Galaxy "NGC 2369:ESO 122-18:AM 0716-621:IRAS 07160-6215"
{
        Type  "SBa"
        RA            7.2769
        Dec         -62.3439
        Distance   1.536e+08  # method: V
        Radius     7.818e+04
        AbsMag        -20.16
        Axis    [ -0.1614  -0.0714  -0.9843]
        Angle     93.8256
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2369"
}

Galaxy "NGC 2369A:ESO 88-8:AM 0718-625:IRAS 07182-6250"
{
        Type  "SBc"
        RA            7.3119
        Dec         -62.9367
        Distance   1.586e+08  # method: T-F
        Radius     4.152e+04
        AbsMag        -19.73
        Axis    [  0.8584   0.3535  -0.3717]
        Angle    152.8518
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2369A"
}

Galaxy "NGC 2369B:ESO 123-5:IRAS 07199-6157"
{
        Type  "SBc"
        RA            7.3414
        Dec         -62.0539
        Distance   1.341e+08  # distance uncertain!
        Radius     2.926e+04
        AbsMag        -19.07
        Axis    [  0.9558   0.1350  -0.2612]
        Angle    167.9283
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2369B"
}

Galaxy "NGC 2370:UGC 3835:MCG 4-18-15:ZWG 117.36"
{
        Type  "SBc"
        RA            7.4169
        Dec          23.7836
        Distance   2.563e+08  # method: V
        Radius     2.982e+04
        AbsMag        -20.08
        Axis    [  0.7991   0.5953   0.0847]
        Angle     78.0458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2370"
}

Galaxy "NGC 2373:UGC 3848:MCG 6-17-4:ZWG 177.14"
{
        Type  "Sc"
        RA            7.4433
        Dec          33.8242
        Distance   3.588e+08  # method: V
        Radius     3.131e+04
        AbsMag        -20.41
        Axis    [ -0.1936   0.7983  -0.5703]
        Angle    120.1117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2373"
}

Galaxy "NGC 2375:UGC 3854:MCG 6-17-5:ZWG 177.17"
{
        Type  "SBb"
        RA            7.4525
        Dec          33.8325
        Distance   3.623e+08  # method: V
        Radius     6.851e+04
        AbsMag        -20.63
        Axis    [ -0.3072   0.7714  -0.5573]
        Angle    124.7732
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2375"
}

Galaxy "NGC 2376:MCG 4-18-17:ZWG 117.39:IRAS 07235+2310"
{
        Type  "Sc"
        RA            7.4431
        Dec          23.0733
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [  0.9736  -0.2168  -0.0714]
        Angle     92.1222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2376"
}

Galaxy "NGC 2377:UGCA 132:C 178:IRAS 07225-0933"
{
        Type  "Sc"
        RA            7.4156
        Dec          -9.6606
        Distance     1.2e+08  # method: V
        Radius     2.966e+04
        AbsMag        -19.33
        Axis    [ -0.2372   0.4688  -0.8508]
        Angle    120.1682
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2377"
}

Galaxy "NGC 2379:UGC 3857:MCG 6-17-6:ZWG 177.18"
{
        Type  "S0"
        RA            7.4572
        Dec          33.8119
        Distance   1.889e+08  # method: V
        Radius     2.472e+04
        AbsMag        -19.31
        Axis    [  0.0859   0.8232  -0.5612]
        Angle    100.8007
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2379"
}

Galaxy "NGC 2380:NGC 2382:ESO 492-12:MCG 5-18-5"
{
        Type  "S0"
        RA            7.3983
        Dec         -27.5286
        Distance   8.384e+07  # method: S
        Radius     2.561e+04
        AbsMag        -19.75
        Axis    [ -0.0979   0.3194  -0.9426]
        Angle    141.8771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2380"
}

Galaxy "NGC 2381:ESO 88-10:FAIR 266:AM 0719-625"
{
        Type  "SBa"
        RA            7.3325
        Dec         -63.0669
        Distance   1.438e+08  # method: V
        Radius     2.929e+04
        AbsMag        -19.82
        Axis    [  0.9865  -0.0481  -0.1563]
        Angle    176.0891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2381"
}

Galaxy "NGC 2385:MCG 6-17-8:ZWG 177.20"
{
        Type  "S0"
        RA            7.4744
        Dec          33.8381
        Distance    2.33e+08  # distance uncertain!
        Radius      3.39e+04
        AbsMag        -19.07
        Axis    [  0.7272   0.6859   0.0277]
        Angle     68.7176
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2385"
}

Galaxy "NGC 2387:ZWG 177.23"
{
        Type  "S0"
        RA            7.4825
        Dec          36.8797
        Distance    2.44e+08  # distance uncertain!
        Radius      2.13e+04
        AbsMag        -19.07
        Axis    [  0.8907   0.4537   0.0285]
        Angle     68.4812
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2387"
}

Galaxy "NGC 2388:UGC 3870:MCG 6-17-10:ZWG 177.22"
{
        Type  "S0"
        RA            7.4814
        Dec          33.8189
        Distance   1.936e+08  # method: V
        Radius     2.816e+04
        AbsMag        -19.17
        Axis    [  0.5687   0.8218   0.0342]
        Angle     68.0471
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2388"
}

Galaxy "NGC 2389:UGC 3872:MCG 6-17-11:ZWG 177.24"
{
        Type  "SBc"
        RA            7.4844
        Dec          33.8608
        Distance   1.856e+08  # method: V
        Radius     5.399e+04
        AbsMag        -20.38
        Axis    [  0.4185   0.8821  -0.2161]
        Angle     70.6562
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2389"
}

Galaxy "NGC 2393:UGC 3884:MCG 6-17-14:ZWG 177.27"
{
        Type  "Sc"
        RA            7.5011
        Dec          34.0278
        Distance   2.278e+08  # method: V
        Radius     3.975e+04
        AbsMag        -19.52
        Axis    [  0.1641   0.9335  -0.3187]
        Angle     76.5966
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2393"
}

Galaxy "NGC 2397:ESO 58-30:IRAS 07214-6854"
{
        Type  "Sb"
        RA            7.3553
        Dec         -69.0014
        Distance   8.825e+07  # method: T-F
        Radius     3.209e+04
        AbsMag        -19.46
        Axis    [  0.3616   0.1649  -0.9176]
        Angle    112.1698
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2397"
}

Galaxy "NGC 2397A:ESO 58-29:AM 0721-685:IRAS 07212-6901"
{
        Type  "Sc"
        RA            7.3519
        Dec         -69.1153
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [  0.8685   0.2319  -0.4382]
        Angle    162.4344
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2397A"
}

Galaxy "NGC 2397B:ESO 58-31:AM 0722-684"
{
        Type  "Irr"
        RA            7.3653
        Dec         -68.8458
        Distance   3.468e+08  # distance uncertain!
        Radius     4.539e+04
        AbsMag        -20.13
        Axis    [  0.5476   0.2452  -0.8000]
        Angle    124.9655
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2397B"
}

Galaxy "NGC 2398-1:MCG 4-18-23:ZWG 117.48"
{
        Type  "S0"
        RA            7.5044
        Dec          24.4881
        Distance    2.44e+08  # distance uncertain!
        Radius      1.42e+04
        AbsMag        -19.07
        Axis    [ -0.1757   0.7730  -0.6096]
        Angle    107.2318
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2398-1"
}

Galaxy "NGC 2398-2:MCG 4-18-22:ZWG 117.46"
{
        Type  "E0"
        RA            7.5036
        Dec          24.4914
        Distance   4.366e+08  # distance uncertain!
        Radius     3.175e+04
        AbsMag        -20.13
        Axis    [  0.9618  -0.2555  -0.0983]
        Angle     91.1793
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2398-2"
}

Galaxy "NGC 2402-1:UGC 3891:MCG 2-19-4:ZWG 57.15"
{
        Type  "E0"
        RA            7.5128
        Dec           9.6475
        Distance   3.631e+08  # distance uncertain!
        Radius     4.225e+04
        AbsMag        -20.13
        Axis    [  0.9690  -0.2172  -0.1177]
        Angle    105.5376
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2402-1"
}

Galaxy "NGC 2402-2:UGC 3891:MCG 2-19-4:ZWG 57.15"
{
        Type  "S0"
        RA            7.5131
        Dec           9.6539
        Distance   3.369e+08  # distance uncertain!
        Radius      3.43e+04
        AbsMag        -19.07
        Axis    [  0.4174   0.7335  -0.5365]
        Angle     83.0110
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2402-2"
}

Galaxy "NGC 2403:UGC 3918:MCG 11-10-7:ZWG 309.40"
{
        Type  "SBc"
        RA            7.6139
        Dec          65.6017
        Distance   1.413e+07  # method: T-F
        Radius      4.81e+04
        AbsMag        -19.28
        Axis    [ -0.3166   0.9483   0.0193]
        Angle     93.4210
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2403"
}

Galaxy "NGC 2405-1:MCG 4-18-26:ZWG 117.51:VV 643"
{
        Type  "S0"
        RA            7.5369
        Dec          25.9061
        Distance    2.03e+08  # distance uncertain!
        Radius     1.476e+04
        AbsMag        -19.07
        Axis    [  0.1576   0.9155  -0.3701]
        Angle     76.1090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2405-1"
}

Galaxy "NGC 2405-2:MCG 4-18-26:ZWG 117.51:VV 643"
{
        Type  "E0"
        RA            7.5375
        Dec          25.9058
        Distance   4.366e+08  # distance uncertain!
        Radius     1.905e+04
        AbsMag        -20.13
        Axis    [  0.9592  -0.2653  -0.0983]
        Angle     89.9223
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2405-2"
}

Galaxy "NGC 2406:MCG 3-19-21:ZWG 86.41:ZWG 87.2"
{
        Type  "E0"
        RA            7.5297
        Dec          18.2886
        Distance   3.802e+08  # distance uncertain!
        Radius     3.871e+04
        AbsMag        -20.13
        Axis    [  0.8374   0.1637  -0.5215]
        Angle     95.1103
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2406"
}

Galaxy "NGC 2407:UGC 3896:MCG 3-20-1:ZWG 86.42"
{
        Type  "S0"
        RA            7.5322
        Dec          18.3336
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [  0.9126   0.3326  -0.2378]
        Angle     83.9149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2407"
}

Galaxy "NGC 2410:UGC 3917:MCG 5-18-23:ZWG 147.43"
{
        Type  "SBb"
        RA            7.5839
        Dec          32.8225
        Distance   2.187e+08  # method: V
        Radius     7.633e+04
        AbsMag        -20.33
        Axis    [  0.6602   0.5773   0.4805]
        Angle     85.2909
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2410"
}

Galaxy "NGC 2411:UGC 3914:MCG 3-20-5:ZWG 87.13"
{
        Type  "E0"
        RA            7.5767
        Dec          18.2819
        Distance   2.884e+08  # distance uncertain!
        Radius     3.776e+04
        AbsMag        -20.13
        Axis    [  0.8421   0.1489  -0.5184]
        Angle     94.7136
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2411"
}

Galaxy "NGC 2415:UGC 3930:MCG 6-17-21:ZWG 177.38"
{
        Type  "Irr"
        RA            7.6156
        Dec          35.2419
        Distance    1.78e+08  # method: V
        Radius      2.33e+04
        AbsMag        -20.89
        Axis    [  0.9565  -0.2860  -0.0566]
        Angle     81.0725
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2415"
}

Galaxy "NGC 2416:UGC 3925:MCG 2-20-2:ZWG 58.8"
{
        Type  "Sc"
        RA            7.5947
        Dec          11.6125
        Distance   2.397e+08  # method: V
        Radius     3.487e+04
        AbsMag        -20.03
        Axis    [  0.2325   0.7658  -0.5995]
        Angle     84.1167
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2416"
}

Galaxy "NGC 2417:ESO 123-15:AM 0729-620:IRAS 07295-6208"
{
        Type  "Sc"
        RA            7.5033
        Dec         -62.2525
        Distance   1.529e+08  # method: T-F
        Radius     6.226e+04
        AbsMag        -20.45
        Axis    [  0.6418   0.2609  -0.7211]
        Angle    131.6187
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2417"
}

Galaxy "NGC 2418:UGC 3931:MCG 3-20-8:ZWG 87.17"
{
        Type  "E0"
        RA            7.6103
        Dec          17.8839
        Distance   2.374e+08  # method: V
        Radius     6.215e+04
        AbsMag        -20.91
        Axis    [  0.9607  -0.2529  -0.1144]
        Angle     97.8365
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2418"
}

Galaxy "NGC 2424:UGC 3959:MCG 7-16-9:ZWG 206.15"
{
        Type  "SBb"
        RA            7.6775
        Dec          39.2333
        Distance   1.476e+08  # method: V
        Radius     7.728e+04
        AbsMag        -19.68
        Axis    [  0.0848   0.9233   0.3746]
        Angle     71.0658
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2424"
}

Galaxy "NGC 2426:UGC 3977:MCG 9-13-38:ZWG 262.22"
{
        Type  "E0"
        RA            7.7217
        Dec          52.3181
        Distance   2.699e+08  # method: V
        Radius     4.319e+04
        AbsMag        -20.39
        Axis    [  0.9116  -0.4079  -0.0510]
        Angle     65.8639
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2426"
}

Galaxy "NGC 2427:ESO 208-27:IRAS 07350-4731"
{
        Type  "Irr"
        RA            7.6075
        Dec         -47.6358
        Distance   4.358e+07  # method: T-F
        Radius     3.106e+04
        AbsMag        -18.43
        Axis    [  0.2818   0.3491  -0.8937]
        Angle     93.1247
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2427"
}

Galaxy "NGC 2429:NGC 2429A:UGC 3983:MCG 9-13-39"
{
        Type  "Sc"
        RA            7.7297
        Dec          52.3575
        Distance   2.515e+08  # method: V
        Radius     5.487e+04
        AbsMag        -19.84
        Axis    [ -0.5261   0.8473  -0.0726]
        Angle     96.4155
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2429"
}

Galaxy "NGC 2429B:MCG 9-13-40:VV 284:KCPG 138A"
{
        Type  "S0"
        RA            7.7308
        Dec          52.3481
        Distance   6.721e+08  # distance uncertain!
        Radius     2.933e+04
        AbsMag        -19.07
        Axis    [  0.3551   0.7433   0.5670]
        Angle     69.3984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2429B"
}

Galaxy "NGC 2431:NGC 2436:UGC 3999:MCG 9-13-42"
{
        Type  "SBa"
        RA            7.7536
        Dec          53.0756
        Distance   2.618e+08  # method: V
        Radius     3.427e+04
        AbsMag        -20.12
        Axis    [  0.9186  -0.3952  -0.0087]
        Angle     65.2600
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2431"
}

Galaxy "NGC 2434:ESO 59-5"
{
        Type  "E0"
        RA            7.5808
        Dec         -69.2844
        Distance   7.038e+07  # method: S
        Radius     2.457e+04
        AbsMag        -19.37
        Axis    [  0.2159  -0.0522  -0.9750]
        Angle    172.9432
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2434"
}

Galaxy "NGC 2435:UGC 3996:MCG 5-19-2:ZWG 147.62"
{
        Type  "Sa"
        RA            7.7369
        Dec          31.6506
        Distance   1.971e+08  # method: V
        Radius     6.308e+04
        AbsMag        -20.31
        Axis    [  0.6070   0.6197   0.4975]
        Angle     85.0199
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2435"
}

Galaxy "NGC 2441:UGC 4036:MCG 12-8-15:ZWG 331.17"
{
        Type  "SBb"
        RA            7.8650
        Dec          73.0153
        Distance    1.59e+08  # method: V
        Radius     4.625e+04
        AbsMag        -20.54
        Axis    [  0.7548   0.5572   0.3462]
        Angle     42.3693
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2441"
}

Galaxy "NGC 2442:NGC 2443:ESO 59-8:AM 0736-692"
{
        Type  "SBc"
        RA            7.6053
        Dec         -69.5247
        Distance    7.04e+07  # method: V
        Radius     6.143e+04
        AbsMag        -20.47
        Axis    [  0.8913   0.2142  -0.3997]
        Angle    165.3793
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2442"
}

Galaxy "NGC 2444:UGC 4016:MCG 7-16-16:ZWG 206.24"
{
        Type  "S0"
        RA            7.7814
        Dec          39.0325
        Distance   1.892e+08  # method: V
        Radius     4.403e+04
        AbsMag        -19.92
        Axis    [  0.8222   0.4091   0.3958]
        Angle     75.2175
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2444"
}

Galaxy "NGC 2445:UGC 4017:MCG 7-16-17:ZWG 206.24"
{
        Type  "S0"
        RA            7.7819
        Dec          39.0156
        Distance   1.877e+08  # method: V
        Radius     4.641e+04
        AbsMag         -19.9
        Axis    [  0.9406   0.2017   0.2730]
        Angle     74.3490
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2445"
}

Galaxy "NGC 2446:UGC 4027:MCG 9-13-58:ZWG 262.30"
{
        Type  "Sb"
        RA            7.8108
        Dec          54.6117
        Distance   2.613e+08  # method: T-F
        Radius     7.221e+04
        AbsMag        -20.82
        Axis    [ -0.2410   0.9674  -0.0780]
        Angle     84.3512
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2446"
}

Galaxy "NGC 2449:UGC 4026:MCG 5-19-7:ZWG 148.20"
{
        Type  "Sb"
        RA            7.7889
        Dec          26.9306
        Distance   2.246e+08  # method: V
        Radius     4.246e+04
        AbsMag        -19.89
        Axis    [ -0.2725   0.8653  -0.4207]
        Angle     83.4672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2449"
}

Galaxy "NGC 2450:MCG 5-19-8:ZWG 148.22"
{
        Type  "Sc"
        RA            7.7922
        Dec          27.0194
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [ -0.5825   0.7393  -0.3378]
        Angle     87.4920
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2450"
}

Galaxy "NGC 2454:UGC 4053:MCG 3-20-15:ZWG 87.44"
{
        Type  "S0"
        RA            7.8428
        Dec          16.3692
        Distance   1.938e+08  # distance uncertain!
        Radius     2.255e+04
        AbsMag        -19.07
        Axis    [  0.1798   0.9458  -0.2705]
        Angle     66.3013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2454"
}

Galaxy "NGC 2456:UGC 4073:MCG 9-13-82:ZWG 262.44"
{
        Type  "E0"
        RA            7.9028
        Dec          55.4953
        Distance   3.475e+08  # method: V
        Radius     5.559e+04
        AbsMag        -20.94
        Axis    [  0.9509  -0.0373  -0.3071]
        Angle     56.1158
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2456"
}

Galaxy "NGC 2457:MCG 9-13-86:ZWG 262.46:NPM 1"
{
        Type  "Sc"
        RA            7.9125
        Dec          55.5472
        Distance   3.694e+08  # distance uncertain!
        Radius     2.686e+04
        AbsMag        -19.07
        Axis    [  0.0769   0.9265   0.3685]
        Angle     66.2479
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2457"
}

Galaxy "NGC 2458:MCG 10-12-16:ZWG 287.9"
{
        Type  "S0"
        RA            7.9308
        Dec          56.7108
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [ -0.3436   0.8751  -0.3407]
        Angle    123.2574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2458"
}

Galaxy "NGC 2460:UGC 4097:MCG 10-12-21:ZWG 287.10"
{
        Type  "Sb"
        RA            7.9478
        Dec          60.3494
        Distance    6.94e+07  # method: V
        Radius     2.523e+04
        AbsMag        -18.94
        Axis    [  0.7772   0.4613   0.4279]
        Angle     53.3963
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2460"
}

Galaxy "NGC 2462:MCG 10-12-24:ZWG 287.9"
{
        Type  "S0"
        RA            7.9419
        Dec          56.6867
        Distance   1.404e+08  # distance uncertain!
        Radius          8170
        AbsMag        -19.07
        Axis    [ -0.3099   0.8939  -0.3239]
        Angle    116.2647
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2462"
}

Galaxy "NGC 2463:MCG 10-12-31:ZWG 287.13:ARAK 145"
{
        Type  "E0"
        RA            7.9533
        Dec          56.6769
        Distance   3.796e+08  # method: V
        Radius     3.312e+04
        AbsMag        -20.13
        Axis    [  0.8762  -0.4801  -0.0415]
        Angle     63.3149
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2463"
}

Galaxy "NGC 2466:ESO 59-18:IRAS 07456-7117"
{
        Type  "Sc"
        RA            7.7542
        Dec         -71.4108
        Distance   2.474e+08  # method: V
        Radius     5.758e+04
        AbsMag         -20.9
        Axis    [  0.9440   0.1885  -0.2709]
        Angle    175.2400
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2466"
}

Galaxy "NGC 2468:UGC 4110:MCG 9-13-95:ZWG 287.16"
{
        Type  "S0"
        RA            7.9672
        Dec          56.3592
        Distance   2.125e+08  # distance uncertain!
        Radius     4.019e+04
        AbsMag        -19.07
        Axis    [  0.5493   0.5724   0.6088]
        Angle     65.2828
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2468"
}

Galaxy "NGC 2469:UGC 4111:MCG 10-12-35:ZWG 287.17"
{
        Type  "Sb"
        RA            7.9675
        Dec          56.6800
        Distance   1.501e+08  # method: V
        Radius     2.183e+04
        AbsMag        -19.91
        Axis    [ -0.3377   0.8935  -0.2960]
        Angle    112.8744
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2469"
}

Galaxy "NGC 2470:UGC 4091:MCG 1-20-9:ZWG 30.29"
{
        Type  "Sb"
        RA            7.9056
        Dec           4.4600
        Distance   1.965e+08  # method: V
        Radius     5.715e+04
        AbsMag         -20.2
        Axis    [ -0.1553   0.8250  -0.5433]
        Angle     68.6761
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2470"
}

Galaxy "NGC 2472:MCG 10-12-39:ZWG 287.19"
{
        Type  "S0"
        RA            7.9781
        Dec          56.7011
        Distance   3.694e+08  # distance uncertain!
        Radius     2.686e+04
        AbsMag        -19.07
        Axis    [  0.8866  -0.4625   0.0005]
        Angle     63.3897
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2472"
}

Galaxy "NGC 2473"
{
        Type  "S0"
        RA            7.9264
        Dec          56.7364
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [  0.1827   0.9646   0.1900]
        Angle     62.4999
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2473"
}

Galaxy "NGC 2474:UGC 4114:MCG 9-13-97:ZWG 262.52"
{
        Type  "E0"
        RA            7.9667
        Dec          52.8622
        Distance   2.579e+08  # method: V
        Radius         3e+04
        AbsMag        -20.39
        Axis    [  0.8865  -0.4595  -0.0552]
        Angle     66.7598
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2474"
}

Galaxy "NGC 2475:UGC 4114:MCG 9-13-96:ZWG 262.52"
{
        Type  "E0"
        RA            7.9661
        Dec          52.8572
        Distance     2.6e+08  # method: V
        Radius     2.269e+04
        AbsMag        -20.21
        Axis    [  0.8866  -0.4593  -0.0552]
        Angle     66.7609
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2475"
}

Galaxy "NGC 2476:UGC 4106:MCG 7-17-3:ZWG 207.8"
{
        Type  "E0"
        RA            7.9458
        Dec          39.9278
        Distance   1.759e+08  # method: V
        Radius     3.581e+04
        AbsMag        -20.06
        Axis    [  0.0868   0.7674  -0.6352]
        Angle    130.4047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2476"
}

Galaxy "NGC 2480:UGC 4116:MCG 4-19-9:ZWG 118.26"
{
        Type  "SBc"
        RA            7.9528
        Dec          23.7797
        Distance   1.142e+08  # method: V
        Radius     2.159e+04
        AbsMag        -17.72
        Axis    [ -0.4040   0.7389  -0.5393]
        Angle     97.9757
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2480"
}

Galaxy "NGC 2481:UGC 4118:MCG 4-19-10:ZWG 118.27"
{
        Type  "Sa"
        RA            7.9536
        Dec          23.7675
        Distance    1.14e+08  # method: V
        Radius     2.321e+04
        AbsMag        -19.12
        Axis    [  0.8224   0.4182   0.3856]
        Angle     93.3336
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2481"
}

Galaxy "NGC 2484:UGC 4125:MCG 6-18-4:ZWG 178.11"
{
        Type  "S0"
        RA            7.9744
        Dec          37.7867
        Distance   5.957e+08  # method: V
        Radius     7.798e+04
        AbsMag        -22.01
        Axis    [ -0.0761   0.8306  -0.5517]
        Angle    105.6074
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2484"
}

Galaxy "NGC 2485:UGC 4112:MCG 1-21-1:ZWG 31.3"
{
        Type  "Sa"
        RA            7.9467
        Dec           7.4775
        Distance   2.189e+08  # method: V
        Radius     5.094e+04
        AbsMag        -20.93
        Axis    [ -0.1052   0.6143  -0.7820]
        Angle    112.6767
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2485"
}

Galaxy "NGC 2486:UGC 4123:MCG 4-19-11:ZWG 118.29"
{
        Type  "Sa"
        RA            7.9656
        Dec          25.1611
        Distance   2.193e+08  # method: V
        Radius     5.422e+04
        AbsMag        -19.94
        Axis    [  0.2460   0.9306  -0.2711]
        Angle     65.9762
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2486"
}

Galaxy "NGC 2487:UGC 4126:MCG 4-19-12:ZWG 118.30"
{
        Type  "SBb"
        RA            7.9722
        Dec          25.1492
        Distance   2.278e+08  # method: V
        Radius     8.945e+04
        AbsMag        -21.02
        Axis    [  0.1520   0.8148  -0.5595]
        Angle     81.0966
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2487"
}

Galaxy "NGC 2488:UGC 4161:MCG 9-13-109:ZWG 287.29"
{
        Type  "S0"
        RA            8.0292
        Dec          56.5528
        Distance    3.94e+08  # method: V
        Radius     8.022e+04
        AbsMag        -21.81
        Axis    [  0.0005   0.9953   0.0973]
        Angle     67.9586
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2488"
}

Galaxy "NGC 2490:MCG 5-19-27:ZWG 148.78"
{
        Type  "E0"
        RA            7.9881
        Dec          27.0778
        Distance   4.571e+08  # distance uncertain!
        Radius     3.989e+04
        AbsMag        -20.13
        Axis    [  0.8641   0.0687  -0.4986]
        Angle     83.9069
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2490"
}

Galaxy "NGC 2491:ZWG 31.7:NPM 1"
{
        Type  "S0"
        RA            7.9742
        Dec           7.9844
        Distance   2.802e+08  # distance uncertain!
        Radius     1.223e+04
        AbsMag        -19.07
        Axis    [  0.4475   0.7157  -0.5362]
        Angle     75.3605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2491"
}

Galaxy "NGC 2492:UGC 4138:MCG 5-19-28:ZWG 148.80"
{
        Type  "S0"
        RA            7.9914
        Dec          27.0264
        Distance   3.104e+08  # method: V
        Radius     4.515e+04
        AbsMag        -21.09
        Axis    [  0.9431  -0.3180  -0.0970]
        Angle     90.1294
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2492"
}

Galaxy "NGC 2493:UGC 4150:MCG 7-17-7:ZWG 207.14"
{
        Type  "S0"
        RA            8.0064
        Dec          39.8308
        Distance   1.853e+08  # method: V
        Radius      5.12e+04
        AbsMag        -20.77
        Axis    [  0.9248  -0.3753  -0.0628]
        Angle     78.4739
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2493"
}

Galaxy "NGC 2494:IC 487:UGC 4141:MCG 0-21-1"
{
        Type  "SBa"
        RA            7.9853
        Dec          -0.6375
        Distance    1.54e+08  # distance uncertain!
        Radius     2.015e+04
        AbsMag        -19.07
        Axis    [  0.4741   0.5692  -0.6718]
        Angle     86.0158
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2494"
}

Galaxy "NGC 2495:MCG 7-17-8:MK 383:ZWG 207.16"
{
        Type  "Irr"
        RA            8.0092
        Dec          39.8406
        Distance   3.874e+08  # method: V
        Radius     2.254e+04
        AbsMag        -19.57
        Axis    [  0.8379   0.2677   0.4757]
        Angle     83.4013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2495"
}

Galaxy "NGC 2496:UGC 4127:MCG 1-21-2:ZWG 31.9"
{
        Type  "E0"
        RA            7.9769
        Dec           8.0281
        Distance   2.188e+08  # distance uncertain!
        Radius       3.5e+04
        AbsMag        -20.13
        Axis    [ -0.0389   0.5813  -0.8127]
        Angle    146.5103
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2496"
}

Galaxy "NGC 2497:UGC 4168:MCG 10-12-61:ZWG 287.32"
{
        Type  "S0"
        RA            8.0364
        Dec          56.9422
        Distance   3.747e+08  # method: V
        Radius     7.629e+04
        AbsMag         -21.1
        Axis    [  0.9393   0.1168   0.3225]
        Angle     56.6615
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2497"
}

Galaxy "NGC 2498:UGC 4142:MCG 4-19-15:ZWG 118.34"
{
        Type  "SBa"
        RA            7.9939
        Dec          24.9833
        Distance   2.227e+08  # method: V
        Radius     3.562e+04
        AbsMag        -19.77
        Axis    [  0.1469   0.8406  -0.5213]
        Angle     77.3926
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2498"
}

Galaxy "NGC 2499:MCG 1-21-3:ZWG 31.11"
{
        Type  "SBa"
        RA            7.9808
        Dec           7.4928
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.9470   0.3083   0.0904]
        Angle     98.3428
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2499"
}

Galaxy "NGC 2500:UGC 4165:MCG 9-13-110:ZWG 262.62"
{
        Type  "SBc"
        RA            8.0314
        Dec          50.7367
        Distance   2.881e+07  # method: V
        Radius     1.215e+04
        AbsMag        -17.53
        Axis    [  0.9030   0.4173  -0.1024]
        Angle     54.3669
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2500"
}

Galaxy "NGC 2501:MCG 2-21-2:IRAS 07561-1413"
{
        Type  "S0"
        RA            7.9750
        Dec         -14.3542
        Distance   1.688e+08  # distance uncertain!
        Radius     3.438e+04
        AbsMag        -19.07
        Axis    [  0.2118   0.5070  -0.8355]
        Angle     92.6084
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2501"
}

Galaxy "NGC 2502:ESO 209-8:AM 0754-521"
{
        Type  "S0"
        RA            7.9308
        Dec         -52.3069
        Distance   5.726e+07  # method: V
        Radius     1.749e+04
        AbsMag        -18.02
        Axis    [  0.2398   0.1980  -0.9504]
        Angle    106.5720
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2502"
}

Galaxy "NGC 2503:UGC 4158:MCG 4-19-19:ZWG 118.41"
{
        Type  "SBc"
        RA            8.0100
        Dec          22.4000
        Distance   2.586e+08  # method: V
        Radius     3.761e+04
        AbsMag         -19.7
        Axis    [  0.9466  -0.3036  -0.1090]
        Angle     94.4877
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2503"
}

Galaxy "NGC 2504:UGC 4152:MCG 1-21-4:ZWG 31.15"
{
        Type  "Irr"
        RA            7.9978
        Dec           5.6078
        Distance   1.288e+08  # method: V
        Radius          9369
        AbsMag        -18.98
        Axis    [  0.4540   0.6062  -0.6530]
        Angle     83.7354
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2504"
}

Galaxy "NGC 2505:UGC 4193:MCG 9-13-115:ZWG 262.66"
{
        Type  "SBa"
        RA            8.0683
        Dec          53.5497
        Distance   1.404e+08  # distance uncertain!
        Radius     2.451e+04
        AbsMag        -19.07
        Axis    [  0.7903   0.0502   0.6107]
        Angle     87.8843
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2505"
}

Galaxy "NGC 2507:UGC 4172:MCG 3-21-10:ZWG 88.20"
{
        Type  "Sa"
        RA            8.0269
        Dec          15.7103
        Distance   2.164e+08  # method: V
        Radius      7.87e+04
        AbsMag        -20.51
        Axis    [  0.0343   0.7619  -0.6468]
        Angle     84.4340
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2507"
}

Galaxy "NGC 2508:UGC 4174:MCG 2-21-4:ZWG 59.18"
{
        Type  "E0"
        RA            8.0325
        Dec           8.5519
        Distance   2.086e+08  # method: V
        Radius     4.248e+04
        AbsMag        -20.13
        Axis    [  0.2335   0.4900  -0.8399]
        Angle    125.6196
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2508"
}

Galaxy "NGC 2510:UGC 4178:MCG 2-21-7:ZWG 59.23"
{
        Type  "S0"
        RA            8.0361
        Dec           9.4861
        Distance   1.688e+08  # distance uncertain!
        Radius     2.455e+04
        AbsMag        -19.07
        Axis    [  0.2287   0.7281  -0.6462]
        Angle     78.9466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2510"
}

Galaxy "NGC 2511:MCG 2-21-8:MK 1207:ZWG 59.24"
{
        Type  "S0"
        RA            8.0375
        Dec           9.3953
        Distance   2.126e+08  # method: V
        Radius     2.783e+04
        AbsMag        -18.97
        Axis    [ -0.0675   0.8823  -0.4658]
        Angle     65.9783
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2511"
}

Galaxy "NGC 2512:UGC 4191:MCG 4-19-21:MK 384"
{
        Type  "SBb"
        RA            8.0519
        Dec          23.3917
        Distance   2.221e+08  # method: V
        Radius     4.523e+04
        AbsMag        -20.27
        Axis    [  0.1085   0.8696  -0.4817]
        Angle     73.3152
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2512"
}

Galaxy "NGC 2513:UGC 4184:MCG 2-21-9:ZWG 59.25"
{
        Type  "E0"
        RA            8.0400
        Dec           9.4139
        Distance   2.016e+08  # method: T-F
        Radius      7.33e+04
        AbsMag        -21.35
        Axis    [ -0.0620   0.5955  -0.8010]
        Angle    147.1697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2513"
}

Galaxy "NGC 2514:UGC 4189:MCG 3-21-11:ZWG 88.22"
{
        Type  "SBc"
        RA            8.0469
        Dec          15.8078
        Distance   2.299e+08  # method: V
        Radius     4.346e+04
        AbsMag        -20.24
        Axis    [  0.9909   0.0567  -0.1223]
        Angle     90.2183
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2514"
}

Galaxy "NGC 2517:MCG 2-21-3:NPM 1:CGMW 1-2065"
{
        Type  "S0"
        RA            8.0464
        Dec         -12.3172
        Distance   7.717e+07  # distance uncertain!
        Radius     1.571e+04
        AbsMag        -19.07
        Axis    [  0.7429   0.4447  -0.5003]
        Angle     92.8127
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2517"
}

Galaxy "NGC 2518:UGC 4221:MCG 9-14-6:ZWG 263.9"
{
        Type  "S0"
        RA            8.1222
        Dec          51.1322
        Distance   2.441e+08  # method: V
        Radius     4.261e+04
        AbsMag        -19.77
        Axis    [  0.9326   0.2892   0.2158]
        Angle     56.6849
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2518"
}

Galaxy "NGC 2521:UGC 4235:MCG 10-12-77:ZWG 287.42"
{
        Type  "S0"
        RA            8.1469
        Dec          57.7697
        Distance   2.438e+08  # method: V
        Radius     4.255e+04
        AbsMag        -20.27
        Axis    [  0.6466   0.5278   0.5508]
        Angle     59.1996
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2521"
}

Galaxy "NGC 2522:UGC 4218:MCG 3-21-14:ZWG 88.31"
{
        Type  "Sa"
        RA            8.1036
        Dec          17.7067
        Distance   1.688e+08  # distance uncertain!
        Radius     2.455e+04
        AbsMag        -19.07
        Axis    [  0.7842   0.5423   0.3016]
        Angle     87.2404
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2522"
}

Galaxy "NGC 2523:UGC 4271:MCG 12-8-31:ZWG 331.32"
{
        Type  "SBc"
        RA            8.2500
        Dec          73.5789
        Distance   1.563e+08  # method: V
        Radius     6.592e+04
        AbsMag         -20.8
        Axis    [  0.3835   0.6305   0.6748]
        Angle     55.3829
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2523"
}

Galaxy "NGC 2523A:UGC 4166:MCG 12-8-24:ZWG 331.26"
{
        Type  "SBc"
        RA            8.0689
        Dec          74.0481
        Distance   1.737e+08  # method: V
        Radius     2.526e+04
        AbsMag        -19.13
        Axis    [  0.0090   0.9705   0.2411]
        Angle     67.7453
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2523A"
}

Galaxy "NGC 2523B:UGC 4259:MCG 12-8-30:ZWG 331.30"
{
        Type  "Sb"
        RA            8.2156
        Dec          73.5636
        Distance   1.752e+08  # method: V
        Radius     5.097e+04
        AbsMag        -18.85
        Axis    [ -0.2229   0.7310   0.6450]
        Angle     83.6325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2523B"
}

Galaxy "NGC 2523C:UGC 4290:MCG 12-8-32:ZWG 331.33"
{
        Type  "E0"
        RA            8.2956
        Dec          73.3181
        Distance   1.563e+08  # method: V
        Radius      3.41e+04
        AbsMag         -19.1
        Axis    [  0.4134   0.8152  -0.4056]
        Angle     69.0232
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2523C"
}

Galaxy "NGC 2524:UGC 4234:MCG 7-17-16:ZWG 207.34"
{
        Type  "Sa"
        RA            8.1358
        Dec          39.1578
        Distance     1.9e+08  # method: V
        Radius      3.87e+04
        AbsMag        -20.23
        Axis    [ -0.0577   0.9181  -0.3922]
        Angle     80.4697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2524"
}

Galaxy "NGC 2525:MCG 2-21-4:UGCA 135:IRAS 08032-1117"
{
        Type  "SBc"
        RA            8.0939
        Dec         -11.4275
        Distance   8.276e+07  # method: V
        Radius     3.611e+04
        AbsMag        -19.72
        Axis    [  0.6759   0.5015  -0.5401]
        Angle     87.6469
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2525"
}

Galaxy "NGC 2526:UGC 4231:MCG 1-21-12:ZWG 31.47"
{
        Type  "Sb"
        RA            8.1161
        Dec           8.0042
        Distance   2.193e+08  # method: V
        Radius     3.827e+04
        AbsMag        -19.44
        Axis    [ -0.0658   0.7385  -0.6710]
        Angle     79.3931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2526"
}

Galaxy "NGC 2528:UGC 4227:MCG 7-17-15:ZWG 207.32"
{
        Type  "Sb"
        RA            8.1236
        Dec          39.1947
        Distance   1.854e+08  # method: V
        Radius     4.044e+04
        AbsMag        -20.37
        Axis    [  0.9171  -0.3926  -0.0700]
        Angle     79.6191
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2528"
}

Galaxy "NGC 2530:UGC 4237:MCG 3-21-20:ZWG 88.38"
{
        Type  "SBc"
        RA            8.1319
        Dec          17.8183
        Distance   2.377e+08  # method: V
        Radius     4.841e+04
        AbsMag        -19.81
        Axis    [ -0.4125   0.6622  -0.6255]
        Angle    106.0691
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2530"
}

Galaxy "NGC 2532:UGC 4256:MCG 6-18-13:ZWG 178.32"
{
        Type  "SBc"
        RA            8.1708
        Dec          33.9561
        Distance   2.465e+08  # method: V
        Radius     6.813e+04
        AbsMag        -21.39
        Axis    [  0.9595   0.0787   0.2704]
        Angle     82.9954
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2532"
}

Galaxy "NGC 2534:UGC 4268:MCG 9-14-14:MK 85"
{
        Type  "E1"
        RA            8.2150
        Dec          55.6719
        Distance   1.715e+08  # method: V
        Radius     2.494e+04
        AbsMag           -20
        Axis    [  0.8508  -0.5231  -0.0499]
        Angle     65.9191
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2534"
}

Galaxy "NGC 2535:UGC 4264:MCG 4-20-4:ZWG 119.8"
{
        Type  "Sc"
        RA            8.1869
        Dec          25.2072
        Distance   1.951e+08  # method: V
        Radius     7.093e+04
        AbsMag        -20.58
        Axis    [  0.8978   0.2747   0.3443]
        Angle     92.9891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2535"
}

Galaxy "NGC 2536:MCG 4-20-5:ZWG 119.9:VV 9"
{
        Type  "SBc"
        RA            8.1878
        Dec          25.1797
        Distance    1.97e+08  # method: V
        Radius     2.292e+04
        AbsMag        -19.11
        Axis    [  0.7885   0.5965   0.1499]
        Angle     70.1546
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2536"
}

Galaxy "NGC 2537:UGC 4274:MCG 8-15-50:MK 86"
{
        Type  "Irr"
        RA            8.2206
        Dec          45.9914
        Distance   2.686e+07  # method: V
        Radius          6642
        AbsMag        -17.28
        Axis    [ -0.2028   0.8555  -0.4764]
        Angle    115.5117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2537"
}

Galaxy "NGC 2537A:MCG 8-15-51"
{
        Type  "SBc"
        RA            8.2281
        Dec          45.9933
        Distance   3.527e+08  # distance uncertain!
        Radius     3.078e+04
        AbsMag        -19.07
        Axis    [  0.8937  -0.4459  -0.0505]
        Angle     74.1820
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2537A"
}

Galaxy "NGC 2538:UGC 4266:MCG 1-21-19:ZWG 31.67"
{
        Type  "SBa"
        RA            8.1897
        Dec           3.6331
        Distance   1.897e+08  # method: V
        Radius     4.138e+04
        AbsMag        -20.22
        Axis    [  0.9734   0.1962  -0.1183]
        Angle     96.9446
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2538"
}

Galaxy "NGC 2540:UGC 4275:MCG 5-20-4:ZWG 149.4"
{
        Type  "SBc"
        RA            8.2128
        Dec          26.3614
        Distance   2.948e+08  # method: V
        Radius     5.573e+04
        AbsMag        -20.38
        Axis    [ -0.0202   0.8504  -0.5257]
        Angle     78.5281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2540"
}

Galaxy "NGC 2541:UGC 4284:MCG 8-15-54:ZWG 236.37"
{
        Type  "SBc"
        RA            8.2444
        Dec          49.0619
        Distance   5.237e+07  # method: T-F
        Radius     4.798e+04
        AbsMag        -18.83
        Axis    [ -0.4879   0.8264  -0.2810]
        Angle    105.9285
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2541"
}

Galaxy "NGC 2543:IC 2232:UGC 4273:MCG 6-18-14"
{
        Type  "SBb"
        RA            8.2158
        Dec          36.2536
        Distance     1.2e+08  # method: V
        Radius     4.014e+04
        AbsMag        -20.13
        Axis    [  0.7786   0.5496   0.3029]
        Angle     66.7931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2543"
}

Galaxy "NGC 2544:UGC 4327:MCG 12-8-34:MK 87"
{
        Type  "SBa"
        RA            8.3611
        Dec          73.9883
        Distance   1.297e+08  # method: V
        Radius     2.075e+04
        AbsMag         -19.1
        Axis    [  0.3308   0.8098   0.4845]
        Angle     51.8073
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2544"
}

Galaxy "NGC 2545:UGC 4287:MCG 4-20-7:ZWG 119.16"
{
        Type  "SBb"
        RA            8.2372
        Dec          21.3561
        Distance   2.277e+08  # method: T-F
        Radius     7.287e+04
        AbsMag        -21.02
        Axis    [ -0.4808   0.6761  -0.5584]
        Angle    101.1468
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2545"
}

Galaxy "NGC 2549:UGC 4313:MCG 10-12-124:ZWG 287.69"
{
        Type  "S0"
        RA            8.3161
        Dec          57.8031
        Distance   4.125e+07  # method: S
        Radius      2.28e+04
        AbsMag        -18.31
        Axis    [ -0.6342   0.7547  -0.1683]
        Angle    116.0291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2549"
}

Galaxy "NGC 2550:UGC 4359:MCG 12-8-37:ZWG 331.39"
{
        Type  "Sb"
        RA            8.4092
        Dec          74.0119
        Distance   1.017e+08  # distance uncertain!
        Radius      1.48e+04
        AbsMag        -19.07
        Axis    [ -0.2031   0.8689   0.4514]
        Angle     76.3526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2550"
}

Galaxy "NGC 2550A:UGC 4397:MCG 12-8-43:ZWG 331.43"
{
        Type  "Sc"
        RA            8.4775
        Dec          73.7481
        Distance   1.667e+08  # method: V
        Radius     3.879e+04
        AbsMag        -20.14
        Axis    [  0.7560  -0.4081   0.5117]
        Angle     63.5524
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2550A"
}

Galaxy "NGC 2551:UGC 4362:MCG 12-8-38:ZWG 331.40"
{
        Type  "Sa"
        RA            8.4139
        Dec          73.4125
        Distance   1.043e+08  # method: V
        Radius     2.427e+04
        AbsMag        -19.42
        Axis    [  0.4335   0.5691   0.6987]
        Angle     54.4504
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2551"
}

Galaxy "NGC 2552:UGC 4325:MCG 8-15-62:ZWG 236.42"
{
        Type  "Irr"
        RA            8.3219
        Dec          50.0069
        Distance   2.963e+07  # method: V
        Radius     1.551e+04
        AbsMag        -17.19
        Axis    [  0.6393   0.6693   0.3785]
        Angle     56.6315
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2552"
}

Galaxy "NGC 2553:MCG 4-20-14:ZWG 119.31"
{
        Type  "S0"
        RA            8.2931
        Dec          20.9033
        Distance    2.24e+08  # method: V
        Radius     5.539e+04
        AbsMag        -19.28
        Axis    [  0.6081   0.7917  -0.0591]
        Angle     62.6337
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2553"
}

Galaxy "NGC 2554:UGC 4312:MCG 4-20-15:ZWG 119.33"
{
        Type  "Sa"
        RA            8.2981
        Dec          23.4722
        Distance    1.98e+08  # method: V
        Radius     9.214e+04
        AbsMag        -21.01
        Axis    [ -0.1908   0.7651  -0.6150]
        Angle     93.8801
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2554"
}

Galaxy "NGC 2555:UGC 4319:MCG 0-21-12:ZWG 3.28"
{
        Type  "SBb"
        RA            8.2989
        Dec           0.7450
        Distance   2.108e+08  # method: V
        Radius     5.826e+04
        AbsMag        -20.75
        Axis    [  0.2187   0.6121  -0.7599]
        Angle     82.2101
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2555"
}

Galaxy "NGC 2556:ZWG 119.45:NPM 1"
{
        Type  "S0"
        RA            8.3167
        Dec          20.9375
        Distance   2.202e+08  # method: V
        Radius     1.281e+04
        AbsMag        -18.85
        Axis    [ -0.2602   0.8241  -0.5031]
        Angle     76.6275
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2556"
}

Galaxy "NGC 2557:UGC 4330:MCG 4-20-21:ZWG 119.48"
{
        Type  "S0"
        RA            8.3194
        Dec          21.4361
        Distance   2.305e+08  # method: V
        Radius     4.024e+04
        AbsMag        -19.85
        Axis    [  0.8685   0.4041  -0.2871]
        Angle     71.4455
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2557"
}

Galaxy "NGC 2558:UGC 4331:MCG 4-20-22:ZWG 119.50"
{
        Type  "Sb"
        RA            8.3200
        Dec          20.5114
        Distance   2.363e+08  # method: V
        Radius     6.186e+04
        AbsMag         -20.5
        Axis    [ -0.3098   0.7132  -0.6288]
        Angle    100.8893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2558"
}

Galaxy "NGC 2559:ESO 494-41:MCG 4-20-3:UGCA 136"
{
        Type  "SBc"
        RA            8.2850
        Dec         -27.4569
        Distance   8.159e+07  # method: V
        Radius      3.56e+04
        AbsMag        -20.29
        Axis    [  0.9261   0.3752  -0.0384]
        Angle    130.3242
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2559"
}

Galaxy "NGC 2560:UGC 4337:MCG 4-20-27:ZWG 119.58"
{
        Type  "Sa"
        RA            8.3308
        Dec          20.9847
        Distance   2.333e+08  # method: V
        Radius     4.751e+04
        AbsMag        -19.67
        Axis    [  0.1608   0.9832   0.0861]
        Angle     58.2056
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2560"
}

Galaxy "NGC 2561:UGC 4336:MCG 1-22-1:ZWG 31.81"
{
        Type  "SBc"
        RA            8.3267
        Dec           4.6567
        Distance   1.959e+08  # method: V
        Radius     3.135e+04
        AbsMag        -19.79
        Axis    [ -0.1653   0.6906  -0.7041]
        Angle     78.0137
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2561"
}

Galaxy "NGC 2562:UGC 4345:MCG 4-20-31:ZWG 119.63"
{
        Type  "Sa"
        RA            8.3397
        Dec          21.1317
        Distance   2.367e+08  # method: V
        Radius     3.443e+04
        AbsMag         -20.4
        Axis    [  0.9748   0.0688   0.2123]
        Angle     97.0822
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2562"
}

Galaxy "NGC 2563:UGC 4347:MCG 4-20-33:ZWG 119.65"
{
        Type  "S0"
        RA            8.3431
        Dec          21.0681
        Distance   2.541e+08  # method: T-F
        Radius     7.392e+04
        AbsMag        -21.16
        Axis    [  0.6303   0.5834  -0.5122]
        Angle     70.9994
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2563"
}

Galaxy "NGC 2564:ESO 562-1:NPM 1:CGMW 2-3167"
{
        Type  "S0"
        RA            8.3083
        Dec         -21.8161
        Distance   1.065e+08  # distance uncertain!
        Radius     1.859e+04
        AbsMag        -19.07
        Axis    [  0.6244   0.4225  -0.6570]
        Angle     91.8539
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2564"
}

Galaxy "NGC 2565:UGC 4334:MCG 4-20-26:MK 386"
{
        Type  "SBc"
        RA            8.3300
        Dec          22.0314
        Distance    1.99e+08  # method: T-F
        Radius     5.499e+04
        AbsMag        -20.53
        Axis    [ -0.5118   0.6854  -0.5179]
        Angle     95.1452
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2565"
}

Galaxy "NGC 2566:ESO 495-3:MCG 4-20-8:UGCA 138"
{
        Type  "SBb"
        RA            8.3125
        Dec         -25.5006
        Distance   8.585e+07  # method: V
        Radius     3.621e+04
        AbsMag         -20.3
        Axis    [  0.7629   0.4221  -0.4897]
        Angle     97.5415
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2566"
}

Galaxy "NGC 2569:MCG 4-20-35:ZWG 119.67:NPM 1"
{
        Type  "S0"
        RA            8.3558
        Dec          20.8681
        Distance   2.415e+08  # method: V
        Radius     2.107e+04
        AbsMag        -19.05
        Axis    [  0.1734   0.7326  -0.6583]
        Angle     81.1452
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2569"
}

Galaxy "NGC 2570:UGC 4354:MCG 4-20-36:ZWG 119.68"
{
        Type  "Sb"
        RA            8.3561
        Dec          20.9106
        Distance    3.29e+08  # method: T-F
        Radius     5.263e+04
        AbsMag        -19.92
        Axis    [  0.6132   0.7729  -0.1632]
        Angle     61.8668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2570"
}

Galaxy "NGC 2572:UGC 4355:MCG 3-22-4:ZWG 89.7"
{
        Type  "Sa"
        RA            8.3567
        Dec          19.1478
        Distance   1.851e+08  # distance uncertain!
        Radius       3.5e+04
        AbsMag        -19.07
        Axis    [ -0.2739   0.8587  -0.4332]
        Angle     69.1263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2572"
}

Galaxy "NGC 2573:ESO 1-1:IRAS 02425-8934"
{
        Type  "SBc"
        RA            1.6981
        Dec         -89.3342
        Distance   1.404e+08  # distance uncertain!
        Radius     3.881e+04
        AbsMag        -19.07
        Axis    [  0.7864   0.5604  -0.2599]
        Angle    185.9283
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2573"
}

Galaxy "NGC 2573A:ESO 1-9:AM 2247-892:IRAS 22443-8923"
{
        Type  "SBb"
        RA           23.2039
        Dec         -89.1242
        Distance   1.851e+08  # distance uncertain!
        Radius     5.654e+04
        AbsMag        -19.07
        Axis    [ -0.5472  -0.6889  -0.4755]
        Angle    115.1363
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2573A"
}

Galaxy "NGC 2573B:ESO 1-8:AM 2240-892"
{
        Type  "Irr"
        RA           23.1256
        Dec         -89.1153
        Distance   3.631e+08  # distance uncertain!
        Radius     7.922e+04
        AbsMag        -20.13
        Axis    [ -0.7725  -0.5875   0.2411]
        Angle    172.1338
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2573B"
}

Galaxy "NGC 2574:MCG 1-22-3:IRAS 08183-0845"
{
        Type  "Sb"
        RA            8.3467
        Dec          -8.9183
        Distance   1.417e+08  # method: V
        Radius      4.74e+04
        AbsMag        -19.49
        Axis    [ -0.2867   0.5053  -0.8139]
        Angle     84.6794
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2574"
}

Galaxy "NGC 2575:UGC 4368:MCG 4-20-40:ZWG 119.75"
{
        Type  "Sc"
        RA            8.3792
        Dec          24.2969
        Distance   1.853e+08  # method: V
        Radius     4.582e+04
        AbsMag        -20.27
        Axis    [ -0.1694   0.7711  -0.6138]
        Angle     92.2024
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2575"
}

Galaxy "NGC 2576:UGC 4371:MCG 4-20-41:ZWG 119.76"
{
        Type  "Sb"
        RA            8.3825
        Dec          25.7394
        Distance   3.882e+08  # method: V
        Radius     9.599e+04
        AbsMag        -20.08
        Axis    [  0.6627   0.5996   0.4487]
        Angle     81.0774
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2576"
}

Galaxy "NGC 2577:UGC 4367:MCG 4-20-42:ZWG 119.74"
{
        Type  "S0"
        RA            8.3786
        Dec          22.5536
        Distance   1.074e+08  # method: V
        Radius     2.811e+04
        AbsMag        -19.09
        Axis    [  0.2114   0.8742  -0.4372]
        Angle     64.6068
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2577"
}

Galaxy "NGC 2578:MCG 2-22-2:IRAS 08191-1310"
{
        Type  "SBa"
        RA            8.3567
        Dec         -13.3181
        Distance   1.065e+08  # distance uncertain!
        Radius     3.408e+04
        AbsMag        -19.07
        Axis    [  0.6315   0.5214  -0.5739]
        Angle     81.7486
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2578"
}

Galaxy "NGC 2581:UGC 4388:MCG 3-22-10:ZWG 89.19"
{
        Type  "SBa"
        RA            8.4083
        Dec          18.5969
        Distance   2.785e+08  # method: V
        Radius     4.455e+04
        AbsMag        -20.36
        Axis    [  0.9865   0.0950   0.1331]
        Angle     93.6381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2581"
}

Galaxy "NGC 2582:IC 2359:UGC 4391:MCG 4-20-50"
{
        Type  "SBb"
        RA            8.4200
        Dec          20.3342
        Distance   2.116e+08  # method: V
        Radius     3.693e+04
        AbsMag        -20.16
        Axis    [  0.9241  -0.3557  -0.1394]
        Angle     97.9407
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2582"
}

Galaxy "NGC 2583:MCG 1-22-8"
{
        Type  "E0"
        RA            8.3853
        Dec          -5.0025
        Distance   2.796e+08  # method: V
        Radius      3.66e+04
        AbsMag        -20.27
        Axis    [  0.9361  -0.2853  -0.2056]
        Angle    121.7144
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2583"
}

Galaxy "NGC 2584:MCG 1-22-9"
{
        Type  "Sc"
        RA            8.3875
        Dec          -4.9708
        Distance   2.614e+08  # method: T-F
        Radius     4.563e+04
        AbsMag        -19.92
        Axis    [  0.9542   0.2749   0.1181]
        Angle    117.5251
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2584"
}

Galaxy "NGC 2585:MCG 1-22-10:IRAS 08209-0445"
{
        Type  "Sb"
        RA            8.3906
        Dec          -4.9153
        Distance   1.688e+08  # distance uncertain!
        Radius      4.42e+04
        AbsMag        -19.07
        Axis    [  0.4296   0.7147  -0.5519]
        Angle     67.0735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2585"
}

Galaxy "NGC 2590:IC 507:UGC 4392:MCG 0-22-10"
{
        Type  "Sc"
        RA            8.4172
        Dec          -0.5911
        Distance   2.382e+08  # method: V
        Radius     7.622e+04
        AbsMag        -20.42
        Axis    [  0.5953   0.7668  -0.2402]
        Angle     66.2292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2590"
}

Galaxy "NGC 2591:UGC 4472:MCG 13-7-1:ZWG 349.29"
{
        Type  "Sc"
        RA            8.6236
        Dec          78.0256
        Distance   7.683e+07  # method: T-F
        Radius     3.352e+04
        AbsMag        -18.96
        Axis    [  0.3598   0.2100   0.9091]
        Angle     89.8617
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2591"
}

Galaxy "NGC 2592:UGC 4411:MCG 4-20-55:ZWG 119.102"
{
        Type  "E0"
        RA            8.4522
        Dec          25.9708
        Distance   8.384e+07  # method: S
        Radius     2.073e+04
        AbsMag        -18.65
        Axis    [  0.8482  -0.0166  -0.5294]
        Angle     83.3892
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2592"
}

Galaxy "NGC 2593:UGC 4408:MCG 3-22-12:ZWG 89.29"
{
        Type  "Sa"
        RA            8.4464
        Dec          17.3744
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [ -0.5002   0.6380  -0.5855]
        Angle     99.4639
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2593"
}

Galaxy "NGC 2594:MCG 4-20-56:ZWG 119.106"
{
        Type  "S0"
        RA            8.4547
        Dec          25.8786
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [  0.9451   0.2729   0.1798]
        Angle     79.0351
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2594"
}

Galaxy "NGC 2595:UGC 4422:MCG 4-20-62:ZWG 119.109"
{
        Type  "SBc"
        RA            8.4614
        Dec          21.4794
        Distance   2.068e+08  # method: V
        Radius     9.623e+04
        AbsMag        -21.01
        Axis    [  0.9279   0.3556  -0.1117]
        Angle     71.9842
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2595"
}

Galaxy "NGC 2596:UGC 4419:MCG 3-22-13:ZWG 89.30"
{
        Type  "Sb"
        RA            8.4572
        Dec          17.2844
        Distance   3.109e+08  # method: T-F
        Radius     6.783e+04
        AbsMag         -20.7
        Axis    [  0.6850   0.7283   0.0195]
        Angle     64.5182
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2596"
}

Galaxy "NGC 2598:UGC 4443:MCG 4-20-65:ZWG 119.116"
{
        Type  "SBa"
        RA            8.5006
        Dec          21.4883
        Distance   2.192e+08  # method: V
        Radius     4.145e+04
        AbsMag        -19.24
        Axis    [  0.9256   0.1885   0.3282]
        Angle    101.7612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2598"
}

Galaxy "NGC 2599:UGC 4458:MCG 4-20-67:MK 389"
{
        Type  "Sa"
        RA            8.5364
        Dec          22.5608
        Distance   2.257e+08  # method: V
        Radius     6.238e+04
        AbsMag         -21.1
        Axis    [  0.3409   0.6577  -0.6717]
        Angle     77.5465
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2599"
}

Galaxy "NGC 2600:UGC 4475:MCG 9-14-68:ZWG 263.55"
{
        Type  "Sb"
        RA            8.5789
        Dec          52.7153
        Distance   5.375e+08  # method: T-F
        Radius     9.381e+04
        AbsMag        -21.08
        Axis    [  0.2171   0.8234   0.5243]
        Angle     60.7403
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2600"
}

Galaxy "NGC 2601:ESO 60-5:IRAS 08251-6757"
{
        Type  "SBa"
        RA            8.4250
        Dec         -68.1178
        Distance   1.529e+08  # method: V
        Radius     3.559e+04
        AbsMag        -19.95
        Axis    [  0.2711   0.0375  -0.9618]
        Angle    119.5872
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2601"
}

Galaxy "NGC 2602:MCG 9-14-69:ZWG 263-56:ARAK 169"
{
        Type  "S0"
        RA            8.5844
        Dec          52.8314
        Distance   2.555e+08  # distance uncertain!
        Radius     1.115e+04
        AbsMag        -19.07
        Axis    [  0.8646   0.1967   0.4624]
        Angle     62.8311
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2602"
}

Galaxy "NGC 2603"
{
        Type  "E0"
        RA            8.5753
        Dec          52.8403
        Distance   6.919e+08  # distance uncertain!
        Radius     3.019e+04
        AbsMag        -20.13
        Axis    [  0.8213  -0.5664  -0.0681]
        Angle     70.8638
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2603"
}

Galaxy "NGC 2604:NGC 2604A:UGC 4469:MCG 5-20-22"
{
        Type  "SBc"
        RA            8.5561
        Dec          29.5386
        Distance   1.046e+08  # method: V
        Radius     2.587e+04
        AbsMag        -19.23
        Axis    [  0.9015  -0.4156  -0.1210]
        Angle     90.3460
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2604"
}

Galaxy "NGC 2604B:MCG 5-20-23:ZWG 149.49:KUG 0830+296"
{
        Type  "Sc"
        RA            8.5597
        Dec          29.4994
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [  0.9099   0.4094   0.0670]
        Angle     66.0567
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2604B"
}

Galaxy "NGC 2605"
{
        Type  "S0"
        RA            8.5814
        Dec          52.8044
        Distance    4.05e+08  # distance uncertain!
        Radius     2.356e+04
        AbsMag        -19.07
        Axis    [  0.9144   0.0185   0.4043]
        Angle     65.8174
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2605"
}

Galaxy "NGC 2606:MCG 9-14-72:ZWG 263.59"
{
        Type  "Sc"
        RA            8.5928
        Dec          52.7886
        Distance   2.226e+08  # distance uncertain!
        Radius     2.266e+04
        AbsMag        -19.07
        Axis    [  0.6420   0.4655   0.6092]
        Angle     64.7494
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2606"
}

Galaxy "NGC 2607:UGC 4473:MCG 5-20-25:ZWG 149.51"
{
        Type  "Sc"
        RA            8.5656
        Dec          26.9731
        Distance     1.7e+08  # method: V
        Radius     2.225e+04
        AbsMag        -18.88
        Axis    [  0.8719   0.3454  -0.3470]
        Angle     67.0648
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2607"
}

Galaxy "NGC 2608:UGC 4484:MCG 5-20-27:ZWG 149.55"
{
        Type  "SBb"
        RA            8.5881
        Dec          28.4733
        Distance   1.066e+08  # method: V
        Radius     2.947e+04
        AbsMag        -19.57
        Axis    [  0.8056   0.5920  -0.0255]
        Angle     60.4399
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2608"
}

Galaxy "NGC 2611:ZWG 119.127"
{
        Type  "S0"
        RA            8.5914
        Dec          25.0278
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.7589   0.5447   0.3570]
        Angle     75.7655
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2611"
}

Galaxy "NGC 2612:MCG 2-22-20"
{
        Type  "S0"
        RA            8.5639
        Dec         -13.1742
        Distance   1.168e+08  # distance uncertain!
        Radius     4.757e+04
        AbsMag        -19.07
        Axis    [  0.0068   0.7511  -0.6601]
        Angle     53.7111
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2612"
}

Galaxy "NGC 2613:ESO 495-18:MCG 4-21-3:UGCA 141"
{
        Type  "Sb"
        RA            8.5561
        Dec         -22.9728
        Distance   1.106e+08  # method: T-F
        Radius     1.045e+05
        AbsMag        -21.45
        Axis    [  0.1972   0.6661  -0.7193]
        Angle     57.4936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2613"
}

Galaxy "NGC 2614:UGC 4523:MCG 12-9-5:ZWG 331.58"
{
        Type  "Sc"
        RA            8.7131
        Dec          72.9767
        Distance   1.587e+08  # method: V
        Radius     4.617e+04
        AbsMag        -19.74
        Axis    [ -0.2180   0.9685  -0.1201]
        Angle    101.1438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2614"
}

Galaxy "NGC 2615:UGC 4481:MCG 0-22-19:ZWG 4.59"
{
        Type  "SBb"
        RA            8.5758
        Dec          -2.5472
        Distance   1.017e+08  # distance uncertain!
        Radius     2.811e+04
        AbsMag        -19.07
        Axis    [  0.9112   0.3797  -0.1600]
        Angle     89.1875
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2615"
}

Galaxy "NGC 2616:UGC 4489:MCG 0-22-21:ZWG 4.69"
{
        Type  "S0"
        RA            8.5928
        Dec          -1.8508
        Distance   4.201e+08  # method: V
        Radius     6.721e+04
        AbsMag        -21.85
        Axis    [ -0.2700   0.5116  -0.8157]
        Angle    106.4295
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2616"
}

Galaxy "NGC 2617:MCG 1-22-27"
{
        Type  "Sa"
        RA            8.5939
        Dec          -4.0878
        Distance   1.851e+08  # distance uncertain!
        Radius     2.962e+04
        AbsMag        -19.07
        Axis    [  0.1929   0.5496  -0.8129]
        Angle     80.5154
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2617"
}

Galaxy "NGC 2618:UGC 4492:MCG 0-22-23:ZWG 4.74"
{
        Type  "Sb"
        RA            8.5981
        Dec           0.7078
        Distance   1.065e+08  # distance uncertain!
        Radius     3.873e+04
        AbsMag        -19.07
        Axis    [ -0.0632   0.5605  -0.8257]
        Angle     92.3433
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2618"
}

Galaxy "NGC 2619:UGC 4503:MCG 5-21-2:ZWG 150.8"
{
        Type  "SBc"
        RA            8.6256
        Dec          28.7050
        Distance   1.675e+08  # method: V
        Radius     4.385e+04
        AbsMag        -20.15
        Axis    [  0.9310   0.3212   0.1736]
        Angle     72.1690
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2619"
}

Galaxy "NGC 2620:UGC 4501:MCG 4-21-1:ZWG 120.6"
{
        Type  "S0"
        RA            8.6244
        Dec          24.9469
        Distance   3.656e+08  # method: V
        Radius     1.064e+05
        AbsMag        -20.65
        Axis    [  0.1929   0.9752   0.1083]
        Angle     54.5893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2620"
}

Galaxy "NGC 2621:MCG 4-21-3:ZWG 120.7:NPM 1"
{
        Type  "S0"
        RA            8.6267
        Dec          25.0003
        Distance   2.934e+08  # distance uncertain!
        Radius     3.414e+04
        AbsMag        -19.07
        Axis    [ -0.5444   0.6838  -0.4858]
        Angle     96.3683
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2621"
}

Galaxy "NGC 2622:MCG 4-21-8:MK 1218:ZWG 120.13"
{
        Type  "Sb"
        RA            8.6361
        Dec          24.8953
        Distance   3.981e+08  # method: V
        Radius     4.632e+04
        AbsMag        -20.53
        Axis    [  0.8619   0.4791   0.1659]
        Angle     69.4751
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2622"
}

Galaxy "NGC 2623:UGC 4509:MCG 4-21-9:ZWG 120.15"
{
        Type  "Sb"
        RA            8.6400
        Dec          25.7547
        Distance    2.61e+08  # method: V
        Radius      9.11e+04
        AbsMag        -20.52
        Axis    [  0.6462   0.7052   0.2918]
        Angle     64.3663
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2623"
}

Galaxy "NGC 2624:UGC 4506:MCG 3-22-19:ZWG 89.55"
{
        Type  "S0"
        RA            8.6358
        Dec          19.7261
        Distance   1.851e+08  # distance uncertain!
        Radius     1.615e+04
        AbsMag        -19.07
        Axis    [  1.0000   0.0006   0.0087]
        Angle     88.8483
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2624"
}

Galaxy "NGC 2625:MK 625:ZWG 89.57"
{
        Type  "E0"
        RA            8.6397
        Dec          19.7161
        Distance   2.155e+08  # method: V
        Radius     2.194e+04
        AbsMag         -18.8
        Axis    [  0.8315  -0.0584  -0.5524]
        Angle     88.9899
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2625"
}

Galaxy "NGC 2628:UGC 4519:MCG 4-21-12:ZWG 120.20"
{
        Type  "Sc"
        RA            8.6728
        Dec          23.5397
        Distance   1.749e+08  # method: V
        Radius     2.798e+04
        AbsMag        -19.65
        Axis    [  0.9027  -0.4050  -0.1454]
        Angle     96.1875
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2628"
}

Galaxy "NGC 2629:UGC 4569:MCG 12-9-10:ZWG 331.62"
{
        Type  "S0"
        RA            8.7875
        Dec          72.9856
        Distance   1.675e+08  # method: V
        Radius     3.655e+04
        AbsMag        -20.25
        Axis    [  0.1243   0.9922   0.0045]
        Angle     63.1465
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2629"
}

Galaxy "NGC 2633:UGC 4574:MCG 12-9-13:VV 519"
{
        Type  "SBb"
        RA            8.8011
        Dec          74.0992
        Distance    9.98e+07  # method: V
        Radius     3.338e+04
        AbsMag        -19.63
        Axis    [ -0.4099   0.9048  -0.1156]
        Angle    120.7421
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2633"
}

Galaxy "NGC 2634:UGC 4581:MCG 12-9-15:ZWG 331.66"
{
        Type  "E1"
        RA            8.8069
        Dec          73.9672
        Distance    1.09e+08  # method: S
        Radius     2.695e+04
        AbsMag        -19.82
        Axis    [  0.9181   0.1703  -0.3578]
        Angle     37.4091
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2634"
}

Galaxy "NGC 2634A:UGC 4585:MCG 12-9-16:ZWG 331.68"
{
        Type  "SBc"
        RA            8.8106
        Dec          73.9386
        Distance   9.649e+07  # method: V
        Radius     2.526e+04
        AbsMag        -18.05
        Axis    [  0.0511   0.5672   0.8220]
        Angle     77.1533
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2634A"
}

Galaxy "NGC 2636:UGC 4583:ZWG 331.67:ZWG 332.14"
{
        Type  "E0"
        RA            8.8067
        Dec          73.6717
        Distance   8.793e+07  # method: V
        Radius          5116
        AbsMag        -17.45
        Axis    [  0.6622  -0.7479   0.0465]
        Angle     57.2845
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2636"
}

Galaxy "NGC 2638:UGC 4534:MCG 6-19-16:ZWG 179.18"
{
        Type  "Sa"
        RA            8.7069
        Dec          37.2208
        Distance    1.78e+08  # method: V
        Radius     4.402e+04
        AbsMag        -19.98
        Axis    [  0.4820   0.8066   0.3423]
        Angle     56.8272
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2638"
}

Galaxy "NGC 2639:UGC 4544:MCG 8-16-24:ZWG 237.14"
{
        Type  "Sa"
        RA            8.7269
        Dec          50.2061
        Distance   1.556e+08  # method: V
        Radius     4.073e+04
        AbsMag        -20.79
        Axis    [ -0.2954   0.9327  -0.2069]
        Angle     82.1812
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2639"
}

Galaxy "NGC 2640:ESO 165-2:IRAS 08360-5456"
{
        Type  "S0"
        RA            8.6233
        Dec         -55.1236
        Distance   5.608e+07  # method: V
        Radius     1.795e+04
        AbsMag        -18.48
        Axis    [  0.3779   0.0838  -0.9220]
        Angle    126.8475
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2640"
}

Galaxy "NGC 2641:UGC 4577:MCG 12-9-12:ZWG 331.65"
{
        Type  "S0"
        RA            8.7992
        Dec          72.8964
        Distance   2.125e+08  # distance uncertain!
        Radius     4.019e+04
        AbsMag        -19.07
        Axis    [  0.7613  -0.3811   0.5246]
        Angle     64.5828
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2641"
}

Galaxy "NGC 2642:MCG 1-22-33:IRAS 08382-0356"
{
        Type  "SBc"
        RA            8.6789
        Dec          -4.1222
        Distance   2.096e+08  # method: V
        Radius     6.097e+04
        AbsMag        -20.64
        Axis    [  0.5302   0.3519  -0.7714]
        Angle     90.4324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2642"
}

Galaxy "NGC 2644:UGC 4533:MCG 1-22-16:ZWG 32.52"
{
        Type  "Sc"
        RA            8.6922
        Dec           4.9808
        Distance   1.003e+08  # method: V
        Radius     3.063e+04
        AbsMag        -19.04
        Axis    [  0.9280   0.3310   0.1711]
        Angle    102.5606
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2644"
}

Galaxy "NGC 2646:UGC 4604:MCG 12-9-19:ZWG 332.19"
{
        Type  "S0"
        RA            8.8392
        Dec          73.4628
        Distance   1.688e+08  # method: V
        Radius     3.191e+04
        AbsMag        -20.37
        Axis    [  0.6766  -0.7306   0.0924]
        Angle     57.9731
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2646"
}

Galaxy "NGC 2647:ZWG 89.68:NPM 1"
{
        Type  "E0"
        RA            8.7119
        Dec          19.6511
        Distance   3.631e+08  # distance uncertain!
        Radius     4.225e+04
        AbsMag        -20.13
        Axis    [  0.8958  -0.2938  -0.3336]
        Angle     93.8846
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2647"
}

Galaxy "NGC 2648:UGC 4541:MCG 2-22-5:ZWG 60.35"
{
        Type  "Sa"
        RA            8.7108
        Dec          14.2850
        Distance    1.05e+08  # method: V
        Radius     4.887e+04
        AbsMag        -19.64
        Axis    [ -0.4680   0.7340  -0.4921]
        Angle     70.2650
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2648"
}

Galaxy "NGC 2649:UGC 4555:MCG 6-19-18:ZWG 179.22"
{
        Type  "SBc"
        RA            8.7356
        Dec          34.7175
        Distance   2.017e+08  # method: V
        Radius     4.401e+04
        AbsMag        -20.86
        Axis    [  0.5223   0.6249  -0.5803]
        Angle     66.3938
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2649"
}

Galaxy "NGC 2650:UGC 4603:MCG 12-9-20:ZWG 332.18"
{
        Type  "SBb"
        RA            8.8328
        Dec          70.2994
        Distance   1.761e+08  # method: V
        Radius     4.099e+04
        AbsMag        -19.56
        Axis    [  0.6520   0.4922   0.5767]
        Angle     46.0169
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2650"
}

Galaxy "NGC 2651:ZWG 61.1:KARA 282"
{
        Type  "S0"
        RA            8.7319
        Dec          11.7711
        Distance   2.555e+08  # distance uncertain!
        Radius      2.23e+04
        AbsMag        -19.07
        Axis    [  0.2250   0.6223  -0.7497]
        Angle     78.3407
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2651"
}

Galaxy "NGC 2654:UGC 4605:MCG 10-13-17:ZWG 288.6"
{
        Type  "SBb"
        RA            8.8200
        Dec          60.2208
        Distance   6.573e+07  # method: V
        Radius     4.015e+04
        AbsMag        -18.82
        Axis    [  0.2573   0.5617   0.7863]
        Angle     73.3175
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2654"
}

Galaxy "NGC 2655:UGC 4637:MCG 13-7-10:ZWG 349.33"
{
        Type  "SBa"
        RA            8.9269
        Dec          78.2236
        Distance   6.464e+07  # method: V
        Radius     4.607e+04
        AbsMag        -20.48
        Axis    [  0.2813   0.9056   0.3173]
        Angle     49.6344
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2655"
}

Galaxy "NGC 2656:MCG 9-15-25:ZWG 264.15:VV 703"
{
        Type  "S0"
        RA            8.7981
        Dec          53.8761
        Distance   6.204e+08  # method: V
        Radius     9.023e+04
        AbsMag         -21.5
        Axis    [  0.8085  -0.5876  -0.0313]
        Angle     71.5900
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2656"
}

Galaxy "NGC 2657:UGC 4573:MCG 2-23-2:ZWG 61.6"
{
        Type  "Irr"
        RA            8.7542
        Dec           9.6458
        Distance   1.999e+08  # method: V
        Radius     2.908e+04
        AbsMag        -20.14
        Axis    [ -0.1469   0.6019  -0.7849]
        Angle    104.2700
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2657"
}

Galaxy "NGC 2661:UGC 4584:MCG 2-23-4:ZWG 61.8"
{
        Type  "Sc"
        RA            8.7664
        Dec          12.6197
        Distance   1.984e+08  # method: V
        Radius     4.039e+04
        AbsMag        -20.22
        Axis    [  0.8184   0.2226  -0.5298]
        Angle     79.8503
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2661"
}

Galaxy "NGC 2662:MCG 2-23-2:NPM 1"
{
        Type  "E0"
        RA            8.7589
        Dec         -15.1211
        Distance   1.995e+08  # distance uncertain!
        Radius     3.483e+04
        AbsMag        -20.13
        Axis    [  0.9222  -0.2925  -0.2528]
        Angle    132.0952
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2662"
}

Galaxy "NGC 2663:ESO 371-14:MCG 6-20-1"
{
        Type  "E0"
        RA            8.7522
        Dec         -33.7950
        Distance   9.674e+07  # method: T-F
        Radius     4.924e+04
        AbsMag        -20.46
        Axis    [  0.3113   0.0921  -0.9458]
        Angle    140.6939
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2663"
}

Galaxy "NGC 2665:ESO 563-19:MCG 3-23-4:UGCA 144"
{
        Type  "SBa"
        RA            8.7667
        Dec         -19.3033
        Distance   1.065e+08  # distance uncertain!
        Radius     3.099e+04
        AbsMag        -19.07
        Axis    [ -0.1010   0.3652  -0.9254]
        Angle     94.6224
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2665"
}

Galaxy "NGC 2667:NGC 2667A:IC 2410:MCG 3-23-7"
{
        Type  "S0"
        RA            8.8075
        Dec          19.0197
        Distance    2.03e+08  # distance uncertain!
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.5724   0.8196  -0.0263]
        Angle     55.2889
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2667"
}

Galaxy "NGC 2668:UGC 4616:MCG 6-20-7:ZWG 180.13"
{
        Type  "SBb"
        RA            8.8228
        Dec          36.7108
        Distance   3.504e+08  # method: V
        Radius     7.646e+04
        AbsMag        -20.26
        Axis    [ -0.4003   0.8288  -0.3910]
        Angle     87.9792
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2668"
}

Galaxy "NGC 2672:UGC 4619:MCG 3-23-10:ZWG 90.19"
{
        Type  "E1"
        RA            8.8225
        Dec          19.0744
        Distance   1.746e+08  # method: T-F
        Radius     7.619e+04
        AbsMag        -21.04
        Axis    [  0.2954   0.4654  -0.8343]
        Angle    104.3862
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2672"
}

Galaxy "NGC 2673:UGC 4620:MCG 3-23-11:ZWG 90.19"
{
        Type  "E0"
        RA            8.8233
        Dec          19.0747
        Distance   1.746e+08  # method: T-F
        Radius     3.048e+04
        AbsMag        -19.64
        Axis    [  0.8843  -0.4275  -0.1880]
        Angle    101.3412
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2673"
}

Galaxy "NGC 2674:NPM 1"
{
        Type  "Sa"
        RA            8.8203
        Dec         -14.2936
        Distance   3.072e+08  # distance uncertain!
        Radius     2.681e+04
        AbsMag        -19.07
        Axis    [  0.7684   0.4704  -0.4340]
        Angle     80.2381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2674"
}

Galaxy "NGC 2675:UGC 4629:MCG 9-15-37:ZWG 264.21"
{
        Type  "E0"
        RA            8.8681
        Dec          53.6172
        Distance   4.246e+08  # method: V
        Radius     9.262e+04
        AbsMag        -21.37
        Axis    [  0.6280   0.4569  -0.6300]
        Angle     63.1513
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2675"
}

Galaxy "NGC 2676:UGC 4627:MCG 8-16-32:ZWG 237.22"
{
        Type  "S0"
        RA            8.8597
        Dec          47.5583
        Distance   2.798e+08  # method: V
        Radius     4.884e+04
        AbsMag        -20.27
        Axis    [  0.8276  -0.5576  -0.0641]
        Angle     77.0325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2676"
}

Galaxy "NGC 2677:MCG 3-23-12:ZWG 90.21:NPM 1"
{
        Type  "S0"
        RA            8.8336
        Dec          19.0103
        Distance   2.676e+08  # distance uncertain!
        Radius     2.335e+04
        AbsMag        -19.07
        Axis    [ -0.5598   0.6393  -0.5272]
        Angle     92.1516
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2677"
}

Galaxy "NGC 2679:UGC 4632:MCG 5-21-14:ZWG 150.41"
{
        Type  "S0"
        RA            8.8589
        Dec          30.8650
        Distance   1.007e+08  # method: V
        Radius     2.343e+04
        AbsMag        -18.35
        Axis    [  0.9746  -0.1471   0.1688]
        Angle     89.5497
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2679"
}

Galaxy "NGC 2680:UGC 4632:MCG 5-21-14:ZWG 150.41"
{
        Type  "E0"
        RA            8.8592
        Dec          30.8658
        Distance   4.366e+08  # distance uncertain!
        Radius      1.27e+04
        AbsMag        -20.13
        Axis    [  0.8593  -0.4869  -0.1568]
        Angle     91.2420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2680"
}

Galaxy "NGC 2681:UGC 4645:MCG 9-15-41:ZWG 264.26"
{
        Type  "SBa"
        RA            8.8922
        Dec          51.3131
        Distance   5.616e+07  # method: S
        Radius     2.941e+04
        AbsMag        -20.08
        Axis    [  0.9995   0.0079   0.0316]
        Angle     53.8470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2681"
}

Galaxy "NGC 2683:UGC 4641:MCG 6-20-11:ZWG 180.17"
{
        Type  "Sb"
        RA            8.8781
        Dec          33.4200
        Distance    2.52e+07  # method: S
        Radius     3.409e+04
        AbsMag        -18.94
        Axis    [  0.6867   0.5131   0.5150]
        Angle     74.4381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2683"
}

Galaxy "NGC 2684:UGC 4662:MCG 8-16-35:ZWG 237.24"
{
        Type  "Sc"
        RA            8.9147
        Dec          49.1603
        Distance   1.369e+08  # method: V
        Radius     1.793e+04
        AbsMag        -19.32
        Axis    [  0.9560   0.0161   0.2928]
        Angle     62.8398
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2684"
}

Galaxy "NGC 2685:UGC 4666:MCG 10-13-39:ZWG 288.12"
{
        Type  "SBa"
        RA            8.9261
        Dec          58.7347
        Distance   4.544e+07  # method: V
        Radius      3.04e+04
        AbsMag        -18.62
        Axis    [  0.7379   0.2528   0.6258]
        Angle     62.3120
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2685"
}

Galaxy "NGC 2686-1:NGC 2686A:MCG 8-16-36:VV 765"
{
        Type  "E0"
        RA            8.9161
        Dec          49.1425
        Distance   6.026e+08  # distance uncertain!
        Radius     4.382e+04
        AbsMag        -20.13
        Axis    [  0.8323   0.0575  -0.5513]
        Angle     59.7158
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2686-1"
}

Galaxy "NGC 2686-2:NGC 2686B:MCG 8-16-37:VV 765"
{
        Type  "E0"
        RA            8.9167
        Dec          49.1422
        Distance   9.551e+08  # distance uncertain!
        Radius     4.167e+04
        AbsMag        -20.13
        Axis    [  0.8858  -0.1684  -0.4324]
        Angle     60.5582
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2686-2"
}

Galaxy "NGC 2687-1:NGC 2687A:MCG 8-16-38:VV 765"
{
        Type  "S0"
        RA            8.9181
        Dec          49.1561
        Distance   8.081e+08  # distance uncertain!
        Radius     2.351e+04
        AbsMag        -19.07
        Axis    [  0.7899   0.3155   0.5259]
        Angle     64.6105
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2687-1"
}

Galaxy "NGC 2687-2:NGC 2687B:MCG 8-16-39:VV 765"
{
        Type  "S0"
        RA            8.9181
        Dec          49.1561
        Distance   4.241e+08  # distance uncertain!
        Radius      1.85e+04
        AbsMag        -19.07
        Axis    [  0.9079   0.0911   0.4093]
        Angle     66.2396
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2687-2"
}

Galaxy "NGC 2688:MCG 8-16-40:NPM 1"
{
        Type  "S0"
        RA            8.9197
        Dec          49.1225
        Distance   4.869e+08  # distance uncertain!
        Radius     2.125e+04
        AbsMag        -19.07
        Axis    [  0.2468   0.9688  -0.0208]
        Angle     52.6846
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2688"
}

Galaxy "NGC 2689"
{
        Type  "S0"
        RA            8.9236
        Dec          49.1153
        Distance    6.13e+08  # distance uncertain!
        Radius     2.675e+04
        AbsMag        -19.07
        Axis    [  0.1552   0.9857  -0.0657]
        Angle     55.2467
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2689"
}

Galaxy "NGC 2690:UGC 4647:MCG 0-23-8:ZWG 5.20"
{
        Type  "Sb"
        RA            8.8772
        Dec          -2.6036
        Distance   1.404e+08  # distance uncertain!
        Radius     3.881e+04
        AbsMag        -19.07
        Axis    [  0.8971   0.4217   0.1318]
        Angle    102.7885
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2690"
}

Galaxy "NGC 2691:UGC 4664:MCG 7-18-64:MK 391"
{
        Type  "Sa"
        RA            8.9128
        Dec          39.5392
        Distance   1.894e+08  # method: V
        Radius     2.479e+04
        AbsMag        -19.92
        Axis    [ -0.4920   0.7984  -0.3472]
        Angle     94.4436
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2691"
}

Galaxy "NGC 2692:UGC 4675:MCG 9-15-57:ZWG 264.36"
{
        Type  "SBb"
        RA            8.9492
        Dec          52.0658
        Distance    1.89e+08  # method: V
        Radius     3.573e+04
        AbsMag        -19.71
        Axis    [ -0.5768   0.8064  -0.1301]
        Angle     96.7679
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2692"
}

Galaxy "NGC 2693:UGC 4674:MCG 9-15-55:ZWG 264.35"
{
        Type  "E1"
        RA            8.9497
        Dec          51.3478
        Distance   2.127e+08  # method: T-F
        Radius     8.044e+04
        AbsMag        -21.37
        Axis    [  0.0393   0.8307  -0.5553]
        Angle    119.2801
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2693"
}

Galaxy "NGC 2694:MCG 9-15-56:ZWG 264.34:NPM 1"
{
        Type  "E1"
        RA            8.9497
        Dec          51.3325
        Distance   2.391e+08  # method: V
        Radius     4.172e+04
        AbsMag        -18.62
        Axis    [  0.7854  -0.6135  -0.0820]
        Angle     74.9505
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2694"
}

Galaxy "NGC 2695:MCG 0-23-10:ZWG 5.25"
{
        Type  "S0"
        RA            8.9075
        Dec          -3.0669
        Distance   1.055e+08  # method: S
        Radius      2.61e+04
        AbsMag        -19.65
        Axis    [ -0.4622   0.4599  -0.7582]
        Angle    102.0301
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2695"
}

Galaxy "NGC 2696:MCG 1-23-4:NPM 1"
{
        Type  "E0"
        RA            8.8450
        Dec          -5.0094
        Distance   2.512e+08  # distance uncertain!
        Radius      4.75e+04
        AbsMag        -20.13
        Axis    [  0.9103  -0.3358  -0.2420]
        Angle    123.0724
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2696"
}

Galaxy "NGC 2697:MCG 0-23-11:ZWG 5.27:IRAS 08524-0247"
{
        Type  "Sa"
        RA            8.9164
        Dec          -2.9878
        Distance   1.065e+08  # distance uncertain!
        Radius     2.789e+04
        AbsMag        -19.07
        Axis    [ -0.0298   0.5849  -0.8106]
        Angle     71.6922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2697"
}

Galaxy "NGC 2698:MCG 0-23-12:ZWG 5.30"
{
        Type  "Sa"
        RA            8.9267
        Dec          -3.1842
        Distance   1.065e+08  # distance uncertain!
        Radius     2.324e+04
        AbsMag        -19.07
        Axis    [  0.4148   0.7678  -0.4883]
        Angle     54.7430
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2698"
}

Galaxy "NGC 2699:MCG 0-23-14:ZWG 5.33:ARAK 187"
{
        Type  "E0"
        RA            8.9300
        Dec          -3.1272
        Distance   8.779e+07  # method: S
        Radius     1.405e+04
        AbsMag        -18.55
        Axis    [  0.7861  -0.1181  -0.6068]
        Angle    110.7864
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2699"
}

Galaxy "NGC 2701:UGC 4695:MCG 9-15-63:ZWG 264.43"
{
        Type  "SBc"
        RA            8.9847
        Dec          53.7706
        Distance   1.653e+08  # method: T-F
        Radius     5.289e+04
        AbsMag        -20.82
        Axis    [  0.9086  -0.0280   0.4168]
        Angle     65.2461
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2701"
}

Galaxy "NGC 2704:IC 2424:UGC 4678:MCG 7-19-5"
{
        Type  "SBb"
        RA            8.9464
        Dec          39.3825
        Distance   3.316e+08  # method: V
        Radius     4.823e+04
        AbsMag        -20.74
        Axis    [  0.8459  -0.5232  -0.1029]
        Angle     84.2380
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2704"
}

Galaxy "NGC 2706:UGC 4680:MCG 0-23-17:ZWG 5.36"
{
        Type  "Sc"
        RA            8.9367
        Dec          -2.5633
        Distance   1.223e+08  # distance uncertain!
        Radius     3.202e+04
        AbsMag        -19.07
        Axis    [ -0.6115   0.4489  -0.6515]
        Angle     76.4415
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2706"
}

Galaxy "NGC 2708:NGC 2727:MCG 0-23-15:ZWG 5.34"
{
        Type  "Sb"
        RA            8.9353
        Dec          -3.3606
        Distance   1.043e+08  # method: V
        Radius     4.095e+04
        AbsMag        -19.72
        Axis    [  0.9559   0.2893  -0.0500]
        Angle     97.3689
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2708"
}

Galaxy "NGC 2709:MCG 0-23-16:ZWG 5.35:NPM 1"
{
        Type  "S0"
        RA            8.9367
        Dec          -3.2425
        Distance   1.851e+08  # distance uncertain!
        Radius     2.154e+04
        AbsMag        -19.07
        Axis    [  0.6366   0.4109  -0.6526]
        Angle     76.2749
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2709"
}

Galaxy "NGC 2710:UGC 4705:MCG 9-15-66:ZWG 264.46"
{
        Type  "SBb"
        RA            8.9967
        Dec          55.7058
        Distance   1.211e+08  # method: V
        Radius     3.524e+04
        AbsMag        -19.15
        Axis    [ -0.2544   0.9651   0.0616]
        Angle     69.5520
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2710"
}

Galaxy "NGC 2711:UGC 4688:MCG 3-23-20:ZWG 90.42"
{
        Type  "SBc"
        RA            8.9564
        Dec          17.2881
        Distance   2.907e+08  # method: V
        Radius     3.805e+04
        AbsMag        -20.15
        Axis    [ -0.4634   0.6466  -0.6059]
        Angle     96.6934
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2711"
}

Galaxy "NGC 2712:UGC 4708:MCG 8-17-3:ZWG 238.1"
{
        Type  "SBb"
        RA            8.9917
        Dec          44.9139
        Distance   9.078e+07  # method: V
        Radius     3.697e+04
        AbsMag        -19.52
        Axis    [ -0.5593   0.7703  -0.3062]
        Angle    105.9092
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2712"
}

Galaxy "NGC 2713:UGC 4691:MCG 1-23-6:ZWG 33.28"
{
        Type  "SBb"
        RA            8.9556
        Dec           2.9214
        Distance   1.909e+08  # method: V
        Radius     9.998e+04
        AbsMag        -21.14
        Axis    [  0.2242   0.7885  -0.5728]
        Angle     54.3681
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2713"
}

Galaxy "NGC 2714:ESO 125-7"
{
        Type  "E0"
        RA            8.8914
        Dec         -59.2175
        Distance   2.188e+08  # distance uncertain!
        Radius       3.5e+04
        AbsMag        -20.13
        Axis    [  0.9290  -0.1687  -0.3295]
        Angle    173.1771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2714"
}

Galaxy "NGC 2715:UGC 4759:MCG 13-7-15:ZWG 350.12"
{
        Type  "SBc"
        RA            9.1347
        Dec          78.0858
        Distance   6.098e+07  # method: V
        Radius     4.257e+04
        AbsMag        -19.56
        Axis    [  0.5315   0.0016   0.8471]
        Angle     84.8720
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2715"
}

Galaxy "NGC 2716:UGC 4692:MCG 1-23-7:ZWG 33.29"
{
        Type  "SBa"
        RA            8.9597
        Dec           3.0903
        Distance   1.734e+08  # method: V
        Radius     3.279e+04
        AbsMag        -20.53
        Axis    [  0.9723   0.1296  -0.1945]
        Angle     91.8030
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2716"
}

Galaxy "NGC 2717:ESO 496-21:MCG 4-21-15:AM 0854-242"
{
        Type  "S0"
        RA            8.9503
        Dec         -24.6739
        Distance   9.715e+07  # distance uncertain!
        Radius     2.967e+04
        AbsMag        -19.07
        Axis    [  0.9688   0.1511  -0.1967]
        Angle    124.2200
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2717"
}

Galaxy "NGC 2718:UGC 4707:MCG 1-23-15:MK 703"
{
        Type  "SBb"
        RA            8.9806
        Dec           6.2939
        Distance   1.871e+08  # method: V
        Radius     5.716e+04
        AbsMag        -20.79
        Axis    [  0.9039  -0.3716  -0.2120]
        Angle    112.7179
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2718"
}

Galaxy "NGC 2719:UGC 4718:MCG 6-20-17:ZWG 180.25"
{
        Type  "Irr"
        RA            9.0042
        Dec          35.7278
        Distance   1.531e+08  # method: V
        Radius     2.449e+04
        AbsMag        -19.46
        Axis    [ -0.4381   0.8981  -0.0389]
        Angle     64.1329
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2719"
}

Galaxy "NGC 2719A:MCG 6-20-18:ARP 202:KCPG 181B"
{
        Type  "Irr"
        RA            9.0042
        Dec          35.7206
        Distance   1.495e+08  # method: V
        Radius          8697
        AbsMag        -18.81
        Axis    [ -0.1378   0.8685  -0.4761]
        Angle     75.5204
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2719A"
}

Galaxy "NGC 2720:UGC 4710:MCG 2-23-16:ZWG 61.34"
{
        Type  "S0"
        RA            8.9856
        Dec          11.1497
        Distance   1.341e+08  # distance uncertain!
        Radius     2.146e+04
        AbsMag        -19.07
        Axis    [  0.8980  -0.3923  -0.1995]
        Angle    108.4660
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2720"
}

Galaxy "NGC 2721:MCG 1-23-15"
{
        Type  "Sc"
        RA            8.9822
        Dec          -4.9014
        Distance   2.098e+08  # method: T-F
        Radius     7.323e+04
        AbsMag        -21.04
        Axis    [ -0.2935   0.4927  -0.8192]
        Angle     85.6866
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2721"
}

Galaxy "NGC 2722:NGC 2733:MCG 1-23-14:IRAS 08562-0330"
{
        Type  "Sc"
        RA            8.9794
        Dec          -3.7097
        Distance   1.507e+08  # method: T-F
        Radius     4.384e+04
        AbsMag        -19.82
        Axis    [  0.8023   0.3928  -0.4495]
        Angle     76.5648
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2722"
}

Galaxy "NGC 2723:UGC 4723:MCG 1-23-17:ZWG 33.39"
{
        Type  "S0"
        RA            9.0039
        Dec           3.1783
        Distance    1.82e+08  # method: V
        Radius     2.118e+04
        AbsMag        -19.53
        Axis    [  0.9056  -0.3618  -0.2215]
        Angle    115.5606
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2723"
}

Galaxy "NGC 2724:UGC 4726:MCG 6-20-19:ZWG 180.27"
{
        Type  "SBc"
        RA            9.0169
        Dec          35.7625
        Distance   1.558e+08  # method: V
        Radius     4.079e+04
        AbsMag        -18.99
        Axis    [  0.9519  -0.2802   0.1240]
        Angle     86.3886
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2724"
}

Galaxy "NGC 2725:UGC 4732:MCG 2-23-18:ZWG 61.38"
{
        Type  "Irr"
        RA            9.0175
        Dec          11.0975
        Distance   1.068e+08  # method: V
        Radius     1.088e+04
        AbsMag        -18.28
        Axis    [  0.8810   0.2065  -0.4257]
        Angle     76.6078
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2725"
}

Galaxy "NGC 2726:UGC 4750:MCG 10-13-54:ZWG 288.18"
{
        Type  "Sa"
        RA            9.0822
        Dec          59.9333
        Distance   7.402e+07  # method: V
        Radius     1.723e+04
        AbsMag        -18.48
        Axis    [  0.0815   0.7799   0.6205]
        Angle     61.3421
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2726"
}

Galaxy "NGC 2728:UGC 4738:MCG 2-23-20:ZWG 61.42"
{
        Type  "Sb"
        RA            9.0278
        Dec          11.0836
        Distance   2.733e+08  # method: V
        Radius     4.372e+04
        AbsMag        -20.02
        Axis    [  0.8611   0.3657  -0.3532]
        Angle     69.4038
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2728"
}

Galaxy "NGC 2729:UGC 4737:MCG 1-23-18:ZWG 33.46"
{
        Type  "S0"
        RA            9.0244
        Dec           3.7211
        Distance   1.281e+08  # distance uncertain!
        Radius      1.49e+04
        AbsMag        -19.07
        Axis    [  0.9933   0.1020   0.0548]
        Angle    106.7852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2729"
}

Galaxy "NGC 2730:UGC 4743:MCG 3-23-28:ZWG 90.57"
{
        Type  "Irr"
        RA            9.0375
        Dec          16.8383
        Distance   1.859e+08  # method: V
        Radius     4.597e+04
        AbsMag        -20.18
        Axis    [  0.6707   0.5344  -0.5143]
        Angle     61.8653
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2730"
}

Galaxy "NGC 2731:UGC 4741:MCG 2-23-21:ZWG 33.48"
{
        Type  "Sc"
        RA            9.0356
        Dec           8.3006
        Distance   1.301e+08  # method: V
        Radius     1.514e+04
        AbsMag         -18.6
        Axis    [  0.7755   0.5053  -0.3784]
        Angle     64.4755
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2731"
}

Galaxy "NGC 2732:UGC 4818:MCG 13-7-16:ZWG 350.13"
{
        Type  "S0"
        RA            9.2236
        Dec          79.1878
        Distance   9.038e+07  # method: V
        Radius      2.76e+04
        AbsMag        -19.31
        Axis    [  0.2263   0.4805   0.8473]
        Angle     65.2699
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2732"
}

Galaxy "NGC 2734:NPM 1"
{
        Type  "E0"
        RA            9.0503
        Dec          16.8642
        Distance   6.919e+08  # distance uncertain!
        Radius     6.038e+04
        AbsMag        -20.13
        Axis    [  0.5563   0.2050  -0.8053]
        Angle     92.4808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2734"
}

Galaxy "NGC 2735:UGC 4744:MCG 4-22-2:ZWG 121.3"
{
        Type  "SBb"
        RA            9.0439
        Dec          25.9347
        Distance   1.224e+08  # method: V
        Radius     2.136e+04
        AbsMag        -18.77
        Axis    [  0.2757   0.9607   0.0321]
        Angle     48.7299
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2735"
}

Galaxy "NGC 2735A:MCG 4-22-3:ZWG 121.3:VV 40"
{
        Type  "Irr"
        RA            9.0447
        Dec          25.9389
        Distance   5.249e+08  # distance uncertain!
        Radius     3.053e+04
        AbsMag        -20.13
        Axis    [  0.9475   0.0468   0.3163]
        Angle    101.3647
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2735A"
}

Galaxy "NGC 2737:UGC 4751:MCG 4-22-5:ZWG 121.9"
{
        Type  "Sb"
        RA            9.0664
        Dec          21.9064
        Distance    2.03e+08  # distance uncertain!
        Radius     2.657e+04
        AbsMag        -19.07
        Axis    [  0.8043   0.5895   0.0744]
        Angle     59.2794
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2737"
}

Galaxy "NGC 2738:UGC 4752:MCG 4-22-6:ZWG 121.10"
{
        Type  "Sc"
        RA            9.0667
        Dec          21.9683
        Distance   1.527e+08  # method: V
        Radius     3.109e+04
        AbsMag        -19.45
        Axis    [  0.8367   0.5322   0.1293]
        Angle     62.8248
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2738"
}

Galaxy "NGC 2739:MCG 9-15-85:ZWG 264.59:KCPG 185A"
{
        Type  "Sb"
        RA            9.1006
        Dec          51.7444
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [ -0.0450   0.8282   0.5586]
        Angle     61.9201
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2739"
}

Galaxy "NGC 2740:MCG 9-15-86:ZWG 264.60:KCPG 185B"
{
        Type  "Sb"
        RA            9.1014
        Dec          51.7356
        Distance   4.104e+08  # method: V
        Radius     5.969e+04
        AbsMag         -20.5
        Axis    [  0.9935   0.1132   0.0075]
        Angle     49.6808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2740"
}

Galaxy "NGC 2741:MK 1221:IRAS 09004+1827"
{
        Type  "S0"
        RA            9.0544
        Dec          18.2606
        Distance   3.369e+08  # distance uncertain!
        Radius      1.96e+04
        AbsMag        -19.07
        Axis    [  0.6359   0.7436  -0.2065]
        Angle     53.1233
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2741"
}

Galaxy "NGC 2742:NGC 2816:UGC 4779:MCG 10-13-57"
{
        Type  "Sc"
        RA            9.1258
        Dec          60.4794
        Distance   8.625e+07  # method: T-F
        Radius     3.763e+04
        AbsMag        -20.01
        Axis    [  0.1966   0.8539   0.4818]
        Angle     53.6615
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2742"
}

Galaxy "NGC 2742A:UGC 4803:MCG 10-13-60:ZWG 288.22"
{
        Type  "SBb"
        RA            9.1658
        Dec          62.2469
        Distance   3.493e+08  # method: V
        Radius     8.129e+04
        AbsMag        -21.15
        Axis    [  0.0691   0.8068   0.5867]
        Angle     59.5764
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2742A"
}

Galaxy "NGC 2743:UGC 4760:MCG 4-22-9:ZWG 121.13"
{
        Type  "Irr"
        RA            9.0817
        Dec          25.0042
        Distance   1.475e+08  # method: V
        Radius     2.361e+04
        AbsMag        -18.98
        Axis    [  0.2781   0.7927  -0.5424]
        Angle     58.4258
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2743"
}

Galaxy "NGC 2744:UGC 4757:MCG 3-23-31:ZWG 90.65"
{
        Type  "SBb"
        RA            9.0775
        Dec          18.4642
        Distance   1.676e+08  # method: V
        Radius     3.899e+04
        AbsMag        -19.65
        Axis    [  0.0830   0.7341  -0.6739]
        Angle     67.7135
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2744"
}

Galaxy "NGC 2744A:VV 612"
{
        Type  "Irr"
        RA            9.0772
        Dec          18.4561
        Distance   6.919e+08  # distance uncertain!
        Radius     2.013e+04
        AbsMag        -20.13
        Axis    [  0.8810  -0.4359  -0.1839]
        Angle    102.5494
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2744A"
}

Galaxy "NGC 2745:ZWG 90.64:NPM 1"
{
        Type  "S0"
        RA            9.0775
        Dec          18.2578
        Distance    2.44e+08  # distance uncertain!
        Radius      1.42e+04
        AbsMag        -19.07
        Axis    [  0.9647   0.0807   0.2506]
        Angle    104.9288
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2745"
}

Galaxy "NGC 2746:UGC 4770:MCG 6-20-23:ZWG 180.32"
{
        Type  "SBa"
        RA            9.0997
        Dec          35.3772
        Distance   3.302e+08  # method: V
        Radius     7.683e+04
        AbsMag        -20.93
        Axis    [  0.1378   0.7507  -0.6461]
        Angle     78.3026
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2746"
}

Galaxy "NGC 2747:ZWG 90.70:NPM 1"
{
        Type  "S0"
        RA            9.0883
        Dec          18.4428
        Distance    2.44e+08  # distance uncertain!
        Radius      1.42e+04
        AbsMag        -19.07
        Axis    [ -0.5762   0.6337  -0.5162]
        Angle     88.2033
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2747"
}

Galaxy "NGC 2748:UGC 4825:MCG 13-7-19:ZWG 350.14"
{
        Type  "Sc"
        RA            9.2286
        Dec          76.4758
        Distance    7.42e+07  # method: T-F
        Radius     3.346e+04
        AbsMag        -19.48
        Axis    [  0.4704   0.1493   0.8697]
        Angle     75.9037
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2748"
}

Galaxy "NGC 2749:UGC 4763:MCG 3-23-36:ZWG 90.69"
{
        Type  "E3"
        RA            9.0892
        Dec          18.3136
        Distance   2.027e+08  # method: T-F
        Radius     5.012e+04
        AbsMag        -21.27
        Axis    [  0.6692   0.0793  -0.7389]
        Angle     88.7726
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2749"
}

Galaxy "NGC 2750:UGC 4769:MCG 4-22-12:ZWG 121.17"
{
        Type  "Sc"
        RA            9.0967
        Dec          25.4375
        Distance   1.326e+08  # method: V
        Radius     4.244e+04
        AbsMag        -20.35
        Axis    [  0.6604   0.5080  -0.5530]
        Angle     60.9331
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2750"
}

Galaxy "NGC 2751:MCG 3-23-37:ZWG 90.71"
{
        Type  "Sc"
        RA            9.0922
        Dec          18.2619
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [ -0.0844   0.6710  -0.7367]
        Angle     88.1490
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2751"
}

Galaxy "NGC 2752:UGC 4772:MCG 3-23-38:ZWG 90.72"
{
        Type  "SBb"
        RA            9.0950
        Dec          18.3397
        Distance   1.851e+08  # distance uncertain!
        Radius     4.846e+04
        AbsMag        -19.07
        Axis    [  0.7102   0.6421   0.2886]
        Angle     65.1133
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2752"
}

Galaxy "NGC 2753-1:MCG 4-22-15:ZWG 121.20:KCPG 187"
{
        Type  "E0"
        RA            9.1189
        Dec          25.3411
        Distance   1.399e+08  # method: V
        Radius     1.628e+04
        AbsMag        -17.66
        Axis    [  0.8634  -0.3967  -0.3117]
        Angle     90.7388
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2753-1"
}

Galaxy "NGC 2753-2:MCG 4-22-15:ZWG 121.20"
{
        Type  "E0"
        RA            9.1189
        Dec          25.3442
        Distance   3.468e+08  # distance uncertain!
        Radius     1.513e+04
        AbsMag        -20.13
        Axis    [  0.8491  -0.4945  -0.1859]
        Angle     97.4476
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2753-2"
}

Galaxy "NGC 2754:ESO 564-16:NPM 1"
{
        Type  "S0"
        RA            9.0864
        Dec         -19.0847
        Distance    2.44e+08  # distance uncertain!
        Radius     2.839e+04
        AbsMag        -19.07
        Axis    [ -0.3897   0.3123  -0.8664]
        Angle     89.7779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2754"
}

Galaxy "NGC 2755:UGC 4789:MCG 7-19-34:ZWG 209.30"
{
        Type  "Sb"
        RA            9.1328
        Dec          41.7086
        Distance    3.51e+08  # method: V
        Radius     6.126e+04
        AbsMag        -20.96
        Axis    [ -0.1636   0.9360  -0.3118]
        Angle     67.8779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2755"
}

Galaxy "NGC 2756:UGC 4796:MCG 9-15-98:ZWG 264.67"
{
        Type  "Sb"
        RA            9.1500
        Dec          53.8486
        Distance   1.888e+08  # method: V
        Radius     4.669e+04
        AbsMag        -20.61
        Axis    [  0.8637  -0.2564   0.4338]
        Angle     84.3444
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2756"
}

Galaxy "NGC 2758:ESO 564-20:MCG 3-23-19:IRAS 09032-1850"
{
        Type  "Sc"
        RA            9.0919
        Dec         -19.0428
        Distance   1.007e+08  # method: T-F
        Radius     2.783e+04
        AbsMag        -18.45
        Axis    [  0.9015   0.4314  -0.0346]
        Angle    109.6425
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2758"
}

Galaxy "NGC 2759:UGC 4795:MCG 6-20-33:ZWG 180.42"
{
        Type  "S0"
        RA            9.1436
        Dec          37.6214
        Distance   3.244e+08  # method: V
        Radius     4.718e+04
        AbsMag        -20.99
        Axis    [  0.9388   0.3298   0.0989]
        Angle     56.4113
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2759"
}

Galaxy "NGC 2761:MCG 3-23-41:ZWG 91.1:ZWG 90.77"
{
        Type  "S0"
        RA            9.1250
        Dec          18.4350
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [ -0.4434   0.6687  -0.5968]
        Angle     90.8880
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2761"
}

Galaxy "NGC 2762:MCG 8-17-45:ZWG 264.72"
{
        Type  "S0"
        RA            9.1650
        Dec          50.4183
        Distance   4.241e+08  # distance uncertain!
        Radius      1.85e+04
        AbsMag        -19.07
        Axis    [  0.8940  -0.1357   0.4269]
        Angle     78.9854
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2762"
}

Galaxy "NGC 2763:MCG 2-23-10:IRAS 09044-1517"
{
        Type  "SBc"
        RA            9.1136
        Dec         -15.4992
        Distance   1.126e+08  # method: T-F
        Radius     3.766e+04
        AbsMag        -19.99
        Axis    [  0.1715   0.3263  -0.9296]
        Angle     94.2681
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2763"
}

Galaxy "NGC 2764:UGC 4794:MCG 4-22-17:ZWG 121.24"
{
        Type  "S0"
        RA            9.1381
        Dec          21.4431
        Distance   1.353e+08  # method: V
        Radius     2.951e+04
        AbsMag        -19.49
        Axis    [  0.9914   0.0388   0.1249]
        Angle     88.7594
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2764"
}

Galaxy "NGC 2765:UGC 4791:MCG 1-24-1:ZWG 33.61"
{
        Type  "S0"
        RA            9.1267
        Dec           3.3928
        Distance   1.869e+08  # method: V
        Radius     5.709e+04
        AbsMag        -20.59
        Axis    [  0.2569   0.7071  -0.6588]
        Angle     56.5600
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2765"
}

Galaxy "NGC 2766:UGC 4801:MCG 5-22-9:ZWG 151.14"
{
        Type  "Sb"
        RA            9.1464
        Dec          29.8653
        Distance   2.007e+08  # method: V
        Radius     4.086e+04
        AbsMag        -19.44
        Axis    [ -0.3650   0.9093  -0.1998]
        Angle     59.7672
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2766"
}

Galaxy "NGC 2767:UGC 4813:MCG 8-17-46:ZWG 264.75"
{
        Type  "S0"
        RA            9.1697
        Dec          50.4019
        Distance   2.314e+08  # method: V
        Radius      3.03e+04
        AbsMag        -19.65
        Axis    [ -0.3598   0.8647  -0.3505]
        Angle    104.9019
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2767"
}

Galaxy "NGC 2768:UGC 4821:MCG 10-13-65:ZWG 288.26"
{
        Type  "E6"
        RA            9.1936
        Dec          60.0364
        Distance   7.302e+07  # method: S
        Radius     6.797e+04
        AbsMag        -20.85
        Axis    [  0.4949   0.6236  -0.6051]
        Angle     63.4895
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2768"
}

Galaxy "NGC 2769:UGC 4816:MCG 8-17-50:ZWG 264.76"
{
        Type  "Sa"
        RA            9.1756
        Dec          50.4336
        Distance   2.259e+08  # method: V
        Radius     5.913e+04
        AbsMag         -20.3
        Axis    [ -0.5821   0.8037   0.1231]
        Angle     79.5376
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2769"
}

Galaxy "NGC 2770:UGC 4806:MCG 6-20-38:ZWG 180.47"
{
        Type  "Sc"
        RA            9.1592
        Dec          33.1242
        Distance   1.222e+08  # method: T-F
        Radius     6.575e+04
        AbsMag        -20.17
        Axis    [ -0.5626   0.8094  -0.1685]
        Angle     70.5162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2770"
}

Galaxy "NGC 2770A:MCG 6-20-36:KUG 0906+333"
{
        Type  "Sa"
        RA            9.1553
        Dec          33.1222
        Distance   3.369e+08  # distance uncertain!
        Radius      2.94e+04
        AbsMag        -19.07
        Axis    [  0.9561  -0.2452   0.1607]
        Angle     91.1266
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2770A"
}

Galaxy "NGC 2771:UGC 4817:MCG 8-17-51:ZWG 264.77"
{
        Type  "SBb"
        RA            9.1775
        Dec          50.3792
        Distance   2.364e+08  # method: V
        Radius     7.909e+04
        AbsMag         -20.6
        Axis    [ -0.1157   0.9272  -0.3563]
        Angle     78.5699
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2771"
}

Galaxy "NGC 2772:ESO 497-14:MCG 4-22-2:AM 0905-232"
{
        Type  "Sb"
        RA            9.1281
        Dec         -23.6194
        Distance   2.171e+08  # method: T-F
        Radius     4.737e+04
        AbsMag        -19.92
        Axis    [ -0.5758   0.1841  -0.7966]
        Angle     76.0728
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2772"
}

Galaxy "NGC 2773:UGC 4815:MCG 1-24-4:ZWG 34.5"
{
        Type  "S0"
        RA            9.1622
        Dec           7.1742
        Distance   2.625e+08  # method: V
        Radius     2.672e+04
        AbsMag        -20.03
        Axis    [  0.6207   0.7119  -0.3285]
        Angle     54.0184
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2773"
}

Galaxy "NGC 2774:MCG 3-24-4:ZWG 91.15"
{
        Type  "S0"
        RA            9.1775
        Dec          18.6967
        Distance   1.851e+08  # distance uncertain!
        Radius     2.423e+04
        AbsMag        -19.07
        Axis    [  0.8730  -0.4497  -0.1888]
        Angle    102.8439
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2774"
}

Galaxy "NGC 2775:UGC 4820:MCG 1-24-5:ZWG 34.6"
{
        Type  "Sb"
        RA            9.1722
        Dec           7.0372
        Distance   7.475e+07  # method: V
        Radius     4.675e+04
        AbsMag         -20.6
        Axis    [ -0.2925   0.5859  -0.7557]
        Angle     89.4334
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2775"
}

Galaxy "NGC 2776:UGC 4838:MCG 8-17-56:ZWG 238.20"
{
        Type  "SBc"
        RA            9.2039
        Dec          44.9547
        Distance   1.276e+08  # method: V
        Radius     5.195e+04
        AbsMag        -20.86
        Axis    [  0.9062  -0.3793   0.1871]
        Angle     83.0506
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2776"
}

Galaxy "NGC 2777:UGC 4823:MCG 1-24-6:ZWG 34.8"
{
        Type  "Sb"
        RA            9.1781
        Dec           7.2072
        Distance   8.091e+07  # method: V
        Radius          8237
        AbsMag        -18.07
        Axis    [ -0.3162   0.5701  -0.7583]
        Angle    102.6589
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2777"
}

Galaxy "NGC 2778:UGC 4840:MCG 6-20-43:ZWG 180.54"
{
        Type  "E0"
        RA            9.2067
        Dec          35.0278
        Distance   7.472e+07  # method: S
        Radius     1.521e+04
        AbsMag         -18.5
        Axis    [  0.8392  -0.2105  -0.5014]
        Angle     73.9153
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2778"
}

Galaxy "NGC 2779:MCG 6-20-44:ZWG 180.55"
{
        Type  "SBa"
        RA            9.2078
        Dec          35.0539
        Distance   3.217e+08  # distance uncertain!
        Radius     3.275e+04
        AbsMag        -19.07
        Axis    [ -0.2679   0.7953  -0.5437]
        Angle     97.9975
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2779"
}

Galaxy "NGC 2780:UGC 4843:MCG 6-20-47:ZWG 180.57"
{
        Type  "SBa"
        RA            9.2122
        Dec          34.9256
        Distance   1.001e+08  # method: V
        Radius     1.311e+04
        AbsMag        -18.14
        Axis    [ -0.2570   0.8243  -0.5045]
        Angle     84.8847
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2780"
}

Galaxy "NGC 2781:MCG 2-24-2:IRAS 09091-1436"
{
        Type  "SBa"
        RA            9.1908
        Dec         -14.8172
        Distance   1.055e+08  # method: V
        Radius     4.604e+04
        AbsMag        -20.05
        Axis    [  0.6642   0.4576  -0.5911]
        Angle     70.7013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2781"
}

Galaxy "NGC 2782:UGC 4862:MCG 7-19-36:ZWG 209.31"
{
        Type  "SBa"
        RA            9.2347
        Dec          40.1136
        Distance   1.255e+08  # method: V
        Radius     6.753e+04
        AbsMag        -20.62
        Axis    [  0.7105   0.7026   0.0387]
        Angle     46.8159
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2782"
}

Galaxy "NGC 2783:NGC 2783A:UGC 4859:MCG 5-22-19"
{
        Type  "E0"
        RA            9.2275
        Dec          29.9931
        Distance   3.146e+08  # method: V
        Radius     1.007e+05
        AbsMag        -21.72
        Axis    [ -0.0725   0.7160  -0.6944]
        Angle    125.4391
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2783"
}

Galaxy "NGC 2783B:UGC 4856:MCG 5-22-17:ZWG 151.26"
{
        Type  "Sb"
        RA            9.2256
        Dec          29.9997
        Distance   3.157e+08  # method: V
        Radius     7.347e+04
        AbsMag        -19.83
        Axis    [  0.4212   0.7857   0.4530]
        Angle     55.1510
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2783B"
}

Galaxy "NGC 2784:ESO 497-23:MCG 4-22-5:UGCA 152"
{
        Type  "S0"
        RA            9.2053
        Dec         -24.1725
        Distance   3.202e+07  # method: S
        Radius     2.562e+04
        AbsMag        -18.66
        Axis    [  0.7039   0.4464  -0.5525]
        Angle     76.0011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2784"
}

Galaxy "NGC 2785:UGC 4876:MCG 7-19-42:ZWG 209.35"
{
        Type  "Irr"
        RA            9.2542
        Dec          40.9181
        Distance   1.335e+08  # method: V
        Radius     2.912e+04
        AbsMag        -18.26
        Axis    [ -0.2575   0.9614   0.0974]
        Angle     56.9022
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2785"
}

Galaxy "NGC 2786:UGC 4861:MCG 2-24-2:ZWG 62.8"
{
        Type  "Sa"
        RA            9.2264
        Dec          12.4406
        Distance   2.354e+08  # method: V
        Radius     3.082e+04
        AbsMag        -20.59
        Axis    [  0.7214   0.5264  -0.4499]
        Angle     59.2177
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2786"
}

Galaxy "NGC 2787:UGC 4914:MCG 12-9-39:ZWG 332.41"
{
        Type  "SBa"
        RA            9.3217
        Dec          69.2036
        Distance    2.44e+07  # method: S
        Radius       1.1e+04
        AbsMag        -17.57
        Axis    [ -0.0937   0.9435   0.3180]
        Angle     63.1727
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2787"
}

Galaxy "NGC 2788:ESO 61-2:AM 0908-674:IRAS 09083-6743"
{
        Type  "Sb"
        RA            9.1508
        Dec         -67.9325
        Distance   6.664e+07  # method: T-F
        Radius     1.745e+04
        AbsMag        -18.25
        Axis    [  0.3093   0.0963  -0.9461]
        Angle     81.2162
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2788"
}

Galaxy "NGC 2788A:ESO 60-24:IRAS 09020-6801"
{
        Type  "Sb"
        RA            9.0444
        Dec         -68.2267
        Distance   2.267e+08  # method: T-F
        Radius     9.561e+04
        AbsMag        -20.31
        Axis    [  0.6780   0.4404  -0.5886]
        Angle    111.0734
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2788A"
}

Galaxy "NGC 2788B:ESO 60-25"
{
        Type  "Sb"
        RA            9.0597
        Dec         -67.9664
        Distance   4.285e+07  # method: T-F
        Radius          9349
        AbsMag        -16.09
        Axis    [ -0.2355  -0.2686  -0.9340]
        Angle     83.7173
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2788B"
}

Galaxy "NGC 2789:UGC 4875:MCG 5-22-26:ZWG 151.35"
{
        Type  "SBa"
        RA            9.2497
        Dec          29.7303
        Distance   2.969e+08  # method: V
        Radius     6.476e+04
        AbsMag         -21.3
        Axis    [  0.9898  -0.1414  -0.0175]
        Angle     78.8716
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2789"
}

Galaxy "NGC 2790:MCG 3-24-16:MK 1228:ZWG 91.34"
{
        Type  "Sc"
        RA            9.2506
        Dec          19.6975
        Distance    3.68e+08  # method: V
        Radius     3.211e+04
        AbsMag        -20.06
        Axis    [  0.9415   0.3119  -0.1274]
        Angle     65.2074
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2790"
}

Galaxy "NGC 2791:ZWG 91.33:NPM 1"
{
        Type  "S0"
        RA            9.2503
        Dec          17.5928
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [ -0.5757   0.6859  -0.4451]
        Angle     70.9407
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2791"
}

Galaxy "NGC 2793:UGC 4894:MCG 6-21-2:ZWG 181.6"
{
        Type  "Irr"
        RA            9.2794
        Dec          34.4322
        Distance   8.675e+07  # method: V
        Radius     1.514e+04
        AbsMag        -18.52
        Axis    [  0.8928   0.3616  -0.2685]
        Angle     53.5245
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2793"
}

Galaxy "NGC 2794:UGC 4885:MCG 3-24-18:ZWG 91.37"
{
        Type  "SBa"
        RA            9.2669
        Dec          17.5894
        Distance   4.097e+08  # method: V
        Radius      7.15e+04
        AbsMag        -21.49
        Axis    [  0.8680  -0.4556  -0.1975]
        Angle    104.2343
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2794"
}

Galaxy "NGC 2795:UGC 4887:MCG 3-24-20:ZWG 91.39"
{
        Type  "E0"
        RA            9.2675
        Dec          17.6283
        Distance   4.006e+08  # method: V
        Radius     8.158e+04
        AbsMag        -21.55
        Axis    [ -0.1243   0.6364  -0.7613]
        Angle    129.1573
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2795"
}

Galaxy "NGC 2796:UGC 4893:MCG 5-22-29:ZWG 151.42"
{
        Type  "Sa"
        RA            9.2781
        Dec          30.9161
        Distance   3.261e+08  # method: V
        Radius     5.217e+04
        AbsMag         -20.6
        Axis    [  0.6685   0.7238  -0.1710]
        Angle     48.0689
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2796"
}

Galaxy "NGC 2797:UGC 4891:MCG 3-24-23:ZWG 91.42"
{
        Type  "Irr"
        RA            9.2725
        Dec          17.7272
        Distance   2.754e+08  # distance uncertain!
        Radius     2.404e+04
        AbsMag        -20.13
        Axis    [  0.9938  -0.0651  -0.0906]
        Angle     86.6853
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2797"
}

Galaxy "NGC 2798:UGC 4905:MCG 7-19-55:ZWG 209.45"
{
        Type  "SBa"
        RA            9.2894
        Dec          42.0000
        Distance   8.811e+07  # method: V
        Radius     3.588e+04
        AbsMag        -19.16
        Axis    [ -0.6195   0.7747  -0.1268]
        Angle     82.7674
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2798"
}

Galaxy "NGC 2799:UGC 4909:MCG 7-19-56:ZWG 209.46"
{
        Type  "Irr"
        RA            9.2919
        Dec          41.9939
        Distance   9.056e+07  # method: V
        Radius     2.502e+04
        AbsMag        -17.92
        Axis    [ -0.3671   0.9157   0.1636]
        Angle     60.1754
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2799"
}

Galaxy "NGC 2800:UGC 4920:MCG 9-15-117:ZWG 264.94"
{
        Type  "E0"
        RA            9.3097
        Dec          52.5147
        Distance   3.525e+08  # method: V
        Radius     7.178e+04
        AbsMag        -21.37
        Axis    [  0.8059  -0.5576  -0.1989]
        Angle     67.7987
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2800"
}

Galaxy "NGC 2801:UGC 4899:MCG 3-24-25:ZWG 91.46"
{
        Type  "Sc"
        RA            9.2789
        Dec          19.9353
        Distance    3.62e+08  # method: V
        Radius     5.792e+04
        AbsMag        -20.13
        Axis    [  0.8344   0.1970  -0.5148]
        Angle     68.5715
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2801"
}

Galaxy "NGC 2802:UGC 4897:MCG 3-24-26:ZWG 91.44"
{
        Type  "S0"
        RA            9.2781
        Dec          18.9639
        Distance   4.092e+08  # method: V
        Radius     6.547e+04
        AbsMag        -20.39
        Axis    [ -0.2147   0.8128  -0.5415]
        Angle     60.8773
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2802"
}

Galaxy "NGC 2803:UGC 4898:MCG 3-24-27:ZWG 91.44"
{
        Type  "S0"
        RA            9.2786
        Dec          18.9544
        Distance    4.14e+08  # method: V
        Radius     6.624e+04
        AbsMag        -20.42
        Axis    [  0.9584   0.1289  -0.2545]
        Angle     71.4255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2803"
}

Galaxy "NGC 2804:IC 2455:UGC 4901:MCG 3-24-28"
{
        Type  "S0"
        RA            9.2803
        Dec          20.1983
        Distance   3.803e+08  # method: V
        Radius     7.743e+04
        AbsMag        -21.53
        Axis    [  0.8725   0.2357  -0.4280]
        Angle     65.7747
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2804"
}

Galaxy "NGC 2805:UGC 4936:MCG 11-12-3:ZWG 312.2"
{
        Type  "SBc"
        RA            9.3389
        Dec          64.1028
        Distance   8.322e+07  # method: V
        Radius     7.625e+04
        AbsMag        -20.53
        Axis    [ -0.1949   0.9738  -0.1168]
        Angle     80.3078
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2805"
}

Galaxy "NGC 2807:MCG 3-24-31:ZWG 91.51"
{
        Type  "S0"
        RA            9.2833
        Dec          20.0361
        Distance   3.072e+08  # distance uncertain!
        Radius     2.681e+04
        AbsMag        -19.07
        Axis    [ -0.3368   0.7267  -0.5988]
        Angle     77.8585
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2807"
}

Galaxy "NGC 2807A:MCG 3-24-30"
{
        Type  "S0"
        RA            9.2825
        Dec          20.0292
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [  0.6722   0.6698  -0.3154]
        Angle     51.5053
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2807A"
}

Galaxy "NGC 2809:UGC 4910:MCG 3-24-33:ZWG 91.54"
{
        Type  "S0"
        RA            9.2850
        Dec          20.0692
        Distance   3.742e+08  # method: V
        Radius     7.076e+04
        AbsMag         -21.4
        Axis    [ -0.2960   0.6714  -0.6794]
        Angle    110.2896
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2809"
}

Galaxy "NGC 2810:NGC 2810A:UGC 4954:MCG 12-9-42"
{
        Type  "E0"
        RA            9.3678
        Dec          71.8439
        Distance   1.877e+08  # method: T-F
        Radius      4.64e+04
        AbsMag         -20.6
        Axis    [  0.6013  -0.7982   0.0368]
        Angle     64.5569
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2810"
}

Galaxy "NGC 2810B"
{
        Type  "S0"
        RA            9.3661
        Dec          71.8667
        Distance   5.339e+08  # distance uncertain!
        Radius     1.553e+04
        AbsMag        -19.07
        Axis    [  0.2125   0.6776   0.7041]
        Angle     56.7879
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2810B"
}

Galaxy "NGC 2811:MCG 3-24-3:UGCA 155:IRAS 09138-1606"
{
        Type  "SBa"
        RA            9.2697
        Dec         -16.3125
        Distance   1.278e+08  # method: V
        Radius     4.647e+04
        AbsMag        -20.66
        Axis    [  0.9326   0.3499  -0.0888]
        Angle    105.1264
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2811"
}

Galaxy "NGC 2812:ZWG 91.60"
{
        Type  "S0"
        RA            9.2944
        Dec          19.9192
        Distance   3.217e+08  # distance uncertain!
        Radius     2.339e+04
        AbsMag        -19.07
        Axis    [ -0.6758   0.7074  -0.2071]
        Angle     61.7320
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2812"
}

Galaxy "NGC 2813:UGC 4916:MCG 3-24-37:ZWG 91.61"
{
        Type  "S0"
        RA            9.2958
        Dec          19.9069
        Distance    2.44e+08  # distance uncertain!
        Radius     4.614e+04
        AbsMag        -19.07
        Axis    [ -0.1603   0.6908  -0.7051]
        Angle     85.1381
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2813"
}

Galaxy "NGC 2814:UGC 4952:MCG 11-12-4:ZWG 312.3"
{
        Type  "Sb"
        RA            9.3531
        Dec          64.2519
        Distance   7.878e+07  # method: V
        Radius      1.26e+04
        AbsMag        -17.61
        Axis    [ -0.6615   0.7499  -0.0006]
        Angle    110.0441
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2814"
}

Galaxy "NGC 2815:ESO 497-32:MCG 4-22-6:UGCA 156"
{
        Type  "SBb"
        RA            9.2719
        Dec         -23.6339
        Distance   1.319e+08  # method: T-F
        Radius     6.715e+04
        AbsMag        -20.23
        Axis    [  0.9283   0.3658  -0.0666]
        Angle    118.8377
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2815"
}

Galaxy "NGC 2817:MCG 1-24-6:IRAS 09146-0432"
{
        Type  "SBc"
        RA            9.2861
        Dec          -4.7528
        Distance   1.168e+08  # distance uncertain!
        Radius     3.398e+04
        AbsMag        -19.07
        Axis    [  0.9869  -0.0816  -0.1392]
        Angle    114.2680
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2817"
}

Galaxy "NGC 2819:UGC 4924:MCG 3-24-40:ZWG 91.62"
{
        Type  "E0"
        RA            9.3025
        Dec          16.1981
        Distance   2.188e+08  # distance uncertain!
        Radius     4.455e+04
        AbsMag        -20.13
        Axis    [  0.7107  -0.0401  -0.7024]
        Angle     89.6301
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2819"
}

Galaxy "NGC 2820:UGC 4961:MCG 11-12-6:ZWG 312.5"
{
        Type  "SBc"
        RA            9.3628
        Dec          64.2586
        Distance    7.62e+07  # method: V
        Radius     4.544e+04
        AbsMag        -18.64
        Axis    [  0.3035   0.4402   0.8451]
        Angle     74.4926
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2820"
}

Galaxy "NGC 2821:ESO 497-34:MCG 4-22-7:IRAS 09145-2636"
{
        Type  "Sc"
        RA            9.2797
        Dec         -26.8167
        Distance    1.61e+08  # method: T-F
        Radius     4.685e+04
        AbsMag        -19.57
        Axis    [  0.4201   0.5302  -0.7365]
        Angle     56.8680
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2821"
}

Galaxy "NGC 2822:ESO 61-4:IRAS 09132-6926"
{
        Type  "E0"
        RA            9.2303
        Dec         -69.6442
        Distance   7.245e+07  # distance uncertain!
        Radius     3.477e+04
        AbsMag        -20.13
        Axis    [  0.3769  -0.1261  -0.9176]
        Angle    169.5730
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2822"
}

Galaxy "NGC 2823:UGC 4935:MCG 6-21-8:ZWG 181.16"
{
        Type  "SBa"
        RA            9.3214
        Dec          34.0083
        Distance    3.32e+08  # method: V
        Radius     4.346e+04
        AbsMag        -19.54
        Axis    [  0.9476   0.1482   0.2831]
        Angle     72.8337
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2823"
}

Galaxy "NGC 2824:UGC 4933:MCG 4-22-31:MK 394"
{
        Type  "S0"
        RA            9.3172
        Dec          26.2703
        Distance   1.369e+08  # method: V
        Radius     1.792e+04
        AbsMag        -18.91
        Axis    [ -0.4225   0.7427  -0.5194]
        Angle     85.4133
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2824"
}

Galaxy "NGC 2825:MCG 6-21-10:ZWG 181.17"
{
        Type  "Sa"
        RA            9.3228
        Dec          33.7431
        Distance   3.663e+08  # method: V
        Radius     4.795e+04
        AbsMag        -19.95
        Axis    [  0.4288   0.8974   0.1037]
        Angle     45.7774
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2825"
}

Galaxy "NGC 2826:UGC 4939:MCG 6-21-11:ZWG 181.18"
{
        Type  "Sa"
        RA            9.3233
        Dec          33.6236
        Distance   2.945e+08  # method: V
        Radius     6.854e+04
        AbsMag        -20.18
        Axis    [ -0.6067   0.7947   0.0189]
        Angle     64.8652
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2826"
}

Galaxy "NGC 2827:IC 2460:MCG 6-21-9:ZWG 181.15"
{
        Type  "Sb"
        RA            9.3217
        Dec          33.8808
        Distance   2.802e+08  # distance uncertain!
        Radius      3.26e+04
        AbsMag        -19.07
        Axis    [  0.9056   0.0699   0.4183]
        Angle     97.0969
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2827"
}

Galaxy "NGC 2828:ZWG 181.21:NPM 1"
{
        Type  "S0"
        RA            9.3261
        Dec          33.8886
        Distance   2.676e+08  # distance uncertain!
        Radius     1.557e+04
        AbsMag        -19.07
        Axis    [  0.8884   0.3662   0.2768]
        Angle     61.2290
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2828"
}

Galaxy "NGC 2829:NPM 1"
{
        Type  "S0"
        RA            9.3311
        Dec          33.6494
        Distance   2.934e+08  # distance uncertain!
        Radius      1.28e+04
        AbsMag        -19.07
        Axis    [  0.8268  -0.5444  -0.1417]
        Angle     91.4141
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2829"
}

Galaxy "NGC 2830:UGC 4941:MCG 6-21-14:ZWG 181.23"
{
        Type  "SBa"
        RA            9.3281
        Dec          33.7381
        Distance   3.432e+08  # method: T-F
        Radius     5.991e+04
        AbsMag        -20.31
        Axis    [ -0.1587   0.9696   0.1862]
        Angle     50.2521
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2830"
}

Galaxy "NGC 2831:UGC 4942:MCG 6-21-13:ZWG 181.24"
{
        Type  "E0"
        RA            9.3292
        Dec          33.7447
        Distance   2.426e+08  # method: V
        Radius     1.764e+04
        AbsMag        -19.96
        Axis    [  0.8089  -0.5639  -0.1661]
        Angle     91.7862
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2831"
}

Galaxy "NGC 2832:UGC 4942:MCG 6-21-15:ZWG 181.24"
{
        Type  "E2"
        RA            9.3294
        Dec          33.7497
        Distance   3.402e+08  # method: T-F
        Radius     1.485e+05
        AbsMag        -22.29
        Axis    [ -0.0194   0.7200  -0.6937]
        Angle    117.3786
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2832"
}

Galaxy "NGC 2833:ZWG 181.27"
{
        Type  "S0"
        RA            9.3325
        Dec          33.9275
        Distance   2.802e+08  # distance uncertain!
        Radius     3.668e+04
        AbsMag        -19.07
        Axis    [ -0.6697   0.7020  -0.2423]
        Angle     84.6254
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2833"
}

Galaxy "NGC 2834:MCG 6-21-21:ZWG 181.29"
{
        Type  "E0"
        RA            9.3339
        Dec          33.7106
        Distance   4.366e+08  # distance uncertain!
        Radius      3.81e+04
        AbsMag        -20.13
        Axis    [  0.7168   0.0536  -0.6952]
        Angle     72.8713
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2834"
}

Galaxy "NGC 2835:ESO 564-35:MCG 4-22-8:UGCA 157"
{
        Type  "SBc"
        RA            9.2978
        Dec         -22.3553
        Distance   4.304e+07  # method: T-F
        Radius     4.131e+04
        AbsMag         -19.6
        Axis    [  0.9753   0.1329  -0.1763]
        Angle    122.6635
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2835"
}

Galaxy "NGC 2836:ESO 61-3:IRAS 09131-6907"
{
        Type  "Sc"
        RA            9.2292
        Dec         -69.3331
        Distance   7.038e+07  # distance uncertain!
        Radius     2.764e+04
        AbsMag        -19.07
        Axis    [  0.2518  -0.0224  -0.9675]
        Angle    121.7515
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2836"
}

Galaxy "NGC 2838:MCG 7-19-61:ZWG 209.55:NPM 1"
{
        Type  "E0"
        RA            9.3453
        Dec          39.3164
        Distance   3.163e+08  # distance uncertain!
        Radius      4.14e+04
        AbsMag        -20.13
        Axis    [  0.7897  -0.5962  -0.1445]
        Angle     87.4450
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2838"
}

Galaxy "NGC 2839:MCG 6-21-23:ZWG 181.31"
{
        Type  "S0"
        RA            9.3433
        Dec          33.6511
        Distance   3.707e+08  # method: V
        Radius     4.852e+04
        AbsMag        -20.08
        Axis    [  0.8256  -0.5460  -0.1421]
        Angle     91.4942
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2839"
}

Galaxy "NGC 2840:UGC 4960:MCG 6-21-25:ZWG 181.32"
{
        Type  "SBc"
        RA            9.3478
        Dec          35.3683
        Distance   3.493e+08  # method: V
        Radius     5.081e+04
        AbsMag        -20.55
        Axis    [  0.2637   0.7384  -0.6207]
        Angle     63.7390
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2840"
}

Galaxy "NGC 2841:UGC 4966:MCG 9-16-5:ZWG 265.6"
{
        Type  "Sb"
        RA            9.3672
        Dec          50.9764
        Distance   8.684e+07  # method: T-F
        Radius     1.023e+05
        AbsMag        -22.02
        Axis    [ -0.4671   0.8834  -0.0373]
        Angle     77.6193
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2841"
}

Galaxy "NGC 2842:ESO 91-4:FAIR 282:IRAS 09144-6251"
{
        Type  "SBa"
        RA            9.2600
        Dec         -63.0694
        Distance   1.372e+08  # method: V
        Radius     3.193e+04
        AbsMag        -19.72
        Axis    [  0.1654  -0.0185  -0.9861]
        Angle    121.8102
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2842"
}

Galaxy "NGC 2843"
{
        Type  "S0"
        RA            9.3411
        Dec          18.9261
        Distance   4.241e+08  # distance uncertain!
        Radius     2.467e+04
        AbsMag        -19.07
        Axis    [  0.8894   0.4571  -0.0079]
        Angle     60.6980
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2843"
}

Galaxy "NGC 2844:UGC 4971:MCG 7-19-64:ZWG 209.57"
{
        Type  "Sa"
        RA            9.3633
        Dec          40.1519
        Distance   7.724e+07  # method: V
        Radius      1.91e+04
        AbsMag        -18.17
        Axis    [  0.9035   0.0233   0.4280]
        Angle     86.7151
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2844"
}

Galaxy "NGC 2845:ESO 314-10:MCG 6-21-2:IRAS 09166-3747"
{
        Type  "Sa"
        RA            9.3100
        Dec         -38.0097
        Distance   9.278e+07  # distance uncertain!
        Radius     3.104e+04
        AbsMag        -19.07
        Axis    [  0.6822   0.2892  -0.6716]
        Angle     92.7451
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2845"
}

Galaxy "NGC 2848:MCG 3-24-7:UGCA 160:IRAS 09178-1618"
{
        Type  "SBc"
        RA            9.3358
        Dec         -16.5256
        Distance   1.069e+08  # method: V
        Radius     3.887e+04
        AbsMag        -20.08
        Axis    [  0.9086   0.2441  -0.3389]
        Angle     95.4021
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2848"
}

Galaxy "NGC 2850:NPM 1"
{
        Type  "S0"
        RA            9.3489
        Dec          -4.9394
        Distance    2.33e+08  # distance uncertain!
        Radius     3.051e+04
        AbsMag        -19.07
        Axis    [  0.9559   0.0710  -0.2850]
        Angle     97.2274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2850"
}

Galaxy "NGC 2851:MCG 3-24-8"
{
        Type  "S0"
        RA            9.3417
        Dec         -16.4953
        Distance   1.612e+08  # distance uncertain!
        Radius     3.048e+04
        AbsMag        -19.07
        Axis    [  0.9595   0.2810  -0.0192]
        Angle    119.0459
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2851"
}

Galaxy "NGC 2852:UGC 4986:MCG 7-19-65:ZWG 209.59"
{
        Type  "SBa"
        RA            9.3872
        Dec          40.1644
        Distance   9.296e+07  # method: V
        Radius     1.352e+04
        AbsMag        -18.07
        Axis    [ -0.4884   0.8072  -0.3316]
        Angle     89.5815
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2852"
}

Galaxy "NGC 2853:UGC 4987:MCG 7-19-66:ZWG 209.60"
{
        Type  "SBa"
        RA            9.3881
        Dec          40.2003
        Distance   9.028e+07  # method: V
        Radius     1.313e+04
        AbsMag        -17.91
        Axis    [  0.9418   0.0400   0.3337]
        Angle     73.4644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2853"
}

Galaxy "NGC 2854:UGC 4995:MCG 8-17-92:ZWG 238.46"
{
        Type  "SBb"
        RA            9.4006
        Dec          49.2039
        Distance   1.322e+08  # method: V
        Radius     3.077e+04
        AbsMag        -19.24
        Axis    [  0.6979   0.3759   0.6096]
        Angle     62.6705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2854"
}

Galaxy "NGC 2855:MCG 2-24-15:UGCA 161:IRAS 09190-1141"
{
        Type  "Sa"
        RA            9.3575
        Dec         -11.9103
        Distance   1.007e+08  # method: V
        Radius     3.663e+04
        AbsMag        -19.85
        Axis    [  0.0142   0.3543  -0.9350]
        Angle     93.6186
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2855"
}

Galaxy "NGC 2856:UGC 4997:MCG 8-17-93:ZWG 238.47"
{
        Type  "Sc"
        RA            9.4044
        Dec          49.2492
        Distance   1.276e+08  # method: V
        Radius     2.041e+04
        AbsMag        -18.96
        Axis    [ -0.3555   0.9347   0.0041]
        Angle     67.0245
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2856"
}

Galaxy "NGC 2857:UGC 5000:MCG 8-17-95:ZWG 238.49"
{
        Type  "Sc"
        RA            9.4103
        Dec          49.3572
        Distance   2.294e+08  # method: V
        Radius     7.342e+04
        AbsMag        -21.04
        Axis    [ -0.0445   0.8894  -0.4550]
        Angle     79.8936
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2857"
}

Galaxy "NGC 2858:UGC 4989:MCG 1-24-17:ZWG 34.40"
{
        Type  "Sa"
        RA            9.3817
        Dec           3.1575
        Distance   1.065e+08  # distance uncertain!
        Radius     2.634e+04
        AbsMag        -19.07
        Axis    [  0.0782   0.6820  -0.7271]
        Angle     55.0637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2858"
}

Galaxy "NGC 2859:UGC 5001:MCG 6-21-30:ZWG 181.40"
{
        Type  "SBa"
        RA            9.4050
        Dec          34.5133
        Distance   8.702e+07  # method: V
        Radius     5.822e+04
        AbsMag        -20.33
        Axis    [  0.6309   0.5490  -0.5483]
        Angle     54.0741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2859"
}

Galaxy "NGC 2860:UGC 5007:MCG 7-20-3:ZWG 209.65"
{
        Type  "SBa"
        RA            9.4147
        Dec          41.0600
        Distance   2.021e+08  # method: V
        Radius     4.409e+04
        AbsMag        -19.36
        Axis    [ -0.0256   0.9892   0.1442]
        Angle     49.5352
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2860"
}

Galaxy "NGC 2861:UGC 4999:MCG 0-24-10:ZWG 6.38"
{
        Type  "SBc"
        RA            9.3933
        Dec           2.1361
        Distance   2.468e+08  # method: V
        Radius     5.383e+04
        AbsMag        -20.59
        Axis    [  0.9602  -0.2115  -0.1826]
        Angle    110.1376
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2861"
}

Galaxy "NGC 2862:UGC 5010:MCG 5-22-45:ZWG 151.76"
{
        Type  "SBc"
        RA            9.4153
        Dec          26.7753
        Distance   1.976e+08  # method: V
        Radius     7.185e+04
        AbsMag        -20.11
        Axis    [ -0.2043   0.9630   0.1760]
        Angle     46.9349
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2862"
}

Galaxy "NGC 2863:NGC 2869:MCG 2-24-18:IRAS 09211-1012"
{
        Type  "Irr"
        RA            9.3933
        Dec         -10.4331
        Distance   1.738e+08  # distance uncertain!
        Radius     2.528e+04
        AbsMag        -20.13
        Axis    [  0.1541   0.3281  -0.9320]
        Angle     91.7366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2863"
}

Galaxy "NGC 2864:MCG 1-24-20:ZWG 34.44:IRAS 09216+0609"
{
        Type  "S0"
        RA            9.4042
        Dec           5.9400
        Distance   2.676e+08  # distance uncertain!
        Radius     3.892e+04
        AbsMag        -19.07
        Axis    [  0.9994   0.0130  -0.0331]
        Angle    100.4600
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2864"
}

Galaxy "NGC 2865:ESO 498-1:MCG 4-22-11:AM 0921-225"
{
        Type  "E3"
        RA            9.3917
        Dec         -23.1614
        Distance   1.234e+08  # method: S
        Radius     4.488e+04
        AbsMag        -20.39
        Axis    [ -0.1796   0.3016  -0.9364]
        Angle    138.6654
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2865"
}

Galaxy "NGC 2868:NPM 1"
{
        Type  "S0"
        RA            9.3908
        Dec         -10.4289
        Distance    2.44e+08  # distance uncertain!
        Radius      2.13e+04
        AbsMag        -19.07
        Axis    [  0.7467   0.1685  -0.6435]
        Angle     87.9192
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2868"
}

Galaxy "NGC 2870:UGC 5034:MCG 10-14-13:ZWG 289.8"
{
        Type  "SBc"
        RA            9.4647
        Dec          57.3758
        Distance    1.52e+08  # method: V
        Radius     5.526e+04
        AbsMag        -19.54
        Axis    [ -0.3622   0.8387   0.4068]
        Angle     69.0662
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2870"
}

Galaxy "NGC 2872:UGC 5018:MCG 2-24-8:ZWG 62.33"
{
        Type  "E2"
        RA            9.4283
        Dec          11.4328
        Distance   2.043e+08  # method: T-F
        Radius     6.239e+04
        AbsMag        -21.08
        Axis    [ -0.1607   0.5920  -0.7898]
        Angle    129.3302
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2872"
}

Galaxy "NGC 2873:MCG 2-24-9:NPM 1"
{
        Type  "Sb"
        RA            9.4300
        Dec          11.4547
        Distance   3.694e+08  # distance uncertain!
        Radius      3.76e+04
        AbsMag        -19.07
        Axis    [ -0.0967   0.9316  -0.3504]
        Angle     42.9588
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2873"
}

Galaxy "NGC 2874:UGC 5021:MCG 2-24-10:KCPG 202B"
{
        Type  "SBc"
        RA            9.4297
        Dec          11.4258
        Distance   1.847e+08  # method: V
        Radius      5.91e+04
        AbsMag        -20.36
        Axis    [  0.9014   0.4129   0.1305]
        Angle     74.0574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2874"
}

Galaxy "NGC 2876:MCG 1-24-16"
{
        Type  "S0"
        RA            9.4203
        Dec          -6.7167
        Distance   1.404e+08  # distance uncertain!
        Radius     3.472e+04
        AbsMag        -19.07
        Axis    [  0.4725   0.4416  -0.7627]
        Angle     65.7310
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2876"
}

Galaxy "NGC 2877:MCG 0-24-15:ZWG 6.43:ARAK 201"
{
        Type  "Irr"
        RA            9.4297
        Dec           2.2286
        Distance   3.295e+08  # method: V
        Radius     3.355e+04
        AbsMag        -19.72
        Axis    [ -0.1947   0.5518  -0.8109]
        Angle     75.5325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2877"
}

Galaxy "NGC 2878:UGC 5022:MCG 0-24-14:ZWG 6.42"
{
        Type  "Sa"
        RA            9.4297
        Dec           2.0900
        Distance   1.851e+08  # distance uncertain!
        Radius     2.154e+04
        AbsMag        -19.07
        Axis    [ -0.6999   0.4280  -0.5718]
        Angle     79.5051
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2878"
}

Galaxy "NGC 2880:UGC 5051:MCG 10-14-15:ZWG 312.11"
{
        Type  "S0"
        RA            9.4928
        Dec          62.4911
        Distance   7.136e+07  # method: S
        Radius     2.076e+04
        AbsMag         -19.2
        Axis    [ -0.3088   0.9509   0.0187]
        Angle     76.8646
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2880"
}

Galaxy "NGC 2881-1:MCG 2-24-21:VV 293:ARP 275"
{
        Type  "S0"
        RA            9.4317
        Dec         -11.9956
        Distance   2.056e+08  # method: V
        Radius     3.289e+04
        AbsMag         -19.9
        Axis    [ -0.0505   0.3705  -0.9275]
        Angle     87.3405
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2881-1"
}

Galaxy "NGC 2881-2:MCG 2-24-21:VV 293:ARP 275"
{
        Type  "S0"
        RA            9.4314
        Dec         -11.9925
        Distance   1.404e+08  # distance uncertain!
        Radius     1.634e+04
        AbsMag        -19.07
        Axis    [  0.9795  -0.1111  -0.1679]
        Angle    123.4764
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2881-2"
}

Galaxy "NGC 2882:UGC 5030:MCG 1-24-21:ZWG 34.46"
{
        Type  "S0"
        RA            9.4431
        Dec           7.9542
        Distance   1.113e+08  # method: V
        Radius     2.429e+04
        AbsMag        -19.17
        Axis    [  0.7024   0.5799  -0.4129]
        Angle     54.3599
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2882"
}

Galaxy "NGC 2883:ESO 372-24:MCG 6-21-5:VV 768"
{
        Type  "Irr"
        RA            9.4217
        Dec         -34.1022
        Distance   6.637e+07  # method: V
        Radius     2.124e+04
        AbsMag        -16.54
        Axis    [ -0.5961   0.0121  -0.8029]
        Angle     81.1575
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2883"
}

Galaxy "NGC 2884:MCG 2-24-22:IRAS 09239-1120"
{
        Type  "Sa"
        RA            9.4400
        Dec         -11.5556
        Distance   2.588e+08  # method: V
        Radius     7.903e+04
        AbsMag           -21
        Axis    [ -0.6206   0.3068  -0.7216]
        Angle     83.3481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2884"
}

Galaxy "NGC 2885:IC 538:UGC 5037:MCG 4-22-58"
{
        Type  "Sa"
        RA            9.4550
        Dec          23.0200
        Distance   1.938e+08  # distance uncertain!
        Radius     1.973e+04
        AbsMag        -19.07
        Axis    [  0.8212   0.5554  -0.1312]
        Angle     51.5462
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2885"
}

Galaxy "NGC 2887:ESO 91-9:AM 0922-633"
{
        Type  "S0"
        RA            9.3900
        Dec         -63.8122
        Distance   1.269e+08  # method: T-F
        Radius     3.876e+04
        AbsMag        -20.25
        Axis    [  0.5266   0.0620  -0.8479]
        Angle    126.5700
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2887"
}

Galaxy "NGC 2888:ESO 434-2:MCG 5-23-1"
{
        Type  "E0"
        RA            9.4386
        Dec         -28.0361
        Distance   1.133e+08  # method: V
        Radius     2.471e+04
        AbsMag         -19.1
        Axis    [ -0.1617   0.2508  -0.9544]
        Angle    139.4764
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2888"
}

Galaxy "NGC 2889:MCG 2-24-26:IRAS 09247-1125"
{
        Type  "SBc"
        RA            9.4533
        Dec         -11.6433
        Distance   1.656e+08  # method: V
        Radius      5.54e+04
        AbsMag        -21.13
        Axis    [  0.9815  -0.0511  -0.1845]
        Angle    118.4384
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2889"
}

Galaxy "NGC 2890:MCG 2-24-24"
{
        Type  "S0"
        RA            9.4414
        Dec         -14.5289
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [  0.7632   0.3011  -0.5718]
        Angle     78.9644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2890"
}

Galaxy "NGC 2891:ESO 498-8:MCG 4-23-3"
{
        Type  "S0"
        RA            9.4489
        Dec         -24.7828
        Distance   1.065e+08  # distance uncertain!
        Radius     2.324e+04
        AbsMag        -19.07
        Axis    [ -0.1085   0.2430  -0.9639]
        Angle    110.7227
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2891"
}

Galaxy "NGC 2892:UGC 5073:MCG 11-12-15:ZWG 312.15"
{
        Type  "E0"
        RA            9.5478
        Dec          67.6175
        Distance   2.291e+08  # distance uncertain!
        Radius     4.665e+04
        AbsMag        -20.13
        Axis    [  0.6136  -0.7896   0.0073]
        Angle     69.1153
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2892"
}

Galaxy "NGC 2893:UGC 5060:MCG 5-23-5:MK 401"
{
        Type  "SBa"
        RA            9.5044
        Dec          29.5403
        Distance    8.87e+07  # method: V
        Radius     1.419e+04
        AbsMag        -18.37
        Axis    [  0.7032   0.3915  -0.5935]
        Angle     57.3623
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2893"
}

Galaxy "NGC 2894:UGC 5056:MCG 1-24-24:ZWG 34.51"
{
        Type  "Sa"
        RA            9.4917
        Dec           7.7183
        Distance   1.113e+08  # method: V
        Radius     3.076e+04
        AbsMag        -19.36
        Axis    [  0.9829   0.1844   0.0019]
        Angle     87.3800
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2894"
}

Galaxy "NGC 2895:MCG 10-14-18:ZWG 289.9"
{
        Type  "SBc"
        RA            9.5400
        Dec          57.4831
        Distance   1.851e+08  # distance uncertain!
        Radius     2.154e+04
        AbsMag        -19.07
        Axis    [  0.9665   0.2396   0.0921]
        Angle     41.4320
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2895"
}

Galaxy "NGC 2896:MCG 4-23-7:ZWG 122.9:NPM 1"
{
        Type  "S0"
        RA            9.5044
        Dec          23.6636
        Distance   1.938e+08  # distance uncertain!
        Radius     2.537e+04
        AbsMag        -19.07
        Axis    [  0.8366  -0.5142  -0.1889]
        Angle    100.5262
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2896"
}

Galaxy "NGC 2897:NPM 1"
{
        Type  "S0"
        RA            9.4958
        Dec           2.2075
        Distance   2.676e+08  # distance uncertain!
        Radius     2.724e+04
        AbsMag        -19.07
        Axis    [ -0.5686   0.4817  -0.6668]
        Angle     84.6348
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2897"
}

Galaxy "NGC 2898:MCG 0-24-18:ZWG 6.48:NPM 1"
{
        Type  "Sa"
        RA            9.4961
        Dec           2.0650
        Distance   2.324e+08  # method: T-F
        Radius     3.381e+04
        AbsMag        -19.66
        Axis    [  0.0473   0.5044  -0.8622]
        Angle     74.4244
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2898"
}

Galaxy "NGC 2900:UGC 5065:MCG 1-24-26:ZWG 34.55"
{
        Type  "SBc"
        RA            9.5042
        Dec           4.1436
        Distance   2.565e+08  # method: V
        Radius      4.85e+04
        AbsMag        -20.28
        Axis    [ -0.2210   0.5318  -0.8175]
        Angle     89.2064
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2900"
}

Galaxy "NGC 2902:MCG 2-24-30"
{
        Type  "S0"
        RA            9.5147
        Dec         -14.7356
        Distance   1.046e+08  # method: V
        Radius     2.435e+04
        AbsMag        -19.33
        Axis    [  0.9764  -0.0297  -0.2139]
        Angle    119.1697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2902"
}

Galaxy "NGC 2903:UGC 5079:MCG 4-23-9:KARA 347"
{
        Type  "SBc"
        RA            9.5358
        Dec          21.4992
        Distance   3.429e+07  # method: T-F
        Radius     6.284e+04
        AbsMag         -20.5
        Axis    [  0.9711   0.1032   0.2153]
        Angle     89.5561
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2903"
}

Galaxy "NGC 2904:ESO 434-6:MCG 5-23-3:AM 0928-300"
{
        Type  "S0"
        RA            9.5044
        Dec         -30.3850
        Distance   7.681e+07  # method: S
        Radius     1.341e+04
        AbsMag        -18.36
        Axis    [  0.5547   0.2222  -0.8018]
        Angle     87.3852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2904"
}

Galaxy "NGC 2906:UGC 5081:MCG 2-25-1:ZWG 63.1"
{
        Type  "Sc"
        RA            9.5350
        Dec           8.4422
        Distance   1.111e+08  # method: V
        Radius     2.262e+04
        AbsMag        -19.46
        Axis    [  0.7625   0.4427  -0.4718]
        Angle     58.6437
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2906"
}

Galaxy "NGC 2907:MCG 3-25-2:IRAS 09292-1630"
{
        Type  "Sa"
        RA            9.5267
        Dec         -16.7336
        Distance    1.09e+08  # method: V
        Radius     3.171e+04
        AbsMag        -19.92
        Axis    [  0.1728   0.3809  -0.9083]
        Angle     67.6562
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2907"
}

Galaxy "NGC 2908:UGC 5152:MCG 13-7-34:ZWG 350.29"
{
        Type  "S0"
        RA            9.7253
        Dec          79.7014
        Distance    1.47e+08  # distance uncertain!
        Radius     1.711e+04
        AbsMag        -19.07
        Axis    [  0.5001  -0.8544   0.1411]
        Angle     64.9266
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2908"
}

Galaxy "NGC 2911:UGC 5092:MCG 2-25-3:ZWG 63.7"
{
        Type  "S0"
        RA            9.5628
        Dec          10.1528
        Distance   1.582e+08  # method: V
        Radius     9.206e+04
        AbsMag        -20.93
        Axis    [ -0.1712   0.6101  -0.7736]
        Angle     75.3706
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2911"
}

Galaxy "NGC 2913:UGC 5095:MCG 2-25-5:ZWG 63.9"
{
        Type  "Sc"
        RA            9.5672
        Dec           9.4783
        Distance   1.527e+08  # method: V
        Radius     2.442e+04
        AbsMag        -19.25
        Axis    [ -0.2581   0.6483  -0.7163]
        Angle     66.6750
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2913"
}

Galaxy "NGC 2914:UGC 5096:MCG 2-25-6:ZWG 63.10"
{
        Type  "SBb"
        RA            9.5672
        Dec          10.1092
        Distance   1.576e+08  # method: V
        Radius     2.064e+04
        AbsMag        -19.32
        Axis    [  1.0000  -0.0045   0.0087]
        Angle     97.8219
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2914"
}

Galaxy "NGC 2915:ESO 37-3:AM 0926-762:IRAS 09265-7624"
{
        Type  "SBa"
        RA            9.4369
        Dec         -76.6267
        Distance   2.578e+07  # method: V
        Radius          7123
        AbsMag        -16.29
        Axis    [  0.1064  -0.1289  -0.9859]
        Angle    103.3741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2915"
}

Galaxy "NGC 2916:UGC 5103:MCG 4-23-11:ZWG 122.21"
{
        Type  "Sb"
        RA            9.5825
        Dec          21.7044
        Distance   1.819e+08  # method: V
        Radius     6.613e+04
        AbsMag        -21.03
        Axis    [  0.9977  -0.0190   0.0650]
        Angle     84.8090
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2916"
}

Galaxy "NGC 2917:UGC 5098:MCG 0-25-2:ZWG 7.3"
{
        Type  "Sa"
        RA            9.5742
        Dec          -2.5039
        Distance   1.812e+08  # method: V
        Radius     3.425e+04
        AbsMag        -19.22
        Axis    [ -0.7221   0.3796  -0.5783]
        Angle     70.7063
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2917"
}

Galaxy "NGC 2918:UGC 5112:MCG 5-23-19:ZWG 152.32"
{
        Type  "E0"
        RA            9.5956
        Dec          31.7053
        Distance   3.191e+08  # method: V
        Radius     6.498e+04
        AbsMag        -21.45
        Axis    [  0.6995  -0.0046  -0.7146]
        Angle     73.5646
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2918"
}

Galaxy "NGC 2919:UGC 5102:MCG 2-25-7:ZWG 63.13"
{
        Type  "SBc"
        RA            9.5797
        Dec          10.2839
        Distance    1.41e+08  # method: T-F
        Radius     3.281e+04
        AbsMag        -19.48
        Axis    [ -0.6728   0.5796  -0.4597]
        Angle     65.3852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2919"
}

Galaxy "NGC 2930:MCG 4-23-18:ZWG 122.35:WAS 1"
{
        Type  "S0"
        RA            9.6256
        Dec          23.2036
        Distance   3.118e+08  # method: V
        Radius     3.175e+04
        AbsMag         -19.8
        Axis    [ -0.2737   0.8227  -0.4983]
        Angle     58.8568
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2930"
}

Galaxy "NGC 2931:MCG 4-23-19:ZWG 122.36"
{
        Type  "S0"
        RA            9.6269
        Dec          23.2406
        Distance   2.226e+08  # distance uncertain!
        Radius      2.59e+04
        AbsMag        -19.07
        Axis    [  0.8551   0.3713  -0.3619]
        Angle     54.0610
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2931"
}

Galaxy "NGC 2933:UGC 5132:MCG 3-25-8:ZWG 92.15"
{
        Type  "S0"
        RA            9.6319
        Dec          17.0147
        Distance   2.676e+08  # distance uncertain!
        Radius     3.892e+04
        AbsMag        -19.07
        Axis    [  0.9582   0.2277   0.1735]
        Angle     81.1663
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2933"
}

Galaxy "NGC 2934:NPM 1"
{
        Type  "E0"
        RA            9.6319
        Dec          17.0550
        Distance    8.71e+08  # distance uncertain!
        Radius     2.534e+04
        AbsMag        -20.13
        Axis    [  0.8228  -0.5161  -0.2379]
        Angle    107.3016
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2934"
}

Galaxy "NGC 2935:ESO 565-23:MCG 3-25-11:UGCA 169"
{
        Type  "SBb"
        RA            9.6122
        Dec         -21.1278
        Distance   1.008e+08  # method: T-F
        Radius     5.424e+04
        AbsMag        -20.25
        Axis    [  0.9839   0.0107  -0.1785]
        Angle    128.0291
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2935"
}

Galaxy "NGC 2936:UGC 5130:MCG 1-25-5:ZWG 35.15"
{
        Type  "E0"
        RA            9.6289
        Dec           2.7606
        Distance   3.312e+08  # method: V
        Radius     6.263e+04
        AbsMag        -21.13
        Axis    [  0.7805  -0.2726  -0.5626]
        Angle    106.3891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2936"
}

Galaxy "NGC 2937:UGC 5131:MCG 1-25-6:ZWG 35.15"
{
        Type  "E0"
        RA            9.6292
        Dec           2.7481
        Distance   3.244e+08  # method: V
        Radius     3.775e+04
        AbsMag        -20.39
        Axis    [  0.8479  -0.4501  -0.2802]
        Angle    119.2498
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2937"
}

Galaxy "NGC 2938:UGC 5115:MCG 13-7-32:ZWG 350.27"
{
        Type  "SBc"
        RA            9.6400
        Dec          76.3192
        Distance   1.054e+08  # method: V
        Radius     2.759e+04
        AbsMag        -18.35
        Axis    [ -0.0449   0.8494   0.5258]
        Angle     62.2734
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2938"
}

Galaxy "NGC 2939:UGC 5134:MCG 2-25-11:ZWG 63.22"
{
        Type  "Sc"
        RA            9.6353
        Dec           9.5236
        Distance   1.821e+08  # method: T-F
        Radius     6.357e+04
        AbsMag        -20.33
        Axis    [ -0.7152   0.5710  -0.4031]
        Angle     60.7280
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2939"
}

Galaxy "NGC 2940:MCG 2-25-12:ZWG 63.23:NPM 1"
{
        Type  "S0"
        RA            9.6347
        Dec           9.6172
        Distance   4.048e+08  # method: V
        Radius     5.299e+04
        AbsMag        -20.87
        Axis    [  0.5529   0.4366  -0.7097]
        Angle     60.6274
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2940"
}

Galaxy "NGC 2941:MCG 3-25-9:ZWG 92.17"
{
        Type  "S0"
        RA            9.6400
        Dec          17.0444
        Distance   3.072e+08  # distance uncertain!
        Radius     3.575e+04
        AbsMag        -19.07
        Axis    [ -0.5039   0.6481  -0.5710]
        Angle     80.8393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2941"
}

Galaxy "NGC 2942:UGC 5140:MCG 6-21-65:ZWG 181.76"
{
        Type  "Sc"
        RA            9.6522
        Dec          34.0061
        Distance   2.118e+08  # method: V
        Radius     5.852e+04
        AbsMag        -20.86
        Axis    [ -0.3792   0.7824  -0.4940]
        Angle     91.3138
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2942"
}

Galaxy "NGC 2943:UGC 5136:MCG 3-25-11:ZWG 92.19"
{
        Type  "E0"
        RA            9.6422
        Dec          17.0311
        Distance   3.931e+08  # method: V
        Radius     1.258e+05
        AbsMag         -21.7
        Axis    [  0.1358   0.4633  -0.8757]
        Angle    102.2066
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2943"
}

Galaxy "NGC 2944-1:UGC 5144:MCG 6-21-67:ZWG 181.78"
{
        Type  "Sc"
        RA            9.6550
        Dec          32.3106
        Distance   3.189e+08  # method: V
        Radius     4.638e+04
        AbsMag        -20.15
        Axis    [  0.3277   0.9372   0.1196]
        Angle     41.5681
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2944-1"
}

Galaxy "NGC 2944-2:UGC 5144:MCG 6-21-67:ZWG 181.78"
{
        Type  "SBc"
        RA            9.6544
        Dec          32.3106
        Distance   2.676e+08  # distance uncertain!
        Radius     1.168e+04
        AbsMag        -19.07
        Axis    [ -0.2224   0.8676  -0.4448]
        Angle     62.5062
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2944-2"
}

Galaxy "NGC 2945:ESO 565-28:MCG 4-23-10:IRAS 09354-2148"
{
        Type  "S0"
        RA            9.6281
        Dec         -22.0344
        Distance    2.24e+08  # method: V
        Radius     5.213e+04
        AbsMag        -20.98
        Axis    [ -0.4400   0.2508  -0.8623]
        Angle     97.1173
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2945"
}

Galaxy "NGC 2946:UGC 5143:MCG 3-25-13:ZWG 92.20"
{
        Type  "SBa"
        RA            9.6503
        Dec          17.0256
        Distance   4.192e+08  # method: V
        Radius     7.316e+04
        AbsMag        -20.74
        Axis    [  0.9534   0.1668   0.2513]
        Angle     96.9978
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2946"
}

Galaxy "NGC 2947:IC 547:IC 2494:MCG 2-25-4"
{
        Type  "SBc"
        RA            9.6014
        Dec         -12.4367
        Distance   1.422e+08  # method: V
        Radius     3.102e+04
        AbsMag           -20
        Axis    [  0.9029  -0.1175  -0.4135]
        Angle    112.2902
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2947"
}

Galaxy "NGC 2948:UGC 5141:MCG 1-25-7:ZWG 35.20"
{
        Type  "SBc"
        RA            9.6497
        Dec           6.9558
        Distance   2.401e+08  # method: V
        Radius      4.89e+04
        AbsMag        -20.53
        Axis    [  0.9998  -0.0088   0.0155]
        Angle    103.7239
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2948"
}

Galaxy "NGC 2949-1:ZWG 92.25"
{
        Type  "S0"
        RA            9.6653
        Dec          16.7844
        Distance   2.555e+08  # distance uncertain!
        Radius      2.23e+04
        AbsMag        -19.07
        Axis    [  0.7903   0.5811  -0.1944]
        Angle     49.1971
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2949-1"
}

Galaxy "NGC 2949-2:ZWG 92.25"
{
        Type  "S0"
        RA            9.6658
        Dec          16.7869
        Distance   2.555e+08  # distance uncertain!
        Radius      2.23e+04
        AbsMag        -19.07
        Axis    [  0.8375  -0.4991  -0.2224]
        Angle    107.0202
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2949-2"
}

Galaxy "NGC 2950:UGC 5176:MCG 10-14-32:ZWG 289.16"
{
        Type  "S0"
        RA            9.7094
        Dec          58.8514
        Distance   4.869e+07  # method: S
        Radius     1.912e+04
        AbsMag        -18.97
        Axis    [ -0.3025   0.9491  -0.0876]
        Angle     76.4619
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2950"
}

Galaxy "NGC 2951-1:MCG 0-25-6:ZWG 7.17"
{
        Type  "E0"
        RA            9.6608
        Dec          -0.2356
        Distance   4.787e+08  # distance uncertain!
        Radius     3.481e+04
        AbsMag        -20.13
        Axis    [  0.4387   0.0901  -0.8941]
        Angle    104.0352
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2951-1"
}

Galaxy "NGC 2951-2:MCG 0-25-6:ZWG 7.17:NPM 1"
{
        Type  "E0"
        RA            9.6611
        Dec          -0.2344
        Distance   4.169e+08  # distance uncertain!
        Radius     3.032e+04
        AbsMag        -20.13
        Axis    [  0.8496  -0.4403  -0.2903]
        Angle    121.9226
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2951-2"
}

Galaxy "NGC 2952"
{
        Type  "Irr"
        RA            9.6269
        Dec         -10.1844
        Distance   3.631e+08  # distance uncertain!
        Radius     4.225e+04
        AbsMag        -20.13
        Axis    [  0.9847   0.1635  -0.0602]
        Angle    111.6046
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2952"
}

Galaxy "NGC 2954:UGC 5155:MCG 3-25-19:ZWG 92.26"
{
        Type  "E0"
        RA            9.6733
        Dec          14.9225
        Distance    1.87e+08  # method: V
        Radius     3.263e+04
        AbsMag        -20.49
        Axis    [ -0.0951   0.5786  -0.8100]
        Angle    118.6050
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2954"
}

Galaxy "NGC 2955:UGC 5166:MCG 6-21-73:ZWG 181.82"
{
        Type  "Sb"
        RA            9.6878
        Dec          35.8828
        Distance   3.308e+08  # method: T-F
        Radius     7.217e+04
        AbsMag        -21.43
        Axis    [ -0.5807   0.7711  -0.2611]
        Angle     78.8350
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2955"
}

Galaxy "NGC 2956:ESO 565-34:IRAS 09369-1852"
{
        Type  "Sb"
        RA            9.6544
        Dec         -19.1011
        Distance    2.44e+08  # distance uncertain!
        Radius     3.194e+04
        AbsMag        -19.07
        Axis    [  0.8485   0.4041  -0.3417]
        Angle     78.0651
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2956"
}

Galaxy "NGC 2957A:MCG 12-10-1:MK 121:NPM 1"
{
        Type  "E1"
        RA            9.7875
        Dec          72.9867
        Distance   3.064e+08  # method: V
        Radius     1.337e+04
        AbsMag        -19.06
        Axis    [  0.6201  -0.7844  -0.0107]
        Angle     58.9705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2957A"
}

Galaxy "NGC 2957B:MCG 12-10-2:ZWG 332.64:ZWG 333.2"
{
        Type  "E0"
        RA            9.7881
        Dec          72.9839
        Distance   3.132e+08  # method: V
        Radius     3.189e+04
        AbsMag        -19.21
        Axis    [  0.8653  -0.4356  -0.2480]
        Angle     39.6487
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2957B"
}

Galaxy "NGC 2958:UGC 5160:MCG 2-25-15:ZWG 63.33"
{
        Type  "Sc"
        RA            9.6781
        Dec          11.8886
        Distance   3.159e+08  # method: V
        Radius     4.595e+04
        AbsMag        -21.03
        Axis    [  0.9881  -0.1405  -0.0629]
        Angle     98.6734
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2958"
}

Galaxy "NGC 2959:UGC 5202:MCG 12-9-62:ZWG 332.61"
{
        Type  "SBb"
        RA            9.7522
        Dec          68.5950
        Distance   2.047e+08  # method: V
        Radius      3.87e+04
        AbsMag        -20.29
        Axis    [  0.6010  -0.7976   0.0512]
        Angle     70.9001
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2959"
}

Galaxy "NGC 2960:UGC 5159:MCG 1-25-9:MK 1419"
{
        Type  "Sa"
        RA            9.6767
        Dec           3.5772
        Distance   2.377e+08  # method: V
        Radius     4.841e+04
        AbsMag        -20.91
        Axis    [  0.9558   0.1023  -0.2757]
        Angle     81.9810
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2960"
}

Galaxy "NGC 2961:NGC 2959A:MCG 12-9-63:ZWG 332.63"
{
        Type  "Sb"
        RA            9.7561
        Dec          68.6092
        Distance   2.934e+08  # distance uncertain!
        Radius     3.414e+04
        AbsMag        -19.07
        Axis    [ -0.4501   0.7964   0.4040]
        Angle     81.9330
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2961"
}

Galaxy "NGC 2962:UGC 5167:MCG 1-25-11:ZWG 35.28"
{
        Type  "S0"
        RA            9.6817
        Dec           5.1658
        Distance   1.037e+08  # method: V
        Radius     3.921e+04
        AbsMag        -19.61
        Axis    [  0.9923  -0.1139  -0.0493]
        Angle    108.1989
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2962"
}

Galaxy "NGC 2963:UGC 5222:MCG 12-10-3:MK 122"
{
        Type  "SBb"
        RA            9.7969
        Dec          72.9644
        Distance    2.99e+08  # method: V
        Radius     5.218e+04
        AbsMag        -20.51
        Axis    [ -0.4612   0.8837   0.0799]
        Angle     99.0812
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2963"
}

Galaxy "NGC 2964:UGC 5183:MCG 5-23-27:ZWG 152.56"
{
        Type  "SBc"
        RA            9.7150
        Dec          31.8469
        Distance   7.819e+07  # method: T-F
        Radius     3.412e+04
        AbsMag         -19.9
        Axis    [  0.3908   0.9024  -0.1816]
        Angle     41.2113
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2964"
}

Galaxy "NGC 2965:UGC 5191:MCG 6-22-3:ZWG 181.86"
{
        Type  "S0"
        RA            9.7219
        Dec          36.2483
        Distance    3.16e+08  # method: V
        Radius     5.516e+04
        AbsMag        -20.43
        Axis    [  0.9319   0.3443  -0.1142]
        Angle     47.8619
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2965"
}

Galaxy "NGC 2966:UGC 5181:MCG 1-25-13:MK 708"
{
        Type  "SBc"
        RA            9.7031
        Dec           4.6736
        Distance   1.071e+08  # method: V
        Radius     3.427e+04
        AbsMag        -18.78
        Axis    [  0.8085   0.5283  -0.2593]
        Angle     54.4114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2966"
}

Galaxy "NGC 2967:UGC 5180:MCG 0-25-7:ZWG 7.20"
{
        Type  "Sc"
        RA            9.7008
        Dec           0.3361
        Distance   1.007e+08  # method: V
        Radius     4.392e+04
        AbsMag        -20.15
        Axis    [  0.7232   0.0558  -0.6884]
        Angle     85.1302
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2967"
}

Galaxy "NGC 2968:UGC 5190:MCG 5-23-29:ZWG 152.58"
{
        Type  "Sa"
        RA            9.7197
        Dec          31.9286
        Distance   7.733e+07  # method: V
        Radius     2.362e+04
        AbsMag        -19.07
        Axis    [  0.9961   0.0718  -0.0503]
        Angle     60.6980
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2968"
}

Galaxy "NGC 2969:MCG 1-25-21:MK 1235:IRAS 09394-0822"
{
        Type  "Sc"
        RA            9.6983
        Dec          -8.6033
        Distance   2.396e+08  # method: V
        Radius     4.879e+04
        AbsMag        -20.53
        Axis    [ -0.1763   0.3850  -0.9059]
        Angle     90.4071
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2969"
}

Galaxy "NGC 2970:MCG 5-23-30:MK 405:ZWG 152.59"
{
        Type  "E1"
        RA            9.7253
        Dec          31.9775
        Distance   8.711e+07  # method: V
        Radius          5068
        AbsMag        -17.43
        Axis    [  0.7500  -0.1577  -0.6424]
        Angle     73.8181
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2970"
}

Galaxy "NGC 2971:UGC 5197:MCG 6-22-5:ZWG 181.87"
{
        Type  "SBb"
        RA            9.7294
        Dec          36.1797
        Distance   1.938e+08  # distance uncertain!
        Radius     3.101e+04
        AbsMag        -19.07
        Axis    [ -0.1845   0.8770  -0.4436]
        Angle     63.9101
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2971"
}

Galaxy "NGC 2974:MCG 0-25-8:UGCA 172:ZWG 7.22"
{
        Type  "E4"
        RA            9.7092
        Dec          -3.6992
        Distance   7.006e+07  # method: S
        Radius     3.464e+04
        AbsMag        -19.76
        Axis    [  0.7475  -0.2433  -0.6181]
        Angle    111.3445
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2974"
}

Galaxy "NGC 2975:NPM 1"
{
        Type  "S0"
        RA            9.6878
        Dec         -16.6739
        Distance   3.072e+08  # distance uncertain!
        Radius     3.575e+04
        AbsMag        -19.07
        Axis    [  0.9696  -0.1202  -0.2133]
        Angle    127.1449
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2975"
}

Galaxy "NGC 2976:UGC 5221:MCG 11-12-25:ZWG 312.23"
{
        Type  "Sc"
        RA            9.7872
        Dec          67.9175
        Distance   4.213e+06  # method: V
        Radius          3615
        AbsMag        -14.75
        Axis    [ -0.3934   0.8964   0.2043]
        Angle     79.8987
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2976"
}

Galaxy "NGC 2977:UGC 5175:MCG 13-7-35:ZWG 350.30"
{
        Type  "Sb"
        RA            9.7294
        Dec          74.8606
        Distance   1.414e+08  # method: V
        Radius     3.703e+04
        AbsMag        -19.88
        Axis    [ -0.3958   0.8826   0.2536]
        Angle     86.9085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2977"
}

Galaxy "NGC 2978:MCG 1-25-29:IRAS 09408-0931"
{
        Type  "Sc"
        RA            9.7211
        Dec          -9.7461
        Distance   9.658e+07  # method: V
        Radius     1.545e+04
        AbsMag        -18.76
        Axis    [  0.5544   0.2171  -0.8034]
        Angle     78.8018
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2978"
}

Galaxy "NGC 2979:NGC 3050:MCG 2-25-12:IRAS 09407-1009"
{
        Type  "Sa"
        RA            9.7189
        Dec         -10.3831
        Distance   1.115e+08  # distance uncertain!
        Radius     2.433e+04
        AbsMag        -19.07
        Axis    [  0.9531   0.1054  -0.2836]
        Angle     97.5264
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2979"
}

Galaxy "NGC 2980:MCG 1-25-28:IRAS 09407-0923"
{
        Type  "SBc"
        RA            9.7197
        Dec          -9.6125
        Distance   2.697e+08  # method: T-F
        Radius     6.276e+04
        AbsMag        -20.89
        Axis    [ -0.5684   0.3490  -0.7451]
        Angle     75.1753
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2980"
}

Galaxy "NGC 2981:UGC 5208:MCG 5-23-32:ZWG 152.62"
{
        Type  "SBc"
        RA            9.7489
        Dec          31.0981
        Distance   4.833e+08  # method: V
        Radius     8.435e+04
        AbsMag        -21.05
        Axis    [  0.7807   0.4206  -0.4622]
        Angle     49.3619
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2981"
}

Galaxy "NGC 2983:ESO 566-3:MCG 3-25-17:UGCA 176"
{
        Type  "SBa"
        RA            9.7281
        Dec         -20.4775
        Distance   1.058e+08  # method: V
        Radius     3.848e+04
        AbsMag        -19.75
        Axis    [  0.4596   0.3218  -0.8278]
        Angle     67.5947
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2983"
}

Galaxy "NGC 2984:IC 556:UGC 5200:MCG 2-25-25"
{
        Type  "S0"
        RA            9.7278
        Dec          11.0614
        Distance   2.951e+08  # method: V
        Radius     3.005e+04
        AbsMag        -20.38
        Axis    [  0.8430  -0.4785  -0.2457]
        Angle    112.0088
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2984"
}

Galaxy "NGC 2985:UGC 5253:MCG 12-10-6:ZWG 333.4"
{
        Type  "Sb"
        RA            9.8392
        Dec          72.2786
        Distance    6.27e+07  # method: V
        Radius     4.195e+04
        AbsMag        -20.22
        Axis    [  0.7081  -0.4804   0.5175]
        Angle     83.7615
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2985"
}

Galaxy "NGC 2986:ESO 566-5:MCG 3-25-19:UGCA 178"
{
        Type  "E2"
        RA            9.7375
        Dec         -21.2781
        Distance   1.349e+08  # method: T-F
        Radius     6.277e+04
        AbsMag        -21.38
        Axis    [  0.2698   0.0722  -0.9602]
        Angle    123.2266
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2986"
}

Galaxy "NGC 2987:UGC 5220:MCG 1-25-17:ZWG 35.47"
{
        Type  "Sb"
        RA            9.7614
        Dec           4.9414
        Distance   1.842e+08  # method: V
        Radius     4.019e+04
        AbsMag        -19.86
        Axis    [ -0.5919   0.5251  -0.6114]
        Angle     69.5366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2987"
}

Galaxy "NGC 2988:ZWG 122.78:KCPG 214A"
{
        Type  "Sc"
        RA            9.7797
        Dec          22.0122
        Distance   3.072e+08  # distance uncertain!
        Radius     4.021e+04
        AbsMag        -19.07
        Axis    [  0.8830   0.2935   0.3663]
        Angle     83.8069
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2988"
}

Galaxy "NGC 2989:ESO 566-9:MCG 3-25-20:IRAS 09430-1808"
{
        Type  "Sc"
        RA            9.7569
        Dec         -18.3744
        Distance   1.915e+08  # method: T-F
        Radius     4.735e+04
        AbsMag        -20.24
        Axis    [  0.9167   0.2216  -0.3326]
        Angle     94.1338
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2989"
}

Galaxy "NGC 2990:UGC 5229:MCG 1-25-21:ZWG 35.51"
{
        Type  "Sc"
        RA            9.7714
        Dec           5.7089
        Distance   1.547e+08  # method: V
        Radius     2.474e+04
        AbsMag        -20.08
        Axis    [  0.6642   0.5320  -0.5253]
        Angle     50.8897
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2990"
}

Galaxy "NGC 2991:UGC 5233:MCG 4-23-33:ZWG 122.78"
{
        Type  "S0"
        RA            9.7803
        Dec          22.0133
        Distance   3.509e+08  # method: V
        Radius     7.146e+04
        AbsMag        -21.66
        Axis    [ -0.1686   0.7202  -0.6730]
        Angle     69.2294
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2991"
}

Galaxy "NGC 2992:MCG 2-25-14:ARP 245:IRAS 09432-1405"
{
        Type  "Sa"
        RA            9.7614
        Dec         -14.3269
        Distance   1.198e+08  # method: V
        Radius     6.446e+04
        AbsMag        -19.72
        Axis    [  0.9391   0.3435  -0.0117]
        Angle    107.2119
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2992"
}

Galaxy "NGC 2993:MCG 2-25-15:ARP 245:IRAS 09434-1408"
{
        Type  "Sa"
        RA            9.7633
        Dec         -14.3689
        Distance   1.242e+08  # method: V
        Radius     2.349e+04
        AbsMag         -19.4
        Axis    [  0.4486   0.2924  -0.8445]
        Angle     71.0668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2993"
}

Galaxy "NGC 2994:UGC 5239:MCG 4-23-35:ZWG 122.82"
{
        Type  "S0"
        RA            9.7878
        Dec          22.0892
        Distance   3.479e+08  # method: V
        Radius     6.577e+04
        AbsMag        -21.14
        Axis    [ -0.0115   0.7284  -0.6851]
        Angle     60.3189
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2994"
}

Galaxy "NGC 2996:ESO 566-12:MCG 3-25-22"
{
        Type  "Sa"
        RA            9.7750
        Dec         -21.5711
        Distance   4.121e+08  # method: V
        Radius      8.99e+04
        AbsMag        -21.91
        Axis    [  0.1716   0.1991  -0.9648]
        Angle     91.4724
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2996"
}

Galaxy "NGC 2997:ESO 434-35:MCG 5-23-12:UGCA 181"
{
        Type  "SBc"
        RA            9.7606
        Dec         -31.1906
        Distance   6.288e+07  # method: V
        Radius     8.139e+04
        AbsMag        -21.32
        Axis    [  0.2293   0.1562  -0.9607]
        Angle     88.9309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2997"
}

Galaxy "NGC 2998:UGC 5250:MCG 7-20-51:ZWG 210.36"
{
        Type  "SBc"
        RA            9.8119
        Dec          44.0817
        Distance   2.091e+08  # method: T-F
        Radius     8.212e+04
        AbsMag        -20.93
        Axis    [  0.8152   0.3127   0.4875]
        Angle     57.0784
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2998"
}

Galaxy "NGC 3001:ESO 434-38:MCG 5-23-14:UGCA 183"
{
        Type  "SBc"
        RA            9.7717
        Dec         -30.4369
        Distance   1.356e+08  # method: T-F
        Radius     5.721e+04
        AbsMag        -20.49
        Axis    [  0.9611   0.0877  -0.2620]
        Angle    128.8548
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3001"
}

Galaxy "NGC 3003:UGC 5251:MCG 6-22-13:ZWG 182.21"
{
        Type  "SBc"
        RA            9.8097
        Dec          33.4219
        Distance   8.163e+07  # method: T-F
        Radius     6.768e+04
        AbsMag        -19.69
        Axis    [  0.5074   0.7064   0.4934]
        Angle     48.4222
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3003"
}

Galaxy "NGC 3005:MCG 7-20-54:IRAS 09461+4421"
{
        Type  "S0"
        RA            9.8206
        Dec          44.1306
        Distance    2.44e+08  # distance uncertain!
        Radius     3.904e+04
        AbsMag        -19.07
        Axis    [ -0.6488   0.7433   0.1633]
        Angle     71.5625
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3005"
}

Galaxy "NGC 3006:MCG 7-20-55:ZWG 210.37:NPM 1"
{
        Type  "S0"
        RA            9.8214
        Dec          44.0256
        Distance   3.217e+08  # distance uncertain!
        Radius     3.275e+04
        AbsMag        -19.07
        Axis    [  0.4042   0.6901   0.6004]
        Angle     49.9634
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3006"
}

Galaxy "NGC 3007:MCG 1-25-38:IRAS 09452-0612"
{
        Type  "Sa"
        RA            9.7958
        Dec          -6.4378
        Distance   1.688e+08  # distance uncertain!
        Radius     3.192e+04
        AbsMag        -19.07
        Axis    [  0.5889   0.5596  -0.5832]
        Angle     49.4702
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3007"
}

Galaxy "NGC 3008:MCG 7-20-59:ZWG 210.39"
{
        Type  "S0"
        RA            9.8261
        Dec          44.1028
        Distance   2.676e+08  # distance uncertain!
        Radius     1.946e+04
        AbsMag        -19.07
        Axis    [ -0.2831   0.9418  -0.1812]
        Angle     60.7673
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3008"
}

Galaxy "NGC 3009:UGC 5264:MCG 7-20-62:ZWG 239.33"
{
        Type  "Sc"
        RA            9.8364
        Dec          44.2953
        Distance   2.209e+08  # method: V
        Radius      2.57e+04
        AbsMag        -20.75
        Axis    [ -0.2633   0.8522  -0.4521]
        Angle     90.5933
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3009"
}

Galaxy "NGC 3010A:UGC 5273:MCG 7-20-66:ZWG 239.35"
{
        Type  "S0"
        RA            9.8428
        Dec          44.3236
        Distance   2.555e+08  # distance uncertain!
        Radius      2.23e+04
        AbsMag        -19.07
        Axis    [ -0.2815   0.9590  -0.0319]
        Angle     55.5962
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3010A"
}

Galaxy "NGC 3010B:UGC 5273:MCG 7-30-65:ZWG 239.35"
{
        Type  "S0"
        RA            9.8425
        Dec          44.3147
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.7851   0.5338   0.3141]
        Angle     43.8886
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3010B"
}

Galaxy "NGC 3010C:UGC 5273:MCG 7-20-67:ZWG 239.35"
{
        Type  "S0"
        RA            9.8442
        Dec          44.3308
        Distance   3.072e+08  # distance uncertain!
        Radius     1.787e+04
        AbsMag        -19.07
        Axis    [  0.9015  -0.0122   0.4326]
        Angle     76.2357
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3010C"
}

Galaxy "NGC 3011:UGC 5259:MCG 5-23-38:MK 409"
{
        Type  "S0"
        RA            9.8281
        Dec          32.2217
        Distance   8.086e+07  # method: V
        Radius     1.058e+04
        AbsMag        -17.37
        Axis    [  0.8503   0.2322  -0.4723]
        Angle     52.5432
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3011"
}

Galaxy "NGC 3012:UGC 5262:MCG 6-22-17:ZWG 182.23"
{
        Type  "E0"
        RA            9.8311
        Dec          34.7147
        Distance   3.312e+08  # distance uncertain!
        Radius     4.817e+04
        AbsMag        -20.13
        Axis    [  0.7565  -0.6289  -0.1794]
        Angle     94.6326
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3012"
}

Galaxy "NGC 3013:MCG 6-22-18:ZWG 182.24:NPM 1"
{
        Type  "S0"
        RA            9.8358
        Dec          33.5697
        Distance   3.369e+08  # distance uncertain!
        Radius     3.919e+04
        AbsMag        -19.07
        Axis    [  0.5545   0.8103  -0.1895]
        Angle     39.9456
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3013"
}

Galaxy "NGC 3014:MCG 1-25-43"
{
        Type  "Sc"
        RA            9.8186
        Dec          -4.7428
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [ -0.2722   0.4245  -0.8635]
        Angle     97.2654
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3014"
}

Galaxy "NGC 3015:UGC 5261:MCG 0-25-20:ZWG 7.41"
{
        Type  "S0"
        RA            9.8228
        Dec           1.1453
        Distance   3.574e+08  # method: V
        Radius     2.599e+04
        AbsMag         -20.7
        Axis    [  0.4596   0.3414  -0.8199]
        Angle     66.4294
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3015"
}

Galaxy "NGC 3016:UGC 5266:MCG 2-25-40:ZWG 63.77"
{
        Type  "Sb"
        RA            9.8306
        Dec          12.6953
        Distance   4.206e+08  # method: V
        Radius     7.341e+04
        AbsMag        -21.85
        Axis    [  0.8188   0.2770  -0.5028]
        Angle     59.5777
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3016"
}

Galaxy "NGC 3017:MCG 0-25-19:ZWG 7.40:NPM 1"
{
        Type  "E0"
        RA            9.8175
        Dec          -2.8214
        Distance   2.754e+08  # distance uncertain!
        Radius     4.006e+04
        AbsMag        -20.13
        Axis    [  0.8412  -0.4446  -0.3078]
        Angle    124.7830
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3017"
}

Galaxy "NGC 3018:UGC 5265:MCG 0-25-21:ZWG 7.42"
{
        Type  "Sb"
        RA            9.8281
        Dec           0.6228
        Distance   9.939e+07  # method: V
        Radius     1.735e+04
        AbsMag        -18.32
        Axis    [  0.9859   0.1084  -0.1278]
        Angle     90.8713
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3018"
}

Galaxy "NGC 3019:MCG 2-25-44:ZWG 63.81"
{
        Type  "Sc"
        RA            9.8353
        Dec          12.7461
        Distance   3.369e+08  # distance uncertain!
        Radius     3.919e+04
        AbsMag        -19.07
        Axis    [  0.9701   0.2401  -0.0364]
        Angle     69.5753
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3019"
}

Galaxy "NGC 3020:UGC 5271:MCG 2-25-45:ZWG 63.82"
{
        Type  "SBc"
        RA            9.8350
        Dec          12.8136
        Distance   7.955e+07  # method: V
        Radius     3.471e+04
        AbsMag        -19.04
        Axis    [  0.2928   0.7575  -0.5835]
        Angle     43.3912
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3020"
}

Galaxy "NGC 3021:UGC 5280:MCG 6-22-19:ZWG 182.25"
{
        Type  "Sc"
        RA            9.8492
        Dec          33.5542
        Distance   8.141e+07  # method: V
        Radius     1.776e+04
        AbsMag        -18.99
        Axis    [  0.1267   0.9516  -0.2802]
        Angle     43.2367
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3021"
}

Galaxy "NGC 3022:MCG 1-25-46"
{
        Type  "S0"
        RA            9.8275
        Dec          -5.1664
        Distance    1.47e+08  # distance uncertain!
        Radius     3.422e+04
        AbsMag        -19.07
        Axis    [  0.8581  -0.4148  -0.3027]
        Angle    125.8741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3022"
}

Galaxy "NGC 3023-1:UGC 5269:MCG 0-25-22:ZWG 7.43"
{
        Type  "SBc"
        RA            9.8311
        Dec           0.6189
        Distance   1.001e+08  # method: V
        Radius     4.368e+04
        AbsMag        -19.43
        Axis    [  0.8285   0.4244  -0.3654]
        Angle     58.0034
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3023-1"
}

Galaxy "NGC 3023-2:MK 1236:NPM 1"
{
        Type  "E0"
        RA            9.8317
        Dec           0.6169
        Distance   3.468e+08  # distance uncertain!
        Radius     1.513e+04
        AbsMag        -20.13
        Axis    [  0.5044   0.0036  -0.8635]
        Angle    101.7708
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3023-2"
}

Galaxy "NGC 3024:UGC 5275:MCG 2-25-46:ZWG 63.84"
{
        Type  "Sc"
        RA            9.8408
        Dec          12.7656
        Distance   7.846e+07  # method: V
        Radius     2.282e+04
        AbsMag        -18.11
        Axis    [ -0.3931   0.9102  -0.1304]
        Angle     37.6899
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3024"
}

Galaxy "NGC 3025:ESO 566-15:MCG 4-23-18"
{
        Type  "S0"
        RA            9.8247
        Dec         -21.7414
        Distance   1.281e+08  # distance uncertain!
        Radius     2.794e+04
        AbsMag        -19.07
        Axis    [  0.2280   0.2064  -0.9516]
        Angle     84.1235
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3025"
}

Galaxy "NGC 3026:UGC 5279:MCG 5-23-43:ZWG 152.74"
{
        Type  "Irr"
        RA            9.8483
        Dec          28.5514
        Distance   9.278e+07  # method: T-F
        Radius     3.643e+04
        AbsMag        -18.57
        Axis    [  0.5687   0.7577   0.3201]
        Angle     43.6272
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3026"
}

Galaxy "NGC 3027:UGC 5316:MCG 12-10-9:ZWG 332.68"
{
        Type  "SBc"
        RA            9.9278
        Dec          72.2042
        Distance   8.503e+07  # method: T-F
        Radius     4.823e+04
        AbsMag        -19.88
        Axis    [ -0.3324   0.8344   0.4397]
        Angle     75.8761
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3027"
}

Galaxy "NGC 3028:ESO 566-16:IRAS 09475-1856"
{
        Type  "Sb"
        RA            9.8317
        Dec         -19.1844
        Distance   1.065e+08  # distance uncertain!
        Radius     1.394e+04
        AbsMag        -19.07
        Axis    [  0.2503   0.1820  -0.9509]
        Angle     91.3896
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3028"
}

Galaxy "NGC 3029:MCG 1-25-47:A 0946-07"
{
        Type  "Sc"
        RA            9.8147
        Dec          -8.0511
        Distance   2.595e+08  # method: T-F
        Radius     5.284e+04
        AbsMag         -19.8
        Axis    [  0.8972   0.1119  -0.4272]
        Angle     86.4589
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3029"
}

Galaxy "NGC 3030:MCG 2-25-21:NPM 1"
{
        Type  "S0"
        RA            9.8361
        Dec         -12.2258
        Distance    1.54e+08  # distance uncertain!
        Radius     2.239e+04
        AbsMag        -19.07
        Axis    [  0.1152   0.2679  -0.9565]
        Angle     88.6527
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3030"
}

Galaxy "M 81:NGC 3031:UGC 5318:MCG 12-10-10"
{
        Type  "Sb"
        RA            9.9258
        Dec          69.0672
        Distance   1.275e+07  # method: S
        Radius     4.617e+04
        AbsMag        -20.15
        Axis    [ -0.4601   0.8780   0.1323]
        Angle     89.2624
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 81"
}

Galaxy "NGC 3032:UGC 5292:MCG 5-23-46:ZWG 152.77"
{
        Type  "S0"
        RA            9.8689
        Dec          29.2367
        Distance   7.169e+07  # method: S
        Radius     1.772e+04
        AbsMag        -18.21
        Axis    [  0.5113   0.6751  -0.5318]
        Angle     45.5584
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3032"
}

Galaxy "M 82:NGC 3034:UGC 5322:MCG 12-10-11"
{
        Type  "Irr"
        RA            9.9317
        Dec          69.6831
        Distance   1.341e+07  # method: V
        Radius     2.184e+04
        AbsMag        -18.87
        Axis    [  0.4124   0.3536   0.8396]
        Angle     62.3995
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 82"
}

Galaxy "NGC 3035:MCG 1-25-52:IRAS 09494-0635"
{
        Type  "SBc"
        RA            9.8650
        Dec          -6.8228
        Distance   1.065e+08  # distance uncertain!
        Radius     2.634e+04
        AbsMag        -19.07
        Axis    [ -0.2988   0.4021  -0.8655]
        Angle     88.2931
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3035"
}

Galaxy "NGC 3037:ESO 499-10:MCG 4-24-2:AM 0949-264"
{
        Type  "Irr"
        RA            9.8567
        Dec         -27.0108
        Distance    5.45e+07  # method: V
        Radius      1.03e+04
        AbsMag        -17.41
        Axis    [  0.8139   0.0083  -0.5810]
        Angle    110.2350
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3037"
}

Galaxy "NGC 3038:ESO 374-2:MCG 5-24-1:AM 0949-323"
{
        Type  "Sb"
        RA            9.8542
        Dec         -32.7536
        Distance    1.27e+08  # method: T-F
        Radius     4.619e+04
        AbsMag        -20.45
        Axis    [ -0.0541   0.1585  -0.9859]
        Angle     73.7439
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3038"
}

Galaxy "NGC 3039:UGC 5297:MCG 0-25-27:ZWG 7.51"
{
        Type  "SBb"
        RA            9.8747
        Dec           2.1536
        Distance   2.432e+08  # method: V
        Radius     4.244e+04
        AbsMag        -19.96
        Axis    [  0.9958   0.0908   0.0085]
        Angle    102.0698
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3039"
}

Galaxy "NGC 3040A:UGC 5300:MCG 3-25-37:ZWG 92.67"
{
        Type  "Sb"
        RA            9.8847
        Dec          19.4328
        Distance    1.47e+08  # distance uncertain!
        Radius     1.497e+04
        AbsMag        -19.07
        Axis    [ -0.5175   0.6452  -0.5621]
        Angle     88.4844
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3040A"
}

Galaxy "NGC 3040B:UGC 5300:MCG 3-25-37:ZWG 92.67"
{
        Type  "S0"
        RA            9.8842
        Dec          19.4422
        Distance   3.072e+08  # distance uncertain!
        Radius     1.787e+04
        AbsMag        -19.07
        Axis    [ -0.5098   0.7182  -0.4736]
        Angle     63.0478
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3040B"
}

Galaxy "NGC 3041:UGC 5303:MCG 3-25-39:ZWG 92.68"
{
        Type  "SBc"
        RA            9.8853
        Dec          16.6775
        Distance   7.801e+07  # method: V
        Radius     4.198e+04
        AbsMag        -19.49
        Axis    [  0.5112   0.6324  -0.5820]
        Angle     45.9365
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3041"
}

Galaxy "NGC 3042:UGC 5307:MCG 0-25-30:ZWG 7.54"
{
        Type  "S0"
        RA            9.8889
        Dec           0.6978
        Distance   1.223e+08  # distance uncertain!
        Radius     2.135e+04
        AbsMag        -19.07
        Axis    [  0.1985   0.5537  -0.8087]
        Angle     51.4900
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3042"
}

Galaxy "NGC 3043:UGC 5327:MCG 10-14-52:ZWG 289.23"
{
        Type  "Sb"
        RA            9.9372
        Dec          59.3072
        Distance    1.42e+08  # method: V
        Radius      3.51e+04
        AbsMag        -19.59
        Axis    [  0.2688   0.6361   0.7233]
        Angle     53.9458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3043"
}

Galaxy "NGC 3044:UGC 5311:MCG 0-25-31:ZWG 7.56"
{
        Type  "SBc"
        RA            9.8944
        Dec           1.5794
        Distance    7.37e+07  # method: V
        Radius     5.038e+04
        AbsMag        -19.27
        Axis    [ -0.0617   0.9291  -0.3647]
        Angle     31.6808
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3044"
}

Galaxy "NGC 3045:ESO 566-22:MCG 3-25-28"
{
        Type  "Sb"
        RA            9.8881
        Dec         -18.6439
        Distance   1.404e+08  # distance uncertain!
        Radius     2.859e+04
        AbsMag        -19.07
        Axis    [  0.9575   0.2265  -0.1784]
        Angle    105.8053
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3045"
}

Galaxy "NGC 3047:UGC 5323:MCG 0-25-33:ZWG 7.59"
{
        Type  "S0"
        RA            9.9089
        Dec          -1.2911
        Distance   2.125e+08  # distance uncertain!
        Radius     1.237e+04
        AbsMag        -19.07
        Axis    [  0.8474  -0.4403  -0.2969]
        Angle    122.9937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3047"
}

Galaxy "NGC 3047A:UGC 5323:MCG 0-25-32:ZWG 7.59"
{
        Type  "E0"
        RA            9.9081
        Dec          -1.2878
        Distance   2.399e+08  # distance uncertain!
        Radius     1.396e+04
        AbsMag        -20.13
        Axis    [  0.7704  -0.3265  -0.5476]
        Angle    111.9747
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3047A"
}

Galaxy "NGC 3048-1:ZWG 92.71"
{
        Type  "S0"
        RA            9.9156
        Dec          16.4561
        Distance    2.03e+08  # distance uncertain!
        Radius     1.771e+04
        AbsMag        -19.07
        Axis    [ -0.1313   0.8294  -0.5430]
        Angle     45.1663
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3048-1"
}

Galaxy "NGC 3048-2:ZWG 92.71"
{
        Type  "Sa"
        RA            9.9161
        Dec          16.4592
        Distance   3.369e+08  # distance uncertain!
        Radius      1.96e+04
        AbsMag        -19.07
        Axis    [  0.9916   0.0604   0.1141]
        Angle     88.6352
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3048-2"
}

Galaxy "NGC 3049:UGC 5325:MCG 2-25-55:MK 710"
{
        Type  "SBb"
        RA            9.9136
        Dec           9.2719
        Distance   8.236e+07  # method: V
        Radius     2.635e+04
        AbsMag        -18.71
        Axis    [  0.9942  -0.0079  -0.1069]
        Angle     88.0472
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3049"
}

Galaxy "NGC 3051:ESO 499-16:MCG 4-24-4"
{
        Type  "S0"
        RA            9.8994
        Dec         -27.2861
        Distance   1.298e+08  # method: V
        Radius     3.966e+04
        AbsMag         -20.2
        Axis    [  0.8922  -0.0938  -0.4417]
        Angle    125.4072
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3051"
}

Galaxy "NGC 3052:ESO 566-26:MCG 3-25-30:IRAS 09521-1824"
{
        Type  "SBc"
        RA            9.9078
        Dec         -18.6389
        Distance   1.783e+08  # method: T-F
        Radius     5.447e+04
        AbsMag        -20.89
        Axis    [  0.3484   0.2858  -0.8927]
        Angle     67.0085
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3052"
}

Galaxy "NGC 3053:UGC 5329:MCG 3-25-40:ZWG 92.74"
{
        Type  "SBa"
        RA            9.9258
        Dec          16.4333
        Distance   1.831e+08  # method: V
        Radius     4.794e+04
        AbsMag        -20.05
        Axis    [ -0.3224   0.7774  -0.5401]
        Angle     51.0541
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3053"
}

Galaxy "NGC 3054:ESO 499-18:MCG 4-24-5:UGCA 187"
{
        Type  "SBb"
        RA            9.9078
        Dec         -25.7036
        Distance   1.276e+08  # method: T-F
        Radius      7.05e+04
        AbsMag        -20.76
        Axis    [  0.1095   0.2217  -0.9689]
        Angle     72.6128
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3054"
}

Galaxy "NGC 3055:UGC 5328:MCG 1-25-34:ZWG 35.87"
{
        Type  "SBc"
        RA            9.9214
        Dec           4.2694
        Distance   9.817e+07  # method: V
        Radius     2.998e+04
        AbsMag        -19.79
        Axis    [  0.8765   0.2650  -0.4018]
        Angle     63.5192
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3055"
}

Galaxy "NGC 3056:ESO 435-7:MCG 5-24-3:AM 0952-280"
{
        Type  "SBa"
        RA            9.9089
        Dec         -28.2983
        Distance   3.976e+07  # method: S
        Radius     1.041e+04
        AbsMag        -17.83
        Axis    [  0.9448   0.1296  -0.3008]
        Angle    118.1340
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3056"
}

Galaxy "NGC 3057:UGC 5404:MCG 14-5-10:DDO 67"
{
        Type  "Irr"
        RA           10.0942
        Dec          80.2853
        Distance   7.022e+07  # method: V
        Radius     2.247e+04
        AbsMag        -18.16
        Axis    [  0.6362  -0.4135   0.6513]
        Angle     88.9841
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3057"
}

Galaxy "NGC 3058:IC 573:MCG 2-25-26:VV 741"
{
        Type  "Sc"
        RA            9.8933
        Dec         -12.4822
        Distance    3.56e+08  # method: V
        Radius     6.732e+04
        AbsMag        -20.99
        Axis    [  0.9556   0.1670  -0.2428]
        Angle     95.7661
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3058"
}

Galaxy "NGC 3058A:MCG 2-25-26:VV 741"
{
        Type  "E0"
        RA            9.8931
        Dec         -12.4794
        Distance   5.012e+08  # distance uncertain!
        Radius     2.187e+04
        AbsMag        -20.13
        Axis    [  0.8471  -0.4100  -0.3382]
        Angle    133.2362
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3058A"
}

Galaxy "NGC 3059:ESO 37-7:IRAS 09496-7341"
{
        Type  "SBc"
        RA            9.8356
        Dec         -73.9214
        Distance   6.301e+07  # method: V
        Radius     3.299e+04
        AbsMag        -19.83
        Axis    [  0.5042  -0.0395  -0.8627]
        Angle    147.7364
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3059"
}

Galaxy "NGC 3060:UGC 5338:MCG 3-26-2:ZWG 93.3"
{
        Type  "Sb"
        RA            9.9386
        Dec          16.8314
        Distance   1.813e+08  # method: V
        Radius     5.802e+04
        AbsMag        -19.92
        Axis    [  0.7180   0.6832   0.1332]
        Angle     44.4355
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3060"
}

Galaxy "NGC 3061:UGC 5319:MCG 13-7-40:ZWG 350.36"
{
        Type  "SBc"
        RA            9.9364
        Dec          75.8664
        Distance   1.134e+08  # method: V
        Radius     2.804e+04
        AbsMag        -19.01
        Axis    [  0.6696  -0.6014   0.4358]
        Angle     71.9614
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3061"
}

Galaxy "NGC 3062:ZWG 8.2:NPM 1"
{
        Type  "Sb"
        RA            9.9431
        Dec           1.4292
        Distance    2.33e+08  # distance uncertain!
        Radius     2.034e+04
        AbsMag        -19.07
        Axis    [  0.8721   0.3465  -0.3454]
        Angle     60.6661
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3062"
}

Galaxy "NGC 3064:MCG 1-26-1"
{
        Type  "Sc"
        RA            9.9281
        Dec          -6.3642
        Distance    2.03e+08  # distance uncertain!
        Radius     3.543e+04
        AbsMag        -19.07
        Axis    [  0.9441   0.3297   0.0035]
        Angle     91.5195
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3064"
}

Galaxy "NGC 3065:UGC 5375:MCG 12-10-14:ZWG 333.10"
{
        Type  "S0"
        RA           10.0319
        Dec          72.1700
        Distance   9.373e+07  # method: V
        Radius     2.317e+04
        AbsMag        -19.69
        Axis    [  0.7623  -0.4943   0.4177]
        Angle     61.0406
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3065"
}

Galaxy "NGC 3066:UGC 5379:MCG 12-10-15:MK 133"
{
        Type  "SBb"
        RA           10.0361
        Dec          72.1256
        Distance   9.586e+07  # method: V
        Radius     1.534e+04
        AbsMag        -18.84
        Axis    [ -0.1304   0.9748  -0.1807]
        Angle     91.9725
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3066"
}

Galaxy "NGC 3067:UGC 5351:MCG 6-22-46:ZWG 182.51"
{
        Type  "SBb"
        RA            9.9725
        Dec          32.3700
        Distance   7.887e+07  # method: V
        Radius     2.753e+04
        AbsMag        -19.12
        Axis    [  0.1229   0.9846   0.1244]
        Angle     38.4155
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3067"
}

Galaxy "NGC 3068:NGC 3068A:UGC 5353:MCG 5-24-6"
{
        Type  "S0"
        RA            9.9778
        Dec          28.8781
        Distance    2.99e+08  # method: V
        Radius     4.783e+04
        AbsMag        -19.41
        Axis    [  0.9680   0.0472  -0.2465]
        Angle     58.0732
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3068"
}

Galaxy "NGC 3068B:NPM 1:ARP 174"
{
        Type  "E0"
        RA            9.9772
        Dec          28.8711
        Distance   6.026e+08  # distance uncertain!
        Radius     2.629e+04
        AbsMag        -20.13
        Axis    [  0.7611  -0.6139  -0.2095]
        Angle    100.1475
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3068B"
}

Galaxy "NGC 3069:IC 580:MCG 2-26-5:ZWG 64.10"
{
        Type  "S0"
        RA            9.9656
        Dec          10.4328
        Distance   2.546e+08  # method: V
        Radius     2.962e+04
        AbsMag        -19.36
        Axis    [ -0.6358   0.5497  -0.5418]
        Angle     72.9281
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3069"
}

Galaxy "NGC 3070:UGC 5350:MCG 2-26-6:ZWG 64.11"
{
        Type  "E0"
        RA            9.9683
        Dec          10.3603
        Distance   1.795e+08  # method: T-F
        Radius     3.656e+04
        AbsMag         -20.5
        Axis    [  0.8076  -0.5202  -0.2778]
        Angle    114.6422
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3070"
}

Galaxy "NGC 3071:ZWG 153.8:NPM 1"
{
        Type  "S0"
        RA            9.9811
        Dec          31.6208
        Distance   3.029e+08  # method: V
        Radius     2.203e+04
        AbsMag        -19.34
        Axis    [ -0.6052   0.7038  -0.3719]
        Angle     90.0574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3071"
}

Galaxy "NGC 3072:ESO 566-33:MCG 3-26-1"
{
        Type  "Sa"
        RA            9.9564
        Dec         -19.3547
        Distance   1.168e+08  # distance uncertain!
        Radius     3.228e+04
        AbsMag        -19.07
        Axis    [  0.7732   0.4053  -0.4878]
        Angle     63.8641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3072"
}

Galaxy "NGC 3073:UGC 5374:MCG 9-17-7:MK 131"
{
        Type  "S0"
        RA           10.0144
        Dec          55.6183
        Distance     1.1e+08  # method: S
        Radius      1.92e+04
        AbsMag        -18.64
        Axis    [ -0.1600   0.9141  -0.3726]
        Angle     86.8926
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3073"
}

Galaxy "NGC 3074:UGC 5366:MCG 6-22-47:ZWG 182.54"
{
        Type  "Sc"
        RA            9.9947
        Dec          35.3933
        Distance   2.445e+08  # method: V
        Radius     8.179e+04
        AbsMag        -20.97
        Axis    [ -0.2853   0.7819  -0.5542]
        Angle     94.8768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3074"
}

Galaxy "NGC 3075:UGC 5360:MCG 3-26-9:ZWG 93.12"
{
        Type  "Sc"
        RA            9.9822
        Dec          14.4194
        Distance   1.766e+08  # method: V
        Radius     3.083e+04
        AbsMag        -19.27
        Axis    [ -0.2224   0.6811  -0.6976]
        Angle     58.9612
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3075"
}

Galaxy "NGC 3076:ESO 566-34:MCG 3-26-2:PGC 28769"
{
        Type  "Sb"
        RA            9.9603
        Dec         -18.1783
        Distance   1.341e+08  # distance uncertain!
        Radius      1.95e+04
        AbsMag        -19.07
        Axis    [  0.9513  -0.1693  -0.2575]
        Angle    129.1845
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3076"
}

Galaxy "NGC 3077:UGC 5398:MCG 12-10-17:ZWG 333.13"
{
        Type  "Irr"
        RA           10.0556
        Dec          68.7350
        Distance   1.317e+07  # method: S
        Radius          9957
        AbsMag        -17.43
        Axis    [  0.9198  -0.2202   0.3249]
        Angle     43.0539
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3077"
}

Galaxy "NGC 3078:ESO 499-27:MCG 4-24-9:AM 0956-264"
{
        Type  "E3"
        RA            9.9733
        Dec         -26.9261
        Distance   1.147e+08  # method: S
        Radius     4.503e+04
        AbsMag        -20.63
        Axis    [ -0.3632   0.3042  -0.8807]
        Angle    139.2523
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3078"
}

Galaxy "NGC 3079:UGC 5387:MCG 9-17-10:ZWG 266.8"
{
        Type  "SBc"
        RA           10.0325
        Dec          55.6814
        Distance    6.94e+07  # method: T-F
        Radius     8.176e+04
        AbsMag        -20.14
        Axis    [ -0.6884   0.7029   0.1788]
        Angle     88.1809
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3079"
}

Galaxy "NGC 3080:UGC 5372:MCG 2-26-15:MK 1243"
{
        Type  "Sa"
        RA            9.9986
        Dec          13.0442
        Distance   4.961e+08  # method: V
        Radius     6.494e+04
        AbsMag        -21.41
        Axis    [  0.7609   0.1091  -0.6397]
        Angle     67.0152
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3080"
}

Galaxy "NGC 3081:IC 2529:ESO 499-31:MCG 4-24-12"
{
        Type  "SBa"
        RA            9.9914
        Dec         -22.8261
        Distance    1.22e+08  # method: V
        Radius     3.905e+04
        AbsMag        -19.96
        Axis    [  0.6099   0.0835  -0.7881]
        Angle     91.3023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3081"
}

Galaxy "NGC 3082:ESO 435-18:MCG 5-24-11:AM 0956-300"
{
        Type  "S0"
        RA            9.9811
        Dec         -30.3575
        Distance   1.065e+08  # distance uncertain!
        Radius     2.789e+04
        AbsMag        -19.07
        Axis    [  0.9144   0.2726  -0.2993]
        Angle    106.6553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3082"
}

Galaxy "NGC 3083:MCG 0-26-2:ZWG 8.11"
{
        Type  "Sa"
        RA            9.9969
        Dec          -2.8775
        Distance   3.027e+08  # method: V
        Radius     4.842e+04
        AbsMag        -20.24
        Axis    [  0.9313   0.3267  -0.1612]
        Angle     71.3039
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3083"
}

Galaxy "NGC 3084:IC 2528:ESO 499-29:MCG 4-24-10"
{
        Type  "SBb"
        RA            9.9850
        Dec         -27.1283
        Distance    1.26e+08  # method: V
        Radius     3.298e+04
        AbsMag        -19.73
        Axis    [  0.9439  -0.1172  -0.3089]
        Angle    134.3181
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3084"
}

Galaxy "NGC 3085:ESO 566-38:MCG 3-26-3"
{
        Type  "S0"
        RA            9.9914
        Dec         -19.4928
        Distance   1.341e+08  # distance uncertain!
        Radius     2.341e+04
        AbsMag        -19.07
        Axis    [  0.0387   0.3951  -0.9178]
        Angle     46.7776
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3085"
}

Galaxy "NGC 3086:MCG 0-26-3:ZWG 8.12"
{
        Type  "Sb"
        RA           10.0028
        Dec          -2.9758
        Distance   4.578e+08  # method: V
        Radius      7.99e+04
        AbsMag        -21.04
        Axis    [ -0.5500   0.4976  -0.6708]
        Angle     50.3641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3086"
}

Galaxy "NGC 3087:ESO 374-15:MCG 6-22-5:AM 0956-335"
{
        Type  "E0"
        RA            9.9856
        Dec         -34.2256
        Distance   1.141e+08  # method: S
        Radius      3.32e+04
        AbsMag        -20.92
        Axis    [  0.8581  -0.3274  -0.3957]
        Angle    152.0610
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3087"
}

Galaxy "NGC 3088:NGC 3088A:UGC 5384:MCG 4-24-10"
{
        Type  "S0"
        RA           10.0189
        Dec          22.4061
        Distance   1.851e+08  # distance uncertain!
        Radius     1.346e+04
        AbsMag        -19.07
        Axis    [  0.9045   0.3866  -0.1801]
        Angle     48.4472
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3088"
}

Galaxy "NGC 3088B:UGC 5384:MCG 4-24-11:ZWG 123.13"
{
        Type  "Sc"
        RA           10.0192
        Dec          22.4017
        Distance   3.072e+08  # distance uncertain!
        Radius     2.234e+04
        AbsMag        -19.07
        Axis    [ -0.5848   0.8104   0.0357]
        Angle     45.5264
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3088B"
}

Galaxy "NGC 3089:ESO 435-24:MCG 5-24-14:AM 0957-280"
{
        Type  "SBb"
        RA            9.9933
        Dec         -28.3311
        Distance   1.311e+08  # method: T-F
        Radius     3.432e+04
        AbsMag        -19.72
        Axis    [ -0.2141   0.1678  -0.9623]
        Angle     71.2234
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3089"
}

Galaxy "NGC 3090:MCG 0-26-5:ZWG 8.16:IRAS 09579-0243"
{
        Type  "E0"
        RA           10.0083
        Dec          -2.9686
        Distance   3.076e+08  # method: T-F
        Radius     7.606e+04
        AbsMag        -21.27
        Axis    [  0.4029   0.0398  -0.9144]
        Angle    104.3217
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3090"
}

Galaxy "NGC 3091:ESO 566-41:MCG 3-26-7:HCG 42A"
{
        Type  "E1"
        RA           10.0039
        Dec         -19.6367
        Distance   1.769e+08  # method: T-F
        Radius     7.717e+04
        AbsMag        -21.47
        Axis    [ -0.1309   0.2618  -0.9562]
        Angle    127.2508
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3091"
}

Galaxy "NGC 3092:MCG 0-26-8:ZWG 8.19"
{
        Type  "Sa"
        RA           10.0131
        Dec          -3.0122
        Distance   2.805e+08  # method: V
        Radius     5.305e+04
        AbsMag        -20.27
        Axis    [  0.9774   0.1758  -0.1171]
        Angle     88.8624
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3092"
}

Galaxy "NGC 3093:MCG 0-26-7:ZWG 8.21:NPM 1"
{
        Type  "E0"
        RA           10.0147
        Dec          -2.9714
        Distance   2.917e+08  # method: V
        Radius      2.97e+04
        AbsMag        -19.56
        Axis    [  0.6739  -0.2235  -0.7042]
        Angle    108.0767
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3093"
}

Galaxy "NGC 3094:UGC 5390:MCG 3-26-15:ZWG 93.23"
{
        Type  "SBa"
        RA           10.0236
        Dec          15.7700
        Distance   1.233e+08  # method: V
        Radius      2.87e+04
        AbsMag        -19.49
        Axis    [  0.7924   0.2989  -0.5317]
        Angle     54.1249
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3094"
}

Galaxy "NGC 3095:ESO 435-26:MCG 5-24-16:UGCA 192"
{
        Type  "SBc"
        RA           10.0014
        Dec         -31.5533
        Distance   1.166e+08  # method: T-F
        Radius     6.105e+04
        AbsMag        -20.47
        Axis    [ -0.0160   0.1571  -0.9875]
        Angle     70.9579
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3095"
}

Galaxy "NGC 3096:ESO 566-42:MCG 3-26-8:HCG 42B"
{
        Type  "S0"
        RA           10.0092
        Dec         -19.6622
        Distance   2.052e+08  # method: V
        Radius     2.984e+04
        AbsMag        -19.19
        Axis    [ -0.4811   0.2609  -0.8370]
        Angle     98.0782
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3096"
}

Galaxy "NGC 3098:UGC 5397:MCG 4-24-12:ZWG 123.14"
{
        Type  "Sa"
        RA           10.0378
        Dec          24.7114
        Distance   7.375e+07  # method: V
        Radius      2.36e+04
        AbsMag        -18.77
        Axis    [  0.4806   0.8358   0.2656]
        Angle     38.3891
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3098"
}

Galaxy "NGC 3099A:MCG 6-22-59:ZWG 182.64:NPM 1"
{
        Type  "E0"
        RA           10.0433
        Dec          32.7072
        Distance   2.754e+08  # distance uncertain!
        Radius     2.404e+04
        AbsMag        -20.13
        Axis    [  0.7421  -0.6412  -0.1951]
        Angle     97.7548
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3099A"
}

Galaxy "NGC 3099B:MCG 6-22-58"
{
        Type  "E0"
        RA           10.0417
        Dec          32.7144
        Distance   5.012e+08  # distance uncertain!
        Radius     2.187e+04
        AbsMag        -20.13
        Axis    [  0.7423  -0.6411  -0.1951]
        Angle     97.7366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3099B"
}

Galaxy "NGC 3100:NGC 3103:ESO 435-30:MCG 5-24-18"
{
        Type  "S0"
        RA           10.0111
        Dec         -31.6642
        Distance    5.59e+07  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [ -0.4046   0.0924  -0.9098]
        Angle     76.2984
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3100"
}

Galaxy "NGC 3101:MCG 0-26-11:ZWG 8.24"
{
        Type  "Sa"
        RA           10.0264
        Dec          -2.9947
        Distance   2.555e+08  # distance uncertain!
        Radius      4.46e+04
        AbsMag        -19.07
        Axis    [ -0.6903   0.4527  -0.5644]
        Angle     49.2487
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3101"
}

Galaxy "NGC 3102:UGC 5418:MCG 10-15-7:ZWG 289.30"
{
        Type  "S0"
        RA           10.0753
        Dec          60.1078
        Distance   1.451e+08  # method: V
        Radius     1.899e+04
        AbsMag        -18.94
        Axis    [  0.6262  -0.7795  -0.0133]
        Angle     79.2994
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3102"
}

Galaxy "NGC 3104:UGC 5414:MCG 7-21-7:ZWG 211.6"
{
        Type  "Irr"
        RA           10.0658
        Dec          40.7572
        Distance   3.828e+07  # method: V
        Radius     1.837e+04
        AbsMag        -16.55
        Axis    [  0.9708  -0.0659   0.2306]
        Angle     65.1315
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3104"
}

Galaxy "NGC 3106:UGC 5419:MCG 5-24-9:ZWG 153.13"
{
        Type  "S0"
        RA           10.0681
        Dec          31.1858
        Distance   2.933e+08  # method: V
        Radius     7.679e+04
        AbsMag        -21.47
        Axis    [  0.7645  -0.6187  -0.1811]
        Angle     98.4979
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3106"
}

Galaxy "NGC 3107:UGC 5425:MCG 2-26-22:ZWG 64.48"
{
        Type  "Sc"
        RA           10.0728
        Dec          13.6219
        Distance    1.41e+08  # method: V
        Radius     1.435e+04
        AbsMag        -19.38
        Axis    [ -0.1608   0.5838  -0.7958]
        Angle     74.3255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3107"
}

Galaxy "NGC 3108:ESO 435-32:MCG 5-24-19:AM 1000-312"
{
        Type  "Sa"
        RA           10.0414
        Dec         -31.6758
        Distance   1.411e+08  # method: T-F
        Radius     5.129e+04
        AbsMag        -20.48
        Axis    [  0.2057   0.1288  -0.9701]
        Angle     83.3814
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3108"
}

Galaxy "NGC 3109:ESO 499-36:MCG 4-24-13:UGCA 194"
{
        Type  "Irr"
        RA           10.0517
        Dec         -26.1583
        Distance   3.284e+07  # method: V
        Radius     9.124e+04
        AbsMag        -19.61
        Axis    [  0.5616   0.4755  -0.6771]
        Angle     46.8824
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3109"
}

Galaxy "NGC 3111:UGC 5441:MCG 8-19-2:ZWG 240.7"
{
        Type  "S0"
        RA           10.1019
        Dec          47.2631
        Distance    1.54e+08  # distance uncertain!
        Radius     2.015e+04
        AbsMag        -19.07
        Axis    [ -0.1335   0.8828  -0.4504]
        Angle     73.2515
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3111"
}

Galaxy "NGC 3112:ESO 567-11"
{
        Type  "Sc"
        RA           10.0664
        Dec         -20.7822
        Distance   3.369e+08  # distance uncertain!
        Radius     4.899e+04
        AbsMag        -19.07
        Axis    [  0.8800   0.4285  -0.2049]
        Angle     78.9514
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3112"
}

Galaxy "NGC 3113:ESO 435-35:MCG 5-24-21:UGCA 198"
{
        Type  "SBc"
        RA           10.0739
        Dec         -28.4447
        Distance   6.279e+07  # method: T-F
        Radius     3.014e+04
        AbsMag        -18.12
        Axis    [  0.5835   0.3250  -0.7443]
        Angle     60.6117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3113"
}

Galaxy "NGC 3115:MCG 1-26-18:UGCA 199"
{
        Type  "S0"
        RA           10.0872
        Dec          -7.7181
        Distance   3.158e+07  # method: S
        Radius     3.307e+04
        AbsMag        -19.83
        Axis    [  0.9468   0.2891  -0.1411]
        Angle     81.1879
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3115"
}

Galaxy "NGC 3116:MCG 5-24-12:ZWG 153.17:ARAK 230"
{
        Type  "E0"
        RA           10.1125
        Dec          31.0983
        Distance   4.366e+08  # distance uncertain!
        Radius      2.54e+04
        AbsMag        -20.13
        Axis    [  0.7407  -0.6400  -0.2046]
        Angle     99.4749
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3116"
}

Galaxy "NGC 3117:UGC 5445:MCG 1-26-14:ZWG 36.38"
{
        Type  "E0"
        RA           10.1028
        Dec           2.9133
        Distance   2.512e+08  # distance uncertain!
        Radius     3.654e+04
        AbsMag        -20.13
        Axis    [  0.8098  -0.4985  -0.3094]
        Angle    121.3723
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3117"
}

Galaxy "NGC 3118:UGC 5452:MCG 6-22-74:ZWG 182.75"
{
        Type  "Sc"
        RA           10.1197
        Dec          33.0272
        Distance   7.284e+07  # method: V
        Radius     2.649e+04
        AbsMag        -17.44
        Axis    [  0.8069   0.2727   0.5240]
        Angle     75.4245
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3118"
}

Galaxy "NGC 3119:ZWG 93.45:NPM 1"
{
        Type  "E0"
        RA           10.1131
        Dec          14.3056
        Distance   3.981e+08  # distance uncertain!
        Radius     2.895e+04
        AbsMag        -20.13
        Axis    [  0.7867  -0.5542  -0.2718]
        Angle    112.3292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3119"
}

Galaxy "NGC 3120:ESO 374-29:MCG 6-22-17:IRAS 10031-3358"
{
        Type  "SBc"
        RA           10.0894
        Dec         -34.2208
        Distance   9.853e+07  # method: T-F
        Radius     2.579e+04
        AbsMag         -18.9
        Axis    [  0.9584   0.0808  -0.2738]
        Angle    133.5399
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3120"
}

Galaxy "NGC 3121:UGC 5450:MCG 3-26-27:ZWG 93.46"
{
        Type  "E0"
        RA           10.1142
        Dec          14.3739
        Distance   4.247e+08  # method: V
        Radius      1.05e+05
        AbsMag        -21.67
        Axis    [  0.7767  -0.4589  -0.4315]
        Angle    102.0958
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3121"
}

Galaxy "NGC 3122:NGC 3110:NGC 3518:MCG 1-26-14"
{
        Type  "Sb"
        RA           10.0669
        Dec          -6.4747
        Distance   2.456e+08  # method: V
        Radius     5.716e+04
        AbsMag        -20.88
        Axis    [ -0.6055   0.3611  -0.7092]
        Angle     70.1660
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3122"
}

Galaxy "NGC 3124:ESO 567-17:MCG 3-26-24:UGCA 202"
{
        Type  "SBc"
        RA           10.1111
        Dec         -19.2217
        Distance   1.764e+08  # method: V
        Radius     7.442e+04
        AbsMag        -20.86
        Axis    [  0.9389  -0.1250  -0.3207]
        Angle    123.0344
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3124"
}

Galaxy "NGC 3125:ESO 435-41:MCG 5-24-22:AM 1004-294"
{
        Type  "E0"
        RA           10.1092
        Dec         -29.9356
        Distance   6.315e+07  # method: V
        Radius      1.01e+04
        AbsMag        -17.93
        Axis    [  0.1370   0.0449  -0.9896]
        Angle    128.6733
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3125"
}

Galaxy "NGC 3126:UGC 5466:MCG 5-24-19:ZWG 153.23"
{
        Type  "Sb"
        RA           10.1389
        Dec          31.8636
        Distance   2.468e+08  # method: V
        Radius     1.005e+05
        AbsMag        -20.89
        Axis    [ -0.3692   0.8799   0.2991]
        Angle     44.3633
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3126"
}

Galaxy "NGC 3127:MCG 3-26-22"
{
        Type  "Sb"
        RA           10.1067
        Dec         -16.1261
        Distance   1.768e+08  # distance uncertain!
        Radius     3.085e+04
        AbsMag        -19.07
        Axis    [  0.8731   0.4472  -0.1941]
        Angle     69.6445
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3127"
}

Galaxy "NGC 3128:MCG 3-26-20"
{
        Type  "Sb"
        RA           10.1003
        Dec         -16.1228
        Distance   2.253e+08  # method: V
        Radius     5.243e+04
        AbsMag         -19.9
        Axis    [ -0.7163   0.1811  -0.6739]
        Angle     77.5238
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3128"
}

Galaxy "NGC 3130:UGC 5468:MCG 2-26-26:ZWG 64.72"
{
        Type  "Sa"
        RA           10.1367
        Dec           9.9767
        Distance   3.867e+08  # method: V
        Radius     5.624e+04
        AbsMag        -21.07
        Axis    [  0.9961   0.0297  -0.0830]
        Angle     82.8514
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3130"
}

Galaxy "NGC 3131:UGC 5471:MCG 3-26-33:ZWG 93.60"
{
        Type  "SBb"
        RA           10.1433
        Dec          18.2311
        Distance   2.454e+08  # method: V
        Radius     8.564e+04
        AbsMag        -20.48
        Axis    [  0.9082   0.3603   0.2131]
        Angle     60.6686
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3131"
}

Galaxy "NGC 3133"
{
        Type  "Sb"
        RA           10.1200
        Dec         -11.9653
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.9657   0.0970  -0.2407]
        Angle     99.1824
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3133"
}

Galaxy "NGC 3134:MCG 2-26-31:ZWG 64.88:"
{
        Type  "S0"
        RA           10.2081
        Dec          12.3769
        Distance   1.851e+08  # distance uncertain!
        Radius     2.154e+04
        AbsMag        -19.07
        Axis    [  0.9182   0.3563   0.1732]
        Angle     64.5114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3134"
}

Galaxy "NGC 3135:UGC 5486:MCG 8-19-7:ZWG 240.15"
{
        Type  "Sc"
        RA           10.1817
        Dec          45.9506
        Distance   3.389e+08  # method: V
        Radius     4.437e+04
        AbsMag        -20.68
        Axis    [  0.5903   0.8038   0.0741]
        Angle     35.4666
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3135"
}

Galaxy "NGC 3136:ESO 92-8"
{
        Type  "E0"
        RA           10.0967
        Dec         -67.3775
        Distance   8.006e+07  # method: S
        Radius      3.61e+04
        AbsMag        -20.25
        Axis    [  0.7094  -0.1949  -0.6774]
        Angle    174.7481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3136"
}

Galaxy "NGC 3136A:ESO 92-7:FGCE 794:AM 1002-671"
{
        Type  "Irr"
        RA           10.0592
        Dec         -67.4489
        Distance   4.571e+08  # distance uncertain!
        Radius      1.33e+05
        AbsMag        -20.13
        Axis    [  0.5145   0.1934  -0.8354]
        Angle     84.5110
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3136A"
}

Galaxy "NGC 3136B:ESO 92-13:AM 1007-664"
{
        Type  "E0"
        RA           10.1703
        Dec         -67.0050
        Distance   6.941e+07  # method: S
        Radius     1.413e+04
        AbsMag        -18.84
        Axis    [  0.7029  -0.1988  -0.6829]
        Angle    174.2943
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3136B"
}

Galaxy "NGC 3137:ESO 435-47:MCG 5-24-24:UGCA 203"
{
        Type  "SBc"
        RA           10.1519
        Dec         -29.0636
        Distance   5.649e+07  # method: T-F
        Radius     5.094e+04
        AbsMag        -18.99
        Axis    [  0.9557   0.2500  -0.1552]
        Angle    125.3650
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3137"
}

Galaxy "NGC 3138:MCG 2-26-32"
{
        Type  "Sc"
        RA           10.1544
        Dec         -11.9572
        Distance   3.722e+08  # method: T-F
        Radius     6.497e+04
        AbsMag        -19.69
        Axis    [  0.7371   0.4300  -0.5213]
        Angle     52.2902
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3138"
}

Galaxy "NGC 3139:MCG 2-26-34:NPM 1"
{
        Type  "S0"
        RA           10.1681
        Dec         -11.7778
        Distance   1.688e+08  # distance uncertain!
        Radius     3.683e+04
        AbsMag        -19.07
        Axis    [  0.6092   0.0597  -0.7908]
        Angle     84.2143
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3139"
}

Galaxy "NGC 3140:MCG 3-26-28"
{
        Type  "Sc"
        RA           10.1575
        Dec         -16.6278
        Distance   3.985e+08  # method: V
        Radius     5.217e+04
        AbsMag        -20.53
        Axis    [  0.8205  -0.0841  -0.5655]
        Angle    104.1322
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3140"
}

Galaxy "NGC 3141:NPM 1"
{
        Type  "Sc"
        RA           10.1553
        Dec         -16.6531
        Distance   3.527e+08  # distance uncertain!
        Radius     2.052e+04
        AbsMag        -19.07
        Axis    [  0.9557   0.1514  -0.2525]
        Angle     99.8283
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3141"
}

Galaxy "NGC 3142:MCG 1-26-28"
{
        Type  "S0"
        RA           10.1683
        Dec          -8.4794
        Distance   1.938e+08  # distance uncertain!
        Radius     2.819e+04
        AbsMag        -19.07
        Axis    [  0.9406  -0.2303  -0.2494]
        Angle    120.4206
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3142"
}

Galaxy "NGC 3143:MCG 2-26-33"
{
        Type  "SBb"
        RA           10.1675
        Dec         -12.5819
        Distance   1.757e+08  # method: V
        Radius       2.3e+04
        AbsMag        -18.56
        Axis    [  0.2795   0.2276  -0.9328]
        Angle     71.8575
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3143"
}

Galaxy "NGC 3145:MCG 2-26-36"
{
        Type  "SBc"
        RA           10.1692
        Dec         -12.4344
        Distance   1.797e+08  # method: T-F
        Radius     7.841e+04
        AbsMag         -21.2
        Axis    [  0.9773   0.0992  -0.1870]
        Angle    104.3697
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3145"
}

Galaxy "NGC 3146:ESO 567-23:MCG 3-26-29"
{
        Type  "SBb"
        RA           10.1858
        Dec         -20.8708
        Distance   1.341e+08  # distance uncertain!
        Radius      1.95e+04
        AbsMag        -19.07
        Axis    [  0.3058   0.0974  -0.9471]
        Angle     91.6651
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3146"
}

Galaxy "NGC 3147:UGC 5532:MCG 12-10-25:ZWG 333.22"
{
        Type  "Sc"
        RA           10.2814
        Dec          73.4003
        Distance   1.302e+08  # method: V
        Radius     7.388e+04
        AbsMag        -21.61
        Axis    [ -0.1178   0.9841  -0.1330]
        Angle     84.8658
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3147"
}

Galaxy "NGC 3149:ESO 19-1:IRAS 10043-8010"
{
        Type  "Sb"
        RA           10.0619
        Dec         -80.4222
        Distance    8.86e+07  # distance uncertain!
        Radius     2.577e+04
        AbsMag        -19.07
        Axis    [  0.8675   0.0187  -0.4970]
        Angle    181.2779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3149"
}

Galaxy "NGC 3150:MCG 7-21-17:ZWG 211.19"
{
        Type  "S0"
        RA           10.2239
        Dec          38.6581
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [ -0.3683   0.8012  -0.4717]
        Angle     95.1133
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3150"
}

Galaxy "NGC 3151:MCG 7-21-18:ZWG 211.20"
{
        Type  "S0"
        RA           10.2247
        Dec          38.6203
        Distance   3.346e+08  # method: V
        Radius     3.893e+04
        AbsMag        -19.96
        Axis    [ -0.6180   0.7577  -0.2098]
        Angle     79.1809
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3151"
}

Galaxy "NGC 3152:MCG 7-21-18A:ZWG 211.21"
{
        Type  "S0"
        RA           10.2261
        Dec          38.8436
        Distance   3.042e+08  # method: V
        Radius      3.54e+04
        AbsMag        -19.25
        Axis    [  0.8600   0.2723  -0.4317]
        Angle     43.2608
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3152"
}

Galaxy "NGC 3153:UGC 5505:MCG 2-26-32:ZWG 64.90"
{
        Type  "Sc"
        RA           10.2139
        Dec          12.6667
        Distance    1.16e+08  # method: T-F
        Radius     3.542e+04
        AbsMag        -19.25
        Axis    [ -0.7363   0.5185  -0.4348]
        Angle     72.3362
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3153"
}

Galaxy "NGC 3154:UGC 5507:MCG 3-26-40:ZWG 93.71"
{
        Type  "Sb"
        RA           10.2169
        Dec          17.0344
        Distance    1.54e+08  # distance uncertain!
        Radius     2.015e+04
        AbsMag        -19.07
        Axis    [ -0.2137   0.8575  -0.4681]
        Angle     39.1957
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3154"
}

Galaxy "NGC 3155:NGC 3194:UGC 5538:MCG 12-10-26"
{
        Type  "S0"
        RA           10.2942
        Dec          74.3478
        Distance    1.36e+08  # method: V
        Radius     1.978e+04
        AbsMag         -19.3
        Axis    [  0.6173  -0.0613   0.7843]
        Angle     69.5146
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3155"
}

Galaxy "NGC 3156:UGC 5503:MCG 1-26-19:ZWG 36.57"
{
        Type  "S0"
        RA           10.2114
        Dec           3.1297
        Distance   7.302e+07  # method: S
        Radius     2.018e+04
        AbsMag        -18.65
        Axis    [  0.9657   0.1968  -0.1695]
        Angle     71.1018
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3156"
}

Galaxy "NGC 3157:IC 2555:ESO 435-51:MCG 5-24-26"
{
        Type  "SBc"
        RA           10.1950
        Dec         -31.6428
        Distance   1.191e+08  # method: T-F
        Radius     4.329e+04
        AbsMag        -18.91
        Axis    [  0.8731   0.3976  -0.2822]
        Angle     91.0082
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3157"
}

Galaxy "NGC 3158:UGC 5511:MCG 7-21-20:ZWG 211.22"
{
        Type  "E3"
        RA           10.2306
        Dec          38.7656
        Distance   2.705e+08  # method: T-F
        Radius     7.869e+04
        AbsMag        -21.69
        Axis    [  0.7003  -0.6930  -0.1715]
        Angle     94.8969
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3158"
}

Galaxy "NGC 3159:MCG 7-21-21:ZWG 211.23:NPM 1"
{
        Type  "E2"
        RA           10.2311
        Dec          38.6550
        Distance   3.245e+08  # method: V
        Radius     5.663e+04
        AbsMag        -20.39
        Axis    [ -0.0217   0.7219  -0.6916]
        Angle    100.4485
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3159"
}

Galaxy "NGC 3160:UGC 5513:MCG 7-21-23:ZWG 211.24"
{
        Type  "S0"
        RA           10.2319
        Dec          38.8428
        Distance    2.33e+08  # distance uncertain!
        Radius     4.406e+04
        AbsMag        -19.07
        Axis    [ -0.5739   0.7907   0.2132]
        Angle     56.7949
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3160"
}

Galaxy "NGC 3161:MCG 7-21-22:ZWG 211.25:ARAK 234"
{
        Type  "E2"
        RA           10.2331
        Dec          38.6578
        Distance   2.907e+08  # method: V
        Radius     3.382e+04
        AbsMag        -19.25
        Axis    [  0.7051  -0.6841  -0.1863]
        Angle     93.6168
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3161"
}

Galaxy "NGC 3162:NGC 3575:UGC 5510:MCG 4-24-19"
{
        Type  "SBc"
        RA           10.2253
        Dec          22.7372
        Distance   7.266e+07  # method: V
        Radius     3.276e+04
        AbsMag        -19.54
        Axis    [  0.9484  -0.2189  -0.2295]
        Angle     76.5948
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3162"
}

Galaxy "NGC 3163:UGC 5517:MCG 7-21-26:ZWG 211.27"
{
        Type  "S0"
        RA           10.2353
        Dec          38.6528
        Distance    2.92e+08  # method: V
        Radius     5.096e+04
        AbsMag        -20.46
        Axis    [  0.9284  -0.3533  -0.1152]
        Angle     69.2516
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3163"
}

Galaxy "NGC 3164:UGC 5527:MCG 10-15-36:ZWG 290.18"
{
        Type  "S0"
        RA           10.2531
        Dec          56.6722
        Distance   3.598e+08  # method: V
        Radius      4.71e+04
        AbsMag        -20.71
        Axis    [  0.8089  -0.4875   0.3286]
        Angle     89.2301
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3164"
}

Galaxy "NGC 3165:UGC 5512:MCG 1-26-23:ZWG 36.63"
{
        Type  "Irr"
        RA           10.2253
        Dec           3.3750
        Distance   7.579e+07  # method: V
        Radius     1.433e+04
        AbsMag        -17.33
        Axis    [ -0.7145   0.4205  -0.5591]
        Angle     81.4060
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3165"
}

Galaxy "NGC 3166:UGC 5516:MCG 1-26-24:ZWG 36.64"
{
        Type  "SBa"
        RA           10.2292
        Dec           3.4258
        Distance   7.638e+07  # method: V
        Radius     5.332e+04
        AbsMag        -20.45
        Axis    [  0.6859   0.4852  -0.5423]
        Angle     44.2177
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3166"
}

Galaxy "NGC 3168:UGC 5536:MCG 10-15-52:ZWG 290.23"
{
        Type  "E0"
        RA           10.2731
        Dec          60.2350
        Distance   4.319e+08  # method: V
        Radius     6.282e+04
        AbsMag        -21.21
        Axis    [  0.7899  -0.4641  -0.4009]
        Angle     50.9059
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3168"
}

Galaxy "NGC 3169:UGC 5525:MCG 1-26-26:ZWG 36.66"
{
        Type  "Sa"
        RA           10.2372
        Dec           3.4669
        Distance   7.135e+07  # method: V
        Radius     4.358e+04
        AbsMag         -20.5
        Axis    [  0.9427   0.0382  -0.3314]
        Angle     76.5011
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3169"
}

Galaxy "NGC 3171:ESO 567-31:MCG 3-26-32:NPM 1"
{
        Type  "S0"
        RA           10.2600
        Dec         -20.6475
        Distance   1.724e+08  # method: V
        Radius     4.012e+04
        AbsMag        -19.72
        Axis    [ -0.6149   0.1978  -0.7634]
        Angle     91.6414
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3171"
}

Galaxy "NGC 3172:MCG 15-1-11:ZWG 370.8:ZWG 370.2"
{
        Type  "S0"
        RA           11.7872
        Dec          89.0936
        Distance    2.44e+08  # distance uncertain!
        Radius     3.549e+04
        AbsMag        -19.07
        Axis    [  0.5417  -0.4495   0.7103]
        Angle     77.5616
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3172"
}

Galaxy "NGC 3173:ESO 500-16:MCG 4-24-22:AM 1012-272"
{
        Type  "Sc"
        RA           10.2431
        Dec         -27.6933
        Distance   1.279e+08  # method: V
        Radius     3.907e+04
        AbsMag        -19.37
        Axis    [  0.9388  -0.0624  -0.3387]
        Angle    128.5704
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3173"
}

Galaxy "NGC 3174:NGC 3144:UGC 5519:MCG 12-10-23"
{
        Type  "SBa"
        RA           10.2589
        Dec          74.2206
        Distance   2.946e+08  # method: V
        Radius     5.142e+04
        AbsMag        -20.48
        Axis    [  0.6919  -0.4052   0.5976]
        Angle     90.5235
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3174"
}

Galaxy "NGC 3175:ESO 436-3:MCG 5-24-28:UGCA 207"
{
        Type  "SBb"
        RA           10.2450
        Dec         -28.8711
        Distance   5.037e+07  # method: T-F
        Radius     3.737e+04
        AbsMag        -18.84
        Axis    [  0.8343   0.3464  -0.4288]
        Angle     76.3049
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3175"
}

Galaxy "NGC 3177:UGC 5544:MCG 4-24-23:ZWG 123.32"
{
        Type  "Sc"
        RA           10.2761
        Dec          21.1231
        Distance   7.293e+07  # method: V
        Radius     1.591e+04
        AbsMag        -18.75
        Axis    [ -0.1599   0.6793  -0.7163]
        Angle     61.6585
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3177"
}

Galaxy "NGC 3178:MCG 3-26-34"
{
        Type  "Sc"
        RA           10.2692
        Dec         -15.7911
        Distance   1.731e+08  # method: V
        Radius     3.526e+04
        AbsMag        -20.22
        Axis    [  0.7686   0.2360  -0.5946]
        Angle     66.9343
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3178"
}

Galaxy "NGC 3179:UGC 5555:MCG 7-21-36:ZWG 211.37"
{
        Type  "S0"
        RA           10.2992
        Dec          41.1147
        Distance   3.395e+08  # method: V
        Radius     8.889e+04
        AbsMag        -20.99
        Axis    [  0.7963   0.2131   0.5660]
        Angle     66.7490
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3179"
}

Galaxy "NGC 3182:UGC 5568:MCG 10-15-62:ZWG 290.27"
{
        Type  "Sa"
        RA           10.3258
        Dec          58.2061
        Distance   1.033e+08  # method: V
        Radius     2.705e+04
        AbsMag         -19.6
        Axis    [ -0.2406   0.9411  -0.2378]
        Angle     78.7191
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3182"
}

Galaxy "NGC 3184:UGC 5557:MCG 7-21-37:ZWG 211.38"
{
        Type  "SBc"
        RA           10.3047
        Dec          41.4233
        Distance   3.742e+07  # method: V
        Radius     4.027e+04
        AbsMag           -20
        Axis    [ -0.0205   0.7968  -0.6038]
        Angle     67.0365
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3184"
}

Galaxy "NGC 3185:UGC 5554:MCG 4-24-24:ZWG 123.34"
{
        Type  "SBa"
        RA           10.2939
        Dec          21.6886
        Distance   6.972e+07  # method: V
        Radius     2.129e+04
        AbsMag        -18.75
        Axis    [ -0.1865   0.7629  -0.6190]
        Angle     50.2848
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3185"
}

Galaxy "NGC 3186-1:MCG 1-26-28:ZWG 36.74:NPM 1"
{
        Type  "E0"
        RA           10.2647
        Dec           6.9644
        Distance   3.802e+08  # distance uncertain!
        Radius     2.212e+04
        AbsMag        -20.13
        Axis    [  0.7887  -0.5335  -0.3055]
        Angle    118.9868
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3186-1"
}

Galaxy "NGC 3186-2"
{
        Type  "E0"
        RA           10.2644
        Dec           6.9594
        Distance   5.496e+08  # distance uncertain!
        Radius     3.997e+04
        AbsMag        -20.13
        Axis    [  0.7887  -0.5335  -0.3055]
        Angle    118.9892
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3186-2"
}

Galaxy "NGC 3187:UGC 5556:MCG 4-24-25:ZWG 123.36"
{
        Type  "SBc"
        RA           10.2964
        Dec          21.8739
        Distance   8.544e+07  # method: V
        Radius     4.474e+04
        AbsMag        -18.49
        Axis    [  0.9603   0.2636   0.0917]
        Angle     55.2611
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3187"
}

Galaxy "NGC 3188:UGC 5569:MCG 10-15-65:MK 31"
{
        Type  "SBb"
        RA           10.3283
        Dec          57.4231
        Distance    3.59e+08  # method: V
        Radius     4.177e+04
        AbsMag        -20.61
        Axis    [ -0.3809   0.9051  -0.1891]
        Angle     88.4533
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3188"
}

Galaxy "NGC 3188A:MCG 10-15-64:MK 30:KUG 1016+576"
{
        Type  "S0"
        RA           10.3272
        Dec          57.4186
        Distance   3.674e+08  # method: V
        Radius     2.137e+04
        AbsMag        -17.76
        Axis    [  0.5441   0.5120   0.6647]
        Angle     45.0229
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3188A"
}

Galaxy "NGC 3190:UGC 5559:MCG 4-24-26:ARP 316"
{
        Type  "Sa"
        RA           10.3014
        Dec          21.8328
        Distance   7.434e+07  # method: V
        Radius     4.757e+04
        AbsMag        -19.79
        Axis    [ -0.3307   0.9274  -0.1748]
        Angle     36.8744
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3190"
}

Galaxy "NGC 3192:NGC 3191:UGC 5565:MCG 8-19-18"
{
        Type  "SBc"
        RA           10.3181
        Dec          46.4550
        Distance   4.239e+08  # method: V
        Radius     4.932e+04
        AbsMag        -21.57
        Axis    [  0.8819  -0.3990   0.2512]
        Angle     88.8611
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3192"
}

Galaxy "NGC 3193:UGC 5562:MCG 4-24-27:ZWG 123.38"
{
        Type  "E2"
        RA           10.3067
        Dec          21.8939
        Distance    1.11e+08  # method: S
        Radius      3.23e+04
        AbsMag        -20.86
        Axis    [  0.7499  -0.6119  -0.2514]
        Angle    107.7462
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3193"
}

Galaxy "NGC 3196:ZWG 153.35:ZWG 154.1:NPM 1"
{
        Type  "S0"
        RA           10.3136
        Dec          27.6694
        Distance   3.217e+08  # distance uncertain!
        Radius     1.404e+04
        AbsMag        -19.07
        Axis    [  0.0892   0.8438  -0.5292]
        Angle     40.9595
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3196"
}

Galaxy "NGC 3197:UGC 5500:MCG 13-8-9:ZWG 351.10"
{
        Type  "Sc"
        RA           10.2408
        Dec          77.8203
        Distance    3.68e+08  # method: V
        Radius     6.959e+04
        AbsMag        -20.96
        Axis    [ -0.2228   0.9738   0.0447]
        Angle     86.5438
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3197"
}

Galaxy "NGC 3198:UGC 5572:MCG 8-19-20:ZWG 240.30"
{
        Type  "SBc"
        RA           10.3317
        Dec          45.5500
        Distance   5.151e+07  # method: T-F
        Radius     6.368e+04
        AbsMag        -20.09
        Axis    [  0.8599   0.0245   0.5099]
        Angle     73.0605
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3198"
}

Galaxy "NGC 3200:ESO 567-45:MCG 3-26-37:UGCA 210"
{
        Type  "SBc"
        RA           10.3100
        Dec         -17.9822
        Distance   1.847e+08  # method: T-F
        Radius     1.128e+05
        AbsMag        -20.86
        Axis    [ -0.7640   0.1044  -0.6367]
        Angle     65.8553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3200"
}

Galaxy "NGC 3202:UGC 5581:MCG 7-21-41:ZWG 211.44"
{
        Type  "SBa"
        RA           10.3419
        Dec          43.0214
        Distance   3.146e+08  # method: V
        Radius      5.49e+04
        AbsMag        -20.82
        Axis    [  0.9323  -0.2451   0.2659]
        Angle     78.3228
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3202"
}

Galaxy "NGC 3203:ESO 500-24:MCG 4-25-2"
{
        Type  "Sa"
        RA           10.3258
        Dec         -26.6989
        Distance   1.232e+08  # method: V
        Radius     5.018e+04
        AbsMag        -19.79
        Axis    [  0.8432   0.3816  -0.3787]
        Angle     70.9131
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3203"
}

Galaxy "NGC 3204:UGC 5580:MCG 5-25-1:ZWG 154.3"
{
        Type  "SBb"
        RA           10.3364
        Dec          27.8172
        Distance   2.382e+08  # method: V
        Radius     4.504e+04
        AbsMag        -19.72
        Axis    [  0.2154   0.8028  -0.5559]
        Angle     39.7586
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3204"
}

Galaxy "NGC 3205:UGC 5585:MCG 7-21-42:ZWG 211.46"
{
        Type  "Irr"
        RA           10.3472
        Dec          42.9717
        Distance   3.291e+08  # method: V
        Radius     6.701e+04
        AbsMag        -20.82
        Axis    [ -0.4036   0.8385  -0.3662]
        Angle     83.6755
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3205"
}

Galaxy "NGC 3206:UGC 5589:MCG 10-15-69:ZWG 290.30"
{
        Type  "SBc"
        RA           10.3631
        Dec          56.9308
        Distance   5.971e+07  # method: V
        Radius     2.518e+04
        AbsMag        -18.71
        Axis    [  0.8179  -0.4131   0.4004]
        Angle     93.9521
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3206"
}

Galaxy "NGC 3207:UGC 5587:MCG 7-21-43:ZWG 211.47"
{
        Type  "Irr"
        RA           10.3500
        Dec          42.9858
        Distance   3.271e+08  # method: V
        Radius     6.185e+04
        AbsMag        -20.31
        Axis    [  0.4539   0.8888   0.0637]
        Angle     33.9167
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3207"
}

Galaxy "NGC 3208:ESO 500-25:MCG 4-25-3:AM 1017-253"
{
        Type  "SBc"
        RA           10.3281
        Dec         -25.8144
        Distance   1.461e+08  # method: V
        Radius     3.826e+04
        AbsMag        -19.86
        Axis    [  0.8771  -0.1300  -0.4624]
        Angle    122.7426
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3208"
}

Galaxy "NGC 3209:UGC 5584:MCG 4-25-2:ZWG 124.3"
{
        Type  "E0"
        RA           10.3439
        Dec          25.5047
        Distance   2.942e+08  # method: V
        Radius     5.562e+04
        AbsMag        -21.08
        Axis    [  0.5316   0.0058  -0.8470]
        Angle     75.8652
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3209"
}

Galaxy "NGC 3212:UGC 5643:MCG 13-8-21:ZWG 350.54"
{
        Type  "SBb"
        RA           10.4711
        Dec          79.8239
        Distance   4.437e+08  # method: V
        Radius     9.681e+04
        AbsMag        -21.17
        Axis    [  0.3069   0.6759   0.6701]
        Angle     45.5834
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3212"
}

Galaxy "NGC 3213:UGC 5590:MCG 3-27-4:ZWG 94.8"
{
        Type  "Sc"
        RA           10.3547
        Dec          19.6517
        Distance   7.538e+07  # method: V
        Radius     1.096e+04
        AbsMag        -17.52
        Axis    [ -0.1401   0.6542  -0.7432]
        Angle     59.8318
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3213"
}

Galaxy "NGC 3214:MCG 10-15-71:ZWG 290.32"
{
        Type  "Sa"
        RA           10.3856
        Dec          57.0389
        Distance    2.44e+08  # distance uncertain!
        Radius     2.484e+04
        AbsMag        -19.07
        Axis    [  0.7755  -0.0151   0.6311]
        Angle     70.0328
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3214"
}

Galaxy "NGC 3215:UGC 5659:MCG 13-8-22:ZWG 351.24"
{
        Type  "Sc"
        RA           10.4778
        Dec          79.8125
        Distance     4.3e+08  # method: V
        Radius      6.88e+04
        AbsMag         -21.6
        Axis    [  0.8020  -0.2369   0.5483]
        Angle     39.6967
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3215"
}

Galaxy "NGC 3216:UGC 5593:MCG 4-25-7:ZWG 124.8"
{
        Type  "E0"
        RA           10.3614
        Dec          23.9233
        Distance    3.02e+08  # distance uncertain!
        Radius     5.711e+04
        AbsMag        -20.13
        Axis    [  0.7388  -0.6278  -0.2450]
        Angle    106.6213
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3216"
}

Galaxy "NGC 3217:IC 606:MCG 2-27-6:MK 721"
{
        Type  "Sc"
        RA           10.3922
        Dec          10.9597
        Distance   4.439e+08  # method: V
        Radius     3.228e+04
        AbsMag        -20.37
        Axis    [  0.9959  -0.0218  -0.0878]
        Angle     82.2093
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3217"
}

Galaxy "NGC 3218:NGC 3183:UGC 5582:MCG 12-10-28"
{
        Type  "SBc"
        RA           10.3633
        Dec          74.1772
        Distance   1.426e+08  # method: V
        Radius     4.771e+04
        AbsMag         -20.6
        Axis    [ -0.3688   0.9230   0.1097]
        Angle     89.1042
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3218"
}

Galaxy "NGC 3219:MCG 7-21-51:ZWG 211.49:NPM 1"
{
        Type  "S0"
        RA           10.3769
        Dec          38.5797
        Distance    1.47e+08  # distance uncertain!
        Radius     1.711e+04
        AbsMag        -19.07
        Axis    [  0.9708   0.1708   0.1684]
        Angle     47.3742
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3219"
}

Galaxy "NGC 3220:IC 604:UGC 5614:MCG 10-15-73"
{
        Type  "Sb"
        RA           10.3956
        Dec          57.0267
        Distance    6.12e+07  # method: V
        Radius     1.157e+04
        AbsMag        -17.47
        Axis    [  0.1657   0.7206   0.6732]
        Angle     47.9261
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3220"
}

Galaxy "NGC 3221:UGC 5601:MCG 4-25-13:ZWG 124.17"
{
        Type  "SBc"
        RA           10.3722
        Dec          21.5689
        Distance       2e+08  # method: V
        Radius     9.018e+04
        AbsMag        -19.84
        Axis    [ -0.8431   0.5242  -0.1202]
        Angle     66.1771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3221"
}

Galaxy "NGC 3222:UGC 5610:MCG 3-27-11:ZWG 94.18"
{
        Type  "S0"
        RA           10.3761
        Dec          19.8867
        Distance   2.672e+08  # method: V
        Radius     4.664e+04
        AbsMag        -20.57
        Axis    [  0.9266  -0.0805  -0.3674]
        Angle     65.3932
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3222"
}

Galaxy "NGC 3223:IC 2571:ESO 375-12:MCG 6-23-23"
{
        Type  "Sb"
        RA           10.3594
        Dec         -34.2669
        Distance   1.223e+08  # method: T-F
        Radius     7.294e+04
        AbsMag        -21.07
        Axis    [ -0.1648   0.0656  -0.9841]
        Angle     79.2809
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3223"
}

Galaxy "NGC 3224:ESO 375-13:MCG 6-23-24"
{
        Type  "E0"
        RA           10.3614
        Dec         -34.6961
        Distance   1.538e+08  # method: V
        Radius     4.249e+04
        AbsMag        -21.07
        Axis    [ -0.0662   0.0822  -0.9944]
        Angle    132.0342
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3224"
}

Galaxy "NGC 3225:UGC 5631:MCG 10-15-77:ZWG 290.37"
{
        Type  "Sc"
        RA           10.4192
        Dec          58.1497
        Distance   1.411e+08  # method: T-F
        Radius     4.103e+04
        AbsMag        -19.88
        Axis    [ -0.4730   0.8778   0.0753]
        Angle     75.1080
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3225"
}

Galaxy "NGC 3226:UGC 5617:MCG 3-27-15:ZWG 94.26"
{
        Type  "E2"
        RA           10.3906
        Dec          19.8975
        Distance   7.681e+07  # method: S
        Radius     3.128e+04
        AbsMag        -19.46
        Axis    [  0.7354  -0.4637  -0.4941]
        Angle     94.0707
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3226"
}

Galaxy "NGC 3227:UGC 5620:MCG 3-27-16:ZWG 94.28"
{
        Type  "SBa"
        RA           10.3917
        Dec          19.8653
        Distance   6.668e+07  # method: V
        Radius     3.976e+04
        AbsMag        -20.25
        Axis    [ -0.1900   0.6083  -0.7706]
        Angle     84.5723
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3227"
}

Galaxy "NGC 3230:UGC 5624:MCG 2-27-7:ZWG 65.20"
{
        Type  "S0"
        RA           10.3956
        Dec          12.5675
        Distance    1.54e+08  # distance uncertain!
        Radius     5.151e+04
        AbsMag        -19.07
        Axis    [  0.0393   0.7872  -0.6155]
        Angle     34.7983
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3230"
}

Galaxy "NGC 3232:MCG 5-25-4:ZWG 154.8"
{
        Type  "SBa"
        RA           10.4067
        Dec          28.0283
        Distance   2.959e+08  # method: V
        Radius     3.443e+04
        AbsMag        -19.49
        Axis    [  0.7418  -0.6373  -0.2088]
        Angle    103.3025
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3232"
}

Galaxy "NGC 3233:ESO 568-1:MCG 4-25-4:AM 1019-220"
{
        Type  "SBa"
        RA           10.3658
        Dec         -22.2678
        Distance   1.828e+08  # method: V
        Radius     4.787e+04
        AbsMag        -20.24
        Axis    [ -0.3234   0.1804  -0.9289]
        Angle     61.1357
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3233"
}

Galaxy "NGC 3234:NGC 3235:UGC 5635:MCG 5-25-7"
{
        Type  "S0"
        RA           10.4164
        Dec          28.0242
        Distance   3.035e+08  # method: V
        Radius     5.297e+04
        AbsMag        -20.34
        Axis    [  0.7601   0.4307  -0.4866]
        Angle     40.0420
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3234"
}

Galaxy "NGC 3236:MCG 10-15-81:ZWG 290.40:NPM 1"
{
        Type  "E0"
        RA           10.4467
        Dec          61.2733
        Distance   4.169e+08  # distance uncertain!
        Radius     3.638e+04
        AbsMag        -20.13
        Axis    [  0.7793  -0.4709  -0.4135]
        Angle     49.3309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3236"
}

Galaxy "NGC 3237:UGC 5640:MCG 7-22-3:ZWG 212.7"
{
        Type  "S0"
        RA           10.4286
        Dec          39.6472
        Distance   3.318e+08  # method: V
        Radius     6.273e+04
        AbsMag        -21.04
        Axis    [  0.6970  -0.7015  -0.1485]
        Angle     95.5292
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3237"
}

Galaxy "NGC 3238:UGC 5649:MCG 10-15-80:ZWG 290.41"
{
        Type  "S0"
        RA           10.4450
        Dec          57.2261
        Distance    3.41e+08  # method: V
        Radius     6.943e+04
        AbsMag         -20.9
        Axis    [  0.0354   0.9227  -0.3838]
        Angle     60.6075
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3238"
}

Galaxy "NGC 3239:UGC 5637:MCG 3-27-25:ZWG 94.38"
{
        Type  "Irr"
        RA           10.4181
        Dec          17.1603
        Distance    4.87e+07  # method: V
        Radius     3.187e+04
        AbsMag        -19.17
        Axis    [  0.8342   0.4579  -0.3075]
        Angle     40.0986
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3239"
}

Galaxy "NGC 3240:ESO 568-3:MCG 4-25-7:IRAS 10221-2132"
{
        Type  "Sc"
        RA           10.4083
        Dec         -21.7914
        Distance   1.951e+08  # method: V
        Radius     3.122e+04
        AbsMag        -19.98
        Axis    [  0.5081  -0.0159  -0.8612]
        Angle     95.8735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3240"
}

Galaxy "NGC 3241:ESO 436-16:MCG 5-25-2:IRAS 10220-3213"
{
        Type  "SBb"
        RA           10.4047
        Dec         -32.4833
        Distance   1.431e+08  # method: V
        Radius     4.994e+04
        AbsMag        -20.31
        Axis    [ -0.0075   0.0807  -0.9967]
        Angle     76.8772
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3241"
}

Galaxy "NGC 3243:UGC 5652:MCG 0-27-12:ZWG 9.33"
{
        Type  "S0"
        RA           10.4392
        Dec          -2.6222
        Distance   2.669e+08  # method: V
        Radius     5.434e+04
        AbsMag        -20.76
        Axis    [ -0.0344   0.3527  -0.9351]
        Angle     65.1645
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3243"
}

Galaxy "NGC 3244:ESO 317-24:MCG 7-22-5:IRAS 10232-3934"
{
        Type  "Sc"
        RA           10.4244
        Dec         -39.8278
        Distance   8.702e+07  # method: T-F
        Radius     2.658e+04
        AbsMag        -19.13
        Axis    [ -0.4890   0.0585  -0.8703]
        Angle    108.9210
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3244"
}

Galaxy "NGC 3245:UGC 5663:MCG 5-25-13:ZWG 154.17"
{
        Type  "S0"
        RA           10.4550
        Dec          28.5078
        Distance   6.815e+07  # method: S
        Radius     3.172e+04
        AbsMag         -19.9
        Axis    [ -0.6735   0.6601  -0.3326]
        Angle     82.8646
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3245"
}

Galaxy "NGC 3245A:UGC 5662:MCG 5-25-12:ZWG 154.16"
{
        Type  "SBb"
        RA           10.4503
        Dec          28.6392
        Distance   7.316e+07  # method: V
        Radius     3.724e+04
        AbsMag        -16.65
        Axis    [ -0.7426   0.6607   0.1096]
        Angle     55.3647
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3245A"
}

Galaxy "NGC 3246:UGC 5661:MCG 1-27-9:ZWG 37.37"
{
        Type  "Irr"
        RA           10.4447
        Dec           3.8625
        Distance   1.131e+08  # method: V
        Radius     3.947e+04
        AbsMag         -19.2
        Axis    [  0.4313   0.4551  -0.7790]
        Angle     43.0117
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3246"
}

Galaxy "NGC 3248:UGC 5669:MCG 4-25-20:ZWG 124.24"
{
        Type  "S0"
        RA           10.4625
        Dec          22.8475
        Distance   1.115e+08  # distance uncertain!
        Radius     4.056e+04
        AbsMag        -19.07
        Axis    [ -0.4532   0.8319  -0.3202]
        Angle     43.1374
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3248"
}

Galaxy "NGC 3249:ESO 375-24:MCG 6-23-28:IRAS 10240-3442"
{
        Type  "SBc"
        RA           10.4394
        Dec         -34.9639
        Distance   1.719e+08  # method: V
        Radius         4e+04
        AbsMag        -19.71
        Axis    [ -0.1934   0.0643  -0.9790]
        Angle     93.3592
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3249"
}

Galaxy "NGC 3250:ESO 317-26:MCG 7-22-7"
{
        Type  "E4"
        RA           10.4422
        Dec         -39.9436
        Distance   1.391e+08  # method: S
        Radius     5.464e+04
        AbsMag        -20.95
        Axis    [ -0.2140   0.1015  -0.9715]
        Angle    136.7026
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250"
}

Galaxy "NGC 3250A:ESO 317-30:IRAS 10257-3949"
{
        Type  "Sb"
        RA           10.4647
        Dec         -40.0811
        Distance   2.934e+08  # distance uncertain!
        Radius     4.694e+04
        AbsMag        -19.07
        Axis    [  0.5626   0.2550  -0.7865]
        Angle     55.4458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250A"
}

Galaxy "NGC 3250B:ESO 317-29:MCG 7-22-9:AM 1025-401"
{
        Type  "SBa"
        RA           10.4622
        Dec         -40.4356
        Distance   1.273e+08  # method: V
        Radius     4.073e+04
        AbsMag        -19.16
        Axis    [  0.9119   0.3157  -0.2623]
        Angle    123.4686
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250B"
}

Galaxy "NGC 3250C:ESO 317-28:MCG 7-22-8:IRAS 10255-3944"
{
        Type  "Sb"
        RA           10.4617
        Dec         -40.0025
        Distance   1.389e+08  # method: V
        Radius     3.434e+04
        AbsMag        -18.85
        Axis    [  0.7781   0.2618  -0.5709]
        Angle     83.6839
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250C"
}

Galaxy "NGC 3250D:ESO 317-31:MCG 7-22-11"
{
        Type  "S0"
        RA           10.4658
        Dec         -39.8153
        Distance   1.389e+08  # method: V
        Radius     3.434e+04
        AbsMag        -18.85
        Axis    [  0.8681   0.3696  -0.3314]
        Angle    100.9101
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250D"
}

Galaxy "NGC 3250E:ESO 317-34:MCG 7-22-13:IRAS 10268-3949"
{
        Type  "SBc"
        RA           10.4833
        Dec         -40.0825
        Distance   1.389e+08  # method: V
        Radius     4.242e+04
        AbsMag        -19.95
        Axis    [ -0.2555  -0.0058  -0.9668]
        Angle     84.6641
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3250E"
}

Galaxy "NGC 3251:IC 2579:UGC 5684:MCG 4-25-23"
{
        Type  "SBc"
        RA           10.4878
        Dec          26.0989
        Distance    2.44e+08  # method: V
        Radius     7.099e+04
        AbsMag        -20.17
        Axis    [  0.8251   0.3248   0.4623]
        Angle     62.4165
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3251"
}

Galaxy "NGC 3252:UGC 5732:MCG 12-10-49:ZWG 333.39"
{
        Type  "SBc"
        RA           10.5728
        Dec          73.7639
        Distance   5.432e+07  # method: V
        Radius     1.501e+04
        AbsMag        -17.01
        Axis    [  0.6015  -0.0861   0.7942]
        Angle     85.1137
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3252"
}

Galaxy "NGC 3253:UGC 5674:MCG 2-27-21:ZWG 65.43"
{
        Type  "SBc"
        RA           10.4742
        Dec          12.7039
        Distance    4.54e+08  # method: V
        Radius     7.924e+04
        AbsMag        -21.42
        Axis    [  0.8539  -0.2024  -0.4795]
        Angle     78.8554
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3253"
}

Galaxy "NGC 3254:UGC 5685:MCG 5-25-18:ZWG 154.20"
{
        Type  "Sc"
        RA           10.4886
        Dec          29.4922
        Distance   1.208e+08  # method: T-F
        Radius     7.907e+04
        AbsMag        -20.44
        Axis    [  0.9136   0.1750   0.3671]
        Angle     65.8014
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3254"
}

Galaxy "NGC 3256:ESO 263-38:MCG 7-22-10:VV 65"
{
        Type  "Sb"
        RA           10.4642
        Dec         -43.9053
        Distance   1.281e+08  # method: V
        Radius     7.081e+04
        AbsMag        -20.87
        Axis    [  0.4705   0.0696  -0.8797]
        Angle     84.7696
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3256"
}

Galaxy "NGC 3256A:ESO 263-34:AM 1023-432"
{
        Type  "Irr"
        RA           10.4308
        Dec         -43.7475
        Distance   1.376e+08  # method: T-F
        Radius     2.601e+04
        AbsMag        -18.13
        Axis    [  0.4962   0.1085  -0.8614]
        Angle     79.0944
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3256A"
}

Galaxy "NGC 3256B:ESO 263-39:MCG 7-22-14:IRAS 10268-4408"
{
        Type  "SBc"
        RA           10.4836
        Dec         -44.4033
        Distance    1.22e+08  # method: T-F
        Radius      3.37e+04
        AbsMag        -19.06
        Axis    [ -0.2093  -0.1075  -0.9719]
        Angle     57.0219
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3256B"
}

Galaxy "NGC 3256C:ESO 263-41:MCG 7-22-16:FAIR 431"
{
        Type  "SBc"
        RA           10.4847
        Dec         -43.8503
        Distance   1.281e+08  # method: V
        Radius     3.168e+04
        AbsMag        -19.67
        Axis    [ -0.4283  -0.0413  -0.9027]
        Angle     94.4811
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3256C"
}

Galaxy "NGC 3257:ESO 375-36:MCG 6-23-31"
{
        Type  "S0"
        RA           10.4797
        Dec         -35.6581
        Distance   1.121e+08  # method: S
        Radius      1.63e+04
        AbsMag        -18.58
        Axis    [  0.9140  -0.1397  -0.3808]
        Angle    142.1909
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3257"
}

Galaxy "NGC 3258:ESO 375-37:MCG 6-23-32"
{
        Type  "E1"
        RA           10.4814
        Dec         -35.6050
        Distance   1.046e+08  # method: S
        Radius     4.411e+04
        AbsMag        -20.03
        Axis    [  0.4064  -0.1525  -0.9009]
        Angle    134.3385
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258"
}

Galaxy "NGC 3258A:ESO 375-32:MCG 6-23-30"
{
        Type  "SBa"
        RA           10.4719
        Dec         -35.4547
        Distance   1.466e+08  # method: V
        Radius     2.345e+04
        AbsMag        -18.76
        Axis    [ -0.6285  -0.0642  -0.7752]
        Angle     78.1644
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258A"
}

Galaxy "NGC 3258B"
{
        Type  "S0"
        RA           10.5069
        Dec         -35.5636
        Distance    2.33e+08  # distance uncertain!
        Radius      3.39e+04
        AbsMag        -19.07
        Axis    [  0.8310   0.2625  -0.4904]
        Angle     85.9172
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258B"
}

Galaxy "NGC 3258C:ESO 375-53:MCG 6-23-48"
{
        Type  "SBa"
        RA           10.5233
        Dec         -35.2200
        Distance   1.372e+08  # method: V
        Radius     2.195e+04
        AbsMag        -18.52
        Axis    [  0.7557   0.0150  -0.6548]
        Angle    105.0329
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258C"
}

Galaxy "NGC 3258D:ESO 375-58:MCG 6-23-51"
{
        Type  "SBb"
        RA           10.5319
        Dec         -35.4103
        Distance   1.372e+08  # method: V
        Radius     3.193e+04
        AbsMag        -19.12
        Axis    [  0.9420   0.1086  -0.3177]
        Angle    127.5782
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258D"
}

Galaxy "NGC 3258E:ESO 375-60:MCG 6-23-51B"
{
        Type  "Sb"
        RA           10.5400
        Dec         -34.9981
        Distance     8.1e+07  # method: T-F
        Radius     1.767e+04
        AbsMag        -16.57
        Axis    [  0.8918   0.3531  -0.2827]
        Angle     99.9319
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3258E"
}

Galaxy "NGC 3259:UGC 5717:MCG 11-13-27:ZWG 313.21"
{
        Type  "SBc"
        RA           10.5428
        Dec          65.0411
        Distance   1.407e+08  # method: T-F
        Radius     3.479e+04
        AbsMag        -20.17
        Axis    [  0.7642  -0.2800   0.5811]
        Angle     82.4613
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3259"
}

Galaxy "NGC 3260:ESO 375-40:MCG 6-23-33"
{
        Type  "E0"
        RA           10.4850
        Dec         -35.5958
        Distance   1.509e+08  # method: T-F
        Radius     2.634e+04
        AbsMag        -19.63
        Axis    [  0.8163  -0.3534  -0.4570]
        Angle    153.6077
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3260"
}

Galaxy "NGC 3261:ESO 263-40:MCG 7-22-15:AM 1026-442"
{
        Type  "SBc"
        RA           10.4836
        Dec         -44.6575
        Distance   1.281e+08  # method: V
        Radius     6.522e+04
        AbsMag        -20.97
        Axis    [  0.4050  -0.0173  -0.9142]
        Angle    103.7912
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3261"
}

Galaxy "NGC 3262:ESO 263-42:MCG 7-22-17"
{
        Type  "S0"
        RA           10.4850
        Dec         -44.1600
        Distance   1.409e+08  # method: V
        Radius     2.255e+04
        AbsMag        -18.98
        Axis    [  0.1837   0.0048  -0.9830]
        Angle     84.7648
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3262"
}

Galaxy "NGC 3263:ESO 263-43:MCG 7-22-18:AM 1027-435"
{
        Type  "SBc"
        RA           10.4869
        Dec         -44.1228
        Distance   1.491e+08  # method: V
        Radius     6.507e+04
        AbsMag         -21.5
        Axis    [  0.3374   0.1120  -0.9347]
        Angle     55.9255
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3263"
}

Galaxy "NGC 3264:UGC 5719:MCG 9-17-69:ZWG 266.54"
{
        Type  "Irr"
        RA           10.5386
        Dec          56.0839
        Distance   8.526e+07  # method: T-F
        Radius     3.596e+04
        AbsMag        -19.59
        Axis    [ -0.6282   0.7779   0.0165]
        Angle     91.0277
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3264"
}

Galaxy "NGC 3265:UGC 5705:MCG 5-25-19:ZWG 154.23"
{
        Type  "E0"
        RA           10.5183
        Dec          28.7969
        Distance    7.86e+07  # method: V
        Radius     1.029e+04
        AbsMag        -17.81
        Axis    [  0.5793  -0.0999  -0.8089]
        Angle     72.3532
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3265"
}

Galaxy "NGC 3266:UGC 5725:MCG 11-13-30:ZWG 313.22"
{
        Type  "S0"
        RA           10.5547
        Dec          64.7497
        Distance   1.065e+08  # distance uncertain!
        Radius     2.169e+04
        AbsMag        -19.07
        Axis    [  0.3533   0.9353   0.0195]
        Angle     37.9981
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3266"
}

Galaxy "NGC 3267:ESO 375-42:MCG 6-23-36:AM 1027-350"
{
        Type  "S0"
        RA           10.4967
        Dec         -35.3228
        Distance   1.836e+08  # method: V
        Radius     4.539e+04
        AbsMag        -20.25
        Axis    [ -0.3644   0.0141  -0.9311]
        Angle     77.0771
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3267"
}

Galaxy "NGC 3268:ESO 375-45:MCG 6-23-41:AM 1027-350"
{
        Type  "E2"
        RA           10.5000
        Dec         -35.3256
        Distance   1.136e+08  # method: S
        Radius     4.957e+04
        AbsMag        -20.21
        Axis    [  0.6052  -0.2499  -0.7558]
        Angle    139.9013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3268"
}

Galaxy "NGC 3269:ESO 375-44:MCG 6-23-40:AM 1027-350"
{
        Type  "SBa"
        RA           10.4992
        Dec         -35.2239
        Distance    1.86e+08  # method: V
        Radius     6.493e+04
        AbsMag        -20.58
        Axis    [  0.9378   0.1751  -0.2998]
        Angle    122.9020
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3269"
}

Galaxy "NGC 3270:UGC 5711:MCG 4-25-29:ZWG 124.34"
{
        Type  "SBb"
        RA           10.5250
        Dec          24.8694
        Distance   2.975e+08  # method: V
        Radius     1.341e+05
        AbsMag           -21
        Axis    [  0.9500   0.0300   0.3107]
        Angle    100.2797
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3270"
}

Galaxy "NGC 3271:IC 2585:ESO 375-48:MCG 6-23-44"
{
        Type  "S0"
        RA           10.5072
        Dec         -35.3600
        Distance   1.858e+08  # method: V
        Radius     8.917e+04
        AbsMag        -20.98
        Axis    [  0.2323   0.0734  -0.9699]
        Angle     70.3570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3271"
}

Galaxy "NGC 3273:ESO 375-49:MCG 6-23-45:AM 1027-350"
{
        Type  "S0"
        RA           10.5081
        Dec         -35.6111
        Distance   1.239e+08  # method: V
        Radius     2.883e+04
        AbsMag         -19.4
        Axis    [  0.3830   0.1183  -0.9161]
        Angle     65.3803
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3273"
}

Galaxy "NGC 3274:UGC 5721:MCG 5-25-20:ZWG 154.24"
{
        Type  "SBc"
        RA           10.5381
        Dec          27.6689
        Distance   3.765e+07  # method: V
        Radius     1.095e+04
        AbsMag        -17.11
        Axis    [  0.4749   0.8408  -0.2599]
        Angle     30.4106
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3274"
}

Galaxy "NGC 3275:ESO 375-50:MCG 6-23-46:AM 1028-362"
{
        Type  "SBb"
        RA           10.5142
        Dec         -36.7369
        Distance   1.592e+08  # method: V
        Radius     6.483e+04
        AbsMag        -21.24
        Axis    [  0.0111   0.0296  -0.9995]
        Angle     86.6374
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3275"
}

Galaxy "NGC 3275A:ESO 375-46"
{
        Type  "Sa"
        RA           10.5011
        Dec         -36.6947
        Distance   2.226e+08  # distance uncertain!
        Radius     3.237e+04
        AbsMag        -19.07
        Axis    [  0.9147   0.2779  -0.2934]
        Angle    114.3833
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3275A"
}

Galaxy "NGC 3276:ESO 317-40"
{
        Type  "S0"
        RA           10.5192
        Dec         -39.9450
        Distance   1.612e+08  # distance uncertain!
        Radius     2.345e+04
        AbsMag        -19.07
        Axis    [  0.5771   0.0702  -0.8137]
        Angle     88.4740
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3276"
}

Galaxy "NGC 3277:UGC 5731:MCG 5-25-22:ZWG 154.26"
{
        Type  "Sb"
        RA           10.5486
        Dec          28.5122
        Distance   7.701e+07  # method: V
        Radius     2.352e+04
        AbsMag        -19.36
        Axis    [ -0.4289   0.7223  -0.5425]
        Angle     86.9250
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3277"
}

Galaxy "NGC 3278:ESO 317-43:MCG 7-22-21:IRAS 10293-3941"
{
        Type  "Sc"
        RA           10.5264
        Dec         -39.9558
        Distance   8.461e+07  # distance uncertain!
        Radius       1.6e+04
        AbsMag        -19.07
        Axis    [  0.6507   0.0346  -0.7586]
        Angle     99.7831
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3278"
}

Galaxy "NGC 3279:IC 622:UGC 5741:MCG 2-27-27"
{
        Type  "Sc"
        RA           10.5783
        Dec          11.1969
        Distance   7.842e+07  # method: V
        Radius     3.307e+04
        AbsMag         -17.9
        Axis    [ -0.8535   0.5029  -0.1368]
        Angle     46.9506
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3279"
}

Galaxy "NGC 3280A:NGC 3295A:IC 617:MCG 2-27-6"
{
        Type  "S0"
        RA           10.5453
        Dec         -12.6367
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [ -0.1390   0.2552  -0.9569]
        Angle     65.9893
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3280A"
}

Galaxy "NGC 3280B:NGC 3295B:MCG 2-27-7:NPM 1"
{
        Type  "S0"
        RA           10.5458
        Dec         -12.6367
        Distance   3.369e+08  # distance uncertain!
        Radius      2.45e+04
        AbsMag        -19.07
        Axis    [ -0.6617   0.2436  -0.7091]
        Angle     78.2999
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3280B"
}

Galaxy "NGC 3280C:NGC 3295:MCG 2-27-8:NPM 1"
{
        Type  "S0"
        RA           10.5461
        Dec         -12.6339
        Distance   3.369e+08  # distance uncertain!
        Radius      1.96e+04
        AbsMag        -19.07
        Axis    [  0.8116  -0.4469  -0.3763]
        Angle    134.7494
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3280C"
}

Galaxy "NGC 3281:ESO 375-55:MCG 6-23-50:AM 1029-343"
{
        Type  "Sb"
        RA           10.5311
        Dec         -34.8544
        Distance   2.572e+08  # method: V
        Radius     1.197e+05
        AbsMag        -21.78
        Axis    [ -0.2895   0.0097  -0.9571]
        Angle     68.0814
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3281"
}

Galaxy "NGC 3281A:ESO 375-59:MCG 6-23-49"
{
        Type  "S0"
        RA           10.5328
        Dec         -35.1986
        Distance   1.176e+08  # method: V
        Radius     2.053e+04
        AbsMag        -18.39
        Axis    [ -0.0130   0.0371  -0.9992]
        Angle     93.3927
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3281A"
}

Galaxy "NGC 3281B"
{
        Type  "S0"
        RA           10.5311
        Dec         -35.2053
        Distance   1.768e+08  # distance uncertain!
        Radius       1.8e+04
        AbsMag        -19.07
        Axis    [  0.7611  -0.0744  -0.6444]
        Angle    117.4526
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3281B"
}

Galaxy "NGC 3281C:ESO 375-63:MCG 6-23-53"
{
        Type  "S0"
        RA           10.5497
        Dec         -34.8864
        Distance   2.572e+08  # method: V
        Radius     5.237e+04
        AbsMag        -20.18
        Axis    [ -0.6688  -0.1815  -0.7210]
        Angle     57.0737
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3281C"
}

Galaxy "NGC 3281D:ESO 375-68:MCG 6-23-55"
{
        Type  "SBc"
        RA           10.5717
        Dec         -34.4031
        Distance   2.572e+08  # method: V
        Radius     7.481e+04
        AbsMag        -19.78
        Axis    [ -0.6853  -0.1921  -0.7025]
        Angle     55.7603
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3281D"
}

Galaxy "NGC 3282:ESO 568-16:MCG 4-25-13"
{
        Type  "S0"
        RA           10.5392
        Dec         -22.3019
        Distance   1.911e+08  # method: V
        Radius     5.282e+04
        AbsMag        -19.84
        Axis    [  0.6857   0.2845  -0.6699]
        Angle     53.8934
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3282"
}

Galaxy "NGC 3283:ESO 263-48:IRAS 10290-4559"
{
        Type  "S0"
        RA           10.5197
        Dec         -46.2506
        Distance   1.431e+08  # method: V
        Radius     6.658e+04
        AbsMag        -20.61
        Axis    [ -0.5646  -0.1720  -0.8072]
        Angle     83.5687
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3283"
}

Galaxy "NGC 3284:NGC 3286:MCG 10-15-112:ZWG 290.56"
{
        Type  "E0"
        RA           10.6058
        Dec          58.6203
        Distance   3.751e+08  # method: V
        Radius      4.91e+04
        AbsMag         -20.7
        Axis    [  0.6225   0.2562  -0.7395]
        Angle     46.4540
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3284"
}

Galaxy "NGC 3285:ESO 501-15:MCG 4-25-19:AM 1031-271"
{
        Type  "SBa"
        RA           10.5597
        Dec         -27.4544
        Distance   1.687e+08  # method: V
        Radius     6.627e+04
        AbsMag        -20.57
        Axis    [  0.2067   0.1190  -0.9711]
        Angle     63.5095
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3285"
}

Galaxy "NGC 3285A:ESO 501-8:MCG 4-25-15:AM 1030-271"
{
        Type  "SBc"
        RA           10.5467
        Dec         -27.5219
        Distance   2.097e+08  # method: V
        Radius      3.66e+04
        AbsMag        -19.54
        Axis    [ -0.6058   0.0959  -0.7898]
        Angle     87.9614
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3285A"
}

Galaxy "NGC 3285B:ESO 501-18:MCG 4-25-22:AM 1032-272"
{
        Type  "SBb"
        RA           10.5767
        Dec         -27.6533
        Distance   1.488e+08  # method: V
        Radius     3.246e+04
        AbsMag        -19.39
        Axis    [  0.7868  -0.0511  -0.6151]
        Angle    105.5430
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3285B"
}

Galaxy "NGC 3287:UGC 5742:MCG 4-25-32:ZWG 124.38"
{
        Type  "SBc"
        RA           10.5797
        Dec          21.6478
        Distance   7.325e+07  # method: V
        Radius     2.131e+04
        AbsMag        -18.76
        Axis    [  0.9862  -0.0479   0.1587]
        Angle     87.9256
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3287"
}

Galaxy "NGC 3288:UGC 5752:MCG 10-15-114:ZWG 290.57"
{
        Type  "SBc"
        RA           10.6069
        Dec          58.5561
        Distance   3.767e+08  # method: V
        Radius     4.931e+04
        AbsMag        -20.41
        Axis    [ -0.3887   0.9017  -0.1894]
        Angle     91.9357
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3288"
}

Galaxy "NGC 3289:ESO 375-65:MCG 6-23-54"
{
        Type  "SBa"
        RA           10.5686
        Dec         -35.3231
        Distance   1.364e+08  # method: V
        Radius     4.363e+04
        AbsMag        -19.61
        Axis    [ -0.5530  -0.1164  -0.8250]
        Angle     58.0115
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3289"
}

Galaxy "NGC 3290:MCG 3-27-20:ARP 53:PGC 31347"
{
        Type  "SBc"
        RA           10.5881
        Dec         -17.2767
        Distance   4.949e+08  # method: V
        Radius     7.198e+04
        AbsMag         -21.6
        Axis    [  0.8307   0.1452  -0.5375]
        Angle     72.5826
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3290"
}

Galaxy "NGC 3292-1:MCG 1-27-23"
{
        Type  "S0"
        RA           10.5928
        Dec          -6.1794
        Distance   2.226e+08  # distance uncertain!
        Radius     3.561e+04
        AbsMag        -19.07
        Axis    [ -0.5763   0.3730  -0.7272]
        Angle     93.0175
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3292-1"
}

Galaxy "NGC 3292-2:MCG 1-27-22:NPM 1"
{
        Type  "S0"
        RA           10.5917
        Dec          -6.1842
        Distance   3.527e+08  # distance uncertain!
        Radius     3.591e+04
        AbsMag        -19.07
        Axis    [  0.0662   0.4428  -0.8942]
        Angle     37.8553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3292-2"
}

Galaxy "NGC 3294:UGC 5753:MCG 6-23-21:ZWG 183.30"
{
        Type  "Sc"
        RA           10.6044
        Dec          37.3247
        Distance   1.161e+08  # method: T-F
        Radius     5.739e+04
        AbsMag        -20.86
        Axis    [ -0.1664   0.9835  -0.0707]
        Angle     38.0054
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3294"
}

Galaxy "NGC 3296:IC 618:NPM 1"
{
        Type  "E0"
        RA           10.5458
        Dec         -12.7167
        Distance   3.312e+08  # distance uncertain!
        Radius     3.372e+04
        AbsMag        -20.13
        Axis    [  0.7965  -0.4656  -0.3857]
        Angle    135.9570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3296"
}

Galaxy "NGC 3297:NPM 1"
{
        Type  "S0"
        RA           10.5531
        Dec         -12.6711
        Distance   2.676e+08  # distance uncertain!
        Radius     3.113e+04
        AbsMag        -19.07
        Axis    [ -0.5638   0.2601  -0.7839]
        Angle     73.1600
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3297"
}

Galaxy "NGC 3298:MCG 8-19-43:ZWG 241.1:ZWG 240.65"
{
        Type  "S0"
        RA           10.6200
        Dec          50.1203
        Distance   2.125e+08  # distance uncertain!
        Radius     2.782e+04
        AbsMag        -19.07
        Axis    [ -0.2806   0.9551  -0.0957]
        Angle     54.9015
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3298"
}

Galaxy "NGC 3299:UGC 5761:MCG 2-27-29:ZWG 65.64"
{
        Type  "Irr"
        RA           10.6064
        Dec          12.7072
        Distance   4.426e+07  # method: V
        Radius     1.416e+04
        AbsMag        -16.96
        Axis    [  0.9571  -0.2816  -0.0688]
        Angle    106.0682
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3299"
}

Galaxy "NGC 3300:UGC 5766:MCG 2-27-30:ZWG 65.66"
{
        Type  "S0"
        RA           10.6106
        Dec          14.1711
        Distance    1.53e+08  # method: V
        Radius     3.783e+04
        AbsMag        -20.06
        Axis    [ -0.7313   0.5236  -0.4372]
        Angle     74.4489
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3300"
}

Galaxy "NGC 3301:NGC 3760:UGC 5767:MCG 4-25-35"
{
        Type  "SBa"
        RA           10.6153
        Dec          21.8817
        Distance   7.407e+07  # method: V
        Radius     3.555e+04
        AbsMag        -19.48
        Axis    [  0.9420   0.2160   0.2567]
        Angle     60.6741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3301"
}

Galaxy "NGC 3302:ESO 437-7:MCG 5-25-20:AM 1033-320"
{
        Type  "S0"
        RA           10.5964
        Dec         -32.3583
        Distance    1.99e+08  # method: V
        Radius      4.63e+04
        AbsMag        -20.43
        Axis    [  0.0412   0.0474  -0.9980]
        Angle     82.3695
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3302"
}

Galaxy "NGC 3303:UGC 5773:MCG 3-27-66:ZWG 94.96"
{
        Type  "Sc"
        RA           10.6164
        Dec          18.1369
        Distance    2.94e+08  # method: V
        Radius     7.268e+04
        AbsMag        -20.47
        Axis    [ -0.5150   0.6242  -0.5876]
        Angle     77.2769
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3303"
}

Galaxy "NGC 3304:UGC 5777:MCG 6-23-26:ZWG 183.32"
{
        Type  "SBa"
        RA           10.6269
        Dec          37.4564
        Distance   3.241e+08  # method: V
        Radius     8.013e+04
        AbsMag        -20.29
        Axis    [ -0.6767   0.7362  -0.0109]
        Angle     64.3773
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3304"
}

Galaxy "NGC 3305:ESO 501-30:MCG 4-25-31"
{
        Type  "E0"
        RA           10.6031
        Dec         -27.1622
        Distance   1.883e+08  # method: T-F
        Radius     3.012e+04
        AbsMag        -20.01
        Axis    [  0.8074  -0.4034  -0.4305]
        Angle    147.7514
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3305"
}

Galaxy "NGC 3306:UGC 5774:MCG 2-27-32:ZWG 65.68"
{
        Type  "Irr"
        RA           10.6194
        Dec          12.6525
        Distance    1.75e+08  # method: T-F
        Radius     3.563e+04
        AbsMag        -19.85
        Axis    [ -0.6284   0.6688  -0.3972]
        Angle     41.7138
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3306"
}

Galaxy "NGC 3307:ESO 501-31:MCG 4-25-29"
{
        Type  "SBa"
        RA           10.6047
        Dec         -27.5289
        Distance   1.914e+08  # method: V
        Radius     2.506e+04
        AbsMag        -19.24
        Axis    [  0.9247   0.2192  -0.3112]
        Angle     98.9023
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3307"
}

Galaxy "NGC 3308:ESO 501-34:MCG 4-25-32"
{
        Type  "S0"
        RA           10.6061
        Dec         -27.4372
        Distance   1.883e+08  # method: T-F
        Radius     4.655e+04
        AbsMag        -20.81
        Axis    [  0.8511  -0.0450  -0.5231]
        Angle    109.8608
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3308"
}

Galaxy "NGC 3309:ESO 501-36:MCG 4-25-34:AM 1034-271"
{
        Type  "E3"
        RA           10.6097
        Dec         -27.5175
        Distance   1.883e+08  # method: T-F
        Radius     5.203e+04
        AbsMag        -21.21
        Axis    [  0.6851  -0.3218  -0.6536]
        Angle    136.7550
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3309"
}

Galaxy "NGC 3310:UGC 5786:MCG 9-18-8:ZWG 267.4"
{
        Type  "SBc"
        RA           10.6458
        Dec          53.5033
        Distance   5.296e+07  # method: V
        Radius     2.388e+04
        AbsMag        -19.65
        Axis    [ -0.3256   0.9211  -0.2135]
        Angle     72.5245
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3310"
}

Galaxy "NGC 3311:ESO 501-38:MCG 4-25-36:AM 1034-271"
{
        Type  "S0"
        RA           10.6117
        Dec         -27.5286
        Distance   1.883e+08  # method: T-F
        Radius     6.299e+04
        AbsMag        -21.21
        Axis    [  0.8493  -0.1798  -0.4964]
        Angle    126.0352
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3311"
}

Galaxy "NGC 3312:IC 629:ESO 501-43:MCG 4-25-39"
{
        Type  "Sb"
        RA           10.6172
        Dec         -27.5656
        Distance   1.447e+08  # method: V
        Radius     6.947e+04
        AbsMag        -20.53
        Axis    [ -0.7643  -0.0464  -0.6432]
        Angle     73.9468
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3312"
}

Galaxy "NGC 3313:ESO 501-50:MCG 4-25-44:UGCA 213"
{
        Type  "SBb"
        RA           10.6236
        Dec         -25.3189
        Distance   1.846e+08  # method: V
        Radius     1.047e+05
        AbsMag        -21.36
        Axis    [  0.7101  -0.0546  -0.7020]
        Angle     98.5179
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3313"
}

Galaxy "NGC 3314A:ESO 501-46:MCG 4-25-41:AM 1034-272"
{
        Type  "SBa"
        RA           10.6200
        Dec         -27.6833
        Distance   1.451e+08  # method: V
        Radius     3.166e+04
        AbsMag        -19.74
        Axis    [ -0.4546   0.0316  -0.8901]
        Angle     52.7049
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3314A"
}

Galaxy "NGC 3314B"
{
        Type  "S0"
        RA           10.6192
        Dec         -27.6575
        Distance    2.44e+08  # distance uncertain!
        Radius      1.42e+04
        AbsMag        -19.07
        Axis    [  0.3080   0.0495  -0.9501]
        Angle     79.8477
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3314B"
}

Galaxy "NGC 3315:ESO 501-48:MCG 4-25-42"
{
        Type  "S0"
        RA           10.6219
        Dec         -27.1917
        Distance   1.883e+08  # method: T-F
        Radius     3.012e+04
        AbsMag        -19.51
        Axis    [  0.4533  -0.0482  -0.8901]
        Angle     99.4067
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3315"
}

Galaxy "NGC 3316-1:ESO 501-54:MCG 4-25-46:AM 1035-271"
{
        Type  "S0"
        RA           10.6269
        Dec         -27.5942
        Distance   2.039e+08  # method: V
        Radius     4.151e+04
        AbsMag        -20.28
        Axis    [  0.7985  -0.1075  -0.5923]
        Angle    112.8541
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3316-1"
}

Galaxy "NGC 3316-2:ESO 501-54:MCG 4-25-46:AM 1035-271"
{
        Type  "S0"
        RA           10.6272
        Dec         -27.5997
        Distance   3.369e+08  # distance uncertain!
        Radius      1.47e+04
        AbsMag        -19.07
        Axis    [  0.5453   0.0565  -0.8363]
        Angle     78.6423
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3316-2"
}

Galaxy "NGC 3318:ESO 317-52:MCG 7-22-26:AM 1035-412"
{
        Type  "SBc"
        RA           10.6208
        Dec         -41.6272
        Distance   1.131e+08  # method: S
        Radius     3.783e+04
        AbsMag         -20.4
        Axis    [  0.5474   0.0767  -0.8334]
        Angle     82.7598
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3318"
}

Galaxy "NGC 3318A:ESO 317-50"
{
        Type  "SBc"
        RA           10.5919
        Dec         -41.7403
        Distance   3.072e+08  # distance uncertain!
        Radius     5.809e+04
        AbsMag        -19.07
        Axis    [  0.9167   0.2842  -0.2807]
        Angle    126.6768
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3318A"
}

Galaxy "NGC 3318B:ESO 317-53:MCG 7-22-27:AM 1035-411"
{
        Type  "SBc"
        RA           10.6258
        Dec         -41.4661
        Distance   1.055e+08  # method: T-F
        Radius     2.302e+04
        AbsMag        -18.65
        Axis    [  0.1344  -0.0124  -0.9909]
        Angle     89.1531
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3318B"
}

Galaxy "NGC 3319:UGC 5789:MCG 7-22-36:ZWG 212.33"
{
        Type  "SBc"
        RA           10.6525
        Dec          41.6872
        Distance    6.99e+07  # method: T-F
        Radius     6.202e+04
        AbsMag        -20.15
        Axis    [  0.9404  -0.1148   0.3200]
        Angle     67.2661
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3319"
}

Galaxy "NGC 3320:UGC 5794:MCG 8-20-10:ZWG 241.5"
{
        Type  "SBc"
        RA           10.6600
        Dec          47.3972
        Distance   1.276e+08  # method: T-F
        Radius     4.082e+04
        AbsMag        -19.86
        Axis    [  0.8818  -0.1829   0.4346]
        Angle     84.9898
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3320"
}

Galaxy "NGC 3321:NGC 3322:MCG 2-27-10:UGCA 214"
{
        Type  "Sc"
        RA           10.6472
        Dec         -11.6489
        Distance   1.499e+08  # method: T-F
        Radius     5.452e+04
        AbsMag        -19.11
        Axis    [  0.9512   0.0932  -0.2943]
        Angle     86.7339
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3321"
}

Galaxy "NGC 3323:UGC 5800:MCG 4-25-36:ZWG 124.49"
{
        Type  "SBa"
        RA           10.6608
        Dec          25.3225
        Distance   2.477e+08  # method: V
        Radius     3.603e+04
        AbsMag         -20.1
        Axis    [ -0.6669   0.6461  -0.3713]
        Angle     78.2368
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3323"
}

Galaxy "NGC 3325:UGC 5795:MCG 0-27-36:ZWG 9.93"
{
        Type  "E0"
        RA           10.6556
        Dec          -0.1997
        Distance   2.729e+08  # method: V
        Radius     4.764e+04
        AbsMag        -21.21
        Axis    [  0.5898  -0.2759  -0.7590]
        Angle    103.5496
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3325"
}

Galaxy "NGC 3326:UGC 5799:MCG 1-27-25:MK 1260"
{
        Type  "Sa"
        RA           10.6586
        Dec           5.1072
        Distance   3.718e+08  # method: V
        Radius     3.245e+04
        AbsMag        -20.88
        Axis    [  0.7756  -0.5437  -0.3206]
        Angle    121.6587
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3326"
}

Galaxy "NGC 3327:UGC 5803:MCG 4-25-38:ZWG 124.51"
{
        Type  "Sb"
        RA           10.6658
        Dec          24.0917
        Distance   2.988e+08  # method: V
        Radius      4.78e+04
        AbsMag        -20.61
        Axis    [  0.7763   0.3396  -0.5310]
        Angle     39.2101
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3327"
}

Galaxy "NGC 3331:ESO 501-72:MCG 4-25-56:AM 1037-233"
{
        Type  "SBc"
        RA           10.6692
        Dec         -23.8206
        Distance   1.843e+08  # method: V
        Radius     3.216e+04
        AbsMag        -19.86
        Axis    [  0.8828  -0.0595  -0.4659]
        Angle    109.5947
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3331"
}

Galaxy "NGC 3333:ESO 376-2:MCG 6-24-1:IRAS 10375-3546"
{
        Type  "SBc"
        RA           10.6636
        Dec         -36.0361
        Distance   1.518e+08  # method: T-F
        Radius     4.635e+04
        AbsMag        -19.44
        Axis    [ -0.6790  -0.2293  -0.6974]
        Angle     56.3574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3333"
}

Galaxy "NGC 3334:UGC 5817:MCG 6-24-4:ZWG 184.5"
{
        Type  "S0"
        RA           10.6919
        Dec          37.3125
        Distance    3.38e+08  # method: V
        Radius     5.407e+04
        AbsMag        -21.18
        Axis    [  0.8306  -0.5564   0.0205]
        Angle     97.4751
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3334"
}

Galaxy "NGC 3335:ESO 501-71:MCG 4-25-55:AM 1037-233"
{
        Type  "SBa"
        RA           10.6594
        Dec         -23.9219
        Distance   1.843e+08  # method: V
        Radius     2.948e+04
        AbsMag        -19.76
        Axis    [ -0.1159   0.1192  -0.9861]
        Angle     82.5951
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3335"
}

Galaxy "NGC 3336:ESO 437-36:MCG 5-25-36:AM 1037-273"
{
        Type  "SBc"
        RA           10.6711
        Dec         -27.7772
        Distance   1.961e+08  # method: V
        Radius     5.703e+04
        AbsMag        -20.89
        Axis    [ -0.0297   0.0739  -0.9968]
        Angle     82.9153
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3336"
}

Galaxy "NGC 3337:ZWG 37.119:NPM 1"
{
        Type  "S0"
        RA           10.6964
        Dec           4.9889
        Distance   1.938e+08  # distance uncertain!
        Radius     1.692e+04
        AbsMag        -19.07
        Axis    [  0.9816   0.0637  -0.1798]
        Angle     70.8336
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3337"
}

Galaxy "NGC 3338:UGC 5826:MCG 2-27-41:ZWG 65.87"
{
        Type  "Sc"
        RA           10.7019
        Dec          13.7467
        Distance   9.459e+07  # method: T-F
        Radius     7.842e+04
        AbsMag        -20.71
        Axis    [  0.4830   0.5390  -0.6901]
        Angle     34.7954
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3338"
}

Galaxy "NGC 3340:UGC 5827:MCG 0-27-42:ZWG 9.101"
{
        Type  "Sc"
        RA           10.7047
        Dec          -0.3769
        Distance   2.682e+08  # method: V
        Radius     3.901e+04
        AbsMag        -20.87
        Axis    [ -0.2574   0.3814  -0.8879]
        Angle     80.3553
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3340"
}

Galaxy "NGC 3341:UGC 5831:MCG 1-27-31:ZWG 37.124"
{
        Type  "Irr"
        RA           10.7086
        Dec           5.0442
        Distance   3.163e+08  # distance uncertain!
        Radius      5.52e+04
        AbsMag        -20.13
        Axis    [  0.9954   0.0902   0.0317]
        Angle     89.2252
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3341"
}

Galaxy "NGC 3342:NGC 3332:UGC 5807:MCG 2-27-38"
{
        Type  "S0"
        RA           10.6744
        Dec           9.1825
        Distance    2.75e+08  # method: V
        Radius     5.599e+04
        AbsMag        -21.13
        Axis    [  0.7661  -0.5658  -0.3051]
        Angle    118.7310
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3342"
}

Galaxy "NGC 3343:UGC 5863:MCG 12-10-73:ZWG 333.51"
{
        Type  "E0"
        RA           10.7694
        Dec          73.3533
        Distance   2.631e+08  # distance uncertain!
        Radius     4.974e+04
        AbsMag        -20.13
        Axis    [  0.8069  -0.5088  -0.3001]
        Angle     37.9932
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3343"
}

Galaxy "NGC 3344:UGC 5840:MCG 4-25-46:ZWG 124.60"
{
        Type  "SBc"
        RA           10.7250
        Dec          24.9228
        Distance   4.036e+07  # method: V
        Radius     4.168e+04
        AbsMag        -19.96
        Axis    [  0.8809  -0.4366  -0.1829]
        Angle     89.3005
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3344"
}

Galaxy "NGC 3346:UGC 5842:MCG 3-28-1:ZWG 94.116"
{
        Type  "SBc"
        RA           10.7272
        Dec          14.8722
        Distance   7.212e+07  # method: V
        Radius     2.832e+04
        AbsMag        -19.22
        Axis    [  0.4615   0.0893  -0.8826]
        Angle     66.5379
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3346"
}

Galaxy "NGC 3347:ESO 376-13:MCG 6-24-7"
{
        Type  "SBb"
        RA           10.7128
        Dec         -36.3533
        Distance   1.042e+08  # method: T-F
        Radius     5.155e+04
        AbsMag        -20.32
        Axis    [ -0.6353  -0.0329  -0.7715]
        Angle     89.0486
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3347"
}

Galaxy "NGC 3347A:ESO 376-4:MCG 6-24-2:AM 1038-360"
{
        Type  "SBc"
        RA           10.6722
        Dec         -36.4125
        Distance   1.253e+08  # method: T-F
        Radius     3.645e+04
        AbsMag        -19.42
        Axis    [  0.9368   0.1964  -0.2895]
        Angle    124.0008
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3347A"
}

Galaxy "NGC 3347B:ESO 376-10:MCG 6-24-5:IRAS 10397-3640"
{
        Type  "SBc"
        RA           10.7000
        Dec         -36.9364
        Distance   1.509e+08  # method: T-F
        Radius     7.021e+04
        AbsMag        -19.62
        Axis    [  0.4642   0.1543  -0.8722]
        Angle     52.8214
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3347B"
}

Galaxy "NGC 3347C:ESO 376-5:MCG 6-24-3"
{
        Type  "SBc"
        RA           10.6814
        Dec         -36.2886
        Distance   1.502e+08  # method: V
        Radius     3.058e+04
        AbsMag        -18.52
        Axis    [  0.8647  -0.0490  -0.4999]
        Angle    124.8467
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3347C"
}

Galaxy "NGC 3348:UGC 5875:MCG 12-10-77:ZWG 333.54"
{
        Type  "E0"
        RA           10.7861
        Dec          72.8389
        Distance   1.179e+08  # method: T-F
        Radius     3.429e+04
        AbsMag        -20.69
        Axis    [  0.4323  -0.9004   0.0494]
        Angle     81.1125
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3348"
}

Galaxy "NGC 3349-1:MCG 1-28-2:ZWG 38.2:VV 514"
{
        Type  "Sc"
        RA           10.7306
        Dec           6.7631
        Distance    2.33e+08  # distance uncertain!
        Radius     1.695e+04
        AbsMag        -19.07
        Axis    [  0.7660  -0.5587  -0.3179]
        Angle    120.8405
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3349-1"
}

Galaxy "NGC 3349-2:MCG 1-28-2:ZWG 38.2:VV 514"
{
        Type  "Irr"
        RA           10.7311
        Dec           6.7572
        Distance   3.802e+08  # distance uncertain!
        Radius     2.765e+04
        AbsMag        -20.13
        Axis    [  0.9899  -0.1156  -0.0818]
        Angle     97.5061
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3349-2"
}

Galaxy "NGC 3350:ZWG 155.2:ZWG 154.44:NPM 1"
{
        Type  "S0"
        RA           10.7394
        Dec          30.7253
        Distance   4.839e+08  # method: V
        Radius     4.222e+04
        AbsMag        -20.36
        Axis    [  0.7001  -0.6836  -0.2065]
        Angle    104.0664
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3350"
}

Galaxy "M 95:NGC 3351:UGC 5850:MCG 2-28-1"
{
        Type  "SBb"
        RA           10.7325
        Dec          11.7033
        Distance    5.06e+07  # method: V
        Radius     5.446e+04
        AbsMag        -20.35
        Axis    [  0.9779  -0.1960  -0.0730]
        Angle     97.5473
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 95"
}

Galaxy "NGC 3352:UGC 5851:MCG 4-25-48:ZWG 124.61"
{
        Type  "S0"
        RA           10.7372
        Dec          22.3714
        Distance   2.744e+08  # method: V
        Radius     6.386e+04
        AbsMag        -21.02
        Axis    [  0.9388  -0.3436   0.0236]
        Angle    104.7844
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3352"
}

Galaxy "NGC 3353:UGC 5860:MCG 9-18-22:MK 35"
{
        Type  "Sb"
        RA           10.7561
        Dec          55.9597
        Distance   5.037e+07  # method: V
        Radius     1.026e+04
        AbsMag        -17.74
        Axis    [  0.9140  -0.0149   0.4055]
        Angle     44.2366
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3353"
}

Galaxy "NGC 3354:ESO 376-14:MCG 6-24-8:AM 1040-360"
{
        Type  "S0"
        RA           10.7172
        Dec         -36.3628
        Distance   1.413e+08  # method: V
        Radius     1.439e+04
        AbsMag        -19.48
        Axis    [  0.8172  -0.3489  -0.4588]
        Angle    154.0922
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3354"
}

Galaxy "NGC 3355:ESO 501-80:MCG 4-26-1:IRAS 10402-2340"
{
        Type  "Sb"
        RA           10.7103
        Dec         -23.9344
        Distance   4.911e+07  # method: T-F
        Radius     2.143e+04
        AbsMag        -17.09
        Axis    [  0.3478   0.2691  -0.8981]
        Angle     36.4412
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3355"
}

Galaxy "NGC 3356:UGC 5852:MCG 1-28-4:ZWG 38.5"
{
        Type  "Sc"
        RA           10.7367
        Dec           6.7589
        Distance   2.275e+08  # method: T-F
        Radius     5.624e+04
        AbsMag        -20.52
        Axis    [  0.4463   0.5650  -0.6939]
        Angle     31.4937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3356"
}

Galaxy "NGC 3357:UGC 5206:UGC 5854A:MCG 2-28-2"
{
        Type  "E0"
        RA           10.7389
        Dec          14.0844
        Distance   4.595e+08  # method: V
        Radius     8.689e+04
        AbsMag        -21.74
        Axis    [  0.3826   0.0054  -0.9239]
        Angle     84.3665
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3357"
}

Galaxy "NGC 3358:ESO 376-17:MCG 6-24-9:IRAS 10412-3609"
{
        Type  "SBa"
        RA           10.7258
        Dec         -36.4108
        Distance   1.492e+08  # method: V
        Radius     6.945e+04
        AbsMag         -20.9
        Axis    [ -0.3079  -0.0251  -0.9511]
        Angle     72.7309
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3358"
}

Galaxy "NGC 3359:UGC 5873:MCG 11-13-37:ZWG 313.33"
{
        Type  "SBc"
        RA           10.7767
        Dec          63.2233
        Distance    5.83e+07  # method: T-F
        Radius     6.105e+04
        AbsMag        -20.26
        Axis    [ -0.4594   0.8882   0.0080]
        Angle     85.7741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3359"
}

Galaxy "NGC 3360:MCG 2-28-3"
{
        Type  "Sc"
        RA           10.7378
        Dec         -11.2425
        Distance   3.985e+08  # method: V
        Radius     6.955e+04
        AbsMag        -21.03
        Axis    [  0.7964  -0.0415  -0.6034]
        Angle     81.8854
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3360"
}

Galaxy "NGC 3361:MCG 2-28-4:IRAS 10419-1056"
{
        Type  "SBc"
        RA           10.7414
        Dec         -11.2081
        Distance   1.133e+08  # method: T-F
        Radius     3.462e+04
        AbsMag         -19.2
        Axis    [ -0.7029   0.2103  -0.6795]
        Angle     54.6935
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3361"
}

Galaxy "NGC 3362:UGC 5857:MCG 1-28-5:ZWG 38.7"
{
        Type  "Sc"
        RA           10.7475
        Dec           6.5972
        Distance   3.926e+08  # method: V
        Radius     7.994e+04
        AbsMag         -21.9
        Axis    [  0.8691  -0.0906  -0.4863]
        Angle     70.5747
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3362"
}

Galaxy "NGC 3363:UGC 5866:MCG 4-26-2:ZWG 125.3"
{
        Type  "Sc"
        RA           10.7525
        Dec          22.0786
        Distance   2.755e+08  # method: V
        Radius     5.209e+04
        AbsMag        -20.13
        Axis    [  0.9636  -0.2505   0.0938]
        Angle    105.6135
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3363"
}

Galaxy "NGC 3364:UGC 5890:MCG 12-10-82:ZWG 333.56"
{
        Type  "SBc"
        RA           10.8081
        Dec          72.4250
        Distance   1.262e+08  # method: V
        Radius     2.752e+04
        AbsMag        -19.24
        Axis    [  0.4561  -0.8866   0.0763]
        Angle     81.7534
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3364"
}

Galaxy "NGC 3365:UGC 5878:MCG 0-28-6:ZWG 10.8"
{
        Type  "Sc"
        RA           10.7700
        Dec           1.8128
        Distance   7.746e+07  # method: T-F
        Radius      5.07e+04
        AbsMag        -18.68
        Axis    [ -0.9224   0.2931  -0.2517]
        Angle     49.2717
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3365"
}

Galaxy "NGC 3366:IC 2592:ESO 264-7:MCG 7-22-24"
{
        Type  "SBb"
        RA           10.5856
        Dec         -43.6936
        Distance   1.506e+08  # method: T-F
        Radius     3.942e+04
        AbsMag        -21.12
        Axis    [  0.8240   0.1788  -0.5376]
        Angle    105.2596
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3366"
}

Galaxy "NGC 3367:UGC 5880:MCG 2-28-5:ZWG 66.11"
{
        Type  "SBc"
        RA           10.7761
        Dec          13.7503
        Distance    1.53e+08  # method: V
        Radius     5.563e+04
        AbsMag        -21.26
        Axis    [  0.7322  -0.2220  -0.6439]
        Angle     75.8950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3367"
}

Galaxy "M 96:NGC 3368:UGC 5882:MCG 2-28-6"
{
        Type  "SBb"
        RA           10.7792
        Dec          11.8200
        Distance   3.384e+07  # method: S
        Radius     3.839e+04
        AbsMag        -19.98
        Axis    [ -0.6822   0.5169  -0.5171]
        Angle     80.3481
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 96"
}

Galaxy "NGC 3369:ESO 501-95:MCG 4-26-9"
{
        Type  "S0"
        RA           10.7789
        Dec         -25.2442
        Distance   1.768e+08  # distance uncertain!
        Radius       3.6e+04
        AbsMag        -19.07
        Axis    [  0.0859   0.0904  -0.9922]
        Angle     60.7065
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3369"
}

Galaxy "NGC 3370:UGC 5887:MCG 3-28-8:ZWG 95.19"
{
        Type  "Sc"
        RA           10.7844
        Dec          17.2739
        Distance   7.289e+07  # method: V
        Radius     2.756e+04
        AbsMag        -19.35
        Axis    [ -0.5494   0.6508  -0.5241]
        Angle     52.9584
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3370"
}

Galaxy "NGC 3374:UGC 5901:MCG 7-22-66:ZWG 212.57"
{
        Type  "SBc"
        RA           10.8003
        Dec          43.1861
        Distance   1.612e+08  # distance uncertain!
        Radius     3.048e+04
        AbsMag        -19.07
        Axis    [ -0.3340   0.9110  -0.2417]
        Angle     53.9221
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3374"
}

Galaxy "NGC 3375:MCG 2-28-8:MCG 1-28-2"
{
        Type  "S0"
        RA           10.7833
        Dec          -9.9419
        Distance   1.471e+08  # method: T-F
        Radius     3.424e+04
        AbsMag        -19.67
        Axis    [ -0.4540   0.2869  -0.8436]
        Angle     74.4574
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3375"
}

Galaxy "NGC 3376:UGC 5891:MCG 1-28-7:ZWG 38.13"
{
        Type  "S0"
        RA           10.7906
        Dec           6.0486
        Distance   2.802e+08  # method: V
        Radius     3.261e+04
        AbsMag        -20.37
        Axis    [ -0.7510   0.4292  -0.5018]
        Angle     66.3247
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3376"
}

Galaxy "NGC 3377:UGC 5899:MCG 2-28-9:ZWG 66.16"
{
        Type  "E5"
        RA           10.7950
        Dec          13.9858
        Distance    3.66e+07  # method: S
        Radius     2.661e+04
        AbsMag        -19.05
        Axis    [  0.6778  -0.4576  -0.5756]
        Angle     97.8058
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3377"
}

Galaxy "NGC 3377A:UGC 5889:MCG 2-28-7:DDO 88"
{
        Type  "Irr"
        RA           10.7894
        Dec          14.0700
        Distance   4.113e+07  # method: V
        Radius     1.316e+04
        AbsMag         -16.2
        Axis    [  0.4621   0.0815  -0.8831]
        Angle     65.3115
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3377A"
}

Galaxy "NGC 3378:ESO 318-12:MCG 7-22-29:IRAS 10444-3945"
{
        Type  "SBc"
        RA           10.7786
        Dec         -40.0156
        Distance   2.483e+08  # method: V
        Radius     5.417e+04
        AbsMag        -20.91
        Axis    [  0.8404  -0.1758  -0.5126]
        Angle    141.5863
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3378"
}

Galaxy "M 105:NGC 3379:UGC 5902:MCG 2-28-11"
{
        Type  "E1"
        RA           10.7969
        Dec          12.5811
        Distance   3.447e+07  # method: S
        Radius     2.657e+04
        AbsMag        -19.62
        Axis    [  0.5115  -0.1837  -0.8394]
        Angle     87.2819
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 105"
}

Galaxy "NGC 3380:UGC 5906:MCG 5-26-12:ZWG 155.15"
{
        Type  "SBa"
        RA           10.8033
        Dec          28.6019
        Distance   8.607e+07  # method: V
        Radius     2.003e+04
        AbsMag        -18.61
        Axis    [  0.8893  -0.4511  -0.0755]
        Angle     91.9268
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3380"
}

Galaxy "NGC 3381:UGC 5909:MCG 6-24-15:ZWG 184.16"
{
        Type  "SBa"
        RA           10.8067
        Dec          34.7114
        Distance    8.58e+07  # method: V
        Radius     2.496e+04
        AbsMag         -19.4
        Axis    [  0.9007  -0.1805  -0.3952]
        Angle     52.2390
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3381"
}

Galaxy "NGC 3383:ESO 501-97:MCG 4-26-10:AM 1044-241"
{
        Type  "SBc"
        RA           10.7886
        Dec         -24.4378
        Distance   1.815e+08  # method: T-F
        Radius     3.695e+04
        AbsMag        -20.23
        Axis    [  0.8752  -0.1008  -0.4731]
        Angle    113.3937
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3383"
}

Galaxy "NGC 3384:NGC 3371:UGC 5911:MCG 2-28-12"
{
        Type  "S0"
        RA           10.8044
        Dec          12.6286
        Distance    3.78e+07  # method: S
        Radius     2.968e+04
        AbsMag        -19.42
        Axis    [  0.9902   0.0684  -0.1221]
        Angle     60.4518
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3384"
}

Galaxy "NGC 3385:UGC 5908:MCG 1-28-9:ZWG 38.15"
{
        Type  "S0"
        RA           10.8031
        Dec           4.9283
        Distance   3.701e+08  # method: V
        Radius     8.074e+04
        AbsMag        -21.87
        Axis    [  0.5068   0.3432  -0.7908]
        Angle     40.1725
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3385"
}

Galaxy "NGC 3386:MCG 1-28-10:ZWG 38.16:NPM 1"
{
        Type  "E0"
        RA           10.8031
        Dec           4.9992
        Distance   3.163e+08  # distance uncertain!
        Radius       2.3e+04
        AbsMag        -20.13
        Axis    [  0.7447  -0.5734  -0.3416]
        Angle    123.5580
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3386"
}

Galaxy "NGC 3387"
{
        Type  "E0"
        RA           10.8044
        Dec           4.9669
        Distance   5.496e+08  # distance uncertain!
        Radius     1.998e+04
        AbsMag        -20.13
        Axis    [  0.4253  -0.1146  -0.8978]
        Angle     93.2365
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3387"
}

Galaxy "NGC 3389:NGC 3373:UGC 5914:MCG 2-28-13"
{
        Type  "Sc"
        RA           10.8078
        Dec          12.5331
        Distance    7.42e+07  # method: V
        Radius      3.13e+04
        AbsMag        -19.28
        Axis    [  0.1261   0.7834  -0.6086]
        Angle     26.8491
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3389"
}

Galaxy "NGC 3390:ESO 437-62:MCG 5-26-7:IRAS 10457-3116"
{
        Type  "Sb"
        RA           10.8011
        Dec         -31.5333
        Distance   1.423e+08  # method: V
        Radius     7.246e+04
        AbsMag         -20.3
        Axis    [ -0.8337  -0.2416  -0.4965]
        Angle     67.7197
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3390"
}

Galaxy "NGC 3391:UGC 5920:MCG 2-28-14:ZWG 66.27"
{
        Type  "Sc"
        RA           10.8156
        Dec          14.2194
        Distance   1.492e+08  # method: V
        Radius      2.17e+04
        AbsMag         -19.6
        Axis    [  0.9696  -0.1608  -0.1845]
        Angle     77.5904
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3391"
}

Galaxy "NGC 3392:MCG 11-13-42:ZWG 313.37"
{
        Type  "E0"
        RA           10.8506
        Dec          65.7814
        Distance   1.534e+08  # method: V
        Radius     1.785e+04
        AbsMag        -18.36
        Axis    [  0.3376   0.7238  -0.6018]
        Angle     56.2577
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3392"
}

Galaxy "NGC 3393:ESO 501-100:MCG 4-26-11:AM 1045-245"
{
        Type  "SBa"
        RA           10.8064
        Dec         -25.1617
        Distance   1.842e+08  # method: V
        Radius     4.823e+04
        AbsMag        -20.66
        Axis    [  0.7376  -0.1006  -0.6677]
        Angle    102.3047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3393"
}

Galaxy "NGC 3394:UGC 5937:MCG 11-13-41:ZWG 313.36"
{
        Type  "Sc"
        RA           10.8442
        Dec          65.7278
        Distance   1.593e+08  # method: V
        Radius     4.402e+04
        AbsMag        -20.34
        Axis    [  0.7958  -0.3655   0.4828]
        Angle     63.7280
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3394"
}

Galaxy "NGC 3395:IC 2613:UGC 5931:MCG 6-24-17"
{
        Type  "SBc"
        RA           10.8303
        Dec          32.9814
        Distance   8.603e+07  # method: V
        Radius     2.628e+04
        AbsMag        -19.61
        Axis    [  0.9784  -0.0097   0.2066]
        Angle     57.8273
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3395"
}

Galaxy "NGC 3396:UGC 5935:MCG 6-24-18:ZWG 184.19"
{
        Type  "Irr"
        RA           10.8319
        Dec          32.9906
        Distance   8.657e+07  # method: V
        Radius     3.651e+04
        AbsMag        -19.52
        Axis    [  0.4265   0.8566   0.2903]
        Angle     27.9155
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3396"
}

Galaxy "NGC 3397:NGC 3329:UGC 5837:MCG 13-8-33"
{
        Type  "Sb"
        RA           10.7442
        Dec          76.8097
        Distance   8.412e+07  # method: V
        Radius     2.325e+04
        AbsMag        -19.06
        Axis    [ -0.2447   0.9022   0.3552]
        Angle     71.2711
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3397"
}

Galaxy "NGC 3398:IC 644:UGC 5954:MCG 9-18-38"
{
        Type  "Sa"
        RA           10.8586
        Dec          55.3911
        Distance   1.377e+08  # method: V
        Radius     2.002e+04
        AbsMag        -18.63
        Axis    [  0.4750   0.3492   0.8077]
        Angle     53.9621
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3398"
}

Galaxy "NGC 3399:MCG 3-28-12:ZWG 95.31"
{
        Type  "S0"
        RA           10.8242
        Dec          16.2189
        Distance   3.242e+08  # method: V
        Radius     3.772e+04
        AbsMag        -20.69
        Axis    [  0.7359  -0.6158  -0.2816]
        Angle    114.6243
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3399"
}

Galaxy "NGC 3400:UGC 5949:MCG 5-26-20:ZWG 155.25"
{
        Type  "SBa"
        RA           10.8458
        Dec          28.4689
        Distance   7.715e+07  # method: V
        Radius     1.234e+04
        AbsMag        -17.57
        Axis    [  0.5473   0.7182  -0.4297]
        Angle     28.5685
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3400"
}

Galaxy "NGC 3403:UGC 5997:MCG 12-10-89:ZWG 333.62"
{
        Type  "Sc"
        RA           10.8983
        Dec          73.6900
        Distance   9.925e+07  # method: T-F
        Radius     4.331e+04
        AbsMag        -19.42
        Axis    [  0.4275   0.2224   0.8762]
        Angle     60.6121
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3403"
}

Galaxy "NGC 3404:IC 2609:MCG 2-28-11:IRAS 10477-1150"
{
        Type  "SBb"
        RA           10.8381
        Dec         -12.1081
        Distance   1.341e+08  # distance uncertain!
        Radius     4.096e+04
        AbsMag        -19.07
        Axis    [  0.7977   0.3613  -0.4828]
        Angle     39.6132
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3404"
}

Galaxy "NGC 3405-1:UGC 5933:MCG 3-28-14:ZWG 95.33"
{
        Type  "S0"
        RA           10.8286
        Dec          16.2392
        Distance   2.555e+08  # distance uncertain!
        Radius     2.602e+04
        AbsMag        -19.07
        Axis    [  0.7354  -0.6163  -0.2817]
        Angle    114.6402
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3405-1"
}

Galaxy "NGC 3405-2:UGC 5933:MCG 3-28-15:ZWG 95.33"
{
        Type  "S0"
        RA           10.8289
        Dec          16.2425
        Distance    1.54e+08  # distance uncertain!
        Radius     1.792e+04
        AbsMag        -19.07
        Axis    [  0.7354  -0.6163  -0.2817]
        Angle    114.6398
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3405-2"
}

Galaxy "NGC 3406-1:UGC 5970:MCG 9-18-40:ZWG 267.20"
{
        Type  "S0"
        RA           10.8619
        Dec          51.0228
        Distance   1.168e+08  # distance uncertain!
        Radius     1.529e+04
        AbsMag        -19.07
        Axis    [  0.9093  -0.2238   0.3507]
        Angle     60.3754
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3406-1"
}

Galaxy "NGC 3406-2:UGC 5970:MCG 9-18-40:ZWG 267.20"
{
        Type  "Irr"
        RA           10.8622
        Dec          51.0258
        Distance   1.906e+08  # distance uncertain!
        Radius     1.386e+04
        AbsMag        -20.13
        Axis    [  0.8698  -0.3237   0.3723]
        Angle     81.7932
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3406-2"
}

Galaxy "NGC 3407:UGC 5978:MCG 10-16-17:ZWG 291.7"
{
        Type  "S0"
        RA           10.8714
        Dec          61.3794
        Distance   2.325e+08  # method: V
        Radius     4.734e+04
        AbsMag        -19.66
        Axis    [  0.7904  -0.3275   0.5177]
        Angle     89.8755
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3407"
}

Galaxy "NGC 3408:UGC 5977:MCG 10-16-16:ZWG 291.6"
{
        Type  "Sc"
        RA           10.8697
        Dec          58.4386
        Distance   4.386e+08  # method: V
        Radius     5.103e+04
        AbsMag        -21.44
        Axis    [  0.0442   0.9693  -0.2419]
        Angle     47.9594
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3408"
}

Galaxy "NGC 3409:MCG 3-28-12"
{
        Type  "Sc"
        RA           10.8389
        Dec         -17.0447
        Distance   1.938e+08  # distance uncertain!
        Radius     3.383e+04
        AbsMag        -19.07
        Axis    [  0.9659   0.2488  -0.0718]
        Angle    107.9705
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3409"
}

Galaxy "NGC 3410:MCG 9-18-42:ZWG 267.21:ARAK 261"
{
        Type  "S0"
        RA           10.8647
        Dec          51.0064
        Distance   3.307e+08  # method: V
        Radius     3.848e+04
        AbsMag        -20.03
        Axis    [  0.8760  -0.3195   0.3612]
        Angle     77.4818
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3410"
}

Galaxy "NGC 3411:NGC 3402:MCG 2-28-12"
{
        Type  "E0"
        RA           10.8406
        Dec         -12.8450
        Distance   3.038e+08  # method: T-F
        Radius      9.28e+04
        AbsMag        -21.95
        Axis    [  0.7719  -0.4891  -0.4061]
        Angle    137.2978
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3411"
}

Galaxy "NGC 3412:UGC 5952:MCG 2-28-16:ZWG 66.38"
{
        Type  "S0"
        RA           10.8481
        Dec          13.4128
        Distance   3.694e+07  # method: S
        Radius     1.988e+04
        AbsMag        -18.87
        Axis    [ -0.6091   0.5705  -0.5509]
        Angle     58.8637
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3412"
}

Galaxy "NGC 3413:UGC 5960:MCG 6-24-24:ZWG 184.27"
{
        Type  "S0"
        RA           10.8556
        Dec          32.7661
        Distance    5.29e+07  # method: S
        Radius     1.385e+04
        AbsMag        -17.95
        Axis    [ -0.7526   0.6381  -0.1629]
        Angle     78.6332
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3413"
}

Galaxy "NGC 3414:UGC 5959:MCG 5-26-21:ZWG 155.29"
{
        Type  "S0"
        RA           10.8544
        Dec          27.9750
        Distance   8.231e+07  # method: S
        Radius      4.19e+04
        AbsMag        -20.11
        Axis    [  0.9539  -0.2997  -0.0178]
        Angle     80.3852
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3414"
}

Galaxy "NGC 3415:UGC 5969:MCG 7-22-72:ZWG 212.62"
{
        Type  "Sa"
        RA           10.8617
        Dec          43.7128
        Distance     1.6e+08  # method: V
        Radius     4.887e+04
        AbsMag        -20.15
        Axis    [  0.8964  -0.3492   0.2729]
        Angle     91.3614
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3415"
}

Galaxy "NGC 3416:MCG 7-22-73:ZWG 213.2:ZWG 212.63"
{
        Type  "S0"
        RA           10.8633
        Dec          43.7647
        Distance   1.589e+08  # method: V
        Radius     1.387e+04
        AbsMag        -17.64
        Axis    [  0.8785  -0.0914   0.4689]
        Angle     83.5062
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3416"
}

Galaxy "NGC 3417:ZWG 66.39"
{
        Type  "S0"
        RA           10.8503
        Dec           8.4736
        Distance   2.802e+08  # distance uncertain!
        Radius     2.445e+04
        AbsMag        -19.07
        Axis    [  0.8511   0.2816  -0.4430]
        Angle     40.1986
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3417"
}

Galaxy "NGC 3418:UGC 5963:MCG 5-26-23:ZWG 155.30"
{
        Type  "SBa"
        RA           10.8564
        Dec          28.1122
        Distance   7.013e+07  # method: V
        Radius     1.428e+04
        AbsMag        -17.26
        Axis    [  0.8889   0.0932  -0.4484]
        Angle     42.6185
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3418"
}

Galaxy "NGC 3419:UGC 5964:MCG 2-28-18:ZWG 66.41"
{
        Type  "SBa"
        RA           10.8547
        Dec          13.9456
        Distance   1.527e+08  # method: V
        Radius     2.665e+04
        AbsMag        -19.55
        Axis    [  0.1235   0.4131  -0.9023]
        Angle     51.4363
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3419"
}

Galaxy "NGC 3419A:UGC 5965:MCG 2-28-19:ZWG 66.42"
{
        Type  "SBc"
        RA           10.8553
        Dec          14.0233
        Distance   1.545e+08  # method: V
        Radius     3.595e+04
        AbsMag        -18.48
        Axis    [ -0.7523   0.6573   0.0454]
        Angle     33.7232
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3419A"
}

Galaxy "NGC 3420:MCG 3-28-11:NPM 1"
{
        Type  "SBa"
        RA           10.8358
        Dec         -17.2431
        Distance   1.851e+08  # distance uncertain!
        Radius       3.5e+04
        AbsMag        -19.07
        Axis    [  0.8455  -0.1676  -0.5070]
        Angle    107.1522
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3420"
}

Galaxy "NGC 3421:IC 652:MCG 2-28-13:NPM 1"
{
        Type  "Sa"
        RA           10.8492
        Dec         -12.4478
        Distance   1.768e+08  # distance uncertain!
        Radius     4.628e+04
        AbsMag        -19.07
        Axis    [ -0.5997   0.2972  -0.7430]
        Angle     93.8741
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3421"
}

Galaxy "NGC 3422:MCG 2-28-15"
{
        Type  "Sa"
        RA           10.8547
        Dec         -12.4019
        Distance   2.125e+08  # distance uncertain!
        Radius     4.019e+04
        AbsMag        -19.07
        Axis    [  0.9393   0.2649  -0.2180]
        Angle     65.2312
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3422"
}

Galaxy "NGC 3423:UGC 5962:MCG 1-28-12:ZWG 38.29"
{
        Type  "Sc"
        RA           10.8539
        Dec           5.8400
        Distance   6.156e+07  # method: V
        Radius     3.492e+04
        AbsMag        -19.78
        Axis    [  0.9212  -0.3186  -0.2232]
        Angle    105.8912
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3423"
}

Galaxy "NGC 3424:UGC 5972:MCG 6-24-25:ZWG 184.28"
{
        Type  "SBb"
        RA           10.8628
        Dec          32.9003
        Distance   8.045e+07  # method: V
        Radius     3.159e+04
        AbsMag        -18.76
        Axis    [ -0.0346   0.8935   0.4478]
        Angle     31.3056
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3424"
}

Galaxy "NGC 3425:NGC 3388:UGC 5967:MCG 2-28-21"
{
        Type  "S0"
        RA           10.8569
        Dec           8.5675
        Distance   3.159e+08  # method: V
        Radius     4.594e+04
        AbsMag        -20.63
        Axis    [  0.7509  -0.5794  -0.3170]
        Angle    120.2779
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3425"
}

Galaxy "NGC 3426:UGC 5975:MCG 3-28-20:ZWG 95.46"
{
        Type  "S0"
        RA           10.8614
        Dec          18.4811
        Distance   2.915e+08  # method: V
        Radius     4.664e+04
        AbsMag        -20.76
        Axis    [  0.1333   0.5754  -0.8070]
        Angle     39.6134
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3426"
}

Galaxy "NGC 3427:UGC 5966:MCG 2-28-20:ZWG 66.43"
{
        Type  "Sa"
        RA           10.8572
        Dec           8.2983
        Distance   2.994e+08  # method: V
        Radius     4.791e+04
        AbsMag        -20.71
        Axis    [  0.9028   0.2690  -0.3356]
        Angle     41.7661
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3427"
}

Galaxy "NGC 3428:NGC 3429:UGC 5968:MCG 2-28-22"
{
        Type  "SBb"
        RA           10.8581
        Dec           9.2792
        Distance   3.759e+08  # method: V
        Radius     8.201e+04
        AbsMag        -21.31
        Axis    [ -0.7913   0.4422  -0.4222]
        Angle     67.2564
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3428"
}

Galaxy "NGC 3430:UGC 5982:MCG 6-24-26:ZWG 184.29"
{
        Type  "SBc"
        RA           10.8697
        Dec          32.9508
        Distance   9.577e+07  # method: T-F
        Radius     5.711e+04
        AbsMag        -20.14
        Axis    [  0.9655  -0.1592   0.2059]
        Angle     75.8950
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3430"
}

Galaxy "NGC 3431:MCG 3-28-14:IRAS 10487-1644"
{
        Type  "Sb"
        RA           10.8542
        Dec         -17.0083
        Distance   2.594e+08  # method: V
        Radius     4.905e+04
        AbsMag         -20.1
        Axis    [ -0.5546   0.1569  -0.8172]
        Angle     33.4933
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3431"
}

Galaxy "NGC 3432:UGC 5986:MCG 6-24-28:ZWG 184.30"
{
        Type  "Irr"
        RA           10.8753
        Dec          36.6189
        Distance   5.703e+07  # method: T-F
        Radius     5.475e+04
        AbsMag        -19.51
        Axis    [  0.8720   0.0559   0.4864]
        Angle     76.5517
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3432"
}

Galaxy "NGC 3433:UGC 5981:MCG 2-28-23:ZWG 66.48"
{
        Type  "Sc"
        RA           10.8678
        Dec          10.1478
        Distance   1.387e+08  # method: V
        Radius     7.061e+04
        AbsMag        -20.64
        Axis    [  0.8482  -0.1949  -0.4925]
        Angle     74.0393
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3433"
}

Galaxy "NGC 3434:UGC 5980:MCG 1-28-15:ZWG 38.36"
{
        Type  "Sb"
        RA           10.8661
        Dec           3.7919
        Distance   1.805e+08  # method: V
        Radius     5.514e+04
        AbsMag        -20.61
        Axis    [  0.8219  -0.2566  -0.5085]
        Angle     87.6147
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3434"
}

Galaxy "NGC 3435:UGC 6025:MCG 10-16-22:ZWG 291.12"
{
        Type  "Sb"
        RA           10.9133
        Dec          61.2889
        Distance   2.399e+08  # method: V
        Radius      6.28e+04
        AbsMag        -20.33
        Axis    [  0.8182  -0.3156   0.4805]
        Angle     66.8263
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3435"
}

Galaxy "NGC 3436:MCG 1-28-16:ZWG 38.39:MK 1266"
{
        Type  "S0"
        RA           10.8742
        Dec           8.0942
        Distance    2.03e+08  # distance uncertain!
        Radius     2.066e+04
        AbsMag        -19.07
        Axis    [  0.5939   0.2037  -0.7783]
        Angle     46.3436
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3436"
}

Galaxy "NGC 3437:UGC 5995:MCG 4-26-16:ZWG 125.13"
{
        Type  "SBc"
        RA           10.8764
        Dec          22.9350
        Distance   7.833e+07  # method: T-F
        Radius     2.962e+04
        AbsMag         -19.1
        Axis    [ -0.3328   0.9407   0.0662]
        Angle     27.9532
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3437"
}

Galaxy "NGC 3438:UGC 5988:MCG 2-28-25:ZWG 66.52"
{
        Type  "S0"
        RA           10.8736
        Dec          10.5475
        Distance   3.094e+08  # method: V
        Radius       3.6e+04
        AbsMag        -20.58
        Axis    [  0.7450  -0.5911  -0.3093]
        Angle    118.9628
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3438"
}

Galaxy "NGC 3439:ZWG 66.50"
{
        Type  "E0"
        RA           10.8736
        Dec           8.5578
        Distance   3.312e+08  # distance uncertain!
        Radius     1.927e+04
        AbsMag        -20.13
        Axis    [ -0.1469   0.4354  -0.8882]
        Angle    101.9194
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3439"
}

Galaxy "NGC 3440:UGC 6009:MCG 10-16-19:ZWG 291.9"
{
        Type  "SBb"
        RA           10.8969
        Dec          57.1189
        Distance   9.395e+07  # method: V
        Radius      2.87e+04
        AbsMag         -18.3
        Axis    [  0.6707   0.0518   0.7399]
        Angle     76.1340
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3440"
}

Galaxy "NGC 3441:UGC 5993:MCG 1-28-17:ZWG 38.40"
{
        Type  "Sc"
        RA           10.8753
        Dec           7.2250
        Distance   3.175e+08  # method: V
        Radius     3.232e+04
        AbsMag        -20.74
        Axis    [  0.9889  -0.1447  -0.0347]
        Angle    106.5460
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3441"
}

Galaxy "NGC 3442:UGC 6001:MK 418:ZWG 184.34"
{
        Type  "Sa"
        RA           10.8856
        Dec          33.9100
        Distance   9.096e+07  # method: V
        Radius          7938
        AbsMag        -18.43
        Axis    [  0.9227  -0.3795  -0.0685]
        Angle     73.8844
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3442"
}

Galaxy "NGC 3443:UGC 6000:MCG 3-28-25:ZWG 95.56"
{
        Type  "Sc"
        RA           10.8833
        Dec          17.5739
        Distance   8.884e+07  # method: T-F
        Radius     3.618e+04
        AbsMag        -17.87
        Axis    [ -0.5966   0.6679  -0.4450]
        Angle     46.5890
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3443"
}

Galaxy "NGC 3444:UGC 6004:ZWG 66.55:FGC 1148"
{
        Type  "Sc"
        RA           10.8831
        Dec          10.2106
        Distance   2.676e+08  # distance uncertain!
        Radius     3.892e+04
        AbsMag        -19.07
        Axis    [  0.9729   0.1325   0.1894]
        Angle     94.5013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3444"
}

Galaxy "NGC 3445:UGC 6021:MCG 10-16-23:ZWG 291.11"
{
        Type  "Irr"
        RA           10.9097
        Dec          56.9900
        Distance   9.894e+07  # method: V
        Radius     2.302e+04
        AbsMag        -19.51
        Axis    [  0.4561   0.8604  -0.2275]
        Angle     32.6253
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3445"
}

Galaxy "NGC 3447:UGC 6006:MCG 3-28-27:ZWG 95.58"
{
        Type  "Irr"
        RA           10.8900
        Dec          16.7719
        Distance   6.338e+07  # method: V
        Radius     3.503e+04
        AbsMag        -17.54
        Axis    [  0.9749  -0.2154   0.0561]
        Angle    108.0061
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3447"
}

Galaxy "NGC 3447A:UGC 6007:MCG 3-28-28:VV 252"
{
        Type  "Irr"
        RA           10.8917
        Dec          16.7847
        Distance   6.396e+07  # method: V
        Radius     1.395e+04
        AbsMag        -18.36
        Axis    [  0.2162   0.7441  -0.6322]
        Angle     27.8551
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3447A"
}

Galaxy "NGC 3448:UGC 6024:MCG 9-18-55:ZWG 267.27"
{
        Type  "Sa"
        RA           10.9106
        Dec          54.3053
        Distance   6.949e+07  # method: V
        Radius      5.66e+04
        AbsMag        -19.14
        Axis    [  0.6276   0.1855   0.7561]
        Angle     59.5963
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3448"
}

Galaxy "NGC 3449:ESO 376-25:MCG 5-26-10:IRAS 10505-3240"
{
        Type  "SBb"
        RA           10.8814
        Dec         -32.9278
        Distance   1.527e+08  # method: T-F
        Radius     7.327e+04
        AbsMag        -20.85
        Axis    [ -0.5372  -0.1179  -0.8351]
        Angle     55.0610
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3449"
}

Galaxy "NGC 3450:ESO 569-6:MCG 3-28-4:UGCA 218"
{
        Type  "SBb"
        RA           10.8008
        Dec         -20.8489
        Distance   1.932e+08  # method: V
        Radius     7.306e+04
        AbsMag        -21.16
        Axis    [ -0.0920   0.1202  -0.9885]
        Angle     86.2399
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3450"
}

Galaxy "NGC 3451:UGC 6023:MCG 5-26-28:ZWG 155.35"
{
        Type  "SBc"
        RA           10.9058
        Dec          27.2397
        Distance   1.257e+08  # method: T-F
        Radius     3.107e+04
        AbsMag        -19.43
        Axis    [  0.9865   0.0151   0.1630]
        Angle     59.3284
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3451"
}

Galaxy "NGC 3452:MCG 2-28-19"
{
        Type  "Sa"
        RA           10.9039
        Dec         -11.4050
        Distance   2.125e+08  # distance uncertain!
        Radius       3.4e+04
        AbsMag        -19.07
        Axis    [  0.9093   0.2445  -0.3367]
        Angle     55.8549
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3452"
}

Galaxy "NGC 3453:ESO 569-17:MCG 4-26-13:IRAS 10512-2131"
{
        Type  "SBb"
        RA           10.8944
        Dec         -21.7933
        Distance   1.945e+08  # method: V
        Radius     3.112e+04
        AbsMag        -19.98
        Axis    [  0.9685   0.0168  -0.2486]
        Angle    119.7722
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3453"
}

Galaxy "NGC 3454:UGC 6026:MCG 3-28-30:ZWG 95.60"
{
        Type  "SBc"
        RA           10.9081
        Dec          17.3436
        Distance   6.514e+07  # method: V
        Radius      1.99e+04
        AbsMag         -17.5
        Axis    [ -0.2066   0.9075   0.3656]
        Angle     24.2112
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3454"
}

Galaxy "NGC 3455:UGC 6028:MCG 3-28-31:ZWG 95.62"
{
        Type  "SBb"
        RA           10.9083
        Dec          17.2844
        Distance    6.51e+07  # method: V
        Radius     2.462e+04
        AbsMag         -18.4
        Axis    [  0.8956  -0.0746  -0.4385]
        Angle     56.7621
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3455"
}

Galaxy "NGC 3456:MCG 3-28-18:IRAS 10515-1545"
{
        Type  "SBc"
        RA           10.9008
        Dec         -16.0275
        Distance    1.63e+08  # method: T-F
        Radius      4.03e+04
        AbsMag        -20.19
        Axis    [  0.2722   0.0888  -0.9581]
        Angle     63.2165
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3456"
}

Galaxy "NGC 3457:NGC 3460:UGC 6030:MCG 3-28-32"
{
        Type  "S0"
        RA           10.9133
        Dec          17.6214
        Distance   6.752e+07  # method: S
        Radius          8839
        AbsMag        -18.38
        Axis    [  0.7238  -0.6312  -0.2789]
        Angle    114.2638
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3457"
}

Galaxy "NGC 3458:UGC 6037:MCG 10-16-26:ZWG 291.14"
{
        Type  "S0"
        RA           10.9336
        Dec          57.1172
        Distance    8.97e+07  # method: V
        Radius     1.826e+04
        AbsMag         -18.9
        Axis    [  0.8144  -0.4095   0.4111]
        Angle     96.6196
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3458"
}

Galaxy "NGC 3459:MCG 3-28-22:IRAS 10522-1646"
{
        Type  "Sb"
        RA           10.9122
        Dec         -17.0417
        Distance   1.365e+08  # method: V
        Radius     3.177e+04
        AbsMag        -18.91
        Axis    [ -0.7434   0.0689  -0.6652]
        Angle     52.0628
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3459"
}

Galaxy "NGC 3461"
{
        Type  "E0"
        RA           10.9153
        Dec          17.7083
        Distance   4.366e+08  # distance uncertain!
        Radius     3.175e+04
        AbsMag        -20.13
        Axis    [  0.7032  -0.6474  -0.2940]
        Angle    115.0765
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3461"
}

Galaxy "NGC 3462:UGC 6034:MCG 1-28-19:ZWG 38.49"
{
        Type  "S0"
        RA           10.9225
        Dec           7.6969
        Distance   9.715e+07  # distance uncertain!
        Radius     2.402e+04
        AbsMag        -19.07
        Axis    [  0.8850  -0.0462  -0.4632]
        Angle     62.0114
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3462"
}

Galaxy "NGC 3463:ESO 502-2:MCG 4-26-14:IRAS 10528-2552"
{
        Type  "Sb"
        RA           10.9203
        Dec         -26.1403
        Distance   2.039e+08  # method: T-F
        Radius     4.448e+04
        AbsMag        -20.18
        Axis    [  0.6467   0.0917  -0.7572]
        Angle     65.1325
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3463"
}

Galaxy "NGC 3464:ESO 569-22:MCG 3-28-21:UGCA 222"
{
        Type  "SBc"
        RA           10.9108
        Dec         -21.0664
        Distance   1.759e+08  # method: T-F
        Radius     6.398e+04
        AbsMag        -20.46
        Axis    [  0.1039   0.0806  -0.9913]
        Angle     64.5882
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3464"
}

Galaxy "NGC 3465:UGC 6056:MCG 13-8-48:ZWG 351.50"
{
        Type  "Sb"
        RA           10.9919
        Dec          75.1917
        Distance   3.273e+08  # method: V
        Radius     5.713e+04
        AbsMag        -20.61
        Axis    [ -0.2296   0.9723  -0.0425]
        Angle     89.5047
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3465"
}

Galaxy "NGC 3466:UGC 6042:MCG 2-28-28:ZWG 66.65"
{
        Type  "SBb"
        RA           10.9375
        Dec           9.7542
        Distance   1.768e+08  # distance uncertain!
        Radius     2.571e+04
        AbsMag        -19.07
        Axis    [  0.9575  -0.0139  -0.2881]
        Angle     61.3770
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3466"
}

Galaxy "NGC 3467:UGC 6045:MCG 2-28-30:ZWG 66.67"
{
        Type  "S0"
        RA           10.9456
        Dec           9.7589
        Distance   4.449e+08  # method: V
        Radius     5.177e+04
        AbsMag        -21.27
        Axis    [  0.7401  -0.5935  -0.3163]
        Angle    119.9753
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3467"
}

Galaxy "NGC 3468:UGC 6048:MCG 7-23-6:ZWG 213.10"
{
        Type  "S0"
        RA           10.9586
        Dec          40.9464
        Distance   1.341e+08  # distance uncertain!
        Radius     2.536e+04
        AbsMag        -19.07
        Axis    [  0.9092  -0.3050   0.2834]
        Angle     95.8983
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3468"
}

Galaxy "NGC 3469:MCG 2-28-24:NPM 1"
{
        Type  "SBb"
        RA           10.9492
        Dec         -14.3003
        Distance   2.266e+08  # method: V
        Radius     5.602e+04
        AbsMag        -20.31
        Axis    [  0.0574   0.1339  -0.9893]
        Angle     60.6633
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3469"
}

Galaxy "NGC 3470:UGC 6060:MCG 10-16-38:ZWG 291.16"
{
        Type  "Sb"
        RA           10.9789
        Dec          59.5106
        Distance    3.08e+08  # method: V
        Radius     6.721e+04
        AbsMag        -20.78
        Axis    [ -0.3517   0.9218  -0.1633]
        Angle     82.9141
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3470"
}

Galaxy "NGC 3471:UGC 6064:MCG 10-16-39:MK 158"
{
        Type  "Sa"
        RA           10.9856
        Dec          61.5303
        Distance   1.026e+08  # method: V
        Radius     2.537e+04
        AbsMag        -19.29
        Axis    [  0.7875  -0.3312   0.5198]
        Angle     92.7159
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3471"
}

Galaxy "NGC 3473:UGC 6052:MCG 3-28-41:ZWG 95.79"
{
        Type  "SBb"
        RA           10.9681
        Dec          17.1250
        Distance   4.279e+08  # method: V
        Radius     6.845e+04
        AbsMag        -20.99
        Axis    [  0.8490  -0.3324  -0.4108]
        Angle     78.6458
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3473"
}

Galaxy "NGC 3474:MCG 3-28-42:ZWG 95.81:NPM 1"
{
        Type  "S0"
        RA           10.9689
        Dec          17.0961
        Distance   4.279e+08  # method: V
        Radius     4.978e+04
        AbsMag        -20.79
        Axis    [ -0.2068   0.5414  -0.8149]
        Angle     62.1988
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3474"
}

Galaxy "NGC 3475:UGC 6058:MCG 4-26-22:ZWG 125.17"
{
        Type  "Sa"
        RA           10.9736
        Dec          24.2269
        Distance   3.053e+08  # method: V
        Radius     7.548e+04
        AbsMag        -20.56
        Axis    [  0.9815   0.0181  -0.1907]
        Angle     47.2391
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3475"
}

Galaxy "NGC 3476:NGC 3480:MCG 2-28-32:ZWG 66.73"
{
        Type  "E0"
        RA           10.9686
        Dec           9.2761
        Distance   3.468e+08  # distance uncertain!
        Radius     4.035e+04
        AbsMag        -20.13
        Axis    [  0.1142   0.1975  -0.9736]
        Angle     89.7517
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3476"
}

Galaxy "NGC 3477:ZWG 66.74"
{
        Type  "Sa"
        RA           10.9700
        Dec           9.2178
        Distance   2.934e+08  # distance uncertain!
        Radius     2.987e+04
        AbsMag        -19.07
        Axis    [  0.9509   0.2055  -0.2313]
        Angle     44.2216
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3477"
}

Galaxy "NGC 3478:UGC 6069:MCG 8-20-59:ZWG 241.51"
{
        Type  "SBc"
        RA           10.9908
        Dec          46.1231
        Distance    3.12e+08  # method: V
        Radius      1.18e+05
        AbsMag         -21.4
        Axis    [ -0.3548   0.9075   0.2249]
        Angle     44.5570
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3478"
}

Galaxy "NGC 3479:NGC 3502:MCG 2-28-27:IRAS 10563-1441"
{
        Type  "SBc"
        RA           10.9819
        Dec         -14.9611
        Distance   2.219e+08  # method: V
        Radius      5.81e+04
        AbsMag        -20.36
        Axis    [ -0.6748   0.2185  -0.7049]
        Angle     85.4559
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3479"
}

Galaxy "NGC 3481:MCG 1-28-16:IRAS 10569-0716"
{
        Type  "Sb"
        RA           10.9906
        Dec          -7.5442
        Distance   1.768e+08  # distance uncertain!
        Radius     2.314e+04
        AbsMag        -19.07
        Axis    [ -0.2599   0.2556  -0.9312]
        Angle     65.8313
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3481"
}

Galaxy "NGC 3482:ESO 264-56"
{
        Type  "SBa"
        RA           10.9761
        Dec         -46.5842
        Distance   1.423e+08  # method: V
        Radius     3.933e+04
        AbsMag         -19.7
        Axis    [  0.8529  -0.0062  -0.5221]
        Angle    132.8867
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3482"
}

Galaxy "NGC 3483:ESO 438-1:MCG 5-26-16:AM 1056-281"
{
        Type  "Sa"
        RA           10.9833
        Dec         -28.4778
        Distance    1.84e+08  # method: V
        Radius     4.816e+04
        AbsMag        -20.66
        Axis    [  0.1927   0.0102  -0.9812]
        Angle     70.3259
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3483"
}

Galaxy "NGC 3485:UGC 6077:MCG 3-28-44:ZWG 95.85"
{
        Type  "SBb"
        RA           11.0006
        Dec          14.8411
        Distance   8.023e+07  # method: V
        Radius       2.8e+04
        AbsMag        -19.25
        Axis    [  0.2784   0.2325  -0.9319]
        Angle     57.1321
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3485"
}

Galaxy "NGC 3486:UGC 6079:MCG 5-26-32:ZWG 155.41"
{
        Type  "SBc"
        RA           11.0067
        Dec          28.9756
        Distance   4.421e+07  # method: V
        Radius     4.566e+04
        AbsMag        -19.66
        Axis    [  0.9027   0.1689  -0.3957]
        Angle     36.7271
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3486"
}

Galaxy "NGC 3487:UGC 6092:MCG 3-28-47:ZWG 95.89"
{
        Type  "Sc"
        RA           11.0128
        Dec          17.5875
        Distance   1.768e+08  # distance uncertain!
        Radius     2.314e+04
        AbsMag        -19.07
        Axis    [ -0.7241   0.6025  -0.3357]
        Angle     50.4735
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3487"
}

Galaxy "NGC 3488:UGC 6096:MCG 10-16-45:ZWG 291.22"
{
        Type  "SBc"
        RA           11.0231
        Dec          57.6775
        Distance   1.428e+08  # method: V
        Radius     3.739e+04
        AbsMag        -19.61
        Axis    [ -0.4822   0.8729  -0.0749]
        Angle     84.9098
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3488"
}

Galaxy "NGC 3489:UGC 6082:MCG 2-28-39:ZWG 66.84"
{
        Type  "SBa"
        RA           11.0050
        Dec          13.9008
        Distance   3.939e+07  # method: S
        Radius     2.063e+04
        AbsMag        -19.31
        Axis    [  0.9248   0.0678  -0.3744]
        Angle     47.5581
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3489"
}

Galaxy "NGC 3490:MCG 2-28-36:ZWG 66.80:NPM 1"
{
        Type  "E0"
        RA           10.9983
        Dec           9.3622
        Distance   3.468e+08  # distance uncertain!
        Radius     2.522e+04
        AbsMag        -20.13
        Axis    [  0.7168  -0.6122  -0.3338]
        Angle    121.5687
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3490"
}

Galaxy "NGC 3491:UGC 6088:MCG 2-28-41:ZWG 66.89"
{
        Type  "S0"
        RA           11.0097
        Dec          12.1617
        Distance   3.047e+08  # method: V
        Radius     3.989e+04
        AbsMag        -20.55
        Axis    [  0.7286  -0.6115  -0.3086]
        Angle    118.7013
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3491"
}

Galaxy "NGC 3492-1:UGC 6094:MCG 2-28-45:ZWG 66.93"
{
        Type  "E0"
        RA           11.0158
        Dec          10.5064
        Distance   5.082e+08  # method: V
        Radius      8.13e+04
        AbsMag        -21.76
        Axis    [  0.2612   0.0463  -0.9642]
        Angle     86.2367
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3492-1"
}

Galaxy "NGC 3492-2:UGC 6094:MCG 2-28-45:ZWG 66.93"
{
        Type  "E0"
        RA           11.0156
        Dec          10.5044
        Distance   5.496e+08  # distance uncertain!
        Radius     3.997e+04
        AbsMag        -20.13
        Axis    [  0.7124  -0.6195  -0.3298]
        Angle    120.8643
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3492-2"
}

Galaxy "NGC 3493:UGC 6099:MCG 5-26-36:ZWG 155.44"
{
        Type  "SBc"
        RA           11.0242
        Dec          27.7200
        Distance   4.196e+08  # method: V
        Radius     6.713e+04
        AbsMag        -20.25
        Axis    [  0.7354   0.4664   0.4917]
        Angle     35.7268
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3493"
}

Galaxy "NGC 3495:UGC 6098:MCG 1-28-27:ZWG 38.88"
{
        Type  "Sc"
        RA           11.0208
        Dec           3.6269
        Distance   6.682e+07  # method: T-F
        Radius     4.762e+04
        AbsMag        -18.86
        Axis    [  0.9894   0.1183   0.0845]
        Angle     93.6267
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3495"
}

Galaxy "NGC 3497:NGC 3525:NGC 3528:IC 2624"
{
        Type  "S0"
        RA           11.1217
        Dec         -19.4714
        Distance   1.838e+08  # method: V
        Radius      6.95e+04
        AbsMag        -21.15
        Axis    [  0.7838  -0.0047  -0.6210]
        Angle     75.7721
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3497"
}

Galaxy "NGC 3499:UGC 6115:MCG 9-18-80:ZWG 267.37"
{
        Type  "Sa"
        RA           11.0528
        Dec          56.2222
        Distance   7.823e+07  # method: V
        Radius     1.024e+04
        AbsMag         -17.5
        Axis    [  0.7835  -0.5580   0.2733]
        Angle     90.9613
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3499"
}

Galaxy "NGC 3500:UGC 6090:MCG 13-8-52:ZWG 351.52"
{
        Type  "Sb"
        RA           11.0308
        Dec          75.2011
        Distance   2.125e+08  # distance uncertain!
        Radius     4.019e+04
        AbsMag        -19.07
        Axis    [  0.5715  -0.0514   0.8190]
        Angle     68.8347
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3500"
}

Galaxy "NGC 3501:UGC 6116:MCG 3-28-51:ZWG 95.97"
{
        Type  "Sc"
        RA           11.0464
        Dec          17.9897
        Distance   8.775e+07  # method: T-F
        Radius     4.977e+04
        AbsMag        -18.45
        Axis    [  0.9575   0.0921   0.2734]
        Angle     86.6453
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3501"
}

Galaxy "NGC 3504:UGC 6118:MCG 5-26-39:ZWG 155.49"
{
        Type  "SBb"
        RA           11.0531
        Dec          27.9731
        Distance   8.322e+07  # method: V
        Radius     3.268e+04
        AbsMag        -20.33
        Axis    [ -0.4810   0.7174  -0.5040]
        Angle     66.7787
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3504"
}

Galaxy "NGC 3506:UGC 6120:MCG 2-28-47:ZWG 66.105"
{
        Type  "Sc"
        RA           11.0533
        Dec          11.0769
        Distance   3.055e+08  # method: V
        Radius     4.888e+04
        AbsMag        -21.56
        Axis    [  0.8113  -0.2990  -0.5024]
        Angle     79.9045
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3506"
}

Galaxy "NGC 3507:UGC 6123:MCG 3-28-53:ZWG 95.100"
{
        Type  "SBb"
        RA           11.0569
        Dec          18.1347
        Distance   5.921e+07  # method: V
        Radius     2.928e+04
        AbsMag        -18.59
        Axis    [  0.2185   0.3672  -0.9041]
        Angle     47.2157
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3507"
}

Galaxy "NGC 3508:NGC 3505:IC 2622:MCG 3-28-31"
{
        Type  "Sb"
        RA           11.0497
        Dec         -16.2886
        Distance   1.922e+08  # method: V
        Radius     3.074e+04
        AbsMag        -19.85
        Axis    [  0.8945  -0.2020  -0.3988]
        Angle    115.2625
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3508"
}

Galaxy "NGC 3509:UGC 6134:MCG 1-28-33:ZWG 38.109"
{
        Type  "SBc"
        RA           11.0733
        Dec           4.8283
        Distance   3.648e+08  # method: V
        Radius     1.114e+05
        AbsMag        -21.44
        Axis    [  0.9879  -0.0205  -0.1538]
        Angle     74.5926
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3509"
}

Galaxy "NGC 3510:UGC 6126:MCG 5-26-40:ZWG 155.50"
{
        Type  "Irr"
        RA           11.0619
        Dec          28.8847
        Distance    6.36e+07  # method: T-F
        Radius     3.793e+04
        AbsMag        -18.25
        Axis    [ -0.8432   0.5163   0.1498]
        Angle     61.4104
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3510"
}

Galaxy "NGC 3511:ESO 502-13:MCG 4-26-20:UGCA 223"
{
        Type  "SBc"
        RA           11.0564
        Dec         -23.0864
        Distance   5.269e+07  # method: T-F
        Radius     4.598e+04
        AbsMag        -19.54
        Axis    [  0.7296   0.1313  -0.6712]
        Angle     56.5466
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3511"
}

Galaxy "NGC 3512:UGC 6128:MCG 5-26-41:ZWG 155.51"
{
        Type  "SBc"
        RA           11.0672
        Dec          28.0375
        Distance   7.583e+07  # method: V
        Radius     1.765e+04
        AbsMag        -18.83
        Axis    [ -0.0588   0.5893  -0.8058]
        Angle     59.5988
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3512"
}

Galaxy "NGC 3513:ESO 502-14:MCG 4-26-21:UGCA 224"
{
        Type  "SBb"
        RA           11.0625
        Dec         -23.2442
        Distance   6.963e+07  # method: V
        Radius     2.937e+04
        AbsMag        -19.75
        Axis    [  0.5157  -0.0820  -0.8528]
        Angle     86.8566
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3513"
}

Galaxy "NGC 3514:ESO 570-1:MCG 3-28-35:IRAS 11015-1830"
{
        Type  "SBc"
        RA           11.0664
        Dec         -18.7806
        Distance   1.065e+08  # distance uncertain!
        Radius     1.704e+04
        AbsMag        -19.07
        Axis    [  0.0408   0.0602  -0.9974]
        Angle     73.9630
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3514"
}

Galaxy "NGC 3515:UGC 6139:MCG 5-26-44:ZWG 155.55"
{
        Type  "Sc"
        RA           11.0769
        Dec          28.2281
        Distance    4.12e+08  # method: V
        Radius     5.393e+04
        AbsMag        -20.81
        Axis    [  0.9512  -0.1997  -0.2353]
        Angle     55.6579
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3515"
}

Galaxy "NGC 3516:UGC 6153:MCG 12-11-9:ZWG 334.11"
{
        Type  "S0"
        RA           11.1131
        Dec          72.5692
        Distance   1.221e+08  # method: V
        Radius     3.375e+04
        AbsMag        -20.37
        Axis    [  0.7110  -0.4604   0.5316]
        Angle     70.8691
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3516"
}

Galaxy "NGC 3517-1:UGC 6144:MCG 10-16-55:ZWG 291.27"
{
        Type  "Sb"
        RA           11.0933
        Dec          56.5253
        Distance   1.223e+08  # distance uncertain!
        Radius     1.779e+04
        AbsMag        -19.07
        Axis    [  0.0943   0.9929  -0.0719]
        Angle     37.7277
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3517-1"
}

Galaxy "NGC 3517-2:MCG 10-16-57:KCPG 266B"
{
        Type  "Sb"
        RA           11.0936
        Dec          56.5344
        Distance   3.829e+08  # method: V
        Radius     2.785e+04
        AbsMag        -18.85
        Axis    [ -0.5868   0.7904   0.1759]
        Angle     75.7861
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3517-2"
}

Galaxy "NGC 3520:ESO 570-4"
{
        Type  "E1"
        RA           11.1189
        Dec         -18.0247
        Distance   2.512e+08  # distance uncertain!
        Radius      4.75e+04
        AbsMag        -20.13
        Axis    [ -0.3701   0.2991  -0.8795]
        Angle    120.3297
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3520"
}

Galaxy "NGC 3521:UGC 6150:MCG 0-28-30:ZWG 10.74"
{
        Type  "SBc"
        RA           11.0967
        Dec          -0.0369
        Distance   4.227e+07  # method: T-F
        Radius     6.885e+04
        AbsMag        -20.56
        Axis    [ -0.7787   0.3219  -0.5386]
        Angle     60.3460
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3521"
}

Galaxy "NGC 3522:UGC 6159:MCG 3-28-60:ZWG 95.113"
{
        Type  "E0"
        RA           11.1111
        Dec          20.0861
        Distance   8.307e+07  # method: S
        Radius      1.45e+04
        AbsMag        -17.93
        Axis    [  0.1396   0.2512  -0.9578]
        Angle     79.8034
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3522"
}

Galaxy "NGC 3523:UGC 6105:MCG 13-8-53:ZWG 351.54"
{
        Type  "Sc"
        RA           11.0517
        Dec          75.1158
        Distance   3.242e+08  # method: V
        Radius     6.129e+04
        AbsMag        -21.39
        Axis    [  0.4116  -0.9061   0.0977]
        Angle     83.8470
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3523"
}

Galaxy "NGC 3524:UGC 6158:MCG 2-28-50:ZWG 66.112"
{
        Type  "Sa"
        RA           11.1089
        Dec          11.3850
        Distance   7.538e+07  # method: V
        Radius     1.754e+04
        AbsMag        -18.32
        Axis    [  0.9948  -0.0170   0.1007]
        Angle     97.6597
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3524"
}

Galaxy "NGC 3526:NGC 3531:UGC 6167:MCG 1-28-39"
{
        Type  "Sc"
        RA           11.1156
        Dec           7.1733
        Distance   8.009e+07  # method: V
        Radius     2.213e+04
        AbsMag        -18.15
        Axis    [  0.9678   0.2122   0.1356]
        Angle     59.2543
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3526"
}

Galaxy "NGC 3527:UGC 6170:MCG 5-26-59:ZWG 155.66"
{
        Type  "SBa"
        RA           11.1217
        Dec          28.5278
        Distance   4.707e+08  # method: V
        Radius     6.846e+04
        AbsMag         -20.9
        Axis    [ -0.3623   0.7034  -0.6115]
        Angle     73.3659
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3527"
}

Galaxy "NGC 3529:IC 2625:ESO 570-7:MCG 3-28-38"
{
        Type  "SBb"
        RA           11.1219
        Dec         -19.5561
        Distance   1.281e+08  # distance uncertain!
        Radius     1.863e+04
        AbsMag        -19.07
        Axis    [  0.7083  -0.1244  -0.6948]
        Angle     90.6790
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3529"
}

Galaxy "NGC 3530:UGC 6188:MCG 10-16-64:ZWG 291.30"
{
        Type  "S0"
        RA           11.1444
        Dec          57.2303
        Distance   9.518e+07  # method: V
        Radius          9690
        AbsMag        -17.73
        Axis    [  0.2629   0.5946   0.7598]
        Angle     42.2044
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3530"
}

Galaxy "NGC 3533:NGC 3557A:ESO 377-11:MCG 6-25-2"
{
        Type  "Sb"
        RA           11.1186
        Dec         -37.1731
        Distance     1.3e+08  # method: T-F
        Radius     5.293e+04
        AbsMag         -19.2
        Axis    [  0.7749   0.1985  -0.6001]
        Angle     65.8446
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3533"
}

Galaxy "NGC 3534A:UGC 6190:MCG 5-26-62:ZWG 155.72"
{
        Type  "Sb"
        RA           11.1486
        Dec          26.6103
        Distance   3.116e+08  # method: V
        Radius     5.892e+04
        AbsMag         -19.6
        Axis    [  0.5778   0.5453   0.6073]
        Angle     32.1044
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3534A"
}

Galaxy "NGC 3534B:UGC 6193:MCG 5-26-63:ZWG 155.74"
{
        Type  "Sb"
        RA           11.1492
        Dec          26.5967
        Distance   2.676e+08  # distance uncertain!
        Radius     3.503e+04
        AbsMag        -19.07
        Axis    [ -0.7800   0.6005  -0.1758]
        Angle     66.5668
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3534B"
}

Galaxy "NGC 3535:UGC 6189:MCG 1-29-4:ZWG 39.10"
{
        Type  "Sa"
        RA           11.1425
        Dec           4.8325
        Distance   3.314e+08  # method: V
        Radius     8.193e+04
        AbsMag        -20.63
        Axis    [ -0.8538   0.3405  -0.3939]
        Angle     72.4324
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3535"
}

Galaxy "NGC 3536:UGC 6191:MCG 5-26-61:ZWG 155.73"
{
        Type  "SBa"
        RA           11.1475
        Dec          28.4761
        Distance   5.084e+08  # method: V
        Radius     8.133e+04
        AbsMag        -20.96
        Axis    [ -0.5056   0.7294  -0.4607]
        Angle     59.9049
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3536"
}

Galaxy "NGC 3537-1"
{
        Type  "Sb"
        RA           11.1406
        Dec         -10.2567
        Distance   1.115e+08  # distance uncertain!
        Radius     2.271e+04
        AbsMag        -19.07
        Axis    [  0.6644  -0.2257  -0.7125]
        Angle     94.1512
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3537-1"
}

Galaxy "NGC 3537-2"
{
        Type  "S0"
        RA           11.1408
        Dec         -10.2589
        Distance   1.688e+08  # distance uncertain!
        Radius     2.455e+04
        AbsMag        -19.07
        Axis    [ -0.9134   0.0690  -0.4011]
        Angle     65.8520
        InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3537-2"
}

Galaxy "NGC 3539:MCG 5-26-65:ZWG 155.77:DRCG 23-38"
{
        Type  "S0"
        RA           11.1522
        Dec          28.6725
        Distance   4.544e+08  # method: V
        Radius      7.27e+04
        AbsMag        -20.12
        Axis    [  0.9468  -0.0543   0.317