;
; Celestia Windows exe Build script, generated by the Inno Setup Script Wizard.

; This script was tested with Inno Setup Compiler version 5.1.5

[Setup]
AppName=Celestia
AppVerName=Celestia 1.5.0
AppPublisher=Shatters Software
AppPublisherURL=http://www.shatters.net/celestia/
AppSupportURL=http://www.shatters.net/celestia/
AppUpdatesURL=http://www.shatters.net/celestia/
DefaultDirName={pf}\Celestia
DefaultGroupName=Celestia
LicenseFile=C:\celestia\celestia\COPYING
Compression=lzma/max
UninstallDisplayIcon={app}\celestia.exe

; Tell Explorer to refresh its file associations information at the
; end of the installation, and Uninstall will do the same at the end
; of uninstallation.
ChangesAssociations=yes

; uncomment the following line if you want your installation to run on NT 3.51 too.
; MinVersion=4,3.51

[Tasks]
Name: "desktopicon"; Description: "Create a &desktop icon";            GroupDescription: "Additional icons:"; MinVersion: 4,4
Name: "urlassoc";    Description: "Associate cel:// &URLs";            GroupDescription: "Other tasks:"
Name: "fileassoc";   Description: "Associate .cel and .celx &scripts"; GroupDescription: "Other tasks:"

[Dirs]
Name: "{app}\extras"
Name: "{app}\textures"
Name: "{app}\textures\hires"
Name: "{app}\textures\medres"
Name: "{app}\textures\lores"
Name: "{app}\tools\binaries"
Name: "{app}\tools\galaxies"
Name: "{app}\scripts"

[Files]
Source: "celestia.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "start.cel";    DestDir: "{app}"; Flags: ignoreversion
Source: "celestia.cfg"; DestDir: "{app}"; Flags: ignoreversion
Source: "demo.cel";     DestDir: "{app}"; Flags: ignoreversion
Source: "guide.cel";    DestDir: "{app}"; Flags: ignoreversion
Source: "libpng1.dll";  DestDir: "{app}"; Flags: ignoreversion
Source: "zlib.dll";     DestDir: "{app}"; Flags: ignoreversion
Source: "intl.dll";     DestDir: "{app}"; Flags: ignoreversion
Source: "iconv.dll";    DestDir: "{app}"; Flags: ignoreversion
Source: "lua5.1.dll";   DestDir: "{app}"; Flags: ignoreversion
Source: "controls.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "COPYING";      DestDir: "{app}"; Flags: ignoreversion
Source: "README";       DestDir: "{app}"; Flags: ignoreversion isreadme;   DestName: "README.txt"
Source: "AUTHORS";      DestDir: "{app}"; Flags: ignoreversion;            DestName: "AUTHORS.txt"
Source: "TRANSLATORS";  DestDir: "{app}"; Flags: ignoreversion;            DestName: "TRANSLATORS.txt"
Source: "ChangeLog";    DestDir: "{app}"; Flags: ignoreversion;            DestName: "ChangeLog.txt"
Source: "KbdMouseJoyControls.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "splash.png";   DestDir: "{app}"; Flags: ignoreversion


; Languages
Source: "locale\res_ar.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_de.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_el.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_es.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_fr.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
;Source: "locale\res_gl.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_hu.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_it.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_ja.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_ko.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_lv.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_nl.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_pt.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_pt_br.dll";    DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_ru.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_sv.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_uk.dll";       DestDir: "{app}/locale"; Flags: ignoreversion
Source: "locale\res_zh_CN.dll";    DestDir: "{app}/locale"; Flags: ignoreversion

Source: "locale\ar\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/ar/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ar\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/ar/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\bg\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/bg/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\bg\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/bg/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\de\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/de/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\de\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/de/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\el\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/el/LC_MESSAGES"; Flags: ignoreversion
; no translation available yet -- Source: "locale\el\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/el/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\es\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/es/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\es\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/es/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\fr\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/fr/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\fr\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/fr/LC_MESSAGES"; Flags: ignoreversion
;Source: "locale\gl\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/gl/LC_MESSAGES"; Flags: ignoreversion
; no translation available yet -- Source: "locale\gl\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/gl/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\hu\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/hu/LC_MESSAGES"; Flags: ignoreversion
; no translation available yet -- Source: "locale\hu\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/hu/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\it\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/it/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\it\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/it/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ja\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/ja/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ja\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/ja/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ko\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/ko/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ko\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/ko/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\lv\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/lv/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\lv\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/lv/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\nl\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/nl/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\nl\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/nl/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\pt\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/pt/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\pt\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/pt/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\pt_br\LC_MESSAGES\celestia.mo";                   DestDir: "{app}/locale/pt_br/LC_MESSAGES"; Flags: ignoreversion
; no translation available yet -- Source: "locale\pt_br\LC_MESSAGES\celestia_constellations.mo";    DestDir: "{app}/locale/pt_br/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ru\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/ru/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\ru\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/ru/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\sv\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/sv/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\sv\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/sv/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\uk\LC_MESSAGES\celestia.mo";                      DestDir: "{app}/locale/uk/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\uk\LC_MESSAGES\celestia_constellations.mo";       DestDir: "{app}/locale/uk/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\zh_CN\LC_MESSAGES\celestia.mo";                   DestDir: "{app}/locale/zh_CN/LC_MESSAGES"; Flags: ignoreversion
Source: "locale\zh_CN\LC_MESSAGES\celestia_constellations.mo";    DestDir: "{app}/locale/zh_CN/LC_MESSAGES"; Flags: ignoreversion


; Data
Source: "data\asterisms.dat";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\boundaries.dat";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\starnames.dat";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\stars.dat";          DestDir: "{app}/data"; Flags: ignoreversion

Source: "data\hdxindex.dat";       DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\saoxindex.dat";      DestDir: "{app}/data"; Flags: ignoreversion

Source: "data\revised.stc";        DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\extrasolar.stc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\nearstars.stc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\visualbins.stc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\spectbins.stc";      DestDir: "{app}/data"; Flags: ignoreversion

Source: "data\deepsky.dsc";        DestDir: "{app}/data"; Flags: ignoreversion

Source: "data\asteroids.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\comets.ssc";         DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\extrasolar.ssc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\outersys.ssc";       DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\solarsys.ssc";       DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\spacecraft.ssc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\merc_locs.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\venus_locs.ssc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\earth_locs.ssc";     DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\mars_locs.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\moon_locs.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\marsmoons_locs.ssc"; DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\jupitermoons_locs.ssc"; DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\saturnmoons_locs.ssc";  DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\uranusmoons_locs.ssc";  DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\neptunemoons_locs.ssc"; DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\ring_locs.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\eros_locs.ssc";      DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\gaspra_locs.ssc";    DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\ida_locs.ssc";       DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\world-capitals.ssc"; DestDir: "{app}/data"; Flags: ignoreversion

Source: "data\cassini.xyz";        DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\galileo.xyz";        DestDir: "{app}/data"; Flags: ignoreversion
Source: "data\huygens.xyz";        DestDir: "{app}/data"; Flags: ignoreversion

; Textures (General)
Source: "textures\flare.jpg";      DestDir: "{app}/textures"; Flags: ignoreversion
Source: "textures\logo.png";       DestDir: "{app}/textures"; Flags: ignoreversion


; Textures (Low resolution)
Source: "textures\lores\astar.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\bstar.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\gstar.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mstar.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion

Source: "textures\lores\amalthea.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\ariel.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\ariel-lok-mask.png";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\asteroid.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\browndwarf.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\callisto.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\callisto-lok-mask.png"; DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\charon-lok.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\charon-lok-spec.jpg";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\deimos.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\dione.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\earth.png";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\earth-clouds.png";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\earthnight.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\enceladus.jpg";         DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\epimetheus.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\epimetheus-lok.jpg";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\eros.jpg";              DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\europa.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\europa-lok-mask.png";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class1.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class2.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class3.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class4.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class4night.jpg";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class5.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\exo-class5night.jpg";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\extrasolar-lok.jpg";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\ganymede.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\ganymede-lok-mask.png"; DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\gaspramosaic.jpg";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\hyperion.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\hyperion-lok.jpg";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\iapetus.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\idamosaic.jpg";         DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\io.jpg";                DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\io-lok-mask.png";       DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\janus.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\jupiter.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mars.jpg";              DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\marsbump.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mercury.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mercury-lok-mask.png";  DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mimas.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\mimas-lok-mask.png";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\miranda.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\miranda-lok-mask.png";  DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\moon.jpg";              DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\moonbump.jpg";          DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\neptune.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\neptune-rings.png";     DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\oberon.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\oberon-lok-mask.png";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\phobos.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\phoebe.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\pluto-lok.jpg";         DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\pluto-lok-spec.jpg";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\proteus.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\prometheus.jpg";        DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\rhea.jpg";              DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\saturn.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\saturn-rings.png";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\tethys.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\titania.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\titania-lok-mask.png";  DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\titan.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\titan-clouds.jpg";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\triton.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\triton-lok-mask.png";   DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\umbriel.jpg";           DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\umbriel-lok-mask.png";  DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\uranus.jpg";            DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\uranus-rings.png";      DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\venus.jpg";             DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\venuslike.jpg";         DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\venuslikenight.jpg";    DestDir: "{app}/textures/lores"; Flags: ignoreversion
Source: "textures\lores\venussurface.jpg";      DestDir: "{app}/textures/lores"; Flags: ignoreversion


; Textures (Medium resolution)
Source: "textures\medres\astar.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\bstar.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\gstar.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\mstar.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion

Source: "textures\medres\amalthea.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\ariel.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\asteroid.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\browndwarf.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\callisto.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\charon-lok.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\charon-lok-spec.jpg"; DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\deimos.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\dione.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\earth.png";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\earth-clouds.png";    DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\earthnight.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\enceladus.jpg";       DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\epimetheus.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\epimetheus-lok.jpg";  DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\eros.jpg";            DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\europa.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class1.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class2.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class3.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class4.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class4night.jpg"; DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class5.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\exo-class5night.jpg"; DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\ganymede.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\gaspramosaic.jpg";    DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\hyperion.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\hyperion-lok.jpg";    DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\iapetus.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\idamosaic.jpg";       DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\io.jpg";              DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\iss-cap1.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\iss-mc1.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\iss-mc31.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\iss-sol1.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\janus.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\jupiter.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\mars.jpg";            DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\marsbump.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\mercury.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\mimas.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\miranda.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\moon.jpg";            DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\moonbump.jpg";        DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\neptune.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\oberon.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\phobos.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\phoebe.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\pluto-lok.jpg";       DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\pluto-lok-spec.jpg";  DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\prometheus.jpg";      DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\proteus.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\rhea.jpg";            DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\saturn.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\tethys.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\titan.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\titan-clouds.jpg";    DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\titania.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\triton.jpg";          DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\umbriel.jpg";         DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\venus.jpg";           DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\venuslike.jpg";       DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\venuslikenight.jpg";  DestDir: "{app}/textures/medres"; Flags: ignoreversion
Source: "textures\medres\venussurface.jpg";    DestDir: "{app}/textures/medres"; Flags: ignoreversion

; Textures (High resolution)
Source: "textures\hires\iapetus.jpg";          DestDir: "{app}/textures/hires"; Flags: ignoreversion
Source: "textures\hires\moon.jpg";             DestDir: "{app}/textures/hires"; Flags: ignoreversion
Source: "textures\hires\moonbump.jpg";         DestDir: "{app}/textures/hires"; Flags: ignoreversion
Source: "textures\hires\phoebe.jpg";           DestDir: "{app}/textures/hires"; Flags: ignoreversion
Source: "textures\hires\tethys.jpg";           DestDir: "{app}/textures/hires"; Flags: ignoreversion
Source: "textures\hires\titan.jpg";            DestDir: "{app}/textures/hires"; Flags: ignoreversion


; Shaders (NV)
Source: "shaders\bumpdiffuse.vp";    DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\bumphaze.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse.vp";        DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse_texoff.vp"; DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\haze.vp";           DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\night.vp";          DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\rings.vp";          DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\ringshadow.vp";     DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\shadowtex.vp";      DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\simple.vp";         DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\specular.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion


; Shaders (ARB)
Source: "shaders\bumpdiffuse_arb.vp";    DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\bumphaze_arb.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse_arb.vp";        DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse_texoff_arb.vp"; DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\glossmap_arb.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\haze_arb.vp";           DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\multishadow_arb.vp";    DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\night_arb.vp";          DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\rings_arb.vp";          DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\ringshadow_arb.vp";     DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\shadowtex_arb.vp";      DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\simple_arb.vp";         DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\specular_arb.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\texphong_arb.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\texphong_alpha_arb.vp"; DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse2_arb.vp";       DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse_texoff2_arb.vp"; DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\haze2_arb.vp";          DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\night2_arb.vp";         DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\specular2_arb.vp";      DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\ell_galaxy_arb.vp";     DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\star_arb.vp";           DestDir: "{app}/shaders"; Flags: ignoreversion


; Shaders (NV pixel)
Source: "shaders\bumpdiffuse_nv.fp";     DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\diffuse_nv.fp";         DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\eclipse1_nv.fp";        DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\eclipse2_nv.fp";        DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\shadow_on_rings_nv.fp"; DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\texphong_nv.fp";        DestDir: "{app}/shaders"; Flags: ignoreversion
Source: "shaders\texphong_alpha_nv.fp";  DestDir: "{app}/shaders"; Flags: ignoreversion


; Models
Source: "models\E0.png";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\S0.png";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\Sa.png";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\Sb.png";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\Sc.png";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\SBa.png";         DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\SBb.png";         DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\SBc.png";         DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\MilkyWay.png";    DestDir: "{app}/models"; Flags: ignoreversion

Source: "models\amalthea.cmod";    DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\asteroid.cms";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\bacchus.cmod";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\borrelly.cms";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\cassini.3ds";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\castalia.cmod";    DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\deimos.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\epimetheus.cmod";  DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\eros.cmod";        DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\galileo.3ds";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\gaspra.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\geographos.cmod";  DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\golevka.cmod";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\halley.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\hubble.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\huygens.3ds";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\hyperion.cmod";    DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\ida.cmod";         DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\iss.3ds";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\janus.cmod";       DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\kleopatra.cmod";   DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\ky26.cmod";        DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\larissa.cmod";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\mir.3ds";          DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\pandora.cmod";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\phobos.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\phoebe.cmod";      DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\prometheus.cmod";  DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\proteus.cmod";     DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\roughsphere.cms";  DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\toutatis.cmod";    DestDir: "{app}/models"; Flags: ignoreversion
Source: "models\vesta.cmod";       DestDir: "{app}/models"; Flags: ignoreversion


; Fonts
Source: "fonts\clean12.txf";     DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\clean16.txf";     DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\cleanbold12.txf"; DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\cleanbold16.txf"; DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\default.txf";     DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sans10.txf";      DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sans12.txf";      DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sans14.txf";      DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sans20.txf";      DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sansbold10.txf";  DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sansbold12.txf";  DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sansbold14.txf";  DestDir: "{app}/fonts"; Flags: ignoreversion
Source: "fonts\sansbold20.txf";  DestDir: "{app}/fonts"; Flags: ignoreversion

; Standard extras
Source: "extras\minormoons.ssc"; DestDir: "{app}/extras"; Flags: ignoreversion

; celx scripts
Source: "scripts\mark-lg.celx";      DestDir: "{app}/scripts"; Flags: ignoreversion
Source: "scripts\z-dist.celx";       DestDir: "{app}/scripts"; Flags: ignoreversion


; Data extraction scripts (PERL)
Source: "src\tools\binaries\spectbins.pl";   DestDir: "{app}/tools/binaries"; Flags: ignoreversion
Source: "src\tools\binaries\visualbins.pl";  DestDir: "{app}/tools/binaries"; Flags: ignoreversion
Source: "src\tools\galaxies\deepsky.pl";     DestDir: "{app}/tools/galaxies"; Flags: ignoreversion


[INI]
Filename: "{app}\celestia.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://www.shatters.net/celestia/"

[Icons]
Name: "{group}\Celestia";            Filename: "{app}\celestia.exe"; WorkingDir: "{app}"
Name: "{group}\README";              Filename: "{app}\README.txt"
Name: "{group}\Celestia on the Web"; Filename: "{app}\celestia.url"
Name: "{userdesktop}\Celestia";      Filename: "{app}\celestia.exe"; WorkingDir: "{app}"; MinVersion: 4,4; Tasks: desktopicon

[Registry]
; The Software\Shatters.net key is created by the Celestia program, so it needs
; to be deleted during an uninstall.
Root: HKCU; Subkey: "Software\Shatters.net"; Flags: uninsdeletekey

Root: HKCR; Subkey: "cel"; Flags: uninsdeletekeyifempty
Root: HKCR; Subkey: "cel"; ValueType: string; ValueData: "URL:cel Protocol"; Tasks: urlassoc; Flags: uninsdeletevalue
Root: HKCR; Subkey: "cel"; ValueName: "URL Protocol"; ValueType: string; Tasks: urlassoc; Flags: uninsdeletevalue

Root: HKCR; Subkey: "cel\Shell"; ValueType: string; Tasks: urlassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: "cel\Shell\open"; ValueType: string; Tasks: urlassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: "cel\Shell\open\Command"; ValueType: string; ValueData: """{app}\celestia.exe"" --once --dir ""{app}"" -u ""%1"""; Tasks: urlassoc; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKCR; Subkey: ".cel";  ValueType: string; ValueData: "celestia_script"; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: ".clx";  ValueType: string; ValueData: "celestia_script"; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: ".celx"; ValueType: string; ValueData: "celestia_script"; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKCR; Subkey: "celestia_script"; ValueName: "URL Protocol"; ValueType: string; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: "celestia_script\Shell"; ValueType: string; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: "celestia_script\Shell\open"; ValueType: string; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; Subkey: "celestia_script\Shell\open\Command"; ValueType: string; ValueData: """{app}\celestia.exe"" --once --dir ""{app}"" -u ""%1"""; Tasks: fileassoc; Flags: uninsdeletevalue uninsdeletekeyifempty


[Run]
Filename: "{app}\celestia.exe"; Description: "Launch Celestia"; Flags: nowait postinstall skipifsilent

[UninstallDelete]
Type: files; Name: "{app}\celestia.url"

