C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RA4 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4A4
C       PARAMETER (ISET=7)                                           
        DATA  DrI, FlI, AlI /             2.,   5.,  .2390 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .202755D+01, .264626D+01, .357027D+01, .500000D+01,
     +  .787375D+01, .132692D+02, .241745D+02, .481697D+02, .106391D+03,
     +  .264502D+03, .753388D+03, .250898D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .264612D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .121644D+06,
     +  .923935D+05, .690159D+05, .515107D+05, .384222D+05,
     +  .286324D+05, .213227D+05, .158632D+05, .117929D+05,
     +  .875748D+04, .649818D+04, .481613D+04, .356636D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .263758D+04, .194882D+04, .143796D+04, .105991D+04,
     +  .780106D+03, .573511D+03, .420959D+03, .308609D+03,
     +  .225861D+03, .165079D+03, .120437D+03, .877384D+02,
     +  .638043D+02, .463467D+02, .334448D+02, .242131D+02,
     +  .174961D+02, .126290D+02, .910075D+01, .655275D+01,
     +  .471718D+01, .339315D+01, .244000D+01, .175663D+01,
     +  .126546D+01, .913780D+00, .660994D+00, .480094D+00,
     +  .349737D+00, .255936D+00, .188016D+00, .138870D+00,
     +  .102987D+00, .768847D-01, .574927D-01, .433115D-01,
     +  .326610D-01, .247584D-01, .188035D-01, .143259D-01,
     +  .109241D-01, .834589D-02, .637126D-02, .486413D-02,
     +  .370544D-02, .282003D-02, .213766D-02, .161600D-02,
     +  .121472D-02, .908519D-03, .675499D-03, .497461D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .362117D-03, .260548D-03, .184437D-03, .128264D-03,
     +  .869236D-04, .571265D-04, .357882D-04, .209112D-04,
     +  .107394D-04, .416211D-05, .668901D-08, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .272762D+06, .206672D+06,
     +  .153940D+06, .114566D+06, .852057D+05, .633087D+05,
     +  .470049D+05, .348638D+05, .258383D+05, .191280D+05,
     +  .141482D+05, .104524D+05, .771472D+04, .568677D+04,
     +  .418759D+04, .307935D+04, .226186D+04, .165889D+04,
     +  .121517D+04, .888692D+03, .649076D+03, .473241D+03,
     +  .344545D+03, .250384D+03, .181670D+03, .131569D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .951659D+02, .683753D+02, .492833D+02, .354524D+02,
     +  .254718D+02, .182695D+02, .130905D+02, .937737D+01,
     +  .671084D+01, .480081D+01, .343770D+01, .246309D+01,
     +  .176861D+01, .127213D+01, .918578D+00, .665225D+00,
     +  .483855D+00, .353288D+00, .259303D+00, .191087D+00,
     +  .141732D+00, .105298D+00, .787938D-01, .590207D-01,
     +  .444335D-01, .335167D-01, .253576D-01, .192025D-01,
     +  .145667D-01, .110427D-01, .837151D-02, .633386D-02,
     +  .478768D-02, .360583D-02, .270909D-02, .202501D-02,
     +  .150717D-02, .111629D-02, .820113D-03, .596913D-03,
     +  .430767D-03, .307245D-03, .216701D-03, .150457D-03,
     +  .102883D-03, .688420D-04, .449564D-04, .284255D-04,
     +  .174085D-04, .100585D-04, .540070D-05, .253893D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .903916D-06, .357757D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .458704D+06, .346684D+06, .257462D+06,
     +  .191036D+06, .141647D+06, .104923D+06, .776602D+05,
     +  .574203D+05, .424194D+05, .313019D+05, .230769D+05,
     +  .169923D+05, .124994D+05, .918240D+04, .673823D+04,
     +  .493761D+04, .361383D+04, .264088D+04, .192737D+04,
     +  .140428D+04, .102174D+04, .742070D+03, .538132D+03,
     +  .389497D+03, .281449D+03, .202977D+03, .146186D+03,
     +  .104570D+03, .750342D+02, .537325D+02, .384250D+02,
     +  .274296D+02, .195577D+02, .139408D+02, .992536D+01,
     +  .706352D+01, .503070D+01, .358490D+01, .255967D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .183072D+01, .131421D+01, .946150D+00, .684030D+00,
     +  .496423D+00, .362088D+00, .265166D+00, .195418D+00,
     +  .144255D+00, .107234D+00, .797958D-01, .596700D-01,
     +  .447097D-01, .335948D-01, .252676D-01, .190345D-01,
     +  .143304D-01, .107883D-01, .810658D-02, .608514D-02,
     +  .455212D-02, .339700D-02, .252287D-02, .186597D-02,
     +  .137395D-02, .100399D-02, .727504D-03, .523259D-03,
     +  .372626D-03, .262985D-03, .183355D-03, .126492D-03,
     +  .860102D-04, .576674D-04, .380527D-04, .248810D-04,
     +  .159678D-04, .101463D-04, .637625D-05, .400347D-05,
     +  .251148D-05, .159976D-05, .102929D-05, .672405D-06,
     +  .437041D-06, .277764D-06, .165468D-06, .881288D-07,
     +  .382058D-07, .106881D-07, .775970D-09, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .685459D+06, .516710D+06, .382546D+06, .282968D+06,
     +  .209151D+06, .154435D+06, .113938D+06, .839702D+05,
     +  .618286D+05, .454726D+05, .334106D+05, .245176D+05,
     +  .179724D+05, .131568D+05, .962035D+04, .702421D+04,
     +  .512218D+04, .372929D+04, .271144D+04, .196802D+04,
     +  .142633D+04, .103184D+04, .745252D+03, .537208D+03,
     +  .386568D+03, .277602D+03, .199062D+03, .141756D+03,
     +  .101257D+03, .721794D+02, .513732D+02, .364974D+02,
     +  .258950D+02, .183661D+02, .130085D+02, .920938D+01,
     +  .652364D+01, .462347D+01, .328273D+01, .233460D+01,
     +  .166619D+01, .119252D+01, .856968D+00, .618182D+00,
     +  .448112D+00, .326128D+00, .238824D+00, .175180D+00,
     +  .129375D+00, .956473D-01, .710502D-01, .528871D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .394726D-01, .294904D-01, .220641D-01, .164991D-01,
     +  .123360D-01, .920705D-02, .686390D-02, .510035D-02,
     +  .378053D-02, .278949D-02, .204993D-02, .150015D-02,
     +  .108979D-02, .785573D-03, .562480D-03, .399222D-03,
     +  .281205D-03, .196113D-03, .135701D-03, .929309D-04,
     +  .630950D-04, .424863D-04, .285996D-04, .191361D-04,
     +  .128495D-04, .866471D-05, .590576D-05, .405528D-05,
     +  .281314D-05, .194683D-05, .133202D-05, .884001D-06,
     +  .557503D-06, .322801D-06, .163869D-06, .666282D-07,
     +  .174167D-07, .131018D-08, .000000D+00, .959397D+06,
     +  .721263D+06, .532289D+06, .392474D+06, .289150D+06,
     +  .212808D+06, .156485D+06, .114941D+06, .843467D+05,
     +  .618222D+05, .452660D+05, .331013D+05, .241786D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .176367D+05, .128492D+05, .934723D+04, .679070D+04,
     +  .492542D+04, .356735D+04, .257921D+04, .186189D+04,
     +  .134153D+04, .964977D+03, .692716D+03, .496367D+03,
     +  .354916D+03, .253383D+03, .179624D+03, .127723D+03,
     +  .906244D+02, .641953D+02, .453875D+02, .320433D+02,
     +  .226131D+02, .159340D+02, .112214D+02, .790609D+01,
     +  .557277D+01, .393463D+01, .278244D+01, .197432D+01,
     +  .140481D+01, .100350D+01, .719551D+00, .518397D+00,
     +  .374959D+00, .272865D+00, .198894D+00, .145947D+00,
     +  .107207D+00, .791186D-01, .585118D-01, .433826D-01,
     +  .321990D-01, .239295D-01, .177753D-01, .132012D-01,
     +  .978765D-02, .724784D-02, .535030D-02, .393967D-02,
     +  .288836D-02, .210916D-02, .153413D-02, .110796D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .794468D-03, .566186D-03, .400369D-03, .281290D-03,
     +  .196025D-03, .135825D-03, .934312D-04, .639661D-04,
     +  .436514D-04, .299279D-04, .205250D-04, .141964D-04,
     +  .989958D-05, .697752D-05, .494268D-05, .350995D-05,
     +  .246620D-05, .169450D-05, .111948D-05, .696394D-06,
     +  .394891D-06, .194758D-06, .762442D-07, .191176D-07,
     +  .146727D-08, .000000D+00, .128716D+07, .965017D+06,
     +  .709859D+06, .521690D+06, .383074D+06, .280993D+06,
     +  .205924D+06, .150740D+06, .110235D+06, .805156D+05,
     +  .587451D+05, .428052D+05, .311538D+05, .226419D+05,
     +  .164346D+05, .119109D+05, .862034D+04, .622854D+04,
     +  .449359D+04, .323610D+04, .232673D+04, .166967D+04,
     +  .119605D+04, .855004D+03, .610047D+03, .434305D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .308689D+03, .217836D+03, .154184D+03, .108893D+03,
     +  .767689D+02, .540156D+02, .379459D+02, .266445D+02,
     +  .186778D+02, .130850D+02, .916956D+01, .642828D+01,
     +  .451341D+01, .317381D+01, .223907D+01, .158395D+01,
     +  .112477D+01, .801713D+00, .574086D+00, .412707D+00,
     +  .298479D+00, .216213D+00, .157653D+00, .115074D+00,
     +  .843795D-01, .620048D-01, .456747D-01, .336815D-01,
     +  .248672D-01, .183519D-01, .135401D-01, .997396D-02,
     +  .733751D-02, .538180D-02, .393744D-02, .286879D-02,
     +  .208199D-02, .150546D-02, .108111D-02, .771263D-03,
     +  .547161D-03, .385529D-03, .270181D-03, .188120D-03,
     +  .130477D-03, .900792D-04, .620909D-04, .428173D-04,
     +  .297620D-04, .207685D-04, .146437D-04, .104159D-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .747157D-05, .536777D-05, .384232D-05, .270618D-05,
     +  .185142D-05, .121160D-05, .742470D-06, .412782D-06,
     +  .198439D-06, .751844D-07, .181935D-07, .142019D-08,
     +  .000000D+00, .167555D+07, .125270D+07, .918424D+06,
     +  .672721D+06, .492310D+06, .359894D+06, .262840D+06,
     +  .191738D+06, .139724D+06, .101694D+06, .739316D+05,
     +  .536766D+05, .389231D+05, .281841D+05, .203808D+05,
     +  .147151D+05, .106090D+05, .763575D+04, .548717D+04,
     +  .393594D+04, .281848D+04, .201428D+04, .143691D+04,
     +  .102286D+04, .726691D+03, .515087D+03, .364480D+03,
     +  .256033D+03, .180389D+03, .126808D+03, .889738D+02,
     +  .623012D+02, .435502D+02, .304267D+02, .212194D+02,
     +  .147881D+02, .103077D+02, .718709D+01, .501829D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .350914D+01, .246151D+01, .173128D+01, .122219D+01,
     +  .866012D+00, .616409D+00, .440458D+00, .316605D+00,
     +  .227936D+00, .165165D+00, .119805D+00, .872952D-01,
     +  .637450D-01, .466580D-01, .341888D-01, .250797D-01,
     +  .183910D-01, .134821D-01, .986844D-02, .721368D-02,
     +  .525798D-02, .382292D-02, .276861D-02, .199737D-02,
     +  .143612D-02, .102576D-02, .728257D-03, .514471D-03,
     +  .361308D-03, .252646D-03, .175803D-03, .122070D-03,
     +  .845695D-04, .586530D-04, .408115D-04, .286865D-04,
     +  .202843D-04, .144972D-04, .104433D-04, .756525D-05,
     +  .546966D-05, .392068D-05, .275352D-05, .186937D-05,
     +  .120939D-05, .729620D-06, .397814D-06, .186625D-06,
     +  .685769D-07, .160633D-07, .127375D-08, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .213136D+07, .158899D+07, .116107D+07, .847587D+06,
     +  .618165D+06, .450346D+06, .327757D+06, .238257D+06,
     +  .173009D+06, .125470D+06, .908872D+05, .657464D+05,
     +  .474995D+05, .342662D+05, .246855D+05, .177552D+05,
     +  .127514D+05, .914198D+04, .654358D+04, .467494D+04,
     +  .333409D+04, .237299D+04, .168575D+04, .119492D+04,
     +  .845288D+03, .596528D+03, .420234D+03, .293850D+03,
     +  .206084D+03, .144199D+03, .100695D+03, .701696D+02,
     +  .488088D+02, .339308D+02, .235421D+02, .163217D+02,
     +  .113162D+02, .784794D+01, .544967D+01, .378966D+01,
     +  .264326D+01, .184850D+01, .129737D+01, .913916D+00,
     +  .646647D+00, .459309D+00, .328167D+00, .234828D+00,
     +  .169115D+00, .121917D+00, .882834D-01, .640690D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .466027D-01, .339361D-01, .247380D-01, .180275D-01,
     +  .131331D-01, .955370D-02, .694039D-02, .502816D-02,
     +  .363384D-02, .261642D-02, .187685D-02, .134222D-02,
     +  .953826D-03, .674153D-03, .474421D-03, .332225D-03,
     +  .231896D-03, .161327D-03, .112180D-03, .779970D-04,
     +  .544130D-04, .381659D-04, .270805D-04, .193484D-04,
     +  .139639D-04, .101419D-04, .738511D-05, .534963D-05,
     +  .382612D-05, .267195D-05, .179687D-05, .114796D-05,
     +  .681569D-06, .364472D-06, .166945D-06, .595695D-07,
     +  .135345D-07, .108948D-08, .000000D+00, .266120D+07,
     +  .197840D+07, .144073D+07, .104816D+07, .761824D+06,
     +  .553086D+06, .401122D+06, .290562D+06, .210237D+06,
     +  .151922D+06, .109648D+06, .790271D+05, .568825D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .408816D+05, .293397D+05, .210221D+05, .150392D+05,
     +  .107400D+05, .765691D+04, .544843D+04, .386993D+04,
     +  .274305D+04, .194050D+04, .136969D+04, .964762D+03,
     +  .677865D+03, .475415D+03, .330922D+03, .231024D+03,
     +  .160901D+03, .111827D+03, .775538D+02, .536810D+02,
     +  .371329D+02, .256329D+02, .176797D+02, .121932D+02,
     +  .841112D+01, .580901D+01, .401735D+01, .278639D+01,
     +  .193759D+01, .135209D+01, .946968D+00, .666109D+00,
     +  .470344D+00, .334057D+00, .237613D+00, .170088D+00,
     +  .121877D+00, .877170D-01, .632722D-01, .457416D-01,
     +  .331061D-01, .239848D-01, .173723D-01, .125787D-01,
     +  .909540D-02, .656776D-02, .473027D-02, .339873D-02,
     +  .243351D-02, .173617D-02, .123530D-02, .873688D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .614974D-03, .431293D-03, .301291D-03, .210029D-03,
     +  .146147D-03, .101808D-03, .710516D-04, .498488D-04,
     +  .352180D-04, .251888D-04, .181441D-04, .131859D-04,
     +  .962466D-05, .702282D-05, .508222D-05, .361852D-05,
     +  .250833D-05, .166905D-05, .105228D-05, .614681D-06,
     +  .322388D-06, .144230D-06, .500191D-07, .110414D-07,
     +  .901856D-09, .000000D+00, .496098D+05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .408654D+05, .315210D+05, .239739D+05,
     +  .182241D+05, .138490D+05, .105178D+05, .798503D+04,
     +  .605810D+04, .459432D+04, .348164D+04, .263723D+04,
     +  .199598D+04, .150988D+04, .114112D+04, .861938D+03,
     +  .650399D+03, .490467D+03, .369445D+03, .278088D+03,
     +  .209064D+03, .157056D+03, .117829D+03, .883252D+02,
     +  .661150D+02, .494437D+02, .369260D+02, .275612D+02,
     +  .204533D+02, .152315D+02, .113256D+02, .841842D+01,
     +  .624963D+01, .463939D+01, .344434D+01, .255753D+01,
     +  .189908D+01, .141305D+01, .105236D+01, .786324D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .588693D+00, .442930D+00, .334292D+00, .253679D+00,
     +  .193253D+00, .148155D+00, .114036D+00, .884201D-01,
     +  .686760D-01, .537706D-01, .421413D-01, .332178D-01,
     +  .262251D-01, .207825D-01, .164793D-01, .130993D-01,
     +  .104011D-01, .826263D-02, .654806D-02, .518740D-02,
     +  .409260D-02, .322231D-02, .252344D-02, .196817D-02,
     +  .152754D-02, .117628D-02, .896903D-03, .677852D-03,
     +  .506033D-03, .373319D-03, .270737D-03, .193000D-03,
     +  .134121D-03, .906974D-04, .585822D-04, .360738D-04,
     +  .201566D-04, .950643D-05, .265722D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .923988D+05, .711036D+05, .539319D+05, .408836D+05,
     +  .309808D+05, .234612D+05, .177593D+05, .134336D+05,
     +  .101567D+05, .767320D+04, .579390D+04, .437111D+04,
     +  .329579D+04, .248265D+04, .186893D+04, .140544D+04,
     +  .105615D+04, .792746D+03, .594563D+03, .445363D+03,
     +  .333323D+03, .249130D+03, .186029D+03, .138708D+03,
     +  .103318D+03, .768489D+02, .571208D+02, .422093D+02,
     +  .312969D+02, .231700D+02, .171445D+02, .126698D+02,
     +  .936080D+01, .691664D+01, .511023D+01, .377568D+01,
     +  .279467D+01, .207044D+01, .153853D+01, .114555D+01,
     +  .856951D+00, .643064D+00, .485060D+00, .367322D+00,
     +  .279842D+00, .214064D+00, .164905D+00, .127266D+00,
     +  .989785D-01, .770622D-01, .603301D-01, .473132D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .372362D-01, .293278D-01, .231514D-01, .182593D-01,
     +  .144070D-01, .113433D-01, .892764D-02, .700033D-02,
     +  .547908D-02, .426746D-02, .331217D-02, .255987D-02,
     +  .196490D-02, .149568D-02, .113066D-02, .846552D-03,
     +  .628597D-03, .461218D-03, .334973D-03, .239798D-03,
     +  .169429D-03, .117339D-03, .803563D-04, .536470D-04,
     +  .351144D-04, .223363D-04, .138358D-04, .825308D-05,
     +  .475134D-05, .260030D-05, .134826D-05, .646133D-06,
     +  .283814D-06, .108157D-06, .348548D-07, .883872D-08,
     +  .183631D-08, .229324D-10, .000000D+00, .156505D+06,
     +  .120145D+06, .908751D+05, .686935D+05, .519043D+05,
     +  .391912D+05, .295781D+05, .223061D+05, .168131D+05,
     +  .126624D+05, .953089D+04, .716737D+04, .538649D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .404414D+04, .303414D+04, .227393D+04, .170285D+04,
     +  .127368D+04, .951844D+03, .710411D+03, .529727D+03,
     +  .394448D+03, .293415D+03, .217935D+03, .161690D+03,
     +  .119786D+03, .886695D+02, .652467D+02, .481719D+02,
     +  .355097D+02, .261583D+02, .192444D+02, .141521D+02,
     +  .104081D+02, .765233D+01, .562623D+01, .414312D+01,
     +  .305375D+01, .225711D+01, .167162D+01, .124353D+01,
     +  .927976D+00, .695920D+00, .523975D+00, .396798D+00,
     +  .301726D+00, .231004D+00, .177194D+00, .136935D+00,
     +  .105946D+00, .824069D-01, .642173D-01, .502096D-01,
     +  .392920D-01, .308118D-01, .241435D-01, .189241D-01,
     +  .148043D-01, .115752D-01, .901902D-02, .701412D-02,
     +  .542970D-02, .418886D-02, .321873D-02, .245691D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .186093D-02, .140059D-02, .104504D-02, .774094D-03,
     +  .567547D-03, .412683D-03, .296691D-03, .211251D-03,
     +  .148326D-03, .103612D-03, .712816D-04, .486786D-04,
     +  .328648D-04, .220754D-04, .146812D-04, .974527D-05,
     +  .640005D-05, .416156D-05, .264102D-05, .161872D-05,
     +  .926835D-06, .477669D-06, .204710D-06, .586468D-07,
     +  .416390D-08, .000000D+00, .217268D+06, .180272D+06,
     +  .135963D+06, .102478D+06, .772037D+05, .581202D+05,
     +  .437312D+05, .328786D+05, .247050D+05, .185475D+05,
     +  .139158D+05, .104311D+05, .781346D+04, .584678D+04,
     +  .437175D+04, .326520D+04, .243666D+04, .181614D+04,
     +  .135238D+04, .100570D+04, .747147D+03, .554271D+03,
     +  .410732D+03, .303900D+03, .224584D+03, .165716D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .122169D+03, .895210D+02, .658137D+02, .483074D+02,
     +  .354289D+02, .259489D+02, .189948D+02, .139051D+02,
     +  .101743D+02, .744434D+01, .545443D+01, .400004D+01,
     +  .294108D+01, .216678D+01, .160314D+01, .118983D+01,
     +  .887283D+00, .664321D+00, .500164D+00, .378133D+00,
     +  .287782D+00, .219445D+00, .168550D+00, .129620D+00,
     +  .100194D+00, .776014D-01, .602930D-01, .468906D-01,
     +  .365361D-01, .284497D-01, .221574D-01, .172257D-01,
     +  .133826D-01, .103627D-01, .800841D-02, .616162D-02,
     +  .472449D-02, .360865D-02, .273830D-02, .206261D-02,
     +  .154422D-02, .114680D-02, .845893D-03, .618168D-03,
     +  .448456D-03, .322180D-03, .229632D-03, .161875D-03,
     +  .113814D-03, .791552D-04, .548781D-04, .378184D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .260498D-04, .178538D-04, .122396D-04, .830905D-05,
     +  .556703D-05, .362466D-05, .226085D-05, .130725D-05,
     +  .673505D-06, .284900D-06, .794961D-07, .576398D-08,
     +  .000000D+00, .351574D+06, .268438D+06, .201762D+06,
     +  .151547D+06, .113768D+06, .853435D+05, .639825D+05,
     +  .479295D+05, .358807D+05, .268374D+05, .200589D+05,
     +  .149784D+05, .111758D+05, .833002D+04, .620352D+04,
     +  .461467D+04, .342951D+04, .254558D+04, .188752D+04,
     +  .139770D+04, .103384D+04, .763596D+03, .563307D+03,
     +  .414909D+03, .305202D+03, .224148D+03, .164452D+03,
     +  .119914D+03, .877186D+02, .640640D+02, .467417D+02,
     +  .340568D+02, .247955D+02, .180537D+02, .131356D+02,
     +  .955697D+01, .696131D+01, .507528D+01, .370896D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .271594D+01, .199680D+01, .147273D+01, .109111D+01,
     +  .811677D+00, .607028D+00, .455894D+00, .344600D+00,
     +  .261000D+00, .199070D+00, .152036D+00, .116687D+00,
     +  .897471D-01, .692283D-01, .534589D-01, .413486D-01,
     +  .319652D-01, .247105D-01, .190699D-01, .147023D-01,
     +  .112986D-01, .866272D-02, .661243D-02, .502773D-02,
     +  .380730D-02, .286221D-02, .213504D-02, .158142D-02,
     +  .116085D-02, .844996D-03, .608360D-03, .433637D-03,
     +  .305119D-03, .212042D-03, .144976D-03, .981777D-04,
     +  .651840D-04, .426729D-04, .274283D-04, .173820D-04,
     +  .108143D-04, .665299D-05, .402507D-05, .240540D-05,
     +  .140558D-05, .800050D-06, .430000D-06, .211480D-06,
     +  .875077D-07, .244602D-07, .171944D-08, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .497343D+06, .378588D+06, .283546D+06, .212218D+06,
     +  .158739D+06, .118644D+06, .886193D+05, .661373D+05,
     +  .493240D+05, .367516D+05, .273627D+05, .203523D+05,
     +  .151252D+05, .112287D+05, .832819D+04, .616976D+04,
     +  .456610D+04, .337498D+04, .249181D+04, .183721D+04,
     +  .135296D+04, .994871D+03, .730603D+03, .535677D+03,
     +  .392205D+03, .286686D+03, .209322D+03, .151877D+03,
     +  .110547D+03, .803315D+02, .583080D+02, .422631D+02,
     +  .306052D+02, .221637D+02, .160360D+02, .116017D+02,
     +  .840173D+01, .608982D+01, .442366D+01, .321982D+01,
     +  .235259D+01, .172437D+01, .126939D+01, .938295D+00,
     +  .697126D+00, .520142D+00, .390536D+00, .293823D+00,
     +  .222570D+00, .168827D+00, .128674D+00, .982868D-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .752819D-01, .577287D-01, .443320D-01, .340300D-01,
     +  .261180D-01, .200136D-01, .153184D-01, .116888D-01,
     +  .889722D-02, .674354D-02, .509078D-02, .382798D-02,
     +  .285741D-02, .211703D-02, .155768D-02, .113633D-02,
     +  .822290D-03, .589004D-03, .418028D-03, .293278D-03,
     +  .203522D-03, .139362D-03, .947956D-04, .635279D-04,
     +  .422074D-04, .277517D-04, .181418D-04, .117667D-04,
     +  .761323D-05, .488543D-05, .310215D-05, .192389D-05,
     +  .114886D-05, .638706D-06, .317218D-06, .128672D-06,
     +  .341712D-07, .250798D-08, .000000D+00, .678050D+06,
     +  .514562D+06, .383998D+06, .286357D+06, .213409D+06,
     +  .158914D+06, .118253D+06, .879190D+05, .653169D+05,
     +  .484796D+05, .359530D+05, .266360D+05, .197157D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .145772D+05, .107674D+05, .794376D+04, .585429D+04,
     +  .430876D+04, .316753D+04, .232526D+04, .170481D+04,
     +  .124799D+04, .912326D+03, .665844D+03, .485233D+03,
     +  .353003D+03, .256497D+03, .185185D+03, .134119D+03,
     +  .969700D+02, .700220D+02, .504891D+02, .363668D+02,
     +  .261942D+02, .188470D+02, .135591D+02, .976268D+01,
     +  .703527D+01, .508006D+01, .367549D+01, .266906D+01,
     +  .194430D+01, .142228D+01, .104468D+01, .771164D+00,
     +  .571670D+00, .426408D+00, .318703D+00, .239797D+00,
     +  .180676D+00, .136767D+00, .103763D+00, .789297D-01,
     +  .601119D-01, .458401D-01, .349445D-01, .266323D-01,
     +  .202665D-01, .154029D-01, .116718D-01, .882196D-02,
     +  .664048D-02, .497815D-02, .371767D-02, .275606D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .202850D-02, .148298D-02, .107534D-02, .773764D-03,
     +  .551532D-03, .389817D-03, .272712D-03, .188999D-03,
     +  .129579D-03, .884774D-04, .597582D-04, .401812D-04,
     +  .268828D-04, .179688D-04, .119769D-04, .798243D-05,
     +  .528145D-05, .344577D-05, .218557D-05, .132357D-05,
     +  .740273D-06, .365853D-06, .145910D-06, .377250D-07,
     +  .282438D-08, .000000D+00, .899678D+06, .680634D+06,
     +  .506077D+06, .376007D+06, .279179D+06, .207109D+06,
     +  .153532D+06, .113711D+06, .841506D+05, .622140D+05,
     +  .459559D+05, .339106D+05, .249988D+05, .184079D+05,
     +  .135407D+05, .994800D+04, .730031D+04, .535006D+04,
     +  .391598D+04, .286211D+04, .208908D+04, .152242D+04,
     +  .110787D+04, .804827D+03, .583769D+03, .422663D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .305627D+03, .219559D+03, .158222D+03, .113820D+03,
     +  .817659D+02, .586498D+02, .420196D+02, .301030D+02,
     +  .215398D+02, .154097D+02, .110317D+02, .790392D+01,
     +  .567364D+01, .408057D+01, .294524D+01, .213238D+01,
     +  .155016D+01, .113151D+01, .829943D+00, .611318D+00,
     +  .453034D+00, .336406D+00, .251447D+00, .188204D+00,
     +  .141513D+00, .106651D+00, .805792D-01, .609557D-01,
     +  .461662D-01, .349547D-01, .264579D-01, .199974D-01,
     +  .150940D-01, .113602D-01, .852787D-02, .637604D-02,
     +  .474766D-02, .352198D-02, .259373D-02, .189692D-02,
     +  .137827D-02, .993695D-03, .711210D-03, .504627D-03,
     +  .355321D-03, .247957D-03, .171677D-03, .117863D-03,
     +  .807714D-04, .549346D-04, .373138D-04, .253105D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .171963D-04, .116745D-04, .792039D-05, .532532D-05,
     +  .351466D-05, .224435D-05, .135934D-05, .755795D-06,
     +  .368444D-06, .143649D-06, .360940D-07, .274720D-08,
     +  .000000D+00, .116859D+07, .881315D+06, .652877D+06,
     +  .483278D+06, .357479D+06, .264193D+06, .195099D+06,
     +  .143939D+06, .106105D+06, .781365D+05, .574875D+05,
     +  .422491D+05, .310191D+05, .227471D+05, .166629D+05,
     +  .121904D+05, .890788D+04, .650013D+04, .473708D+04,
     +  .344700D+04, .250479D+04, .181714D+04, .131629D+04,
     +  .951813D+03, .687143D+03, .495133D+03, .356296D+03,
     +  .254687D+03, .182623D+03, .130711D+03, .934173D+02,
     +  .666585D+02, .475038D+02, .338493D+02, .240872D+02,
     +  .171364D+02, .121981D+02, .868948D+01, .620105D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .443359D+01, .318081D+01, .228899D+01, .165377D+01,
     +  .119968D+01, .874419D+00, .640016D+00, .471279D+00,
     +  .347712D+00, .258210D+00, .192010D+00, .143427D+00,
     +  .107387D+00, .805978D-01, .605672D-01, .455651D-01,
     +  .342703D-01, .257664D-01, .193455D-01, .145041D-01,
     +  .108441D-01, .808627D-02, .600637D-02, .444311D-02,
     +  .327486D-02, .239639D-02, .174193D-02, .125827D-02,
     +  .902276D-03, .642588D-03, .454039D-03, .318643D-03,
     +  .221911D-03, .153572D-03, .105612D-03, .726484D-04,
     +  .497343D-04, .340847D-04, .233833D-04, .160854D-04,
     +  .110604D-04, .758555D-05, .514235D-05, .340662D-05,
     +  .217409D-05, .130891D-05, .719801D-06, .344852D-06,
     +  .131124D-06, .319937D-07, .247317D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .149143D+07, .112127D+07, .827563D+06, .610302D+06,
     +  .449738D+06, .331114D+06, .243580D+06, .179011D+06,
     +  .131441D+06, .964116D+05, .706495D+05, .517127D+05,
     +  .378123D+05, .276145D+05, .201441D+05, .146752D+05,
     +  .106779D+05, .775818D+04, .562928D+04, .407818D+04,
     +  .295022D+04, .213063D+04, .153632D+04, .110578D+04,
     +  .794550D+03, .569794D+03, .408039D+03, .290227D+03,
     +  .207073D+03, .147467D+03, .104853D+03, .744303D+02,
     +  .527619D+02, .373952D+02, .264651D+02, .187240D+02,
     +  .132530D+02, .938724D+01, .666016D+01, .473398D+01,
     +  .337611D+01, .241496D+01, .173417D+01, .125031D+01,
     +  .905674D+00, .658761D+00, .482035D+00, .353399D+00,
     +  .260756D+00, .192660D+00, .142984D+00, .106367D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .793133D-01, .592152D-01, .442559D-01, .330688D-01,
     +  .247003D-01, .184246D-01, .137233D-01, .101940D-01,
     +  .755238D-02, .557417D-02, .409724D-02, .300116D-02,
     +  .218270D-02, .157738D-02, .113312D-02, .808431D-03,
     +  .573145D-03, .403470D-03, .282362D-03, .196350D-03,
     +  .135896D-03, .936512D-04, .646765D-04, .445544D-04,
     +  .307793D-04, .213145D-04, .148017D-04, .102672D-04,
     +  .708554D-05, .481940D-05, .318998D-05, .202625D-05,
     +  .120861D-05, .655639D-06, .308124D-06, .114148D-06,
     +  .270515D-07, .212271D-08, .000000D+00, .187499D+07,
     +  .140523D+07, .103330D+07, .759184D+06, .557343D+06,
     +  .408777D+06, .299556D+06, .219295D+06, .160390D+06,
     +  .117180D+06, .855254D+05, .623488D+05, .454034D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .330218D+05, .239883D+05, .174022D+05, .126082D+05,
     +  .912129D+04, .658954D+04, .475287D+04, .342299D+04,
     +  .246093D+04, .176639D+04, .126550D+04, .905068D+03,
     +  .645962D+03, .460356D+03, .325821D+03, .231320D+03,
     +  .163910D+03, .115950D+03, .818839D+02, .577408D+02,
     +  .407068D+02, .286527D+02, .201604D+02, .141900D+02,
     +  .999414D+01, .705004D+01, .498207D+01, .353212D+01,
     +  .251157D+01, .179270D+01, .128470D+01, .924886D+00,
     +  .668595D+00, .486200D+00, .354229D+00, .259724D+00,
     +  .190687D+00, .140622D+00, .103948D+00, .770145D-01,
     +  .571325D-01, .424250D-01, .314982D-01, .233766D-01,
     +  .173263D-01, .128229D-01, .946518D-02, .696829D-02,
     +  .511134D-02, .373397D-02, .271871D-02, .196572D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .141273D-02, .100958D-02, .716920D-03, .506186D-03,
     +  .355183D-03, .248006D-03, .172299D-03, .119326D-03,
     +  .824358D-04, .571659D-04, .396151D-04, .275612D-04,
     +  .192330D-04, .134507D-04, .938312D-05, .649416D-05,
     +  .441696D-05, .291236D-05, .183642D-05, .108304D-05,
     +  .578634D-06, .266464D-06, .961426D-07, .221441D-07,
     +  .176327D-08, .000000D+00, .232605D+07, .173787D+07,
     +  .127317D+07, .931943D+06, .681598D+06, .498015D+06,
     +  .363552D+06, .265116D+06, .193145D+06, .140555D+06,
     +  .102177D+06, .741881D+05, .538052D+05, .389718D+05,
     +  .281930D+05, .203668D+05, .146935D+05, .105844D+05,
     +  .761336D+04, .546728D+04, .392004D+04, .280565D+04,
     +  .200468D+04, .142962D+04, .101768D+04, .722900D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .512720D+03, .361100D+03, .255107D+03, .179867D+03,
     +  .126595D+03, .889441D+02, .623926D+02, .437549D+02,
     +  .306327D+02, .214364D+02, .150046D+02, .105088D+02,
     +  .737099D+01, .517900D+01, .365038D+01, .258042D+01,
     +  .183091D+01, .130425D+01, .933289D+00, .670571D+00,
     +  .484662D+00, .350935D+00, .255716D+00, .186578D+00,
     +  .136733D+00, .100444D+00, .739525D-01, .545177D-01,
     +  .402284D-01, .296804D-01, .218895D-01, .161232D-01,
     +  .118582D-01, .869934D-02, .636532D-02, .464111D-02,
     +  .337034D-02, .243985D-02, .175425D-02, .125417D-02,
     +  .891922D-03, .630651D-03, .443650D-03, .310448D-03,
     +  .216395D-03, .150279D-03, .104195D-03, .721831D-04,
     +  .502658D-04, .350271D-04, .245191D-04, .172149D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .120992D-04, .846724D-05, .586228D-05, .397722D-05,
     +  .260681D-05, .162886D-05, .948529D-06, .498586D-06,
     +  .224837D-06, .790053D-07, .177000D-07, .142980D-08,
     +  .000000D+00, .285124D+07, .212370D+07, .155010D+07,
     +  .113045D+07, .823689D+06, .599564D+06, .436013D+06,
     +  .316735D+06, .229854D+06, .166612D+06, .120639D+06,
     +  .872428D+05, .630172D+05, .454578D+05, .327494D+05,
     +  .235597D+05, .169253D+05, .121401D+05, .869480D+04,
     +  .621670D+04, .443774D+04, .316202D+04, .224913D+04,
     +  .159663D+04, .113132D+04, .799842D+03, .564597D+03,
     +  .395698D+03, .278189D+03, .195175D+03, .136681D+03,
     +  .955435D+02, .666764D+02, .465154D+02, .323922D+02,
     +  .225457D+02, .156947D+02, .109314D+02, .762435D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .532665D+01, .373287D+01, .262345D+01, .185053D+01,
     +  .131046D+01, .932145D+00, .665737D+00, .478274D+00,
     +  .344209D+00, .249287D+00, .180775D+00, .131668D+00,
     +  .961321D-01, .703420D-01, .515376D-01, .377947D-01,
     +  .277138D-01, .203139D-01, .148717D-01, .108713D-01,
     +  .792760D-02, .576620D-02, .417989D-02, .301805D-02,
     +  .217277D-02, .155393D-02, .110549D-02, .782649D-03,
     +  .551228D-03, .386534D-03, .269870D-03, .187880D-03,
     +  .130491D-03, .906160D-04, .629648D-04, .440274D-04,
     +  .308351D-04, .216962D-04, .153036D-04, .107896D-04,
     +  .755924D-05, .522492D-05, .352935D-05, .229593D-05,
     +  .141979D-05, .815596D-06, .421485D-06, .186050D-06,
     +  .636775D-07, .138890D-07, .113793D-08, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .408384D+05, .244600D+05, .192305D+05, .151190D+05,
     +  .118867D+05, .934548D+04, .734760D+04, .577689D+04,
     +  .454202D+04, .357116D+04, .280789D+04, .220780D+04,
     +  .173601D+04, .136509D+04, .107347D+04, .844195D+03,
     +  .663933D+03, .522205D+03, .410773D+03, .323160D+03,
     +  .254271D+03, .200105D+03, .157512D+03, .124020D+03,
     +  .976813D+02, .769674D+02, .606754D+02, .476994D+02,
     +  .376553D+02, .297511D+02, .235294D+02, .186305D+02,
     +  .147718D+02, .117389D+02, .934076D+01, .744881D+01,
     +  .595450D+01, .477250D+01, .383580D+01, .309147D+01,
     +  .249923D+01, .202570D+01, .164591D+01, .134011D+01,
     +  .109289D+01, .892261D+00, .729395D+00, .595443D+00,
     +  .486316D+00, .396133D+00, .322254D+00, .261455D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .211434D+00, .170321D+00, .136592D+00, .108991D+00,
     +  .864815D-01, .681979D-01, .534183D-01, .415361D-01,
     +  .320414D-01, .245055D-01, .185685D-01, .139476D-01,
     +  .103453D-01, .758332D-02, .548789D-02, .391638D-02,
     +  .275257D-02, .190255D-02, .129109D-02, .858572D-03,
     +  .558104D-03, .353517D-03, .218555D-03, .130485D-03,
     +  .751560D-04, .415367D-04, .218811D-04, .108951D-04,
     +  .507282D-05, .218088D-05, .844203D-06, .288760D-06,
     +  .835817D-07, .192628D-07, .319161D-08, .313902D-09,
     +  .119200D-10, .441541D-13, .000000D+00, .713987D+05,
     +  .557627D+05, .430325D+05, .332081D+05, .256294D+05,
     +  .197797D+05, .152668D+05, .117832D+05, .909554D+04,
     +  .702071D+04, .541981D+04, .418385D+04, .323017D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .249382D+04, .192562D+04, .148686D+04, .114828D+04,
     +  .886805D+03, .685016D+03, .529170D+03, .408894D+03,
     +  .315993D+03, .244284D+03, .188888D+03, .146120D+03,
     +  .113079D+03, .875742D+02, .676127D+02, .524423D+02,
     +  .407088D+02, .316409D+02, .246226D+02, .191930D+02,
     +  .149972D+02, .117383D+02, .920947D+01, .724680D+01,
     +  .571895D+01, .452862D+01, .359730D+01, .286840D+01,
     +  .229422D+01, .184082D+01, .148087D+01, .119420D+01,
     +  .964574D+00, .780740D+00, .631321D+00, .511178D+00,
     +  .412955D+00, .333402D+00, .268569D+00, .215771D+00,
     +  .172754D+00, .137778D+00, .109371D+00, .863785D-01,
     +  .678249D-01, .529285D-01, .410167D-01, .315523D-01,
     +  .240749D-01, .182088D-01, .136603D-01, .101253D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .742008D-02, .537160D-02, .383647D-02, .270032D-02,
     +  .186960D-02, .127137D-02, .846777D-03, .551023D-03,
     +  .348251D-03, .213951D-03, .125618D-03, .698051D-04,
     +  .357329D-04, .158662D-04, .500966D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .122673D+06, .951392D+05,
     +  .728283D+05, .557401D+05, .426608D+05, .326441D+05,
     +  .249789D+05, .191098D+05, .146194D+05, .111819D+05,
     +  .855256D+04, .654013D+04, .500120D+04, .382361D+04,
     +  .292333D+04, .223457D+04, .170815D+04, .130551D+04,
     +  .997837D+03, .762564D+03, .582845D+03, .445444D+03,
     +  .340504D+03, .260289D+03, .199031D+03, .152221D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .116497D+03, .888486D+02, .680789D+02, .521976D+02,
     +  .400699D+02, .307931D+02, .237028D+02, .182890D+02,
     +  .141358D+02, .109517D+02, .851137D+01, .663451D+01,
     +  .519055D+01, .407436D+01, .321163D+01, .254010D+01,
     +  .201624D+01, .160519D+01, .128169D+01, .102544D+01,
     +  .822604D+00, .659447D+00, .529680D+00, .424612D+00,
     +  .340349D+00, .272291D+00, .217363D+00, .172977D+00,
     +  .137181D+00, .108319D+00, .851259D-01, .665327D-01,
     +  .517023D-01, .399110D-01, .305966D-01, .232749D-01,
     +  .175587D-01, .131460D-01, .973019D-02, .712472D-02,
     +  .515816D-02, .368796D-02, .260232D-02, .180931D-02,
     +  .123865D-02, .833275D-03, .550334D-03, .355441D-03,
     +  .225570D-03, .139133D-03, .836259D-04, .487410D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .275200D-04, .149535D-04, .781392D-05, .389245D-05,
     +  .183796D-05, .810057D-06, .330117D-06, .118574D-06,
     +  .365350D-07, .900037D-08, .184239D-08, .229576D-10,
     +  .000000D+00, .186531D+06, .143984D+06, .109617D+06,
     +  .834281D+05, .634884D+05, .482987D+05, .367382D+05,
     +  .279355D+05, .212390D+05, .161421D+05, .122667D+05,
     +  .931835D+04, .707766D+04, .537385D+04, .407965D+04,
     +  .309603D+04, .234928D+04, .178202D+04, .135161D+04,
     +  .102482D+04, .777019D+03, .588978D+03, .446458D+03,
     +  .338362D+03, .256471D+03, .194399D+03, .147427D+03,
     +  .111379D+03, .845354D+02, .641899D+02, .487930D+02,
     +  .371230D+02, .282866D+02, .216033D+02, .165256D+02,
     +  .126706D+02, .974523D+01, .751761D+01, .582107D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .452281D+01, .352959D+01, .276427D+01, .217329D+01,
     +  .171421D+01, .135654D+01, .107597D+01, .856054D+00,
     +  .680800D+00, .542725D+00, .431915D+00, .343825D+00,
     +  .273265D+00, .216783D+00, .171492D+00, .135239D+00,
     +  .106214D+00, .830488D-01, .645974D-01, .499726D-01,
     +  .384121D-01, .293323D-01, .222326D-01, .167174D-01,
     +  .124797D-01, .921397D-02, .673278D-02, .486724D-02,
     +  .347722D-02, .245398D-02, .170834D-02, .117286D-02,
     +  .792906D-03, .527764D-03, .344903D-03, .222708D-03,
     +  .140909D-03, .879049D-04, .540554D-04, .329697D-04,
     +  .199714D-04, .121413D-04, .740153D-05, .453714D-05,
     +  .276539D-05, .165342D-05, .934547D-06, .478896D-06,
     +  .204827D-06, .586512D-07, .416392D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .208789D+06, .203921D+06, .154555D+06, .117095D+06,
     +  .886953D+05, .671550D+05, .508341D+05, .384629D+05,
     +  .290953D+05, .219992D+05, .166295D+05, .125646D+05,
     +  .949088D+04, .716564D+04, .540867D+04, .408050D+04,
     +  .307770D+04, .232021D+04, .174874D+04, .131740D+04,
     +  .992272D+03, .747065D+03, .562380D+03, .423202D+03,
     +  .318453D+03, .239588D+03, .180319D+03, .135156D+03,
     +  .101766D+03, .766452D+02, .577769D+02, .435859D+02,
     +  .329244D+02, .249253D+02, .188972D+02, .143587D+02,
     +  .109436D+02, .836530D+01, .641862D+01, .494200D+01,
     +  .382225D+01, .296709D+01, .231257D+01, .180865D+01,
     +  .141953D+01, .111694D+01, .881832D+00, .696062D+00,
     +  .550940D+00, .435425D+00, .344330D+00, .271930D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .214412D+00, .168628D+00, .132238D+00, .103300D+00,
     +  .803556D-01, .621955D-01, .478892D-01, .366464D-01,
     +  .278658D-01, .210371D-01, .157594D-01, .117239D-01,
     +  .862856D-02, .628716D-02, .453419D-02, .323317D-02,
     +  .227896D-02, .158586D-02, .108955D-02, .738188D-03,
     +  .493383D-03, .324652D-03, .211795D-03, .136053D-03,
     +  .867066D-04, .548867D-04, .347566D-04, .220475D-04,
     +  .141223D-04, .908879D-05, .585650D-05, .371951D-05,
     +  .228701D-05, .131299D-05, .674408D-06, .284985D-06,
     +  .794992D-07, .576400D-08, .000000D+00, .381088D+06,
     +  .291869D+06, .220183D+06, .166030D+06, .125154D+06,
     +  .942949D+05, .710199D+05, .534621D+05, .402303D+05,
     +  .302570D+05, .227473D+05, .170919D+05, .128375D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .963640D+04, .723058D+04, .542215D+04, .406436D+04,
     +  .304472D+04, .227996D+04, .170626D+04, .127646D+04,
     +  .954380D+03, .713337D+03, .532904D+03, .398010D+03,
     +  .297155D+03, .221894D+03, .164967D+03, .123189D+03,
     +  .920003D+02, .687530D+02, .514100D+02, .384842D+02,
     +  .288681D+02, .216817D+02, .163188D+02, .123181D+02,
     +  .932528D+01, .708577D+01, .540292D+01, .413846D+01,
     +  .318197D+01, .245668D+01, .190364D+01, .148057D+01,
     +  .115472D+01, .903876D+00, .707524D+00, .555524D+00,
     +  .435632D+00, .341906D+00, .268063D+00, .209885D+00,
     +  .163957D+00, .127737D+00, .991569D-01, .766626D-01,
     +  .589884D-01, .451602D-01, .343672D-01, .259921D-01,
     +  .195202D-01, .145477D-01, .107680D-01, .788474D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .571587D-02, .410056D-02, .290798D-02, .203763D-02,
     +  .140863D-02, .960407D-03, .644698D-03, .425902D-03,
     +  .276048D-03, .176516D-03, .110341D-03, .677406D-04,
     +  .407645D-04, .241285D-04, .140357D-04, .808582D-05,
     +  .461280D-05, .262132D-05, .147556D-05, .819127D-06,
     +  .434140D-06, .212122D-06, .875675D-07, .244625D-07,
     +  .171946D-08, .000000D+00, .526587D+06, .401805D+06,
     +  .301799D+06, .226568D+06, .170020D+06, .127513D+06,
     +  .955920D+05, .716191D+05, .536334D+05, .401395D+05,
     +  .300260D+05, .224462D+05, .167713D+05, .125227D+05,
     +  .934547D+04, .696949D+04, .519479D+04, .386922D+04,
     +  .288034D+04, .214266D+04, .159309D+04, .118365D+04,
     +  .879015D+03, .652362D+03, .483949D+03, .358823D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .266050D+03, .196344D+03, .145531D+03, .107862D+03,
     +  .799787D+02, .593288D+02, .440499D+02, .327698D+02,
     +  .244035D+02, .182095D+02, .136252D+02, .102239D+02,
     +  .769953D+01, .581868D+01, .441723D+01, .336627D+01,
     +  .257613D+01, .197895D+01, .152602D+01, .118023D+01,
     +  .916310D+00, .711525D+00, .554336D+00, .431409D+00,
     +  .336101D+00, .261635D+00, .203431D+00, .157847D+00,
     +  .122170D+00, .942327D-01, .724037D-01, .553763D-01,
     +  .421460D-01, .318910D-01, .239857D-01, .179170D-01,
     +  .132831D-01, .978247D-02, .712803D-02, .514321D-02,
     +  .367345D-02, .259449D-02, .181129D-02, .124830D-02,
     +  .849095D-03, .569258D-03, .376113D-03, .244370D-03,
     +  .157087D-03, .991543D-04, .618230D-04, .380985D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .233291D-04, .142202D-04, .869349D-05, .532385D-05,
     +  .326136D-05, .197486D-05, .116257D-05, .641641D-06,
     +  .317667D-06, .128713D-06, .341727D-07, .250799D-08,
     +  .000000D+00, .707029D+06, .537569D+06, .402085D+06,
     +  .300577D+06, .224587D+06, .167702D+06, .125162D+06,
     +  .933503D+05, .695866D+05, .518362D+05, .385916D+05,
     +  .287103D+05, .213463D+05, .158591D+05, .117750D+05,
     +  .873580D+04, .647686D+04, .479813D+04, .355218D+04,
     +  .262760D+04, .194244D+04, .143476D+04, .105912D+04,
     +  .781216D+03, .575907D+03, .424264D+03, .312506D+03,
     +  .229058D+03, .168610D+03, .124089D+03, .913476D+02,
     +  .672635D+02, .495642D+02, .365892D+02, .270336D+02,
     +  .200112D+02, .148516D+02, .110529D+02, .825472D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .618633D+01, .465710D+01, .351953D+01, .267107D+01,
     +  .203505D+01, .155654D+01, .119422D+01, .919915D+00,
     +  .708818D+00, .548075D+00, .423392D+00, .327482D+00,
     +  .253140D+00, .195477D+00, .150663D+00, .115848D+00,
     +  .887867D-01, .677935D-01, .515350D-01, .389886D-01,
     +  .293304D-01, .219343D-01, .162941D-01, .120143D-01,
     +  .880147D-02, .638020D-02, .458088D-02, .325642D-02,
     +  .228986D-02, .159222D-02, .109356D-02, .741834D-03,
     +  .496532D-03, .327988D-03, .213523D-03, .137900D-03,
     +  .878026D-04, .554957D-04, .348918D-04, .219479D-04,
     +  .138411D-04, .879488D-05, .560765D-05, .356285D-05,
     +  .222259D-05, .133340D-05, .742348D-06, .366166D-06,
     +  .145938D-06, .377260D-07, .282438D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .928394D+06, .703432D+06, .524000D+06, .390097D+06,
     +  .290255D+06, .215817D+06, .160377D+06, .119092D+06,
     +  .883809D+05, .655396D+05, .485701D+05, .359656D+05,
     +  .266140D+05, .196775D+05, .145386D+05, .107324D+05,
     +  .791679D+04, .583457D+04, .429675D+04, .316133D+04,
     +  .232421D+04, .170718D+04, .125303D+04, .918877D+03,
     +  .673365D+03, .493041D+03, .360909D+03, .262833D+03,
     +  .192215D+03, .140523D+03, .102742D+03, .751286D+02,
     +  .549662D+02, .402841D+02, .295432D+02, .217045D+02,
     +  .159851D+02, .118044D+02, .874690D+01, .650356D+01,
     +  .485714D+01, .364167D+01, .274191D+01, .207265D+01,
     +  .157296D+01, .119754D+01, .915502D+00, .700148D+00,
     +  .537412D+00, .412164D+00, .316550D+00, .243004D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .186380D+00, .142701D+00, .109012D+00, .830162D-01,
     +  .629913D-01, .475917D-01, .357887D-01, .267649D-01,
     +  .199002D-01, .146997D-01, .107785D-01, .785347D-02,
     +  .566285D-02, .404515D-02, .286162D-02, .200312D-02,
     +  .138708D-02, .949281D-03, .642152D-03, .429073D-03,
     +  .283354D-03, .184817D-03, .119893D-03, .769591D-04,
     +  .492423D-04, .314951D-04, .202413D-04, .130875D-04,
     +  .852994D-05, .556744D-05, .360055D-05, .227118D-05,
     +  .136637D-05, .757258D-06, .368662D-06, .143668D-06,
     +  .360947D-07, .274720D-08, .000000D+00, .119705D+07,
     +  .903906D+06, .670637D+06, .497239D+06, .368455D+06,
     +  .272822D+06, .201882D+06, .149271D+06, .110297D+06,
     +  .814312D+05, .600773D+05, .442848D+05, .326191D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .240047D+05, .176513D+05, .129672D+05, .951829D+04,
     +  .697979D+04, .511397D+04, .374312D+04, .273742D+04,
     +  .199988D+04, .145982D+04, .106453D+04, .775652D+03,
     +  .564619D+03, .410843D+03, .297354D+03, .216110D+03,
     +  .156991D+03, .114038D+03, .828373D+02, .601960D+02,
     +  .438135D+02, .319054D+02, .232722D+02, .170149D+02,
     +  .124722D+02, .917281D+01, .676899D+01, .501714D+01,
     +  .373313D+01, .278947D+01, .209271D+01, .157627D+01,
     +  .119114D+01, .903939D+00, .686281D+00, .523010D+00,
     +  .398292D+00, .303780D+00, .231619D+00, .176461D+00,
     +  .134221D+00, .101872D+00, .770872D-01, .581278D-01,
     +  .436484D-01, .326254D-01, .242549D-01, .179290D-01,
     +  .131682D-01, .960135D-02, .695749D-02, .498990D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .354608D-02, .249625D-02, .173938D-02, .119946D-02,
     +  .817983D-03, .551824D-03, .368131D-03, .243095D-03,
     +  .158887D-03, .103543D-03, .669892D-04, .433530D-04,
     +  .281472D-04, .184096D-04, .121287D-04, .804169D-05,
     +  .532159D-05, .346947D-05, .219348D-05, .131392D-05,
     +  .720831D-06, .345003D-06, .131137D-06, .319942D-07,
     +  .247317D-08, .000000D+00, .151963D+07, .114366D+07,
     +  .845161D+06, .624136D+06, .460614D+06, .339664D+06,
     +  .250300D+06, .184293D+06, .135594D+06, .996756D+05,
     +  .732150D+05, .537292D+05, .393971D+05, .288600D+05,
     +  .211229D+05, .154444D+05, .112822D+05, .823300D+04,
     +  .600228D+04, .437118D+04, .318034D+04, .231134D+04,
     +  .167820D+04, .121715D+04, .881962D+03, .638378D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .461842D+03, .332279D+03, .240048D+03, .173317D+03,
     +  .125112D+03, .903046D+02, .651960D+02, .471399D+02,
     +  .340959D+02, .246995D+02, .179323D+02, .130519D+02,
     +  .953045D+01, .698217D+01, .513753D+01, .379486D+01,
     +  .281488D+01, .209640D+01, .156759D+01, .117604D+01,
     +  .886121D+00, .667987D+00, .505518D+00, .382313D+00,
     +  .289611D+00, .219341D+00, .166005D+00, .125449D+00,
     +  .946049D-01, .711371D-01, .533081D-01, .397849D-01,
     +  .295584D-01, .218447D-01, .160533D-01, .117233D-01,
     +  .849965D-02, .612533D-02, .436950D-02, .308921D-02,
     +  .216401D-02, .150107D-02, .103092D-02, .700666D-03,
     +  .471486D-03, .314120D-03, .207488D-03, .135940D-03,
     +  .890137D-04, .580391D-04, .379626D-04, .249748D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .165713D-04, .110728D-04, .742600D-05, .495173D-05,
     +  .323584D-05, .204023D-05, .121217D-05, .656361D-06,
     +  .308228D-06, .114157D-06, .270519D-07, .212271D-08,
     +  .000000D+00, .190293D+07, .142741D+07, .105074D+07,
     +  .772892D+06, .568119D+06, .417248D+06, .306214D+06,
     +  .224529D+06, .164504D+06, .120414D+06, .880668D+05,
     +  .643462D+05, .469731D+05, .342553D+05, .249575D+05,
     +  .181638D+05, .132065D+05, .959126D+04, .695866D+04,
     +  .504274D+04, .365058D+04, .263959D+04, .190661D+04,
     +  .137553D+04, .991370D+03, .713633D+03, .513404D+03,
     +  .367248D+03, .263774D+03, .189325D+03, .135844D+03,
     +  .974492D+02, .699133D+02, .502291D+02, .360940D+02,
     +  .259742D+02, .187310D+02, .135405D+02, .981904D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .714357D+01, .521943D+01, .382820D+01, .281955D+01,
     +  .208506D+01, .154813D+01, .115329D+01, .862950D+00,
     +  .646018D+00, .485556D+00, .364728D+00, .274445D+00,
     +  .206487D+00, .155260D+00, .116577D+00, .873563D-01,
     +  .652761D-01, .486144D-01, .360616D-01, .266314D-01,
     +  .195655D-01, .142947D-01, .103796D-01, .748317D-02,
     +  .536331D-02, .380551D-02, .267677D-02, .186609D-02,
     +  .128871D-02, .881632D-03, .597308D-03, .401037D-03,
     +  .266929D-03, .176441D-03, .115922D-03, .762905D-04,
     +  .501271D-04, .331145D-04, .220382D-04, .147945D-04,
     +  .998896D-05, .674760D-05, .451441D-05, .294574D-05,
     +  .184647D-05, .108557D-05, .579140D-06, .266537D-06,
     +  .961488D-07, .221444D-07, .176327D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .235374D+07, .175985D+07, .129045D+07, .945526D+06,
     +  .692276D+06, .506408D+06, .370149D+06, .270301D+06,
     +  .197221D+06, .143758D+06, .104694D+06, .761665D+05,
     +  .553598D+05, .401933D+05, .291528D+05, .211208D+05,
     +  .152857D+05, .110495D+05, .797857D+04, .575400D+04,
     +  .414509D+04, .298225D+04, .214322D+04, .153827D+04,
     +  .110286D+04, .789646D+03, .565004D+03, .401893D+03,
     +  .287033D+03, .204840D+03, .146117D+03, .104196D+03,
     +  .743000D+02, .530522D+02, .378828D+02, .270873D+02,
     +  .194068D+02, .139367D+02, .100390D+02, .725448D+01,
     +  .526448D+01, .383489D+01, .280512D+01, .206017D+01,
     +  .151916D+01, .112398D+01, .835315D+00, .621096D+00,
     +  .463702D+00, .345996D+00, .258640D+00, .193334D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .144437D+00, .107763D+00, .802447D-01, .595909D-01,
     +  .441089D-01, .325222D-01, .238743D-01, .174371D-01,
     +  .126662D-01, .914498D-02, .655635D-02, .467360D-02,
     +  .329869D-02, .230867D-02, .160195D-02, .110161D-02,
     +  .750867D-03, .507249D-03, .339931D-03, .226135D-03,
     +  .149650D-03, .986349D-04, .652573D-04, .432013D-04,
     +  .288014D-04, .193592D-04, .131171D-04, .892170D-05,
     +  .605045D-05, .404879D-05, .263105D-05, .163606D-05,
     +  .950319D-06, .498939D-06, .224887D-06, .790095D-07,
     +  .177002D-07, .142980D-08, .000000D+00, .287868D+07,
     +  .214548D+07, .156723D+07, .114391D+07, .834268D+06,
     +  .607880D+06, .442549D+06, .321872D+06, .233891D+06,
     +  .169785D+06, .123133D+06, .892023D+05, .645568D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .466674D+05, .336996D+05, .243061D+05, .175114D+05,
     +  .126003D+05, .905609D+04, .650026D+04, .466023D+04,
     +  .333655D+04, .238598D+04, .170390D+04, .121536D+04,
     +  .865650D+03, .616105D+03, .435849D+03, .309579D+03,
     +  .219699D+03, .155826D+03, .110478D+03, .783154D+02,
     +  .555854D+02, .394495D+02, .280329D+02, .199578D+02,
     +  .142410D+02, .101919D+02, .731693D+01, .527482D+01,
     +  .381695D+01, .277339D+01, .202328D+01, .148199D+01,
     +  .108915D+01, .804071D+00, .593900D+00, .440489D+00,
     +  .326528D+00, .242510D+00, .180118D+00, .133712D+00,
     +  .991358D-01, .733626D-01, .541463D-01, .398360D-01,
     +  .291962D-01, .213061D-01, .154709D-01, .111736D-01,
     +  .802211D-02, .571964D-02, .405541D-02, .284760D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .198325D-02, .136993D-02, .938263D-03, .637352D-03,
     +  .429464D-03, .287375D-03, .191156D-03, .126707D-03,
     +  .838098D-04, .557506D-04, .371759D-04, .249903D-04,
     +  .169386D-04, .115587D-04, .789927D-05, .536427D-05,
     +  .358178D-05, .231348D-05, .142495D-05, .816860D-06,
     +  .421731D-06, .186084D-06, .636804D-07, .138892D-07,
     +  .113793D-08, .000000D+00, .319920D+05, .489424D+05,
     +  .384798D+05, .302541D+05, .237870D+05, .187026D+05,
     +  .147052D+05, .115624D+05, .909146D+04, .714877D+04,
     +  .562138D+04, .442049D+04, .347631D+04, .273394D+04,
     +  .215025D+04, .169130D+04, .133044D+04, .104669D+04,
     +  .823570D+03, .648117D+03, .510143D+03, .401638D+03,
     +  .316302D+03, .249183D+03, .196389D+03, .154858D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .122184D+03, .961514D+02, .759938D+02, .601245D+02,
     +  .476278D+02, .377837D+02, .300260D+02, .239254D+02,
     +  .190988D+02, .152887D+02, .122773D+02, .989336D+01,
     +  .800223D+01, .649748D+01, .529805D+01, .433669D+01,
     +  .356302D+01, .293724D+01, .242832D+01, .201216D+01,
     +  .167112D+01, .138742D+01, .115321D+01, .956710D+00,
     +  .792996D+00, .655774D+00, .540647D+00, .444057D+00,
     +  .363105D+00, .295396D+00, .238936D+00, .192039D+00,
     +  .153272D+00, .121404D+00, .953714D-01, .742557D-01,
     +  .572604D-01, .437527D-01, .330042D-01, .245953D-01,
     +  .180889D-01, .131146D-01, .936100D-02, .656883D-02,
     +  .452415D-02, .305242D-02, .201251D-02, .129262D-02,
     +  .809994D-03, .490070D-03, .285968D-03, .160074D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .853851D-04, .430388D-04, .202808D-04, .882193D-05,
     +  .345464D-05, .119509D-05, .349777D-06, .814947D-07,
     +  .136478D-07, .135646D-08, .520433D-10, .194743D-12,
     +  .000000D+00, .101959D+06, .800270D+05, .621102D+05,
     +  .482083D+05, .374236D+05, .290534D+05, .225587D+05,
     +  .175171D+05, .136044D+05, .105664D+05, .820814D+04,
     +  .637675D+04, .495486D+04, .385039D+04, .299271D+04,
     +  .232634D+04, .180876D+04, .140654D+04, .109406D+04,
     +  .851158D+03, .662413D+03, .515661D+03, .401591D+03,
     +  .312872D+03, .243885D+03, .190215D+03, .148476D+03,
     +  .115576D+03, .903845D+02, .707592D+02, .554740D+02,
     +  .435566D+02, .342644D+02, .270299D+02, .213656D+02,
     +  .169371D+02, .134720D+02, .107540D+02, .861875D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .693475D+01, .560496D+01, .454822D+01, .370538D+01,
     +  .302933D+01, .248441D+01, .204241D+01, .168337D+01,
     +  .138707D+01, .114461D+01, .942807D+00, .776095D+00,
     +  .637473D+00, .522125D+00, .426109D+00, .346272D+00,
     +  .279998D+00, .225145D+00, .179913D+00, .142792D+00,
     +  .112485D+00, .878969D-01, .680858D-01, .522384D-01,
     +  .397230D-01, .298224D-01, .221212D-01, .161957D-01,
     +  .116900D-01, .830805D-02, .580476D-02, .398051D-02,
     +  .267324D-02, .175395D-02, .111970D-02, .696434D-03,
     +  .416863D-03, .239268D-03, .130288D-03, .661074D-04,
     +  .302275D-04, .114141D-04, .249528D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .152974D+06, .119198D+06, .917441D+05, .706130D+05,
     +  .543548D+05, .418391D+05, .322089D+05, .247950D+05,
     +  .190899D+05, .146974D+05, .113171D+05, .871434D+04,
     +  .671117D+04, .516858D+04, .398127D+04, .306684D+04,
     +  .236295D+04, .182075D+04, .140332D+04, .108174D+04,
     +  .834135D+03, .643344D+03, .496404D+03, .383151D+03,
     +  .295900D+03, .228637D+03, .176819D+03, .136345D+03,
     +  .105641D+03, .819377D+02, .636476D+02, .495154D+02,
     +  .385971D+02, .301723D+02, .236358D+02, .185698D+02,
     +  .146412D+02, .115857D+02, .920607D+01, .734482D+01,
     +  .588746D+01, .473865D+01, .382985D+01, .310664D+01,
     +  .252843D+01, .206306D+01, .168807D+01, .138095D+01,
     +  .113169D+01, .925797D+00, .757040D+00, .617782D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .502796D+00, .407795D+00, .329389D+00, .264773D+00,
     +  .211673D+00, .168192D+00, .132753D+00, .104014D+00,
     +  .808517D-01, .623108D-01, .475702D-01, .360011D-01,
     +  .269033D-01, .198676D-01, .144849D-01, .104147D-01,
     +  .737621D-02, .513867D-02, .351618D-02, .235882D-02,
     +  .154846D-02, .991170D-03, .620376D-03, .375717D-03,
     +  .220229D-03, .124358D-03, .673597D-04, .347764D-04,
     +  .170177D-04, .783535D-05, .335486D-05, .132528D-05,
     +  .477746D-06, .152251D-06, .420418D-07, .953733D-08,
     +  .186289D-08, .230433D-10, .000000D+00, .216584D+06,
     +  .167846D+06, .128378D+06, .981795D+05, .750868D+05,
     +  .574185D+05, .439090D+05, .335741D+05, .256728D+05,
     +  .196288D+05, .150085D+05, .114747D+05, .877355D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .670774D+04, .512885D+04, .392140D+04, .299863D+04,
     +  .229296D+04, .175369D+04, .134130D+04, .102617D+04,
     +  .785180D+03, .601006D+03, .460146D+03, .352476D+03,
     +  .270122D+03, .207189D+03, .158424D+03, .121730D+03,
     +  .936283D+02, .721217D+02, .556385D+02, .430076D+02,
     +  .333399D+02, .259004D+02, .201807D+02, .157809D+02,
     +  .123860D+02, .976293D+01, .772719D+01, .614563D+01,
     +  .490835D+01, .393702D+01, .316984D+01, .256112D+01,
     +  .207478D+01, .168585D+01, .136965D+01, .111494D+01,
     +  .906096D+00, .736181D+00, .596986D+00, .482887D+00,
     +  .389293D+00, .312596D+00, .249826D+00, .198594D+00,
     +  .156925D+00, .123189D+00, .960071D-01, .742405D-01,
     +  .569266D-01, .432439D-01, .325699D-01, .242249D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .178084D-01, .129272D-01, .925670D-02, .653141D-02,
     +  .453494D-02, .309458D-02, .207204D-02, .135933D-02,
     +  .871029D-03, .547224D-03, .333998D-03, .198566D-03,
     +  .114843D-03, .647348D-04, .356429D-04, .193505D-04,
     +  .104606D-04, .570153D-05, .315654D-05, .176413D-05,
     +  .959488D-06, .482919D-06, .205215D-06, .586659D-07,
     +  .416399D-08, .000000D+00, .200207D+06, .227594D+06,
     +  .173167D+06, .131730D+06, .100202D+06, .762023D+05,
     +  .579479D+05, .440567D+05, .334938D+05, .254581D+05,
     +  .193495D+05, .147037D+05, .111732D+05, .848883D+04,
     +  .644944D+04, .489922D+04, .372180D+04, .282699D+04,
     +  .214753D+04, .163128D+04, .123936D+04, .941624D+03,
     +  .715619D+03, .543939D+03, .413620D+03, .314635D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .239536D+03, .181759D+03, .138599D+03, .105788D+03,
     +  .808609D+02, .618976D+02, .474741D+02, .365167D+02,
     +  .281477D+02, .217616D+02, .168858D+02, .131513D+02,
     +  .102873D+02, .808078D+01, .637906D+01, .505738D+01,
     +  .402721D+01, .321938D+01, .258297D+01, .207810D+01,
     +  .167721D+01, .135358D+01, .109475D+01, .884010D+00,
     +  .713764D+00, .575272D+00, .462539D+00, .370700D+00,
     +  .295953D+00, .235187D+00, .185919D+00, .146108D+00,
     +  .114084D+00, .884442D-01, .680402D-01, .519096D-01,
     +  .392372D-01, .294096D-01, .217706D-01, .159303D-01,
     +  .115125D-01, .820867D-02, .576895D-02, .399107D-02,
     +  .271496D-02, .181347D-02, .118807D-02, .761322D-03,
     +  .479347D-03, .294148D-03, .176657D-03, .103927D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .601798D-04, .344866D-04, .197933D-04, .114728D-04,
     +  .675465D-05, .401801D-05, .237049D-05, .133158D-05,
     +  .677367D-06, .285267D-06, .795099D-07, .576405D-08,
     +  .000000D+00, .410631D+06, .315325D+06, .238625D+06,
     +  .180530D+06, .136555D+06, .103259D+06, .780685D+05,
     +  .590046D+05, .445885D+05, .336841D+05, .254423D+05,
     +  .192114D+05, .145043D+05, .109474D+05, .826169D+04,
     +  .623325D+04, .470242D+04, .354674D+04, .267498D+04,
     +  .201715D+04, .152117D+04, .114705D+04, .865065D+03,
     +  .652432D+03, .492206D+03, .371419D+03, .280477D+03,
     +  .211056D+03, .159602D+03, .120796D+03, .915501D+02,
     +  .694821D+02, .528321D+02, .402882D+02, .307855D+02,
     +  .235947D+02, .181496D+02, .140138D+02, .108679D+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .846428D+01, .662555D+01, .520915D+01, .411398D+01,
     +  .326217D+01, .259646D+01, .207260D+01, .165995D+01,
     +  .132949D+01, .106732D+01, .855575D+00, .685871D+00,
     +  .548922D+00, .438317D+00, .348919D+00, .276717D+00,
     +  .218469D+00, .171596D+00, .134002D+00, .103981D+00,
     +  .801186D-01, .612634D-01, .464618D-01, .349113D-01,
     +  .260143D-01, .191441D-01, .139262D-01, .100046D-01,
     +  .709079D-02, .495268D-02, .340447D-02, .230016D-02,
     +  .152499D-02, .990696D-03, .628536D-03, .390917D-03,
     +  .236072D-03, .138717D-03, .791462D-04, .438574D-04,
     +  .236034D-04, .124066D-04, .641151D-05, .329183D-05,
     +  .169596D-05, .880046D-06, .447538D-06, .214229D-06,
     +  .877662D-07, .244700D-07, .171949D-08, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .555861D+06, .425048D+06, .320073D+06, .240936D+06,
     +  .181318D+06, .136396D+06, .102576D+06, .771110D+05,
     +  .579518D+05, .435353D+05, .326964D+05, .245462D+05,
     +  .184228D+05, .138216D+05, .103670D+05, .777306D+04,
     +  .582690D+04, .436653D+04, .327163D+04, .245058D+04,
     +  .183544D+04, .137444D+04, .102924D+04, .770688D+03,
     +  .577177D+03, .432305D+03, .323999D+03, .241917D+03,
     +  .181521D+03, .136309D+03, .102486D+03, .771582D+02,
     +  .581932D+02, .440157D+02, .333578D+02, .253561D+02,
     +  .193438D+02, .148132D+02, .113936D+02, .880149D+01,
     +  .683380D+01, .532987D+01, .417593D+01, .328538D+01,
     +  .259472D+01, .205542D+01, .163387D+01, .129889D+01,
     +  .103518D+01, .823850D+00, .655780D+00, .521200D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .413338D+00, .326825D+00, .257478D+00, .201954D+00,
     +  .157602D+00, .122294D+00, .943014D-01, .722116D-01,
     +  .548806D-01, .413714D-01, .309010D-01, .228912D-01,
     +  .167476D-01, .121131D-01, .865312D-02, .609933D-02,
     +  .423761D-02, .289826D-02, .194900D-02, .128684D-02,
     +  .833189D-03, .527490D-03, .327972D-03, .198563D-03,
     +  .117472D-03, .679299D-04, .385226D-04, .215177D-04,
     +  .119552D-04, .666702D-05, .375619D-05, .213551D-05,
     +  .120638D-05, .651143D-06, .319140D-06, .128850D-06,
     +  .341778D-07, .250801D-08, .000000D+00, .736037D+06,
     +  .560601D+06, .420193D+06, .314815D+06, .235782D+06,
     +  .176504D+06, .132083D+06, .987923D+05, .738656D+05,
     +  .552010D+05, .412376D+05, .307910D+05, .229826D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .171460D+05, .127871D+05, .953190D+04, .710308D+04,
     +  .529077D+04, .393976D+04, .293258D+04, .218245D+04,
     +  .162368D+04, .120785D+04, .898340D+03, .668167D+03,
     +  .496962D+03, .369818D+03, .274113D+03, .204174D+03,
     +  .152184D+03, .113561D+03, .848466D+02, .634993D+02,
     +  .476578D+02, .358356D+02, .270259D+02, .204552D+02,
     +  .155409D+02, .118593D+02, .908943D+01, .700234D+01,
     +  .541906D+01, .421319D+01, .328951D+01, .257844D+01,
     +  .202733D+01, .159975D+01, .126251D+01, .999015D+00,
     +  .789445D+00, .624023D+00, .492562D+00, .387985D+00,
     +  .304735D+00, .238494D+00, .185848D+00, .144103D+00,
     +  .111110D+00, .851403D-01, .647928D-01, .489410D-01,
     +  .366709D-01, .272256D-01, .200491D-01, .145819D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .104855D-01, .744770D-02, .522047D-02, .360750D-02,
     +  .245468D-02, .164289D-02, .108021D-02, .697083D-03,
     +  .440426D-03, .273797D-03, .166222D-03, .990273D-04,
     +  .580233D-04, .336210D-04, .193936D-04, .112510D-04,
     +  .660811D-05, .392708D-05, .233937D-05, .136481D-05,
     +  .749067D-06, .367192D-06, .146033D-06, .377296D-07,
     +  .282440D-08, .000000D+00, .957140D+06, .726256D+06,
     +  .541945D+06, .404206D+06, .301348D+06, .224539D+06,
     +  .167235D+06, .124485D+06, .926211D+05, .688738D+05,
     +  .511919D+05, .380273D+05, .282353D+05, .209526D+05,
     +  .155414D+05, .115211D+05, .853716D+04, .632257D+04,
     +  .468065D+04, .346338D+04, .256189D+04, .189423D+04,
     +  .140027D+04, .103480D+04, .764655D+03, .564952D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .417580D+03, .307364D+03, .227348D+03, .168260D+03,
     +  .124657D+03, .924612D+02, .686893D+02, .511717D+02,
     +  .381898D+02, .285847D+02, .214713D+02, .161894D+02,
     +  .122605D+02, .932585D+01, .713032D+01, .547674D+01,
     +  .422628D+01, .327535D+01, .254852D+01, .198925D+01,
     +  .155845D+01, .122115D+01, .959509D+00, .752946D+00,
     +  .591088D+00, .463406D+00, .362575D+00, .282894D+00,
     +  .219952D+00, .170292D+00, .131196D+00, .100518D+00,
     +  .765418D-01, .578884D-01, .434577D-01, .323649D-01,
     +  .238837D-01, .174833D-01, .126405D-01, .903633D-02,
     +  .638158D-02, .444816D-02, .305721D-02, .206961D-02,
     +  .137864D-02, .902761D-03, .580720D-03, .366242D-03,
     +  .227714D-03, .138675D-03, .832137D-04, .493884D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .291879D-04, .173018D-04, .103749D-04, .631077D-05,
     +  .386799D-05, .235586D-05, .138885D-05, .761999D-06,
     +  .369376D-06, .143733D-06, .360971D-07, .274722D-08,
     +  .000000D+00, .122553D+07, .926524D+06, .688420D+06,
     +  .511221D+06, .379448D+06, .281465D+06, .208678D+06,
     +  .154615D+06, .114498D+06, .847351D+05, .626752D+05,
     +  .463276D+05, .342255D+05, .252680D+05, .186448D+05,
     +  .137486D+05, .101328D+05, .746318D+04, .549420D+04,
     +  .404225D+04, .297276D+04, .218507D+04, .160556D+04,
     +  .117925D+04, .865967D+03, .635738D+03, .466867D+03,
     +  .341356D+03, .250806D+03, .184366D+03, .135650D+03,
     +  .999150D+02, .737030D+02, .545167D+02, .403933D+02,
     +  .300151D+02, .223814D+02, .167524D+02, .125940D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .950945D+01, .721761D+01, .550346D+01, .421612D+01,
     +  .324396D+01, .250603D+01, .194218D+01, .151090D+01,
     +  .117560D+01, .917350D+00, .714923D+00, .557437D+00,
     +  .434098D+00, .337393D+00, .261519D+00, .202013D+00,
     +  .155397D+00, .118958D+00, .905675D-01, .685335D-01,
     +  .515110D-01, .384329D-01, .284490D-01, .208671D-01,
     +  .151839D-01, .109128D-01, .775563D-02, .544571D-02,
     +  .377463D-02, .258036D-02, .173797D-02, .115240D-02,
     +  .751644D-03, .482098D-03, .303601D-03, .188879D-03,
     +  .115440D-03, .697979D-04, .419536D-04, .252492D-04,
     +  .153192D-04, .942396D-05, .587244D-05, .366534D-05,
     +  .225472D-05, .132996D-05, .724167D-06, .345498D-06,
     +  .131181D-06, .319959D-07, .247318D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .154786D+07, .116607D+07, .862783D+06, .637992D+06,
     +  .471508D+06, .348229D+06, .257035D+06, .189589D+06,
     +  .139757D+06, .102949D+06, .757892D+05, .557534D+05,
     +  .409888D+05, .301117D+05, .221072D+05, .162184D+05,
     +  .118910D+05, .871179D+04, .637886D+04, .466740D+04,
     +  .341336D+04, .249466D+04, .182244D+04, .133066D+04,
     +  .971296D+03, .708699D+03, .517214D+03, .375746D+03,
     +  .274302D+03, .200324D+03, .146416D+03, .107123D+03,
     +  .784827D+02, .576547D+02, .424220D+02, .313023D+02,
     +  .231770D+02, .172254D+02, .128578D+02, .963991D+01,
     +  .726479D+01, .550027D+01, .418395D+01, .319661D+01,
     +  .245220D+01, .188724D+01, .145805D+01, .112668D+01,
     +  .873207D+00, .675917D+00, .523500D+00, .404970D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .312688D+00, .240794D+00, .184804D+00, .141250D+00,
     +  .107444D+00, .812877D-01, .611281D-01, .456613D-01,
     +  .338599D-01, .249120D-01, .181623D-01, .131370D-01,
     +  .938568D-02, .663139D-02, .462972D-02, .319126D-02,
     +  .217000D-02, .145435D-02, .960052D-03, .623878D-03,
     +  .399116D-03, .251087D-03, .156387D-03, .959797D-04,
     +  .584963D-04, .356004D-04, .217865D-04, .134818D-04,
     +  .845889D-05, .535886D-05, .337890D-05, .208441D-05,
     +  .122359D-05, .658703D-06, .308571D-06, .114187D-06,
     +  .270530D-07, .212272D-08, .000000D+00, .193090D+07,
     +  .144963D+07, .106820D+07, .786623D+06, .578914D+06,
     +  .425736D+06, .312888D+06, .229776D+06, .168630D+06,
     +  .123658D+06, .906175D+05, .663518D+05, .485501D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .354954D+05, .259326D+05, .189306D+05, .138095D+05,
     +  .100655D+05, .733159D+04, .533604D+04, .388127D+04,
     +  .282105D+04, .204935D+04, .148782D+04, .107972D+04,
     +  .783148D+03, .568116D+03, .410173D+03, .297579D+03,
     +  .215957D+03, .156834D+03, .114002D+03, .829751D+02,
     +  .605518D+02, .442550D+02, .324343D+02, .238517D+02,
     +  .176057D+02, .130515D+02, .971783D+01, .727311D+01,
     +  .546868D+01, .413133D+01, .313478D+01, .238832D+01,
     +  .182556D+01, .140087D+01, .107517D+01, .827719D+00,
     +  .636433D+00, .489664D+00, .376316D+00, .288674D+00,
     +  .220869D+00, .168426D+00, .127915D+00, .966874D-01,
     +  .726928D-01, .543256D-01, .403304D-01, .297243D-01,
     +  .217370D-01, .157521D-01, .113259D-01, .804403D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .565050D-02, .392259D-02, .268906D-02, .181902D-02,
     +  .121328D-02, .797532D-03, .516509D-03, .329708D-03,
     +  .207316D-03, .129348D-03, .797626D-04, .490175D-04,
     +  .301947D-04, .187607D-04, .118031D-04, .751738D-05,
     +  .481450D-05, .304995D-05, .187825D-05, .109367D-05,
     +  .580779D-06, .266773D-06, .961694D-07, .221451D-07,
     +  .176327D-08, .000000D+00, .238146D+07, .178187D+07,
     +  .130776D+07, .959132D+06, .702973D+06, .514819D+06,
     +  .376762D+06, .275501D+06, .201309D+06, .146972D+06,
     +  .107221D+06, .781536D+05, .569222D+05, .414218D+05,
     +  .301187D+05, .218803D+05, .158829D+05, .115191D+05,
     +  .834786D+04, .604439D+04, .437344D+04, .316182D+04,
     +  .228444D+04, .164934D+04, .119021D+04, .858347D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .619047D+03, .444268D+03, .320382D+03, .231091D+03,
     +  .166788D+03, .120479D+03, .871326D+02, .631790D+02,
     +  .458755D+02, .334021D+02, .244014D+02, .178922D+02,
     +  .131755D+02, .974465D+01, .724436D+01, .541056D+01,
     +  .406002D+01, .306004D+01, .231578D+01, .175828D+01,
     +  .134029D+01, .102184D+01, .781484D+00, .596928D+00,
     +  .456274D+00, .348384D+00, .265528D+00, .201860D+00,
     +  .152953D+00, .115432D+00, .867052D-01, .647827D-01,
     +  .481153D-01, .355013D-01, .260062D-01, .189034D-01,
     +  .136166D-01, .973263D-02, .687191D-02, .479943D-02,
     +  .331318D-02, .225911D-02, .152046D-02, .100947D-02,
     +  .660936D-03, .426743D-03, .271937D-03, .170997D-03,
     +  .106938D-03, .662913D-04, .410868D-04, .256042D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .161256D-04, .102843D-04, .662263D-05, .426940D-05,
     +  .270676D-05, .165887D-05, .956058D-06, .500083D-06,
     +  .225050D-06, .790235D-07, .177007D-07, .142981D-08,
     +  .000000D+00, .290615D+07, .216729D+07, .158437D+07,
     +  .115739D+07, .844868D+06, .616214D+06, .449102D+06,
     +  .327024D+06, .237942D+06, .172970D+06, .125637D+06,
     +  .911710D+05, .661047D+05, .478844D+05, .346564D+05,
     +  .250584D+05, .181029D+05, .130654D+05, .942173D+04,
     +  .678773D+04, .488624D+04, .351424D+04, .252568D+04,
     +  .181373D+04, .130170D+04, .933527D+03, .669471D+03,
     +  .477665D+03, .342463D+03, .245562D+03, .176171D+03,
     +  .126486D+03, .909143D+02, .655124D+02, .472708D+02,
     +  .341998D+02, .248244D+02, .180853D+02, .132316D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .972258D+01, .718085D+01, .532810D+01, .397196D+01,
     +  .297406D+01, .223597D+01, .168655D+01, .127724D+01,
     +  .967395D+00, .735043D+00, .557808D+00, .423624D+00,
     +  .321382D+00, .243386D+00, .183856D+00, .138433D+00,
     +  .103819D+00, .774978D-01, .575457D-01, .424779D-01,
     +  .311510D-01, .226815D-01, .163880D-01, .117344D-01,
     +  .833810D-02, .585312D-02, .406472D-02, .279059D-02,
     +  .189281D-02, .126771D-02, .837984D-03, .546648D-03,
     +  .352015D-03, .224040D-03, .140964D-03, .884125D-04,
     +  .551214D-04, .344571D-04, .217080D-04, .138349D-04,
     +  .892008D-05, .578846D-05, .374353D-05, .236835D-05,
     +  .144126D-05, .820913D-06, .422528D-06, .186196D-06,
     +  .636899D-07, .138895D-07, .113793D-08, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .319388D+05, .489190D+05, .384588D+05, .302353D+05,
     +  .237702D+05, .186875D+05, .146916D+05, .115502D+05,
     +  .908057D+04, .713900D+04, .561262D+04, .441264D+04,
     +  .346926D+04, .272762D+04, .214457D+04, .168621D+04,
     +  .132587D+04, .104259D+04, .819883D+03, .644803D+03,
     +  .507163D+03, .398955D+03, .313885D+03, .247004D+03,
     +  .194421D+03, .153078D+03, .120571D+03, .946876D+02,
     +  .746603D+02, .589059D+02, .465102D+02, .367546D+02,
     +  .290740D+02, .230405D+02, .182724D+02, .145130D+02,
     +  .115459D+02, .920081D+01, .734433D+01, .587110D+01,
     +  .470105D+01, .376790D+01, .302206D+01, .242435D+01,
     +  .194418D+01, .155766D+01, .124709D+01, .994865D+00,
     +  .792473D+00, .628168D+00, .496304D+00, .390274D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .305272D+00, .237376D+00, .183383D+00, .140665D+00,
     +  .107066D+00, .808124D-01, .604479D-01, .447769D-01,
     +  .328221D-01, .237877D-01, .170296D-01, .120497D-01,
     +  .838596D-02, .574457D-02, .386745D-02, .255436D-02,
     +  .165169D-02, .104302D-02, .641352D-03, .382620D-03,
     +  .220387D-03, .121758D-03, .644157D-04, .319823D-04,
     +  .147217D-04, .610844D-05, .215822D-05, .551238D-06,
     +  .149019D-07, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .101930D+06,
     +  .800012D+05, .620871D+05, .481876D+05, .374050D+05,
     +  .290368D+05, .225438D+05, .175037D+05, .135923D+05,
     +  .105556D+05, .819848D+04, .636809D+04, .494709D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .384342D+04, .298645D+04, .232073D+04, .180372D+04,
     +  .140202D+04, .108999D+04, .847507D+03, .659129D+03,
     +  .512706D+03, .398929D+03, .310472D+03, .241720D+03,
     +  .188257D+03, .146702D+03, .113969D+03, .889220D+02,
     +  .694247D+02, .542523D+02, .424342D+02, .332290D+02,
     +  .260707D+02, .204733D+02, .161034D+02, .126900D+02,
     +  .100181D+02, .792414D+01, .627809D+01, .498376D+01,
     +  .396100D+01, .315138D+01, .250839D+01, .199673D+01,
     +  .158838D+01, .126324D+01, .100128D+01, .792907D+00,
     +  .625017D+00, .491315D+00, .384550D+00, .299552D+00,
     +  .232078D+00, .178744D+00, .136766D+00, .103910D+00,
     +  .783426D-01, .585884D-01, .434285D-01, .318922D-01,
     +  .231854D-01, .166745D-01, .118737D-01, .833398D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .577092D-02, .393910D-02, .264669D-02, .174862D-02,
     +  .113356D-02, .719909D-03, .446242D-03, .269146D-03,
     +  .156390D-03, .873759D-04, .453884D-04, .209917D-04,
     +  .735810D-05, .208887D-06, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .152942D+06, .119169D+06,
     +  .917187D+05, .705903D+05, .543344D+05, .418209D+05,
     +  .321925D+05, .247803D+05, .190767D+05, .146856D+05,
     +  .113066D+05, .870486D+04, .670267D+04, .516096D+04,
     +  .397443D+04, .306071D+04, .235744D+04, .181580D+04,
     +  .139888D+04, .107775D+04, .830550D+03, .640119D+03,
     +  .493500D+03, .380535D+03, .293540D+03, .226504D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .174889D+03, .134598D+03, .104053D+03, .804909D+02,
     +  .623254D+02, .483035D+02, .374822D+02, .291427D+02,
     +  .226815D+02, .176821D+02, .138125D+02, .108100D+02,
     +  .847831D+01, .666125D+01, .524521D+01, .413589D+01,
     +  .326538D+01, .257988D+01, .203907D+01, .161096D+01,
     +  .127291D+01, .100263D+01, .789362D+00, .618769D+00,
     +  .483899D+00, .376924D+00, .292323D+00, .225573D+00,
     +  .173123D+00, .132056D+00, .100075D+00, .752989D-01,
     +  .562366D-01, .416575D-01, .305980D-01, .222702D-01,
     +  .160527D-01, .114721D-01, .809437D-02, .564481D-02,
     +  .388993D-02, .264650D-02, .177757D-02, .117731D-02,
     +  .769248D-03, .495198D-03, .314347D-03, .196123D-03,
     +  .121316D-03, .735945D-04, .440883D-04, .259561D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .150608D-04, .853738D-05, .473798D-05, .253495D-05,
     +  .130089D-05, .622817D-06, .275133D-06, .105738D-06,
     +  .343896D-07, .878675D-08, .183406D-08, .229204D-10,
     +  .000000D+00, .216550D+06, .167815D+06, .128350D+06,
     +  .981548D+05, .750646D+05, .573986D+05, .438912D+05,
     +  .335582D+05, .256585D+05, .196160D+05, .149971D+05,
     +  .114644D+05, .876432D+04, .669945D+04, .512143D+04,
     +  .391474D+04, .299265D+04, .228760D+04, .174887D+04,
     +  .133697D+04, .102228D+04, .781685D+03, .597861D+03,
     +  .457314D+03, .349922D+03, .267816D+03, .205104D+03,
     +  .156539D+03, .120018D+03, .920716D+02, .707018D+02,
     +  .543399D+02, .418160D+02, .322429D+02, .248871D+02,
     +  .192420D+02, .149087D+02, .115736D+02, .900502D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .701959D+01, .548503D+01, .429254D+01, .336432D+01,
     +  .263920D+01, .207170D+01, .162591D+01, .127663D+01,
     +  .999423D+00, .782326D+00, .609878D+00, .474482D+00,
     +  .367790D+00, .283948D+00, .218193D+00, .166819D+00,
     +  .126808D+00, .958051D-01, .718974D-01, .535828D-01,
     +  .396281D-01, .290792D-01, .211586D-01, .152586D-01,
     +  .109194D-01, .772293D-02, .540505D-02, .374356D-02,
     +  .256422D-02, .173779D-02, .116432D-02, .772167D-03,
     +  .506628D-03, .329499D-03, .212101D-03, .136484D-03,
     +  .871369D-04, .557300D-04, .356681D-04, .230029D-04,
     +  .148848D-04, .972634D-05, .634632D-05, .412423D-05,
     +  .262306D-05, .161216D-05, .925035D-06, .477328D-06,
     +  .204673D-06, .586452D-07, .416389D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .200139D+06, .227560D+06, .173138D+06, .131703D+06,
     +  .100178D+06, .761808D+05, .579286D+05, .440394D+05,
     +  .334784D+05, .254442D+05, .193371D+05, .146926D+05,
     +  .111632D+05, .847988D+04, .644141D+04, .489202D+04,
     +  .371534D+04, .282120D+04, .214233D+04, .162661D+04,
     +  .123517D+04, .937857D+03, .712230D+03, .540890D+03,
     +  .410872D+03, .312156D+03, .237297D+03, .179737D+03,
     +  .136766D+03, .104123D+03, .793451D+02, .605144D+02,
     +  .462081D+02, .353547D+02, .270782D+02, .207745D+02,
     +  .159726D+02, .123050D+02, .950184D+01, .735168D+01,
     +  .570252D+01, .443071D+01, .344826D+01, .268657D+01,
     +  .209493D+01, .163358D+01, .127476D+01, .991994D+00,
     +  .772111D+00, .598630D+00, .463321D+00, .357376D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .274633D+00, .210120D+00, .159999D+00, .121171D+00,
     +  .912348D-01, .682589D-01, .507357D-01, .374379D-01,
     +  .274230D-01, .199280D-01, .143607D-01, .102757D-01,
     +  .727213D-02, .509673D-02, .353844D-02, .243221D-02,
     +  .165633D-02, .111689D-02, .746902D-03, .495280D-03,
     +  .326430D-03, .213677D-03, .140290D-03, .918045D-04,
     +  .604403D-04, .399979D-04, .267545D-04, .179993D-04,
     +  .122184D-04, .826492D-05, .553753D-05, .361077D-05,
     +  .225586D-05, .130590D-05, .673254D-06, .284872D-06,
     +  .794949D-07, .576398D-08, .000000D+00, .410590D+06,
     +  .315289D+06, .238592D+06, .180501D+06, .136529D+06,
     +  .103236D+06, .780474D+05, .589858D+05, .445715D+05,
     +  .336689D+05, .254287D+05, .191992D+05, .144934D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .109376D+05, .825293D+04, .622540D+04, .469539D+04,
     +  .354043D+04, .266932D+04, .201207D+04, .151661D+04,
     +  .114295D+04, .861385D+03, .649123D+03, .489227D+03,
     +  .368735D+03, .278056D+03, .208872D+03, .157625D+03,
     +  .119005D+03, .899230D+02, .680011D+02, .514809D+02,
     +  .390522D+02, .296523D+02, .225537D+02, .171913D+02,
     +  .131305D+02, .100531D+02, .771285D+01, .593308D+01,
     +  .457234D+01, .353005D+01, .272888D+01, .211178D+01,
     +  .163460D+01, .126651D+01, .978773D+00, .756804D+00,
     +  .583033D+00, .448511D+00, .343953D+00, .262864D+00,
     +  .200070D+00, .151598D+00, .114280D+00, .856750D-01,
     +  .638440D-01, .472800D-01, .347721D-01, .253940D-01,
     +  .184052D-01, .132321D-01, .944900D-02, .667476D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .467030D-02, .323699D-02, .222095D-02, .150886D-02,
     +  .101404D-02, .674645D-03, .443852D-03, .289012D-03,
     +  .185817D-03, .118860D-03, .749640D-04, .469211D-04,
     +  .290668D-04, .178985D-04, .109135D-04, .663188D-05,
     +  .399005D-05, .238285D-05, .139518D-05, .796379D-06,
     +  .429024D-06, .211300D-06, .874884D-07, .244594D-07,
     +  .171944D-08, .000000D+00, .555817D+06, .425008D+06,
     +  .320037D+06, .240904D+06, .181289D+06, .136371D+06,
     +  .102553D+06, .770904D+05, .579333D+05, .435188D+05,
     +  .326816D+05, .245329D+05, .184109D+05, .138109D+05,
     +  .103575D+05, .776453D+04, .581926D+04, .435968D+04,
     +  .326549D+04, .244507D+04, .183050D+04, .137000D+04,
     +  .102526D+04, .767112D+03, .573961D+03, .429411D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .321392D+03, .239569D+03, .179400D+03, .134391D+03,
     +  .100748D+03, .755804D+02, .567579D+02, .427075D+02,
     +  .321632D+02, .242635D+02, .183430D+02, .138957D+02,
     +  .105523D+02, .803044D+01, .612799D+01, .468533D+01,
     +  .358920D+01, .275354D+01, .211502D+01, .162524D+01,
     +  .125041D+01, .959704D+00, .737162D+00, .564263D+00,
     +  .431396D+00, .328870D+00, .249907D+00, .189175D+00,
     +  .142597D+00, .106963D+00, .798125D-01, .592124D-01,
     +  .436676D-01, .319916D-01, .232802D-01, .168190D-01,
     +  .120566D-01, .858784D-02, .605331D-02, .422830D-02,
     +  .292714D-02, .200722D-02, .136381D-02, .917502D-03,
     +  .611698D-03, .403874D-03, .264368D-03, .171354D-03,
     +  .110837D-03, .710285D-04, .454219D-04, .289698D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .185146D-04, .118318D-04, .759324D-05, .485788D-05,
     +  .308508D-05, .191620D-05, .114619D-05, .638011D-06,
     +  .317093D-06, .128658D-06, .341706D-07, .250798D-08,
     +  .000000D+00, .735989D+06, .560557D+06, .420154D+06,
     +  .314780D+06, .235751D+06, .176477D+06, .132058D+06,
     +  .987699D+05, .738456D+05, .551831D+05, .412215D+05,
     +  .307767D+05, .229697D+05, .171344D+05, .127768D+05,
     +  .952266D+04, .709480D+04, .528335D+04, .393312D+04,
     +  .292663D+04, .217711D+04, .161890D+04, .120356D+04,
     +  .894489D+03, .664709D+03, .493854D+03, .367022D+03,
     +  .271599D+03, .201908D+03, .150138D+03, .111712D+03,
     +  .831727D+02, .619815D+02, .462791D+02, .345817D+02,
     +  .258841D+02, .194144D+02, .145920D+02, .109941D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .830143D+01, .628574D+01, .476917D+01, .362580D+01,
     +  .276096D+01, .210526D+01, .160620D+01, .122717D+01,
     +  .935461D+00, .713813D+00, .542884D+00, .412476D+00,
     +  .312563D+00, .236139D+00, .177757D+00, .133269D+00,
     +  .994500D-01, .738388D-01, .545220D-01, .400273D-01,
     +  .291998D-01, .211634D-01, .152326D-01, .108812D-01,
     +  .772580D-02, .542985D-02, .378324D-02, .261352D-02,
     +  .178934D-02, .121458D-02, .816977D-03, .545115D-03,
     +  .360684D-03, .236990D-03, .154581D-03, .100889D-03,
     +  .654955D-04, .426063D-04, .277850D-04, .182364D-04,
     +  .120186D-04, .796438D-05, .525989D-05, .343288D-05,
     +  .217990D-05, .132164D-05, .739779D-06, .365765D-06,
     +  .145901D-06, .377246D-07, .282437D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .957088D+06, .726209D+06, .541902D+06, .404169D+06,
     +  .301315D+06, .224509D+06, .167208D+06, .124460D+06,
     +  .925994D+05, .688544D+05, .511745D+05, .380117D+05,
     +  .282214D+05, .209401D+05, .155302D+05, .115111D+05,
     +  .852822D+04, .631457D+04, .467349D+04, .345697D+04,
     +  .255615D+04, .188909D+04, .139566D+04, .103067D+04,
     +  .760949D+03, .561625D+03, .414591D+03, .304682D+03,
     +  .224935D+03, .166087D+03, .122697D+03, .906924D+02,
     +  .670905D+02, .497247D+02, .368789D+02, .273963D+02,
     +  .203933D+02, .152117D+02, .113742D+02, .852356D+01,
     +  .640545D+01, .482379D+01, .364027D+01, .275183D+01,
     +  .208328D+01, .157826D+01, .119755D+01, .906719D+00,
     +  .687348D+00, .519404D+00, .392179D+00, .295389D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .221855D+00, .166055D+00, .123810D+00, .918996D-01,
     +  .678819D-01, .498757D-01, .364418D-01, .264633D-01,
     +  .190967D-01, .136885D-01, .973997D-02, .689024D-02,
     +  .482609D-02, .335228D-02, .230961D-02, .157781D-02,
     +  .106927D-02, .718647D-03, .479570D-03, .317773D-03,
     +  .209440D-03, .137355D-03, .903501D-04, .593112D-04,
     +  .391380D-04, .259764D-04, .173872D-04, .117003D-04,
     +  .790462D-05, .530855D-05, .350497D-05, .224019D-05,
     +  .135795D-05, .755444D-06, .368383D-06, .143642D-06,
     +  .360937D-07, .274720D-08, .000000D+00, .122548D+07,
     +  .926473D+06, .688374D+06, .511180D+06, .379411D+06,
     +  .281432D+06, .208649D+06, .154589D+06, .114475D+06,
     +  .847141D+05, .626564D+05, .463108D+05, .342105D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .252545D+05, .186328D+05, .137378D+05, .101232D+05,
     +  .745457D+04, .548650D+04, .403536D+04, .296660D+04,
     +  .217955D+04, .160062D+04, .117483D+04, .862007D+03,
     +  .632187D+03, .463684D+03, .338504D+03, .248246D+03,
     +  .182065D+03, .133581D+03, .980526D+02, .720251D+02,
     +  .530034D+02, .390280D+02, .287828D+02, .212690D+02,
     +  .157488D+02, .116894D+02, .869554D+01, .648694D+01,
     +  .484967D+01, .363342D+01, .272710D+01, .205004D+01,
     +  .154231D+01, .116235D+01, .874177D+00, .658362D+00,
     +  .494318D+00, .370912D+00, .277676D+00, .207318D+00,
     +  .154282D+00, .114387D+00, .844435D-01, .620452D-01,
     +  .453544D-01, .329744D-01, .238314D-01, .171186D-01,
     +  .122170D-01, .865641D-02, .609941D-02, .425622D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .294637D-02, .202382D-02, .137907D-02, .932769D-03,
     +  .626199D-03, .417817D-03, .277185D-03, .183214D-03,
     +  .120768D-03, .800211D-04, .530634D-04, .354525D-04,
     +  .238727D-04, .162207D-04, .110756D-04, .757211D-05,
     +  .512937D-05, .339937D-05, .217103D-05, .130791D-05,
     +  .719554D-06, .344809D-06, .131119D-06, .319935D-07,
     +  .247316D-08, .000000D+00, .154779D+07, .116602D+07,
     +  .862734D+06, .637948D+06, .471468D+06, .348194D+06,
     +  .257003D+06, .189560D+06, .139732D+06, .102927D+06,
     +  .757690D+05, .557353D+05, .409726D+05, .300972D+05,
     +  .220943D+05, .162069D+05, .118806D+05, .870255D+04,
     +  .637060D+04, .466002D+04, .340676D+04, .248876D+04,
     +  .181717D+04, .132594D+04, .967076D+03, .704922D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .513833D+03, .372723D+03, .271593D+03, .197896D+03,
     +  .144238D+03, .105168D+03, .767277D+02, .560777D+02,
     +  .410049D+02, .300290D+02, .220331D+02, .161988D+02,
     +  .119377D+02, .881702D+01, .653074D+01, .484779D+01,
     +  .360641D+01, .268793D+01, .200663D+01, .149935D+01,
     +  .112240D+01, .838540D+00, .627437D+00, .468097D+00,
     +  .349053D+00, .259723D+00, .192762D+00, .142618D+00,
     +  .105140D+00, .771885D-01, .564097D-01, .410197D-01,
     +  .296714D-01, .213390D-01, .152556D-01, .108379D-01,
     +  .764551D-02, .536467D-02, .372878D-02, .257197D-02,
     +  .176098D-02, .119674D-02, .807772D-03, .541632D-03,
     +  .361332D-03, .240004D-03, .159104D-03, .105407D-03,
     +  .703359D-04, .470795D-04, .318016D-04, .216729D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .148969D-04, .102755D-04, .707430D-05, .480940D-05,
     +  .318456D-05, .202402D-05, .120789D-05, .655464D-06,
     +  .308094D-06, .114145D-06, .270514D-07, .212271D-08,
     +  .000000D+00, .193084D+07, .144957D+07, .106815D+07,
     +  .786575D+06, .578871D+06, .425698D+06, .312854D+06,
     +  .229746D+06, .168602D+06, .123633D+06, .905957D+05,
     +  .663323D+05, .485327D+05, .354798D+05, .259187D+05,
     +  .189182D+05, .137984D+05, .100556D+05, .732274D+04,
     +  .532815D+04, .387422D+04, .281475D+04, .204373D+04,
     +  .148279D+04, .107523D+04, .779140D+03, .564535D+03,
     +  .406978D+03, .294722D+03, .213402D+03, .154549D+03,
     +  .111958D+03, .811454D+02, .589138D+02, .427890D+02,
     +  .311229D+02, .226793D+02, .165591D+02, .121187D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .888857D+01, .653802D+01, .481958D+01, .356067D+01,
     +  .263565D+01, .195424D+01, .145038D+01, .107856D+01,
     +  .800503D+00, .595130D+00, .441181D+00, .326942D+00,
     +  .241794D+00, .178387D+00, .131213D+00, .961806D-01,
     +  .702177D-01, .510364D-01, .369158D-01, .265650D-01,
     +  .190094D-01, .135242D-01, .956301D-02, .671577D-02,
     +  .469213D-02, .324815D-02, .223219D-02, .152335D-02,
     +  .103244D-02, .695453D-03, .465797D-03, .310736D-03,
     +  .206690D-03, .137451D-03, .915291D-04, .614982D-04,
     +  .415247D-04, .283227D-04, .194943D-04, .135171D-04,
     +  .938698D-05, .648491D-05, .440930D-05, .290833D-05,
     +  .183479D-05, .108252D-05, .578511D-06, .266444D-06,
     +  .961405D-07, .221441D-07, .176326D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .238139D+07, .178180D+07, .130770D+07, .959081D+06,
     +  .702927D+06, .514778D+06, .376725D+06, .275468D+06,
     +  .201279D+06, .146946D+06, .107198D+06, .781327D+05,
     +  .569035D+05, .414051D+05, .301038D+05, .218670D+05,
     +  .158711D+05, .115085D+05, .833841D+04, .603596D+04,
     +  .436593D+04, .315512D+04, .227847D+04, .164401D+04,
     +  .118546D+04, .854105D+03, .615265D+03, .440900D+03,
     +  .317378D+03, .228411D+03, .164397D+03, .118347D+03,
     +  .852309D+02, .614828D+02, .443637D+02, .320558D+02,
     +  .232037D+02, .168285D+02, .122329D+02, .891161D+01,
     +  .651054D+01, .476680D+01, .349787D+01, .257175D+01,
     +  .189412D+01, .139643D+01, .103166D+01, .760729D+00,
     +  .561961D+00, .413969D+00, .304883D+00, .224115D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .164360D+00, .120191D+00, .875968D-01, .635931D-01,
     +  .459684D-01, .330724D-01, .236752D-01, .168557D-01,
     +  .119331D-01, .839804D-02, .587074D-02, .408398D-02,
     +  .281566D-02, .192783D-02, .131139D-02, .886436D-03,
     +  .595970D-03, .398798D-03, .266104D-03, .177306D-03,
     +  .118314D-03, .791987D-04, .535729D-04, .364668D-04,
     +  .250845D-04, .174046D-04, .121452D-04, .846839D-05,
     +  .585478D-05, .397139D-05, .260383D-05, .162768D-05,
     +  .948163D-06, .498500D-06, .224823D-06, .790039D-07,
     +  .177000D-07, .142980D-08, .000000D+00, .290607D+07,
     +  .216722D+07, .158431D+07, .115734D+07, .844819D+06,
     +  .616170D+06, .449062D+06, .326989D+06, .237911D+06,
     +  .172942D+06, .125611D+06, .911486D+05, .660847D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .478665D+05, .346405D+05, .250442D+05, .180903D+05,
     +  .130541D+05, .941166D+04, .677876D+04, .487824D+04,
     +  .350712D+04, .251933D+04, .180808D+04, .129667D+04,
     +  .929049D+03, .665485D+03, .474124D+03, .339312D+03,
     +  .242759D+03, .173677D+03, .124269D+03, .889434D+02,
     +  .637612D+02, .457164D+02, .328219D+02, .236046D+02,
     +  .170077D+02, .122819D+02, .888830D+01, .645050D+01,
     +  .469152D+01, .341982D+01, .249776D+01, .182753D+01,
     +  .133854D+01, .982517D+00, .719838D+00, .528400D+00,
     +  .386815D+00, .283136D+00, .206874D+00, .150817D+00,
     +  .109644D+00, .794531D-01, .573576D-01, .412335D-01,
     +  .295068D-01, .210121D-01, .148836D-01, .104849D-01,
     +  .734384D-02, .511030D-02, .353962D-02, .243050D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .165808D-02, .112435D-02, .758119D-03, .508839D-03,
     +  .340271D-03, .227178D-03, .151679D-03, .101587D-03,
     +  .683634D-04, .465452D-04, .319174D-04, .221146D-04,
     +  .154406D-04, .108212D-04, .755881D-05, .521889D-05,
     +  .352493D-05, .229373D-05, .141894D-05, .815336D-06,
     +  .421425D-06, .186040D-06, .636766D-07, .138890D-07,
     +  .113793D-08, .000000D+00, .163288D+07, .126754D+07,
     +  .971388D+06, .744435D+06, .570511D+06, .437223D+06,
     +  .335078D+06, .256799D+06, .196810D+06, .150836D+06,
     +  .115604D+06, .886032D+05, .679107D+05, .520525D+05,
     +  .398991D+05, .305849D+05, .234465D+05, .179755D+05,
     +  .137825D+05, .105687D+05, .810544D+04, .621736D+04,
     +  .477009D+04, .366065D+04, .281013D+04, .215804D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .165803D+04, .126985D+04, .976974D+03, .752269D+03,
     +  .579827D+03, .447454D+03, .345804D+03, .267917D+03,
     +  .207884D+03, .161724D+03, .126199D+03, .988248D+02,
     +  .776986D+02, .613560D+02, .487020D+02, .388590D+02,
     +  .311796D+02, .251640D+02, .204300D+02, .166860D+02,
     +  .137184D+02, .113289D+02, .941653D+01, .785707D+01,
     +  .658980D+01, .554891D+01, .468840D+01, .397244D+01,
     +  .337311D+01, .286859D+01, .244167D+01, .207879D+01,
     +  .176913D+01, .150404D+01, .127653D+01, .108092D+01,
     +  .912567D+00, .768245D+00, .643283D+00, .535937D+00,
     +  .443919D+00, .365274D+00, .298317D+00, .241582D+00,
     +  .193783D+00, .153787D+00, .120563D+00, .931963D-01,
     +  .710916D-01, .531915D-01, .390108D-01, .279569D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .195023D-01, .131791D-01, .857453D-02, .533237D-02,
     +  .312462D-02, .170673D-02, .847867D-03, .370024D-03,
     +  .133851D-03, .359879D-04, .563032D-05, .234289D-06,
     +  .000000D+00, .253463D+07, .196325D+07, .150055D+07,
     +  .114651D+07, .876029D+06, .669130D+06, .511106D+06,
     +  .390262D+06, .297992D+06, .227452D+06, .173610D+06,
     +  .132461D+06, .101064D+06, .770781D+05, .587833D+05,
     +  .448125D+05, .341611D+05, .260307D+05, .198350D+05,
     +  .151078D+05, .115071D+05, .876133D+04, .667098D+04,
     +  .507775D+04, .386545D+04, .294181D+04, .223943D+04,
     +  .169821D+04, .129344D+04, .985364D+03, .751228D+03,
     +  .573081D+03, .437713D+03, .334980D+03, .256690D+03,
     +  .197118D+03, .151817D+03, .117296D+03, .909861D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .708678D+02, .554878D+02, .436650D+02, .345587D+02,
     +  .275094D+02, .220321D+02, .177500D+02, .143980D+02,
     +  .117299D+02, .962039D+01, .792009D+01, .655485D+01,
     +  .544660D+01, .454141D+01, .379731D+01, .318209D+01,
     +  .267067D+01, .224343D+01, .188502D+01, .158321D+01,
     +  .132836D+01, .111263D+01, .929823D+00, .774634D+00,
     +  .643535D+00, .531660D+00, .437002D+00, .357058D+00,
     +  .289784D+00, .233376D+00, .186332D+00, .147313D+00,
     +  .115195D+00, .889604D-01, .677063D-01, .508291D-01,
     +  .374064D-01, .269627D-01, .189778D-01, .129884D-01,
     +  .860345D-02, .547740D-02, .332910D-02, .190183D-02,
     +  .101062D-02, .486647D-03, .205125D-03, .712233D-04,
     +  .182813D-04, .274335D-05, .116680D-06, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .377829D+07, .291709D+07, .222109D+07, .169030D+07,
     +  .128628D+07, .978322D+06, .744035D+06, .565545D+06,
     +  .429830D+06, .326495D+06, .247971D+06, .188219D+06,
     +  .142844D+06, .108339D+06, .821550D+05, .622585D+05,
     +  .471715D+05, .357165D+05, .270378D+05, .204538D+05,
     +  .154700D+05, .116926D+05, .883600D+04, .667303D+04,
     +  .503890D+04, .380253D+04, .286962D+04, .215630D+04,
     +  .162716D+04, .122770D+04, .926756D+03, .699781D+03,
     +  .528902D+03, .400422D+03, .303470D+03, .230422D+03,
     +  .175444D+03, .133977D+03, .102710D+03, .790527D+02,
     +  .611623D+02, .475561D+02, .371897D+02, .292503D+02,
     +  .231477D+02, .184265D+02, .147701D+02, .118898D+02,
     +  .963635D+01, .783900D+01, .641093D+01, .526390D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .433698D+01, .358327D+01, .296694D+01, .246037D+01,
     +  .204201D+01, .169517D+01, .140658D+01, .116589D+01,
     +  .964676D+00, .796362D+00, .655274D+00, .537661D+00,
     +  .438625D+00, .355976D+00, .287131D+00, .230012D+00,
     +  .182797D+00, .143992D+00, .112277D+00, .865684D-01,
     +  .658952D-01, .494074D-01, .365258D-01, .264531D-01,
     +  .187506D-01, .129686D-01, .871260D-02, .565925D-02,
     +  .352740D-02, .209602D-02, .116783D-02, .603855D-03,
     +  .281917D-03, .114763D-03, .382479D-04, .937114D-05,
     +  .134758D-05, .580337D-07, .000000D+00, .542532D+07,
     +  .417355D+07, .316435D+07, .239772D+07, .181651D+07,
     +  .137532D+07, .104108D+07, .787539D+06, .595609D+06,
     +  .450139D+06, .340108D+06, .256784D+06, .193815D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .146175D+06, .110208D+06, .830233D+05, .625218D+05,
     +  .470431D+05, .353830D+05, .265898D+05, .199740D+05,
     +  .149909D+05, .112469D+05, .843063D+04, .631741D+04,
     +  .472967D+04, .354039D+04, .263784D+04, .197346D+04,
     +  .147586D+04, .110399D+04, .825871D+03, .618255D+03,
     +  .463521D+03, .347796D+03, .261403D+03, .196984D+03,
     +  .148856D+03, .112913D+03, .859808D+02, .658109D+02,
     +  .506210D+02, .391601D+02, .304680D+02, .238513D+02,
     +  .187815D+02, .148927D+02, .118584D+02, .950716D+01,
     +  .764980D+01, .618817D+01, .502561D+01, .409531D+01,
     +  .334642D+01, .274023D+01, .224716D+01, .184426D+01,
     +  .151385D+01, .124197D+01, .101778D+01, .832526D+00,
     +  .679392D+00, .552541D+00, .448088D+00, .361222D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .289650D+00, .230797D+00, .182609D+00, .143306D+00,
     +  .111444D+00, .857634D-01, .652432D-01, .489834D-01,
     +  .362066D-01, .263770D-01, .188129D-01, .131235D-01,
     +  .892603D-02, .589163D-02, .375591D-02, .229435D-02,
     +  .133427D-02, .725994D-03, .365791D-03, .165875D-03,
     +  .653539D-04, .209721D-04, .492635D-05, .681504D-06,
     +  .291914D-07, .000000D+00, .754293D+07, .578095D+07,
     +  .436401D+07, .329211D+07, .248279D+07, .187110D+07,
     +  .140967D+07, .106123D+07, .798633D+06, .600538D+06,
     +  .451402D+06, .339017D+06, .254502D+06, .190886D+06,
     +  .143104D+06, .107182D+06, .802365D+05, .600062D+05,
     +  .448523D+05, .334912D+05, .249937D+05, .186329D+05,
     +  .138830D+05, .103334D+05, .768713D+04, .571230D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .424335D+04, .313656D+04, .232774D+04, .172652D+04,
     +  .128062D+04, .949755D+03, .704721D+03, .523609D+03,
     +  .389274D+03, .289850D+03, .216348D+03, .161921D+03,
     +  .121631D+03, .917134D+02, .695072D+02, .529355D+02,
     +  .405437D+02, .312307D+02, .242045D+02, .188690D+02,
     +  .148128D+02, .116759D+02, .926682D+01, .738086D+01,
     +  .590999D+01, .475077D+01, .383164D+01, .309871D+01,
     +  .251105D+01, .203775D+01, .165481D+01, .134399D+01,
     +  .109086D+01, .884373D+00, .715585D+00, .577608D+00,
     +  .464585D+00, .372587D+00, .296972D+00, .235414D+00,
     +  .185410D+00, .144975D+00, .112410D+00, .863508D-01,
     +  .656228D-01, .492842D-01, .365170D-01, .266256D-01,
     +  .191268D-01, .134434D-01, .923547D-02, .618180D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .401199D-02, .251231D-02, .150553D-02, .857761D-03,
     +  .456358D-03, .224371D-03, .990050D-04, .378351D-04,
     +  .117266D-04, .265150D-05, .353953D-06, .147299D-07,
     +  .000000D+00, .105408D+08, .804403D+07, .604208D+07,
     +  .453495D+07, .340238D+07, .255066D+07, .191130D+07,
     +  .143102D+07, .107090D+07, .800706D+06, .598360D+06,
     +  .446733D+06, .333333D+06, .248475D+06, .185101D+06,
     +  .137747D+06, .102438D+06, .760963D+05, .564873D+05,
     +  .418834D+05, .310315D+05, .229642D+05, .169812D+05,
     +  .125422D+05, .925651D+04, .682279D+04, .502629D+04,
     +  .368339D+04, .270981D+04, .199210D+04, .146416D+04,
     +  .107583D+04, .790683D+03, .581823D+03, .428285D+03,
     +  .315708D+03, .233250D+03, .172776D+03, .128432D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .958249D+02, .718543D+02, .541412D+02, .410231D+02,
     +  .312610D+02, .239667D+02, .184815D+02, .143515D+02,
     +  .111884D+02, .878283D+01, .691808D+01, .547800D+01,
     +  .435443D+01, .347251D+01, .277653D+01, .222434D+01,
     +  .178437D+01, .143229D+01, .114971D+01, .922213D+00,
     +  .738801D+00, .590664D+00, .471039D+00, .374253D+00,
     +  .296465D+00, .233352D+00, .182647D+00, .142009D+00,
     +  .109595D+00, .838534D-01, .635455D-01, .476267D-01,
     +  .352650D-01, .257525D-01, .184967D-01, .130841D-01,
     +  .904968D-02, .611406D-02, .402171D-02, .256275D-02,
     +  .157407D-02, .924083D-03, .515081D-03, .267619D-03,
     +  .128241D-03, .550168D-04, .203827D-04, .610455D-05,
     +  .133034D-05, .171378D-06, .664476D-08, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .144134D+08, .109519D+08, .818463D+07, .611159D+07,
     +  .456127D+07, .340134D+07, .253495D+07, .188755D+07,
     +  .140463D+07, .104427D+07, .775839D+06, .575828D+06,
     +  .427070D+06, .316403D+06, .234230D+06, .173201D+06,
     +  .127966D+06, .944313D+05, .696232D+05, .512677D+05,
     +  .377164D+05, .277108D+05, .203404D+05, .149106D+05,
     +  .109198D+05, .798546D+04, .583560D+04, .424093D+04,
     +  .309379D+04, .225494D+04, .164283D+04, .119636D+04,
     +  .871243D+03, .635178D+03, .463139D+03, .338128D+03,
     +  .247380D+03, .181439D+03, .133527D+03, .986255D+02,
     +  .732050D+02, .545974D+02, .409445D+02, .308803D+02,
     +  .234300D+02, .178800D+02, .137400D+02, .105990D+02,
     +  .823268D+01, .641578D+01, .502604D+01, .395226D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .311767D+01, .246564D+01, .195357D+01, .154980D+01,
     +  .123011D+01, .976302D+00, .774226D+00, .613145D+00,
     +  .484539D+00, .381902D+00, .299846D+00, .234699D+00,
     +  .182497D+00, .141088D+00, .108330D+00, .825451D-01,
     +  .623426D-01, .466229D-01, .344737D-01, .251747D-01,
     +  .181245D-01, .128278D-01, .893813D-02, .608557D-02,
     +  .404471D-02, .261540D-02, .163694D-02, .986529D-03,
     +  .567584D-03, .309636D-03, .157176D-03, .734429D-04,
     +  .306504D-04, .110153D-04, .319047D-05, .670471D-06,
     +  .831468D-07, .280994D-08, .000000D+00, .192937D+08,
     +  .145977D+08, .108545D+08, .806414D+07, .598740D+07,
     +  .444143D+07, .329244D+07, .243833D+07, .180449D+07,
     +  .133405D+07, .985479D+06, .727194D+06, .536149D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .394837D+06, .290505D+06, .213479D+06, .156723D+06,
     +  .114907D+06, .841608D+05, .615570D+05, .449754D+05,
     +  .328134D+05, .239137D+05, .174024D+05, .126497D+05,
     +  .918008D+04, .665651D+04, .479864D+04, .347228D+04,
     +  .250992D+04, .181316D+04, .130905D+04, .944937D+03,
     +  .682774D+03, .493313D+03, .356838D+03, .258622D+03,
     +  .187888D+03, .136947D+03, .100174D+03, .736294D+02,
     +  .543757D+02, .403755D+02, .301494D+02, .226475D+02,
     +  .171096D+02, .130161D+02, .993870D+01, .764145D+01,
     +  .589392D+01, .456965D+01, .355614D+01, .277590D+01,
     +  .217227D+01, .170288D+01, .133651D+01, .104940D+01,
     +  .823848D+00, .646184D+00, .506103D+00, .395503D+00,
     +  .308230D+00, .239255D+00, .185133D+00, .142281D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .108702D+00, .824669D-01, .620759D-01, .463050D-01,
     +  .341941D-01, .249595D-01, .179880D-01, .127767D-01,
     +  .891751D-02, .612551D-02, .410915D-02, .268942D-02,
     +  .171142D-02, .105338D-02, .623779D-03, .352287D-03,
     +  .188448D-03, .936709D-04, .427961D-04, .174335D-04,
     +  .610344D-05, .171900D-05, .350583D-06, .419896D-07,
     +  .111368D-08, .000000D+00, .253157D+08, .190742D+08,
     +  .141133D+08, .104329D+08, .770685D+07, .568756D+07,
     +  .419415D+07, .308969D+07, .227419D+07, .167211D+07,
     +  .122833D+07, .901275D+06, .660670D+06, .483696D+06,
     +  .353763D+06, .258391D+06, .188523D+06, .137355D+06,
     +  .999575D+05, .726348D+05, .527158D+05, .382002D+05,
     +  .276467D+05, .199771D+05, .144164D+05, .103851D+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .747369D+04, .534587D+04, .383797D+04, .275214D+04,
     +  .197193D+04, .141188D+04, .101052D+04, .723894D+03,
     +  .518433D+03, .371673D+03, .266940D+03, .192159D+03,
     +  .138765D+03, .100557D+03, .732156D+02, .535585D+02,
     +  .393895D+02, .291315D+02, .216721D+02, .162143D+02,
     +  .122154D+02, .923580D+01, .703142D+01, .536964D+01,
     +  .412177D+01, .317552D+01, .245383D+01, .190079D+01,
     +  .147486D+01, .114566D+01, .890237D+00, .691618D+00,
     +  .536779D+00, .415973D+00, .321608D+00, .247951D+00,
     +  .190376D+00, .145705D+00, .110738D+00, .836550D-01,
     +  .627447D-01, .466869D-01, .344191D-01, .251152D-01,
     +  .181111D-01, .128915D-01, .904151D-02, .622889D-02,
     +  .422228D-02, .279377D-02, .180279D-02, .113052D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .685334D-03, .399451D-03, .221890D-03, .116655D-03,
     +  .569348D-04, .255161D-04, .101858D-04, .349049D-05,
     +  .961569D-06, .191578D-06, .222391D-07, .385653D-09,
     +  .000000D+00, .326070D+08, .244682D+08, .180171D+08,
     +  .132538D+08, .974205D+07, .715344D+07, .524819D+07,
     +  .384617D+07, .281611D+07, .205952D+07, .150470D+07,
     +  .109799D+07, .800356D+06, .582632D+06, .423651D+06,
     +  .307618D+06, .223092D+06, .161550D+06, .116833D+06,
     +  .843607D+05, .608306D+05, .437909D+05, .314801D+05,
     +  .225915D+05, .161892D+05, .115788D+05, .827219D+04,
     +  .587254D+04, .418415D+04, .297724D+04, .211640D+04,
     +  .150317D+04, .106705D+04, .758047D+03, .538290D+03,
     +  .382593D+03, .272383D+03, .194347D+03, .139090D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .998839D+02, .720643D+02, .522338D+02, .380610D+02,
     +  .278884D+02, .205540D+02, .152338D+02, .113692D+02,
     +  .851446D+01, .642089D+01, .485648D+01, .369212D+01,
     +  .281709D+01, .215577D+01, .165364D+01, .127052D+01,
     +  .977210D+00, .751821D+00, .578266D+00, .444308D+00,
     +  .340845D+00, .260851D+00, .199057D+00, .151262D+00,
     +  .114573D+00, .861654D-01, .644037D-01, .477898D-01,
     +  .351754D-01, .256492D-01, .185087D-01, .131971D-01,
     +  .928656D-02, .643756D-02, .438229D-02, .293482D-02,
     +  .191784D-02, .122188D-02, .756255D-03, .452319D-03,
     +  .259998D-03, .142372D-03, .737487D-04, .354464D-04,
     +  .156360D-04, .614106D-05, .206946D-05, .560635D-06,
     +  .109745D-06, .123909D-07, .888538D-10, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .412836D+08, .308567D+08, .226143D+08, .165563D+08,
     +  .121106D+08, .884910D+07, .645988D+07, .471031D+07,
     +  .343112D+07, .249626D+07, .181415D+07, .131670D+07,
     +  .954544D+06, .691031D+06, .499638D+06, .360717D+06,
     +  .260075D+06, .187215D+06, .134576D+06, .965752D+05,
     +  .692017D+05, .494995D+05, .353522D+05, .252021D+05,
     +  .179375D+05, .127404D+05, .903798D+04, .636944D+04,
     +  .450491D+04, .318154D+04, .224438D+04, .158170D+04,
     +  .111390D+04, .784972D+03, .552838D+03, .389665D+03,
     +  .275075D+03, .194591D+03, .138060D+03, .982792D+02,
     +  .702826D+02, .504911D+02, .364629D+02, .264780D+02,
     +  .193388D+02, .142033D+02, .105042D+02, .779460D+01,
     +  .582435D+01, .436466D+01, .328759D+01, .248521D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .188411D+01, .143176D+01, .108974D+01, .830281D+00,
     +  .632748D+00, .482069D+00, .366872D+00, .278753D+00,
     +  .211287D+00, .159683D+00, .120166D+00, .901368D-01,
     +  .671235D-01, .496759D-01, .364952D-01, .265932D-01,
     +  .191956D-01, .137106D-01, .967545D-02, .673756D-02,
     +  .462140D-02, .311227D-02, .206183D-02, .133252D-02,
     +  .839472D-03, .513661D-03, .303668D-03, .172491D-03,
     +  .933205D-04, .477487D-04, .226643D-04, .987120D-05,
     +  .382774D-05, .127331D-05, .340595D-06, .657684D-07,
     +  .724545D-08, .000000D+00, .000000D+00, .514456D+08,
     +  .383044D+08, .279434D+08, .203627D+08, .148246D+08,
     +  .107804D+08, .783148D+07, .568236D+07, .411850D+07,
     +  .298119D+07, .215541D+07, .155623D+07, .112219D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .808024D+06, .581024D+06, .417140D+06, .299049D+06,
     +  .214031D+06, .152949D+06, .109105D+06, .777041D+05,
     +  .552371D+05, .392007D+05, .277657D+05, .196323D+05,
     +  .138505D+05, .975836D+04, .682854D+04, .479528D+04,
     +  .336211D+04, .235423D+04, .164665D+04, .115073D+04,
     +  .804619D+03, .562174D+03, .393053D+03, .275197D+03,
     +  .193067D+03, .135833D+03, .958764D+02, .679802D+02,
     +  .484184D+02, .346642D+02, .249537D+02, .180668D+02,
     +  .131530D+02, .964244D+01, .709200D+01, .525277D+01,
     +  .390142D+01, .291264D+01, .218223D+01, .163970D+01,
     +  .123493D+01, .931536D+00, .703401D+00, .531256D+00,
     +  .401117D+00, .302525D+00, .227796D+00, .171110D+00,
     +  .128153D+00, .955677D-01, .710391D-01, .524210D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .384415D-01, .279837D-01, .202041D-01, .144495D-01,
     +  .102253D-01, .714885D-02, .493159D-02, .335085D-02,
     +  .223518D-02, .146671D-02, .938776D-03, .585686D-03,
     +  .354867D-03, .207724D-03, .116819D-03, .625691D-04,
     +  .316911D-04, .148898D-04, .641871D-05, .246354D-05,
     +  .810960D-06, .214670D-06, .409736D-07, .441599D-08,
     +  .000000D+00, .000000D+00, .631720D+08, .468597D+08,
     +  .340311D+08, .246863D+08, .178894D+08, .129484D+08,
     +  .936191D+07, .676024D+07, .487586D+07, .351199D+07,
     +  .252644D+07, .181484D+07, .130191D+07, .932513D+06,
     +  .666960D+06, .476243D+06, .339537D+06, .241648D+06,
     +  .171698D+06, .121769D+06, .862103D+05, .609151D+05,
     +  .429648D+05, .302416D+05, .212465D+05, .148916D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .104223D+05, .724313D+04, .505135D+04, .351678D+04,
     +  .244489D+04, .169759D+04, .117750D+04, .817130D+03,
     +  .566521D+03, .393001D+03, .272981D+03, .189978D+03,
     +  .132575D+03, .928119D+02, .652649D+02, .460989D+02,
     +  .327282D+02, .233627D+02, .167728D+02, .121079D+02,
     +  .880160D+01, .641860D+01, .471388D+01, .347141D+01,
     +  .256966D+01, .190895D+01, .142221D+01, .106206D+01,
     +  .794361D+00, .594752D+00, .445406D+00, .333464D+00,
     +  .249385D+00, .186206D+00, .138697D+00, .103008D+00,
     +  .761743D-01, .561527D-01, .410903D-01, .298813D-01,
     +  .215713D-01, .154448D-01, .109541D-01, .768733D-02,
     +  .532989D-02, .364622D-02, .245690D-02, .162519D-02,
     +  .105761D-02, .671271D-03, .415296D-03, .249519D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .144833D-03, .807638D-04, .428930D-04, .215402D-04,
     +  .100336D-04, .428746D-05, .163093D-05, .531850D-06,
     +  .139417D-06, .263139D-07, .278025D-08, .000000D+00,
     +  .000000D+00, .765181D+08, .565532D+08, .408908D+08,
     +  .295308D+08, .213037D+08, .153495D+08, .110466D+08,
     +  .793947D+07, .569917D+07, .408526D+07, .292446D+07,
     +  .209035D+07, .149200D+07, .106320D+07, .756480D+06,
     +  .537316D+06, .381022D+06, .269694D+06, .190561D+06,
     +  .134384D+06, .945941D+05, .664479D+05, .465876D+05,
     +  .325923D+05, .227559D+05, .158485D+05, .110206D+05,
     +  .760797D+04, .527028D+04, .364420D+04, .251585D+04,
     +  .173451D+04, .119442D+04, .822814D+03, .566206D+03,
     +  .389811D+03, .268687D+03, .185539D+03, .128462D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .892200D+02, .622391D+02, .436092D+02, .307112D+02,
     +  .217457D+02, .154855D+02, .110879D+02, .799496D+01,
     +  .578286D+01, .421268D+01, .307713D+01, .225940D+01,
     +  .166494D+01, .123046D+01, .911510D+00, .676321D+00,
     +  .502349D+00, .373231D+00, .277227D+00, .205704D+00,
     +  .152393D+00, .112631D+00, .830046D-01, .609103D-01,
     +  .445591D-01, .323586D-01, .233535D-01, .167321D-01,
     +  .118903D-01, .837031D-02, .583054D-02, .401271D-02,
     +  .272493D-02, .182267D-02, .119683D-02, .773205D-03,
     +  .487182D-03, .299215D-03, .178464D-03, .102834D-03,
     +  .569211D-04, .300061D-04, .149543D-04, .691154D-05,
     +  .292932D-05, .110476D-05, .356889D-06, .926042D-07,
     +  .172749D-07, .179219D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .319388D+05, .493033D+05, .388034D+05, .305442D+05,
     +  .240472D+05, .189359D+05, .149144D+05, .117500D+05,
     +  .925970D+04, .729966D+04, .575671D+04, .454189D+04,
     +  .358522D+04, .283166D+04, .223794D+04, .177001D+04,
     +  .140110D+04, .111014D+04, .880561D+03, .699329D+03,
     +  .556181D+03, .443046D+03, .353568D+03, .282746D+03,
     +  .226642D+03, .182153D+03, .146838D+03, .118418D+03,
     +  .961640D+02, .784268D+02, .642674D+02, .529445D+02,
     +  .438727D+02, .366087D+02, .307473D+02, .260198D+02,
     +  .221950D+02, .190894D+02, .165569D+02, .144803D+02,
     +  .127698D+02, .113484D+02, .101581D+02, .915185D+01,
     +  .829245D+01, .755043D+01, .690469D+01, .633070D+01,
     +  .582108D+01, .535827D+01, .493817D+01, .455219D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .419503D+01, .386262D+01, .355182D+01, .326022D+01,
     +  .298603D+01, .272787D+01, .248473D+01, .225582D+01,
     +  .204056D+01, .183848D+01, .164920D+01, .147319D+01,
     +  .130832D+01, .115544D+01, .101425D+01, .884466D+00,
     +  .765779D+00, .657847D+00, .560301D+00, .472740D+00,
     +  .394682D+00, .325606D+00, .265597D+00, .213231D+00,
     +  .168400D+00, .130513D+00, .989656D-01, .731491D-01,
     +  .524484D-01, .362734D-01, .239278D-01, .149272D-01,
     +  .863776D-02, .451133D-02, .203133D-02, .723587D-03,
     +  .168106D-03, .137357D-04, .000000D+00, .102396D+06,
     +  .804200D+05, .624626D+05, .485242D+05, .377068D+05,
     +  .293074D+05, .227865D+05, .177213D+05, .137875D+05,
     +  .107306D+05, .835541D+04, .650883D+04, .507334D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .395668D+04, .308808D+04, .241192D+04, .188558D+04,
     +  .147550D+04, .115599D+04, .906792D+03, .712413D+03,
     +  .560615D+03, .442033D+03, .349278D+03, .276684D+03,
     +  .219790D+03, .175171D+03, .139666D+03, .112185D+03,
     +  .905180D+02, .734146D+02, .598768D+02, .491440D+02,
     +  .406308D+02, .338278D+02, .283867D+02, .240222D+02,
     +  .205035D+02, .176549D+02, .153327D+02, .134313D+02,
     +  .118585D+02, .105477D+02, .944376D+01, .850496D+01,
     +  .769731D+01, .699744D+01, .637784D+01, .583041D+01,
     +  .533564D+01, .488910D+01, .448117D+01, .410616D+01,
     +  .375942D+01, .343749D+01, .313761D+01, .285769D+01,
     +  .259608D+01, .235153D+01, .212303D+01, .190976D+01,
     +  .171108D+01, .152634D+01, .135583D+01, .119728D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .105134D+01, .917553D+00, .795481D+00, .684658D+00,
     +  .584623D+00, .494874D+00, .414914D+00, .344185D+00,
     +  .282060D+00, .228511D+00, .182155D+00, .142792D+00,
     +  .109809D+00, .825856D-01, .605190D-01, .429907D-01,
     +  .294391D-01, .192082D-01, .118403D-01, .675968D-02,
     +  .347670D-02, .153737D-02, .535876D-03, .121748D-03,
     +  .100545D-04, .000000D+00, .153448D+06, .119623D+06,
     +  .921256D+05, .709550D+05, .546614D+05, .421140D+05,
     +  .324554D+05, .250159D+05, .192880D+05, .148751D+05,
     +  .114764D+05, .885720D+04, .683930D+04, .528351D+04,
     +  .408437D+04, .315934D+04, .244595D+04, .189524D+04,
     +  .147021D+04, .114180D+04, .888095D+03, .691838D+03,
     +  .540011D+03, .422385D+03, .331225D+03, .260470D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .205531D+03, .162230D+03, .129043D+03, .103122D+03,
     +  .828565D+02, .669615D+02, .544750D+02, .446558D+02,
     +  .368763D+02, .307027D+02, .257888D+02, .218540D+02,
     +  .186898D+02, .161250D+02, .140365D+02, .123171D+02,
     +  .108907D+02, .969407D+01, .868059D+01, .781196D+01,
     +  .706228D+01, .640126D+01, .581990D+01, .529690D+01,
     +  .482735D+01, .440071D+01, .401081D+01, .365249D+01,
     +  .332194D+01, .301601D+01, .273236D+01, .246907D+01,
     +  .222463D+01, .199780D+01, .178756D+01, .159307D+01,
     +  .141345D+01, .124882D+01, .109677D+01, .957787D+00,
     +  .831248D+00, .716593D+00, .613222D+00, .520565D+00,
     +  .438013D+00, .364991D+00, .300876D+00, .244963D+00,
     +  .197129D+00, .156041D+00, .121425D+00, .926613D-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .691225D-01, .502144D-01, .353361D-01, .239544D-01,
     +  .154557D-01, .941048D-02, .529770D-02, .268122D-02,
     +  .116300D-02, .395988D-03, .877726D-04, .733592D-05,
     +  .000000D+00, .217095D+06, .168305D+06, .128789D+06,
     +  .985482D+05, .754173D+05, .577148D+05, .441747D+05,
     +  .338122D+05, .258863D+05, .198202D+05, .151801D+05,
     +  .116285D+05, .891151D+04, .683144D+04, .523980D+04,
     +  .402091D+04, .308791D+04, .237306D+04, .182558D+04,
     +  .140583D+04, .108412D+04, .837238D+03, .647794D+03,
     +  .502217D+03, .390331D+03, .304210D+03, .237909D+03,
     +  .186093D+03, .146717D+03, .116220D+03, .925784D+02,
     +  .741879D+02, .598592D+02, .486804D+02, .398923D+02,
     +  .329693D+02, .274978D+02, .231450D+02, .196662D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .168620D+02, .145906D+02, .127292D+02, .111917D+02,
     +  .990707D+01, .882327D+01, .789787D+01, .710230D+01,
     +  .640362D+01, .579178D+01, .524384D+01, .475430D+01,
     +  .431179D+01, .390961D+01, .354209D+01, .320508D+01,
     +  .289507D+01, .260942D+01, .234595D+01, .210291D+01,
     +  .187885D+01, .167251D+01, .148289D+01, .130888D+01,
     +  .115043D+01, .100504D+01, .873016D+00, .753596D+00,
     +  .646104D+00, .549830D+00, .464109D+00, .388247D+00,
     +  .321601D+00, .263497D+00, .213175D+00, .170436D+00,
     +  .133995D+00, .103530D+00, .784164D-01, .580349D-01,
     +  .418069D-01, .291535D-01, .195713D-01, .124921D-01,
     +  .751598D-02, .417442D-02, .208020D-02, .885801D-03,
     +  .294981D-03, .639036D-04, .540221D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .200139D+06, .228087D+06, .173609D+06, .132126D+06,
     +  .100557D+06, .765206D+05, .582332D+05, .443124D+05,
     +  .337231D+05, .256635D+05, .195337D+05, .148688D+05,
     +  .113212D+05, .862151D+04, .656841D+04, .500589D+04,
     +  .381747D+04, .291280D+04, .222452D+04, .170035D+04,
     +  .130136D+04, .997292D+03, .765622D+03, .588873D+03,
     +  .454022D+03, .350990D+03, .272269D+03, .211211D+03,
     +  .165168D+03, .129777D+03, .102552D+03, .815342D+02,
     +  .652810D+02, .526937D+02, .428691D+02, .351827D+02,
     +  .291480D+02, .243767D+02, .205857D+02, .175461D+02,
     +  .150963D+02, .130977D+02, .114539D+02, .100858D+02,
     +  .893591D+01, .795776D+01, .712000D+01, .638715D+01,
     +  .574802D+01, .517815D+01, .467139D+01, .421557D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .380342D+01, .342885D+01, .308728D+01, .277489D+01,
     +  .248874D+01, .222640D+01, .198587D+01, .176547D+01,
     +  .156376D+01, .137954D+01, .121153D+01, .105949D+01,
     +  .920849D+00, .795740D+00, .683284D+00, .582701D+00,
     +  .493187D+00, .413996D+00, .344366D+00, .283600D+00,
     +  .230982D+00, .185716D+00, .147541D+00, .115225D+00,
     +  .884092D-01, .664756D-01, .488185D-01, .348796D-01,
     +  .241078D-01, .160303D-01, .101247D-01, .602117D-02,
     +  .330046D-02, .162004D-02, .677639D-03, .220917D-03,
     +  .468454D-04, .400371D-05, .000000D+00, .411228D+06,
     +  .315861D+06, .239105D+06, .180960D+06, .136941D+06,
     +  .103605D+06, .783780D+05, .592820D+05, .448370D+05,
     +  .339068D+05, .256419D+05, .193902D+05, .146646D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .110910D+05, .839045D+04, .634865D+04, .480588D+04,
     +  .363949D+04, .275815D+04, .209173D+04, .158807D+04,
     +  .120707D+04, .918945D+03, .700809D+03, .535665D+03,
     +  .410486D+03, .315612D+03, .242628D+03, .188041D+03,
     +  .146435D+03, .114691D+03, .903895D+02, .717495D+02,
     +  .574320D+02, .463442D+02, .377369D+02, .310282D+02,
     +  .257614D+02, .216037D+02, .182908D+02, .156355D+02,
     +  .134808D+02, .117170D+02, .102558D+02, .903309D+01,
     +  .799750D+01, .711439D+01, .634539D+01, .567790D+01,
     +  .508574D+01, .456194D+01, .409344D+01, .367231D+01,
     +  .329191D+01, .294721D+01, .263402D+01, .234903D+01,
     +  .208951D+01, .185320D+01, .163816D+01, .144273D+01,
     +  .126550D+01, .110496D+01, .960718D+00, .830106D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .713078D+00, .608635D+00, .515886D+00, .433939D+00,
     +  .361970D+00, .299154D+00, .244745D+00, .197994D+00,
     +  .158081D+00, .124687D+00, .966488D-01, .735775D-01,
     +  .548717D-01, .399501D-01, .282832D-01, .193574D-01,
     +  .127369D-01, .795234D-02, .466992D-02, .252387D-02,
     +  .121918D-02, .500604D-03, .159767D-03, .332007D-04,
     +  .286813D-05, .000000D+00, .556508D+06, .425629D+06,
     +  .320593D+06, .241402D+06, .181735D+06, .136770D+06,
     +  .102912D+06, .774112D+05, .582208D+05, .437763D+05,
     +  .329122D+05, .247396D+05, .185960D+05, .139768D+05,
     +  .105061D+05, .789763D+04, .593853D+04, .446654D+04,
     +  .336126D+04, .253091D+04, .190745D+04, .143900D+04,
     +  .108714D+04, .822626D+03, .623788D+03, .474161D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .361596D+03, .275655D+03, .211866D+03, .163619D+03,
     +  .127090D+03, .993414D+02, .782191D+02, .621186D+02,
     +  .497414D+02, .402030D+02, .328194D+02, .270613D+02,
     +  .225436D+02, .189650D+02, .161119D+02, .138084D+02,
     +  .119314D+02, .103834D+02, .909340D+01, .800550D+01,
     +  .708168D+01, .628080D+01, .558881D+01, .497795D+01,
     +  .444034D+01, .396213D+01, .353467D+01, .315085D+01,
     +  .280516D+01, .249304D+01, .221084D+01, .195555D+01,
     +  .172461D+01, .151588D+01, .132745D+01, .115774D+01,
     +  .100506D+01, .868800D+00, .746273D+00, .637253D+00,
     +  .540637D+00, .455445D+00, .380711D+00, .315549D+00,
     +  .259089D+00, .210551D+00, .169163D+00, .134100D+00,
     +  .104997D+00, .807612D-01, .609887D-01, .450995D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .325421D-01, .228197D-01, .154583D-01, .100592D-01,
     +  .620425D-02, .359454D-02, .191331D-02, .908265D-03,
     +  .365390D-03, .113863D-03, .231202D-04, .202229D-05,
     +  .000000D+00, .736738D+06, .561229D+06, .420756D+06,
     +  .315319D+06, .236233D+06, .176909D+06, .132445D+06,
     +  .991168D+05, .741562D+05, .554613D+05, .414707D+05,
     +  .309998D+05, .231695D+05, .173133D+05, .129370D+05,
     +  .966611D+04, .722326D+04, .539839D+04, .403615D+04,
     +  .301890D+04, .225977D+04, .169295D+04, .126991D+04,
     +  .953962D+03, .718031D+03, .541687D+03, .409939D+03,
     +  .310063D+03, .236457D+03, .181188D+03, .139640D+03,
     +  .108310D+03, .846309D+02, .667112D+02, .530307D+02,
     +  .425603D+02, .345076D+02, .282674D+02, .233998D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .195655D+02, .165239D+02, .140800D+02, .120973D+02,
     +  .104692D+02, .911794D+01, .798304D+01, .702326D+01,
     +  .619478D+01, .548215D+01, .485607D+01, .430782D+01,
     +  .382273D+01, .339150D+01, .300654D+01, .266185D+01,
     +  .235256D+01, .207465D+01, .182484D+01, .160032D+01,
     +  .139872D+01, .121794D+01, .105619D+01, .911632D+00,
     +  .783497D+00, .669054D+00, .567924D+00, .478918D+00,
     +  .400983D+00, .333096D+00, .274326D+00, .223774D+00,
     +  .180636D+00, .144132D+00, .113441D+00, .881691D-01,
     +  .672954D-01, .504104D-01, .369614D-01, .264311D-01,
     +  .183577D-01, .123078D-01, .792047D-02, .482554D-02,
     +  .275811D-02, .144582D-02, .674429D-03, .265825D-03,
     +  .808949D-04, .160582D-04, .142222D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .957898D+06, .726935D+06, .542553D+06, .404751D+06,
     +  .301836D+06, .224976D+06, .167626D+06, .124835D+06,
     +  .929346D+05, .691544D+05, .514431D+05, .382522D+05,
     +  .284366D+05, .211328D+05, .157026D+05, .116654D+05,
     +  .866631D+04, .643815D+04, .478410D+04, .355596D+04,
     +  .264474D+04, .196839D+04, .146665D+04, .109423D+04,
     +  .817872D+03, .612625D+03, .460286D+03, .345572D+03,
     +  .261601D+03, .198978D+03, .152221D+03, .117206D+03,
     +  .909216D+02, .711649D+02, .561811D+02, .447876D+02,
     +  .360789D+02, .293705D+02, .241667D+02, .200891D+02,
     +  .168701D+02, .142954D+02, .122153D+02, .105143D+02,
     +  .910808D+01, .793168D+01, .694078D+01, .608904D+01,
     +  .535960D+01, .472176D+01, .416594D+01, .367670D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .324413D+01, .286013D+01, .251832D+01, .221343D+01,
     +  .194115D+01, .169794D+01, .148072D+01, .128693D+01,
     +  .111428D+01, .960819D+00, .824563D+00, .704585D+00,
     +  .598143D+00, .504718D+00, .423055D+00, .352043D+00,
     +  .290617D+00, .237817D+00, .192726D+00, .154531D+00,
     +  .122454D+00, .956892D-01, .738240D-01, .559112D-01,
     +  .415441D-01, .302018D-01, .214031D-01, .147231D-01,
     +  .976927D-02, .621694D-02, .374132D-02, .210952D-02,
     +  .108901D-02, .499173D-03, .192785D-03, .573139D-04,
     +  .111318D-04, .998157D-06, .000000D+00, .122635D+07,
     +  .927257D+06, .689076D+06, .511809D+06, .379974D+06,
     +  .281936D+06, .209100D+06, .154992D+06, .114836D+06,
     +  .850373D+05, .629456D+05, .465696D+05, .344420D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .254616D+05, .188180D+05, .139035D+05, .102714D+05,
     +  .758709D+04, .560502D+04, .414134D+04, .306137D+04,
     +  .226430D+04, .167641D+04, .124261D+04, .922636D+03,
     +  .686436D+03, .512218D+03, .381865D+03, .287059D+03,
     +  .216815D+03, .164707D+03, .125941D+03, .970280D+02,
     +  .754362D+02, .591629D+02, .468653D+02, .375205D+02,
     +  .303630D+02, .248398D+02, .205337D+02, .171497D+02,
     +  .144548D+02, .122864D+02, .105201D+02, .906542D+01,
     +  .785315D+01, .683604D+01, .596535D+01, .522288D+01,
     +  .457666D+01, .401622D+01, .352544D+01, .309380D+01,
     +  .271276D+01, .237549D+01, .207644D+01, .181098D+01,
     +  .157531D+01, .136614D+01, .118071D+01, .101655D+01,
     +  .871587D+00, .743702D+00, .631830D+00, .533237D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .447279D+00, .372651D+00, .308199D+00, .252834D+00,
     +  .205577D+00, .165509D+00, .131817D+00, .103733D+00,
     +  .804786D-01, .616302D-01, .463143D-01, .341342D-01,
     +  .246031D-01, .172782D-01, .117712D-01, .772975D-02,
     +  .486413D-02, .289125D-02, .160811D-02, .817527D-03,
     +  .368227D-03, .139364D-03, .404911D-04, .770130D-05,
     +  .699018D-06, .000000D+00, .154874D+07, .116686D+07,
     +  .863491D+06, .638625D+06, .472074D+06, .348736D+06,
     +  .257488D+06, .189995D+06, .140121D+06, .103274D+06,
     +  .760799D+05, .560133D+05, .412212D+05, .303195D+05,
     +  .222930D+05, .163845D+05, .120394D+05, .884440D+04,
     +  .649737D+04, .477328D+04, .350794D+04, .257916D+04,
     +  .189792D+04, .139808D+04, .103151D+04, .762498D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .565265D+03, .418594D+03, .312579D+03, .234518D+03,
     +  .176970D+03, .134425D+03, .102889D+03, .794840D+02,
     +  .619492D+02, .487763D+02, .388220D+02, .312388D+02,
     +  .254161D+02, .208981D+02, .173628D+02, .145592D+02,
     +  .123119D+02, .104883D+02, .899176D+01, .774933D+01,
     +  .671089D+01, .582553D+01, .507375D+01, .442238D+01,
     +  .386017D+01, .337031D+01, .294172D+01, .256545D+01,
     +  .223427D+01, .194232D+01, .168470D+01, .145737D+01,
     +  .125684D+01, .108018D+01, .924777D+00, .788409D+00,
     +  .668878D+00, .564989D+00, .474030D+00, .395254D+00,
     +  .327320D+00, .269046D+00, .219333D+00, .177197D+00,
     +  .141725D+00, .112115D+00, .876175D-01, .674859D-01,
     +  .512971D-01, .382492D-01, .279605D-01, .199807D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .139047D-01, .938143D-02, .609641D-02, .379331D-02,
     +  .222695D-02, .122179D-02, .611650D-03, .270716D-03,
     +  .100418D-03, .285235D-04, .531684D-05, .488432D-06,
     +  .000000D+00, .193185D+07, .145048D+07, .106896D+07,
     +  .787305D+06, .579524D+06, .426281D+06, .313376D+06,
     +  .230213D+06, .169020D+06, .124007D+06, .909294D+05,
     +  .666306D+05, .487993D+05, .357180D+05, .261316D+05,
     +  .191083D+05, .139682D+05, .102072D+05, .745810D+04,
     +  .544898D+04, .398206D+04, .291099D+04, .212960D+04,
     +  .155941D+04, .114358D+04, .840119D+03, .618919D+03,
     +  .455396D+03, .337901D+03, .251905D+03, .188883D+03,
     +  .142572D+03, .108448D+03, .832712D+02, .645164D+02,
     +  .505061D+02, .399750D+02, .319933D+02, .258938D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .211820D+02, .175104D+02, .146099D+02, .122935D+02,
     +  .104206D+02, .888909D+01, .762219D+01, .656728D+01,
     +  .567143D+01, .491392D+01, .426054D+01, .369923D+01,
     +  .321260D+01, .278903D+01, .241917D+01, .209545D+01,
     +  .181170D+01, .156279D+01, .134446D+01, .115304D+01,
     +  .985438D+00, .838927D+00, .711171D+00, .599894D+00,
     +  .503799D+00, .420212D+00, .348295D+00, .286689D+00,
     +  .234200D+00, .189728D+00, .152296D+00, .121009D+00,
     +  .950804D-01, .737886D-01, .564236D-01, .425692D-01,
     +  .314933D-01, .228337D-01, .161767D-01, .111550D-01,
     +  .745315D-02, .479278D-02, .294859D-02, .170962D-02,
     +  .925161D-03, .456075D-03, .198357D-03, .721208D-04,
     +  .200353D-04, .366292D-05, .340516D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .238248D+07, .178278D+07, .130858D+07, .959866D+06,
     +  .703629D+06, .515406D+06, .377286D+06, .275969D+06,
     +  .201728D+06, .147347D+06, .107556D+06, .784524D+05,
     +  .571891D+05, .416601D+05, .303315D+05, .220702D+05,
     +  .160524D+05, .116703D+05, .848272D+04, .616466D+04,
     +  .448067D+04, .325740D+04, .236961D+04, .172522D+04,
     +  .125781D+04, .918555D+03, .672648D+03, .491895D+03,
     +  .362765D+03, .268797D+03, .200327D+03, .150304D+03,
     +  .113654D+03, .867653D+02, .668448D+02, .520431D+02,
     +  .409733D+02, .326241D+02, .262722D+02, .213863D+02,
     +  .175937D+02, .146088D+02, .122334D+02, .103193D+02,
     +  .875956D+01, .747383D+01, .640719D+01, .550490D+01,
     +  .474512D+01, .409269D+01, .353480D+01, .305353D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .263677D+01, .227481D+01, .195974D+01, .168515D+01,
     +  .144567D+01, .123685D+01, .105488D+01, .896515D+00,
     +  .758937D+00, .639719D+00, .536530D+00, .447986D+00,
     +  .371464D+00, .306055D+00, .250397D+00, .203292D+00,
     +  .163654D+00, .130522D+00, .103024D+00, .804010D-01,
     +  .619613D-01, .470360D-01, .352215D-01, .258531D-01,
     +  .185905D-01, .130568D-01, .892128D-02, .590259D-02,
     +  .375591D-02, .228457D-02, .130816D-02, .698225D-03,
     +  .338934D-03, .144856D-03, .516327D-04, .140333D-04,
     +  .251824D-05, .236863D-06, .000000D+00, .290725D+07,
     +  .216828D+07, .158526D+07, .115818D+07, .845573D+06,
     +  .616844D+06, .449665D+06, .327527D+06, .238391D+06,
     +  .173371D+06, .125995D+06, .914908D+05, .663901D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .481391D+05, .348836D+05, .252610D+05, .182836D+05,
     +  .132265D+05, .956526D+04, .691560D+04, .500012D+04,
     +  .361563D+04, .261591D+04, .189401D+04, .137311D+04,
     +  .997034D+03, .725911D+03, .527721D+03, .386917D+03,
     +  .285025D+03, .211191D+03, .157549D+03, .118461D+03,
     +  .899390D+02, .689186D+02, .533791D+02, .418134D+02,
     +  .331301D+02, .265520D+02, .215125D+02, .176150D+02,
     +  .145584D+02, .121338D+02, .101868D+02, .860543D+01,
     +  .730638D+01, .623261D+01, .532778D+01, .456901D+01,
     +  .392032D+01, .336821D+01, .289425D+01, .248592D+01,
     +  .213315D+01, .182778D+01, .156314D+01, .133366D+01,
     +  .113474D+01, .962430D+00, .813385D+00, .684695D+00,
     +  .573869D+00, .478542D+00, .397260D+00, .327465D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .268194D+00, .218091D+00, .175970D+00, .140767D+00,
     +  .111545D+00, .874632D-01, .677936D-01, .518799D-01,
     +  .390964D-01, .290567D-01, .211602D-01, .150906D-01,
     +  .105067D-01, .711298D-02, .466010D-02, .293409D-02,
     +  .176444D-02, .997738D-03, .525234D-03, .251054D-03,
     +  .105441D-03, .368499D-04, .980237D-05, .172778D-05,
     +  .164402D-06, .000000D+00, .319920D+05, .491218D+05,
     +  .386415D+05, .304000D+05, .239187D+05, .188215D+05,
     +  .148126D+05, .116595D+05, .917931D+04, .722827D+04,
     +  .569336D+04, .448571D+04, .353543D+04, .278758D+04,
     +  .219895D+04, .173556D+04, .137068D+04, .108331D+04,
     +  .856930D+03, .678533D+03, .537900D+03, .426991D+03,
     +  .339483D+03, .270400D+03, .215827D+03, .172684D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .138549D+03, .111172D+03, .898108D+02, .728466D+02,
     +  .593522D+02, .485975D+02, .400069D+02, .331455D+02,
     +  .276184D+02, .231637D+02, .195577D+02, .166237D+02,
     +  .142225D+02, .122432D+02, .106018D+02, .922738D+01,
     +  .806713D+01, .707906D+01, .623039D+01, .549556D+01,
     +  .485682D+01, .429249D+01, .379727D+01, .335543D+01,
     +  .296385D+01, .261464D+01, .230279D+01, .202412D+01,
     +  .177509D+01, .155270D+01, .135430D+01, .117761D+01,
     +  .102054D+01, .881242D+00, .758015D+00, .649308D+00,
     +  .553698D+00, .470242D+00, .396884D+00, .333069D+00,
     +  .277788D+00, .230115D+00, .189210D+00, .154305D+00,
     +  .124703D+00, .997683D-01, .789143D-01, .616083D-01,
     +  .475146D-01, .359949D-01, .267704D-01, .194903D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .138418D-01, .954646D-02, .635748D-02, .406085D-02,
     +  .245499D-02, .139086D-02, .721759D-03, .332223D-03,
     +  .128533D-03, .377842D-04, .672820D-05, .351569D-06,
     +  .000000D+00, .102178D+06, .802252D+05, .622890D+05,
     +  .483697D+05, .375692D+05, .291850D+05, .226776D+05,
     +  .176246D+05, .137016D+05, .106543D+05, .828777D+04,
     +  .644889D+04, .502025D+04, .390970D+04, .304653D+04,
     +  .237522D+04, .185318D+04, .144694D+04, .113082D+04,
     +  .884642D+03, .692933D+03, .543500D+03, .427005D+03,
     +  .336091D+03, .265117D+03, .209646D+03, .166272D+03,
     +  .131867D+03, .105328D+03, .844749D+02, .680720D+02,
     +  .551334D+02, .449086D+02, .368217D+02, .303742D+02,
     +  .252254D+02, .210977D+02, .177680D+02, .150676D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .128595D+02, .110443D+02, .953592D+01, .827306D+01,
     +  .720575D+01, .629645D+01, .551508D+01, .484134D+01,
     +  .425057D+01, .373631D+01, .328095D+01, .288049D+01,
     +  .252602D+01, .221183D+01, .193310D+01, .168579D+01,
     +  .146647D+01, .127214D+01, .110022D+01, .948401D+00,
     +  .814623D+00, .697023D+00, .593947D+00, .503824D+00,
     +  .425646D+00, .357335D+00, .298274D+00, .247417D+00,
     +  .203830D+00, .166658D+00, .135137D+00, .108571D+00,
     +  .863391D-01, .678717D-01, .526464D-01, .403340D-01,
     +  .303432D-01, .224025D-01, .161855D-01, .114011D-01,
     +  .779536D-02, .514248D-02, .325173D-02, .194489D-02,
     +  .108968D-02, .558282D-03, .253261D-03, .963095D-04,
     +  .277535D-04, .485192D-05, .257563D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .153215D+06, .119415D+06, .919403D+05, .707901D+05,
     +  .545147D+05, .419836D+05, .323394D+05, .249129D+05,
     +  .191966D+05, .147939D+05, .114045D+05, .879348D+04,
     +  .678288D+04, .523360D+04, .404025D+04, .312038D+04,
     +  .241156D+04, .186492D+04, .144349D+04, .111829D+04,
     +  .867406D+03, .673651D+03, .524031D+03, .408349D+03,
     +  .318899D+03, .249642D+03, .196014D+03, .153872D+03,
     +  .121676D+03, .966119D+02, .770840D+02, .618207D+02,
     +  .498707D+02, .405031D+02, .331019D+02, .272417D+02,
     +  .225843D+02, .188574D+02, .158596D+02, .134272D+02,
     +  .114430D+02, .980643D+01, .844649D+01, .730537D+01,
     +  .634037D+01, .551704D+01, .481232D+01, .419875D+01,
     +  .366855D+01, .320236D+01, .279530D+01, .243748D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .212250D+01, .184495D+01, .160033D+01, .138479D+01,
     +  .119503D+01, .102821D+01, .881794D+00, .753565D+00,
     +  .641515D+00, .543896D+00, .459027D+00, .385839D+00,
     +  .322252D+00, .267597D+00, .220805D+00, .180937D+00,
     +  .147137D+00, .118648D+00, .947817D-01, .749335D-01,
     +  .585541D-01, .451358D-01, .343583D-01, .256742D-01,
     +  .188218D-01, .134982D-01, .943386D-02, .639706D-02,
     +  .418236D-02, .261953D-02, .154950D-02, .857172D-03,
     +  .432955D-03, .193289D-03, .721322D-04, .203350D-04,
     +  .348264D-05, .188123D-06, .000000D+00, .216847D+06,
     +  .168083D+06, .128592D+06, .983728D+05, .752613D+05,
     +  .575761D+05, .440515D+05, .337029D+05, .257892D+05,
     +  .197341D+05, .151039D+05, .115610D+05, .885173D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .677857D+04, .519308D+04, .397966D+04, .305150D+04,
     +  .234096D+04, .179729D+04, .138093D+04, .106221D+04,
     +  .817960D+03, .630843D+03, .487315D+03, .377229D+03,
     +  .292685D+03, .227763D+03, .177166D+03, .138832D+03,
     +  .109236D+03, .863706D+02, .686460D+02, .548839D+02,
     +  .441838D+02, .357986D+02, .292117D+02, .240180D+02,
     +  .198935D+02, .166009D+02, .139486D+02, .118008D+02,
     +  .100415D+02, .858981D+01, .738000D+01, .636394D+01,
     +  .550289D+01, .477089D+01, .413783D+01, .359449D+01,
     +  .311993D+01, .270830D+01, .234882D+01, .203444D+01,
     +  .175917D+01, .151807D+01, .130695D+01, .112219D+01,
     +  .960739D+00, .819863D+00, .697202D+00, .590629D+00,
     +  .498315D+00, .418493D+00, .350045D+00, .290903D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .240353D+00, .197315D+00, .160854D+00, .130118D+00,
     +  .104361D+00, .829081D-01, .651754D-01, .506337D-01,
     +  .387944D-01, .293473D-01, .217866D-01, .158627D-01,
     +  .112945D-01, .783376D-02, .526939D-02, .341522D-02,
     +  .211930D-02, .124089D-02, .678893D-03, .338706D-03,
     +  .149166D-03, .548199D-04, .152093D-04, .257851D-05,
     +  .142702D-06, .000000D+00, .200207D+06, .227852D+06,
     +  .173400D+06, .131940D+06, .100391D+06, .763736D+05,
     +  .581027D+05, .441965D+05, .336203D+05, .255724D+05,
     +  .194530D+05, .147974D+05, .112580D+05, .856562D+04,
     +  .651902D+04, .496229D+04, .377899D+04, .287888D+04,
     +  .219462D+04, .167402D+04, .127818D+04, .976895D+03,
     +  .747676D+03, .573083D+03, .440125D+03, .338750D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .261478D+03, .201701D+03, .156752D+03, .122310D+03,
     +  .959017D+02, .755858D+02, .599312D+02, .478515D+02,
     +  .384562D+02, .311305D+02, .253965D+02, .208755D+02,
     +  .172918D+02, .144249D+02, .121190D+02, .102428D+02,
     +  .870475D+01, .743129D+01, .636868D+01, .547393D+01,
     +  .471815D+01, .406867D+01, .351480D+01, .303408D+01,
     +  .261972D+01, .226011D+01, .194753D+01, .167550D+01,
     +  .143866D+01, .123248D+01, .105309D+01, .897227D+00,
     +  .761989D+00, .644892D+00, .543714D+00, .456554D+00,
     +  .381588D+00, .317650D+00, .262701D+00, .215988D+00,
     +  .176432D+00, .143105D+00, .115165D+00, .918832D-01,
     +  .726023D-01, .567583D-01, .438446D-01, .333939D-01,
     +  .251082D-01, .185207D-01, .133946D-01, .947023D-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .651973D-02, .435101D-02, .279608D-02, .171941D-02,
     +  .996760D-03, .539449D-03, .265913D-03, .115557D-03,
     +  .418379D-04, .114270D-04, .191670D-05, .108460D-06,
     +  .000000D+00, .410945D+06, .315609D+06, .238881D+06,
     +  .180761D+06, .136763D+06, .103448D+06, .782385D+05,
     +  .591582D+05, .447273D+05, .338096D+05, .255558D+05,
     +  .193140D+05, .145972D+05, .110314D+05, .833782D+04,
     +  .630219D+04, .476488D+04, .360334D+04, .272629D+04,
     +  .206366D+04, .156335D+04, .118531D+04, .899780D+03,
     +  .683931D+03, .520793D+03, .397371D+03, .304033D+03,
     +  .232406D+03, .178981D+03, .138381D+03, .107505D+03,
     +  .839511D+02, .659506D+02, .521776D+02, .415529D+02,
     +  .333377D+02, .269591D+02, .219707D+02, .180473D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .149333D+02, .124476D+02, .104403D+02, .880676D+01,
     +  .746426D+01, .635210D+01, .542241D+01, .464274D+01,
     +  .397753D+01, .341430D+01, .292894D+01, .251352D+01,
     +  .215552D+01, .184648D+01, .157938D+01, .134838D+01,
     +  .114863D+01, .975965D+00, .826914D+00, .698415D+00,
     +  .587856D+00, .492924D+00, .411656D+00, .342178D+00,
     +  .283284D+00, .232978D+00, .190477D+00, .154709D+00,
     +  .124761D+00, .998124D-01, .791559D-01, .621603D-01,
     +  .482878D-01, .370590D-01, .280347D-01, .209316D-01,
     +  .153268D-01, .109996D-01, .771411D-02, .526527D-02,
     +  .348179D-02, .221543D-02, .134788D-02, .772202D-03,
     +  .412489D-03, .200335D-03, .855829D-04, .303616D-04,
     +  .809156D-05, .132190D-05, .754130D-07, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .556205D+06, .425359D+06, .320353D+06, .241189D+06,
     +  .181546D+06, .136602D+06, .102763D+06, .772791D+05,
     +  .581037D+05, .436726D+05, .328204D+05, .246583D+05,
     +  .185242D+05, .139133D+05, .104500D+05, .784816D+04,
     +  .589487D+04, .442805D+04, .332732D+04, .250100D+04,
     +  .188110D+04, .141578D+04, .106669D+04, .804601D+03,
     +  .607891D+03, .460125D+03, .349189D+03, .264687D+03,
     +  .202130D+03, .154953D+03, .119347D+03, .923961D+02,
     +  .719577D+02, .564421D+02, .445652D+02, .354534D+02,
     +  .284323D+02, .229832D+02, .187292D+02, .153777D+02,
     +  .127215D+02, .105919D+02, .887084D+01, .746629D+01,
     +  .631070D+01, .535136D+01, .455231D+01, .387523D+01,
     +  .330586D+01, .281856D+01, .240430D+01, .204971D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .174565D+01, .148459D+01, .126028D+01, .106758D+01,
     +  .902069D+00, .760096D+00, .638463D+00, .534462D+00,
     +  .445711D+00, .370199D+00, .306029D+00, .251965D+00,
     +  .206065D+00, .167522D+00, .135286D+00, .108464D+00,
     +  .862596D-01, .679930D-01, .530619D-01, .409564D-01,
     +  .312260D-01, .234603D-01, .173926D-01, .126411D-01,
     +  .900180D-02, .626156D-02, .423699D-02, .277615D-02,
     +  .174904D-02, .105291D-02, .596253D-03, .314497D-03,
     +  .150616D-03, .633496D-04, .220886D-04, .578068D-05,
     +  .932101D-06, .544882D-07, .000000D+00, .736414D+06,
     +  .560940D+06, .420500D+06, .315091D+06, .236031D+06,
     +  .176730D+06, .132286D+06, .989759D+05, .740314D+05,
     +  .553508D+05, .413729D+05, .309133D+05, .230930D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .172458D+05, .128774D+05, .961346D+04, .717680D+04,
     +  .535742D+04, .400003D+04, .298706D+04, .223171D+04,
     +  .166821D+04, .124811D+04, .934729D+03, .701055D+03,
     +  .526684D+03, .396663D+03, .298314D+03, .226017D+03,
     +  .171884D+03, .131320D+03, .100841D+03, .778943D+02,
     +  .606034D+02, .474637D+02, .374575D+02, .298025D+02,
     +  .239046D+02, .193323D+02, .157553D+02, .129396D+02,
     +  .106975D+02, .889745D+01, .743826D+01, .624555D+01,
     +  .526192D+01, .444799D+01, .376284D+01, .319046D+01,
     +  .270381D+01, .229281D+01, .194330D+01, .164554D+01,
     +  .139153D+01, .117467D+01, .989533D+00, .831519D+00,
     +  .696817D+00, .582122D+00, .484651D+00, .401978D+00,
     +  .332062D+00, .273000D+00, .223537D+00, .181797D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .146960D+00, .118002D+00, .940565D-01, .743578D-01,
     +  .582559D-01, .451798D-01, .346494D-01, .262435D-01,
     +  .195816D-01, .144144D-01, .103988D-01, .734748D-02,
     +  .506908D-02, .340045D-02, .220759D-02, .137712D-02,
     +  .820266D-03, .459154D-03, .239144D-03, .112943D-03,
     +  .467786D-04, .160371D-04, .412464D-05, .657369D-06,
     +  .393907D-07, .000000D+00, .957551D+06, .726627D+06,
     +  .542279D+06, .404508D+06, .301621D+06, .224785D+06,
     +  .167457D+06, .124685D+06, .928017D+05, .690368D+05,
     +  .513390D+05, .381601D+05, .283553D+05, .210609D+05,
     +  .156392D+05, .116094D+05, .861690D+04, .639458D+04,
     +  .474567D+04, .352208D+04, .261487D+04, .194206D+04,
     +  .144342D+04, .107372D+04, .799760D+03, .596605D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .446099D+03, .333006D+03, .250425D+03, .189011D+03,
     +  .143303D+03, .109197D+03, .836976D+02, .646176D+02,
     +  .502185D+02, .393299D+02, .310570D+02, .247267D+02,
     +  .198520D+02, .160639D+02, .131013D+02, .107574D+02,
     +  .888761D+01, .738149D+01, .615814D+01, .515560D+01,
     +  .433124D+01, .364170D+01, .306929D+01, .258573D+01,
     +  .217992D+01, .183702D+01, .154672D+01, .130063D+01,
     +  .109183D+01, .914691D+00, .764423D+00, .637105D+00,
     +  .529351D+00, .438330D+00, .361591D+00, .297080D+00,
     +  .242905D+00, .197804D+00, .159973D+00, .128589D+00,
     +  .102660D+00, .813513D-01, .639315D-01, .497828D-01,
     +  .383677D-01, .292364D-01, .219976D-01, .163006D-01,
     +  .119141D-01, .853105D-02, .598083D-02, .409241D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .272152D-02, .175056D-02, .108124D-02, .637226D-03,
     +  .352584D-03, .181337D-03, .844621D-04, .344519D-04,
     +  .116160D-04, .293725D-05, .462850D-06, .284166D-07,
     +  .000000D+00, .122598D+07, .926928D+06, .688784D+06,
     +  .511550D+06, .379744D+06, .281732D+06, .208919D+06,
     +  .154832D+06, .114695D+06, .849121D+05, .628348D+05,
     +  .464717D+05, .343555D+05, .253852D+05, .187506D+05,
     +  .138440D+05, .102189D+05, .754076D+04, .556416D+04,
     +  .410531D+04, .302960D+04, .223627D+04, .165168D+04,
     +  .122077D+04, .903332D+03, .669351D+03, .497078D+03,
     +  .368446D+03, .275117D+03, .206161D+03, .155171D+03,
     +  .117377D+03, .893059D+02, .684423D+02, .528013D+02,
     +  .410526D+02, .321844D+02, .254431D+02, .202851D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .163023D+02, .132066D+02, .107727D+02, .884269D+01,
     +  .729760D+01, .605013D+01, .503401D+01, .420356D+01,
     +  .351317D+01, .294356D+01, .246535D+01, .206649D+01,
     +  .173155D+01, .144973D+01, .121229D+01, .101207D+01,
     +  .843226D+00, .700863D+00, .580966D+00, .480098D+00,
     +  .395400D+00, .324415D+00, .265093D+00, .215567D+00,
     +  .174579D+00, .140403D+00, .112221D+00, .890796D-01,
     +  .701778D-01, .548224D-01, .424295D-01, .324960D-01,
     +  .246029D-01, .183888D-01, .135324D-01, .982052D-02,
     +  .697944D-02, .485481D-02, .329463D-02, .217197D-02,
     +  .138419D-02, .846494D-03, .493600D-03, .269967D-03,
     +  .137109D-03, .629857D-04, .253051D-04, .839322D-05,
     +  .208734D-05, .325298D-06, .204533D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .154834D+07, .116651D+07, .863180D+06, .638349D+06,
     +  .471830D+06, .348519D+06, .257296D+06, .189825D+06,
     +  .139970D+06, .103141D+06, .759621D+05, .559092D+05,
     +  .411292D+05, .302383D+05, .222213D+05, .163212D+05,
     +  .119836D+05, .879518D+04, .645395D+04, .473498D+04,
     +  .347416D+04, .254935D+04, .187160D+04, .137483D+04,
     +  .101096D+04, .744297D+03, .549129D+03, .404287D+03,
     +  .299843D+03, .223153D+03, .166798D+03, .125292D+03,
     +  .946597D+02, .720382D+02, .551867D+02, .426096D+02,
     +  .331755D+02, .260491D+02, .206296D+02, .164704D+02,
     +  .132566D+02, .107447D+02, .876448D+01, .718843D+01,
     +  .592334D+01, .489887D+01, .406650D+01, .337861D+01,
     +  .281444D+01, .234364D+01, .195332D+01, .162753D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .135506D+01, .112687D+01, .935603D+00, .775273D+00,
     +  .640891D+00, .528385D+00, .434293D+00, .355749D+00,
     +  .290308D+00, .235939D+00, .190811D+00, .153682D+00,
     +  .122907D+00, .976821D-01, .770935D-01, .603801D-01,
     +  .468870D-01, .360662D-01, .274493D-01, .206480D-01,
     +  .153303D-01, .112036D-01, .807245D-02, .569411D-02,
     +  .392970D-02, .264485D-02, .172842D-02, .109133D-02,
     +  .660788D-03, .381231D-03, .206107D-03, .103368D-03,
     +  .468373D-04, .185365D-04, .604964D-05, .148024D-05,
     +  .228204D-06, .146881D-07, .000000D+00, .193143D+07,
     +  .145010D+07, .106863D+07, .787011D+06, .579263D+06,
     +  .426051D+06, .313171D+06, .230032D+06, .168860D+06,
     +  .123865D+06, .908043D+05, .665201D+05, .487016D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .356318D+05, .260555D+05, .190411D+05, .139089D+05,
     +  .101549D+05, .741199D+04, .540830D+04, .394617D+04,
     +  .287931D+04, .210163D+04, .153469D+04, .112171D+04,
     +  .820753D+03, .601745D+03, .440165D+03, .324342D+03,
     +  .239806D+03, .178059D+03, .132860D+03, .997037D+02,
     +  .753697D+02, .573527D+02, .439882D+02, .340236D+02,
     +  .265416D+02, .208848D+02, .165688D+02, .132527D+02,
     +  .106755D+02, .865508D+01, .705608D+01, .577971D+01,
     +  .475193D+01, .392162D+01, .323936D+01, .268305D+01,
     +  .222153D+01, .184116D+01, .152554D+01, .126313D+01,
     +  .104467D+01, .862626D+00, .710928D+00, .584527D+00,
     +  .479322D+00, .391848D+00, .319253D+00, .259122D+00,
     +  .209452D+00, .168465D+00, .134939D+00, .107315D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .848066D-01, .665469D-01, .518145D-01, .399948D-01,
     +  .305761D-01, .231246D-01, .172823D-01, .127459D-01,
     +  .925014D-02, .661724D-02, .463255D-02, .317195D-02,
     +  .211719D-02, .137152D-02, .857950D-03, .514328D-03,
     +  .293587D-03, .156895D-03, .777066D-04, .347312D-04,
     +  .135419D-04, .434981D-05, .104751D-05, .159799D-06,
     +  .105244D-07, .000000D+00, .238203D+07, .178238D+07,
     +  .130822D+07, .959553D+06, .703352D+06, .515160D+06,
     +  .377069D+06, .275777D+06, .201558D+06, .147196D+06,
     +  .107423D+06, .783350D+05, .570854D+05, .415686D+05,
     +  .302506D+05, .219989D+05, .159895D+05, .116148D+05,
     +  .843376D+04, .612147D+04, .444256D+04, .322376D+04,
     +  .233990D+04, .169896D+04, .123457D+04, .897974D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .654396D+03, .475709D+03, .348357D+03, .255945D+03,
     +  .188835D+03, .140001D+03, .104388D+03, .784062D+02,
     +  .592814D+02, .451786D+02, .347240D+02, .269192D+02,
     +  .210514D+02, .165993D+02, .131971D+02, .105674D+02,
     +  .851687D+01, .690276D+01, .562128D+01, .459500D+01,
     +  .377047D+01, .309674D+01, .255049D+01, .209991D+01,
     +  .173069D+01, .142610D+01, .117432D+01, .965924D+00,
     +  .793280D+00, .650248D+00, .531760D+00, .433709D+00,
     +  .352656D+00, .285778D+00, .230702D+00, .185470D+00,
     +  .148359D+00, .118181D+00, .934614D-01, .734399D-01,
     +  .572953D-01, .443490D-01, .340270D-01, .258538D-01,
     +  .194298D-01, .144267D-01, .105687D-01, .761662D-02,
     +  .540953D-02, .375851D-02, .255318D-02, .169005D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .108524D-02, .672555D-03, .399182D-03, .225442D-03,
     +  .119092D-03, .582499D-04, .256831D-04, .986714D-05,
     +  .312014D-05, .739758D-06, .111701D-06, .752451D-08,
     +  .000000D+00, .290677D+07, .216785D+07, .158488D+07,
     +  .115785D+07, .845278D+06, .616583D+06, .449434D+06,
     +  .327322D+06, .238210D+06, .173212D+06, .125854D+06,
     +  .913661D+05, .662800D+05, .480419D+05, .347979D+05,
     +  .251854D+05, .182169D+05, .131676D+05, .951332D+04,
     +  .686978D+04, .495968D+04, .357993D+04, .258438D+04,
     +  .186614D+04, .134845D+04, .975190D+03, .706540D+03,
     +  .510546D+03, .371635D+03, .271401D+03, .199018D+03,
     +  .146647D+03, .108671D+03, .811225D+02, .609590D+02,
     +  .461742D+02, .352746D+02, .271825D+02, .211313D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .165644D+02, .130928D+02, .104233D+02, .835243D+01,
     +  .673083D+01, .545011D+01, .442984D+01, .361455D+01,
     +  .295199D+01, .241775D+01, .197955D+01, .162251D+01,
     +  .132964D+01, .108892D+01, .890830D+00, .727660D+00,
     +  .593251D+00, .482546D+00, .391460D+00, .316596D+00,
     +  .255178D+00, .204889D+00, .163825D+00, .130328D+00,
     +  .103246D+00, .811924D-01, .634364D-01, .492049D-01,
     +  .378623D-01, .288753D-01, .218043D-01, .162828D-01,
     +  .120114D-01, .874021D-02, .625481D-02, .441032D-02,
     +  .304108D-02, .204948D-02, .134535D-02, .856315D-03,
     +  .525743D-03, .308942D-03, .172626D-03, .901434D-04,
     +  .435440D-04, .189411D-04, .717123D-05, .223292D-05,
     +  .521377D-06, .779458D-07, .536826D-08, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
