#include "pdf/pilot.h"
*********************************************************************
*                                                                   *
*    POLARIZED RADIATIVELY GENERATED LO AND NLO PARTON DENSITIES    *
*                         AND DIS ASYMMETRIES                       *
*                                                                   *
*         M. GLUCK, E. REYA, M. STRATMANN AND W. VOGELSANG,         *
*                  (PHYS. REV. D53 (1996) 4775)                     *       
*          PROBLEMS/QUESTIONS TO VOGELSANG@V2.RL.AC.UK              *
*            OR TO STRAT@HAL1.PHYSIK.UNI-DORTMUND.DE                *
*                                                                   *
*   INPUT:   ISET = number of the parton set :                      *
*              ISET = 1  'STANDARD' SCENARIO, NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   * 
*                        (DATA FILE 'STDNLOA1.GRID' UNIT=11, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 2  'VALENCE' SCENARIO,  NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   *  
*                        (DATA FILE 'VALNLOA1.GRID' UNIT=22, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 3  'STANDARD' SCENARIO, LEADING ORDER         *
*                        (DATA FILE 'STDLOA1.GRID' UNIT=33, TO BE   *
*                         DEFINED BY THE USER )                     *
*              ISET = 4  'VALENCE' SCENARIO,  LEADING ORDER         *
*                        (DATA FILE 'VALLOA1.GRID' UNIT=44, TO BE   *
*                         DEFINED BY THE USER )                     *
*                                                                   *
*            X  = Bjorken-x       (between  1.E-4  and  1)          *
*            Q2 = scale in GeV**2 (between  0.4  and   1.E4)        *
*             (for values outside the allowed range the program     *
*              writes a warning and extrapolates to the x and       *
*              Q2 values requested)                                 *
*                                                                   *
*   OUTPUT:  UV = x * ( DELTA u - DELTA u(bar) ),                   *
*            DV = x * ( DELTA d - DELTA d(bar) ),                   *        
*            QB = x * POLARIZED LIGHT SEA,                          *   
*                 QB= x * ( (DELTA U(BAR) + DELTA D(BAR))/2 )       * 
*            ST = x * DELTA STRANGE = x * DELTA STRANGE(BAR)        *     
*            GL = x * DELTA GLUON                                   *
*                                                                   *
*          (  For the parton distributions always x times           *
*                   the distribution is returned   )                *
*                                                                   *
*            A1P = A1-Proton                                        *
*            A1N = A1-Neutron                                       *
*            A1D = A1-Deuteron                                      *
*                                                                   *
*            The sets are the result of a combined fit to           *
*            data for the spin asymmetries A_1 (p,n,d)              *
*                                                                   *
*            Note: No charm is included                             *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINI / IINI , and  IINI     *
*            has always to be zero when PARPOL is called for the    *
*            first time or when 'ISET' has been changed.            *
*                                                                   *
*********************************************************************
*
      SUBROUTINE GRSVH2 (DX,DQ,DUV,DDV,DSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRSVH2 (X, Q2, UV, DV, QB, ST, GL, A1P, A1N, A1D)
#include "pdf/impdp.inc"
      PARAMETER (NPART=8, NX=42, NQ=25, NARG=2)
      DIMENSION
     +          XUVF(NX,NQ), XDVF(NX,NQ), XQBF(NX,NQ), 
     1          XSF(NX,NQ), XGF(NX,NQ), 
     2          XAPF(NX,NQ), XANF(NX,NQ), XADF(NX,NQ),
     3          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ)
      DIMENSION
     +        PARTON (NPART,NQ,NX-1)
      COMMON / GRSVA1 / A1P, A1N, A1D
C      COMMON / INTINI / IINI
      SAVE XUVF, XDVF, XQBF, XSF, XGF, XAPF, XANF, XADF, NA, ARRF
       DATA ZEROD/0.D0/
*...BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.4D0, 0.5d0, 0.6d0, 0.75D0, 1.0D0,
     1           1.25d0, 1.5D0, 2.d0, 2.5D0, 
     1           4.0D0, 6.4D0, 1.0D1, 1.5D1, 2.5D1, 4.0D1, 6.4D1,
     2           1.0D2, 1.8D2, 3.2D2, 5.8D2, 1.0D3, 1.8D3,
     3           3.2D3, 5.8D3, 1.0D4 /
       DATA XB / 1.D-4, 1.5D-4, 2.2D-4, 3.2D-4, 4.8D-4, 7.D-4,
     2           1.D-3, 1.5D-3, 2.2D-3, 3.2D-3, 4.8D-3, 7.D-3,
     3           1.D-2, 1.5D-2, 2.2D-2, 3.2D-2, 5.0D-2, 7.5D-2,
     4           0.1D0, 0.125D0, 0.15D0, 0.175D0, 0.2D0, 0.225D0, 
     +           0.25D0, 0.275D0,
     5           0.3D0, 0.325D0, 0.35D0, 0.375D0, 0.4D0, 0.45D0,  
     +           0.5D0, 0.55D0,
     6           0.6D0, 0.65D0,  0.7D0,  0.75D0,  0.8D0, 0.85D0,  
     +           0.9D0, 1.0D0 /
       DATA IINI/0/
C
        DATA ((PARTON(I,N,1),I=1,8),N=1,8)/
     +   .9740D-03, -.3008D-02, -.3088D-03, -.5819D-04,  .8630D-03,
     +  -.1385D-02, -.2221D-01, -.1087D-01,
     +   .1208D-02, -.3194D-02, -.4786D-03, -.1735D-03,  .3024D-02,
     +  -.1334D-02, -.1431D-01, -.7178D-02,
     +   .1382D-02, -.3327D-02, -.6301D-03, -.2854D-03,  .5441D-02,
     +  -.1382D-02, -.1125D-01, -.5785D-02,
     +   .1579D-02, -.3474D-02, -.8216D-03, -.4332D-03,  .8997D-02,
     +  -.1456D-02, -.9099D-02, -.4831D-02,
     +   .1810D-02, -.3641D-02, -.1069D-02, -.6303D-03,  .1430D-01,
     +  -.1537D-02, -.7498D-02, -.4132D-02,
     +   .1975D-02, -.3757D-02, -.1258D-02, -.7834D-03,  .1884D-01,
     +  -.1583D-02, -.6696D-02, -.3784D-02,
     +   .2103D-02, -.3846D-02, -.1408D-02, -.9070D-03,  .2275D-01,
     +  -.1609D-02, -.6200D-02, -.3568D-02,
     +   .2293D-02, -.3975D-02, -.1639D-02, -.1098D-02,  .2924D-01,
     +  -.1633D-02, -.5602D-02, -.3305D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=9,16)/
     +   .2434D-02, -.4068D-02, -.1804D-02, -.1233D-02,  .3442D-01,
     +  -.1635D-02, -.5254D-02, -.3147D-02,
     +   .2708D-02, -.4246D-02, -.2109D-02, -.1484D-02,  .4527D-01,
     +  -.1605D-02, -.4704D-02, -.2882D-02,
     +   .2965D-02, -.4409D-02, -.2404D-02, -.1728D-02,  .5690D-01,
     +  -.1564D-02, -.4264D-02, -.2662D-02,
     +   .3196D-02, -.4553D-02, -.2674D-02, -.1952D-02,  .6857D-01,
     +  -.1521D-02, -.3925D-02, -.2487D-02,
     +   .3397D-02, -.4676D-02, -.2911D-02, -.2150D-02,  .7962D-01,
     +  -.1481D-02, -.3668D-02, -.2351D-02,
     +   .3639D-02, -.4822D-02, -.3195D-02, -.2388D-02,  .9405D-01,
     +  -.1431D-02, -.3400D-02, -.2206D-02,
     +   .3852D-02, -.4948D-02, -.3443D-02, -.2596D-02,  .1078D+00,
     +  -.1386D-02, -.3193D-02, -.2091D-02,
     +   .4059D-02, -.5070D-02, -.3683D-02, -.2798D-02,  .1220D+00,
     +  -.1343D-02, -.3014D-02, -.1989D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=17,25)/
     +   .4251D-02, -.5181D-02, -.3905D-02, -.2984D-02,  .1360D+00,
     +  -.1304D-02, -.2862D-02, -.1902D-02,
     +   .4496D-02, -.5322D-02, -.4186D-02, -.3219D-02,  .1550D+00,
     +  -.1256D-02, -.2690D-02, -.1801D-02,
     +   .4729D-02, -.5453D-02, -.4449D-02, -.3440D-02,  .1742D+00,
     +  -.1211D-02, -.2543D-02, -.1714D-02,
     +   .4962D-02, -.5584D-02, -.4709D-02, -.3658D-02,  .1946D+00,
     +  -.1169D-02, -.2410D-02, -.1634D-02,
     +   .5171D-02, -.5700D-02, -.4936D-02, -.3848D-02,  .2137D+00,
     +  -.1132D-02, -.2302D-02, -.1568D-02,
     +   .5390D-02, -.5820D-02, -.5170D-02, -.4043D-02,  .2347D+00,
     +  -.1094D-02, -.2198D-02, -.1503D-02,
     +   .5599D-02, -.5934D-02, -.5388D-02, -.4224D-02,  .2556D+00,
     +  -.1060D-02, -.2106D-02, -.1445D-02,
     +   .5810D-02, -.6048D-02, -.5601D-02, -.4400D-02,  .2776D+00,
     +  -.1026D-02, -.2021D-02, -.1391D-02,
     +   .5999D-02, -.6149D-02, -.5786D-02, -.4552D-02,  .2980D+00,
     +  -.9962D-03, -.1949D-02, -.1345D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=1,8)/
     +   .1310D-02, -.3489D-02, -.4222D-03, -.7981D-04,  .1214D-02,
     +  -.9882D-03, -.2526D-01, -.1209D-01,
     +   .1617D-02, -.3712D-02, -.6388D-03, -.2264D-03,  .3993D-02,
     +  -.1223D-02, -.1717D-01, -.8439D-02,
     +   .1845D-02, -.3872D-02, -.8259D-03, -.3627D-03,  .6974D-02,
     +  -.1404D-02, -.1383D-01, -.6980D-02,
     +   .2102D-02, -.4047D-02, -.1057D-02, -.5375D-03,  .1125D-01,
     +  -.1581D-02, -.1140D-01, -.5944D-02,
     +   .2403D-02, -.4247D-02, -.1348D-02, -.7647D-03,  .1750D-01,
     +  -.1740D-02, -.9533D-02, -.5156D-02,
     +   .2618D-02, -.4386D-02, -.1566D-02, -.9376D-03,  .2275D-01,
     +  -.1820D-02, -.8570D-02, -.4749D-02,
     +   .2783D-02, -.4492D-02, -.1738D-02, -.1075D-02,  .2725D-01,
     +  -.1865D-02, -.7966D-02, -.4493D-02,
     +   .3029D-02, -.4646D-02, -.1998D-02, -.1285D-02,  .3463D-01,
     +  -.1908D-02, -.7222D-02, -.4171D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=9,16)/
     +   .3212D-02, -.4759D-02, -.2182D-02, -.1432D-02,  .4047D-01,
     +  -.1912D-02, -.6776D-02, -.3969D-02,
     +   .3564D-02, -.4971D-02, -.2518D-02, -.1699D-02,  .5264D-01,
     +  -.1873D-02, -.6063D-02, -.3625D-02,
     +   .3894D-02, -.5166D-02, -.2839D-02, -.1956D-02,  .6559D-01,
     +  -.1822D-02, -.5494D-02, -.3341D-02,
     +   .4190D-02, -.5337D-02, -.3130D-02, -.2190D-02,  .7849D-01,
     +  -.1769D-02, -.5057D-02, -.3117D-02,
     +   .4446D-02, -.5484D-02, -.3383D-02, -.2394D-02,  .9066D-01,
     +  -.1721D-02, -.4725D-02, -.2943D-02,
     +   .4754D-02, -.5658D-02, -.3683D-02, -.2637D-02,  .1065D+00,
     +  -.1661D-02, -.4377D-02, -.2757D-02,
     +   .5026D-02, -.5809D-02, -.3942D-02, -.2846D-02,  .1214D+00,
     +  -.1605D-02, -.4111D-02, -.2610D-02,
     +   .5290D-02, -.5954D-02, -.4191D-02, -.3048D-02,  .1369D+00,
     +  -.1553D-02, -.3878D-02, -.2479D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=17,25)/
     +   .5533D-02, -.6086D-02, -.4419D-02, -.3231D-02,  .1520D+00,
     +  -.1505D-02, -.3683D-02, -.2369D-02,
     +   .5843D-02, -.6253D-02, -.4704D-02, -.3461D-02,  .1724D+00,
     +  -.1446D-02, -.3459D-02, -.2240D-02,
     +   .6137D-02, -.6410D-02, -.4969D-02, -.3673D-02,  .1930D+00,
     +  -.1391D-02, -.3268D-02, -.2127D-02,
     +   .6432D-02, -.6565D-02, -.5227D-02, -.3879D-02,  .2147D+00,
     +  -.1339D-02, -.3094D-02, -.2024D-02,
     +   .6695D-02, -.6702D-02, -.5449D-02, -.4056D-02,  .2350D+00,
     +  -.1292D-02, -.2954D-02, -.1939D-02,
     +   .6971D-02, -.6845D-02, -.5676D-02, -.4235D-02,  .2572D+00,
     +  -.1246D-02, -.2818D-02, -.1855D-02,
     +   .7234D-02, -.6980D-02, -.5883D-02, -.4397D-02,  .2793D+00,
     +  -.1202D-02, -.2698D-02, -.1781D-02,
     +   .7499D-02, -.7115D-02, -.6084D-02, -.4552D-02,  .3023D+00,
     +  -.1160D-02, -.2586D-02, -.1710D-02,
     +   .7736D-02, -.7235D-02, -.6255D-02, -.4684D-02,  .3237D+00,
     +  -.1122D-02, -.2492D-02, -.1650D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=1,8)/
     +   .1734D-02, -.4022D-02, -.5654D-03, -.1057D-03,  .1639D-02,
     +  -.4290D-03, -.2842D-01, -.1329D-01,
     +   .2131D-02, -.4286D-02, -.8356D-03, -.2873D-03,  .5118D-02,
     +  -.9770D-03, -.2028D-01, -.9756D-02,
     +   .2425D-02, -.4477D-02, -.1062D-02, -.4496D-03,  .8715D-02,
     +  -.1316D-02, -.1673D-01, -.8270D-02,
     +   .2754D-02, -.4685D-02, -.1335D-02, -.6522D-03,  .1376D-01,
     +  -.1617D-02, -.1406D-01, -.7171D-02,
     +   .3140D-02, -.4923D-02, -.1672D-02, -.9089D-03,  .2098D-01,
     +  -.1873D-02, -.1191D-01, -.6302D-02,
     +   .3415D-02, -.5089D-02, -.1920D-02, -.1100D-02,  .2697D-01,
     +  -.2000D-02, -.1077D-01, -.5839D-02,
     +   .3626D-02, -.5214D-02, -.2113D-02, -.1251D-02,  .3205D-01,
     +  -.2070D-02, -.1005D-01, -.5537D-02,
     +   .3939D-02, -.5398D-02, -.2402D-02, -.1477D-02,  .4034D-01,
     +  -.2137D-02, -.9138D-02, -.5152D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=9,16)/
     +   .4171D-02, -.5531D-02, -.2604D-02, -.1633D-02,  .4685D-01,
     +  -.2146D-02, -.8582D-02, -.4901D-02,
     +   .4617D-02, -.5783D-02, -.2971D-02, -.1915D-02,  .6035D-01,
     +  -.2101D-02, -.7679D-02, -.4467D-02,
     +   .5033D-02, -.6013D-02, -.3317D-02, -.2182D-02,  .7462D-01,
     +  -.2043D-02, -.6963D-02, -.4113D-02,
     +   .5406D-02, -.6217D-02, -.3626D-02, -.2422D-02,  .8875D-01,
     +  -.1983D-02, -.6409D-02, -.3832D-02,
     +   .5728D-02, -.6390D-02, -.3893D-02, -.2629D-02,  .1020D+00,
     +  -.1928D-02, -.5990D-02, -.3616D-02,
     +   .6115D-02, -.6596D-02, -.4206D-02, -.2871D-02,  .1191D+00,
     +  -.1857D-02, -.5551D-02, -.3382D-02,
     +   .6455D-02, -.6774D-02, -.4474D-02, -.3078D-02,  .1353D+00,
     +  -.1792D-02, -.5212D-02, -.3198D-02,
     +   .6784D-02, -.6945D-02, -.4729D-02, -.3275D-02,  .1519D+00,
     +  -.1730D-02, -.4916D-02, -.3034D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=17,25)/
     +   .7088D-02, -.7101D-02, -.4959D-02, -.3451D-02,  .1681D+00,
     +  -.1673D-02, -.4669D-02, -.2895D-02,
     +   .7474D-02, -.7298D-02, -.5244D-02, -.3670D-02,  .1899D+00,
     +  -.1603D-02, -.4383D-02, -.2732D-02,
     +   .7840D-02, -.7483D-02, -.5505D-02, -.3867D-02,  .2116D+00,
     +  -.1537D-02, -.4140D-02, -.2592D-02,
     +   .8207D-02, -.7666D-02, -.5756D-02, -.4056D-02,  .2346D+00,
     +  -.1473D-02, -.3917D-02, -.2461D-02,
     +   .8532D-02, -.7827D-02, -.5970D-02, -.4214D-02,  .2559D+00,
     +  -.1417D-02, -.3738D-02, -.2353D-02,
     +   .8874D-02, -.7995D-02, -.6184D-02, -.4371D-02,  .2792D+00,
     +  -.1359D-02, -.3562D-02, -.2247D-02,
     +   .9199D-02, -.8153D-02, -.6377D-02, -.4510D-02,  .3022D+00,
     +  -.1306D-02, -.3408D-02, -.2152D-02,
     +   .9526D-02, -.8312D-02, -.6560D-02, -.4639D-02,  .3262D+00,
     +  -.1253D-02, -.3264D-02, -.2062D-02,
     +   .9819D-02, -.8453D-02, -.6714D-02, -.4745D-02,  .3483D+00,
     +  -.1207D-02, -.3142D-02, -.1985D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=1,8)/
     +   .2283D-02, -.4630D-02, -.7502D-03, -.1369D-03,  .2158D-02,
     +   .3402D-03, -.3178D-01, -.1446D-01,
     +   .2792D-02, -.4946D-02, -.1083D-02, -.3583D-03,  .6442D-02,
     +  -.5442D-03, -.2375D-01, -.1114D-01,
     +   .3168D-02, -.5172D-02, -.1353D-02, -.5486D-03,  .1072D-01,
     +  -.1067D-02, -.2005D-01, -.9671D-02,
     +   .3588D-02, -.5420D-02, -.1672D-02, -.7799D-03,  .1660D-01,
     +  -.1519D-02, -.1714D-01, -.8537D-02,
     +   .4079D-02, -.5702D-02, -.2058D-02, -.1065D-02,  .2485D-01,
     +  -.1894D-02, -.1472D-01, -.7595D-02,
     +   .4427D-02, -.5899D-02, -.2336D-02, -.1274D-02,  .3162D-01,
     +  -.2077D-02, -.1339D-01, -.7071D-02,
     +   .4695D-02, -.6048D-02, -.2551D-02, -.1436D-02,  .3731D-01,
     +  -.2179D-02, -.1253D-01, -.6723D-02,
     +   .5091D-02, -.6266D-02, -.2868D-02, -.1676D-02,  .4652D-01,
     +  -.2279D-02, -.1144D-01, -.6269D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=9,16)/
     +   .5383D-02, -.6424D-02, -.3088D-02, -.1840D-02,  .5372D-01,
     +  -.2298D-02, -.1076D-01, -.5966D-02,
     +   .5943D-02, -.6722D-02, -.3486D-02, -.2133D-02,  .6861D-01,
     +  -.2255D-02, -.9641D-02, -.5433D-02,
     +   .6464D-02, -.6995D-02, -.3855D-02, -.2406D-02,  .8423D-01,
     +  -.2195D-02, -.8750D-02, -.4998D-02,
     +   .6930D-02, -.7235D-02, -.4181D-02, -.2648D-02,  .9961D-01,
     +  -.2131D-02, -.8062D-02, -.4654D-02,
     +   .7332D-02, -.7439D-02, -.4459D-02, -.2854D-02,  .1140D+00,
     +  -.2071D-02, -.7538D-02, -.4387D-02,
     +   .7813D-02, -.7682D-02, -.4782D-02, -.3092D-02,  .1324D+00,
     +  -.1991D-02, -.6988D-02, -.4100D-02,
     +   .8236D-02, -.7892D-02, -.5055D-02, -.3291D-02,  .1498D+00,
     +  -.1917D-02, -.6563D-02, -.3872D-02,
     +   .8644D-02, -.8093D-02, -.5312D-02, -.3478D-02,  .1675D+00,
     +  -.1846D-02, -.6192D-02, -.3669D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=17,25)/
     +   .9020D-02, -.8277D-02, -.5541D-02, -.3643D-02,  .1847D+00,
     +  -.1780D-02, -.5880D-02, -.3497D-02,
     +   .9498D-02, -.8508D-02, -.5822D-02, -.3843D-02,  .2077D+00,
     +  -.1697D-02, -.5519D-02, -.3295D-02,
     +   .9949D-02, -.8725D-02, -.6074D-02, -.4019D-02,  .2307D+00,
     +  -.1619D-02, -.5212D-02, -.3118D-02,
     +   .1040D-01, -.8939D-02, -.6313D-02, -.4183D-02,  .2547D+00,
     +  -.1542D-02, -.4930D-02, -.2955D-02,
     +   .1080D-01, -.9128D-02, -.6512D-02, -.4317D-02,  .2770D+00,
     +  -.1476D-02, -.4703D-02, -.2821D-02,
     +   .1122D-01, -.9324D-02, -.6708D-02, -.4445D-02,  .3012D+00,
     +  -.1406D-02, -.4480D-02, -.2687D-02,
     +   .1162D-01, -.9510D-02, -.6881D-02, -.4554D-02,  .3250D+00,
     +  -.1341D-02, -.4283D-02, -.2567D-02,
     +   .1202D-01, -.9695D-02, -.7042D-02, -.4650D-02,  .3497D+00,
     +  -.1276D-02, -.4097D-02, -.2453D-02,
     +   .1238D-01, -.9859D-02, -.7173D-02, -.4725D-02,  .3724D+00,
     +  -.1218D-02, -.3942D-02, -.2355D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=1,8)/
     +   .3077D-02, -.5408D-02, -.1016D-02, -.1782D-03,  .2853D-02,
     +   .1493D-02, -.3570D-01, -.1571D-01,
     +   .3742D-02, -.5790D-02, -.1427D-02, -.4486D-03,  .8152D-02,
     +   .2255D-03, -.2798D-01, -.1272D-01,
     +   .4231D-02, -.6065D-02, -.1752D-02, -.6715D-03,  .1326D-01,
     +  -.5210D-03, -.2419D-01, -.1131D-01,
     +   .4777D-02, -.6365D-02, -.2125D-02, -.9345D-03,  .2013D-01,
     +  -.1165D-02, -.2106D-01, -.1017D-01,
     +   .5412D-02, -.6706D-02, -.2567D-02, -.1250D-02,  .2960D-01,
     +  -.1697D-02, -.1836D-01, -.9165D-02,
     +   .5862D-02, -.6944D-02, -.2879D-02, -.1475D-02,  .3725D-01,
     +  -.1957D-02, -.1683D-01, -.8584D-02,
     +   .6206D-02, -.7124D-02, -.3117D-02, -.1647D-02,  .4364D-01,
     +  -.2104D-02, -.1581D-01, -.8184D-02,
     +   .6715D-02, -.7387D-02, -.3464D-02, -.1898D-02,  .5390D-01,
     +  -.2252D-02, -.1450D-01, -.7651D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=9,16)/
     +   .7089D-02, -.7577D-02, -.3704D-02, -.2069D-02,  .6190D-01,
     +  -.2289D-02, -.1366D-01, -.7284D-02,
     +   .7803D-02, -.7935D-02, -.4134D-02, -.2369D-02,  .7838D-01,
     +  -.2261D-02, -.1226D-01, -.6632D-02,
     +   .8467D-02, -.8263D-02, -.4527D-02, -.2644D-02,  .9554D-01,
     +  -.2209D-02, -.1115D-01, -.6101D-02,
     +   .9057D-02, -.8550D-02, -.4868D-02, -.2882D-02,  .1123D+00,
     +  -.2148D-02, -.1029D-01, -.5680D-02,
     +   .9566D-02, -.8795D-02, -.5155D-02, -.3081D-02,  .1279D+00,
     +  -.2086D-02, -.9634D-02, -.5350D-02,
     +   .1017D-01, -.9085D-02, -.5484D-02, -.3306D-02,  .1478D+00,
     +  -.2001D-02, -.8940D-02, -.4995D-02,
     +   .1071D-01, -.9336D-02, -.5758D-02, -.3491D-02,  .1664D+00,
     +  -.1919D-02, -.8401D-02, -.4711D-02,
     +   .1122D-01, -.9576D-02, -.6012D-02, -.3659D-02,  .1853D+00,
     +  -.1838D-02, -.7930D-02, -.4459D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=17,25)/
     +   .1169D-01, -.9795D-02, -.6235D-02, -.3805D-02,  .2036D+00,
     +  -.1762D-02, -.7533D-02, -.4243D-02,
     +   .1229D-01, -.1007D-01, -.6503D-02, -.3976D-02,  .2279D+00,
     +  -.1666D-02, -.7072D-02, -.3988D-02,
     +   .1285D-01, -.1033D-01, -.6739D-02, -.4121D-02,  .2520D+00,
     +  -.1574D-02, -.6677D-02, -.3766D-02,
     +   .1342D-01, -.1058D-01, -.6957D-02, -.4249D-02,  .2771D+00,
     +  -.1482D-02, -.6316D-02, -.3559D-02,
     +   .1391D-01, -.1080D-01, -.7134D-02, -.4347D-02,  .3003D+00,
     +  -.1400D-02, -.6020D-02, -.3387D-02,
     +   .1443D-01, -.1104D-01, -.7303D-02, -.4435D-02,  .3253D+00,
     +  -.1315D-02, -.5731D-02, -.3216D-02,
     +   .1493D-01, -.1126D-01, -.7447D-02, -.4503D-02,  .3498D+00,
     +  -.1234D-02, -.5474D-02, -.3062D-02,
     +   .1542D-01, -.1147D-01, -.7575D-02, -.4556D-02,  .3751D+00,
     +  -.1152D-02, -.5231D-02, -.2914D-02,
     +   .1587D-01, -.1167D-01, -.7676D-02, -.4589D-02,  .3982D+00,
     +  -.1080D-02, -.5029D-02, -.2789D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=1,8)/
     +   .4063D-02, -.6268D-02, -.1343D-02, -.2241D-03,  .3635D-02,
     +   .2951D-02, -.3959D-01, -.1679D-01,
     +   .4914D-02, -.6728D-02, -.1840D-02, -.5453D-03,  .1002D-01,
     +   .1330D-02, -.3233D-01, -.1418D-01,
     +   .5539D-02, -.7057D-02, -.2220D-02, -.7998D-03,  .1599D-01,
     +   .3619D-03, -.2855D-01, -.1289D-01,
     +   .6234D-02, -.7417D-02, -.2648D-02, -.1092D-02,  .2386D-01,
     +  -.4797D-03, -.2530D-01, -.1178D-01,
     +   .7039D-02, -.7826D-02, -.3143D-02, -.1432D-02,  .3454D-01,
     +  -.1181D-02, -.2236D-01, -.1075D-01,
     +   .7608D-02, -.8110D-02, -.3487D-02, -.1670D-02,  .4307D-01,
     +  -.1528D-02, -.2063D-01, -.1012D-01,
     +   .8042D-02, -.8325D-02, -.3746D-02, -.1848D-02,  .5014D-01,
     +  -.1727D-02, -.1946D-01, -.9674D-02,
     +   .8683D-02, -.8638D-02, -.4119D-02, -.2104D-02,  .6142D-01,
     +  -.1931D-02, -.1792D-01, -.9064D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=9,16)/
     +   .9152D-02, -.8865D-02, -.4376D-02, -.2277D-02,  .7020D-01,
     +  -.1997D-02, -.1693D-01, -.8639D-02,
     +   .1005D-01, -.9291D-02, -.4834D-02, -.2579D-02,  .8826D-01,
     +  -.2003D-02, -.1525D-01, -.7874D-02,
     +   .1087D-01, -.9679D-02, -.5246D-02, -.2848D-02,  .1069D+00,
     +  -.1973D-02, -.1390D-01, -.7247D-02,
     +   .1161D-01, -.1002D-01, -.5597D-02, -.3076D-02,  .1250D+00,
     +  -.1923D-02, -.1286D-01, -.6747D-02,
     +   .1224D-01, -.1031D-01, -.5887D-02, -.3260D-02,  .1417D+00,
     +  -.1866D-02, -.1206D-01, -.6354D-02,
     +   .1299D-01, -.1065D-01, -.6215D-02, -.3465D-02,  .1630D+00,
     +  -.1780D-02, -.1120D-01, -.5925D-02,
     +   .1365D-01, -.1095D-01, -.6485D-02, -.3629D-02,  .1827D+00,
     +  -.1693D-02, -.1054D-01, -.5582D-02,
     +   .1428D-01, -.1123D-01, -.6730D-02, -.3773D-02,  .2027D+00,
     +  -.1605D-02, -.9954D-02, -.5275D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=17,25)/
     +   .1486D-01, -.1149D-01, -.6941D-02, -.3892D-02,  .2219D+00,
     +  -.1522D-02, -.9460D-02, -.5012D-02,
     +   .1559D-01, -.1181D-01, -.7189D-02, -.4026D-02,  .2474D+00,
     +  -.1412D-02, -.8885D-02, -.4699D-02,
     +   .1628D-01, -.1211D-01, -.7401D-02, -.4132D-02,  .2724D+00,
     +  -.1305D-02, -.8390D-02, -.4424D-02,
     +   .1697D-01, -.1241D-01, -.7591D-02, -.4216D-02,  .2984D+00,
     +  -.1197D-02, -.7935D-02, -.4167D-02,
     +   .1758D-01, -.1267D-01, -.7739D-02, -.4273D-02,  .3221D+00,
     +  -.1100D-02, -.7561D-02, -.3952D-02,
     +   .1821D-01, -.1294D-01, -.7875D-02, -.4314D-02,  .3477D+00,
     +  -.9962D-03, -.7196D-02, -.3738D-02,
     +   .1881D-01, -.1319D-01, -.7984D-02, -.4335D-02,  .3726D+00,
     +  -.8970D-03, -.6871D-02, -.3544D-02,
     +   .1941D-01, -.1345D-01, -.8075D-02, -.4338D-02,  .3983D+00,
     +  -.7965D-03, -.6562D-02, -.3358D-02,
     +   .1995D-01, -.1367D-01, -.8139D-02, -.4325D-02,  .4216D+00,
     +  -.7064D-03, -.6302D-02, -.3198D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=1,8)/
     +   .5285D-02, -.7232D-02, -.1745D-02, -.2742D-03,  .4501D-02,
     +   .4772D-02, -.4343D-01, -.1766D-01,
     +   .6360D-02, -.7781D-02, -.2333D-02, -.6468D-03,  .1205D-01,
     +   .2837D-02, -.3676D-01, -.1549D-01,
     +   .7145D-02, -.8173D-02, -.2769D-02, -.9311D-03,  .1891D-01,
     +   .1661D-02, -.3310D-01, -.1435D-01,
     +   .8016D-02, -.8602D-02, -.3252D-02, -.1248D-02,  .2780D-01,
     +   .6267D-03, -.2981D-01, -.1332D-01,
     +   .9022D-02, -.9088D-02, -.3797D-02, -.1608D-02,  .3969D-01,
     +  -.2474D-03, -.2669D-01, -.1229D-01,
     +   .9730D-02, -.9425D-02, -.4170D-02, -.1852D-02,  .4910D-01,
     +  -.6890D-03, -.2479D-01, -.1162D-01,
     +   .1027D-01, -.9680D-02, -.4447D-02, -.2033D-02,  .5685D-01,
     +  -.9454D-03, -.2348D-01, -.1114D-01,
     +   .1106D-01, -.1005D-01, -.4842D-02, -.2288D-02,  .6915D-01,
     +  -.1219D-02, -.2173D-01, -.1047D-01 /
        DATA ((PARTON(I,N,7),I=1,8),N=9,16)/
     +   .1164D-01, -.1032D-01, -.5112D-02, -.2459D-02,  .7871D-01,
     +  -.1322D-02, -.2057D-01, -.9987D-02,
     +   .1275D-01, -.1082D-01, -.5594D-02, -.2755D-02,  .9834D-01,
     +  -.1382D-02, -.1862D-01, -.9122D-02,
     +   .1376D-01, -.1127D-01, -.6017D-02, -.3011D-02,  .1185D+00,
     +  -.1388D-02, -.1704D-01, -.8403D-02,
     +   .1466D-01, -.1167D-01, -.6372D-02, -.3220D-02,  .1379D+00,
     +  -.1360D-02, -.1579D-01, -.7824D-02,
     +   .1543D-01, -.1201D-01, -.6660D-02, -.3385D-02,  .1556D+00,
     +  -.1315D-02, -.1483D-01, -.7366D-02,
     +   .1635D-01, -.1241D-01, -.6980D-02, -.3561D-02,  .1781D+00,
     +  -.1235D-02, -.1381D-01, -.6862D-02,
     +   .1715D-01, -.1276D-01, -.7238D-02, -.3695D-02,  .1989D+00,
     +  -.1147D-02, -.1301D-01, -.6456D-02,
     +   .1791D-01, -.1309D-01, -.7467D-02, -.3808D-02,  .2199D+00,
     +  -.1054D-02, -.1230D-01, -.6090D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=17,25)/
     +   .1861D-01, -.1338D-01, -.7660D-02, -.3895D-02,  .2398D+00,
     +  -.9631D-03, -.1170D-01, -.5774D-02,
     +   .1950D-01, -.1376D-01, -.7880D-02, -.3983D-02,  .2662D+00,
     +  -.8404D-03, -.1099D-01, -.5397D-02,
     +   .2033D-01, -.1411D-01, -.8061D-02, -.4041D-02,  .2920D+00,
     +  -.7186D-03, -.1038D-01, -.5064D-02,
     +   .2116D-01, -.1445D-01, -.8214D-02, -.4075D-02,  .3185D+00,
     +  -.5922D-03, -.9822D-02, -.4750D-02,
     +   .2189D-01, -.1475D-01, -.8328D-02, -.4084D-02,  .3427D+00,
     +  -.4765D-03, -.9357D-02, -.4485D-02,
     +   .2264D-01, -.1506D-01, -.8423D-02, -.4073D-02,  .3686D+00,
     +  -.3525D-03, -.8901D-02, -.4221D-02,
     +   .2336D-01, -.1536D-01, -.8492D-02, -.4041D-02,  .3937D+00,
     +  -.2322D-03, -.8495D-02, -.3980D-02,
     +   .2408D-01, -.1565D-01, -.8539D-02, -.3988D-02,  .4193D+00,
     +  -.1092D-03, -.8108D-02, -.3748D-02,
     +   .2472D-01, -.1590D-01, -.8563D-02, -.3924D-02,  .4426D+00,
     +   .1943D-05, -.7781D-02, -.3548D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=1,8)/
     +   .7137D-02, -.8563D-02, -.2346D-02, -.3377D-03,  .5657D-02,
     +   .7447D-02, -.4791D-01, -.1843D-01,
     +   .8539D-02, -.9237D-02, -.3045D-02, -.7703D-03,  .1470D-01,
     +   .5219D-02, -.4210D-01, -.1679D-01,
     +   .9558D-02, -.9718D-02, -.3549D-02, -.1086D-02,  .2268D-01,
     +   .3843D-02, -.3870D-01, -.1587D-01,
     +   .1068D-01, -.1024D-01, -.4092D-02, -.1426D-02,  .3283D-01,
     +   .2613D-02, -.3546D-01, -.1496D-01,
     +   .1198D-01, -.1083D-01, -.4692D-02, -.1799D-02,  .4620D-01,
     +   .1550D-02, -.3222D-01, -.1396D-01,
     +   .1288D-01, -.1124D-01, -.5094D-02, -.2045D-02,  .5667D-01,
     +   .1002D-02, -.3016D-01, -.1328D-01,
     +   .1357D-01, -.1155D-01, -.5388D-02, -.2223D-02,  .6524D-01,
     +   .6742D-03, -.2871D-01, -.1277D-01,
     +   .1458D-01, -.1200D-01, -.5801D-02, -.2467D-02,  .7875D-01,
     +   .3136D-03, -.2673D-01, -.1203D-01 /
        DATA ((PARTON(I,N,8),I=1,8),N=9,16)/
     +   .1532D-01, -.1232D-01, -.6083D-02, -.2630D-02,  .8925D-01,
     +   .1566D-03, -.2541D-01, -.1150D-01,
     +   .1671D-01, -.1293D-01, -.6582D-02, -.2907D-02,  .1108D+00,
     +   .7632D-05, -.2314D-01, -.1054D-01,
     +   .1799D-01, -.1347D-01, -.7009D-02, -.3136D-02,  .1326D+00,
     +  -.5864D-04, -.2127D-01, -.9719D-02,
     +   .1911D-01, -.1395D-01, -.7358D-02, -.3312D-02,  .1535D+00,
     +  -.6833D-04, -.1980D-01, -.9051D-02,
     +   .2007D-01, -.1435D-01, -.7634D-02, -.3444D-02,  .1724D+00,
     +  -.4535D-04, -.1864D-01, -.8515D-02,
     +   .2122D-01, -.1483D-01, -.7933D-02, -.3574D-02,  .1963D+00,
     +   .1999D-04, -.1740D-01, -.7919D-02,
     +   .2221D-01, -.1524D-01, -.8167D-02, -.3664D-02,  .2182D+00,
     +   .1054D-03, -.1642D-01, -.7435D-02,
     +   .2315D-01, -.1562D-01, -.8368D-02, -.3729D-02,  .2400D+00,
     +   .2018D-03, -.1555D-01, -.6994D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=17,25)/
     +   .2402D-01, -.1598D-01, -.8530D-02, -.3768D-02,  .2608D+00,
     +   .3011D-03, -.1481D-01, -.6609D-02,
     +   .2511D-01, -.1642D-01, -.8705D-02, -.3791D-02,  .2879D+00,
     +   .4402D-03, -.1393D-01, -.6146D-02,
     +   .2613D-01, -.1683D-01, -.8838D-02, -.3783D-02,  .3143D+00,
     +   .5829D-03, -.1316D-01, -.5733D-02,
     +   .2714D-01, -.1723D-01, -.8939D-02, -.3747D-02,  .3412D+00,
     +   .7347D-03, -.1246D-01, -.5341D-02,
     +   .2803D-01, -.1758D-01, -.9002D-02, -.3691D-02,  .3656D+00,
     +   .8761D-03, -.1187D-01, -.5008D-02,
     +   .2896D-01, -.1794D-01, -.9041D-02, -.3609D-02,  .3915D+00,
     +   .1030D-02, -.1129D-01, -.4673D-02,
     +   .2983D-01, -.1828D-01, -.9054D-02, -.3507D-02,  .4164D+00,
     +   .1181D-02, -.1077D-01, -.4367D-02,
     +   .3070D-01, -.1862D-01, -.9042D-02, -.3383D-02,  .4418D+00,
     +   .1337D-02, -.1027D-01, -.4070D-02,
     +   .3147D-01, -.1892D-01, -.9012D-02, -.3254D-02,  .4646D+00,
     +   .1479D-02, -.9849D-02, -.3813D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=1,8)/
     +   .9504D-02, -.1010D-01, -.3090D-02, -.4028D-03,  .6931D-02,
     +   .1083D-01, -.5210D-01, -.1870D-01,
     +   .1130D-01, -.1093D-01, -.3902D-02, -.8906D-03,  .1754D-01,
     +   .8410D-02, -.4727D-01, -.1762D-01,
     +   .1259D-01, -.1151D-01, -.4470D-02, -.1231D-02,  .2667D-01,
     +   .6888D-02, -.4424D-01, -.1694D-01,
     +   .1402D-01, -.1214D-01, -.5067D-02, -.1586D-02,  .3811D-01,
     +   .5503D-02, -.4118D-01, -.1620D-01,
     +   .1565D-01, -.1286D-01, -.5711D-02, -.1959D-02,  .5299D-01,
     +   .4275D-02, -.3793D-01, -.1529D-01,
     +   .1679D-01, -.1335D-01, -.6134D-02, -.2197D-02,  .6454D-01,
     +   .3621D-02, -.3580D-01, -.1462D-01,
     +   .1766D-01, -.1372D-01, -.6439D-02, -.2365D-02,  .7394D-01,
     +   .3223D-02, -.3427D-01, -.1410D-01,
     +   .1892D-01, -.1425D-01, -.6860D-02, -.2589D-02,  .8868D-01,
     +   .2767D-02, -.3212D-01, -.1333D-01 /
        DATA ((PARTON(I,N,9),I=1,8),N=9,16)/
     +   .1983D-01, -.1464D-01, -.7147D-02, -.2735D-02,  .1001D+00,
     +   .2547D-02, -.3066D-01, -.1278D-01,
     +   .2156D-01, -.1535D-01, -.7651D-02, -.2981D-02,  .1235D+00,
     +   .2286D-02, -.2812D-01, -.1174D-01,
     +   .2313D-01, -.1600D-01, -.8068D-02, -.3167D-02,  .1470D+00,
     +   .2144D-02, -.2601D-01, -.1085D-01,
     +   .2452D-01, -.1656D-01, -.8398D-02, -.3299D-02,  .1692D+00,
     +   .2086D-02, -.2431D-01, -.1010D-01,
     +   .2570D-01, -.1704D-01, -.8650D-02, -.3386D-02,  .1893D+00,
     +   .2082D-02, -.2296D-01, -.9491D-02,
     +   .2709D-01, -.1759D-01, -.8914D-02, -.3457D-02,  .2143D+00,
     +   .2130D-02, -.2149D-01, -.8804D-02,
     +   .2829D-01, -.1807D-01, -.9112D-02, -.3491D-02,  .2370D+00,
     +   .2213D-02, -.2033D-01, -.8237D-02,
     +   .2945D-01, -.1852D-01, -.9272D-02, -.3498D-02,  .2596D+00,
     +   .2315D-02, -.1928D-01, -.7715D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=17,25)/
     +   .3049D-01, -.1893D-01, -.9393D-02, -.3481D-02,  .2809D+00,
     +   .2426D-02, -.1838D-01, -.7256D-02,
     +   .3181D-01, -.1944D-01, -.9510D-02, -.3428D-02,  .3085D+00,
     +   .2587D-02, -.1731D-01, -.6696D-02,
     +   .3304D-01, -.1991D-01, -.9583D-02, -.3344D-02,  .3351D+00,
     +   .2758D-02, -.1638D-01, -.6193D-02,
     +   .3425D-01, -.2038D-01, -.9621D-02, -.3230D-02,  .3620D+00,
     +   .2943D-02, -.1550D-01, -.5710D-02,
     +   .3532D-01, -.2078D-01, -.9625D-02, -.3102D-02,  .3862D+00,
     +   .3118D-02, -.1477D-01, -.5298D-02,
     +   .3642D-01, -.2120D-01, -.9600D-02, -.2943D-02,  .4117D+00,
     +   .3311D-02, -.1405D-01, -.4881D-02,
     +   .3746D-01, -.2159D-01, -.9549D-02, -.2767D-02,  .4362D+00,
     +   .3503D-02, -.1340D-01, -.4496D-02,
     +   .3849D-01, -.2197D-01, -.9472D-02, -.2568D-02,  .4608D+00,
     +   .3702D-02, -.1277D-01, -.4121D-02,
     +   .3941D-01, -.2231D-01, -.9382D-02, -.2370D-02,  .4828D+00,
     +   .3884D-02, -.1224D-01, -.3796D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=1,8)/
     +   .1260D-01, -.1197D-01, -.4034D-02, -.4676D-03,  .8354D-02,
     +   .1514D-01, -.5601D-01, -.1838D-01,
     +   .1488D-01, -.1297D-01, -.4956D-02, -.1003D-02,  .2066D-01,
     +   .1263D-01, -.5227D-01, -.1786D-01,
     +   .1651D-01, -.1368D-01, -.5581D-02, -.1360D-02,  .3104D-01,
     +   .1103D-01, -.4975D-01, -.1746D-01,
     +   .1831D-01, -.1444D-01, -.6224D-02, -.1717D-02,  .4386D-01,
     +   .9538D-02, -.4702D-01, -.1692D-01,
     +   .2035D-01, -.1529D-01, -.6899D-02, -.2076D-02,  .6036D-01,
     +   .8181D-02, -.4393D-01, -.1615D-01,
     +   .2176D-01, -.1588D-01, -.7333D-02, -.2296D-02,  .7306D-01,
     +   .7444D-02, -.4179D-01, -.1553D-01,
     +   .2284D-01, -.1632D-01, -.7640D-02, -.2445D-02,  .8335D-01,
     +   .6980D-02, -.4021D-01, -.1503D-01,
     +   .2440D-01, -.1696D-01, -.8057D-02, -.2635D-02,  .9939D-01,
     +   .6438D-02, -.3797D-01, -.1426D-01 /
        DATA ((PARTON(I,N,10),I=1,8),N=9,16)/
     +   .2553D-01, -.1741D-01, -.8339D-02, -.2757D-02,  .1118D+00,
     +   .6152D-02, -.3641D-01, -.1369D-01,
     +   .2764D-01, -.1825D-01, -.8828D-02, -.2952D-02,  .1371D+00,
     +   .5773D-02, -.3368D-01, -.1263D-01,
     +   .2956D-01, -.1901D-01, -.9216D-02, -.3080D-02,  .1622D+00,
     +   .5554D-02, -.3134D-01, -.1168D-01,
     +   .3124D-01, -.1967D-01, -.9510D-02, -.3151D-02,  .1857D+00,
     +   .5451D-02, -.2942D-01, -.1086D-01,
     +   .3267D-01, -.2022D-01, -.9724D-02, -.3180D-02,  .2067D+00,
     +   .5425D-02, -.2789D-01, -.1018D-01,
     +   .3435D-01, -.2086D-01, -.9935D-02, -.3178D-02,  .2327D+00,
     +   .5464D-02, -.2620D-01, -.9393D-02,
     +   .3580D-01, -.2141D-01, -.1008D-01, -.3144D-02,  .2561D+00,
     +   .5554D-02, -.2484D-01, -.8737D-02,
     +   .3718D-01, -.2193D-01, -.1019D-01, -.3080D-02,  .2792D+00,
     +   .5671D-02, -.2361D-01, -.8124D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=17,25)/
     +   .3843D-01, -.2240D-01, -.1025D-01, -.2997D-02,  .3007D+00,
     +   .5805D-02, -.2254D-01, -.7578D-02,
     +   .4000D-01, -.2299D-01, -.1030D-01, -.2855D-02,  .3284D+00,
     +   .6004D-02, -.2126D-01, -.6907D-02,
     +   .4146D-01, -.2352D-01, -.1030D-01, -.2686D-02,  .3548D+00,
     +   .6218D-02, -.2013D-01, -.6296D-02,
     +   .4290D-01, -.2405D-01, -.1026D-01, -.2484D-02,  .3813D+00,
     +   .6453D-02, -.1907D-01, -.5706D-02,
     +   .4416D-01, -.2451D-01, -.1019D-01, -.2277D-02,  .4049D+00,
     +   .6679D-02, -.1817D-01, -.5197D-02,
     +   .4546D-01, -.2498D-01, -.1009D-01, -.2035D-02,  .4296D+00,
     +   .6928D-02, -.1728D-01, -.4680D-02,
     +   .4668D-01, -.2542D-01, -.9972D-02, -.1780D-02,  .4531D+00,
     +   .7175D-02, -.1647D-01, -.4200D-02,
     +   .4789D-01, -.2585D-01, -.9823D-02, -.1502D-02,  .4766D+00,
     +   .7434D-02, -.1570D-01, -.3731D-02,
     +   .4896D-01, -.2623D-01, -.9669D-02, -.1234D-02,  .4974D+00,
     +   .7672D-02, -.1504D-01, -.3320D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=1,8)/
     +   .1715D-01, -.1453D-01, -.5361D-02, -.5324D-03,  .1012D-01,
     +   .2123D-01, -.5979D-01, -.1713D-01,
     +   .2008D-01, -.1576D-01, -.6390D-02, -.1104D-02,  .2450D-01,
     +   .1873D-01, -.5742D-01, -.1724D-01,
     +   .2218D-01, -.1663D-01, -.7065D-02, -.1464D-02,  .3639D-01,
     +   .1711D-01, -.5559D-01, -.1718D-01,
     +   .2446D-01, -.1756D-01, -.7739D-02, -.1806D-02,  .5090D-01,
     +   .1557D-01, -.5340D-01, -.1691D-01,
     +   .2704D-01, -.1859D-01, -.8425D-02, -.2130D-02,  .6939D-01,
     +   .1414D-01, -.5063D-01, -.1635D-01,
     +   .2883D-01, -.1930D-01, -.8853D-02, -.2313D-02,  .8348D-01,
     +   .1334D-01, -.4866D-01, -.1583D-01,
     +   .3017D-01, -.1983D-01, -.9150D-02, -.2429D-02,  .9482D-01,
     +   .1283D-01, -.4709D-01, -.1537D-01,
     +   .3212D-01, -.2059D-01, -.9542D-02, -.2565D-02,  .1124D+00,
     +   .1223D-01, -.4486D-01, -.1465D-01 /
        DATA ((PARTON(I,N,11),I=1,8),N=9,16)/
     +   .3352D-01, -.2113D-01, -.9803D-02, -.2647D-02,  .1259D+00,
     +   .1188D-01, -.4326D-01, -.1409D-01,
     +   .3613D-01, -.2212D-01, -.1024D-01, -.2762D-02,  .1533D+00,
     +   .1141D-01, -.4040D-01, -.1302D-01,
     +   .3850D-01, -.2301D-01, -.1057D-01, -.2802D-02,  .1801D+00,
     +   .1113D-01, -.3788D-01, -.1202D-01,
     +   .4055D-01, -.2378D-01, -.1080D-01, -.2787D-02,  .2048D+00,
     +   .1101D-01, -.3576D-01, -.1112D-01,
     +   .4229D-01, -.2442D-01, -.1095D-01, -.2737D-02,  .2267D+00,
     +   .1099D-01, -.3402D-01, -.1035D-01,
     +   .4433D-01, -.2517D-01, -.1108D-01, -.2634D-02,  .2534D+00,
     +   .1106D-01, -.3209D-01, -.9452D-02,
     +   .4608D-01, -.2580D-01, -.1115D-01, -.2510D-02,  .2772D+00,
     +   .1119D-01, -.3051D-01, -.8681D-02,
     +   .4774D-01, -.2640D-01, -.1117D-01, -.2357D-02,  .3004D+00,
     +   .1135D-01, -.2906D-01, -.7950D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=17,25)/
     +   .4924D-01, -.2694D-01, -.1117D-01, -.2188D-02,  .3218D+00,
     +   .1154D-01, -.2779D-01, -.7291D-02,
     +   .5112D-01, -.2760D-01, -.1111D-01, -.1937D-02,  .3490D+00,
     +   .1182D-01, -.2626D-01, -.6471D-02,
     +   .5286D-01, -.2821D-01, -.1101D-01, -.1664D-02,  .3747D+00,
     +   .1211D-01, -.2489D-01, -.5715D-02,
     +   .5456D-01, -.2881D-01, -.1088D-01, -.1358D-02,  .4002D+00,
     +   .1244D-01, -.2359D-01, -.4979D-02,
     +   .5604D-01, -.2932D-01, -.1072D-01, -.1061D-02,  .4226D+00,
     +   .1275D-01, -.2249D-01, -.4340D-02,
     +   .5757D-01, -.2985D-01, -.1053D-01, -.7236D-03,  .4459D+00,
     +   .1309D-01, -.2139D-01, -.3686D-02,
     +   .5900D-01, -.3033D-01, -.1032D-01, -.3805D-03,  .4678D+00,
     +   .1343D-01, -.2039D-01, -.3076D-02,
     +   .6042D-01, -.3081D-01, -.1009D-01, -.1454D-04,  .4894D+00,
     +   .1379D-01, -.1942D-01, -.2477D-02,
     +   .6166D-01, -.3123D-01, -.9858D-02,  .3289D-03,  .5084D+00,
     +   .1411D-01, -.1860D-01, -.1952D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=1,8)/
     +   .2291D-01, -.1761D-01, -.6952D-02, -.5787D-03,  .1205D-01,
     +   .2854D-01, -.6266D-01, -.1487D-01,
     +   .2660D-01, -.1909D-01, -.8053D-02, -.1161D-02,  .2866D-01,
     +   .2612D-01, -.6177D-01, -.1562D-01,
     +   .2923D-01, -.2013D-01, -.8750D-02, -.1505D-02,  .4219D-01,
     +   .2455D-01, -.6074D-01, -.1591D-01,
     +   .3207D-01, -.2124D-01, -.9425D-02, -.1810D-02,  .5854D-01,
     +   .2304D-01, -.5921D-01, -.1594D-01,
     +   .3526D-01, -.2247D-01, -.1009D-01, -.2073D-02,  .7914D-01,
     +   .2161D-01, -.5701D-01, -.1564D-01,
     +   .3746D-01, -.2330D-01, -.1049D-01, -.2204D-02,  .9470D-01,
     +   .2082D-01, -.5525D-01, -.1524D-01,
     +   .3910D-01, -.2392D-01, -.1075D-01, -.2277D-02,  .1071D+00,
     +   .2030D-01, -.5386D-01, -.1486D-01,
     +   .4148D-01, -.2481D-01, -.1110D-01, -.2342D-02,  .1262D+00,
     +   .1969D-01, -.5171D-01, -.1418D-01 /
        DATA ((PARTON(I,N,12),I=1,8),N=9,16)/
     +   .4318D-01, -.2543D-01, -.1132D-01, -.2371D-02,  .1409D+00,
     +   .1935D-01, -.5015D-01, -.1366D-01,
     +   .4633D-01, -.2658D-01, -.1168D-01, -.2382D-02,  .1702D+00,
     +   .1887D-01, -.4724D-01, -.1259D-01,
     +   .4917D-01, -.2760D-01, -.1191D-01, -.2316D-02,  .1983D+00,
     +   .1863D-01, -.4461D-01, -.1152D-01,
     +   .5162D-01, -.2848D-01, -.1205D-01, -.2200D-02,  .2239D+00,
     +   .1856D-01, -.4234D-01, -.1053D-01,
     +   .5369D-01, -.2921D-01, -.1211D-01, -.2059D-02,  .2463D+00,
     +   .1860D-01, -.4044D-01, -.9666D-02,
     +   .5610D-01, -.3005D-01, -.1214D-01, -.1846D-02,  .2733D+00,
     +   .1876D-01, -.3827D-01, -.8625D-02,
     +   .5816D-01, -.3076D-01, -.1211D-01, -.1623D-02,  .2970D+00,
     +   .1899D-01, -.3648D-01, -.7716D-02,
     +   .6010D-01, -.3143D-01, -.1204D-01, -.1375D-02,  .3198D+00,
     +   .1926D-01, -.3482D-01, -.6844D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=17,25)/
     +   .6186D-01, -.3202D-01, -.1194D-01, -.1119D-02,  .3406D+00,
     +   .1955D-01, -.3334D-01, -.6051D-02,
     +   .6404D-01, -.3276D-01, -.1177D-01, -.7574D-03,  .3668D+00,
     +   .1996D-01, -.3154D-01, -.5052D-02,
     +   .6604D-01, -.3343D-01, -.1157D-01, -.3819D-03,  .3912D+00,
     +   .2040D-01, -.2993D-01, -.4125D-02,
     +   .6801D-01, -.3408D-01, -.1133D-01,  .2367D-04,  .4150D+00,
     +   .2086D-01, -.2839D-01, -.3215D-02,
     +   .6971D-01, -.3464D-01, -.1108D-01,  .4073D-03,  .4358D+00,
     +   .2131D-01, -.2707D-01, -.2421D-02,
     +   .7146D-01, -.3521D-01, -.1080D-01,  .8312D-03,  .4571D+00,
     +   .2179D-01, -.2575D-01, -.1605D-02,
     +   .7309D-01, -.3573D-01, -.1051D-01,  .1254D-02,  .4768D+00,
     +   .2226D-01, -.2454D-01, -.8420D-03,
     +   .7470D-01, -.3625D-01, -.1019D-01,  .1696D-02,  .4961D+00,
     +   .2275D-01, -.2338D-01, -.8938D-04,
     +   .7611D-01, -.3670D-01, -.9883D-02,  .2104D-02,  .5130D+00,
     +   .2320D-01, -.2237D-01,  .5708D-03 /
        DATA ((PARTON(I,N,13),I=1,8),N=1,8)/
     +   .3023D-01, -.2136D-01, -.8835D-02, -.5986D-03,  .1429D-01,
     +   .3717D-01, -.6466D-01, -.1155D-01,
     +   .3481D-01, -.2312D-01, -.9958D-02, -.1158D-02,  .3341D-01,
     +   .3484D-01, -.6541D-01, -.1301D-01,
     +   .3803D-01, -.2435D-01, -.1064D-01, -.1462D-02,  .4879D-01,
     +   .3334D-01, -.6533D-01, -.1370D-01,
     +   .4150D-01, -.2564D-01, -.1128D-01, -.1706D-02,  .6719D-01,
     +   .3194D-01, -.6461D-01, -.1408D-01,
     +   .4537D-01, -.2706D-01, -.1187D-01, -.1882D-02,  .9011D-01,
     +   .3061D-01, -.6311D-01, -.1404D-01,
     +   .4801D-01, -.2802D-01, -.1221D-01, -.1945D-02,  .1072D+00,
     +   .2989D-01, -.6171D-01, -.1377D-01,
     +   .4998D-01, -.2873D-01, -.1243D-01, -.1961D-02,  .1208D+00,
     +   .2942D-01, -.6048D-01, -.1344D-01,
     +   .5282D-01, -.2974D-01, -.1269D-01, -.1940D-02,  .1414D+00,
     +   .2892D-01, -.5849D-01, -.1282D-01 /
        DATA ((PARTON(I,N,13),I=1,8),N=9,16)/
     +   .5484D-01, -.3046D-01, -.1285D-01, -.1905D-02,  .1571D+00,
     +   .2865D-01, -.5703D-01, -.1230D-01,
     +   .5856D-01, -.3175D-01, -.1308D-01, -.1789D-02,  .1880D+00,
     +   .2833D-01, -.5418D-01, -.1119D-01,
     +   .6189D-01, -.3289D-01, -.1319D-01, -.1599D-02,  .2171D+00,
     +   .2826D-01, -.5147D-01, -.1002D-01,
     +   .6475D-01, -.3386D-01, -.1321D-01, -.1369D-02,  .2432D+00,
     +   .2836D-01, -.4905D-01, -.8900D-02,
     +   .6715D-01, -.3466D-01, -.1317D-01, -.1129D-02,  .2656D+00,
     +   .2856D-01, -.4699D-01, -.7893D-02,
     +   .6994D-01, -.3558D-01, -.1306D-01, -.7992D-03,  .2923D+00,
     +   .2893D-01, -.4460D-01, -.6667D-02,
     +   .7230D-01, -.3636D-01, -.1292D-01, -.4754D-03,  .3153D+00,
     +   .2935D-01, -.4260D-01, -.5583D-02,
     +   .7453D-01, -.3708D-01, -.1274D-01, -.1310D-03,  .3372D+00,
     +   .2980D-01, -.4073D-01, -.4533D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=17,25)/
     +   .7652D-01, -.3772D-01, -.1255D-01,  .2108D-03,  .3570D+00,
     +   .3026D-01, -.3905D-01, -.3571D-02,
     +   .7899D-01, -.3851D-01, -.1226D-01,  .6777D-03,  .3815D+00,
     +   .3090D-01, -.3699D-01, -.2353D-02,
     +   .8126D-01, -.3922D-01, -.1194D-01,  .1148D-02,  .4039D+00,
     +   .3156D-01, -.3512D-01, -.1217D-02,
     +   .8346D-01, -.3990D-01, -.1159D-01,  .1643D-02,  .4255D+00,
     +   .3224D-01, -.3333D-01, -.9777D-04,
     +   .8537D-01, -.4049D-01, -.1126D-01,  .2101D-02,  .4441D+00,
     +   .3287D-01, -.3179D-01,  .8811D-03,
     +   .8732D-01, -.4108D-01, -.1088D-01,  .2598D-02,  .4628D+00,
     +   .3354D-01, -.3024D-01,  .1890D-02,
     +   .8912D-01, -.4163D-01, -.1050D-01,  .3085D-02,  .4800D+00,
     +   .3420D-01, -.2882D-01,  .2834D-02,
     +   .9090D-01, -.4216D-01, -.1010D-01,  .3587D-02,  .4966D+00,
     +   .3487D-01, -.2743D-01,  .3766D-02,
     +   .9245D-01, -.4262D-01, -.9733D-02,  .4044D-02,  .5108D+00,
     +   .3549D-01, -.2624D-01,  .4584D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=1,8)/
     +   .4166D-01, -.2701D-01, -.1149D-01, -.5735D-03,  .1782D-01,
     +   .4915D-01, -.6614D-01, -.6354D-02,
     +   .4743D-01, -.2912D-01, -.1254D-01, -.1051D-02,  .4053D-01,
     +   .4689D-01, -.6915D-01, -.8802D-02,
     +   .5146D-01, -.3056D-01, -.1314D-01, -.1270D-02,  .5852D-01,
     +   .4554D-01, -.7040D-01, -.1001D-01,
     +   .5575D-01, -.3208D-01, -.1367D-01, -.1405D-02,  .7974D-01,
     +   .4433D-01, -.7080D-01, -.1080D-01,
     +   .6050D-01, -.3372D-01, -.1411D-01, -.1440D-02,  .1057D+00,
     +   .4334D-01, -.7021D-01, -.1105D-01,
     +   .6372D-01, -.3482D-01, -.1433D-01, -.1398D-02,  .1248D+00,
     +   .4285D-01, -.6929D-01, -.1088D-01,
     +   .6612D-01, -.3563D-01, -.1446D-01, -.1332D-02,  .1396D+00,
     +   .4259D-01, -.6832D-01, -.1058D-01,
     +   .6953D-01, -.3677D-01, -.1457D-01, -.1187D-02,  .1619D+00,
     +   .4240D-01, -.6659D-01, -.9934D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=9,16)/
     +   .7195D-01, -.3756D-01, -.1463D-01, -.1060D-02,  .1786D+00,
     +   .4238D-01, -.6521D-01, -.9357D-02,
     +   .7637D-01, -.3900D-01, -.1465D-01, -.7665D-03,  .2108D+00,
     +   .4251D-01, -.6243D-01, -.8065D-02,
     +   .8028D-01, -.4024D-01, -.1455D-01, -.4121D-03,  .2404D+00,
     +   .4291D-01, -.5961D-01, -.6646D-02,
     +   .8362D-01, -.4129D-01, -.1439D-01, -.3847D-04,  .2663D+00,
     +   .4345D-01, -.5704D-01, -.5261D-02,
     +   .8640D-01, -.4216D-01, -.1420D-01,  .3218D-03,  .2880D+00,
     +   .4402D-01, -.5478D-01, -.4004D-02,
     +   .8960D-01, -.4314D-01, -.1391D-01,  .7902D-03,  .3134D+00,
     +   .4482D-01, -.5214D-01, -.2459D-02,
     +   .9231D-01, -.4395D-01, -.1362D-01,  .1230D-02,  .3349D+00,
     +   .4562D-01, -.4987D-01, -.1088D-02,
     +   .9483D-01, -.4471D-01, -.1330D-01,  .1679D-02,  .3549D+00,
     +   .4645D-01, -.4772D-01,  .2443D-03 /
        DATA ((PARTON(I,N,14),I=1,8),N=17,25)/
     +   .9709D-01, -.4537D-01, -.1298D-01,  .2112D-02,  .3726D+00,
     +   .4723D-01, -.4580D-01,  .1469D-02,
     +   .9986D-01, -.4617D-01, -.1254D-01,  .2686D-02,  .3941D+00,
     +   .4828D-01, -.4341D-01,  .3018D-02,
     +   .1024D+00, -.4690D-01, -.1209D-01,  .3248D-02,  .4134D+00,
     +   .4931D-01, -.4125D-01,  .4466D-02,
     +   .1048D+00, -.4759D-01, -.1161D-01,  .3825D-02,  .4315D+00,
     +   .5036D-01, -.3914D-01,  .5892D-02,
     +   .1069D+00, -.4817D-01, -.1117D-01,  .4348D-02,  .4468D+00,
     +   .5131D-01, -.3733D-01,  .7138D-02,
     +   .1090D+00, -.4876D-01, -.1069D-01,  .4904D-02,  .4619D+00,
     +   .5232D-01, -.3550D-01,  .8422D-02,
     +   .1110D+00, -.4929D-01, -.1023D-01,  .5440D-02,  .4755D+00,
     +   .5329D-01, -.3383D-01,  .9622D-02,
     +   .1129D+00, -.4981D-01, -.9748D-02,  .5982D-02,  .4883D+00,
     +   .5426D-01, -.3219D-01,  .1080D-01,
     +   .1146D+00, -.5025D-01, -.9313D-02,  .6469D-02,  .4990D+00,
     +   .5514D-01, -.3078D-01,  .1184D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=1,8)/
     +   .5677D-01, -.3425D-01, -.1451D-01, -.4771D-03,  .2329D-01,
     +   .6243D-01, -.6734D-01, -.3979D-03,
     +   .6386D-01, -.3666D-01, -.1536D-01, -.7985D-03,  .5043D-01,
     +   .6027D-01, -.7298D-01, -.3960D-02,
     +   .6875D-01, -.3829D-01, -.1579D-01, -.8885D-03,  .7152D-01,
     +   .5918D-01, -.7562D-01, -.5669D-02,
     +   .7392D-01, -.3998D-01, -.1611D-01, -.8727D-03,  .9592D-01,
     +   .5839D-01, -.7716D-01, -.6756D-02,
     +   .7958D-01, -.4180D-01, -.1631D-01, -.7291D-03,  .1250D+00,
     +   .5800D-01, -.7745D-01, -.7109D-02,
     +   .8338D-01, -.4299D-01, -.1635D-01, -.5602D-03,  .1459D+00,
     +   .5803D-01, -.7689D-01, -.6881D-02,
     +   .8619D-01, -.4386D-01, -.1634D-01, -.3986D-03,  .1620D+00,
     +   .5817D-01, -.7610D-01, -.6487D-02,
     +   .9017D-01, -.4508D-01, -.1626D-01, -.1152D-03,  .1855D+00,
     +   .5859D-01, -.7456D-01, -.5630D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=9,16)/
     +   .9296D-01, -.4592D-01, -.1617D-01,  .1125D-03,  .2028D+00,
     +   .5902D-01, -.7323D-01, -.4857D-02,
     +   .9802D-01, -.4743D-01, -.1592D-01,  .5950D-03,  .2352D+00,
     +   .6003D-01, -.7036D-01, -.3123D-02,
     +   .1025D+00, -.4871D-01, -.1558D-01,  .1114D-02,  .2641D+00,
     +   .6127D-01, -.6739D-01, -.1244D-02,
     +   .1062D+00, -.4978D-01, -.1521D-01,  .1624D-02,  .2887D+00,
     +   .6250D-01, -.6455D-01,  .5743D-03,
     +   .1093D+00, -.5065D-01, -.1484D-01,  .2092D-02,  .3088D+00,
     +   .6365D-01, -.6208D-01,  .2210D-02,
     +   .1129D+00, -.5162D-01, -.1437D-01,  .2679D-02,  .3317D+00,
     +   .6514D-01, -.5914D-01,  .4209D-02,
     +   .1158D+00, -.5241D-01, -.1392D-01,  .3211D-02,  .3506D+00,
     +   .6651D-01, -.5660D-01,  .5974D-02,
     +   .1186D+00, -.5314D-01, -.1345D-01,  .3740D-02,  .3678D+00,
     +   .6786D-01, -.5417D-01,  .7677D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=17,25)/
     +   .1210D+00, -.5377D-01, -.1301D-01,  .4237D-02,  .3826D+00,
     +   .6913D-01, -.5197D-01,  .9237D-02,
     +   .1240D+00, -.5453D-01, -.1242D-01,  .4880D-02,  .4001D+00,
     +   .7074D-01, -.4926D-01,  .1120D-01,
     +   .1266D+00, -.5520D-01, -.1185D-01,  .5494D-02,  .4153D+00,
     +   .7230D-01, -.4678D-01,  .1303D-01,
     +   .1292D+00, -.5583D-01, -.1127D-01,  .6110D-02,  .4293D+00,
     +   .7383D-01, -.4438D-01,  .1482D-01,
     +   .1314D+00, -.5636D-01, -.1074D-01,  .6658D-02,  .4407D+00,
     +   .7522D-01, -.4232D-01,  .1638D-01,
     +   .1336D+00, -.5688D-01, -.1019D-01,  .7231D-02,  .4516D+00,
     +   .7665D-01, -.4025D-01,  .1799D-01,
     +   .1356D+00, -.5735D-01, -.9656D-02,  .7773D-02,  .4611D+00,
     +   .7800D-01, -.3832D-01,  .1948D-01,
     +   .1376D+00, -.5780D-01, -.9119D-02,  .8313D-02,  .4697D+00,
     +   .7937D-01, -.3646D-01,  .2095D-01,
     +   .1393D+00, -.5817D-01, -.8641D-02,  .8792D-02,  .4768D+00,
     +   .8056D-01, -.3485D-01,  .2223D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=1,8)/
     +   .7745D-01, -.4375D-01, -.1785D-01, -.2838D-03,  .3312D-01,
     +   .7650D-01, -.7002D-01,  .5346D-02,
     +   .8594D-01, -.4637D-01, -.1831D-01, -.3570D-03,  .6586D-01,
     +   .7477D-01, -.7836D-01,  .7974D-03,
     +   .9173D-01, -.4812D-01, -.1845D-01, -.2660D-03,  .9057D-01,
     +   .7433D-01, -.8224D-01, -.1163D-02,
     +   .9777D-01, -.4989D-01, -.1846D-01, -.5496D-04,  .1183D+00,
     +   .7446D-01, -.8466D-01, -.2200D-02,
     +   .1043D+00, -.5176D-01, -.1830D-01,  .3033D-03,  .1504D+00,
     +   .7526D-01, -.8545D-01, -.2198D-02,
     +   .1086D+00, -.5298D-01, -.1811D-01,  .6149D-03,  .1727D+00,
     +   .7620D-01, -.8504D-01, -.1593D-02,
     +   .1118D+00, -.5385D-01, -.1792D-01,  .8801D-03,  .1894D+00,
     +   .7705D-01, -.8431D-01, -.8669D-03,
     +   .1163D+00, -.5505D-01, -.1759D-01,  .1307D-02,  .2134D+00,
     +   .7854D-01, -.8267D-01,  .5310D-03 /
        DATA ((PARTON(I,N,16),I=1,8),N=9,16)/
     +   .1194D+00, -.5588D-01, -.1732D-01,  .1636D-02,  .2305D+00,
     +   .7972D-01, -.8122D-01,  .1725D-02,
     +   .1250D+00, -.5732D-01, -.1673D-01,  .2299D-02,  .2615D+00,
     +   .8210D-01, -.7798D-01,  .4285D-02,
     +   .1298D+00, -.5852D-01, -.1612D-01,  .2962D-02,  .2881D+00,
     +   .8455D-01, -.7459D-01,  .6929D-02,
     +   .1338D+00, -.5950D-01, -.1552D-01,  .3580D-02,  .3098D+00,
     +   .8682D-01, -.7143D-01,  .9410D-02,
     +   .1371D+00, -.6028D-01, -.1498D-01,  .4127D-02,  .3271D+00,
     +   .8885D-01, -.6861D-01,  .1160D-01,
     +   .1408D+00, -.6113D-01, -.1431D-01,  .4789D-02,  .3460D+00,
     +   .9125D-01, -.6527D-01,  .1422D-01,
     +   .1439D+00, -.6182D-01, -.1371D-01,  .5373D-02,  .3610D+00,
     +   .9341D-01, -.6242D-01,  .1651D-01,
     +   .1467D+00, -.6243D-01, -.1311D-01,  .5939D-02,  .3742D+00,
     +   .9544D-01, -.5968D-01,  .1868D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=17,25)/
     +   .1492D+00, -.6295D-01, -.1256D-01,  .6457D-02,  .3852D+00,
     +   .9733D-01, -.5722D-01,  .2066D-01,
     +   .1522D+00, -.6356D-01, -.1186D-01,  .7112D-02,  .3976D+00,
     +   .9967D-01, -.5419D-01,  .2313D-01,
     +   .1548D+00, -.6409D-01, -.1119D-01,  .7722D-02,  .4079D+00,
     +   .1019D+00, -.5140D-01,  .2541D-01,
     +   .1573D+00, -.6457D-01, -.1053D-01,  .8321D-02,  .4169D+00,
     +   .1041D+00, -.4872D-01,  .2763D-01,
     +   .1595D+00, -.6496D-01, -.9951D-02,  .8843D-02,  .4238D+00,
     +   .1059D+00, -.4642D-01,  .2954D-01,
     +   .1616D+00, -.6533D-01, -.9347D-02,  .9378D-02,  .4300D+00,
     +   .1079D+00, -.4411D-01,  .3150D-01,
     +   .1635D+00, -.6566D-01, -.8781D-02,  .9875D-02,  .4351D+00,
     +   .1097D+00, -.4197D-01,  .3332D-01,
     +   .1653D+00, -.6596D-01, -.8221D-02,  .1036D-01,  .4394D+00,
     +   .1115D+00, -.3991D-01,  .3509D-01,
     +   .1669D+00, -.6620D-01, -.7729D-02,  .1079D-01,  .4426D+00,
     +   .1131D+00, -.3813D-01,  .3664D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=1,8)/
     +   .1135D+00, -.5915D-01, -.2190D-01,  .1091D-03,  .5785D-01,
     +   .9282D-01, -.7922D-01,  .9285D-02,
     +   .1235D+00, -.6170D-01, -.2158D-01,  .4666D-03,  .9840D-01,
     +   .9331D-01, -.8974D-01,  .4896D-02,
     +   .1302D+00, -.6334D-01, -.2120D-01,  .8368D-03,  .1274D+00,
     +   .9488D-01, -.9417D-01,  .3713D-02,
     +   .1371D+00, -.6496D-01, -.2067D-01,  .1323D-02,  .1584D+00,
     +   .9745D-01, -.9657D-01,  .3903D-02,
     +   .1444D+00, -.6660D-01, -.1996D-01,  .1955D-02,  .1923D+00,
     +   .1011D+00, -.9682D-01,  .5554D-02,
     +   .1491D+00, -.6763D-01, -.1940D-01,  .2432D-02,  .2146D+00,
     +   .1039D+00, -.9585D-01,  .7370D-02,
     +   .1525D+00, -.6835D-01, -.1895D-01,  .2809D-02,  .2307D+00,
     +   .1062D+00, -.9459D-01,  .9018D-02,
     +   .1573D+00, -.6931D-01, -.1827D-01,  .3378D-02,  .2529D+00,
     +   .1097D+00, -.9227D-01,  .1174D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=9,16)/
     +   .1605D+00, -.6995D-01, -.1776D-01,  .3799D-02,  .2679D+00,
     +   .1122D+00, -.9025D-01,  .1386D-01,
     +   .1662D+00, -.7101D-01, -.1676D-01,  .4609D-02,  .2937D+00,
     +   .1170D+00, -.8603D-01,  .1808D-01,
     +   .1711D+00, -.7185D-01, -.1581D-01,  .5363D-02,  .3142D+00,
     +   .1216D+00, -.8176D-01,  .2213D-01,
     +   .1750D+00, -.7249D-01, -.1496D-01,  .6027D-02,  .3299D+00,
     +   .1254D+00, -.7791D-01,  .2574D-01,
     +   .1782D+00, -.7297D-01, -.1424D-01,  .6589D-02,  .3415D+00,
     +   .1287D+00, -.7457D-01,  .2882D-01,
     +   .1817D+00, -.7346D-01, -.1338D-01,  .7244D-02,  .3533D+00,
     +   .1325D+00, -.7061D-01,  .3241D-01,
     +   .1845D+00, -.7383D-01, -.1264D-01,  .7801D-02,  .3619D+00,
     +   .1358D+00, -.6732D-01,  .3547D-01,
     +   .1870D+00, -.7412D-01, -.1195D-01,  .8322D-02,  .3687D+00,
     +   .1388D+00, -.6417D-01,  .3832D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=17,25)/
     +   .1892D+00, -.7435D-01, -.1132D-01,  .8785D-02,  .3738D+00,
     +   .1415D+00, -.6140D-01,  .4090D-01,
     +   .1918D+00, -.7459D-01, -.1054D-01,  .9350D-02,  .3789D+00,
     +   .1448D+00, -.5797D-01,  .4404D-01,
     +   .1940D+00, -.7476D-01, -.9827D-02,  .9860D-02,  .3823D+00,
     +   .1480D+00, -.5487D-01,  .4692D-01,
     +   .1960D+00, -.7489D-01, -.9138D-02,  .1034D-01,  .3846D+00,
     +   .1508D+00, -.5189D-01,  .4966D-01,
     +   .1977D+00, -.7497D-01, -.8548D-02,  .1075D-01,  .3857D+00,
     +   .1534D+00, -.4938D-01,  .5203D-01,
     +   .1993D+00, -.7502D-01, -.7949D-02,  .1116D-01,  .3860D+00,
     +   .1560D+00, -.4684D-01,  .5441D-01,
     +   .2008D+00, -.7504D-01, -.7400D-02,  .1153D-01,  .3857D+00,
     +   .1584D+00, -.4455D-01,  .5661D-01,
     +   .2021D+00, -.7503D-01, -.6867D-02,  .1188D-01,  .3848D+00,
     +   .1607D+00, -.4231D-01,  .5874D-01,
     +   .2032D+00, -.7500D-01, -.6407D-02,  .1218D-01,  .3835D+00,
     +   .1627D+00, -.4040D-01,  .6058D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=1,8)/
     +   .1622D+00, -.7746D-01, -.2475D-01,  .6037D-03,  .1050D+00,
     +   .1058D+00, -.9920D-01,  .6823D-02,
     +   .1729D+00, -.7933D-01, -.2346D-01,  .1428D-02,  .1510D+00,
     +   .1123D+00, -.1080D+00,  .6279D-02,
     +   .1798D+00, -.8044D-01, -.2248D-01,  .2060D-02,  .1815D+00,
     +   .1181D+00, -.1105D+00,  .8084D-02,
     +   .1867D+00, -.8146D-01, -.2138D-01,  .2769D-02,  .2120D+00,
     +   .1250D+00, -.1106D+00,  .1147D-01,
     +   .1937D+00, -.8239D-01, -.2010D-01,  .3585D-02,  .2428D+00,
     +   .1330D+00, -.1084D+00,  .1650D-01,
     +   .1982D+00, -.8291D-01, -.1920D-01,  .4150D-02,  .2616D+00,
     +   .1385D+00, -.1058D+00,  .2045D-01,
     +   .2014D+00, -.8324D-01, -.1853D-01,  .4574D-02,  .2744D+00,
     +   .1426D+00, -.1035D+00,  .2358D-01,
     +   .2057D+00, -.8363D-01, -.1755D-01,  .5181D-02,  .2910D+00,
     +   .1486D+00, -.9956D-01,  .2827D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=9,16)/
     +   .2086D+00, -.8385D-01, -.1685D-01,  .5614D-02,  .3014D+00,
     +   .1528D+00, -.9658D-01,  .3168D-01,
     +   .2135D+00, -.8413D-01, -.1555D-01,  .6410D-02,  .3175D+00,
     +   .1603D+00, -.9080D-01,  .3803D-01,
     +   .2174D+00, -.8424D-01, -.1440D-01,  .7102D-02,  .3285D+00,
     +   .1669D+00, -.8539D-01,  .4372D-01,
     +   .2205D+00, -.8425D-01, -.1342D-01,  .7678D-02,  .3356D+00,
     +   .1723D+00, -.8067D-01,  .4857D-01,
     +   .2229D+00, -.8419D-01, -.1261D-01,  .8144D-02,  .3398D+00,
     +   .1768D+00, -.7672D-01,  .5259D-01,
     +   .2254D+00, -.8404D-01, -.1169D-01,  .8664D-02,  .3428D+00,
     +   .1819D+00, -.7219D-01,  .5716D-01,
     +   .2273D+00, -.8386D-01, -.1092D-01,  .9087D-02,  .3440D+00,
     +   .1861D+00, -.6846D-01,  .6094D-01,
     +   .2289D+00, -.8364D-01, -.1021D-01,  .9466D-02,  .3440D+00,
     +   .1899D+00, -.6500D-01,  .6442D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=17,25)/
     +   .2303D+00, -.8341D-01, -.9591D-02,  .9790D-02,  .3430D+00,
     +   .1934D+00, -.6193D-01,  .6750D-01,
     +   .2317D+00, -.8306D-01, -.8842D-02,  .1017D-01,  .3408D+00,
     +   .1974D+00, -.5825D-01,  .7122D-01,
     +   .2329D+00, -.8270D-01, -.8174D-02,  .1050D-01,  .3378D+00,
     +   .2011D+00, -.5495D-01,  .7457D-01,
     +   .2339D+00, -.8230D-01, -.7543D-02,  .1079D-01,  .3340D+00,
     +   .2047D+00, -.5183D-01,  .7775D-01,
     +   .2346D+00, -.8193D-01, -.7014D-02,  .1103D-01,  .3301D+00,
     +   .2077D+00, -.4920D-01,  .8046D-01,
     +   .2352D+00, -.8151D-01, -.6488D-02,  .1126D-01,  .3257D+00,
     +   .2107D+00, -.4661D-01,  .8320D-01,
     +   .2357D+00, -.8110D-01, -.6015D-02,  .1145D-01,  .3211D+00,
     +   .2135D+00, -.4423D-01,  .8567D-01,
     +   .2361D+00, -.8066D-01, -.5563D-02,  .1163D-01,  .3162D+00,
     +   .2162D+00, -.4195D-01,  .8805D-01,
     +   .2363D+00, -.8026D-01, -.5180D-02,  .1177D-01,  .3116D+00,
     +   .2185D+00, -.4004D-01,  .9013D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=1,8)/
     +   .2095D+00, -.9242D-01, -.2549D-01,  .9496D-03,  .1618D+00,
     +   .1161D+00, -.1222D+00,  .1806D-02,
     +   .2194D+00, -.9321D-01, -.2350D-01,  .2049D-02,  .2063D+00,
     +   .1306D+00, -.1255D+00,  .7824D-02,
     +   .2255D+00, -.9355D-01, -.2211D-01,  .2804D-02,  .2336D+00,
     +   .1411D+00, -.1245D+00,  .1371D-01,
     +   .2315D+00, -.9374D-01, -.2065D-01,  .3590D-02,  .2590D+00,
     +   .1522D+00, -.1211D+00,  .2090D-01,
     +   .2374D+00, -.9373D-01, -.1905D-01,  .4432D-02,  .2822D+00,
     +   .1641D+00, -.1157D+00,  .2950D-01,
     +   .2410D+00, -.9361D-01, -.1798D-01,  .4982D-02,  .2951D+00,
     +   .1718D+00, -.1112D+00,  .3549D-01,
     +   .2434D+00, -.9346D-01, -.1720D-01,  .5379D-02,  .3032D+00,
     +   .1775D+00, -.1077D+00,  .3998D-01,
     +   .2466D+00, -.9316D-01, -.1610D-01,  .5928D-02,  .3125D+00,
     +   .1853D+00, -.1023D+00,  .4637D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=9,16)/
     +   .2487D+00, -.9289D-01, -.1533D-01,  .6308D-02,  .3175D+00,
     +   .1906D+00, -.9846D-01,  .5083D-01,
     +   .2520D+00, -.9227D-01, -.1394D-01,  .6977D-02,  .3235D+00,
     +   .1998D+00, -.9126D-01,  .5879D-01,
     +   .2544D+00, -.9159D-01, -.1275D-01,  .7526D-02,  .3255D+00,
     +   .2076D+00, -.8492D-01,  .6565D-01,
     +   .2561D+00, -.9092D-01, -.1177D-01,  .7960D-02,  .3249D+00,
     +   .2140D+00, -.7957D-01,  .7134D-01,
     +   .2572D+00, -.9029D-01, -.1098D-01,  .8296D-02,  .3230D+00,
     +   .2191D+00, -.7520D-01,  .7596D-01,
     +   .2583D+00, -.8950D-01, -.1009D-01,  .8653D-02,  .3193D+00,
     +   .2248D+00, -.7030D-01,  .8112D-01,
     +   .2589D+00, -.8877D-01, -.9370D-02,  .8931D-02,  .3150D+00,
     +   .2294D+00, -.6634D-01,  .8532D-01,
     +   .2593D+00, -.8804D-01, -.8719D-02,  .9168D-02,  .3102D+00,
     +   .2336D+00, -.6270D-01,  .8915D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=17,25)/
     +   .2596D+00, -.8735D-01, -.8156D-02,  .9360D-02,  .3052D+00,
     +   .2373D+00, -.5952D-01,  .9248D-01,
     +   .2596D+00, -.8646D-01, -.7488D-02,  .9573D-02,  .2983D+00,
     +   .2417D+00, -.5573D-01,  .9653D-01,
     +   .2595D+00, -.8559D-01, -.6903D-02,  .9744D-02,  .2914D+00,
     +   .2457D+00, -.5238D-01,  .1001D+00,
     +   .2592D+00, -.8471D-01, -.6359D-02,  .9887D-02,  .2842D+00,
     +   .2494D+00, -.4922D-01,  .1035D+00,
     +   .2588D+00, -.8393D-01, -.5909D-02,  .9993D-02,  .2776D+00,
     +   .2525D+00, -.4660D-01,  .1064D+00,
     +   .2582D+00, -.8310D-01, -.5468D-02,  .1008D-01,  .2707D+00,
     +   .2556D+00, -.4396D-01,  .1092D+00,
     +   .2576D+00, -.8230D-01, -.5075D-02,  .1016D-01,  .2640D+00,
     +   .2586D+00, -.4163D-01,  .1118D+00,
     +   .2569D+00, -.8150D-01, -.4704D-02,  .1021D-01,  .2574D+00,
     +   .2614D+00, -.3939D-01,  .1143D+00,
     +   .2562D+00, -.8078D-01, -.4393D-02,  .1025D-01,  .2514D+00,
     +   .2638D+00, -.3748D-01,  .1165D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=1,8)/
     +   .2545D+00, -.1041D+00, -.2486D-01,  .1133D-02,  .2204D+00,
     +   .1292D+00, -.1435D+00, -.8068D-03,
     +   .2625D+00, -.1037D+00, -.2245D-01,  .2337D-02,  .2575D+00,
     +   .1516D+00, -.1396D+00,  .1267D-01,
     +   .2673D+00, -.1031D+00, -.2085D-01,  .3110D-02,  .2781D+00,
     +   .1663D+00, -.1345D+00,  .2268D-01,
     +   .2716D+00, -.1024D+00, -.1921D-01,  .3873D-02,  .2953D+00,
     +   .1809D+00, -.1276D+00,  .3343D-01,
     +   .2756D+00, -.1014D+00, -.1748D-01,  .4648D-02,  .3087D+00,
     +   .1957D+00, -.1190D+00,  .4511D-01,
     +   .2778D+00, -.1006D+00, -.1635D-01,  .5132D-02,  .3146D+00,
     +   .2050D+00, -.1128D+00,  .5276D-01,
     +   .2792D+00, -.9990D-01, -.1554D-01,  .5471D-02,  .3175D+00,
     +   .2115D+00, -.1082D+00,  .5828D-01,
     +   .2808D+00, -.9889D-01, -.1442D-01,  .5922D-02,  .3194D+00,
     +   .2204D+00, -.1016D+00,  .6592D-01 /
        DATA ((PARTON(I,N,20),I=1,8),N=9,16)/
     +   .2817D+00, -.9813D-01, -.1365D-01,  .6225D-02,  .3192D+00,
     +   .2262D+00, -.9695D-01,  .7110D-01,
     +   .2828D+00, -.9662D-01, -.1229D-01,  .6738D-02,  .3160D+00,
     +   .2364D+00, -.8878D-01,  .8015D-01,
     +   .2833D+00, -.9517D-01, -.1116D-01,  .7135D-02,  .3104D+00,
     +   .2447D+00, -.8180D-01,  .8775D-01,
     +   .2833D+00, -.9385D-01, -.1024D-01,  .7431D-02,  .3038D+00,
     +   .2515D+00, -.7602D-01,  .9394D-01,
     +   .2830D+00, -.9270D-01, -.9510D-02,  .7647D-02,  .2973D+00,
     +   .2568D+00, -.7139D-01,  .9887D-01,
     +   .2824D+00, -.9131D-01, -.8707D-02,  .7865D-02,  .2888D+00,
     +   .2626D+00, -.6625D-01,  .1043D+00,
     +   .2816D+00, -.9008D-01, -.8061D-02,  .8023D-02,  .2808D+00,
     +   .2674D+00, -.6214D-01,  .1087D+00,
     +   .2806D+00, -.8890D-01, -.7485D-02,  .8147D-02,  .2729D+00,
     +   .2716D+00, -.5843D-01,  .1127D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=17,25)/
     +   .2796D+00, -.8782D-01, -.6994D-02,  .8240D-02,  .2654D+00,
     +   .2753D+00, -.5525D-01,  .1162D+00,
     +   .2782D+00, -.8644D-01, -.6416D-02,  .8330D-02,  .2559D+00,
     +   .2798D+00, -.5144D-01,  .1203D+00,
     +   .2766D+00, -.8515D-01, -.5917D-02,  .8391D-02,  .2469D+00,
     +   .2837D+00, -.4807D-01,  .1240D+00,
     +   .2750D+00, -.8387D-01, -.5457D-02,  .8430D-02,  .2380D+00,
     +   .2874D+00, -.4493D-01,  .1274D+00,
     +   .2734D+00, -.8274D-01, -.5080D-02,  .8449D-02,  .2302D+00,
     +   .2905D+00, -.4231D-01,  .1303D+00,
     +   .2716D+00, -.8157D-01, -.4714D-02,  .8455D-02,  .2223D+00,
     +   .2936D+00, -.3975D-01,  .1332D+00,
     +   .2699D+00, -.8047D-01, -.4390D-02,  .8448D-02,  .2149D+00,
     +   .2964D+00, -.3743D-01,  .1359D+00,
     +   .2681D+00, -.7938D-01, -.4087D-02,  .8430D-02,  .2077D+00,
     +   .2992D+00, -.3521D-01,  .1384D+00,
     +   .2665D+00, -.7841D-01, -.3834D-02,  .8407D-02,  .2014D+00,
     +   .3015D+00, -.3334D-01,  .1405D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=1,8)/
     +   .2964D+00, -.1128D+00, -.2337D-01,  .1176D-02,  .2738D+00,
     +   .1477D+00, -.1601D+00,  .1775D-02,
     +   .3017D+00, -.1110D+00, -.2078D-01,  .2357D-02,  .2993D+00,
     +   .1766D+00, -.1489D+00,  .2216D-01,
     +   .3045D+00, -.1095D+00, -.1910D-01,  .3077D-02,  .3111D+00,
     +   .1943D+00, -.1399D+00,  .3567D-01,
     +   .3066D+00, -.1078D+00, -.1742D-01,  .3761D-02,  .3187D+00,
     +   .2112D+00, -.1297D+00,  .4926D-01,
     +   .3081D+00, -.1058D+00, -.1569D-01,  .4424D-02,  .3216D+00,
     +   .2276D+00, -.1185D+00,  .6319D-01,
     +   .3086D+00, -.1043D+00, -.1459D-01,  .4822D-02,  .3207D+00,
     +   .2376D+00, -.1110D+00,  .7199D-01,
     +   .3087D+00, -.1032D+00, -.1381D-01,  .5092D-02,  .3186D+00,
     +   .2446D+00, -.1056D+00,  .7822D-01,
     +   .3084D+00, -.1015D+00, -.1274D-01,  .5440D-02,  .3138D+00,
     +   .2538D+00, -.9802D-01,  .8665D-01 /
        DATA ((PARTON(I,N,21),I=1,8),N=9,16)/
     +   .3080D+00, -.1003D+00, -.1201D-01,  .5666D-02,  .3092D+00,
     +   .2599D+00, -.9285D-01,  .9225D-01,
     +   .3067D+00, -.9799D-01, -.1074D-01,  .6034D-02,  .2985D+00,
     +   .2703D+00, -.8399D-01,  .1019D+00,
     +   .3050D+00, -.9584D-01, -.9701D-02,  .6300D-02,  .2871D+00,
     +   .2786D+00, -.7655D-01,  .1098D+00,
     +   .3031D+00, -.9395D-01, -.8871D-02,  .6483D-02,  .2762D+00,
     +   .2854D+00, -.7054D-01,  .1162D+00,
     +   .3013D+00, -.9234D-01, -.8221D-02,  .6607D-02,  .2666D+00,
     +   .2906D+00, -.6575D-01,  .1213D+00,
     +   .2989D+00, -.9043D-01, -.7512D-02,  .6721D-02,  .2550D+00,
     +   .2963D+00, -.6057D-01,  .1268D+00,
     +   .2966D+00, -.8879D-01, -.6948D-02,  .6792D-02,  .2449D+00,
     +   .3010D+00, -.5639D-01,  .1313D+00,
     +   .2942D+00, -.8723D-01, -.6449D-02,  .6839D-02,  .2352D+00,
     +   .3050D+00, -.5267D-01,  .1353D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=17,25)/
     +   .2920D+00, -.8582D-01, -.6026D-02,  .6865D-02,  .2265D+00,
     +   .3086D+00, -.4945D-01,  .1387D+00,
     +   .2890D+00, -.8406D-01, -.5533D-02,  .6877D-02,  .2158D+00,
     +   .3130D+00, -.4566D-01,  .1429D+00,
     +   .2861D+00, -.8243D-01, -.5110D-02,  .6870D-02,  .2060D+00,
     +   .3166D+00, -.4232D-01,  .1465D+00,
     +   .2831D+00, -.8083D-01, -.4724D-02,  .6848D-02,  .1966D+00,
     +   .3202D+00, -.3922D-01,  .1500D+00,
     +   .2804D+00, -.7944D-01, -.4409D-02,  .6817D-02,  .1886D+00,
     +   .3232D+00, -.3665D-01,  .1529D+00,
     +   .2775D+00, -.7801D-01, -.4104D-02,  .6775D-02,  .1805D+00,
     +   .3262D+00, -.3410D-01,  .1557D+00,
     +   .2747D+00, -.7668D-01, -.3836D-02,  .6727D-02,  .1732D+00,
     +   .3289D+00, -.3181D-01,  .1584D+00,
     +   .2719D+00, -.7537D-01, -.3586D-02,  .6672D-02,  .1662D+00,
     +   .3315D+00, -.2966D-01,  .1609D+00,
     +   .2694D+00, -.7422D-01, -.3379D-02,  .6619D-02,  .1602D+00,
     +   .3338D+00, -.2780D-01,  .1630D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=1,8)/
     +   .3344D+00, -.1185D+00, -.2136D-01,  .1115D-02,  .3169D+00,
     +   .1722D+00, -.1706D+00,  .1069D-01,
     +   .3363D+00, -.1154D+00, -.1877D-01,  .2187D-02,  .3286D+00,
     +   .2052D+00, -.1529D+00,  .3649D-01,
     +   .3366D+00, -.1131D+00, -.1712D-01,  .2816D-02,  .3309D+00,
     +   .2244D+00, -.1406D+00,  .5254D-01,
     +   .3362D+00, -.1105D+00, -.1550D-01,  .3393D-02,  .3288D+00,
     +   .2421D+00, -.1280D+00,  .6801D-01,
     +   .3348D+00, -.1075D+00, -.1386D-01,  .3932D-02,  .3219D+00,
     +   .2592D+00, -.1147D+00,  .8335D-01,
     +   .3334D+00, -.1055D+00, -.1283D-01,  .4244D-02,  .3148D+00,
     +   .2693D+00, -.1062D+00,  .9279D-01,
     +   .3321D+00, -.1039D+00, -.1210D-01,  .4448D-02,  .3086D+00,
     +   .2763D+00, -.1001D+00,  .9936D-01,
     +   .3298D+00, -.1017D+00, -.1111D-01,  .4704D-02,  .2983D+00,
     +   .2855D+00, -.9195D-01,  .1081D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=9,16)/
     +   .3279D+00, -.1000D+00, -.1045D-01,  .4865D-02,  .2902D+00,
     +   .2915D+00, -.8653D-01,  .1140D+00,
     +   .3240D+00, -.9699D-01, -.9307D-02,  .5114D-02,  .2740D+00,
     +   .3015D+00, -.7718D-01,  .1238D+00,
     +   .3201D+00, -.9426D-01, -.8381D-02,  .5278D-02,  .2587D+00,
     +   .3096D+00, -.6954D-01,  .1318D+00,
     +   .3163D+00, -.9189D-01, -.7649D-02,  .5380D-02,  .2452D+00,
     +   .3160D+00, -.6341D-01,  .1382D+00,
     +   .3129D+00, -.8990D-01, -.7079D-02,  .5440D-02,  .2338D+00,
     +   .3209D+00, -.5860D-01,  .1432D+00,
     +   .3086D+00, -.8758D-01, -.6464D-02,  .5484D-02,  .2206D+00,
     +   .3264D+00, -.5338D-01,  .1487D+00,
     +   .3049D+00, -.8561D-01, -.5977D-02,  .5501D-02,  .2095D+00,
     +   .3308D+00, -.4922D-01,  .1531D+00,
     +   .3011D+00, -.8376D-01, -.5549D-02,  .5500D-02,  .1992D+00,
     +   .3348D+00, -.4551D-01,  .1571D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=17,25)/
     +   .2977D+00, -.8210D-01, -.5189D-02,  .5487D-02,  .1902D+00,
     +   .3381D+00, -.4233D-01,  .1605D+00,
     +   .2933D+00, -.8004D-01, -.4771D-02,  .5455D-02,  .1792D+00,
     +   .3422D+00, -.3856D-01,  .1646D+00,
     +   .2891D+00, -.7815D-01, -.4413D-02,  .5412D-02,  .1695D+00,
     +   .3456D+00, -.3524D-01,  .1681D+00,
     +   .2848D+00, -.7633D-01, -.4089D-02,  .5359D-02,  .1604D+00,
     +   .3490D+00, -.3218D-01,  .1714D+00,
     +   .2811D+00, -.7475D-01, -.3824D-02,  .5305D-02,  .1527D+00,
     +   .3518D+00, -.2965D-01,  .1743D+00,
     +   .2772D+00, -.7314D-01, -.3570D-02,  .5242D-02,  .1452D+00,
     +   .3545D+00, -.2713D-01,  .1771D+00,
     +   .2735D+00, -.7165D-01, -.3346D-02,  .5178D-02,  .1384D+00,
     +   .3572D+00, -.2486D-01,  .1797D+00,
     +   .2698D+00, -.7020D-01, -.3139D-02,  .5110D-02,  .1319D+00,
     +   .3595D+00, -.2271D-01,  .1821D+00,
     +   .2665D+00, -.6893D-01, -.2966D-02,  .5047D-02,  .1265D+00,
     +   .3617D+00, -.2088D-01,  .1843D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=1,8)/
     +   .3677D+00, -.1216D+00, -.1907D-01,  .9858D-03,  .3467D+00,
     +   .2017D+00, -.1745D+00,  .2586D-01,
     +   .3657D+00, -.1173D+00, -.1661D-01,  .1904D-02,  .3441D+00,
     +   .2361D+00, -.1517D+00,  .5516D-01,
     +   .3634D+00, -.1142D+00, -.1507D-01,  .2426D-02,  .3373D+00,
     +   .2556D+00, -.1370D+00,  .7268D-01,
     +   .3601D+00, -.1108D+00, -.1357D-01,  .2892D-02,  .3265D+00,
     +   .2732D+00, -.1225D+00,  .8908D-01,
     +   .3557D+00, -.1070D+00, -.1207D-01,  .3312D-02,  .3112D+00,
     +   .2899D+00, -.1079D+00,  .1050D+00,
     +   .3522D+00, -.1044D+00, -.1113D-01,  .3546D-02,  .2993D+00,
     +   .2997D+00, -.9874D-01,  .1146D+00,
     +   .3494D+00, -.1025D+00, -.1047D-01,  .3695D-02,  .2898D+00,
     +   .3063D+00, -.9238D-01,  .1213D+00,
     +   .3450D+00, -.9973D-01, -.9592D-02,  .3876D-02,  .2756D+00,
     +   .3151D+00, -.8382D-01,  .1301D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=9,16)/
     +   .3417D+00, -.9776D-01, -.9002D-02,  .3985D-02,  .2651D+00,
     +   .3208D+00, -.7823D-01,  .1359D+00,
     +   .3352D+00, -.9415D-01, -.7994D-02,  .4145D-02,  .2454D+00,
     +   .3302D+00, -.6872D-01,  .1456D+00,
     +   .3290D+00, -.9094D-01, -.7184D-02,  .4239D-02,  .2279D+00,
     +   .3376D+00, -.6095D-01,  .1534D+00,
     +   .3233D+00, -.8820D-01, -.6549D-02,  .4287D-02,  .2131D+00,
     +   .3437D+00, -.5483D-01,  .1597D+00,
     +   .3184D+00, -.8592D-01, -.6057D-02,  .4306D-02,  .2010D+00,
     +   .3483D+00, -.5001D-01,  .1646D+00,
     +   .3125D+00, -.8329D-01, -.5529D-02,  .4308D-02,  .1874D+00,
     +   .3534D+00, -.4485D-01,  .1700D+00,
     +   .3073D+00, -.8108D-01, -.5112D-02,  .4294D-02,  .1762D+00,
     +   .3575D+00, -.4070D-01,  .1742D+00,
     +   .3023D+00, -.7901D-01, -.4748D-02,  .4269D-02,  .1660D+00,
     +   .3611D+00, -.3703D-01,  .1780D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=17,25)/
     +   .2978D+00, -.7717D-01, -.4442D-02,  .4236D-02,  .1573D+00,
     +   .3643D+00, -.3390D-01,  .1814D+00,
     +   .2920D+00, -.7492D-01, -.4088D-02,  .4185D-02,  .1469D+00,
     +   .3680D+00, -.3016D-01,  .1853D+00,
     +   .2867D+00, -.7286D-01, -.3787D-02,  .4128D-02,  .1378D+00,
     +   .3713D+00, -.2690D-01,  .1887D+00,
     +   .2814D+00, -.7089D-01, -.3513D-02,  .4065D-02,  .1294D+00,
     +   .3744D+00, -.2387D-01,  .1920D+00,
     +   .2767D+00, -.6919D-01, -.3292D-02,  .4005D-02,  .1224D+00,
     +   .3769D+00, -.2134D-01,  .1947D+00,
     +   .2719D+00, -.6747D-01, -.3078D-02,  .3939D-02,  .1156D+00,
     +   .3796D+00, -.1884D-01,  .1975D+00,
     +   .2674D+00, -.6589D-01, -.2891D-02,  .3873D-02,  .1096D+00,
     +   .3819D+00, -.1660D-01,  .2000D+00,
     +   .2630D+00, -.6435D-01, -.2717D-02,  .3806D-02,  .1039D+00,
     +   .3842D+00, -.1445D-01,  .2024D+00,
     +   .2591D+00, -.6302D-01, -.2573D-02,  .3745D-02,  .9915D-01,
     +   .3862D+00, -.1262D-01,  .2044D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=1,8)/
     +   .3958D+00, -.1223D+00, -.1668D-01,  .8227D-03,  .3619D+00,
     +   .2346D+00, -.1721D+00,  .4644D-01,
     +   .3896D+00, -.1169D+00, -.1444D-01,  .1570D-02,  .3461D+00,
     +   .2682D+00, -.1457D+00,  .7728D-01,
     +   .3844D+00, -.1131D+00, -.1305D-01,  .1985D-02,  .3315D+00,
     +   .2869D+00, -.1294D+00,  .9523D-01,
     +   .3782D+00, -.1091D+00, -.1171D-01,  .2346D-02,  .3136D+00,
     +   .3036D+00, -.1138D+00,  .1118D+00,
     +   .3706D+00, -.1046D+00, -.1037D-01,  .2662D-02,  .2919D+00,
     +   .3192D+00, -.9844D-01,  .1276D+00,
     +   .3651D+00, -.1016D+00, -.9537D-02,  .2833D-02,  .2765D+00,
     +   .3283D+00, -.8906D-01,  .1371D+00,
     +   .3608D+00, -.9935D-01, -.8959D-02,  .2939D-02,  .2649D+00,
     +   .3344D+00, -.8251D-01,  .1436D+00,
     +   .3543D+00, -.9618D-01, -.8186D-02,  .3063D-02,  .2482D+00,
     +   .3426D+00, -.7387D-01,  .1522D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=9,16)/
     +   .3496D+00, -.9395D-01, -.7671D-02,  .3135D-02,  .2363D+00,
     +   .3477D+00, -.6817D-01,  .1578D+00,
     +   .3406D+00, -.8990D-01, -.6797D-02,  .3233D-02,  .2149D+00,
     +   .3564D+00, -.5865D-01,  .1671D+00,
     +   .3322D+00, -.8634D-01, -.6100D-02,  .3280D-02,  .1966D+00,
     +   .3634D+00, -.5095D-01,  .1747D+00,
     +   .3248D+00, -.8333D-01, -.5555D-02,  .3296D-02,  .1816D+00,
     +   .3688D+00, -.4488D-01,  .1807D+00,
     +   .3185D+00, -.8084D-01, -.5135D-02,  .3292D-02,  .1697D+00,
     +   .3730D+00, -.4015D-01,  .1854D+00,
     +   .3111D+00, -.7800D-01, -.4685D-02,  .3273D-02,  .1565D+00,
     +   .3778D+00, -.3503D-01,  .1906D+00,
     +   .3047D+00, -.7563D-01, -.4332D-02,  .3246D-02,  .1458D+00,
     +   .3815D+00, -.3097D-01,  .1947D+00,
     +   .2986D+00, -.7343D-01, -.4024D-02,  .3211D-02,  .1363D+00,
     +   .3847D+00, -.2733D-01,  .1983D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=17,25)/
     +   .2931D+00, -.7148D-01, -.3765D-02,  .3172D-02,  .1283D+00,
     +   .3877D+00, -.2423D-01,  .2015D+00,
     +   .2862D+00, -.6910D-01, -.3467D-02,  .3117D-02,  .1188D+00,
     +   .3910D+00, -.2055D-01,  .2052D+00,
     +   .2798D+00, -.6696D-01, -.3213D-02,  .3060D-02,  .1107D+00,
     +   .3941D+00, -.1732D-01,  .2086D+00,
     +   .2736D+00, -.6490D-01, -.2984D-02,  .2999D-02,  .1032D+00,
     +   .3971D+00, -.1432D-01,  .2118D+00,
     +   .2682D+00, -.6315D-01, -.2797D-02,  .2943D-02,  .9713D-01,
     +   .3995D+00, -.1181D-01,  .2144D+00,
     +   .2627D+00, -.6138D-01, -.2618D-02,  .2882D-02,  .9124D-01,
     +   .4019D+00, -.9323D-02,  .2171D+00,
     +   .2575D+00, -.5977D-01, -.2461D-02,  .2824D-02,  .8605D-01,
     +   .4040D+00, -.7084D-02,  .2194D+00,
     +   .2525D+00, -.5820D-01, -.2316D-02,  .2764D-02,  .8122D-01,
     +   .4061D+00, -.4942D-02,  .2217D+00,
     +   .2481D+00, -.5684D-01, -.2195D-02,  .2711D-02,  .7721D-01,
     +   .4079D+00, -.3114D-02,  .2237D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=1,8)/
     +   .4182D+00, -.1210D+00, -.1433D-01,  .6503D-03,  .3630D+00,
     +   .2691D+00, -.1640D+00,  .7116D-01,
     +   .4076D+00, -.1146D+00, -.1235D-01,  .1231D-02,  .3362D+00,
     +   .3003D+00, -.1356D+00,  .1019D+00,
     +   .3996D+00, -.1103D+00, -.1113D-01,  .1548D-02,  .3154D+00,
     +   .3173D+00, -.1185D+00,  .1194D+00,
     +   .3905D+00, -.1057D+00, -.9953D-02,  .1819D-02,  .2923D+00,
     +   .3326D+00, -.1023D+00,  .1354D+00,
     +   .3798D+00, -.1006D+00, -.8785D-02,  .2050D-02,  .2664D+00,
     +   .3466D+00, -.8678D-01,  .1506D+00,
     +   .3723D+00, -.9731D-01, -.8066D-02,  .2172D-02,  .2489D+00,
     +   .3549D+00, -.7731D-01,  .1597D+00,
     +   .3666D+00, -.9485D-01, -.7567D-02,  .2245D-02,  .2362D+00,
     +   .3605D+00, -.7084D-01,  .1660D+00,
     +   .3582D+00, -.9139D-01, -.6901D-02,  .2328D-02,  .2183D+00,
     +   .3677D+00, -.6218D-01,  .1740D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=9,16)/
     +   .3521D+00, -.8896D-01, -.6460D-02,  .2374D-02,  .2060D+00,
     +   .3726D+00, -.5657D-01,  .1794D+00,
     +   .3407D+00, -.8460D-01, -.5714D-02,  .2432D-02,  .1844D+00,
     +   .3803D+00, -.4722D-01,  .1883D+00,
     +   .3304D+00, -.8081D-01, -.5120D-02,  .2453D-02,  .1665D+00,
     +   .3866D+00, -.3968D-01,  .1955D+00,
     +   .3215D+00, -.7762D-01, -.4658D-02,  .2451D-02,  .1521D+00,
     +   .3916D+00, -.3371D-01,  .2011D+00,
     +   .3139D+00, -.7502D-01, -.4303D-02,  .2438D-02,  .1409D+00,
     +   .3953D+00, -.2905D-01,  .2056D+00,
     +   .3052D+00, -.7206D-01, -.3924D-02,  .2411D-02,  .1286D+00,
     +   .3997D+00, -.2402D-01,  .2105D+00,
     +   .2977D+00, -.6960D-01, -.3626D-02,  .2381D-02,  .1190D+00,
     +   .4030D+00, -.2003D-01,  .2143D+00,
     +   .2906D+00, -.6733D-01, -.3367D-02,  .2345D-02,  .1105D+00,
     +   .4062D+00, -.1647D-01,  .2179D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=17,25)/
     +   .2843D+00, -.6534D-01, -.3150D-02,  .2309D-02,  .1033D+00,
     +   .4086D+00, -.1341D-01,  .2208D+00,
     +   .2765D+00, -.6292D-01, -.2900D-02,  .2258D-02,  .9500D-01,
     +   .4120D+00, -.9777D-02,  .2246D+00,
     +   .2693D+00, -.6074D-01, -.2688D-02,  .2208D-02,  .8793D-01,
     +   .4146D+00, -.6590D-02,  .2277D+00,
     +   .2624D+00, -.5867D-01, -.2496D-02,  .2155D-02,  .8154D-01,
     +   .4172D+00, -.3611D-02,  .2307D+00,
     +   .2564D+00, -.5692D-01, -.2340D-02,  .2108D-02,  .7636D-01,
     +   .4194D+00, -.1119D-02,  .2332D+00,
     +   .2503D+00, -.5515D-01, -.2191D-02,  .2057D-02,  .7139D-01,
     +   .4217D+00,  .1355D-02,  .2358D+00,
     +   .2447D+00, -.5354D-01, -.2060D-02,  .2009D-02,  .6705D-01,
     +   .4238D+00,  .3590D-02,  .2381D+00,
     +   .2392D+00, -.5199D-01, -.1938D-02,  .1961D-02,  .6304D-01,
     +   .4256D+00,  .5732D-02,  .2403D+00,
     +   .2344D+00, -.5066D-01, -.1837D-02,  .1918D-02,  .5972D-01,
     +   .4273D+00,  .7563D-02,  .2422D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=1,8)/
     +   .4347D+00, -.1179D+00, -.1209D-01,  .4868D-03,  .3516D+00,
     +   .3035D+00, -.1511D+00,  .9863D-01,
     +   .4198D+00, -.1108D+00, -.1040D-01,  .9178D-03,  .3165D+00,
     +   .3312D+00, -.1219D+00,  .1278D+00,
     +   .4090D+00, -.1059D+00, -.9347D-02,  .1151D-02,  .2915D+00,
     +   .3464D+00, -.1047D+00,  .1444D+00,
     +   .3971D+00, -.1009D+00, -.8340D-02,  .1348D-02,  .2652D+00,
     +   .3598D+00, -.8864D-01,  .1595D+00,
     +   .3835D+00, -.9551D-01, -.7343D-02,  .1513D-02,  .2371D+00,
     +   .3723D+00, -.7320D-01,  .1737D+00,
     +   .3741D+00, -.9193D-01, -.6731D-02,  .1598D-02,  .2189D+00,
     +   .3796D+00, -.6390D-01,  .1822D+00,
     +   .3670D+00, -.8933D-01, -.6307D-02,  .1648D-02,  .2058D+00,
     +   .3845D+00, -.5754D-01,  .1880D+00,
     +   .3568D+00, -.8567D-01, -.5743D-02,  .1703D-02,  .1880D+00,
     +   .3910D+00, -.4915D-01,  .1956D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=9,16)/
     +   .3495D+00, -.8313D-01, -.5369D-02,  .1733D-02,  .1760D+00,
     +   .3951D+00, -.4365D-01,  .2005D+00,
     +   .3361D+00, -.7857D-01, -.4741D-02,  .1766D-02,  .1552D+00,
     +   .4022D+00, -.3454D-01,  .2089D+00,
     +   .3241D+00, -.7466D-01, -.4242D-02,  .1773D-02,  .1385D+00,
     +   .4077D+00, -.2720D-01,  .2156D+00,
     +   .3138D+00, -.7139D-01, -.3855D-02,  .1765D-02,  .1253D+00,
     +   .4124D+00, -.2139D-01,  .2210D+00,
     +   .3053D+00, -.6874D-01, -.3558D-02,  .1749D-02,  .1151D+00,
     +   .4158D+00, -.1685D-01,  .2252D+00,
     +   .2954D+00, -.6574D-01, -.3241D-02,  .1723D-02,  .1042D+00,
     +   .4195D+00, -.1193D-01,  .2297D+00,
     +   .2870D+00, -.6326D-01, -.2993D-02,  .1695D-02,  .9572D-01,
     +   .4226D+00, -.8030D-02,  .2334D+00,
     +   .2792D+00, -.6099D-01, -.2777D-02,  .1665D-02,  .8833D-01,
     +   .4255D+00, -.4532D-02,  .2368D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=17,25)/
     +   .2722D+00, -.5900D-01, -.2596D-02,  .1634D-02,  .8216D-01,
     +   .4278D+00, -.1524D-02,  .2396D+00,
     +   .2637D+00, -.5660D-01, -.2389D-02,  .1593D-02,  .7510D-01,
     +   .4308D+00,  .2053D-02,  .2431D+00,
     +   .2559D+00, -.5446D-01, -.2212D-02,  .1552D-02,  .6914D-01,
     +   .4334D+00,  .5202D-02,  .2462D+00,
     +   .2485D+00, -.5242D-01, -.2053D-02,  .1510D-02,  .6379D-01,
     +   .4358D+00,  .8154D-02,  .2490D+00,
     +   .2421D+00, -.5070D-01, -.1924D-02,  .1473D-02,  .5949D-01,
     +   .4378D+00,  .1063D-01,  .2514D+00,
     +   .2356D+00, -.4899D-01, -.1800D-02,  .1433D-02,  .5540D-01,
     +   .4398D+00,  .1309D-01,  .2539D+00,
     +   .2296D+00, -.4743D-01, -.1691D-02,  .1396D-02,  .5185D-01,
     +   .4414D+00,  .1532D-01,  .2560D+00,
     +   .2238D+00, -.4592D-01, -.1590D-02,  .1359D-02,  .4859D-01,
     +   .4436D+00,  .1746D-01,  .2582D+00,
     +   .2188D+00, -.4464D-01, -.1507D-02,  .1326D-02,  .4590D-01,
     +   .4450D+00,  .1929D-01,  .2600D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=1,8)/
     +   .4452D+00, -.1132D+00, -.1004D-01,  .3429D-03,  .3300D+00,
     +   .3367D+00, -.1343D+00,  .1275D+00,
     +   .4262D+00, -.1056D+00, -.8612D-02,  .6477D-03,  .2895D+00,
     +   .3604D+00, -.1055D+00,  .1544D+00,
     +   .4127D+00, -.1004D+00, -.7732D-02,  .8124D-03,  .2623D+00,
     +   .3735D+00, -.8865D-01,  .1696D+00,
     +   .3981D+00, -.9512D-01, -.6886D-02,  .9515D-03,  .2347D+00,
     +   .3850D+00, -.7303D-01,  .1834D+00,
     +   .3819D+00, -.8947D-01, -.6050D-02,  .1068D-02,  .2062D+00,
     +   .3958D+00, -.5808D-01,  .1964D+00,
     +   .3708D+00, -.8576D-01, -.5537D-02,  .1127D-02,  .1883D+00,
     +   .4022D+00, -.4914D-01,  .2042D+00,
     +   .3626D+00, -.8307D-01, -.5182D-02,  .1161D-02,  .1756D+00,
     +   .4064D+00, -.4301D-01,  .2096D+00,
     +   .3508D+00, -.7931D-01, -.4711D-02,  .1198D-02,  .1587D+00,
     +   .4122D+00, -.3488D-01,  .2166D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=9,16)/
     +   .3425D+00, -.7671D-01, -.4400D-02,  .1217D-02,  .1474D+00,
     +   .4160D+00, -.2961D-01,  .2212D+00,
     +   .3273D+00, -.7209D-01, -.3877D-02,  .1237D-02,  .1283D+00,
     +   .4220D+00, -.2080D-01,  .2288D+00,
     +   .3139D+00, -.6815D-01, -.3464D-02,  .1238D-02,  .1132D+00,
     +   .4271D+00, -.1370D-01,  .2351D+00,
     +   .3025D+00, -.6488D-01, -.3143D-02,  .1229D-02,  .1016D+00,
     +   .4309D+00, -.8070D-02,  .2400D+00,
     +   .2931D+00, -.6224D-01, -.2897D-02,  .1215D-02,  .9269D-01,
     +   .4342D+00, -.3658D-02,  .2440D+00,
     +   .2823D+00, -.5928D-01, -.2635D-02,  .1194D-02,  .8329D-01,
     +   .4376D+00,  .1130D-02,  .2483D+00,
     +   .2733D+00, -.5684D-01, -.2431D-02,  .1172D-02,  .7603D-01,
     +   .4404D+00,  .4942D-02,  .2518D+00,
     +   .2650D+00, -.5462D-01, -.2253D-02,  .1148D-02,  .6978D-01,
     +   .4430D+00,  .8367D-02,  .2549D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=17,25)/
     +   .2575D+00, -.5268D-01, -.2105D-02,  .1125D-02,  .6461D-01,
     +   .4451D+00,  .1132D-01,  .2576D+00,
     +   .2485D+00, -.5035D-01, -.1934D-02,  .1093D-02,  .5874D-01,
     +   .4479D+00,  .1484D-01,  .2609D+00,
     +   .2403D+00, -.4827D-01, -.1789D-02,  .1062D-02,  .5383D-01,
     +   .4501D+00,  .1795D-01,  .2638D+00,
     +   .2325D+00, -.4632D-01, -.1658D-02,  .1031D-02,  .4945D-01,
     +   .4523D+00,  .2087D-01,  .2665D+00,
     +   .2258D+00, -.4467D-01, -.1552D-02,  .1004D-02,  .4597D-01,
     +   .4542D+00,  .2332D-01,  .2688D+00,
     +   .2191D+00, -.4303D-01, -.1450D-02,  .9746D-03,  .4266D-01,
     +   .4561D+00,  .2577D-01,  .2712D+00,
     +   .2130D+00, -.4155D-01, -.1361D-02,  .9474D-03,  .3981D-01,
     +   .4578D+00,  .2799D-01,  .2733D+00,
     +   .2070D+00, -.4013D-01, -.1279D-02,  .9205D-03,  .3720D-01,
     +   .4595D+00,  .3013D-01,  .2753D+00,
     +   .2019D+00, -.3891D-01, -.1211D-02,  .8968D-03,  .3507D-01,
     +   .4608D+00,  .3196D-01,  .2770D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=1,8)/
     +   .4497D+00, -.1074D+00, -.8196D-02,  .2242D-03,  .3009D+00,
     +   .3676D+00, -.1145D+00,  .1568D+00,
     +   .4269D+00, -.9935D-01, -.7022D-02,  .4280D-03,  .2580D+00,
     +   .3872D+00, -.8683D-01,  .1807D+00,
     +   .4110D+00, -.9402D-01, -.6297D-02,  .5400D-03,  .2302D+00,
     +   .3983D+00, -.7079D-01,  .1943D+00,
     +   .3941D+00, -.8857D-01, -.5599D-02,  .6356D-03,  .2029D+00,
     +   .4081D+00, -.5596D-01,  .2067D+00,
     +   .3755D+00, -.8280D-01, -.4909D-02,  .7161D-03,  .1754D+00,
     +   .4175D+00, -.4174D-01,  .2186D+00,
     +   .3630D+00, -.7904D-01, -.4487D-02,  .7570D-03,  .1585D+00,
     +   .4229D+00, -.3320D-01,  .2256D+00,
     +   .3538D+00, -.7632D-01, -.4195D-02,  .7810D-03,  .1468D+00,
     +   .4265D+00, -.2735D-01,  .2304D+00,
     +   .3407D+00, -.7255D-01, -.3807D-02,  .8065D-03,  .1314D+00,
     +   .4316D+00, -.1961D-01,  .2369D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=9,16)/
     +   .3315D+00, -.6996D-01, -.3552D-02,  .8196D-03,  .1212D+00,
     +   .4349D+00, -.1456D-01,  .2411D+00,
     +   .3149D+00, -.6538D-01, -.3123D-02,  .8332D-03,  .1043D+00,
     +   .4402D+00, -.6127D-02,  .2481D+00,
     +   .3004D+00, -.6149D-01, -.2784D-02,  .8334D-03,  .9115D-01,
     +   .4447D+00,  .7014D-03,  .2539D+00,
     +   .2882D+00, -.5830D-01, -.2522D-02,  .8264D-03,  .8113D-01,
     +   .4482D+00,  .6134D-02,  .2585D+00,
     +   .2781D+00, -.5573D-01, -.2321D-02,  .8163D-03,  .7358D-01,
     +   .4512D+00,  .1040D-01,  .2623D+00,
     +   .2668D+00, -.5285D-01, -.2108D-02,  .8008D-03,  .6569D-01,
     +   .4542D+00,  .1506D-01,  .2663D+00,
     +   .2573D+00, -.5050D-01, -.1941D-02,  .7850D-03,  .5965D-01,
     +   .4567D+00,  .1877D-01,  .2695D+00,
     +   .2485D+00, -.4837D-01, -.1796D-02,  .7680D-03,  .5449D-01,
     +   .4588D+00,  .2212D-01,  .2724D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=17,25)/
     +   .2409D+00, -.4652D-01, -.1676D-02,  .7513D-03,  .5026D-01,
     +   .4611D+00,  .2501D-01,  .2750D+00,
     +   .2315D+00, -.4430D-01, -.1537D-02,  .7291D-03,  .4548D-01,
     +   .4631D+00,  .2847D-01,  .2780D+00,
     +   .2231D+00, -.4233D-01, -.1419D-02,  .7075D-03,  .4152D-01,
     +   .4655D+00,  .3153D-01,  .2808D+00,
     +   .2151D+00, -.4049D-01, -.1313D-02,  .6857D-03,  .3801D-01,
     +   .4675D+00,  .3442D-01,  .2834D+00,
     +   .2084D+00, -.3894D-01, -.1228D-02,  .6664D-03,  .3523D-01,
     +   .4692D+00,  .3684D-01,  .2856D+00,
     +   .2015D+00, -.3740D-01, -.1145D-02,  .6463D-03,  .3260D-01,
     +   .4710D+00,  .3927D-01,  .2878D+00,
     +   .1953D+00, -.3602D-01, -.1074D-02,  .6274D-03,  .3035D-01,
     +   .4725D+00,  .4148D-01,  .2898D+00,
     +   .1894D+00, -.3469D-01, -.1007D-02,  .6087D-03,  .2830D-01,
     +   .4740D+00,  .4361D-01,  .2917D+00,
     +   .1842D+00, -.3357D-01, -.9520D-03,  .5924D-03,  .2663D-01,
     +   .4754D+00,  .4543D-01,  .2934D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=1,8)/
     +   .4485D+00, -.1006D+00, -.6579D-02,  .1318D-03,  .2670D+00,
     +   .3958D+00, -.9241D-01,  .1854D+00,
     +   .4223D+00, -.9238D-01, -.5634D-02,  .2588D-03,  .2241D+00,
     +   .4119D+00, -.6666D-01,  .2063D+00,
     +   .4042D+00, -.8698D-01, -.5046D-02,  .3317D-03,  .1973D+00,
     +   .4210D+00, -.5164D-01,  .2183D+00,
     +   .3853D+00, -.8149D-01, -.4481D-02,  .3959D-03,  .1714D+00,
     +   .4294D+00, -.3774D-01,  .2294D+00,
     +   .3647D+00, -.7573D-01, -.3921D-02,  .4513D-03,  .1461D+00,
     +   .4370D+00, -.2440D-01,  .2398D+00,
     +   .3511D+00, -.7200D-01, -.3578D-02,  .4801D-03,  .1308D+00,
     +   .4418D+00, -.1636D-01,  .2462D+00,
     +   .3410D+00, -.6932D-01, -.3341D-02,  .4973D-03,  .1204D+00,
     +   .4450D+00, -.1084D-01,  .2506D+00,
     +   .3269D+00, -.6562D-01, -.3027D-02,  .5160D-03,  .1067D+00,
     +   .4494D+00, -.3504D-02,  .2564D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=9,16)/
     +   .3171D+00, -.6308D-01, -.2820D-02,  .5259D-03,  .9790D-01,
     +   .4521D+00,  .1286D-02,  .2602D+00,
     +   .2994D+00, -.5862D-01, -.2474D-02,  .5366D-03,  .8339D-01,
     +   .4568D+00,  .9327D-02,  .2667D+00,
     +   .2841D+00, -.5487D-01, -.2200D-02,  .5380D-03,  .7225D-01,
     +   .4608D+00,  .1587D-01,  .2720D+00,
     +   .2713D+00, -.5180D-01, -.1989D-02,  .5342D-03,  .6387D-01,
     +   .4638D+00,  .2109D-01,  .2762D+00,
     +   .2609D+00, -.4934D-01, -.1828D-02,  .5280D-03,  .5763D-01,
     +   .4664D+00,  .2522D-01,  .2797D+00,
     +   .2492D+00, -.4661D-01, -.1656D-02,  .5183D-03,  .5115D-01,
     +   .4695D+00,  .2973D-01,  .2835D+00,
     +   .2395D+00, -.4438D-01, -.1522D-02,  .5082D-03,  .4624D-01,
     +   .4716D+00,  .3334D-01,  .2865D+00,
     +   .2305D+00, -.4237D-01, -.1406D-02,  .4972D-03,  .4208D-01,
     +   .4735D+00,  .3660D-01,  .2892D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=17,25)/
     +   .2227D+00, -.4063D-01, -.1309D-02,  .4863D-03,  .3868D-01,
     +   .4754D+00,  .3943D-01,  .2916D+00,
     +   .2133D+00, -.3855D-01, -.1198D-02,  .4717D-03,  .3488D-01,
     +   .4776D+00,  .4282D-01,  .2945D+00,
     +   .2049D+00, -.3672D-01, -.1104D-02,  .4576D-03,  .3174D-01,
     +   .4796D+00,  .4584D-01,  .2971D+00,
     +   .1969D+00, -.3501D-01, -.1020D-02,  .4433D-03,  .2897D-01,
     +   .4814D+00,  .4868D-01,  .2996D+00,
     +   .1901D+00, -.3358D-01, -.9516D-03,  .4306D-03,  .2679D-01,
     +   .4830D+00,  .5108D-01,  .3016D+00,
     +   .1834D+00, -.3217D-01, -.8861D-03,  .4173D-03,  .2474D-01,
     +   .4846D+00,  .5348D-01,  .3037D+00,
     +   .1772D+00, -.3089D-01, -.8291D-03,  .4049D-03,  .2299D-01,
     +   .4861D+00,  .5567D-01,  .3056D+00,
     +   .1713D+00, -.2968D-01, -.7763D-03,  .3927D-03,  .2140D-01,
     +   .4875D+00,  .5778D-01,  .3075D+00,
     +   .1663D+00, -.2865D-01, -.7327D-03,  .3820D-03,  .2010D-01,
     +   .4887D+00,  .5959D-01,  .3090D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=1,8)/
     +   .4418D+00, -.9309D-01, -.5192D-02,  .6412D-04,  .2309D+00,
     +   .4212D+00, -.6907D-01,  .2130D+00,
     +   .4126D+00, -.8490D-01, -.4445D-02,  .1357D-03,  .1901D+00,
     +   .4342D+00, -.4541D-01,  .2309D+00,
     +   .3928D+00, -.7953D-01, -.3978D-02,  .1808D-03,  .1652D+00,
     +   .4415D+00, -.3158D-01,  .2413D+00,
     +   .3723D+00, -.7412D-01, -.3527D-02,  .2229D-03,  .1418D+00,
     +   .4484D+00, -.1873D-01,  .2509D+00,
     +   .3502D+00, -.6848D-01, -.3080D-02,  .2612D-03,  .1193D+00,
     +   .4551D+00, -.6332D-02,  .2603D+00,
     +   .3356D+00, -.6485D-01, -.2806D-02,  .2820D-03,  .1059D+00,
     +   .4591D+00,  .1178D-02,  .2659D+00,
     +   .3250D+00, -.6225D-01, -.2617D-02,  .2949D-03,  .9688D-01,
     +   .4615D+00,  .6363D-02,  .2698D+00,
     +   .3101D+00, -.5868D-01, -.2366D-02,  .3094D-03,  .8521D-01,
     +   .4653D+00,  .1327D-01,  .2750D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=9,16)/
     +   .2998D+00, -.5624D-01, -.2201D-02,  .3175D-03,  .7773D-01,
     +   .4678D+00,  .1779D-01,  .2785D+00,
     +   .2814D+00, -.5198D-01, -.1926D-02,  .3273D-03,  .6560D-01,
     +   .4721D+00,  .2543D-01,  .2845D+00,
     +   .2657D+00, -.4842D-01, -.1708D-02,  .3304D-03,  .5643D-01,
     +   .4753D+00,  .3168D-01,  .2893D+00,
     +   .2526D+00, -.4552D-01, -.1540D-02,  .3296D-03,  .4960D-01,
     +   .4782D+00,  .3669D-01,  .2932D+00,
     +   .2421D+00, -.4321D-01, -.1412D-02,  .3269D-03,  .4455D-01,
     +   .4807D+00,  .4067D-01,  .2965D+00,
     +   .2302D+00, -.4065D-01, -.1277D-02,  .3220D-03,  .3936D-01,
     +   .4832D+00,  .4503D-01,  .3000D+00,
     +   .2204D+00, -.3858D-01, -.1171D-02,  .3164D-03,  .3545D-01,
     +   .4853D+00,  .4853D-01,  .3028D+00,
     +   .2115D+00, -.3671D-01, -.1079D-02,  .3101D-03,  .3215D-01,
     +   .4871D+00,  .5171D-01,  .3054D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=17,25)/
     +   .2037D+00, -.3511D-01, -.1003D-02,  .3038D-03,  .2948D-01,
     +   .4888D+00,  .5448D-01,  .3076D+00,
     +   .1944D+00, -.3320D-01, -.9159D-03,  .2951D-03,  .2650D-01,
     +   .4908D+00,  .5779D-01,  .3103D+00,
     +   .1861D+00, -.3152D-01, -.8421D-03,  .2866D-03,  .2405D-01,
     +   .4925D+00,  .6075D-01,  .3128D+00,
     +   .1782D+00, -.2995D-01, -.7758D-03,  .2779D-03,  .2191D-01,
     +   .4942D+00,  .6354D-01,  .3151D+00,
     +   .1716D+00, -.2865D-01, -.7223D-03,  .2701D-03,  .2022D-01,
     +   .4957D+00,  .6592D-01,  .3171D+00,
     +   .1650D+00, -.2737D-01, -.6711D-03,  .2620D-03,  .1865D-01,
     +   .4972D+00,  .6829D-01,  .3190D+00,
     +   .1591D+00, -.2622D-01, -.6266D-03,  .2543D-03,  .1730D-01,
     +   .4985D+00,  .7045D-01,  .3208D+00,
     +   .1534D+00, -.2512D-01, -.5855D-03,  .2467D-03,  .1608D-01,
     +   .4998D+00,  .7253D-01,  .3225D+00,
     +   .1485D+00, -.2420D-01, -.5516D-03,  .2401D-03,  .1509D-01,
     +   .5009D+00,  .7435D-01,  .3241D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=1,8)/
     +   .4301D+00, -.8516D-01, -.4026D-02,  .1786D-04,  .1947D+00,
     +   .4440D+00, -.4489D-01,  .2391D+00,
     +   .3985D+00, -.7712D-01, -.3446D-02,  .5168D-04,  .1574D+00,
     +   .4543D+00, -.2353D-01,  .2543D+00,
     +   .3773D+00, -.7189D-01, -.3081D-02,  .7790D-04,  .1352D+00,
     +   .4603D+00, -.1095D-01,  .2632D+00,
     +   .3555D+00, -.6664D-01, -.2727D-02,  .1050D-03,  .1147D+00,
     +   .4658D+00,  .8267D-03,  .2715D+00,
     +   .3323D+00, -.6121D-01, -.2376D-02,  .1318D-03,  .9541D-01,
     +   .4712D+00,  .1227D-01,  .2797D+00,
     +   .3171D+00, -.5774D-01, -.2161D-02,  .1473D-03,  .8409D-01,
     +   .4744D+00,  .1924D-01,  .2846D+00,
     +   .3061D+00, -.5527D-01, -.2013D-02,  .1573D-03,  .7653D-01,
     +   .4768D+00,  .2408D-01,  .2881D+00,
     +   .2908D+00, -.5188D-01, -.1816D-02,  .1692D-03,  .6684D-01,
     +   .4800D+00,  .3056D-01,  .2929D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=9,16)/
     +   .2803D+00, -.4958D-01, -.1687D-02,  .1763D-03,  .6069D-01,
     +   .4823D+00,  .3482D-01,  .2961D+00,
     +   .2616D+00, -.4558D-01, -.1471D-02,  .1858D-03,  .5082D-01,
     +   .4860D+00,  .4206D-01,  .3015D+00,
     +   .2457D+00, -.4225D-01, -.1301D-02,  .1904D-03,  .4344D-01,
     +   .4891D+00,  .4801D-01,  .3060D+00,
     +   .2326D+00, -.3955D-01, -.1170D-02,  .1920D-03,  .3800D-01,
     +   .4916D+00,  .5282D-01,  .3096D+00,
     +   .2221D+00, -.3742D-01, -.1071D-02,  .1918D-03,  .3401D-01,
     +   .4937D+00,  .5665D-01,  .3125D+00,
     +   .2103D+00, -.3507D-01, -.9649D-03,  .1904D-03,  .2993D-01,
     +   .4960D+00,  .6086D-01,  .3158D+00,
     +   .2007D+00, -.3317D-01, -.8828D-03,  .1882D-03,  .2688D-01,
     +   .4979D+00,  .6425D-01,  .3184D+00,
     +   .1919D+00, -.3146D-01, -.8119D-03,  .1853D-03,  .2432D-01,
     +   .4996D+00,  .6734D-01,  .3208D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=17,25)/
     +   .1843D+00, -.3000D-01, -.7529D-03,  .1822D-03,  .2225D-01,
     +   .5010D+00,  .7003D-01,  .3229D+00,
     +   .1752D+00, -.2827D-01, -.6855D-03,  .1777D-03,  .1996D-01,
     +   .5029D+00,  .7329D-01,  .3255D+00,
     +   .1671D+00, -.2675D-01, -.6286D-03,  .1731D-03,  .1808D-01,
     +   .5045D+00,  .7617D-01,  .3278D+00,
     +   .1596D+00, -.2535D-01, -.5776D-03,  .1684D-03,  .1644D-01,
     +   .5061D+00,  .7892D-01,  .3300D+00,
     +   .1532D+00, -.2418D-01, -.5365D-03,  .1640D-03,  .1516D-01,
     +   .5075D+00,  .8125D-01,  .3319D+00,
     +   .1469D+00, -.2303D-01, -.4973D-03,  .1595D-03,  .1395D-01,
     +   .5088D+00,  .8358D-01,  .3337D+00,
     +   .1413D+00, -.2201D-01, -.4632D-03,  .1551D-03,  .1293D-01,
     +   .5100D+00,  .8572D-01,  .3354D+00,
     +   .1358D+00, -.2104D-01, -.4318D-03,  .1507D-03,  .1201D-01,
     +   .5112D+00,  .8778D-01,  .3370D+00,
     +   .1312D+00, -.2022D-01, -.4060D-03,  .1468D-03,  .1126D-01,
     +   .5122D+00,  .8954D-01,  .3384D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=1,8)/
     +   .3934D+00, -.6880D-01, -.2288D-02, -.2667D-04,  .1284D+00,
     +   .4820D+00,  .4042D-02,  .2861D+00,
     +   .3589D+00, -.6142D-01, -.1958D-02, -.3068D-04,  .1007D+00,
     +   .4880D+00,  .2093D-01,  .2966D+00,
     +   .3362D+00, -.5670D-01, -.1746D-02, -.2417D-04,  .8480D-01,
     +   .4919D+00,  .3111D-01,  .3031D+00,
     +   .3132D+00, -.5202D-01, -.1540D-02, -.1321D-04,  .7056D-01,
     +   .4959D+00,  .4081D-01,  .3094D+00,
     +   .2892D+00, -.4723D-01, -.1335D-02,  .6401D-06,  .5755D-01,
     +   .4995D+00,  .5043D-01,  .3156D+00,
     +   .2737D+00, -.4421D-01, -.1210D-02,  .9966D-05,  .5012D-01,
     +   .5020D+00,  .5639D-01,  .3196D+00,
     +   .2625D+00, -.4207D-01, -.1123D-02,  .1655D-04,  .4524D-01,
     +   .5039D+00,  .6058D-01,  .3224D+00,
     +   .2472D+00, -.3916D-01, -.1008D-02,  .2522D-04,  .3908D-01,
     +   .5062D+00,  .6625D-01,  .3262D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=9,16)/
     +   .2368D+00, -.3721D-01, -.9328D-03,  .3075D-04,  .3524D-01,
     +   .5078D+00,  .7002D-01,  .3288D+00,
     +   .2185D+00, -.3384D-01, -.8078D-03,  .3928D-04,  .2917D-01,
     +   .5108D+00,  .7648D-01,  .3333D+00,
     +   .2031D+00, -.3107D-01, -.7098D-03,  .4513D-04,  .2471D-01,
     +   .5132D+00,  .8190D-01,  .3371D+00,
     +   .1907D+00, -.2885D-01, -.6345D-03,  .4896D-04,  .2147D-01,
     +   .5153D+00,  .8631D-01,  .3402D+00,
     +   .1807D+00, -.2710D-01, -.5773D-03,  .5141D-04,  .1913D-01,
     +   .5170D+00,  .8982D-01,  .3427D+00,
     +   .1697D+00, -.2520D-01, -.5170D-03,  .5351D-04,  .1675D-01,
     +   .5188D+00,  .9377D-01,  .3455D+00,
     +   .1608D+00, -.2368D-01, -.4704D-03,  .5471D-04,  .1499D-01,
     +   .5203D+00,  .9694D-01,  .3478D+00,
     +   .1527D+00, -.2232D-01, -.4303D-03,  .5538D-04,  .1352D-01,
     +   .5218D+00,  .9985D-01,  .3499D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=17,25)/
     +   .1458D+00, -.2116D-01, -.3970D-03,  .5563D-04,  .1234D-01,
     +   .5231D+00,  .1024D+00,  .3518D+00,
     +   .1376D+00, -.1980D-01, -.3592D-03,  .5556D-04,  .1103D-01,
     +   .5246D+00,  .1055D+00,  .3540D+00,
     +   .1304D+00, -.1862D-01, -.3274D-03,  .5519D-04,  .9972D-02,
     +   .5260D+00,  .1083D+00,  .3561D+00,
     +   .1237D+00, -.1753D-01, -.2990D-03,  .5456D-04,  .9049D-02,
     +   .5273D+00,  .1109D+00,  .3580D+00,
     +   .1181D+00, -.1663D-01, -.2763D-03,  .5385D-04,  .8327D-02,
     +   .5285D+00,  .1131D+00,  .3596D+00,
     +   .1126D+00, -.1576D-01, -.2547D-03,  .5299D-04,  .7654D-02,
     +   .5295D+00,  .1154D+00,  .3613D+00,
     +   .1077D+00, -.1498D-01, -.2360D-03,  .5207D-04,  .7083D-02,
     +   .5306D+00,  .1174D+00,  .3627D+00,
     +   .1030D+00, -.1424D-01, -.2189D-03,  .5109D-04,  .6567D-02,
     +   .5316D+00,  .1194D+00,  .3642D+00,
     +   .9906D-01, -.1363D-01, -.2048D-03,  .5016D-04,  .6149D-02,
     +   .5325D+00,  .1211D+00,  .3655D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=1,8)/
     +   .3431D+00, -.5292D-01, -.1197D-02, -.3311D-04,  .7655D-01,
     +   .5117D+00,  .5193D-01,  .3263D+00,
     +   .3083D+00, -.4658D-01, -.1023D-02, -.4609D-04,  .5857D-01,
     +   .5155D+00,  .6504D-01,  .3337D+00,
     +   .2857D+00, -.4257D-01, -.9103D-03, -.4598D-04,  .4861D-01,
     +   .5181D+00,  .7318D-01,  .3384D+00,
     +   .2632D+00, -.3865D-01, -.7994D-03, -.4140D-04,  .3989D-01,
     +   .5206D+00,  .8113D-01,  .3431D+00,
     +   .2400D+00, -.3469D-01, -.6887D-03, -.3369D-04,  .3210D-01,
     +   .5231D+00,  .8919D-01,  .3479D+00,
     +   .2252D+00, -.3221D-01, -.6208D-03, -.2786D-04,  .2775D-01,
     +   .5252D+00,  .9429D-01,  .3511D+00,
     +   .2148D+00, -.3048D-01, -.5740D-03, -.2349D-04,  .2492D-01,
     +   .5265D+00,  .9793D-01,  .3534D+00,
     +   .2004D+00, -.2814D-01, -.5122D-03, -.1743D-04,  .2140D-01,
     +   .5284D+00,  .1029D+00,  .3565D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=9,16)/
     +   .1908D+00, -.2657D-01, -.4720D-03, -.1343D-04,  .1922D-01,
     +   .5297D+00,  .1062D+00,  .3587D+00,
     +   .1740D+00, -.2390D-01, -.4054D-03, -.6937D-05,  .1581D-01,
     +   .5320D+00,  .1120D+00,  .3624D+00,
     +   .1601D+00, -.2174D-01, -.3534D-03, -.1958D-05,  .1334D-01,
     +   .5340D+00,  .1169D+00,  .3656D+00,
     +   .1490D+00, -.2002D-01, -.3137D-03,  .1707D-05,  .1157D-01,
     +   .5357D+00,  .1210D+00,  .3683D+00,
     +   .1402D+00, -.1868D-01, -.2836D-03,  .4352D-05,  .1028D-01,
     +   .5370D+00,  .1242D+00,  .3705D+00,
     +   .1306D+00, -.1723D-01, -.2521D-03,  .6977D-05,  .8988D-02,
     +   .5387D+00,  .1279D+00,  .3729D+00,
     +   .1228D+00, -.1608D-01, -.2279D-03,  .8839D-05,  .8031D-02,
     +   .5399D+00,  .1309D+00,  .3749D+00,
     +   .1159D+00, -.1506D-01, -.2072D-03,  .1030D-04,  .7236D-02,
     +   .5411D+00,  .1336D+00,  .3767D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=17,25)/
     +   .1100D+00, -.1420D-01, -.1901D-03,  .1140D-04,  .6598D-02,
     +   .5421D+00,  .1360D+00,  .3784D+00,
     +   .1030D+00, -.1319D-01, -.1707D-03,  .1251D-04,  .5895D-02,
     +   .5435D+00,  .1389D+00,  .3804D+00,
     +   .9699D-01, -.1232D-01, -.1545D-03,  .1331D-04,  .5322D-02,
     +   .5446D+00,  .1415D+00,  .3821D+00,
     +   .9140D-01, -.1153D-01, -.1402D-03,  .1390D-04,  .4825D-02,
     +   .5457D+00,  .1440D+00,  .3838D+00,
     +   .8678D-01, -.1088D-01, -.1287D-03,  .1429D-04,  .4435D-02,
     +   .5467D+00,  .1462D+00,  .3853D+00,
     +   .8226D-01, -.1025D-01, -.1179D-03,  .1458D-04,  .4072D-02,
     +   .5476D+00,  .1482D+00,  .3867D+00,
     +   .7823D-01, -.9691D-02, -.1086D-03,  .1476D-04,  .3764D-02,
     +   .5485D+00,  .1502D+00,  .3880D+00,
     +   .7444D-01, -.9170D-02, -.1001D-03,  .1485D-04,  .3485D-02,
     +   .5495D+00,  .1521D+00,  .3894D+00,
     +   .7125D-01, -.8734D-02, -.9319D-04,  .1488D-04,  .3260D-02,
     +   .5501D+00,  .1538D+00,  .3905D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=1,8)/
     +   .2845D+00, -.3856D-01, -.5694D-03, -.2464D-04,  .4097D-01,
     +   .5359D+00,  .9797D-01,  .3611D+00,
     +   .2517D+00, -.3346D-01, -.4856D-03, -.3536D-04,  .3087D-01,
     +   .5383D+00,  .1082D+00,  .3663D+00,
     +   .2308D+00, -.3027D-01, -.4304D-03, -.3638D-04,  .2540D-01,
     +   .5397D+00,  .1148D+00,  .3697D+00,
     +   .2102D+00, -.2719D-01, -.3759D-03, -.3427D-04,  .2070D-01,
     +   .5416D+00,  .1214D+00,  .3734D+00,
     +   .1893D+00, -.2411D-01, -.3214D-03, -.2994D-04,  .1658D-01,
     +   .5436D+00,  .1282D+00,  .3772D+00,
     +   .1761D+00, -.2221D-01, -.2881D-03, -.2646D-04,  .1430D-01,
     +   .5451D+00,  .1326D+00,  .3798D+00,
     +   .1669D+00, -.2089D-01, -.2651D-03, -.2379D-04,  .1282D-01,
     +   .5461D+00,  .1358D+00,  .3816D+00,
     +   .1543D+00, -.1912D-01, -.2349D-03, -.2000D-04,  .1100D-01,
     +   .5476D+00,  .1402D+00,  .3843D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=9,16)/
     +   .1460D+00, -.1795D-01, -.2154D-03, -.1751D-04,  .9877D-02,
     +   .5486D+00,  .1432D+00,  .3861D+00,
     +   .1316D+00, -.1597D-01, -.1833D-03, -.1339D-04,  .8127D-02,
     +   .5506D+00,  .1484D+00,  .3892D+00,
     +   .1198D+00, -.1438D-01, -.1584D-03, -.1010D-04,  .6861D-02,
     +   .5522D+00,  .1529D+00,  .3920D+00,
     +   .1105D+00, -.1313D-01, -.1395D-03, -.7581D-05,  .5950D-02,
     +   .5536D+00,  .1566D+00,  .3943D+00,
     +   .1032D+00, -.1216D-01, -.1252D-03, -.5705D-05,  .5293D-02,
     +   .5548D+00,  .1596D+00,  .3962D+00,
     +   .9531D-01, -.1113D-01, -.1104D-03, -.3784D-05,  .4629D-02,
     +   .5561D+00,  .1630D+00,  .3983D+00,
     +   .8901D-01, -.1031D-01, -.9906D-04, -.2378D-05,  .4136D-02,
     +   .5572D+00,  .1658D+00,  .4001D+00,
     +   .8343D-01, -.9595D-02, -.8941D-04, -.1219D-05,  .3727D-02,
     +   .5582D+00,  .1684D+00,  .4017D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=17,25)/
     +   .7870D-01, -.8992D-02, -.8149D-04, -.3004D-06,  .3398D-02,
     +   .5591D+00,  .1705D+00,  .4030D+00,
     +   .7316D-01, -.8294D-02, -.7258D-04,  .6805D-06,  .3034D-02,
     +   .5603D+00,  .1733D+00,  .4048D+00,
     +   .6839D-01, -.7697D-02, -.6519D-04,  .1446D-05,  .2737D-02,
     +   .5612D+00,  .1758D+00,  .4064D+00,
     +   .6401D-01, -.7155D-02, -.5867D-04,  .2074D-05,  .2479D-02,
     +   .5622D+00,  .1781D+00,  .4079D+00,
     +   .6042D-01, -.6714D-02, -.5351D-04,  .2542D-05,  .2276D-02,
     +   .5629D+00,  .1802D+00,  .4091D+00,
     +   .5693D-01, -.6288D-02, -.4866D-04,  .2948D-05,  .2087D-02,
     +   .5638D+00,  .1822D+00,  .4104D+00,
     +   .5385D-01, -.5915D-02, -.4451D-04,  .3263D-05,  .1926D-02,
     +   .5646D+00,  .1840D+00,  .4116D+00,
     +   .5096D-01, -.5567D-02, -.4075D-04,  .3524D-05,  .1780D-02,
     +   .5651D+00,  .1858D+00,  .4127D+00,
     +   .4854D-01, -.5278D-02, -.3770D-04,  .3710D-05,  .1662D-02,
     +   .5657D+00,  .1874D+00,  .4136D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=1,8)/
     +   .2230D+00, -.2642D-01, -.2417D-03, -.1416D-04,  .1949D-01,
     +   .5556D+00,  .1424D+00,  .3914D+00,
     +   .1941D+00, -.2257D-01, -.2054D-03, -.2042D-04,  .1465D-01,
     +   .5571D+00,  .1506D+00,  .3953D+00,
     +   .1761D+00, -.2021D-01, -.1812D-03, -.2113D-04,  .1207D-01,
     +   .5583D+00,  .1561D+00,  .3980D+00,
     +   .1585D+00, -.1795D-01, -.1572D-03, -.2008D-04,  .9865D-02,
     +   .5598D+00,  .1617D+00,  .4009D+00,
     +   .1408D+00, -.1573D-01, -.1332D-03, -.1780D-04,  .7938D-02,
     +   .5614D+00,  .1676D+00,  .4041D+00,
     +   .1299D+00, -.1437D-01, -.1186D-03, -.1593D-04,  .6872D-02,
     +   .5625D+00,  .1714D+00,  .4062D+00,
     +   .1223D+00, -.1343D-01, -.1086D-03, -.1450D-04,  .6183D-02,
     +   .5634D+00,  .1743D+00,  .4078D+00,
     +   .1121D+00, -.1218D-01, -.9543D-04, -.1245D-04,  .5327D-02,
     +   .5646D+00,  .1782D+00,  .4099D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=9,16)/
     +   .1053D+00, -.1136D-01, -.8701D-04, -.1112D-04,  .4797D-02,
     +   .5655D+00,  .1809D+00,  .4115D+00,
     +   .9375D-01, -.9990D-02, -.7330D-04, -.8959D-05,  .3966D-02,
     +   .5671D+00,  .1857D+00,  .4143D+00,
     +   .8447D-01, -.8902D-02, -.6271D-04, -.7180D-05,  .3361D-02,
     +   .5685D+00,  .1897D+00,  .4166D+00,
     +   .7718D-01, -.8057D-02, -.5471D-04, -.5797D-05,  .2922D-02,
     +   .5696D+00,  .1932D+00,  .4186D+00,
     +   .7154D-01, -.7409D-02, -.4873D-04, -.4757D-05,  .2603D-02,
     +   .5706D+00,  .1959D+00,  .4202D+00,
     +   .6546D-01, -.6719D-02, -.4254D-04, -.3684D-05,  .2279D-02,
     +   .5717D+00,  .1990D+00,  .4220D+00,
     +   .6067D-01, -.6181D-02, -.3786D-04, -.2898D-05,  .2037D-02,
     +   .5727D+00,  .2017D+00,  .4236D+00,
     +   .5647D-01, -.5713D-02, -.3390D-04, -.2239D-05,  .1834D-02,
     +   .5735D+00,  .2042D+00,  .4250D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=17,25)/
     +   .5293D-01, -.5321D-02, -.3066D-04, -.1711D-05,  .1671D-02,
     +   .5742D+00,  .2062D+00,  .4262D+00,
     +   .4882D-01, -.4871D-02, -.2705D-04, -.1138D-05,  .1490D-02,
     +   .5752D+00,  .2088D+00,  .4278D+00,
     +   .4530D-01, -.4489D-02, -.2408D-04, -.6809D-06,  .1342D-02,
     +   .5760D+00,  .2111D+00,  .4291D+00,
     +   .4211D-01, -.4145D-02, -.2147D-04, -.3046D-06,  .1213D-02,
     +   .5768D+00,  .2133D+00,  .4304D+00,
     +   .3950D-01, -.3866D-02, -.1943D-04, -.1476D-07,  .1112D-02,
     +   .5776D+00,  .2152D+00,  .4316D+00,
     +   .3699D-01, -.3599D-02, -.1752D-04,  .2444D-06,  .1017D-02,
     +   .5780D+00,  .2171D+00,  .4325D+00,
     +   .3479D-01, -.3367D-02, -.1589D-04,  .4445D-06,  .9359D-03,
     +   .5789D+00,  .2188D+00,  .4337D+00,
     +   .3273D-01, -.3151D-02, -.1444D-04,  .6177D-06,  .8627D-03,
     +   .5793D+00,  .2205D+00,  .4346D+00,
     +   .3103D-01, -.2973D-02, -.1326D-04,  .7472D-06,  .8034D-03,
     +   .5800D+00,  .2220D+00,  .4356D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=1,8)/
     +   .1636D+00, -.1680D-01, -.8912D-04, -.6627D-05,  .8112D-02,
     +   .5724D+00,  .1862D+00,  .4186D+00,
     +   .1401D+00, -.1413D-01, -.7540D-04, -.9514D-05,  .6223D-02,
     +   .5737D+00,  .1931D+00,  .4218D+00,
     +   .1256D+00, -.1251D-01, -.6613D-04, -.9826D-05,  .5205D-02,
     +   .5747D+00,  .1977D+00,  .4241D+00,
     +   .1116D+00, -.1098D-01, -.5693D-04, -.9328D-05,  .4323D-02,
     +   .5758D+00,  .2025D+00,  .4264D+00,
     +   .9785D-01, -.9491D-02, -.4775D-04, -.8262D-05,  .3536D-02,
     +   .5772D+00,  .2078D+00,  .4292D+00,
     +   .8942D-01, -.8593D-02, -.4218D-04, -.7397D-05,  .3092D-02,
     +   .5781D+00,  .2113D+00,  .4309D+00,
     +   .8359D-01, -.7978D-02, -.3836D-04, -.6736D-05,  .2801D-02,
     +   .5789D+00,  .2137D+00,  .4323D+00,
     +   .7585D-01, -.7169D-02, -.3339D-04, -.5787D-05,  .2433D-02,
     +   .5799D+00,  .2173D+00,  .4342D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=9,16)/
     +   .7075D-01, -.6643D-02, -.3025D-04, -.5199D-05,  .2202D-02,
     +   .5807D+00,  .2198D+00,  .4355D+00,
     +   .6220D-01, -.5768D-02, -.2521D-04, -.4261D-05,  .1833D-02,
     +   .5820D+00,  .2241D+00,  .4378D+00,
     +   .5541D-01, -.5084D-02, -.2132D-04, -.3463D-05,  .1560D-02,
     +   .5832D+00,  .2278D+00,  .4399D+00,
     +   .5014D-01, -.4558D-02, -.1840D-04, -.2840D-05,  .1359D-02,
     +   .5841D+00,  .2310D+00,  .4416D+00,
     +   .4609D-01, -.4158D-02, -.1624D-04, -.2369D-05,  .1211D-02,
     +   .5848D+00,  .2336D+00,  .4429D+00,
     +   .4178D-01, -.3737D-02, -.1402D-04, -.1883D-05,  .1060D-02,
     +   .5858D+00,  .2365D+00,  .4446D+00,
     +   .3841D-01, -.3411D-02, -.1236D-04, -.1530D-05,  .9459D-03,
     +   .5865D+00,  .2389D+00,  .4459D+00,
     +   .3548D-01, -.3130D-02, -.1096D-04, -.1233D-05,  .8505D-03,
     +   .5873D+00,  .2411D+00,  .4471D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=17,25)/
     +   .3303D-01, -.2896D-02, -.9819D-05, -.9918D-06,  .7731D-03,
     +   .5879D+00,  .2431D+00,  .4482D+00,
     +   .3021D-01, -.2630D-02, -.8563D-05, -.7308D-06,  .6871D-03,
     +   .5889D+00,  .2455D+00,  .4496D+00,
     +   .2782D-01, -.2405D-02, -.7539D-05, -.5235D-06,  .6167D-03,
     +   .5894D+00,  .2476D+00,  .4507D+00,
     +   .2567D-01, -.2205D-02, -.6651D-05, -.3553D-06,  .5551D-03,
     +   .5899D+00,  .2497D+00,  .4517D+00,
     +   .2393D-01, -.2044D-02, -.5958D-05, -.2217D-06,  .5067D-03,
     +   .5905D+00,  .2515D+00,  .4527D+00,
     +   .2226D-01, -.1891D-02, -.5317D-05, -.1021D-06,  .4615D-03,
     +   .5912D+00,  .2533D+00,  .4538D+00,
     +   .2080D-01, -.1758D-02, -.4777D-05, -.1303D-07,  .4231D-03,
     +   .5918D+00,  .2549D+00,  .4546D+00,
     +   .1946D-01, -.1636D-02, -.4300D-05,  .6580D-07,  .3885D-03,
     +   .5923D+00,  .2565D+00,  .4555D+00,
     +   .1835D-01, -.1535D-02, -.3915D-05,  .1232D-06,  .3604D-03,
     +   .5927D+00,  .2579D+00,  .4563D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=1,8)/
     +   .1107D+00, -.9730D-02, -.2743D-04, -.2534D-05,  .2907D-02,
     +   .5874D+00,  .2304D+00,  .4440D+00,
     +   .9309D-01, -.8040D-02, -.2308D-04, -.3612D-05,  .2363D-02,
     +   .5886D+00,  .2364D+00,  .4468D+00,
     +   .8239D-01, -.7033D-02, -.2010D-04, -.3710D-05,  .2044D-02,
     +   .5895D+00,  .2405D+00,  .4486D+00,
     +   .7226D-01, -.6093D-02, -.1714D-04, -.3502D-05,  .1749D-02,
     +   .5904D+00,  .2448D+00,  .4507D+00,
     +   .6241D-01, -.5193D-02, -.1419D-04, -.3079D-05,  .1468D-02,
     +   .5916D+00,  .2494D+00,  .4530D+00,
     +   .5646D-01, -.4656D-02, -.1242D-04, -.2738D-05,  .1301D-02,
     +   .5924D+00,  .2525D+00,  .4544D+00,
     +   .5239D-01, -.4291D-02, -.1120D-04, -.2484D-05,  .1188D-02,
     +   .5931D+00,  .2549D+00,  .4557D+00,
     +   .4703D-01, -.3817D-02, -.9627D-05, -.2112D-05,  .1042D-02,
     +   .5940D+00,  .2581D+00,  .4573D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=9,16)/
     +   .4354D-01, -.3510D-02, -.8659D-05, -.1900D-05,  .9466D-03,
     +   .5946D+00,  .2603D+00,  .4585D+00,
     +   .3775D-01, -.3008D-02, -.7124D-05, -.1570D-05,  .7916D-03,
     +   .5955D+00,  .2643D+00,  .4604D+00,
     +   .3321D-01, -.2619D-02, -.5941D-05, -.1277D-05,  .6741D-03,
     +   .5966D+00,  .2677D+00,  .4622D+00,
     +   .2973D-01, -.2324D-02, -.5059D-05, -.1043D-05,  .5865D-03,
     +   .5974D+00,  .2707D+00,  .4637D+00,
     +   .2709D-01, -.2102D-02, -.4409D-05, -.8692D-06,  .5216D-03,
     +   .5982D+00,  .2731D+00,  .4650D+00,
     +   .2430D-01, -.1870D-02, -.3748D-05, -.6856D-06,  .4546D-03,
     +   .5989D+00,  .2758D+00,  .4663D+00,
     +   .2215D-01, -.1693D-02, -.3267D-05, -.5592D-06,  .4041D-03,
     +   .5996D+00,  .2780D+00,  .4674D+00,
     +   .2030D-01, -.1541D-02, -.2860D-05, -.4524D-06,  .3616D-03,
     +   .6001D+00,  .2800D+00,  .4684D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=17,25)/
     +   .1876D-01, -.1416D-02, -.2530D-05, -.3595D-06,  .3272D-03,
     +   .6006D+00,  .2818D+00,  .4693D+00,
     +   .1700D-01, -.1274D-02, -.2172D-05, -.2655D-06,  .2890D-03,
     +   .6012D+00,  .2840D+00,  .4705D+00,
     +   .1553D-01, -.1156D-02, -.1886D-05, -.1885D-06,  .2577D-03,
     +   .6018D+00,  .2860D+00,  .4715D+00,
     +   .1421D-01, -.1051D-02, -.1640D-05, -.1326D-06,  .2305D-03,
     +   .6024D+00,  .2879D+00,  .4725D+00,
     +   .1315D-01, -.9679D-03, -.1450D-05, -.8929D-07,  .2092D-03,
     +   .6029D+00,  .2896D+00,  .4733D+00,
     +   .1215D-01, -.8891D-03, -.1278D-05, -.4544D-07,  .1894D-03,
     +   .6034D+00,  .2913D+00,  .4742D+00,
     +   .1128D-01, -.8212D-03, -.1134D-05, -.1686D-07,  .1727D-03,
     +   .6038D+00,  .2928D+00,  .4749D+00,
     +   .1048D-01, -.7593D-03, -.1011D-05,  .1059D-07,  .1576D-03,
     +   .6042D+00,  .2943D+00,  .4757D+00,
     +   .9821D-02, -.7088D-03, -.9131D-06,  .2619D-07,  .1454D-03,
     +   .6045D+00,  .2955D+00,  .4763D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=1,8)/
     +   .6739D-01, -.4977D-02, -.6564D-05, -.7717D-06,  .8869D-03,
     +   .6013D+00,  .2766D+00,  .4684D+00,
     +   .5552D-01, -.4033D-02, -.5471D-05, -.1086D-05,  .8055D-03,
     +   .6024D+00,  .2819D+00,  .4708D+00,
     +   .4845D-01, -.3480D-02, -.4715D-05, -.1104D-05,  .7334D-03,
     +   .6033D+00,  .2857D+00,  .4725D+00,
     +   .4186D-01, -.2972D-02, -.3965D-05, -.1026D-05,  .6515D-03,
     +   .6041D+00,  .2895D+00,  .4743D+00,
     +   .3556D-01, -.2492D-02, -.3217D-05, -.8851D-06,  .5615D-03,
     +   .6051D+00,  .2937D+00,  .4762D+00,
     +   .3182D-01, -.2210D-02, -.2770D-05, -.7730D-06,  .5032D-03,
     +   .6057D+00,  .2965D+00,  .4775D+00,
     +   .2927D-01, -.2021D-02, -.2462D-05, -.6938D-06,  .4620D-03,
     +   .6061D+00,  .2986D+00,  .4784D+00,
     +   .2597D-01, -.1777D-02, -.2066D-05, -.5691D-06,  .4068D-03,
     +   .6069D+00,  .3015D+00,  .4798D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=9,16)/
     +   .2384D-01, -.1621D-02, -.1839D-05, -.5110D-06,  .3700D-03,
     +   .6076D+00,  .3035D+00,  .4809D+00,
     +   .2035D-01, -.1368D-02, -.1484D-05, -.4250D-06,  .3086D-03,
     +   .6083D+00,  .3071D+00,  .4825D+00,
     +   .1766D-01, -.1175D-02, -.1206D-05, -.3334D-06,  .2614D-03,
     +   .6092D+00,  .3103D+00,  .4840D+00,
     +   .1562D-01, -.1031D-02, -.9983D-06, -.2625D-06,  .2260D-03,
     +   .6098D+00,  .3129D+00,  .4852D+00,
     +   .1409D-01, -.9234D-03, -.8507D-06, -.2105D-06,  .1997D-03,
     +   .6104D+00,  .3151D+00,  .4863D+00,
     +   .1250D-01, -.8124D-03, -.6994D-06, -.1505D-06,  .1726D-03,
     +   .6110D+00,  .3176D+00,  .4874D+00,
     +   .1128D-01, -.7284D-03, -.5982D-06, -.1228D-06,  .1522D-03,
     +   .6115D+00,  .3196D+00,  .4884D+00,
     +   .1024D-01, -.6571D-03, -.5107D-06, -.8905D-07,  .1351D-03,
     +   .6119D+00,  .3214D+00,  .4892D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=17,25)/
     +   .9390D-02, -.5990D-03, -.4383D-06, -.6476D-07,  .1213D-03,
     +   .6125D+00,  .3232D+00,  .4901D+00,
     +   .8425D-02, -.5338D-03, -.3655D-06, -.3677D-07,  .1061D-03,
     +   .6130D+00,  .3252D+00,  .4910D+00,
     +   .7623D-02, -.4799D-03, -.3106D-06, -.1564D-07,  .9372D-04,
     +   .6134D+00,  .3270D+00,  .4919D+00,
     +   .6912D-02, -.4326D-03, -.2654D-06, -.4674D-08,  .8303D-04,
     +   .6138D+00,  .3288D+00,  .4927D+00,
     +   .6348D-02, -.3953D-03, -.2297D-06,  .3714D-08,  .7482D-04,
     +   .6142D+00,  .3303D+00,  .4934D+00,
     +   .5816D-02, -.3602D-03, -.1988D-06,  .1817D-07,  .6712D-04,
     +   .6147D+00,  .3317D+00,  .4941D+00,
     +   .5359D-02, -.3303D-03, -.1763D-06,  .1675D-07,  .6070D-04,
     +   .6151D+00,  .3331D+00,  .4948D+00,
     +   .4943D-02, -.3032D-03, -.1609D-06,  .2295D-07,  .5495D-04,
     +   .6154D+00,  .3344D+00,  .4954D+00,
     +   .4604D-02, -.2813D-03, -.1454D-06,  .2301D-07,  .5041D-04,
     +   .6156D+00,  .3356D+00,  .4959D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=1,8)/
     +   .3534D-01, -.2134D-02, -.1006D-05, -.1682D-06,  .2300D-03,
     +   .6147D+00,  .3265D+00,  .4927D+00,
     +   .2845D-01, -.1691D-02, -.7933D-06, -.2233D-06,  .2455D-03,
     +   .6154D+00,  .3313D+00,  .4946D+00,
     +   .2443D-01, -.1436D-02, -.6565D-06, -.2128D-06,  .2356D-03,
     +   .6163D+00,  .3345D+00,  .4961D+00,
     +   .2074D-01, -.1206D-02, -.5195D-06, -.1845D-06,  .2157D-03,
     +   .6171D+00,  .3380D+00,  .4977D+00,
     +   .1729D-01, -.9924D-03, -.3823D-06, -.1434D-06,  .1886D-03,
     +   .6175D+00,  .3417D+00,  .4991D+00,
     +   .1527D-01, -.8691D-03, -.3060D-06, -.1105D-06,  .1695D-03,
     +   .6183D+00,  .3442D+00,  .5003D+00,
     +   .1391D-01, -.7872D-03, -.2488D-06, -.9310D-07,  .1555D-03,
     +   .6187D+00,  .3461D+00,  .5011D+00,
     +   .1217D-01, -.6828D-03, -.1804D-06, -.5556D-07,  .1365D-03,
     +   .6193D+00,  .3487D+00,  .5022D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=9,16)/
     +   .1106D-01, -.6169D-03, -.1490D-06, -.4699D-07,  .1234D-03,
     +   .6197D+00,  .3505D+00,  .5030D+00,
     +   .9276D-02, -.5116D-03, -.1001D-06, -.3321D-07,  .1019D-03,
     +   .6205D+00,  .3536D+00,  .5044D+00,
     +   .7922D-02, -.4327D-03, -.5880D-07, -.9045D-08,  .8524D-04,
     +   .6211D+00,  .3565D+00,  .5056D+00,
     +   .6913D-02, -.3745D-03, -.3229D-07,  .8308D-08,  .7282D-04,
     +   .6216D+00,  .3589D+00,  .5067D+00,
     +   .6166D-02, -.3318D-03, -.1326D-07,  .1560D-07,  .6366D-04,
     +   .6220D+00,  .3607D+00,  .5075D+00,
     +   .5397D-02, -.2882D-03,  .3764D-08,  .3292D-07,  .5432D-04,
     +   .6225D+00,  .3630D+00,  .5085D+00,
     +   .4817D-02, -.2556D-03,  .5319D-08,  .3721D-07,  .4728D-04,
     +   .6228D+00,  .3647D+00,  .5092D+00,
     +   .4327D-02, -.2283D-03,  .1318D-07,  .3299D-07,  .4151D-04,
     +   .6233D+00,  .3664D+00,  .5100D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=17,25)/
     +   .3928D-02, -.2062D-03,  .1857D-07,  .4261D-07,  .3679D-04,
     +   .6236D+00,  .3679D+00,  .5106D+00,
     +   .3483D-02, -.1816D-03,  .2078D-07,  .4570D-07,  .3171D-04,
     +   .6240D+00,  .3697D+00,  .5114D+00,
     +   .3118D-02, -.1616D-03,  .1767D-07,  .4645D-07,  .2763D-04,
     +   .6243D+00,  .3713D+00,  .5120D+00,
     +   .2798D-02, -.1442D-03,  .1313D-07,  .3904D-07,  .2412D-04,
     +   .6247D+00,  .3729D+00,  .5127D+00,
     +   .2546D-02, -.1306D-03,  .1072D-07,  .3815D-07,  .2146D-04,
     +   .6250D+00,  .3741D+00,  .5133D+00,
     +   .2311D-02, -.1180D-03,  .5438D-08,  .3773D-07,  .1901D-04,
     +   .6254D+00,  .3755D+00,  .5140D+00,
     +   .2111D-02, -.1073D-03,  .2501D-09,  .2838D-07,  .1699D-04,
     +   .6256D+00,  .3767D+00,  .5144D+00,
     +   .1930D-02, -.9770D-04, -.1147D-07,  .2437D-07,  .1523D-04,
     +   .6259D+00,  .3778D+00,  .5149D+00,
     +   .1784D-02, -.8997D-04, -.1563D-07,  .2058D-07,  .1383D-04,
     +   .6261D+00,  .3789D+00,  .5154D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=1,8)/
     +   .1473D-01, -.6954D-03,  .5285D-07, -.2954D-08,  .4845D-04,
     +   .6276D+00,  .3823D+00,  .5173D+00,
     +   .1153D-01, -.5357D-03,  .1084D-06,  .1742D-07,  .6097D-04,
     +   .6283D+00,  .3865D+00,  .5189D+00,
     +   .9701D-02, -.4462D-03,  .1262D-06,  .3536D-07,  .6053D-04,
     +   .6288D+00,  .3892D+00,  .5200D+00,
     +   .8066D-02, -.3670D-03,  .1436D-06,  .5181D-07,  .5603D-04,
     +   .6294D+00,  .3924D+00,  .5213D+00,
     +   .6567D-02, -.2953D-03,  .1561D-06,  .6551D-07,  .4884D-04,
     +   .6300D+00,  .3955D+00,  .5226D+00,
     +   .5708D-02, -.2547D-03,  .1578D-06,  .7476D-07,  .4372D-04,
     +   .6305D+00,  .3976D+00,  .5234D+00,
     +   .5140D-02, -.2281D-03,  .1631D-06,  .7822D-07,  .3991D-04,
     +   .6308D+00,  .3992D+00,  .5241D+00,
     +   .4422D-02, -.1946D-03,  .1634D-06,  .9127D-07,  .3481D-04,
     +   .6311D+00,  .4014D+00,  .5249D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=9,16)/
     +   .3972D-02, -.1738D-03,  .1573D-06,  .9005D-07,  .3126D-04,
     +   .6315D+00,  .4030D+00,  .5256D+00,
     +   .3258D-02, -.1411D-03,  .1440D-06,  .8039D-07,  .2552D-04,
     +   .6321D+00,  .4057D+00,  .5267D+00,
     +   .2728D-02, -.1172D-03,  .1404D-06,  .8583D-07,  .2109D-04,
     +   .6326D+00,  .4081D+00,  .5276D+00,
     +   .2341D-02, -.9982D-04,  .1300D-06,  .8815D-07,  .1776D-04,
     +   .6327D+00,  .4101D+00,  .5283D+00,
     +   .2059D-02, -.8727D-04,  .1246D-06,  .8470D-07,  .1531D-04,
     +   .6331D+00,  .4116D+00,  .5290D+00,
     +   .1773D-02, -.7465D-04,  .1133D-06,  .8830D-07,  .1292D-04,
     +   .6335D+00,  .4135D+00,  .5297D+00,
     +   .1561D-02, -.6537D-04,  .9604D-07,  .8175D-07,  .1108D-04,
     +   .6338D+00,  .4151D+00,  .5304D+00,
     +   .1384D-02, -.5767D-04,  .8482D-07,  .6769D-07,  .9556D-05,
     +   .6341D+00,  .4165D+00,  .5309D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=17,25)/
     +   .1242D-02, -.5154D-04,  .7833D-07,  .6846D-07,  .8307D-05,
     +   .6344D+00,  .4176D+00,  .5314D+00,
     +   .1085D-02, -.4482D-04,  .6678D-07,  .6717D-07,  .6939D-05,
     +   .6346D+00,  .4192D+00,  .5320D+00,
     +   .9588D-03, -.3940D-04,  .5078D-07,  .5871D-07,  .5886D-05,
     +   .6349D+00,  .4204D+00,  .5325D+00,
     +   .8493D-03, -.3477D-04,  .3643D-07,  .4857D-07,  .4993D-05,
     +   .6352D+00,  .4217D+00,  .5330D+00,
     +   .7643D-03, -.3119D-04,  .2736D-07,  .4184D-07,  .4263D-05,
     +   .6354D+00,  .4226D+00,  .5334D+00,
     +   .6858D-03, -.2789D-04,  .1519D-07,  .3591D-07,  .3681D-05,
     +   .6356D+00,  .4238D+00,  .5339D+00,
     +   .6198D-03, -.2513D-04,  .2693D-08,  .2507D-07,  .3214D-05,
     +   .6357D+00,  .4247D+00,  .5342D+00,
     +   .5608D-03, -.2268D-04, -.1236D-07,  .1952D-07,  .2796D-05,
     +   .6359D+00,  .4255D+00,  .5345D+00,
     +   .5137D-03, -.2072D-04, -.2113D-07,  .1190D-07,  .2520D-05,
     +   .6362D+00,  .4262D+00,  .5349D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=1,8)/
     +   .4062D-02, -.1380D-03,  .1918D-06,  .3717D-07,  .3470D-05,
     +   .6401D+00,  .4472D+00,  .5429D+00,
     +   .3058D-02, -.1025D-03,  .2375D-06,  .7905D-07,  .6807D-05,
     +   .6407D+00,  .4507D+00,  .5442D+00,
     +   .2507D-02, -.8329D-04,  .2416D-06,  .1017D-06,  .7332D-05,
     +   .6411D+00,  .4529D+00,  .5450D+00,
     +   .2026D-02, -.6670D-04,  .2403D-06,  .1157D-06,  .7087D-05,
     +   .6412D+00,  .4553D+00,  .5457D+00,
     +   .1599D-02, -.5214D-04,  .2393D-06,  .1243D-06,  .6484D-05,
     +   .6419D+00,  .4578D+00,  .5468D+00,
     +   .1360D-02, -.4411D-04,  .2234D-06,  .1275D-06,  .6030D-05,
     +   .6419D+00,  .4594D+00,  .5471D+00,
     +   .1206D-02, -.3894D-04,  .2206D-06,  .1237D-06,  .5732D-05,
     +   .6423D+00,  .4606D+00,  .5477D+00,
     +   .1014D-02, -.3259D-04,  .2123D-06,  .1336D-06,  .5352D-05,
     +   .6426D+00,  .4623D+00,  .5483D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=9,16)/
     +   .8966D-03, -.2870D-04,  .1974D-06,  .1221D-06,  .5004D-05,
     +   .6427D+00,  .4635D+00,  .5487D+00,
     +   .7141D-03, -.2274D-04,  .1758D-06,  .1104D-06,  .4424D-05,
     +   .6431D+00,  .4655D+00,  .5495D+00,
     +   .5826D-03, -.1849D-04,  .1640D-06,  .1088D-06,  .3813D-05,
     +   .6434D+00,  .4673D+00,  .5501D+00,
     +   .4888D-03, -.1549D-04,  .1438D-06,  .1067D-06,  .3373D-05,
     +   .6437D+00,  .4687D+00,  .5506D+00,
     +   .4220D-03, -.1336D-04,  .1314D-06,  .9798D-07,  .2936D-05,
     +   .6439D+00,  .4698D+00,  .5510D+00,
     +   .3555D-03, -.1126D-04,  .1154D-06,  .9586D-07,  .2488D-05,
     +   .6440D+00,  .4711D+00,  .5515D+00,
     +   .3073D-03, -.9755D-05,  .9141D-07,  .8224D-07,  .2125D-05,
     +   .6444D+00,  .4721D+00,  .5520D+00,
     +   .2678D-03, -.8516D-05,  .7706D-07,  .7051D-07,  .1824D-05,
     +   .6443D+00,  .4728D+00,  .5521D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=17,25)/
     +   .2366D-03, -.7557D-05,  .6677D-07,  .6692D-07,  .1465D-05,
     +   .6448D+00,  .4735D+00,  .5526D+00,
     +   .2029D-03, -.6507D-05,  .5167D-07,  .5900D-07,  .1134D-05,
     +   .6450D+00,  .4741D+00,  .5529D+00,
     +   .1760D-03, -.5685D-05,  .3289D-07,  .5206D-07,  .8092D-06,
     +   .6450D+00,  .4747D+00,  .5530D+00,
     +   .1533D-03, -.4987D-05,  .1523D-07,  .3587D-07,  .5625D-06,
     +   .6452D+00,  .4750D+00,  .5533D+00,
     +   .1359D-03, -.4456D-05,  .2986D-08,  .2767D-07,  .3940D-06,
     +   .6454D+00,  .4750D+00,  .5534D+00,
     +   .1201D-03, -.3977D-05, -.9646D-08,  .2680D-07,  .2536D-06,
     +   .6452D+00,  .4750D+00,  .5533D+00,
     +   .1070D-03, -.3578D-05, -.2326D-07,  .1079D-07,  .1882D-06,
     +   .6456D+00,  .4746D+00,  .5535D+00,
     +   .9539D-04, -.3232D-05, -.3982D-07,  .1826D-08,  .7077D-07,
     +   .6455D+00,  .4744D+00,  .5534D+00,
     +   .8630D-04, -.2948D-05, -.4911D-07, -.8505D-08,  .3023D-07,
     +   .6455D+00,  .4740D+00,  .5533D+00 /
C
         X  = DX
         Q  = DQ
         Q2 = DQ*DQ
*...CHECK OF X AND Q2 VALUES : 
C       IF ( (X.LT.1.0D-4) .OR. (X.GT.1.0D0) ) THEN
C           WRITE(6,91) 
C  91       FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C          GOTO 60
C       ENDIF
C       IF ( (Q2.LT.0.4D0) .OR. (Q2.GT.1.D4) ) THEN
C           WRITE(6,92) 
C  92       FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C          GOTO 60
C       ENDIF
C
*...INITIALIZATION :
*    SELECTION AND READING OF THE GRID :
*    FILE - NO. = 11 FOR NLO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.040D-03 )     
*    FILE - NO. = 22 FOR NLO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 9.740D-04 )     
*    FILE - NO. = 33 FOR  LO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.731D-03 )     
*    FILE - NO. = 44 FOR  LO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.846D-03 )     
      IF (IINI.NE.0) GOTO 16
C      IF (ISET.EQ.1) THEN
C       IIREAD=11       
C       OPEN(UNIT=11,FILE='stdnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.2) THEN
C       IIREAD=22
C       OPEN(UNIT=22,FILE='valnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.3) THEN
C       IIREAD=33       
C       OPEN(UNIT=33,FILE='stdloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.4) THEN
C       IIREAD=44
C       OPEN(UNIT=44,FILE='valloa1.grid',STATUS='OLD')
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'PARTON INTERPOLATION: ISET OUT OF RANGE')
C        GOTO 60
C      END IF
C
C       DO 15 M = 1, NX-1 
C       DO 15 N = 1, NQ
C       READ(IIREAD,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1                 PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M),
C     2                 PARTON(7,N,M), PARTON(8,N,M)
C  90   FORMAT (8(1PE10.3))
C  15   CONTINUE
C
      IINI = 1
*....ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0 = XB(IX) 
        XB1 = 1.D0-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0**0.7)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0**0.6)
        XQBF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0**0.3) 
        XSF(IX,IQ)  = PARTON(4,IQ,IX) / (XB1**7 * XB0**0.3) 
        XGF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**10 * XB0**0.3)
        XAPF(IX,IQ)  = PARTON(6,IQ,IX) / XB0
        XANF(IX,IQ)  = PARTON(7,IQ,IX) / XB0
        XADF(IX,IQ)  = PARTON(8,IQ,IX) / XB0
  20  CONTINUE
        XUVF(NX,IQ) = 0.D0
        XDVF(NX,IQ) = 0.D0
        XQBF(NX,IQ) = 0.D0
        XSF(NX,IQ)  = 0.D0
        XGF(NX,IQ)  = 0.D0
        XAPF(NX,IQ)  = 0.D0
        XANF(NX,IQ)  = 0.D0
        XADF(NX,IQ)  = 0.D0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
  16  CONTINUE
C
*...INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * (1.D0-X)**3 * X**0.7
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * (1.D0-X)**4 * X**0.6 
      DDV = DV 
      QB = DBFINT(NARG,XT,NA,ARRF,XQBF) * (1.D0-X)**7 * X**0.3
      DSEA = QB
      ST = DBFINT(NARG,XT,NA,ARRF,XSF)  * (1.D0-X)**7 * X**0.3
      DSTR = ST
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * (1.D0-X)**10 * X**0.3
      DGL = GL
      A1P = DBFINT(NARG,XT,NA,ARRF,XAPF)  * X
      A1N = DBFINT(NARG,XT,NA,ARRF,XANF)  * X
      A1D = DBFINT(NARG,XT,NA,ARRF,XADF)  * X
 60   RETURN
      END
