// Copyright (c) 2011  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org)
//
// $URL: https://github.com/CGAL/cgal/blob/releases/CGAL-5.0.3/Spatial_sorting/include/CGAL/Hilbert_sort_2.h $
// $Id: Hilbert_sort_2.h 0779373 2020-03-26T13:31:46+01:00 Sébastien Loriot
// SPDX-License-Identifier: LGPL-3.0-or-later OR LicenseRef-Commercial
//
// Author(s)     : Olivier Devillers

#ifndef CGAL_HILBERT_SORT_2_H
#define CGAL_HILBERT_SORT_2_H

#include <CGAL/Hilbert_policy_tags.h>
#include <CGAL/Hilbert_sort_median_2.h>
#include <CGAL/Hilbert_sort_middle_2.h>

namespace CGAL {

template <class K,  class Hilbert_policy >
  class Hilbert_sort_2;

template <class K>
  class Hilbert_sort_2<K, Hilbert_sort_median_policy >
  : public Hilbert_sort_median_2<K>
{
 public:
  Hilbert_sort_2 (const K &k=K() , std::ptrdiff_t limit=1 )
   : Hilbert_sort_median_2<K> (k,limit)
    {}
};

template <class K>
  class Hilbert_sort_2<K, Hilbert_sort_middle_policy >
  : public Hilbert_sort_middle_2<K>
{
 public:
 Hilbert_sort_2 (const K &k=K() , std::ptrdiff_t limit=1 )
   : Hilbert_sort_middle_2<K> (k,limit)
    {}
};

} // namespace CGAL

#endif//CGAL_HILBERT_SORT_2_H
