/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
#include "config.h"
#include "gimpgradient.h"
#include "gprop.h"
#include "gaccel.h"
#include "gtkmultirowsel.h"
#include "gtkselbox.h"
#include "gtkbgpixmap.h"

#include "pixmaps/stock_close.xpm"
#include "pixmaps/stock_restart.xpm"

extern int rgb_savePNG(char *, int, int, unsigned char *);

typedef struct {
	gboolean	frst;
	int		per_page;
	int		first_sh;
	GtkWidget	*shaderpv;
	GtkWidget	*ptab;
	GtkWidget	*progress;
	GtkTooltips	*tt;
	GtkWidget	*menu;
	GtkWidget	*combo;
	GtkWidget	*b_next;
	GtkWidget	*b_prev;
	GtkWidget	*pv;
	GtkWidget	*refreshb;
	GtkWidget	*savefs;
	GtkWidget	*w_sel;
	GtkWidget	*h_sel;
} shaderdlg_info;

randshader_info *rinfo_dup(rinfo)
randshader_info *rinfo;
{
	randshader_info *rv;

	rv = g_memdup(rinfo, sizeof(randshader_info));

	if (rv->tile)
		rv->tile = g_strdup(rv->tile);

	return rv;
}

void rinfo_free(rinfo)
randshader_info *rinfo;
{
	g_free(rinfo->tile);
	g_free(rinfo);
}

static void ShaderView(info)
shaderdlg_info *info;
{
	randshader_info *rinfo;
	char pom[128];

	rinfo = gtk_object_get_data(GTK_OBJECT(info->pv), "shinfo");

	if (rinfo)
	{
		GdkPixmap *pmap;
		GtkWidget *pixmap;
		GdkGC *gc;
		guint w,h;
		prop_t prop;

		sprintf(pom , gettext("ChBg: shader %d"), rinfo->shadernr);
		gtk_window_set_title(GTK_WINDOW(info->pv), pom);

		gdk_window_get_size(info->pv->window , &w, &h);

		gc = gdk_gc_new(info->pv->window);
		pmap = gdk_pixmap_new(info->pv->window, w, h,
			gdk_visual_get_best_depth());

		prop.shade = rinfo->shadernr;
		prop.tile = rinfo->tile;
		if (rinfo->gradnr > 0)
			prop.use_grad = TRUE;
		if (rinfo->tile)
			prop.use_tiles = TRUE;
		shader_shade_pixmap(&prop , pmap, gc, w, h, FALSE, rinfo, NULL);

		if (GTK_BIN(info->pv)->child)
			gtk_widget_destroy(GTK_BIN(info->pv)->child);

		pixmap = gtk_bg_pixmap_new(pmap);
		gtk_container_add(GTK_CONTAINER(info->pv), pixmap);
		gtk_widget_show(pixmap);

		gdk_gc_unref(gc);
		gdk_pixmap_unref(pmap);
	}
	else
	{
		gdk_beep();
	}
}

static gint ShaderViewKEvents(widget , event, info)
GtkWidget *widget;
GdkEvent  *event;
shaderdlg_info *info;
{
	switch (event->type)
	{
		case GDK_KEY_RELEASE:
		{
                        GdkEventKey *kevent = (GdkEventKey *)event;
                        switch(kevent->keyval)
                        {
				case GDK_Q:
				case GDK_q:
				case GDK_Escape:
					gtk_widget_destroy(GTK_WIDGET(info->pv));
				break;
			}
		}
		break;
		case GDK_CONFIGURE:
		{
			static gint w = -1, h = -1;
			GdkEventConfigure *cevent = (GdkEventConfigure *)event;

			if (cevent->width != w || cevent->height != h)
			{
				ShaderView(info);

				w = cevent->width;
				h = cevent->height;
			}
		}
		break;
		default:
		break;
	}

	return FALSE;
}

static void ShaderViewDlg(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	randshader_info *rinfo;
	GtkWidget *sw;

	sw = gtk_multirowsel_get_selected(GTK_MULTIROWSEL(info->ptab));

	if (!sw)
	{
		gdk_beep();
		return;
	}

	rinfo = gtk_object_get_data(GTK_OBJECT(sw), "shinfo");

	if (!info->pv)
	{
		info->pv = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(info->pv) , TRUE , TRUE , FALSE);
		gtk_window_set_default_size(GTK_WINDOW(info->pv), 100, 100);
		gtk_signal_connect(GTK_OBJECT(info->pv), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(info->pv));
		gtk_widget_add_events(info->pv, GDK_KEY_RELEASE_MASK);
		gtk_signal_connect(GTK_OBJECT(info->pv), "key_release_event",
			GTK_SIGNAL_FUNC(ShaderViewKEvents), info);
		gtk_signal_connect(GTK_OBJECT(info->pv), "configure_event",
			GTK_SIGNAL_FUNC(ShaderViewKEvents), info);
		if (info->frst)
			gtk_signal_connect(GTK_OBJECT(toplevel_window),
				"destroy", GTK_SIGNAL_FUNC(KillAll), &info->pv);
		info->frst = FALSE;
	}
	gtk_object_set_data_full(GTK_OBJECT(info->pv), "shinfo",
		g_memdup(rinfo, sizeof(randshader_info)),
		(GtkDestroyNotify)g_free);

	if (GTK_WIDGET_REALIZED(info->pv))
		gdk_window_raise(info->pv->window);
	gtk_widget_show(info->pv);

	ShaderView(info);
}

static void ShaderSetWalp(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	randshader_info *rinfo;
	GtkWidget *sw;

	sw = gtk_multirowsel_get_selected(GTK_MULTIROWSEL(info->ptab));

	if (!sw)
	{
		gdk_beep();
		return;
	}

	rinfo = gtk_object_get_data(GTK_OBJECT(sw), "shinfo");

	if (rinfo)
	{
		GdkPixmap *pmap;
		GdkGC *gc;
		GdkWindow *root_window = GDK_ROOT_PARENT();
		guint w,h;
		prop_t prop;

		gdk_window_get_size(root_window , &w, &h);

		gc = gdk_gc_new(root_window);
		pmap = gdk_pixmap_new(root_window, w, h,
			gdk_visual_get_best_depth());

		prop.shade = rinfo->shadernr;
		prop.tile = rinfo->tile;
		if (rinfo->gradnr > 0)
			prop.use_grad = TRUE;
		if (rinfo->tile)
			prop.use_tiles = TRUE;
		shader_shade_pixmap(&prop , pmap, gc, w, h, TRUE, rinfo, NULL);
		gdk_window_set_back_pixmap(root_window, pmap, FALSE);

#ifdef HAVE_ESETROOT_SUPPORT
		esetroot_pixmap_property(root_window, pmap, w, h, &prop);
#endif /* HAVE_ESETROOT_SUPPORT */

		gdk_gc_unref(gc);
		gdk_pixmap_unref(pmap);

		gdk_window_clear(root_window);
		gdk_flush();

		chbg_status_clear();
	}
}

static void ShaderSaveOK(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	randshader_info *rinfo;

	rinfo = gtk_object_get_data(GTK_OBJECT(info->savefs), "shinfo");

	if (rinfo)
	{
		char *name;
		guint w,h;
		prop_t prop;
		absimg_rgb_t *pixels;

		name = gtk_file_selection_get_filename(GTK_FILE_SELECTION(info->savefs));
		gprop_set_str("shader_last_save", name);

		w = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(info->w_sel));
		h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(info->h_sel));

		pixels = absimg_rgb_new(w, h);

		prop.shade = rinfo->shadernr;
		prop.tile = rinfo->tile;
		if (rinfo->gradnr > 0)
			prop.use_grad = TRUE;
		if (rinfo->tile)
			prop.use_tiles = TRUE;
		shader_shade_pixmap(&prop , NULL, NULL, w, h, FALSE, rinfo, pixels);

		if (!absimg_rgb_savePNG(pixels, name))
			gtk_widget_destroy(info->savefs);
		else
			gdk_beep();

		absimg_rgb_free(pixels);
	}
	else
		gdk_beep();
}

static void ShaderSave(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	static int frst = TRUE;
	randshader_info *rinfo;
	GtkWidget *sw;

	sw = gtk_multirowsel_get_selected(GTK_MULTIROWSEL(info->ptab));

	if (!sw)
	{
		gdk_beep();
		return;
	}

	rinfo = gtk_object_get_data(GTK_OBJECT(sw), "shinfo");

	if (!info->savefs)
	{
		GtkWidget *box, *label;
		GtkAdjustment *adj;
		int w,h;
		char *name;

		info->savefs = gtk_file_selection_new(gettext("ChBg: save shader"));
		if (!gprop_get_str("shader_last_save", &name))
			name = "shader.png";
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(info->savefs), name);

		gtk_signal_connect(GTK_OBJECT(info->savefs), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &info->savefs);

		if (frst)
		{
			gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
				GTK_SIGNAL_FUNC(KillAll), &info->savefs);
			frst = FALSE;
		}

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(info->savefs)->ok_button),
			"clicked", GTK_SIGNAL_FUNC(ShaderSaveOK), info);

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(info->savefs)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(KillWin), info->savefs);

		box = gtk_hbox_new(FALSE, 5);
		gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(info->savefs)->selection_text->parent),
			box, TRUE, FALSE, 2);
		gtk_box_reorder_child(GTK_BOX(GTK_FILE_SELECTION(info->savefs)->selection_text->parent) ,
                        box , 0);
		gtk_widget_show(box);

		label = gtk_label_new(gettext("Size: "));
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 3);
		gtk_widget_show(label);

		if (!gprop_get_int("shader_save_width", &w))
			w = 320;
		if (!gprop_get_int("shader_save_height", &h))
			h = 320;

		adj = (GtkAdjustment *)gtk_adjustment_new((gfloat)w, 1.0, 32768.0, 1.0, 10.0, 0.0);

		info->w_sel = gtk_spin_button_new(adj , 0 , 0);
		gtk_widget_set_usize(info->w_sel , 
			gdk_string_width(info->w_sel->style->font , "wwwwwww") , -1);
		gtk_box_pack_start(GTK_BOX(box), info->w_sel, FALSE, FALSE, 3);
		gtk_widget_show(info->w_sel);

		label = gtk_label_new(gettext(" x "));
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 3);
		gtk_widget_show(label);

		adj = (GtkAdjustment *)gtk_adjustment_new((gfloat)h, 1.0, 32768.0, 1.0, 10.0, 0.0);

		info->h_sel = gtk_spin_button_new(adj , 0 , 0);
		gtk_widget_set_usize(info->h_sel , 
			gdk_string_width(info->h_sel->style->font , "wwwwwww") , -1);
		gtk_box_pack_start(GTK_BOX(box), info->h_sel, FALSE, FALSE, 3);
		gtk_widget_show(info->h_sel);

		label = gtk_label_new(gettext(" pixels"));
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 3);
		gtk_widget_show(label);
	}

	gtk_object_set_data_full(GTK_OBJECT(info->savefs), "shinfo",
		g_memdup(rinfo, sizeof(randshader_info)),
		(GtkDestroyNotify)g_free);

	gtk_widget_show(info->savefs);
	if (GTK_WIDGET_REALIZED(info->savefs))
		gdk_window_raise(info->savefs->window);
}

static void ShaderOpen(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	randshader_info *rinfo;
	char *cmd;
	GtkWidget *sw;

	sw = gtk_multirowsel_get_selected(GTK_MULTIROWSEL(info->ptab));

	if (!sw)
	{
		gdk_beep();
		return;
	}

	rinfo = gtk_object_get_data(GTK_OBJECT(sw), "shinfo");

	cmd = (char *) gtk_object_get_user_data(GTK_OBJECT(w));

	if (rinfo)
	{
		char name[2048];
		guint w,h;
		prop_t prop;
		absimg_rgb_t *pixels;

#ifdef HAVE_MKSTEMP
		strcpy(name, "/tmp/chbg_png_save_for_openXXXXXX");
		close(mkstemp(name));
		unlink(name);
		strcat(name, ".png");
#else
		sprintf(name, "%s.png", tmpnam(NULL));
#endif

		if (!gprop_get_int("shader_open_width", &w))
			w = 320;
		if (!gprop_get_int("shader_open_height", &h))
			h = 320;

		pixels = absimg_rgb_new(w, h);

		prop.shade = rinfo->shadernr;
		prop.tile = rinfo->tile;
		if (rinfo->gradnr > 0)
			prop.use_grad = TRUE;
		if (rinfo->tile)
			prop.use_tiles = TRUE;
		shader_shade_pixmap(&prop , NULL, NULL, w, h, FALSE, rinfo, pixels);

		if (!absimg_rgb_savePNG(pixels, name))
		{
			char pom[4096], *p;

			p = strstr(cmd, "%f");

			if (p)
			{
				strncpy(pom, cmd, p - cmd);
				pom[p - cmd] = '\0';
				strcat(pom, "\'");
				strcat(pom, name);
				strcat(pom , "\'");
				strcat(pom, p+2);
				strcat(pom , " &");
			}
			else
			{
				strcpy(pom, cmd);
				strcat(pom, " \'");
				strcat(pom, name);
				strcat(pom , "\' &");
			}
			system(pom);
		}
		else
			gdk_beep();

		absimg_rgb_free(pixels);
	}
	else
		gdk_beep();
}
static int ShadersPreviewTabBEvent(widget, event, info)
GtkWidget *widget;
GdkEvent  *event;
shaderdlg_info *info;
{
	GdkEventButton *bevent;

	bevent = (GdkEventButton *) event;

	switch (event->type)
	{
		case GDK_BUTTON_PRESS:
			if (bevent->button == 3)
			{
				GList *ptr;
				int is_selected = gtk_multirowsel_get_selected(GTK_MULTIROWSEL(info->ptab)) != NULL;
				for (ptr = GTK_MENU_SHELL(info->menu)->children 
	; ptr ; ptr = ptr->next)
					gtk_widget_set_sensitive(GTK_WIDGET(ptr->data), is_selected);
				
				gtk_menu_popup (GTK_MENU(info->menu), 
					NULL, NULL, NULL, NULL, 3, bevent->time);
			}
		break;
		default:
		break;
	}
	return FALSE;
}

static int ShadersPreviewBEvent(widget, event, info)
GtkWidget *widget;
GdkEvent  *event;
shaderdlg_info *info;
{
	GdkEventButton *bevent;

	bevent = (GdkEventButton *) event;

	switch (event->type)
	{
		case GDK_2BUTTON_PRESS:
			if (bevent->button == 1)
				ShaderSetWalp(NULL, info);
		break;
		default:
		break;
	}

	return FALSE;
}

static void ShadersPreviewGen(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	GtkWidget *pixmap, *box;
	GdkPixmap *pmap;
	GdkGC *gc;
	prop_t *prop;
	int i,onpage;
	gboolean stop = FALSE;

	if (!info->tt)
		info->tt = gtk_tooltips_new();

	if (info->combo)
	{
		gtk_option_menu_set_history(GTK_OPTION_MENU(info->combo), info->first_sh/info->per_page);
		gtk_widget_set_sensitive(info->combo, FALSE);
		gtk_widget_set_sensitive(info->b_next, FALSE);
		gtk_widget_set_sensitive(info->b_prev, FALSE);
	}

	gtk_widget_set_sensitive(info->refreshb, FALSE);
	gtk_widget_show(info->progress);
	gtk_window_set_title(GTK_WINDOW(info->shaderpv), gettext("Chbg: shaders preview (wait ...)"));

	while (GTK_BOX(info->ptab)->children)
	{
		gtk_widget_destroy(((GtkBoxChild *)GTK_BOX(info->ptab)->children->data)->widget);
	}

	gc = gdk_gc_new(toplevel_window->window);
	prop = prop_dup(&cfg.properties);

	onpage = (info->per_page > (shader_get_cnt() - info->first_sh)) ? (shader_get_cnt() - info->first_sh+1) : info->per_page;

	for (i = info->first_sh ; !stop && (i < info->first_sh + onpage); i ++)
	{
		randshader_info sinfo;
		char pom[250];
		char *p;

		gtk_progress_bar_update(GTK_PROGRESS_BAR(info->progress) , ((gfloat)(i-info->first_sh))/(gfloat)(onpage));
		while (gtk_events_pending()) gtk_main_iteration();

		if (!info->shaderpv)
		{
			stop = TRUE;
			break;
		}

		box = gtk_selbox_new(FALSE, TRUE);
		gtk_box_pack_start(GTK_BOX(info->ptab), box, FALSE, FALSE, 0);
		gtk_widget_show(box);

		prop->shade = i;
		pmap = gdk_pixmap_new(toplevel_window->window, 70, 70, gdk_visual_get_best_depth());
		sinfo.load = FALSE;
		shader_shade_pixmap(prop, pmap, gc, 70, 70, FALSE, &sinfo, NULL);
		sinfo.load = TRUE;
		sinfo.shadernr = prop->shade;

		gtk_object_set_data_full(GTK_OBJECT(box), "shinfo",
			rinfo_dup(&sinfo), (GtkDestroyNotify)rinfo_free);
		pixmap = gtk_bg_pixmap_new(pmap);
		gtk_widget_add_events(pixmap,
			GDK_BUTTON_PRESS_MASK 
			| GDK_BUTTON_RELEASE_MASK
			| GDK_ENTER_NOTIFY_MASK
			| GDK_LEAVE_NOTIFY_MASK);

		pom[0] = '\0';
		if (sinfo.gradnr > 0)
		{
			gradient_t *grad;

			grad = (gradient_t *) (g_slist_nth(cfg.grads, sinfo.gradnr - 1))->data;
			if (grad)
			{
				p = strrchr(grad->filename, '/');
				if (p) p++;
				else p = grad->filename;
				sprintf(pom, gettext("Shader number: %d\n"
						     "Gradient: %s"), i, p);
			}
		}
		else
		{
			sprintf(pom, gettext("Shader number: %d\nColor1: #%02x%02x%02x\nColor2: #%02x%02x%02x"), i,
				sinfo.r0, sinfo.g0, sinfo.b0, sinfo.r1, sinfo.g1, sinfo.b1);
		}
		if (pom[0])
			gtk_tooltips_set_tip(info->tt, pixmap, pom, NULL);
		gtk_container_add(GTK_CONTAINER(box), pixmap);
		gtk_widget_show(pixmap);

		gtk_signal_connect(GTK_OBJECT(box), "button_press_event",
			GTK_SIGNAL_FUNC(ShadersPreviewBEvent), info);

		gdk_pixmap_unref(pmap);
	}
	gdk_gc_unref(gc);
	prop_free(prop);

	if (info->shaderpv)
	{
		gtk_widget_hide(info->progress);
		gtk_window_set_title(GTK_WINDOW(info->shaderpv), gettext("Chbg: shaders preview"));
		gtk_widget_set_sensitive(info->refreshb, TRUE);

		if (info->combo)
		{
			gtk_widget_set_sensitive(info->combo, TRUE);
			gtk_widget_set_sensitive(info->b_next, (info->first_sh + info->per_page) <= shader_get_cnt());
			gtk_widget_set_sensitive(info->b_prev, (info->first_sh - info->per_page)>0);
		}
	}
}

static void ShadersWinClose(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	if (info->pv)
		gtk_widget_destroy(info->pv);
	if (info->savefs)
		gtk_widget_destroy(info->savefs);
}

static void ShaderMenuOpenBuild(smenu, info)
GtkWidget *smenu;
shaderdlg_info *info;
{
	int i;

	while (GTK_MENU_SHELL(smenu)->children)
	{
		gtk_widget_destroy(GTK_WIDGET(GTK_MENU_SHELL(smenu)->children->data));
	}

	for (i = 0; i < CHBG_EXTERNOPENER; i++)
	{
		char pom[1024];
		char *label = NULL, *cmd = NULL;

		sprintf(pom , "option-extop%02d-label", i);
		gprop_get_str(pom, &label);
		sprintf(pom , "option-extop%02d-cmd", i);
		gprop_get_str(pom, &cmd);

		if (cmd)
		{
			GtkWidget *mi;

			mi = gtk_menu_item_new_with_label(label ? label : "???");
			if (label)
			{
				sprintf(pom, "shader/open-with/%s", label);
				gaccel_bind_widget(pom , "activate" , mi, NULL, guitl_menu_parent(GTK_MENU_SHELL(smenu)->parent_menu_shell));
			}
			gtk_object_set_user_data(GTK_OBJECT(mi), cmd);
			gtk_menu_append(GTK_MENU(smenu), mi);
			gtk_widget_show(mi);

			gtk_signal_connect(GTK_OBJECT(mi), "activate",
				GTK_SIGNAL_FUNC(ShaderOpen), info);
		}
	}
}

static void ShaderNewPage(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	info->first_sh = (int)gtk_object_get_user_data(GTK_OBJECT(w));
	ShadersPreviewGen(NULL, info);
}

static void ShaderPrevPage(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	info->first_sh -= info->per_page;
	if (info->first_sh < 0)
		info->first_sh = 2;
	else
		ShadersPreviewGen(NULL, info);
}

static void ShaderNextPage(w, info)
GtkWidget *w;
shaderdlg_info *info;
{
	info->first_sh += info->per_page;

	if (info->first_sh > shader_get_cnt())
		info->first_sh -= info->per_page;
	else
		ShadersPreviewGen(NULL, info);
}

void ShadersPreview(w, data)
GtkWidget *w;
gpointer *data;
{
	static int frst = TRUE;
	static shaderdlg_info info = {TRUE, 2, 100, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};

	if (!info.shaderpv)
	{
		GtkWidget *col, *button, *box, *swin, *mi, *smenu;

		info.shaderpv = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(info.shaderpv), gettext("Chbg: shaders preview (wait ...)"));
		gtk_signal_connect(GTK_OBJECT(info.shaderpv), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &info.shaderpv);
		gtk_signal_connect(GTK_OBJECT(info.shaderpv), "destroy",
			GTK_SIGNAL_FUNC(ShadersWinClose), &info);

		if (frst)
		{
			gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
				GTK_SIGNAL_FUNC(KillAll), &info.shaderpv);
			frst = FALSE;
		}

		col = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(info.shaderpv), col);
		gtk_widget_show(col);

		if (!gprop_get_int("shaders_per_page", &info.per_page))
			info.per_page = 100;

		if (info.per_page < (shader_get_cnt()-1))
		{
			GtkWidget *menu,*mi,*box;
			int n;

			box = gtk_hbutton_box_new();
			gtk_box_pack_start(GTK_BOX(col), box, FALSE, FALSE, 2);
			gtk_widget_show(box);

			info.b_prev = gtk_button_new_with_label(gettext("<< previous"));
			gtk_box_pack_start(GTK_BOX(box), info.b_prev, FALSE, FALSE, 1);
			gtk_widget_show(info.b_prev);
			gtk_signal_connect(GTK_OBJECT(info.b_prev), "clicked" ,
				GTK_SIGNAL_FUNC(ShaderPrevPage) ,(gpointer)&info); 

			info.combo = gtk_option_menu_new();

			menu = gtk_menu_new();

			n = 2;

			while(n <= (shader_get_cnt()))
			{
				char pom[30];

				sprintf(pom , "%d - %d", n, ((n+info.per_page) <= shader_get_cnt()) ? n+info.per_page-1 : shader_get_cnt());

				mi = gtk_menu_item_new_with_label(pom);
				gtk_menu_append(GTK_MENU(menu), mi);
				gtk_widget_show(mi);

				gtk_object_set_user_data(GTK_OBJECT(mi), (gpointer)n);

				gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
					GTK_SIGNAL_FUNC(ShaderNewPage) ,(gpointer)&info); 

				n += info.per_page;
			}

			gtk_option_menu_set_menu(GTK_OPTION_MENU(info.combo), menu);
			gtk_option_menu_set_history(GTK_OPTION_MENU(info.combo), 0);
			gtk_box_pack_start(GTK_BOX(box), info.combo, FALSE, FALSE, 1);
			gtk_widget_show(info.combo);

			info.b_next = gtk_button_new_with_label(gettext("next >>"));
			gtk_box_pack_start(GTK_BOX(box), info.b_next, FALSE, FALSE, 1);
			gtk_widget_show(info.b_next);
			gtk_signal_connect(GTK_OBJECT(info.b_next), "clicked" ,
				GTK_SIGNAL_FUNC(ShaderNextPage) ,(gpointer)&info); 
		}
		else
		{
			info.combo = NULL;
		}

		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_widget_set_usize(swin, -1, 455);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		gtk_widget_show(swin);
		gtk_container_add(GTK_CONTAINER(col), swin);

		info.ptab = gtk_multirowsel_new(5);
		gtk_multirow_set_spacing(GTK_MULTIROW(info.ptab), 0, 0);
		gtk_multirowsel_set_selection_mode(GTK_MULTIROWSEL(info.ptab), GTK_SELECTION_SINGLE);
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin), info.ptab);
		gtk_widget_show(info.ptab);
		gtk_signal_connect(GTK_OBJECT(info.ptab), "button_press_event",
			GTK_SIGNAL_FUNC(ShadersPreviewTabBEvent), &info);

		info.progress = gtk_progress_bar_new();
		gtk_box_pack_start(GTK_BOX(col), info.progress, FALSE, FALSE, 2);

		box = gtk_hbutton_box_new();
		gtk_box_pack_start(GTK_BOX(col), box, FALSE, FALSE, 2);
		gtk_widget_show(box);

		button = guitl_pixmap_button(stock_close_xpm, gettext("Close"));
		gtk_box_pack_start(GTK_BOX(box) , button , FALSE , TRUE , 0);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(KillWin), info.shaderpv);

		info.refreshb = button = guitl_pixmap_button(stock_restart_xpm, gettext("Refresh"));
		gtk_box_pack_end(GTK_BOX(box) , button , FALSE , TRUE , 0);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ShadersPreviewGen), &info);

		info.menu = gtk_menu_new();
		gtk_widget_realize(info.menu);

		mi = gtk_menu_item_new_with_label(gettext("View ..."));
		gaccel_bind_widget("shader/view" , "activate" , mi, NULL, info.shaderpv);
		gtk_menu_append(GTK_MENU(info.menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ShaderViewDlg), &info);

		mi = gtk_menu_item_new_with_label(gettext("Set wallpaper"));
		gaccel_bind_widget("shader/setwallp" , "activate" , mi, NULL, info.shaderpv);
		gtk_menu_append(GTK_MENU(info.menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ShaderSetWalp), &info);

		mi = gtk_menu_item_new();
		gtk_menu_append(GTK_MENU(info.menu), mi);
		gtk_widget_show(mi);

		mi = gtk_menu_item_new_with_label(gettext("Save as ..."));
		gaccel_bind_widget("shader/save_as" , "activate" , mi, NULL, info.shaderpv);
		gtk_menu_append(GTK_MENU(info.menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ShaderSave), &info);

		smenu = gtk_menu_new();
		gtk_signal_connect(GTK_OBJECT(smenu), "show",
			GTK_SIGNAL_FUNC(ShaderMenuOpenBuild), &info);
		gtk_widget_realize(smenu);

		mi = gtk_menu_item_new_with_label(gettext("Open with"));
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi), smenu);
		gtk_menu_append(GTK_MENU(info.menu), mi);
		gtk_widget_show(mi);

		gtk_widget_show(info.shaderpv);
		while (gtk_events_pending()) gtk_main_iteration();

		info.first_sh = 2;
		ShadersPreviewGen(NULL, &info);
	}
	else
		gtk_widget_show(info.shaderpv);

	if (info.shaderpv && GTK_WIDGET_REALIZED(info.shaderpv))
		gdk_window_raise(info.shaderpv->window);
}

