%{
#include <string.h>
#include "users.tab.h"

static char linebuf[2][255];
static unsigned int lno = 0;
int yywarn(char *msg);

unsigned long policydb_lineno = 1;

unsigned int policydb_errors = 0;
%}
%array
letter  [A-Za-z]
digit   [0-9]
hexval	[0-9A-Fa-f]
%%
\n.*				{ strncpy(linebuf[lno], yytext+1, 255);
                                  linebuf[lno][254] = 0;
                                  lno = 1 - lno; 
                                  policydb_lineno++;
                                  yyless(1); }
ROLES |
roles				{ return(ROLES); }
RANGES |
ranges				{ return(RANGES); }
USER |
user				{ return(USER); }
{letter}({letter}|{digit}|_)*	{ return(IDENTIFIER); }
{letter}({letter}|{digit}|_|"."|"-")*	{ return(USER_IDENTIFIER); }
#[^\n]*                         { /* delete comments */ }
[ \t\f]+			{ /* delete whitespace */ }
"{" |
"}" |
";" |
"-" |
"~" |
"*"				{ return(yytext[0]); } 
.                               { yywarn("unrecognized character");}
%%
int yyerror(char *msg)
{
	fprintf(stderr, "ERROR '%s' at token '%s' on line %ld:\n%s\n%s\n",
			msg,
			yytext,
			policydb_lineno,
			linebuf[0], linebuf[1]);
	policydb_errors++;
	return -1;
}

int yywarn(char *msg)
{
	fprintf(stderr, "WARNING '%s' at token '%s' on line %ld:\n%s\n%s\n",
			msg,
			yytext,
			policydb_lineno,
			linebuf[0], linebuf[1]);
	return 0;
}
