/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          engine_manager.cpp  -  description
                             -------------------
    begin                : vie nov 1 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "engine_manager.h"



Midi_Voice *Engine_Manager::get_midi_voice(int p_bank,int p_patch) {

	if ((p_bank<0) || (p_bank>=(int)bank_list.size())) return NULL;


        Engine *engine= engine_list [ bank_list[p_bank].engine_index ];
	
	return engine->get_midi_voice(bank_list[p_bank].engine_bank_index , p_patch);

}


Midi_Voice * Engine_Manager::get_midi_drum_voice(int p_bank,int p_drum_bank,char p_instrument) {


	if ((p_bank<0) || (p_bank>=(int)bank_list.size())) return NULL;


        Engine *engine= engine_list [ bank_list[p_bank].engine_index ];

	return engine->get_midi_drum_voice(bank_list[p_bank].engine_bank_index , p_drum_bank, p_instrument);
}

void Engine_Manager::register_engine(Engine *p_engine) {

	engine_list.push_back(p_engine);
}


int Engine_Manager::get_engine_count() {

	return engine_list.size();
}

int Engine_Manager::get_bank_count() {

	return bank_list.size();
}

string Engine_Manager::get_engine_name(int p_index) {

	if ((p_index<0) && (p_index>(int)engine_list.size())) return "<Invalid Engine>";

	return engine_list[p_index]->get_name();
}

void Engine_Manager::add_bank(int p_engine_index) {

	if ((p_engine_index<0) && (p_engine_index>engine_list.size())) return;

	Bank new_bank; // new bank!

	new_bank.engine_index=p_engine_index;
	new_bank.engine_bank_index=engine_list[p_engine_index]->add_bank();

	bank_list.push_back(new_bank);
}


Engine_Manager::Engine_Manager(){
}
Engine_Manager::~Engine_Manager(){
}
