/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          sample_data.h  -  description
                             -------------------
    begin                : Mon Feb 5 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SAMPLE_DATA_H
#define SAMPLE_DATA_H

#include "typedefs.h"
#include "sample_defs.h"
#include "tables.h"
//#include "tables.h"

/**Sample Data.
All data needed to modify a Sample

  *@author Juan Linietsky
  */


/******************************
 sample_data.h
 --------

This contains the real "data"
of a sample. It is used both by the
song and the player.

Also contains some useful editing functions.
that will make your life easier
********************************/


#define IS_16_BIT true


class Sample_Data {
	int get_data_value(int p_pos);
	void put_data_value(int p_pos,int p_val);


	/* loop flags */

	bool loop_on;
	bool sustain_loop_on;

	/* loop data */
	Uint32 loop_begin;
	Uint32 loop_end;
	bool pingpong_loop;

	/* sustain loop data */
	Uint32 sustain_loop_begin;
	Uint32 sustain_loop_end;
	bool sustain_pingpong_loop;

	/* format Data */
	bool is_16bits;

	int c5_freq;

	Sint32 size; // in samples, not bytes.
	sample_16s_t *data_ptr;

public:

	inline int get_size()  const;
	inline bool is_16bit()  const;
	inline sample_16s_t *get_data_16() const;
	inline sample_8s_t *get_data_8()  const;
	float get_sample(int p_index)  const;
	void set_sample(int p_idx,float p_val);

        void set_c5_freq(int p_c5_freq);
        inline int get_c5_freq()  const;

	void set_loop_enabled(bool p_enabled);
	inline bool is_loop_enabled()  const;

	void set_loop_ping_pong(bool p_enabled);
	inline bool is_loop_ping_pong()  const;

	inline int get_loop_begin()  const;
	inline int get_loop_end()  const;

	void set_loop_begin(int p_idx);
	void set_loop_end(int p_idx);

	void release_data_ptr();
	void set_data_ptr(void *p_data,int p_size=0,bool p_16bits=false);
	void copy_sample_data(Sample_Data *p_sdata);


	void change_sign();
	void toggle_quality();

	/*
        void reverse();
        void post_loop_cut();
        void pre_loop_cut();
	void amplify(int p_amount);
	int get_value_to_normalize();
	void resize(int p_new_size);
	void resize_interpolated(int p_new_size);
	void centralize();
          */
        //void import_frequency(int p_freq);
	//int export_frequency();

	Sample_Data();
	~Sample_Data();
};


inline int Sample_Data::get_c5_freq()  const{

	return c5_freq;
}

inline int Sample_Data::get_size()   const{

	return size;
}



inline bool Sample_Data::is_16bit()  const{

	return is_16bits;
}
inline sample_16s_t *Sample_Data::get_data_16()  const{


		return  data_ptr;
}
inline sample_8s_t *Sample_Data::get_data_8()  const{

		return  (sample_8s_t*)data_ptr;
}

inline bool Sample_Data::is_loop_enabled()  const{

	return loop_on;
}

inline bool Sample_Data::is_loop_ping_pong()  const{

	return pingpong_loop;
}

inline int Sample_Data::get_loop_begin()  const{

	return loop_begin;
}
inline int Sample_Data::get_loop_end()  const{

	return loop_end;

}

#endif
