%define name cheops
%define version 0.57
%define release 2
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: X11/Applications/Networking
Source: ftp://ftp.marko.net/pub/cheops/%{name}-%{version}.tar.gz
Summary: Cheops Network User Interface
Packager: Mark Spencer <markster@marko.net>
Buildroot: /var/tmp/cheops-buildroot

%description
Cheops is a network "swiss army knife".  It's "network neighborhood" done right
(or gone out of control, depending on your perspective).  It's a combination
of a variety of network tools to provide system adminstrators and users with
a simple interface to managing and accessing their networks.  Cheops aims to
do for the network what the file manager did for the filesystem.

%prep
%setup

%build
./configure --prefix=/usr
make

%install
mkdir -p ${RPM_BUILD_ROOT}/usr/X11R6/bin
mkdir -p ${RPM_BUILD_ROOT}/usr/share/cheops
install -s cheops ${RPM_BUILD_ROOT}/usr/X11R6/bin
install pixmaps/*.xpm cheops.conf services.conf ${RPM_BUILD_ROOT}/usr/share/cheops
install plugins/*.so ${RPM_BUILD_ROOT}/usr/lib/cheops/plugins

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(755, root, root)
%attr(644,root,root) %doc COPYING README Changelog
/usr/X11R6/bin/cheops
%dir /usr/share/cheops/
%dir /usr/lib/cheops
%attr(644,root,root) /usr/share/cheops/*

%changelog
* Fri Dec 12 1998 Mark A. Spencer <markster@marko.net>
- Update to new cheops with plugin support
* Wed Dec 9 1998 Mark A. Spencer <markster@marko.net>
- Remove setuid permissions from cheops
* Mon Dec 7 1998 Mark A. Spencer <markster@marko.net>
- Fix permissions problems and incorporate RPM fixes from Tom <x@4t2.com>
* Sun Dec 6 1998 Mark A. Spencer <markster@marko.net>
- Initial Release.


