/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <string.h>
#include <netdb.h>
#include "cheops.h"

#define FLAG_DOMAIN 1

void highlight_object(struct net_object *no, int type)
{
	switch(type) {
	case HIGHLIGHT_NORMAL:
#ifdef USE_CANVAS
		gnome_canvas_item_set(no->label, "fill_color", NULL, NULL);
		break;
	case HIGHLIGHT_SELECTED:
		gnome_canvas_item_set(no->label, "fill_color", "darkred", NULL);
		break;
#else
		gtk_widget_set_state(no->label, GTK_STATE_NORMAL);	
		break;
	case HIGHLIGHT_SELECTED:
		gtk_widget_set_state(no->label, GTK_STATE_SELECTED);
		break;
#endif	
	default:
	}
}

#ifdef USE_CANVAS
void move_object(struct net_object *no, double ofx, double ofy)
{
	gnome_canvas_item_move(no->icon, ofx, ofy);
	gnome_canvas_item_move(no->otherbox, ofx, ofy);
}
#else
void move_object(struct net_object *no, int ofx, int ofy)
{
	int newx = no->eventbox->allocation.x + ofx;
	int newy = no->eventbox->allocation.y + ofy;
	int targetx = (no->otherbox->allocation.width - no->eventbox->allocation.width)/2 + 1;
	if (newx < 0)
		newx = 0;
	if (newx < targetx)
		newx = targetx;
	if (newy < 0)
		newy = 0;
	gtk_widget_set_uposition(no->eventbox, newx, newy);
	check_label(no);
}
#endif

void select_page(struct net_page *np)
{
	/* Make this page the one which is currently selected */
	int x=0;
	while(current_page != np) 
		gtk_notebook_set_page(GTK_NOTEBOOK(main_window.notebook), x++);
		
}

void generic_setcursor(GdkWindow *window, int c)
{
	GdkCursor *cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(window, cursor);
	gdk_cursor_destroy(cursor);
	while (gtk_events_pending()) {
               gtk_main_iteration();
	}
}

void add_object(struct net_page *page, struct net_object *no)
{

	struct pcache *pc;
	pc = check_cache(page, no->ip_addr);
#ifdef USE_CANVAS
	gnome_canvas_item_raise_to_top(no->otherbox);
	gnome_canvas_item_raise_to_top(no->icon);
	if (pc) {
		place_object(no, pc->x, pc->y);
		if (pc->x + page->icon_width > page->canvas->allocation.width)
			gtk_widget_set_usize(page->canvas, pc->x + page->icon_width, 0);
		if (pc->y + page->icon_height > page->canvas->allocation.height)
			gtk_widget_set_usize(page->canvas, 0, pc->y + page->icon_height);
	} else {
		place_object(no, page->lastx, page->lasty);
		page->lastx += page->icon_width;
		if (page->lastx > (option_use_visible_area ? page->canvas->allocation.width : FIXED_WIDTH) - page->icon_width) {
			page->lastx = 20;
			page->lasty += page->icon_height;
			if (page->lasty + page->icon_height > page->canvas->allocation.height) {
				gtk_widget_set_usize(page->canvas, 0, page->canvas->allocation.height + page->icon_height);
			}
			
		}
	}
#else
	if (pc) {
		gtk_fixed_put(GTK_FIXED(page->fixed), no->eventbox, pc->x, pc->y);
		gtk_fixed_put(GTK_FIXED(page->fixed), no->otherbox, pc->x , pc->y + page->icon_height - 15);
		place_object(no, pc->x, pc->y);
		if (pc->y + page->icon_height > page->fixed->allocation.height)
			gtk_widget_set_usize(page->fixed, 0, pc->y + page->icon_height);
	} else {
		gtk_fixed_put(GTK_FIXED(page->fixed), no->eventbox, page->lastx, page->lasty);
		gtk_fixed_put(GTK_FIXED(page->fixed), no->otherbox, page->lastx + (no->eventbox->allocation.width - no->otherbox->allocation.width)/2 , page->lasty + page->icon_height - 15);
		place_object(no, page->lastx, page->lasty);
		page->lastx += page->icon_width;
		if (page->lastx > (option_use_visible_area ? page->pane->allocation.width : FIXED_WIDTH) - page->icon_width) {
			page->lastx = 20;
			page->lasty += page->icon_height;
			if (page->lasty + page->icon_height > page->eventbox->allocation.height) {
				gtk_widget_set_usize(page->eventbox, 0, page->fixed->allocation.height + page->icon_height);
			}
			
		}
	}
#endif
	add_to_list(page->list, no);
#ifndef USE_CANVAS
	gtk_widget_realize(no->eventbox);
	gtk_widget_realize(no->pixmap);
	gtk_widget_realize(no->otherbox);
	gtk_widget_realize(no->label);
#endif
	no->next = page->objs;
	page->objs = no;
#ifndef USE_CANVAS
	while(gtk_events_pending())
		gtk_main_iteration();
#endif
	check_connections(page, no);
	if (page->automap && option_automap && !no->mapped)
		start_mapping(no);
}

void shrink_pixmaps()
{
	struct net_object *no;
	if (current_page->small_icons)
		return;
	current_page->small_icons=2;
	current_page->icon_height /= 2;
	current_page->icon_width /= 2;
	no = current_page->objs;
	while(no) {
		set_icon(no, no->fn);
		check_label(no);
		check_links(no);
		no = no->next;
	}
}

static void unvisit_all(struct net_page *np)
{
	struct net_object *no;
	no = np->objs;
	while(no) {
		no->visited=0;
		no->count=0;
		no = no->next;
	};
}

static char *get_dom(char *s)
{
	char *s2=s;
	while(s2 && !get_server(s2, 0)) {
		s2 = strchr(s2, '.');
		if (s2)
			s2++;
	}
	if (!s2)
		s2=s;
	return s2;
}

void set_infobox(struct net_object *no)
{
	char buf[256];
	if (no) {
		snprintf(buf, sizeof(buf), "Name: %s\n", no->hostname);
		gtk_label_set(GTK_LABEL(main_window.namelabel), buf);
		snprintf(buf, sizeof(buf), "IP: %s\n", inet_ntoa(*(struct in_addr *)&no->ip_addr));
		gtk_label_set(GTK_LABEL(main_window.iplabel), buf);
		snprintf(buf, sizeof(buf), "OS: %s\n", no->os + 2);
		gtk_label_set(GTK_LABEL(main_window.oslabel), buf);
#ifdef SNMP
		snprintf(buf, sizeof(buf), "SNMP: %s\n", no->hassnmp ? "Yes" : "no");
		gtk_label_set(GTK_LABEL(main_window.snmplabel), buf);
#endif
	} else {
		gtk_label_set(GTK_LABEL(main_window.namelabel), "Name:");
		gtk_label_set(GTK_LABEL(main_window.iplabel), "IP:");
		gtk_label_set(GTK_LABEL(main_window.oslabel), "OS:");
#ifdef SNMP
		gtk_label_set(GTK_LABEL(main_window.snmplabel), "SNMP:");
#endif
	}
}

void check_label(struct net_object *no)
{
	struct net_page *np;
#ifdef USE_CANVAS
	double x1, y1, x2, y2, newx;
#endif
	np = no->np;
#ifdef USE_CANVAS
	gnome_canvas_item_get_bounds(no->otherbox, &x1, &y1, &x2, &y2);
	newx = -(x2 - x1)/2;
	gnome_canvas_item_get_bounds(no->icon, &x1, &y1, &x2, &y2);
	newx += (x1 + (x2 - x1)/2);
	gnome_canvas_item_set(no->otherbox, "x", newx, "y", (double)(y1 + np->icon_height - 25/(np->small_icons ? np->small_icons : 1)), NULL);
#else
	gtk_widget_set_uposition(no->otherbox, 
		no->eventbox->allocation.x + (no->eventbox->allocation.width - no->otherbox->allocation.width)/2, no->eventbox->allocation.y + np->icon_height - 15);
#endif
}

void check_links(struct net_object *no)
{
	struct link *l;
#ifdef USE_CANVAS
	double x1, y1, x2, y2;
	GnomeCanvasPoints *pnts;
#endif	
	l = no->links;
	while(l) {
		/* Check validity of other widget? */
#ifdef USE_CANVAS
		pnts = gnome_canvas_points_new(2);
		gnome_canvas_item_get_bounds(no->icon, &x1, &y1, &x2, &y2);
		pnts->coords[0] = x1 + (x2 - x1)/2;
		pnts->coords[1] = y1 + (y2 - y1)/2;
		gnome_canvas_item_get_bounds(l->other->icon, &x1, &y1, &x2, &y2);
		pnts->coords[2] = x1 + (x2 - x1)/2;
		pnts->coords[3] = y1 + (y2 - y1)/2;
		gnome_canvas_item_set(l->linkw, "points", pnts, NULL);
#else
		gtk_link_set_coords(GTK_LINK(l->linkw),
				    no->eventbox->allocation.x + no->eventbox->allocation.width/2,
				    no->eventbox->allocation.y + no->eventbox->allocation.height/2,
				    l->other->eventbox->allocation.x + l->other->eventbox->allocation.width / 2,
				    l->other->eventbox->allocation.y + l->other->eventbox->allocation.height / 2);
#endif
			l=l->next;
	}
}

void place_object(struct net_object *no, int xp, int yp)
{
#ifdef USE_CANVAS
	gnome_canvas_item_set(no->icon, "x", (double)xp, "y", (double)yp, NULL);
#else
	gtk_widget_set_uposition(no->eventbox, xp, yp);
#endif

	check_links(no);
	check_label(no);
}

#if (GTK_MINOR_VERSION> 0) || (GTK_MAJOR_VERSION > 1)
static void move_row(GtkWidget *list, struct net_object *no, int row)
{
	struct net_object *no2;
	int id;
	no2 = (struct net_object *)gtk_clist_get_row_data(GTK_CLIST(list), row);
	if (no != no2) {
		id = no->id;
		no->id = no2->id;
		no2->id = id;
		gtk_clist_swap_rows(GTK_CLIST(list), no->id, no2->id);
	}
}
#endif

void add_to_list(GtkWidget *list, struct net_object *no)
{
	char *argv[4];
	char *c, *cd;
	struct in_addr ia;
	struct pixmap_cache_r *tmp;
	argv[0]=no->hostname;
	ia.s_addr = no->ip_addr;
	argv[1]=inet_ntoa(ia);
	argv[2]=no->os + 2;
	argv[3]=print_aliases(no, ' ');
	gtk_clist_freeze(GTK_CLIST(list));
	no->id=gtk_clist_append(GTK_CLIST(list), argv);
	gtk_clist_set_row_data(GTK_CLIST(list), no->id, no);
	gtk_clist_get_text(GTK_CLIST(list), no->id, 0, &c);
	cd = strdup(c);
	tmp = get_pixmap_r(get_pm_name(no->fn, "-tiny.xpm"));
	gtk_clist_set_pixtext(GTK_CLIST(list), no->id, 0, cd, 4, tmp->pixmap, tmp->mask);
	gtk_clist_thaw(GTK_CLIST(list));
	free(cd);
	
}

static void place(struct net_object **nos, int cnt, struct net_page *np, int flags)
{
	int x;
	int xp, yp;
	char *last=NULL;
	struct in_addr ia;
	xp = 20;
	yp = 20;
	gtk_clist_freeze(GTK_CLIST(np->list));
#if !(GTK_MINOR_VERSION > 0)
	gtk_clist_clear(GTK_CLIST(np->list));
#endif
	for (x=0;x<cnt;x++) {
		if (!gtk_notebook_current_page(GTK_NOTEBOOK(np->notebook))) {
			if (flags & FLAG_DOMAIN) {
				ia.s_addr = nos[x]->ip_addr;
				if (strcasecmp(nos[x]->hostname, inet_ntoa(ia))) {
					if (last) {
						if (strcasecmp(last, get_dom(nos[x]->hostname)) && (xp != 20)) {
							xp = 20;
							yp += np->icon_height;
							if (yp + np->icon_height > np->eventbox->allocation.height) {
								gtk_widget_set_usize(np->eventbox, 0, 
									np->eventbox->allocation.height + np->icon_height);
							}
						}
					}
					last = get_dom(nos[x]->hostname);
				} else last="";
			}
			place_object(nos[x], xp, yp);
			xp += np->icon_width;
			if (xp > (option_use_visible_area ? np->pane->allocation.width : FIXED_WIDTH) - np->icon_width) {
				xp = 20;
				yp += np->icon_height;
				if (yp + np->icon_height > np->eventbox->allocation.height) {
					gtk_widget_set_usize(np->eventbox, 0, np->eventbox->allocation.height + np->icon_height);
				}
				
			}
		} else 
#if (GTK_MINOR_VERSION > 0)
			move_row(np->list, nos[x], x);
#else 
			add_to_list(np->list, nos[x]);
#endif
			
	}
	np->lastx = xp;
	np->lasty = yp;
	gtk_widget_queue_draw(np->list);
	gtk_clist_thaw(GTK_CLIST(np->list));
}

static int compare_ip(const void *a_d, const void *b_d)
{
	struct net_object **a, **b;
	unsigned int aa, ab;
	a = (struct net_object **)a_d;
	b = (struct net_object **)b_d;
	aa=ntohl((*a)->ip_addr);
	ab=ntohl((*b)->ip_addr);
	if (aa<ab) return -1; else
	if (aa>ab) return 1; else
	return 0;
}

static int compare_os(const void *a_d, const void *b_d)
{
	int res;
	struct net_object **a, **b;
	a = (struct net_object **)a_d;
	b = (struct net_object **)b_d;
	res = strcasecmp((*a)->fn, (*b)->fn);
	if (!res)
		res = strcasecmp((*a)->hostname, (*b)->hostname);
	return res;
}

static int compare_name(const void *a_d, const void *b_d)
{
	struct net_object **a, **b;
	a = (struct net_object **)a_d;
	b = (struct net_object **)b_d;
	return strcasecmp((*a)->hostname, (*b)->hostname);
}

static int compare_domain(const void *a_d, const void *b_d)
{
	struct net_object **a, **b;
	int res;
	struct in_addr ia;
	char *da, *db;
	a = (struct net_object **)a_d;
	b = (struct net_object **)b_d;
	ia.s_addr = (*a)->ip_addr;
	if (!strcmp((*a)->hostname, inet_ntoa(ia))) 
		return strcasecmp((*a)->hostname, (*b)->hostname);
	ia.s_addr = (*b)->ip_addr;
	if (!strcmp((*b)->hostname, inet_ntoa(ia))) 
		return strcasecmp((*a)->hostname, (*b)->hostname);
	da = get_dom((*a)->hostname);
	db = get_dom((*b)->hostname);
	res = strcasecmp(da, db);
	if (!res)
		res = strcasecmp((*a)->hostname, (*b)->hostname);
	return res;
}


static void map_layout(struct net_page *np)
{
	/* Umm... ideas? */
	printf("Would somebody please write me a map layout routine?\n");
	unvisit_all(np);
}

void arrange(struct net_page *np, int how)
{
	int cnt=0;
	int x=0;
	struct net_object *no;
	struct net_object **sorter;
	immediate_setcursor(GDK_WATCH);
	for (no = np->objs; no; no=no->next)
		cnt++;
	if (!cnt)
		return;
	sorter = g_new0(struct net_object *, cnt);
	for (no = np->objs; no; no=no->next) {
		sorter[x]=no;
		x++;
	}
	switch(how) {
	case BY_OS:
		qsort(sorter, cnt, sizeof(struct net_object *), compare_os);
		place(sorter, cnt, np, 0);
		break;
	case BY_NAME:
		qsort(sorter, cnt, sizeof(struct net_object *), compare_name);
		place(sorter, cnt, np, 0);
		break;
	case BY_ADDR:
		qsort(sorter, cnt, sizeof(struct net_object *), compare_ip);
		place(sorter, cnt, np, 0);
		break;
	case BY_DOMAIN:
		qsort(sorter, cnt, sizeof(struct net_object *), compare_domain);
		place(sorter, cnt, np, FLAG_DOMAIN);
		break;
	case BY_MAP:
		map_layout(np);
		break;
	default:
		fprintf(stderr, "Don't know how to arrange by %d\n", how);
	}
	g_free(sorter);
	gdk_window_set_cursor(main_window.window->window, NULL);
}

void set_icon(struct net_object *no, char *filename)
{
	/* Sets icon and mini-icon to specified filename */
	struct pixmap_cache_r *tmp;
#ifdef USE_CANVAS	
	GdkImlibImage *im;
#else
	struct pixmap_cache *pix;
#endif
	struct net_page *np;
	char *c, *cd;
	np = no->np;
#ifdef USE_CANVAS
	if (np->small_icons) {
		im = gdk_imlib_load_image(find_file(get_pm_name(filename, "-small.xpm")));
	} else {
		im = gdk_imlib_load_image(find_file(filename));
	}
	gnome_canvas_item_set(no->icon, "image", im, "width", (double)im->rgb_width, "height", (double)im->rgb_height, NULL);
#else
	if (np->small_icons) {
		pix = get_pixmap(get_pm_name(filename, "-small.xpm"));
	} else {
		pix = get_pixmap(filename);
	}
	if (no->pixmap) {
		gtk_pixmap_set(GTK_PIXMAP(no->pixmap), pix->pixmap, pix->mask);
	} else {
		no->pixmap = gtk_pixmap_new (pix->pixmap, pix->mask);
		gtk_container_add(GTK_CONTAINER(no->eventbox), no->pixmap);
		gtk_widget_show(no->pixmap);
	}
	gtk_widget_shape_combine_mask (no->eventbox, pix->mask, 0,0);
#endif
	tmp = get_pixmap_r(get_pm_name(filename, "-tiny.xpm"));

	if (!gtk_clist_get_text(GTK_CLIST(np->list), no->id, 0, &c))
		return;
	if (c) {
		cd = strdup(c);
		gtk_clist_set_pixtext(GTK_CLIST(np->list), no->id, 0, cd, 4, tmp->pixmap, tmp->mask);
		free(cd);
	}

}

