/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <string.h>
#include <cherokee/cherokee.h>

#define ERROR       1
#define WATCH_SLEEP 1000

int 
main (int argc, char *argv[]) 
{
	ret_t              ret;
	cuint_t            fds_num;

	cherokee_boolean_t       exit;
	cherokee_fdpoll_t       *fdpoll;
	cherokee_admin_client_t *client;
	cherokee_buffer_t        config;
	cherokee_buffer_t        url;

	if (argc <= 2) {
		PRINT_ERROR ("%s url \"config\"\n", argv[0]);
		return 1;
	}

	/* Build everyhing
	 */
	cherokee_sys_fdlimit_get (&fds_num);

	ret = cherokee_fdpoll_best_new (&fdpoll, fds_num, fds_num);
	if (ret != ret_ok) return ERROR;
	   
	ret = cherokee_admin_client_new (&client);
	if (ret != ret_ok) return ERROR;

	ret = cherokee_admin_client_set_fdpoll (client, fdpoll);
	if (ret != ret_ok) return ERROR;

	/* Set the request
	 */
	cherokee_buffer_init (&url);
	cherokee_buffer_add (&url, argv[1], strlen(argv[1]));
	cherokee_admin_client_set_url (client, &url);

	cherokee_buffer_init (&config);
	cherokee_buffer_add (&config, argv[2], strlen(argv[2]));
	cherokee_admin_client_add_raw (client, &config);

	ret = cherokee_admin_client_prepare (client);
	if (ret != ret_ok) {
		printf ("Client prepare failed\n");
		return ERROR;
	}

	for (exit = false; exit == false;) {
		int re;

		re = cherokee_fdpoll_watch (fdpoll, WATCH_SLEEP);
		if (re <= 0) continue;

		ret = cherokee_admin_client_step (client);
		switch (ret) {
		case ret_eof:
		case ret_error:
			exit = true;
			break;
		case ret_ok:
		case ret_eagain:
			break;
		default:
			RET_UNKNOWN(ret);			
		}
	}

	/* Clean up
	 */
	if (fdpoll != NULL)
		cherokee_fdpoll_free (fdpoll);
	
	if (client != NULL)
		cherokee_admin_client_free (client);

	cherokee_buffer_mrproper (&config);

	return 0;
}
