/* dgram - Tcl extension for udp datagrams
 * Copyright 2006 Ian Jackson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


/* from sockaddr.c */

typedef struct {
  Byte *begin, *end;
} SockAddr_Value;

extern Tcl_ObjType sockaddr_type;

void sockaddr_clear(SockAddr_Value*);
void sockaddr_create(SockAddr_Value*, const struct sockaddr *addr, int len);
int sockaddr_len(const SockAddr_Value*);
const struct sockaddr *sockaddr_addr(const SockAddr_Value*);
void sockaddr_free(const SockAddr_Value*);

/* from dgram.c */

extern const IdDataSpec dgram_socks;

/* from misc.c */

int setnonblock(int fd, int isnonblock);

