/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2008-09-23 22:56
   Version 3.3.0 - linux-unix-gnu-x86	[ manyargs dload ptables applyhook ]
   SVN rev. 11106	compiled 2008-07-08 on galinha (Linux)
   command line: posixunix.scm -quiet -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -unsafe -no-lambda-info -output-file uposixunix.c
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>
#include <math.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)
#define C_isdir             ((C_statbuf.st_mode & S_IFMT) == S_IFDIR)
#define C_ischr             ((C_statbuf.st_mode & S_IFMT) == S_IFCHR)
#define C_isblk             ((C_statbuf.st_mode & S_IFMT) == S_IFBLK)
#define C_isfifo            ((C_statbuf.st_mode & S_IFMT) == S_IFIFO)
#ifdef S_IFSOCK
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == S_IFSOCK)
#else
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == 0140000)
#endif

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set_9(v) \
        (C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)))

#define C_tm_get_08(v) \
        (C_set_block_item(v, 0, C_fix(C_tm.tm_sec)), \
        C_set_block_item(v, 1, C_fix(C_tm.tm_min)), \
        C_set_block_item(v, 2, C_fix(C_tm.tm_hour)), \
        C_set_block_item(v, 3, C_fix(C_tm.tm_mday)), \
        C_set_block_item(v, 4, C_fix(C_tm.tm_mon)), \
        C_set_block_item(v, 5, C_fix(C_tm.tm_year)), \
        C_set_block_item(v, 6, C_fix(C_tm.tm_wday)), \
        C_set_block_item(v, 7, C_fix(C_tm.tm_yday)), \
        C_set_block_item(v, 8, (C_tm.tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define C_tm_get_9(v) \
        (C_set_block_item(v, 9, C_fix(C_tm.tm_gmtoff)))

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  return v;
}

#else

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  C_tm_set_9 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  C_tm_get_9 (v);
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)
#define C_timegm(v)     ((C_temporary_flonum = timegm(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[473];
static double C_possibly_force_alignment;


/* from k7239 in set-root-directory! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1393(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1393(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from sleep in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1166(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1166(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1163(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1163(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1161(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1161(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub1092(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1092(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k6194 */
static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub1080(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1080(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k6186 */
static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f_6171 in k6165 in process-fork in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1061(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1061(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub1056(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1056(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1016(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1016(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);else return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k5983 */
static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from ttyname */
static C_word C_fcall stub992(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub992(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub972(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub972(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub967(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub967(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub962(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub962(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub916(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub916(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub907(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub907(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k5553 */
static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k5495 */
static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub845(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub845(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4196 in k4192 in file-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k3916 in initialize-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from _ensure-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub482(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_ret:
#undef return

return C_r;}

/* from _get-groups */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub478(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub478(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

/* from group-member */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub461(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub461(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a7285 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub448(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub448(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a7303 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub446(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub446(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a7306 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub440(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub440(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a7324 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub438(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub438(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from fd_test in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub81(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub81(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from fcntl */
static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from ##sys#file-select-one in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub17(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub17(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

/* from ##sys#file-nonblocking! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub13(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub13(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from strerror */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1656)
static void C_ccall f_1656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1659)
static void C_ccall f_1659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1662)
static void C_ccall f_1662(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1665)
static void C_ccall f_1665(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1668)
static void C_ccall f_1668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1671)
static void C_ccall f_1671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7334)
static void C_ccall f_7334(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7350)
static void C_ccall f_7350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7338)
static void C_ccall f_7338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7341)
static void C_ccall f_7341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2382)
static void C_ccall f_2382(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3400)
static void C_ccall f_3400(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7328)
static void C_ccall f_7328(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3535)
static void C_ccall f_3535(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7325)
static void C_ccall f_7325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3592)
static void C_ccall f_3592(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7310)
static void C_ccall f_7310(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7320)
static void C_ccall f_7320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7307)
static void C_ccall f_7307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3596)
static void C_ccall f_3596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7304)
static void C_ccall f_7304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3615)
static void C_ccall f_3615(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7289)
static void C_ccall f_7289(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7299)
static void C_ccall f_7299(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7286)
static void C_ccall f_7286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3619)
static void C_ccall f_3619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7268)
static void C_ccall f_7268(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7281)
static void C_ccall f_7281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7275)
static void C_ccall f_7275(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4123)
static void C_ccall f_4123(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4162)
static void C_ccall f_4162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7245)
static void C_ccall f_7245(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7241)
static void C_ccall f_7241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6987)
static void C_ccall f_6987(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6987)
static void C_ccall f_6987r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7170)
static void C_fcall f_7170(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7176)
static void C_ccall f_7176(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7165)
static void C_fcall f_7165(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7160)
static void C_fcall f_7160(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6989)
static void C_fcall f_6989(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7147)
static void C_ccall f_7147(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7155)
static void C_ccall f_7155(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6996)
static void C_fcall f_6996(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7135)
static void C_ccall f_7135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7129)
static void C_ccall f_7129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7006)
static void C_ccall f_7006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7008)
static void C_fcall f_7008(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7027)
static void C_ccall f_7027(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7115)
static void C_ccall f_7115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7122)
static void C_ccall f_7122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7109)
static void C_ccall f_7109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7042)
static void C_ccall f_7042(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7102)
static void C_ccall f_7102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7099)
static void C_ccall f_7099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7086)
static void C_ccall f_7086(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7062)
static void C_ccall f_7062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7084)
static void C_ccall f_7084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7070)
static void C_ccall f_7070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7077)
static void C_ccall f_7077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7074)
static void C_ccall f_7074(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7054)
static void C_ccall f_7054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7052)
static void C_ccall f_7052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7136)
static void C_ccall f_7136(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6930)
static void C_ccall f_6930(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6930)
static void C_ccall f_6930r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6942)
static void C_fcall f_6942(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6937)
static void C_fcall f_6937(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6932)
static void C_fcall f_6932(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6873)
static void C_ccall f_6873(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6873)
static void C_ccall f_6873r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6885)
static void C_fcall f_6885(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6880)
static void C_fcall f_6880(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6875)
static void C_fcall f_6875(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6812)
static void C_fcall f_6812(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6867)
static void C_ccall f_6867(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6871)
static void C_ccall f_6871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6833)
static void C_ccall f_6833(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6836)
static void C_ccall f_6836(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6847)
static void C_ccall f_6847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6841)
static void C_ccall f_6841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6814)
static void C_fcall f_6814(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6823)
static void C_ccall f_6823(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6748)
static void C_ccall f_6748(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_6760)
static void C_ccall f_6760(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6791)
static void C_ccall f_6791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6771)
static void C_ccall f_6771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6787)
static void C_ccall f_6787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6775)
static void C_ccall f_6775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6783)
static void C_ccall f_6783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6779)
static void C_ccall f_6779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6754)
static void C_ccall f_6754(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6737)
static void C_fcall f_6737(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6741)
static void C_ccall f_6741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6726)
static void C_fcall f_6726(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6730)
static void C_ccall f_6730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6681)
static void C_fcall f_6681(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6685)
static void C_ccall f_6685(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6688)
static void C_ccall f_6688(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6691)
static void C_ccall f_6691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6704)
static void C_ccall f_6704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6708)
static void C_ccall f_6708(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6711)
static void C_ccall f_6711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6714)
static void C_ccall f_6714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6702)
static void C_ccall f_6702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6665)
static C_word C_fcall f_6665(C_word *a,C_word t0);
C_noret_decl(f_6648)
static void C_fcall f_6648(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6661)
static void C_ccall f_6661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6573)
static void C_ccall f_6573(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6634)
static void C_fcall f_6634(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6647)
static void C_ccall f_6647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6614)
static void C_fcall f_6614(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6629)
static void C_ccall f_6629(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6623)
static void C_ccall f_6623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6577)
static void C_fcall f_6577(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6579)
static void C_ccall f_6579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6600)
static void C_ccall f_6600(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6594)
static void C_ccall f_6594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6521)
static void C_ccall f_6521(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6521)
static void C_ccall f_6521r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6528)
static void C_ccall f_6528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6547)
static void C_ccall f_6547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6551)
static void C_ccall f_6551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6515)
static void C_ccall f_6515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6506)
static void C_ccall f_6506(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6510)
static void C_ccall f_6510(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6479)
static void C_ccall f_6479(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6479)
static void C_ccall f_6479r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6476)
static void C_ccall f_6476(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6473)
static void C_ccall f_6473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6470)
static void C_ccall f_6470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6395)
static void C_ccall f_6395(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6395)
static void C_ccall f_6395r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6428)
static void C_ccall f_6428(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6422)
static void C_ccall f_6422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6378)
static void C_ccall f_6378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6199)
static void C_ccall f_6199(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6199)
static void C_ccall f_6199r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6333)
static void C_fcall f_6333(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6328)
static void C_fcall f_6328(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6201)
static void C_fcall f_6201(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6211)
static void C_ccall f_6211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6219)
static void C_fcall f_6219(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6265)
static C_word C_fcall f_6265(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6232)
static void C_fcall f_6232(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6257)
static void C_ccall f_6257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6235)
static void C_ccall f_6235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6191)
static C_word C_fcall f_6191(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6183)
static C_word C_fcall f_6183(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6145)
static void C_ccall f_6145(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6145)
static void C_ccall f_6145r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6167)
static void C_ccall f_6167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6171)
static void C_ccall f_6171(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6033)
static void C_ccall f_6033(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6033)
static void C_ccall f_6033r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6039)
static void C_fcall f_6039(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6060)
static void C_ccall f_6060(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6137)
static void C_ccall f_6137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6064)
static void C_ccall f_6064(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6067)
static void C_ccall f_6067(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6070)
static void C_ccall f_6070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6077)
static void C_ccall f_6077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6079)
static void C_fcall f_6079(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6096)
static void C_ccall f_6096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6106)
static void C_ccall f_6106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6110)
static void C_ccall f_6110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6054)
static void C_ccall f_6054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6021)
static void C_ccall f_6021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6025)
static void C_ccall f_6025(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6028)
static void C_ccall f_6028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5986)
static void C_ccall f_5986(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5990)
static void C_ccall f_5990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6010)
static void C_ccall f_6010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6014)
static void C_ccall f_6014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5967)
static void C_ccall f_5967(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5971)
static void C_ccall f_5971(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5940)
static void C_fcall f_5940(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5944)
static void C_ccall f_5944(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5921)
static void C_ccall f_5921(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5925)
static void C_ccall f_5925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5928)
static void C_ccall f_5928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5862)
static void C_ccall f_5862(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5862)
static void C_ccall f_5862r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5866)
static void C_ccall f_5866(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5872)
static void C_ccall f_5872(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5859)
static void C_ccall f_5859(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5843)
static void C_ccall f_5843(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5843)
static void C_ccall f_5843r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5835)
static void C_ccall f_5835(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5807)
static void C_ccall f_5807(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5814)
static void C_ccall f_5814(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5779)
static void C_ccall f_5779(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5786)
static void C_ccall f_5786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5740)
static void C_ccall f_5740(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5740)
static void C_ccall f_5740r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5757)
static void C_ccall f_5757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5761)
static void C_ccall f_5761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5665)
static void C_ccall f_5665(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5665)
static void C_ccall f_5665r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5675)
static void C_ccall f_5675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5697)
static void C_ccall f_5697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5694)
static void C_ccall f_5694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5684)
static void C_ccall f_5684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5632)
static void C_ccall f_5632(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5636)
static void C_ccall f_5636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5618)
static void C_ccall f_5618(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5609)
static void C_ccall f_5609(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5603)
static void C_ccall f_5603(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5594)
static void C_ccall f_5594(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5501)
static void C_ccall f_5501(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_5501)
static void C_ccall f_5501r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_5505)
static void C_ccall f_5505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5511)
static void C_ccall f_5511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5530)
static void C_ccall f_5530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5517)
static void C_ccall f_5517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5418)
static void C_ccall f_5418(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5424)
static void C_fcall f_5424(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5428)
static void C_ccall f_5428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5436)
static void C_fcall f_5436(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5454)
static void C_ccall f_5454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5403)
static void C_ccall f_5403(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5411)
static void C_ccall f_5411(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5386)
static void C_ccall f_5386(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5397)
static void C_ccall f_5397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5401)
static void C_ccall f_5401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5360)
static void C_ccall f_5360(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5384)
static void C_ccall f_5384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5367)
static void C_ccall f_5367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5317)
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5317)
static void C_ccall f_5317r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5324)
static void C_fcall f_5324(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5345)
static void C_ccall f_5345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5341)
static void C_ccall f_5341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5289)
static void C_ccall f_5289(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5267)
static void C_ccall f_5267(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5267)
static void C_ccall f_5267r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5271)
static void C_ccall f_5271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5256)
static void C_ccall f_5256(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5237)
static void C_ccall f_5237(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5237)
static void C_ccall f_5237r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5241)
static void C_ccall f_5241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5219)
static void C_fcall f_5219(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5148)
static void C_fcall f_5148(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5167)
static void C_ccall f_5167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5173)
static void C_fcall f_5173(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5109)
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5137)
static void C_ccall f_5137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5133)
static void C_ccall f_5133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5126)
static void C_ccall f_5126(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4853)
static void C_ccall f_4853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4853)
static void C_ccall f_4853r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5049)
static void C_fcall f_5049(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5044)
static void C_fcall f_5044(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5039)
static void C_fcall f_5039(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4855)
static void C_fcall f_4855(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4859)
static void C_ccall f_4859(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4965)
static void C_ccall f_4965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4966)
static void C_ccall f_4966(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4983)
static void C_fcall f_4983(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4993)
static void C_ccall f_4993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4951)
static void C_ccall f_4951(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4907)
static void C_fcall f_4907(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4943)
static void C_ccall f_4943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4922)
static void C_ccall f_4922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4932)
static void C_ccall f_4932(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4916)
static void C_ccall f_4916(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4911)
static void C_ccall f_4911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4914)
static void C_ccall f_4914(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4861)
static void C_fcall f_4861(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4896)
static void C_ccall f_4896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4877)
static void C_ccall f_4877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4382)
static void C_ccall f_4382(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4382)
static void C_ccall f_4382r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_4778)
static void C_fcall f_4778(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4773)
static void C_fcall f_4773(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4768)
static void C_fcall f_4768(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4763)
static void C_fcall f_4763(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4384)
static void C_fcall f_4384(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4388)
static void C_ccall f_4388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4394)
static void C_ccall f_4394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4636)
static void C_ccall f_4636(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4642)
static void C_fcall f_4642(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4738)
static void C_ccall f_4738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4728)
static void C_ccall f_4728(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4722)
static void C_ccall f_4722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4644)
static void C_ccall f_4644(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4694)
static void C_ccall f_4694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4651)
static void C_ccall f_4651(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4661)
static void C_ccall f_4661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4560)
static void C_ccall f_4560(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4568)
static void C_fcall f_4568(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4570)
static void C_fcall f_4570(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4618)
static void C_ccall f_4618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4551)
static void C_ccall f_4551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4555)
static void C_ccall f_4555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4530)
static void C_ccall f_4530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4540)
static void C_ccall f_4540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4518)
static void C_ccall f_4518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4505)
static void C_ccall f_4505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4509)
static void C_ccall f_4509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4500)
static void C_ccall f_4500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4503)
static void C_ccall f_4503(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4418)
static void C_fcall f_4418(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4430)
static void C_fcall f_4430(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4467)
static void C_ccall f_4467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4476)
static void C_ccall f_4476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4470)
static void C_ccall f_4470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4446)
static void C_ccall f_4446(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4449)
static void C_ccall f_4449(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4410)
static C_word C_fcall f_4410(C_word t0);
C_noret_decl(f_4395)
static void C_fcall f_4395(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4409)
static void C_ccall f_4409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4355)
static void C_ccall f_4355(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4355)
static void C_ccall f_4355r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4362)
static void C_fcall f_4362(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4365)
static void C_ccall f_4365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4310)
static void C_ccall f_4310(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4314)
static void C_ccall f_4314(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4349)
static void C_ccall f_4349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4332)
static void C_ccall f_4332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4296)
static void C_ccall f_4296(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4296)
static void C_ccall f_4296r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4308)
static void C_ccall f_4308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4267)
static void C_fcall f_4267(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4280)
static void C_ccall f_4280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4230)
static void C_fcall f_4230(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4238)
static void C_ccall f_4238(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4205)
static void C_ccall f_4205(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4194)
static void C_ccall f_4194(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4198)
static void C_ccall f_4198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4163)
static void C_ccall f_4163(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4187)
static void C_ccall f_4187(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4171)
static void C_ccall f_4171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4174)
static void C_ccall f_4174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4125)
static void C_ccall f_4125(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4146)
static void C_ccall f_4146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4154)
static void C_ccall f_4154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4150)
static void C_ccall f_4150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4116)
static void C_ccall f_4116(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4085)
static void C_ccall f_4085(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4089)
static void C_ccall f_4089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4079)
static void C_ccall f_4079(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4073)
static void C_ccall f_4073(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4067)
static void C_ccall f_4067(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4043)
static void C_fcall f_4043(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4065)
static void C_ccall f_4065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4053)
static void C_ccall f_4053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4013)
static void C_ccall f_4013(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3986)
static void C_ccall f_3986(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4011)
static void C_ccall f_4011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4007)
static void C_ccall f_4007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3922)
static void C_ccall f_3922(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3918)
static void C_ccall f_3918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3938)
static void C_ccall f_3938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3856)
static void C_ccall f_3856(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3860)
static void C_ccall f_3860(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3865)
static void C_fcall f_3865(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3881)
static void C_ccall f_3881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3851)
static void C_ccall f_3851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3797)
static void C_ccall f_3797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3800)
static void C_ccall f_3800(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3832)
static void C_ccall f_3832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3803)
static void C_ccall f_3803(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3808)
static void C_fcall f_3808(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3822)
static void C_ccall f_3822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3790)
static C_word C_fcall f_3790(C_word t0);
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3773)
static void C_ccall f_3773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3722)
static void C_fcall f_3722(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3732)
static void C_ccall f_3732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3736)
static void C_ccall f_3736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3745)
static void C_fcall f_3745(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3749)
static void C_ccall f_3749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3759)
static void C_ccall f_3759(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3740)
static void C_ccall f_3740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3695)
static void C_ccall f_3695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3707)
static void C_ccall f_3707(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3703)
static void C_ccall f_3703(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3681)
static void C_ccall f_3681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3621)
static void C_ccall f_3621(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3621)
static void C_ccall f_3621r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3667)
static void C_ccall f_3667(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3628)
static void C_fcall f_3628(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3638)
static void C_ccall f_3638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3642)
static void C_ccall f_3642(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3650)
static void C_ccall f_3650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3654)
static void C_ccall f_3654(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3598)
static void C_ccall f_3598(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3608)
static void C_ccall f_3608(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3575)
static void C_ccall f_3575(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3537)
static void C_ccall f_3537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3570)
static void C_ccall f_3570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3541)
static void C_ccall f_3541(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3548)
static void C_ccall f_3548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3552)
static void C_ccall f_3552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3556)
static void C_ccall f_3556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3560)
static void C_ccall f_3560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3564)
static void C_ccall f_3564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3519)
static void C_ccall f_3519(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3504)
static void C_ccall f_3504(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3498)
static void C_ccall f_3498(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3466)
static void C_ccall f_3466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3472)
static void C_fcall f_3472(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3442)
static void C_ccall f_3442(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3460)
static void C_ccall f_3460(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3449)
static void C_ccall f_3449(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3424)
static void C_ccall f_3424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3434)
static void C_ccall f_3434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3411)
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3402)
static void C_ccall f_3402(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3355)
static void C_ccall f_3355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3359)
static void C_ccall f_3359(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3335)
static void C_ccall f_3335(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3335)
static void C_ccall f_3335r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3339)
static void C_ccall f_3339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3345)
static void C_ccall f_3345(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3345)
static void C_ccall f_3345r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3349)
static void C_ccall f_3349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3319)
static void C_ccall f_3319(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3325)
static void C_ccall f_3325(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3325)
static void C_ccall f_3325r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3329)
static void C_ccall f_3329(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3295)
static void C_ccall f_3295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3306)
static void C_ccall f_3306(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3306)
static void C_ccall f_3306r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3310)
static void C_ccall f_3310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3300)
static void C_ccall f_3300(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3271)
static void C_ccall f_3271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3286)
static void C_ccall f_3286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3251)
static void C_ccall f_3251(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3258)
static void C_ccall f_3258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3215)
static void C_ccall f_3215(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3215)
static void C_ccall f_3215r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3236)
static void C_ccall f_3236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3179)
static void C_ccall f_3179(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3179)
static void C_ccall f_3179r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3210)
static void C_ccall f_3210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3200)
static void C_ccall f_3200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3164)
static void C_fcall f_3164(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3177)
static void C_ccall f_3177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3158)
static void C_fcall f_3158(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3146)
static C_word C_fcall f_3146(C_word t0);
C_noret_decl(f_2829)
static void C_ccall f_2829(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3136)
static void C_ccall f_3136(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2956)
static void C_fcall f_2956(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3122)
static void C_ccall f_3122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3111)
static void C_ccall f_3111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2975)
static void C_fcall f_2975(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3104)
static void C_ccall f_3104(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3083)
static void C_ccall f_3083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3100)
static void C_ccall f_3100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3089)
static void C_ccall f_3089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3096)
static void C_ccall f_3096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3019)
static void C_fcall f_3019(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3080)
static void C_ccall f_3080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3059)
static void C_ccall f_3059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3072)
static void C_ccall f_3072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3032)
static void C_ccall f_3032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3056)
static void C_ccall f_3056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3052)
static void C_ccall f_3052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3013)
static void C_ccall f_3013(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2982)
static void C_ccall f_2982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2985)
static void C_ccall f_2985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2989)
static void C_ccall f_2989(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2969)
static void C_ccall f_2969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2950)
static void C_ccall f_2950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2836)
static void C_ccall f_2836(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2845)
static void C_fcall f_2845(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2852)
static void C_ccall f_2852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2916)
static void C_ccall f_2916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2925)
static void C_ccall f_2925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2913)
static void C_fcall f_2913(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2858)
static void C_ccall f_2858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2894)
static void C_ccall f_2894(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2886)
static void C_ccall f_2886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2875)
static void C_ccall f_2875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2871)
static void C_ccall f_2871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2773)
static void C_fcall f_2773(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2782)
static void C_ccall f_2782(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2806)
static void C_ccall f_2806(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2818)
static void C_ccall f_2818(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2818)
static void C_ccall f_2818r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2824)
static void C_ccall f_2824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2812)
static void C_ccall f_2812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2788)
static void C_ccall f_2788(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2794)
static void C_ccall f_2794(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2780)
static void C_ccall f_2780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2762)
static C_word C_fcall f_2762(C_word t0);
C_noret_decl(f_2757)
static void C_fcall f_2757(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2716)
static void C_ccall f_2716(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2716)
static void C_ccall f_2716r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2729)
static void C_ccall f_2729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2693)
static void C_ccall f_2693(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2714)
static void C_ccall f_2714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2700)
static void C_ccall f_2700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2644)
static void C_fcall f_2644(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2652)
static void C_ccall f_2652(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2639)
static void C_fcall f_2639(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2541)
static void C_fcall f_2541(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2548)
static void C_ccall f_2548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2551)
static void C_ccall f_2551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2638)
static void C_ccall f_2638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2558)
static void C_ccall f_2558(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2572)
static void C_fcall f_2572(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2582)
static void C_ccall f_2582(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2588)
static void C_ccall f_2588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2594)
static void C_fcall f_2594(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2604)
static void C_ccall f_2604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2515)
static void C_ccall f_2515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2537)
static void C_ccall f_2537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2533)
static void C_ccall f_2533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2491)
static void C_ccall f_2491(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2509)
static void C_ccall f_2509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2463)
static void C_ccall f_2463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2477)
static void C_ccall f_2477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2403)
static void C_ccall f_2403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2460)
static void C_ccall f_2460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2408)
static void C_ccall f_2408(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2413)
static void C_ccall f_2413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2436)
static void C_ccall f_2436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2456)
static void C_ccall f_2456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2419)
static void C_ccall f_2419(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2433)
static void C_ccall f_2433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2322)
static void C_ccall f_2322(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2322)
static void C_ccall f_2322r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2335)
static void C_ccall f_2335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2347)
static void C_ccall f_2347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2341)
static void C_ccall f_2341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2313)
static void C_ccall f_2313(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2320)
static void C_ccall f_2320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2304)
static void C_ccall f_2304(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2311)
static void C_ccall f_2311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2295)
static void C_ccall f_2295(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2302)
static void C_ccall f_2302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2286)
static void C_ccall f_2286(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2293)
static void C_ccall f_2293(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2277)
static void C_ccall f_2277(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2284)
static void C_ccall f_2284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2268)
static void C_ccall f_2268(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2275)
static void C_ccall f_2275(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2259)
static void C_ccall f_2259(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2266)
static void C_ccall f_2266(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2250)
static void C_ccall f_2250(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2257)
static void C_ccall f_2257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2241)
static void C_ccall f_2241(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2248)
static void C_ccall f_2248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2235)
static void C_ccall f_2235(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2239)
static void C_ccall f_2239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2229)
static void C_ccall f_2229(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2233)
static void C_ccall f_2233(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2223)
static void C_ccall f_2223(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2217)
static void C_ccall f_2217(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2221)
static void C_ccall f_2221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2215)
static void C_ccall f_2215(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2205)
static void C_ccall f_2205(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2209)
static void C_ccall f_2209(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2180)
static void C_ccall f_2180(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2180)
static void C_ccall f_2180r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2184)
static void C_ccall f_2184(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2143)
static void C_fcall f_2143(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2175)
static void C_ccall f_2175(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2168)
static void C_ccall f_2168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2147)
static void C_ccall f_2147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1951)
static void C_ccall f_1951(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1951)
static void C_ccall f_1951r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2124)
static void C_ccall f_2124(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1967)
static void C_ccall f_1967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2098)
static void C_ccall f_2098(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1973)
static void C_ccall f_1973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1976)
static void C_fcall f_1976(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2058)
static void C_ccall f_2058(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2056)
static void C_ccall f_2056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2015)
static void C_fcall f_2015(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2033)
static void C_ccall f_2033(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2031)
static void C_ccall f_2031(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2019)
static void C_fcall f_2019(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1949)
static C_word C_fcall f_1949(C_word t0,C_word t1);
C_noret_decl(f_1947)
static C_word C_fcall f_1947(C_word t0,C_word t1);
C_noret_decl(f_1945)
static C_word C_fcall f_1945(C_word t0);
C_noret_decl(f_1913)
static void C_ccall f_1913(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1920)
static void C_ccall f_1920(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1926)
static void C_ccall f_1926(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1933)
static void C_ccall f_1933(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1874)
static void C_ccall f_1874(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1874)
static void C_ccall f_1874r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1881)
static void C_ccall f_1881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1890)
static void C_ccall f_1890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1832)
static void C_ccall f_1832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1832)
static void C_ccall f_1832r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1842)
static void C_ccall f_1842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1845)
static void C_ccall f_1845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1848)
static void C_ccall f_1848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1817)
static void C_ccall f_1817(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1779)
static void C_ccall f_1779(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1779)
static void C_ccall f_1779r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1809)
static void C_ccall f_1809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1796)
static void C_ccall f_1796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1799)
static void C_ccall f_1799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1740)
static void C_ccall f_1740(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1740)
static void C_ccall f_1740r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1699)
static void C_ccall f_1699(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1696)
static void C_ccall f_1696(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1682)
static void C_ccall f_1682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1693)
static void C_ccall f_1693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1689)
static void C_ccall f_1689(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_7170)
static void C_fcall trf_7170(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7170(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7170(t0,t1);}

C_noret_decl(trf_7165)
static void C_fcall trf_7165(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7165(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7165(t0,t1,t2);}

C_noret_decl(trf_7160)
static void C_fcall trf_7160(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7160(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7160(t0,t1,t2,t3);}

C_noret_decl(trf_6989)
static void C_fcall trf_6989(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6989(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6989(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6996)
static void C_fcall trf_6996(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6996(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6996(t0,t1);}

C_noret_decl(trf_7008)
static void C_fcall trf_7008(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7008(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7008(t0,t1,t2,t3);}

C_noret_decl(trf_6942)
static void C_fcall trf_6942(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6942(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6942(t0,t1);}

C_noret_decl(trf_6937)
static void C_fcall trf_6937(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6937(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6937(t0,t1,t2);}

C_noret_decl(trf_6932)
static void C_fcall trf_6932(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6932(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6932(t0,t1,t2,t3);}

C_noret_decl(trf_6885)
static void C_fcall trf_6885(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6885(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6885(t0,t1);}

C_noret_decl(trf_6880)
static void C_fcall trf_6880(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6880(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6880(t0,t1,t2);}

C_noret_decl(trf_6875)
static void C_fcall trf_6875(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6875(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6875(t0,t1,t2,t3);}

C_noret_decl(trf_6812)
static void C_fcall trf_6812(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6812(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_6812(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_6814)
static void C_fcall trf_6814(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6814(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6814(t0,t1,t2);}

C_noret_decl(trf_6737)
static void C_fcall trf_6737(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6737(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6737(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6726)
static void C_fcall trf_6726(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6726(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6726(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6681)
static void C_fcall trf_6681(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6681(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6681(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6648)
static void C_fcall trf_6648(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6648(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6648(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6634)
static void C_fcall trf_6634(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6634(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6634(t0,t1,t2,t3);}

C_noret_decl(trf_6614)
static void C_fcall trf_6614(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6614(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6614(t0,t1,t2);}

C_noret_decl(trf_6577)
static void C_fcall trf_6577(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6577(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6577(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6333)
static void C_fcall trf_6333(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6333(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6333(t0,t1);}

C_noret_decl(trf_6328)
static void C_fcall trf_6328(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6328(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6328(t0,t1,t2);}

C_noret_decl(trf_6201)
static void C_fcall trf_6201(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6201(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6201(t0,t1,t2,t3);}

C_noret_decl(trf_6219)
static void C_fcall trf_6219(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6219(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6219(t0,t1,t2,t3);}

C_noret_decl(trf_6232)
static void C_fcall trf_6232(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6232(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6232(t0,t1);}

C_noret_decl(trf_6039)
static void C_fcall trf_6039(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6039(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6039(t0,t1,t2);}

C_noret_decl(trf_6079)
static void C_fcall trf_6079(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6079(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6079(t0,t1,t2);}

C_noret_decl(trf_5940)
static void C_fcall trf_5940(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5940(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5940(t0,t1,t2);}

C_noret_decl(trf_5424)
static void C_fcall trf_5424(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5424(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5424(t0,t1,t2);}

C_noret_decl(trf_5436)
static void C_fcall trf_5436(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5436(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5436(t0,t1,t2);}

C_noret_decl(trf_5324)
static void C_fcall trf_5324(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5324(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5324(t0,t1);}

C_noret_decl(trf_5219)
static void C_fcall trf_5219(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5219(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5219(t0,t1,t2,t3);}

C_noret_decl(trf_5148)
static void C_fcall trf_5148(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5148(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5148(t0,t1,t2,t3);}

C_noret_decl(trf_5173)
static void C_fcall trf_5173(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5173(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5173(t0,t1);}

C_noret_decl(trf_5049)
static void C_fcall trf_5049(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5049(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5049(t0,t1);}

C_noret_decl(trf_5044)
static void C_fcall trf_5044(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5044(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5044(t0,t1,t2);}

C_noret_decl(trf_5039)
static void C_fcall trf_5039(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5039(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5039(t0,t1,t2,t3);}

C_noret_decl(trf_4855)
static void C_fcall trf_4855(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4855(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4855(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4983)
static void C_fcall trf_4983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4983(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4983(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4907)
static void C_fcall trf_4907(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4907(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4907(t0,t1);}

C_noret_decl(trf_4861)
static void C_fcall trf_4861(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4861(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4861(t0,t1,t2,t3);}

C_noret_decl(trf_4778)
static void C_fcall trf_4778(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4778(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4778(t0,t1);}

C_noret_decl(trf_4773)
static void C_fcall trf_4773(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4773(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4773(t0,t1,t2);}

C_noret_decl(trf_4768)
static void C_fcall trf_4768(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4768(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4768(t0,t1,t2,t3);}

C_noret_decl(trf_4763)
static void C_fcall trf_4763(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4763(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4763(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4384)
static void C_fcall trf_4384(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4384(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_4384(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_4642)
static void C_fcall trf_4642(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4642(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4642(t0,t1,t2);}

C_noret_decl(trf_4568)
static void C_fcall trf_4568(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4568(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4568(t0,t1);}

C_noret_decl(trf_4570)
static void C_fcall trf_4570(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4570(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4570(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4418)
static void C_fcall trf_4418(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4418(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4418(t0,t1);}

C_noret_decl(trf_4430)
static void C_fcall trf_4430(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4430(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4430(t0,t1);}

C_noret_decl(trf_4395)
static void C_fcall trf_4395(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4395(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4395(t0,t1);}

C_noret_decl(trf_4362)
static void C_fcall trf_4362(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4362(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4362(t0,t1);}

C_noret_decl(trf_4267)
static void C_fcall trf_4267(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4267(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4267(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4230)
static void C_fcall trf_4230(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4230(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4230(t0,t1,t2);}

C_noret_decl(trf_4043)
static void C_fcall trf_4043(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4043(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4043(t0,t1,t2,t3);}

C_noret_decl(trf_3865)
static void C_fcall trf_3865(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3865(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3865(t0,t1,t2,t3);}

C_noret_decl(trf_3808)
static void C_fcall trf_3808(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3808(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3808(t0,t1,t2);}

C_noret_decl(trf_3722)
static void C_fcall trf_3722(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3722(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3722(t0,t1);}

C_noret_decl(trf_3745)
static void C_fcall trf_3745(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3745(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3745(t0,t1,t2);}

C_noret_decl(trf_3628)
static void C_fcall trf_3628(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3628(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3628(t0,t1);}

C_noret_decl(trf_3472)
static void C_fcall trf_3472(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3472(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3472(t0,t1,t2,t3);}

C_noret_decl(trf_3164)
static void C_fcall trf_3164(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3164(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3164(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3158)
static void C_fcall trf_3158(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3158(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3158(t0,t1);}

C_noret_decl(trf_2956)
static void C_fcall trf_2956(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2956(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2956(t0,t1);}

C_noret_decl(trf_2975)
static void C_fcall trf_2975(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2975(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2975(t0,t1);}

C_noret_decl(trf_3019)
static void C_fcall trf_3019(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3019(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3019(t0,t1);}

C_noret_decl(trf_2845)
static void C_fcall trf_2845(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2845(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2845(t0,t1,t2,t3);}

C_noret_decl(trf_2913)
static void C_fcall trf_2913(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2913(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2913(t0,t1);}

C_noret_decl(trf_2773)
static void C_fcall trf_2773(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2773(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2773(t0,t1);}

C_noret_decl(trf_2757)
static void C_fcall trf_2757(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2757(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2757(t0,t1);}

C_noret_decl(trf_2644)
static void C_fcall trf_2644(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2644(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2644(t0,t1);}

C_noret_decl(trf_2639)
static void C_fcall trf_2639(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2639(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2639(t0,t1,t2);}

C_noret_decl(trf_2541)
static void C_fcall trf_2541(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2541(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2541(t0,t1,t2,t3);}

C_noret_decl(trf_2572)
static void C_fcall trf_2572(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2572(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2572(t0,t1);}

C_noret_decl(trf_2594)
static void C_fcall trf_2594(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2594(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2594(t0,t1);}

C_noret_decl(trf_2143)
static void C_fcall trf_2143(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2143(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2143(t0,t1,t2,t3);}

C_noret_decl(trf_1976)
static void C_fcall trf_1976(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1976(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1976(t0,t1);}

C_noret_decl(trf_2015)
static void C_fcall trf_2015(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2015(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2015(t0,t1);}

C_noret_decl(trf_2019)
static void C_fcall trf_2019(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2019(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2019(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3410)){
C_save(t1);
C_rereclaim2(3410*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,473);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[9]=C_h_intern(&lf[9],21,"\003sysfile-nonblocking!");
lf[10]=C_h_intern(&lf[10],19,"\003sysfile-select-one");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"fcntl/dupfd");
lf[13]=C_h_intern(&lf[13],11,"fcntl/getfd");
lf[14]=C_h_intern(&lf[14],11,"fcntl/setfd");
lf[15]=C_h_intern(&lf[15],11,"fcntl/getfl");
lf[16]=C_h_intern(&lf[16],11,"fcntl/setfl");
lf[17]=C_h_intern(&lf[17],11,"open/rdonly");
lf[18]=C_h_intern(&lf[18],11,"open/wronly");
lf[19]=C_h_intern(&lf[19],9,"open/rdwr");
lf[20]=C_h_intern(&lf[20],9,"open/read");
lf[21]=C_h_intern(&lf[21],10,"open/write");
lf[22]=C_h_intern(&lf[22],10,"open/creat");
lf[23]=C_h_intern(&lf[23],11,"open/append");
lf[24]=C_h_intern(&lf[24],9,"open/excl");
lf[25]=C_h_intern(&lf[25],11,"open/noctty");
lf[26]=C_h_intern(&lf[26],13,"open/nonblock");
lf[27]=C_h_intern(&lf[27],10,"open/trunc");
lf[28]=C_h_intern(&lf[28],9,"open/sync");
lf[29]=C_h_intern(&lf[29],10,"open/fsync");
lf[30]=C_h_intern(&lf[30],11,"open/binary");
lf[31]=C_h_intern(&lf[31],9,"open/text");
lf[32]=C_h_intern(&lf[32],10,"perm/irusr");
lf[33]=C_h_intern(&lf[33],10,"perm/iwusr");
lf[34]=C_h_intern(&lf[34],10,"perm/ixusr");
lf[35]=C_h_intern(&lf[35],10,"perm/irgrp");
lf[36]=C_h_intern(&lf[36],10,"perm/iwgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/ixgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/iroth");
lf[39]=C_h_intern(&lf[39],10,"perm/iwoth");
lf[40]=C_h_intern(&lf[40],10,"perm/ixoth");
lf[41]=C_h_intern(&lf[41],10,"perm/irwxu");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxg");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxo");
lf[44]=C_h_intern(&lf[44],10,"perm/isvtx");
lf[45]=C_h_intern(&lf[45],10,"perm/isuid");
lf[46]=C_h_intern(&lf[46],10,"perm/isgid");
lf[47]=C_h_intern(&lf[47],12,"file-control");
lf[48]=C_h_intern(&lf[48],11,"\000file-error");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[50]=C_h_intern(&lf[50],9,"file-open");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[52]=C_h_intern(&lf[52],17,"\003sysmake-c-string");
lf[53]=C_h_intern(&lf[53],20,"\003sysexpand-home-path");
lf[54]=C_h_intern(&lf[54],10,"file-close");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[56]=C_h_intern(&lf[56],11,"make-string");
lf[57]=C_h_intern(&lf[57],9,"file-read");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[59]=C_h_intern(&lf[59],11,"\000type-error");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[61]=C_h_intern(&lf[61],10,"file-write");
lf[62]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[64]=C_h_intern(&lf[64],12,"file-mkstemp");
lf[65]=C_h_intern(&lf[65],13,"\003syssubstring");
lf[66]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[67]=C_h_intern(&lf[67],11,"file-select");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[69]=C_h_intern(&lf[69],12,"\003sysfor-each");
lf[70]=C_h_intern(&lf[70],8,"seek/set");
lf[71]=C_h_intern(&lf[71],8,"seek/end");
lf[72]=C_h_intern(&lf[72],8,"seek/cur");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[75]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[76]=C_h_intern(&lf[76],9,"file-stat");
lf[77]=C_h_intern(&lf[77],9,"file-size");
lf[78]=C_h_intern(&lf[78],22,"file-modification-time");
lf[79]=C_h_intern(&lf[79],16,"file-access-time");
lf[80]=C_h_intern(&lf[80],16,"file-change-time");
lf[81]=C_h_intern(&lf[81],10,"file-owner");
lf[82]=C_h_intern(&lf[82],16,"file-permissions");
lf[83]=C_h_intern(&lf[83],13,"regular-file\077");
lf[84]=C_h_intern(&lf[84],14,"symbolic-link\077");
lf[85]=C_h_intern(&lf[85],13,"stat-regular\077");
lf[86]=C_h_intern(&lf[86],15,"stat-directory\077");
lf[87]=C_h_intern(&lf[87],17,"stat-char-device\077");
lf[88]=C_h_intern(&lf[88],18,"stat-block-device\077");
lf[89]=C_h_intern(&lf[89],10,"stat-fifo\077");
lf[90]=C_h_intern(&lf[90],13,"stat-symlink\077");
lf[91]=C_h_intern(&lf[91],12,"stat-socket\077");
lf[92]=C_h_intern(&lf[92],18,"set-file-position!");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[94]=C_h_intern(&lf[94],6,"stream");
lf[95]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[96]=C_h_intern(&lf[96],5,"port\077");
lf[97]=C_h_intern(&lf[97],13,"\000bounds-error");
lf[98]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[99]=C_h_intern(&lf[99],13,"file-position");
lf[100]=C_h_intern(&lf[100],19,"g196-1222221401.074");
lf[101]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[102]=C_h_intern(&lf[102],20,"g202-1222221401.0584");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\026path segment is a file");
lf[104]=C_h_intern(&lf[104],20,"g201-1222221401.0699");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot stat file");
lf[106]=C_h_intern(&lf[106],20,"g218-1222221401.0594");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[108]=C_h_intern(&lf[108],19,"g217-1222221401.083");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[110]=C_h_intern(&lf[110],20,"g216-1222221401.0980");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[112]=C_h_intern(&lf[112],16,"create-directory");
lf[113]=C_h_intern(&lf[113],12,"file-exists\077");
lf[114]=C_h_intern(&lf[114],12,"string-split");
lf[115]=C_h_intern(&lf[115],14,"canonical-path");
lf[116]=C_h_intern(&lf[116],16,"change-directory");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[118]=C_h_intern(&lf[118],16,"delete-directory");
lf[119]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[120]=C_h_intern(&lf[120],10,"string-ref");
lf[121]=C_h_intern(&lf[121],6,"string");
lf[122]=C_h_intern(&lf[122],9,"directory");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[124]=C_h_intern(&lf[124],16,"\003sysmake-pointer");
lf[125]=C_h_intern(&lf[125],17,"current-directory");
lf[126]=C_h_intern(&lf[126],10,"directory\077");
lf[127]=C_h_intern(&lf[127],13,"\003sysfile-info");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[129]=C_h_intern(&lf[129],5,"null\077");
lf[130]=C_h_intern(&lf[130],6,"char=\077");
lf[131]=C_h_intern(&lf[131],8,"string=\077");
lf[132]=C_h_intern(&lf[132],16,"char-alphabetic\077");
lf[133]=C_h_intern(&lf[133],18,"string-intersperse");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[135]=C_h_intern(&lf[135],6,"getenv");
lf[136]=C_h_intern(&lf[136],17,"current-user-name");
lf[137]=C_h_intern(&lf[137],9,"condition");
lf[138]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[139]=C_h_intern(&lf[139],22,"with-exception-handler");
lf[140]=C_h_intern(&lf[140],30,"call-with-current-continuation");
lf[141]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[144]=C_h_intern(&lf[144],7,"reverse");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[148]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[149]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[151]=C_decode_literal(C_heaptop,"\376B\000\000\006/home/");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\004HOME");
lf[153]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[155]=C_h_intern(&lf[155],5,"\000text");
lf[156]=C_h_intern(&lf[156],9,"\003syserror");
lf[157]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[158]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[159]=C_h_intern(&lf[159],13,"\003sysmake-port");
lf[160]=C_h_intern(&lf[160],21,"\003sysstream-port-class");
lf[161]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[162]=C_h_intern(&lf[162],15,"open-input-pipe");
lf[163]=C_h_intern(&lf[163],7,"\000binary");
lf[164]=C_h_intern(&lf[164],16,"open-output-pipe");
lf[165]=C_h_intern(&lf[165],16,"close-input-pipe");
lf[166]=C_h_intern(&lf[166],23,"close-input/output-pipe");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[168]=C_h_intern(&lf[168],14,"\003syscheck-port");
lf[169]=C_h_intern(&lf[169],17,"close-output-pipe");
lf[170]=C_h_intern(&lf[170],20,"call-with-input-pipe");
lf[171]=C_h_intern(&lf[171],21,"call-with-output-pipe");
lf[172]=C_h_intern(&lf[172],20,"with-input-from-pipe");
lf[173]=C_h_intern(&lf[173],18,"\003sysstandard-input");
lf[174]=C_h_intern(&lf[174],19,"with-output-to-pipe");
lf[175]=C_h_intern(&lf[175],19,"\003sysstandard-output");
lf[176]=C_h_intern(&lf[176],11,"create-pipe");
lf[177]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[178]=C_h_intern(&lf[178],11,"signal/term");
lf[179]=C_h_intern(&lf[179],11,"signal/kill");
lf[180]=C_h_intern(&lf[180],10,"signal/int");
lf[181]=C_h_intern(&lf[181],10,"signal/hup");
lf[182]=C_h_intern(&lf[182],10,"signal/fpe");
lf[183]=C_h_intern(&lf[183],10,"signal/ill");
lf[184]=C_h_intern(&lf[184],11,"signal/segv");
lf[185]=C_h_intern(&lf[185],11,"signal/abrt");
lf[186]=C_h_intern(&lf[186],11,"signal/trap");
lf[187]=C_h_intern(&lf[187],11,"signal/quit");
lf[188]=C_h_intern(&lf[188],11,"signal/alrm");
lf[189]=C_h_intern(&lf[189],13,"signal/vtalrm");
lf[190]=C_h_intern(&lf[190],11,"signal/prof");
lf[191]=C_h_intern(&lf[191],9,"signal/io");
lf[192]=C_h_intern(&lf[192],10,"signal/urg");
lf[193]=C_h_intern(&lf[193],11,"signal/chld");
lf[194]=C_h_intern(&lf[194],11,"signal/cont");
lf[195]=C_h_intern(&lf[195],11,"signal/stop");
lf[196]=C_h_intern(&lf[196],11,"signal/tstp");
lf[197]=C_h_intern(&lf[197],11,"signal/pipe");
lf[198]=C_h_intern(&lf[198],11,"signal/xcpu");
lf[199]=C_h_intern(&lf[199],11,"signal/xfsz");
lf[200]=C_h_intern(&lf[200],11,"signal/usr1");
lf[201]=C_h_intern(&lf[201],11,"signal/usr2");
lf[202]=C_h_intern(&lf[202],12,"signal/winch");
lf[203]=C_h_intern(&lf[203],12,"signals-list");
lf[204]=C_h_intern(&lf[204],18,"\003sysinterrupt-hook");
lf[205]=C_h_intern(&lf[205],14,"signal-handler");
lf[206]=C_h_intern(&lf[206],19,"set-signal-handler!");
lf[207]=C_h_intern(&lf[207],16,"set-signal-mask!");
lf[208]=C_h_intern(&lf[208],14,"\000process-error");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[210]=C_h_intern(&lf[210],11,"signal-mask");
lf[211]=C_h_intern(&lf[211],14,"signal-masked\077");
lf[212]=C_h_intern(&lf[212],12,"signal-mask!");
lf[213]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[214]=C_h_intern(&lf[214],14,"signal-unmask!");
lf[215]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[216]=C_h_intern(&lf[216],18,"system-information");
lf[217]=C_h_intern(&lf[217],25,"\003syspeek-nonnull-c-string");
lf[218]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[219]=C_h_intern(&lf[219],12,"set-user-id!");
lf[220]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[221]=C_h_intern(&lf[221],15,"current-user-id");
lf[222]=C_h_intern(&lf[222],25,"current-effective-user-id");
lf[223]=C_h_intern(&lf[223],13,"set-group-id!");
lf[224]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[225]=C_h_intern(&lf[225],16,"current-group-id");
lf[226]=C_h_intern(&lf[226],26,"current-effective-group-id");
lf[227]=C_h_intern(&lf[227],16,"user-information");
lf[228]=C_h_intern(&lf[228],6,"vector");
lf[229]=C_h_intern(&lf[229],4,"list");
lf[230]=C_h_intern(&lf[230],27,"current-effective-user-name");
lf[231]=C_h_intern(&lf[231],17,"group-information");
lf[233]=C_h_intern(&lf[233],10,"get-groups");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[237]=C_h_intern(&lf[237],11,"set-groups!");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[240]=C_h_intern(&lf[240],17,"initialize-groups");
lf[241]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[242]=C_h_intern(&lf[242],10,"errno/perm");
lf[243]=C_h_intern(&lf[243],11,"errno/noent");
lf[244]=C_h_intern(&lf[244],10,"errno/srch");
lf[245]=C_h_intern(&lf[245],10,"errno/intr");
lf[246]=C_h_intern(&lf[246],8,"errno/io");
lf[247]=C_h_intern(&lf[247],12,"errno/noexec");
lf[248]=C_h_intern(&lf[248],10,"errno/badf");
lf[249]=C_h_intern(&lf[249],11,"errno/child");
lf[250]=C_h_intern(&lf[250],11,"errno/nomem");
lf[251]=C_h_intern(&lf[251],11,"errno/acces");
lf[252]=C_h_intern(&lf[252],11,"errno/fault");
lf[253]=C_h_intern(&lf[253],10,"errno/busy");
lf[254]=C_h_intern(&lf[254],12,"errno/notdir");
lf[255]=C_h_intern(&lf[255],11,"errno/isdir");
lf[256]=C_h_intern(&lf[256],11,"errno/inval");
lf[257]=C_h_intern(&lf[257],11,"errno/mfile");
lf[258]=C_h_intern(&lf[258],11,"errno/nospc");
lf[259]=C_h_intern(&lf[259],11,"errno/spipe");
lf[260]=C_h_intern(&lf[260],10,"errno/pipe");
lf[261]=C_h_intern(&lf[261],11,"errno/again");
lf[262]=C_h_intern(&lf[262],10,"errno/rofs");
lf[263]=C_h_intern(&lf[263],11,"errno/exist");
lf[264]=C_h_intern(&lf[264],16,"errno/wouldblock");
lf[265]=C_h_intern(&lf[265],10,"errno/2big");
lf[266]=C_h_intern(&lf[266],12,"errno/deadlk");
lf[267]=C_h_intern(&lf[267],9,"errno/dom");
lf[268]=C_h_intern(&lf[268],10,"errno/fbig");
lf[269]=C_h_intern(&lf[269],11,"errno/ilseq");
lf[270]=C_h_intern(&lf[270],11,"errno/mlink");
lf[271]=C_h_intern(&lf[271],17,"errno/nametoolong");
lf[272]=C_h_intern(&lf[272],11,"errno/nfile");
lf[273]=C_h_intern(&lf[273],11,"errno/nodev");
lf[274]=C_h_intern(&lf[274],11,"errno/nolck");
lf[275]=C_h_intern(&lf[275],11,"errno/nosys");
lf[276]=C_h_intern(&lf[276],14,"errno/notempty");
lf[277]=C_h_intern(&lf[277],11,"errno/notty");
lf[278]=C_h_intern(&lf[278],10,"errno/nxio");
lf[279]=C_h_intern(&lf[279],11,"errno/range");
lf[280]=C_h_intern(&lf[280],10,"errno/xdev");
lf[281]=C_h_intern(&lf[281],16,"change-file-mode");
lf[282]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[283]=C_h_intern(&lf[283],17,"change-file-owner");
lf[284]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[285]=C_h_intern(&lf[285],17,"file-read-access\077");
lf[286]=C_h_intern(&lf[286],18,"file-write-access\077");
lf[287]=C_h_intern(&lf[287],20,"file-execute-access\077");
lf[288]=C_h_intern(&lf[288],14,"create-session");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[290]=C_h_intern(&lf[290],21,"set-process-group-id!");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[292]=C_h_intern(&lf[292],16,"process-group-id");
lf[293]=C_h_intern(&lf[293],20,"create-symbolic-link");
lf[294]=C_h_intern(&lf[294],18,"create-symbol-link");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[296]=C_h_intern(&lf[296],9,"substring");
lf[297]=C_h_intern(&lf[297],18,"read-symbolic-link");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[299]=C_h_intern(&lf[299],9,"file-link");
lf[300]=C_h_intern(&lf[300],9,"hard-link");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[302]=C_h_intern(&lf[302],12,"fileno/stdin");
lf[303]=C_h_intern(&lf[303],13,"fileno/stdout");
lf[304]=C_h_intern(&lf[304],13,"fileno/stderr");
lf[305]=C_h_intern(&lf[305],7,"\000append");
lf[306]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[308]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[312]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[313]=C_h_intern(&lf[313],16,"open-input-file*");
lf[314]=C_h_intern(&lf[314],17,"open-output-file*");
lf[315]=C_h_intern(&lf[315],12,"port->fileno");
lf[316]=C_h_intern(&lf[316],6,"socket");
lf[317]=C_h_intern(&lf[317],20,"\003systcp-port->fileno");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[320]=C_h_intern(&lf[320],25,"\003syspeek-unsigned-integer");
lf[321]=C_h_intern(&lf[321],16,"duplicate-fileno");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[323]=C_h_intern(&lf[323],15,"make-input-port");
lf[324]=C_h_intern(&lf[324],14,"set-port-name!");
lf[325]=C_h_intern(&lf[325],21,"\003syscustom-input-port");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[327]=C_h_intern(&lf[327],17,"\003systhread-yield!");
lf[328]=C_h_intern(&lf[328],25,"\003systhread-block-for-i/o!");
lf[329]=C_h_intern(&lf[329],18,"\003syscurrent-thread");
lf[330]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[334]=C_h_intern(&lf[334],17,"\003sysstring-append");
lf[335]=C_h_intern(&lf[335],15,"\003sysmake-string");
lf[336]=C_h_intern(&lf[336],20,"\003sysscan-buffer-line");
lf[337]=C_h_intern(&lf[337],4,"noop");
lf[338]=C_h_intern(&lf[338],16,"make-output-port");
lf[339]=C_h_intern(&lf[339],22,"\003syscustom-output-port");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[342]=C_h_intern(&lf[342],13,"file-truncate");
lf[343]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[345]=C_h_intern(&lf[345],4,"lock");
lf[346]=C_h_intern(&lf[346],9,"file-lock");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[348]=C_h_intern(&lf[348],18,"file-lock/blocking");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[350]=C_h_intern(&lf[350],14,"file-test-lock");
lf[351]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[352]=C_h_intern(&lf[352],11,"file-unlock");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[354]=C_h_intern(&lf[354],11,"create-fifo");
lf[355]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[356]=C_h_intern(&lf[356],5,"fifo\077");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[358]=C_h_intern(&lf[358],6,"setenv");
lf[359]=C_h_intern(&lf[359],8,"unsetenv");
lf[360]=C_h_intern(&lf[360],19,"current-environment");
lf[361]=C_h_intern(&lf[361],9,"prot/read");
lf[362]=C_h_intern(&lf[362],10,"prot/write");
lf[363]=C_h_intern(&lf[363],9,"prot/exec");
lf[364]=C_h_intern(&lf[364],9,"prot/none");
lf[365]=C_h_intern(&lf[365],9,"map/fixed");
lf[366]=C_h_intern(&lf[366],10,"map/shared");
lf[367]=C_h_intern(&lf[367],11,"map/private");
lf[368]=C_h_intern(&lf[368],13,"map/anonymous");
lf[369]=C_h_intern(&lf[369],8,"map/file");
lf[370]=C_h_intern(&lf[370],18,"map-file-to-memory");
lf[371]=C_h_intern(&lf[371],4,"mmap");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[373]=C_h_intern(&lf[373],20,"\003syspointer->address");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[375]=C_h_intern(&lf[375],16,"\003sysnull-pointer");
lf[376]=C_h_intern(&lf[376],22,"unmap-file-from-memory");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[378]=C_h_intern(&lf[378],26,"memory-mapped-file-pointer");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],19,"seconds->local-time");
lf[381]=C_h_intern(&lf[381],18,"\003sysdecode-seconds");
lf[382]=C_h_intern(&lf[382],17,"seconds->utc-time");
lf[383]=C_h_intern(&lf[383],15,"seconds->string");
lf[384]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[385]=C_h_intern(&lf[385],12,"time->string");
lf[386]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[388]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[389]=C_h_intern(&lf[389],12,"string->time");
lf[390]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[391]=C_h_intern(&lf[391],19,"local-time->seconds");
lf[392]=C_h_intern(&lf[392],15,"\003syscons-flonum");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[395]=C_h_intern(&lf[395],17,"utc-time->seconds");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[398]=C_h_intern(&lf[398],27,"local-timezone-abbreviation");
lf[399]=C_h_intern(&lf[399],5,"_exit");
lf[400]=C_h_intern(&lf[400],10,"set-alarm!");
lf[401]=C_h_intern(&lf[401],19,"set-buffering-mode!");
lf[402]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[403]=C_h_intern(&lf[403],5,"\000full");
lf[404]=C_h_intern(&lf[404],5,"\000line");
lf[405]=C_h_intern(&lf[405],5,"\000none");
lf[406]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[407]=C_h_intern(&lf[407],14,"terminal-port\077");
lf[409]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[410]=C_h_intern(&lf[410],13,"terminal-name");
lf[411]=C_h_intern(&lf[411],13,"terminal-size");
lf[412]=C_h_intern(&lf[412],6,"\000error");
lf[413]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[414]=C_h_intern(&lf[414],17,"\003sysmake-locative");
lf[415]=C_h_intern(&lf[415],8,"location");
lf[416]=C_h_intern(&lf[416],13,"get-host-name");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[418]=C_h_intern(&lf[418],6,"regexp");
lf[419]=C_h_intern(&lf[419],21,"make-anchored-pattern");
lf[420]=C_h_intern(&lf[420],12,"string-match");
lf[421]=C_h_intern(&lf[421],12,"glob->regexp");
lf[422]=C_h_intern(&lf[422],13,"make-pathname");
lf[423]=C_h_intern(&lf[423],18,"decompose-pathname");
lf[424]=C_h_intern(&lf[424],4,"glob");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[426]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[427]=C_h_intern(&lf[427],12,"process-fork");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[429]=C_h_intern(&lf[429],24,"pathname-strip-directory");
lf[430]=C_h_intern(&lf[430],15,"process-execute");
lf[431]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[432]=C_h_intern(&lf[432],16,"\003sysprocess-wait");
lf[433]=C_h_intern(&lf[433],12,"process-wait");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[435]=C_h_intern(&lf[435],18,"current-process-id");
lf[436]=C_h_intern(&lf[436],17,"parent-process-id");
lf[437]=C_h_intern(&lf[437],5,"sleep");
lf[438]=C_h_intern(&lf[438],14,"process-signal");
lf[439]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[440]=C_h_intern(&lf[440],17,"\003sysshell-command");
lf[441]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[443]=C_h_intern(&lf[443],27,"\003sysshell-command-arguments");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[445]=C_h_intern(&lf[445],11,"process-run");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[447]=C_h_intern(&lf[447],11,"\003sysprocess");
lf[448]=C_h_intern(&lf[448],19,"\003sysundefined-value");
lf[449]=C_h_intern(&lf[449],7,"process");
lf[450]=C_h_intern(&lf[450],8,"process*");
lf[451]=C_h_intern(&lf[451],10,"find-files");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[455]=C_h_intern(&lf[455],16,"\003sysdynamic-wind");
lf[456]=C_h_intern(&lf[456],13,"pathname-file");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[458]=C_h_intern(&lf[458],7,"regexp\077");
lf[459]=C_h_intern(&lf[459],19,"set-root-directory!");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[462]=C_h_intern(&lf[462],18,"getter-with-setter");
lf[463]=C_h_intern(&lf[463],26,"effective-group-id!-setter");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[465]=C_h_intern(&lf[465],25,"effective-user-id!-setter");
lf[466]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[467]=C_h_intern(&lf[467],23,"\003sysuser-interrupt-hook");
lf[468]=C_h_intern(&lf[468],11,"make-vector");
lf[469]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[470]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[471]=C_h_intern(&lf[471],17,"register-feature!");
lf[472]=C_h_intern(&lf[472],5,"posix");
C_register_lf2(lf,473,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1656,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1654 */
static void C_ccall f_1656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1659,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1657 in k1654 */
static void C_ccall f_1659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1659,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1662,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1660 in k1657 in k1654 */
static void C_ccall f_1662(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1662,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1665,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1665,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1668,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1668,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1671,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 508  register-feature! */
t3=*((C_word*)lf[471]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[472]);}

/* k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word ab[81],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1671,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1678,a[2]=t2,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[8]+1,lf[3]);
t5=C_mutate((C_word*)lf[9]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1696,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[10]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1699,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[11]+1,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[12]+1,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[13]+1,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[14]+1,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[15]+1,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[16]+1,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1740,tmp=(C_word)a,a+=2,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[50]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1779,a[2]=t45,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[54]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1817,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[56]+1);
t49=C_mutate((C_word*)lf[57]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1832,a[2]=t48,tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1874,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1913,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1945,tmp=(C_word)a,a+=2,tmp);
t53=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1947,tmp=(C_word)a,a+=2,tmp);
t54=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1949,tmp=(C_word)a,a+=2,tmp);
t55=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1951,a[2]=t53,a[3]=t54,a[4]=t52,tmp=(C_word)a,a+=5,tmp));
t56=C_mutate((C_word*)lf[70]+1,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[71]+1,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[72]+1,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[73],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2143,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2180,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2205,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2211,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2217,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2223,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[81]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2229,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[82]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2235,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2241,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2250,tmp=(C_word)a,a+=2,tmp));
t69=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2259,tmp=(C_word)a,a+=2,tmp));
t70=C_mutate((C_word*)lf[86]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2268,tmp=(C_word)a,a+=2,tmp));
t71=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2277,tmp=(C_word)a,a+=2,tmp));
t72=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2286,tmp=(C_word)a,a+=2,tmp));
t73=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2295,tmp=(C_word)a,a+=2,tmp));
t74=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2304,tmp=(C_word)a,a+=2,tmp));
t75=C_mutate((C_word*)lf[91]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2313,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2322,tmp=(C_word)a,a+=2,tmp));
t77=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2382,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t78=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7334,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 848  getter-with-setter */
t79=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t79+1)))(4,t79,t77,t78,*((C_word*)lf[92]+1));}

/* a7333 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7334(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7334,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7338,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7350,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 850  port? */
t5=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7348 in a7333 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[94]);
t4=((C_word*)t0)[2];
f_7338(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_7338(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 855  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[59],lf[99],lf[470],((C_word*)t0)[3]);}}}

/* k7336 in a7333 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7338,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7341,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 857  posix-error */
t3=lf[3];
f_1678(6,t3,t2,lf[48],lf[99],lf[469],((C_word*)t0)[2]);}
else{
t3=t2;
f_7341(2,t3,C_SCHEME_UNDEFINED);}}

/* k7339 in k7336 in a7333 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2382(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[150],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2382,2,t0,t1);}
t2=C_mutate((C_word*)lf[99]+1,t1);
t3=C_mutate((C_word*)lf[100]+1,lf[101]);
t4=C_mutate((C_word*)lf[102]+1,lf[103]);
t5=C_mutate((C_word*)lf[104]+1,lf[105]);
t6=C_mutate((C_word*)lf[106]+1,lf[107]);
t7=C_mutate((C_word*)lf[108]+1,lf[109]);
t8=C_mutate((C_word*)lf[110]+1,lf[111]);
t9=C_mutate((C_word*)lf[112]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2390,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2491,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2515,tmp=(C_word)a,a+=2,tmp));
t12=*((C_word*)lf[120]+1);
t13=*((C_word*)lf[56]+1);
t14=*((C_word*)lf[121]+1);
t15=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2539,a[2]=t13,a[3]=t12,tmp=(C_word)a,a+=4,tmp));
t16=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2693,tmp=(C_word)a,a+=2,tmp));
t17=*((C_word*)lf[56]+1);
t18=C_mutate((C_word*)lf[125]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2716,a[2]=t17,tmp=(C_word)a,a+=3,tmp));
t19=*((C_word*)lf[129]+1);
t20=*((C_word*)lf[130]+1);
t21=*((C_word*)lf[131]+1);
t22=*((C_word*)lf[132]+1);
t23=*((C_word*)lf[120]+1);
t24=*((C_word*)lf[2]+1);
t25=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2757,tmp=(C_word)a,a+=2,tmp);
t26=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2762,tmp=(C_word)a,a+=2,tmp);
t27=*((C_word*)lf[135]+1);
t28=*((C_word*)lf[136]+1);
t29=*((C_word*)lf[125]+1);
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2773,a[2]=t29,tmp=(C_word)a,a+=3,tmp);
t31=C_mutate((C_word*)lf[115]+1,(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2829,a[2]=t22,a[3]=t20,a[4]=t27,a[5]=t28,a[6]=t30,a[7]=t21,a[8]=t19,a[9]=t23,a[10]=t25,a[11]=t24,a[12]=t26,tmp=(C_word)a,a+=13,tmp));
t32=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3146,tmp=(C_word)a,a+=2,tmp);
t33=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3158,tmp=(C_word)a,a+=2,tmp);
t34=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3164,tmp=(C_word)a,a+=2,tmp);
t35=C_mutate((C_word*)lf[162]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3179,a[2]=t33,a[3]=t34,a[4]=t32,tmp=(C_word)a,a+=5,tmp));
t36=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3215,a[2]=t33,a[3]=t34,a[4]=t32,tmp=(C_word)a,a+=5,tmp));
t37=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3251,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[169]+1,*((C_word*)lf[165]+1));
t39=*((C_word*)lf[162]+1);
t40=*((C_word*)lf[164]+1);
t41=*((C_word*)lf[165]+1);
t42=*((C_word*)lf[169]+1);
t43=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3267,a[2]=t39,a[3]=t41,tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[171]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3291,a[2]=t40,a[3]=t42,tmp=(C_word)a,a+=4,tmp));
t45=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3315,a[2]=t39,a[3]=t41,tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3335,a[2]=t40,a[3]=t42,tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3355,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[178]+1,C_fix((C_word)SIGTERM));
t49=C_mutate((C_word*)lf[179]+1,C_fix((C_word)SIGKILL));
t50=C_mutate((C_word*)lf[180]+1,C_fix((C_word)SIGINT));
t51=C_mutate((C_word*)lf[181]+1,C_fix((C_word)SIGHUP));
t52=C_mutate((C_word*)lf[182]+1,C_fix((C_word)SIGFPE));
t53=C_mutate((C_word*)lf[183]+1,C_fix((C_word)SIGILL));
t54=C_mutate((C_word*)lf[184]+1,C_fix((C_word)SIGSEGV));
t55=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGABRT));
t56=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGTRAP));
t57=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGQUIT));
t58=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGALRM));
t59=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGVTALRM));
t60=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGPROF));
t61=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGIO));
t62=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGURG));
t63=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGCHLD));
t64=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGCONT));
t65=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGSTOP));
t66=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGTSTP));
t67=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGPIPE));
t68=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGXCPU));
t69=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGXFSZ));
t70=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGUSR1));
t71=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGUSR2));
t72=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGWINCH));
t73=(C_word)C_a_i_list(&a,25,*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1),*((C_word*)lf[201]+1),*((C_word*)lf[202]+1));
t74=C_mutate((C_word*)lf[203]+1,t73);
t75=*((C_word*)lf[204]+1);
t76=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3400,a[2]=((C_word*)t0)[2],a[3]=t75,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1181 make-vector */
t77=*((C_word*)lf[468]+1);
((C_proc4)(void*)(*((C_word*)t77+1)))(4,t77,t76,C_fix(256),C_SCHEME_FALSE);}

/* k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3400(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3400,2,t0,t1);}
t2=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3402,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[206]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3411,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[204]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3424,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3442,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3466,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3498,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3504,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3519,tmp=(C_word)a,a+=2,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3535,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7328,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1237 set-signal-handler! */
t12=*((C_word*)lf[206]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,*((C_word*)lf[180]+1),t11);}

/* a7327 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7328(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7328,3,t0,t1,t2);}
/* posixunix.scm: 1239 ##sys#user-interrupt-hook */
t3=*((C_word*)lf[467]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3535,2,t0,t1);}
t2=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3537,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3575,tmp=(C_word)a,a+=2,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3592,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7325,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1269 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,*((C_word*)lf[219]+1));}

/* a7324 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7325,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub438(C_SCHEME_UNDEFINED));}

/* k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3592,2,t0,t1);}
t2=C_mutate((C_word*)lf[221]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3596,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7307,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7310,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1274 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a7309 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7310(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7310,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7320,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1278 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7318 in a7309 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1279 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[465],lf[466],((C_word*)t0)[2]);}

/* a7306 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7307,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub440(C_SCHEME_UNDEFINED));}

/* k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3596,2,t0,t1);}
t2=C_mutate((C_word*)lf[222]+1,t1);
t3=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3598,tmp=(C_word)a,a+=2,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3615,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7304,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1289 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,*((C_word*)lf[223]+1));}

/* a7303 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7304,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub446(C_SCHEME_UNDEFINED));}

/* k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3615(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3615,2,t0,t1);}
t2=C_mutate((C_word*)lf[225]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3619,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7286,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7289,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1294 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a7288 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7289(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7289,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7299,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1298 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7297 in a7288 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1299 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[463],lf[464],((C_word*)t0)[2]);}

/* a7285 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7286,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub448(C_SCHEME_UNDEFINED));}

/* k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[40],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3619,2,t0,t1);}
t2=C_mutate((C_word*)lf[226]+1,t1);
t3=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3621,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3681,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3695,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[231]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3715,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate(&lf[232],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3790,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3793,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3856,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3922,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[242]+1,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[243]+1,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[244]+1,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[245]+1,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[246]+1,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[247]+1,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[248]+1,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[249]+1,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[250]+1,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[251]+1,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[252]+1,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[253]+1,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[254]+1,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[255]+1,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[256]+1,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[257]+1,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[258]+1,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[259]+1,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[260]+1,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[261]+1,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[263]+1,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[265],0,C_fix(0));
t35=C_set_block_item(lf[266],0,C_fix(0));
t36=C_set_block_item(lf[267],0,C_fix(0));
t37=C_set_block_item(lf[268],0,C_fix(0));
t38=C_set_block_item(lf[269],0,C_fix(0));
t39=C_set_block_item(lf[270],0,C_fix(0));
t40=C_set_block_item(lf[271],0,C_fix(0));
t41=C_set_block_item(lf[272],0,C_fix(0));
t42=C_set_block_item(lf[273],0,C_fix(0));
t43=C_set_block_item(lf[274],0,C_fix(0));
t44=C_set_block_item(lf[275],0,C_fix(0));
t45=C_set_block_item(lf[276],0,C_fix(0));
t46=C_set_block_item(lf[277],0,C_fix(0));
t47=C_set_block_item(lf[278],0,C_fix(0));
t48=C_set_block_item(lf[279],0,C_fix(0));
t49=C_set_block_item(lf[280],0,C_fix(0));
t50=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3986,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[283]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4013,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4043,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4067,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4073,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4079,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4085,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4100,tmp=(C_word)a,a+=2,tmp));
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4123,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7268,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1521 getter-with-setter */
t60=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t60+1)))(4,t60,t58,t59,*((C_word*)lf[290]+1));}

/* a7267 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7268(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7268,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[292]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7275,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7281,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1526 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_7275(2,t6,C_SCHEME_UNDEFINED);}}

/* k7279 in a7267 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1527 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[292],lf[461],((C_word*)t0)[2]);}

/* k7273 in a7267 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4123,2,t0,t1);}
t2=C_mutate((C_word*)lf[292]+1,t1);
t3=C_mutate((C_word*)lf[293]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4125,tmp=(C_word)a,a+=2,tmp));
t4=*((C_word*)lf[296]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4162,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1548 make-string */
t7=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word ab[189],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4162,2,t0,t1);}
t2=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4163,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4205,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[302]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[303]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[304]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4230,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4267,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4282,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4296,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[315]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4310,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[321]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4355,tmp=(C_word)a,a+=2,tmp));
t13=*((C_word*)lf[323]+1);
t14=*((C_word*)lf[324]+1);
t15=C_mutate((C_word*)lf[325]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4382,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t16=*((C_word*)lf[338]+1);
t17=*((C_word*)lf[324]+1);
t18=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4853,a[2]=t16,a[3]=t17,tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5109,tmp=(C_word)a,a+=2,tmp));
t20=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5148,tmp=(C_word)a,a+=2,tmp);
t21=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5219,tmp=(C_word)a,a+=2,tmp);
t22=C_mutate((C_word*)lf[346]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5237,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t23=C_mutate((C_word*)lf[348]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5252,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t24=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5267,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t25=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5289,tmp=(C_word)a,a+=2,tmp));
t26=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5317,tmp=(C_word)a,a+=2,tmp));
t27=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5360,tmp=(C_word)a,a+=2,tmp));
t28=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5386,tmp=(C_word)a,a+=2,tmp));
t29=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5403,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[360]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5418,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[361]+1,C_fix((C_word)PROT_READ));
t32=C_mutate((C_word*)lf[362]+1,C_fix((C_word)PROT_WRITE));
t33=C_mutate((C_word*)lf[363]+1,C_fix((C_word)PROT_EXEC));
t34=C_mutate((C_word*)lf[364]+1,C_fix((C_word)PROT_NONE));
t35=C_mutate((C_word*)lf[365]+1,C_fix((C_word)MAP_FIXED));
t36=C_mutate((C_word*)lf[366]+1,C_fix((C_word)MAP_SHARED));
t37=C_mutate((C_word*)lf[367]+1,C_fix((C_word)MAP_PRIVATE));
t38=C_mutate((C_word*)lf[368]+1,C_fix((C_word)MAP_ANON));
t39=C_mutate((C_word*)lf[369]+1,C_fix((C_word)MAP_FILE));
t40=C_mutate((C_word*)lf[370]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5501,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[376]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5559,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[378]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5594,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[379]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5603,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[380]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5609,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[382]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5618,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[383]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5632,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[385]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5665,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[389]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5740,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[391]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5779,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[395]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5807,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[398]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5835,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[399]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5843,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[400]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5859,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[401]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5862,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[407]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5921,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate(&lf[408],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5940,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[410]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5967,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[411]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5986,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[416]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6021,tmp=(C_word)a,a+=2,tmp));
t60=*((C_word*)lf[418]+1);
t61=*((C_word*)lf[419]+1);
t62=*((C_word*)lf[420]+1);
t63=*((C_word*)lf[421]+1);
t64=*((C_word*)lf[122]+1);
t65=*((C_word*)lf[422]+1);
t66=*((C_word*)lf[423]+1);
t67=C_mutate((C_word*)lf[424]+1,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6033,a[2]=t63,a[3]=t61,a[4]=t60,a[5]=t64,a[6]=t62,a[7]=t65,a[8]=t66,tmp=(C_word)a,a+=9,tmp));
t68=C_mutate((C_word*)lf[427]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6145,tmp=(C_word)a,a+=2,tmp));
t69=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6183,tmp=(C_word)a,a+=2,tmp);
t70=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6191,tmp=(C_word)a,a+=2,tmp);
t71=*((C_word*)lf[429]+1);
t72=C_mutate((C_word*)lf[430]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6199,a[2]=t71,a[3]=t70,a[4]=t69,tmp=(C_word)a,a+=5,tmp));
t73=C_mutate((C_word*)lf[432]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6378,tmp=(C_word)a,a+=2,tmp));
t74=C_mutate((C_word*)lf[433]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6395,tmp=(C_word)a,a+=2,tmp));
t75=C_mutate((C_word*)lf[435]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6470,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[436]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6473,tmp=(C_word)a,a+=2,tmp));
t77=C_mutate((C_word*)lf[437]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6476,tmp=(C_word)a,a+=2,tmp));
t78=C_mutate((C_word*)lf[438]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6479,tmp=(C_word)a,a+=2,tmp));
t79=C_mutate((C_word*)lf[440]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6506,tmp=(C_word)a,a+=2,tmp));
t80=C_mutate((C_word*)lf[443]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6515,tmp=(C_word)a,a+=2,tmp));
t81=*((C_word*)lf[427]+1);
t82=*((C_word*)lf[430]+1);
t83=*((C_word*)lf[135]+1);
t84=C_mutate((C_word*)lf[445]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6521,a[2]=t81,a[3]=t82,tmp=(C_word)a,a+=4,tmp));
t85=*((C_word*)lf[176]+1);
t86=*((C_word*)lf[433]+1);
t87=*((C_word*)lf[427]+1);
t88=*((C_word*)lf[430]+1);
t89=*((C_word*)lf[321]+1);
t90=*((C_word*)lf[54]+1);
t91=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6577,a[2]=t86,tmp=(C_word)a,a+=3,tmp);
t92=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6614,a[2]=t85,tmp=(C_word)a,a+=3,tmp);
t93=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6634,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t94=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6648,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t95=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6665,tmp=(C_word)a,a+=2,tmp);
t96=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6681,a[2]=t92,a[3]=t87,a[4]=t94,a[5]=t88,a[6]=t95,tmp=(C_word)a,a+=7,tmp);
t97=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6726,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t98=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6737,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t99=C_mutate((C_word*)lf[447]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6748,a[2]=t98,a[3]=t91,a[4]=t97,a[5]=t96,tmp=(C_word)a,a+=6,tmp));
t100=*((C_word*)lf[448]+1);
t101=C_mutate((C_word*)lf[449]+1,t100);
t102=*((C_word*)lf[448]+1);
t103=C_mutate((C_word*)lf[450]+1,t102);
t104=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6812,tmp=(C_word)a,a+=2,tmp);
t105=C_mutate((C_word*)lf[449]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6873,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[450]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6930,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t107=*((C_word*)lf[424]+1);
t108=*((C_word*)lf[420]+1);
t109=*((C_word*)lf[422]+1);
t110=*((C_word*)lf[126]+1);
t111=C_mutate((C_word*)lf[451]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6987,a[2]=t110,a[3]=t109,a[4]=t107,a[5]=t108,tmp=(C_word)a,a+=6,tmp));
t112=C_mutate((C_word*)lf[459]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7245,tmp=(C_word)a,a+=2,tmp));
t113=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t113+1)))(2,t113,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7245(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7245,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[459]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7241,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t4);}
else{
t6=t5;
f_7241(2,t6,C_SCHEME_FALSE);}}

/* k7239 in set-root-directory! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1393(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2401 posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[459],lf[460],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6987(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_6987r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_6987r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6987r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6989,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7160,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7165,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7170,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action13461382 */
t9=t8;
f_7170(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id13471380 */
t11=t7;
f_7165(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit13481377 */
t13=t6;
f_7160(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body13441350 */
t15=t5;
f_6989(t15,t1,t9,t11,t13);}}}}

/* def-action1346 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7170(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7170,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7176,tmp=(C_word)a,a+=2,tmp);
/* def-id13471380 */
t3=((C_word*)t0)[2];
f_7165(t3,t1,t2);}

/* a7175 in def-action1346 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7176(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7176,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1347 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7165(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7165,NULL,3,t0,t1,t2);}
/* def-limit13481377 */
t3=((C_word*)t0)[2];
f_7160(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1348 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7160(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7160,NULL,4,t0,t1,t2,t3);}
/* body13441350 */
t4=((C_word*)t0)[2];
f_6989(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6989(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6989,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[451]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6996,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t2,a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_6996(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7155,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_6996(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7147,tmp=(C_word)a,a+=2,tmp));}}

/* f_7147 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7147(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7147,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_7155 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7155(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7155,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6996(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6996,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7135,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
if(C_truep(t2)){
t4=t3;
f_7135(2,t4,t2);}
else{
/* posixunix.scm: 2373 regexp? */
t4=*((C_word*)lf[458]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[11]);}}

/* k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7135,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7136,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[12],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7006,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t2,a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7129,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2376 make-pathname */
t5=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],lf[457]);}

/* k7127 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2376 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7006,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7008,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_7008(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7008(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7008,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7027,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2382 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7027,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7109,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2383 pathname-file */
t3=*((C_word*)lf[456]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7115,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2390 pproc */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7113 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7115,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7122,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2390 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2391 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_7008(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k7120 in k7113 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2390 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7008(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7109,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[452]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[453]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2383 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_7008(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7042,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 2384 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[39],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7042,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7052,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7054,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7062,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7086,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2386 ##sys#dynamic-wind */
t11=*((C_word*)lf[455]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7099,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7102,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2389 pproc */
t4=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[6]);}}

/* k7100 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2389 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7099(2,t2,((C_word*)t0)[2]);}}

/* k7097 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2389 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7008(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7085 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7086,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* a7061 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7062,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7070,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7084,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2387 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[6],lf[454]);}

/* k7082 in a7061 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7068 in a7061 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7070,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7074,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7077,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2388 pproc */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k7075 in k7068 in a7061 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2388 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7074(2,t2,((C_word*)t0)[2]);}}

/* k7072 in k7068 in a7061 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7074(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7008(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7053 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7054,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* k7050 in k7040 in k7107 in k7025 in loop in k7004 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7008(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_7136 in k7133 in k6994 in body1344 in find-files in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7136(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7136,3,t0,t1,t2);}
/* posixunix.scm: 2374 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6930(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_6930r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6930r(t0,t1,t2,t3);}}

static void C_ccall f_6930r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6932,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6937,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6942,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13201328 */
t7=t6;
f_6942(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13211326 */
t9=t5;
f_6937(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body13181323 */
t11=t4;
f_6932(t11,t1,t7,t9);}}}

/* def-args1320 in process* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6942(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6942,NULL,2,t0,t1);}
/* def-env13211326 */
t2=((C_word*)t0)[2];
f_6937(t2,t1,C_SCHEME_FALSE);}

/* def-env1321 in process* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6937(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6937,NULL,3,t0,t1,t2);}
/* body13181323 */
t3=((C_word*)t0)[2];
f_6932(t3,t1,t2,C_SCHEME_FALSE);}

/* body1318 in process* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6932(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6932,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2351 %process */
f_6812(t1,lf[450],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6873(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_6873r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6873r(t0,t1,t2,t3);}}

static void C_ccall f_6873r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6875,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6880,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6885,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13001308 */
t7=t6;
f_6885(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13011306 */
t9=t5;
f_6880(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body12981303 */
t11=t4;
f_6875(t11,t1,t7,t9);}}}

/* def-args1300 in process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6885(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6885,NULL,2,t0,t1);}
/* def-env13011306 */
t2=((C_word*)t0)[2];
f_6880(t2,t1,C_SCHEME_FALSE);}

/* def-env1301 in process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6880(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6880,NULL,3,t0,t1,t2);}
/* body12981303 */
t3=((C_word*)t0)[2];
f_6875(t3,t1,t2,C_SCHEME_FALSE);}

/* body1298 in process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6875(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6875,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2348 %process */
f_6812(t1,lf[449],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6812(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6812,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6814,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t10=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6833,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm: 2337 chkstrlst */
t12=t9;
f_6814(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6867,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2339 ##sys#shell-command-arguments */
t13=*((C_word*)lf[443]+1);
((C_proc3)(void*)(*((C_word*)t13+1)))(3,t13,t12,((C_word*)t7)[1]);}}

/* k6865 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6867(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6867,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6871,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2340 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k6869 in k6865 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_6833(2,t3,t2);}

/* k6831 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6833,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6836,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2341 chkstrlst */
t3=((C_word*)t0)[2];
f_6814(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_6836(2,t3,C_SCHEME_UNDEFINED);}}

/* k6834 in k6831 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6836,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6841,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6847,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2342 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a6846 in k6834 in k6831 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6847,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2344 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2345 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a6840 in k6834 in k6831 in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6841,2,t0,t1);}
/* posixunix.scm: 2342 ##sys#process */
t2=*((C_word*)lf[447]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6814(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6814,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6823,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t5=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a6822 in chkstrlst in %process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6823(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6823,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6748(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_6748,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6754,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6760,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t9,t10);}

/* a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6760(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6760,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6771,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6791,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2318 make-on-close */
t12=((C_word*)t0)[3];
f_6577(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k6789 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2317 input-port */
t2=((C_word*)t0)[7];
f_6726(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6769 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6771,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6775,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6787,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2320 make-on-close */
t4=((C_word*)t0)[6];
f_6577(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k6785 in k6769 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2319 output-port */
t2=((C_word*)t0)[7];
f_6737(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6773 in k6769 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6775,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6779,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6783,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2323 make-on-close */
t4=((C_word*)t0)[3];
f_6577(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k6781 in k6773 in k6769 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2322 input-port */
t2=((C_word*)t0)[7];
f_6726(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6777 in k6773 in k6769 in a6759 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2316 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a6753 in ##sys#process in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6754(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6754,2,t0,t1);}
/* posixunix.scm: 2311 spawn */
t2=((C_word*)t0)[8];
f_6681(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6737(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6737,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6741,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2307 connect-parent */
t8=((C_word*)t0)[2];
f_6634(t8,t7,t4,t5);}

/* k6739 in output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2308 ##sys#custom-output-port */
t2=*((C_word*)lf[339]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6726(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6726,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6730,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2303 connect-parent */
t8=((C_word*)t0)[2];
f_6634(t8,t7,t4,t5);}

/* k6728 in input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2304 ##sys#custom-input-port */
t2=*((C_word*)lf[325]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6681(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6681,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6685,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,a[13]=((C_word*)t0)[6],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2290 needed-pipe */
t9=((C_word*)t0)[2];
f_6614(t9,t8,t6);}

/* k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6685,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6688,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2291 needed-pipe */
t3=((C_word*)t0)[2];
f_6614(t3,t2,((C_word*)t0)[5]);}

/* k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6688(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6688,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6691,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2292 needed-pipe */
t3=((C_word*)t0)[2];
f_6614(t3,t2,((C_word*)t0)[6]);}

/* k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6691,2,t0,t1);}
t2=f_6665(C_a_i(&a,3),((C_word*)t0)[13]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6702,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6704,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=((C_word*)t0)[14],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2295 process-fork */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* a6703 in k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6704,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_6708,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2297 connect-child */
t3=((C_word*)t0)[7];
f_6648(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[302]+1));}

/* k6706 in a6703 in k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6708,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6711,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_6665(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2298 connect-child */
t4=((C_word*)t0)[5];
f_6648(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[303]+1));}

/* k6709 in k6706 in a6703 in k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6711,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6714,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_6665(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2299 connect-child */
t4=((C_word*)t0)[3];
f_6648(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[304]+1));}

/* k6712 in k6709 in k6706 in a6703 in k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2300 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k6700 in k6689 in k6686 in k6683 in spawn in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2293 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swapped-ends in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6665(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(1));
t3=(C_word)C_u_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6648(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6648,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_u_i_car(t2);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6661,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2281 file-close */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k6659 in connect-child in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6661,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6573,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2255 duplicate-fileno */
t6=*((C_word*)lf[321]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k6571 in k6659 in connect-child in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2256 file-close */
t2=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6634(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6634,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6647,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2275 file-close */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k6645 in connect-parent in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6614(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6614,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6623,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6629,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 2270 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a6628 in needed-pipe in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6629(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6629,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a6622 in needed-pipe in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6623,2,t0,t1);}
/* posixunix.scm: 2270 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* make-on-close in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6577(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6577,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6579,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,tmp=(C_word)a,a+=9,tmp));}

/* f_6579 in make-on-close in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6579,2,t0,t1);}
t2=(C_word)C_i_set_i_slot(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6594,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6600,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2263 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a6599 */
static void C_ccall f_6600(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6600,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2265 ##sys#signal-hook */
t5=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[208],((C_word*)t0)[3],lf[446],((C_word*)t0)[2],t4);}}

/* a6593 */
static void C_ccall f_6594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6594,2,t0,t1);}
/* posixunix.scm: 2263 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6521(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6521r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6521r(t0,t1,t2,t3);}}

static void C_ccall f_6521r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6528,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2219 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k6526 in process-run in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6528,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2221 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6547,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k6545 in k6526 in process-run in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6547,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6551,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command-arguments */
t3=*((C_word*)lf[443]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k6549 in k6545 in k6526 in process-run in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2223 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6515,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[444],t2));}

/* ##sys#shell-command in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6506(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6506,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6510,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2208 getenv */
t3=*((C_word*)lf[135]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[442]);}

/* k6508 in ##sys#shell-command in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6510(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[441]));}

/* process-signal in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6479(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6479r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6479r(t0,t1,t2,t3);}}

static void C_ccall f_6479r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[438]);
t7=(C_word)C_i_check_exact_2(t5,lf[438]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 2205 posix-error */
t10=lf[3];
f_1678(7,t10,t1,lf[208],lf[438],lf[439],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6476(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6476,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub1166(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6473,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1163(C_SCHEME_UNDEFINED));}

/* current-process-id in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6470,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1161(C_SCHEME_UNDEFINED));}

/* process-wait in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6395(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr2r,(void*)f_6395r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6395r(t0,t1,t2);}}

static void C_ccall f_6395r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(7);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[433]);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6422,a[2]=t8,a[3]=t11,tmp=(C_word)a,a+=4,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6428,a[2]=t11,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2189 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t13,t14);}

/* a6427 in process-wait in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6428(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6428,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 2191 posix-error */
t6=lf[3];
f_1678(6,t6,t1,lf[208],lf[433],lf[434],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2192 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a6421 in process-wait in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6422,2,t0,t1);}
/* posixunix.scm: 2189 ##sys#process-wait */
t2=*((C_word*)lf[432]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6378,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 2176 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6199(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_6199r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6199r(t0,t1,t2,t3);}}

static void C_ccall f_6199r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6201,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6328,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6333,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist11011136 */
t7=t6;
f_6333(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist11021134 */
t9=t5;
f_6328(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body10991104 */
t11=t4;
f_6201(t11,t1,t7,t9);}}}

/* def-arglist1101 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6333(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6333,NULL,2,t0,t1);}
/* def-envlist11021134 */
t2=((C_word*)t0)[2];
f_6328(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist1102 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6328(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6328,NULL,3,t0,t1,t2);}
/* body10991104 */
t3=((C_word*)t0)[2];
f_6201(t3,t1,t2,C_SCHEME_FALSE);}

/* body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6201(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6201,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[430]);
t5=(C_word)C_i_check_list_2(t2,lf[430]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6211,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2144 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}

/* k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6211,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_6183(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6219,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_6219(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do1108 in k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6219(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6219,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_6183(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6232,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(C_word)C_i_check_list_2(((C_word*)t0)[5],lf[430]);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6265,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t8=t5;
f_6232(t8,f_6265(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_6232(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[430]);
t6=(C_word)C_block_size(t4);
t7=f_6183(t3,t4,t6);
t8=(C_word)C_slot(t2,C_fix(1));
t9=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* do1112 in do1108 in k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6265(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
if(C_truep((C_word)C_i_nullp(t1))){
return(f_6191(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_u_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[430]);
t5=(C_word)C_block_size(t3);
t6=f_6191(t2,t3,t5);
t7=(C_word)C_slot(t1,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k6230 in do1108 in k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6232(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6232,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6235,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6257,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2158 ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k6255 in k6230 in do1108 in k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2158 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6233 in k6230 in do1108 in k6209 in body1099 in process-execute in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub1080(C_SCHEME_UNDEFINED);
t5=(C_word)stub1092(C_SCHEME_UNDEFINED);
/* posixunix.scm: 2165 posix-error */
t6=lf[3];
f_1678(6,t6,((C_word*)t0)[3],lf[208],lf[430],lf[431],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6191(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub1085(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* setarg in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6183(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub1073(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-fork in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6145(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_6145r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_6145r(t0,t1,t2);}}

static void C_ccall f_6145r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub1056(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 2129 posix-error */
t5=lf[3];
f_1678(5,t5,t1,lf[208],lf[427],lf[428]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6167,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_slot(t2,C_fix(0));
t9=t8;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k6165 in process-fork in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6167,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6171,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_6171 in k6165 in process-fork in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6171(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6171,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub1061(C_SCHEME_UNDEFINED,t2));}

/* glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6033(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_6033r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6033r(t0,t1,t2);}}

static void C_ccall f_6033r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6039,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_6039(t6,t1,t2);}

/* conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6039(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6039,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6054,a[2]=t3,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6060,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6060(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6060,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6064,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6137,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[426]);
/* posixunix.scm: 2113 make-pathname */
t8=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k6135 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2113 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6064,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6067,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 2114 make-anchored-pattern */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6067(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6067,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6070,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 2115 regexp */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6070,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6077,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[425]);
/* posixunix.scm: 2116 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k6075 in k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6077,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6079,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6079(t5,((C_word*)t0)[2],t1);}

/* loop in k6075 in k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6079(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6079,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[8],C_fix(1));
/* posixunix.scm: 2117 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_6039(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6096,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixunix.scm: 2118 string-match */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k6094 in loop in k6075 in k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6096,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6106,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixunix.scm: 2119 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixunix.scm: 2120 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6079(t3,((C_word*)t0)[6],t2);}}

/* k6104 in k6094 in loop in k6075 in k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6106,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6110,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 2119 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6079(t4,t2,t3);}

/* k6108 in k6104 in k6094 in loop in k6075 in k6068 in k6065 in k6062 in a6059 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6110,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a6053 in conc-loop in glob in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6054,2,t0,t1);}
/* posixunix.scm: 2112 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6021,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6025,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub1016(t3),C_fix(0));}

/* k6023 in get-host-name in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6025,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6028,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_6028(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2093 posix-error */
t3=lf[3];
f_1678(5,t3,t2,lf[412],lf[416],lf[417]);}}

/* k6026 in k6023 in get-host-name in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5986(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5986,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5990,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2074 ##sys#terminal-check */
f_5940(t3,lf[411],t2);}

/* k5988 in terminal-size in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5990,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6010,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
t5=*((C_word*)lf[414]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,t2,C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6008 in k5988 in terminal-size in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6010,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6014,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[414]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6012 in k6008 in k5988 in terminal-size in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
t2=(C_word)C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=(C_word)C_i_foreign_pointer_argumentp(t3);
t5=(C_word)C_i_foreign_pointer_argumentp(t1);
t6=(C_word)stub1002(C_SCHEME_UNDEFINED,t2,t4,t5);
t7=(C_word)C_eqp(C_fix(0),t6);
if(C_truep(t7)){
/* posixunix.scm: 2081 values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm: 2082 posix-error */
t8=lf[3];
f_1678(6,t8,((C_word*)t0)[4],lf[412],lf[411],lf[413],((C_word*)t0)[6]);}}

/* terminal-name in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5967(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5967,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5971,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2066 ##sys#terminal-check */
f_5940(t3,lf[410],t2);}

/* k5969 in terminal-name in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5971,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub992(t4,t3),C_fix(0));}

/* ##sys#terminal-check in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5940(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5940,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5944,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2058 ##sys#check-port */
t5=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,t3,t2);}

/* k5942 in ##sys#terminal-check in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5944(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[94],t2);
t4=(C_truep(t3)?(C_word)C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2061 ##sys#error */
t5=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[409],((C_word*)t0)[4]);}}

/* terminal-port? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5921(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5921,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5925,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2053 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[407]);}

/* k5923 in terminal-port? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5925,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5928,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2054 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k5926 in k5923 in terminal-port? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5862(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_5862r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_5862r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5862r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5866,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2038 ##sys#check-port */
t6=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[401]);}

/* k5864 in set-buffering-mode! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5866(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5866,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5872,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[403]);
if(C_truep(t6)){
t7=t5;
f_5872(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[404]);
if(C_truep(t7)){
t8=t5;
f_5872(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[405]);
if(C_truep(t8)){
t9=t5;
f_5872(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 2044 ##sys#error */
t9=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[401],lf[406],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k5870 in k5864 in set-buffering-mode! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5872(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[401]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[94],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 2050 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[401],lf[402],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5859(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5859,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub972(C_SCHEME_UNDEFINED,t2));}

/* _exit in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5843(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_5843r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_5843r(t0,t1,t2);}}

static void C_ccall f_5843r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_slot(t2,C_fix(0)):C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub967(C_SCHEME_UNDEFINED,t4));}

/* local-timezone-abbreviation in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5835,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub962(t2),C_fix(0));}

/* utc-time->seconds in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5807(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5807,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[395]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5814,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 2006 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[395],lf[397],t2);}
else{
t6=t4;
f_5814(2,t6,C_SCHEME_UNDEFINED);}}

/* k5812 in utc-time->seconds in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 2008 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2009 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[395],lf[396],((C_word*)t0)[3]);}}

/* local-time->seconds in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5779(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5779,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[391]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5786,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1999 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[391],lf[394],t2);}
else{
t6=t4;
f_5786(2,t6,C_SCHEME_UNDEFINED);}}

/* k5784 in local-time->seconds in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 2001 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2002 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[391],lf[393],((C_word*)t0)[3]);}}

/* string->time in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5740(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5740r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5740r(t0,t1,t2,t3);}}

static void C_ccall f_5740r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?lf[390]:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[389]);
t7=(C_word)C_i_check_string_2(t5,lf[389]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5757,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k5755 in string->time in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5757,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5761,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5759 in k5755 in string->time in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5761,2,t0,t1);}
t2=(C_word)C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub943(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5665(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5665r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5665r(t0,t1,t2,t3);}}

static void C_ccall f_5665r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_vector_2(t2,lf[385]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5675,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(10)))){
/* posixunix.scm: 1979 ##sys#error */
t9=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t7,lf[385],lf[388],t2);}
else{
t9=t7;
f_5675(2,t9,C_SCHEME_UNDEFINED);}}

/* k5673 in time->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5675,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[385]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5684,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5694,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1983 ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5697,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub916(t4,t3),C_fix(0));}}

/* k5695 in k5673 in time->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1987 ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1988 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[387],((C_word*)t0)[2]);}}

/* k5692 in k5673 in time->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5694,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub922(t3,t2,t1),C_fix(0));}

/* k5682 in k5673 in time->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm: 1984 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[386],((C_word*)t0)[2]);}}

/* seconds->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5632(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5632,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5636,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub907(t5,t4),C_fix(0));}

/* k5634 in seconds->string in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1971 ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1972 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[383],lf[384],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5618(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5618,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[382]);
/* posixunix.scm: 1964 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5609(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5609,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[380]);
/* posixunix.scm: 1960 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5603(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5603,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[371]));}

/* memory-mapped-file-pointer in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5594(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5594,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[371],lf[378]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5559(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5559r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5559r(t0,t1,t2,t3);}}

static void C_ccall f_5559r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=(C_word)C_i_check_structure_2(t2,lf[371],lf[376]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)stub888(C_SCHEME_UNDEFINED,t8,t6);
t10=(C_word)C_eqp(C_fix(0),t9);
if(C_truep(t10)){
t11=t1;
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1947 posix-error */
t11=lf[3];
f_1678(7,t11,t1,lf[48],lf[376],lf[377],t2,t6);}}

/* map-file-to-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5501(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_5501r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_5501r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_5501r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5505,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_5505(2,t10,t2);}
else{
/* posixunix.scm: 1932 ##sys#null-pointer */
t10=*((C_word*)lf[375]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k5503 in map-file-to-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5505,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5511,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_5511(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1935 ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[59],lf[370],lf[374],t1);}}

/* k5509 in k5503 in map-file-to-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5511,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub863(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5517,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5530,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1937 ##sys#pointer->address */
t12=*((C_word*)lf[373]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k5528 in k5509 in k5503 in map-file-to-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1938 posix-error */
t3=lf[3];
f_1678(11,t3,((C_word*)t0)[8],lf[48],lf[370],lf[372],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_5517(2,t3,C_SCHEME_UNDEFINED);}}

/* k5515 in k5509 in k5503 in map-file-to-memory in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5517,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[371],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5418,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5424,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_5424(t5,t1,C_fix(0));}

/* loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5424(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5424,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5428,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub845(t5,t4),C_fix(0));}

/* k5426 in loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5428,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5436,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_5436(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k5426 in loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5436(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5436,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5462,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1899 ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1902 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k5460 in scan in k5426 in loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5462,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5466,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1900 ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k5464 in k5460 in scan in k5426 in loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5466,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5454,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1901 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_5424(t5,t3,t4);}

/* k5452 in k5464 in k5460 in scan in k5426 in loop in current-environment in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5454,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5403(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5403,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[359]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5411,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1888 ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k5409 in unsetenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5411(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5386(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5386,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[358]);
t5=(C_word)C_i_check_string_2(t3,lf[358]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5397,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t7=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k5395 in setenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5397,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5401,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5399 in k5395 in setenv in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5360(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5360,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[356]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5367,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5384,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1872 ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k5382 in fifo? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1872 ##sys#file-info */
t2=*((C_word*)lf[127]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5365 in fifo? in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1875 posix-error */
t2=lf[3];
f_1678(6,t2,((C_word*)t0)[3],lf[48],lf[356],lf[357],((C_word*)t0)[2]);}}

/* create-fifo in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5317r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5317r(t0,t1,t2,t3);}}

static void C_ccall f_5317r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[354]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5324,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_5324(t6,(C_word)C_slot(t3,C_fix(0)));}
else{
t6=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_5324(t7,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k5322 in create-fifo in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5324(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5324,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[354]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5341,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5345,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1866 ##sys#expand-home-path */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k5343 in k5322 in create-fifo in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1866 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5339 in k5322 in create-fifo in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1867 posix-error */
t3=lf[3];
f_1678(7,t3,((C_word*)t0)[3],lf[48],lf[354],lf[355],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5289(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5289,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[345],lf[352]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1856 posix-error */
t9=lf[3];
f_1678(6,t9,t1,lf[48],lf[352],lf[353],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5267(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5267r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5267r(t0,t1,t2,t3);}}

static void C_ccall f_5267r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5271,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1847 setup */
f_5148(t4,t2,t3,lf[350]);}

/* k5269 in file-test-lock in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1849 err */
f_5219(((C_word*)t0)[3],lf[351],t1,lf[350]);}}

/* file-lock/blocking in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5252(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5252r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5252r(t0,t1,t2,t3);}}

static void C_ccall f_5252r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5256,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1841 setup */
f_5148(t4,t2,t3,lf[348]);}

/* k5254 in file-lock/blocking in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1843 err */
f_5219(((C_word*)t0)[2],lf[349],t1,lf[348]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5237(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5237r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5237r(t0,t1,t2,t3);}}

static void C_ccall f_5237r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5241,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1835 setup */
f_5148(t4,t2,t3,lf[346]);}

/* k5239 in file-lock in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1837 err */
f_5219(((C_word*)t0)[2],lf[347],t1,lf[346]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5219(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5219,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1832 posix-error */
t8=lf[3];
f_1678(8,t8,t1,lf[48],t4,t2,t5,t6,t7);}

/* setup in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5148(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5148,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_u_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_u_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t8,C_fix(1)));
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5167,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1824 ##sys#check-port */
t16=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}

/* k5165 in setup in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5167,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5173,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_5173(t6,t5);}
else{
t5=t3;
f_5173(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k5171 in k5165 in setup in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5173(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5173,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[345],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5109,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[342]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5126,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5133,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5137,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1807 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_5126(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1809 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[342],lf[344],t2);}}}

/* k5135 in file-truncate in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1807 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5131 in file-truncate in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_5126(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k5124 in file-truncate in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1811 posix-error */
t2=lf[3];
f_1678(7,t2,((C_word*)t0)[4],lf[48],lf[342],lf[343],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr5r,(void*)f_4853r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4853r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4853r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4855,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5039,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5044,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5049,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?737778 */
t10=t9;
f_5049(t10,t1);}
else{
t10=(C_word)C_u_i_car(t5);
t11=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-bufi738776 */
t12=t8;
f_5044(t12,t1,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
if(C_truep((C_word)C_i_nullp(t13))){
/* def-on-close739773 */
t14=t7;
f_5039(t14,t1,t10,t12);}
else{
t14=(C_word)C_u_i_car(t13);
t15=(C_word)C_slot(t13,C_fix(1));
/* body735741 */
t16=t6;
f_4855(t16,t1,t10,t12,t14);}}}}

/* def-nonblocking?737 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5049(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5049,NULL,2,t0,t1);}
/* def-bufi738776 */
t2=((C_word*)t0)[2];
f_5044(t2,t1,C_SCHEME_FALSE);}

/* def-bufi738 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5044(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5044,NULL,3,t0,t1,t2);}
/* def-on-close739773 */
t3=((C_word*)t0)[2];
f_5039(t3,t1,t2,C_fix(0));}

/* def-on-close739 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5039(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5039,NULL,4,t0,t1,t2,t3);}
/* body735741 */
t4=((C_word*)t0)[2];
f_4855(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4855(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4855,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4859,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1749 ##sys#file-nonblocking! */
t6=*((C_word*)lf[9]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[6]);}
else{
t6=t5;
f_4859(2,t6,C_SCHEME_UNDEFINED);}}

/* k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4859(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[28],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4859,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4861,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=t3,a[5]=((C_word*)t0)[9],tmp=(C_word)a,a+=6,tmp));
t7=(C_word)C_fixnump(((C_word*)t0)[6]);
t8=(C_truep(t7)?((C_word*)t0)[6]:(C_word)C_block_size(((C_word*)t0)[6]));
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4907,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t10=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_4907(t11,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4951,a[2]=t3,tmp=(C_word)a,a+=3,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4965,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
/* posixunix.scm: 1768 ##sys#make-string */
t12=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,((C_word*)t0)[6]);}
else{
t12=t11;
f_4965(2,t12,((C_word*)t0)[6]);}}}

/* k4963 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4965,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_4907(t4,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4966,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp));}

/* f_4966 in k4963 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4966(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4966,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4983,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp));
t8=((C_word*)t6)[1];
f_4983(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1784 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4861(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_4983(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4983,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4993,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1774 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_4861(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_difference(t4,t2);
/* posixunix.scm: 1779 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k4991 in loop */
static void C_ccall f_4993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1776 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_4983(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_4951 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4951(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4951,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1767 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4861(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4907(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4907,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4911,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4916,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4922,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4943,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1787 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t5,t6,t7,t8);}

/* a4942 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4943,2,t0,t1);}
/* posixunix.scm: 1797 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_FALSE);}

/* a4921 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4922,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4932,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1794 posix-error */
t3=lf[3];
f_1678(7,t3,t2,lf[48],((C_word*)t0)[3],lf[341],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_4932(2,t3,C_SCHEME_UNDEFINED);}}}

/* k4930 in a4921 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4932(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1795 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a4915 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4916(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4916,3,t0,t1,t2);}
/* posixunix.scm: 1789 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t1,t2);}

/* k4909 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4911,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4914,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1798 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k4912 in k4909 in k4905 in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4861(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4861,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4877,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1757 ##sys#thread-yield! */
t8=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1759 posix-error */
t7=lf[3];
f_1678(7,t7,t1,((C_word*)t0)[3],lf[48],lf[340],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4896,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1761 ##sys#substring */
t7=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k4894 in poke in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1761 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4861(t3,((C_word*)t0)[2],t1,t2);}

/* k4875 in poke in k4857 in body735 in ##sys#custom-output-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1758 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_4861(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4382(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+19)){
C_save_and_reclaim((void*)tr5r,(void*)f_4382r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4382r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4382r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(19);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4384,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4763,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4768,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4773,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4778,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?627716 */
t11=t10;
f_4778(t11,t1);}
else{
t11=(C_word)C_u_i_car(t5);
t12=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-bufi628714 */
t13=t9;
f_4773(t13,t1,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
if(C_truep((C_word)C_i_nullp(t14))){
/* def-on-close629711 */
t15=t8;
f_4768(t15,t1,t11,t13);}
else{
t15=(C_word)C_u_i_car(t14);
t16=(C_word)C_slot(t14,C_fix(1));
if(C_truep((C_word)C_i_nullp(t16))){
/* def-more?630707 */
t17=t7;
f_4763(t17,t1,t11,t13,t15);}
else{
t17=(C_word)C_u_i_car(t16);
t18=(C_word)C_slot(t16,C_fix(1));
/* body625632 */
t19=t6;
f_4384(t19,t1,t11,t13,t15,t17);}}}}}

/* def-nonblocking?627 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4778(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4778,NULL,2,t0,t1);}
/* def-bufi628714 */
t2=((C_word*)t0)[2];
f_4773(t2,t1,C_SCHEME_FALSE);}

/* def-bufi628 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4773(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4773,NULL,3,t0,t1,t2);}
/* def-on-close629711 */
t3=((C_word*)t0)[2];
f_4768(t3,t1,t2,C_fix(1));}

/* def-on-close629 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4768(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4768,NULL,4,t0,t1,t2,t3);}
/* def-more?630707 */
t4=((C_word*)t0)[2];
f_4763(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* def-more?630 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4763(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4763,NULL,5,t0,t1,t2,t3,t4);}
/* body625632 */
t5=((C_word*)t0)[2];
f_4384(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4384(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4384,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4388,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=t3,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1627 ##sys#file-nonblocking! */
t7=*((C_word*)lf[9]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}
else{
t7=t6;
f_4388(2,t7,C_SCHEME_UNDEFINED);}}

/* k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4388,2,t0,t1);}
t2=(C_word)C_fixnump(((C_word*)t0)[10]);
t3=(C_truep(t2)?((C_word*)t0)[10]:(C_word)C_block_size(((C_word*)t0)[10]));
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4394,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[10]))){
/* posixunix.scm: 1629 ##sys#make-string */
t5=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[10]);}
else{
t5=t4;
f_4394(2,t5,((C_word*)t0)[10]);}}

/* k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[65],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4394,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4395,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4410,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4418,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4500,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4505,a[2]=t8,a[3]=t5,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4518,a[2]=t6,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4530,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,tmp=(C_word)a,a+=7,tmp);
t15=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4551,a[2]=t8,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4560,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t17=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4636,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1673 make-input-port */
t18=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t18+1)))(8,t18,t11,t12,t13,t14,t15,t16,t17);}

/* a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4636(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4636,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4642,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_4642(t7,t1,C_SCHEME_FALSE);}

/* loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4642(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4642,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4644,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4722,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4728,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1732 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4738,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1738 fetch */
t5=((C_word*)t0)[5];
f_4418(t5,t4);}}

/* k4736 in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm: 1740 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4642(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a4727 in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4728(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4728,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm: 1735 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4642(t4,t1,t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a4721 in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4722,2,t0,t1);}
/* posixunix.scm: 1733 ##sys#scan-buffer-line */
t2=*((C_word*)lf[336]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4644(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4644,4,t0,t1,t2,t3);}
t4=(C_word)C_u_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4651,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_4651(2,t8,(C_truep(t7)?t7:lf[333]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4694,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1715 ##sys#make-string */
t8=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t4);}}

/* k4692 in bumper in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(5));
t4=(C_word)C_u_fixnum_plus(t3,((C_word*)t0)[4]);
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm: 1721 ##sys#string-append */
t6=*((C_word*)lf[334]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=((C_word*)t0)[2];
f_4651(2,t6,t1);}}

/* k4649 in bumper in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4651,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=(C_word)C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4661,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1725 fetch */
t5=((C_word*)t0)[3];
f_4418(t5,t4);}
else{
t4=(C_word)C_slot(((C_word*)t0)[2],C_fix(4));
t5=(C_word)C_u_fixnum_plus(t4,C_fix(1));
t6=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm: 1730 values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k4659 in k4649 in bumper in loop in a4635 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm: 1726 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a4559 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4560(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4560,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4568,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_4568(t7,t3);}
else{
t7=(C_word)C_block_size(t4);
t8=t6;
f_4568(t8,(C_word)C_u_fixnum_difference(t7,t5));}}

/* k4566 in a4559 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4568(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4568,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4570,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_4570(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k4566 in a4559 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4570(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4570,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}
else{
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=(C_word)C_u_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=(C_word)C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=(C_word)C_u_fixnum_difference(t2,t8);
t14=(C_word)C_u_fixnum_plus(t3,t8);
t15=(C_word)C_u_fixnum_plus(t4,t8);
/* posixunix.scm: 1701 loop */
t18=t1;
t19=t13;
t20=t14;
t21=t15;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4618,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1703 fetch */
t7=((C_word*)t0)[2];
f_4418(t7,t6);}}}

/* k4616 in loop in k4566 in a4559 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm: 1706 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4570(t3,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* a4550 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4551,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4555,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1691 fetch */
t3=((C_word*)t0)[2];
f_4418(t3,t2);}

/* k4553 in a4550 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1692 peek */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_4410(((C_word*)t0)[2]));}

/* a4529 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4530,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4540,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1688 posix-error */
t3=lf[3];
f_1678(7,t3,t2,lf[48],((C_word*)t0)[3],lf[332],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_4540(2,t3,C_SCHEME_UNDEFINED);}}}

/* k4538 in a4529 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1689 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a4517 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4518,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1683 ready? */
t3=((C_word*)t0)[2];
f_4395(t3,t1);}}

/* a4504 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4505,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4509,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1675 fetch */
t3=((C_word*)t0)[2];
f_4418(t3,t2);}

/* k4507 in a4504 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_4410(((C_word*)t0)[4]);
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k4498 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4500,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4503,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1742 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k4501 in k4498 in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4418(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4418,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4430,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4430(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4430(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4430,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4446,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1650 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[328]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[329]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1653 posix-error */
t5=lf[3];
f_1678(7,t5,t1,lf[48],((C_word*)t0)[6],lf[330],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4467,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1657 more? */
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k4465 in loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4467,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4470,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1659 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4476,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_4476(2,t8,t7);}
else{
/* posixunix.scm: 1665 posix-error */
t7=lf[3];
f_1678(7,t7,t4,lf[48],((C_word*)t0)[3],lf[331],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_4476(2,t6,C_SCHEME_UNDEFINED);}}}

/* k4474 in k4465 in loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4468 in k4465 in loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1660 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4430(t2,((C_word*)t0)[2]);}

/* k4444 in loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4446,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4449,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1651 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4447 in k4444 in loop in fetch in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1652 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4430(t2,((C_word*)t0)[2]);}

/* peek in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_4410(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4395(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4395,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4409,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1635 ##sys#file-select-one */
t3=*((C_word*)lf[10]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k4407 in ready? in k4392 in k4386 in body625 in ##sys#custom-input-port in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1636 posix-error */
t3=lf[3];
f_1678(7,t3,((C_word*)t0)[5],lf[48],((C_word*)t0)[4],lf[326],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4355(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4355r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4355r(t0,t1,t2,t3);}}

static void C_ccall f_4355r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[321]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4362,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_4362(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_slot(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[321]);
t8=t5;
f_4362(t8,(C_word)C_dup2(t2,t6));}}

/* k4360 in duplicate-fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4362(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4362,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4365,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1620 posix-error */
t3=lf[3];
f_1678(6,t3,t2,lf[48],lf[321],lf[322],((C_word*)t0)[2]);}
else{
t3=t2;
f_4365(2,t3,C_SCHEME_UNDEFINED);}}

/* k4363 in k4360 in duplicate-fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4310(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4310,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4314,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1602 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[315]);}

/* k4312 in port->fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4314(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4314,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[316],t2);
if(C_truep(t3)){
/* posixunix.scm: 1603 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[317]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4349,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1604 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k4347 in k4312 in port->fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4349,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1609 posix-error */
t2=lf[3];
f_1678(6,t2,((C_word*)t0)[3],lf[59],lf[315],lf[318],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4332,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1607 posix-error */
t4=lf[3];
f_1678(6,t4,t3,lf[48],lf[315],lf[319],((C_word*)t0)[2]);}
else{
t4=t3;
f_4332(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4330 in k4347 in k4312 in port->fileno in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4296(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4296r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4296r(t0,t1,t2,t3);}}

static void C_ccall f_4296r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[314]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4308,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1598 mode */
f_4230(t5,C_SCHEME_FALSE,t3);}

/* k4306 in open-output-file* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4308,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1598 check */
f_4267(((C_word*)t0)[2],lf[314],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4282r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4282r(t0,t1,t2,t3);}}

static void C_ccall f_4282r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[313]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4294,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1594 mode */
f_4230(t5,C_SCHEME_TRUE,t3);}

/* k4292 in open-input-file* in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4294(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4294,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1594 check */
f_4267(((C_word*)t0)[2],lf[313],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4267(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4267,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1587 posix-error */
t6=lf[3];
f_1678(6,t6,t1,lf[48],t2,lf[311],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4280,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1588 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[312],lf[94]);}}

/* k4278 in check in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4230(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4230,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4238,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[305]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1581 ##sys#error */
t8=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[306],t5);}
else{
t8=t4;
f_4238(2,t8,lf[307]);}}
else{
/* posixunix.scm: 1582 ##sys#error */
t7=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[308],t5);}}
else{
t5=t4;
f_4238(2,t5,(C_truep(t2)?lf[309]:lf[310]));}}

/* k4236 in mode in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4238(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1577 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4205(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4205,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[299]);
t5=(C_word)C_i_check_string_2(t3,lf[299]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4194,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_4194(2,t9,C_SCHEME_FALSE);}}

/* k4192 in file-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4194,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4198,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_4198(2,t3,C_SCHEME_FALSE);}}

/* k4196 in k4192 in file-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub569(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1562 posix-error */
t3=lf[3];
f_1678(7,t3,((C_word*)t0)[4],lf[48],lf[300],lf[301],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4163(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4163,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[297]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4171,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4187,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1551 ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4185 in read-symbolic-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1551 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4169 in read-symbolic-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4171,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4174,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1553 posix-error */
t4=lf[3];
f_1678(6,t4,t3,lf[48],lf[297],lf[298],((C_word*)t0)[2]);}
else{
t4=t3;
f_4174(2,t4,C_SCHEME_UNDEFINED);}}

/* k4172 in k4169 in read-symbolic-link in k4160 in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1554 substring */
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4125(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4125,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[293]);
t5=(C_word)C_i_check_string_2(t3,lf[293]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4146,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4158,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1539 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4156 in create-symbolic-link in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1539 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4144 in create-symbolic-link in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4146,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4150,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4154,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1540 ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4152 in k4144 in create-symbolic-link in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1540 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4148 in k4144 in create-symbolic-link in k4121 in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1542 posix-error */
t3=lf[3];
f_1678(7,t3,((C_word*)t0)[4],lf[48],lf[294],lf[295],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4100(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4100,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[290]);
t5=(C_word)C_i_check_exact_2(t3,lf[290]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4116,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1517 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k4114 in set-process-group-id! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4116(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1518 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[290],lf[291],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-session in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4085,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4089,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4095,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1509 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_4089(2,t4,C_SCHEME_UNDEFINED);}}

/* k4093 in create-session in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1510 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[288],lf[289]);}

/* k4087 in create-session in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4079(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4079,3,t0,t1,t2);}
/* posixunix.scm: 1504 check */
f_4043(t1,t2,C_fix((C_word)X_OK),lf[287]);}

/* file-write-access? in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4073(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4073,3,t0,t1,t2);}
/* posixunix.scm: 1503 check */
f_4043(t1,t2,C_fix((C_word)W_OK),lf[286]);}

/* file-read-access? in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4067(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4067,3,t0,t1,t2);}
/* posixunix.scm: 1502 check */
f_4043(t1,t2,C_fix((C_word)R_OK),lf[285]);}

/* check in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4043(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4043,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4061,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4065,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1499 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4063 in check in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1499 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4059 in check in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4061,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4053,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_4053(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1500 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4051 in k4059 in check in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4013(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4013,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[283]);
t6=(C_word)C_i_check_exact_2(t3,lf[283]);
t7=(C_word)C_i_check_exact_2(t4,lf[283]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4037,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4041,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1489 ##sys#expand-home-path */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k4039 in change-file-owner in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1489 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4035 in change-file-owner in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1490 posix-error */
t3=lf[3];
f_1678(8,t3,((C_word*)t0)[3],lf[48],lf[283],lf[284],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3986(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3986,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[281]);
t5=(C_word)C_i_check_exact_2(t3,lf[281]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4007,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4011,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1481 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4009 in change-file-mode in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1481 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4005 in change-file-mode in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1482 posix-error */
t3=lf[3];
f_1678(7,t3,((C_word*)t0)[3],lf[48],lf[281],lf[282],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3922(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3922,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[240]);
t5=(C_word)C_i_check_exact_2(t3,lf[240]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3918,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_3918(2,t9,C_SCHEME_FALSE);}}

/* k3916 in initialize-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3918,2,t0,t1);}
t2=(C_word)stub509(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[5]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3938,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1402 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3936 in k3916 in initialize-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1403 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[240],lf[241],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3856(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3856,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3860,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_3790(t4);
if(C_truep(t5)){
t6=t3;
f_3860(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1385 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[237],lf[239]);}}

/* k3858 in set-groups! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3860(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3860,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3865,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3865(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do496 in k3858 in set-groups! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3865(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3865,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3881,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1390 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[237]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k3879 in do496 in k3858 in set-groups! in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1391 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[237],lf[238],((C_word*)t0)[2]);}

/* get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3793,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3797,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3851,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1371 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3797(2,t4,C_SCHEME_UNDEFINED);}}

/* k3849 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1372 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[236]);}

/* k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3797,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3800,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_3790(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_3800(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1374 ##sys#error */
t4=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[233],lf[235]);}}

/* k3798 in k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3800(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3800,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3803,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)stub478(C_SCHEME_UNDEFINED,((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3832,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1376 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_3803(2,t4,C_SCHEME_UNDEFINED);}}

/* k3830 in k3798 in k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1377 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[234]);}

/* k3801 in k3798 in k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3803(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3803,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3808,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3808(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k3801 in k3798 in k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3808(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3808,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3822,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1381 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k3820 in loop in k3801 in k3798 in k3795 in get-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3822,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_3790(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub482(C_SCHEME_UNDEFINED,t1));}

/* group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3715r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3715r(t0,t1,t2,t3);}}

static void C_ccall f_3715r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3722,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_3722(t7,(C_word)C_getgrgid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[231]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3773,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1345 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k3771 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3722(t2,(C_word)C_getgrnam(t1));}

/* k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3722(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3722,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3732,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3732,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3736,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k3734 in k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3736,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3740,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3745,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_3745(t6,t2,C_fix(0));}

/* loop in k3734 in k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3745(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3745,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3749,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub461(t5,t4),C_fix(0));}

/* k3747 in loop in k3734 in k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3749,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3759,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1354 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3745(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k3757 in k3747 in loop in k3734 in k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3759(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3759,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k3738 in k3734 in k3730 in k3720 in group-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3695,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3703,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3707,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1330 current-effective-user-id */
t4=*((C_word*)lf[222]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3705 in current-effective-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3707(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1330 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3701 in current-effective-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3703(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* current-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3681,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3689,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3693,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1327 current-user-id */
t4=*((C_word*)lf[221]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3691 in current-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1327 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3687 in current-user-name in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3621(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3621r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3621r(t0,t1,t2,t3);}}

static void C_ccall f_3621r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3628,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_3628(t7,(C_word)C_getpwuid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[227]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3667,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1315 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k3665 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3667(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3628(t2,(C_word)C_getpwnam(t1));}

/* k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3628(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3628,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3636 in k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3638,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3642,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k3640 in k3636 in k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3642,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3646,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k3644 in k3640 in k3636 in k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3646,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3650,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k3648 in k3644 in k3640 in k3636 in k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3650,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3654,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k3652 in k3648 in k3644 in k3640 in k3636 in k3626 in user-information in k3617 in k3613 in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3654(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[7])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc9)(void*)(*((C_word*)t3+1)))(9,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-group-id! in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3598(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3598,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3608,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1285 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3606 in set-group-id! in k3594 in k3590 in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1286 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[224],((C_word*)t0)[2]);}

/* set-user-id! in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3575(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3575,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3585,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1265 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3583 in set-user-id! in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1266 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[220],((C_word*)t0)[2]);}

/* system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3537,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3541,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3570,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1254 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_3541(2,t3,C_SCHEME_UNDEFINED);}}

/* k3568 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1255 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[216],lf[218]);}

/* k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3541,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3548,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k3546 in k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3548,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3552,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k3550 in k3546 in k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3552,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3556,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k3554 in k3550 in k3546 in k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3556,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3560,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k3558 in k3554 in k3550 in k3546 in k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3560,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3564,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k3562 in k3558 in k3554 in k3550 in k3546 in k3539 in system-information in k3533 in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3564,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3519(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3519,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[214]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1233 posix-error */
t5=lf[3];
f_1678(5,t5,t1,lf[208],lf[214],lf[215]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3504(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3504,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1227 posix-error */
t5=lf[3];
f_1678(5,t5,t1,lf[208],lf[212],lf[213]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3498(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3498,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[211]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3466,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3472,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_3472(t5,t1,*((C_word*)lf[203]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3472(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3472,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1217 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3442(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3442,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[207]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3449,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3460,tmp=(C_word)a,a+=2,tmp);
/* for-each */
t7=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a3459 in set-signal-mask! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3460(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3460,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[207]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k3447 in set-signal-mask! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1210 posix-error */
t2=lf[3];
f_1678(5,t2,((C_word*)t0)[2],lf[208],lf[207],lf[209]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3424,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3434,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1196 h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixunix.scm: 1198 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k3432 in ##sys#interrupt-hook in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1197 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3411,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[206]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k3398 in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3402(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3402,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[205]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3355,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3359,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 1113 posix-error */
t3=lf[3];
f_1678(5,t3,t2,lf[48],lf[176],lf[177]);}
else{
t3=t2;
f_3359(2,t3,C_SCHEME_UNDEFINED);}}

/* k3357 in create-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3359(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1114 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3335(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3335r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3335r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3335r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[175]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3339,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3337 in with-output-to-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3339,2,t0,t1);}
t2=C_mutate((C_word*)lf[175]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3345,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1101 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3344 in k3337 in with-output-to-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3345(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3345r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3345r(t0,t1,t2);}}

static void C_ccall f_3345r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3349,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1103 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3347 in a3344 in k3337 in with-output-to-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[175]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3315r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3315r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3315r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[173]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3319,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3317 in with-input-from-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3319(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3319,2,t0,t1);}
t2=C_mutate((C_word*)lf[173]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3325,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1091 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3324 in k3317 in with-input-from-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3325(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3325r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3325r(t0,t1,t2);}}

static void C_ccall f_3325r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3329,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1093 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3327 in a3324 in k3317 in with-input-from-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3329(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[173]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3291r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3291r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3291r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3295,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3293 in call-with-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3295,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3300,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3306,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1081 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3305 in k3293 in call-with-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3306(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3306r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3306r(t0,t1,t2);}}

static void C_ccall f_3306r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3310,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1084 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3308 in a3305 in k3293 in call-with-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3299 in k3293 in call-with-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3300,2,t0,t1);}
/* posixunix.scm: 1082 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3267r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3267r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3267r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3271,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3269 in call-with-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3271,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3276,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3282,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1073 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3281 in k3269 in call-with-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3282r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3282r(t0,t1,t2);}}

static void C_ccall f_3282r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3286,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1076 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3284 in a3281 in k3269 in call-with-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3275 in k3269 in call-with-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3276,2,t0,t1);}
/* posixunix.scm: 1074 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3251(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3251,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3255,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1060 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[165]);}

/* k3253 in close-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3255,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3258,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 1062 posix-error */
t5=lf[3];
f_1678(6,t5,t3,lf[48],lf[166],lf[167],((C_word*)t0)[3]);}
else{
t5=t3;
f_3258(2,t5,C_SCHEME_UNDEFINED);}}

/* k3256 in k3253 in close-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3215(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3215r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3215r(t0,t1,t2,t3);}}

static void C_ccall f_3215r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[164]);
t5=f_3146(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3229,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3236,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1055 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3246,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1056 ##sys#make-c-string */
t10=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1057 badmode */
f_3158(t6,t5);}}}

/* k3244 in open-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3246,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3229(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k3234 in open-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3236,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3229(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k3227 in open-output-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1051 check */
f_3164(((C_word*)t0)[3],lf[164],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3179(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3179r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3179r(t0,t1,t2,t3);}}

static void C_ccall f_3179r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[162]);
t5=f_3146(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3193,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3200,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1044 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3210,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1045 ##sys#make-c-string */
t10=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1046 badmode */
f_3158(t6,t5);}}}

/* k3208 in open-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3210,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3193(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k3198 in open-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3200,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3193(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k3191 in open-input-pipe in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1040 check */
f_3164(((C_word*)t0)[3],lf[162],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3164(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3164,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1032 posix-error */
t6=lf[3];
f_1678(6,t6,t1,lf[48],t2,lf[158],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3177,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1033 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[161],lf[94]);}}

/* k3175 in check in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3158(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3158,NULL,2,t1,t2);}
/* posixunix.scm: 1029 ##sys#error */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[157],t2);}

/* mode in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_3146(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[155]));}

/* canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2829(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2829,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[115]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2836,a[2]=t1,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2950,a[2]=t4,a[3]=((C_word*)t0)[11],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 977  cwd */
t8=((C_word*)t0)[6];
f_2773(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2956,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[12],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[11],a[10]=t2,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3136,a[2]=((C_word*)t0)[12],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 979  sref */
t10=((C_word*)t0)[9];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_2956(t9,C_SCHEME_FALSE);}}}

/* k3134 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3136(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 979  sep? */
t2=((C_word*)t0)[3];
f_2956(t2,f_2762(t1));}

/* k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2956(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2956,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[11];
f_2836(2,t2,((C_word*)t0)[10]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[10]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2969,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[11],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 982  cwd */
t5=((C_word*)t0)[8];
f_2773(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2975,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[9],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3111,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3122,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 983  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[10],C_fix(0));}}}

/* k3120 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 983  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3109 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3111,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3118,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 984  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2975(t2,C_SCHEME_FALSE);}}

/* k3116 in k3109 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 984  sep? */
t2=((C_word*)t0)[3];
f_2975(t2,f_2762(t1));}

/* k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2975(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[32],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2975,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2982,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 986  getenv */
t3=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[152]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[9]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3013,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 991  cwd */
t5=((C_word*)t0)[6];
f_2773(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3019,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3083,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3104,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 992  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[9],C_fix(0));}}}

/* k3102 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 992  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3081 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3083,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3089,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3100,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 993  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_3019(t2,C_SCHEME_FALSE);}}

/* k3098 in k3081 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 993  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3087 in k3081 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3089,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3096,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 994  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_3019(t2,C_SCHEME_FALSE);}}

/* k3094 in k3087 in k3081 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 994  sep? */
t2=((C_word*)t0)[3];
f_3019(t2,f_2762(t1));}

/* k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3019(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3019,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[9]);
/* posixunix.scm: 995  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3032,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3059,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3080,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 996  sref */
t5=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],C_fix(0));}}

/* k3078 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 996  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3057 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3059,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3065,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3076,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 997  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3032(2,t2,C_SCHEME_FALSE);}}

/* k3074 in k3057 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 997  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3063 in k3057 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3065,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3072,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 998  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3032(2,t2,C_SCHEME_FALSE);}}

/* k3070 in k3063 in k3057 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 998  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3030 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3032,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[7]);
/* posixunix.scm: 999  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3056,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1000 sref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[7],C_fix(0));}}

/* k3054 in k3030 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3056,2,t0,t1);}
t2=f_2762(t1);
if(C_truep(t2)){
t3=((C_word*)t0)[5];
f_2836(2,t3,((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3052,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1003 cwd */
t4=((C_word*)t0)[2];
f_2773(t4,t3);}}

/* k3050 in k3054 in k3030 in k3017 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1003 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[154],((C_word*)t0)[2]);}

/* k3011 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 991  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[153],((C_word*)t0)[2]);}

/* k2980 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2982,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2985,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;
f_2985(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3000,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 987  user */
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2998 in k2980 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 987  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[151],t1);}

/* k2983 in k2980 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2985,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2989,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 988  ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k2987 in k2983 in k2980 in k2973 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 985  sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2967 in k2954 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 982  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[150],((C_word*)t0)[2]);}

/* k2948 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 977  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[149]);}

/* k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2836,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2843,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=t1;
/* string-split */
t4=*((C_word*)lf[114]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,lf[148]);}

/* k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2843,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2845,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_2845(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2845(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2845,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2852,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1006 null? */
t5=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2852,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2858,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1007 null? */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2913,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2916,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[8],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_u_i_car(((C_word*)t0)[4]);
/* posixunix.scm: 1018 string=? */
t6=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[147],t5);}}

/* k2914 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2916,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_2913(t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2925,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(((C_word*)t0)[3]);
/* posixunix.scm: 1020 string=? */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[146],t3);}}

/* k2923 in k2914 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2925,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_2913(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_u_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_2913(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k2911 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2913(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1016 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2845(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2858,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[141]);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2894,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[3]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixunix.scm: 1009 sref */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,((C_word*)t0)[3],t4);}}

/* k2892 in k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2894(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2894,2,t0,t1);}
t2=f_2762(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2871,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2875,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_a_i_cons(&a,2,lf[143],((C_word*)t0)[2]);
/* posixunix.scm: 1012 reverse */
t6=*((C_word*)lf[144]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2886,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2890,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1015 reverse */
t5=*((C_word*)lf[144]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k2888 in k2892 in k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1015 isperse */
f_2757(((C_word*)t0)[2],t1);}

/* k2884 in k2892 in k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1013 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[145],t1);}

/* k2873 in k2892 in k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1012 isperse */
f_2757(((C_word*)t0)[2],t1);}

/* k2869 in k2892 in k2856 in k2850 in loop in k2841 in k2834 in canonical-path in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1010 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[142],t1);}

/* cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2773(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2773,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2780,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2782,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2782(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2782,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2788,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2806,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[139]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t3,t4);}

/* a2805 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2806(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2806,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2812,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2818,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t2,t3);}

/* a2817 in a2805 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2818(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2818r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2818r(t0,t1,t2);}}

static void C_ccall f_2818r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2824,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2823 in a2817 in a2805 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2824,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2811 in a2805 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2812,2,t0,t1);}
/* posixunix.scm: 972  cw */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a2787 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2788(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2788,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2794,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2793 in a2787 in a2781 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2794(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2794,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[137]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[138]);}

/* k2778 in cwd in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* sep? in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_2762(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2757(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2757,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[133]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,lf[134]);}

/* current-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2716(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2716r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2716r(t0,t1,t2);}}

static void C_ccall f_2716r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_slot(t2,C_fix(0)));
if(C_truep(t4)){
/* posixunix.scm: 950  change-directory */
t5=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2729,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 951  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}}

/* k2727 in current-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 954  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 955  posix-error */
t3=lf[3];
f_1678(5,t3,((C_word*)t0)[2],lf[48],lf[125],lf[128]);}}

/* directory? in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2693(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2693,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[126]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2700,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2714,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 943  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2712 in directory? in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 943  ##sys#file-info */
t2=*((C_word*)lf[127]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2698 in directory? in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2539(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_2539r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2539r(t0,t1,t2);}}

static void C_ccall f_2539r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2541,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2639,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2644,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec250275 */
t6=t5;
f_2644(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?251273 */
t8=t4;
f_2639(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body248253 */
t10=t3;
f_2541(t10,t1,t6,t8);}}}

/* def-spec250 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2644(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2644,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2652,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 916  current-directory */
t3=*((C_word*)lf[125]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2650 in def-spec250 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2652(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?251273 */
t2=((C_word*)t0)[3];
f_2639(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?251 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2639(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2639,NULL,3,t0,t1,t2);}
/* body248253 */
t3=((C_word*)t0)[2];
f_2541(t3,t1,t2,C_SCHEME_FALSE);}

/* body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2541(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2541,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[122]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2548,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 918  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}

/* k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2548,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2551,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 919  ##sys#make-pointer */
t3=*((C_word*)lf[124]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2551,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2554,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 920  ##sys#make-pointer */
t3=*((C_word*)lf[124]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2554,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2558,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2638,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 921  ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[5]);}

/* k2636 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 921  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2558,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[8]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[8]))){
/* posixunix.scm: 923  posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[7],lf[48],lf[122],lf[123],((C_word*)t0)[6]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2572,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2572(t6,((C_word*)t0)[7]);}}

/* loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2572(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2572,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[7],((C_word*)t0)[6]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[6]))){
t3=(C_word)C_closedir(((C_word*)t0)[7]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[6],((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2582,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 931  ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t3);}}

/* k2580 in loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2582(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2582,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2585,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 932  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,t1,C_fix(0));}

/* k2583 in k2580 in loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2585,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2588,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
/* posixunix.scm: 933  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[5],C_fix(1));}
else{
t3=t2;
f_2588(2,t3,C_SCHEME_FALSE);}}

/* k2586 in k2583 in k2580 in loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2588,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2594,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_make_character(46),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(C_word)C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_2594(t5,t4);}
else{
t5=(C_word)C_eqp(C_make_character(46),t1);
t6=(C_truep(t5)?(C_word)C_eqp(C_fix(2),((C_word*)t0)[3]):C_SCHEME_FALSE);
t7=t2;
f_2594(t7,(C_truep(t6)?t6:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t4=t2;
f_2594(t4,C_SCHEME_FALSE);}}

/* k2592 in k2586 in k2583 in k2580 in loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2594(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2594,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 938  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2572(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2604,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 939  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2572(t3,t2);}}

/* k2602 in k2592 in k2586 in k2583 in k2580 in loop in k2556 in k2552 in k2549 in k2546 in body248 in directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2604,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2515,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[118]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2533,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2537,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 909  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2535 in delete-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 909  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2531 in delete-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 910  posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[118],lf[119],((C_word*)t0)[2]);}}

/* change-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2491(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2491,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[116]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2509,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2513,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 903  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2511 in change-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 903  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2507 in change-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 904  posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[116],lf[117],((C_word*)t0)[2]);}}

/* create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2390(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2390r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2390r(t0,t1,t2,t3);}}

static void C_ccall f_2390r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(6);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[112]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2403,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 895  canonical-path */
t8=*((C_word*)lf[115]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2463,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 896  canonical-path */
t8=*((C_word*)lf[115]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}}

/* k2461 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2463,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2477,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k2475 in k2461 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[100]+1),((C_word*)t0)[2]);}}

/* k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2403,2,t0,t1);}
t2=*((C_word*)lf[110]+1);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2408,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2460,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-split */
t6=*((C_word*)lf[114]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t1,*((C_word*)lf[106]+1));}

/* k2458 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* for-each */
t2=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2408(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2408,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2413,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-append */
t4=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],*((C_word*)lf[108]+1),t2);}

/* k2411 in a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2413,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2419,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2436,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* file-exists? */
t6=*((C_word*)lf[113]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

/* k2434 in k2411 in a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2436,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2456,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2419(2,t2,C_SCHEME_FALSE);}}

/* k2454 in k2434 in k2411 in a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_stat(t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[104]+1),((C_word*)t0)[2]);}
else{
t3=C_mk_bool(C_isdir);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
f_2419(2,t4,t3);}
else{
/* posix-error */
t4=lf[3];
f_1678(6,t4,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[102]+1),((C_word*)t0)[2]);}}}

/* k2417 in k2411 in a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2419,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2433,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k2431 in k2417 in k2411 in a2407 in k2401 in create-directory in k2380 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1678(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[100]+1),((C_word*)t0)[2]);}}

/* set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2322(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2322r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2322r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2322r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[92]);
t8=(C_word)C_i_check_exact_2(t6,lf[92]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2335,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 839  ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[97],lf[92],lf[98],t3,t2);}
else{
t10=t9;
f_2335(2,t10,C_SCHEME_UNDEFINED);}}

/* k2333 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2335,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2341,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2347,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 840  port? */
t4=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2345 in k2333 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[94]);
t4=((C_word*)t0)[4];
f_2341(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_2341(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 844  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[59],lf[92],lf[95],((C_word*)t0)[5]);}}}

/* k2339 in k2333 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 845  posix-error */
t2=lf[3];
f_1678(7,t2,((C_word*)t0)[4],lf[48],lf[92],lf[93],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* stat-socket? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2313(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2313,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[91]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2320,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 831  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[91]);}

/* k2318 in stat-socket? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_issock));}

/* stat-symlink? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2304(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2304,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2311,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#stat */
f_2143(t4,t2,C_SCHEME_TRUE,lf[90]);}

/* k2309 in stat-symlink? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* stat-fifo? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2295(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2295,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[89]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2302,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 821  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[89]);}

/* k2300 in stat-fifo? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isfifo));}

/* stat-block-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2286(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2286,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[88]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2293,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 816  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[88]);}

/* k2291 in stat-block-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isblk));}

/* stat-char-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2277(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2277,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[87]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2284,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 811  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[87]);}

/* k2282 in stat-char-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_ischr));}

/* stat-directory? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2268(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2268,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[86]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2275,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 806  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[86]);}

/* k2273 in stat-directory? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isdir));}

/* stat-regular? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2259(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2259,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2266,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 801  ##sys#stat */
f_2143(t4,t2,C_SCHEME_FALSE,lf[85]);}

/* k2264 in stat-regular? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* symbolic-link? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2250(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2250,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[84]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2257,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 796  ##sys#stat */
f_2143(t4,t2,C_SCHEME_TRUE,lf[84]);}

/* k2255 in symbolic-link? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2241(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2241,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[83]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2248,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 791  ##sys#stat */
f_2143(t4,t2,C_SCHEME_TRUE,lf[83]);}

/* k2246 in regular-file? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2235(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2235,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2239,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 787  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[82]);}

/* k2237 in file-permissions in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2229(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2229,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2233,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 786  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[81]);}

/* k2231 in file-owner in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2233(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2223(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2223,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2227,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 785  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[80]);}

/* k2225 in file-change-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2227,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2217(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2217,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2221,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 784  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[79]);}

/* k2219 in file-access-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2221,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2211,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2215,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 783  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[78]);}

/* k2213 in file-modification-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2215(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2215,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2205(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2205,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2209,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 782  ##sys#stat */
f_2143(t3,t2,C_SCHEME_FALSE,lf[77]);}

/* k2207 in file-size in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2209,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2180(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2180r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2180r(t0,t1,t2,t3);}}

static void C_ccall f_2180r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2184,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_vemptyp(t3);
t6=(C_truep(t5)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
/* posixunix.scm: 775  ##sys#stat */
f_2143(t4,t2,t6,lf[76]);}

/* k2182 in file-stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2184,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2143(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2143,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2147,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_2147(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2168,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2175,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 766  ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 770  ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[59],lf[75],t2);}}}

/* k2173 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 766  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2166 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2147(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k2145 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 772  posix-error */
t2=lf[3];
f_1678(6,t2,((C_word*)t0)[4],lf[48],((C_word*)t0)[3],lf[74],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1951(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1951r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1951r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1951r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1945(C_fix(0));
t10=f_1945(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1967,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1967(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 695  fd_set */
t14=t12;
f_1967(2,t14,f_1947(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[67]);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2124,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* for-each */
t15=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a2123 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2124(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2124,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[67]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 702  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_1947(C_fix(0),t2));}

/* k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1967,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1973,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1973(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 707  fd_set */
t5=t3;
f_1973(2,t5,f_1947(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[67]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2098,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t6=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a2097 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2098(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2098,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[67]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 714  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_1947(C_fix(1),t2));}

/* k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1973,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1976,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_number_2(((C_word*)t0)[3],lf[67]);
t4=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1976(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1976(t4,(C_word)C_C_select(t3));}}

/* k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_1976(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1976,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 721  posix-error */
t2=lf[3];
f_1678(7,t2,((C_word*)t0)[5],lf[48],lf[67],lf[68],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 722  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2015,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 727  fd_test */
t4=t3;
f_2015(t4,f_1949(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2056,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2058,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t8=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_2015(t4,C_SCHEME_FALSE);}}}}

/* a2057 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2058(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2058,3,t0,t1,t2);}
t3=f_1949(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2054 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2015(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2013 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2015(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2015,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2019,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 733  fd_test */
t3=t2;
f_2019(t3,f_1949(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2031,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2033,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t7=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_2019(t3,C_SCHEME_FALSE);}}

/* a2032 in k2013 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2033(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2033,3,t0,t1,t2);}
t3=f_1949(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2029 in k2013 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2019(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2017 in k2013 in k1974 in k1971 in k1965 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2019(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 724  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1949(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub92(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_set in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1947(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub86(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1945(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub81(C_SCHEME_UNDEFINED,t1));}

/* file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1913(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1913,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[64]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1920,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 673  ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1918 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1920,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1926,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 677  posix-error */
t6=lf[3];
f_1678(6,t6,t4,lf[48],lf[64],lf[66],((C_word*)t0)[2]);}
else{
t6=t4;
f_1926(2,t6,C_SCHEME_UNDEFINED);}}

/* k1924 in k1918 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1926(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1926,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1933,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 678  ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1931 in k1924 in k1918 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1933(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 678  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1874(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1874r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1874r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1874r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[61]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1881,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1881(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 662  ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[59],lf[61],lf[63],t3);}}

/* k1879 in file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1881,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[61]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1890,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 667  posix-error */
t8=lf[3];
f_1678(7,t8,t6,lf[48],lf[61],lf[62],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_1890(2,t8,C_SCHEME_UNDEFINED);}}

/* k1888 in k1879 in file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1832r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1832r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1832r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[57]);
t6=(C_word)C_i_check_exact_2(t3,lf[57]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1842,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1842(2,t8,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixunix.scm: 650  make-string */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}}

/* k1840 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1842,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1845,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1845(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 652  ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[59],lf[57],lf[60],t1);}}

/* k1843 in k1840 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1845,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1848,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 655  posix-error */
t5=lf[3];
f_1678(7,t5,t3,lf[48],lf[57],lf[58],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_1848(2,t5,C_SCHEME_UNDEFINED);}}

/* k1846 in k1843 in k1840 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1848,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1817(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1817,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[54]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 643  posix-error */
t4=lf[3];
f_1678(6,t4,t1,lf[48],lf[54],lf[55],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1779(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1779r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1779r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1779r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[50]);
t8=(C_word)C_i_check_exact_2(t3,lf[50]);
t9=(C_word)C_i_check_exact_2(t6,lf[50]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1796,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1809,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 634  ##sys#expand-home-path */
t12=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1807 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 634  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1794 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1796,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1799,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 636  posix-error */
t5=lf[3];
f_1678(8,t5,t3,lf[48],lf[50],lf[51],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_1799(2,t5,C_SCHEME_UNDEFINED);}}

/* k1797 in k1794 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1740(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1740r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1740r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1740r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t5=(C_word)C_vemptyp(t4);
t6=(C_truep(t5)?C_fix(0):(C_word)C_slot(t4,C_fix(0)));
t7=(C_word)C_i_check_exact_2(t2,lf[47]);
t8=(C_word)C_i_check_exact_2(t3,lf[47]);
t9=t2;
t10=t3;
t11=(C_word)stub24(C_SCHEME_UNDEFINED,t9,t10,t6);
t12=(C_word)C_eqp(t11,C_fix(-1));
if(C_truep(t12)){
/* posixunix.scm: 624  posix-error */
t13=lf[3];
f_1678(7,t13,t1,lf[48],lf[47],lf[49],t2,t3);}
else{
t13=t1;
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t11);}}

/* ##sys#file-select-one in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1699(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1699,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub17(C_SCHEME_UNDEFINED,t2));}

/* ##sys#file-nonblocking! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1696(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1696,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub13(C_SCHEME_UNDEFINED,t2));}

/* posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1678r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1678r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1678r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1682,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 514  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1680 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1682,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1689,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1693,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub3(t4,t1),C_fix(0));}

/* k1691 in k1680 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 515  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k1687 in k1680 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[609] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1656posixunix.scm",(void*)f_1656},
{"f_1659posixunix.scm",(void*)f_1659},
{"f_1662posixunix.scm",(void*)f_1662},
{"f_1665posixunix.scm",(void*)f_1665},
{"f_1668posixunix.scm",(void*)f_1668},
{"f_1671posixunix.scm",(void*)f_1671},
{"f_7334posixunix.scm",(void*)f_7334},
{"f_7350posixunix.scm",(void*)f_7350},
{"f_7338posixunix.scm",(void*)f_7338},
{"f_7341posixunix.scm",(void*)f_7341},
{"f_2382posixunix.scm",(void*)f_2382},
{"f_3400posixunix.scm",(void*)f_3400},
{"f_7328posixunix.scm",(void*)f_7328},
{"f_3535posixunix.scm",(void*)f_3535},
{"f_7325posixunix.scm",(void*)f_7325},
{"f_3592posixunix.scm",(void*)f_3592},
{"f_7310posixunix.scm",(void*)f_7310},
{"f_7320posixunix.scm",(void*)f_7320},
{"f_7307posixunix.scm",(void*)f_7307},
{"f_3596posixunix.scm",(void*)f_3596},
{"f_7304posixunix.scm",(void*)f_7304},
{"f_3615posixunix.scm",(void*)f_3615},
{"f_7289posixunix.scm",(void*)f_7289},
{"f_7299posixunix.scm",(void*)f_7299},
{"f_7286posixunix.scm",(void*)f_7286},
{"f_3619posixunix.scm",(void*)f_3619},
{"f_7268posixunix.scm",(void*)f_7268},
{"f_7281posixunix.scm",(void*)f_7281},
{"f_7275posixunix.scm",(void*)f_7275},
{"f_4123posixunix.scm",(void*)f_4123},
{"f_4162posixunix.scm",(void*)f_4162},
{"f_7245posixunix.scm",(void*)f_7245},
{"f_7241posixunix.scm",(void*)f_7241},
{"f_6987posixunix.scm",(void*)f_6987},
{"f_7170posixunix.scm",(void*)f_7170},
{"f_7176posixunix.scm",(void*)f_7176},
{"f_7165posixunix.scm",(void*)f_7165},
{"f_7160posixunix.scm",(void*)f_7160},
{"f_6989posixunix.scm",(void*)f_6989},
{"f_7147posixunix.scm",(void*)f_7147},
{"f_7155posixunix.scm",(void*)f_7155},
{"f_6996posixunix.scm",(void*)f_6996},
{"f_7135posixunix.scm",(void*)f_7135},
{"f_7129posixunix.scm",(void*)f_7129},
{"f_7006posixunix.scm",(void*)f_7006},
{"f_7008posixunix.scm",(void*)f_7008},
{"f_7027posixunix.scm",(void*)f_7027},
{"f_7115posixunix.scm",(void*)f_7115},
{"f_7122posixunix.scm",(void*)f_7122},
{"f_7109posixunix.scm",(void*)f_7109},
{"f_7042posixunix.scm",(void*)f_7042},
{"f_7102posixunix.scm",(void*)f_7102},
{"f_7099posixunix.scm",(void*)f_7099},
{"f_7086posixunix.scm",(void*)f_7086},
{"f_7062posixunix.scm",(void*)f_7062},
{"f_7084posixunix.scm",(void*)f_7084},
{"f_7070posixunix.scm",(void*)f_7070},
{"f_7077posixunix.scm",(void*)f_7077},
{"f_7074posixunix.scm",(void*)f_7074},
{"f_7054posixunix.scm",(void*)f_7054},
{"f_7052posixunix.scm",(void*)f_7052},
{"f_7136posixunix.scm",(void*)f_7136},
{"f_6930posixunix.scm",(void*)f_6930},
{"f_6942posixunix.scm",(void*)f_6942},
{"f_6937posixunix.scm",(void*)f_6937},
{"f_6932posixunix.scm",(void*)f_6932},
{"f_6873posixunix.scm",(void*)f_6873},
{"f_6885posixunix.scm",(void*)f_6885},
{"f_6880posixunix.scm",(void*)f_6880},
{"f_6875posixunix.scm",(void*)f_6875},
{"f_6812posixunix.scm",(void*)f_6812},
{"f_6867posixunix.scm",(void*)f_6867},
{"f_6871posixunix.scm",(void*)f_6871},
{"f_6833posixunix.scm",(void*)f_6833},
{"f_6836posixunix.scm",(void*)f_6836},
{"f_6847posixunix.scm",(void*)f_6847},
{"f_6841posixunix.scm",(void*)f_6841},
{"f_6814posixunix.scm",(void*)f_6814},
{"f_6823posixunix.scm",(void*)f_6823},
{"f_6748posixunix.scm",(void*)f_6748},
{"f_6760posixunix.scm",(void*)f_6760},
{"f_6791posixunix.scm",(void*)f_6791},
{"f_6771posixunix.scm",(void*)f_6771},
{"f_6787posixunix.scm",(void*)f_6787},
{"f_6775posixunix.scm",(void*)f_6775},
{"f_6783posixunix.scm",(void*)f_6783},
{"f_6779posixunix.scm",(void*)f_6779},
{"f_6754posixunix.scm",(void*)f_6754},
{"f_6737posixunix.scm",(void*)f_6737},
{"f_6741posixunix.scm",(void*)f_6741},
{"f_6726posixunix.scm",(void*)f_6726},
{"f_6730posixunix.scm",(void*)f_6730},
{"f_6681posixunix.scm",(void*)f_6681},
{"f_6685posixunix.scm",(void*)f_6685},
{"f_6688posixunix.scm",(void*)f_6688},
{"f_6691posixunix.scm",(void*)f_6691},
{"f_6704posixunix.scm",(void*)f_6704},
{"f_6708posixunix.scm",(void*)f_6708},
{"f_6711posixunix.scm",(void*)f_6711},
{"f_6714posixunix.scm",(void*)f_6714},
{"f_6702posixunix.scm",(void*)f_6702},
{"f_6665posixunix.scm",(void*)f_6665},
{"f_6648posixunix.scm",(void*)f_6648},
{"f_6661posixunix.scm",(void*)f_6661},
{"f_6573posixunix.scm",(void*)f_6573},
{"f_6634posixunix.scm",(void*)f_6634},
{"f_6647posixunix.scm",(void*)f_6647},
{"f_6614posixunix.scm",(void*)f_6614},
{"f_6629posixunix.scm",(void*)f_6629},
{"f_6623posixunix.scm",(void*)f_6623},
{"f_6577posixunix.scm",(void*)f_6577},
{"f_6579posixunix.scm",(void*)f_6579},
{"f_6600posixunix.scm",(void*)f_6600},
{"f_6594posixunix.scm",(void*)f_6594},
{"f_6521posixunix.scm",(void*)f_6521},
{"f_6528posixunix.scm",(void*)f_6528},
{"f_6547posixunix.scm",(void*)f_6547},
{"f_6551posixunix.scm",(void*)f_6551},
{"f_6515posixunix.scm",(void*)f_6515},
{"f_6506posixunix.scm",(void*)f_6506},
{"f_6510posixunix.scm",(void*)f_6510},
{"f_6479posixunix.scm",(void*)f_6479},
{"f_6476posixunix.scm",(void*)f_6476},
{"f_6473posixunix.scm",(void*)f_6473},
{"f_6470posixunix.scm",(void*)f_6470},
{"f_6395posixunix.scm",(void*)f_6395},
{"f_6428posixunix.scm",(void*)f_6428},
{"f_6422posixunix.scm",(void*)f_6422},
{"f_6378posixunix.scm",(void*)f_6378},
{"f_6199posixunix.scm",(void*)f_6199},
{"f_6333posixunix.scm",(void*)f_6333},
{"f_6328posixunix.scm",(void*)f_6328},
{"f_6201posixunix.scm",(void*)f_6201},
{"f_6211posixunix.scm",(void*)f_6211},
{"f_6219posixunix.scm",(void*)f_6219},
{"f_6265posixunix.scm",(void*)f_6265},
{"f_6232posixunix.scm",(void*)f_6232},
{"f_6257posixunix.scm",(void*)f_6257},
{"f_6235posixunix.scm",(void*)f_6235},
{"f_6191posixunix.scm",(void*)f_6191},
{"f_6183posixunix.scm",(void*)f_6183},
{"f_6145posixunix.scm",(void*)f_6145},
{"f_6167posixunix.scm",(void*)f_6167},
{"f_6171posixunix.scm",(void*)f_6171},
{"f_6033posixunix.scm",(void*)f_6033},
{"f_6039posixunix.scm",(void*)f_6039},
{"f_6060posixunix.scm",(void*)f_6060},
{"f_6137posixunix.scm",(void*)f_6137},
{"f_6064posixunix.scm",(void*)f_6064},
{"f_6067posixunix.scm",(void*)f_6067},
{"f_6070posixunix.scm",(void*)f_6070},
{"f_6077posixunix.scm",(void*)f_6077},
{"f_6079posixunix.scm",(void*)f_6079},
{"f_6096posixunix.scm",(void*)f_6096},
{"f_6106posixunix.scm",(void*)f_6106},
{"f_6110posixunix.scm",(void*)f_6110},
{"f_6054posixunix.scm",(void*)f_6054},
{"f_6021posixunix.scm",(void*)f_6021},
{"f_6025posixunix.scm",(void*)f_6025},
{"f_6028posixunix.scm",(void*)f_6028},
{"f_5986posixunix.scm",(void*)f_5986},
{"f_5990posixunix.scm",(void*)f_5990},
{"f_6010posixunix.scm",(void*)f_6010},
{"f_6014posixunix.scm",(void*)f_6014},
{"f_5967posixunix.scm",(void*)f_5967},
{"f_5971posixunix.scm",(void*)f_5971},
{"f_5940posixunix.scm",(void*)f_5940},
{"f_5944posixunix.scm",(void*)f_5944},
{"f_5921posixunix.scm",(void*)f_5921},
{"f_5925posixunix.scm",(void*)f_5925},
{"f_5928posixunix.scm",(void*)f_5928},
{"f_5862posixunix.scm",(void*)f_5862},
{"f_5866posixunix.scm",(void*)f_5866},
{"f_5872posixunix.scm",(void*)f_5872},
{"f_5859posixunix.scm",(void*)f_5859},
{"f_5843posixunix.scm",(void*)f_5843},
{"f_5835posixunix.scm",(void*)f_5835},
{"f_5807posixunix.scm",(void*)f_5807},
{"f_5814posixunix.scm",(void*)f_5814},
{"f_5779posixunix.scm",(void*)f_5779},
{"f_5786posixunix.scm",(void*)f_5786},
{"f_5740posixunix.scm",(void*)f_5740},
{"f_5757posixunix.scm",(void*)f_5757},
{"f_5761posixunix.scm",(void*)f_5761},
{"f_5665posixunix.scm",(void*)f_5665},
{"f_5675posixunix.scm",(void*)f_5675},
{"f_5697posixunix.scm",(void*)f_5697},
{"f_5694posixunix.scm",(void*)f_5694},
{"f_5684posixunix.scm",(void*)f_5684},
{"f_5632posixunix.scm",(void*)f_5632},
{"f_5636posixunix.scm",(void*)f_5636},
{"f_5618posixunix.scm",(void*)f_5618},
{"f_5609posixunix.scm",(void*)f_5609},
{"f_5603posixunix.scm",(void*)f_5603},
{"f_5594posixunix.scm",(void*)f_5594},
{"f_5559posixunix.scm",(void*)f_5559},
{"f_5501posixunix.scm",(void*)f_5501},
{"f_5505posixunix.scm",(void*)f_5505},
{"f_5511posixunix.scm",(void*)f_5511},
{"f_5530posixunix.scm",(void*)f_5530},
{"f_5517posixunix.scm",(void*)f_5517},
{"f_5418posixunix.scm",(void*)f_5418},
{"f_5424posixunix.scm",(void*)f_5424},
{"f_5428posixunix.scm",(void*)f_5428},
{"f_5436posixunix.scm",(void*)f_5436},
{"f_5462posixunix.scm",(void*)f_5462},
{"f_5466posixunix.scm",(void*)f_5466},
{"f_5454posixunix.scm",(void*)f_5454},
{"f_5403posixunix.scm",(void*)f_5403},
{"f_5411posixunix.scm",(void*)f_5411},
{"f_5386posixunix.scm",(void*)f_5386},
{"f_5397posixunix.scm",(void*)f_5397},
{"f_5401posixunix.scm",(void*)f_5401},
{"f_5360posixunix.scm",(void*)f_5360},
{"f_5384posixunix.scm",(void*)f_5384},
{"f_5367posixunix.scm",(void*)f_5367},
{"f_5317posixunix.scm",(void*)f_5317},
{"f_5324posixunix.scm",(void*)f_5324},
{"f_5345posixunix.scm",(void*)f_5345},
{"f_5341posixunix.scm",(void*)f_5341},
{"f_5289posixunix.scm",(void*)f_5289},
{"f_5267posixunix.scm",(void*)f_5267},
{"f_5271posixunix.scm",(void*)f_5271},
{"f_5252posixunix.scm",(void*)f_5252},
{"f_5256posixunix.scm",(void*)f_5256},
{"f_5237posixunix.scm",(void*)f_5237},
{"f_5241posixunix.scm",(void*)f_5241},
{"f_5219posixunix.scm",(void*)f_5219},
{"f_5148posixunix.scm",(void*)f_5148},
{"f_5167posixunix.scm",(void*)f_5167},
{"f_5173posixunix.scm",(void*)f_5173},
{"f_5109posixunix.scm",(void*)f_5109},
{"f_5137posixunix.scm",(void*)f_5137},
{"f_5133posixunix.scm",(void*)f_5133},
{"f_5126posixunix.scm",(void*)f_5126},
{"f_4853posixunix.scm",(void*)f_4853},
{"f_5049posixunix.scm",(void*)f_5049},
{"f_5044posixunix.scm",(void*)f_5044},
{"f_5039posixunix.scm",(void*)f_5039},
{"f_4855posixunix.scm",(void*)f_4855},
{"f_4859posixunix.scm",(void*)f_4859},
{"f_4965posixunix.scm",(void*)f_4965},
{"f_4966posixunix.scm",(void*)f_4966},
{"f_4983posixunix.scm",(void*)f_4983},
{"f_4993posixunix.scm",(void*)f_4993},
{"f_4951posixunix.scm",(void*)f_4951},
{"f_4907posixunix.scm",(void*)f_4907},
{"f_4943posixunix.scm",(void*)f_4943},
{"f_4922posixunix.scm",(void*)f_4922},
{"f_4932posixunix.scm",(void*)f_4932},
{"f_4916posixunix.scm",(void*)f_4916},
{"f_4911posixunix.scm",(void*)f_4911},
{"f_4914posixunix.scm",(void*)f_4914},
{"f_4861posixunix.scm",(void*)f_4861},
{"f_4896posixunix.scm",(void*)f_4896},
{"f_4877posixunix.scm",(void*)f_4877},
{"f_4382posixunix.scm",(void*)f_4382},
{"f_4778posixunix.scm",(void*)f_4778},
{"f_4773posixunix.scm",(void*)f_4773},
{"f_4768posixunix.scm",(void*)f_4768},
{"f_4763posixunix.scm",(void*)f_4763},
{"f_4384posixunix.scm",(void*)f_4384},
{"f_4388posixunix.scm",(void*)f_4388},
{"f_4394posixunix.scm",(void*)f_4394},
{"f_4636posixunix.scm",(void*)f_4636},
{"f_4642posixunix.scm",(void*)f_4642},
{"f_4738posixunix.scm",(void*)f_4738},
{"f_4728posixunix.scm",(void*)f_4728},
{"f_4722posixunix.scm",(void*)f_4722},
{"f_4644posixunix.scm",(void*)f_4644},
{"f_4694posixunix.scm",(void*)f_4694},
{"f_4651posixunix.scm",(void*)f_4651},
{"f_4661posixunix.scm",(void*)f_4661},
{"f_4560posixunix.scm",(void*)f_4560},
{"f_4568posixunix.scm",(void*)f_4568},
{"f_4570posixunix.scm",(void*)f_4570},
{"f_4618posixunix.scm",(void*)f_4618},
{"f_4551posixunix.scm",(void*)f_4551},
{"f_4555posixunix.scm",(void*)f_4555},
{"f_4530posixunix.scm",(void*)f_4530},
{"f_4540posixunix.scm",(void*)f_4540},
{"f_4518posixunix.scm",(void*)f_4518},
{"f_4505posixunix.scm",(void*)f_4505},
{"f_4509posixunix.scm",(void*)f_4509},
{"f_4500posixunix.scm",(void*)f_4500},
{"f_4503posixunix.scm",(void*)f_4503},
{"f_4418posixunix.scm",(void*)f_4418},
{"f_4430posixunix.scm",(void*)f_4430},
{"f_4467posixunix.scm",(void*)f_4467},
{"f_4476posixunix.scm",(void*)f_4476},
{"f_4470posixunix.scm",(void*)f_4470},
{"f_4446posixunix.scm",(void*)f_4446},
{"f_4449posixunix.scm",(void*)f_4449},
{"f_4410posixunix.scm",(void*)f_4410},
{"f_4395posixunix.scm",(void*)f_4395},
{"f_4409posixunix.scm",(void*)f_4409},
{"f_4355posixunix.scm",(void*)f_4355},
{"f_4362posixunix.scm",(void*)f_4362},
{"f_4365posixunix.scm",(void*)f_4365},
{"f_4310posixunix.scm",(void*)f_4310},
{"f_4314posixunix.scm",(void*)f_4314},
{"f_4349posixunix.scm",(void*)f_4349},
{"f_4332posixunix.scm",(void*)f_4332},
{"f_4296posixunix.scm",(void*)f_4296},
{"f_4308posixunix.scm",(void*)f_4308},
{"f_4282posixunix.scm",(void*)f_4282},
{"f_4294posixunix.scm",(void*)f_4294},
{"f_4267posixunix.scm",(void*)f_4267},
{"f_4280posixunix.scm",(void*)f_4280},
{"f_4230posixunix.scm",(void*)f_4230},
{"f_4238posixunix.scm",(void*)f_4238},
{"f_4205posixunix.scm",(void*)f_4205},
{"f_4194posixunix.scm",(void*)f_4194},
{"f_4198posixunix.scm",(void*)f_4198},
{"f_4163posixunix.scm",(void*)f_4163},
{"f_4187posixunix.scm",(void*)f_4187},
{"f_4171posixunix.scm",(void*)f_4171},
{"f_4174posixunix.scm",(void*)f_4174},
{"f_4125posixunix.scm",(void*)f_4125},
{"f_4158posixunix.scm",(void*)f_4158},
{"f_4146posixunix.scm",(void*)f_4146},
{"f_4154posixunix.scm",(void*)f_4154},
{"f_4150posixunix.scm",(void*)f_4150},
{"f_4100posixunix.scm",(void*)f_4100},
{"f_4116posixunix.scm",(void*)f_4116},
{"f_4085posixunix.scm",(void*)f_4085},
{"f_4095posixunix.scm",(void*)f_4095},
{"f_4089posixunix.scm",(void*)f_4089},
{"f_4079posixunix.scm",(void*)f_4079},
{"f_4073posixunix.scm",(void*)f_4073},
{"f_4067posixunix.scm",(void*)f_4067},
{"f_4043posixunix.scm",(void*)f_4043},
{"f_4065posixunix.scm",(void*)f_4065},
{"f_4061posixunix.scm",(void*)f_4061},
{"f_4053posixunix.scm",(void*)f_4053},
{"f_4013posixunix.scm",(void*)f_4013},
{"f_4041posixunix.scm",(void*)f_4041},
{"f_4037posixunix.scm",(void*)f_4037},
{"f_3986posixunix.scm",(void*)f_3986},
{"f_4011posixunix.scm",(void*)f_4011},
{"f_4007posixunix.scm",(void*)f_4007},
{"f_3922posixunix.scm",(void*)f_3922},
{"f_3918posixunix.scm",(void*)f_3918},
{"f_3938posixunix.scm",(void*)f_3938},
{"f_3856posixunix.scm",(void*)f_3856},
{"f_3860posixunix.scm",(void*)f_3860},
{"f_3865posixunix.scm",(void*)f_3865},
{"f_3881posixunix.scm",(void*)f_3881},
{"f_3793posixunix.scm",(void*)f_3793},
{"f_3851posixunix.scm",(void*)f_3851},
{"f_3797posixunix.scm",(void*)f_3797},
{"f_3800posixunix.scm",(void*)f_3800},
{"f_3832posixunix.scm",(void*)f_3832},
{"f_3803posixunix.scm",(void*)f_3803},
{"f_3808posixunix.scm",(void*)f_3808},
{"f_3822posixunix.scm",(void*)f_3822},
{"f_3790posixunix.scm",(void*)f_3790},
{"f_3715posixunix.scm",(void*)f_3715},
{"f_3773posixunix.scm",(void*)f_3773},
{"f_3722posixunix.scm",(void*)f_3722},
{"f_3732posixunix.scm",(void*)f_3732},
{"f_3736posixunix.scm",(void*)f_3736},
{"f_3745posixunix.scm",(void*)f_3745},
{"f_3749posixunix.scm",(void*)f_3749},
{"f_3759posixunix.scm",(void*)f_3759},
{"f_3740posixunix.scm",(void*)f_3740},
{"f_3695posixunix.scm",(void*)f_3695},
{"f_3707posixunix.scm",(void*)f_3707},
{"f_3703posixunix.scm",(void*)f_3703},
{"f_3681posixunix.scm",(void*)f_3681},
{"f_3693posixunix.scm",(void*)f_3693},
{"f_3689posixunix.scm",(void*)f_3689},
{"f_3621posixunix.scm",(void*)f_3621},
{"f_3667posixunix.scm",(void*)f_3667},
{"f_3628posixunix.scm",(void*)f_3628},
{"f_3638posixunix.scm",(void*)f_3638},
{"f_3642posixunix.scm",(void*)f_3642},
{"f_3646posixunix.scm",(void*)f_3646},
{"f_3650posixunix.scm",(void*)f_3650},
{"f_3654posixunix.scm",(void*)f_3654},
{"f_3598posixunix.scm",(void*)f_3598},
{"f_3608posixunix.scm",(void*)f_3608},
{"f_3575posixunix.scm",(void*)f_3575},
{"f_3585posixunix.scm",(void*)f_3585},
{"f_3537posixunix.scm",(void*)f_3537},
{"f_3570posixunix.scm",(void*)f_3570},
{"f_3541posixunix.scm",(void*)f_3541},
{"f_3548posixunix.scm",(void*)f_3548},
{"f_3552posixunix.scm",(void*)f_3552},
{"f_3556posixunix.scm",(void*)f_3556},
{"f_3560posixunix.scm",(void*)f_3560},
{"f_3564posixunix.scm",(void*)f_3564},
{"f_3519posixunix.scm",(void*)f_3519},
{"f_3504posixunix.scm",(void*)f_3504},
{"f_3498posixunix.scm",(void*)f_3498},
{"f_3466posixunix.scm",(void*)f_3466},
{"f_3472posixunix.scm",(void*)f_3472},
{"f_3442posixunix.scm",(void*)f_3442},
{"f_3460posixunix.scm",(void*)f_3460},
{"f_3449posixunix.scm",(void*)f_3449},
{"f_3424posixunix.scm",(void*)f_3424},
{"f_3434posixunix.scm",(void*)f_3434},
{"f_3411posixunix.scm",(void*)f_3411},
{"f_3402posixunix.scm",(void*)f_3402},
{"f_3355posixunix.scm",(void*)f_3355},
{"f_3359posixunix.scm",(void*)f_3359},
{"f_3335posixunix.scm",(void*)f_3335},
{"f_3339posixunix.scm",(void*)f_3339},
{"f_3345posixunix.scm",(void*)f_3345},
{"f_3349posixunix.scm",(void*)f_3349},
{"f_3315posixunix.scm",(void*)f_3315},
{"f_3319posixunix.scm",(void*)f_3319},
{"f_3325posixunix.scm",(void*)f_3325},
{"f_3329posixunix.scm",(void*)f_3329},
{"f_3291posixunix.scm",(void*)f_3291},
{"f_3295posixunix.scm",(void*)f_3295},
{"f_3306posixunix.scm",(void*)f_3306},
{"f_3310posixunix.scm",(void*)f_3310},
{"f_3300posixunix.scm",(void*)f_3300},
{"f_3267posixunix.scm",(void*)f_3267},
{"f_3271posixunix.scm",(void*)f_3271},
{"f_3282posixunix.scm",(void*)f_3282},
{"f_3286posixunix.scm",(void*)f_3286},
{"f_3276posixunix.scm",(void*)f_3276},
{"f_3251posixunix.scm",(void*)f_3251},
{"f_3255posixunix.scm",(void*)f_3255},
{"f_3258posixunix.scm",(void*)f_3258},
{"f_3215posixunix.scm",(void*)f_3215},
{"f_3246posixunix.scm",(void*)f_3246},
{"f_3236posixunix.scm",(void*)f_3236},
{"f_3229posixunix.scm",(void*)f_3229},
{"f_3179posixunix.scm",(void*)f_3179},
{"f_3210posixunix.scm",(void*)f_3210},
{"f_3200posixunix.scm",(void*)f_3200},
{"f_3193posixunix.scm",(void*)f_3193},
{"f_3164posixunix.scm",(void*)f_3164},
{"f_3177posixunix.scm",(void*)f_3177},
{"f_3158posixunix.scm",(void*)f_3158},
{"f_3146posixunix.scm",(void*)f_3146},
{"f_2829posixunix.scm",(void*)f_2829},
{"f_3136posixunix.scm",(void*)f_3136},
{"f_2956posixunix.scm",(void*)f_2956},
{"f_3122posixunix.scm",(void*)f_3122},
{"f_3111posixunix.scm",(void*)f_3111},
{"f_3118posixunix.scm",(void*)f_3118},
{"f_2975posixunix.scm",(void*)f_2975},
{"f_3104posixunix.scm",(void*)f_3104},
{"f_3083posixunix.scm",(void*)f_3083},
{"f_3100posixunix.scm",(void*)f_3100},
{"f_3089posixunix.scm",(void*)f_3089},
{"f_3096posixunix.scm",(void*)f_3096},
{"f_3019posixunix.scm",(void*)f_3019},
{"f_3080posixunix.scm",(void*)f_3080},
{"f_3059posixunix.scm",(void*)f_3059},
{"f_3076posixunix.scm",(void*)f_3076},
{"f_3065posixunix.scm",(void*)f_3065},
{"f_3072posixunix.scm",(void*)f_3072},
{"f_3032posixunix.scm",(void*)f_3032},
{"f_3056posixunix.scm",(void*)f_3056},
{"f_3052posixunix.scm",(void*)f_3052},
{"f_3013posixunix.scm",(void*)f_3013},
{"f_2982posixunix.scm",(void*)f_2982},
{"f_3000posixunix.scm",(void*)f_3000},
{"f_2985posixunix.scm",(void*)f_2985},
{"f_2989posixunix.scm",(void*)f_2989},
{"f_2969posixunix.scm",(void*)f_2969},
{"f_2950posixunix.scm",(void*)f_2950},
{"f_2836posixunix.scm",(void*)f_2836},
{"f_2843posixunix.scm",(void*)f_2843},
{"f_2845posixunix.scm",(void*)f_2845},
{"f_2852posixunix.scm",(void*)f_2852},
{"f_2916posixunix.scm",(void*)f_2916},
{"f_2925posixunix.scm",(void*)f_2925},
{"f_2913posixunix.scm",(void*)f_2913},
{"f_2858posixunix.scm",(void*)f_2858},
{"f_2894posixunix.scm",(void*)f_2894},
{"f_2890posixunix.scm",(void*)f_2890},
{"f_2886posixunix.scm",(void*)f_2886},
{"f_2875posixunix.scm",(void*)f_2875},
{"f_2871posixunix.scm",(void*)f_2871},
{"f_2773posixunix.scm",(void*)f_2773},
{"f_2782posixunix.scm",(void*)f_2782},
{"f_2806posixunix.scm",(void*)f_2806},
{"f_2818posixunix.scm",(void*)f_2818},
{"f_2824posixunix.scm",(void*)f_2824},
{"f_2812posixunix.scm",(void*)f_2812},
{"f_2788posixunix.scm",(void*)f_2788},
{"f_2794posixunix.scm",(void*)f_2794},
{"f_2780posixunix.scm",(void*)f_2780},
{"f_2762posixunix.scm",(void*)f_2762},
{"f_2757posixunix.scm",(void*)f_2757},
{"f_2716posixunix.scm",(void*)f_2716},
{"f_2729posixunix.scm",(void*)f_2729},
{"f_2693posixunix.scm",(void*)f_2693},
{"f_2714posixunix.scm",(void*)f_2714},
{"f_2700posixunix.scm",(void*)f_2700},
{"f_2539posixunix.scm",(void*)f_2539},
{"f_2644posixunix.scm",(void*)f_2644},
{"f_2652posixunix.scm",(void*)f_2652},
{"f_2639posixunix.scm",(void*)f_2639},
{"f_2541posixunix.scm",(void*)f_2541},
{"f_2548posixunix.scm",(void*)f_2548},
{"f_2551posixunix.scm",(void*)f_2551},
{"f_2554posixunix.scm",(void*)f_2554},
{"f_2638posixunix.scm",(void*)f_2638},
{"f_2558posixunix.scm",(void*)f_2558},
{"f_2572posixunix.scm",(void*)f_2572},
{"f_2582posixunix.scm",(void*)f_2582},
{"f_2585posixunix.scm",(void*)f_2585},
{"f_2588posixunix.scm",(void*)f_2588},
{"f_2594posixunix.scm",(void*)f_2594},
{"f_2604posixunix.scm",(void*)f_2604},
{"f_2515posixunix.scm",(void*)f_2515},
{"f_2537posixunix.scm",(void*)f_2537},
{"f_2533posixunix.scm",(void*)f_2533},
{"f_2491posixunix.scm",(void*)f_2491},
{"f_2513posixunix.scm",(void*)f_2513},
{"f_2509posixunix.scm",(void*)f_2509},
{"f_2390posixunix.scm",(void*)f_2390},
{"f_2463posixunix.scm",(void*)f_2463},
{"f_2477posixunix.scm",(void*)f_2477},
{"f_2403posixunix.scm",(void*)f_2403},
{"f_2460posixunix.scm",(void*)f_2460},
{"f_2408posixunix.scm",(void*)f_2408},
{"f_2413posixunix.scm",(void*)f_2413},
{"f_2436posixunix.scm",(void*)f_2436},
{"f_2456posixunix.scm",(void*)f_2456},
{"f_2419posixunix.scm",(void*)f_2419},
{"f_2433posixunix.scm",(void*)f_2433},
{"f_2322posixunix.scm",(void*)f_2322},
{"f_2335posixunix.scm",(void*)f_2335},
{"f_2347posixunix.scm",(void*)f_2347},
{"f_2341posixunix.scm",(void*)f_2341},
{"f_2313posixunix.scm",(void*)f_2313},
{"f_2320posixunix.scm",(void*)f_2320},
{"f_2304posixunix.scm",(void*)f_2304},
{"f_2311posixunix.scm",(void*)f_2311},
{"f_2295posixunix.scm",(void*)f_2295},
{"f_2302posixunix.scm",(void*)f_2302},
{"f_2286posixunix.scm",(void*)f_2286},
{"f_2293posixunix.scm",(void*)f_2293},
{"f_2277posixunix.scm",(void*)f_2277},
{"f_2284posixunix.scm",(void*)f_2284},
{"f_2268posixunix.scm",(void*)f_2268},
{"f_2275posixunix.scm",(void*)f_2275},
{"f_2259posixunix.scm",(void*)f_2259},
{"f_2266posixunix.scm",(void*)f_2266},
{"f_2250posixunix.scm",(void*)f_2250},
{"f_2257posixunix.scm",(void*)f_2257},
{"f_2241posixunix.scm",(void*)f_2241},
{"f_2248posixunix.scm",(void*)f_2248},
{"f_2235posixunix.scm",(void*)f_2235},
{"f_2239posixunix.scm",(void*)f_2239},
{"f_2229posixunix.scm",(void*)f_2229},
{"f_2233posixunix.scm",(void*)f_2233},
{"f_2223posixunix.scm",(void*)f_2223},
{"f_2227posixunix.scm",(void*)f_2227},
{"f_2217posixunix.scm",(void*)f_2217},
{"f_2221posixunix.scm",(void*)f_2221},
{"f_2211posixunix.scm",(void*)f_2211},
{"f_2215posixunix.scm",(void*)f_2215},
{"f_2205posixunix.scm",(void*)f_2205},
{"f_2209posixunix.scm",(void*)f_2209},
{"f_2180posixunix.scm",(void*)f_2180},
{"f_2184posixunix.scm",(void*)f_2184},
{"f_2143posixunix.scm",(void*)f_2143},
{"f_2175posixunix.scm",(void*)f_2175},
{"f_2168posixunix.scm",(void*)f_2168},
{"f_2147posixunix.scm",(void*)f_2147},
{"f_1951posixunix.scm",(void*)f_1951},
{"f_2124posixunix.scm",(void*)f_2124},
{"f_1967posixunix.scm",(void*)f_1967},
{"f_2098posixunix.scm",(void*)f_2098},
{"f_1973posixunix.scm",(void*)f_1973},
{"f_1976posixunix.scm",(void*)f_1976},
{"f_2058posixunix.scm",(void*)f_2058},
{"f_2056posixunix.scm",(void*)f_2056},
{"f_2015posixunix.scm",(void*)f_2015},
{"f_2033posixunix.scm",(void*)f_2033},
{"f_2031posixunix.scm",(void*)f_2031},
{"f_2019posixunix.scm",(void*)f_2019},
{"f_1949posixunix.scm",(void*)f_1949},
{"f_1947posixunix.scm",(void*)f_1947},
{"f_1945posixunix.scm",(void*)f_1945},
{"f_1913posixunix.scm",(void*)f_1913},
{"f_1920posixunix.scm",(void*)f_1920},
{"f_1926posixunix.scm",(void*)f_1926},
{"f_1933posixunix.scm",(void*)f_1933},
{"f_1874posixunix.scm",(void*)f_1874},
{"f_1881posixunix.scm",(void*)f_1881},
{"f_1890posixunix.scm",(void*)f_1890},
{"f_1832posixunix.scm",(void*)f_1832},
{"f_1842posixunix.scm",(void*)f_1842},
{"f_1845posixunix.scm",(void*)f_1845},
{"f_1848posixunix.scm",(void*)f_1848},
{"f_1817posixunix.scm",(void*)f_1817},
{"f_1779posixunix.scm",(void*)f_1779},
{"f_1809posixunix.scm",(void*)f_1809},
{"f_1796posixunix.scm",(void*)f_1796},
{"f_1799posixunix.scm",(void*)f_1799},
{"f_1740posixunix.scm",(void*)f_1740},
{"f_1699posixunix.scm",(void*)f_1699},
{"f_1696posixunix.scm",(void*)f_1696},
{"f_1678posixunix.scm",(void*)f_1678},
{"f_1682posixunix.scm",(void*)f_1682},
{"f_1693posixunix.scm",(void*)f_1693},
{"f_1689posixunix.scm",(void*)f_1689},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
