/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2009-09-21 21:26
   Version 4.0.1 - SVN rev. 14292
   linux-unix-gnu-x86 [ manyargs dload ptables applyhook ]
   compiled 2009-05-12 on galinha (Linux)
   command line: posixunix.scm -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>
#include <math.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)
#define C_isdir             ((C_statbuf.st_mode & S_IFMT) == S_IFDIR)
#define C_ischr             ((C_statbuf.st_mode & S_IFMT) == S_IFCHR)
#define C_isblk             ((C_statbuf.st_mode & S_IFMT) == S_IFBLK)
#define C_isfifo            ((C_statbuf.st_mode & S_IFMT) == S_IFIFO)
#ifdef S_IFSOCK
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == S_IFSOCK)
#else
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == 0140000)
#endif

#ifdef C_GNU_ENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    (memset((ptm), 0, sizeof(struct tm)), \
    (ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = C_unfix(C_block_item((v), 9)))

#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix((ptm)->tm_gmtoff)))

#define C_tm_set_08(v)  cpy_tmvec_to_tmstc08( &C_tm, (v) )
#define C_tm_set_9(v)   cpy_tmvec_to_tmstc9( &C_tm, (v) )

#define C_tm_get_08(v)  cpy_tmstc08_to_tmvec( (v), &C_tm )
#define C_tm_get_9(v)   cpy_tmstc9_to_tmvec( (v), &C_tm )

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  return v;
}

#else

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  C_tm_set_9( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  C_tm_get_9( v );
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)
#define C_timegm(v)     ((C_temporary_flonum = timegm(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[468];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,51,48,32,108,111,99,51,49,32,109,115,103,51,50,32,46,32,97,114,103,115,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,97,51,57,52,50,41,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,97,52,53,52,56,41,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,49,51,55,32,99,109,100,49,51,56,32,46,32,116,109,112,49,51,54,49,51,57,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,49,53,57,32,102,108,97,103,115,49,54,48,32,46,32,109,111,100,101,49,54,49,41,0,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,49,55,52,41,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,49,56,50,32,115,105,122,101,49,56,51,32,46,32,98,117,102,102,101,114,49,56,52,41,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,50,48,49,32,98,117,102,102,101,114,50,48,50,32,46,32,115,105,122,101,50,48,51,41,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,50,50,48,41,0,0,0,0,0,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,9),40,102,100,95,122,101,114,111,41,0,0,0,0,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,16),40,102,100,95,115,101,116,32,97,50,52,51,50,52,56,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,17),40,102,100,95,116,101,115,116,32,97,50,53,48,50,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,13),40,97,51,56,56,54,32,102,100,51,51,51,41,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,13),40,97,51,57,49,49,32,102,100,51,50,52,41,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,13),40,97,51,57,53,49,32,102,100,50,57,56,41,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,13),40,97,51,57,55,55,32,102,100,50,55,57,41,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,50,53,56,32,102,100,115,119,50,53,57,32,46,32,116,105,109,101,111,117,116,50,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,51,54,51,32,108,105,110,107,51,54,52,32,108,111,99,51,54,53,41,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,115,116,97,116,32,102,51,56,50,32,46,32,108,105,110,107,51,56,51,41,0,0,0,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,51,57,54,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,29),40,102,105,108,101,45,109,111,100,105,102,105,99,97,116,105,111,110,45,116,105,109,101,32,102,52,48,49,41,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,52,48,54,41,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,52,49,49,41,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,52,49,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,52,50,49,41,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,24),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,110,97,109,101,52,50,54,41};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,52,51,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,24),40,115,116,97,116,45,114,101,103,117,108,97,114,63,32,102,110,97,109,101,52,52,52,41};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,26),40,115,116,97,116,45,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,52,53,51,41,0,0,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,28),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,110,97,109,101,52,54,50,41,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,24),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,110,97,109,101,52,55,50,41};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,102,95,52,49,53,56,32,102,110,97,109,101,52,56,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,18),40,115,111,99,107,101,116,63,32,102,110,97,109,101,52,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,53,48,50,32,112,111,115,53,48,51,32,46,32,119,104,101,110,99,101,53,48,52,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,12),40,97,52,50,53,53,32,120,53,55,50,41,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,53,53,52,32,46,32,116,109,112,53,53,51,53,53,53,41,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,54,48,52,41,0,0,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,54,49,48,41,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,54,51,53,32,115,112,101,99,54,52,53,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,54,52,54,41,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,54,51,56,32,37,115,112,101,99,54,51,51,54,57,49,41,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,54,51,55,41,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,54,50,53,54,50,54,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,55,48,54,41,0,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,55,50,49,55,50,50,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,20),40,105,115,112,101,114,115,101,32,103,55,54,55,55,54,56,55,54,57,41,0,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,6),40,115,101,112,63,41,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,52,54,53,53,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,19),40,97,52,54,52,57,32,101,120,118,97,114,55,56,49,55,57,55,41,0,0,0,0,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,52,54,55,51,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,52,54,56,53,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,20),40,97,52,54,55,57,32,46,32,97,114,103,115,55,57,48,56,49,53,41,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,52,54,54,55,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,97,52,54,52,51,32,107,55,56,57,55,57,53,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,5),40,99,119,100,41,0,0,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,56,53,48,32,114,56,53,49,41};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,24),40,99,97,110,111,110,105,99,97,108,45,112,97,116,104,32,112,97,116,104,56,49,57,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,6),40,109,111,100,101,41,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,14),40,98,97,100,109,111,100,101,32,109,56,54,51,41,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,56,54,53,32,99,109,100,56,54,54,32,105,110,112,56,54,55,32,114,56,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,55,51,32,46,32,109,56,55,52,41,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,56,54,32,46,32,109,56,56,55,41};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,56,57,57,41,0,0,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,7),40,97,53,49,51,55,41,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,20),40,97,53,49,52,51,32,46,32,114,101,115,117,108,116,115,57,50,54,41,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,57,49,57,32,112,114,111,99,57,50,48,32,46,32,109,111,100,101,57,50,49,41,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,7),40,97,53,49,54,49,41,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,20),40,97,53,49,54,55,32,46,32,114,101,115,117,108,116,115,57,51,54,41,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,57,50,57,32,112,114,111,99,57,51,48,32,46,32,109,111,100,101,57,51,49,41};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,20),40,97,53,49,56,54,32,46,32,114,101,115,117,108,116,115,57,52,54,41,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,57,51,57,32,116,104,117,110,107,57,52,48,32,46,32,109,111,100,101,57,52,49,41};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,20),40,97,53,50,48,54,32,46,32,114,101,115,117,108,116,115,57,53,56,41,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,57,53,49,32,116,104,117,110,107,57,53,50,32,46,32,109,111,100,101,57,53,51,41,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,49,48,50,57,41};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,38),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,49,48,51,50,32,112,114,111,99,49,48,51,51,41,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,49,48,51,57,32,115,116,97,116,101,49,48,52,48,41,0,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,13),40,97,53,51,50,49,32,115,49,48,53,48,41,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,49,48,52,56,41,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,115,105,103,115,49,48,54,51,32,109,97,115,107,49,48,54,52,41};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,13),40,115,105,103,110,97,108,45,109,97,115,107,41,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,49,48,55,50,41};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,22),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,49,48,55,55,41,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,49,48,56,53,41};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,41),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,49,49,53,55,32,46,32,116,109,112,49,49,53,54,49,49,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,50,48,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,43),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,49,50,48,48,32,46,32,116,109,112,49,49,57,57,49,50,48,49,41,0,0,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,16),40,95,101,110,115,117,114,101,45,103,114,111,117,112,115,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,53,54,41,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,26),40,100,111,108,111,111,112,49,50,54,57,32,108,115,116,49,50,55,53,32,105,49,50,55,54,41,0,0,0,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,49,50,54,53,41,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,35),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,49,51,48,50,32,105,100,49,51,48,51,41,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,51,55,52,32,109,49,51,55,53,41,0,0,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,42),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,49,51,56,50,32,117,105,100,49,51,56,51,32,103,105,100,49,51,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,51,57,55,32,97,99,99,49,51,57,56,32,108,111,99,49,51,57,57,41,0,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,52,48,55,41};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,52,48,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,52,49,49,41,0,0,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,49,52,52,52,32,110,101,119,49,52,52,53,41,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,44),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,52,54,50,32,46,32,116,109,112,49,52,54,49,49,52,54,51,41,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,105,110,107,32,111,108,100,49,53,48,49,32,110,101,119,49,53,48,50,41,0,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,20),40,109,111,100,101,32,105,110,112,49,53,49,56,32,109,49,53,49,57,41,0,0,0,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,108,111,99,49,53,51,55,32,102,100,49,53,51,56,32,105,110,112,49,53,51,57,32,114,49,53,52,48,41,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,33),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,49,53,52,53,32,46,32,109,49,53,52,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,34),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,49,53,52,57,32,46,32,109,49,53,53,48,41,0,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,23),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,49,53,53,55,41,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,36),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,49,53,55,51,32,46,32,110,101,119,49,53,55,52,41,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,7),40,97,54,52,48,48,41,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,7),40,97,54,52,49,51,41,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,7),40,97,54,52,50,53,41,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,7),40,97,54,52,52,54,41,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,54,57,57,32,109,49,55,48,48,32,115,116,97,114,116,49,55,48,49,41,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,41),40,97,54,52,53,53,32,112,111,114,116,49,54,57,50,32,110,49,54,57,51,32,100,101,115,116,49,54,57,52,32,115,116,97,114,116,49,54,57,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,24),40,98,117,109,112,101,114,32,99,117,114,49,55,51,53,32,112,116,114,49,55,51,54,41};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,7),40,97,54,54,49,55,41,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,42),40,97,54,54,50,51,32,100,101,115,116,49,55,55,53,49,55,55,54,49,55,56,48,32,99,111,110,116,63,49,55,55,55,49,55,55,56,49,55,56,49,41,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,115,116,114,49,55,51,50,41,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,26),40,97,54,53,51,49,32,112,111,114,116,49,55,50,55,32,108,105,109,105,116,49,55,50,56,41,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,59),40,98,111,100,121,49,54,48,57,32,110,111,110,98,108,111,99,107,105,110,103,63,49,54,50,49,32,98,117,102,105,49,54,50,50,32,111,110,45,99,108,111,115,101,49,54,50,51,32,109,111,114,101,63,49,54,50,52,41,0,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,69),40,100,101,102,45,109,111,114,101,63,49,54,49,52,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,54,48,53,49,55,57,53,32,37,98,117,102,105,49,54,48,54,49,55,57,54,32,37,111,110,45,99,108,111,115,101,49,54,48,55,49,55,57,55,41,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,54),40,100,101,102,45,111,110,45,99,108,111,115,101,49,54,49,51,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,54,48,53,49,56,48,49,32,37,98,117,102,105,49,54,48,54,49,56,48,50,41,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,36),40,100,101,102,45,98,117,102,105,49,54,49,50,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,54,48,53,49,56,48,54,41,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,49,54,49,49,41,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,62),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,53,57,53,32,110,97,109,49,53,57,54,32,102,100,49,53,57,55,32,46,32,116,109,112,49,53,57,52,49,53,57,56,41,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,22),40,112,111,107,101,32,115,116,114,49,56,54,56,32,108,101,110,49,56,54,57,41,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,15),40,97,54,56,49,52,32,115,116,114,49,57,49,54,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,97,54,56,50,48,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,7),40,97,54,56,52,49,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,16),40,102,95,54,56,53,48,32,115,116,114,49,56,56,51,41};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,56,57,52,32,115,116,97,114,116,49,56,57,53,32,108,101,110,49,56,57,54,41};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,16),40,102,95,54,56,54,53,32,115,116,114,49,56,57,48,41};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,49),40,98,111,100,121,49,56,52,56,32,110,111,110,98,108,111,99,107,105,110,103,63,49,56,53,57,32,98,117,102,105,49,56,54,48,32,111,110,45,99,108,111,115,101,49,56,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,54),40,100,101,102,45,111,110,45,99,108,111,115,101,49,56,53,50,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,56,52,53,49,57,51,51,32,37,98,117,102,105,49,56,52,54,49,57,51,52,41,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,36),40,100,101,102,45,98,117,102,105,49,56,53,49,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,56,52,53,49,57,51,56,41,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,49,56,53,48,41,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,56,51,53,32,110,97,109,49,56,51,54,32,102,100,49,56,51,55,32,46,32,116,109,112,49,56,51,52,49,56,51,56,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,57,53,53,32,111,102,102,49,57,53,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,57,55,53,32,97,114,103,115,49,57,55,54,32,108,111,99,49,57,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,57,57,57,32,108,111,99,107,50,48,48,48,32,108,111,99,50,48,48,49,41,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,50,48,48,51,32,46,32,97,114,103,115,50,48,48,52,41,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,50,48,48,56,32,46,32,97,114,103,115,50,48,48,57,41};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,50,48,49,51,32,46,32,97,114,103,115,50,48,49,52,41,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,50,48,51,56,41,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,50,48,52,53,32,46,32,109,111,100,101,50,48,52,54,41,0,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,50,48,53,53,41,0,0,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,24),40,115,101,116,101,110,118,32,118,97,114,50,48,54,49,32,118,97,108,50,48,54,50,41};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,18),40,117,110,115,101,116,101,110,118,32,118,97,114,50,48,54,57,41,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,12),40,115,99,97,110,32,106,50,48,57,50,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,50,48,56,54,41,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,50,49,52,48,32,108,101,110,50,49,52,49,32,112,114,111,116,50,49,52,50,32,102,108,97,103,50,49,52,51,32,102,100,50,49,52,52,32,46,32,111,102,102,50,49,52,53,41};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,50,49,55,51,32,46,32,108,101,110,50,49,55,52,41,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,50,49,56,51,41,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,50,49,56,56,41,0,0,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,34),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,50,49,57,50,32,116,109,50,49,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,30),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,115,101,99,115,50,50,48,48,41,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,28),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,115,101,99,115,50,50,48,53,41,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,26),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,115,101,99,115,50,50,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,35),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,50,50,52,57,32,46,32,116,109,112,50,50,52,56,50,50,53,48,41,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,50,50,57,48,32,46,32,116,109,112,50,50,56,57,50,50,57,49,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,50,51,48,55,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,50,51,49,50,41,0,0,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,50,51,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,97,108,97,114,109,33,32,97,50,51,51,50,50,51,51,53,41,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,50,51,52,50,32,109,111,100,101,50,51,52,51,32,46,32,115,105,122,101,50,51,52,52,41,0,0,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,50,51,54,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,50,51,55,49,32,112,111,114,116,50,51,55,50,41,0,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,50,51,56,57,41};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,50,52,48,52,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,7),40,97,56,48,48,55,41,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,102,110,115,50,52,56,53,41,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,55),40,97,56,48,49,51,32,100,105,114,50,52,53,53,50,52,53,54,50,52,54,51,32,102,105,108,50,52,53,55,50,52,53,56,50,52,54,52,32,101,120,116,50,52,53,57,50,52,54,48,50,52,54,53,41,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,21),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,50,52,53,48,41,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,18),40,103,108,111,98,32,46,32,112,97,116,104,115,50,52,52,54,41,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,18),40,102,95,56,49,50,50,32,97,50,53,50,57,50,53,51,50,41,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,104,117,110,107,50,53,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,28),40,115,101,116,97,114,103,32,97,50,53,52,50,50,53,52,56,32,97,50,53,52,49,50,53,52,57,41,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,28),40,115,101,116,101,110,118,32,97,50,53,53,55,50,53,54,51,32,97,50,53,53,54,50,53,54,52,41,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,50,54,49,52,32,105,50,54,50,49,41,0,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,50,54,48,51,32,97,108,50,54,48,57,32,105,50,54,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,50,53,56,56,32,97,114,103,108,105,115,116,50,53,57,56,32,101,110,118,108,105,115,116,50,53,57,57,41,0,0,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,34),40,100,101,102,45,101,110,118,108,105,115,116,50,53,57,49,32,37,97,114,103,108,105,115,116,50,53,56,54,50,54,53,53,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,17),40,100,101,102,45,97,114,103,108,105,115,116,50,53,57,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,50,53,55,56,32,46,32,116,109,112,50,53,55,55,50,53,55,57,41,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,50,54,55,50,32,110,111,104,97,110,103,50,54,55,51,41,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,7),40,97,56,52,48,52,41,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,36),40,97,56,52,49,48,32,101,112,105,100,50,55,49,56,32,101,110,111,114,109,50,55,49,57,32,101,99,111,100,101,50,55,50,48,41,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,25),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,50,54,56,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,17),40,115,108,101,101,112,32,97,50,55,51,50,50,55,51,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,50,55,51,56,32,46,32,115,105,103,50,55,51,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,50,55,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,50,55,54,54,32,46,32,97,114,103,115,50,55,54,55,41,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,7),40,97,56,53,56,48,41,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,29),40,97,56,53,56,54,32,95,50,56,49,54,32,102,108,103,50,56,49,55,32,99,111,100,50,56,49,56,41,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,8),40,102,95,56,53,54,54,41};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,50,56,48,49,32,112,105,100,50,56,48,50,32,99,108,115,118,101,99,50,56,48,51,32,105,100,120,50,56,48,52,32,105,100,120,97,50,56,48,53,32,105,100,120,98,50,56,48,54,41,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,7),40,97,56,54,48,57,41,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,19),40,97,56,54,49,53,32,105,50,56,51,49,32,111,50,56,51,50,41,0,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,50,56,50,52,41,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,50,56,51,53,32,112,111,114,116,50,56,51,54,41,0,0,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,50,56,52,54,32,112,111,114,116,50,56,52,55,32,115,116,100,102,100,50,56,52,56,41,0,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,14),40,115,119,97,112,112,101,100,45,101,110,100,115,41,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,7),40,97,56,54,57,48,41,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,50,56,54,55,32,97,114,103,115,50,56,54,56,32,101,110,118,50,56,54,57,32,115,116,100,111,117,116,102,50,56,55,48,32,115,116,100,105,110,102,50,56,55,49,32,115,116,100,101,114,114,102,50,56,55,50,41,0,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,50,56,56,50,32,99,109,100,50,56,56,52,32,112,105,112,101,50,56,56,53,32,115,116,100,102,50,56,56,54,32,111,110,45,99,108,111,115,101,50,56,56,56,41,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,50,56,57,53,32,99,109,100,50,56,57,55,32,112,105,112,101,50,56,57,56,32,115,116,100,102,50,56,57,57,32,111,110,45,99,108,111,115,101,50,57,48,49,41,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,7),40,97,56,55,52,48,41,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,50),40,97,56,55,52,54,32,105,110,112,105,112,101,50,57,50,48,32,111,117,116,112,105,112,101,50,57,50,49,32,101,114,114,112,105,112,101,50,57,50,50,32,112,105,100,50,57,50,51,41,0,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,50,57,48,57,32,99,109,100,50,57,49,48,32,97,114,103,115,50,57,49,49,32,101,110,118,50,57,49,50,32,115,116,100,111,117,116,102,50,57,49,51,32,115,116,100,105,110,102,50,57,49,52,32,115,116,100,101,114,114,102,50,57,49,53,41,0,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,21),40,97,56,56,48,51,32,103,50,57,52,53,50,57,52,54,50,57,52,55,41,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,50,57,51,56,41,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,7),40,97,56,56,50,49,41,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,38),40,97,56,56,50,55,32,105,110,50,57,53,55,32,111,117,116,50,57,53,56,32,112,105,100,50,57,53,57,32,101,114,114,50,57,54,48,41,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,52),40,37,112,114,111,99,101,115,115,32,108,111,99,50,57,51,49,32,101,114,114,63,50,57,51,50,32,99,109,100,50,57,51,51,32,97,114,103,115,50,57,51,52,32,101,110,118,50,57,51,53,41,0,0,0,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,50,57,56,50,32,97,114,103,115,50,57,57,50,32,101,110,118,50,57,57,51,41,0,0,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,50,57,56,53,32,37,97,114,103,115,50,57,56,48,50,57,57,55,41,0,0,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,50,57,56,52,41,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,50,57,55,50,32,46,32,116,109,112,50,57,55,49,50,57,55,51,41,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,51,48,50,54,32,97,114,103,115,51,48,51,54,32,101,110,118,51,48,51,55,41,0,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,51,48,50,57,32,37,97,114,103,115,51,48,50,52,51,48,52,49,41,0,0,0,0,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,51,48,50,56,41,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,51,48,49,54,32,46,32,116,109,112,51,48,49,53,51,48,49,55,41};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,14),40,102,95,57,49,49,55,32,120,51,49,49,49,41,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,7),40,97,57,48,52,48,41,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,7),40,97,57,48,52,53,41,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,7),40,97,57,48,54,57,41,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,19),40,108,111,111,112,32,102,115,51,49,49,55,32,114,51,49,49,56,41,0,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,16),40,102,95,57,49,51,54,32,46,32,95,51,49,48,49,41};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,16),40,102,95,57,49,50,56,32,46,32,95,51,48,57,57,41};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,51,48,55,51,32,97,99,116,105,111,110,51,48,56,52,32,105,100,51,48,56,53,32,108,105,109,105,116,51,48,56,54,41,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,108,105,109,105,116,51,48,55,55,32,37,97,99,116,105,111,110,51,48,55,48,51,49,53,56,32,37,105,100,51,48,55,49,51,49,53,57,41,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,28),40,100,101,102,45,105,100,51,48,55,54,32,37,97,99,116,105,111,110,51,48,55,48,51,49,54,51,41,0,0,0,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,19),40,97,57,49,53,54,32,120,51,49,54,56,32,121,51,49,54,57,41,0,0,0,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,99,116,105,111,110,51,48,55,53,41};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,51),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,51,48,54,49,32,112,114,101,100,51,48,54,50,32,46,32,97,99,116,105,111,110,45,105,100,45,108,105,109,105,116,51,48,54,51,41,0,0,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,51,49,57,51,41,0,0,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,15),40,97,57,50,53,53,32,112,105,100,49,52,50,54,41,0};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,24),40,97,57,50,55,51,32,112,105,100,49,52,51,53,32,112,103,105,100,49,52,51,54,41};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,7),40,97,57,50,57,52,41,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,14),40,97,57,50,57,55,32,105,100,49,49,51,55,41,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,7),40,97,57,51,49,50,41,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,14),40,97,57,51,49,53,32,105,100,49,49,50,56,41,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,7),40,97,57,51,51,48,41,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,14),40,97,57,51,51,51,32,105,100,49,49,49,57,41,0,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,7),40,97,57,51,52,56,41,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,14),40,97,57,51,53,49,32,105,100,49,49,49,48,41,0,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,13),40,97,57,51,54,54,32,110,49,48,57,50,41,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,15),40,97,57,51,55,50,32,112,111,114,116,53,50,53,41,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k9223 in set-root-directory! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub3185(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3185(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k8462 */
static C_word C_fcall stub2733(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2733(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2728(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2728(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2724(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2724(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub2568(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2568(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k8168 */
static C_word C_fcall stub2559(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2559(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub2553(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2553(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k8149 */
static C_word C_fcall stub2544(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2544(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k8125 */
static C_word C_fcall stub2530(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2530(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub2512(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2512(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub2426(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2426(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);else return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7937 */
static C_word C_fcall stub2397(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2397(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k7914 */
static C_word C_fcall stub2382(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2382(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k7803 */
static C_word C_fcall stub2333(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2333(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k7781 */
static C_word C_fcall stub2324(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2324(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub2316(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2316(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub2277(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2277(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub2235(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub2235(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub2227(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2227(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k7588 */
static C_word C_fcall stub2211(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2211(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k7488 */
static C_word C_fcall stub2164(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub2164(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k7426 */
static C_word C_fcall stub2125(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub2125(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k7325 */
static C_word C_fcall stub2076(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2076(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k6076 in k6072 in file-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1489(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1489(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5779 */
static C_word C_fcall stub1293(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1293(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k5648 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub1234(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1234(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_ret:
#undef return

return C_r;}

/* from k5641 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1228(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1228(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

/* from k5555 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1186(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1186(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a9294 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1134(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1134(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a9312 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1125(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1125(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a9330 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1116(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1116(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a9348 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1107(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1107(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k3802 */
static C_word C_fcall stub252(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub252(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k3792 */
static C_word C_fcall stub245(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub245(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k3782 */
static C_word C_fcall stub239(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub239(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k3564 */
static C_word C_fcall stub124(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub124(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k3513 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub46(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub46(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

/* from k3506 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub40(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub40(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k3482 */
static C_word C_fcall stub23(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub23(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3455)
static void C_ccall f_3455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3458)
static void C_ccall f_3458(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3461)
static void C_ccall f_3461(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3464)
static void C_ccall f_3464(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3467)
static void C_ccall f_3467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3470)
static void C_ccall f_3470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3473)
static void C_ccall f_3473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9373)
static void C_ccall f_9373(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9389)
static void C_ccall f_9389(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9377)
static void C_ccall f_9377(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9380)
static void C_ccall f_9380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4239)
static void C_ccall f_4239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5262)
static void C_ccall f_5262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9367)
static void C_ccall f_9367(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5397)
static void C_ccall f_5397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9352)
static void C_ccall f_9352(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9362)
static void C_ccall f_9362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9349)
static void C_ccall f_9349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5439)
static void C_ccall f_5439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9334)
static void C_ccall f_9334(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9344)
static void C_ccall f_9344(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9331)
static void C_ccall f_9331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5443)
static void C_ccall f_5443(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9316)
static void C_ccall f_9316(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9326)
static void C_ccall f_9326(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9313)
static void C_ccall f_9313(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5447)
static void C_ccall f_5447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9298)
static void C_ccall f_9298(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9308)
static void C_ccall f_9308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9295)
static void C_ccall f_9295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5451)
static void C_ccall f_5451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9274)
static void C_ccall f_9274(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9290)
static void C_ccall f_9290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9256)
static void C_ccall f_9256(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9269)
static void C_ccall f_9269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9263)
static void C_ccall f_9263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5969)
static void C_ccall f_5969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6008)
static void C_ccall f_6008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9233)
static void C_ccall f_9233(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9225)
static void C_ccall f_9225(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8974)
static void C_ccall f_8974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_8974)
static void C_ccall f_8974r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_9151)
static void C_fcall f_9151(C_word t0,C_word t1) C_noret;
C_noret_decl(f_9157)
static void C_ccall f_9157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9146)
static void C_fcall f_9146(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9141)
static void C_fcall f_9141(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8976)
static void C_fcall f_8976(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_9128)
static void C_ccall f_9128(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_9136)
static void C_ccall f_9136(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8983)
static void C_fcall f_8983(C_word t0,C_word t1) C_noret;
C_noret_decl(f_9116)
static void C_ccall f_9116(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9110)
static void C_ccall f_9110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8993)
static void C_ccall f_8993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8995)
static void C_fcall f_8995(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9014)
static void C_ccall f_9014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9096)
static void C_ccall f_9096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9103)
static void C_ccall f_9103(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9090)
static void C_ccall f_9090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9029)
static void C_ccall f_9029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9083)
static void C_ccall f_9083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9080)
static void C_ccall f_9080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9070)
static void C_ccall f_9070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9046)
static void C_ccall f_9046(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9068)
static void C_ccall f_9068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9054)
static void C_ccall f_9054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9061)
static void C_ccall f_9061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9058)
static void C_ccall f_9058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9041)
static void C_ccall f_9041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9039)
static void C_ccall f_9039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9117)
static void C_ccall f_9117(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8914)
static void C_ccall f_8914(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8914)
static void C_ccall f_8914r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8926)
static void C_fcall f_8926(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8921)
static void C_fcall f_8921(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8916)
static void C_fcall f_8916(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8854)
static void C_ccall f_8854(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8854)
static void C_ccall f_8854r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8866)
static void C_fcall f_8866(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8861)
static void C_fcall f_8861(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8856)
static void C_fcall f_8856(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8793)
static void C_fcall f_8793(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8848)
static void C_ccall f_8848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8852)
static void C_ccall f_8852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8814)
static void C_ccall f_8814(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8817)
static void C_ccall f_8817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8828)
static void C_ccall f_8828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8822)
static void C_ccall f_8822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8795)
static void C_fcall f_8795(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8804)
static void C_ccall f_8804(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8735)
static void C_ccall f_8735(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_8747)
static void C_ccall f_8747(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8778)
static void C_ccall f_8778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8758)
static void C_ccall f_8758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8774)
static void C_ccall f_8774(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8762)
static void C_ccall f_8762(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8770)
static void C_ccall f_8770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8766)
static void C_ccall f_8766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8741)
static void C_ccall f_8741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8724)
static void C_fcall f_8724(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8728)
static void C_ccall f_8728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8713)
static void C_fcall f_8713(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8717)
static void C_ccall f_8717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8668)
static void C_fcall f_8668(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8672)
static void C_ccall f_8672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8675)
static void C_ccall f_8675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8678)
static void C_ccall f_8678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8691)
static void C_ccall f_8691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8695)
static void C_ccall f_8695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8698)
static void C_ccall f_8698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8701)
static void C_ccall f_8701(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8689)
static void C_ccall f_8689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8652)
static C_word C_fcall f_8652(C_word *a,C_word t0);
C_noret_decl(f_8635)
static void C_fcall f_8635(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8648)
static void C_ccall f_8648(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8560)
static void C_ccall f_8560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8621)
static void C_fcall f_8621(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8634)
static void C_ccall f_8634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8601)
static void C_fcall f_8601(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8616)
static void C_ccall f_8616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8610)
static void C_ccall f_8610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8564)
static void C_fcall f_8564(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8566)
static void C_ccall f_8566(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8587)
static void C_ccall f_8587(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8581)
static void C_ccall f_8581(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8508)
static void C_ccall f_8508(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8508)
static void C_ccall f_8508r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8515)
static void C_ccall f_8515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8534)
static void C_ccall f_8534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8538)
static void C_ccall f_8538(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8502)
static void C_ccall f_8502(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8493)
static void C_ccall f_8493(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8497)
static void C_ccall f_8497(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8466)
static void C_ccall f_8466(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8466)
static void C_ccall f_8466r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8459)
static void C_ccall f_8459(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8456)
static void C_ccall f_8456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8453)
static void C_ccall f_8453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8375)
static void C_ccall f_8375(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8375)
static void C_ccall f_8375r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_8411)
static void C_ccall f_8411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8405)
static void C_ccall f_8405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8358)
static void C_ccall f_8358(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8176)
static void C_ccall f_8176(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8176)
static void C_ccall f_8176r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8310)
static void C_fcall f_8310(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8305)
static void C_fcall f_8305(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8178)
static void C_fcall f_8178(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8188)
static void C_ccall f_8188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8196)
static void C_fcall f_8196(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8242)
static C_word C_fcall f_8242(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_8209)
static void C_fcall f_8209(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8234)
static void C_ccall f_8234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8212)
static void C_ccall f_8212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8157)
static C_word C_fcall f_8157(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_8138)
static C_word C_fcall f_8138(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_8096)
static void C_ccall f_8096(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8096)
static void C_ccall f_8096r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_8118)
static void C_ccall f_8118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8122)
static void C_ccall f_8122(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7987)
static void C_ccall f_7987(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7987)
static void C_ccall f_7987r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7993)
static void C_fcall f_7993(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8014)
static void C_ccall f_8014(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8088)
static void C_ccall f_8088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8018)
static void C_ccall f_8018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8021)
static void C_ccall f_8021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8028)
static void C_ccall f_8028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8030)
static void C_fcall f_8030(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8047)
static void C_ccall f_8047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8057)
static void C_ccall f_8057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8061)
static void C_ccall f_8061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8008)
static void C_ccall f_8008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7975)
static void C_ccall f_7975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7979)
static void C_ccall f_7979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7982)
static void C_ccall f_7982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7940)
static void C_ccall f_7940(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7944)
static void C_ccall f_7944(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7964)
static void C_ccall f_7964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7968)
static void C_ccall f_7968(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7917)
static void C_ccall f_7917(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7921)
static void C_ccall f_7921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7885)
static void C_fcall f_7885(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7889)
static void C_ccall f_7889(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7866)
static void C_ccall f_7866(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7870)
static void C_ccall f_7870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7873)
static void C_ccall f_7873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7807)
static void C_ccall f_7807(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_7807)
static void C_ccall f_7807r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7811)
static void C_ccall f_7811(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7817)
static void C_ccall f_7817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7800)
static void C_ccall f_7800(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7784)
static void C_ccall f_7784(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7784)
static void C_ccall f_7784r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7772)
static void C_ccall f_7772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7757)
static void C_ccall f_7757(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7761)
static void C_ccall f_7761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7742)
static void C_ccall f_7742(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7746)
static void C_ccall f_7746(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7696)
static void C_ccall f_7696(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7696)
static void C_ccall f_7696r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7700)
static void C_ccall f_7700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7713)
static void C_ccall f_7713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7717)
static void C_ccall f_7717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7627)
static void C_ccall f_7627(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7627)
static void C_ccall f_7627r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7631)
static void C_ccall f_7631(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7634)
static void C_ccall f_7634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7656)
static void C_ccall f_7656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7653)
static void C_ccall f_7653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7643)
static void C_ccall f_7643(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7591)
static void C_ccall f_7591(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7598)
static void C_ccall f_7598(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7572)
static void C_ccall f_7572(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7563)
static void C_ccall f_7563(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7544)
static void C_fcall f_7544(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7538)
static void C_ccall f_7538(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7529)
static void C_ccall f_7529(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7494)
static void C_ccall f_7494(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7494)
static void C_ccall f_7494r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7432)
static void C_ccall f_7432(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_7432)
static void C_ccall f_7432r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_7436)
static void C_ccall f_7436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7442)
static void C_ccall f_7442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7461)
static void C_ccall f_7461(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7448)
static void C_ccall f_7448(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7328)
static void C_ccall f_7328(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7334)
static void C_fcall f_7334(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7338)
static void C_ccall f_7338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7346)
static void C_fcall f_7346(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7372)
static void C_ccall f_7372(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7376)
static void C_ccall f_7376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7364)
static void C_ccall f_7364(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7308)
static void C_ccall f_7308(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7316)
static void C_ccall f_7316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7291)
static void C_ccall f_7291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7302)
static void C_ccall f_7302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7306)
static void C_ccall f_7306(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7265)
static void C_ccall f_7265(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7289)
static void C_ccall f_7289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7272)
static void C_ccall f_7272(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7222)
static void C_ccall f_7222(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7222)
static void C_ccall f_7222r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7229)
static void C_fcall f_7229(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7250)
static void C_ccall f_7250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7246)
static void C_ccall f_7246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7194)
static void C_ccall f_7194(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7172)
static void C_ccall f_7172(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7172)
static void C_ccall f_7172r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7176)
static void C_ccall f_7176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7157)
static void C_ccall f_7157(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7157)
static void C_ccall f_7157r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7161)
static void C_ccall f_7161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7142)
static void C_ccall f_7142(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7142)
static void C_ccall f_7142r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7146)
static void C_ccall f_7146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7124)
static void C_fcall f_7124(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7050)
static void C_fcall f_7050(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7072)
static void C_ccall f_7072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7078)
static void C_fcall f_7078(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7011)
static void C_ccall f_7011(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7039)
static void C_ccall f_7039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7035)
static void C_ccall f_7035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7028)
static void C_ccall f_7028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6752)
static void C_ccall f_6752(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6752)
static void C_ccall f_6752r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6948)
static void C_fcall f_6948(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6943)
static void C_fcall f_6943(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6938)
static void C_fcall f_6938(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6754)
static void C_fcall f_6754(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6758)
static void C_ccall f_6758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6864)
static void C_ccall f_6864(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6865)
static void C_ccall f_6865(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6882)
static void C_fcall f_6882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6892)
static void C_ccall f_6892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6850)
static void C_ccall f_6850(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6806)
static void C_fcall f_6806(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6842)
static void C_ccall f_6842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6821)
static void C_ccall f_6821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6831)
static void C_ccall f_6831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6815)
static void C_ccall f_6815(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6810)
static void C_ccall f_6810(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6813)
static void C_ccall f_6813(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6760)
static void C_fcall f_6760(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6795)
static void C_ccall f_6795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6776)
static void C_ccall f_6776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6674)
static void C_fcall f_6674(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6669)
static void C_fcall f_6669(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6664)
static void C_fcall f_6664(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6659)
static void C_fcall f_6659(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6272)
static void C_fcall f_6272(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6276)
static void C_ccall f_6276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6282)
static void C_ccall f_6282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6532)
static void C_ccall f_6532(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6538)
static void C_fcall f_6538(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6634)
static void C_ccall f_6634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6624)
static void C_ccall f_6624(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6618)
static void C_ccall f_6618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6540)
static void C_ccall f_6540(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6590)
static void C_ccall f_6590(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6547)
static void C_ccall f_6547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6557)
static void C_ccall f_6557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6456)
static void C_ccall f_6456(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6464)
static void C_fcall f_6464(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6466)
static void C_fcall f_6466(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6514)
static void C_ccall f_6514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6447)
static void C_ccall f_6447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6451)
static void C_ccall f_6451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6426)
static void C_ccall f_6426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6436)
static void C_ccall f_6436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6414)
static void C_ccall f_6414(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6401)
static void C_ccall f_6401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6405)
static void C_ccall f_6405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6396)
static void C_ccall f_6396(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6399)
static void C_ccall f_6399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6314)
static void C_fcall f_6314(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6326)
static void C_fcall f_6326(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6363)
static void C_ccall f_6363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6372)
static void C_ccall f_6372(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6366)
static void C_ccall f_6366(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6342)
static void C_ccall f_6342(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6345)
static void C_ccall f_6345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6306)
static C_word C_fcall f_6306(C_word t0);
C_noret_decl(f_6283)
static void C_fcall f_6283(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6287)
static void C_ccall f_6287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6243)
static void C_ccall f_6243(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6243)
static void C_ccall f_6243r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6250)
static void C_fcall f_6250(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6253)
static void C_ccall f_6253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6198)
static void C_ccall f_6198(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6202)
static void C_ccall f_6202(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6237)
static void C_ccall f_6237(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6220)
static void C_ccall f_6220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6184)
static void C_ccall f_6184(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6184)
static void C_ccall f_6184r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6196)
static void C_ccall f_6196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6170)
static void C_ccall f_6170(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6170)
static void C_ccall f_6170r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6182)
static void C_ccall f_6182(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6155)
static void C_fcall f_6155(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6168)
static void C_ccall f_6168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6118)
static void C_fcall f_6118(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6126)
static void C_ccall f_6126(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6093)
static void C_ccall f_6093(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6074)
static void C_ccall f_6074(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6078)
static void C_ccall f_6078(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6009)
static void C_ccall f_6009(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6009)
static void C_ccall f_6009r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6013)
static void C_ccall f_6013(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6048)
static void C_ccall f_6048(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6020)
static void C_ccall f_6020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6026)
static void C_ccall f_6026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6032)
static void C_ccall f_6032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5971)
static void C_ccall f_5971(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6004)
static void C_ccall f_6004(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5992)
static void C_ccall f_5992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6000)
static void C_ccall f_6000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5996)
static void C_ccall f_5996(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5952)
static void C_ccall f_5952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5962)
static void C_ccall f_5962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5956)
static void C_ccall f_5956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5946)
static void C_ccall f_5946(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5940)
static void C_ccall f_5940(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5934)
static void C_ccall f_5934(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5910)
static void C_fcall f_5910(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5932)
static void C_ccall f_5932(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5928)
static void C_ccall f_5928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5920)
static void C_ccall f_5920(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5880)
static void C_ccall f_5880(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5908)
static void C_ccall f_5908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5904)
static void C_ccall f_5904(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5853)
static void C_ccall f_5853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5878)
static void C_ccall f_5878(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5874)
static void C_ccall f_5874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5789)
static void C_ccall f_5789(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5777)
static void C_ccall f_5777(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5805)
static void C_ccall f_5805(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5715)
static void C_ccall f_5715(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5719)
static void C_ccall f_5719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5724)
static void C_fcall f_5724(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5740)
static void C_ccall f_5740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5652)
static void C_ccall f_5652(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5710)
static void C_ccall f_5710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5656)
static void C_ccall f_5656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5659)
static void C_ccall f_5659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5691)
static void C_ccall f_5691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5662)
static void C_ccall f_5662(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5667)
static void C_fcall f_5667(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5681)
static void C_ccall f_5681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5645)
static C_word C_fcall f_5645(C_word t0);
C_noret_decl(f_5559)
static void C_ccall f_5559(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5563)
static void C_ccall f_5563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5617)
static void C_ccall f_5617(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5566)
static void C_fcall f_5566(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5576)
static void C_ccall f_5576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5580)
static void C_ccall f_5580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5589)
static void C_fcall f_5589(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5593)
static void C_ccall f_5593(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5603)
static void C_ccall f_5603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5584)
static void C_ccall f_5584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5534)
static void C_ccall f_5534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5546)
static void C_ccall f_5546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5542)
static void C_ccall f_5542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5520)
static void C_ccall f_5520(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5532)
static void C_ccall f_5532(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5528)
static void C_ccall f_5528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5453)
static void C_ccall f_5453(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5453)
static void C_ccall f_5453r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5457)
static void C_ccall f_5457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5499)
static void C_ccall f_5499(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5460)
static void C_fcall f_5460(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5470)
static void C_ccall f_5470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5482)
static void C_ccall f_5482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5486)
static void C_ccall f_5486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5399)
static void C_ccall f_5399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5432)
static void C_ccall f_5432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5403)
static void C_ccall f_5403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5410)
static void C_ccall f_5410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5414)
static void C_ccall f_5414(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5418)
static void C_ccall f_5418(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5422)
static void C_ccall f_5422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5426)
static void C_ccall f_5426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5381)
static void C_ccall f_5381(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5366)
static void C_ccall f_5366(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5360)
static void C_ccall f_5360(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5328)
static void C_ccall f_5328(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5334)
static void C_fcall f_5334(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5304)
static void C_ccall f_5304(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5322)
static void C_ccall f_5322(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5311)
static void C_ccall f_5311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5286)
static void C_ccall f_5286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5296)
static void C_ccall f_5296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5273)
static void C_ccall f_5273(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5264)
static void C_ccall f_5264(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5217)
static void C_ccall f_5217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5221)
static void C_ccall f_5221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5197)
static void C_ccall f_5197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5197)
static void C_ccall f_5197r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5201)
static void C_ccall f_5201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5207)
static void C_ccall f_5207(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5207)
static void C_ccall f_5207r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5211)
static void C_ccall f_5211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5177)
static void C_ccall f_5177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5177)
static void C_ccall f_5177r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5181)
static void C_ccall f_5181(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5187)
static void C_ccall f_5187(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5187)
static void C_ccall f_5187r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5191)
static void C_ccall f_5191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5153)
static void C_ccall f_5153(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5153)
static void C_ccall f_5153r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5157)
static void C_ccall f_5157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5168)
static void C_ccall f_5168(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5168)
static void C_ccall f_5168r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5172)
static void C_ccall f_5172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5162)
static void C_ccall f_5162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5129)
static void C_ccall f_5129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5129)
static void C_ccall f_5129r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5133)
static void C_ccall f_5133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5144)
static void C_ccall f_5144(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5144)
static void C_ccall f_5144r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5148)
static void C_ccall f_5148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5138)
static void C_ccall f_5138(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5113)
static void C_ccall f_5113(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5117)
static void C_ccall f_5117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5120)
static void C_ccall f_5120(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5077)
static void C_ccall f_5077(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5077)
static void C_ccall f_5077r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5108)
static void C_ccall f_5108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5098)
static void C_ccall f_5098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5091)
static void C_ccall f_5091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5041)
static void C_ccall f_5041(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5041)
static void C_ccall f_5041r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5072)
static void C_ccall f_5072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5062)
static void C_ccall f_5062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5055)
static void C_ccall f_5055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5026)
static void C_fcall f_5026(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5039)
static void C_ccall f_5039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5020)
static void C_fcall f_5020(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5008)
static C_word C_fcall f_5008(C_word t0);
C_noret_decl(f_4691)
static void C_ccall f_4691(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4998)
static void C_ccall f_4998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4818)
static void C_fcall f_4818(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4984)
static void C_ccall f_4984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4973)
static void C_ccall f_4973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4980)
static void C_ccall f_4980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4837)
static void C_fcall f_4837(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4966)
static void C_ccall f_4966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4945)
static void C_ccall f_4945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4951)
static void C_ccall f_4951(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4958)
static void C_ccall f_4958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4881)
static void C_fcall f_4881(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4942)
static void C_ccall f_4942(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4921)
static void C_ccall f_4921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4938)
static void C_ccall f_4938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4927)
static void C_ccall f_4927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4934)
static void C_ccall f_4934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4894)
static void C_ccall f_4894(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4918)
static void C_ccall f_4918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4914)
static void C_ccall f_4914(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4844)
static void C_ccall f_4844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4862)
static void C_ccall f_4862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4847)
static void C_ccall f_4847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4851)
static void C_ccall f_4851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4831)
static void C_ccall f_4831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4812)
static void C_ccall f_4812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4698)
static void C_ccall f_4698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4705)
static void C_ccall f_4705(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4707)
static void C_fcall f_4707(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4714)
static void C_ccall f_4714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4778)
static void C_ccall f_4778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4787)
static void C_ccall f_4787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4775)
static void C_fcall f_4775(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4720)
static void C_ccall f_4720(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4756)
static void C_ccall f_4756(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4752)
static void C_ccall f_4752(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4748)
static void C_ccall f_4748(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4737)
static void C_ccall f_4737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4733)
static void C_ccall f_4733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4635)
static void C_fcall f_4635(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4644)
static void C_ccall f_4644(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4668)
static void C_ccall f_4668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4686)
static void C_ccall f_4686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4674)
static void C_ccall f_4674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4650)
static void C_ccall f_4650(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4656)
static void C_ccall f_4656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4642)
static void C_ccall f_4642(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4624)
static C_word C_fcall f_4624(C_word t0);
C_noret_decl(f_4619)
static void C_fcall f_4619(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4571)
static void C_ccall f_4571(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4571)
static void C_ccall f_4571r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4575)
static void C_ccall f_4575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4584)
static void C_ccall f_4584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4548)
static void C_ccall f_4548(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4555)
static void C_ccall f_4555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4496)
static void C_fcall f_4496(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4504)
static void C_ccall f_4504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4491)
static void C_fcall f_4491(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4393)
static void C_fcall f_4393(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4400)
static void C_ccall f_4400(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4403)
static void C_ccall f_4403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4406)
static void C_ccall f_4406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4490)
static void C_ccall f_4490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4410)
static void C_ccall f_4410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4424)
static void C_fcall f_4424(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4434)
static void C_ccall f_4434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4437)
static void C_ccall f_4437(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4440)
static void C_ccall f_4440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4446)
static void C_fcall f_4446(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4456)
static void C_ccall f_4456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4367)
static void C_ccall f_4367(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4389)
static void C_ccall f_4389(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4385)
static void C_ccall f_4385(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4343)
static void C_ccall f_4343(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4365)
static void C_ccall f_4365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4361)
static void C_ccall f_4361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4241)
static void C_ccall f_4241(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4241)
static void C_ccall f_4241r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4245)
static void C_ccall f_4245(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4322)
static void C_ccall f_4322(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4308)
static void C_ccall f_4308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4256)
static void C_ccall f_4256(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4261)
static void C_ccall f_4261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4284)
static void C_ccall f_4284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4304)
static void C_ccall f_4304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4267)
static void C_ccall f_4267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4281)
static void C_ccall f_4281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4179)
static void C_ccall f_4179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4179)
static void C_ccall f_4179r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4192)
static void C_ccall f_4192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4204)
static void C_ccall f_4204(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4198)
static void C_ccall f_4198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4169)
static void C_ccall f_4169(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4176)
static void C_ccall f_4176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4165)
static void C_ccall f_4165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4155)
static void C_ccall f_4155(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4138)
static void C_ccall f_4138(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4145)
static void C_ccall f_4145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4129)
static void C_ccall f_4129(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4136)
static void C_ccall f_4136(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4120)
static void C_ccall f_4120(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4127)
static void C_ccall f_4127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4111)
static void C_ccall f_4111(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4102)
static void C_ccall f_4102(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4109)
static void C_ccall f_4109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4090)
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4094)
static void C_ccall f_4094(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4084)
static void C_ccall f_4084(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4088)
static void C_ccall f_4088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4078)
static void C_ccall f_4078(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4082)
static void C_ccall f_4082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4072)
static void C_ccall f_4072(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4076)
static void C_ccall f_4076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4066)
static void C_ccall f_4066(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4070)
static void C_ccall f_4070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4034)
static void C_ccall f_4034(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4034)
static void C_ccall f_4034r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4045)
static void C_ccall f_4045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4038)
static void C_ccall f_4038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3997)
static void C_fcall f_3997(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4029)
static void C_ccall f_4029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4022)
static void C_ccall f_4022(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4001)
static void C_ccall f_4001(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3805)
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3805)
static void C_ccall f_3805r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3978)
static void C_ccall f_3978(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3821)
static void C_ccall f_3821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3827)
static void C_ccall f_3827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3830)
static void C_fcall f_3830(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3912)
static void C_ccall f_3912(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3910)
static void C_ccall f_3910(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3869)
static void C_fcall f_3869(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3887)
static void C_ccall f_3887(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3885)
static void C_ccall f_3885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3873)
static void C_fcall f_3873(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3795)
static C_word C_fcall f_3795(C_word t0,C_word t1);
C_noret_decl(f_3785)
static C_word C_fcall f_3785(C_word t0,C_word t1);
C_noret_decl(f_3779)
static C_word C_fcall f_3779(C_word t0);
C_noret_decl(f_3747)
static void C_ccall f_3747(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3754)
static void C_ccall f_3754(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3760)
static void C_ccall f_3760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3767)
static void C_ccall f_3767(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3708)
static void C_ccall f_3708(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3708)
static void C_ccall f_3708r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3724)
static void C_ccall f_3724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3666)
static void C_ccall f_3666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3666)
static void C_ccall f_3666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3679)
static void C_ccall f_3679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3682)
static void C_ccall f_3682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3651)
static void C_ccall f_3651(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3613)
static void C_ccall f_3613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3613)
static void C_ccall f_3613r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3643)
static void C_ccall f_3643(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3630)
static void C_ccall f_3630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3633)
static void C_ccall f_3633(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3567)
static void C_ccall f_3567(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3567)
static void C_ccall f_3567r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3571)
static void C_ccall f_3571(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3510)
static void C_ccall f_3510(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3503)
static void C_ccall f_3503(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3485)
static void C_ccall f_3485(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_3485)
static void C_ccall f_3485r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_3489)
static void C_ccall f_3489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3500)
static void C_ccall f_3500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3496)
static void C_ccall f_3496(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_9151)
static void C_fcall trf_9151(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_9151(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_9151(t0,t1);}

C_noret_decl(trf_9146)
static void C_fcall trf_9146(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_9146(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_9146(t0,t1,t2);}

C_noret_decl(trf_9141)
static void C_fcall trf_9141(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_9141(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_9141(t0,t1,t2,t3);}

C_noret_decl(trf_8976)
static void C_fcall trf_8976(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8976(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_8976(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8983)
static void C_fcall trf_8983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8983(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8983(t0,t1);}

C_noret_decl(trf_8995)
static void C_fcall trf_8995(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8995(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8995(t0,t1,t2,t3);}

C_noret_decl(trf_8926)
static void C_fcall trf_8926(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8926(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8926(t0,t1);}

C_noret_decl(trf_8921)
static void C_fcall trf_8921(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8921(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8921(t0,t1,t2);}

C_noret_decl(trf_8916)
static void C_fcall trf_8916(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8916(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8916(t0,t1,t2,t3);}

C_noret_decl(trf_8866)
static void C_fcall trf_8866(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8866(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8866(t0,t1);}

C_noret_decl(trf_8861)
static void C_fcall trf_8861(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8861(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8861(t0,t1,t2);}

C_noret_decl(trf_8856)
static void C_fcall trf_8856(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8856(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8856(t0,t1,t2,t3);}

C_noret_decl(trf_8793)
static void C_fcall trf_8793(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8793(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_8793(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_8795)
static void C_fcall trf_8795(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8795(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8795(t0,t1,t2);}

C_noret_decl(trf_8724)
static void C_fcall trf_8724(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8724(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8724(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8713)
static void C_fcall trf_8713(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8713(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8713(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8668)
static void C_fcall trf_8668(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8668(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_8668(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8635)
static void C_fcall trf_8635(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8635(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_8635(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8621)
static void C_fcall trf_8621(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8621(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8621(t0,t1,t2,t3);}

C_noret_decl(trf_8601)
static void C_fcall trf_8601(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8601(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8601(t0,t1,t2);}

C_noret_decl(trf_8564)
static void C_fcall trf_8564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8564(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_8564(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8310)
static void C_fcall trf_8310(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8310(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8310(t0,t1);}

C_noret_decl(trf_8305)
static void C_fcall trf_8305(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8305(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8305(t0,t1,t2);}

C_noret_decl(trf_8178)
static void C_fcall trf_8178(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8178(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8178(t0,t1,t2,t3);}

C_noret_decl(trf_8196)
static void C_fcall trf_8196(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8196(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8196(t0,t1,t2,t3);}

C_noret_decl(trf_8209)
static void C_fcall trf_8209(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8209(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8209(t0,t1);}

C_noret_decl(trf_7993)
static void C_fcall trf_7993(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7993(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7993(t0,t1,t2);}

C_noret_decl(trf_8030)
static void C_fcall trf_8030(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8030(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8030(t0,t1,t2);}

C_noret_decl(trf_7885)
static void C_fcall trf_7885(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7885(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7885(t0,t1,t2);}

C_noret_decl(trf_7544)
static void C_fcall trf_7544(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7544(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7544(t0,t1,t2);}

C_noret_decl(trf_7334)
static void C_fcall trf_7334(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7334(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7334(t0,t1,t2);}

C_noret_decl(trf_7346)
static void C_fcall trf_7346(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7346(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7346(t0,t1,t2);}

C_noret_decl(trf_7229)
static void C_fcall trf_7229(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7229(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7229(t0,t1);}

C_noret_decl(trf_7124)
static void C_fcall trf_7124(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7124(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7124(t0,t1,t2,t3);}

C_noret_decl(trf_7050)
static void C_fcall trf_7050(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7050(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7050(t0,t1,t2,t3);}

C_noret_decl(trf_7078)
static void C_fcall trf_7078(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7078(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7078(t0,t1);}

C_noret_decl(trf_6948)
static void C_fcall trf_6948(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6948(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6948(t0,t1);}

C_noret_decl(trf_6943)
static void C_fcall trf_6943(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6943(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6943(t0,t1,t2);}

C_noret_decl(trf_6938)
static void C_fcall trf_6938(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6938(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6938(t0,t1,t2,t3);}

C_noret_decl(trf_6754)
static void C_fcall trf_6754(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6754(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6754(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6882)
static void C_fcall trf_6882(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6882(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6882(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6806)
static void C_fcall trf_6806(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6806(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6806(t0,t1);}

C_noret_decl(trf_6760)
static void C_fcall trf_6760(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6760(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6760(t0,t1,t2,t3);}

C_noret_decl(trf_6674)
static void C_fcall trf_6674(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6674(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6674(t0,t1);}

C_noret_decl(trf_6669)
static void C_fcall trf_6669(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6669(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6669(t0,t1,t2);}

C_noret_decl(trf_6664)
static void C_fcall trf_6664(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6664(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6664(t0,t1,t2,t3);}

C_noret_decl(trf_6659)
static void C_fcall trf_6659(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6659(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6659(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6272)
static void C_fcall trf_6272(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6272(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_6272(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_6538)
static void C_fcall trf_6538(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6538(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6538(t0,t1,t2);}

C_noret_decl(trf_6464)
static void C_fcall trf_6464(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6464(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6464(t0,t1);}

C_noret_decl(trf_6466)
static void C_fcall trf_6466(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6466(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6466(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6314)
static void C_fcall trf_6314(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6314(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6314(t0,t1);}

C_noret_decl(trf_6326)
static void C_fcall trf_6326(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6326(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6326(t0,t1);}

C_noret_decl(trf_6283)
static void C_fcall trf_6283(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6283(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6283(t0,t1);}

C_noret_decl(trf_6250)
static void C_fcall trf_6250(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6250(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6250(t0,t1);}

C_noret_decl(trf_6155)
static void C_fcall trf_6155(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6155(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6155(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6118)
static void C_fcall trf_6118(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6118(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6118(t0,t1,t2);}

C_noret_decl(trf_5910)
static void C_fcall trf_5910(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5910(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5910(t0,t1,t2,t3);}

C_noret_decl(trf_5724)
static void C_fcall trf_5724(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5724(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5724(t0,t1,t2,t3);}

C_noret_decl(trf_5667)
static void C_fcall trf_5667(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5667(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5667(t0,t1,t2);}

C_noret_decl(trf_5566)
static void C_fcall trf_5566(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5566(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5566(t0,t1);}

C_noret_decl(trf_5589)
static void C_fcall trf_5589(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5589(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5589(t0,t1,t2);}

C_noret_decl(trf_5460)
static void C_fcall trf_5460(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5460(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5460(t0,t1);}

C_noret_decl(trf_5334)
static void C_fcall trf_5334(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5334(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5334(t0,t1,t2,t3);}

C_noret_decl(trf_5026)
static void C_fcall trf_5026(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5026(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5026(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5020)
static void C_fcall trf_5020(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5020(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5020(t0,t1);}

C_noret_decl(trf_4818)
static void C_fcall trf_4818(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4818(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4818(t0,t1);}

C_noret_decl(trf_4837)
static void C_fcall trf_4837(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4837(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4837(t0,t1);}

C_noret_decl(trf_4881)
static void C_fcall trf_4881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4881(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4881(t0,t1);}

C_noret_decl(trf_4707)
static void C_fcall trf_4707(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4707(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4707(t0,t1,t2,t3);}

C_noret_decl(trf_4775)
static void C_fcall trf_4775(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4775(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4775(t0,t1);}

C_noret_decl(trf_4635)
static void C_fcall trf_4635(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4635(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4635(t0,t1);}

C_noret_decl(trf_4619)
static void C_fcall trf_4619(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4619(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4619(t0,t1);}

C_noret_decl(trf_4496)
static void C_fcall trf_4496(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4496(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4496(t0,t1);}

C_noret_decl(trf_4491)
static void C_fcall trf_4491(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4491(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4491(t0,t1,t2);}

C_noret_decl(trf_4393)
static void C_fcall trf_4393(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4393(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4393(t0,t1,t2,t3);}

C_noret_decl(trf_4424)
static void C_fcall trf_4424(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4424(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4424(t0,t1);}

C_noret_decl(trf_4446)
static void C_fcall trf_4446(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4446(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4446(t0,t1);}

C_noret_decl(trf_3997)
static void C_fcall trf_3997(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3997(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3997(t0,t1,t2,t3);}

C_noret_decl(trf_3830)
static void C_fcall trf_3830(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3830(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3830(t0,t1);}

C_noret_decl(trf_3869)
static void C_fcall trf_3869(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3869(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3869(t0,t1);}

C_noret_decl(trf_3873)
static void C_fcall trf_3873(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3873(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3873(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3370)){
C_save(t1);
C_rereclaim2(3370*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,468);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[9]=C_h_intern(&lf[9],21,"\003sysfile-nonblocking!");
lf[10]=C_h_intern(&lf[10],19,"\003sysfile-select-one");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"fcntl/dupfd");
lf[13]=C_h_intern(&lf[13],11,"fcntl/getfd");
lf[14]=C_h_intern(&lf[14],11,"fcntl/setfd");
lf[15]=C_h_intern(&lf[15],11,"fcntl/getfl");
lf[16]=C_h_intern(&lf[16],11,"fcntl/setfl");
lf[17]=C_h_intern(&lf[17],11,"open/rdonly");
lf[18]=C_h_intern(&lf[18],11,"open/wronly");
lf[19]=C_h_intern(&lf[19],9,"open/rdwr");
lf[20]=C_h_intern(&lf[20],9,"open/read");
lf[21]=C_h_intern(&lf[21],10,"open/write");
lf[22]=C_h_intern(&lf[22],10,"open/creat");
lf[23]=C_h_intern(&lf[23],11,"open/append");
lf[24]=C_h_intern(&lf[24],9,"open/excl");
lf[25]=C_h_intern(&lf[25],11,"open/noctty");
lf[26]=C_h_intern(&lf[26],13,"open/nonblock");
lf[27]=C_h_intern(&lf[27],10,"open/trunc");
lf[28]=C_h_intern(&lf[28],9,"open/sync");
lf[29]=C_h_intern(&lf[29],10,"open/fsync");
lf[30]=C_h_intern(&lf[30],11,"open/binary");
lf[31]=C_h_intern(&lf[31],9,"open/text");
lf[32]=C_h_intern(&lf[32],10,"perm/irusr");
lf[33]=C_h_intern(&lf[33],10,"perm/iwusr");
lf[34]=C_h_intern(&lf[34],10,"perm/ixusr");
lf[35]=C_h_intern(&lf[35],10,"perm/irgrp");
lf[36]=C_h_intern(&lf[36],10,"perm/iwgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/ixgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/iroth");
lf[39]=C_h_intern(&lf[39],10,"perm/iwoth");
lf[40]=C_h_intern(&lf[40],10,"perm/ixoth");
lf[41]=C_h_intern(&lf[41],10,"perm/irwxu");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxg");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxo");
lf[44]=C_h_intern(&lf[44],10,"perm/isvtx");
lf[45]=C_h_intern(&lf[45],10,"perm/isuid");
lf[46]=C_h_intern(&lf[46],10,"perm/isgid");
lf[47]=C_h_intern(&lf[47],12,"file-control");
lf[48]=C_h_intern(&lf[48],11,"\000file-error");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[50]=C_h_intern(&lf[50],9,"\003syserror");
lf[51]=C_h_intern(&lf[51],9,"file-open");
lf[52]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[53]=C_h_intern(&lf[53],17,"\003sysmake-c-string");
lf[54]=C_h_intern(&lf[54],20,"\003sysexpand-home-path");
lf[55]=C_h_intern(&lf[55],10,"file-close");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[57]=C_h_intern(&lf[57],11,"make-string");
lf[58]=C_h_intern(&lf[58],9,"file-read");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[60]=C_h_intern(&lf[60],11,"\000type-error");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[62]=C_h_intern(&lf[62],10,"file-write");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[65]=C_h_intern(&lf[65],12,"file-mkstemp");
lf[66]=C_h_intern(&lf[66],13,"\003syssubstring");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[68]=C_h_intern(&lf[68],11,"file-select");
lf[69]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[70]=C_h_intern(&lf[70],12,"\003sysfor-each");
lf[71]=C_h_intern(&lf[71],8,"seek/set");
lf[72]=C_h_intern(&lf[72],8,"seek/end");
lf[73]=C_h_intern(&lf[73],8,"seek/cur");
lf[75]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[76]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[77]=C_h_intern(&lf[77],9,"file-stat");
lf[78]=C_h_intern(&lf[78],9,"file-size");
lf[79]=C_h_intern(&lf[79],22,"file-modification-time");
lf[80]=C_h_intern(&lf[80],16,"file-access-time");
lf[81]=C_h_intern(&lf[81],16,"file-change-time");
lf[82]=C_h_intern(&lf[82],10,"file-owner");
lf[83]=C_h_intern(&lf[83],16,"file-permissions");
lf[84]=C_h_intern(&lf[84],13,"regular-file\077");
lf[85]=C_h_intern(&lf[85],14,"symbolic-link\077");
lf[86]=C_h_intern(&lf[86],13,"stat-regular\077");
lf[87]=C_h_intern(&lf[87],15,"stat-directory\077");
lf[88]=C_h_intern(&lf[88],17,"character-device\077");
lf[89]=C_h_intern(&lf[89],17,"stat-char-device\077");
lf[90]=C_h_intern(&lf[90],13,"block-device\077");
lf[91]=C_h_intern(&lf[91],18,"stat-block-device\077");
lf[92]=C_h_intern(&lf[92],5,"fifo\077");
lf[93]=C_h_intern(&lf[93],10,"stat-fifo\077");
lf[94]=C_h_intern(&lf[94],13,"stat-symlink\077");
lf[95]=C_h_intern(&lf[95],7,"socket\077");
lf[96]=C_h_intern(&lf[96],12,"stat-socket\077");
lf[97]=C_h_intern(&lf[97],18,"set-file-position!");
lf[98]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[99]=C_h_intern(&lf[99],6,"stream");
lf[100]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[101]=C_h_intern(&lf[101],5,"port\077");
lf[102]=C_h_intern(&lf[102],13,"\000bounds-error");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[104]=C_h_intern(&lf[104],13,"file-position");
lf[105]=C_h_intern(&lf[105],16,"create-directory");
lf[106]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[108]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot stat file");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000\026path segment is a file");
lf[110]=C_h_intern(&lf[110],12,"file-exists\077");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[112]=C_h_intern(&lf[112],12,"string-split");
lf[113]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[114]=C_h_intern(&lf[114],16,"change-directory");
lf[115]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[116]=C_h_intern(&lf[116],16,"delete-directory");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[118]=C_h_intern(&lf[118],10,"string-ref");
lf[119]=C_h_intern(&lf[119],6,"string");
lf[120]=C_h_intern(&lf[120],9,"directory");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[122]=C_h_intern(&lf[122],16,"\003sysmake-pointer");
lf[123]=C_h_intern(&lf[123],17,"current-directory");
lf[124]=C_h_intern(&lf[124],10,"directory\077");
lf[125]=C_h_intern(&lf[125],13,"\003sysfile-info");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[127]=C_h_intern(&lf[127],5,"null\077");
lf[128]=C_h_intern(&lf[128],6,"char=\077");
lf[129]=C_h_intern(&lf[129],8,"string=\077");
lf[130]=C_h_intern(&lf[130],16,"char-alphabetic\077");
lf[131]=C_h_intern(&lf[131],18,"string-intersperse");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[133]=C_h_intern(&lf[133],24,"get-environment-variable");
lf[134]=C_h_intern(&lf[134],17,"current-user-name");
lf[135]=C_h_intern(&lf[135],9,"condition");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[137]=C_h_intern(&lf[137],22,"with-exception-handler");
lf[138]=C_h_intern(&lf[138],30,"call-with-current-continuation");
lf[139]=C_h_intern(&lf[139],14,"canonical-path");
lf[140]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[141]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[143]=C_h_intern(&lf[143],7,"reverse");
lf[144]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[148]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[149]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\006/home/");
lf[151]=C_decode_literal(C_heaptop,"\376B\000\000\004HOME");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[153]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[154]=C_h_intern(&lf[154],5,"\000text");
lf[155]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[156]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[157]=C_h_intern(&lf[157],13,"\003sysmake-port");
lf[158]=C_h_intern(&lf[158],21,"\003sysstream-port-class");
lf[159]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[160]=C_h_intern(&lf[160],15,"open-input-pipe");
lf[161]=C_h_intern(&lf[161],7,"\000binary");
lf[162]=C_h_intern(&lf[162],16,"open-output-pipe");
lf[163]=C_h_intern(&lf[163],16,"close-input-pipe");
lf[164]=C_h_intern(&lf[164],23,"close-input/output-pipe");
lf[165]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[166]=C_h_intern(&lf[166],14,"\003syscheck-port");
lf[167]=C_h_intern(&lf[167],17,"close-output-pipe");
lf[168]=C_h_intern(&lf[168],20,"call-with-input-pipe");
lf[169]=C_h_intern(&lf[169],21,"call-with-output-pipe");
lf[170]=C_h_intern(&lf[170],20,"with-input-from-pipe");
lf[171]=C_h_intern(&lf[171],18,"\003sysstandard-input");
lf[172]=C_h_intern(&lf[172],19,"with-output-to-pipe");
lf[173]=C_h_intern(&lf[173],19,"\003sysstandard-output");
lf[174]=C_h_intern(&lf[174],11,"create-pipe");
lf[175]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[176]=C_h_intern(&lf[176],11,"signal/term");
lf[177]=C_h_intern(&lf[177],11,"signal/kill");
lf[178]=C_h_intern(&lf[178],10,"signal/int");
lf[179]=C_h_intern(&lf[179],10,"signal/hup");
lf[180]=C_h_intern(&lf[180],10,"signal/fpe");
lf[181]=C_h_intern(&lf[181],10,"signal/ill");
lf[182]=C_h_intern(&lf[182],11,"signal/segv");
lf[183]=C_h_intern(&lf[183],11,"signal/abrt");
lf[184]=C_h_intern(&lf[184],11,"signal/trap");
lf[185]=C_h_intern(&lf[185],11,"signal/quit");
lf[186]=C_h_intern(&lf[186],11,"signal/alrm");
lf[187]=C_h_intern(&lf[187],13,"signal/vtalrm");
lf[188]=C_h_intern(&lf[188],11,"signal/prof");
lf[189]=C_h_intern(&lf[189],9,"signal/io");
lf[190]=C_h_intern(&lf[190],10,"signal/urg");
lf[191]=C_h_intern(&lf[191],11,"signal/chld");
lf[192]=C_h_intern(&lf[192],11,"signal/cont");
lf[193]=C_h_intern(&lf[193],11,"signal/stop");
lf[194]=C_h_intern(&lf[194],11,"signal/tstp");
lf[195]=C_h_intern(&lf[195],11,"signal/pipe");
lf[196]=C_h_intern(&lf[196],11,"signal/xcpu");
lf[197]=C_h_intern(&lf[197],11,"signal/xfsz");
lf[198]=C_h_intern(&lf[198],11,"signal/usr1");
lf[199]=C_h_intern(&lf[199],11,"signal/usr2");
lf[200]=C_h_intern(&lf[200],12,"signal/winch");
lf[201]=C_h_intern(&lf[201],12,"signals-list");
lf[202]=C_h_intern(&lf[202],18,"\003sysinterrupt-hook");
lf[203]=C_h_intern(&lf[203],14,"signal-handler");
lf[204]=C_h_intern(&lf[204],19,"set-signal-handler!");
lf[205]=C_h_intern(&lf[205],16,"set-signal-mask!");
lf[206]=C_h_intern(&lf[206],14,"\000process-error");
lf[207]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[208]=C_h_intern(&lf[208],11,"signal-mask");
lf[209]=C_h_intern(&lf[209],14,"signal-masked\077");
lf[210]=C_h_intern(&lf[210],12,"signal-mask!");
lf[211]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[212]=C_h_intern(&lf[212],14,"signal-unmask!");
lf[213]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[214]=C_h_intern(&lf[214],18,"system-information");
lf[215]=C_h_intern(&lf[215],25,"\003syspeek-nonnull-c-string");
lf[216]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[217]=C_h_intern(&lf[217],15,"current-user-id");
lf[218]=C_h_intern(&lf[218],25,"current-effective-user-id");
lf[219]=C_h_intern(&lf[219],16,"current-group-id");
lf[220]=C_h_intern(&lf[220],26,"current-effective-group-id");
lf[221]=C_h_intern(&lf[221],16,"user-information");
lf[222]=C_h_intern(&lf[222],6,"vector");
lf[223]=C_h_intern(&lf[223],4,"list");
lf[224]=C_h_intern(&lf[224],27,"current-effective-user-name");
lf[225]=C_h_intern(&lf[225],17,"group-information");
lf[227]=C_h_intern(&lf[227],10,"get-groups");
lf[228]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[229]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[230]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[231]=C_h_intern(&lf[231],11,"set-groups!");
lf[232]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[234]=C_h_intern(&lf[234],17,"initialize-groups");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[236]=C_h_intern(&lf[236],10,"errno/perm");
lf[237]=C_h_intern(&lf[237],11,"errno/noent");
lf[238]=C_h_intern(&lf[238],10,"errno/srch");
lf[239]=C_h_intern(&lf[239],10,"errno/intr");
lf[240]=C_h_intern(&lf[240],8,"errno/io");
lf[241]=C_h_intern(&lf[241],12,"errno/noexec");
lf[242]=C_h_intern(&lf[242],10,"errno/badf");
lf[243]=C_h_intern(&lf[243],11,"errno/child");
lf[244]=C_h_intern(&lf[244],11,"errno/nomem");
lf[245]=C_h_intern(&lf[245],11,"errno/acces");
lf[246]=C_h_intern(&lf[246],11,"errno/fault");
lf[247]=C_h_intern(&lf[247],10,"errno/busy");
lf[248]=C_h_intern(&lf[248],12,"errno/notdir");
lf[249]=C_h_intern(&lf[249],11,"errno/isdir");
lf[250]=C_h_intern(&lf[250],11,"errno/inval");
lf[251]=C_h_intern(&lf[251],11,"errno/mfile");
lf[252]=C_h_intern(&lf[252],11,"errno/nospc");
lf[253]=C_h_intern(&lf[253],11,"errno/spipe");
lf[254]=C_h_intern(&lf[254],10,"errno/pipe");
lf[255]=C_h_intern(&lf[255],11,"errno/again");
lf[256]=C_h_intern(&lf[256],10,"errno/rofs");
lf[257]=C_h_intern(&lf[257],11,"errno/exist");
lf[258]=C_h_intern(&lf[258],16,"errno/wouldblock");
lf[259]=C_h_intern(&lf[259],10,"errno/2big");
lf[260]=C_h_intern(&lf[260],12,"errno/deadlk");
lf[261]=C_h_intern(&lf[261],9,"errno/dom");
lf[262]=C_h_intern(&lf[262],10,"errno/fbig");
lf[263]=C_h_intern(&lf[263],11,"errno/ilseq");
lf[264]=C_h_intern(&lf[264],11,"errno/mlink");
lf[265]=C_h_intern(&lf[265],17,"errno/nametoolong");
lf[266]=C_h_intern(&lf[266],11,"errno/nfile");
lf[267]=C_h_intern(&lf[267],11,"errno/nodev");
lf[268]=C_h_intern(&lf[268],11,"errno/nolck");
lf[269]=C_h_intern(&lf[269],11,"errno/nosys");
lf[270]=C_h_intern(&lf[270],14,"errno/notempty");
lf[271]=C_h_intern(&lf[271],11,"errno/notty");
lf[272]=C_h_intern(&lf[272],10,"errno/nxio");
lf[273]=C_h_intern(&lf[273],11,"errno/range");
lf[274]=C_h_intern(&lf[274],10,"errno/xdev");
lf[275]=C_h_intern(&lf[275],16,"change-file-mode");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[277]=C_h_intern(&lf[277],17,"change-file-owner");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[279]=C_h_intern(&lf[279],17,"file-read-access\077");
lf[280]=C_h_intern(&lf[280],18,"file-write-access\077");
lf[281]=C_h_intern(&lf[281],20,"file-execute-access\077");
lf[282]=C_h_intern(&lf[282],14,"create-session");
lf[283]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[284]=C_h_intern(&lf[284],16,"process-group-id");
lf[285]=C_h_intern(&lf[285],20,"create-symbolic-link");
lf[286]=C_h_intern(&lf[286],18,"create-symbol-link");
lf[287]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[288]=C_h_intern(&lf[288],9,"substring");
lf[289]=C_h_intern(&lf[289],18,"read-symbolic-link");
lf[290]=C_h_intern(&lf[290],12,"canonicalize");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[292]=C_h_intern(&lf[292],9,"file-link");
lf[293]=C_h_intern(&lf[293],9,"hard-link");
lf[294]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[295]=C_h_intern(&lf[295],12,"fileno/stdin");
lf[296]=C_h_intern(&lf[296],13,"fileno/stdout");
lf[297]=C_h_intern(&lf[297],13,"fileno/stderr");
lf[298]=C_h_intern(&lf[298],7,"\000append");
lf[299]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[303]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[305]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[306]=C_h_intern(&lf[306],16,"open-input-file*");
lf[307]=C_h_intern(&lf[307],17,"open-output-file*");
lf[308]=C_h_intern(&lf[308],12,"port->fileno");
lf[309]=C_h_intern(&lf[309],6,"socket");
lf[310]=C_h_intern(&lf[310],20,"\003systcp-port->fileno");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[312]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[313]=C_h_intern(&lf[313],25,"\003syspeek-unsigned-integer");
lf[314]=C_h_intern(&lf[314],16,"duplicate-fileno");
lf[315]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[316]=C_h_intern(&lf[316],15,"make-input-port");
lf[317]=C_h_intern(&lf[317],14,"set-port-name!");
lf[318]=C_h_intern(&lf[318],21,"\003syscustom-input-port");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[320]=C_h_intern(&lf[320],17,"\003systhread-yield!");
lf[321]=C_h_intern(&lf[321],25,"\003systhread-block-for-i/o!");
lf[322]=C_h_intern(&lf[322],18,"\003syscurrent-thread");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[327]=C_h_intern(&lf[327],17,"\003sysstring-append");
lf[328]=C_h_intern(&lf[328],15,"\003sysmake-string");
lf[329]=C_h_intern(&lf[329],20,"\003sysscan-buffer-line");
lf[330]=C_h_intern(&lf[330],4,"noop");
lf[331]=C_h_intern(&lf[331],16,"make-output-port");
lf[332]=C_h_intern(&lf[332],22,"\003syscustom-output-port");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[334]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[335]=C_h_intern(&lf[335],13,"file-truncate");
lf[336]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[337]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[338]=C_h_intern(&lf[338],4,"lock");
lf[339]=C_h_intern(&lf[339],9,"file-lock");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[341]=C_h_intern(&lf[341],18,"file-lock/blocking");
lf[342]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[343]=C_h_intern(&lf[343],14,"file-test-lock");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[345]=C_h_intern(&lf[345],11,"file-unlock");
lf[346]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[347]=C_h_intern(&lf[347],11,"create-fifo");
lf[348]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[350]=C_h_intern(&lf[350],6,"setenv");
lf[351]=C_h_intern(&lf[351],8,"unsetenv");
lf[352]=C_h_intern(&lf[352],25,"get-environment-variables");
lf[353]=C_h_intern(&lf[353],19,"current-environment");
lf[354]=C_h_intern(&lf[354],9,"prot/read");
lf[355]=C_h_intern(&lf[355],10,"prot/write");
lf[356]=C_h_intern(&lf[356],9,"prot/exec");
lf[357]=C_h_intern(&lf[357],9,"prot/none");
lf[358]=C_h_intern(&lf[358],9,"map/fixed");
lf[359]=C_h_intern(&lf[359],10,"map/shared");
lf[360]=C_h_intern(&lf[360],11,"map/private");
lf[361]=C_h_intern(&lf[361],13,"map/anonymous");
lf[362]=C_h_intern(&lf[362],8,"map/file");
lf[363]=C_h_intern(&lf[363],18,"map-file-to-memory");
lf[364]=C_h_intern(&lf[364],4,"mmap");
lf[365]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[366]=C_h_intern(&lf[366],20,"\003syspointer->address");
lf[367]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[368]=C_h_intern(&lf[368],16,"\003sysnull-pointer");
lf[369]=C_h_intern(&lf[369],22,"unmap-file-from-memory");
lf[370]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[371]=C_h_intern(&lf[371],26,"memory-mapped-file-pointer");
lf[372]=C_h_intern(&lf[372],19,"memory-mapped-file\077");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[375]=C_h_intern(&lf[375],19,"seconds->local-time");
lf[376]=C_h_intern(&lf[376],18,"\003sysdecode-seconds");
lf[377]=C_h_intern(&lf[377],17,"seconds->utc-time");
lf[378]=C_h_intern(&lf[378],15,"seconds->string");
lf[379]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[380]=C_h_intern(&lf[380],12,"time->string");
lf[381]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[382]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[383]=C_h_intern(&lf[383],12,"string->time");
lf[384]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[385]=C_h_intern(&lf[385],19,"local-time->seconds");
lf[386]=C_h_intern(&lf[386],15,"\003syscons-flonum");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[388]=C_h_intern(&lf[388],17,"utc-time->seconds");
lf[389]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[390]=C_h_intern(&lf[390],27,"local-timezone-abbreviation");
lf[391]=C_h_intern(&lf[391],5,"_exit");
lf[392]=C_h_intern(&lf[392],10,"set-alarm!");
lf[393]=C_h_intern(&lf[393],19,"set-buffering-mode!");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[395]=C_h_intern(&lf[395],5,"\000full");
lf[396]=C_h_intern(&lf[396],5,"\000line");
lf[397]=C_h_intern(&lf[397],5,"\000none");
lf[398]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[399]=C_h_intern(&lf[399],14,"terminal-port\077");
lf[401]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[402]=C_h_intern(&lf[402],13,"terminal-name");
lf[403]=C_h_intern(&lf[403],13,"terminal-size");
lf[404]=C_h_intern(&lf[404],6,"\000error");
lf[405]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[406]=C_h_intern(&lf[406],17,"\003sysmake-locative");
lf[407]=C_h_intern(&lf[407],8,"location");
lf[408]=C_h_intern(&lf[408],13,"get-host-name");
lf[409]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[410]=C_h_intern(&lf[410],6,"regexp");
lf[411]=C_h_intern(&lf[411],12,"string-match");
lf[412]=C_h_intern(&lf[412],12,"glob->regexp");
lf[413]=C_h_intern(&lf[413],13,"make-pathname");
lf[414]=C_h_intern(&lf[414],18,"decompose-pathname");
lf[415]=C_h_intern(&lf[415],4,"glob");
lf[416]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[418]=C_h_intern(&lf[418],12,"process-fork");
lf[419]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[420]=C_h_intern(&lf[420],24,"pathname-strip-directory");
lf[421]=C_h_intern(&lf[421],15,"process-execute");
lf[422]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[423]=C_h_intern(&lf[423],16,"\003sysprocess-wait");
lf[424]=C_h_intern(&lf[424],12,"process-wait");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[426]=C_h_intern(&lf[426],18,"current-process-id");
lf[427]=C_h_intern(&lf[427],17,"parent-process-id");
lf[428]=C_h_intern(&lf[428],5,"sleep");
lf[429]=C_h_intern(&lf[429],14,"process-signal");
lf[430]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[431]=C_h_intern(&lf[431],17,"\003sysshell-command");
lf[432]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[433]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[434]=C_h_intern(&lf[434],27,"\003sysshell-command-arguments");
lf[435]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[436]=C_h_intern(&lf[436],11,"process-run");
lf[437]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[438]=C_h_intern(&lf[438],11,"\003sysprocess");
lf[439]=C_h_intern(&lf[439],7,"process");
lf[440]=C_h_intern(&lf[440],8,"process*");
lf[441]=C_h_intern(&lf[441],10,"find-files");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[443]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[445]=C_h_intern(&lf[445],16,"\003sysdynamic-wind");
lf[446]=C_h_intern(&lf[446],13,"pathname-file");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[448]=C_h_intern(&lf[448],7,"regexp\077");
lf[449]=C_h_intern(&lf[449],19,"set-root-directory!");
lf[450]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[451]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[452]=C_h_intern(&lf[452],21,"set-process-group-id!");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[454]=C_h_intern(&lf[454],18,"getter-with-setter");
lf[455]=C_h_intern(&lf[455],26,"effective-group-id!-setter");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[457]=C_h_intern(&lf[457],12,"set-user-id!");
lf[458]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[459]=C_h_intern(&lf[459],25,"effective-user-id!-setter");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[462]=C_h_intern(&lf[462],23,"\003sysuser-interrupt-hook");
lf[463]=C_h_intern(&lf[463],11,"make-vector");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[465]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[466]=C_h_intern(&lf[466],17,"register-feature!");
lf[467]=C_h_intern(&lf[467],5,"posix");
C_register_lf2(lf,468,create_ptable());
t2=C_mutate(&lf[0] /* (set! c150 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3455,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k3453 */
static void C_ccall f_3455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3455,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3458,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3456 in k3453 */
static void C_ccall f_3458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3458,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3461,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3459 in k3456 in k3453 */
static void C_ccall f_3461(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3461,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3464,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3464,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3467,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3467,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3470,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3470,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3473,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 501  register-feature! */
((C_proc3)C_retrieve_proc(*((C_word*)lf[466]+1)))(3,*((C_word*)lf[466]+1),t2,lf[467]);}

/* k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word ab[110],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3473,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3485,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[8]+1 /* (set! posix-error ...) */,lf[3]);
t5=C_mutate((C_word*)lf[9]+1 /* (set! file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3503,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[10]+1 /* (set! file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3510,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[11]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[12]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[13]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[14]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[15]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[16]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[17]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[18]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[19]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[20]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[21]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[22]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[23]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[24]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[25]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[26]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[27]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[28]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[29]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[30]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[31]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[32]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[33]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[34]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[35]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[36]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[37]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[38]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[39]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[40]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[41]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[42]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[43]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[44]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[45]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[46]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[47]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3567,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[51]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3613,a[2]=t45,a[3]=((C_word)li4),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[55]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3651,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t48=*((C_word*)lf[57]+1);
t49=C_mutate((C_word*)lf[58]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3666,a[2]=t48,a[3]=((C_word)li6),tmp=(C_word)a,a+=4,tmp));
t50=C_mutate((C_word*)lf[62]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3708,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[65]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3747,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3779,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp);
t53=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3785,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp);
t54=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3795,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp);
t55=C_mutate((C_word*)lf[68]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3805,a[2]=t53,a[3]=t54,a[4]=t52,a[5]=((C_word)li16),tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[71]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[72]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[73]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[74] /* (set! stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3997,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[77]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4034,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[78]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4066,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[79]+1 /* (set! file-modification-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4072,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[80]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4078,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[81]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4084,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[82]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4090,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[83]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4096,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[84]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4102,a[2]=((C_word)li25),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[85]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4111,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[86]+1 /* (set! stat-regular? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4120,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[87]+1 /* (set! stat-directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4129,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[88]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4138,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[89]+1 /* (set! stat-char-device? ...) */,*((C_word*)lf[88]+1));
t73=C_mutate((C_word*)lf[90]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4148,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[91]+1 /* (set! stat-block-device? ...) */,*((C_word*)lf[90]+1));
t75=C_mutate((C_word*)lf[92]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4158,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[93]+1 /* (set! stat-fifo? ...) */,*((C_word*)lf[92]+1));
t77=C_mutate((C_word*)lf[94]+1 /* (set! stat-symlink? ...) */,*((C_word*)lf[85]+1));
t78=C_mutate((C_word*)lf[95]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4169,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[96]+1 /* (set! stat-socket? ...) */,*((C_word*)lf[95]+1));
t80=C_mutate((C_word*)lf[97]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4179,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t81=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4239,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t82=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9373,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 845  getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t81,t82,*((C_word*)lf[97]+1));}

/* a9372 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9373(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9373,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9377,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9389,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 847  port? */
t5=*((C_word*)lf[101]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k9387 in a9372 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[99]);
t4=((C_word*)t0)[2];
f_9377(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_9377(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 852  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[60],lf[104],lf[465],((C_word*)t0)[3]);}}}

/* k9375 in a9372 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9377(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9377,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9380,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 854  posix-error */
t3=lf[3];
f_3485(6,t3,t2,lf[48],lf[104],lf[464],((C_word*)t0)[2]);}
else{
t3=t2;
f_9380(2,t3,C_SCHEME_UNDEFINED);}}

/* k9378 in k9375 in a9372 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word ab[171],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4239,2,t0,t1);}
t2=C_mutate((C_word*)lf[104]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[105]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4241,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[114]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4343,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[116]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4367,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t6=*((C_word*)lf[118]+1);
t7=*((C_word*)lf[57]+1);
t8=*((C_word*)lf[119]+1);
t9=C_mutate((C_word*)lf[120]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4391,a[2]=t7,a[3]=t6,a[4]=((C_word)li42),tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[124]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4548,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp));
t11=*((C_word*)lf[57]+1);
t12=C_mutate((C_word*)lf[123]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4571,a[2]=t11,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp));
t13=*((C_word*)lf[127]+1);
t14=*((C_word*)lf[128]+1);
t15=*((C_word*)lf[129]+1);
t16=*((C_word*)lf[130]+1);
t17=*((C_word*)lf[118]+1);
t18=*((C_word*)lf[2]+1);
t19=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4619,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4624,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp);
t21=*((C_word*)lf[133]+1);
t22=*((C_word*)lf[134]+1);
t23=*((C_word*)lf[123]+1);
t24=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4635,a[2]=t23,a[3]=((C_word)li54),tmp=(C_word)a,a+=4,tmp);
t25=C_mutate((C_word*)lf[139]+1 /* (set! canonical-path ...) */,(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4691,a[2]=t16,a[3]=t14,a[4]=t21,a[5]=t22,a[6]=t24,a[7]=t15,a[8]=t13,a[9]=t17,a[10]=t19,a[11]=t18,a[12]=t20,a[13]=((C_word)li56),tmp=(C_word)a,a+=14,tmp));
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5008,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5020,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5026,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp);
t29=C_mutate((C_word*)lf[160]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5041,a[2]=t27,a[3]=t28,a[4]=t26,a[5]=((C_word)li60),tmp=(C_word)a,a+=6,tmp));
t30=C_mutate((C_word*)lf[162]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5077,a[2]=t27,a[3]=t28,a[4]=t26,a[5]=((C_word)li61),tmp=(C_word)a,a+=6,tmp));
t31=C_mutate((C_word*)lf[163]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5113,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[167]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[163]+1));
t33=*((C_word*)lf[160]+1);
t34=*((C_word*)lf[162]+1);
t35=*((C_word*)lf[163]+1);
t36=*((C_word*)lf[167]+1);
t37=C_mutate((C_word*)lf[168]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5129,a[2]=t33,a[3]=t35,a[4]=((C_word)li65),tmp=(C_word)a,a+=5,tmp));
t38=C_mutate((C_word*)lf[169]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5153,a[2]=t34,a[3]=t36,a[4]=((C_word)li68),tmp=(C_word)a,a+=5,tmp));
t39=C_mutate((C_word*)lf[170]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5177,a[2]=t33,a[3]=t35,a[4]=((C_word)li70),tmp=(C_word)a,a+=5,tmp));
t40=C_mutate((C_word*)lf[172]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5197,a[2]=t34,a[3]=t36,a[4]=((C_word)li72),tmp=(C_word)a,a+=5,tmp));
t41=C_mutate((C_word*)lf[174]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5217,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[176]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t43=C_mutate((C_word*)lf[177]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t44=C_mutate((C_word*)lf[178]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t45=C_mutate((C_word*)lf[179]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t46=C_mutate((C_word*)lf[180]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t47=C_mutate((C_word*)lf[181]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t48=C_mutate((C_word*)lf[182]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t49=C_mutate((C_word*)lf[183]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t50=C_mutate((C_word*)lf[184]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t51=C_mutate((C_word*)lf[185]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t52=C_mutate((C_word*)lf[186]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t53=C_mutate((C_word*)lf[187]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t54=C_mutate((C_word*)lf[188]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t55=C_mutate((C_word*)lf[189]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t56=C_mutate((C_word*)lf[190]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t57=C_mutate((C_word*)lf[191]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t58=C_mutate((C_word*)lf[192]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t59=C_mutate((C_word*)lf[193]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t60=C_mutate((C_word*)lf[194]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t61=C_mutate((C_word*)lf[195]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t62=C_mutate((C_word*)lf[196]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t63=C_mutate((C_word*)lf[197]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t64=C_mutate((C_word*)lf[198]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t65=C_mutate((C_word*)lf[199]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t66=C_mutate((C_word*)lf[200]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t67=(C_word)C_a_i_list(&a,25,*((C_word*)lf[176]+1),*((C_word*)lf[177]+1),*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1));
t68=C_mutate((C_word*)lf[201]+1 /* (set! signals-list ...) */,t67);
t69=*((C_word*)lf[202]+1);
t70=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5262,a[2]=((C_word*)t0)[2],a[3]=t69,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1175 make-vector */
t71=*((C_word*)lf[463]+1);
((C_proc4)(void*)(*((C_word*)t71+1)))(4,t71,t70,C_fix(256),C_SCHEME_FALSE);}

/* k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5262,2,t0,t1);}
t2=C_mutate((C_word*)lf[203]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5264,a[2]=t1,a[3]=((C_word)li74),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[204]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5273,a[2]=t1,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[202]+1 /* (set! interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5286,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li76),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[205]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5304,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[208]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5328,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[209]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5360,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[210]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5366,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[212]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5381,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5397,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9367,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1231 set-signal-handler! */
((C_proc4)C_retrieve_proc(*((C_word*)lf[204]+1)))(4,*((C_word*)lf[204]+1),t10,*((C_word*)lf[178]+1),t11);}

/* a9366 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9367(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9367,3,t0,t1,t2);}
/* posixunix.scm: 1233 ##sys#user-interrupt-hook */
((C_proc2)C_retrieve_proc(*((C_word*)lf[462]+1)))(2,*((C_word*)lf[462]+1),t1);}

/* k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5397,2,t0,t1);}
t2=C_mutate((C_word*)lf[214]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5399,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5439,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9349,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9352,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1257 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t3,t4,t5);}

/* a9351 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9352(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9352,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9362,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1261 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9360 in a9351 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1262 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[457],lf[461],((C_word*)t0)[2]);}

/* a9348 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9349,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1107(C_SCHEME_UNDEFINED));}

/* k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5439,2,t0,t1);}
t2=C_mutate((C_word*)lf[217]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5443,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9331,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9334,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1265 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t3,t4,t5);}

/* a9333 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9334(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9334,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9344,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1269 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9342 in a9333 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9344(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1270 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[459],lf[460],((C_word*)t0)[2]);}

/* a9330 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9331,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1116(C_SCHEME_UNDEFINED));}

/* k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5443(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5443,2,t0,t1);}
t2=C_mutate((C_word*)lf[218]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5447,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9313,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9316,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1274 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t3,t4,t5);}

/* a9315 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9316(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9316,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9326,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1278 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9324 in a9315 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9326(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1279 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[457],lf[458],((C_word*)t0)[2]);}

/* a9312 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9313(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9313,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1125(C_SCHEME_UNDEFINED));}

/* k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5447,2,t0,t1);}
t2=C_mutate((C_word*)lf[219]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5451,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9295,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9298,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1282 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t3,t4,t5);}

/* a9297 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9298(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9298,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9308,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1286 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9306 in a9297 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1287 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[455],lf[456],((C_word*)t0)[2]);}

/* a9294 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9295,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1134(C_SCHEME_UNDEFINED));}

/* k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[57],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5451,2,t0,t1);}
t2=C_mutate((C_word*)lf[220]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[221]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5453,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[134]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5520,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[224]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5534,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[225]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5559,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate(&lf[226] /* (set! _ensure-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5645,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[227]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5652,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[231]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5715,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[234]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5789,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[236]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[237]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[238]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[239]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[240]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[241]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[242]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[243]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[244]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[245]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[246]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[247]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[248]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[249]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[250]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[251]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[252]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[253]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[254]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[255]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[256]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[257]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[258]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[259] /* errno/2big */,0,C_fix(0));
t35=C_set_block_item(lf[260] /* errno/deadlk */,0,C_fix(0));
t36=C_set_block_item(lf[261] /* errno/dom */,0,C_fix(0));
t37=C_set_block_item(lf[262] /* errno/fbig */,0,C_fix(0));
t38=C_set_block_item(lf[263] /* errno/ilseq */,0,C_fix(0));
t39=C_set_block_item(lf[264] /* errno/mlink */,0,C_fix(0));
t40=C_set_block_item(lf[265] /* errno/nametoolong */,0,C_fix(0));
t41=C_set_block_item(lf[266] /* errno/nfile */,0,C_fix(0));
t42=C_set_block_item(lf[267] /* errno/nodev */,0,C_fix(0));
t43=C_set_block_item(lf[268] /* errno/nolck */,0,C_fix(0));
t44=C_set_block_item(lf[269] /* errno/nosys */,0,C_fix(0));
t45=C_set_block_item(lf[270] /* errno/notempty */,0,C_fix(0));
t46=C_set_block_item(lf[271] /* errno/notty */,0,C_fix(0));
t47=C_set_block_item(lf[272] /* errno/nxio */,0,C_fix(0));
t48=C_set_block_item(lf[273] /* errno/range */,0,C_fix(0));
t49=C_set_block_item(lf[274] /* errno/xdev */,0,C_fix(0));
t50=C_mutate((C_word*)lf[275]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5853,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[277]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5880,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5910,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[279]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5934,a[2]=t52,a[3]=((C_word)li99),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[280]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5940,a[2]=t52,a[3]=((C_word)li100),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[281]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5946,a[2]=t52,a[3]=((C_word)li101),tmp=(C_word)a,a+=4,tmp));
t56=C_mutate((C_word*)lf[282]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5952,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5969,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9256,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9274,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1502 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[454]+1)))(4,*((C_word*)lf[454]+1),t57,t58,t59);}

/* a9273 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9274(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_9274,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[452]);
t5=(C_word)C_i_check_exact_2(t3,lf[452]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9290,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1514 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k9288 in a9273 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1515 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[452],lf[453],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a9255 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9256(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9256,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[284]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9263,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9269,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1507 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_9263(2,t6,C_SCHEME_UNDEFINED);}}

/* k9267 in a9255 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1508 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[284],lf[451],((C_word*)t0)[2]);}

/* k9261 in a9255 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5969,2,t0,t1);}
t2=C_mutate((C_word*)lf[284]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[285]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5971,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t4=*((C_word*)lf[288]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6008,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1535 make-string */
t7=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word ab[261],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6008,2,t0,t1);}
t2=C_mutate((C_word*)lf[289]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6009,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[292]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6093,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[295]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[296]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[297]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6118,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6155,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[306]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6170,a[2]=t7,a[3]=t8,a[4]=((C_word)li108),tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[307]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6184,a[2]=t7,a[3]=t8,a[4]=((C_word)li109),tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[308]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6198,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[314]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6243,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[316]+1);
t14=*((C_word*)lf[317]+1);
t15=C_mutate((C_word*)lf[318]+1 /* (set! custom-input-port ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6270,a[2]=t13,a[3]=t14,a[4]=((C_word)li131),tmp=(C_word)a,a+=5,tmp));
t16=*((C_word*)lf[331]+1);
t17=*((C_word*)lf[317]+1);
t18=C_mutate((C_word*)lf[332]+1 /* (set! custom-output-port ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6752,a[2]=t16,a[3]=t17,a[4]=((C_word)li143),tmp=(C_word)a,a+=5,tmp));
t19=C_mutate((C_word*)lf[335]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7011,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7050,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7124,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp);
t22=C_mutate((C_word*)lf[339]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7142,a[2]=t20,a[3]=t21,a[4]=((C_word)li147),tmp=(C_word)a,a+=5,tmp));
t23=C_mutate((C_word*)lf[341]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7157,a[2]=t20,a[3]=t21,a[4]=((C_word)li148),tmp=(C_word)a,a+=5,tmp));
t24=C_mutate((C_word*)lf[343]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7172,a[2]=t20,a[3]=t21,a[4]=((C_word)li149),tmp=(C_word)a,a+=5,tmp));
t25=C_mutate((C_word*)lf[345]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7194,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[347]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7222,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[92]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7265,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[350]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7291,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[351]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7308,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[352]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7328,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[353]+1 /* (set! current-environment ...) */,*((C_word*)lf[352]+1));
t32=C_mutate((C_word*)lf[354]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t33=C_mutate((C_word*)lf[355]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t34=C_mutate((C_word*)lf[356]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t35=C_mutate((C_word*)lf[357]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t36=C_mutate((C_word*)lf[358]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t37=C_mutate((C_word*)lf[359]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t38=C_mutate((C_word*)lf[360]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t39=C_mutate((C_word*)lf[361]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t40=C_mutate((C_word*)lf[362]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t41=C_mutate((C_word*)lf[363]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7432,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[369]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7494,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[371]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7529,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[372]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7538,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate(&lf[373] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7544,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[375]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7563,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[377]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7572,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[378]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7591,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[380]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7627,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[383]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7696,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[385]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7742,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[388]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7757,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[390]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7772,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[391]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7784,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[392]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7800,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[393]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7807,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[399]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7866,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate(&lf[400] /* (set! terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7885,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[402]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7917,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[403]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7940,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[408]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7975,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t62=*((C_word*)lf[410]+1);
t63=*((C_word*)lf[411]+1);
t64=*((C_word*)lf[412]+1);
t65=*((C_word*)lf[120]+1);
t66=*((C_word*)lf[413]+1);
t67=*((C_word*)lf[414]+1);
t68=C_mutate((C_word*)lf[415]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7987,a[2]=t64,a[3]=t62,a[4]=t65,a[5]=t63,a[6]=t66,a[7]=t67,a[8]=((C_word)li183),tmp=(C_word)a,a+=9,tmp));
t69=C_mutate((C_word*)lf[418]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8096,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t70=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8138,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp);
t71=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8157,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp);
t72=*((C_word*)lf[420]+1);
t73=C_mutate((C_word*)lf[421]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8176,a[2]=t72,a[3]=t71,a[4]=t70,a[5]=((C_word)li193),tmp=(C_word)a,a+=6,tmp));
t74=C_mutate((C_word*)lf[423]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8358,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[424]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8375,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[426]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8453,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[427]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8456,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[428]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8459,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[429]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8466,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t80=C_mutate((C_word*)lf[431]+1 /* (set! shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8493,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t81=C_mutate((C_word*)lf[434]+1 /* (set! shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8502,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t82=*((C_word*)lf[418]+1);
t83=*((C_word*)lf[421]+1);
t84=C_mutate((C_word*)lf[436]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8508,a[2]=t82,a[3]=t83,a[4]=((C_word)li204),tmp=(C_word)a,a+=5,tmp));
t85=*((C_word*)lf[174]+1);
t86=*((C_word*)lf[424]+1);
t87=*((C_word*)lf[418]+1);
t88=*((C_word*)lf[421]+1);
t89=*((C_word*)lf[314]+1);
t90=*((C_word*)lf[55]+1);
t91=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8564,a[2]=t86,a[3]=((C_word)li208),tmp=(C_word)a,a+=4,tmp);
t92=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8601,a[2]=t85,a[3]=((C_word)li211),tmp=(C_word)a,a+=4,tmp);
t93=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8621,a[2]=t90,a[3]=((C_word)li212),tmp=(C_word)a,a+=4,tmp);
t94=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8635,a[2]=t90,a[3]=((C_word)li213),tmp=(C_word)a,a+=4,tmp);
t95=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8652,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp);
t96=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8668,a[2]=t92,a[3]=t87,a[4]=t94,a[5]=t88,a[6]=t95,a[7]=((C_word)li216),tmp=(C_word)a,a+=8,tmp);
t97=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8713,a[2]=t93,a[3]=((C_word)li217),tmp=(C_word)a,a+=4,tmp);
t98=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8724,a[2]=t93,a[3]=((C_word)li218),tmp=(C_word)a,a+=4,tmp);
t99=C_mutate((C_word*)lf[438]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8735,a[2]=t98,a[3]=t91,a[4]=t97,a[5]=t96,a[6]=((C_word)li221),tmp=(C_word)a,a+=7,tmp));
t100=C_set_block_item(lf[439] /* process */,0,C_SCHEME_UNDEFINED);
t101=C_set_block_item(lf[440] /* process* */,0,C_SCHEME_UNDEFINED);
t102=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8793,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp);
t103=C_mutate((C_word*)lf[439]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8854,a[2]=t102,a[3]=((C_word)li230),tmp=(C_word)a,a+=4,tmp));
t104=C_mutate((C_word*)lf[440]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8914,a[2]=t102,a[3]=((C_word)li234),tmp=(C_word)a,a+=4,tmp));
t105=*((C_word*)lf[415]+1);
t106=*((C_word*)lf[411]+1);
t107=*((C_word*)lf[413]+1);
t108=*((C_word*)lf[124]+1);
t109=C_mutate((C_word*)lf[441]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8974,a[2]=t108,a[3]=t107,a[4]=t105,a[5]=t106,a[6]=((C_word)li247),tmp=(C_word)a,a+=7,tmp));
t110=C_mutate((C_word*)lf[449]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9233,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t111=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t111+1)))(2,t111,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9233(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9233,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[449]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9225,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=(C_word)C_i_foreign_string_argumentp(t4);
/* ##sys#make-c-string */
t7=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}
else{
t6=t5;
f_9225(2,t6,C_SCHEME_FALSE);}}

/* k9223 in set-root-directory! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9225(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub3185(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2399 posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[449],lf[450],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_8974r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_8974r(t0,t1,t2,t3,t4);}}

static void C_ccall f_8974r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8976,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=((C_word)li242),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9141,a[2]=t5,a[3]=((C_word)li243),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9146,a[2]=t6,a[3]=((C_word)li244),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9151,a[2]=t7,a[3]=((C_word)li246),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action30753166 */
t9=t8;
f_9151(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id30763162 */
t11=t7;
f_9146(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit30773157 */
t13=t6;
f_9141(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body30733083 */
t15=t5;
f_8976(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action3075 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_9151(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_9151,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9157,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp);
/* def-id30763162 */
t3=((C_word*)t0)[2];
f_9146(t3,t1,t2);}

/* a9156 in def-action3075 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_9157,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id3076 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_9146(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_9146,NULL,3,t0,t1,t2);}
/* def-limit30773157 */
t3=((C_word*)t0)[2];
f_9141(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit3077 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_9141(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_9141,NULL,4,t0,t1,t2,t3);}
/* body30733083 */
t4=((C_word*)t0)[2];
f_8976(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8976(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8976,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[441]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8983,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t2,a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_8983(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9136,a[2]=t4,a[3]=t7,a[4]=((C_word)li240),tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_8983(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_9128,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp));}}

/* f_9128 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9128(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9128,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_9136 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9136(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9136,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8983(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8983,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_9116,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
if(C_truep(t2)){
t4=t3;
f_9116(2,t4,t2);}
else{
/* posixunix.scm: 2371 regexp? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[448]+1)))(3,*((C_word*)lf[448]+1),t3,((C_word*)t0)[11]);}}

/* k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9116(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9116,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9117,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[12],a[4]=((C_word)li235),tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8993,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t2,a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9110,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2374 make-pathname */
t5=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],lf[447]);}

/* k9108 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2374 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8993,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8995,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=((C_word)li239),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_8995(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8995(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8995,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_9014,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2380 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9014,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_9090,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2381 pathname-file */
t3=*((C_word*)lf[446]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_9096,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2388 pproc */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[6]);}}

/* k9094 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9096,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9103,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2388 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2389 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_8995(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k9101 in k9094 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9103(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2388 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9090,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[442]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[443]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2381 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_8995(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_9029,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 2382 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[6]);}}

/* k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[31],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9029,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9039,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_9041,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,a[5]=((C_word)li236),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_9046,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word)li237),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_9070,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,a[5]=((C_word)li238),tmp=(C_word)a,a+=6,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[445]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9080,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_9083,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2387 pproc */
t4=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[6]);}}

/* k9081 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2387 action */
t2=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_9080(2,t2,((C_word*)t0)[2]);}}

/* k9078 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a9069 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9070,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a9045 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9046,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_9054,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9068,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2385 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[6],lf[444]);}

/* k9066 in a9045 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k9052 in a9045 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9054,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9058,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_9061,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2386 pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k9059 in k9052 in a9045 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2386 action */
t2=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_9058(2,t2,((C_word*)t0)[2]);}}

/* k9056 in k9052 in a9045 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a9040 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9041,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k9037 in k9027 in k9088 in k9012 in loop in k8991 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2383 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_9117 in k9114 in k8981 in body3073 in find-files in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9117(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9117,3,t0,t1,t2);}
/* posixunix.scm: 2372 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8914(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_8914r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8914r(t0,t1,t2,t3);}}

static void C_ccall f_8914r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8916,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li231),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8921,a[2]=t4,a[3]=((C_word)li232),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8926,a[2]=t5,a[3]=((C_word)li233),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args30283044 */
t7=t6;
f_8926(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env30293040 */
t9=t5;
f_8921(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body30263035 */
t11=t4;
f_8916(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args3028 in process* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8926(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8926,NULL,2,t0,t1);}
/* def-env30293040 */
t2=((C_word*)t0)[2];
f_8921(t2,t1,C_SCHEME_FALSE);}

/* def-env3029 in process* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8921(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8921,NULL,3,t0,t1,t2);}
/* body30263035 */
t3=((C_word*)t0)[2];
f_8916(t3,t1,t2,C_SCHEME_FALSE);}

/* body3026 in process* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8916(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8916,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2349 %process */
f_8793(t1,lf[440],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8854(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_8854r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8854r(t0,t1,t2,t3);}}

static void C_ccall f_8854r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8856,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li227),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8861,a[2]=t4,a[3]=((C_word)li228),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8866,a[2]=t5,a[3]=((C_word)li229),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args29843000 */
t7=t6;
f_8866(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env29852996 */
t9=t5;
f_8861(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body29822991 */
t11=t4;
f_8856(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args2984 in process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8866(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8866,NULL,2,t0,t1);}
/* def-env29852996 */
t2=((C_word*)t0)[2];
f_8861(t2,t1,C_SCHEME_FALSE);}

/* def-env2985 in process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8861(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8861,NULL,3,t0,t1,t2);}
/* body29822991 */
t3=((C_word*)t0)[2];
f_8856(t3,t1,t2,C_SCHEME_FALSE);}

/* body2982 in process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8856(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8856,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2346 %process */
f_8793(t1,lf[439],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8793(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8793,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8795,a[2]=t2,a[3]=((C_word)li223),tmp=(C_word)a,a+=4,tmp);
t10=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8814,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm: 2335 chkstrlst */
t12=t9;
f_8795(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8848,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2337 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[434]+1)))(3,*((C_word*)lf[434]+1),t12,((C_word*)t7)[1]);}}

/* k8846 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8848,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8852,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2338 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[431]+1)))(2,*((C_word*)lf[431]+1),t3);}

/* k8850 in k8846 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_8814(2,t3,t2);}

/* k8812 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8814,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8817,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2339 chkstrlst */
t3=((C_word*)t0)[2];
f_8795(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_8817(2,t3,C_SCHEME_UNDEFINED);}}

/* k8815 in k8812 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8817,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8822,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li224),tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8828,a[2]=((C_word*)t0)[3],a[3]=((C_word)li225),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a8827 in k8815 in k8812 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8828,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2342 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2343 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a8821 in k8815 in k8812 in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8822,2,t0,t1);}
/* posixunix.scm: 2340 ##sys#process */
t2=*((C_word*)lf[438]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8795(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8795,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8804,a[2]=((C_word*)t0)[2],a[3]=((C_word)li222),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a8803 in chkstrlst in %process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8804(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8804,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8735(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_8735,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8741,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word)li219),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8747,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,a[10]=((C_word)li220),tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8747(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8747,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8758,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8778,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2316 make-on-close */
t12=((C_word*)t0)[3];
f_8564(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k8776 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2315 input-port */
t2=((C_word*)t0)[7];
f_8713(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8756 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8758,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8762,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8774,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2318 make-on-close */
t4=((C_word*)t0)[6];
f_8564(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k8772 in k8756 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2317 output-port */
t2=((C_word*)t0)[7];
f_8724(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8760 in k8756 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8762,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8766,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8770,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2321 make-on-close */
t4=((C_word*)t0)[3];
f_8564(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k8768 in k8760 in k8756 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2320 input-port */
t2=((C_word*)t0)[7];
f_8713(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8764 in k8760 in k8756 in a8746 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2314 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a8740 in ##sys#process in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8741,2,t0,t1);}
/* posixunix.scm: 2309 spawn */
t2=((C_word*)t0)[8];
f_8668(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8724(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8724,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8728,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2305 connect-parent */
t8=((C_word*)t0)[2];
f_8621(t8,t7,t4,t5);}

/* k8726 in output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2306 ##sys#custom-output-port */
((C_proc8)C_retrieve_proc(*((C_word*)lf[332]+1)))(8,*((C_word*)lf[332]+1),((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8713(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8713,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8717,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2301 connect-parent */
t8=((C_word*)t0)[2];
f_8621(t8,t7,t4,t5);}

/* k8715 in input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2302 ##sys#custom-input-port */
((C_proc8)C_retrieve_proc(*((C_word*)lf[318]+1)))(8,*((C_word*)lf[318]+1),((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8668(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8668,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8672,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,a[13]=((C_word*)t0)[6],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2288 needed-pipe */
t9=((C_word*)t0)[2];
f_8601(t9,t8,t6);}

/* k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8672,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8675,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2289 needed-pipe */
t3=((C_word*)t0)[2];
f_8601(t3,t2,((C_word*)t0)[5]);}

/* k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8675,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8678,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2290 needed-pipe */
t3=((C_word*)t0)[2];
f_8601(t3,t2,((C_word*)t0)[6]);}

/* k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8678,2,t0,t1);}
t2=f_8652(C_a_i(&a,3),((C_word*)t0)[13]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8689,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8691,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=((C_word*)t0)[14],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=((C_word)li215),tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2293 process-fork */
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t3,t4);}

/* a8690 in k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8691,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8695,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2295 connect-child */
t3=((C_word*)t0)[7];
f_8635(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[295]+1));}

/* k8693 in a8690 in k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8695,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8698,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_8652(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2296 connect-child */
t4=((C_word*)t0)[5];
f_8635(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[296]+1));}

/* k8696 in k8693 in a8690 in k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8698,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8701,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_8652(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2297 connect-child */
t4=((C_word*)t0)[3];
f_8635(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[297]+1));}

/* k8699 in k8696 in k8693 in a8690 in k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2298 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k8687 in k8676 in k8673 in k8670 in spawn in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2291 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swapped-ends in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8652(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_check;
if(C_truep(t1)){
t2=(C_word)C_i_cdr(t1);
t3=(C_word)C_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8635(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8635,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_i_car(t2);
t6=(C_word)C_i_cdr(t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8648,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2279 file-close */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k8646 in connect-child in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8648,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8560,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2253 duplicate-fileno */
t6=*((C_word*)lf[314]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k8558 in k8646 in connect-child in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2254 file-close */
t2=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8621(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8621,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8634,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2273 file-close */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k8632 in connect-parent in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8601(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8601,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8610,a[2]=((C_word*)t0)[2],a[3]=((C_word)li209),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8616,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a8615 in needed-pipe in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8616,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a8609 in needed-pipe in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8610,2,t0,t1);}
/* posixunix.scm: 2268 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* make-on-close in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8564(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8564,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8566,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,a[9]=((C_word)li207),tmp=(C_word)a,a+=10,tmp));}

/* f_8566 in make-on-close in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8566,2,t0,t1);}
t2=(C_word)C_i_vector_set(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8581,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word)li205),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8587,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word)li206),tmp=(C_word)a,a+=5,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a8586 */
static void C_ccall f_8587(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8587,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2263 ##sys#signal-hook */
t5=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[206],((C_word*)t0)[3],lf[437],((C_word*)t0)[2],t4);}}

/* a8580 */
static void C_ccall f_8581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8581,2,t0,t1);}
/* posixunix.scm: 2261 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8508(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_8508r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_8508r(t0,t1,t2,t3);}}

static void C_ccall f_8508r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8515,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2217 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k8513 in process-run in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8515,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2219 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8534,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2221 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[431]+1)))(2,*((C_word*)lf[431]+1),t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k8532 in k8513 in process-run in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8534,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8538,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2221 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[434]+1)))(3,*((C_word*)lf[434]+1),t2,((C_word*)t0)[2]);}

/* k8536 in k8532 in k8513 in process-run in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8538(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2221 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8502(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8502,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[435],t2));}

/* ##sys#shell-command in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8493(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8493,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8497,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2207 get-environment-variable */
t3=*((C_word*)lf[133]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[433]);}

/* k8495 in ##sys#shell-command in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[432]));}

/* process-signal in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8466(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_8466r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_8466r(t0,t1,t2,t3);}}

static void C_ccall f_8466r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[429]);
t7=(C_word)C_i_check_exact_2(t5,lf[429]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 2204 posix-error */
t10=lf[3];
f_3485(7,t10,t1,lf[206],lf[429],lf[430],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8459(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8459,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub2733(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8456,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub2728(C_SCHEME_UNDEFINED));}

/* current-process-id in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8453,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub2724(C_SCHEME_UNDEFINED));}

/* process-wait in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8375(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_8375r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_8375r(t0,t1,t2);}}

static void C_ccall f_8375r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[424]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8405,a[2]=t8,a[3]=t11,a[4]=((C_word)li195),tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8411,a[2]=t11,a[3]=((C_word)li196),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* a8410 in process-wait in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8411,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 2190 posix-error */
t6=lf[3];
f_3485(6,t6,t1,lf[206],lf[424],lf[425],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2191 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a8404 in process-wait in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8405,2,t0,t1);}
/* posixunix.scm: 2188 ##sys#process-wait */
((C_proc4)C_retrieve_proc(*((C_word*)lf[423]+1)))(4,*((C_word*)lf[423]+1),t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8358(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8358,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 2175 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8176(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_8176r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8176r(t0,t1,t2,t3);}}

static void C_ccall f_8176r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8178,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li190),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8305,a[2]=t4,a[3]=((C_word)li191),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8310,a[2]=t5,a[3]=((C_word)li192),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist25902658 */
t7=t6;
f_8310(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist25912654 */
t9=t5;
f_8305(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body25882597 */
t11=t4;
f_8178(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist2590 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8310(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8310,NULL,2,t0,t1);}
/* def-envlist25912654 */
t2=((C_word*)t0)[2];
f_8305(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist2591 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8305(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8305,NULL,3,t0,t1,t2);}
/* body25882597 */
t3=((C_word*)t0)[2];
f_8178(t3,t1,t2,C_SCHEME_FALSE);}

/* body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8178(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8178,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[421]);
t5=(C_word)C_i_check_list_2(t2,lf[421]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8188,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2143 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8188,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_8138(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8196,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li189),tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_8196(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* doloop2603 in k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8196(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_8196,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_8138(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8209,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(C_word)C_i_check_list_2(((C_word*)t0)[5],lf[421]);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8242,a[2]=((C_word*)t0)[3],a[3]=((C_word)li188),tmp=(C_word)a,a+=4,tmp);
t8=t5;
f_8209(t8,f_8242(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_8209(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[421]);
t6=(C_word)C_block_size(t4);
t7=f_8138(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* doloop2614 in doloop2603 in k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8242(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep((C_word)C_i_nullp(t1))){
return(f_8157(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[421]);
t5=(C_word)C_block_size(t3);
t6=f_8157(t2,t3,t5);
t7=(C_word)C_i_cdr(t1);
t8=(C_word)C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k8207 in doloop2603 in k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8209(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8209,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8212,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8234,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2157 ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k8232 in k8207 in doloop2603 in k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2157 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k8210 in k8207 in doloop2603 in k8186 in body2588 in process-execute in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub2553(C_SCHEME_UNDEFINED);
t5=(C_word)stub2568(C_SCHEME_UNDEFINED);
/* posixunix.scm: 2164 posix-error */
t6=lf[3];
f_3485(6,t6,((C_word*)t0)[3],lf[206],lf[421],lf[422],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8157(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub2559(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8138(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub2544(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8096(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_8096r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_8096r(t0,t1,t2);}}

static void C_ccall f_8096r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub2512(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 2128 posix-error */
t5=lf[3];
f_3485(5,t5,t1,lf[206],lf[418],lf[419]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8118,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_i_vector_ref(t2,C_fix(0));
t9=t8;
((C_proc2)C_retrieve_proc(t9))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k8116 in process-fork in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8118,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8122,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_8122 in k8116 in process-fork in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8122(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8122,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub2530(C_SCHEME_UNDEFINED,t3));}

/* glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7987(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_7987r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7987r(t0,t1,t2);}}

static void C_ccall f_7987r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7993,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,a[8]=((C_word*)t0)[7],a[9]=((C_word)li182),tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_7993(t6,t1,t2);}

/* conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7993(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7993,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8008,a[2]=t3,a[3]=((C_word*)t0)[8],a[4]=((C_word)li179),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8014,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,a[9]=((C_word)li181),tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8014(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8014,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8018,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8088,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[417]);
/* posixunix.scm: 2113 make-pathname */
t8=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k8086 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2113 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8021,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 2114 regexp */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8021,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8028,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[416]);
/* posixunix.scm: 2115 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k8026 in k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8028,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8030,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li180),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_8030(t5,((C_word*)t0)[2],t1);}

/* loop in k8026 in k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8030(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8030,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[8]);
/* posixunix.scm: 2116 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_7993(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8047,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixunix.scm: 2117 string-match */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k8045 in loop in k8026 in k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8047,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8057,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixunix.scm: 2118 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixunix.scm: 2119 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_8030(t3,((C_word*)t0)[6],t2);}}

/* k8055 in k8045 in loop in k8026 in k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8057,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8061,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm: 2118 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_8030(t4,t2,t3);}

/* k8059 in k8055 in k8045 in loop in k8026 in k8019 in k8016 in a8013 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8061,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a8007 in conc-loop in glob in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8008,2,t0,t1);}
/* posixunix.scm: 2112 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7975,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7979,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub2426(t3),C_fix(0));}

/* k7977 in get-host-name in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7979,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7982,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_7982(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2094 posix-error */
t3=lf[3];
f_3485(5,t3,t2,lf[404],lf[408],lf[409]);}}

/* k7980 in k7977 in get-host-name in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7940(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7940,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7944,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2075 ##sys#terminal-check */
f_7885(t3,lf[403],t2);}

/* k7942 in terminal-size in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7944(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7944,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7964,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[406]+1)))(6,*((C_word*)lf[406]+1),t4,t2,C_fix(0),C_SCHEME_FALSE,lf[407]);}

/* k7962 in k7942 in terminal-size in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7964,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7968,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[406]+1)))(6,*((C_word*)lf[406]+1),t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[407]);}

/* k7966 in k7962 in k7942 in terminal-size in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7968(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
t2=(C_word)C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
t5=(C_word)C_i_foreign_pointer_argumentp(t3);
t6=(C_word)C_i_foreign_pointer_argumentp(t1);
t7=(C_word)stub2397(C_SCHEME_UNDEFINED,t4,t5,t6);
t8=(C_word)C_eqp(C_fix(0),t7);
if(C_truep(t8)){
/* posixunix.scm: 2082 values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm: 2083 posix-error */
t9=lf[3];
f_3485(6,t9,((C_word*)t0)[4],lf[404],lf[403],lf[405],((C_word*)t0)[6]);}}

/* terminal-name in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7917(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7917,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7921,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2067 ##sys#terminal-check */
f_7885(t3,lf[402],t2);}

/* k7919 in terminal-name in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7921,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub2382(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* ##sys#terminal-check in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7885(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7885,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7889,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2059 ##sys#check-port */
t5=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,t3,t2);}

/* k7887 in ##sys#terminal-check in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[99],t2);
t4=(C_truep(t3)?(C_word)C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2062 ##sys#error */
t5=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[401],((C_word*)t0)[4]);}}

/* terminal-port? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7866(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7866,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7870,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2054 ##sys#check-port */
t4=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[399]);}

/* k7868 in terminal-port? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7870,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7873,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2055 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[313]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k7871 in k7868 in terminal-port? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7807(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_7807r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_7807r(t0,t1,t2,t3,t4);}}

static void C_ccall f_7807r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7811,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2039 ##sys#check-port */
t6=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[393]);}

/* k7809 in set-buffering-mode! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7811(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7811,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7817,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[395]);
if(C_truep(t6)){
t7=t5;
f_7817(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[396]);
if(C_truep(t7)){
t8=t5;
f_7817(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[397]);
if(C_truep(t8)){
t9=t5;
f_7817(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 2045 ##sys#error */
t9=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[393],lf[398],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k7815 in k7809 in set-buffering-mode! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[393]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[99],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 2051 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[393],lf[394],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7800(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7800,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub2333(C_SCHEME_UNDEFINED,t3));}

/* _exit in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7784(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_7784r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_7784r(t0,t1,t2);}}

static void C_ccall f_7784r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(t2,C_fix(0)):C_fix(0));
t5=(C_word)C_i_foreign_fixnum_argumentp(t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub2324(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7772,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub2316(t2),C_fix(0));}

/* utc-time->seconds in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7757(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7757,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7761,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2007 check-time-vector */
f_7544(t3,lf[388],t2);}

/* k7759 in utc-time->seconds in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 2009 ##sys#cons-flonum */
t2=*((C_word*)lf[386]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2010 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[388],lf[389],((C_word*)t0)[3]);}}

/* local-time->seconds in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7742(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7742,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7746,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2001 check-time-vector */
f_7544(t3,lf[385],t2);}

/* k7744 in local-time->seconds in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 2003 ##sys#cons-flonum */
t2=*((C_word*)lf[386]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2004 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[385],lf[387],((C_word*)t0)[3]);}}

/* string->time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7696(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7696r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7696r(t0,t1,t2,t3);}}

static void C_ccall f_7696r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7700,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_7700(2,t5,lf[384]);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_7700(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k7698 in string->time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7700,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[383]);
t3=(C_word)C_i_check_string_2(t1,lf[383]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7713,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1998 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[3]);}

/* k7711 in k7698 in string->time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7713,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7717,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1998 ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k7715 in k7711 in k7698 in string->time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7717,2,t0,t1);}
t2=(C_word)C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub2277(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7627(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7627r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7627r(t0,t1,t2,t3);}}

static void C_ccall f_7627r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7631,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_7631(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_7631(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k7629 in time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7631(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7631,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7634,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1982 check-time-vector */
f_7544(t2,lf[380],((C_word*)t0)[2]);}

/* k7632 in k7629 in time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7634,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[380]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7643,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7653,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1986 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7656,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub2227(t4,t3),C_fix(0));}}

/* k7654 in k7632 in k7629 in time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1990 ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1991 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[380],lf[382],((C_word*)t0)[2]);}}

/* k7651 in k7632 in k7629 in time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7653,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub2235(t3,t2,t1),C_fix(0));}

/* k7641 in k7632 in k7629 in time->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7643(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm: 1987 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[380],lf[381],((C_word*)t0)[2]);}}

/* seconds->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7591(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7591,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[378]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7598,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_word)C_i_foreign_integer_argumentp(t5);
t8=(C_word)stub2211(t6,t7);
/* ##sys#peek-c-string */
t9=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t4,t8,C_fix(0));}

/* k7596 in seconds->string in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7598(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1975 ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1976 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[378],lf[379],((C_word*)t0)[2]);}}

/* seconds->utc-time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7572(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7572,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[377]);
/* posixunix.scm: 1967 ##sys#decode-seconds */
t4=*((C_word*)lf[376]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7563(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7563,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[375]);
/* posixunix.scm: 1963 ##sys#decode-seconds */
t4=*((C_word*)lf[376]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* check-time-vector in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7544(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7544,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_check_vector_2(t3,t2);
t5=(C_word)C_block_size(t3);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1959 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[374],t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* memory-mapped-file? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7538(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7538,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[364]));}

/* memory-mapped-file-pointer in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7529(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7529,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[364],lf[371]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7494(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7494r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7494r(t0,t1,t2,t3);}}

static void C_ccall f_7494r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=(C_word)C_i_check_structure_2(t2,lf[364],lf[369]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub2164(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1945 posix-error */
t12=lf[3];
f_3485(7,t12,t1,lf[48],lf[369],lf[370],t2,t6);}}

/* map-file-to-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7432(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_7432r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_7432r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_7432r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7436,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_7436(2,t10,t2);}
else{
/* posixunix.scm: 1930 ##sys#null-pointer */
t10=*((C_word*)lf[368]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k7434 in map-file-to-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7436,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7442,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_7442(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1933 ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[60],lf[363],lf[367],t1);}}

/* k7440 in k7434 in map-file-to-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7442,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub2125(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7448,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7461,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1935 ##sys#pointer->address */
t17=*((C_word*)lf[366]+1);
((C_proc3)(void*)(*((C_word*)t17+1)))(3,t17,t16,t14);}

/* k7459 in k7440 in k7434 in map-file-to-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7461(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1936 posix-error */
t3=lf[3];
f_3485(11,t3,((C_word*)t0)[8],lf[48],lf[363],lf[365],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_7448(2,t3,C_SCHEME_UNDEFINED);}}

/* k7446 in k7440 in k7434 in map-file-to-memory in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7448(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7448,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[364],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7328(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7328,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7334,a[2]=t3,a[3]=((C_word)li156),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_7334(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7334(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7334,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7338,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub2076(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k7336 in loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7338,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7346,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word)li155),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_7346(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k7336 in loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7346(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_7346,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7372,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1894 ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1897 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k7370 in scan in k7336 in loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7372(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7372,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7376,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1895 ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k7374 in k7370 in scan in k7336 in loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7376,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7364,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1896 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_7334(t5,t3,t4);}

/* k7362 in k7374 in k7370 in scan in k7336 in loop in get-environment-variables in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7364,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7308(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7308,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[351]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7316,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7314 in unsetenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7291,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[350]);
t5=(C_word)C_i_check_string_2(t3,lf[350]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7302,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1878 ##sys#make-c-string */
t7=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k7300 in setenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7302,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7306,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1878 ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k7304 in k7300 in setenv in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7265(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7265,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[92]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7272,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7289,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1866 ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k7287 in fifo? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1866 ##sys#file-info */
t2=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7270 in fifo? in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7272(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1869 posix-error */
t2=lf[3];
f_3485(6,t2,((C_word*)t0)[3],lf[48],lf[92],lf[349],((C_word*)t0)[2]);}}

/* create-fifo in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7222(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7222r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7222r(t0,t1,t2,t3);}}

static void C_ccall f_7222r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[347]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7229,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_7229(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_7229(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k7227 in create-fifo in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7229(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7229,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[347]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7246,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7250,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1860 ##sys#expand-home-path */
t5=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k7248 in k7227 in create-fifo in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1860 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7244 in k7227 in create-fifo in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1861 posix-error */
t3=lf[3];
f_3485(7,t3,((C_word*)t0)[3],lf[48],lf[347],lf[348],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7194(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7194,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[338],lf[345]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1850 posix-error */
t9=lf[3];
f_3485(6,t9,t1,lf[48],lf[345],lf[346],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7172(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7172r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7172r(t0,t1,t2,t3);}}

static void C_ccall f_7172r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7176,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1841 setup */
f_7050(t4,t2,t3,lf[343]);}

/* k7174 in file-test-lock in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1843 err */
f_7124(((C_word*)t0)[3],lf[344],t1,lf[343]);}}

/* file-lock/blocking in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7157(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7157r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7157r(t0,t1,t2,t3);}}

static void C_ccall f_7157r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7161,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1835 setup */
f_7050(t4,t2,t3,lf[341]);}

/* k7159 in file-lock/blocking in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1837 err */
f_7124(((C_word*)t0)[2],lf[342],t1,lf[341]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7142(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7142r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7142r(t0,t1,t2,t3);}}

static void C_ccall f_7142r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7146,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1829 setup */
f_7050(t4,t2,t3,lf[339]);}

/* k7144 in file-lock in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1831 err */
f_7124(((C_word*)t0)[2],lf[340],t1,lf[339]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7124(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7124,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1826 posix-error */
t8=lf[3];
f_3485(8,t8,t1,lf[48],t4,t2,t5,t6,t7);}

/* setup in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7050(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7050,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7072,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1818 ##sys#check-port */
t16=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k7070 in setup in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7072,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7078,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_7078(t6,t5);}
else{
t5=t3;
f_7078(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k7076 in k7070 in setup in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7078(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7078,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[338],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7011(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7011,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[335]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7028,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7035,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7039,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1801 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_7028(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1803 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[335],lf[337],t2);}}}

/* k7037 in file-truncate in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1801 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7033 in file-truncate in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_7028(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k7026 in file-truncate in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1805 posix-error */
t2=lf[3];
f_3485(7,t2,((C_word*)t0)[4],lf[48],lf[335],lf[336],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6752(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+20)){
C_save_and_reclaim((void*)tr5r,(void*)f_6752r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6752r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6752r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(20);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6754,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,a[7]=((C_word)li139),tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6938,a[2]=t6,a[3]=((C_word)li140),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6943,a[2]=t7,a[3]=((C_word)li141),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6948,a[2]=t8,a[3]=((C_word)li142),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?18501941 */
t10=t9;
f_6948(t10,t1);}
else{
t10=(C_word)C_i_car(t5);
t11=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-bufi18511937 */
t12=t8;
f_6943(t12,t1,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* def-on-close18521932 */
t14=t7;
f_6938(t14,t1,t10,t12);}
else{
t14=(C_word)C_i_car(t13);
t15=(C_word)C_i_cdr(t13);
if(C_truep((C_word)C_i_nullp(t15))){
/* body18481858 */
t16=t6;
f_6754(t16,t1,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t1,lf[0],t15);}}}}}

/* def-nonblocking?1850 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6948(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6948,NULL,2,t0,t1);}
/* def-bufi18511937 */
t2=((C_word*)t0)[2];
f_6943(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1851 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6943(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6943,NULL,3,t0,t1,t2);}
/* def-on-close18521932 */
t3=((C_word*)t0)[2];
f_6938(t3,t1,t2,C_fix(0));}

/* def-on-close1852 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6938(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6938,NULL,4,t0,t1,t2,t3);}
/* body18481858 */
t4=((C_word*)t0)[2];
f_6754(t4,t1,t2,t3,*((C_word*)lf[330]+1));}

/* body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6754(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6754,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6758,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1743 ##sys#file-nonblocking! */
((C_proc3)C_retrieve_proc(*((C_word*)lf[9]+1)))(3,*((C_word*)lf[9]+1),t5,((C_word*)t0)[6]);}
else{
t6=t5;
f_6758(2,t6,C_SCHEME_UNDEFINED);}}

/* k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6758,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6760,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=t3,a[5]=((C_word*)t0)[9],a[6]=((C_word)li132),tmp=(C_word)a,a+=7,tmp));
t7=(C_word)C_fixnump(((C_word*)t0)[6]);
t8=(C_truep(t7)?((C_word*)t0)[6]:(C_word)C_block_size(((C_word*)t0)[6]));
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6806,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t10=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_6806(t11,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6850,a[2]=t3,a[3]=((C_word)li136),tmp=(C_word)a,a+=4,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6864,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
/* posixunix.scm: 1762 ##sys#make-string */
t12=*((C_word*)lf[328]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,((C_word*)t0)[6]);}
else{
t12=t11;
f_6864(2,t12,((C_word*)t0)[6]);}}}

/* k6862 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6864,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_6806(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6865,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word)li138),tmp=(C_word)a,a+=7,tmp));}

/* f_6865 in k6862 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6865(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6865,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6882,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word)li137),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_6882(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1778 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6760(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_6882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6882,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6892,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1768 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_6760(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_difference(t4,t2);
/* posixunix.scm: 1773 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k6890 in loop */
static void C_ccall f_6892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1770 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6882(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_6850 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6850(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6850,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1761 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6760(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6806(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6806,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6810,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6815,a[2]=((C_word*)t0)[9],a[3]=((C_word)li133),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6821,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,a[7]=((C_word)li134),tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6842,a[2]=((C_word*)t0)[9],a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1781 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t9))(5,t9,t5,t6,t7,t8);}

/* a6841 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6842,2,t0,t1);}
/* posixunix.scm: 1791 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* a6820 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6821,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6831,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1788 posix-error */
t3=lf[3];
f_3485(7,t3,t2,lf[48],((C_word*)t0)[3],lf[334],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_6831(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6829 in a6820 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1789 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a6814 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6815(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6815,3,t0,t1,t2);}
/* posixunix.scm: 1783 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t3))(3,t3,t1,t2);}

/* k6808 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6810(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6810,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6813,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1792 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k6811 in k6808 in k6804 in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6813(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6760(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6760,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6776,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1751 ##sys#thread-yield! */
t8=*((C_word*)lf[320]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1753 posix-error */
t7=lf[3];
f_3485(7,t7,t1,((C_word*)t0)[3],lf[48],lf[333],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6795,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1755 ##sys#substring */
t7=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k6793 in poke in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1755 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6760(t3,((C_word*)t0)[2],t1,t2);}

/* k6774 in poke in k6756 in body1848 in ##sys#custom-output-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1752 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_6760(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6270(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+24)){
C_save_and_reclaim((void*)tr5r,(void*)f_6270r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6270r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6270r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(24);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6272,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,a[7]=((C_word)li126),tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6659,a[2]=t6,a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6664,a[2]=t7,a[3]=((C_word)li128),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6669,a[2]=t8,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6674,a[2]=t9,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?16111809 */
t11=t10;
f_6674(t11,t1);}
else{
t11=(C_word)C_i_car(t5);
t12=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-bufi16121805 */
t13=t9;
f_6669(t13,t1,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* def-on-close16131800 */
t15=t8;
f_6664(t15,t1,t11,t13);}
else{
t15=(C_word)C_i_car(t14);
t16=(C_word)C_i_cdr(t14);
if(C_truep((C_word)C_i_nullp(t16))){
/* def-more?16141794 */
t17=t7;
f_6659(t17,t1,t11,t13,t15);}
else{
t17=(C_word)C_i_car(t16);
t18=(C_word)C_i_cdr(t16);
if(C_truep((C_word)C_i_nullp(t18))){
/* body16091620 */
t19=t6;
f_6272(t19,t1,t11,t13,t15,t17);}
else{
/* ##sys#error */
t19=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t19+1)))(4,t19,t1,lf[0],t18);}}}}}}

/* def-nonblocking?1611 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6674(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6674,NULL,2,t0,t1);}
/* def-bufi16121805 */
t2=((C_word*)t0)[2];
f_6669(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1612 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6669(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6669,NULL,3,t0,t1,t2);}
/* def-on-close16131800 */
t3=((C_word*)t0)[2];
f_6664(t3,t1,t2,C_fix(1));}

/* def-on-close1613 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6664(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6664,NULL,4,t0,t1,t2,t3);}
/* def-more?16141794 */
t4=((C_word*)t0)[2];
f_6659(t4,t1,t2,t3,*((C_word*)lf[330]+1));}

/* def-more?1614 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6659(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6659,NULL,5,t0,t1,t2,t3,t4);}
/* body16091620 */
t5=((C_word*)t0)[2];
f_6272(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6272(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6272,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6276,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=t3,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1617 ##sys#file-nonblocking! */
((C_proc3)C_retrieve_proc(*((C_word*)lf[9]+1)))(3,*((C_word*)lf[9]+1),t6,((C_word*)t0)[5]);}
else{
t7=t6;
f_6276(2,t7,C_SCHEME_UNDEFINED);}}

/* k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6276,2,t0,t1);}
t2=(C_word)C_fixnump(((C_word*)t0)[10]);
t3=(C_truep(t2)?((C_word*)t0)[10]:(C_word)C_block_size(((C_word*)t0)[10]));
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6282,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[10]))){
/* posixunix.scm: 1619 ##sys#make-string */
t5=*((C_word*)lf[328]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[10]);}
else{
t5=t4;
f_6282(2,t5,((C_word*)t0)[10]);}}

/* k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[73],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6282,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6283,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word)li112),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6306,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6314,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,a[10]=((C_word)li114),tmp=(C_word)a,a+=11,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6396,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6401,a[2]=t8,a[3]=t5,a[4]=t7,a[5]=((C_word)li115),tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6414,a[2]=t6,a[3]=t3,a[4]=t5,a[5]=((C_word)li116),tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6426,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,a[7]=((C_word)li117),tmp=(C_word)a,a+=8,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6447,a[2]=t8,a[3]=t7,a[4]=((C_word)li118),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6456,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,a[6]=((C_word)li120),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6532,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,a[6]=((C_word)li125),tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1667 make-input-port */
t18=((C_word*)t0)[2];
((C_proc8)C_retrieve_proc(t18))(8,t18,t11,t12,t13,t14,t15,t16,t17);}

/* a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6532(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6532,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6538,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word)li124),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f_6538(t7,t1,C_SCHEME_FALSE);}

/* loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6538(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6538,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6540,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li121),tmp=(C_word)a,a+=9,tmp);
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6618,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word)li122),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6624,a[2]=((C_word*)t0)[2],a[3]=((C_word)li123),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6634,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1732 fetch */
t5=((C_word*)t0)[5];
f_6314(t5,t4);}}

/* k6632 in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm: 1734 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_6538(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a6623 in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6624(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6624,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm: 1729 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6538(t4,t1,t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a6617 in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6618,2,t0,t1);}
/* posixunix.scm: 1727 ##sys#scan-buffer-line */
((C_proc6)C_retrieve_proc(*((C_word*)lf[329]+1)))(6,*((C_word*)lf[329]+1),t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6540(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6540,4,t0,t1,t2,t3);}
t4=(C_word)C_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6547,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_6547(2,t8,(C_truep(t7)?t7:lf[326]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6590,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1709 ##sys#make-string */
t8=*((C_word*)lf[328]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t4);}}

/* k6588 in bumper in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6590(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(5));
t4=(C_word)C_fixnum_plus(t3,((C_word*)t0)[4]);
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm: 1715 ##sys#string-append */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=((C_word*)t0)[2];
f_6547(2,t6,t1);}}

/* k6545 in bumper in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6547,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=(C_word)C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6557,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1719 fetch */
t5=((C_word*)t0)[3];
f_6314(t5,t4);}
else{
t4=(C_word)C_slot(((C_word*)t0)[2],C_fix(4));
t5=(C_word)C_fixnum_plus(t4,C_fix(1));
t6=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm: 1724 values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k6555 in k6545 in bumper in loop in a6531 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm: 1720 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a6455 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6456(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6456,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6464,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_6464(t7,t3);}
else{
t7=(C_word)C_block_size(t4);
t8=t6;
f_6464(t8,(C_word)C_fixnum_difference(t7,t5));}}

/* k6462 in a6455 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6464(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6464,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6466,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li119),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6466(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k6462 in a6455 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6466(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6466,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}
else{
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=(C_word)C_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=(C_word)C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=(C_word)C_fixnum_difference(t2,t8);
t14=(C_word)C_fixnum_plus(t3,t8);
t15=(C_word)C_fixnum_plus(t4,t8);
/* posixunix.scm: 1695 loop */
t18=t1;
t19=t13;
t20=t14;
t21=t15;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6514,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1697 fetch */
t7=((C_word*)t0)[2];
f_6314(t7,t6);}}}

/* k6512 in loop in k6462 in a6455 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm: 1700 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6466(t3,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* a6446 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6447,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6451,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1685 fetch */
t3=((C_word*)t0)[2];
f_6314(t3,t2);}

/* k6449 in a6446 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1686 peek */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,f_6306(((C_word*)t0)[2]));}

/* a6425 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6426,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6436,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1682 posix-error */
t3=lf[3];
f_3485(7,t3,t2,lf[48],((C_word*)t0)[3],lf[325],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_6436(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6434 in a6425 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1683 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a6413 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6414,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1677 ready? */
t3=((C_word*)t0)[2];
f_6283(t3,t1);}}

/* a6400 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6401,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6405,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1669 fetch */
t3=((C_word*)t0)[2];
f_6314(t3,t2);}

/* k6403 in a6400 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_6306(((C_word*)t0)[4]);
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k6394 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6396,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6399,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1736 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k6397 in k6394 in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6314(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6314,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6326,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word)li113),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_6326(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6326(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6326,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6342,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1644 ##sys#thread-block-for-i/o! */
((C_proc5)C_retrieve_proc(*((C_word*)lf[321]+1)))(5,*((C_word*)lf[321]+1),t5,*((C_word*)lf[322]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1647 posix-error */
t5=lf[3];
f_3485(7,t5,t1,lf[48],((C_word*)t0)[6],lf[323],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6363,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1651 more? */
t6=((C_word*)t0)[4];
((C_proc2)C_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k6361 in loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6363,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6366,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1653 ##sys#thread-yield! */
t3=*((C_word*)lf[320]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6372,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_6372(2,t8,t7);}
else{
/* posixunix.scm: 1659 posix-error */
t7=lf[3];
f_3485(7,t7,t4,lf[48],((C_word*)t0)[3],lf[324],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_6372(2,t6,C_SCHEME_UNDEFINED);}}}

/* k6370 in k6361 in loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6372(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k6364 in k6361 in loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6366(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1654 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_6326(t2,((C_word*)t0)[2]);}

/* k6340 in loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6342(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6342,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6345,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1645 ##sys#thread-yield! */
t3=*((C_word*)lf[320]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k6343 in k6340 in loop in fetch in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1646 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_6326(t2,((C_word*)t0)[2]);}

/* peek in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_6306(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_check;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6283(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6283,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6287,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1625 ##sys#file-select-one */
((C_proc3)C_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t2,((C_word*)t0)[3]);}

/* k6285 in ready? in k6280 in k6274 in body1609 in ##sys#custom-input-port in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
/* posixunix.scm: 1629 posix-error */
t4=lf[3];
f_3485(7,t4,((C_word*)t0)[5],lf[48],((C_word*)t0)[4],lf[319],((C_word*)t0)[3],((C_word*)t0)[2]);}}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t1));}}

/* duplicate-fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6243(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6243r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6243r(t0,t1,t2,t3);}}

static void C_ccall f_6243r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[314]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6250,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_6250(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[314]);
t8=t5;
f_6250(t8,(C_word)C_dup2(t2,t6));}}

/* k6248 in duplicate-fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6250(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6250,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6253,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1610 posix-error */
t3=lf[3];
f_3485(6,t3,t2,lf[48],lf[314],lf[315],((C_word*)t0)[2]);}
else{
t3=t2;
f_6253(2,t3,C_SCHEME_UNDEFINED);}}

/* k6251 in k6248 in duplicate-fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6198(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6198,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6202,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1592 ##sys#check-port */
t4=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[308]);}

/* k6200 in port->fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6202,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[309],t2);
if(C_truep(t3)){
/* posixunix.scm: 1593 ##sys#tcp-port->fileno */
((C_proc3)C_retrieve_proc(*((C_word*)lf[310]+1)))(3,*((C_word*)lf[310]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6237,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1594 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[313]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k6235 in k6200 in port->fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6237,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1599 posix-error */
t2=lf[3];
f_3485(6,t2,((C_word*)t0)[3],lf[60],lf[308],lf[311],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6220,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1597 posix-error */
t4=lf[3];
f_3485(6,t4,t3,lf[48],lf[308],lf[312],((C_word*)t0)[2]);}
else{
t4=t3;
f_6220(2,t4,C_SCHEME_UNDEFINED);}}}

/* k6218 in k6235 in k6200 in port->fileno in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6184(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6184r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6184r(t0,t1,t2,t3);}}

static void C_ccall f_6184r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[307]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6196,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1588 mode */
f_6118(t5,C_SCHEME_FALSE,t3);}

/* k6194 in open-output-file* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6196,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1588 check */
f_6155(((C_word*)t0)[2],lf[307],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6170(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6170r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6170r(t0,t1,t2,t3);}}

static void C_ccall f_6170r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[306]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6182,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1584 mode */
f_6118(t5,C_SCHEME_TRUE,t3);}

/* k6180 in open-input-file* in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6182(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6182,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1584 check */
f_6155(((C_word*)t0)[2],lf[306],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6155(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6155,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1577 posix-error */
t6=lf[3];
f_3485(6,t6,t1,lf[48],t2,lf[304],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6168,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1578 ##sys#make-port */
t7=*((C_word*)lf[157]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[158]+1),lf[305],lf[99]);}}

/* k6166 in check in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6118(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6118,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6126,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[298]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1571 ##sys#error */
t8=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[299],t5);}
else{
t8=t4;
f_6126(2,t8,lf[300]);}}
else{
/* posixunix.scm: 1572 ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[301],t5);}}
else{
t5=t4;
f_6126(2,t5,(C_truep(t2)?lf[302]:lf[303]));}}

/* k6124 in mode in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1567 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6093(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6093,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[292]);
t5=(C_word)C_i_check_string_2(t3,lf[292]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6074,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_6074(2,t9,C_SCHEME_FALSE);}}

/* k6072 in file-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6074(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6074,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6078,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_6078(2,t3,C_SCHEME_FALSE);}}

/* k6076 in k6072 in file-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6078(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1489(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1552 posix-error */
t3=lf[3];
f_3485(7,t3,((C_word*)t0)[4],lf[48],lf[293],lf[294],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6009(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3r,(void*)f_6009r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6009r(t0,t1,t2,t3);}}

static void C_ccall f_6009r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6013,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_6013(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_6013(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6013,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[289]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6020,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6048,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1538 ##sys#expand-home-path */
t5=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[5]);}

/* k6046 in k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1538 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6018 in k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6020,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6023,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1540 posix-error */
t4=lf[3];
f_3485(6,t4,t3,lf[48],lf[289],lf[291],((C_word*)t0)[2]);}
else{
t4=t3;
f_6023(2,t4,C_SCHEME_UNDEFINED);}}

/* k6021 in k6018 in k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6023,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6026,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1541 substring */
t3=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t3))(5,t3,t2,((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* k6024 in k6021 in k6018 in k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6026,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6032,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 1542 symbolic-link? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[85]+1)))(3,*((C_word*)lf[85]+1),t2,t1);}
else{
t3=t2;
f_6032(2,t3,C_SCHEME_FALSE);}}

/* k6030 in k6024 in k6021 in k6018 in k6011 in read-symbolic-link in k6006 in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 1543 read-symbolic-link */
((C_proc4)C_retrieve_proc(*((C_word*)lf[289]+1)))(4,*((C_word*)lf[289]+1),((C_word*)t0)[3],((C_word*)t0)[2],lf[290]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* create-symbolic-link in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5971(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5971,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[285]);
t5=(C_word)C_i_check_string_2(t3,lf[285]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5992,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6004,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1526 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k6002 in create-symbolic-link in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1526 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5990 in create-symbolic-link in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5992,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5996,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6000,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1527 ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5998 in k5990 in create-symbolic-link in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1527 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5994 in k5990 in create-symbolic-link in k5967 in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5996(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1529 posix-error */
t3=lf[3];
f_3485(7,t3,((C_word*)t0)[4],lf[48],lf[286],lf[287],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* create-session in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5952,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5956,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5962,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1497 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_5956(2,t4,C_SCHEME_UNDEFINED);}}

/* k5960 in create-session in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1498 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[282],lf[283]);}

/* k5954 in create-session in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5946(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5946,3,t0,t1,t2);}
/* posixunix.scm: 1492 check */
f_5910(t1,t2,C_fix((C_word)X_OK),lf[281]);}

/* file-write-access? in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5940(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5940,3,t0,t1,t2);}
/* posixunix.scm: 1491 check */
f_5910(t1,t2,C_fix((C_word)W_OK),lf[280]);}

/* file-read-access? in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5934(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5934,3,t0,t1,t2);}
/* posixunix.scm: 1490 check */
f_5910(t1,t2,C_fix((C_word)R_OK),lf[279]);}

/* check in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5910(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5910,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5928,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5932,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1487 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k5930 in check in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5932(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1487 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5926 in check in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5928,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5920,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_5920(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1488 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k5918 in k5926 in check in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5880(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5880,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[277]);
t6=(C_word)C_i_check_exact_2(t3,lf[277]);
t7=(C_word)C_i_check_exact_2(t4,lf[277]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5904,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5908,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1477 ##sys#expand-home-path */
t10=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k5906 in change-file-owner in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1477 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5902 in change-file-owner in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5904(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1478 posix-error */
t3=lf[3];
f_3485(8,t3,((C_word*)t0)[3],lf[48],lf[277],lf[278],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5853,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[275]);
t5=(C_word)C_i_check_exact_2(t3,lf[275]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5874,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5878,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1469 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k5876 in change-file-mode in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5878(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1469 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5872 in change-file-mode in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1470 posix-error */
t3=lf[3];
f_3485(7,t3,((C_word*)t0)[3],lf[48],lf[275],lf[276],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5789(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5789,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[234]);
t5=(C_word)C_i_check_exact_2(t3,lf[234]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5777,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_5777(2,t9,C_SCHEME_FALSE);}}

/* k5775 in initialize-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5777,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub1293(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5805,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1390 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k5803 in k5775 in initialize-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1391 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[234],lf[235],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5715(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5715,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5719,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_5645(t4);
if(C_truep(t5)){
t6=t3;
f_5719(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1373 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[231],lf[233]);}}

/* k5717 in set-groups! in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5719,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5724,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li93),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5724(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* doloop1269 in k5717 in set-groups! in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5724(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5724,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5740,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1378 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[231]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k5738 in doloop1269 in k5717 in set-groups! in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1379 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[231],lf[232],((C_word*)t0)[2]);}

/* get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5652(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5652,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5656,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5710,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1359 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_5656(2,t4,C_SCHEME_UNDEFINED);}}

/* k5708 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1360 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[227],lf[230]);}

/* k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5659,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_5645(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_5659(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1362 ##sys#error */
t4=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[227],lf[229]);}}

/* k5657 in k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5659,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5662,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub1228(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5691,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1364 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_5662(2,t5,C_SCHEME_UNDEFINED);}}

/* k5689 in k5657 in k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1365 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[227],lf[228]);}

/* k5660 in k5657 in k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5662(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5662,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5667,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li91),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5667(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k5660 in k5657 in k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5667(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5667,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5681,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1369 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k5679 in loop in k5660 in k5657 in k5654 in get-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5681,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_5645(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub1234(C_SCHEME_UNDEFINED,t2));}

/* group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5559(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5559r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5559r(t0,t1,t2,t3);}}

static void C_ccall f_5559r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5563,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_5563(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_5563(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5563,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5566,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_5566(t3,(C_word)C_getgrgid(((C_word*)t0)[2]));}
else{
t3=(C_word)C_i_check_string_2(((C_word*)t0)[2],lf[225]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5617,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1333 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k5615 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5566(t2,(C_word)C_getgrnam(t1));}

/* k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5566(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5566,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5576,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5576,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5580,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k5578 in k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5580,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5584,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5589,a[2]=t4,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_5589(t6,t2,C_fix(0));}

/* loop in k5578 in k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5589(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5589,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5593,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub1186(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k5591 in loop in k5578 in k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5593,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5603,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1342 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5589(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k5601 in k5591 in loop in k5578 in k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5603,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k5582 in k5578 in k5574 in k5564 in k5561 in group-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?*((C_word*)lf[222]+1):*((C_word*)lf[223]+1));
t3=t2;
((C_proc6)C_retrieve_proc(t3))(6,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5534,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5542,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5546,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1318 current-effective-user-id */
((C_proc2)C_retrieve_proc(*((C_word*)lf[218]+1)))(2,*((C_word*)lf[218]+1),t3);}

/* k5544 in current-effective-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1318 user-information */
((C_proc3)C_retrieve_proc(*((C_word*)lf[221]+1)))(3,*((C_word*)lf[221]+1),((C_word*)t0)[2],t1);}

/* k5540 in current-effective-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_list_ref(t1,C_fix(0)));}

/* current-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5520(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5520,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5528,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5532,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1315 current-user-id */
((C_proc2)C_retrieve_proc(*((C_word*)lf[217]+1)))(2,*((C_word*)lf[217]+1),t3);}

/* k5530 in current-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1315 user-information */
((C_proc3)C_retrieve_proc(*((C_word*)lf[221]+1)))(3,*((C_word*)lf[221]+1),((C_word*)t0)[2],t1);}

/* k5526 in current-user-name in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_list_ref(t1,C_fix(0)));}

/* user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5453(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5453r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5453r(t0,t1,t2,t3);}}

static void C_ccall f_5453r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5457,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_5457(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_5457(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5457,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5460,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_5460(t3,(C_word)C_getpwuid(((C_word*)t0)[2]));}
else{
t3=(C_word)C_i_check_string_2(((C_word*)t0)[2],lf[221]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5499,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1303 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k5497 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5499(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5460(t2,(C_word)C_getpwnam(t1));}

/* k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5460(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5460,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5470,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k5468 in k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5470,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5474,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k5472 in k5468 in k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5474,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5478,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k5476 in k5472 in k5468 in k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5478,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5482,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k5480 in k5476 in k5472 in k5468 in k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5482,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5486,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k5484 in k5480 in k5476 in k5472 in k5468 in k5458 in k5455 in user-information in k5449 in k5445 in k5441 in k5437 in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[7])?*((C_word*)lf[222]+1):*((C_word*)lf[223]+1));
t3=t2;
((C_proc9)C_retrieve_proc(t3))(9,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5399,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5403,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5432,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1248 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_5403(2,t3,C_SCHEME_UNDEFINED);}}

/* k5430 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1249 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[214],lf[216]);}

/* k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5403,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5410,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k5408 in k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5410,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5414,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k5412 in k5408 in k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5414,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5418,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k5416 in k5412 in k5408 in k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5418,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5422,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k5420 in k5416 in k5412 in k5408 in k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5422,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5426,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[215]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k5424 in k5420 in k5416 in k5412 in k5408 in k5401 in system-information in k5395 in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5426,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5381(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5381,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1227 posix-error */
t5=lf[3];
f_3485(5,t5,t1,lf[206],lf[212],lf[213]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5366(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5366,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[210]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1221 posix-error */
t5=lf[3];
f_3485(5,t5,t1,lf[206],lf[210],lf[211]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5360(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5360,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[209]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5328(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5328,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5334,a[2]=t3,a[3]=((C_word)li79),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_5334(t5,t1,*((C_word*)lf[201]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5334(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5334,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1211 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5304(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5304,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[205]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5311,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5322,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp);
/* for-each */
t7=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a5321 in set-signal-mask! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5322(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5322,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[205]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k5309 in set-signal-mask! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1204 posix-error */
t2=lf[3];
f_3485(5,t2,((C_word*)t0)[2],lf[206],lf[205],lf[207]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5286,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5296,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1190 h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixunix.scm: 1192 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k5294 in ##sys#interrupt-hook in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1191 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5273(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5273,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[204]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k5260 in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5264(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5264,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[203]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5217,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5221,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 1107 posix-error */
t3=lf[3];
f_3485(5,t3,t2,lf[48],lf[174],lf[175]);}
else{
t3=t2;
f_5221(2,t3,C_SCHEME_UNDEFINED);}}

/* k5219 in create-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1108 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_5197r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5197r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5197r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[173]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5201,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k5199 in with-output-to-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5201,2,t0,t1);}
t2=C_mutate((C_word*)lf[173]+1 /* (set! standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5207,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li71),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1095 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a5206 in k5199 in with-output-to-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5207(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_5207r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5207r(t0,t1,t2);}}

static void C_ccall f_5207r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5211,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1097 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k5209 in a5206 in k5199 in with-output-to-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[173]+1 /* (set! standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_5177r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5177r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5177r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[171]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5181,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k5179 in with-input-from-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5181(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5181,2,t0,t1);}
t2=C_mutate((C_word*)lf[171]+1 /* (set! standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5187,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li69),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1085 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a5186 in k5179 in with-input-from-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5187(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_5187r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5187r(t0,t1,t2);}}

static void C_ccall f_5187r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5191,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1087 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k5189 in a5186 in k5179 in with-input-from-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[171]+1 /* (set! standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5153(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_5153r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5153r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5153r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5157,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k5155 in call-with-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5157,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5162,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li66),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5168,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li67),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1075 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5167 in k5155 in call-with-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5168(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5168r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5168r(t0,t1,t2);}}

static void C_ccall f_5168r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5172,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1078 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k5170 in a5167 in k5155 in call-with-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a5161 in k5155 in call-with-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5162,2,t0,t1);}
/* posixunix.scm: 1076 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_5129r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5129r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5129r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5133,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k5131 in call-with-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5133,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5138,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li63),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5144,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li64),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1067 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5143 in k5131 in call-with-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5144(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5144r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5144r(t0,t1,t2);}}

static void C_ccall f_5144r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5148,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1070 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k5146 in a5143 in k5131 in call-with-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a5137 in k5131 in call-with-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5138,2,t0,t1);}
/* posixunix.scm: 1068 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5113(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5113,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5117,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1054 ##sys#check-port */
t4=*((C_word*)lf[166]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[163]);}

/* k5115 in close-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5117,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5120,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 1056 posix-error */
t5=lf[3];
f_3485(6,t5,t3,lf[48],lf[164],lf[165],((C_word*)t0)[3]);}
else{
t5=t3;
f_5120(2,t5,C_SCHEME_UNDEFINED);}}

/* k5118 in k5115 in close-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5120(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5077(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_5077r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5077r(t0,t1,t2,t3);}}

static void C_ccall f_5077r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[162]);
t5=f_5008(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5091,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[154]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5098,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1049 ##sys#make-c-string */
t9=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[161]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5108,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1050 ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1051 badmode */
f_5020(t6,t5);}}}

/* k5106 in open-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5108,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5091(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k5096 in open-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5098,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5091(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k5089 in open-output-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1045 check */
f_5026(((C_word*)t0)[3],lf[162],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5041(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_5041r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5041r(t0,t1,t2,t3);}}

static void C_ccall f_5041r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[160]);
t5=f_5008(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5055,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[154]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5062,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1038 ##sys#make-c-string */
t9=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[161]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5072,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1039 ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1040 badmode */
f_5020(t6,t5);}}}

/* k5070 in open-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5072,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5055(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k5060 in open-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5062,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5055(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k5053 in open-input-pipe in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1034 check */
f_5026(((C_word*)t0)[3],lf[160],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5026(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5026,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1026 posix-error */
t6=lf[3];
f_3485(6,t6,t1,lf[48],t2,lf[156],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5039,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1027 ##sys#make-port */
t7=*((C_word*)lf[157]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[158]+1),lf[159],lf[99]);}}

/* k5037 in check in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5020(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5020,NULL,2,t1,t2);}
/* posixunix.scm: 1023 ##sys#error */
t3=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[155],t2);}

/* mode in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_5008(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[154]));}

/* canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4691(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[25],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4691,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[139]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4698,a[2]=t1,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4812,a[2]=t4,a[3]=((C_word*)t0)[11],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 971  cwd */
t8=((C_word*)t0)[6];
f_4635(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4818,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[12],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[11],a[10]=t2,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4998,a[2]=((C_word*)t0)[12],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 973  sref */
t10=((C_word*)t0)[9];
((C_proc4)C_retrieve_proc(t10))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_4818(t9,C_SCHEME_FALSE);}}}

/* k4996 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 973  sep? */
t2=((C_word*)t0)[3];
f_4818(t2,f_4624(t1));}

/* k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4818(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4818,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[11];
f_4698(2,t2,((C_word*)t0)[10]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[10]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4831,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[11],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 976  cwd */
t5=((C_word*)t0)[8];
f_4635(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4837,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[9],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4973,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4984,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 977  sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[10],C_fix(0));}}}

/* k4982 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 977  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k4971 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4973,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4980,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 978  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_4837(t2,C_SCHEME_FALSE);}}

/* k4978 in k4971 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 978  sep? */
t2=((C_word*)t0)[3];
f_4837(t2,f_4624(t1));}

/* k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4837(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4837,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4844,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 980  get-environment-variable */
t3=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[151]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[9]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4875,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 985  cwd */
t5=((C_word*)t0)[6];
f_4635(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4881,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4945,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4966,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 986  sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[9],C_fix(0));}}}

/* k4964 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 986  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4943 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4945,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4951,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4962,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 987  sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_4881(t2,C_SCHEME_FALSE);}}

/* k4960 in k4943 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 987  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k4949 in k4943 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4951,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4958,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 988  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_4881(t2,C_SCHEME_FALSE);}}

/* k4956 in k4949 in k4943 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 988  sep? */
t2=((C_word*)t0)[3];
f_4881(t2,f_4624(t1));}

/* k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4881(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4881,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[9]);
/* posixunix.scm: 989  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4894,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4921,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4942,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 990  sref */
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[9],C_fix(0));}}

/* k4940 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4942(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 990  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k4919 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4921,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4927,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4938,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 991  sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_4894(2,t2,C_SCHEME_FALSE);}}

/* k4936 in k4919 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 991  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4925 in k4919 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4927,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4934,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 992  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_4894(2,t2,C_SCHEME_FALSE);}}

/* k4932 in k4925 in k4919 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 992  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k4892 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4894(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4894,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[7]);
/* posixunix.scm: 993  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4918,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 994  sref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[7],C_fix(0));}}

/* k4916 in k4892 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4918,2,t0,t1);}
t2=f_4624(t1);
if(C_truep(t2)){
t3=((C_word*)t0)[5];
f_4698(2,t3,((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4914,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 997  cwd */
t4=((C_word*)t0)[2];
f_4635(t4,t3);}}

/* k4912 in k4916 in k4892 in k4879 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 997  sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[153],((C_word*)t0)[2]);}

/* k4873 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 985  sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[152],((C_word*)t0)[2]);}

/* k4842 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4844,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4847,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;
f_4847(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4862,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 981  user */
t4=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}}

/* k4860 in k4842 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 981  sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[150],t1);}

/* k4845 in k4842 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4847,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4851,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 982  ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k4849 in k4845 in k4842 in k4835 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 979  sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4829 in k4816 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 976  sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[149],((C_word*)t0)[2]);}

/* k4810 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 971  sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[148]);}

/* k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4698,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4705,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=t1;
/* string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[112]+1)))(4,*((C_word*)lf[112]+1),t2,t3,lf[147]);}

/* k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4705,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4707,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word)li55),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4707(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4707(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4707,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4714,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1000 null? */
t5=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4714,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4720,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1001 null? */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4775,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4778,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[8],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_i_car(((C_word*)t0)[4]);
/* posixunix.scm: 1012 string=? */
t6=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,lf[146],t5);}}

/* k4776 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4778,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_4775(t2,(C_word)C_i_cdr(((C_word*)t0)[4]));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4787,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(((C_word*)t0)[3]);
/* posixunix.scm: 1014 string=? */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,lf[145],t3);}}

/* k4785 in k4776 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4787,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_4775(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_4775(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k4773 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4775(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1010 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4707(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4720(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4720,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[140]);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4756,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[3]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixunix.scm: 1003 sref */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,((C_word*)t0)[3],t4);}}

/* k4754 in k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4756,2,t0,t1);}
t2=f_4624(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4733,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4737,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_a_i_cons(&a,2,lf[142],((C_word*)t0)[2]);
/* posixunix.scm: 1006 reverse */
t6=*((C_word*)lf[143]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4748,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4752,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1009 reverse */
t5=*((C_word*)lf[143]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k4750 in k4754 in k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4752(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1009 isperse */
f_4619(((C_word*)t0)[2],t1);}

/* k4746 in k4754 in k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4748(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1007 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[144],t1);}

/* k4735 in k4754 in k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1006 isperse */
f_4619(((C_word*)t0)[2],t1);}

/* k4731 in k4754 in k4718 in k4712 in loop in k4703 in k4696 in canonical-path in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1004 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[141],t1);}

/* cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4635(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4635,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4642,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4644,a[2]=((C_word*)t0)[2],a[3]=((C_word)li53),tmp=(C_word)a,a+=4,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[138]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4644(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4644,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4650,a[2]=t2,a[3]=((C_word)li48),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4668,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li52),tmp=(C_word)a,a+=5,tmp);
/* with-exception-handler */
((C_proc4)C_retrieve_proc(*((C_word*)lf[137]+1)))(4,*((C_word*)lf[137]+1),t1,t3,t4);}

/* a4667 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4668,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4674,a[2]=((C_word*)t0)[3],a[3]=((C_word)li49),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4680,a[2]=((C_word*)t0)[2],a[3]=((C_word)li51),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t2,t3);}

/* a4679 in a4667 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4680(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4680r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4680r(t0,t1,t2);}}

static void C_ccall f_4680r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4686,a[2]=t2,a[3]=((C_word)li50),tmp=(C_word)a,a+=4,tmp);
/* k789795 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a4685 in a4679 in a4667 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4686,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a4673 in a4667 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4674,2,t0,t1);}
/* posixunix.scm: 966  cw */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a4649 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4650(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4650,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4656,a[2]=t2,a[3]=((C_word)li47),tmp=(C_word)a,a+=4,tmp);
/* k789795 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a4655 in a4649 in a4643 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4656,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[135]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[136]);}

/* k4640 in cwd in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* sep? in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_4624(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4619(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4619,NULL,2,t1,t2);}
/* string-intersperse */
((C_proc4)C_retrieve_proc(*((C_word*)lf[131]+1)))(4,*((C_word*)lf[131]+1),t1,t2,lf[132]);}

/* current-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4571(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4571r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4571r(t0,t1,t2);}}

static void C_ccall f_4571r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4575,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_4575(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_4575(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k4573 in current-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4575,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 945  change-directory */
t2=*((C_word*)lf[114]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4584,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 946  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k4582 in k4573 in current-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 949  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 950  posix-error */
t3=lf[3];
f_3485(5,t3,((C_word*)t0)[2],lf[48],lf[123],lf[126]);}}

/* directory? in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4548(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4548,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[124]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4555,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4569,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 938  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4567 in directory? in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 938  ##sys#file-info */
t2=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4553 in directory? in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4391(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr2r,(void*)f_4391r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4391r(t0,t1,t2);}}

static void C_ccall f_4391r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(13);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4393,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word)li39),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4491,a[2]=t3,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4496,a[2]=t4,a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec637694 */
t6=t5;
f_4496(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?638690 */
t8=t4;
f_4491(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body635644 */
t10=t3;
f_4393(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec637 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4496(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4496,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4504,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 911  current-directory */
t3=*((C_word*)lf[123]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4502 in def-spec637 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?638690 */
t2=((C_word*)t0)[3];
f_4491(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?638 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4491(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4491,NULL,3,t0,t1,t2);}
/* body635644 */
t3=((C_word*)t0)[2];
f_4393(t3,t1,t2,C_SCHEME_FALSE);}

/* body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4393(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4393,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[120]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4400,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 913  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4400(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4400,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4403,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 914  ##sys#make-pointer */
t3=*((C_word*)lf[122]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4403,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4406,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 915  ##sys#make-pointer */
t3=*((C_word*)lf[122]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4406,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4410,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4490,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 916  ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[5]);}

/* k4488 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 916  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4410,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[8]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[8]))){
/* posixunix.scm: 918  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[7],lf[48],lf[120],lf[121],((C_word*)t0)[6]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4424,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[8],a[8]=((C_word)li38),tmp=(C_word)a,a+=9,tmp));
t6=((C_word*)t4)[1];
f_4424(t6,((C_word*)t0)[7]);}}

/* loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4424(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4424,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[7],((C_word*)t0)[6]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[6]))){
t3=(C_word)C_closedir(((C_word*)t0)[7]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[6],((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4434,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 926  ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t3);}}

/* k4432 in loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4434,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4437,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 927  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,t1,C_fix(0));}

/* k4435 in k4432 in loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4437(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4437,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4440,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
/* posixunix.scm: 928  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[5],C_fix(1));}
else{
t3=t2;
f_4440(2,t3,C_SCHEME_FALSE);}}

/* k4438 in k4435 in k4432 in loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4440,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4446,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_make_character(46),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(C_word)C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_4446(t5,t4);}
else{
t5=(C_word)C_eqp(C_make_character(46),t1);
t6=(C_truep(t5)?(C_word)C_eqp(C_fix(2),((C_word*)t0)[3]):C_SCHEME_FALSE);
t7=t2;
f_4446(t7,(C_truep(t6)?t6:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t4=t2;
f_4446(t4,C_SCHEME_FALSE);}}

/* k4444 in k4438 in k4435 in k4432 in loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4446(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4446,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 933  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4424(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4456,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 934  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4424(t3,t2);}}

/* k4454 in k4444 in k4438 in k4435 in k4432 in loop in k4408 in k4404 in k4401 in k4398 in body635 in directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4456,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4367(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4367,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[116]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4385,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4389,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 904  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4387 in delete-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 904  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4383 in delete-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4385(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 905  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[116],lf[117],((C_word*)t0)[2]);}}

/* change-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4343(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4343,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[114]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4361,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4365,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 898  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4363 in change-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 898  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4359 in change-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 899  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[114],lf[115],((C_word*)t0)[2]);}}

/* create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4241(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4241r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4241r(t0,t1,t2,t3);}}

static void C_ccall f_4241r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4245,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_4245(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_4245(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4245,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[105]);
if(C_truep(t1)){
t3=((C_word*)t0)[3];
t4=lf[106];
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4256,a[2]=t5,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4308,a[2]=t6,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 886  string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[112]+1)))(4,*((C_word*)lf[112]+1),t7,t3,lf[113]);}
else{
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4322,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 862  ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t3);}}

/* k4320 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 863  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[105],lf[107],((C_word*)t0)[2]);}}

/* k4306 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* for-each */
t2=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4256(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4256,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4261,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 884  string-append */
t4=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[111],t2);}

/* k4259 in a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4261,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4267,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4284,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 867  file-exists? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[110]+1)))(3,*((C_word*)lf[110]+1),t5,t3);}

/* k4282 in k4259 in a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4284,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4304,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 868  ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_4267(2,t2,C_SCHEME_FALSE);}}

/* k4302 in k4282 in k4259 in a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_stat(t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 869  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[105],lf[108],((C_word*)t0)[2]);}
else{
t3=C_mk_bool(C_isdir);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
f_4267(2,t4,t3);}
else{
/* posixunix.scm: 872  posix-error */
t4=lf[3];
f_3485(6,t4,((C_word*)t0)[3],lf[48],lf[105],lf[109],((C_word*)t0)[2]);}}}

/* k4265 in k4259 in a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4267,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4281,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 862  ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k4279 in k4265 in k4259 in a4255 in k4243 in create-directory in k4237 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 863  posix-error */
t3=lf[3];
f_3485(6,t3,((C_word*)t0)[3],lf[48],lf[105],lf[107],((C_word*)t0)[2]);}}

/* set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_4179r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_4179r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4179r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[97]);
t8=(C_word)C_i_check_exact_2(t6,lf[97]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4192,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 836  ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[102],lf[97],lf[103],t3,t2);}
else{
t10=t9;
f_4192(2,t10,C_SCHEME_UNDEFINED);}}

/* k4190 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4192,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4198,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4204,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 837  port? */
t4=*((C_word*)lf[101]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k4202 in k4190 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[99]);
t4=((C_word*)t0)[4];
f_4198(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_4198(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 841  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[60],lf[97],lf[100],((C_word*)t0)[5]);}}}

/* k4196 in k4190 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 842  posix-error */
t2=lf[3];
f_3485(7,t2,((C_word*)t0)[4],lf[48],lf[97],lf[98],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* socket? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4169(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4169,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[95]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4176,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[95]);}

/* k4174 in socket? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_issock));}

/* f_4158 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4158,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[93]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4165,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 818  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[93]);}

/* k4163 */
static void C_ccall f_4165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isfifo));}

/* block-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4148,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4155,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 811  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[90]);}

/* k4153 in block-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isblk));}

/* character-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4138(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4138,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[88]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4145,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 804  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[88]);}

/* k4143 in character-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_ischr));}

/* stat-directory? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4129(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4129,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[87]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4136,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 799  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[87]);}

/* k4134 in stat-directory? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4136(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isdir));}

/* stat-regular? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4120(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4120,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[86]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4127,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 794  ##sys#stat */
f_3997(t4,t2,C_SCHEME_FALSE,lf[86]);}

/* k4125 in stat-regular? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* symbolic-link? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4111(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4111,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4118,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 789  ##sys#stat */
f_3997(t4,t2,C_SCHEME_TRUE,lf[85]);}

/* k4116 in symbolic-link? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4102(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4102,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[84]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4109,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 784  ##sys#stat */
f_3997(t4,t2,C_SCHEME_TRUE,lf[84]);}

/* k4107 in regular-file? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4096(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4096,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4100,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 780  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[83]);}

/* k4098 in file-permissions in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4090,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4094,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 779  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[82]);}

/* k4092 in file-owner in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4084(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4084,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4088,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 778  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[81]);}

/* k4086 in file-change-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4088,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4078(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4078,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4082,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 777  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[80]);}

/* k4080 in file-access-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4082,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4072(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4072,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4076,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 776  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[79]);}

/* k4074 in file-modification-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4076,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4066(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4066,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4070,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 775  ##sys#stat */
f_3997(t3,t2,C_SCHEME_FALSE,lf[78]);}

/* k4068 in file-size in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4070,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4034(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_4034r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4034r(t0,t1,t2,t3);}}

static void C_ccall f_4034r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4038,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4045,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_4045(2,t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_4045(2,t7,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t3);}}}

/* k4043 in file-stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 768  ##sys#stat */
f_3997(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[77]);}

/* k4036 in file-stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4038,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3997(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3997,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4001,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_4001(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4022,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4029,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 759  ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 763  ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[60],lf[76],t2);}}}

/* k4027 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 759  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4020 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_4001(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k3999 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4001(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 765  posix-error */
t2=lf[3];
f_3485(6,t2,((C_word*)t0)[4],lf[48],((C_word*)t0)[3],lf[75],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3805r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3805r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3805r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_3779(C_fix(0));
t10=f_3779(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3821,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_3821(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 688  fd_set */
t14=t12;
f_3821(2,t14,f_3785(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[68]);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3978,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=((C_word)li15),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t15=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a3977 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3978(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3978,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[68]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 695  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_3785(C_fix(0),t2));}

/* k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3821,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3827,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_3827(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 700  fd_set */
t5=t3;
f_3827(2,t5,f_3785(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[68]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3952,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word)li14),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t6=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a3951 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3952(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3952,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[68]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 707  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_3785(C_fix(1),t2));}

/* k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3827,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3830,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_number_2(((C_word*)t0)[3],lf[68]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_3830(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_3830(t4,(C_word)C_C_select(t3));}}

/* k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3830(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3830,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 714  posix-error */
t2=lf[3];
f_3485(7,t2,((C_word*)t0)[5],lf[48],lf[68],lf[69],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 715  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3869,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 720  fd_test */
t4=t3;
f_3869(t4,f_3795(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3910,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3912,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=((C_word)li13),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t8=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_3869(t4,C_SCHEME_FALSE);}}}}

/* a3911 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3912(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3912,3,t0,t1,t2);}
t3=f_3795(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k3908 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3869(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k3867 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3869(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3869,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3873,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 726  fd_test */
t3=t2;
f_3873(t3,f_3795(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3885,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3887,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=((C_word)li12),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t7=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_3873(t3,C_SCHEME_FALSE);}}

/* a3886 in k3867 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3887(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3887,3,t0,t1,t2);}
t3=f_3795(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k3883 in k3867 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3873(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k3871 in k3867 in k3828 in k3825 in k3819 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3873(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 717  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3795(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub252(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3785(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub245(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3779(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub239(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3747(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3747,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[65]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3754,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 666  ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3752 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3754(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3754,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3760,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 670  posix-error */
t6=lf[3];
f_3485(6,t6,t4,lf[48],lf[65],lf[67],((C_word*)t0)[2]);}
else{
t6=t4;
f_3760(2,t6,C_SCHEME_UNDEFINED);}}

/* k3758 in k3752 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3760,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3767,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 671  ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k3765 in k3758 in k3752 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3767(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 671  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3708(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3708r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3708r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3708r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[62]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3715,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_3715(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 655  ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[60],lf[62],lf[64],t3);}}

/* k3713 in file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3715,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[62]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3724,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 660  posix-error */
t8=lf[3];
f_3485(7,t8,t6,lf[48],lf[62],lf[63],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_3724(2,t8,C_SCHEME_UNDEFINED);}}

/* k3722 in k3713 in file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3666r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3666r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[58]);
t6=(C_word)C_i_check_exact_2(t3,lf[58]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3676,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_3676(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixunix.scm: 643  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k3674 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3676,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3679,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_3679(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 645  ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[60],lf[58],lf[61],t1);}}

/* k3677 in k3674 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3679,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3682,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 648  posix-error */
t5=lf[3];
f_3485(7,t5,t3,lf[48],lf[58],lf[59],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_3682(2,t5,C_SCHEME_UNDEFINED);}}

/* k3680 in k3677 in k3674 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3682,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3651(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3651,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[55]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 636  posix-error */
t4=lf[3];
f_3485(6,t4,t1,lf[48],lf[55],lf[56],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3613r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3613r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3613r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[51]);
t8=(C_word)C_i_check_exact_2(t3,lf[51]);
t9=(C_word)C_i_check_exact_2(t6,lf[51]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3630,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3643,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 627  ##sys#expand-home-path */
t12=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k3641 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3643(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 627  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3628 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3630,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3633,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 629  posix-error */
t5=lf[3];
f_3485(8,t5,t3,lf[48],lf[51],lf[52],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_3633(2,t5,C_SCHEME_UNDEFINED);}}

/* k3631 in k3628 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3567(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3567r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3567r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3567r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3571,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
t6=t5;
f_3571(2,t6,C_fix(0));}
else{
t6=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_3571(2,t7,(C_word)C_i_car(t4));}
else{
/* ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t4);}}}

/* k3569 in file-control in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[47]);
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[47]);
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[3];
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)C_i_foreign_fixnum_argumentp(t5);
t8=(C_word)C_i_foreign_integer_argumentp(t1);
t9=(C_word)stub124(C_SCHEME_UNDEFINED,t6,t7,t8);
t10=(C_word)C_eqp(t9,C_fix(-1));
if(C_truep(t10)){
/* posixunix.scm: 617  posix-error */
t11=lf[3];
f_3485(7,t11,((C_word*)t0)[2],lf[48],lf[47],lf[49],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t11=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t9);}}

/* ##sys#file-select-one in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3510(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3510,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub46(C_SCHEME_UNDEFINED,t3));}

/* ##sys#file-nonblocking! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3503(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3503,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub40(C_SCHEME_UNDEFINED,t3));}

/* posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3485(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_3485r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_3485r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_3485r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3489,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 507  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k3487 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3489,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3496,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3500,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub23(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k3498 in k3487 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 508  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k3494 in k3487 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[617] = {
{"toplevel:posixunix_scm",(void*)C_posix_toplevel},
{"f_3455:posixunix_scm",(void*)f_3455},
{"f_3458:posixunix_scm",(void*)f_3458},
{"f_3461:posixunix_scm",(void*)f_3461},
{"f_3464:posixunix_scm",(void*)f_3464},
{"f_3467:posixunix_scm",(void*)f_3467},
{"f_3470:posixunix_scm",(void*)f_3470},
{"f_3473:posixunix_scm",(void*)f_3473},
{"f_9373:posixunix_scm",(void*)f_9373},
{"f_9389:posixunix_scm",(void*)f_9389},
{"f_9377:posixunix_scm",(void*)f_9377},
{"f_9380:posixunix_scm",(void*)f_9380},
{"f_4239:posixunix_scm",(void*)f_4239},
{"f_5262:posixunix_scm",(void*)f_5262},
{"f_9367:posixunix_scm",(void*)f_9367},
{"f_5397:posixunix_scm",(void*)f_5397},
{"f_9352:posixunix_scm",(void*)f_9352},
{"f_9362:posixunix_scm",(void*)f_9362},
{"f_9349:posixunix_scm",(void*)f_9349},
{"f_5439:posixunix_scm",(void*)f_5439},
{"f_9334:posixunix_scm",(void*)f_9334},
{"f_9344:posixunix_scm",(void*)f_9344},
{"f_9331:posixunix_scm",(void*)f_9331},
{"f_5443:posixunix_scm",(void*)f_5443},
{"f_9316:posixunix_scm",(void*)f_9316},
{"f_9326:posixunix_scm",(void*)f_9326},
{"f_9313:posixunix_scm",(void*)f_9313},
{"f_5447:posixunix_scm",(void*)f_5447},
{"f_9298:posixunix_scm",(void*)f_9298},
{"f_9308:posixunix_scm",(void*)f_9308},
{"f_9295:posixunix_scm",(void*)f_9295},
{"f_5451:posixunix_scm",(void*)f_5451},
{"f_9274:posixunix_scm",(void*)f_9274},
{"f_9290:posixunix_scm",(void*)f_9290},
{"f_9256:posixunix_scm",(void*)f_9256},
{"f_9269:posixunix_scm",(void*)f_9269},
{"f_9263:posixunix_scm",(void*)f_9263},
{"f_5969:posixunix_scm",(void*)f_5969},
{"f_6008:posixunix_scm",(void*)f_6008},
{"f_9233:posixunix_scm",(void*)f_9233},
{"f_9225:posixunix_scm",(void*)f_9225},
{"f_8974:posixunix_scm",(void*)f_8974},
{"f_9151:posixunix_scm",(void*)f_9151},
{"f_9157:posixunix_scm",(void*)f_9157},
{"f_9146:posixunix_scm",(void*)f_9146},
{"f_9141:posixunix_scm",(void*)f_9141},
{"f_8976:posixunix_scm",(void*)f_8976},
{"f_9128:posixunix_scm",(void*)f_9128},
{"f_9136:posixunix_scm",(void*)f_9136},
{"f_8983:posixunix_scm",(void*)f_8983},
{"f_9116:posixunix_scm",(void*)f_9116},
{"f_9110:posixunix_scm",(void*)f_9110},
{"f_8993:posixunix_scm",(void*)f_8993},
{"f_8995:posixunix_scm",(void*)f_8995},
{"f_9014:posixunix_scm",(void*)f_9014},
{"f_9096:posixunix_scm",(void*)f_9096},
{"f_9103:posixunix_scm",(void*)f_9103},
{"f_9090:posixunix_scm",(void*)f_9090},
{"f_9029:posixunix_scm",(void*)f_9029},
{"f_9083:posixunix_scm",(void*)f_9083},
{"f_9080:posixunix_scm",(void*)f_9080},
{"f_9070:posixunix_scm",(void*)f_9070},
{"f_9046:posixunix_scm",(void*)f_9046},
{"f_9068:posixunix_scm",(void*)f_9068},
{"f_9054:posixunix_scm",(void*)f_9054},
{"f_9061:posixunix_scm",(void*)f_9061},
{"f_9058:posixunix_scm",(void*)f_9058},
{"f_9041:posixunix_scm",(void*)f_9041},
{"f_9039:posixunix_scm",(void*)f_9039},
{"f_9117:posixunix_scm",(void*)f_9117},
{"f_8914:posixunix_scm",(void*)f_8914},
{"f_8926:posixunix_scm",(void*)f_8926},
{"f_8921:posixunix_scm",(void*)f_8921},
{"f_8916:posixunix_scm",(void*)f_8916},
{"f_8854:posixunix_scm",(void*)f_8854},
{"f_8866:posixunix_scm",(void*)f_8866},
{"f_8861:posixunix_scm",(void*)f_8861},
{"f_8856:posixunix_scm",(void*)f_8856},
{"f_8793:posixunix_scm",(void*)f_8793},
{"f_8848:posixunix_scm",(void*)f_8848},
{"f_8852:posixunix_scm",(void*)f_8852},
{"f_8814:posixunix_scm",(void*)f_8814},
{"f_8817:posixunix_scm",(void*)f_8817},
{"f_8828:posixunix_scm",(void*)f_8828},
{"f_8822:posixunix_scm",(void*)f_8822},
{"f_8795:posixunix_scm",(void*)f_8795},
{"f_8804:posixunix_scm",(void*)f_8804},
{"f_8735:posixunix_scm",(void*)f_8735},
{"f_8747:posixunix_scm",(void*)f_8747},
{"f_8778:posixunix_scm",(void*)f_8778},
{"f_8758:posixunix_scm",(void*)f_8758},
{"f_8774:posixunix_scm",(void*)f_8774},
{"f_8762:posixunix_scm",(void*)f_8762},
{"f_8770:posixunix_scm",(void*)f_8770},
{"f_8766:posixunix_scm",(void*)f_8766},
{"f_8741:posixunix_scm",(void*)f_8741},
{"f_8724:posixunix_scm",(void*)f_8724},
{"f_8728:posixunix_scm",(void*)f_8728},
{"f_8713:posixunix_scm",(void*)f_8713},
{"f_8717:posixunix_scm",(void*)f_8717},
{"f_8668:posixunix_scm",(void*)f_8668},
{"f_8672:posixunix_scm",(void*)f_8672},
{"f_8675:posixunix_scm",(void*)f_8675},
{"f_8678:posixunix_scm",(void*)f_8678},
{"f_8691:posixunix_scm",(void*)f_8691},
{"f_8695:posixunix_scm",(void*)f_8695},
{"f_8698:posixunix_scm",(void*)f_8698},
{"f_8701:posixunix_scm",(void*)f_8701},
{"f_8689:posixunix_scm",(void*)f_8689},
{"f_8652:posixunix_scm",(void*)f_8652},
{"f_8635:posixunix_scm",(void*)f_8635},
{"f_8648:posixunix_scm",(void*)f_8648},
{"f_8560:posixunix_scm",(void*)f_8560},
{"f_8621:posixunix_scm",(void*)f_8621},
{"f_8634:posixunix_scm",(void*)f_8634},
{"f_8601:posixunix_scm",(void*)f_8601},
{"f_8616:posixunix_scm",(void*)f_8616},
{"f_8610:posixunix_scm",(void*)f_8610},
{"f_8564:posixunix_scm",(void*)f_8564},
{"f_8566:posixunix_scm",(void*)f_8566},
{"f_8587:posixunix_scm",(void*)f_8587},
{"f_8581:posixunix_scm",(void*)f_8581},
{"f_8508:posixunix_scm",(void*)f_8508},
{"f_8515:posixunix_scm",(void*)f_8515},
{"f_8534:posixunix_scm",(void*)f_8534},
{"f_8538:posixunix_scm",(void*)f_8538},
{"f_8502:posixunix_scm",(void*)f_8502},
{"f_8493:posixunix_scm",(void*)f_8493},
{"f_8497:posixunix_scm",(void*)f_8497},
{"f_8466:posixunix_scm",(void*)f_8466},
{"f_8459:posixunix_scm",(void*)f_8459},
{"f_8456:posixunix_scm",(void*)f_8456},
{"f_8453:posixunix_scm",(void*)f_8453},
{"f_8375:posixunix_scm",(void*)f_8375},
{"f_8411:posixunix_scm",(void*)f_8411},
{"f_8405:posixunix_scm",(void*)f_8405},
{"f_8358:posixunix_scm",(void*)f_8358},
{"f_8176:posixunix_scm",(void*)f_8176},
{"f_8310:posixunix_scm",(void*)f_8310},
{"f_8305:posixunix_scm",(void*)f_8305},
{"f_8178:posixunix_scm",(void*)f_8178},
{"f_8188:posixunix_scm",(void*)f_8188},
{"f_8196:posixunix_scm",(void*)f_8196},
{"f_8242:posixunix_scm",(void*)f_8242},
{"f_8209:posixunix_scm",(void*)f_8209},
{"f_8234:posixunix_scm",(void*)f_8234},
{"f_8212:posixunix_scm",(void*)f_8212},
{"f_8157:posixunix_scm",(void*)f_8157},
{"f_8138:posixunix_scm",(void*)f_8138},
{"f_8096:posixunix_scm",(void*)f_8096},
{"f_8118:posixunix_scm",(void*)f_8118},
{"f_8122:posixunix_scm",(void*)f_8122},
{"f_7987:posixunix_scm",(void*)f_7987},
{"f_7993:posixunix_scm",(void*)f_7993},
{"f_8014:posixunix_scm",(void*)f_8014},
{"f_8088:posixunix_scm",(void*)f_8088},
{"f_8018:posixunix_scm",(void*)f_8018},
{"f_8021:posixunix_scm",(void*)f_8021},
{"f_8028:posixunix_scm",(void*)f_8028},
{"f_8030:posixunix_scm",(void*)f_8030},
{"f_8047:posixunix_scm",(void*)f_8047},
{"f_8057:posixunix_scm",(void*)f_8057},
{"f_8061:posixunix_scm",(void*)f_8061},
{"f_8008:posixunix_scm",(void*)f_8008},
{"f_7975:posixunix_scm",(void*)f_7975},
{"f_7979:posixunix_scm",(void*)f_7979},
{"f_7982:posixunix_scm",(void*)f_7982},
{"f_7940:posixunix_scm",(void*)f_7940},
{"f_7944:posixunix_scm",(void*)f_7944},
{"f_7964:posixunix_scm",(void*)f_7964},
{"f_7968:posixunix_scm",(void*)f_7968},
{"f_7917:posixunix_scm",(void*)f_7917},
{"f_7921:posixunix_scm",(void*)f_7921},
{"f_7885:posixunix_scm",(void*)f_7885},
{"f_7889:posixunix_scm",(void*)f_7889},
{"f_7866:posixunix_scm",(void*)f_7866},
{"f_7870:posixunix_scm",(void*)f_7870},
{"f_7873:posixunix_scm",(void*)f_7873},
{"f_7807:posixunix_scm",(void*)f_7807},
{"f_7811:posixunix_scm",(void*)f_7811},
{"f_7817:posixunix_scm",(void*)f_7817},
{"f_7800:posixunix_scm",(void*)f_7800},
{"f_7784:posixunix_scm",(void*)f_7784},
{"f_7772:posixunix_scm",(void*)f_7772},
{"f_7757:posixunix_scm",(void*)f_7757},
{"f_7761:posixunix_scm",(void*)f_7761},
{"f_7742:posixunix_scm",(void*)f_7742},
{"f_7746:posixunix_scm",(void*)f_7746},
{"f_7696:posixunix_scm",(void*)f_7696},
{"f_7700:posixunix_scm",(void*)f_7700},
{"f_7713:posixunix_scm",(void*)f_7713},
{"f_7717:posixunix_scm",(void*)f_7717},
{"f_7627:posixunix_scm",(void*)f_7627},
{"f_7631:posixunix_scm",(void*)f_7631},
{"f_7634:posixunix_scm",(void*)f_7634},
{"f_7656:posixunix_scm",(void*)f_7656},
{"f_7653:posixunix_scm",(void*)f_7653},
{"f_7643:posixunix_scm",(void*)f_7643},
{"f_7591:posixunix_scm",(void*)f_7591},
{"f_7598:posixunix_scm",(void*)f_7598},
{"f_7572:posixunix_scm",(void*)f_7572},
{"f_7563:posixunix_scm",(void*)f_7563},
{"f_7544:posixunix_scm",(void*)f_7544},
{"f_7538:posixunix_scm",(void*)f_7538},
{"f_7529:posixunix_scm",(void*)f_7529},
{"f_7494:posixunix_scm",(void*)f_7494},
{"f_7432:posixunix_scm",(void*)f_7432},
{"f_7436:posixunix_scm",(void*)f_7436},
{"f_7442:posixunix_scm",(void*)f_7442},
{"f_7461:posixunix_scm",(void*)f_7461},
{"f_7448:posixunix_scm",(void*)f_7448},
{"f_7328:posixunix_scm",(void*)f_7328},
{"f_7334:posixunix_scm",(void*)f_7334},
{"f_7338:posixunix_scm",(void*)f_7338},
{"f_7346:posixunix_scm",(void*)f_7346},
{"f_7372:posixunix_scm",(void*)f_7372},
{"f_7376:posixunix_scm",(void*)f_7376},
{"f_7364:posixunix_scm",(void*)f_7364},
{"f_7308:posixunix_scm",(void*)f_7308},
{"f_7316:posixunix_scm",(void*)f_7316},
{"f_7291:posixunix_scm",(void*)f_7291},
{"f_7302:posixunix_scm",(void*)f_7302},
{"f_7306:posixunix_scm",(void*)f_7306},
{"f_7265:posixunix_scm",(void*)f_7265},
{"f_7289:posixunix_scm",(void*)f_7289},
{"f_7272:posixunix_scm",(void*)f_7272},
{"f_7222:posixunix_scm",(void*)f_7222},
{"f_7229:posixunix_scm",(void*)f_7229},
{"f_7250:posixunix_scm",(void*)f_7250},
{"f_7246:posixunix_scm",(void*)f_7246},
{"f_7194:posixunix_scm",(void*)f_7194},
{"f_7172:posixunix_scm",(void*)f_7172},
{"f_7176:posixunix_scm",(void*)f_7176},
{"f_7157:posixunix_scm",(void*)f_7157},
{"f_7161:posixunix_scm",(void*)f_7161},
{"f_7142:posixunix_scm",(void*)f_7142},
{"f_7146:posixunix_scm",(void*)f_7146},
{"f_7124:posixunix_scm",(void*)f_7124},
{"f_7050:posixunix_scm",(void*)f_7050},
{"f_7072:posixunix_scm",(void*)f_7072},
{"f_7078:posixunix_scm",(void*)f_7078},
{"f_7011:posixunix_scm",(void*)f_7011},
{"f_7039:posixunix_scm",(void*)f_7039},
{"f_7035:posixunix_scm",(void*)f_7035},
{"f_7028:posixunix_scm",(void*)f_7028},
{"f_6752:posixunix_scm",(void*)f_6752},
{"f_6948:posixunix_scm",(void*)f_6948},
{"f_6943:posixunix_scm",(void*)f_6943},
{"f_6938:posixunix_scm",(void*)f_6938},
{"f_6754:posixunix_scm",(void*)f_6754},
{"f_6758:posixunix_scm",(void*)f_6758},
{"f_6864:posixunix_scm",(void*)f_6864},
{"f_6865:posixunix_scm",(void*)f_6865},
{"f_6882:posixunix_scm",(void*)f_6882},
{"f_6892:posixunix_scm",(void*)f_6892},
{"f_6850:posixunix_scm",(void*)f_6850},
{"f_6806:posixunix_scm",(void*)f_6806},
{"f_6842:posixunix_scm",(void*)f_6842},
{"f_6821:posixunix_scm",(void*)f_6821},
{"f_6831:posixunix_scm",(void*)f_6831},
{"f_6815:posixunix_scm",(void*)f_6815},
{"f_6810:posixunix_scm",(void*)f_6810},
{"f_6813:posixunix_scm",(void*)f_6813},
{"f_6760:posixunix_scm",(void*)f_6760},
{"f_6795:posixunix_scm",(void*)f_6795},
{"f_6776:posixunix_scm",(void*)f_6776},
{"f_6270:posixunix_scm",(void*)f_6270},
{"f_6674:posixunix_scm",(void*)f_6674},
{"f_6669:posixunix_scm",(void*)f_6669},
{"f_6664:posixunix_scm",(void*)f_6664},
{"f_6659:posixunix_scm",(void*)f_6659},
{"f_6272:posixunix_scm",(void*)f_6272},
{"f_6276:posixunix_scm",(void*)f_6276},
{"f_6282:posixunix_scm",(void*)f_6282},
{"f_6532:posixunix_scm",(void*)f_6532},
{"f_6538:posixunix_scm",(void*)f_6538},
{"f_6634:posixunix_scm",(void*)f_6634},
{"f_6624:posixunix_scm",(void*)f_6624},
{"f_6618:posixunix_scm",(void*)f_6618},
{"f_6540:posixunix_scm",(void*)f_6540},
{"f_6590:posixunix_scm",(void*)f_6590},
{"f_6547:posixunix_scm",(void*)f_6547},
{"f_6557:posixunix_scm",(void*)f_6557},
{"f_6456:posixunix_scm",(void*)f_6456},
{"f_6464:posixunix_scm",(void*)f_6464},
{"f_6466:posixunix_scm",(void*)f_6466},
{"f_6514:posixunix_scm",(void*)f_6514},
{"f_6447:posixunix_scm",(void*)f_6447},
{"f_6451:posixunix_scm",(void*)f_6451},
{"f_6426:posixunix_scm",(void*)f_6426},
{"f_6436:posixunix_scm",(void*)f_6436},
{"f_6414:posixunix_scm",(void*)f_6414},
{"f_6401:posixunix_scm",(void*)f_6401},
{"f_6405:posixunix_scm",(void*)f_6405},
{"f_6396:posixunix_scm",(void*)f_6396},
{"f_6399:posixunix_scm",(void*)f_6399},
{"f_6314:posixunix_scm",(void*)f_6314},
{"f_6326:posixunix_scm",(void*)f_6326},
{"f_6363:posixunix_scm",(void*)f_6363},
{"f_6372:posixunix_scm",(void*)f_6372},
{"f_6366:posixunix_scm",(void*)f_6366},
{"f_6342:posixunix_scm",(void*)f_6342},
{"f_6345:posixunix_scm",(void*)f_6345},
{"f_6306:posixunix_scm",(void*)f_6306},
{"f_6283:posixunix_scm",(void*)f_6283},
{"f_6287:posixunix_scm",(void*)f_6287},
{"f_6243:posixunix_scm",(void*)f_6243},
{"f_6250:posixunix_scm",(void*)f_6250},
{"f_6253:posixunix_scm",(void*)f_6253},
{"f_6198:posixunix_scm",(void*)f_6198},
{"f_6202:posixunix_scm",(void*)f_6202},
{"f_6237:posixunix_scm",(void*)f_6237},
{"f_6220:posixunix_scm",(void*)f_6220},
{"f_6184:posixunix_scm",(void*)f_6184},
{"f_6196:posixunix_scm",(void*)f_6196},
{"f_6170:posixunix_scm",(void*)f_6170},
{"f_6182:posixunix_scm",(void*)f_6182},
{"f_6155:posixunix_scm",(void*)f_6155},
{"f_6168:posixunix_scm",(void*)f_6168},
{"f_6118:posixunix_scm",(void*)f_6118},
{"f_6126:posixunix_scm",(void*)f_6126},
{"f_6093:posixunix_scm",(void*)f_6093},
{"f_6074:posixunix_scm",(void*)f_6074},
{"f_6078:posixunix_scm",(void*)f_6078},
{"f_6009:posixunix_scm",(void*)f_6009},
{"f_6013:posixunix_scm",(void*)f_6013},
{"f_6048:posixunix_scm",(void*)f_6048},
{"f_6020:posixunix_scm",(void*)f_6020},
{"f_6023:posixunix_scm",(void*)f_6023},
{"f_6026:posixunix_scm",(void*)f_6026},
{"f_6032:posixunix_scm",(void*)f_6032},
{"f_5971:posixunix_scm",(void*)f_5971},
{"f_6004:posixunix_scm",(void*)f_6004},
{"f_5992:posixunix_scm",(void*)f_5992},
{"f_6000:posixunix_scm",(void*)f_6000},
{"f_5996:posixunix_scm",(void*)f_5996},
{"f_5952:posixunix_scm",(void*)f_5952},
{"f_5962:posixunix_scm",(void*)f_5962},
{"f_5956:posixunix_scm",(void*)f_5956},
{"f_5946:posixunix_scm",(void*)f_5946},
{"f_5940:posixunix_scm",(void*)f_5940},
{"f_5934:posixunix_scm",(void*)f_5934},
{"f_5910:posixunix_scm",(void*)f_5910},
{"f_5932:posixunix_scm",(void*)f_5932},
{"f_5928:posixunix_scm",(void*)f_5928},
{"f_5920:posixunix_scm",(void*)f_5920},
{"f_5880:posixunix_scm",(void*)f_5880},
{"f_5908:posixunix_scm",(void*)f_5908},
{"f_5904:posixunix_scm",(void*)f_5904},
{"f_5853:posixunix_scm",(void*)f_5853},
{"f_5878:posixunix_scm",(void*)f_5878},
{"f_5874:posixunix_scm",(void*)f_5874},
{"f_5789:posixunix_scm",(void*)f_5789},
{"f_5777:posixunix_scm",(void*)f_5777},
{"f_5805:posixunix_scm",(void*)f_5805},
{"f_5715:posixunix_scm",(void*)f_5715},
{"f_5719:posixunix_scm",(void*)f_5719},
{"f_5724:posixunix_scm",(void*)f_5724},
{"f_5740:posixunix_scm",(void*)f_5740},
{"f_5652:posixunix_scm",(void*)f_5652},
{"f_5710:posixunix_scm",(void*)f_5710},
{"f_5656:posixunix_scm",(void*)f_5656},
{"f_5659:posixunix_scm",(void*)f_5659},
{"f_5691:posixunix_scm",(void*)f_5691},
{"f_5662:posixunix_scm",(void*)f_5662},
{"f_5667:posixunix_scm",(void*)f_5667},
{"f_5681:posixunix_scm",(void*)f_5681},
{"f_5645:posixunix_scm",(void*)f_5645},
{"f_5559:posixunix_scm",(void*)f_5559},
{"f_5563:posixunix_scm",(void*)f_5563},
{"f_5617:posixunix_scm",(void*)f_5617},
{"f_5566:posixunix_scm",(void*)f_5566},
{"f_5576:posixunix_scm",(void*)f_5576},
{"f_5580:posixunix_scm",(void*)f_5580},
{"f_5589:posixunix_scm",(void*)f_5589},
{"f_5593:posixunix_scm",(void*)f_5593},
{"f_5603:posixunix_scm",(void*)f_5603},
{"f_5584:posixunix_scm",(void*)f_5584},
{"f_5534:posixunix_scm",(void*)f_5534},
{"f_5546:posixunix_scm",(void*)f_5546},
{"f_5542:posixunix_scm",(void*)f_5542},
{"f_5520:posixunix_scm",(void*)f_5520},
{"f_5532:posixunix_scm",(void*)f_5532},
{"f_5528:posixunix_scm",(void*)f_5528},
{"f_5453:posixunix_scm",(void*)f_5453},
{"f_5457:posixunix_scm",(void*)f_5457},
{"f_5499:posixunix_scm",(void*)f_5499},
{"f_5460:posixunix_scm",(void*)f_5460},
{"f_5470:posixunix_scm",(void*)f_5470},
{"f_5474:posixunix_scm",(void*)f_5474},
{"f_5478:posixunix_scm",(void*)f_5478},
{"f_5482:posixunix_scm",(void*)f_5482},
{"f_5486:posixunix_scm",(void*)f_5486},
{"f_5399:posixunix_scm",(void*)f_5399},
{"f_5432:posixunix_scm",(void*)f_5432},
{"f_5403:posixunix_scm",(void*)f_5403},
{"f_5410:posixunix_scm",(void*)f_5410},
{"f_5414:posixunix_scm",(void*)f_5414},
{"f_5418:posixunix_scm",(void*)f_5418},
{"f_5422:posixunix_scm",(void*)f_5422},
{"f_5426:posixunix_scm",(void*)f_5426},
{"f_5381:posixunix_scm",(void*)f_5381},
{"f_5366:posixunix_scm",(void*)f_5366},
{"f_5360:posixunix_scm",(void*)f_5360},
{"f_5328:posixunix_scm",(void*)f_5328},
{"f_5334:posixunix_scm",(void*)f_5334},
{"f_5304:posixunix_scm",(void*)f_5304},
{"f_5322:posixunix_scm",(void*)f_5322},
{"f_5311:posixunix_scm",(void*)f_5311},
{"f_5286:posixunix_scm",(void*)f_5286},
{"f_5296:posixunix_scm",(void*)f_5296},
{"f_5273:posixunix_scm",(void*)f_5273},
{"f_5264:posixunix_scm",(void*)f_5264},
{"f_5217:posixunix_scm",(void*)f_5217},
{"f_5221:posixunix_scm",(void*)f_5221},
{"f_5197:posixunix_scm",(void*)f_5197},
{"f_5201:posixunix_scm",(void*)f_5201},
{"f_5207:posixunix_scm",(void*)f_5207},
{"f_5211:posixunix_scm",(void*)f_5211},
{"f_5177:posixunix_scm",(void*)f_5177},
{"f_5181:posixunix_scm",(void*)f_5181},
{"f_5187:posixunix_scm",(void*)f_5187},
{"f_5191:posixunix_scm",(void*)f_5191},
{"f_5153:posixunix_scm",(void*)f_5153},
{"f_5157:posixunix_scm",(void*)f_5157},
{"f_5168:posixunix_scm",(void*)f_5168},
{"f_5172:posixunix_scm",(void*)f_5172},
{"f_5162:posixunix_scm",(void*)f_5162},
{"f_5129:posixunix_scm",(void*)f_5129},
{"f_5133:posixunix_scm",(void*)f_5133},
{"f_5144:posixunix_scm",(void*)f_5144},
{"f_5148:posixunix_scm",(void*)f_5148},
{"f_5138:posixunix_scm",(void*)f_5138},
{"f_5113:posixunix_scm",(void*)f_5113},
{"f_5117:posixunix_scm",(void*)f_5117},
{"f_5120:posixunix_scm",(void*)f_5120},
{"f_5077:posixunix_scm",(void*)f_5077},
{"f_5108:posixunix_scm",(void*)f_5108},
{"f_5098:posixunix_scm",(void*)f_5098},
{"f_5091:posixunix_scm",(void*)f_5091},
{"f_5041:posixunix_scm",(void*)f_5041},
{"f_5072:posixunix_scm",(void*)f_5072},
{"f_5062:posixunix_scm",(void*)f_5062},
{"f_5055:posixunix_scm",(void*)f_5055},
{"f_5026:posixunix_scm",(void*)f_5026},
{"f_5039:posixunix_scm",(void*)f_5039},
{"f_5020:posixunix_scm",(void*)f_5020},
{"f_5008:posixunix_scm",(void*)f_5008},
{"f_4691:posixunix_scm",(void*)f_4691},
{"f_4998:posixunix_scm",(void*)f_4998},
{"f_4818:posixunix_scm",(void*)f_4818},
{"f_4984:posixunix_scm",(void*)f_4984},
{"f_4973:posixunix_scm",(void*)f_4973},
{"f_4980:posixunix_scm",(void*)f_4980},
{"f_4837:posixunix_scm",(void*)f_4837},
{"f_4966:posixunix_scm",(void*)f_4966},
{"f_4945:posixunix_scm",(void*)f_4945},
{"f_4962:posixunix_scm",(void*)f_4962},
{"f_4951:posixunix_scm",(void*)f_4951},
{"f_4958:posixunix_scm",(void*)f_4958},
{"f_4881:posixunix_scm",(void*)f_4881},
{"f_4942:posixunix_scm",(void*)f_4942},
{"f_4921:posixunix_scm",(void*)f_4921},
{"f_4938:posixunix_scm",(void*)f_4938},
{"f_4927:posixunix_scm",(void*)f_4927},
{"f_4934:posixunix_scm",(void*)f_4934},
{"f_4894:posixunix_scm",(void*)f_4894},
{"f_4918:posixunix_scm",(void*)f_4918},
{"f_4914:posixunix_scm",(void*)f_4914},
{"f_4875:posixunix_scm",(void*)f_4875},
{"f_4844:posixunix_scm",(void*)f_4844},
{"f_4862:posixunix_scm",(void*)f_4862},
{"f_4847:posixunix_scm",(void*)f_4847},
{"f_4851:posixunix_scm",(void*)f_4851},
{"f_4831:posixunix_scm",(void*)f_4831},
{"f_4812:posixunix_scm",(void*)f_4812},
{"f_4698:posixunix_scm",(void*)f_4698},
{"f_4705:posixunix_scm",(void*)f_4705},
{"f_4707:posixunix_scm",(void*)f_4707},
{"f_4714:posixunix_scm",(void*)f_4714},
{"f_4778:posixunix_scm",(void*)f_4778},
{"f_4787:posixunix_scm",(void*)f_4787},
{"f_4775:posixunix_scm",(void*)f_4775},
{"f_4720:posixunix_scm",(void*)f_4720},
{"f_4756:posixunix_scm",(void*)f_4756},
{"f_4752:posixunix_scm",(void*)f_4752},
{"f_4748:posixunix_scm",(void*)f_4748},
{"f_4737:posixunix_scm",(void*)f_4737},
{"f_4733:posixunix_scm",(void*)f_4733},
{"f_4635:posixunix_scm",(void*)f_4635},
{"f_4644:posixunix_scm",(void*)f_4644},
{"f_4668:posixunix_scm",(void*)f_4668},
{"f_4680:posixunix_scm",(void*)f_4680},
{"f_4686:posixunix_scm",(void*)f_4686},
{"f_4674:posixunix_scm",(void*)f_4674},
{"f_4650:posixunix_scm",(void*)f_4650},
{"f_4656:posixunix_scm",(void*)f_4656},
{"f_4642:posixunix_scm",(void*)f_4642},
{"f_4624:posixunix_scm",(void*)f_4624},
{"f_4619:posixunix_scm",(void*)f_4619},
{"f_4571:posixunix_scm",(void*)f_4571},
{"f_4575:posixunix_scm",(void*)f_4575},
{"f_4584:posixunix_scm",(void*)f_4584},
{"f_4548:posixunix_scm",(void*)f_4548},
{"f_4569:posixunix_scm",(void*)f_4569},
{"f_4555:posixunix_scm",(void*)f_4555},
{"f_4391:posixunix_scm",(void*)f_4391},
{"f_4496:posixunix_scm",(void*)f_4496},
{"f_4504:posixunix_scm",(void*)f_4504},
{"f_4491:posixunix_scm",(void*)f_4491},
{"f_4393:posixunix_scm",(void*)f_4393},
{"f_4400:posixunix_scm",(void*)f_4400},
{"f_4403:posixunix_scm",(void*)f_4403},
{"f_4406:posixunix_scm",(void*)f_4406},
{"f_4490:posixunix_scm",(void*)f_4490},
{"f_4410:posixunix_scm",(void*)f_4410},
{"f_4424:posixunix_scm",(void*)f_4424},
{"f_4434:posixunix_scm",(void*)f_4434},
{"f_4437:posixunix_scm",(void*)f_4437},
{"f_4440:posixunix_scm",(void*)f_4440},
{"f_4446:posixunix_scm",(void*)f_4446},
{"f_4456:posixunix_scm",(void*)f_4456},
{"f_4367:posixunix_scm",(void*)f_4367},
{"f_4389:posixunix_scm",(void*)f_4389},
{"f_4385:posixunix_scm",(void*)f_4385},
{"f_4343:posixunix_scm",(void*)f_4343},
{"f_4365:posixunix_scm",(void*)f_4365},
{"f_4361:posixunix_scm",(void*)f_4361},
{"f_4241:posixunix_scm",(void*)f_4241},
{"f_4245:posixunix_scm",(void*)f_4245},
{"f_4322:posixunix_scm",(void*)f_4322},
{"f_4308:posixunix_scm",(void*)f_4308},
{"f_4256:posixunix_scm",(void*)f_4256},
{"f_4261:posixunix_scm",(void*)f_4261},
{"f_4284:posixunix_scm",(void*)f_4284},
{"f_4304:posixunix_scm",(void*)f_4304},
{"f_4267:posixunix_scm",(void*)f_4267},
{"f_4281:posixunix_scm",(void*)f_4281},
{"f_4179:posixunix_scm",(void*)f_4179},
{"f_4192:posixunix_scm",(void*)f_4192},
{"f_4204:posixunix_scm",(void*)f_4204},
{"f_4198:posixunix_scm",(void*)f_4198},
{"f_4169:posixunix_scm",(void*)f_4169},
{"f_4176:posixunix_scm",(void*)f_4176},
{"f_4158:posixunix_scm",(void*)f_4158},
{"f_4165:posixunix_scm",(void*)f_4165},
{"f_4148:posixunix_scm",(void*)f_4148},
{"f_4155:posixunix_scm",(void*)f_4155},
{"f_4138:posixunix_scm",(void*)f_4138},
{"f_4145:posixunix_scm",(void*)f_4145},
{"f_4129:posixunix_scm",(void*)f_4129},
{"f_4136:posixunix_scm",(void*)f_4136},
{"f_4120:posixunix_scm",(void*)f_4120},
{"f_4127:posixunix_scm",(void*)f_4127},
{"f_4111:posixunix_scm",(void*)f_4111},
{"f_4118:posixunix_scm",(void*)f_4118},
{"f_4102:posixunix_scm",(void*)f_4102},
{"f_4109:posixunix_scm",(void*)f_4109},
{"f_4096:posixunix_scm",(void*)f_4096},
{"f_4100:posixunix_scm",(void*)f_4100},
{"f_4090:posixunix_scm",(void*)f_4090},
{"f_4094:posixunix_scm",(void*)f_4094},
{"f_4084:posixunix_scm",(void*)f_4084},
{"f_4088:posixunix_scm",(void*)f_4088},
{"f_4078:posixunix_scm",(void*)f_4078},
{"f_4082:posixunix_scm",(void*)f_4082},
{"f_4072:posixunix_scm",(void*)f_4072},
{"f_4076:posixunix_scm",(void*)f_4076},
{"f_4066:posixunix_scm",(void*)f_4066},
{"f_4070:posixunix_scm",(void*)f_4070},
{"f_4034:posixunix_scm",(void*)f_4034},
{"f_4045:posixunix_scm",(void*)f_4045},
{"f_4038:posixunix_scm",(void*)f_4038},
{"f_3997:posixunix_scm",(void*)f_3997},
{"f_4029:posixunix_scm",(void*)f_4029},
{"f_4022:posixunix_scm",(void*)f_4022},
{"f_4001:posixunix_scm",(void*)f_4001},
{"f_3805:posixunix_scm",(void*)f_3805},
{"f_3978:posixunix_scm",(void*)f_3978},
{"f_3821:posixunix_scm",(void*)f_3821},
{"f_3952:posixunix_scm",(void*)f_3952},
{"f_3827:posixunix_scm",(void*)f_3827},
{"f_3830:posixunix_scm",(void*)f_3830},
{"f_3912:posixunix_scm",(void*)f_3912},
{"f_3910:posixunix_scm",(void*)f_3910},
{"f_3869:posixunix_scm",(void*)f_3869},
{"f_3887:posixunix_scm",(void*)f_3887},
{"f_3885:posixunix_scm",(void*)f_3885},
{"f_3873:posixunix_scm",(void*)f_3873},
{"f_3795:posixunix_scm",(void*)f_3795},
{"f_3785:posixunix_scm",(void*)f_3785},
{"f_3779:posixunix_scm",(void*)f_3779},
{"f_3747:posixunix_scm",(void*)f_3747},
{"f_3754:posixunix_scm",(void*)f_3754},
{"f_3760:posixunix_scm",(void*)f_3760},
{"f_3767:posixunix_scm",(void*)f_3767},
{"f_3708:posixunix_scm",(void*)f_3708},
{"f_3715:posixunix_scm",(void*)f_3715},
{"f_3724:posixunix_scm",(void*)f_3724},
{"f_3666:posixunix_scm",(void*)f_3666},
{"f_3676:posixunix_scm",(void*)f_3676},
{"f_3679:posixunix_scm",(void*)f_3679},
{"f_3682:posixunix_scm",(void*)f_3682},
{"f_3651:posixunix_scm",(void*)f_3651},
{"f_3613:posixunix_scm",(void*)f_3613},
{"f_3643:posixunix_scm",(void*)f_3643},
{"f_3630:posixunix_scm",(void*)f_3630},
{"f_3633:posixunix_scm",(void*)f_3633},
{"f_3567:posixunix_scm",(void*)f_3567},
{"f_3571:posixunix_scm",(void*)f_3571},
{"f_3510:posixunix_scm",(void*)f_3510},
{"f_3503:posixunix_scm",(void*)f_3503},
{"f_3485:posixunix_scm",(void*)f_3485},
{"f_3489:posixunix_scm",(void*)f_3489},
{"f_3500:posixunix_scm",(void*)f_3500},
{"f_3496:posixunix_scm",(void*)f_3496},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
