#!/bin/bash 
# install childsplay.  
# Be aware that childsplay probably won't work when you edit this file :-(
# As of 11/2004 childsplay will be converted to follow the File System
# Hierarchy (FSH).
# As a result it won't be possible to choose a install location and
# you just should let this script do his thing.
# However, you can change the "prefix" to "/usr" and childsplay will still
# work. Set it to anything else and your on your own.
  
PREFIX=/usr/local

#################################################################
# DON'T EDIT BEHIND THIS POINT 
#################################################################

if [ $1 ] && [ -e $1 ]
then PREFIX=$1
fi

LOCALEDIR=$PREFIX/share/locale
ASSETMLDIR=/usr/share/assetml
PYTHON=`which python`
SCOREDIR=/var/games
DOCDIR=$PREFIX/share/doc/childsplay
MANDIR=$PREFIX/man/man6
CPDIR=$PREFIX/lib/games/childsplay
SHAREDIR=$PREFIX/share/childsplay
BINDIR=$PREFIX/games
SHARELIBDATADIR=$SHAREDIR/lib
SHAREDATADIR=$SHAREDIR/Data

##################################################
#  Package text to be displayed as last step
# 0 = no readmes to display, 1 = there are readmes
README=1
# if README=1 then READMES=names of readmes in CWD
# like this READMES="README README2 README3"
READMES="README"
# Dependency, which version of childsplay at least
DEPEN=0.81.7
 
CWD=`pwd`

USERID=`id | sed -e 's/).*//; s/^.*(//;'`
if [ "$USERID" != "root" ]; then
    echo " You must be root to install the plugins"
    echo " exit"
    exit 1
fi

echo -e "\n>>>>>>>>>>> Install childsplay plugins >>>>>>>>>>>>>>>>>>>>"
echo -e "\n This release depends on childsplay version >= $DEPEN"
echo -n " Checking, version = "
#CP=`which childsplay`
CP=$BINDIR/childsplay
VERSION=$($CP --version)
echo $VERSION

if [ `expr $VERSION \< $DEPEN` -eq 1 ]                                          
then
    echo " Childsplay version incorrect, please upgrade to at least";           
    echo " version $DEPEN";                                                     
    echo "exit";                                                                
    exit 1                                                                      
fi                    

if [ ! -f $CP ]
then echo "############# Can\`t find childsplay ###########" && \
    echo "Be sure to install childsplay first" && \
    exit 1
fi

set -e

echo -e "\n The path to install the plugins in is $CPDIR."
echo " If you have installed childsplay in a other place, you can"
echo " give the full path to childsplay, otherwise just hit enter"
echo " Hit enter to install in $CPDIR, or give the full path"
read path
if [ $path ];then
    if [ -e $path/install.py ];then
        CPDIR=path
    else
        echo "*********** WARNING *************"
        echo " $path does not exists or is not the childsplay directory"
        echo " exit"
        exit 1
    fi
fi
echo " Installing in $CPDIR"

echo "Compiling modules to bytecode..."
$PYTHON $CPDIR/install.py --compile $CWD/lib

echo " Copy libraries"
for DIR in `ls $CWD/lib`
do 
    if [ -d $CWD/lib/$DIR ]
	 then cp -rf $CWD/lib/$DIR $SHARELIBDATADIR
	 else cp -f $CWD/lib/$DIR $CPDIR/lib
    fi
done

echo " Copy misc. data files"
cp -rf $CWD/Data/*.icon.png $SHAREDATADIR/icons/

echo " Copy assetml files"
cp -rf $CWD/assetml/* $ASSETMLDIR

echo -e "\n Everything installed, enjoy\n"
echo -e "\n***************** IMPORTANT *************************"
echo "If you find any bugs please put any output in a email"
echo "And send it to: childsplay@users.sourceforge.net."
echo "BUG REPORTS ARE THE MOST IMPORTANT THINGS YOU CAN DO"
echo ""
echo "Example of a bug report:"
echo "Hello,"
echo "I did 'childsplay [enter]' and then this happend:"
echo "Traceback (most recent call last):"
echo "  File \"<pyshell#2>\", line 1, in ?"
echo "    My_feelings = i_get_sick()"
echo "NameError: name 'i_get_sick' is not defined"
echo ""
echo -e "That's all you have to do.\n"

if [ $README == 1 ];then
    echo " Read the README's (if any) that came with these packages,"
    echo " they contains directions on how to translate some"
    echo " text files used by the games in your own language"
    echo -e "\nHit any key to read the readme(s), enter to quit"
    read key
    if [ $key ];then
        for name in $READMES;do
            cat $name >> chplREADMEScat
        done
        `which more` chplREADMEScat
        rm chplREADMEScat
    fi
fi

echo ""
echo "***********************************************************************"
echo "  Childsplay and some of the games it contains uses"
echo "  configuration files."
echo "  You can find these files in the dot directory called '.childsplay'"
echo "  in your home directory."
echo "***********************************************************************"
echo "  Enjoy childsplay :-)"
echo ""

