/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
###
*/

#define N_KEYS	71

#define KEY_WIDTH	30
#define KEY_HEIGHT	30
#define KEY_XOFF	5
#define KEY_YOFF	5

#define KEYBOARD_ENGLISH        0
#define KEYBOARD_GERMAN         1

#define KEYBOARD_DEFAULT	KEYBOARD_ENGLISH


typedef struct _vk_keyboard {
	unsigned char *language;	//language name
	unsigned char *locale;		//locale name for the encoding
	unsigned char *normal_keys;	//keys 58
	unsigned char *shift_keys;	//shift 58
	unsigned char *alt_keys;	//alt-ed keys
	unsigned char *font_name;	//xfont name
	Bool flag_capslock;		//CapsLock on?
	Bool flag_shift;		//shift pressed?
	Bool flag_control;		//control pressed?
	Bool flag_alt;			//alt pressed?
} vk_keyboard;


typedef struct _vk_keys {
	unsigned char c;		//character
	unsigned char f;		//shift char
	unsigned char a;		//alted char
	unsigned long s;		//X key symbol
	int x;				//position and size
	int y;
	int w;
	int h;
} vk_keys;



