/*
 * br_messages.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  @file br_messages.hpp
  
  For messages from the ./br_core scope (Br2HdrManager), which should be presented
   on the GUI screen in a modal window (if possible), we provide some global 
   function pointers. Per default they are directed here to functions which
   output on stderr. In the GUI layer (../gui/br_messages_gui.cpp) they are
   redirected to appropriate GUI functions. 
  Alternatives? (1) Virtual message functions in Br2HdrManager with overwriting
   in a class Br2HdrManagerGUI. Long-winded. And the functions could not be 
   used outside of Br2HdrManager. (2)...
*/
#ifndef br_messages_hpp
#define br_messages_hpp


namespace br {

#define ERROR_MSG(args)   {fprintf(stderr, "\nBr2Hdr-ERROR ***: [%s:%d] %s():\n",__FILE__,__LINE__,__func__);\
                           e_printf args;}

void e_printf (const char *fmt, ...);

void core_msg_alert (const char* text);
void core_msg_message (const char* text);

typedef void (*MsgFuncAlert) (const char* text);
typedef void (*MsgFuncMessage) (const char* text);
typedef void (*FmtMsgFuncAlert) (const char* fmt, ...);
typedef void (*FmtMsgFuncMessage) (const char* fmt, ...);

extern MsgFuncAlert       alert;        ///< output a simple string
extern MsgFuncMessage     message;      ///< output a simple string
extern FmtMsgFuncAlert    v_alert;      ///< output a formated string (va_arg list)
extern FmtMsgFuncMessage  v_message;    ///< output a formated string (va_arg list)
                         
}  // namespace "br"

#endif  // br_messsages_hpp

// END OF FILE
