Summary: CIPE - encrypted IP over UDP tunneling
Name: cipe
Version: 1.5.4
Release: 1
Copyright: GPL
Group: System Environment/Daemons
Source: http://sites.inka.de/bigred/sw/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-root

%description
CIPE (the name is shortened from *Crypto IP Encapsulation*) is a
package for an encrypting IP tunnel device. This can be used to build
encrypting routers for VPN (Virtual Private Networks) and similar
applications.

%prep
%setup -q
./configure --prefix=/usr

%build
make

%install
rm -rf $RPM_BUILD_ROOT
%define kversion `uname -r`

make install BINDIR=$RPM_BUILD_ROOT/usr/sbin INFODIR=$RPM_BUILD_ROOT/usr/info \
     MODDIR=$RPM_BUILD_ROOT/lib/modules/%{kversion}/misc \
     sbindir=$RPM_BUILD_ROOT/usr/sbin bindir=$RPM_BUILD_ROOT/usr/bin
gzip $RPM_BUILD_ROOT/usr/info/cipe.info

%post
depmod -a
install-info --info-file=/usr/info/cipe.info.gz \
	     --dir-file=/usr/info/dir \
             --item="* cipe: (cipe)cipe.        CIPE - encrypted IP over UDP tunneling"


%preun
install-info --delete \
	     --info-file=/usr/info/cipe.info.gz \
	     --dir-file=/usr/info/dir \
             --item="* cipe: (cipe)cipe.        CIPE - encrypted IP over UDP tunneling"

%postun
depmod -a

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc COPYING CHANGES README README.key-bug tcpdump.patch samples
/usr/info/cipe.info.gz
/usr/sbin/ciped-cb
/usr/sbin/pkcipe
/usr/bin/rsa-keygen
/lib/modules/*/misc/cipcb.o

%changelog
* Sat Dec 16 2000 Olaf Titz <olaf@bigred.inka.de>
- integrated pkcipe

* Fri Jul 21 2000 Mirko Zeibig <mz@webideal.de>
- created spec-file
