/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: dsprintf.c,v 1.1 2000/11/30 22:12:41 olaf Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include "cipelib.h"

#define INITCHUNK 32
#define CHUNK 64

char *dsprintf(const char *fmt, ...)
{
    va_list v;
    int l=strlen(fmt)+INITCHUNK, i;
    char *r=malloc(l);

    while (r) {
	va_start(v, fmt);
	i=vsnprintf(r, l, fmt, v);
	va_end(v);
	if (i<0)
	    l+=CHUNK;
	else if (i>=l)
	    i=l+1;
	else
	    break;
	r=realloc(r, i);
    }
    return r;
}
