use strict;
use warnings;
use Module::Build::CipUX;

my $builder = Module::Build::CipUX->new(
    module_name       => 'CipUX',
    license           => 'gpl',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version_from => 'lib/CipUX.pm',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic' => 0,
        'POD::Spell'         => 0,
        'Readonly::XS'       => 0,
    },

    build_requires => {
        'Test::LeakTrace'      => 0,
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
        'Test::Pod::Coverage'  => '1.04',
        'Test::Refcount'       => 0,
        'Module::Build::CipUX' => '0.3.0',
    },

    requires => {
        'Array::Unique'   => 0,
        'Carp'            => 0,
        'Class::Std'      => '0.0.9',
        'Config::Any'     => 0,
        'Config::Tiny'    => 0,
        'Data::Dumper'    => 0,
        'Date::Manip'     => 0,
        'English'         => 0,
        'File::Basename'  => 0,
        'File::Glob'      => 0,
        'File::Path'      => 2.06,
        'Hash::Merge'     => 0,
        'Log::Log4perl'   => '0.42',
        'Pod::Usage'      => 0,
        'Readonly'        => 0,
        'Storable'        => 0,
        'Term::ReadKey'   => 0,
        'Unicode::String' => 0,
        'version'         => 0,
        'YAML::Any'       => 0,
    },

    add_to_cleanup => ['CipUX-*'],
);

$builder->create_build_script();

