#include "cp_types.h"
#include "cp_proto.h"

/* read string of node pairs into linked list, endptr=NULL or 
pts to inappropriate char, if such is encountered or odd number 
of nodes is listed. hits=0 ==> no expressions parsed. */

struct Edgelist *Node_pair_link(struct p_data *p,char *dpoint,
				char **endptr,int *hits,
				 struct Vertlist **Vlist,
				 struct Edgelist **Elist,
				struct Vertlist **Flist,
				 Region *region,struct Pathlist *pathlist,
				 int pathlength)
{
  int count,nextvert,stopvert,v1,v2,i,j,k,v,hts;
  char next[256],next2[256],*nextptr,*lastptr;
  struct K_data *pK_ptr;
  struct Edgelist *edgelist=NULL,*trace,*clobber;
  struct Vertlist *vertlist=NULL,*facelist=NULL,*vtrace;

  pK_ptr=p->packK_ptr;
  stripsp(dpoint);
  nextptr=lastptr=dpoint;
  *endptr=NULL;
  count=*hits=0;
  if (*nextptr == '\0' || !grab_next(&nextptr,next) ) return NULL;
  edgelist=(struct Edgelist *)malloc(sizeof(struct Edgelist));
  edgelist->next=NULL;
  trace=edgelist;
  clobber=trace;
  do
    {
      lastptr += notspace(lastptr);
      if (next[0]=='a') /* do all edges */
	{
	  for (i=1;i<p->nodecount;i++) 
	    for (j=0;j<=pK_ptr[i].num;j++)
	      if ((k=pK_ptr[i].flower[j])>i)
		{
		  trace->v=i;trace->w=k;
		  trace->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	}
      else if (next[0]=='b') /* all boundary edges */
	{
	  lastptr++;
	  for (j=1;j<=p->num_bdry_comp;j++)
	    {
	      v1=stopvert=p->bdry_starts[j];
	      nextvert=pK_ptr[v1].flower[0];
	      trace->v=v1;trace->w=nextvert;
	      trace->next=(struct Edgelist *)
		calloc((size_t)1,sizeof(struct Edgelist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	      do
		{
		  v1=nextvert;
		  nextvert=pK_ptr[v1].flower[0];
		  trace->v=v1;trace->w=nextvert;
		  trace->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	      while (nextvert!=stopvert);
	    }
	}
      else if (strncmp(next+1,"list",4)==0) /* use elist */
	{
	  struct Edgelist *elptr=NULL,*ceptr=NULL;
	  if (((*next=='E' && (ceptr=*(Elist) )) 
	       || (*next=='e' && (ceptr=p->elist)))
	      && *(next+5)=='[')
	    {
	      if (*(next+6)=='r') /* rotate list */
		{
		  elptr=ceptr;
		  while (elptr && elptr->next) elptr=elptr->next;
		  elptr->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  elptr->next->v=ceptr->v;
		  elptr->next->w=ceptr->w;
		}
	      if (*(next+6)=='n' || *(next+6)=='r')
		{
		  consume_one_edge(&ceptr,&v1,&v2);
		  if (*next=='E') (*Elist)=ceptr;
		  else p->elist=ceptr;
		}
	      else if (sscanf(next+5,"[%d]",&j) && j>=0)
		{
		  elptr=ceptr;
		  while (j-- > 1 && elptr->next)
		    elptr=elptr->next;
		  if (j==0 && elptr)
		    {
		      v1=elptr->v;
		      v2=elptr->w;
		    }
		  else v1=0;
		}
	      else v1=0;
	      if (v1>0 && v1<=p->nodecount 
		  && v2>0 && v2<=p->nodecount ) 
		{
		  trace->v=v1;trace->w=v2;
		  trace->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}	
	      elptr=(struct Edgelist *)NULL;
	    }
	  else if (*next=='E') elptr=(*Elist); /* adjoint Elist */
	  else if (*next=='e') elptr=p->elist; /* adjoint pack elist */
	  while (elptr && (v1=elptr->v)>0 && v1<=p->nodecount
		 && (v2=elptr->w)>0 && v2<=p->nodecount)
	    {
	      trace->v=v1;trace->w=v2;
	      trace->next=(struct Edgelist *)
		calloc((size_t)1,sizeof(struct Edgelist));
	      clobber=trace;
	      trace=trace->next;
	      elptr=elptr->next;
	      count++;
	    }
	}
 /* oriented, closed lists of edges bounding given faces: Caution: 
    assumes rest of data string specifies verts; resets nextptr. */      
      else if (next[0]=='f')
	{
	  lastptr++;
	  if ((facelist=Face_link_parse(p,lastptr,endptr,&hts,Vlist,
					Elist,Flist,region,pathlist,
					pathlength)))
	    {
	      nextptr=*endptr;
	      vtrace=facelist;
	      while(vtrace)
		{
		  for (j=0;j<3;j++)
		    {
		      v1=p->faces[vtrace->v].vert[j];
		      v2=p->faces[vtrace->v].vert[(j+1)%3];
		      trace->v=v1;trace->w=v2;
		      trace->next=(struct Edgelist *)
			calloc((size_t)1,sizeof(struct Edgelist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }
		  vtrace=vtrace->next;
		}
	      vert_free(&facelist);
	    }
	}

/* attempt to make edgelist from raw vert list (ie., not listed
   in pairs); little attempt to avoid duplication. Caution: assumes 
   rest of data string specifies verts;	resets nextptr. */      
      else if (next[0]=='e') 
	{
	  lastptr++;
	  if ((vertlist=Node_link_parse(p,lastptr,endptr,&hts,
					Vlist,Elist,Flist,
					region,pathlist,pathlength)))
	    {
	      nextptr=*endptr;
	      vtrace=vertlist;
	      while(vtrace && vtrace->next)
		{
		  v1=vtrace->v;
		  v2=vtrace->next->v;
		  if ((v1!=v2) && nghb(p,v1,v2)>=0)
		    {
		      trace->v=v1;trace->w=v2;
		      trace->next=(struct Edgelist *)
			calloc((size_t)1,sizeof(struct Edgelist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }
		  vtrace=vtrace->next;
		}
	      vert_free(&vertlist);
	    }
	}
      else if (next[0]=='m') /* all with both ends marked */
	{
	  lastptr++;
	  for (j=1;j<p->nodecount;j++)
	    if (pK_ptr[j].mark) 
	      for (k=0;k<=pK_ptr[j].num;k++)
		if (pK_ptr[(v=pK_ptr[j].flower[k])].mark
		    && v>j)
		  {
		    trace->v=j;trace->w=v;
		    trace->next=(struct Edgelist *)
		      calloc((size_t)1,sizeof(struct Edgelist));
		    clobber=trace;
		    trace=trace->next;
		    count++;
		  }
	}
      else if (sscanf(next,"%d",&v1)  
	       && v1>0 && v1<=p->nodecount
	       && grab_next(&nextptr,next2)
	       && sscanf(next2,"%d",&v2) 
	       && v2>0 && v2<=p->nodecount)
	/* removed restriction that they're nghbs: && nghb(p,v1,v2)!=-1) */
	/* just regular edge pair */
	{
	  trace->v=v1;trace->w=v2;
	  trace->next=(struct Edgelist *)
	    calloc((size_t)1,sizeof(struct Edgelist));
	  clobber=trace;
	  trace=trace->next;
	  count++;
	}
      else goto E_GETOUT;   /* inappropriate entry */

      stripsp(nextptr);
      lastptr=nextptr;
    }
  while (*nextptr!='-' && grab_next(&nextptr,next) );
  *endptr=nextptr;
 E_GETOUT: /* clean up and leave */
  *hits=count;
  if (trace!=clobber) 
    {
      clobber->next=NULL; /* clobber should be last valid data */
      free(trace);trace=NULL;
    }
  if (!count) /* no data; should have trace=clobber=vertlist */
    {
      free(trace);
      return NULL;
    } 
  return edgelist;
} /* Node_pair_link */
