#include "cp_types.h"
#include "cp_proto.h"

/* adjoin the pack p2 to p1, starting with
vertex v2 of p2 to vertex v1 of p1, and proceeding n additional vertices
about the boundary of p1 in the negative (clockwise) direction. Put
results in p1. If p1!=p2, then p2 should remain unchanged.
return 1 if successful. Lose overlap data. oldnew returns
conversions of indices for possible use. */

int adjoin(struct p_data *p1,struct p_data *p2,
	   int v1,int v2,int n,int **Oldnew)
{
  int i,ii,jj,j,k,kk,ll,m,mm,nn,node,newnode,endvertex,endnode;
  int b1,b2,count,dist,w,indx;
  int next,v,old_vert,new_vert;
  int *oldnew=NULL,*oldnewflag=NULL,*newflower;
  struct K_data *pK_ptr1,*pK_ptr2;
  struct R_data *pR_ptr1,*pR_ptr2;

  pK_ptr2=p2->packK_ptr;pR_ptr2=p2->packR_ptr;
  pK_ptr1=p1->packK_ptr;pR_ptr1=p1->packR_ptr;
  if 
    ( !p1->status
      || !p2->status
      || n<1 || v1<=0 || v2<=0 
      || v1>p1->nodecount || v2>p2->nodecount
      || (b1=bdry_comp_count(p1,v1))<n
      || (b2=bdry_comp_count(p2,v2))<n
      || p1->locks
      )
    return 0;
  /* overlaps are saved before adjoin and reset after. */
  free_overlaps(p1); 
  if (p1!=p2) /* procedure for adjoining distinct packs */
    {
      oldnew=(int *)calloc((size_t)(p2->nodecount+2),sizeof(int));
      oldnewflag=(int *)calloc((size_t)(p2->nodecount+2),sizeof(int));

      /* store new indices */
      node=v1;
      newnode=v2;
      for (i=1;i<=n;i++)
	{
	  oldnewflag[newnode]=1;
	  oldnew[newnode]=node;
	  node=pK_ptr1[node].flower[pK_ptr1[node].num];
	  newnode=pK_ptr2[newnode].flower[0];
	}
      endvertex=newnode; 	/* last p2 vertex */
      endnode=node; 		/* last p1 vertex */
      if (b2>n) 
	{
	  oldnewflag[endvertex]=1;
	  oldnew[endvertex]=endnode;
	}
		
      /* get rest of new indices */
      newnode=p1->nodecount+1;
      for (i=1;i<=p2->nodecount;i++)
	if (!oldnewflag[i])
	  {oldnew[i]=newnode;newnode++;}
      if (!alloc_pack_space(p1,newnode+2,1)) return 0;
      pK_ptr1=p1->packK_ptr;pR_ptr1=p1->packR_ptr; /* updata ptr's */
      p1->nodecount=newnode-1;

      /* fix up flowers */

      for (i=1;i<=p2->nodecount;i++)
	{
	  j=oldnew[i];

	  if (i==endvertex)  /* special measures for last vertex */
	    {
	      if ((b1 > n) && (b2 > n)) 
				/* flower begins with nghbs in p2 */
		{
		  ll=pK_ptr2[i].num;
		  m=pK_ptr1[j].num;
		  newflower=(int *)calloc((size_t)(ll+m+1),sizeof(int));
		  for (k=1;k<=m;k++) 
		    newflower[ll+m-k+1]=
		      pK_ptr1[j].flower[m-k+1];
		  for (k=0;k<=ll;k++) 
		    newflower[k]=
		      oldnew[pK_ptr2[i].flower[k]]; 
		  free(pK_ptr1[j].flower);
		  pK_ptr1[j].flower=newflower;
		  pK_ptr1[j].num=ll+m;
		}
	      else if ((b1==n) && (b2>n)) 
				/* identify endnode and v1 in p1;
				   use parts of three flowers;
				   endnode to be deleted later. */
		{
		  for (ii=0;ii<=pK_ptr1[endnode].num;ii++)
				/* remove references to endnode in p1 */
		    {
		      w=pK_ptr1[endnode].flower[ii];
		      indx=nghb(p1,w,node);
		      if (indx==0 && !pK_ptr1[w].bdry_flag)
			pK_ptr1[w].flower[0]=
			  pK_ptr1[w].flower[pK_ptr1[w].num]=v1;
		      else if (indx>=0) pK_ptr1[w].flower[indx]=v1;
		    }
		  ll=pK_ptr2[endvertex].num;
		  mm=pK_ptr1[v1].num;
		  nn=pK_ptr2[v2].num;
		  newflower=(int *)calloc((size_t)(ll+mm+nn+1),
					  sizeof(int));
		  for (k=0;k<ll;k++)
		    newflower[k]=oldnew[pK_ptr2[endvertex].flower[k]];
		  for (k=ll;k<=(ll+mm);k++)
		    newflower[k]=pK_ptr1[v1].flower[k-ll];
		  for (k=(ll+mm+1);k<=(ll+mm+nn);k++)
		    newflower[k]=oldnew[pK_ptr2[v2].flower[ll+mm-k]];
		  free(pK_ptr1[v1].flower);
		  pK_ptr1[v1].flower=newflower;
		  pK_ptr1[v1].num=ll+mm+nn;
		}
	      else if (b1==n && b2==n)
				/* whole bdrys; all become interior */
		{
		  ll=pK_ptr2[v2].num;
		  mm=pK_ptr1[v1].num;
		  newflower=(int *)calloc((size_t)(ll+mm+1),
					  sizeof(int));
		  for (k=0;k<ll;k++)
		    newflower[k]=oldnew[pK_ptr2[v2].flower[k]];
		  for (k=ll;k<=(ll+mm);k++)
		    newflower[k]=pK_ptr1[v1].flower[k-ll];
		  free(pK_ptr1[v1].flower);
		  pK_ptr1[v1].flower=newflower;
		  pK_ptr1[v1].num=ll+mm;
		}
	    }

	  /* rest of flowers are more routine */

	  else if (oldnewflag[i])
	    {
	      ll=pK_ptr2[i].num;
	      mm=pK_ptr1[j].num;
	      newflower=(int *)calloc((size_t)(ll+mm+1),
				      sizeof(int));
	      for (k=0;k<=mm;k++)
		newflower[k]=pK_ptr1[j].flower[k];
	      for (k=mm+1;k<=ll+mm;k++)
		newflower[k]=oldnew[pK_ptr2[i].flower[k-mm]];
	      if (j>p1->nodecount) free(pK_ptr1[j].flower);
	      pK_ptr1[j].flower=newflower;
	      pK_ptr1[j].num = ll+mm;
	    }
	  else
	    {
	      pR_ptr1[j].center=pR_ptr2[i].center;
	      pR_ptr1[j].rad=pR_ptr2[i].rad;
	      pK_ptr1[j].num=pK_ptr2[i].num;
	      newflower=(int *)
		calloc((size_t)(pK_ptr2[i].num+1),sizeof(int));
	      for (k=0;k<=pK_ptr2[i].num;k++)
		newflower[k]=
		  oldnew[pK_ptr2[i].flower[k]];
	      if (j>p1->nodecount) free(pK_ptr1[j].flower);
	      pK_ptr1[j].flower=newflower;
	    }
	} /* end of for loop */
      if (b1>n && b2==n) delete(p1,endnode);
      /* use all bdry comp of p2, not p1; causes identification
	 of endnode and v1 in p1. References to endnode
	 have been changed. */
    } /* done with case of different packs */


  else /* adjoin pack to itself */
    {
      node=p1->nodecount;
      /* first check if everything is compatable. */
      next=v1;
      if (!(count=bdry_comp_count(p1,v1))) return 0;
      dist=1;
      while ((next=pK_ptr1[next].flower[0])!=v2 
	     && dist<=count) dist++;
      /* dist counts edges to v2, if on same bdry comp */
      if (count>=p1->nodecount || count<2 /* error in combinatorics */
	  || dist==1			/* leave self-id'd edge */
	  || n>count			/* not enough edges */
	  || (dist<count && ((2*n)>(count-dist)||(2*n)==(count-dist-1)))
	  || (v1==v2 && (2*n==(count-1) || 2*n>count))
	  /* leave self-id'd edge or
	     conflicting ident's */
	  ) return 0;
      if ((dist=count-dist)==2*n) /* will be same as zip from vert 
				     half way tween v1 and v2; indicate by setting v2=v1. */
	{
	  dist=n;
	  while (dist>0)
	    {
	      v1=pK_ptr1[v2].flower[0];
	      v2=v1;
	      dist--;
	    }
	}
      if (count==dist && v1!=v2) 	/* v1, v2 on separate bdry comps*/
	{
	  next=v2;
	  if (!(dist=bdry_comp_count(p1,v2))
	      || dist<3 		/* error in complex */
	      || n > dist		/* not long enough */
	      || (n==count && n!=dist) || (n==dist && n!=count)
				/* conflict on whether comps close up */
	      ) return 0;
	}
      /* now handle various possibilities */
      oldnew=(int *)calloc((size_t)(node+2),sizeof(int));
      for (kk=1;kk<=node;kk++) oldnew[kk]=kk;
      next=pK_ptr1[v1].flower[pK_ptr1[v1].num];
      v=pK_ptr1[v2].flower[0];
      if (next==v && v1!=v2) /* verts v2, next, v1 along edge */
	{
	  old_vert=pK_ptr1[next].flower[0]; /* v1 */
	  new_vert=pK_ptr1[next].flower[pK_ptr1[next].num]; /* v2 */
	  if (!close_up(p1,next)) return 0;
	  for (kk=1;kk<=node;kk++)
	    {
	      if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
	      else if (oldnew[kk]>old_vert) oldnew[kk] -= 1;
	    }
	}
      else if (v1==v2) /* zip up n edges */
	{
	  next=v1;
	  for (j=1;j<=n;j++) 
	    {
	      old_vert=pK_ptr1[next].flower[0];
	      new_vert=pK_ptr1[next].flower[pK_ptr1[next].num];
	      if (old_vert!=new_vert) 
		{
		  if (!close_up(p1,next)) return 0;
		  for (kk=1;kk<=node;kk++)
		    {
		      if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
		      if (oldnew[kk]>old_vert) oldnew[kk] -= 1;
		    }
		  if (new_vert>old_vert) new_vert--;
		  next=new_vert;
		}
	      else {pK_ptr1[next].bdry_flag=1;j=n+1;}
	    }
	}
      else  
	{
	  /* attach first edge */
	  /* fix up v1 (will remove v2) */
	  ll=pK_ptr1[v1].num;
	  mm=pK_ptr1[v2].num;
	  newflower=(int *)calloc((size_t)(ll+mm+1),sizeof(int));
	  for (i=0;i<=ll;i++) newflower[i]=pK_ptr1[v1].flower[i];
	  for (i=ll+1;i<=(ll+mm);i++) 
	    newflower[i]= pK_ptr1[v2].flower[i-ll];
	  free(pK_ptr1[v1].flower);
	  pK_ptr1[v1].flower=newflower;
	  pK_ptr1[v1].num = ll+mm;
	  /* fix up 'next', clockwise from v1 (will remove ctrclk'w 
	     nghb v of v2) */
	  ll=pK_ptr1[v].num;
	  mm=pK_ptr1[next].num;
	  newflower=(int *)calloc((size_t)(ll+mm+1),sizeof(int));
	  for (i=0;i<=ll;i++) newflower[i]=pK_ptr1[v].flower[i];
	  for (i=ll+1;i<=(ll+mm);i++) 
	    newflower[i]= pK_ptr1[next].flower[i-ll];
	  free(pK_ptr1[next].flower);
	  pK_ptr1[next].flower=newflower;
	  pK_ptr1[next].num = ll+mm;
	  /* fix up things pointed to v (which is to be removed) */
	  for (i=0;i<=pK_ptr1[v].num;i++)
	    {
	      ii=pK_ptr1[v].flower[i];
	      for (j=0;j<=pK_ptr1[ii].num;j++)
		{
		  jj=pK_ptr1[ii].flower[j];
		  if (jj==v) pK_ptr1[ii].flower[j]=next;
		}
	    }
	  /* fix up things pointed to v2 (which is to be removed )*/
	  for (i=0;i<=pK_ptr1[v2].num;i++)
	    {
	      ii=pK_ptr1[v2].flower[i];
	      for (j=0;j<=pK_ptr1[ii].num;j++)
		{
		  jj=pK_ptr1[ii].flower[j];
		  if (jj==v2) pK_ptr1[ii].flower[j]=v1;
		}
	    }
	  /* now to remove v and v2, replaced by next and v1, respectively. 
	     Old names should no longer be in any flowers.*/
	  delete(p1,v);
	  for (kk=1;kk<=node;kk++)
	    {
	      if (oldnew[kk]==v) oldnew[kk]=next;
	      if (oldnew[kk]>v) oldnew[kk]--;
	    }
	  if (v2>v) v2--;
	  if (next>v) next--;
	  if (v1>v) v1--;
	  delete(p1,v2);
	  for (kk=1;kk<=node;kk++)
	    {
	      if (oldnew[kk]==v2) oldnew[kk]=v1;
	      if (oldnew[kk]>v2) oldnew[kk]--;
	    }
	  if (next>v2) next--;
	  /* now zip up chain of edges for rest of attachments */
	  if (n>1) for (j=1;j<=n-1;j++) 
	    {
	      old_vert=pK_ptr1[next].flower[0];
	      new_vert=pK_ptr1[next].flower[pK_ptr1[next].num];
	      if (old_vert!=new_vert) 
		{
		  if (!close_up(p1,next)) return 0;
		  for (kk=1;kk<=node;kk++)
		    {
		      if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
		      if (oldnew[kk]>old_vert) oldnew[kk]--;
		    }
		  if (new_vert>old_vert) new_vert--;
		  next=new_vert;
		}
	      else {pK_ptr1[next].bdry_flag=1;j=n+1;}
	    }
	}
    } /* done with case of self-adjoin. */

  /* finish up */
  for (i=1;i<=p1->nodecount;i++) /* set bdry and plot flags */
    {
      if (pK_ptr1[i].flower[0]==pK_ptr1[i].flower[pK_ptr1[i].num])
	{
	  pK_ptr1[i].bdry_flag=0;
	  if (pR_ptr1[i].rad<=0) pR_ptr1[i].rad=.7;
	  /* so ones now in interior don't have infinite radius*/
	}
      else pK_ptr1[i].bdry_flag=1;
      pK_ptr1[i].plot_flag=1;
    }
  choose_beta(p1);choose_gamma(p1);
  if (oldnewflag) free(oldnewflag);
  *Oldnew=oldnew;
  /* size might have decreased */
  alloc_pack_space(p1,p1->nodecount+1,1); 
  return 1;
} /* adjoin */
