#include "cp_types.h"
#include "cp_proto.h"

/* inc/dec radii of the string. 
For s_radii, replace s by s=exp(factor*(log(s)))=s^(factor). 
For eucl radii, just multiply.  */

int crement_radii(struct p_data *p,double factor,char *datastr)
{ 
  char *endptr;
  int count=0,vert,hits;
  double newrad;
  struct Vertlist *vertlist,*trace;
  struct R_data *pR_ptr;

  pR_ptr=p->packR_ptr;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) != NULL)
    {
      trace=vertlist;
      if (p->hes<0)
	{
	  do {
	    vert=trace->v;
	    if (pR_ptr[vert].rad<=0 && factor < 1.0) 
	      {
		newrad=.1;
		count += h_changerad(p,vert,newrad);
	      }
	    /* make it finite if decr horocycle */
	    else if (pR_ptr[vert].rad > 0)
	      {
		newrad=exp(factor*log(pR_ptr[vert].rad));
		count += h_changerad(p,vert,newrad);
	      }
	    trace=trace->next;
	  } while (trace!=NULL);
	}
      else if (p->hes>=0)
	{
	  do {
	    vert=trace->v;
	    newrad=factor*pR_ptr[vert].rad;
	    if (p->hes>0)
	      count += s_changerad(p,vert,newrad);
	    else
	      count += e_changerad(p,vert,newrad);
	    trace=trace->next;
	  } while (trace!=NULL);
	}
      vert_free(&vertlist);
    }
  if (count)
    {
      fillcurves(p);
      return count;
    }
  strcpy(msgbuf,"No radii adjusted.");
  emsg();
  return 0;
} /* crement_radii */



