#include "cp_types.h"
#include "cp_proto.h"

#include <sys/time.h>

/* repacking routine using original riffle method with uniform
   neighbor approximation, but with "light" pack structure and 
   options for perron up/down, regular. 

   repack_method: 3 = perron up, 4=perron down, else perron.

   All aims assumed to be 2pi (at interior) and no overlaps.
   Return count of adjustments when every interior meets tolr
   or when count exceeds passes. */

int e_pack_light_uniform(struct p_light *pl,int passes,double tolr,
		      int repack_method,long *elapsetime)
{
  int i,n,num,tick,count=0,int_count,trip_flag,go_flag;
  int *indices=pl->var_indices;
  double first_m,d,b,ang_sum,m1,m2,rad,denom,m2pi=2.0*M_PI;
  double *radii=pl->radii;
  long timein;
  struct rusage RU;

  int_count=pl->counts[2];
  getrusage(RUSAGE_SELF,&RU);
  timein=RU.ru_utime.tv_sec;
  while(1)
    {
      count++;
      n=trip_flag=0;
      tick=1;
      while(n<int_count) /* loop through packing */
	{
	  n++;
	  /* compute angle-sum */
	  ang_sum=0.0;
	  rad=radii[n];
	  num=indices[tick++];
	  first_m=m2=radii[indices[tick]]/(rad+radii[indices[tick]]);
	  tick++;
	  for (i=2;i<=num;i++)
	    {
	      m1=m2;
	      m2=radii[indices[tick]]/(rad+radii[indices[tick]]);
	      tick++;
	      ang_sum += acos(1-2*m1*m2);
	    }
	  ang_sum += acos(1-2*m2*first_m); /* get last angle */
	  go_flag=1;
	  if (repack_method==3 && ang_sum>m2pi) /* perron_up */
	    {if (ang_sum>(m2pi+tolr)) trip_flag++;}
	  else if (repack_method==4 && ang_sum<m2pi) /* perron_down */
	    {if (ang_sum<(m2pi-tolr)) trip_flag++;}
	  else if (ang_sum>(m2pi+tolr) || ang_sum<(m2pi-tolr))
	    {trip_flag++;}
	  else go_flag=0;
	  if (go_flag) /* note, we adjust even if not out of tolr,
			  but we don't trip trip_flag */
	    {
	      /* adjust radius using 'uniform' method */
	      denom=1.0/(2.0*num);
	      d=sin(m2pi*denom);
	      b=sin(ang_sum*denom);
	      radii[n]=rad*b*(1-d)/(d*(1-b));
	    }
	} /* end of while */
      if (!trip_flag || count>passes) /* out of passes or no adjust's */
	{
	   getrusage(RUSAGE_SELF,&RU);
	   *elapsetime=RU.ru_utime.tv_sec-timein;	
	   return count;
	}
    } /* end of endless while */
} /* e_pack_light_uniform */

