#include "cp_types.h"
#include "cp_proto.h"

int line_ck(complex end1, complex end2, Box box) 
/* returns 1 if line is in circle circumscribing box. This needs work. */
{
	double diag,m,a,cx,cy,x1,x2,y1,y2,lx,ly,w,h;

	lx=box.lx;ly=box.ly;
	w = (box.rx-lx)*0.5;  h =(box.ry-ly)*0.5;
	cx=lx+w;cy=ly+h;
	x1=end1.re-cx;y1=end1.im-cy;
	x2=end2.re-cx;y2=end2.im-cy;
	diag=(w*w+h*h); /* rad squared of circumscribed circle */
	if (x1*x1+y1*y1<diag || x2*x2+y2*y2<diag) return 1;
	if (y1==y2)
	 {
		if (y1<ly || y1>cy+h) return 0;
		if ((x1<lx && x2>lx) || (x2<lx && x1>lx)) return 1;
		if ((x1<cx+w && x2>cx+w) || (x2<cx+w && x1>cx+w)) return 1;
		return 0;
	 }
	if (x1==x2)
	 {
		if (x1<lx || x1>cx+w) return 0;
		if ((y1<ly && y2>ly) || (y2<ly && y1>ly)) return 1;
		if ((y1<cy+h && y2>cy+h) || (y2<cy+h && y1>cy+h)) return 1;
		return 0;
	 }
	m=(y1-y2)/(x1-x2); /* slope */
	a=m*x1-y1;
	if (a*a/(m*m+1) < diag) return 1;
	return 0;
} /* line_ck */

