#include "cp_types.h"
#include "cp_proto.h"

/* Go through a red chain of faces of p, pick off successive 
"outer" verts (those on righthand edge of the chain) and generate 
data for the BdryData structure. Assume face_org is in place for 
p and poison verts are indicated by util_flag=-1. Special 
treatment needed for blue faces (as always!). (Note that indices 
for fan of faces lie in [0,num-1], not [1,num].) */

extern int **face_org;

struct BdryData *organize_bdry_data(struct p_data *p,
				    struct RedList *redlist)
{
  int i,v,vert,n,num,try,f1,f2,w,wflag=0,debug=0;
  int *face_ptr;
  struct BdryData *bdrydata,*trace,*temp,*hold=NULL;
  struct BdryData *ntrace,*orig,*last,*low;
  struct RedList *rtrace,*stop_ptr=NULL;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  /* start at face having an edge */
  while (!(redlist->next_edge) 
    || redlist->next->face==redlist->prev->face) redlist=redlist->next;
  while (redlist!=stop_ptr)
    {
      temp=(struct BdryData *)
	calloc((size_t)1,sizeof(struct BdryData));
      temp->next_v=temp->prev_v=temp; /* default: points to self */
      temp->v=v=p->faces[redlist->face].vert[redlist->v_flag];
      temp->bdry_flag=(pK_ptr[v].flower[0]
		       !=pK_ptr[v].flower[pK_ptr[v].num]);
      temp->poison_flag=(pK_ptr[v].util_flag==-1);
      /* set indices of faces */
      num=*(face_org[v]);
      face_ptr=face_org[v]+1;
      temp->indx2=num-1;
      while (*(face_ptr+temp->indx2)!=redlist->face && temp->indx2>0)
	temp->indx2--;
      rtrace=redlist;
      i=temp->indx2;
      while (rtrace->next->face==*(face_ptr+((i+num-1) % num))
	     && rtrace->next->face!=redlist->face)
	{
	  rtrace=rtrace->next;
	  i--;
	}
      temp->num=temp->indx2-i+1;
      temp->indx1=((i+num) % num);
      if (!(wflag++)) /* first time through? start double linked list */
	{
	  bdrydata=hold=temp;
	  bdrydata->next=bdrydata->prev=bdrydata;
	  stop_ptr=redlist;
	}
      else /* interleaf new data */
	{
	  trace=hold->next;
	  hold->next=temp;
	  temp->prev=hold;
	  temp->next=trace;
	  trace->prev=temp;
	  hold=temp;
	}

      /* if this face is blue, do everything again, but for next vertex. */
      if (redlist->prev->face==redlist->next->face)
	{
	  temp=(struct BdryData *)
	    calloc((size_t)1,sizeof(struct BdryData));
	  temp->next_v=temp->prev_v=temp; /* default: points to self */
	  temp->v=v=p->faces[redlist->face].vert[(redlist->v_flag+1) % 3];
	  temp->bdry_flag=(pK_ptr[v].flower[0]
	    !=pK_ptr[v].flower[pK_ptr[v].num]);
	  temp->poison_flag=(pK_ptr[v].util_flag==-1);
	  /* set indices of faces */
	  num=*(face_org[v]);
	  face_ptr=face_org[v]+1;
	  temp->indx2=num-1;
	  while (*(face_ptr+temp->indx2)!=redlist->face && temp->indx2>0)
	    temp->indx2--;
	  rtrace=redlist;
	  i=temp->indx2;
	  while (rtrace->next->face==*(face_ptr+((i+num-1) % num))
		 && rtrace->next->face!=redlist->face)
	    {
	      rtrace=rtrace->next;
	      i--;
	    }
	  temp->num=temp->indx2-i+1;
	  temp->indx1=((i+num) % num);
	  trace=hold->next;
	  hold->next=temp;
	  temp->prev=hold;
	  temp->next=trace;
	  trace->prev=temp;
	  hold=temp;
	}
      redlist=redlist->next_edge;
    } /* end of while */

  /* next, we'll look through this list, set up sub linkings between those
     sharing same v, throw out any with complete fans -- they can't be 
     cloned and flower of v won't need adjustment. */

  /* debug */
  if (debug) record_bdrydata(p,bdrydata,face_org);

  zero_duty_flags(bdrydata);
  trace=bdrydata;
  while (!trace->duty_flag)
    {
      if (trace->num==pK_ptr[trace->v].num)
	{
	  trace=drop_bd(&trace,&bdrydata); /* complete fan */
	  if (bdrydata && bdrydata->next==bdrydata) return NULL;
	}
      else
	{
	  vert=trace->v;
	  if (trace->next_v!=trace) 
	    trace->duty_flag=1; /* already in a sublist */
	  else
	    {
	      n=trace->num;
	      hold=trace;
	      temp=trace->next;
	      while (temp!=trace) /* find other occurances of vert */
		{
		  if (temp->v==vert)
		    {
		      hold->next_v=temp;
		      temp->prev_v=hold;
		      hold=temp;
		      n += hold->num;
		    }
		  hold->next_v=trace;
		  trace->prev_v=hold; /* last points to first (or possibly
					 first points to itself). */
		  temp=temp->next;
		} /* end of while */
	      if (!trace->poison_flag && n==pK_ptr[vert].num) 
		/* vert's not poison and the various fans account for all 
		   its faces. Drop this whole sublist of entries */
		{
		  temp=orig=trace;
		  wflag=0;
		  while (temp!=orig || !(wflag++))
		    {
		      ntrace=temp->next_v;
		      if (!drop_bd(&temp,&bdrydata)) return NULL;
		      temp=ntrace;
		    }
		}
	      else trace->duty_flag=1;
	    }
	  trace=trace->next;
	}
    } /* end of while */
  if (!bdrydata || bdrydata->next==bdrydata) return NULL;

  /* debug */
  if (debug) record_bdrydata(p,bdrydata,face_org);

  /*  Organize sublists with more than one entry in increasing 
      fan-index order, then pass through this list to consolidate 
      fans where possible. */


  zero_duty_flags(bdrydata);
  trace=bdrydata;
  wflag=0;
  while(!trace->duty_flag)
    {
      vert=trace->v;
      face_ptr=face_org[vert]+1;

      /* find orig: lowest face index among fans in sublist */
      orig=trace;
      temp=orig->next_v;
      while (temp!=trace)
	{
	  if (temp->indx1 < orig->indx1) orig=temp;
	  temp=temp->next_v;
	}
      if (!(wflag++)) trace=bdrydata=orig; /* first time through?
					      reset to help exit loop */ 

      /* Leave orig unchanged, find successive lowest indices. */

      last=orig;
      while (last->next_v!=orig && last->next_v->next_v!=orig)
	{
	  low=last->next_v;
	  temp=low->next_v;
	  while (temp!=orig)
	    {
	      if (temp->indx1 < low->indx1) low=temp;
	      temp=temp->next_v;
	    }
	  if (low!=last->next_v) /* put low right after last in 
				    next_v list */
	    {
	      low->prev_v->next_v=low->next_v;
	      low->next_v->prev_v=low->prev_v; 
	      low->prev_v=last;
	      low->next_v=last->next_v;
	      last->next_v->prev_v=low;
	      last->next_v=low; 
	    }
	  last=low;
	} /* go get next lowest */

      /* check this sublist for contiguous fans -- consolidate
	 when possible. Not all contig fans are melded; may 
	 remain separate depending on need for cloning. */
      
      hold=orig;
      if (orig->next_v==orig) orig->duty_flag=1; /* only one fan */ 
      while(!hold->duty_flag && hold!=hold->next_v) 
	/* hold is next starting place in fan to try to hook to. */
	{
	  hold->duty_flag=1;
	  temp=hold->next_v;
	  try=1;
	  while (try) /* Is next fan contiguous? (Note that as we come 
			 around to orig at the end, have to allow
			 possibility that it may get hooked up with the 
			 last fan.) */
	    {
	      if ((pK_ptr[vert].bdry_flag && hold->indx2<pK_ptr[vert].num-1
		   && temp->indx1==hold->indx2+1) 
		  || (!pK_ptr[vert].bdry_flag 
		      && temp->indx1==((hold->indx2+1) % pK_ptr[vert].num)))
		{
		  f1=face_ptr[hold->indx2];
		  f2=face_ptr[temp->indx1];
		  w=p->faces[f1].vert[nghb_tri(p,f2,f1)]; 
		  /* the edge between the contig faces is <vert,w>;
		     either end not poison, consolidate in first fan,
		     drop second entry. */
		  if (pK_ptr[w].util_flag!=-1 || pK_ptr[vert].util_flag!=-1)
		    {
		      hold->indx2=temp->indx2;
		      hold->num += temp->num;
		      hold->next_v=temp->next_v;
		      temp->next_v->prev_v=hold;
		      if (!drop_bd(&temp,&bdrydata)) return NULL;
		      temp=hold->next_v; /* try the next fan, too */
		    }
		  else 
		    {
		      hold=temp;
		      try=0;
		    }
		}
	      else
		{
		  hold=temp;
		  try=0;
		}
	    } /* end of inner while */
	} /* end of while; done with this sublist */

      /* point to next sublist via trace */
      trace=trace->next;
      while (trace!=bdrydata && trace->duty_flag) trace=trace->next;
    } /* end of outer while; have gone through all the sublists */

  /* debug */
  if (debug) record_bdrydata(p,bdrydata,face_org);

  return bdrydata;
} /* organize_bdry_data */

struct BdryData *drop_bd(struct BdryData **ptr,struct BdryData **bd_ptr)
/* drop an entry of the list. Make sure that bd_ptr is adjusted if 
it's the one being dropped. Return NULL if list collapses. */
{
  struct BdryData *n,*p;

  if (*ptr==*bd_ptr) *bd_ptr=(*bd_ptr)->next;
  n=(*ptr)->next;
  p=(*ptr)->prev;
  n->prev=p;
  p->next=n;
  free(*ptr);
  *ptr=NULL;
  if ((*bd_ptr)->next==*bd_ptr) return NULL;
  return n;
} /* drop_bd */
