#include "cp_types.h"
#include "cp_proto.h"

/* To be called by stand-alone programs that need to use the
circle packing library routines. Not all these are needed by all
the routines. See cp_types.h for descriptions 

   The main program must have this declaration "char *emsgbuf,*msgbuf;"
must provide emsg(), msg(), and often needs routines repack_activity_msg()
and refresh_canvas(). 

   Use "shell_main.c" to get stared. */

extern char *emsgbuf;

int set_cp_globals()
{
  toler=0.0000000001;	
  okerr=0.000000000001;
  m_toler=EpsMach();
  degPI=180.0/M_PI;
  iterates=2;
  face_org=NULL;
  pathlength=0;
  pathlist=newpath=NULL;
  layout_th=0.00001; /* threshold for circle layout accuracy */

  /* postscript/drawing parameters */
  num_plot=40;
  line_thick=1;      /* 'brush' setting */
  ps_linewidth=PS_UNIT_LINEWIDTH;  /* postscript linewidth */
  graylevel=.5;      /* for postscript filling */
  fill_mode=0;       /* default gray filling */
  std_real_box.lx=std_real_box.ly=-1.1;
  std_real_box.rx=std_real_box.ry=1.1;

  /* create space for global pointers */
  Vlist=Flist=(struct Vertlist *)NULL;
  Elist=Vertex_map=(struct Edgelist *)NULL;
  Clist=(struct Centlist *)NULL;

  /* standard message space (dual use, buffers overlap). */
  emsgbuf=(char *)calloc(BUFSIZE+11,sizeof(char));
  strncpy(emsgbuf,"**ERROR** ",13); 
  msgbuf=emsgbuf+10;

  /* color and color ramp stuff */
  bc_min=255;
  bc_max=bc_offset=0;
  sc_print_size=7;
  color_ramp_size=COLOR_RAMP; /* 200 is set in cp_types.h */
  blue_to_red_ramp(0); /* default color ramp and misc colors */
  fgcolor=0;
  bgcolor=1677725; /* based on XView CMS_BACKGROUND_PIXEL */

  return 1;
} /* set_cp_globals */









