#include "cp_types.h"
#include "cp_proto.h"

/* Several technical routines to set various details of face structure */

int set_face_next(struct p_data *p,char *datastr)
/* set's "next_face" index of faces */
{
  char next[256];
  int f1,f2;
  char *nextptr;

  nextptr=datastr;
  while (grab_next(&nextptr,next) && sscanf(next,"%d",&f1)==1
	 && f1>=0 && f1<=p->facecount 
	 && grab_next(&nextptr,next) && sscanf(next,"%d",&f2)==1
	 && f2>0 && f2<=p->facecount)
    {
      if (f1==0) p->first_face=f2;
      else p->faces[f1].next_face=f2;
    }
  return 1;
} /* set_face_next */

int set_face_index(struct p_data *p,char *datastr)
/* set "index_flag" of faces */
{
  char next[256];
  int fn,ind;
  char *nextptr;

  nextptr=datastr;
  while (grab_next(&nextptr,next) && sscanf(next,"%d",&fn)==1
	 && fn>0 && fn<=p->facecount 
	 && grab_next(&nextptr,next) && sscanf(next,"%d",&ind)==1
	 && ind >=0 && ind <3)
    p->faces[fn].index_flag=ind;
  return 1;
} /* set_face_index */

int set_face_red(struct p_data *p,char *datastr)
/* set "rwb_flag" of faces */
{
  char next[256];
  int fn,ind;
  char *nextptr;

  nextptr=datastr;
  while (grab_next(&nextptr,next) && sscanf(next,"%d",&fn)==1
	 && fn>0 && fn<=p->facecount 
	 && grab_next(&nextptr,next) && sscanf(next,"%d",&ind)==1
	 && p->rwb_flags)
    p->rwb_flags[fn]=ind;
  return 1;
} /* set_face_red */

int set_face_rnext(struct p_data *p,char *datastr)
/* set's "next_face" index of faces */
{
  char next[256];
  int f1,f2;
  char *nextptr;

  nextptr=datastr;
  while (grab_next(&nextptr,next) && sscanf(next,"%d",&f1)==1
	 && f1>=0 && f1<=p->facecount 
	 && grab_next(&nextptr,next) && sscanf(next,"%d",&f2)==1
	 && f2>0 && f2<=p->facecount)
    p->faces[f1].next_red=f2;
  return 1;
} /* set_face_rnext */






