--
-- MULTI_FDW_CREATE_TABLE
--

-- Create new table definitions for use in testing in distributed foreign data
-- wrapper functionality.

SELECT fdwname FROM pg_foreign_data_wrapper;

CREATE SERVER file_server FOREIGN DATA WRAPPER file_fdw;

CREATE FOREIGN TABLE lineitem (
	l_orderkey bigint not null,
	l_partkey integer not null,
	l_suppkey integer not null,
	l_linenumber integer not null,
	l_quantity decimal(15, 2) not null,
	l_extendedprice decimal(15, 2) not null,
	l_discount decimal(15, 2) not null,
	l_tax decimal(15, 2) not null,
	l_returnflag char(1) not null,
	l_linestatus char(1) not null,
	l_shipdate date not null,
	l_commitdate date not null,
	l_receiptdate date not null,
	l_shipinstruct char(25) not null,
	l_shipmode char(10) not null,
	l_comment varchar(44) not null)
SERVER file_server 
OPTIONS (format 'text', filename '', delimiter '|', null '');
SELECT master_create_distributed_table('lineitem', 'l_orderkey', 'append');

CREATE FOREIGN TABLE orders (
	o_orderkey bigint not null,
	o_custkey integer not null,
	o_orderstatus char(1) not null,
	o_totalprice decimal(15,2) not null,
	o_orderdate date not null,
	o_orderpriority char(15) not null,
	o_clerk char(15) not null,
	o_shippriority integer not null,
	o_comment varchar(79) not null)
SERVER file_server 
OPTIONS (format 'text', filename '', delimiter '|', null '');
SELECT master_create_distributed_table('orders', 'o_orderkey', 'append');

CREATE FOREIGN TABLE customer (
	c_custkey integer not null,
	c_name varchar(25) not null,
	c_address varchar(40) not null,
	c_nationkey integer not null,
	c_phone char(15) not null,
	c_acctbal decimal(15,2) not null,
	c_mktsegment char(10) not null,
	c_comment varchar(117) not null)
SERVER file_server 
OPTIONS (format 'text', filename '', delimiter '|', null '');
SELECT master_create_distributed_table('customer', 'c_custkey', 'append');

CREATE FOREIGN TABLE nation (
	n_nationkey integer not null,
	n_name char(25) not null,
	n_regionkey integer not null,
	n_comment varchar(152))
SERVER file_server 
OPTIONS (format 'text', filename '', delimiter '|', null '');
SELECT master_create_distributed_table('nation', 'n_nationkey', 'append');

CREATE FOREIGN TABLE part (
	p_partkey integer not null,
	p_name varchar(55) not null,
	p_mfgr char(25) not null,
	p_brand char(10) not null,
	p_type varchar(25) not null,
	p_size integer not null,
	p_container char(10) not null,
	p_retailprice decimal(15,2) not null,
	p_comment varchar(23) not null)
SERVER file_server 
OPTIONS (format 'text', filename '', delimiter '|', null '');
SELECT master_create_distributed_table('part', 'p_partkey', 'append');
