<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Financial/FinancialAccount.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:ccca91d77f1c8f2639bf0d81bd484b9c)
 */

/**
 * Database access object for the FinancialAccount entity.
 */
class CRM_Financial_DAO_FinancialAccount extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_financial_account';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * ID
   *
   * @var int
   */
  public $id;

  /**
   * Financial Account Name.
   *
   * @var string
   */
  public $name;

  /**
   * FK to Contact ID that is responsible for the funds in this account
   *
   * @var int
   */
  public $contact_id;

  /**
   * pseudo FK into civicrm_option_value.
   *
   * @var int
   */
  public $financial_account_type_id;

  /**
   * Optional value for mapping monies owed and received to accounting system codes.
   *
   * @var string
   */
  public $accounting_code;

  /**
   * Optional value for mapping account types to accounting system account categories (QuickBooks Account Type Codes for example).
   *
   * @var string
   */
  public $account_type_code;

  /**
   * Financial Type Description.
   *
   * @var string
   */
  public $description;

  /**
   * Parent ID in account hierarchy
   *
   * @var int
   */
  public $parent_id;

  /**
   * Is this a header account which does not allow transactions to be posted against it directly, but only to its sub-accounts?
   *
   * @var bool
   */
  public $is_header_account;

  /**
   * Is this account tax-deductible?
   *
   * @var bool
   */
  public $is_deductible;

  /**
   * Is this account for taxes?
   *
   * @var bool
   */
  public $is_tax;

  /**
   * The percentage of the total_amount that is due for this tax.
   *
   * @var float
   */
  public $tax_rate;

  /**
   * Is this a predefined system object?
   *
   * @var bool
   */
  public $is_reserved;

  /**
   * Is this property active?
   *
   * @var bool
   */
  public $is_active;

  /**
   * Is this account the default one (or default tax one) for its financial_account_type?
   *
   * @var bool
   */
  public $is_default;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_financial_account';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'parent_id', 'civicrm_financial_account', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account ID'),
          'description' => ts('ID'),
          'required' => TRUE,
          'where' => 'civicrm_financial_account.id',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Financial Account Name'),
          'description' => ts('Financial Account Name.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_financial_account.name',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'financial_account_contact_id' => [
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID'),
          'description' => ts('FK to Contact ID that is responsible for the funds in this account'),
          'where' => 'civicrm_financial_account.contact_id',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ],
        'financial_account_type_id' => [
          'name' => 'financial_account_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account Type'),
          'description' => ts('pseudo FK into civicrm_option_value.'),
          'required' => TRUE,
          'where' => 'civicrm_financial_account.financial_account_type_id',
          'default' => '3',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'financial_account_type',
            'optionEditPath' => 'civicrm/admin/options/financial_account_type',
          ],
        ],
        'accounting_code' => [
          'name' => 'accounting_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Accounting Code'),
          'description' => ts('Optional value for mapping monies owed and received to accounting system codes.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'where' => 'civicrm_financial_account.accounting_code',
          'export' => TRUE,
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'account_type_code' => [
          'name' => 'account_type_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Account Type Code'),
          'description' => ts('Optional value for mapping account types to accounting system account categories (QuickBooks Account Type Codes for example).'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'where' => 'civicrm_financial_account.account_type_code',
          'export' => TRUE,
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Financial Account Description'),
          'description' => ts('Financial Type Description.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_financial_account.description',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'parent_id' => [
          'name' => 'parent_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account Parent'),
          'description' => ts('Parent ID in account hierarchy'),
          'where' => 'civicrm_financial_account.parent_id',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
          'FKClassName' => 'CRM_Financial_DAO_FinancialAccount',
        ],
        'is_header_account' => [
          'name' => 'is_header_account',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Header Financial Account?'),
          'description' => ts('Is this a header account which does not allow transactions to be posted against it directly, but only to its sub-accounts?'),
          'where' => 'civicrm_financial_account.is_header_account',
          'default' => '0',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'is_deductible' => [
          'name' => 'is_deductible',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Deductible Financial Account?'),
          'description' => ts('Is this account tax-deductible?'),
          'where' => 'civicrm_financial_account.is_deductible',
          'default' => '1',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'is_tax' => [
          'name' => 'is_tax',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Tax Financial Account?'),
          'description' => ts('Is this account for taxes?'),
          'where' => 'civicrm_financial_account.is_tax',
          'default' => '0',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'tax_rate' => [
          'name' => 'tax_rate',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Financial Account Tax Rate'),
          'description' => ts('The percentage of the total_amount that is due for this tax.'),
          'precision' => [
            10,
            8,
          ],
          'where' => 'civicrm_financial_account.tax_rate',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Reserved Financial Account?'),
          'description' => ts('Is this a predefined system object?'),
          'where' => 'civicrm_financial_account.is_reserved',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Financial Account is Active'),
          'description' => ts('Is this property active?'),
          'where' => 'civicrm_financial_account.is_active',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
        'is_default' => [
          'name' => 'is_default',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Default Financial Account'),
          'description' => ts('Is this account the default one (or default tax one) for its financial_account_type?'),
          'where' => 'civicrm_financial_account.is_default',
          'table_name' => 'civicrm_financial_account',
          'entity' => 'FinancialAccount',
          'bao' => 'CRM_Financial_BAO_FinancialAccount',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'financial_account', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'financial_account', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_financial_account::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
