<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/UserJob.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:58e6fcaa028d157bfa074a073111239d)
 */

/**
 * Database access object for the UserJob entity.
 */
class CRM_Core_DAO_UserJob extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '5.50';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_user_job';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Job ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Unique name for job.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * FK to contact table.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_id;

  /**
   * Date and time this job was created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * Date and time this import job started.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_date;

  /**
   * Date and time this import job ended.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_date;

  /**
   * Date and time to clean up after this import job (temp table deletion date).
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $expires_date;

  /**
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $status_id;

  /**
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $type_id;

  /**
   * FK to Queue
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $queue_id;

  /**
   * Data pertaining to job configuration
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $metadata;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_user_job';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('User Jobs') : ts('User Job');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'created_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'queue_id', 'civicrm_queue', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('User Job ID'),
          'description' => ts('Job ID'),
          'required' => TRUE,
          'where' => 'civicrm_user_job.id',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '5.50',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('User job name'),
          'description' => ts('Unique name for job.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'where' => 'civicrm_user_job.name',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'add' => '5.50',
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to contact table.'),
          'where' => 'civicrm_user_job.created_id',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'label' => ts("Created By"),
          ],
          'add' => '5.50',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Import Job Created Date'),
          'description' => ts('Date and time this job was created.'),
          'required' => TRUE,
          'where' => 'civicrm_user_job.created_date',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'readonly' => TRUE,
          'add' => '5.50',
        ],
        'start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Import Job Started Date'),
          'description' => ts('Date and time this import job started.'),
          'required' => FALSE,
          'where' => 'civicrm_user_job.start_date',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'readonly' => TRUE,
          'add' => '5.50',
        ],
        'end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Job Ended Date'),
          'description' => ts('Date and time this import job ended.'),
          'required' => FALSE,
          'where' => 'civicrm_user_job.end_date',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'add' => '5.50',
        ],
        'expires_date' => [
          'name' => 'expires_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Import Job Expires Date'),
          'description' => ts('Date and time to clean up after this import job (temp table deletion date).'),
          'required' => FALSE,
          'where' => 'civicrm_user_job.expires_date',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'add' => '5.50',
        ],
        'status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('User Job Status ID'),
          'required' => TRUE,
          'where' => 'civicrm_user_job.status_id',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'label' => ts("Job Status"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_UserJob::getStatuses',
          ],
          'add' => '5.50',
        ],
        'type_id' => [
          'name' => 'type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('User Job Type ID'),
          'required' => TRUE,
          'where' => 'civicrm_user_job.type_id',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'html' => [
            'label' => ts("Job Type"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_UserJob::getTypes',
          ],
          'add' => '5.50',
        ],
        'queue_id' => [
          'name' => 'queue_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Queue ID'),
          'description' => ts('FK to Queue'),
          'where' => 'civicrm_user_job.queue_id',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'FKClassName' => 'CRM_Queue_DAO_Queue',
          'html' => [
            'label' => ts("Queue"),
          ],
          'add' => NULL,
        ],
        'metadata' => [
          'name' => 'metadata',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Job metadata'),
          'description' => ts('Data pertaining to job configuration'),
          'where' => 'civicrm_user_job.metadata',
          'table_name' => 'civicrm_user_job',
          'entity' => 'UserJob',
          'bao' => 'CRM_Core_BAO_UserJob',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '5.50',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'user_job', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'user_job', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_user_job::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
