# CiviCRM 5.16.0

Released August 7, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     | **yes** |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Allow extensions to define CSS themes / Add a configuration setting for when
  to load custom CSS
  ([CRM-18792](https://issues.civicrm.org/jira/browse/CRM-18792) /
  [dev/core#378](https://lab.civicrm.org/dev/core/issues/378):
  [14551](https://github.com/civicrm/civicrm-core/pull/14551) and
  [12929](https://github.com/civicrm/civicrm-core/pull/12929))**

  Adds an option to the "Display Preferences" settings form to allow users to
  more finely tune when CiviCRM's css is loaded. On WordPress and Joomla two
  options are available the "Backend Theme" and "Frontend Theme", on Drupal and
  Backdrop, the administration screen "Display Preferences" presents a singular
  "Theme" option.

- **Clean up use of DAO::nullArray
  ([dev/core#1047](https://lab.civicrm.org/dev/core/issues/1047):
  [14556](https://github.com/civicrm/civicrm-core/pull/14556),
  [14555](https://github.com/civicrm/civicrm-core/pull/14555) and
  [14550](https://github.com/civicrm/civicrm-core/pull/14550))**

  Improves code stability by removing the unnecessary function
  `CRM_Core_DAO::_nullArray`.

- **Consolidate handling of conflicts between the batch job and get_conflicts
  api ([14685](https://github.com/civicrm/civicrm-core/pull/14685))**

  Improves code consistency by ensuring that merge conflicts are stored during
  batch_merge to the prev_next cache with the same format as when the api calls
  get_conflicts, the code doing this wrangling is moved from the api to the BAO
  layer.

- **Better support for hookable menubar colors
  ([14944](https://github.com/civicrm/civicrm-core/pull/14944))**

  More colors in the menu, including the base color, highlight color, and text
  color, can be modified with hooks.

- **Add csv reader package
  ([14524](https://github.com/civicrm/civicrm-core/pull/14524))**

  Adds the CSV processing utility, league/csv ^9.2 which will help with future
  PRs which introduce more test-coverage for CSV outputs and help cleanup some
  of the csv code down the way.

- **Improve protected field metadata
  ([14679](https://github.com/civicrm/civicrm-core/pull/14679))**

  Adds more robust metadata to fields protected by permissions in a format that
  can be directly passed into `CRM_Core_Permissions::check()`.

- **Move api_key read/write permission checks from api to BAO
  ([14660](https://github.com/civicrm/civicrm-core/pull/14660))**

  Moves the logic for checking the api_key field permissions from the api layer
  to the BAO layer so it can be reused by api4 and other things.

- **Add a configuration setting for when to load custom CSS (initial work for
  [dev/core#378](https://lab.civicrm.org/dev/core/issues/378):
  [14876](https://github.com/civicrm/civicrm-core/pull/14876))**

  A new function, `CRM_Utils_System::isFrontEndPage()`, indicates whether a page
  is considered "front-end".

- **Permit sort_name as a url parameter on advanced search
  ([14475](https://github.com/civicrm/civicrm-core/pull/14475) and
  [14920](https://github.com/civicrm/civicrm-core/pull/14920))**

  You can now set `sort_name=x` in the URL on the advanced search form.  In
  doing this, the sort name field is now defined through metadata rather than
  *ad hoc*.

- **Menubar - Improve flexibility & remove hardcoded values
  ([14924](https://github.com/civicrm/civicrm-core/pull/14924))**

  The menu no longer relies on hardcoded pixel dimensions to determine mobile
  appearance, and it replaces references to the ID selector `crm-container` with
  the class selector of the same name (which is used more broadly).

  This also resolves
  [dev/core#1127](https://lab.civicrm.org/dev/core/issues/1127).

- **Handle relative start & end dates passed to datepicker widget
  ([14632](https://github.com/civicrm/civicrm-core/pull/14632))**

  Adds some client-side logic to the datepicker widget that was previously done
  server-side. Paves the way for afform.

- **Improve utilities & tests for working with js notation
  ([14588](https://github.com/civicrm/civicrm-core/pull/14588),
  [14537](https://github.com/civicrm/civicrm-core/pull/14537) and
  [14586](https://github.com/civicrm/civicrm-core/pull/14586))**

  Removes dependence on an external library & improves robustness & accuracy of
  reading/writing js notation. Adds a utility function for getting properties of
  a Javascript option without parsing them. Adds a utility function  and a
  test for dealing with data in js notation.

- **i18n - Improve multilingual popup for text and wysiwyg fields
  ([14578](https://github.com/civicrm/civicrm-core/pull/14578))**

  Fixes copying of values between multilingual popup and main form for wysiwyg
  fields and makes text fields larger in multilingual pop-up.

- **Buttons inconsistencies
  ([dev/core#347](https://lab.civicrm.org/dev/core/issues/347):
  [14136](https://github.com/civicrm/civicrm-core/pull/14136) and
  [14509](https://github.com/civicrm/civicrm-core/pull/14509))**

  Adds support for "button" elements in CiviCRM ajax popup forms in addition to
  the input type=button/submit and the "a class=button". This is a first step
  towards cleaning up button handling from a theming perspective. Adds
  buttons to 'Cleanup caches and update paths' in standard way

- **Display description next to 'paperclip' file icon - usually the filename
  ([14501](https://github.com/civicrm/civicrm-core/pull/14501))**

  When viewing custom files displays the description (usually the filename) next
  to the paperclip.

- **Address BAO - Handle standard 'custom' param as well as individual fields
  ([14535](https://github.com/civicrm/civicrm-core/pull/14535))**

  Ensures that the Address BAO can handle both raw unformatted custom field
  input and processed custom field inputs.

- **Update PSR16 handling for multisite extension legacy caching group
  ([14505](https://github.com/civicrm/civicrm-core/pull/14505))**

  Only use a Legacy group if using a version of org.civicrm.multisite 2.6 or
  below.

- **Improve I18n schema by including comments and default and NOT NULL or NULL
  statements to be more consistent with non lingual schema
  ([14484](https://github.com/civicrm/civicrm-core/pull/14484))**

  Adds more information to the I18n schema structure so that when the
  translated schema is created it is more similar to the non multilingual schema.

- **Add a couple customField pseudoconstants
  ([14494](https://github.com/civicrm/civicrm-core/pull/14494))**

  Adds a couple missing option lists to the schema so that they show up in the
  api explorer for the CustomField entity.

- **Deprecate ARCHIVE format for CiviCRM Database Logging (continues work for
  [dev/core#663](https://lab.civicrm.org/dev/core/issues/663):
  [14256](https://github.com/civicrm/civicrm-core/pull/14256))**

  Switches to using InnoDB for extended log tables instead of the ARCHIVE
  format.

- **ActivityForm - Redirect to contact page or activity view in standalone mode
  ([14522](https://github.com/civicrm/civicrm-core/pull/14522))**

  When using the "standalone" New Activity form, moves from always redirecting
  to the dashboard after saving to redirecting to the contact page (if 1
  contact) and the activity view screen (if multiple).

### CiviEvent

- **URL support for some params in event search
  ([14477](https://github.com/civicrm/civicrm-core/pull/14477))**

  Adds Event Search URL support for the params: sort_name, participant_status_id,
  participant_register_date_low, participant_register_date_high, and
  participant_register_date_relative. Date format is a string of numbers YmdHIS
  (ex: 20180101).

- **Add checklist-model angular module
  ([14634](https://github.com/civicrm/civicrm-core/pull/14634))**

  Adds the angular `checklist-model` library required by form builder.

### CiviContribute

- **Reduce deadlocks on inserting custom data by only using 'ON DUPLICATE' when
  it is not a new row
  ([14605](https://github.com/civicrm/civicrm-core/pull/14605))**

  Reduce deadlocks when processing contributions with custom data. This
  specifically makes the custom data insert SQL more efficient.

- **Fix url support for receive_date_high & receive_date_low
  ([14594](https://github.com/civicrm/civicrm-core/pull/14594) and
  [14611](https://github.com/civicrm/civicrm-core/pull/14611))**

  As a part of a general standardization movement, adds Url support on the
  contribution search form for the following fields: receive_date_high,
  receive_date_low, contribution_cancel_date_high, contribution_cancel_date_low
  and invoice_number=9. Deprecates and continues to support the start date being
  passed to contribution search as "start=2018-01-01".

- **Deprecate contribution_date as a parameter
  ([14533](https://github.com/civicrm/civicrm-core/pull/14533))**

  Add deprecation notice for accessing old field name for receive_date in query
  object.

- **Create payment activity when creating a payment via the api, test
  ([14452](https://github.com/civicrm/civicrm-core/pull/14452))**

  Ensures when creating a payment via the api a payment activity is created.

### CiviMembership

- **Expose Primary member only/Non primary member only filter in membership
  reports. ([14530](https://github.com/civicrm/civicrm-core/pull/14530) and
  [14507](https://github.com/civicrm/civicrm-core/pull/14507))**

  On Membership Reports filters tabs, cleans up Membership Owner ID options.

- **Update Owner Membership ID label in reports to be Primary Membership to be
  more consistent with rest of system
  ([14585](https://github.com/civicrm/civicrm-core/pull/14585))**

  Changes the label of the Owner Membership ID in reports from "Membership Owner
  ID" to "Primary Membership".

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **submitOnce revisited
  ([dev/core#914](https://lab.civicrm.org/dev/core/issues/914):
  [14519](https://github.com/civicrm/civicrm-core/pull/14519))**

  Ensures "SubmitOnce" functionality works with forms with multiple buttons.

- **[regression] `cv` fails on CiviCRM 5.15.0
  ([dev/drupal#75](https://lab.civicrm.org/dev/drupal/issues/75):
  [14775](https://github.com/civicrm/civicrm-core/pull/14775))**

  This fixes the return value of `CRM_Utils_System_Drupal8::languageNegotiationURL()`

- **Errors exporting contributions on 5.13.2 (continues work for
  [dev/core#1015](https://lab.civicrm.org/dev/core/issues/1015):
  [14513](https://github.com/civicrm/civicrm-core/pull/14513))**

  Applies a more robust fix to a bug exporting soft credits in 5.13.2.

- **Email created without location when syncing from CMS account
  ([dev/core#1026](https://lab.civicrm.org/dev/core/issues/1026):
  [14489](https://github.com/civicrm/civicrm-core/pull/14489))**

  Adds a default for `location_type_id` in the API Email.create in order to
  address a bug where Emails were being created without a location type when
  syncing from a CMS account.

- **$this->_selectedTables is not populated incase of boleen filters
  ([14503](https://github.com/civicrm/civicrm-core/pull/14503))**

  Fixes a bug where when a report was filtered on a boolean field with option No
  then `$this->_selectedTables` was not being populated so that it is populated.

- **Block classes in unserialize field for IDE cheer
  ([14683](https://github.com/civicrm/civicrm-core/pull/14683))**

  Ensures unserialize does not permit class unserialization.

- **Support api3 & 4 language syntax & improve test
  ([14590](https://github.com/civicrm/civicrm-core/pull/14590))**

   Fixes support for api3 "language" option and extends test coverage to the new
   syntax as well as api v4.

- **Reset language at end of localized api call
  ([14597](https://github.com/civicrm/civicrm-core/pull/14597))**

  Restore the original language after changing it for an api call using
  `options['language']`.

- **Activity formRule status check cleanup
  ([14630](https://github.com/civicrm/civicrm-core/pull/14630))**

  Fixes a bug where under some circumstances, the activity_type_id from fields
  and from the getKey call can both return NULL, causing the formRule to raise
  an error that one cannot record a scheduled SMS activity.

- **Add query object support for receive_date_high & receive_date_low and
  generically date fields
  ([14623](https://github.com/civicrm/civicrm-core/pull/14623))**

  Ensures choosing from receive date in advanced search filters appropriately.

- **Fix setup.sh crash when using the -a flag
  ([14595](https://github.com/civicrm/civicrm-core/pull/14595))**

  Fixes an error where the command setup.sh -a dies with an error because it
  doesn't know what database to load.

- **Fix duplicate households on 'Merge same household' exports
  ([14443](https://github.com/civicrm/civicrm-core/pull/14443))**

  Ensures "Merge same household" does not create duplicate rows for each
  household, one for the "merged individuals" and one being the explicit
  household directly exported.

- **Fix placeholder font in Quicksearch
  ([14154](https://github.com/civicrm/civicrm-core/pull/14154))**

  Make the Quicksearch font be the CiviCRM font instead of the "FontAwesome"
  font.

- **CRM_Utils_SQL_ - Properly interpolate NULL values
  ([14250](https://github.com/civicrm/civicrm-core/pull/14250))**

  Ensures the classes `CRM_Utils_SQL_Select`, `CRM_Utils_SQL_Delete`, and
  `CRM_Utils_SQL_Insert` properly handle NULL values.

- **Fix deletion of contact sub_type in api4
  ([14492](https://github.com/civicrm/civicrm-core/pull/14492))**

   Cleans up the contact BAO to not arbitrarily delete a contact's sub-type when
   saving a contact using Api4.

- **Add in uniqueness to cache keys to mitigate clashes on multisite installs
  ([14485](https://github.com/civicrm/civicrm-core/pull/14485))**

  Ensures cache keys are unique to the specific domain.

- **Object id is always NULL in ore hook in update activity mode
  ([14491](https://github.com/civicrm/civicrm-core/pull/14491))**

  Ensures when using the pre hook with the Activity entity, the Activity id (i.e
  the object id) is NOT NULL.

- **Scheduled jobs: replace outdated wiki link
  ([14641](https://github.com/civicrm/civicrm-core/pull/14641))**

- **Make the contact summary details popup on merge screen non bold a la contact
  summary screen ([dev/core#1039](https://lab.civicrm.org/dev/core/issues/1039):
  [14506](https://github.com/civicrm/civicrm-core/pull/14506))**

- **When using custom fields for smart group criteria with relative dates the
  group does not respect the relative date over time
  ([dev/core#389](https://lab.civicrm.org/dev/core/issues/389):
  [14625](https://github.com/civicrm/civicrm-core/pull/14625))**  

- **Improper character encoding breaks xml processor
  ([dev-core#1079](https://lab.civicrm.org/dev/core/issues/1079):
  [14654](https://github.com/civicrm/civicrm-core/pull/14654))**

- **Php 7.2 notices fix on import
  ([14531](https://github.com/civicrm/civicrm-core/pull/14531))**

- **Fix use of cached schema information in SchemaHandler
  ([14568](https://github.com/civicrm/civicrm-core/pull/14568))**

- **Ensure that contact groups caches are cleared if memory backed
  ([14607](https://github.com/civicrm/civicrm-core/pull/14607))**

- **Ensure recently converted groups cache matches previous behaviour by setting
  `withArray` as fast for it
  ([14789](https://github.com/civicrm/civicrm-core/pull/14789))**

- **Does CiviCRM make it possible to specify which directories are private and
  which are public-accessible? (continues work for
  [dev/cloud-native#3](https://lab.civicrm.org/dev/cloud-native/issues/3):
  [14717](https://github.com/civicrm/civicrm-core/pull/14717))**

  Removes an unused cache-driver for storing cache records in the file system
  (under CIVICRM_TEMPLATE_COMPILEDIR, using PHP serialize() format).

### CiviCampaign

- **CiviCRM Campaign, the Revenue Goal field stores 0 if $5,000 or any other
  non-numeric value is entered
  ([dev/core#1067](https://lab.civicrm.org/dev/core/issues/1067):
  [14601](https://github.com/civicrm/civicrm-core/pull/14601))**

### CiviCase

- **Make a_b relationships available as case roles
  ([dev/core#530](https://lab.civicrm.org/dev/core/issues/530):
  [13916](https://github.com/civicrm/civicrm-core/pull/13916))**

  This change makes it so users can select b_a relationships AND a_b
  relationships when creating case roles, before this change only b_a
  relationships were available when creating case roles.

- **Too many divs in caseTypeDetails.html
  ([dev/core#1086](https://lab.civicrm.org/dev/core/issues/1086):
  [14682](https://github.com/civicrm/civicrm-core/pull/14682))**

- **Send copy of case activity is using the contribution receipt template -
  actually all message templates seem to be mixed up (Test for
  [dev/core#1082](https://lab.civicrm.org/dev/core/issues/1082):
  [14666](https://github.com/civicrm/civicrm-core/pull/14666))**

### CiviContribute

- **Add default receive_date for contributions at BAO level
  ([14460](https://github.com/civicrm/civicrm-core/pull/14460))**

  This change ensures one cannot create contributions with no receive date using
  the API.

- **Fix A.net to resolve time when using default
  ([14540](https://github.com/civicrm/civicrm-core/pull/14540))**

  Fixes failure to resolve date in authorize.net - this is likely a test-only
  bug.

- **Fixed visibility logic on Price field options.
  ([13966](https://github.com/civicrm/civicrm-core/pull/13966))**

  Ensure that when adding price options to a price field with some public
  options and some private options the new options are considered when
  validating that there is an admin option.

- **Support storing IPNs in `civicrm_system_log` for processors that send JSON
  data ([dev/financial#55](https://lab.civicrm.org/dev/financial/issues/55):
  [14290](https://github.com/civicrm/civicrm-core/pull/14290))**

  Ensures Stripe can log to the `civicrm_system_log`.

- **Grab contribution status id from database
  ([14713](https://github.com/civicrm/civicrm-core/pull/14713) and
  [14704](https://github.com/civicrm/civicrm-core/pull/14704))**

  Replaces hard coded Contribution Status Id with a pseudoconstant.

- **Error in civicrm/payment/edit "Expected one FinancialTrxn but found 25
  ([dev/core#965](https://lab.civicrm.org/dev/core/issues/965):
  [14518](https://github.com/civicrm/civicrm-core/pull/14518))**

  Fixes a bug where when ajax popup forms are disabled submitting the payment
  edit form results in a fatal error "Expected one FinancialTrxn but found 25".

- **New contribution may overwrite other contribution if it's opened in other
  tab ([dev/financial#50](https://lab.civicrm.org/dev/financial/issues/50):
  [14244](https://github.com/civicrm/civicrm-core/pull/14244))**

- **Refund throws a fatal error if the main contribution amount is
  0. ([dev/core#889](https://lab.civicrm.org/dev/core/issues/889):
  [14488](https://github.com/civicrm/civicrm-core/pull/14488) and
  [14103](https://github.com/civicrm/civicrm-core/pull/14103))**

- **Event Confirmation and ThankYou forms show tax rate with ALL the decimal
  places. ([dev/core#1049](https://lab.civicrm.org/dev/core/issues/1049):
  [14562](https://github.com/civicrm/civicrm-core/pull/14562))**

- **Deprecation notice on Find Contributions when get there from Manage
  Contribution Pages
  ([dev/core#1059](https://lab.civicrm.org/dev/core/issues/1059):
  [14624](https://github.com/civicrm/civicrm-core/pull/14624) and
  [14613](https://github.com/civicrm/civicrm-core/pull/14613))**

- **Fix refund payment not recording from additional payment form
  ([14733](https://github.com/civicrm/civicrm-core/pull/14733))**

- **contribution detail report: error when sorting by custom contrib field (DB
  Error: no such field)
  ([dev/core#1081](https://lab.civicrm.org/dev/core/issues/1081):
  [14746](https://github.com/civicrm/civicrm-core/pull/14746))**

- **Fix notice on editing contribution
  ([14626](https://github.com/civicrm/civicrm-core/pull/14626))**

- **Ensure that completed status is selected by default on search contribution
  form ([14612](https://github.com/civicrm/civicrm-core/pull/14612))**

- **Fix unreleased regression - fatal on financial account screen
  ([14900](https://github.com/civicrm/civicrm-core/pull/14900))**

### CiviEvent

- **When creating a new event using a template the new event screen is taking
  the default values directly from the custom fields, and not from what's saved
  in the event template.
  ([dev/core#553](https://lab.civicrm.org/dev/core/issues/553) /
  [CRM-18570](https://issues.civicrm.org/jira/browse/CRM-18570):
  [14480](https://github.com/civicrm/civicrm-core/pull/14480))**

- **Display bug for Checkboxes Custom field on Event Confirm / Thank you pages
  ([dev/core#1058](https://lab.civicrm.org/dev/core/issues/1058):
  [14587](https://github.com/civicrm/civicrm-core/pull/14587))**

- **Fix incorrect display of Line Items created via API when printing invoice
  (for Participants)
  ([13477](https://github.com/civicrm/civicrm-core/pull/13477))**

- **Add a helper function to ensure we always set the correct tab for manage
  events ([14602](https://github.com/civicrm/civicrm-core/pull/14602))**

- **Removed hardcoded value for registered participant status
  ([14569](https://github.com/civicrm/civicrm-core/pull/14569))**

### CiviMail

- **Hashed mailing URLs do not work with view mailing links
  ([dev/core#1037](https://lab.civicrm.org/dev/core/issues/1037):
  [14508](https://github.com/civicrm/civicrm-core/pull/14508) and
  [14722](https://github.com/civicrm/civicrm-core/pull/14722))**

### Drupal Integration

- **Drupal8: CiviCRM menu does not use the correct locale (continues work for
  [dev/drupal#21](https://lab.civicrm.org/dev/drupal/issues/21):
  [14474](https://github.com/civicrm/civicrm-core/pull/14474))**

  Ensures CiviCRM menu is translated appropriately on Drupal 8 sites using the
  locale module and CiviCRM in multilingual mode.

- **Drupal8: drupal_set_message is deprecated (or: Event Cart messages display
  HTML) ([dev/drupal#63](https://lab.civicrm.org/dev/drupal/issues/63):
  [13959](https://github.com/civicrm/civicrm-core/pull/13959))**

  Fixes a bug where when using CiviCRM Event Cart in Drupal8, some status
  messages were being displayed as HTML to the user.

### Joomla Integration

- **Upgrade to 5.14 fails on updating case views
  ([dev/joomla#13](https://lab.civicrm.org/dev/joomla/issues/13):
  [14707](https://github.com/civicrm/civicrm-core/pull/14707),
  [14708](https://github.com/civicrm/civicrm-core/pull/14708),
  [14709](https://github.com/civicrm/civicrm-core/pull/14709),
  [14710](https://github.com/civicrm/civicrm-core/pull/14710) and
  [14702](https://github.com/civicrm/civicrm-core/pull/14702))**

- **CiviDist fails on BSD flavor of 'cp' with '-r -p' switch to '-R -p'
  ([14523](https://github.com/civicrm/civicrm-core/pull/14523))**

  Ensures cividist does not fail for joomla-alt on MacOSX.

### Wordpress Integration

- **Recreate rewrite rules when basepage setting is updated
  ([157](https://github.com/civicrm/civicrm-wordpress/pull/157))**

  Ensures rewrite rules are flushed when saving the WordPress Base Page setting
  in CiviCRM.

- **Implement "document_title_parts" filter to apply CiviCRM title on basepage
  ([158](https://github.com/civicrm/civicrm-wordpress/pull/158))**

  Ensures when Clean URLs are not implemented, the `<title>` element is
  correctly set on the civicrm base page.

## <a name="misc"></a>Miscellany

- **Revert "[REF] use generic loadStandardSearchOptionsFromUrl". Fix search
  selections. ([14918](https://github.com/civicrm/civicrm-core/pull/14918))**

- **Remove duplicated code in contribution recur search build function
  ([14504](https://github.com/civicrm/civicrm-core/pull/14504))**

- **Civi\Angular\ChangeSet - Relax debug-mode consistency check
  ([14510](https://github.com/civicrm/civicrm-core/pull/14510))**

- **Alter PSR16 code to take into account of new entitysetting release with
  upgraded caching
  ([14559](https://github.com/civicrm/civicrm-core/pull/14559))**

- **Remove handling for legacy PrevNextCache group as it has now been converted
  ([14584](https://github.com/civicrm/civicrm-core/pull/14584),
  [14631](https://github.com/civicrm/civicrm-core/pull/14631) and
  [14580](https://github.com/civicrm/civicrm-core/pull/14580))**

- **[Form cleanup] remove form classes & tpls for Event Component settings &
  Multisite ([14425](https://github.com/civicrm/civicrm-core/pull/14425))**

- **Add WP-oriented E2E test suite, with HookTest as an example
  ([159](https://github.com/civicrm/civicrm-wordpress/pull/159))**

- **Decommission recordPartialPayment function
  ([14599](https://github.com/civicrm/civicrm-core/pull/14599))**

- **Fix erroneous variable passed to callAPISuccessGetValue
  ([14688](https://github.com/civicrm/civicrm-core/pull/14688))**

- **Deprecate some deprecated address functions: defaultCurrencySymbol
  ([14687](https://github.com/civicrm/civicrm-core/pull/14687))**

- **Extract code converting a date object to local timezone object to own
  function ([14723](https://github.com/civicrm/civicrm-core/pull/14723))**

- **Replace jcalendar instances with datepicker (continues work for
  [dev/core#561](https://lab.civicrm.org/dev/core/issues/561):
  [14593](https://github.com/civicrm/civicrm-core/pull/14593),
  [14431](https://github.com/civicrm/civicrm-core/pull/14431) and
  [14627](https://github.com/civicrm/civicrm-core/pull/14627))**

- **[REF] Remove more instances of _nullArray
  ([14558](https://github.com/civicrm/civicrm-core/pull/14558))**

- **[REF] transform the setting of defaults in CustomField::create to be like
  (some) other entities
  ([14671](https://github.com/civicrm/civicrm-core/pull/14671))**

- **[NFC] Fix Test function delcaration to match change in CiviUnitTestCa…
  ([14548](https://github.com/civicrm/civicrm-core/pull/14548))**

- **[NFC] Fix indenting in Misc Setting Template
  ([14526](https://github.com/civicrm/civicrm-core/pull/14526))**

- **[NFC] code formatting
  ([14606](https://github.com/civicrm/civicrm-core/pull/14606))**

- **[NFC][test] reformat jobTest class
  ([14681](https://github.com/civicrm/civicrm-core/pull/14681))**

- **[NFC] test cleanup. Uses CRM_Core_Exceptions, properly outputs unfiltered
  results ([14471](https://github.com/civicrm/civicrm-core/pull/14471))**

- **[NFC][test] reformat activity search test
  ([14699](https://github.com/civicrm/civicrm-core/pull/14699))**

- **[NFC][test] code formatting only
  ([14700](https://github.com/civicrm/civicrm-core/pull/14700))**

- **[NFC] formatting on test class cleanup
  ([14649](https://github.com/civicrm/civicrm-core/pull/14649))**

- **NFC These pseudoconstant functions return array or string
  ([14619](https://github.com/civicrm/civicrm-core/pull/14619))**

- **NFC Comments and formatting only
  ([14497](https://github.com/civicrm/civicrm-core/pull/14497))**

- **NFC Cleanup comments on BAO event
  ([14603](https://github.com/civicrm/civicrm-core/pull/14603))**

- **[TEST] add assert to ensure nullArray & nullObject are not contaminated
  ([14543](https://github.com/civicrm/civicrm-core/pull/14543))**

- **[TEST] Update Email Common Test to incorporate testing for the fix fo…
  ([14629](https://github.com/civicrm/civicrm-core/pull/14629))**

- **[TEST] Fix intermittent test fail on NULL array getting contaminated
  ([14542](https://github.com/civicrm/civicrm-core/pull/14542))**

- **[Test] Add in unit test attempting to demonstrate issue caused by dev…
  ([14637](https://github.com/civicrm/civicrm-core/pull/14637))**

- **[test] Call parent tearDown more consistently
  ([14552](https://github.com/civicrm/civicrm-core/pull/14552))**

- **[test] convert export test to handle exception rather than early return
  ([14608](https://github.com/civicrm/civicrm-core/pull/14608))**

- **[test] truncate pledge block when cleaning up financial entities
  ([14538](https://github.com/civicrm/civicrm-core/pull/14538))**

- **Fix failing test by changing expected date format
  ([14686](https://github.com/civicrm/civicrm-core/pull/14686))**

- **Fix proportional test to test Payment.create & for the test to make more
  sense ([14436](https://github.com/civicrm/civicrm-core/pull/14436))**

- **Fix test which fails when run in isolation.
  ([14517](https://github.com/civicrm/civicrm-core/pull/14517))**

- **[REF] do not receive  by reference in CustomField::create
  ([14670](https://github.com/civicrm/civicrm-core/pull/14670))**

- **[REF] extract createOptionValue function in CustomField::create
  ([14652](https://github.com/civicrm/civicrm-core/pull/14652))**

- **[REF] remove instances of pass-by-reference where no change takes place
  ([14693](https://github.com/civicrm/civicrm-core/pull/14693))**

- **[REF] extract prepareCreate from CustomField.create
  ([14689](https://github.com/civicrm/civicrm-core/pull/14689))**

- **[REF] Minor code cleanup on string concatenation
  ([14444](https://github.com/civicrm/civicrm-core/pull/14444))**

- **[REF] Move sort_name definition to searchFieldMetadata
  ([14478](https://github.com/civicrm/civicrm-core/pull/14478))**

- **[REF] Copy assignProportional Line items back into Payment.create function
  ([14622](https://github.com/civicrm/civicrm-core/pull/14622))**

- **[REF] minor code cleanup - move indexExist calculation to the only place in
  the code that needs it
  ([14650](https://github.com/civicrm/civicrm-core/pull/14650))**

- **[REF] Remove columnName field
  ([14651](https://github.com/civicrm/civicrm-core/pull/14651))**

- **[REF + test] extract buildFieldChangeSql and add unit test
  ([14653](https://github.com/civicrm/civicrm-core/pull/14653))**

- **[REF] CRM_Case_BAO_Case::addcaseActivityLinks to CRM_Case_Selector_Search
  ([14512](https://github.com/civicrm/civicrm-core/pull/14512))**

- **[REF] dev/core#561 Convert Contribution Date field to use date picker…
  ([14486](https://github.com/civicrm/civicrm-core/pull/14486))**

- **[REF] do not pass  by reference to store & create functions
  ([14598](https://github.com/civicrm/civicrm-core/pull/14598))**

- **[REF] Add in utility function for resetting ACL and System Level Caches
  ([14600](https://github.com/civicrm/civicrm-core/pull/14600))**

- **REF Extract getDefaultRoleID for add participant
  ([14499](https://github.com/civicrm/civicrm-core/pull/14499))**

- **REF Deduplicate recaptcha handling code
  ([14500](https://github.com/civicrm/civicrm-core/pull/14500))**

- **REF Extract override default currency function
  ([14496](https://github.com/civicrm/civicrm-core/pull/14496))**

- **REF: Extract preProcess paypalexpress
  ([14498](https://github.com/civicrm/civicrm-core/pull/14498))**

- **Remove more uses of CRM_Core_DAO::$_nullArray that are unncessary
  ([14564](https://github.com/civicrm/civicrm-core/pull/14564))**

- **Remove unncessary $_nullArray usage when calling createProfileContact
  function ([14560](https://github.com/civicrm/civicrm-core/pull/14560))**

- **Remove unneeded use of CRM_Core_DAO::$_nullArray in executeQuery or s…
  ([14561](https://github.com/civicrm/civicrm-core/pull/14561))**

- **Remove more free calls
  ([14493](https://github.com/civicrm/civicrm-core/pull/14493))**

- **Remove a few places where pass by reference is used but does not need to be
  ([14643](https://github.com/civicrm/civicrm-core/pull/14643))**

- **Remove failing assertion
  ([14695](https://github.com/civicrm/civicrm-core/pull/14695))**

- **Removing unused spec function
  ([14646](https://github.com/civicrm/civicrm-core/pull/14646))**

- **Remove superfluous pass-by-ref in api3
  ([14645](https://github.com/civicrm/civicrm-core/pull/14645))**

- **Add in Andrei Mondoc(mecachisenros) to contributor key
  ([14665](https://github.com/civicrm/civicrm-core/pull/14665))**

- **Adding myself to the contributors file
  ([14532](https://github.com/civicrm/civicrm-core/pull/14532))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt, Eli Lisseck; Agileware - Alok Patel,
Francis Whittle; Andrei Mondoc; Australian Greens - Seamus Lee; Christian Wach;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC -
Mathieu Lutfy, Samuel Vanhove; Dave D; Electronic Frontier Foundation - Mark
Burdett; Fuzion - Jitendra Purohit; Greenpeace CEE - Patrick Figel; iXiam -
César Ramos; JMA Consulting - Monish Deb; John Kingsnorth; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich;
Pradeep Nayak; Squiffle Consulting - Aidan Saunders; Tadpole Collective - Kevin
Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; CiviCoop - Jaap Jansma; CiviDesk - Sunil Pawar;
Fuzion - Luke Stewart; JMA Consulting - Joe Murray; Korlon - Stuart Gaston;
Lighthouse Design and Consulting - Brian Shaughnessy; National Urban League -
Lisa Taliano; Palante Technology Cooperative - Morgan Robinson; Semper IT -
Karin Gerritsen; Tech To The People - Xavier Dutoit

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
