# CiviCRM 5.22.0

Released February 5, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Field Names now Reserved Words in MySQL8
  ([dev/core#1143](https://lab.civicrm.org/dev/core/issues/1143),
  [dev/core#1144](https://lab.civicrm.org/dev/core/issues/1144) and
  [dev/core#1480](https://lab.civicrm.org/dev/core/issues/1480):
  [16179](https://github.com/civicrm/civicrm-core/pull/16179) and
  [16182](https://github.com/civicrm/civicrm-core/pull/16182))**

  Allows CiviCRM installations to run on MySQL8 and updates the test
  infastructure to support MySQL8.

- **Add controlField metadata for ChainSelect fields
  ([16164](https://github.com/civicrm/civicrm-core/pull/16164))**

  Adds additional field metadata for state/province and county address fields
  for the sake of autogenerated forms (afform).

- **Allow Angular modules to provide dynamic HTML snippets
  ([16078](https://github.com/civicrm/civicrm-core/pull/16078))**

  Supports afforms dynamic templates by allowing angular partials to be passed
  as strings not just file paths.

- **Allow values to be passed to api4 GetFields
  ([16154](https://github.com/civicrm/civicrm-core/pull/16154) and
  [16162](https://github.com/civicrm/civicrm-core/pull/16162))**

  Makes it possible to filter api4 `getFields` calls by contact
  type, only returning custom fields appropriate to certain contact types.

- **Pass api4 getFields values through to getOptions
  ([16168](https://github.com/civicrm/civicrm-core/pull/16168))**

  Allows option filtering in api4, similar to how it works in api3.

- **Add api to check for missing indices
  ([16145](https://github.com/civicrm/civicrm-core/pull/16145))**

  Adds an api to check for missing mysql indices.

- **Add in Country and StateProvince APIv4 Entities
  ([16110](https://github.com/civicrm/civicrm-core/pull/16110))**

  Adds Country and StateProvince APIv4 Entities.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (Work Towards [dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [16141](https://github.com/civicrm/civicrm-core/pull/16141) and
  [16067](https://github.com/civicrm/civicrm-core/pull/16067))**

  Work towards throwing exceptions (instead of fatal errors).

- **Deadlocked queries cause an instant error for end-users, but are retried in
  other circumstances (Work Towards
  [dev/core#395](https://lab.civicrm.org/dev/core/issues/395):
  [275](https://github.com/civicrm/civicrm-packages/pull/275) and
  [16143](https://github.com/civicrm/civicrm-core/pull/16143))**

  Improves logging from deadlocks specifically, before this change an error
  recorded because of a deadlock query was recorded as "DBError::Unknown Error"
  now they are recorded as "DBError::deadlock".

### CiviContribute

- **We should give user feedback in case of a Payment Processor Exception
  ([15676](https://github.com/civicrm/civicrm-core/pull/15676))**

  Improves user experience when updating or canceling a recurring payment by
  displaying any error message sent from the payment processor to the user.

- **Code cleanup Update Paypal invokeApi to only throw exceptions.
  ([16072](https://github.com/civicrm/civicrm-core/pull/16072))**

  Standardizes and improves error handling within PayPal.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CIVI-SA-2019-21 may lead to regressions when following typehints on
  CRM_Core_BAO_Setting::setItem()
  ([dev/core#1425](https://lab.civicrm.org/dev/core/issues/1425):
  [15975](https://github.com/civicrm/civicrm-core/pull/15975))**

  Deprecates old setItem & setOptionValue functions on
  BAO_Setting to prevent regressions.

- **Deadlocks on acl_cache (Work Towards
  [dev/core#1486](https://lab.civicrm.org/dev/core/issues/1486):
  [16144](https://github.com/civicrm/civicrm-core/pull/16144))**

  Adds an index to the `civicrm_acl_cache.modified_date` column to reduce
  deadlocks when running the ACL Cache.

- **Port "+options" for constant-parameters to APIv4-PHP (Work Towards
  [dev/core#1489](https://lab.civicrm.org/dev/core/issues/1489):
  [16149](https://github.com/civicrm/civicrm-core/pull/16149))**

  Ensures managed entities are not reconciled during upgrades.

- **Api4 - Fix auto serialize array input for CheckBox/MultiSelect fields
  ([16152](https://github.com/civicrm/civicrm-core/pull/16152))**

  In Api4, serialized fields should input/output as array data. This wasn't
  working on the input side for custom entities. This fixes array input handling
  and adds test coverage.

- **Fix output display in api4 explorer
  ([16130](https://github.com/civicrm/civicrm-core/pull/16130))**

  Ensures api4 explorer displays output with html entities properly.

- **Add in searchFieldMetadata for contact_tags, contact_type, group and
  deleted_contacts fields for contribute, pledge searches
  ([15942](https://github.com/civicrm/civicrm-core/pull/15942))**

  Adds url support on search forms (other than the search builder) for the
  following fields: `contact_tags`, `contact_type`, `group` and
  `deleted_contacts`.

- **Update Smart Group form uses different labels for Group Title and Group
  Description ([16042](https://github.com/civicrm/civicrm-core/pull/16042))**

  Improves user experience by making the Smart Group field labels on the
  Advanced Search from match the labels used on the Smart Group edit form.

- **Update Smart Group form unsets the existing Group Types
  ([16043](https://github.com/civicrm/civicrm-core/pull/16043))**

  Ensures the Mailing List group type remains set on the Update Smart Group
  form.

- **loadServices: tighten up file match regex
  ([16377](https://github.com/civicrm/civicrm-core/pull/16377))**

  Ensures that CiviCRM code living under a path containing the characters 'php'
  does not crash when loading services.

- **Activity type listing shows name instead label
  ([dev/core#1470](https://lab.civicrm.org/dev/core/issues/1470):
  [16094](https://github.com/civicrm/civicrm-core/pull/16094))**

- **Export doesn't work in Excel with diacritic chars
  ([dev/core#1424](https://lab.civicrm.org/dev/core/issues/1424):
  [16117](https://github.com/civicrm/civicrm-core/pull/16117) and
  [15968](https://github.com/civicrm/civicrm-core/pull/15968))**

- **text missing from email column when custom search profile is used
  in Advanced Search
  ([dev/core#1474](https://lab.civicrm.org/dev/core/issues/1474):
  [16101](https://github.com/civicrm/civicrm-core/pull/16101))**

- **Undefined offset and uninitialized string offset notices on upgrade to 5.21
  ([dev/core#1555](https://lab.civicrm.org/dev/core/issues/1555):
  [16417](https://github.com/civicrm/civicrm-core/pull/16417))**

### CiviCase

- **Add case activity action links to activity report
  ([15135](https://github.com/civicrm/civicrm-core/pull/15135))**

  Ensures if an activity is linked to a case the "case activity" actions are
  displayed instead of the standard activity actions (eg. move/copy to case
  instead of file on case).

- **Activity Details CiviReport gives network error when paging to next page if
  choose filter to include case activities
  ([dev/core#1552](https://lab.civicrm.org/dev/core/issues/1552):
  [16393](https://github.com/civicrm/civicrm-core/pull/16393))**

- **Case Detail 'Active Role?' filter excludes cases without relationships
  ([dev/report#24](https://lab.civicrm.org/dev/report/issues/24):
  [15972](https://github.com/civicrm/civicrm-core/pull/15972))**

- **Manager/Creator Information not being returned for case related contacts
  when fetching Case Details
  ([dev/core#1426](https://lab.civicrm.org/dev/core/issues/1426):
  [16006](https://github.com/civicrm/civicrm-core/pull/16006))**

### CiviContribute

- **Thousands-separator corrupts price field values (comma)
  ([dev/core#1472](https://lab.civicrm.org/dev/core/issues/1472):
  [16111](https://github.com/civicrm/civicrm-core/pull/16111))**

  Fixes a bug where price options with thousands operators didn't submit
  correctly.

- **E notice fix on Price set form
  ([16096](https://github.com/civicrm/civicrm-core/pull/16096))**

  Removes an e notice when submitting the price set form.

- **Advanced search fails to properly search for contribution source
  ([dev/core#1468](https://lab.civicrm.org/dev/core/issues/1468):
  [16083](https://github.com/civicrm/civicrm-core/pull/16083))**

### CiviEvent

- **Event Participants actions (Print Name Badges, Export...) ignores search
  criteria ([dev/core#1422](https://lab.civicrm.org/dev/core/issues/1422):
  [16038](https://github.com/civicrm/civicrm-core/pull/16038))**

  Ensures that the actions menu on the participant search form respects search
  criteria.

### CiviMail

- **Exception Malformed temp table category on New A/B Test
  ([dev/core#1564](https://lab.civicrm.org/dev/core/issues/1564):
  [16464](https://github.com/civicrm/civicrm-core/pull/16464))**

  Fixes a regression in 5.21.2 where creating a new A/B Test resulted in a
  session status Exception Malformed temp table.

### CiviMember

- **Fix js error on choosing membership type
  ([16058](https://github.com/civicrm/civicrm-core/pull/16058))**

  Fixes a javascript error "Uncaught ReferenceError" when choosing a membership
  type from the backend membership signup form.

### Drupal Integration

- **Error when creating user record for Civi contact
  ([dev/drupal#99](https://lab.civicrm.org/dev/drupal/issues/99):
  [16157](https://github.com/civicrm/civicrm-core/pull/16157))**

  Fixes an E-notice "Notice: Trying to get property 'id' of non-object in
  CRM_Core_BAO_UFMatch::updateContactEmail() (line 449 of
  /var/www/sitename/vendor/civicrm/civicrm-core/CRM/Core/BAO/UFMatch.php)." when
  submitting the "Create User Record" form which can be found from the "Actions"
  menu-button while viewing a CRM contact.

- **Missing address on `/user` when location type label differs from its name
  ([dev/core#1473](https://lab.civicrm.org/dev/core/issues/1473):
  [16100](https://github.com/civicrm/civicrm-core/pull/16100))**

### Wordpress Integration

- **Fix basepage title for Yoast SEO when theme declares "title-tag" support
  ([174](https://github.com/civicrm/civicrm-wordpress/pull/174))**

  Fixes a bug for sites with the Yoast SEO plugin where the CiviCRM page title
  was not being displayed properly. Specifically the Yoast SEO plugin
  short-circuits the code in `wp_get_document_title()` by filtering via
  `pre_get_document_title`. This means that the CiviCRM code to apply the
  CiviCRM basepage title via the document_title_parts filter is never reached
  and the basepage title does not reflect the CiviCRM content.

## <a name="misc"></a>Miscellany

- **Fix typo, Mailign should be Mailing
  ([16031](https://github.com/civicrm/civicrm-core/pull/16031))**

- **Switch static var to using Civi::statics
  ([16138](https://github.com/civicrm/civicrm-core/pull/16138))**

- **Remove code to create a subscription history entry when a contact is created
  ([dev/core#1482](https://lab.civicrm.org/dev/core/issues/1482):
  [16125](https://github.com/civicrm/civicrm-core/pull/16125))**

- **Remove unnecessary query when updating org, if no name update.
  ([16080](https://github.com/civicrm/civicrm-core/pull/16080))**

- **Remove unnecessary, and possibly incorrect query from email update
  ([16079](https://github.com/civicrm/civicrm-core/pull/16079))**

- **Remove unneeded zendframwork/zend-validator and zendframwork/zend-stdlib
  packages as not required by any other package
  ([16112](https://github.com/civicrm/civicrm-core/pull/16112))**

- **Remove legacy_redirect_path handling
  ([16134](https://github.com/civicrm/civicrm-core/pull/16134))**

- **Remove function marked as deprecated & unused by core nearly a year ago
  ([16124](https://github.com/civicrm/civicrm-core/pull/16124))**

- **Remove vestige of apiv2
  ([16115](https://github.com/civicrm/civicrm-core/pull/16115))**

- **Remove PEAR package Structures_Graph as there appears to be no use for it
  ([279](https://github.com/civicrm/civicrm-packages/pull/279))**

- **Remove Net_UserAgent_Detect package
  ([272](https://github.com/civicrm/civicrm-packages/pull/272))**

- **Paypal class cleanup
  ([16088](https://github.com/civicrm/civicrm-core/pull/16088))**

- **2020 test fixes.
  ([16172](https://github.com/civicrm/civicrm-core/pull/16172))**

- **Unit test for https://github.com/civicrm/civicrm-core/pull/16120
  ([16127](https://github.com/civicrm/civicrm-core/pull/16127))**

- **Update unit tests to use name spaced format of phpunit test classes for
  phpunit6 compatability
  ([594](https://github.com/civicrm/civicrm-drupal/pull/594))**

- **Update to use the namespaced version of the PHPUnit test classes as this
  will work for phpunit6 going forward as well as phpunit5
  ([175](https://github.com/civicrm/civicrm-wordpress/pull/175))**

- **Update PHPUnit Test class declarations to use namespaced format for phpunit6
  compatability ([108](https://github.com/civicrm/civicrm-backdrop/pull/108))**

- **[REF] Minor cleanup - declare exceptions, use single quotes, strict
  comparison ([16137](https://github.com/civicrm/civicrm-core/pull/16137))**

- **[REF] remove CRM_Core_Error check
  ([16136](https://github.com/civicrm/civicrm-core/pull/16136))**

- **[REF] Convert more petition signature fatals to status bounce
  ([16075](https://github.com/civicrm/civicrm-core/pull/16075))**

- **[REF] Switch CRM_Utils_Error::fatal calls for CRM_Core_Exception in Grant.
  utils, bin/ and Civi/Angular/ folders
  ([16109](https://github.com/civicrm/civicrm-core/pull/16109))**

- **[REF] Minor simplification on additional_participants checks
  ([16056](https://github.com/civicrm/civicrm-core/pull/16056))**

- **[REF] Refactor Contact Search form to use standardised getSortID function
  ([16054](https://github.com/civicrm/civicrm-core/pull/16054))**

- **[REF] Refactor Activity Search to use parent getSortID function
  ([16053](https://github.com/civicrm/civicrm-core/pull/16053))**

- **[REF] Refactor Campaign Search form to use standardised getSortID function
  ([16055](https://github.com/civicrm/civicrm-core/pull/16055))**

- **[REF] Move wrangling of Front end form contribution param for autoRenew back
  to form ([15927](https://github.com/civicrm/civicrm-core/pull/15927))**

- **[REF] Replace Deprecated function CRM_Core_BAO_Setting::setItem with the
  relevant Civi::contactSettings function
  ([16044](https://github.com/civicrm/civicrm-core/pull/16044))**

- **[REF] remove unused  from getACLRoles
  ([16180](https://github.com/civicrm/civicrm-core/pull/16180))**

- **[REF] simplify recordAdjustedAmt function
  ([16135](https://github.com/civicrm/civicrm-core/pull/16135))**

- **[REF] extract member form batch update & add test
  ([16151](https://github.com/civicrm/civicrm-core/pull/16151))**

- **[REF] Remove unused params from function signature for getACLs
  ([16175](https://github.com/civicrm/civicrm-core/pull/16175))**

- **[REF] step towards wiping out  $ids array in membership bao functions
  ([16132](https://github.com/civicrm/civicrm-core/pull/16132))**

- **[Ref] improve readability of acl code
  ([16131](https://github.com/civicrm/civicrm-core/pull/16131))**

- **[Ref] Remove php4 support from BAO_Acl class
  ([16119](https://github.com/civicrm/civicrm-core/pull/16119))**

- **(NFC) Civi, CRM, tests - Update for
  Drupal.Commenting.VariableComment.IncorrectVarType
  ([16384](https://github.com/civicrm/civicrm-core/pull/16384))**

- **[NFC] Test clean up.
  ([16133](https://github.com/civicrm/civicrm-core/pull/16133))**

- **[NFC] cleanup to declared exceptions, quotes, strict mode.
  ([16114](https://github.com/civicrm/civicrm-core/pull/16114))**

- **[NFC] Declare exceptions, use single quotes where possible, use strict
  comparison ([16142](https://github.com/civicrm/civicrm-core/pull/16142))**

- **[NFC] Add in unit test for dev/core#1460
  ([16063](https://github.com/civicrm/civicrm-core/pull/16063))**

- **[NFC] code cleanup
  ([16050](https://github.com/civicrm/civicrm-core/pull/16050))**

- **[NFC] Add in a unit test of passing an array into the Civi::settings set
  facade and getting it back
  ([16045](https://github.com/civicrm/civicrm-core/pull/16045))**

- **[NFC] Add test on buildMembershipTypeValues & cleanup class
  ([16167](https://github.com/civicrm/civicrm-core/pull/16167))**

- **[NFC] Re-generate DAOs
  ([16178](https://github.com/civicrm/civicrm-core/pull/16178))**

- **[NFC] Extract duplicated code lines in test
  ([16165](https://github.com/civicrm/civicrm-core/pull/16165))**

- **[NFC] Clean up unit test
  ([16163](https://github.com/civicrm/civicrm-core/pull/16163))**

- **[NFC] If statement is always true
  ([16122](https://github.com/civicrm/civicrm-core/pull/16122))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Australian Greens -
Seamus Lee; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM -
Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy; Dave D; Fuzion -
Jitendra Purohit; MJW Consulting - Matthew Wire; Squiffle Consulting - Aidan
Saunders; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; CiviDesk - Yashodha
Chaku; Joinery - Allen Shaw; Megaphone Technology Consulting - Jon Goldberg;
Tadpole Collective - Kevin Cristiano;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
