# CiviCRM 5.34.0

Released February 3, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Re-Thinking our Crypto implementation
  ([dev/core#2258](https://lab.civicrm.org/dev/core/-/issues/2258):
  [19236](https://github.com/civicrm/civicrm-core/pull/19236),
  [19251](https://github.com/civicrm/civicrm-core/pull/19251),
  [19239](https://github.com/civicrm/civicrm-core/pull/19239),
  [19349](https://github.com/civicrm/civicrm-core/pull/19349),
  [237](https://github.com/civicrm/civicrm-wordpress/pull/237),
  [57](https://github.com/civicrm/civicrm-joomla/pull/57),
  [125](https://github.com/civicrm/civicrm-backdrop/pull/125),
  [635](https://github.com/civicrm/civicrm-drupal/pull/635), and
  [57](https://github.com/civicrm/civicrm-drupal-8/pull/57))**

  This adds a new framework for encrypting setting values that are stored in the
  database.  An encryption key is defined upon installation, and the key can be
  rotated using APIv4.  Keys can also be managed with a new
  `hook_civicrm_crypto`.  The system allows for old keys to be retained for
  decrypting old values even as a new key is used for encrypting new ones.

  The only setting that is changed at this point is the SMTP password, as that
  was the only setting in core encrypted with `CRM_Utils_Crypt`.  However, this
  framework is available for extensions and will likely be adopted for other
  sensitive settings.

  You may optionally configure `CIVICRM_CRED_KEYS` in `civicrm.settings.php`
  upon upgrade.  Sites that define `smtpPassword` in their
  `civicrm.settings.php` file may need to update the value.  See
  [pull request 19239](https://github.com/civicrm/civicrm-core/pull/19239) for
  details.

  Meanwhile, `CRM_Utils_Crypt` is retained (but deprecated) for compatibility
  with the extensions that use it.

- **Add pre() and post() hooks for ufgroup entity
  ([dev/core#2199](https://lab.civicrm.org/dev/core/-/issues/2199):
  [18995](https://github.com/civicrm/civicrm-core/pull/18995))**

  The pre and post hooks are now triggered when modifying profiles.

- **Add support for multi-value contact reference custom fields
  ([18941](https://github.com/civicrm/civicrm-core/pull/18941))**

  Makes it so users can configure a multi-value contact reference custom field.

- **Add missing state for South Korea
  ([19157](https://github.com/civicrm/civicrm-core/pull/19157))**

  This adds the special self-governing city Sejong to the state/province table
  for South Korea.

- **CRM_Core_Key - Provide more debugging hints about mismatched `qfKey` values
  ([19145](https://github.com/civicrm/civicrm-core/pull/19145))**

  The qfKey now has a prefix that corresponds with the form name.

- **Add min-width to flex columns for responsive layout on small screens
  ([19235](https://github.com/civicrm/civicrm-core/pull/19235))**

  This adjusts 2-column layouts on the main CiviCRM dashboard and Search Kit to
  collapse to 1 column on small screens.

- **APIv4 - Add "Permission.get" for listing available permissions
  ([19115](https://github.com/civicrm/civicrm-core/pull/19115))**

  Adds a new API method "Permission.get" to be used for administrative tools
  that allow one to choose/assign a permission.

- **APIv4: Support relative date range input
  ([19181](https://github.com/civicrm/civicrm-core/pull/19181))**

  Extends APIv4 to support relative date range inputs.

- **Free the joins! APIv4 explicit joins - can we remove the requirement for
  specific columns in the "on" clause? (Work Towards
  [dev/core#2271](https://lab.civicrm.org/dev/core/-/issues/2271):
  [19275](https://github.com/civicrm/civicrm-core/pull/19275))**

  Allows greater flexibility in how explicit joins are performed in APIv4.

- **Non translatable fields in profile schema (Work Towards
  [dev/core#527](https://lab.civicrm.org/dev/core/-/issues/527):
  [19291](https://github.com/civicrm/civicrm-core/pull/19291))**

  Ensures the public title is used and translatable for on behalf profiles,
  confirm pages and thank you pages.

- **Proposal - add hook alterIndices
  (Work Towards [dev/core#2279](https://lab.civicrm.org/dev/core/-/issues/2279):
  [19293](https://github.com/civicrm/civicrm-core/pull/19293) and
  [19288](https://github.com/civicrm/civicrm-core/pull/19288))**

  Adds indexes to `campaign.name` and `civicrm_group.cache_date`.

### CiviContribute

- **Wording change - change UI parts of contribution soft schema to soft credit
  ([dev/financial#158](https://lab.civicrm.org/dev/financial/-/issues/158):
  [19085](https://github.com/civicrm/civicrm-core/pull/19085))**

  Improves user experience of Search Kit/Afform by cleaning up language
  related to Soft Credits.

- **Cancel first contribution associated to membership, cancels the membership
  (Work Towards [dev/core#927](https://lab.civicrm.org/dev/core/-/issues/927):
  [19019](https://github.com/civicrm/civicrm-core/pull/19019))**

  Completes moving the logic for the contribution statuses "Cancel" and "Fail"
  from core to the `contributioncancelactions` extension.

- **Move financial acl warning from FinancialType BAO to extension.
  ([19283](https://github.com/civicrm/civicrm-core/pull/19283))**

  Moves more code from core to the financial acls extension.

- **Add ContributionSoft v4 api
  ([19083](https://github.com/civicrm/civicrm-core/pull/19083))**

  Adds the Contribution Soft entity to APIv4.

- **Add v4 api for financial type, financial account
  ([19282](https://github.com/civicrm/civicrm-core/pull/19282))**

  Adds "Financial Type" and "Financial Account" entities to APIv4.

- **[APIv4] Permit using other SQL functions such as CONCAT within a
  GROUP_CONCAT ([19255](https://github.com/civicrm/civicrm-core/pull/19255))**

  Allows for SQL functions such as CONCAT to be used within a GROUP CONCAT,
  this maybe useful for example when trying to get all the line items associated with a
  contribution into one field.

- **Add default for boolean fields on financial_type
  ([19281](https://github.com/civicrm/civicrm-core/pull/19281) and
  [19335](https://github.com/civicrm/civicrm-core/pull/19335))**

  Sets default values for the "Financial Type" fields 'is_active' and
  'is_reserved'.

- **Improve logging when a contribution is created/updated
  ([19252](https://github.com/civicrm/civicrm-core/pull/19252))**

  Improves logging when a Contribution is created/updated to improve the
  debugging experience.

### CiviEvent

- **Add a unique event ID so we can match pre/post Insert/Update
  ([19209](https://github.com/civicrm/civicrm-core/pull/19209))**

  Makes it so developers can use the event ID to link pre/post Insert/Update
  events for the same change.

### Search Kit

- **Search kit: Rewrite input widget to support IN sets, relative dates, BETWEEN
  groups, etc. ([19229](https://github.com/civicrm/civicrm-core/pull/19229))**

  Overhauls the input widget for all fields in Search Kit so that they support:
  IN, BETWEEN etc.

- **Search kit: Improve token support
  ([19260](https://github.com/civicrm/civicrm-core/pull/19260))**

  Adds a token selector to the Search Kit UI when configuring displays.

### WordPress Integration

- **Enhance CiviCRM's integration in WordPress
  ([231](https://github.com/civicrm/civicrm-wordpress/pull/231))**

  Improves user experience for WordPress sites by introducing sub menu items to the
  WordPress SideBar "CiviCRM" Menu item including:
  - Integration Page
  - Settings Page

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **jquery.validate.js update (includes CVE-2021-21252)
  ([dev/core#2324](https://lab.civicrm.org/dev/core/-/issues/2324):
  [19457](https://github.com/civicrm/civicrm-core/pull/19457))**

  The jQuery Validate library contained a regular expression that was vulnerable
  to ReDoS (Regular Expression Denial of Service).

  ReDoS, or Regular Expression Denial of Service, is a vulnerability affecting
  poorly constructed and potentially inefficient regular expressions which can
  make them perform extremely badly given a creatively constructed input string.

  This offers security hardening by preventing a user from entering a string
  that could tie up their browser in validating it.

- **Fix updating custom field schema when toggling search or multiple
  ([18939](https://github.com/civicrm/civicrm-core/pull/18939))**

  Fixes a crash & possible data loss when changing a custom field of type
  "Country" or "State/Province" from a multi-select to single or vice versa.

- **Quick fix on summary actions conflict
  ([19067](https://github.com/civicrm/civicrm-core/pull/19067))**

  If multiple extensions insert items with the same weight into the contact
  summary actions drop-down, this ensures all menu items are displayed.

- **Greenwich: Fix Select2 free-tagging css bug
  ([19225](https://github.com/civicrm/civicrm-core/pull/19225))**

  Adds a CSS tweak to Greenwich that fixes a style conflict between Bootstrap
  and Select2.

- **APIv4: Normalize option list descriptions as plain text
  ([19237](https://github.com/civicrm/civicrm-core/pull/19237))**

  Ensures the description field comes through as plain text when fetching option
  lists from APIv4.

- **Unwanted mail blast sent by Scheduled Reminders (Work Towards
  [dev/core#365](https://lab.civicrm.org/dev/core/-/issues/365):
  [19068](https://github.com/civicrm/civicrm-core/pull/19068))**

  This adds a `created_date` column to the `action_schedule` table.  This is in
  anticipation of a change to prevent a newly-created scheduled reminder from
  triggering reminders that would be due to send prior to the creation of the
  reminder.

- **Editing a smartgroup created through the search builder renders the new
  block by force
  ([dev/core#2270](https://lab.civicrm.org/dev/core/-/issues/2270):
  [19257](https://github.com/civicrm/civicrm-core/pull/19257))**

  Ensures the new record type and operator line only appear on the new search
  builder form (not when editing existing smart groups via search builder).

- **Merge all members into the same household when using select fields fails
  with a db error
  ([dev/core#2272](https://lab.civicrm.org/dev/core/-/issues/2272):
  [19268](https://github.com/civicrm/civicrm-core/pull/19268))**

  Fixes a DB Error when exporting contacts using the "Merge Household members
  into their Households" setting and selecting fields for export.

- **civicrm-setup - Error during, uh, let's call them unit tests, if db port
  isn't specified
  ([dev/core#2286](https://lab.civicrm.org/dev/core/-/issues/2286):
  [19324](https://github.com/civicrm/civicrm-core/pull/19324))**

  Avoids a notice of a missing db port during install.

- **Move non-compliant trigger_error out of logging
  ([dev/core#2241](https://lab.civicrm.org/dev/core/-/issues/2241) and
  [dev/core#2240](https://lab.civicrm.org/dev/core/-/issues/2240):
  [19256](https://github.com/civicrm/civicrm-core/pull/19256))**

  Makes CRM_Core_Error_Log more PSR3-compliant by not throwing errors itself,
  and removing dependence on the presence of a .git folder.

- **Tabs at top of extension list are no longer tabs
  ([dev/core#2233](https://lab.civicrm.org/dev/core/-/issues/2233):
  [19138](https://github.com/civicrm/civicrm-core/pull/19138))**

  Fixes broken tabs on the profiles administration page.

- **Weird "null" after adding new tagset
  ([dev/core#2234](https://lab.civicrm.org/dev/core/-/issues/2234):
  [19131](https://github.com/civicrm/civicrm-core/pull/19131))**

  Ensures the word 'null' is not displayed after adding a new tagset.

- **Stop preventing test runs and dev sites from seeing PHP deprecation notices
  ([19330](https://github.com/civicrm/civicrm-core/pull/19330))**

  Ensures notices appear based on the sites error reporting settings.

- **Unable to delete file with brackets in filename via ckeditor/kcfinder
  ([dev/user-interface#25](https://lab.civicrm.org/dev/user-interface/-/issues/25):
  [304](https://github.com/civicrm/civicrm-packages/pull/304))**

- **Obsolete wkhtmltopdfPath causes hard fail in event registration due to
  internal fatal error for the missing package
  ([dev/core#2028](https://lab.civicrm.org/dev/core/-/issues/2028):
  [19311](https://github.com/civicrm/civicrm-core/pull/19311))**

  If the setting for the path to wkhtmltopdf is set, but nothing is there at
  that path, a system check message will appear and PDF generation will fall
  back to domPDF.

- **Contact import by CSV fails when string ends with "à"
  ([dev/core#2127](https://lab.civicrm.org/dev/core/-/issues/2127):
  [19241](https://github.com/civicrm/civicrm-core/pull/19241))**

  In certain encodings, the &agrave; character can have the same byte as a
  non-breaking space.  This ensures that trimming non-breaking spaces does not
  accidentally snag multi-byte characters that share the same `0xA0` byte.

- **Activity Summary report is missing pagination
  ([dev/core#2174](https://lab.civicrm.org/dev/core/-/issues/2174):
  [19146](https://github.com/civicrm/civicrm-core/pull/19146))**

- **Export crashes when many contacts share an address and are merged
  ([dev/core#2211](https://lab.civicrm.org/dev/core/-/issues/2211):
  [19216](https://github.com/civicrm/civicrm-core/pull/19216))**

- **Deprecation warnings are implemented backwards
  ([dev/core#2240](https://lab.civicrm.org/dev/core/-/issues/2240):
  [19266](https://github.com/civicrm/civicrm-core/pull/19266))**

- **CiviCRM Export, Saved Export Field Mapping that contains custom fields which
  have been disabled or deleted are still loaded as "clear" values and cause the
  export download to fail with "DB Error: no such field"
  ([dev/core#2242](https://lab.civicrm.org/dev/core/-/issues/2242):
  [19199](https://github.com/civicrm/civicrm-core/pull/19199))**

- **Inline email edit form fails to set is_bulkmail flag
  ([dev/core#2254](https://lab.civicrm.org/dev/core/-/issues/2254):
  [19224](https://github.com/civicrm/civicrm-core/pull/19224))**

- **Accept PHP memory_limit of -1 as meeting requirement
  ([19340](https://github.com/civicrm/civicrm-core/pull/19340))**

- **Fix hook_civicrm_permission upgrade failure. Defer system-flush to
  'upgrade.finish' phase.
  ([19346](https://github.com/civicrm/civicrm-core/pull/19346))**

  On Drupal and Backdrop sites, the system flush was triggered after each
  incremental database update.  It is now deferred until the end of the upgrade
  process.

- **Fix APIv3 profile.getfields to return correctly keyed phone field
  ([19321](https://github.com/civicrm/civicrm-core/pull/19321))**

- **Reports don't filter with empty custom fields
  ([dev/core#2173](https://lab.civicrm.org/dev/core/-/issues/2173):
  [19057](https://github.com/civicrm/civicrm-core/pull/19057))**

- **Fatal error on contribution summary report (and probably others) when adding
  contacts to group
  ([19250](https://github.com/civicrm/civicrm-core/pull/19250))**

  This disables full group by mode for reports that are not optimized to work
  with it.

- **Stop passing ids as reference
  ([19204](https://github.com/civicrm/civicrm-core/pull/19204))**

- **Fix extensions tabs following deprecation of old tab code
  ([19130](https://github.com/civicrm/civicrm-core/pull/19130))**

- **php 7.4 compatibility
  ([19355](https://github.com/civicrm/civicrm-core/pull/19355),
  [19350](https://github.com/civicrm/civicrm-core/pull/19350),
  [19331](https://github.com/civicrm/civicrm-core/pull/19331),
  [19353](https://github.com/civicrm/civicrm-core/pull/19353) and
  [19354](https://github.com/civicrm/civicrm-core/pull/19354))**

  Assorted changes to make the code compatible with php 7.4.

### CiviCampaign

- **Menu links for Petitions, Surveys do not open correct tab
  ([dev/core#2215](https://lab.civicrm.org/dev/core/-/issues/2215):
  [19066](https://github.com/civicrm/civicrm-core/pull/19066))**

### CiviCase

- **Add timeline dropdown on manage case no longer working
  ([dev/core#2292](https://lab.civicrm.org/dev/core/-/issues/2292):
  [19356](https://github.com/civicrm/civicrm-core/pull/19356))**

### CiviContribute

- **Error creating thank you letter with multiple contributions
  ([dev/core#2344](https://lab.civicrm.org/dev/core/-/issues/2344):
  [19480](https://github.com/civicrm/civicrm-core/pull/19480),
  [19481](https://github.com/civicrm/civicrm-core/pull/19481), and
  [19482](https://github.com/civicrm/civicrm-core/pull/19482))**

  This resolves an invalid currency error when generating a thank you letter
  grouping multiple contributions per contact.

- **fix email receipt flag for recurring record
  ([19299](https://github.com/civicrm/civicrm-core/pull/19299))**

  Ensures receipts are not sent for each recurring payment.

- **Owner notification email sending before payment (Work Towards
  [dev/core#521](https://lab.civicrm.org/dev/core/-/issues/521):
  [19259](https://github.com/civicrm/civicrm-core/pull/19259))**

  Code clean up towards ensuring that owner notification emails do not get sent
  before the payment is made.

- **Fully remove contributionTypeID (Work Towards
  [dev/financial#163](https://lab.civicrm.org/dev/financial/-/issues/163):
  [19174](https://github.com/civicrm/civicrm-core/pull/19174) and
  [19166](https://github.com/civicrm/civicrm-core/pull/19166))**

  Work to remove legacy references to `contributionTypeID`.

- **Line items are added from default price set on recurring contributions for
  financial types with tax accounts.
  ([dev/financial#159](https://lab.civicrm.org/dev/financial/-/issues/159):
  [19086](https://github.com/civicrm/civicrm-core/pull/19086))**

- **Allocation of "fee amount" is incorrect if fee is added after contribution
  is created
  ([dev/financial#160](https://lab.civicrm.org/dev/financial/-/issues/160):
  [19152](https://github.com/civicrm/civicrm-core/pull/19152))**

- **Owner notification email sending every time the contribution is resaved
  ([dev/core#537](https://lab.civicrm.org/dev/core/-/issues/537):
  [19095](https://github.com/civicrm/civicrm-core/pull/19095))**

- **Default currency shown on invoices if payment is made with different
  currency ([dev/core#2269](https://lab.civicrm.org/dev/core/-/issues/2269):
  [19290](https://github.com/civicrm/civicrm-core/pull/19290))**

- **Contact type incorrectly set to Contribution due to 'Honoree Profile'
  ([dev/core#2273](https://lab.civicrm.org/dev/core/-/issues/2273):
  [19277](https://github.com/civicrm/civicrm-core/pull/19277))**

- **Disable frequency/interval fields if not required on backend contribution
  forms ([17889](https://github.com/civicrm/civicrm-core/pull/17889))**

- **Fix Contribution.tpl mismatched ts.
  ([19343](https://github.com/civicrm/civicrm-core/pull/19343))**

- **Fix preferred repeattransaction flow to correctly create the activity
  contacts for the contribution
  ([19200](https://github.com/civicrm/civicrm-core/pull/19200))**

- **Fix pledge on contribution page when the site has a Word Replacement for
  "contribution" ([19238](https://github.com/civicrm/civicrm-core/pull/19238))**

- **Fix Contribution.create to not attempt to set contacts on activity update
  ([19202](https://github.com/civicrm/civicrm-core/pull/19202))**

- **Allow Sendconfirmation api to override pay later receipt text
  ([19129](https://github.com/civicrm/civicrm-core/pull/19129))**

### CiviEvent

- **New Event using a template - clicking "Continue" doesn't save custom data
  ([dev/core#766](https://lab.civicrm.org/dev/core/-/issues/766):
  [19308](https://github.com/civicrm/civicrm-core/pull/19308))**

- **Use the proper content type for ICalendar link
  ([dev/core#2282](https://lab.civicrm.org/dev/core/-/issues/2282):
  [19316](https://github.com/civicrm/civicrm-core/pull/19316))**

  The iCalendar feed link now specifies that it is `text/calendar` so it will be
  handled correctly if the icon is clicked.

- **Import Participants fails
  ([dev/core#2348](https://lab.civicrm.org/dev/core/-/issues/2348):
  [19483](https://github.com/civicrm/civicrm-core/pull/19483))**

  This was an unreleased regression in 5.34.beta.

- **Manage Event: avoid E_NOTICE in smarty
  ([19137](https://github.com/civicrm/civicrm-core/pull/19137))**

- **Fatal error Incorrect datetime value: '0' for column 'transaction_date' when
  editing a participant record and recording payment with no received date
  ([dev/core#2251](https://lab.civicrm.org/dev/core/-/issues/2251):
  [19307](https://github.com/civicrm/civicrm-core/pull/19307))**

- **Allow overriding participant_status_id in Order API
  ([18096](https://github.com/civicrm/civicrm-core/pull/18096))**

### CiviMail

- **Proposal replace PEAR mailer classes in core extension (Work Towards
  [dev/core#2159](https://lab.civicrm.org/dev/core/-/issues/2159):
  [18905](https://github.com/civicrm/civicrm-core/pull/18905))**

  Handles exceptions in Mail:send class.

### CiviMember

- **Simplify decision as to whether to use a pdf on membership emails
  ([dev/financial#162](https://lab.civicrm.org/dev/financial/-/issues/162):
  [19165](https://github.com/civicrm/civicrm-core/pull/19165))**

  Makes decision to include a PDF in Membership emails dependent on settings
  instead of whether the tax-amount is non-zero.

- **Membership renewal with 0 tax creating extra line item
  ([dev/core#2024](https://lab.civicrm.org/dev/core/-/issues/2024):
  [18838](https://github.com/civicrm/civicrm-core/pull/18838))**

### CiviPledge

- **Rename PledgePayment create function
  ([19298](https://github.com/civicrm/civicrm-core/pull/19298))**

  Standardizes create function for a pledge payment.

- **Pledge: mark needed fields as required in schema
  ([19309](https://github.com/civicrm/civicrm-core/pull/19309))**

### Joomla Integration

- **distmaker - Don't require dummy config file for building Joomla
  ([19357](https://github.com/civicrm/civicrm-core/pull/19357))**

### WordPress Integration

- **Mailing default domain error: force a backend URL for WP
  ([19319](https://github.com/civicrm/civicrm-core/pull/19319))**

- **Allow wp-cli upgrade command to proceed when there is only a single settings
  file ([224](https://github.com/civicrm/civicrm-wordpress/pull/224))**

- **Prevent "add_action" from being called multiple times
  ([dev/core#2217](https://lab.civicrm.org/dev/core/-/issues/2217):
  [19061](https://github.com/civicrm/civicrm-core/pull/19061))**

## <a name="misc"></a>Miscellany

- **Membership BAO - do not require date fields to be passed in on update
  ([18794](https://github.com/civicrm/civicrm-core/pull/18794))**

- **Rename internal references to contributionTypeId
  ([19169](https://github.com/civicrm/civicrm-core/pull/19169))**

- **Switch to non-static functions
  ([19164](https://github.com/civicrm/civicrm-core/pull/19164))**

- **Duplicate processFormContribution only Membership form
  ([19211](https://github.com/civicrm/civicrm-core/pull/19211))**

- **Only do cms account create from the one relevant place
  ([19234](https://github.com/civicrm/civicrm-core/pull/19234))**

- **Convert previously shared function from static to non-static
  ([19231](https://github.com/civicrm/civicrm-core/pull/19231))**

- **Fix Payment edit form to use Payment.cancel & payment.create api
  ([19116](https://github.com/civicrm/civicrm-core/pull/19116))**

- **Fold deprecated function into the only function that calls it
  ([19270](https://github.com/civicrm/civicrm-core/pull/19270))**

- **Use specific function when formatting money for a default
  ([19285](https://github.com/civicrm/civicrm-core/pull/19285))**

- **Stop using refresh_date in civicrm_group table
  ([19287](https://github.com/civicrm/civicrm-core/pull/19287))**

- **Simplify handling of ids in Authorize.net now that related_contact is no
  longer used ([19273](https://github.com/civicrm/civicrm-core/pull/19273))**

- **CRM_Member_Form_MembershipRenewalTest - Started failing circa Jan 1, 2021
  ([dev/core#2284](https://lab.civicrm.org/dev/core/-/issues/2284):
  [19306](https://github.com/civicrm/civicrm-core/pull/19306))**

- **preliminary cleanup - extract a couple of functions in the payment processor
  form for readability (Work Towards
  [dev/financial#157](https://lab.civicrm.org/dev/financial/-/issues/157):
  [19072](https://github.com/civicrm/civicrm-core/pull/19072))**

- **finish 'this round' of completeOrder cleanup (Work Towards
  [dev/financial#152](https://lab.civicrm.org/dev/financial/-/issues/152):
  [19017](https://github.com/civicrm/civicrm-core/pull/19017))**

- **Squash 2 if clauses into 1
  ([19190](https://github.com/civicrm/civicrm-core/pull/19190))**

- **Clean up error handling in legacy functions in import parser
  ([19160](https://github.com/civicrm/civicrm-core/pull/19160))**

- **Unused writeLegacyWarnings() in PropertyBag
  ([19167](https://github.com/civicrm/civicrm-core/pull/19167))**

- **Update docs links
  ([624](https://github.com/civicrm/civicrm-drupal/pull/624))**

- **Preliminary cleanup -remove unused params from function signature
  ([19110](https://github.com/civicrm/civicrm-core/pull/19110))**

- **Minor code cleanup
  ([19220](https://github.com/civicrm/civicrm-core/pull/19220))**

- **Move processConfirm function from Utils file back to form class
  ([19212](https://github.com/civicrm/civicrm-core/pull/19212))**

- **Remove use of ignoreException from SMTP settings form
 ([19315](https://github.com/civicrm/civicrm-core/pull/19315))**

- **Remove constant CIVICRM_MYSQL_STRICT
 ([dev/core#2252](https://lab.civicrm.org/dev/core/-/issues/2252):
 [19244](https://github.com/civicrm/civicrm-core/pull/19244))**

- **Removes default for is_active & is_reserved since they now have DB defaults
  ([19296](https://github.com/civicrm/civicrm-core/pull/19296))**

- **Remove code to retrieve premium data
  ([19262](https://github.com/civicrm/civicrm-core/pull/19262))**

- **Remove use of ignoreException on import form
  ([19314](https://github.com/civicrm/civicrm-core/pull/19314))**

- **Remove unreachable customGroup section in online event receipt
  ([19069](https://github.com/civicrm/civicrm-core/pull/19069))**

- **Remove never-used IMAP_XOAUTH2 option value before it gets more confusing
  ([dev/core#2264](https://lab.civicrm.org/dev/core/-/issues/2264):
  [19243](https://github.com/civicrm/civicrm-core/pull/19243))**

- **Remove the print_array modifier as it is now supplied in civicrm-core
  ([314](https://github.com/civicrm/civicrm-packages/pull/314))**

- **Remove deprecated function
  ([19213](https://github.com/civicrm/civicrm-core/pull/19213))**

- **Remove some more variable variables + some test cleanup
  ([19208](https://github.com/civicrm/civicrm-core/pull/19208))**

- **Remove unreachable code.
  ([19203](https://github.com/civicrm/civicrm-core/pull/19203))**

- **Remove some deprecated code chunks
  ([19191](https://github.com/civicrm/civicrm-core/pull/19191))**

- **Remove extraneous elses
  ([19182](https://github.com/civicrm/civicrm-core/pull/19182))**

- **Remove obsolete IF
  ([19108](https://github.com/civicrm/civicrm-core/pull/19108))**

- **Remove extraneous elses
  ([19171](https://github.com/civicrm/civicrm-core/pull/19171))**

- **Remove extraneous handling duplicated from createProfileContact
  ([19109](https://github.com/civicrm/civicrm-core/pull/19109))**

- **Remove or hard-code variables from previously shared function
  ([19227](https://github.com/civicrm/civicrm-core/pull/19227))**

- **Remove code deprecated +1 year ago - case_from_XX / case_to_XXX search
  parameters ([19158](https://github.com/civicrm/civicrm-core/pull/19158))**

- **Remove extraneous elses
  ([19168](https://github.com/civicrm/civicrm-core/pull/19168))**

- **Remove meaningless calls to ignoreException
  ([19155](https://github.com/civicrm/civicrm-core/pull/19155))**

- **Remove some unused variables
  ([19156](https://github.com/civicrm/civicrm-core/pull/19156))**

- **Remove functions from EmailCommon that were moved to the trait
  ([19214](https://github.com/civicrm/civicrm-core/pull/19214))**

- **Remove duplicated tax assignments from copied code
  ([19228](https://github.com/civicrm/civicrm-core/pull/19228))**

- **Remove unused tpl assigns
  ([19226](https://github.com/civicrm/civicrm-core/pull/19226))**

- **Remove all handling related to pledge, cms user from newly separated
  function  ([19222](https://github.com/civicrm/civicrm-core/pull/19222))**

- **[REF] Extract determination of subscription status information
  ([19193](https://github.com/civicrm/civicrm-core/pull/19193))**

- **[REF] extract getIdsOfMatchingContact
  ([19172](https://github.com/civicrm/civicrm-core/pull/19172))**

- **[REF] Extract function to retrieve the membership labels.
  ([18854](https://github.com/civicrm/civicrm-core/pull/18854))**

- **REF Allow for fields of type Blob or Mediumblob in Apiv4
  ([19196](https://github.com/civicrm/civicrm-core/pull/19196))**

- **#REF Migrate the print_array smarty plugin from in packages into core…
  ([19206](https://github.com/civicrm/civicrm-core/pull/19206))**

- **[REF] Move function to shared parent so MemberForm can use it too
  ([19205](https://github.com/civicrm/civicrm-core/pull/19205))**

- **[REF] Relocate function from DeprecatedUtils to the class that actually
  calls it ([19247](https://github.com/civicrm/civicrm-core/pull/19247))**

- **[REF] Clean up on $ids['contribution']
  ([19207](https://github.com/civicrm/civicrm-core/pull/19207))**

- **[REF] Simplify membership form code towards simplifying BAO
  ([18855](https://github.com/civicrm/civicrm-core/pull/18855))**

- **[REF] Convert previously shared function to non-static, remove unrelated
  code ([19258](https://github.com/civicrm/civicrm-core/pull/19258))**

- **[REF] Move another deprecated function to the class that uses it
  ([19253](https://github.com/civicrm/civicrm-core/pull/19253))**

- **[REF] Switch to using shared function to call deprecated function
  ([19246](https://github.com/civicrm/civicrm-core/pull/19246))**

- **[REF] Relocate another function from DeprecatedUtils to the calling c…
  ([19249](https://github.com/civicrm/civicrm-core/pull/19249))**

- **REF use addRadio function to add in the radio fields to these forms
  ([19265](https://github.com/civicrm/civicrm-core/pull/19265))**

- **[REF] Relocate another deprecated utils function to the only class that
  calls it. ([19248](https://github.com/civicrm/civicrm-core/pull/19248))**

- **[REF] Deprecate passing a blank currecny to CRM_Utils_Money::format a…
  ([19099](https://github.com/civicrm/civicrm-core/pull/19099))**

- **[REF] Fix tax_amount to be consistent & load from the templateContribution
  ([19274](https://github.com/civicrm/civicrm-core/pull/19274))**

- **[REF] Unshared another function back onto Membership_Form
  ([19269](https://github.com/civicrm/civicrm-core/pull/19269))**

- **[REF] Unshare code to build an array of params for the recurring
  contribution ([19271](https://github.com/civicrm/civicrm-core/pull/19271))**

- **[REF] Extract duplicate handling code
  ([19103](https://github.com/civicrm/civicrm-core/pull/19103))**

- **[REF] Duplicate possibly-used parts of createProfileContact onto
  Parser_Contact ([19098](https://github.com/civicrm/civicrm-core/pull/19098))**

- **[REF] use early return for errors rather than confusing assignment
  ([19102](https://github.com/civicrm/civicrm-core/pull/19102))**

- **[REF] Remove unreachable code
  ([19279](https://github.com/civicrm/civicrm-core/pull/19279))**

- **[REF] Minor cleanup, remove variable variables
  ([19292](https://github.com/civicrm/civicrm-core/pull/19292))**

- **REF use centralised addRadio function more
  ([19272](https://github.com/civicrm/civicrm-core/pull/19272))**

- **(REF) Civi\Test\Invasive - Add helper for checking protected/private members
  ([19294](https://github.com/civicrm/civicrm-core/pull/19294))**

- **[REF] Move another deprecated function back to the only class that calls it
  ([19300](https://github.com/civicrm/civicrm-core/pull/19300))**

- **[REF] Minor cleanup on contactGroup function
  ([19286](https://github.com/civicrm/civicrm-core/pull/19286))**

- **[REF] Remove some variables not relevant to backoffice member form
  ([19284](https://github.com/civicrm/civicrm-core/pull/19284))**

- **[REF] Rationalise financialType variable
  ([19280](https://github.com/civicrm/civicrm-core/pull/19280))**

- **[REF] Extract code that assigns isPendingOutcome variable on thank yo…
  ([19232](https://github.com/civicrm/civicrm-core/pull/19232))**

- **[REF] extract and share code to determine if required contact fields are
  present ([19302](https://github.com/civicrm/civicrm-core/pull/19302))**

- **[REF] Fix import signature on activity parser, add preliminary test
  ([19301](https://github.com/civicrm/civicrm-core/pull/19301))**

- **Add test to check pcp notification is sent
  ([19117](https://github.com/civicrm/civicrm-core/pull/19117))**

- **Extend test to cover membership logs
  ([19023](https://github.com/civicrm/civicrm-core/pull/19023))**

- **[tests] Fix join syntax conversion for APIv4 in v3 unit tests
  ([19318](https://github.com/civicrm/civicrm-core/pull/19318))**

- **(NFC) DispatchPolicy - Add comments to docblock
  ([19215](https://github.com/civicrm/civicrm-core/pull/19215))**

- **[NFC] Convert civi.tag-deprecated to use central function
  ([19179](https://github.com/civicrm/civicrm-core/pull/19179))**

- **(NFC) Fix issue reporting link to go to the corresponding `core` project.
  ([19240](https://github.com/civicrm/civicrm-core/pull/19240))**

- **[NFC] Cleanup in test class
  ([19322](https://github.com/civicrm/civicrm-core/pull/19322))**

- **[NFC] Code reformat pledge class
  ([19336](https://github.com/civicrm/civicrm-core/pull/19336))**

- **[NFC] Fix Contribution Soft Credit entity translation
  ([19351](https://github.com/civicrm/civicrm-core/pull/19351) and
  [19359](https://github.com/civicrm/civicrm-core/pull/19359))**

- **NFC When printing out the result of the correctly update in single va…
  ([19198](https://github.com/civicrm/civicrm-core/pull/19198))**

- **[NFC] Update comments in CRM/Core/Key
  ([19197](https://github.com/civicrm/civicrm-core/pull/19197))**

- **(POC#C) MembershipRenewalTest - Address assertions that started failing
  circa Jan 1, 2021
  ([19305](https://github.com/civicrm/civicrm-core/pull/19305))**

- **REF Bump the composer-compile-plugin version
  ([19377](https://github.com/civicrm/civicrm-core/pull/19377))**

- **Test framework - API4 DateTest::testRelativeDateRanges will fail on the last
  day of Jan, Mar, May, Aug, Oct
  ([dev/core#2339](https://lab.civicrm.org/dev/core/-/issues/2339):
  [19466](https://github.com/civicrm/civicrm-core/pull/19466))**

- **Fix for ReportTest when launching a pdf
  ([19497](https://github.com/civicrm/civicrm-core/pull/19497))**

  This fixes a unit test failure caused by a recent merge on testing Report
  output.

- **Enotice fix ([19201](https://github.com/civicrm/civicrm-core/pull/19201))**

- **Fix notice error on using max() with only one variable
  ([19149](https://github.com/civicrm/civicrm-core/pull/19149))**

- **Minor typos in schema files
  ([19142](https://github.com/civicrm/civicrm-core/pull/19142))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle;
Bluehorn Digital - Matt Glaman; CEDC - Laryn Kragt Bakker; Christian Wach;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Sunil Pawar, Yashodha Chaku;
CompuCorp - Ahed; Coop SymbioTIC - Mathieu Lutfy; Dave D; Fuzion - Jitendra
Purohit; iXiam - César Ramos, Vangelis Pantazis; Jarek; JMA Consulting - Monish
Deb, Seamus Lee; lucky091588; maynardsmith; Megaphone Technology Consulting -
Jon Goldberg; MJCO - Mikey O'Toole; MJW Consulting - Matthew Wire; Nishant
Bhorodia; Tadpole Collective - Kevin Cristiano; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; iXiam - Luciano Spiegel;
JMA Consulting - Joe Murray; Joinery - Allen Shaw; Nicol Wistreich; Semper IT -
Karin Gerritsen; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
