# CiviCRM 5.46.0

Released February 3, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **re-jig demo roles to add restricted user
  ([dev/core#2773](https://lab.civicrm.org/dev/core/-/issues/2773):
  [22377](https://github.com/civicrm/civicrm-core/pull/22377))**

  Adds an ACL to demo data.

- **When adding custom data set change default selected option
  ([dev/core#2977](https://lab.civicrm.org/dev/core/-/issues/2977):
  [22244](https://github.com/civicrm/civicrm-core/pull/22244))**

  Changes the defaults when adding custom data sets to make them more user
  friendly.

- **Expose email on hold as filter for reports
  ([dev/core#3012](https://lab.civicrm.org/dev/core/-/issues/3012):
  [22357](https://github.com/civicrm/civicrm-core/pull/22357))**

  Adds a email on hold filter to reports.

- **Increment recommended PHP version
  ([dev/core#2996](https://lab.civicrm.org/dev/core/-/issues/2996):
  [22265](https://github.com/civicrm/civicrm-core/pull/22265))**

  Changes the minimum PHP version to 7.3 and the recommended PHP version to 7.4.

- **APIv4 Explorer - Make selected language and format bookmarkable
  ([22233](https://github.com/civicrm/civicrm-core/pull/22233))**

  The APIv4 explorer already places params in the URL for easy bookmarking.
  This extends it to work for the selected language tab and the selected output
  format.

- **SearchKit - Contextual "View" button
  ([dev/core#3016](https://lab.civicrm.org/dev/core/-/issues/3016):
  [22367](https://github.com/civicrm/civicrm-core/pull/22367))**

  Improves the SearchKit user interface

- **SearchKit - Add links for CustomField and CustomGroup entities
  ([22302](https://github.com/civicrm/civicrm-core/pull/22302))**

  Improves SearchKit user interface by adding links to custom field and custom
  group entities.

- **SearchKit - Allow functions in the WHERE clause
  ([22241](https://github.com/civicrm/civicrm-core/pull/22241))**

  Adds an advanced feature for SearchKit which allows SQL functions in the
  WHERE clause.

- **SearchKit - Import/Export saved search configuration
  ([22229](https://github.com/civicrm/civicrm-core/pull/22229))**

  Provides a UI for importing and exporting SavedSearches in JSON format. This
  allows power-users to copy and paste their Searches between sites. For
  extension developers, includes a direct link to generate a .mgd.php file from
  the API Explorer.

- **SearchKit - Facilitate popup forms
  ([22490](https://github.com/civicrm/civicrm-core/pull/22490))**

  This adds two bits of utility code to facilitate adding a popup form to an
  Afform containing a Search Display.

- **SearchKit - Allow aggregate columns to be links
  ([22356](https://github.com/civicrm/civicrm-core/pull/22356))**

  Allows aggregate columns to be rendered as a link in SearchKit Displays

- **CustomGroup - Add pseudoconstant for extends column
  ([22282](https://github.com/civicrm/civicrm-core/pull/22282))**

  Adds missing pseudoconstant to schema, which will allow a SearchKit-based
  display of custom groups.

- **Afform - UI and contextual titles for search displays
  ([22319](https://github.com/civicrm/civicrm-core/pull/22319))**

  Makes it easy to create drilldown search displays, passing in a URL arg to
  specify a category/container. E.g. "Custom fields in group X", "Option values
  for Individual Prefix", "Email addresses for Bob Smith".

- **Add system status warning to display scheduled job failures
  ([21762](https://github.com/civicrm/civicrm-core/pull/21762))**

  Adds a system status message to display scheduled job errors.

- **Add system status check for missing dedupe rules
  ([22369](https://github.com/civicrm/civicrm-core/pull/22369))**

  Adds a system status check to alert system administrators when an unsupervised
  and/or supervised dedupe rule is missing.

- **Extensions - Add dependency status check
  ([22640](https://github.com/civicrm/civicrm-core/pull/22640))**

  Adds a extensions dependency status check.

- **Improve accessibility - associate label and fields
  ([22361](https://github.com/civicrm/civicrm-core/pull/22361))**

  Associates the labels on the event location form with the relevant inputs to
  improve accessibility for screen reader users.

- **Add state name to export fields
  ([22318](https://github.com/civicrm/civicrm-core/pull/22318))**

  Adds the ability to export the state name when exporting contacts.

- **Add authx_login() API for backend script authentication (alt)
  ([22292](https://github.com/civicrm/civicrm-core/pull/22292))**

  Adds a function to login as a user. It is cross-platform; accepts contact ID,
  user ID, or username; and it updates relevant services (eg Civi session;
  Drupal $user; MySQL @civicrm_user_id).

### CiviContribute

- **Payments - Where do we store IDs from payment processor? (Work Towards
  [dev/financial#57](https://lab.civicrm.org/dev/financial/-/issues/57):
  [21916](https://github.com/civicrm/civicrm-core/pull/21916))**

  Hides the recur trxn_id if it matches the processor_id.

- **Financial entity permissions (Work Towards
  [dev/core#2752](https://lab.civicrm.org/dev/core/-/issues/2752):
  [21178](https://github.com/civicrm/civicrm-core/pull/21178) and
  [21181](https://github.com/civicrm/civicrm-core/pull/21181))**

  Allows financial_trxns to be viewed and use ACL, not blanket permissions on
  FinancialAccount, FinancialType, EntityFinancialAccount.

- **Demo sample data - Add in some mixed currency contributions
  ([22307](https://github.com/civicrm/civicrm-core/pull/22307))**

  Improves contribution sample data by adding some mixed currency contributions.

- **Add recurring conributions to sample data
  ([22296](https://github.com/civicrm/civicrm-core/pull/22296))**

  Improves contributions sample data by adding recurring contributions.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **"Open in new tab" on .crm-summary-link icons should open contact
  page, not summary content.
  ([dev/core#2926](https://lab.civicrm.org/dev/core/-/issues/2926):
  [22303](https://github.com/civicrm/civicrm-core/pull/22303))**

- **Separate membership payment on contribution form with auto renewal not get
  processed (Work Towards
  [dev/core#567](https://lab.civicrm.org/dev/core/-/issues/567):
  [22275](https://github.com/civicrm/civicrm-core/pull/22275))**

  Adds a test shell to ensure membership payments with auto renewal get
  processed.

- **Avoid warnings for is_dir() when open_basedir is in effect
  ([dev/core#2927](https://lab.civicrm.org/dev/core/-/issues/2927):
  [22107](https://github.com/civicrm/civicrm-core/pull/22107))**

- **Removes the limit of 15 max values for multiple values can also
  be retrieved from URL in reports
  ([dev/core#2979](https://lab.civicrm.org/dev/core/-/issues/2979):
  [22214](https://github.com/civicrm/civicrm-core/pull/22214))**

- **Fatal error when merging Housholds (getTemplateForGreeting)
  ([dev/core#3028](https://lab.civicrm.org/dev/core/-/issues/3028):
  [22650](https://github.com/civicrm/civicrm-core/pull/22650))**

- **TypeError when trying to replace tokens for custom fields that don't exist
  ([dev/core#3029](https://lab.civicrm.org/dev/core/-/issues/3029):
  [22537](https://github.com/civicrm/civicrm-core/pull/22537))**

- **Escape single quotes in token html output
  ([dev/core#3001](https://lab.civicrm.org/dev/core/-/issues/3001):
  [22387](https://github.com/civicrm/civicrm-core/pull/22387) and
  [22285](https://github.com/civicrm/civicrm-core/pull/22285))**

- **APIv4 - Rename 'ReadOnly' trait to 'ReadOnlyEntity' to avoid PHP error
  ([22626](https://github.com/civicrm/civicrm-core/pull/22626))**

- **APIv4 - Fix saving NULL as custom field value
  ([22328](https://github.com/civicrm/civicrm-core/pull/22328))**

- **APIv4 GroupContact create indicates user is added but are not
  ([dev/core#2924](https://lab.civicrm.org/dev/core/-/issues/2924):
  [22322](https://github.com/civicrm/civicrm-core/pull/22322))**

- **APIv4 - Make Groups a managed entity, fix 'null' bugs in BAO_Group
  ([22228](https://github.com/civicrm/civicrm-core/pull/22228))**

- **APIv4 - Set 'activity_type_id' to required
  ([22359](https://github.com/civicrm/civicrm-core/pull/22359))**

- **Use api for entityRole - addresses save issue on the form
  ([22589](https://github.com/civicrm/civicrm-core/pull/22589))**

- **SearchKit - Fix editable dates on standalone form
  ([22366](https://github.com/civicrm/civicrm-core/pull/22366))**

- **SearchKit - Fix running searches for anonymous users
  ([22597](https://github.com/civicrm/civicrm-core/pull/22597))**

- **SearchKit - Fix token selector to use expression alias
  ([22539](https://github.com/civicrm/civicrm-core/pull/22539))**

- **SearchKit - Fix UI for configuring display pager limit
  ([22321](https://github.com/civicrm/civicrm-core/pull/22321))**

- **SearchKit - Fix column headers for custom fields in default display
  ([22331](https://github.com/civicrm/civicrm-core/pull/22331))**

- **SearchKit/Form: exposing a Date custom field has invalid year range
  ([dev/report#84](https://lab.civicrm.org/dev/report/-/issues/84):
  [22234](https://github.com/civicrm/civicrm-core/pull/22234))**

- **SearchKit: URLs to external sites no longer render
  ([dev/report#93](https://lab.civicrm.org/dev/report/-/issues/93):
  [22437](https://github.com/civicrm/civicrm-core/pull/22437))**

- **SearchKit: Chicken-and-egg problem upgrading from 5.35.2 to 5.44.0
  ([dev/report#90](https://lab.civicrm.org/dev/report/-/issues/90):
  [22375](https://github.com/civicrm/civicrm-core/pull/22375))**

  Don't crash SearchKit on upgrade from 5.35.

- **DedupeRules - Translate contact type labels, respect enabled contact types
  ([22383](https://github.com/civicrm/civicrm-core/pull/22383))**

  Fixes up the Dedupe Rules page to properly handle contact types.

- **Allow chart dropdown labels to be translatable.
  ([22349](https://github.com/civicrm/civicrm-core/pull/22349))**

- **SqlParallel - Enable more tests. Fix compatiblity with `release_time`
  ([22326](https://github.com/civicrm/civicrm-core/pull/22326))**

- **Use JS escaping for {ts} calls in a JS context
  ([22348](https://github.com/civicrm/civicrm-core/pull/22348))**

- **Find Activities Search, default search option for Activity Status will
  exclude Activities by default which do not have a status of Scheduled or
  Completed. Confuses and frustrates End Users.
  ([21596](https://github.com/civicrm/civicrm-core/pull/21596))**

- **Wrap another set of hardcoded strings in {ts}
  ([22315](https://github.com/civicrm/civicrm-core/pull/22315))**

- **Display label before input elements on SMTP settings page
  ([22304](https://github.com/civicrm/civicrm-core/pull/22304))**

- **ExtensionUpgrades - Skip trying to upgrade missing dependencies
  ([22623](https://github.com/civicrm/civicrm-core/pull/22623))**

- **Fix input type for Smarty number formatting (more forgiving)
  ([22429](https://github.com/civicrm/civicrm-core/pull/22429))**

- **Ensure getDuplicateContacts always returns an array
  ([22394](https://github.com/civicrm/civicrm-core/pull/22394))**

- **Ensure dashboardLinks assigned to prevent e-notice
  ([22378](https://github.com/civicrm/civicrm-core/pull/22378))**

- **enotice fix (with default modifiers)
  ([22372](https://github.com/civicrm/civicrm-core/pull/22372))**

- **Fix "Import Multi-Value Custom Data"  
  ([22365](https://github.com/civicrm/civicrm-core/pull/22365))**

- **Do not escape showHideBlocks by default
  ([22371](https://github.com/civicrm/civicrm-core/pull/22371))**

- **Fix notices on ACL page
  ([22370](https://github.com/civicrm/civicrm-core/pull/22370))**

- **Fix PropertyBag setRecurInstallments to accept 0
  ([21517](https://github.com/civicrm/civicrm-core/pull/21517))**

- **Fix over-escaping when default escaping is on
  ([22363](https://github.com/civicrm/civicrm-core/pull/22363))**

- **Fix escape-by-default
  ([22362](https://github.com/civicrm/civicrm-core/pull/22362))**

- **Fix params passed to setStatus method
  ([22338](https://github.com/civicrm/civicrm-core/pull/22338))**

- **Fix Profile helptext menu reference to reCaptcha (by r4zoli)
  ([22333](https://github.com/civicrm/civicrm-core/pull/22333))**

- **Fix inaccuracies and mistakes in comments (especially phpdoc comments)
  ([22334](https://github.com/civicrm/civicrm-core/pull/22334))**

- **Correctly mark updateStatusMessage method as static
  ([22335](https://github.com/civicrm/civicrm-core/pull/22335))**

- **Fix typo. CRM_Core_Execption should be CRM_Core_Exception
  ([22336](https://github.com/civicrm/civicrm-core/pull/22336))**

- **APIv3 - Fix overzealous pseudoconstant matching
  ([22298](https://github.com/civicrm/civicrm-core/pull/22298))**

- **Allow text to be translated and fix URL paths in calls to docURL() function.
  ([22311](https://github.com/civicrm/civicrm-core/pull/22311))**

- **Fix char-set for default escaping
  ([22306](https://github.com/civicrm/civicrm-core/pull/22306))**

- **Crash when adding a relationship when CiviMember is disabled
  ([22451](https://github.com/civicrm/civicrm-core/pull/22451))**

- **Resources: set language-specific cacheCode, fixes AngularJS translation with
  multilingual ([22236](https://github.com/civicrm/civicrm-core/pull/22236))**

- **Do not default-escape weight field on order
  ([22256](https://github.com/civicrm/civicrm-core/pull/22256))**

- **Move require_once for Smarty modifier due to order issues
  ([22252](https://github.com/civicrm/civicrm-core/pull/22252))**

- **Contact/BAO/Query.php: fix searching for whitespace
  ([22240](https://github.com/civicrm/civicrm-core/pull/22240))**

- **Use new money formatting util for Smarty formatting
  ([22309](https://github.com/civicrm/civicrm-core/pull/22309))**

- **Smarty variables]  Remove another isset - deferredFinancialType
  ([22183](https://github.com/civicrm/civicrm-core/pull/22183))**

- **Smarty variables]  Another isset bites the dust
  ([22186](https://github.com/civicrm/civicrm-core/pull/22186))**

- **Smarty variables]  Remove isset from batch form
  ([22187](https://github.com/civicrm/civicrm-core/pull/22187))**

- **[Smarty variables] remove isset from merge screen
  ([22193](https://github.com/civicrm/civicrm-core/pull/22193))**

- **[Smarty variables] Fix overzealous escaping with Smarty default escaping
  ([22194](https://github.com/civicrm/civicrm-core/pull/22194))**

- **[Smarty variables]  Remove issets relating to auto_renew
  ([22195](https://github.com/civicrm/civicrm-core/pull/22195))**

- **[Smarty variables] Remove issets from payment processor form
  ([22192](https://github.com/civicrm/civicrm-core/pull/22192))**

- **Smarty modifier - stop using isset to check taxTerm
  ([22323](https://github.com/civicrm/civicrm-core/pull/22323))**

- **E-notice fix (Smarty)
  ([22308](https://github.com/civicrm/civicrm-core/pull/22308))**

## CiviCampaign

- **Cleanup Smarty e-notices on campaign dashboard
  ([22283](https://github.com/civicrm/civicrm-core/pull/22283))**

- **Fix campaign dashboard to work with default escaping
  ([22364](https://github.com/civicrm/civicrm-core/pull/22364))**

## CiviCase

- **Case activity won't open without a source
  ([dev/core#2825](https://lab.civicrm.org/dev/core/-/issues/2825):
  [22243](https://github.com/civicrm/civicrm-core/pull/22243))**

- **APIv4: Confusing error when calling CaseType API
  ([dev/core#2984](https://lab.civicrm.org/dev/core/-/issues/2984):
  [22231](https://github.com/civicrm/civicrm-core/pull/22231))**

## CiviContribution

- **Repeat Contributions CiviReport warnings: Formatting non-numeric values is
  no longer supported
  ([dev/core#2982](https://lab.civicrm.org/dev/core/-/issues/2982):
  [22217](https://github.com/civicrm/civicrm-core/pull/22217))**

- **Do not apply default escaping to multiselects on currency form
 ([22294](https://github.com/civicrm/civicrm-core/pull/22294))**

- **Fix broken links in default modifier mode on manage contributions
  ([22290](https://github.com/civicrm/civicrm-core/pull/22290))**

- **Enotice fixes on ContributionPage dash
  ([22289](https://github.com/civicrm/civicrm-core/pull/22289))**

- **Fix E_WARNING access array offset on null when creating new contribution
  page ([22373](https://github.com/civicrm/civicrm-core/pull/22373))**

- **Ensure we don't get previously set honoree values in receipts
  ([21483](https://github.com/civicrm/civicrm-core/pull/21483))**

- **Follow up fix on recur data
  ([22301](https://github.com/civicrm/civicrm-core/pull/22301))**

## CiviEvent

- **Event Registration: initialize array
  ([22312](https://github.com/civicrm/civicrm-core/pull/22312))**

  Minor code nitpick to avoid a PHP fatal on PHP 8.0 in certain unusual
  circumstances.

- **Fix JS Error for Free event with multiple participant on registration
  ([22310](https://github.com/civicrm/civicrm-core/pull/22310))**

## Drupal Integration

- **Deprecated function drupal_get_installed_schema_version() in 9.3, but with a
  twist ([dev/drupal#172](https://lab.civicrm.org/dev/drupal/-/issues/172):
  [22337](https://github.com/civicrm/civicrm-core/pull/22337) and
  [22350](https://github.com/civicrm/civicrm-core/pull/22350))**

- **"Your browser session has expired and we are unable to complete your form
  submission" on all D9.2 anonymous sessions
  ([dev/drupal#169](https://lab.civicrm.org/dev/drupal/-/issues/169):
  [338](https://github.com/civicrm/civicrm-packages/pull/338))**

  Fixes an error when uploading images to CKEditor via KCFinder.

- **Fix unreplaced template vars in civicrm.settings.php when using drush
  installer ([67](https://github.com/civicrm/civicrm-drupal-8/pull/67))**

- **Drupal Full-Text Search block session time out error
  ([dev/core#3026](https://lab.civicrm.org/dev/core/-/issues/3026):
  [22479](https://github.com/civicrm/civicrm-core/pull/22479))**

## WordPress Integration

- **Migrate installers to "setup" API
  (Work Towards [dev/core#1615](https://lab.civicrm.org/dev/core/-/issues/1615):
  [264](https://github.com/civicrm/civicrm-wordpress/pull/264))**

  Perform CLI installations using Civi\Setup.

## <a name="misc"></a>Miscellany

- **Add workflow template for recurring cancelled
  ([21611](https://github.com/civicrm/civicrm-core/pull/21611))**

- **Add workflow template classes for contributions
  ([22340](https://github.com/civicrm/civicrm-core/pull/22340))**

- **Use field value function to get html signature
  ([22445](https://github.com/civicrm/civicrm-core/pull/22445))**

- **SearchKit - Tweak export explorer link icon + format
  ([22300](https://github.com/civicrm/civicrm-core/pull/22300))**

- **Expose contact ID in getContactInfo method in
  CRM/Mailing/Event/BAO/Queue.php
  ([dev/core#2962](https://lab.civicrm.org/dev/core/-/issues/2962):
  [22096](https://github.com/civicrm/civicrm-core/pull/22096))**

- **APIv4 Explorer - Format array params using add methods instead of set
  ([22382](https://github.com/civicrm/civicrm-core/pull/22382))**

- **Update Brick/Money to 0.5.3
  ([22246](https://github.com/civicrm/civicrm-core/pull/22246))**

- **Simplify autogenerated boilerplate upgrader class
  ([22225](https://github.com/civicrm/civicrm-core/pull/22225))**

- **Upgrade - Bump minimum upgradable version to 4.6.12
  ([22238](https://github.com/civicrm/civicrm-core/pull/22238))**

- **Move two more functions to financialProcessor
  ([21927](https://github.com/civicrm/civicrm-core/pull/21927))**

- **Formatting cleanup
  ([22374](https://github.com/civicrm/civicrm-core/pull/22374))**

- **Rename protected function
  ([22259](https://github.com/civicrm/civicrm-core/pull/22259))**

- **Contributor key: Add Matt Trim
  ([22248](https://github.com/civicrm/civicrm-core/pull/22248))**

- **5.45.0 release notes: added late changes
  ([22386](https://github.com/civicrm/civicrm-core/pull/22386))**

- **Remove handling for always-truthy var being false
  ([22260](https://github.com/civicrm/civicrm-core/pull/22260))**

- **Remove unnecessary ID attribute.
  ([22347](https://github.com/civicrm/civicrm-core/pull/22347))**

- **Remove never passed variables
  ([22258](https://github.com/civicrm/civicrm-core/pull/22258))**

- **Remove unused function
  ([22388](https://github.com/civicrm/civicrm-core/pull/22388))**

- **Initial refactor of createProfileContact groups
  ([18158](https://github.com/civicrm/civicrm-core/pull/18158))**

- **Deprecated function drupal_get_path()
  ([69](https://github.com/civicrm/civicrm-drupal-8/pull/69))**

- **Update jquery.tokeninput.js to 1.6.1
  ([336](https://github.com/civicrm/civicrm-packages/pull/336))**

- **Privatise function
  ([22392](https://github.com/civicrm/civicrm-core/pull/22392))**

- **Remove unnecessary pass-by-ref
  ([22393](https://github.com/civicrm/civicrm-core/pull/22393))**

- **Remove unused function CRM/Utils/Mail/EmailProcessor::cleanupDir
  ([22278](https://github.com/civicrm/civicrm-core/pull/22278))**

- **Remove unused method getGrantStatusOptGroup
  ([22332](https://github.com/civicrm/civicrm-core/pull/22332))**

- **Remove unnecessary pass-by-ref
  ([22279](https://github.com/civicrm/civicrm-core/pull/22279))**

- **(REF) CRM/Upgrade - Remove unused entrypoint `verifyPreDBstate()`
  ([22237](https://github.com/civicrm/civicrm-core/pull/22237))**

- **(REF) Remove more params that are unused now function is not shared
  ([22261](https://github.com/civicrm/civicrm-core/pull/22261))**

- **(REF) Duplicate function to allow us to work it out of the code
  ([22254](https://github.com/civicrm/civicrm-core/pull/22254))**

- **(REF) Minor parameter simplification
  ([22253](https://github.com/civicrm/civicrm-core/pull/22253))**

- **(REF) Add in getVersion override for Drupal 8/9 to support cv testing and
  also cv vars:show picking up the right CMS version
  ([22220](https://github.com/civicrm/civicrm-core/pull/22220))**

- **(REF) Add getter for priceSetID and use full form flow
  ([22267](https://github.com/civicrm/civicrm-core/pull/22267))**

- **(REF) Afform - Use APIv4 for managed dashboard
  ([22213](https://github.com/civicrm/civicrm-core/pull/22213))**

- **(REF) Remove handling for relationshipID
  ([22391](https://github.com/civicrm/civicrm-core/pull/22391))**

- **(REF) Use `CRM_Contact_BAO_ContactType::basicTypes()` instead of hardcoded
  lists ([22389](https://github.com/civicrm/civicrm-core/pull/22389))**

- **(REF) Move code into the function
  ([22288](https://github.com/civicrm/civicrm-core/pull/22288))**

- **(REF) Remove now non-variable variables from previously shared code
  ([22284](https://github.com/civicrm/civicrm-core/pull/22284))**

- **(REF) Duplicate & unshare processFormContribution
  ([22276](https://github.com/civicrm/civicrm-core/pull/22276))**

- **(REF) Stop passing this as form, set in function
  ([22287](https://github.com/civicrm/civicrm-core/pull/22287))**

- **(REF) Deprecated old getContributionStatuses
  ([22345](https://github.com/civicrm/civicrm-core/pull/22345))**

- **(REF) Simplify getContributionStatuses
  ([22280](https://github.com/civicrm/civicrm-core/pull/22280))**

- **(REF) Upgrade jQuery UI to 1.13.0
  ([22583](https://github.com/civicrm/civicrm-core/pull/22583))**

- **(REF) Further cleanup on employer create
  ([22390](https://github.com/civicrm/civicrm-core/pull/22390))**

- **HookTest - Fix execution on PHP 8
  ([266](https://github.com/civicrm/civicrm-wordpress/pull/266))**

- **Fix membership test fail for Dec 31
  ([22351](https://github.com/civicrm/civicrm-core/pull/22351))**

- **Fix tests that fail after 2021
  ([22352](https://github.com/civicrm/civicrm-core/pull/22352))**

- **Fix test to use full form flow
  ([22266](https://github.com/civicrm/civicrm-core/pull/22266))**

- **Cleanup test class
  ([22493](https://github.com/civicrm/civicrm-core/pull/22493))**

- **(NFC) Cleanup test class
  ([22384](https://github.com/civicrm/civicrm-core/pull/22384))**

- **(NFC) Try to work around failing tests
  ([22269](https://github.com/civicrm/civicrm-core/pull/22269))**

- **(NFC) Cleanup in Authorize.net test class
  ([22272](https://github.com/civicrm/civicrm-core/pull/22272))**

- **(NFC) isDir unit test fails on PHP 7 'min' matrix
  ([22418](https://github.com/civicrm/civicrm-core/pull/22418))**

- **(NFC) APIv4: Add help info for multi-record custom field sets
  ([22257](https://github.com/civicrm/civicrm-core/pull/22257))**

- **(NFC) Test cleanup
  ([22251](https://github.com/civicrm/civicrm-core/pull/22251))**

- **(NFC) Minor cleanup in test class
  ([22249](https://github.com/civicrm/civicrm-core/pull/22249))**

- **(NFC) Cleanup messy boilerplate
  ([22224](https://github.com/civicrm/civicrm-core/pull/22224))**

- **(NFC) Delete boilerplate comments and empty functions from upgrade classes
  ([22226](https://github.com/civicrm/civicrm-core/pull/22226))**

- **(NFC) CRM_Core_Exception incorrectly called without message
  ([22339](https://github.com/civicrm/civicrm-core/pull/22339))**

- **(NFC) Docblock improvements to Import_Field classes
  ([22360](https://github.com/civicrm/civicrm-core/pull/22360))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
BrightMinded Ltd - Bradley Taylor; Circle Interactive - Matt Trim;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
Coop SymbioTIC - Mathieu Lutfy; Dave D; Jens Schuppe;
JMA Consulting - Seamus Lee; Megaphone Technology Consulting - Jon Goldberg;
Miguel Almeida; MJW Consulting - Matthew Wire;
Progressive Technology Project - Jamie McClelland; Skvare - Sunil Pawar;
Squiffle Consulting - Aidan Saunders; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Ben Mango; Betty Dolfing; Christian Wach;
CiviCoop - Jaap Jansma, Klaas Eikelboom; Coop SymbioTIC - Samuel Vanhove;
Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit, Peter Davis;
Greenpeace Central and Eastern Europe - Patrick Figel;
JMA Consulting - Joe Murray, Monish Deb; Lighthouse Consulting and
Design - Brian Shaughnessy; Mikey O'Toole; Semper IT - Karin Gerritsen;
Tadpole Collective - Kevin Cristiano; tapashdatta;
Third Sector Design - William Mortada; Wikimedia Foundation - Elliott Eggleston
