(defpackage :simple-tests (:use :lisp :gl :xlib))
(in-package :simple-tests)

;; very simple GL test
(defun test-gl ()
  (glutCreateWindow "dummy")
  (list (glGetString GL_VENDOR)
	(glGetString GL_RENDERER)
	(glGetString GL_VERSION)))

;; GLUT test
;;(defvar *window*)
;; C callbacks
;;(def-c-call-in draw (:return-type nil))
;;(defun draw ()
;;  (format t "In DRAW~%"))

;;(def-c-call-in keypress
;;    (:return-type nil)
;;  (:arguments (key uchar) (x int) (y int)))
;;(defun keypress (key x y)
;;  (format t "In KEYPRESS~%key ~A,  x ~A,  y ~A~%" (code-char key) x y)
;;  (glutDestroyWindow *window*)
  ;; can't jump out of glutMainLoop, so just quit
;;  (quit))

;;(defun test-glut ()
;;  (glutInitWindowSize 300 300)
;;  (setq *window* (glutCreateWindow "dummy"))
;;  (glutDisplayFunc #'draw)
;;  (glutKeyboardFunc #'keypress)
;;  (glutMainLoop))

;; Xlib test
(defun test-xlib ()
  (let* ((display (XOpenDisplay ""))
	 (screen (XDefaultScreen display))
	 (root (XRootWindow display screen))
	 (window (XCreateWindow display root
				50 50 200 200 0
				CopyFromParent CopyFromParent CopyFromParent
				0 0)))
    (format t "An empty X window should appear for 5 seconds...~%")
    (XMapWindow display window)
    (XFlush display)
    (sleep 5)
    (XDestroyWindow display window)
    (XCloseDisplay display)))

