;;; -*- Mode: CLtL -*-

;;; comfiguration-templete-impl.lisp --
;;;
;;; Copyright (c) 2000 Marco Antoniotti, all rights reserved.
;;; This software is released under the terms of the GNU Lesser General
;;; Public License (LGPL, see file COPYING for details).

(in-package "CL.EXT.CONFIGURATION")

;;; Configuration handling

;;; *configuration-factories*
;;; A table hashed by configuration symbol.  The value associated with
;;; each key is a 'configuration' instance (which should probably be
;;; renamed a 'configuration-template'.
;;; Getting the configuration template a new special configuration is
;;; generated by applying the 'make-configuration' (or a better named)
;;; method to it.
;;;
;;; This configuration can then be processed to actually set up all
;;; the necessary translations, require's and load's.
;;;
;;; Notes:
;;; 20000226 Marco Antoniotti
;;; This code is "dead" for the time being.  It is left here for
;;; future reference.

(defvar *configuration-factories* (make-hash-table))

(defun find-configuration-template (configuration-name)
  (gethash configuration-name *configuration-factories*))

(defun register-configuration-template (configuration-name configuration)
  (setf (gethash configuration-name *configuration-factories*) configuration))


(defun configuration-templates ()
  (loop for v being the hash-value of *configuration-factories*
	collect v))

(defgeneric make-configuration (conf cl os machine
				     &key configuration-name
				     &allow-other-keys))

(defmethod make-configuration ((conf symbol)
			       (cl cl.env:generic-common-lisp-implementation)
			       (os cl.env:operating-system)
			       (mach cl.env:machine)
			       &key (configuration-name (name conf))
			       )
  (let ((conf-template (find-configuration-template conf)))
    (when conf-template
      (make-configuration conf-template cl os mach
			  :configuration-name configuration-name))))


(defmethod make-configuration ((conf configuration-template)
			       (cl cl.env:generic-common-lisp-implementation)
			       (os cl.env:operating-system)
			       (mach cl.env:machine)
			       &key (configuration-name (name conf))
			       )
  (make-instance 'configuration
		 :special-translations
		 (build-translations-forms (special-translations conf)
					   (logical-host conf)
					   (build-location
					    (library-location-clauses conf)
					    cl
					    os
					    mach))
		 :name configuration-name
		 :operating-system os
		 :common-lisp-implementation cl
		 :machine mach
		 :logical-host (logical-host conf)
		 :library-location (build-location
				    (library-location-clauses conf)
				    cl
				    os
				    mach)
		 :source-location (build-location
				   (source-location-clauses conf)
				   cl
				   os
				   mach)))

;;; end of file -- configuration-template-impl.lisp --
