package Language::INTERCAL::INET::Constants;

# Constants used by the INET extension

# This file is part of CLC-INTERCAL

# Copyright (c) 2023 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use strict;
use Carp;
use Language::INTERCAL::Exporter '1.-94.-2.4';

use vars qw($VERSION $PERVERSION @EXPORT_OK);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/INET INTERCAL/INET/Constants.pm 1.-94.-2.4") =~ /\s(\S+)$/;
@EXPORT_OK = qw(
    SP_INTERNET SP_CASE SP_IPV6 SP_NONET BC_STE BC_SMU BC_CSE DOS_TH
);

# our splats
use constant SP_INTERNET => 899;
use constant SP_CASE     => 900;
use constant SP_IPV6     => 901;
use constant SP_NONET    => 902;

# our opcodes
use constant BC_STE      =>  45;
use constant BC_SMU      =>  46;
use constant BC_CSE      =>  47;

# our register
use constant DOS_TH      =>  20;

1;
