/*
 * Copyright 2013 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "testclickmanager.h"

#include "clickmanager.h"
#include "application.h"

namespace ClickPlugin {

void TestClickManager::cleanup()
{
    this->m_signal_counter = 0;
}

void TestClickManager::slotModelChanged()
{
    this->m_signal_counter++;
}

void TestClickManager::testCheckUpdates()
{
    this->m_signal_counter = 0;
    ClickManager manager;
    this->connect(&(manager), SIGNAL(modelChanged()),
                  this, SLOT(slotModelChanged()));
    QCOMPARE(manager.m_apps.size(), 0);
    manager.checkUpdates();
    QCOMPARE(manager.m_apps.size(), 4);
    QCOMPARE(manager.m_model.size(), 1);
    Application* app = manager.m_model[0].value<Application*>();
    QCOMPARE(app->getTitle(), QString("XDA Developers App"));
    QCOMPARE(app->updateRequired(), true);
    QCOMPARE(app->getPackageName(), QString("com.ubuntu.developer.xda-app"));
    QCOMPARE(this->m_signal_counter, 1);
}

void TestClickManager::testStartDownload()
{
    ClickManager manager;
    manager.checkUpdates();
    Application* app = manager.m_model[0].value<Application*>();
    manager.startDownload(app->getPackageName());
    QCOMPARE(app->updateState(), true);
    QCOMPARE(app->dbusPath(), QString("/com/canonical/download/path"));
}

void TestClickManager::testTokenObtained()
{
    ClickManager manager;
    manager.checkUpdates();
    QCOMPARE(manager.m_token.isValid(), true);
}

void TestClickManager::testDownloadNotCreated()
{
    ClickManager manager;
    manager.checkUpdates();
    manager.m_token = Token();
    Application* app = manager.m_model[0].value<Application*>();
    manager.startDownload(app->getPackageName());
    QCOMPARE(app->updateState(), false);
    QCOMPARE(app->dbusPath(), QString(""));
    QCOMPARE(app->getError(), QString("Invalid User Token"));
}

}
