/* minimol.cpp: atomic model data */
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#include "minimol_data.h"


namespace clipper {


namespace data {


Rotamer_data rotamer_data[] = { 
  {"ALA", 1, 0, 1.0000, 1," CB ",-0.940,-1.196, 0.000},
  {"ARG",16, 0, 0.1099, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 0, 0.1099, 7," CG ",-2.017,-1.162,-1.063},
  {"ARG",16, 0, 0.1099, 7," CD ",-2.937,-2.372,-1.071},
  {"ARG",16, 0, 0.1099, 7," NE ",-3.939,-2.292,-2.130},
  {"ARG",16, 0, 0.1099, 7," CZ ",-4.817,-3.248,-2.399},
  {"ARG",16, 0, 0.1099, 7," NH1",-4.823,-4.365,-1.684},
  {"ARG",16, 0, 0.1099, 7," NH2",-5.693,-3.090,-3.382},
  {"ARG",16, 1, 0.0666, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 1, 0.0666, 7," CG ",-2.007,-1.170,-1.074},
  {"ARG",16, 1, 0.0666, 7," CD ",-2.932,-2.375,-1.075},
  {"ARG",16, 1, 0.0666, 7," NE ",-2.238,-3.599,-1.465},
  {"ARG",16, 1, 0.0666, 7," CZ ",-2.778,-4.809,-1.423},
  {"ARG",16, 1, 0.0666, 7," NH1",-4.029,-4.965,-1.009},
  {"ARG",16, 1, 0.0666, 7," NH2",-2.072,-5.867,-1.796},
  {"ARG",16, 2, 0.0611, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 2, 0.0611, 7," CG ",-2.002,-1.174,-1.079},
  {"ARG",16, 2, 0.0611, 7," CD ",-2.913,-2.390,-1.095},
  {"ARG",16, 2, 0.0611, 7," NE ",-3.735,-2.475, 0.109},
  {"ARG",16, 2, 0.0611, 7," CZ ",-4.472,-3.527, 0.436},
  {"ARG",16, 2, 0.0611, 7," NH1",-4.492,-4.595,-0.351},
  {"ARG",16, 2, 0.0611, 7," NH2",-5.190,-3.517, 1.550},
  {"ARG",16, 3, 0.0602, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 3, 0.0602, 7," CG ",-2.023,-1.158,-1.057},
  {"ARG",16, 3, 0.0602, 7," CD ",-2.960,-2.353,-1.046},
  {"ARG",16, 3, 0.0602, 7," NE ",-3.928,-2.302,-2.138},
  {"ARG",16, 3, 0.0602, 7," CZ ",-5.057,-1.608,-2.102},
  {"ARG",16, 3, 0.0602, 7," NH1",-5.367,-0.899,-1.025},
  {"ARG",16, 3, 0.0602, 7," NH2",-5.879,-1.619,-3.142},
  {"ARG",16, 4, 0.0546, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 4, 0.0546, 7," CG ",-1.888,-1.249, 1.194},
  {"ARG",16, 4, 0.0546, 7," CD ",-2.880,-2.399, 1.157},
  {"ARG",16, 4, 0.0546, 7," NE ",-3.750,-2.411, 2.330},
  {"ARG",16, 4, 0.0546, 7," CZ ",-4.694,-3.315, 2.549},
  {"ARG",16, 4, 0.0546, 7," NH1",-4.895,-4.292, 1.673},
  {"ARG",16, 4, 0.0546, 7," NH2",-5.439,-3.249, 3.644},
  {"ARG",16, 5, 0.0534, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 5, 0.0534, 7," CG ",-2.028,-1.154,-1.052},
  {"ARG",16, 5, 0.0534, 7," CD ",-3.091,-2.230,-0.905},
  {"ARG",16, 5, 0.0534, 7," NE ",-2.543,-3.570,-1.094},
  {"ARG",16, 5, 0.0534, 7," CZ ",-2.396,-4.156,-2.274},
  {"ARG",16, 5, 0.0534, 7," NH1",-2.754,-3.520,-3.382},
  {"ARG",16, 5, 0.0534, 7," NH2",-1.890,-5.380,-2.352},
  {"ARG",16, 6, 0.0480, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 6, 0.0480, 7," CG ",-2.006,-1.171,-1.075},
  {"ARG",16, 6, 0.0480, 7," CD ",-2.934,-2.374,-1.073},
  {"ARG",16, 6, 0.0480, 7," NE ",-3.958,-2.278,-2.109},
  {"ARG",16, 6, 0.0480, 7," CZ ",-3.794,-2.687,-3.359},
  {"ARG",16, 6, 0.0480, 7," NH1",-2.642,-3.227,-3.737},
  {"ARG",16, 6, 0.0480, 7," NH2",-4.780,-2.560,-4.237},
  {"ARG",16, 7, 0.0392, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 7, 0.0392, 7," CG ",-1.995,-1.180,-1.086},
  {"ARG",16, 7, 0.0392, 7," CD ",-2.920,-2.385,-1.086},
  {"ARG",16, 7, 0.0392, 7," NE ",-3.759,-2.432, 0.108},
  {"ARG",16, 7, 0.0392, 7," CZ ",-4.905,-1.779, 0.241},
  {"ARG",16, 7, 0.0392, 7," NH1",-5.358,-1.023,-0.751},
  {"ARG",16, 7, 0.0392, 7," NH2",-5.603,-1.879, 1.364},
  {"ARG",16, 8, 0.0367, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 8, 0.0367, 7," CG ",-1.933,-1.214, 1.158},
  {"ARG",16, 8, 0.0367, 7," CD ",-2.916,-2.372, 1.123},
  {"ARG",16, 8, 0.0367, 7," NE ",-2.260,-3.655, 1.362},
  {"ARG",16, 8, 0.0367, 7," CZ ",-2.830,-4.833, 1.158},
  {"ARG",16, 8, 0.0367, 7," NH1",-4.075,-4.900, 0.704},
  {"ARG",16, 8, 0.0367, 7," NH2",-2.158,-5.950, 1.404},
  {"ARG",16, 9, 0.0321, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 9, 0.0321, 7," CG ",-1.913,-1.230, 1.175},
  {"ARG",16, 9, 0.0321, 7," CD ",-2.850,-2.425, 1.179},
  {"ARG",16, 9, 0.0321, 7," NE ",-3.754,-2.417, 0.032},
  {"ARG",16, 9, 0.0321, 7," CZ ",-4.468,-3.462,-0.361},
  {"ARG",16, 9, 0.0321, 7," NH1",-4.391,-4.608, 0.301},
  {"ARG",16, 9, 0.0321, 7," NH2",-5.265,-3.364,-1.417},
  {"ARG",16,10, 0.0319, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,10, 0.0319, 7," CG ",-1.878,-1.256, 1.202},
  {"ARG",16,10, 0.0319, 7," CD ",-2.868,-2.409, 1.168},
  {"ARG",16,10, 0.0319, 7," NE ",-3.780,-2.383, 2.307},
  {"ARG",16,10, 0.0319, 7," CZ ",-3.507,-2.909, 3.493},
  {"ARG",16,10, 0.0319, 7," NH1",-2.341,-3.505, 3.703},
  {"ARG",16,10, 0.0319, 7," NH2",-4.397,-2.839, 4.473},
  {"ARG",16,11, 0.0308, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,11, 0.0308, 7," CG ",-1.882,-1.254, 1.199},
  {"ARG",16,11, 0.0308, 7," CD ",-2.837,-2.435, 1.190},
  {"ARG",16,11, 0.0308, 7," NE ",-2.135,-3.709, 1.314},
  {"ARG",16,11, 0.0308, 7," CZ ",-1.706,-4.216, 2.461},
  {"ARG",16,11, 0.0308, 7," NH1",-1.909,-3.558, 3.596},
  {"ARG",16,11, 0.0308, 7," NH2",-1.075,-5.382, 2.480},
  {"ARG",16,12, 0.0292, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,12, 0.0292, 7," CG ",-1.909,-1.232, 1.178},
  {"ARG",16,12, 0.0292, 7," CD ",-2.849,-2.427, 1.181},
  {"ARG",16,12, 0.0292, 7," NE ",-3.759,-2.411, 0.039},
  {"ARG",16,12, 0.0292, 7," CZ ",-4.885,-1.715,-0.007},
  {"ARG",16,12, 0.0292, 7," NH1",-5.248,-0.968, 1.027},
  {"ARG",16,12, 0.0292, 7," NH2",-5.653,-1.760,-1.087},
  {"ARG",16,13, 0.0283, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,13, 0.0283, 7," CG ",-1.941,-1.222,-1.135},
  {"ARG",16,13, 0.0283, 7," CD ",-3.052,-0.194,-1.000},
  {"ARG",16,13, 0.0283, 7," NE ",-4.014,-0.279,-2.095},
  {"ARG",16,13, 0.0283, 7," CZ ",-5.054, 0.530,-2.238},
  {"ARG",16,13, 0.0283, 7," NH1",-5.272, 1.496,-1.355},
  {"ARG",16,13, 0.0283, 7," NH2",-5.879, 0.379,-3.265},
  {"ARG",16,14, 0.0252, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,14, 0.0252, 7," CG ",-1.890,-1.247, 1.193},
  {"ARG",16,14, 0.0252, 7," CD ",-2.861,-2.415, 1.171},
  {"ARG",16,14, 0.0252, 7," NE ",-3.733,-2.425, 2.343},
  {"ARG",16,14, 0.0252, 7," CZ ",-4.864,-1.740, 2.436},
  {"ARG",16,14, 0.0252, 7," NH1",-5.270,-0.985, 1.424},
  {"ARG",16,14, 0.0252, 7," NH2",-5.594,-1.808, 3.541},
  {"ARG",16,15, 0.0237, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,15, 0.0237, 7," CG ",-1.949,-1.216,-1.129},
  {"ARG",16,15, 0.0237, 7," CD ",-3.023,-0.147,-1.012},
  {"ARG",16,15, 0.0237, 7," NE ",-4.031,-0.266,-2.062},
  {"ARG",16,15, 0.0237, 7," CZ ",-3.928, 0.291,-3.260},
  {"ARG",16,15, 0.0237, 7," NH1",-2.856, 1.009,-3.570},
  {"ARG",16,15, 0.0237, 7," NH2",-4.894, 0.131,-4.154},
  {"ASN",12, 0, 0.2820, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 0, 0.2820, 4," CG ",-2.060,-1.067,-1.020},
  {"ASN",12, 0, 0.2820, 4," OD1",-2.402, 0.037,-1.445},
  {"ASN",12, 0, 0.2820, 4," ND2",-2.628,-2.197,-1.425},
  {"ASN",12, 1, 0.1860, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 1, 0.1860, 4," CG ",-1.992,-1.122,-1.095},
  {"ASN",12, 1, 0.1860, 4," OD1",-2.829,-0.219,-1.113},
  {"ASN",12, 1, 0.1860, 4," ND2",-1.944,-2.073,-2.020},
  {"ASN",12, 2, 0.0984, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 2, 0.0984, 4," CG ",-1.993,-1.108, 1.105},
  {"ASN",12, 2, 0.0984, 4," OD1",-2.320,-0.019, 1.579},
  {"ASN",12, 2, 0.0984, 4," ND2",-2.519,-2.255, 1.516},
  {"ASN",12, 3, 0.0714, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 3, 0.0714, 4," CG ",-1.970,-1.126, 1.128},
  {"ASN",12, 3, 0.0714, 4," OD1",-1.774,-0.416, 2.115},
  {"ASN",12, 3, 0.0714, 4," ND2",-3.065,-1.862, 0.980},
  {"ASN",12, 4, 0.0705, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 4, 0.0705, 4," CG ",-0.220,-2.524, 0.066},
  {"ASN",12, 4, 0.0705, 4," OD1", 1.008,-2.565, 0.131},
  {"ASN",12, 4, 0.0705, 4," ND2",-0.974,-3.616, 0.045},
  {"ASN",12, 5, 0.0549, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 5, 0.0549, 4," CG ",-1.953,-1.139, 1.143},
  {"ASN",12, 5, 0.0549, 4," OD1",-2.749,-0.204, 1.238},
  {"ASN",12, 5, 0.0549, 4," ND2",-1.918,-2.141, 2.014},
  {"ASN",12, 6, 0.0432, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 6, 0.0432, 4," CG ",-1.928,-1.159, 1.166},
  {"ASN",12, 6, 0.0432, 4," OD1",-1.534,-1.274, 2.327},
  {"ASN",12, 6, 0.0432, 4," ND2",-3.209,-0.996, 0.857},
  {"ASN",12, 7, 0.0416, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 7, 0.0416, 4," CG ",-1.985,-1.128,-1.102},
  {"ASN",12, 7, 0.0416, 4," OD1",-1.811,-1.724,-2.165},
  {"ASN",12, 7, 0.0416, 4," ND2",-3.067,-0.398,-0.857},
  {"ASN",12, 8, 0.0359, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 8, 0.0359, 4," CG ",-0.221,-2.524,-0.046},
  {"ASN",12, 8, 0.0359, 4," OD1", 0.618,-2.818, 0.806},
  {"ASN",12, 8, 0.0359, 4," ND2",-0.536,-3.334,-1.049},
  {"ASN",12, 9, 0.0309, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 9, 0.0309, 4," CG ",-1.888,-1.191, 1.200},
  {"ASN",12, 9, 0.0309, 4," OD1",-1.820,-2.068, 2.060},
  {"ASN",12, 9, 0.0309, 4," ND2",-2.767,-0.198, 1.257},
  {"ASN",12,10, 0.0304, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12,10, 0.0304, 4," CG ",-1.977,-1.134,-1.109},
  {"ASN",12,10, 0.0304, 4," OD1",-2.296,-2.147,-1.732},
  {"ASN",12,10, 0.0304, 4," ND2",-2.499, 0.059,-1.366},
  {"ASN",12,11, 0.0260, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12,11, 0.0260, 4," CG ",-0.220,-2.524, 0.064},
  {"ASN",12,11, 0.0260, 4," OD1", 0.653,-2.800,-0.759},
  {"ASN",12,11, 0.0260, 4," ND2",-0.574,-3.353, 1.039},
  {"ASP", 8, 0, 0.3087, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 0, 0.3087, 4," CG ",-2.062,-1.078,-1.004},
  {"ASP", 8, 0, 0.3087, 4," OD1",-2.259, 0.034,-1.536},
  {"ASP", 8, 0, 0.3087, 4," OD2",-2.798,-2.034,-1.328},
  {"ASP", 8, 1, 0.1945, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 1, 0.1945, 4," CG ",-1.964,-1.155,-1.109},
  {"ASP", 8, 1, 0.1945, 4," OD1",-2.622,-0.105,-1.264},
  {"ASP", 8, 1, 0.1945, 4," OD2",-2.178,-2.113,-1.882},
  {"ASP", 8, 2, 0.1761, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 2, 0.1761, 4," CG ",-1.945,-1.157, 1.139},
  {"ASP", 8, 2, 0.1761, 4," OD1",-1.903,-0.190, 1.929},
  {"ASP", 8, 2, 0.1761, 4," OD2",-2.814,-2.036, 1.318},
  {"ASP", 8, 3, 0.1097, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 3, 0.1097, 4," CG ",-0.191,-2.526, 0.032},
  {"ASP", 8, 3, 0.1097, 4," OD1", 1.057,-2.502, 0.069},
  {"ASP", 8, 3, 0.1097, 4," OD2",-0.767,-3.635, 0.019},
  {"ASP", 8, 4, 0.0872, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 4, 0.0872, 4," CG ",-1.924,-1.173, 1.158},
  {"ASP", 8, 4, 0.0872, 4," OD1",-2.693,-0.193, 1.254},
  {"ASP", 8, 4, 0.0872, 4," OD2",-2.003,-2.079, 2.014},
  {"ASP", 8, 5, 0.0493, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 5, 0.0493, 4," CG ",-2.011,-1.105, 1.073},
  {"ASP", 8, 5, 0.0493, 4," OD1",-1.657,-0.939, 2.259},
  {"ASP", 8, 5, 0.0493, 4," OD2",-3.232,-1.177, 0.819},
  {"ASP", 8, 6, 0.0347, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 6, 0.0347, 4," CG ",-0.191,-2.526, 0.029},
  {"ASP", 8, 6, 0.0347, 4," OD1", 0.647,-2.751,-0.869},
  {"ASP", 8, 6, 0.0347, 4," OD2",-0.374,-3.397, 0.907},
  {"ASP", 8, 7, 0.0208, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 7, 0.0208, 4," CG ",-0.195,-2.524,-0.100},
  {"ASP", 8, 7, 0.0208, 4," OD1", 0.712,-2.764, 0.725},
  {"ASP", 8, 7, 0.0208, 4," OD2",-0.448,-3.380,-0.974},
  {"CYS", 3, 0, 0.5664, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 0, 0.5664, 2," SG ",-2.165,-1.207,-1.322},
  {"CYS", 3, 1, 0.2742, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 1, 0.2742, 2," SG ",-2.064,-1.270, 1.421},
  {"CYS", 3, 2, 0.1594, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 2, 0.1594, 2," SG ",-0.101,-2.807, 0.069},
  {"GLN",13, 0, 0.1853, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 0, 0.1853, 5," CG ",-2.016,-1.163,-1.066},
  {"GLN",13, 0, 0.1853, 5," CD ",-2.891,-2.400,-1.067},
  {"GLN",13, 0, 0.1853, 5," OE1",-2.682,-3.315,-0.270},
  {"GLN",13, 0, 0.1853, 5," NE2",-3.874,-2.431,-1.962},
  {"GLN",13, 1, 0.1466, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 1, 0.1466, 5," CG ",-1.953,-1.212,-1.126},
  {"GLN",13, 1, 0.1466, 5," CD ",-2.911,-0.039,-1.058},
  {"GLN",13, 1, 0.1466, 5," OE1",-3.449, 0.268, 0.006},
  {"GLN",13, 1, 0.1466, 5," NE2",-3.125, 0.619,-2.193},
  {"GLN",13, 2, 0.0949, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 2, 0.0949, 5," CG ",-1.888,-1.251, 1.193},
  {"GLN",13, 2, 0.0949, 5," CD ",-2.846,-2.423, 1.132},
  {"GLN",13, 2, 0.0949, 5," OE1",-2.794,-3.227, 0.202},
  {"GLN",13, 2, 0.0949, 5," NE2",-3.725,-2.523, 2.125},
  {"GLN",13, 3, 0.0906, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 3, 0.0906, 5," CG ",-2.005,-1.171,-1.077},
  {"GLN",13, 3, 0.0906, 5," CD ",-2.921,-2.377,-1.035},
  {"GLN",13, 3, 0.0906, 5," OE1",-2.543,-3.466,-1.469},
  {"GLN",13, 3, 0.0906, 5," NE2",-4.129,-2.188,-0.513},
  {"GLN",13, 4, 0.0788, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 4, 0.0788, 5," CG ",-1.990,-1.183,-1.092},
  {"GLN",13, 4, 0.0788, 5," CD ",-2.919,-2.379,-1.038},
  {"GLN",13, 4, 0.0788, 5," OE1",-3.803,-2.448,-0.185},
  {"GLN",13, 4, 0.0788, 5," NE2",-2.721,-3.325,-1.952},
  {"GLN",13, 5, 0.0776, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 5, 0.0776, 5," CG ",-1.902,-1.239, 1.182},
  {"GLN",13, 5, 0.0776, 5," CD ",-2.901,-0.100, 1.151},
  {"GLN",13, 5, 0.0776, 5," OE1",-3.472, 0.205, 0.104},
  {"GLN",13, 5, 0.0776, 5," NE2",-3.114, 0.533, 2.300},
  {"GLN",13, 6, 0.0448, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 6, 0.0448, 5," CG ",-1.894,-1.246, 1.189},
  {"GLN",13, 6, 0.0448, 5," CD ",-2.799,-2.461, 1.169},
  {"GLN",13, 6, 0.0448, 5," OE1",-2.361,-3.572, 1.467},
  {"GLN",13, 6, 0.0448, 5," NE2",-4.065,-2.253, 0.820},
  {"GLN",13, 7, 0.0393, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 7, 0.0393, 5," CG ",-1.871,-1.263, 1.206},
  {"GLN",13, 7, 0.0393, 5," CD ",-2.850,-2.418, 1.132},
  {"GLN",13, 7, 0.0393, 5," OE1",-3.841,-2.352, 0.405},
  {"GLN",13, 7, 0.0393, 5," NE2",-2.574,-3.479, 1.883},
  {"GLN",13, 8, 0.0251, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 8, 0.0251, 5," CG ",-0.230,-2.548, 0.092},
  {"GLN",13, 8, 0.0251, 5," CD ",-1.187,-3.720, 0.035},
  {"GLN",13, 8, 0.0251, 5," OE1",-2.404,-3.535, 0.006},
  {"GLN",13, 8, 0.0251, 5," NE2",-0.641,-4.933, 0.018},
  {"GLN",13, 9, 0.0248, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 9, 0.0248, 5," CG ",-2.031,-1.151,-1.050},
  {"GLN",13, 9, 0.0248, 5," CD ",-2.949, 0.041,-0.879},
  {"GLN",13, 9, 0.0248, 5," OE1",-3.057, 0.882,-1.772},
  {"GLN",13, 9, 0.0248, 5," NE2",-3.615, 0.117, 0.269},
  {"GLN",13,10, 0.0245, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,10, 0.0245, 5," CG ",-2.008,-1.169,-1.073},
  {"GLN",13,10, 0.0245, 5," CD ",-3.137,-0.213,-0.744},
  {"GLN",13,10, 0.0245, 5," OE1",-2.898, 0.909,-0.298},
  {"GLN",13,10, 0.0245, 5," NE2",-4.372,-0.655,-0.965},
  {"GLN",13,11, 0.0223, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,11, 0.0223, 5," CG ",-2.029,-1.153,-1.052},
  {"GLN",13,11, 0.0223, 5," CD ",-1.506,-1.446,-2.443},
  {"GLN",13,11, 0.0223, 5," OE1",-0.632,-2.295,-2.618},
  {"GLN",13,11, 0.0223, 5," NE2",-2.041,-0.745,-3.438},
  {"GLN",13,12, 0.0208, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,12, 0.0208, 5," CG ",-2.007,-1.170,-1.075},
  {"GLN",13,12, 0.0208, 5," CD ",-2.903,-2.391,-1.053},
  {"GLN",13,12, 0.0208, 5," OE1",-3.794,-2.530,-1.892},
  {"GLN",13,12, 0.0208, 5," NE2",-2.670,-3.282,-0.094},
  {"GLU",13, 0, 0.1884, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 0, 0.1884, 5," CG ",-2.018,-1.162,-1.064},
  {"GLU",13, 0, 0.1884, 5," CD ",-2.894,-2.400,-1.060},
  {"GLU",13, 0, 0.1884, 5," OE1",-2.632,-3.312,-0.249},
  {"GLU",13, 0, 0.1884, 5," OE2",-3.843,-2.461,-1.870},
  {"GLU",13, 1, 0.1200, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 1, 0.1200, 5," CG ",-1.882,-1.255, 1.198},
  {"GLU",13, 1, 0.1200, 5," CD ",-2.831,-2.438, 1.142},
  {"GLU",13, 1, 0.1200, 5," OE1",-2.752,-3.218, 0.170},
  {"GLU",13, 1, 0.1200, 5," OE2",-3.655,-2.586, 2.069},
  {"GLU",13, 2, 0.0900, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 2, 0.0900, 5," CG ",-1.982,-1.190,-1.100},
  {"GLU",13, 2, 0.0900, 5," CD ",-2.920,-2.380,-1.035},
  {"GLU",13, 2, 0.0900, 5," OE1",-2.426,-3.527,-1.027},
  {"GLU",13, 2, 0.0900, 5," OE2",-4.150,-2.168,-0.993},
  {"GLU",13, 3, 0.0830, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 3, 0.0830, 5," CG ",-2.018,-1.162,-1.064},
  {"GLU",13, 3, 0.0830, 5," CD ",-2.931, 0.041,-0.918},
  {"GLU",13, 3, 0.0830, 5," OE1",-3.470, 0.247, 0.189},
  {"GLU",13, 3, 0.0830, 5," OE2",-3.111, 0.777,-1.911},
  {"GLU",13, 4, 0.0750, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 4, 0.0750, 5," CG ",-2.026,-1.155,-1.055},
  {"GLU",13, 4, 0.0750, 5," CD ",-2.926,-2.377,-1.028},
  {"GLU",13, 4, 0.0750, 5," OE1",-3.507,-2.664, 0.039},
  {"GLU",13, 4, 0.0750, 5," OE2",-3.048,-3.050,-2.073},
  {"GLU",13, 5, 0.0685, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 5, 0.0685, 5," CG ",-1.965,-1.203,-1.116},
  {"GLU",13, 5, 0.0685, 5," CD ",-3.037,-0.148,-0.920},
  {"GLU",13, 5, 0.0685, 5," OE1",-3.088, 0.452, 0.175},
  {"GLU",13, 5, 0.0685, 5," OE2",-3.828, 0.080,-1.859},
  {"GLU",13, 6, 0.0600, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 6, 0.0600, 5," CG ",-1.877,-1.259, 1.201},
  {"GLU",13, 6, 0.0600, 5," CD ",-2.860,-2.413, 1.121},
  {"GLU",13, 6, 0.0600, 5," OE1",-2.408,-3.572, 1.019},
  {"GLU",13, 6, 0.0600, 5," OE2",-4.082,-2.158, 1.157},
  {"GLU",13, 7, 0.0572, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 7, 0.0572, 5," CG ",-1.916,-1.229, 1.171},
  {"GLU",13, 7, 0.0572, 5," CD ",-2.842,-2.430, 1.131},
  {"GLU",13, 7, 0.0572, 5," OE1",-3.551,-2.602, 0.118},
  {"GLU",13, 7, 0.0572, 5," OE2",-2.862,-3.200, 2.115},
  {"GLU",13, 8, 0.0409, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 8, 0.0409, 5," CG ",-1.864,-1.269, 1.212},
  {"GLU",13, 8, 0.0409, 5," CD ",-2.895,-0.157, 1.211},
  {"GLU",13, 8, 0.0409, 5," OE1",-3.009, 0.548, 0.186},
  {"GLU",13, 8, 0.0409, 5," OE2",-3.590, 0.013, 2.235},
  {"GLU",13, 9, 0.0392, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 9, 0.0392, 5," CG ",-1.995,-1.179,-1.086},
  {"GLU",13, 9, 0.0392, 5," CD ",-1.468,-1.678,-2.419},
  {"GLU",13, 9, 0.0392, 5," OE1",-0.287,-2.079,-2.478},
  {"GLU",13, 9, 0.0392, 5," OE2",-2.234,-1.666,-3.405},
  {"GLU",13,10, 0.0300, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,10, 0.0300, 5," CG ",-1.954,-1.200, 1.138},
  {"GLU",13,10, 0.0300, 5," CD ",-2.895,-0.012, 1.067},
  {"GLU",13,10, 0.0300, 5," OE1",-3.497, 0.207,-0.005},
  {"GLU",13,10, 0.0300, 5," OE2",-3.030, 0.704, 2.082},
  {"GLU",13,11, 0.0256, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,11, 0.0256, 5," CG ",-0.226,-2.549, 0.080},
  {"GLU",13,11, 0.0256, 5," CD ",-1.186,-3.722, 0.021},
  {"GLU",13,11, 0.0256, 5," OE1",-2.405,-3.487,-0.110},
  {"GLU",13,11, 0.0256, 5," OE2",-0.720,-4.878, 0.108},
  {"GLU",13,12, 0.0210, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,12, 0.0210, 5," CG ",-1.997,-1.178,-1.085},
  {"GLU",13,12, 0.0210, 5," CD ",-1.415,-1.414,-2.466},
  {"GLU",13,12, 0.0210, 5," OE1",-0.696,-2.419,-2.645},
  {"GLU",13,12, 0.0210, 5," OE2",-1.675,-0.594,-3.371},
  {"HIS", 8, 0, 0.2964, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 0, 0.2964, 6," CG ",-1.939,-1.201,-1.105},
  {"HIS", 8, 0, 0.2964, 6," ND1",-3.021,-0.346,-1.133},
  {"HIS", 8, 0, 0.2964, 6," CD2",-2.024,-1.947,-2.233},
  {"HIS", 8, 0, 0.2964, 6," CE1",-3.726,-0.565,-2.227},
  {"HIS", 8, 0, 0.2964, 6," NE2",-3.144,-1.531,-2.913},
  {"HIS", 8, 1, 0.1533, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 1, 0.1533, 6," CG ",-1.846,-1.260, 1.196},
  {"HIS", 8, 1, 0.1533, 6," ND1",-2.904,-0.390, 1.368},
  {"HIS", 8, 1, 0.1533, 6," CD2",-1.855,-2.077, 2.275},
  {"HIS", 8, 1, 0.1533, 6," CE1",-3.523,-0.670, 2.499},
  {"HIS", 8, 1, 0.1533, 6," NE2",-2.909,-1.690, 3.070},
  {"HIS", 8, 2, 0.1451, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 2, 0.1451, 6," CG ",-1.974,-1.174,-1.073},
  {"HIS", 8, 2, 0.1451, 6," ND1",-1.737,-1.645,-2.348},
  {"HIS", 8, 2, 0.1451, 6," CD2",-3.252,-0.726,-1.071},
  {"HIS", 8, 2, 0.1451, 6," CE1",-2.823,-1.489,-3.082},
  {"HIS", 8, 2, 0.1451, 6," NE2",-3.758,-0.934,-2.333},
  {"HIS", 8, 3, 0.1213, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 3, 0.1213, 6," CG ",-1.938,-1.188, 1.121},
  {"HIS", 8, 3, 0.1213, 6," ND1",-1.649,-1.643, 2.391},
  {"HIS", 8, 3, 0.1213, 6," CD2",-3.226,-0.770, 1.158},
  {"HIS", 8, 3, 0.1213, 6," CE1",-2.713,-1.506, 3.159},
  {"HIS", 8, 3, 0.1213, 6," NE2",-3.684,-0.978, 2.438},
  {"HIS", 8, 4, 0.1077, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 4, 0.1077, 6," CG ",-2.005,-1.150,-1.041},
  {"HIS", 8, 4, 0.1077, 6," ND1",-2.805,-2.230,-1.352},
  {"HIS", 8, 4, 0.1077, 6," CD2",-2.403,-0.143,-1.854},
  {"HIS", 8, 4, 0.1077, 6," CE1",-3.649,-1.890,-2.309},
  {"HIS", 8, 4, 0.1077, 6," NE2",-3.428,-0.629,-2.632},
  {"HIS", 8, 5, 0.0705, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 5, 0.0705, 6," CG ",-0.234,-2.522, 0.099},
  {"HIS", 8, 5, 0.0705, 6," ND1", 0.360,-3.128,-0.988},
  {"HIS", 8, 5, 0.0705, 6," CD2",-0.025,-3.351, 1.150},
  {"HIS", 8, 5, 0.0705, 6," CE1", 0.903,-4.271,-0.612},
  {"HIS", 8, 5, 0.0705, 6," NE2", 0.685,-4.431, 0.680},
  {"HIS", 8, 6, 0.0528, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 6, 0.0528, 6," CG ",-1.935,-1.191, 1.124},
  {"HIS", 8, 6, 0.0528, 6," ND1",-2.738,-2.272, 1.424},
  {"HIS", 8, 6, 0.0528, 6," CD2",-2.260,-0.225, 2.015},
  {"HIS", 8, 6, 0.0528, 6," CE1",-3.513,-1.972, 2.450},
  {"HIS", 8, 6, 0.0528, 6," NE2",-3.243,-0.736, 2.829},
  {"HIS", 8, 7, 0.0474, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 7, 0.0474, 6," CG ",-0.232,-2.524, 0.042},
  {"HIS", 8, 7, 0.0474, 6," ND1", 0.182,-3.118, 1.216},
  {"HIS", 8, 7, 0.0474, 6," CD2", 0.137,-3.365,-0.953},
  {"HIS", 8, 7, 0.0474, 6," CE1", 0.775,-4.265, 0.942},
  {"HIS", 8, 7, 0.0474, 6," NE2", 0.761,-4.441,-0.366},
  {"ILE", 5, 0, 0.6158, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 0, 0.6158, 4," CG1",-1.934,-1.131,-1.157},
  {"ILE", 5, 0, 0.6158, 4," CG2",-1.685,-1.306, 1.334},
  {"ILE", 5, 0, 0.6158, 4," CD1",-2.741,-2.393,-1.366},
  {"ILE", 5, 1, 0.1557, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 1, 0.1557, 4," CG1",-1.858,-1.191,-1.220},
  {"ILE", 5, 1, 0.1557, 4," CG2",-1.768,-1.243, 1.287},
  {"ILE", 5, 1, 0.1557, 4," CD1",-2.749, 0.029,-1.294},
  {"ILE", 5, 2, 0.1202, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 2, 0.1202, 4," CG1",-0.142,-2.518,-0.003},
  {"ILE", 5, 2, 0.1202, 4," CG2",-1.895,-1.160,-1.179},
  {"ILE", 5, 2, 0.1202, 4," CD1",-0.981,-3.756, 0.221},
  {"ILE", 5, 3, 0.0615, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 3, 0.0615, 4," CG1",-1.950,-1.103, 1.157},
  {"ILE", 5, 3, 0.0615, 4," CG2",-0.151,-2.508, 0.114},
  {"ILE", 5, 3, 0.0615, 4," CD1",-3.097,-2.085, 1.064},
  {"ILE", 5, 4, 0.0267, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 4, 0.0267, 4," CG1",-2.004,-1.061, 1.103},
  {"ILE", 5, 4, 0.0267, 4," CG2",-0.158,-2.502, 0.201},
  {"ILE", 5, 4, 0.0267, 4," CD1",-2.976, 0.071, 0.856},
  {"LEU", 4, 0, 0.6252, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 0, 0.6252, 4," CG ",-2.001,-1.247,-1.094},
  {"LEU", 4, 0, 0.6252, 4," CD1",-2.772,-2.557,-1.051},
  {"LEU", 4, 0, 0.6252, 4," CD2",-2.946,-0.060,-0.975},
  {"LEU", 4, 1, 0.2891, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 1, 0.2891, 4," CG ",-1.880,-1.328, 1.209},
  {"LEU", 4, 1, 0.2891, 4," CD1",-2.838,-0.149, 1.260},
  {"LEU", 4, 1, 0.2891, 4," CD2",-2.643,-2.643, 1.167},
  {"LEU", 4, 2, 0.0365, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 2, 0.0365, 4," CG ",-2.274,-1.032,-0.721},
  {"LEU", 4, 2, 0.0365, 4," CD1",-2.048,-0.582,-2.155},
  {"LEU", 4, 2, 0.0365, 4," CD2",-3.084,-2.320,-0.680},
  {"LEU", 4, 3, 0.0256, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 3, 0.0256, 4," CG ",-2.097,-1.160, 1.008},
  {"LEU", 4, 3, 0.0256, 4," CD1",-3.073,-2.299, 0.755},
  {"LEU", 4, 3, 0.0256, 4," CD2",-1.577,-1.201, 2.436},
  {"LYS",14, 0, 0.2279, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 0, 0.2279, 5," CG ",-2.008,-1.171,-1.073},
  {"LYS",14, 0, 0.2279, 5," CD ",-2.911,-2.390,-1.000},
  {"LYS",14, 0, 0.2279, 5," CE ",-3.970,-2.360,-2.088},
  {"LYS",14, 0, 0.2279, 5," NZ ",-4.856,-3.556,-2.035},
  {"LYS",14, 1, 0.1345, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 1, 0.1345, 5," CG ",-1.884,-1.253, 1.197},
  {"LYS",14, 1, 0.1345, 5," CD ",-2.833,-2.437, 1.105},
  {"LYS",14, 1, 0.1345, 5," CE ",-3.769,-2.489, 2.300},
  {"LYS",14, 1, 0.1345, 5," NZ ",-4.706,-3.643, 2.221},
  {"LYS",14, 2, 0.0696, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 2, 0.0696, 5," CG ",-1.932,-1.230,-1.143},
  {"LYS",14, 2, 0.0696, 5," CD ",-2.924,-0.083,-1.040},
  {"LYS",14, 2, 0.0696, 5," CE ",-3.957,-0.143,-2.152},
  {"LYS",14, 2, 0.0696, 5," NZ ",-4.905, 1.003,-2.092},
  {"LYS",14, 3, 0.0544, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 3, 0.0544, 5," CG ",-2.003,-1.174,-1.078},
  {"LYS",14, 3, 0.0544, 5," CD ",-2.928,-2.376,-0.983},
  {"LYS",14, 3, 0.0544, 5," CE ",-3.954,-2.375,-2.103},
  {"LYS",14, 3, 0.0544, 5," NZ ",-4.899,-1.230,-1.989},
  {"LYS",14, 4, 0.0529, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 4, 0.0529, 5," CG ",-2.008,-1.171,-1.073},
  {"LYS",14, 4, 0.0529, 5," CD ",-2.926,-2.378,-0.984},
  {"LYS",14, 4, 0.0529, 5," CE ",-4.028,-2.312,-2.028},
  {"LYS",14, 4, 0.0529, 5," NZ ",-3.491,-2.432,-3.411},
  {"LYS",14, 5, 0.0383, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 5, 0.0383, 5," CG ",-2.015,-1.165,-1.065},
  {"LYS",14, 5, 0.0383, 5," CD ",-2.983,-2.328,-0.925},
  {"LYS",14, 5, 0.0383, 5," CE ",-2.339,-3.637,-1.350},
  {"LYS",14, 5, 0.0383, 5," NZ ",-3.301,-4.772,-1.297},
  {"LYS",14, 6, 0.0353, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 6, 0.0353, 5," CG ",-1.892,-1.247, 1.191},
  {"LYS",14, 6, 0.0353, 5," CD ",-2.857,-2.415, 1.086},
  {"LYS",14, 6, 0.0353, 5," CE ",-3.735,-2.521, 2.321},
  {"LYS",14, 6, 0.0353, 5," NZ ",-4.638,-1.346, 2.463},
  {"LYS",14, 7, 0.0348, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 7, 0.0348, 5," CG ",-2.028,-1.155,-1.051},
  {"LYS",14, 7, 0.0348, 5," CD ",-2.864,-2.424,-1.049},
  {"LYS",14, 7, 0.0348, 5," CE ",-3.719,-2.521, 0.203},
  {"LYS",14, 7, 0.0348, 5," NZ ",-4.591,-3.727, 0.188},
  {"LYS",14, 8, 0.0347, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 8, 0.0347, 5," CG ",-1.885,-1.252, 1.196},
  {"LYS",14, 8, 0.0347, 5," CD ",-2.835,-2.434, 1.103},
  {"LYS",14, 8, 0.0347, 5," CE ",-3.835,-2.431, 2.247},
  {"LYS",14, 8, 0.0347, 5," NZ ",-3.180,-2.686, 3.559},
  {"LYS",14, 9, 0.0314, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 9, 0.0314, 5," CG ",-0.226,-2.547, 0.117},
  {"LYS",14, 9, 0.0314, 5," CD ",-1.213,-3.702, 0.104},
  {"LYS",14, 9, 0.0314, 5," CE ",-0.503,-5.039, 0.226},
  {"LYS",14, 9, 0.0314, 5," NZ ",-1.460,-6.179, 0.217},
  {"LYS",14,10, 0.0299, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,10, 0.0299, 5," CG ",-1.875,-1.260, 1.204},
  {"LYS",14,10, 0.0299, 5," CD ",-2.934,-0.173, 1.124},
  {"LYS",14,10, 0.0299, 5," CE ",-3.932,-0.288, 2.265},
  {"LYS",14,10, 0.0299, 5," NZ ",-4.966, 0.781, 2.208},
  {"LYS",14,11, 0.0238, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,11, 0.0238, 5," CG ",-1.919,-1.226, 1.169},
  {"LYS",14,11, 0.0238, 5," CD ",-2.774,-2.482, 1.153},
  {"LYS",14,11, 0.0238, 5," CE ",-3.761,-2.464,-0.002},
  {"LYS",14,11, 0.0238, 5," NZ ",-4.656,-3.654, 0.014},
  {"LYS",14,12, 0.0232, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,12, 0.0232, 5," CG ",-1.879,-1.257, 1.201},
  {"LYS",14,12, 0.0232, 5," CD ",-2.882,-2.390, 1.069},
  {"LYS",14,12, 0.0232, 5," CE ",-2.217,-3.743, 1.261},
  {"LYS",14,12, 0.0232, 5," NZ ",-3.198,-4.860, 1.186},
  {"LYS",14,13, 0.0212, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,13, 0.0212, 5," CG ",-1.899,-1.256,-1.170},
  {"LYS",14,13, 0.0212, 5," CD ",-2.906,-0.121,-1.109},
  {"LYS",14,13, 0.0212, 5," CE ",-3.950,-0.248,-2.206},
  {"LYS",14,13, 0.0212, 5," NZ ",-3.372, 0.002,-3.555},
  {"MET",12, 0, 0.1853, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 0, 0.1853, 4," CG ",-1.991,-1.182,-1.091},
  {"MET",12, 0, 0.1853, 4," SD ",-3.101, 0.232,-0.960},
  {"MET",12, 0, 0.1853, 4," CE ",-4.019,-0.193, 0.518},
  {"MET",12, 1, 0.1634, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 1, 0.1634, 4," CG ",-2.015,-1.163,-1.067},
  {"MET",12, 1, 0.1634, 4," SD ",-3.064,-2.629,-1.060},
  {"MET",12, 1, 0.1634, 4," CE ",-3.984,-2.380, 0.457},
  {"MET",12, 2, 0.1181, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 2, 0.1181, 4," CG ",-2.020,-1.160,-1.062},
  {"MET",12, 2, 0.1181, 4," SD ",-3.168,-2.544,-0.951},
  {"MET",12, 2, 0.1181, 4," CE ",-2.150,-3.880,-1.575},
  {"MET",12, 3, 0.0931, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 3, 0.0931, 4," CG ",-2.014,-1.165,-1.068},
  {"MET",12, 3, 0.0931, 4," SD ",-3.084,-2.614,-1.039},
  {"MET",12, 3, 0.0931, 4," CE ",-4.149,-2.278,-2.440},
  {"MET",12, 4, 0.0722, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 4, 0.0722, 4," CG ",-1.927,-1.219, 1.164},
  {"MET",12, 4, 0.0722, 4," SD ",-3.020,-2.651, 1.129},
  {"MET",12, 4, 0.0722, 4," CE ",-4.070,-2.243,-0.263},
  {"MET",12, 5, 0.0702, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 5, 0.0702, 4," CG ",-1.875,-1.259, 1.205},
  {"MET",12, 5, 0.0702, 4," SD ",-2.980,-2.682, 1.162},
  {"MET",12, 5, 0.0702, 4," CE ",-1.836,-4.011, 1.529},
  {"MET",12, 6, 0.0690, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 6, 0.0690, 4," CG ",-1.904,-1.236, 1.182},
  {"MET",12, 6, 0.0690, 4," SD ",-3.060, 0.146, 1.170},
  {"MET",12, 6, 0.0690, 4," CE ",-4.134,-0.322,-0.186},
  {"MET",12, 7, 0.0373, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 7, 0.0373, 4," CG ",-1.881,-1.254, 1.200},
  {"MET",12, 7, 0.0373, 4," SD ",-3.073,-2.601, 1.092},
  {"MET",12, 7, 0.0373, 4," CE ",-3.937,-2.415, 2.650},
  {"MET",12, 8, 0.0332, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 8, 0.0332, 4," CG ",-1.944,-1.220,-1.134},
  {"MET",12, 8, 0.0332, 4," SD ",-3.098, 0.162,-1.062},
  {"MET",12, 8, 0.0332, 4," CE ",-3.940,-0.017,-2.633},
  {"MET",12, 9, 0.0311, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 9, 0.0311, 4," CG ",-1.991,-1.182,-1.090},
  {"MET",12, 9, 0.0311, 4," SD ",-3.156, 0.181,-0.909},
  {"MET",12, 9, 0.0311, 4," CE ",-2.486, 1.358,-2.081},
  {"MET",12,10, 0.0253, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,10, 0.0253, 4," CG ",-0.230,-2.548, 0.076},
  {"MET",12,10, 0.0253, 4," SD ",-1.371,-3.942, 0.034},
  {"MET",12,10, 0.0253, 4," CE ",-1.808,-3.970,-1.703},
  {"MET",12,11, 0.0244, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,11, 0.0244, 4," CG ",-0.229,-2.549, 0.052},
  {"MET",12,11, 0.0244, 4," SD ",-1.373,-3.941, 0.086},
  {"MET",12,11, 0.0244, 4," CE ",-2.024,-3.805, 1.749},
  {"MSE",12, 0, 0.1853, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 0, 0.1853, 4," CG ",-1.991,-1.182,-1.091},
  {"MSE",12, 0, 0.1853, 4,"SE  ",-3.101, 0.232,-0.960},
  {"MSE",12, 0, 0.1853, 4," CE ",-4.019,-0.193, 0.518},
  {"MSE",12, 1, 0.1634, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 1, 0.1634, 4," CG ",-2.015,-1.163,-1.067},
  {"MSE",12, 1, 0.1634, 4,"SE  ",-3.064,-2.629,-1.060},
  {"MSE",12, 1, 0.1634, 4," CE ",-3.984,-2.380, 0.457},
  {"MSE",12, 2, 0.1181, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 2, 0.1181, 4," CG ",-2.020,-1.160,-1.062},
  {"MSE",12, 2, 0.1181, 4,"SE  ",-3.168,-2.544,-0.951},
  {"MSE",12, 2, 0.1181, 4," CE ",-2.150,-3.880,-1.575},
  {"MSE",12, 3, 0.0931, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 3, 0.0931, 4," CG ",-2.014,-1.165,-1.068},
  {"MSE",12, 3, 0.0931, 4,"SE  ",-3.084,-2.614,-1.039},
  {"MSE",12, 3, 0.0931, 4," CE ",-4.149,-2.278,-2.440},
  {"MSE",12, 4, 0.0722, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 4, 0.0722, 4," CG ",-1.927,-1.219, 1.164},
  {"MSE",12, 4, 0.0722, 4,"SE  ",-3.020,-2.651, 1.129},
  {"MSE",12, 4, 0.0722, 4," CE ",-4.070,-2.243,-0.263},
  {"MSE",12, 5, 0.0702, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 5, 0.0702, 4," CG ",-1.875,-1.259, 1.205},
  {"MSE",12, 5, 0.0702, 4,"SE  ",-2.980,-2.682, 1.162},
  {"MSE",12, 5, 0.0702, 4," CE ",-1.836,-4.011, 1.529},
  {"MSE",12, 6, 0.0690, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 6, 0.0690, 4," CG ",-1.904,-1.236, 1.182},
  {"MSE",12, 6, 0.0690, 4,"SE  ",-3.060, 0.146, 1.170},
  {"MSE",12, 6, 0.0690, 4," CE ",-4.134,-0.322,-0.186},
  {"MSE",12, 7, 0.0373, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 7, 0.0373, 4," CG ",-1.881,-1.254, 1.200},
  {"MSE",12, 7, 0.0373, 4,"SE  ",-3.073,-2.601, 1.092},
  {"MSE",12, 7, 0.0373, 4," CE ",-3.937,-2.415, 2.650},
  {"MSE",12, 8, 0.0332, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 8, 0.0332, 4," CG ",-1.944,-1.220,-1.134},
  {"MSE",12, 8, 0.0332, 4,"SE  ",-3.098, 0.162,-1.062},
  {"MSE",12, 8, 0.0332, 4," CE ",-3.940,-0.017,-2.633},
  {"MSE",12, 9, 0.0311, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 9, 0.0311, 4," CG ",-1.991,-1.182,-1.090},
  {"MSE",12, 9, 0.0311, 4,"SE  ",-3.156, 0.181,-0.909},
  {"MSE",12, 9, 0.0311, 4," CE ",-2.486, 1.358,-2.081},
  {"MSE",12,10, 0.0253, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,10, 0.0253, 4," CG ",-0.230,-2.548, 0.076},
  {"MSE",12,10, 0.0253, 4,"SE  ",-1.371,-3.942, 0.034},
  {"MSE",12,10, 0.0253, 4," CE ",-1.808,-3.970,-1.703},
  {"MSE",12,11, 0.0244, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,11, 0.0244, 4," CG ",-0.229,-2.549, 0.052},
  {"MSE",12,11, 0.0244, 4,"SE  ",-1.373,-3.941, 0.086},
  {"MSE",12,11, 0.0244, 4," CE ",-2.024,-3.805, 1.749},
  {"PHE", 4, 0, 0.4708, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 0, 0.4708, 7," CG ",-1.956,-1.198,-1.072},
  {"PHE", 4, 0, 0.4708, 7," CD1",-3.131,-0.489,-0.893},
  {"PHE", 4, 0, 0.4708, 7," CD2",-1.766,-1.879,-2.263},
  {"PHE", 4, 0, 0.4708, 7," CE1",-4.096,-0.458,-1.880},
  {"PHE", 4, 0, 0.4708, 7," CE2",-2.728,-1.853,-3.253},
  {"PHE", 4, 0, 0.4708, 7," CZ ",-3.895,-1.141,-3.063},
  {"PHE", 4, 1, 0.3171, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 1, 0.3171, 7," CG ",-1.813,-1.306, 1.199},
  {"PHE", 4, 1, 0.3171, 7," CD1",-2.953,-0.524, 1.274},
  {"PHE", 4, 1, 0.3171, 7," CD2",-1.525,-2.163, 2.248},
  {"PHE", 4, 1, 0.3171, 7," CE1",-3.788,-0.595, 2.372},
  {"PHE", 4, 1, 0.3171, 7," CE2",-2.355,-2.237, 3.350},
  {"PHE", 4, 1, 0.3171, 7," CZ ",-3.490,-1.452, 3.412},
  {"PHE", 4, 2, 0.1106, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 2, 0.1106, 7," CG ",-0.174,-2.540, 0.036},
  {"PHE", 4, 2, 0.1106, 7," CD1", 0.201,-3.170,-1.139},
  {"PHE", 4, 2, 0.1106, 7," CD2", 0.143,-3.141, 1.242},
  {"PHE", 4, 2, 0.1106, 7," CE1", 0.876,-4.374,-1.111},
  {"PHE", 4, 2, 0.1106, 7," CE2", 0.817,-4.347, 1.276},
  {"PHE", 4, 2, 0.1106, 7," CZ ", 1.185,-4.965, 0.098},
  {"PHE", 4, 3, 0.0817, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 3, 0.0817, 7," CG ",-1.976,-1.184,-1.052},
  {"PHE", 4, 3, 0.0817, 7," CD1",-2.277,-0.000,-1.703},
  {"PHE", 4, 3, 0.0817, 7," CD2",-2.678,-2.328,-1.393},
  {"PHE", 4, 3, 0.0817, 7," CE1",-3.258, 0.042,-2.674},
  {"PHE", 4, 3, 0.0817, 7," CE2",-3.661,-2.291,-2.363},
  {"PHE", 4, 3, 0.0817, 7," CZ ",-3.952,-1.104,-3.006},
  {"PRO", 2, 0, 0.5072, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 2, 0, 0.5072, 3," CG ", 0.081,-2.204,-0.926},
  {"PRO", 2, 0, 0.5072, 3," CD ", 0.755,-1.306,-1.916},
  {"PRO", 2, 1, 0.4928, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 2, 1, 0.4928, 3," CG ",-0.832,-1.606,-1.565},
  {"PRO", 2, 1, 0.4928, 3," CD ",-0.930,-0.272,-2.238},
  {"SER", 3, 0, 0.4707, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 0, 0.4707, 2," OG ",-0.212,-2.419, 0.096},
  {"SER", 3, 1, 0.2938, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 1, 0.2938, 2," OG ",-1.863,-1.139,-1.066},
  {"SER", 3, 2, 0.2354, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 2, 0.2354, 2," OG ",-1.729,-1.229, 1.186},
  {"THR", 3, 0, 0.4886, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 0, 0.4886, 3," OG1",-0.177,-2.423,-0.002},
  {"THR", 3, 0, 0.4886, 3," CG2",-1.731,-1.289,-1.292},
  {"THR", 3, 1, 0.4364, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 1, 0.4364, 3," OG1",-1.810,-1.160,-1.133},
  {"THR", 3, 1, 0.4364, 3," CG2",-1.910,-1.133, 1.182},
  {"THR", 3, 2, 0.0751, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 2, 0.0751, 3," OG1",-1.849,-1.114, 1.115},
  {"THR", 3, 2, 0.0751, 3," CG2",-0.173,-2.491, 0.303},
  {"TRP", 8, 0, 0.3081,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 0, 0.3081,10," CG ",-1.992,-1.157,-1.056},
  {"TRP", 8, 0, 0.3081,10," CD1",-1.984,-1.813,-2.254},
  {"TRP", 8, 0, 0.3081,10," CD2",-3.212,-0.408,-1.020},
  {"TRP", 8, 0, 0.3081,10," NE1",-3.121,-1.516,-2.964},
  {"TRP", 8, 0, 0.3081,10," CE2",-3.893,-0.656,-2.229},
  {"TRP", 8, 0, 0.3081,10," CE3",-3.801, 0.453,-0.088},
  {"TRP", 8, 0, 0.3081,10," CZ2",-5.126,-0.079,-2.526},
  {"TRP", 8, 0, 0.3081,10," CZ3",-5.025, 1.025,-0.385},
  {"TRP", 8, 0, 0.3081,10," CH2",-5.673, 0.756,-1.594},
  {"TRP", 8, 1, 0.1621,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 1, 0.1621,10," CG ",-1.862,-1.242, 1.188},
  {"TRP", 8, 1, 0.1621,10," CD1",-1.767,-2.050, 2.285},
  {"TRP", 8, 1, 0.1621,10," CD2",-3.024,-0.430, 1.390},
  {"TRP", 8, 1, 0.1621,10," NE1",-2.798,-1.792, 3.154},
  {"TRP", 8, 1, 0.1621,10," CE2",-3.584,-0.800, 2.630},
  {"TRP", 8, 1, 0.1621,10," CE3",-3.654, 0.576, 0.648},
  {"TRP", 8, 1, 0.1621,10," CZ2",-4.736,-0.203, 3.140},
  {"TRP", 8, 1, 0.1621,10," CZ3",-4.796, 1.167, 1.157},
  {"TRP", 8, 1, 0.1621,10," CH2",-5.324, 0.775, 2.390},
  {"TRP", 8, 2, 0.1302,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 2, 0.1302,10," CG ",-1.821,-1.274, 1.217},
  {"TRP", 8, 2, 0.1302,10," CD1",-3.018,-0.643, 1.396},
  {"TRP", 8, 2, 0.1302,10," CD2",-1.577,-2.014, 2.420},
  {"TRP", 8, 2, 0.1302,10," NE1",-3.532,-0.942, 2.634},
  {"TRP", 8, 2, 0.1302,10," CE2",-2.667,-1.783, 3.283},
  {"TRP", 8, 2, 0.1302,10," CE3",-0.544,-2.849, 2.859},
  {"TRP", 8, 2, 0.1302,10," CZ2",-2.752,-2.355, 4.551},
  {"TRP", 8, 2, 0.1302,10," CZ3",-0.631,-3.416, 4.117},
  {"TRP", 8, 2, 0.1302,10," CH2",-1.727,-3.166, 4.948},
  {"TRP", 8, 3, 0.1302,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 3, 0.1302,10," CG ",-2.009,-1.143,-1.038},
  {"TRP", 8, 3, 0.1302,10," CD1",-2.256,-0.112,-1.898},
  {"TRP", 8, 3, 0.1302,10," CD2",-2.979,-2.153,-1.337},
  {"TRP", 8, 3, 0.1302,10," NE1",-3.321,-0.417,-2.710},
  {"TRP", 8, 3, 0.1302,10," CE2",-3.783,-1.665,-2.388},
  {"TRP", 8, 3, 0.1302,10," CE3",-3.255,-3.425,-0.822},
  {"TRP", 8, 3, 0.1302,10," CZ2",-4.836,-2.401,-2.929},
  {"TRP", 8, 3, 0.1302,10," CZ3",-4.301,-4.152,-1.362},
  {"TRP", 8, 3, 0.1302,10," CH2",-5.077,-3.638,-2.404},
  {"TRP", 8, 4, 0.0992,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 4, 0.0992,10," CG ",-0.220,-2.524, 0.002},
  {"TRP", 8, 4, 0.0992,10," CD1", 0.167,-3.245,-1.091},
  {"TRP", 8, 4, 0.0992,10," CD2", 0.201,-3.278, 1.145},
  {"TRP", 8, 4, 0.0992,10," NE1", 0.798,-4.400,-0.699},
  {"TRP", 8, 4, 0.0992,10," CE2", 0.834,-4.445, 0.670},
  {"TRP", 8, 4, 0.0992,10," CE3", 0.106,-3.088, 2.528},
  {"TRP", 8, 4, 0.0992,10," CZ2", 1.366,-5.409, 1.523},
  {"TRP", 8, 4, 0.0992,10," CZ3", 0.635,-4.047, 3.373},
  {"TRP", 8, 4, 0.0992,10," CH2", 1.257,-5.192, 2.868},
  {"TRP", 8, 5, 0.0581,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 5, 0.0581,10," CG ",-1.897,-1.215, 1.159},
  {"TRP", 8, 5, 0.0581,10," CD1",-2.233,-0.158, 1.956},
  {"TRP", 8, 5, 0.0581,10," CD2",-2.649,-2.334, 1.645},
  {"TRP", 8, 5, 0.0581,10," NE1",-3.143,-0.550, 2.906},
  {"TRP", 8, 5, 0.0581,10," CE2",-3.417,-1.882, 2.738},
  {"TRP", 8, 5, 0.0581,10," CE3",-2.751,-3.678, 1.269},
  {"TRP", 8, 5, 0.0581,10," CZ2",-4.270,-2.721, 3.452},
  {"TRP", 8, 5, 0.0581,10," CZ3",-3.598,-4.508, 1.980},
  {"TRP", 8, 5, 0.0581,10," CH2",-4.346,-4.027, 3.058},
  {"TRP", 8, 6, 0.0532,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 6, 0.0532,10," CG ",-0.220,-2.524, 0.009},
  {"TRP", 8, 6, 0.0532,10," CD1", 0.193,-3.235, 1.100},
  {"TRP", 8, 6, 0.0532,10," CD2", 0.171,-3.290,-1.137},
  {"TRP", 8, 6, 0.0532,10," NE1", 0.817,-4.392, 0.703},
  {"TRP", 8, 6, 0.0532,10," CE2", 0.817,-4.451,-0.666},
  {"TRP", 8, 6, 0.0532,10," CE3", 0.044,-3.112,-2.519},
  {"TRP", 8, 6, 0.0532,10," CZ2", 1.329,-5.423,-1.523},
  {"TRP", 8, 6, 0.0532,10," CZ3", 0.553,-4.078,-3.367},
  {"TRP", 8, 6, 0.0532,10," CH2", 1.187,-5.218,-2.866},
  {"TRP", 8, 7, 0.0532,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 7, 0.0532,10," CG ",-2.030,-1.126,-1.014},
  {"TRP", 8, 7, 0.0532,10," CD1",-3.285,-0.617,-0.838},
  {"TRP", 8, 7, 0.0532,10," CD2",-1.966,-1.567,-2.376},
  {"TRP", 8, 7, 0.0532,10," NE1",-4.004,-0.715,-2.004},
  {"TRP", 8, 7, 0.0532,10," CE2",-3.218,-1.294,-2.965},
  {"TRP", 8, 7, 0.0532,10," CE3",-0.977,-2.168,-3.162},
  {"TRP", 8, 7, 0.0532,10," CZ2",-3.503,-1.599,-4.294},
  {"TRP", 8, 7, 0.0532,10," CZ3",-1.263,-2.470,-4.481},
  {"TRP", 8, 7, 0.0532,10," CH2",-2.515,-2.185,-5.033},
  {"TYR", 4, 0, 0.4735, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 0, 0.4735, 8," CG ",-1.983,-1.178,-1.087},
  {"TYR", 4, 0, 0.4735, 8," CD1",-3.154,-0.444,-0.938},
  {"TYR", 4, 0, 0.4735, 8," CD2",-1.797,-1.885,-2.266},
  {"TYR", 4, 0, 0.4735, 8," CE1",-4.110,-0.416,-1.935},
  {"TYR", 4, 0, 0.4735, 8," CE2",-2.749,-1.863,-3.269},
  {"TYR", 4, 0, 0.4735, 8," CZ ",-3.901,-1.126,-3.099},
  {"TYR", 4, 0, 0.4735, 8," OH ",-4.852,-1.102,-4.093},
  {"TYR", 4, 1, 0.3248, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 1, 0.3248, 8," CG ",-1.838,-1.275, 1.223},
  {"TYR", 4, 1, 0.3248, 8," CD1",-2.963,-0.466, 1.326},
  {"TYR", 4, 1, 0.3248, 8," CD2",-1.561,-2.149, 2.265},
  {"TYR", 4, 1, 0.3248, 8," CE1",-3.786,-0.525, 2.434},
  {"TYR", 4, 1, 0.3248, 8," CE2",-2.380,-2.215, 3.378},
  {"TYR", 4, 1, 0.3248, 8," CZ ",-3.490,-1.403, 3.456},
  {"TYR", 4, 1, 0.3248, 8," OH ",-4.307,-1.463, 4.562},
  {"TYR", 4, 2, 0.1159, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 2, 0.1159, 8," CG ",-0.227,-2.539, 0.059},
  {"TYR", 4, 2, 0.1159, 8," CD1", 0.141,-3.196,-1.108},
  {"TYR", 4, 2, 0.1159, 8," CD2", 0.076,-3.138, 1.274},
  {"TYR", 4, 2, 0.1159, 8," CE1", 0.792,-4.414,-1.066},
  {"TYR", 4, 2, 0.1159, 8," CE2", 0.727,-4.358, 1.325},
  {"TYR", 4, 2, 0.1159, 8," CZ ", 1.083,-4.989, 0.153},
  {"TYR", 4, 2, 0.1159, 8," OH ", 1.730,-6.203, 0.198},
  {"TYR", 4, 3, 0.0653, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 3, 0.0653, 8," CG ",-2.004,-1.162,-1.066},
  {"TYR", 4, 3, 0.0653, 8," CD1",-2.304, 0.025,-1.724},
  {"TYR", 4, 3, 0.0653, 8," CD2",-2.707,-2.305,-1.420},
  {"TYR", 4, 3, 0.0653, 8," CE1",-3.276, 0.070,-2.705},
  {"TYR", 4, 3, 0.0653, 8," CE2",-3.681,-2.268,-2.401},
  {"TYR", 4, 3, 0.0653, 8," CZ ",-3.960,-1.080,-3.040},
  {"TYR", 4, 3, 0.0653, 8," OH ",-4.929,-1.037,-4.016},
  {"VAL", 3, 0, 0.7390, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 0, 0.7390, 3," CG1",-1.718,-1.247, 1.347},
  {"VAL", 3, 0, 0.7390, 3," CG2",-1.895,-1.189,-1.149},
  {"VAL", 3, 1, 0.1870, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 1, 0.1870, 3," CG1",-1.904,-1.181,-1.141},
  {"VAL", 3, 1, 0.1870, 3," CG2",-0.147,-2.510, 0.049},
  {"VAL", 3, 2, 0.0740, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 2, 0.0740, 3," CG1",-0.149,-2.505, 0.153},
  {"VAL", 3, 2, 0.0740, 3," CG2",-1.933,-1.086, 1.188}};
int rotamer_data_size = sizeof( rotamer_data ) / sizeof( rotamer_data[0] );


} // namespace data


} // namespace clipper
